"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePath = exports.resolveHome = void 0;

var _fs = require("fs");

var _path = require("path");

const resolveHome = filepath => {
  if (filepath[0] === '~') {
    const restOfPath = filepath.slice(1);
    if (!process.env.HOME) throw new Error('HOME environment variable is missing');
    const home = process.env.HOME;
    return (0, _path.join)(home, restOfPath);
  }

  return filepath;
};

exports.resolveHome = resolveHome;

const validatePath = resolvedPath => {
  if (!(0, _fs.existsSync)(resolvedPath)) {
    throw new Error(`The path ${resolvedPath} was not found`);
  }

  if (!(0, _fs.existsSync)((0, _path.join)(resolvedPath, '.git'))) {
    throw new Error(`The directory ${resolvedPath} does not appear to be the root of a git repository.`);
  }
};

exports.validatePath = validatePath;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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