"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = _default;

var _merge = _interopRequireDefault(require("merge"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _default(source) {
  var extra = source == 'server' ? serverExtra() : clientExtra();
  return _merge["default"].recursive(true, {
    props: {
      name: {
        type: String,
        required: true
      }
    },
    computed: {
      state: function state() {
        return this.$store.state[this.name] ? this.$store.state[this.name] : {};
      },
      Page: function Page() {
        return this.state.page;
      },
      count: function count() {
        return this.state.count;
      },
      Columns: function Columns() {
        return this.state.columns ? this.state.columns : [];
      },
      tableData: function tableData() {
        return this.state.data ? this.state.data : [];
      },
      page: function page() {
        return this.state.page;
      },
      limit: function limit() {
        return this.state.limit;
      },
      customQueries: function customQueries() {
        return this.state.customQueries;
      },
      query: function query() {
        return this.state.query;
      },
      orderBy: function orderBy() {
        return {
          column: this.state.sortBy,
          ascending: this.state.ascending
        };
      }
    },
    methods: {
      commit: function commit(action, payload) {
        return this.$store.commit("".concat(this.name, "/").concat(action), payload);
      },
      orderByColumn: function orderByColumn(column, ev) {
        if (!this.sortable(column)) return;

        if (ev.shiftKey && this.orderBy.column && this.hasMultiSort) {
          this.setUserMultiSort(column);
        } else {
          var ascending = this.orderBy.column === column ? !this.orderBy.ascending : this._initialOrderAscending(column);
          var orderBy = {
            column: column,
            ascending: ascending
          };
          this.updateState('orderBy', orderBy);
          this.commit('SORT', orderBy);
          this.dispatch('sorted', orderBy);
        }
      },
      setLimit: function setLimit(e) {
        var limit = _typeof(e) === 'object' ? parseInt(e.target.value) : e;
        this.updateState('perPage', limit);
        this.commit("SET_LIMIT", limit);
        this.dispatch("limit", limit);
      },
      setOrder: function setOrder(column, ascending) {
        this.updateState('orderBy', {
          column: column,
          ascending: ascending
        });
        this.commit('SORT', {
          column: column,
          ascending: ascending
        });
      },
      setPage: function setPage(page) {
        this.dispatch('pagination', page);
        this.commit("PAGINATE", page);
      }
    }
  }, extra);
}

function serverExtra() {
  return {
    methods: {
      setData: function setData(data) {
        this.commit('SET_DATA', data);
        setTimeout(function () {
          this.dispatch('loaded', data);
        }.bind(this), 0);
      }
    }
  };
}

function clientExtra() {
  return {};
}