var defaultCrown = {
    items: [
        {
            id: "task",
            name: "Task".translate(),
            className: "mafe-corona-task",
            eventOnMouseDown: function (item) {
                item.canvas.canCreateShape = true;
                item.canvas.canCreateShapeType = 'TASK';
                item.canvas.canCreateShapeClass = 'mafe-toolbar-task';
                item.canvas.connectStartShape = item.parent.parent;
            },
            eventOnMouseOut: function (item) {
                if (item.canvas.canCreateShape) {
                    item.parent.hide();
                }
            }
        },
        {
            id: "gateway",
            name: 'Gateway'.translate(),
            className: 'mafe-corona-gateway-exclusive',
            eventOnClick: function (item) {
                item.parent.hide();
            },
            eventOnMouseDown: function (item) {
                item.canvas.canCreateShape = true;
                item.canvas.canCreateShapeType = 'EXCLUSIVE';
                item.canvas.canCreateShapeClass = 'mafe-toolbar-gateway-exclusive';
                item.canvas.connectStartShape = item.parent.parent;
            },
            eventOnMouseOut: function (item) {
                if (item.canvas.canCreateShape) {
                    item.parent.hide();
                }
            }
        },
        {
            id: "intermediate",
            name: 'Intermediate'.translate(),
            className: 'mafe-corona-intermediate',
            eventOnClick: function (item) {
                item.parent.hide();
            },
            eventOnMouseDown: function (item) {
                item.canvas.canCreateShape = true;
                item.canvas.canCreateShapeType = 'INTERMEDIATE_EMAIL';
                item.canvas.canCreateShapeClass = 'mafe-toolbar-intermediate-send-mesage';
                item.canvas.connectStartShape = item.parent.parent;
            },
            eventOnMouseOut: function (item) {
                if (item.canvas.canCreateShape) {
                    item.parent.hide();
                }
            }
        },
        {
            id: "end",
            name: 'End'.translate(),
            className: 'mafe-corona-end',
            eventOnClick: function (item) {
                item.parent.hide();
            },
            eventOnMouseDown: function (item) {
                item.canvas.canCreateShape = true;
                item.canvas.canCreateShapeType = 'END';
                item.canvas.canCreateShapeClass = 'mafe-toolbar-end';
                item.canvas.connectStartShape = item.parent.parent;
            },
            eventOnMouseOut: function (item) {
                if (item.canvas.canCreateShape) {
                    item.parent.hide();
                }
            }
        },
        {
            id: "flow",
            name: 'Flow'.translate(),
            className: 'mafe-corona-flow',
            eventOnClick: function (item) {
                item.parent.hide();
                item.parent.parent.canvas.hideAllFocusedLabels();
            },
            eventOnMouseDown: function (item) {
                item.canvas.canConnect = true;
                item.canvas.connectStartShape = item.parent.parent;
            }
        },
        {
            id: "properties",
            name: 'Properties'.translate(),
            className: 'mafe-corona-settings',
            eventOnClick: function (item) {
                item.parent.hide();
                PMDesigner.saveAndOpenSettings(item.parent.parent, PMDesigner.shapeProperties);
            }
        },
        {
            id: "delete",
            name: 'Delete'.translate(),
            className: 'mafe-corona-delete',
            eventOnClick: function (item) {
                PMUI.getActiveCanvas().removeElements();
                item.parent.hide();
            }
        }
    ]
};

var configCrown = {
    'PMActivity': {
        'DEFAULT': {
            order: ["task", "gateway", "intermediate", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 3
        }
    },
    'PMGateway': {
        'PARALLEL': {
            order: ["task", "gateway", "end", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'EXCLUSIVE': {
            order: ["task", "gateway", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'INCLUSIVE': {
            order: ["task", "gateway", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        }
    },
    'PMEvent': {
        'START_EMPTY': {
            order: ["task", "gateway", "intermediate", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'START_MESSAGECATCH': {
            order: ["task", "gateway", "intermediate", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'START_TIMER': {
            order: ["task", "gateway", "intermediate", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'START_CONDITIONAL': {
            order: ["task", "gateway", "intermediate", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'START_SIGNALCATCH': {
            order: ["task", "gateway", "intermediate", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_EMAIL': {
            order: ["task", "gateway", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_MESSAGETHROW': {
            order: ["task", "gateway", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_SIGNALTHROW': {
            order: ["task", "gateway", "end", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_MESSAGECATCH': {
            order: ["task", "gateway", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_TIMER': {
            order: ["task", "gateway", "end", "flow", "properties", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_CONDITIONAL': {
            order: ["task", "gateway", "end", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'INTERMEDIATE_SIGNALCATCH': {
            order: ["task", "gateway", "end", "flow", "delete"],
            rows: 3,
            cols: 2
        },
        'END_EMPTY': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'END_EMAIL': {
            order: ["flow", "properties", "delete"],
            rows: 2,
            cols: 2
        },
        'END_MESSAGETHROW': {
            order: ["flow", "properties", "delete"],
            rows: 2,
            cols: 2
        },
        'END_ERRORTHROW': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'END_SIGNALTHROW': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'END_TERMINATETHROW': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        }
    },
    'PMPool': {
        'DEFAULT': {
            order: ["delete"],
            rows: 1,
            cols: 1
        }
    },
    'PMParticipant': {
        'DEFAULT': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        }
    },
    'PMArtifact': {
        'TEXT_ANNOTATION': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'GROUP': {
            order: ["delete"],
            rows: 1,
            cols: 1
        }
    },
    'PMData': {
        'DATAOBJECT': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'DATAINPUT': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'DATAOUTPUT': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        },
        'DATASTORE': {
            order: ["flow", "delete"],
            rows: 2,
            cols: 1
        }
    }
};
var PMDesigner = {},
    LANG,
    WORKSPACE,
    SKIN,
    DEFAULT_WINDOW_WIDTH,
    DEFAULT_WINDOW_HEIGHT,
    ENABLED_FEATURES,
    DataDictionary,
    enviromentVariables,
    resizingFrame,
    ViewTaskInformation;

PMDesigner.defaultRules = window.defaultRules ? window.defaultRules : {};
PMDesigner.defaultCrown = window.defaultCrown ? defaultCrown : {};
PMDesigner.configCrown = window.configCrown ? configCrown : {};
PMDesigner.modelRules = new ModelRules(PMDesigner.defaultRules);
PMDesigner.modelCrown = new ModelCrown(PMDesigner.defaultCrown);
PMDesigner.remoteUrl = "";
PMDesigner.moddle = new BpmnModdle();
PMDesigner.bpmnFactory = new BpmnFactory(PMDesigner.moddle);
PMDesigner.keyCodeF5 = 116;
PMDesigner.autoSave = true;
PMDesigner.shapeProperties = function (shape) {
    var typeShape = shape.type;
    switch (typeShape) {
        case "PMActivity":
            PMDesigner.activityProperties(shape);
            break;
        case "PMGateway":
            PMDesigner.gatewayProperties(shape);
            break;
        case "PMEvent":
            shape.eventProperties();
            break;
    }
};

/**
 * function to get the enviroment variables (WORKSPACE, LANG, SKIN)
 */
enviromentVariables = function (variable) {
    var url1, variables, WORKSPACE, LANG, SKIN;
    if (window.parent) {
        url1 = window.parent.location.pathname;
        variables = url1.split('/');
        WORKSPACE = variables[1];
        WORKSPACE = WORKSPACE.substring(3);
        LANG = variables[2];
        SKIN = variables[3];

        if (variable == 'WORKSPACE') {
            return WORKSPACE;
        } else if (variable == 'LANG') {
            return LANG;
        } else if (variable == 'SKIN') {
            return SKIN;
        } else {
            return null;
        }
    }
};

LANG = (typeof SYS_LANG !== "undefined") ? SYS_LANG : enviromentVariables('LANG');
WORKSPACE = (typeof SYS_SYS !== "undefined") ? SYS_SYS : enviromentVariables('WORKSPACE');
SKIN = (typeof SYS_SKIN !== "undefined") ? SYS_SKIN : enviromentVariables('SKIN');

DEFAULT_WINDOW_WIDTH = 1093;
DEFAULT_WINDOW_HEIGHT = 520;
ENABLED_FEATURES = [];

if (LANG != 'en') {
    if (typeof __TRANSLATIONMAFE != "undefined" && typeof __TRANSLATIONMAFE[LANG] != 'undefined') {
        PMUI.loadLanguage(__TRANSLATIONMAFE.en, 'en');
        PMUI.loadLanguage(__TRANSLATIONMAFE[LANG], LANG);

        PMUI.setDefaultLanguage('en');
        PMUI.setCurrentLanguage(LANG);
    }
}

PMDesigner.resizeFrame = function () {
    if (parent.document.documentElement === document.documentElement) {
        jQuery(".content").css("height", parseInt(jQuery(window).height()));
    } else {
        jQuery(".content").css("height", document.body.clientHeight);

    }
};
resizingFrame = PMDesigner.resizeFrame;
PMDesigner.applyCanvasOptions = function () {
    list = new PMUI.control.DropDownListControl({
        options: [],
        style: {
            cssClasses: [
                "mafe-dropdown-zoom"
            ]
        },
        width: 150,
        onChange: function (newValue, previous) {
            var canvas = PMDesigner.project.diagrams.find('id', newValue);
            PMUI.getActiveCanvas().getHTML().style.display = 'none';
            PMUI.setActiveCanvas(canvas);
            canvas.getHTML().style.display = 'inline';
        }
    });
    //enable to support multidiagram
    //jQuery(jQuery(".navBar li")[6]).append(list.getHTML());
    list.defineEvents();
    PMDesigner.canvasList = list;
};
//Zoom
PMDesigner.ApplyOptionsZoom = function () {
    list = new PMUI.control.DropDownListControl({
        id: '_idListZoom',
        options: [
            {
                label: "50%",
                value: 1
            },
            {
                label: "75%",
                value: 2
            },
            {
                label: "100%",
                value: 3,
                selected: true
            },
            {
                label: "125%",
                value: 4
            },
            {
                label: "150%",
                value: 5
            }
        ],
        style: {
            cssClasses: [
                "mafe-dropdown-zoom"
            ]
        },
        onChange: function (newValue, previous) {
            var i;
            newValue = parseInt(newValue, 10);
            PMUI.getActiveCanvas().applyZoom(newValue);
        }
    });

    //jQuery(jQuery(".navBar li")[4]).append(list.getHTML());
    jQuery(jQuery(".mafe-zoom-options")).append(list.getHTML());

    list.defineEvents();
};
/**
 * hides all requiered TinyControls
 */
PMDesigner.hideAllTinyEditorControls = function () {
    var control,
        i,
        max,
        j,
        mapMax,
        editor,
        controlMap = [
            'tinyeditor_fontselect',
            'tinyeditor_fontsizeselect',
            'tinyeditor_bullist',
            'tinyeditor_numlist',
            'tinyeditor_forecolor',
            'tinyeditor_backcolor'
        ];
    for (i = 0, max = tinymce.editors.length; i < max; i += 1) {
        editor = tinymce.editors[i];
        jQuery.each(editor.controlManager.controls, function (index, val) {
            if (val && jQuery.isFunction(val.hideMenu)) {
                val.hideMenu();
            }
        });
    }

};


jQuery(document).ready(function ($) {
    var setSaveButtonDisabled,
        s,
        sidebarCanvas,
        project,
        d,
        downloadLink,
        handlerExportNormal,
        handlerExportGranular,
        handler,
        validatosr,
        help,
        option,
        menu,
        elem,
        validatorLabel = "Validator".translate();
    /***************************************************
     * Defines the Process
     ***************************************************/
    if (typeof prj_uid === "undefined") {
        prj_uid = '';
    }
    if (typeof prj_readonly === "undefined") {
        prj_readonly = '';
    }
    if (typeof credentials === "undefined") {
        credentials = '';
    } else {
        credentials = RCBase64.decode(credentials);
        credentials = (credentials == '') ? "" : JSON.parse(credentials);
    }

    if (prj_readonly !== 'true') {
        $("#idContent").find(".content_controls").show();
        $(".bpmn_shapes").show();
        $('.bpmn_shapes_legend').hide();
        $("#idNavBar").show().css('height', '33px');
    }

    PMDesigner.createHTML();
    setSaveButtonDisabled = function (that) {
        if (that.isDirty()) {
            if (document.getElementsByClassName("mafe-save-process").length > 0) {
                document.getElementsByClassName("mafe-save-process")[0].removeAttribute("style");
                document.getElementsByClassName("mafe-save-process")[0].childNodes[0].style.color = "#FFF";

                var mafebuttonMenu = document.getElementsByClassName("mafe-button-menu")[0];
                mafebuttonMenu.style.backgroundColor = "#0C9778";
                mafebuttonMenu.firstChild.src = "/lib/img/caret-down-w.png";
            }
        } else {
            if (document.getElementsByClassName("mafe-save-process").length > 0) {
                document.getElementsByClassName("mafe-save-process")[0].style.backgroundColor = "#e8e8e8";
                document.getElementsByClassName("mafe-save-process")[0].style.color = "#000";
                document.getElementsByClassName("mafe-save-process")[0].childNodes[0].style.color = "#000";
                document.getElementsByClassName("mafe-save-process")[0].childNodes[0].text = "Save".translate();

                var mafebuttonMenu = document.getElementsByClassName("mafe-button-menu")[0];
                mafebuttonMenu.style.backgroundColor = "#e8e8e8";
                mafebuttonMenu.firstChild.src = "/lib/img/caret-down.png";
            }
        }
    };
    sidebarCanvas = [];
    for (s = 0; s < PMDesigner.sidebar.length; s += 1) {
        sidebarCanvas = sidebarCanvas.concat(PMDesigner.sidebar[s].getSelectors());
        jQuery(".bpmn_shapes").append(PMDesigner.sidebar[s].getHTML());
    }
    //Adding Sidebar to DOM
    firstAbsuluteX = jQuery("#div-layout-canvas").offset().left;

    project = new PMProject({
        id: prj_uid,
        name: 'Untitled Process',
        readOnly: prj_readonly === "true",
        keys: {
            access_token: credentials.access_token,
            expires_in: credentials.expires_in,
            token_type: credentials.token_type,
            scope: credentials.scope,
            refresh_token: credentials.refresh_token,
            client_id: credentials.client_id,
            client_secret: credentials.client_secret
        },
        listeners: {
            create: function (self, element) {
                var sh, i,
                    contDivergent = 0,
                    contConvergent = 0;
                //Updating the background color for connections
                jQuery(".pmui-intersection > div > div").css("background-color", "black");

                if (element.type == "Connection") {
                    ///////////****************Changing the gatDirection*******************//////////////////
                    if (element.relatedObject.srcPort.parent.gat_type === "PARALLEL" ||
                        element.relatedObject.srcPort.parent.gat_type === "INCLUSIVE" ||
                        element.relatedObject.destPort.parent.gat_type === "PARALLEL" ||
                        element.relatedObject.destPort.parent.gat_type === "INCLUSIVE") {
                        if (element.relatedObject.srcPort.parent.gat_type !== undefined) {
                            sh = element.relatedObject.srcPort.parent;
                        } else {
                            sh = element.relatedObject.destPort.parent;
                        }

                        if (sh.gat_direction === "DIVERGING") {
                            for (i = 0; i < sh.ports.asArray().length; i += 1) {
                                if (sh.ports.asArray()[i].connection.flo_element_origin_type === "bpmnActivity") {
                                    contDivergent += 1;
                                }
                                if (contDivergent > 1) {
                                    sh.gat_direction = "CONVERGING";
                                    i = sh.ports.asArray().length;
                                }
                            }
                        }
                        if (sh.gat_direction === "CONVERGING") {
                            for (i = 0; i < sh.ports.asArray().length; i += 1) {
                                if (sh.ports.asArray()[i].connection.flo_element_origin_type === "bpmnGateway") {
                                    contConvergent += 1;
                                }
                                if (contConvergent > 1) {
                                    sh.gat_direction = "DIVERGING";
                                    i = sh.ports.asArray().length;
                                }
                            }
                        }

                    }
                }
                setSaveButtonDisabled(self);
            },
            update: function (self) {
                //Updating the background color for connections
                jQuery(".pmui-intersection > div > div").css("background-color", "black");
                setSaveButtonDisabled(self);
            },
            remove: function (self) {
                setSaveButtonDisabled(self);
            },
            success: function (self, xhr, response) {
                var message;
                self.dirty = false;
                setSaveButtonDisabled(self);
                self.dirtyElements[0] = {
                    laneset: {},
                    lanes: {},
                    activities: {},
                    events: {},
                    gateways: {},
                    flows: {},
                    artifacts: {},
                    lines: {},
                    data: {},
                    participants: {},
                    startMessageEvent: {},
                    startTimerEvent: {}
                };
                self.updateIdentifiers(response);
                //if (PMDesigner.currentMsgFlash) {
                PMDesigner.msgFlash('The process was saved successfully.'.translate(), document.body, 'success', 3000, 5);
                PMDesigner.RoutingRuleSetOrder();
                //}

            },
            failure: function (self, xhr, response) {
                var message;
                if (response.error.code === 401) {
                    /*message = new PMUI.ui.FlashMessage({
                     message: "It was not possible to establish a connection with the server".translate(),
                     duration: 5000,
                     appendTo: document.body,
                     severity: 'info'
                     });
                     message.show();*/
                    //self.remoteProxy.setUrl("/"+WORKSPACE+"/oauth2/token");
                    //self.setRefreshToken();
                    //self.remoteProxy.setUrl("/api/1.0/"+WORKSPACE+"/project/"+prj_uid);
                    //self.save();
                } else {
                    PMDesigner.msgFlash('Error saving the process.'.translate(), document.body, 'error', 3000, 5);
                    self.updateIdentifiers(response);
                }
            }
        }
    });
    PMDesigner.project = project;
    //create a new restApi
    PMDesigner.restApi = RestApi.createRestApi({
        serverUrl: '/rest/v10',
        keys: PMDesigner.project.keys
    });
    systemRest = new PMRestClient({
        typeRequest: 'post',
        multipart: true,
        data: {
            calls: [{
                url: 'system/enabled-features',
                method: 'GET'
            }
            ]
        },
        functionSuccess: function (xhr, response) {
            var result = response.pop();
            ENABLED_FEATURES = result.response;
            navbarExportUpdate();
        },
        functionFailure: function (xhr, response) {
            ENABLED_FEATURES = [];
        }
    }).setBaseEndPoint('').executeRestClient();
    PMDesigner.connectValidator = new ConnectValidator();
    for (d = 0; d < PMDesigner.sidebar.length; d += 1) {
        PMDesigner.sidebar[d].activate();
        PMDesigner.sidebar[d].enableActions();
    }

    $('.bpmn_shapes_legend').hide();
    project.remoteProxy.setUrl(HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + prj_uid);
    project.load();

    /*===========================================
     =            ProcessMaker module            =
     ===========================================*/

    //Renders content controls
    PMDesigner.contentControl.show();
    new PMAction({
        selector: ".mafe-menu-eventmessages-create",
        label: {
            selector: ".mafe-menu-eventmessages-create span",
            text: "Create".translate()
        },
        execute: true,
        handler: function () {
            PMDesigner.eventMessages.create();
        }
    });

    /*-----  End of ProcessMaker module  ------*/

    /*========================================
     =            Designer buttons            =
     ========================================*/

    //Renders navBar Panel
    PMDesigner.navbarPanel.show();
    // create Zoom options
    PMDesigner.ApplyOptionsZoom();
    //the action to generate a .bpmn file with the export option.
    downloadLink = $('.mafe-button-export-bpmn-process');
    downloadLink.click(function (e) {
        PMDesigner.moddle.toXML(PMDesigner.businessObject, function (err, xmlStrUpdated) {

            setEncoded(downloadLink, PMDesigner.project.projectName + '.bpmn', xmlStrUpdated);

            // xmlStrUpdated contains new id and the added process
        });

    });
    option = $("<div class='mafe-button-menu-option'>" + "Save as".translate() + "</div>");
    /**
     * Add data tables
     */
    $('body').append('<div class="bpmn_validator"><div class="validator_header"></div><div class="validator_body"></div></div>')
    $('.validator_header').append('<h2> ' + validatorLabel + ' </h2>');
    $('.validator_header').append('<a class="validator-close" href="#"><span class="mafe-validator-close" title=""></span></a>');
    $('.validator_body').html('<table cellpadding="0" cellspacing="0" border="0" class="display" id="validator-table" width="100%"></table>');
    PMDesigner.validTable = $('#validator-table').DataTable({
        paging: false,
        scrollY: 100,
        searching: false,
        "info": false,
        scrollCollapse: true,
        "columns": [
            {
                name: 'numrow',
                "title": "#",
                width: '5%',
                render: function (data, type, row, conf) {
                    return conf.row + 1;
                }
            },
            {
                name: 'id',
                className: 'never'
            },
            {
                "title": "Type".translate(),
                width: '10%',
                name: 'severity',
                render: function (data, type, row, conf) {
                    var clasMap = {
                        Error: 'mafe-icon-error',
                        Warning: 'mafe-icon-warning'
                    };
                    if (type === 'display') {
                        return ' <i class="' + clasMap[data] + '"></i> ' + data;
                    }
                    return data;
                }
            },
            {name: 'element', "title": "Element".translate(), width: '15%'},
            {name: 'element-type', "title": "Element Type".translate(), width: '15%'},
            {name: 'description', "title": "Description".translate(), width: '45%'}
        ]
    });
    jQuery('#validator-table tbody').on('click', 'tr', function () {
        var id = PMDesigner.validTable.row(this).data()[1],
            shape;
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            PMUI.getActiveCanvas().hideAllCoronas().emptyCurrentSelection();
        }
        else {
            PMDesigner.validTable.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            PMUI.getActiveCanvas().hideAllCoronas().emptyCurrentSelection();
            shape = PMUI.getActiveCanvas().items.find('id', id);
            PMUI.getActiveCanvas().addToSelection(shape.relatedObject);
        }
    });
    PMDesigner.validTable.columns([1]).visible(false);
    /********finish datatables********/
    new PMAction({
        selector: ".mafe-validator-close",
        tooltip: "Close Validator".translate(),
        execute: true,
        handler: function () {
            $('.bpmn_validator').css('visibility', 'hidden');
            $('.mafe-toolbar-validation').css('background-color', 'rgb(233, 233, 233)');
            PMDesigner.validator = false;
        }
    });

    menu = $("<div class='mafe-button-menu-container'></div>");
    menu.append(option);
    option.on("mouseout", function (e) {
        menu.hide();
    });
    option.on("click", function (e) {
        var saveas;
        menu.hide();
        PMDesigner.project.remoteProxy.setUrl(HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id);
        PMDesigner.project.save(true);
        saveas = new SaveAs();
        saveas.open();
    });
    $(".mafe-button-menu").on("click", function (e) {
        e.stopPropagation();
        $(".mafe-save-process").append(menu);
        menu.show();
    });

    /*-----  End of Designer buttons  ------*/
    /*=================================================
     =            Full screen functionality            =
     =================================================*/
    if (parent.document.documentElement === document.documentElement) {
        elem = document.documentElement;
    } else {
        elem = parent.document.getElementById("frameMain");
    }
    PMDesigner.fullScreen = new FullScreen({
        element: elem,
        onReadyScreen: function () {
            setTimeout(function () {
                PMDesigner.resizeFrame();
            }, 500);
        },
        onCancelScreen: function () {
            setTimeout(function () {
                PMDesigner.resizeFrame();
            }, 500);
        }
    });
    /*-----  End of Full screen functionality  ------*/

    /*=============================================
     =            Shapes and Controls Box            =
     =============================================*/
    PMDesigner.cookie = {
        name: "PMDesigner",
        object: {},
        get: function (cname) {
            var name = cname + "=", i, c,
                ca = document.cookie.split(';');
            for (i = 0; i < ca.length; i += 1) {
                c = ca[i].trim();
                if (c.indexOf(name) == 0)
                    return c.substring(name.length, c.length);
            }
            return "";
        },
        remove: function (cname) {
            jQuery.each(PMDesigner.cookie.object, function (index, val) {
                if (index === cname) {
                    delete PMDesigner.cookie.object[cname];
                    PMDesigner.cookie.refresh();
                }
            });
        },
        refresh: function () {
            document.cookie = PMDesigner.cookie.name + "=" + JSON.stringify(PMDesigner.cookie.object);
        }
    };
    PMDesigner.localStorage = {
        prefix: "PM_" + WORKSPACE + "_" + prj_uid,
        object: {},
        remove: function (cname) {
            var obj;
            obj = localStorage.getItem(PMDesigner.localStorage.prefix);
            obj = (obj === null) ? {} : JSON.parse(obj);
            if (obj[cname]) {
                delete obj[cname];
                localStorage.setItem(PMDesigner.localStorage.prefix, JSON.stringify(obj));
            }
        }
    };
    if (Modernizr.localstorage) {
        var localDesigner = localStorage.getItem(PMDesigner.localStorage.prefix);
        localDesigner = (localDesigner === null) ? {} : JSON.parse(localDesigner);
        PMDesigner.panelsPosition = localDesigner;
    } else {
        if (PMDesigner.cookie.get(PMDesigner.cookie.name) !== "") {
            var positions, pLeft, pTop, html;
            positions = JSON.parse(PMDesigner.cookie.get(PMDesigner.cookie.name));
            PMDesigner.cookie.object = positions;
            PMDesigner.panelsPosition = positions;
        }
    }
    if (typeof PMDesigner.panelsPosition === "object") {
        var pst = PMDesigner.panelsPosition;
        if (pst.navbar) {
            pLeft = pst.navbar.x;
            pTop = pst.navbar.y;
            html = document.getElementsByClassName("navBar")[0];
        }
        if (pst.bpmn) {
            pLeft = 0;
            pTop = 0;
            html = document.getElementsByClassName("bpmn_shapes")[0];
            html.style.left = pLeft + "px";
            html.style.top = pTop + "px";
        }
        if (pst.controls) {
            pLeft = pst.controls.x;
            pTop = pst.controls.y;
            html = document.getElementsByClassName("content_controls")[0];
            html.style.left = pLeft + "px";
            html.style.top = pTop + "px";
            if (pTop > 503) {
                $("#idContent").find(".content_controls").css({'top': '', 'left': ''});
            }
        }
    }
    jQuery(".bpmn_shapes").draggable({
        handle: "div",
        start: function () {
        },
        drag: function () {
        },
        stop: function (event) {
            var pLeft, pTop, currentObj;
            pLeft = parseInt(event.target.style.left);
            pTop = parseInt(event.target.style.top);
            bpmn = {
                bpmn: {
                    x: pLeft,
                    y: pTop
                }
            };
            if (Modernizr.localstorage) {
                currentObj = localStorage.getItem(PMDesigner.localStorage.prefix);
                currentObj = (currentObj === null) ? {} : JSON.parse(currentObj);
                jQuery.extend(true, currentObj, bpmn);
                localStorage.setItem(PMDesigner.localStorage.prefix, JSON.stringify(currentObj));
            } else {
                jQuery.extend(true, PMDesigner.cookie.object, bpmn);
                document.cookie = PMDesigner.cookie.name + "=" + JSON.stringify(PMDesigner.cookie.object);
            }
        }
    });
    jQuery(".content_controls").draggable({
        handle: "div",
        start: function () {
        },
        drag: function () {
            jQuery("html").css("overflow", "hidden");
        },
        stop: function (event) {
            jQuery("html").css("overflow", "auto");
            if (jQuery(this).position().top > $(window).height()) {
                var x = $(window).height() - 30;
                jQuery(this).css({'top': x + 'px'});
            }
            var pLeft, pTop, currentObj;
            pLeft = parseInt(event.target.style.left);
            pTop = parseInt(event.target.style.top);
            if (pTop < 90)
                pTop = 90;
            event.target.style.setProperty("top", pTop.toString() + "px");
            controls = {
                controls: {
                    x: pLeft,
                    y: pTop
                }
            };
            if (Modernizr.localstorage) {
                currentObj = localStorage.getItem(PMDesigner.localStorage.prefix);
                currentObj = (currentObj === null) ? {} : JSON.parse(currentObj);
                jQuery.extend(true, currentObj, controls);
                localStorage.setItem(PMDesigner.localStorage.prefix, JSON.stringify(currentObj));
            } else {
                jQuery.extend(true, PMDesigner.cookie.object, controls);
                document.cookie = PMDesigner.cookie.name + "=" + JSON.stringify(PMDesigner.cookie.object);
            }
        }
    });
    /*-----  End of Shapes and Controls Box  ------*/

    //Resize window
    PMDesigner.resizeFrame();

    /*==============================================
     =            Autosave functionality            =
     ==============================================*/
    PMDesigner.project.setSaveInterval(40000);
    setInterval(function () {
        if (PMDesigner.autoSave && PMDesigner.project.isDirty() && PMDesigner.project.readOnly === false) {
            PMDesigner.project.remoteProxy.setUrl(HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + prj_uid);
            PMDesigner.msgFlash('Saving Process'.translate(), document.body, 'success', 5000, 5);
            PMDesigner.project.save(true);
        }
    }, PMDesigner.project.saveInterval);
    /*-----  End of Autosave functionality  ------*/

    //Reviewing functionalities
    if (!PMDesigner.supportBrowser("fullscreen")) {
        var li = document.getElementsByClassName("mafe-button-fullscreen");
        if (li) {
            li[0].parentElement.style.display = "none";
        }
    }
    jQuery('.mafe-zoom-options').attr('title', 'Zoom'.translate()).tooltip({tooltipClass: "mafe-action-tooltip"});
    jQuery('.mafe-toolbar-lasso').mouseover(function (e) {
        $('.mafe-toolbar-lasso').css('cursor', 'pointer');
    });
    jQuery('.mafe-toolbar-validation').mouseover(function (e) {
        $('.mafe-toolbar-validation').css('cursor', 'pointer');
    });
    jQuery('.mafe-toolbar-lasso').click(function (e) {
        if (!PMUI.getActiveCanvas().lassoEnabled) {
            $('.mafe-toolbar-lasso').css('background-color', 'rgb(207, 207, 207)');
            PMUI.getActiveCanvas().lassoEnabled = true;
        } else {
            $('.mafe-toolbar-lasso').css('background-color', 'rgb(233, 233, 233)');
            PMUI.getActiveCanvas().lassoEnabled = false;
        }
    });

    PMDesigner.helper = new IntroHelper({
        tooltipClass: 'general',
        skipLabel: 'Quit'.translate(),

        nextLabel: 'Next &#8594;'.translate(),
        prevLabel: '&#8592; Back'.translate(),
        doneLabel: 'Done'.translate(),
        steps: [
            {
                intro: '<div class="screencast"/>'
            },
            {
                element: '#idNavBar',
                intro: 'The designer bar displays the process name and is used to control the process view (zoom, full screen view), the export, undo/redo and the save button.'.translate()
            },

            {
                element: '.bpmn_shapes',
                intro: 'Drag and drop the process elements that you want to include in the process design.'.translate() +
                '<br /><img src="../../../lib/img/corona-task.png">' + ' Task: Add to include an action in your process.'.translate() +
                '<br /><img src="../../../lib/img/corona-gateway-exclusive.png"> <img src="../../../lib/img/corona-gateway-parallel.png"> <img src="../../../lib/img/corona-gateway-inclusive.png">' + ' Gateway: Selects a path or divides the process into multiple paths and joins them together.'.translate() +
                '<br /><img src="../../../lib/img/corona-start.png"> <img src="../../../lib/img/corona-start-message.png">' + ' Start Event: The process always begins with a start event.'.translate() +
                '<br /><img src="../../../lib/img/corona-intermediate-receive-message.png"> <img src="../../../lib/img/corona-intermediate-send-message.png">' + ' Intermediate Event: Used to define an event that happens in the middle of the process.'.translate() +
                '<br /><img src="../../../lib/img/corona-end.png"> <img src="../../../lib/img/corona-end-message.png">' + ' End Event: End the execution of the process.'.translate() +
                '<br /><img src="../../../lib/img/corona-pool.png">' + ' Pool: Place each process in a separate pool.'.translate() +
                '<br /><img src="../../../lib/img/corona-lane.png">' + ' Lane: Used to divide a process into different sections.'.translate()
            },
            {
                element: '#div-layout-canvas',
                intro: "In the design area you can drop the process elements and order or arrange them to design your process.".translate()
            },
            {
                element: '.content_controls',
                intro: '<p>' +
                'The process objects are used to add execution features to the current process design.'.translate() +
                '<br/>Variables: Define the process data.'.translate() +
                '<br/>Dynaforms: Create dynamic forms.'.translate() +
                '<br/>Triggers: Create scripts.'.translate() +
                '<br/>Output documents: Generate documents with process data.'.translate() +
                '<br/>DB connections: Connect to external databases.'.translate() +
                '</p>',
                position: 'left'
            },
            {
                intro: '<div class="startcoronahelp"></div><div>' + 'Select an element in the designer to display the quick toolbar with the list of the most used options available for that element.'.translate() + '</div>'
            }
        ],
        onExit: function () {
            var canvas = PMUI.getActiveCanvas();
            if (canvas && canvas.getGridLine() && canvas.getHTML()) {
                canvas.getHTML().classList.add("pmui-pmcanvas");
            }
        }
    });

    jQuery('.mafe-toolbar-validation').click(function (e) {
        if (!PMDesigner.validator) {
            $('.mafe-toolbar-validation').css('background-color', 'rgb(207, 207, 207)');
            PMDesigner.validator = true;
        } else {
            $('.bpmn_validator').css('visibility', 'hidden');
            $('.mafe-toolbar-validation').css('background-color', 'rgb(233, 233, 233)');
            PMDesigner.validator = false;
        }
    });
    if (inArray("jXsSi94bkRUcVZyRStNVExlTXhEclVadGRRcG9xbjNvTWVFQUF3cklKQVBiVT0=", ENABLED_FEATURES)) {
        $("#idNavBar").find(".mafe-button-export-process").html(
            $("#idNavBar").find(".mafe-button-export-process").text() + "  &#x25BC;"
        );
    }

    function inArray(needle, haystack) {
        var i,
            length = haystack.length;
        for (i = 0; i < length; i += 1) {
            if (haystack[i] == needle) return true;
        }
        return false;
    }
});

window.onload = function () {
    //Reset the scroll positions
    window.scrollBy(-window.scrollX, -window.scrollY);
    document.onkeydown = function (e) {
        if (e.keyCode === 8 && e.target === document.body) {
            e.stopPropagation();
            return false;
        }
    };
};
/*==================================================
 =            Components from the Panels            =
 ==================================================*/

PMDesigner.createHTML = function () {
    var minShapes = document.createElement("span"),
        minShapesLegend = document.createElement("span"),
        refreshShapes = document.createElement("span"),
        minControls = document.createElement("span"),
        processObjects = document.createElement("span"),
        refreshControls = document.createElement("span"),
        refreshNavBar = document.createElement("span");
    minShapes.id = "minShapes";
    minShapesLegend.id = "minShapesLegend";
    refreshShapes.id = "resetShapes";
    minControls.id = "minControls";
    refreshControls.id = "resetControls";
    refreshNavBar.id = "resetNavBar";
    minShapes.className = "mafe-shapes-toggle";
    minShapesLegend.className = "mafe-shapes-toggle";
    refreshShapes.className = "mafe-shapes-refresh";
    minControls.className = "mafe-shapes-toggle";
    processObjects.className = "mafe-process-object";
    refreshControls.className = "mafe-shapes-refresh";
    refreshNavBar.className = "mafe-shapes-refresh";
    minShapes.title = "Minimize".translate();
    minShapesLegend.title = "Minimize".translate();
    refreshShapes.title = "reset".translate();
    minControls.title = "Minimize".translate();
    refreshControls.title = "Reset to original position".translate();
    refreshNavBar.title = "reset".translate();

    jQuery(minShapes).tooltip({tooltipClass: "mafe-action-tooltip"});
    jQuery(minShapesLegend).tooltip({tooltipClass: "mafe-action-tooltip"});
    jQuery(refreshShapes).tooltip({tooltipClass: "mafe-action-tooltip"});
    jQuery(minControls).tooltip({tooltipClass: "mafe-action-tooltip"});
    jQuery(refreshControls).tooltip({tooltipClass: "mafe-action-tooltip"});
    jQuery(refreshNavBar).tooltip({tooltipClass: "mafe-action-tooltip"});

    refreshControls.style.backgroundPosition = '0px 0px';
    processObjects.textContent = "Process Objects".translate();

    minShapes.onclick = function () {
        var i,
            items = jQuery(".bpmn_shapes > ul");
        if (items.length > 0) {
            for (i = 0; i < items.length; i += 1) {
                if (jQuery(items[i]).css("display").toLowerCase() !== "none") {
                    jQuery(items[i]).css({
                        display: 'none'
                    });
                } else {
                    jQuery(items[i]).css({
                        display: 'block'
                    });
                }

            }
        }
    };
    minShapesLegend.onclick = function () {
        var i,
            items = jQuery(".bpmn_shapes_legend").children();
        for (i = 1; i < items.length; i += 1) {
            if (jQuery(items[i]).css("display").toLowerCase() !== "none") {
                jQuery(items[i]).css({
                    display: 'none'
                });
            } else {
                jQuery(items[i]).css({
                    display: 'block'
                });
            }
        }
    };
    refreshShapes.onclick = function () {
        jQuery(".bpmn_shapes").removeAttr('style');
        if (Modernizr.localstorage) {
            PMDesigner.localStorage.remove("bpmn");
        } else {
            PMDesigner.cookie.remove("bpmn");
        }
    };
    minControls.onclick = function () {
        var i,
            title = '',
            items = jQuery(".content_controls > ul");

        if (items.length > 0) {
            for (i = 0; i < items.length; i += 1) {
                if (jQuery(items[i]).css("display").toLowerCase() !== "none") {
                    jQuery(items[i]).css({
                        display: 'none'
                    });
                    title = "Maximize";
                    $('#minControls').removeClass('mafe-shapes-toggle');
                    $('#minControls').addClass('mafe-shapes-plus');
                } else {
                    jQuery(items[i]).css({
                        display: 'block'
                    });
                    title = "Minimize";
                    $('#minControls').removeClass('mafe-shapes-plus');
                    $('#minControls').addClass('mafe-shapes-toggle');

                }
            }
        }
        jQuery(minControls).tooltip({content: title.translate()});
    };
    refreshControls.onclick = function () {
        jQuery(".content_controls").css({
            left: "auto",
            right: "20px",
            top: "90px"
        });
        if (Modernizr.localstorage) {
            PMDesigner.localStorage.remove("controls");
        } else {
            PMDesigner.cookie.remove("controls");
        }
    };
    refreshNavBar.onclick = function () {
        jQuery(".navBar").removeAttr('style');
        if (Modernizr.localstorage) {
            PMDesigner.localStorage.remove("navbar");
        } else {
            PMDesigner.cookie.remove("navbar");
        }
    };


    jQuery(".bpmn_shapes>div").append(minShapes);
    jQuery(".bpmn_shapes>div").append(refreshShapes);
    jQuery(".content_controls>div").append(processObjects);
    jQuery(".content_controls>div").append(minControls);
    jQuery(".content_controls>div").append(refreshControls);
    jQuery(".navBar>div").append(refreshNavBar);
    jQuery(".bpmn_shapes_legend>div").append(minShapesLegend);
    jQuery(".bpmn_shapes, .content_controls").on("contextmenu", function (e) {
        e.preventDefault();
    });

    PMDesigner.applyCanvasOptions();

};

/*-----  End of Components from the Panels  ------*/

/*=====================================================
 =            Get information about browser            =
 =====================================================*/
PMDesigner.getBrowser = function () {
    var match,
        ua = navigator.userAgent.toLowerCase();
    if (ua) {
        match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
            /(webkit)[ \/]([\w.]+)/.exec(ua) ||
            /(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
            /(msie) ([\w.]+)/.exec(ua) ||
            ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
            [];

        return {
            browser: match[1] || "",
            version: match[2] || "0"
        };
    }
};
/*-----  End of Get information about browser  ------*/

PMDesigner.supportBrowser = function (functionality) {
    var browser, el, module;
    functionality = functionality.toLowerCase();
    switch (functionality) {
        case "fullscreen":
            browser = PMDesigner.getBrowser();
            if ((browser.browser === "msie") && (parseInt(browser.version, 10) <= 10)) {
                try {
                    module = new ActiveXObject("WScript.Shell");
                } catch (e) {
                    module = false;
                }
            } else {
                el = document.documentElement;
                module = el.requestFullScreen || el.webkitRequestFullScreen || el.mozRequestFullScreen || el.msRequestFullScreen;
                if (!module) {
                    module = false;
                }
            }
            break;
        case "":
            break;
    }
    return module;
};

/*============================================================
 =            Leave the current page Functionality            =
 ============================================================*/
window.onbeforeunload = function (e) {
    var message;
    if ((PMDesigner.project.isDirty()
        && !PMDesigner.project.readOnly)
        || PMDesigner.project.isSave) {
        message = "There are unsaved changes, if you leave the editor some changes won't be saved.".translate();
        e = e || window.event;
        if (e) {
            e.returnValue = message;
        }
        return message;
    }
};
/*-----  End of Leave the current page Functionality  ------*/

/*=====================================================================
 =            Validating coordinates for create a new shape            =
 =====================================================================*/
PMUI.validCoordinatedToCreate = function (canvas, event, shape) {
    var position, p, width, height, createElem = true, panels = [], message;
    //navBar panel
    position = jQuery(".navBar").offset();
    width = jQuery(".navBar").width();
    height = jQuery(".navBar").height();
    element = {
        x1: position.left,
        y1: position.top,
        x2: position.left + width,
        y2: position.top + height
    };
    panels.push(element);
    //BPMN panel
    position = jQuery(".bpmn_shapes").offset();
    width = jQuery(".bpmn_shapes").width();
    height = jQuery(".bpmn_shapes").height();
    element = {
        x1: position.left,
        y1: position.top,
        x2: position.left + width,
        y2: position.top + height
    };
    if (panels.length > 0) {
        for (p = 0; p < panels.length; p += 1) {
            if (((event.pageX >= panels[p].x1) && (event.pageX <= panels[p].x2))
                && ((event.pageY >= panels[p].y1) && (event.pageY <= panels[p].y2))) {
                PMDesigner.msgFlash('Is not possible create the element in that area'.translate(), document.body, 'info', 3000, 5);
                return false;
            }
        }
    }

    return true;
};
/*-----  End of Validating coordinates for create a new shape  ------*/

PMUI.pageCoordinatesToShapeCoordinates = function (shape, e, xCoord, yCoord, customShape) {
    var coordinates,
        x = (!xCoord) ? e.pageX : xCoord,
        y = (!yCoord) ? e.pageY : yCoord,
        orgX = (!xCoord) ? e.pageX : xCoord,
        orgY = (!yCoord) ? e.pageY : yCoord,
        canvas = shape.getCanvas();
    x += canvas.getLeftScroll() - shape.getAbsoluteX() - canvas.getX();
    y += canvas.getTopScroll() - shape.getAbsoluteY() - canvas.getY();
    coordinates = new PMUI.util.Point(x, y);
    return coordinates;
};

PMDesigner.msgFlash = function (text, container, severity, duration, zorder) {
    var msg;
    if (!PMDesigner.currentMsgFlash) {
        msg = new PMUI.ui.FlashMessage({
            id: '__msgFlashMessage',
            severity: 'success'
        });
    } else {
        msg = PMDesigner.currentMsgFlash;
    }
    if (msg.html)
        jQuery(msg.html).remove();
    msg.setMessage(text || "");
    msg.setAppendTo(container || document.body);
    msg.setSeverity(severity || "success");
    msg.setDuration(duration || 3000);
    msg.setZOrder(zorder || 200);
    msg.show();
    PMDesigner.currentMsgFlash = msg;
};

PMDesigner.msgWinError = function (text) {
    var msgError;
    if (!PMDesigner.currentWinError) {
        msgError = new PMUI.ui.MessageWindow({
            id: 'showMessageWindowFailure',
            width: 490,
            windowMessageType: 'error',
            title: 'Error'.translate(),
            footerItems: [
                {
                    text: 'Ok'.translate(),
                    handler: function () {
                        msgError.close();
                    },
                    buttonType: "success"
                }
            ]
        });
    } else {
        msgError = PMDesigner.currentWinError;
    }
    msgError.setMessage(text || 'Error'.translate());
    msgError.showFooter();
    msgError.open();
    PMDesigner.currentWinError = msgError;
};

PMDesigner.msgWinWarning = function (text) {
    var msgWarning;
    if (!PMDesigner.currentWinWarning) {
        msgWarning = new PMUI.ui.MessageWindow({
            id: 'showMessageWindowWarning',
            windowMessageType: 'warning',
            width: 490,
            title: 'Warning'.translate(),
            footerItems: [{
                text: 'Ok'.translate(),
                buttonType: "success", handler: function () {
                    msgWarning.close();
                }
            }]
        });
    } else {
        msgWarning = PMDesigner.currentWinWarning;
    }
    msgWarning.setMessage(text || 'Warning'.translate());
    msgWarning.showFooter();
    msgWarning.open();
    PMDesigner.currentWinWarning = msgWarning;
};

PMDesigner.modeReadOnly = function () {
    var restClient;
    if (prj_readonly === 'true') {
        restClient = new PMRestClient({
            typeRequest: 'post',
            multipart: true,
            data: {
                calls: [{
                    url: 'cases/' + app_uid + '/tasks',
                    method: 'GET'
                }
                ]
            },
            functionSuccess: function (xhr, response) {
                var viewTaskInformation = new ViewTaskInformation();
                viewTaskInformation.setData(response[0].response);
                viewTaskInformation.setShapes();
                viewTaskInformation.showViewLegendsInformation();
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });
        restClient.setBaseEndPoint('');
        restClient.executeRestClient();
    }
};

PMDesigner.reloadDataTable = function () {
    $('.bpmn_validator').css('visibility', 'visible');
};
/**
 * Disable the autosave feature
 */
PMDesigner.autoSaveValue = function (value) {
    PMDesigner.autoSave = value;
};
/**
 * Escape XML characters method.
 * There are only five:
 * "   &quot;
 * '   &apos;
 * <   &lt;
 * >   &gt;
 * &   &amp;
 * 
 * @param {string} label
 * @returns {string}
 */
PMDesigner.escapeXMLCharacters = function (label) {
    return label
            .replace(/&/g, "&amp;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&apos;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;");
};

DataDictionary = function () {
};
DataDictionary.prototype.getColor = function (value) {
    switch (value) {
        case 'TASK_IN_PROGRESS':
            return 'red';
        case 'TASK_COMPLETED':
            return 'green';
        case 'TASK_PENDING_NOT_EXECUTED':
            return 'silver';
        case 'TASK_PARALLEL':
            return 'orange';
        default:
            return 'white';
    }
};
DataDictionary.prototype.getStatus = function (value) {
    switch (value) {
        case 'TASK_IN_PROGRESS':
            return 'Task in Progress'.translate();
        case 'TASK_COMPLETED':
            return 'Completed Task'.translate();
        case 'TASK_PENDING_NOT_EXECUTED':
            return 'Pending Task / Not Executed'.translate();
        case 'TASK_PARALLEL':
            return 'Parallel Task'.translate();
        default:
            return value;
    }
};
DataDictionary.prototype.getTasAssignType = function (value) {
    switch (value) {
        case 'BALANCED':
            return 'Balanced'.translate();
        case 'MANUAL':
            return 'Manual'.translate();
        case 'REPORT_TO':
            return 'Report toO'.translate();
        case 'EVALUATE':
            return 'Evaluate'.translate();
        case 'SELF_SERVICE':
            return 'self Service'.translate();
        case 'SELF_SERVICE_EVALUATE':
            return 'Self Service Evaluate'.translate();
        default:
            return value;
    }
};
DataDictionary.prototype.getTasType = function (value) {
    switch (value) {
        case 'NORMAL':
            return 'Normal'.translate();
        case 'SUBPROCESS':
            return 'Sub Process'.translate();
        default:
            return value;
    }
};
DataDictionary.prototype.getTasDerivation = function (value) {
    switch (value) {
        case 'NORMAL':
            return 'Normal'.translate();
        default:
            return value;
    }
};

ViewTaskInformation = function (settings) {
    ViewTaskInformation.prototype.init.call(this, settings);
};
ViewTaskInformation.prototype.init = function () {
    var that = this,
        panelButton = new PMUI.core.Panel({
            layout: 'hbox',
            items: [
                that.getButton('Information', function () {
                    that.showInformation();
                }),
                that.getButton('Delegations', function () {
                    that.showDelegations();
                }),
                that.getButton('Route', function () {
                    that.showRoute();
                })
            ]
        });
    that.windowAbstract.showFooter();
    that.windowAbstract.addItem(panelButton);
    that.windowAbstract.addItem(that.panelvertical);
};
ViewTaskInformation.prototype.dataDictionary = new DataDictionary();
ViewTaskInformation.prototype.data = null;
ViewTaskInformation.prototype.shapeData = null;
ViewTaskInformation.prototype.panelvertical = new PMUI.core.Panel({layout: 'vbox', width: 400});
ViewTaskInformation.prototype.windowAbstract = new PMUI.ui.Window({id: 'windowAbstract', width: 500, height: 350});
ViewTaskInformation.prototype.setData = function (data) {
    this.data = data;
};
ViewTaskInformation.prototype.setCursor = function (shape) {
    shape.getHTML().onmouseover = function () {
        this.style.cursor = 'pointer';
    };
    shape.getHTML().onmouseout = function () {
        this.style.cursor = '';
    };
};
ViewTaskInformation.prototype.setShapes = function () {
    var that = this,
        shape,
        diagrams,
        i,
        j,
        dt = that.data;
    for (i = 0; i < dt.length; i += 1) {
        diagrams = PMDesigner.project.diagrams.asArray();
        for (j = 0; j < diagrams.length; j += 1) {
            shape = diagrams[j].getCustomShapes().find('id', dt[i].tas_uid);
            if (typeof shape != "undefined" && shape != null) {
                shape.changeColor(that.dataDictionary.getColor(dt[i].status));
                shape.data = dt[i];
                shape.hasClick = function (event) {
                    that.setShapeData(this.data);
                    that.showInformation();
                };
                that.setCursor(shape);
            }
        }
    }
};
ViewTaskInformation.prototype.setShapeData = function (data) {
    this.shapeData = data;
};
ViewTaskInformation.prototype.addRowNewLine = function (label, value) {
    var panelhorizontal = new PMUI.core.Panel({
        layout: 'hbox'
    });
    panelhorizontal.addItem(new PMUI.ui.TextLabel({text: ''}));
    this.panelvertical.addItem(panelhorizontal);
    return panelhorizontal;
};
ViewTaskInformation.prototype.addRow = function (label, value) {
    var field1, field2, field3, panelhorizontal;

    field1 = new PMUI.ui.TextLabel({text: label.translate(), proportion: 0.3});
    field2 = new PMUI.ui.TextLabel({text: ':', proportion: 0.1});
    field3 = new PMUI.ui.TextLabel({text: value ? value + '' : '', proportion: 0.6});

    panelhorizontal = new PMUI.core.Panel({
        layout: 'hbox'
    });

    panelhorizontal.addItem(field1);
    panelhorizontal.addItem(field2);
    panelhorizontal.addItem(field3);
    this.panelvertical.addItem(panelhorizontal);
    return panelhorizontal;
};
ViewTaskInformation.prototype.clearRows = function () {
    this.panelvertical.clearItems();
};
ViewTaskInformation.prototype.showInformation = function () {
    var that = this;
    that.clearRows();
    that.addRow('Title'.translate(), that.shapeData.tas_title);
    that.addRow('Description'.translate(), that.shapeData.tas_description);
    that.addRow('Status'.translate(), that.dataDictionary.getStatus(that.shapeData.status));
    that.addRow('Type'.translate(), that.dataDictionary.getTasType(that.shapeData.tas_type));
    that.addRow('Assign type'.translate(), that.dataDictionary.getTasAssignType(that.shapeData.tas_assign_type));
    that.addRow('Routing'.translate(), that.dataDictionary.getTasDerivation(that.shapeData.tas_derivation));
    that.addRow('Start'.translate(), that.shapeData.tas_start);
    that.addRowNewLine();
    that.addRow('Last User Name'.translate(), that.shapeData.usr_username);
    that.addRow('Last User'.translate(), that.shapeData.usr_firstname + ' ' + that.shapeData.usr_lastname);

    that.windowAbstract.setTitle('Information'.translate() + ' ' + that.shapeData.tas_title);
    that.windowAbstract.open();
    that.windowAbstract.body.style.padding = '20px';
};
ViewTaskInformation.prototype.showDelegations = function () {
    var that = this, i, dt;
    that.clearRows();
    dt = that.shapeData.delegations;
    for (i = 0; i < dt.length; i += 1) {
        that.addRow('User', dt[i].usr_username);
        that.addRow('User Name', dt[i].usr_firstname + ' ' + dt[i].usr_lastname);
        that.addRow('Duration', dt[i].del_duration);
        that.addRow('Finish Date', dt[i].del_finish_date);
        that.addRow('Index', dt[i].del_index);
        that.addRow('Init Date', dt[i].del_init_date);
        that.addRow('Task Due Date', dt[i].del_task_due_date);
        that.addRowNewLine();
    }

    that.windowAbstract.setTitle('Delegations'.translate() + ' ' + that.shapeData.tas_title);
    that.windowAbstract.open();
    that.windowAbstract.body.style.padding = '20px';
};
ViewTaskInformation.prototype.showRoute = function () {
    var that = this, i, dt;
    that.clearRows();
    that.addRow('Type', that.shapeData.route.type);
    that.addRowNewLine();
    dt = that.shapeData.route.to;
    for (i = 0; i < dt.length; i += 1) {
        that.addRow('Condition', dt[i].rou_condition);
        that.addRow('Number', dt[i].rou_number);
        that.addRowNewLine();
    }

    that.windowAbstract.setTitle('Route'.translate() + ' ' + that.shapeData.tas_title);
    that.windowAbstract.open();
    that.windowAbstract.body.style.padding = '20px';
};
ViewTaskInformation.prototype.getButton = function (text, fn) {
    return new PMUI.ui.Button({
        text: text.translate(),
        width: 180,
        height: 50,
        style: {
            cssProperties: {
                marginRight: 10,
                marginBottom: 10,
                backgroundColor: '#474747',
                borderRadius: 5,
                padding: 5
            },
            cssClasses: ['mafeButton']
        },
        handler: fn
    });
};
ViewTaskInformation.prototype.showViewLegendsInformation = function () {
    var i, dt, legend, legendIcon, legendText;
    $('.bpmn_shapes_legend').show();

    i;
    dt = [
        ['red', 'Task in Progress'.translate()],
        ['green', 'Completed Task'.translate()],
        ['silver', 'Pending Task / Not Executed'.translate()],
        ['orange', 'Parallel Task'.translate()]
    ];
    for (i = 0; i < dt.length; i += 1) {
        legend = $("<div></div>");
        legendIcon = $("<div></div>").addClass("mafe-activity-task-" + dt[i][0]).addClass("icon-legend");
        legendText = $("<div>" + dt[i][1] + "</div>").addClass("text-legend");
        legend.append(legendIcon).append(legendText);
        jQuery(".bpmn_shapes_legend").append(legend);
    }

    jQuery(".bpmn_shapes_legend").draggable({
        handle: "div",
        start: function () {
        },
        drag: function (event, e, u) {
        },
        stop: function (event) {

        }
    });
};

(function () {
    /**
     * @class PMUI.menu.ContextMenu
     * Handles the context menu of designer
     * contains all the menus for elements
     *
     * @extend PMUI.util.Factory
     * @constructor
     * This method creates a new instance of this object
     * @param {Object} [settings] Constructor settings
     */
    "use strict";
    var ContextMenu = function (settings) {
        this.factory = null;
        ContextMenu.prototype.init.call(this, settings);
    };

    ContextMenu.prototype.type = 'ContextMenu';

    ContextMenu.prototype.family = 'ContextMenu';

    /**
     * Initializes the object.
     * @param  {Object} settings A JSON object with the config options.
     * @private
     */
    ContextMenu.prototype.init = function (settings) {
        jQuery.extend(true, defaults, settings);
        this.factory = new PMUI.util.Factory(defaults.factory);
    };

    /**
     * Register a new context menu object into a product.
     *
     * Usage example:
     *      @example
     *       //Remember, this is an abstract class so it shouldn't be instantiate,
     *       //anyway we are instantiating it just for this example
     *       var additionalMenu = {
     *          id: "additionalMenu",
     *          text: "New Menu",
     *          onClick: function () {
     *              PMDesigner.msgWinWarning('This is a new Menu');
     *              }
     *          };
     *       // Assuming that you're using PMDesigner.contextMenuFactory as the default contextMenuFactory
     *       PMDesigner.contextMenuFactory.registerMenu("CANVAS", additionalMenu);
     *
     * @param  {String} productName Name of the shape or product in factory.
     * @param  {Object} menu Object with menu values and actions.
     * @private
     */
    ContextMenu.prototype.registerMenu = function (productName, menu) {
        if (typeof this.factory.products[productName] === 'undefined') {
            console.log('Context Menu Warning: Cannot add Menu into: ' + productName + '. Please, review name.');
        } else {
            if (this.factory.products[productName].items instanceof Array) {
                this.factory.products[productName].items.push(menu);
            }
        }
    };

    /**
     * Removes context menu object from product.
     *
     * Usage example:
     *      @example
     *       // Assuming that you're using PMDesigner.contextMenuFactory as the default contextMenuFactory
     *       // this example removes Canvas gridLines option
     *       PMDesigner.contextMenuFactory.removeMenu("CANVAS", "id", "menuGridLines");
     *
     * @param  {String} product Name of the shape or product in factory.
     * @param  {String} id Key to look through product.
     * @param  {String} value Name of the elementValue.
     * @private
     */
    ContextMenu.prototype.removeMenu = function (product, id, value) {
        if (typeof this.factory.products[product] !== 'undefined') {
            this.factory.products[product].items = _.reject(this.factory.products[product].items, function (menuValue) {
                return menuValue[id] === value;
            });
        } else {
            console.log('Context Menu Warning: Cannot find ' + product + ' Menu. Please, review name.');
        }
    };

    /**
     * Returns specific product.
     * @param  {String} type Name of product.
     * @private
     */
    ContextMenu.prototype.getProduct = function (type) {
        return this.factory.products[type];
    };

    var menuMessages = {
            'START': {
                'TIMER': 'Please configure cron to create cases.'.translate(),
                'CONDITIONAL': 'Please configure cron to create cases in base to a condition.'.translate(),
                'SIGNALCATCH': 'Please configure cron to create cases in base to a signal.'.translate()
            },
            'INTERMEDIATE': {
                'CATCH': {
                    'TIMER': 'Please configure cron to wait for time event.'.translate(),
                    'CONDITIONAL': 'Please configure cron to wait for time condition.'.translate(),
                    'SIGNALCATCH': 'Please configure script to wait for a signal.'.translate()
                },
                'THROW': {
                    'SIGNALTHROW': 'Please configure a script to send a signal.'.translate()
                }
            },
            'END': {
                'ERRORTHROW': 'Please configure script to end with error status.'.translate(),
                'SIGNALTHROW': 'Please configure script to send a signal.'.translate(),
                'TERMINATETHROW': 'Please configure script to terminate case.'.translate()
            }
        },
        menu = {},
        rootMenu,
        elementActivite,
        typeMenu = {
            text: "Gateway Type".translate(),
            icon: "mafe-menu-properties-action",
            id: "gatewaytype",
            items: [
                {
                    id: "gatewayexclusive",
                    text: "Exclusive (XOR) Gateway".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeTypeTo('EXCLUSIVE');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "gatewayparallel",
                    text: "Parallel (AND) Gateway".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeTypeTo('PARALLEL');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "gatewayinclusive",
                    text: "Inclusive (OR) Gateway".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeTypeTo('INCLUSIVE');
                        PMDesigner.project.updateElement([]);
                    }
                }
            ]
        },
        endMarker = {
            text: "End Event Type".translate(),
            icon: "mafe-menu-properties-action",
            id: "result",
            items: [
                {
                    id: "endempty",
                    text: "Empty".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('EMPTY', 'Empty');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "endemail",
                    text: "Email Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('EMAIL', 'Email Message');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "endmessagethrow",
                    text: "Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('MESSAGETHROW', 'Message');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "enderrorthrow",
                    text: "Error".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('ERRORTHROW', 'Error');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "endsignalthrow",
                    text: "Signal".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('SIGNALTHROW', 'Signal');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "endterminatethrow",
                    text: "Terminate".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('TERMINATETHROW', 'Terminate');
                        PMDesigner.project.updateElement([]);
                    }
                }
            ]
        },
        intermediateCatchMarker = {
            text: "Intermediate Event Type".translate(),
            icon: "mafe-menu-properties-action",
            id: "trigger",
            items: [
                {
                    id: "intermediatemessagecatch",
                    text: "Receive Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('MESSAGECATCH', 'Receive Message');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "intermediatetimer",
                    text: "Timer".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('TIMER', 'Timer');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "intermediateconditional",
                    text: "Conditional".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('CONDITIONAL', 'Conditional');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "intermediatesignalcatch",
                    text: "Signal".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('SIGNALCATCH', 'Signal');
                        PMDesigner.project.updateElement([]);
                    }
                }
            ]
        },
        boundaryCatchMarker = {
            text: "Boundary Event Type".translate(),
            icon: "mafe-menu-properties-action",
            id: "eventType",
            items: [
                {
                    id: "messageCatch",
                    text: "Receive Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('MESSAGECATCH', 'Receive Message');
                    }
                },
                {
                    id: "boundaryTimer",
                    text: "Timer".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('TIMER', 'Timer');
                    }
                },
                {
                    id: "BoudaryConditional",
                    text: "Conditional".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('CONDITIONAL', 'Conditional');
                    }
                },
                {
                    id: "BoudarySignal",
                    text: "Signal".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('SIGNALCATCH', 'Signal');
                    }
                },
                {
                    id: "BoudaryError",
                    text: "Error".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('ERRORCATCH', 'Error');
                    }
                }
            ]
        },
        intermediateThrowMarker = {
            text: "Intermediate Event Type".translate(),
            icon: "mafe-menu-properties-action",
            id: "result",
            items: [
                {
                    id: "intermediateemail",
                    text: "Email Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('EMAIL', 'Email Message');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "intermediatemessagethrow",
                    text: "Send Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('MESSAGETHROW', 'Send Message');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "intermediatesignalthrow",
                    text: "Signal".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('SIGNALTHROW', 'Signal');
                        PMDesigner.project.updateElement([]);
                    }
                }
            ]
        },
        startCatchMarker = {
            text: "Start Event Type".translate(),
            icon: "mafe-menu-properties-action",
            id: "trigger",
            items: [
                {
                    id: "startempty",
                    text: "Empty".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('EMPTY', 'Empty');
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "startmessagecatch",
                    text: "Receive Message".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('MESSAGECATCH', 'Receive Message');
                        rootMenu = menuOption.getRootMenu();
                        rootMenu.getItems()[3].disable();
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "starttimer",
                    text: "Timer".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('TIMER', 'Timer');
                        rootMenu = menuOption.getRootMenu();
                        rootMenu.getItems()[3].disable();
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "startconditional",
                    text: "Conditional".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('CONDITIONAL', 'Conditional');
                        rootMenu = menuOption.getRootMenu();
                        rootMenu.getItems()[3].disable();
                        PMDesigner.project.updateElement([]);
                    }
                },
                {
                    id: "startsignalcatch",
                    text: "Signal".translate(),
                    onClick: function (menuOption) {
                        var targetElement = menuOption
                            .getMenuTargetElement();
                        targetElement.changeMarkerTo('SIGNALCATCH', 'Signal');
                        rootMenu = menuOption.getRootMenu();
                        rootMenu.getItems()[3].disable();
                        PMDesigner.project.updateElement([]);
                    }
                }
            ]
        },
        canvas = {
            id: "menuCanvas",
            width: 150,
            items: [
                {
                    id: "menuEditProcess",
                    text: "Edit Process".translate(),
                    onClick: function (menuOption) {
                        PMDesigner.propertiesProcess();
                    }
                },
                {
                    id: "menuGridLines",
                    text: "Enable Grid Lines".translate(),
                    onClick: function () {
                        var canvas = PMUI.getActiveCanvas();
                        if (canvas.toogleGridLine()) {
                            this.setText("Disable Grid Lines".translate());
                        } else {
                            this.setText("Enable Grid Lines".translate());
                        }
                    }
                }
            ],
            onShow: function (menu) {
                var canvas = PMUI.getActiveCanvas();
                if (canvas.currentConnection) {
                    canvas.currentConnection.hidePortsAndHandlers();
                }
                if (canvas.isGridLine) {
                    menu.items.find('id', 'menuGridLines').setText("Disable Grid Lines".translate());
                }

            }
        },
        task = {
            id: "menuTask",
            items: [
                {
                    id: "taskType",
                    text: "Task Type".translate(),
                    items: [
                        {
                            id: "empty",
                            text: "Empty Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "sendtask",
                            text: "Send Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "receivetask",
                            text: "Receive Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "usertask",
                            text: "User Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "servicetask",
                            text: "Service Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "scripttask",
                            text: "Script Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "manualtask",
                            text: "Manual Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        },
                        {
                            id: "businessrule",
                            text: "Business Rule Task".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerType(menuOption);
                            }
                        }
                    ]
                },
                {
                    id: "loopType",
                    text: "Marker Type".translate(),
                    items: [
                        {
                            id: "empty",
                            text: "None".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerLoopType(menuOption);
                            }
                        },
                        {
                            id: "loop",
                            text: "Loop".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerLoopType(menuOption);
                            }
                        },
                        {
                            id: "parallel",
                            text: "Parallel".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerLoopType(menuOption);
                            }
                        },
                        {
                            id: "sequential",
                            text: "Sequential".translate(),
                            onClick: function (menuOption) {
                                handlerMarkerLoopType(menuOption);
                            }
                        }
                    ]
                },
                {
                    id: "menuTaskSteps",
                    text: "Steps".translate(),
                    icon: "mafe-menu-task-steps",
                    onClick: function (menuOption) {
                        var splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        menuOption.parent.hide();
                        if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                            PMDesigner.restApi.execute({
                                data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                method: "update",
                                url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                success: function (data, textStatus, xhr) {
                                    PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                    PMDesigner.project.isSave = false;
                                    //open property form
                                    PMDesigner.act_name = menuOption.getMenuTargetElement().act_name;
                                    PMDesigner.act_uid = menuOption.getMenuTargetElement().act_uid;
                                    PMDesigner.stepsTask = new stepsTask();
                                },
                                error: function (xhr, textStatus, errorThrown) {
                                    PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                    PMDesigner.project.isSave = false;
                                }
                            });
                        } else {
                            PMDesigner.act_name = menuOption.getMenuTargetElement().act_name;
                            PMDesigner.act_uid = menuOption.getMenuTargetElement().act_uid;
                            PMDesigner.stepsTask = new stepsTask();
                        }
                    }
                },
                {
                    id: "menuTaskAssignedRules",
                    text: "Assignment Rules".translate(),
                    icon: "mafe-menu-users-action",
                    onClick: function (menuOption) {
                        var splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        menuOption.parent.hide();
                        if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                            PMDesigner.restApi.execute({
                                data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                method: "update",
                                url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                success: function (data, textStatus, xhr) {
                                    PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                    PMDesigner.project.isSave = false;
                                    //open property form
                                    PMDesigner.assigmentRules(menuOption.getMenuTargetElement());
                                },
                                error: function (xhr, textStatus, errorThrown) {
                                    PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                    PMDesigner.project.isSave = false;
                                }
                            });
                        } else {
                            PMDesigner.assigmentRules(menuOption.getMenuTargetElement());
                        }
                    }
                },
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.parent.hide();

                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        menuOption.parent.hide();

                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    id: "menuTaskProperties",
                    text: "Properties".translate(),
                    icon: "mafe-menu-properties-action",
                    onClick: function (menuOption) {
                        var splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        menuOption.parent.hide();
                        if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                            PMDesigner.restApi.execute({
                                data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                method: "update",
                                url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                success: function (data, textStatus, xhr) {
                                    PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                    PMDesigner.project.isSave = false;
                                    //open property form
                                    PMDesigner.activityProperties(menuOption.getMenuTargetElement());
                                },
                                error: function (xhr, textStatus, errorThrown) {
                                    PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                    PMDesigner.project.isSave = false;
                                }
                            });
                        } else {
                            PMDesigner.activityProperties(menuOption.getMenuTargetElement());
                        }
                    }
                }
            ],
            onShow: function (menu) {
                var targetElement = menu.getTargetElement();
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(targetElement);
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection
                        .hidePortsAndHandlers();
                }

                if (targetElement.act_task_type == "SCRIPTTASK") {
                    menu.getItems()[1].setVisible(false);
                    menu.getItems()[2].setVisible(false);
                    menu.getItems()[3].setVisible(false);
                } else {
                    menu.getItems()[1].setVisible(true);
                    menu.getItems()[2].setVisible(true);
                    menu.getItems()[3].setVisible(true);
                }

                if (targetElement.act_task_type == "MANUALTASK" || targetElement.act_task_type == "USERTASK" || targetElement.act_task_type == "EMPTY") {
                    menu.getItems()[1].getItems()[2].setVisible(true);
                } else {
                    menu.getItems()[1].getItems()[2].setVisible(false);
                }
            }
        },
        subProcess = {
            id: "menuSubProcess",
            items: [
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.parent.hide();

                        menuOption.getMenuTargetElement().label.canvas
                            .hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete Routing Rule".translate(),
                    icon: "mafe-menu-delete-rules-action",
                    onClick: function (menuOption) {
                        var splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        menuOption.parent.hide();
                        if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                            PMDesigner.restApi.execute({
                                data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                method: "update",
                                url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                success: function (data, textStatus, xhr) {
                                    PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                    PMDesigner.project.isSave = false;
                                    //open property form
                                    PMDesigner.RoutingRuleDeleteAllFlow(menuOption.getMenuTargetElement());
                                },
                                error: function (xhr, textStatus, errorThrown) {
                                    PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                    PMDesigner.project.isSave = false;
                                }
                            });
                        } else {
                            PMDesigner.RoutingRuleDeleteAllFlow(menuOption.getMenuTargetElement());
                        }
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        menuOption.parent.hide();

                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    id: "menuSubProperties",
                    text: "Properties".translate(),
                    icon: "mafe-menu-properties-action",
                    onClick: function (menuOption) {
                        var splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        menuOption.parent.hide();
                        if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                            PMDesigner.restApi.execute({
                                data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                method: "update",
                                url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                success: function (data, textStatus, xhr) {
                                    PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                    PMDesigner.project.isSave = false;
                                    //open property form
                                    PMDesigner.propertiesSubProcess(menuOption
                                        .getMenuTargetElement(menuOption.getMenuTargetElement()));

                                },
                                error: function (xhr, textStatus, errorThrown) {
                                    PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                    PMDesigner.project.isSave = false;
                                }
                            });
                        } else {
                            PMDesigner.propertiesSubProcess(menuOption
                                .getMenuTargetElement(menuOption.getMenuTargetElement()));

                        }
                    }
                }
            ],
            onShow: function (menu) {
                var targetElement = menu.getTargetElement();
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(targetElement);
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection
                        .hidePortsAndHandlers();
                }
            }
        },
        start = {
            id: 'menuStart',
            items: [
                startCatchMarker,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    id: "menuStartWebEntry",
                    text: "Web Entry".translate(),
                    icon: "mafe-menu-start-message-view",
                    //visible: false,
                    onClick: function (menuOption) {
                        var splitedID = menuOption.getMenuTargetElement().getID().split("-"), webEntry;
                        menuOption.parent.hide();
                        if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                            PMDesigner.restApi.execute({
                                data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                method: "update",
                                url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                success: function (data, textStatus, xhr) {
                                    var webEntry;
                                    PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                    PMDesigner.project.isSave = false;
                                    //open property form
                                    webEntry = new WebEntry(menuOption.getMenuTargetElement());
                                    webEntry.render();
                                },
                                error: function (xhr, textStatus, errorThrown) {
                                    PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                    PMDesigner.project.isSave = false;
                                }
                            });
                        } else {
                            webEntry = new WebEntry(menuOption.getMenuTargetElement());
                            webEntry.render();
                        }
                    }
                },
                {
                    id: "menuStartProperties",
                    text: "Properties".translate(),
                    icon: "mafe-menu-start-message-view",
                    onClick: function (menuOption) {
                        var a = menuOption.getMenuTargetElement(), message_window,
                            splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        switch (a.getEventMarker()) {
                            case "TIMER":
                                menuOption.parent.hide();
                                if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                    PMDesigner.restApi.execute({
                                        data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                        method: "update",
                                        url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                        success: function (data, textStatus, xhr) {
                                            PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                            PMDesigner.project.isSave = false;
                                            //open property form
                                            PMDesigner.timerEventProperties(menuOption.getMenuTargetElement());
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                            PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                            PMDesigner.project.isSave = false;
                                        }
                                    });
                                } else {
                                    PMDesigner.timerEventProperties(menuOption.getMenuTargetElement());
                                }
                                break;
                            default :
                                var messageEventDefinition,
                                    eventCurrent = menuOption.getMenuTargetElement();
                                if (menuMessages[eventCurrent.evn_type][eventCurrent.evn_marker] !== undefined) {
                                    message_window = new PMUI.ui.MessageWindow({
                                        id: "cancelMessageTriggers",
                                        width: 490,
                                        title: 'Information'.translate(),
                                        windowMessageType: 'info',
                                        bodyHeight: 'auto',
                                        message: menuMessages[eventCurrent.evn_type][eventCurrent.evn_marker],
                                        footerItems: [
                                            {
                                                text: 'Ok'.translate(),
                                                handler: function () {
                                                    message_window.close();
                                                },
                                                buttonType: "success"
                                            }
                                        ]
                                    });
                                    message_window.open();
                                    message_window.showFooter();
                                } else {
                                    menuOption.parent.hide();
                                    if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                        PMDesigner.restApi.execute({
                                            data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                            method: "update",
                                            url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                            success: function (data, textStatus, xhr) {
                                                PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                                PMDesigner.project.isSave = false;
                                                //open property form
                                                messageEventDefinition = new MessageEventDefinition(eventCurrent);
                                            },
                                            error: function (xhr, textStatus, errorThrown) {
                                                PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                                PMDesigner.project.isSave = false;
                                            }
                                        });
                                    } else {
                                        messageEventDefinition = new MessageEventDefinition(eventCurrent);
                                    }
                                }
                        }
                    }
                }
            ],
            onShow: function (menu) {
                var targetElement = menu.getTargetElement(),
                    shape,
                    propertyMap = ['MESSAGECATCH', 'TIMER'];
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(targetElement);
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
                if (targetElement.evn_marker == 'TIMER') {
                }
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                if (targetElement.evn_marker === 'MESSAGECATCH') {
                    var dt = menu.getItems();
                    for (var i = 0; i < dt.length; i += 1) {
                        if (dt[i].id === 'idReceiveMessage') {
                            dt[i].setVisible(true);
                        }
                    }
                }
                //disabled weebentry for others pmEvent no support
                if (targetElement.getPorts().asArray().length) {
                    shape = targetElement.getPorts().getFirst().getConnection().getDestPort().parent;
                    if (shape && (shape instanceof PMActivity) && targetElement.evn_marker === "EMPTY") {
                        menu.items.find('id', 'menuStartWebEntry').enable();
                    } else if (shape && (shape instanceof PMEvent) && shape.evn_marker === "EMAIL"
                        && targetElement.evn_marker === "EMPTY") {
                        menu.items.find('id', 'menuStartWebEntry').enable();
                    } else {
                        menu.items.find('id', 'menuStartWebEntry').disable();
                    }
                } else {
                    menu.items.find('id', 'menuStartWebEntry').disable();
                }

                //Enable && Disabled - Properties
                if (targetElement.evn_type === "START" && propertyMap.indexOf(targetElement.evn_marker) >= 0) {
                    menu.items.find('id', 'menuStartProperties').enable();
                } else {
                    menu.items.find('id', 'menuStartProperties').disable();
                }
            },
            onHide: function (menu) {
                var dt = menu.getItems(), i;
                for (i = 0; i < dt.length; i += 1) {
                    if (dt[i].id === 'idReceiveMessage') {
                        dt[i].setVisible(false);
                    }
                }
            }
        },
        end = {
            id: 'menuEnd',
            items: [
                endMarker,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    id: "menuEndProperties",
                    text: "Properties".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        var a = menuOption.getMenuTargetElement(), message_window,
                            splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        switch (a.getEventMarker()) {
                            case "EMAIL":
                                menuOption.parent.hide();
                                if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                    PMDesigner.restApi.execute({
                                        data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                        method: "update",
                                        url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                        success: function (data, textStatus, xhr) {
                                            PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                            PMDesigner.project.isSave = false;
                                            //open property form
                                            PMDesigner.emailEventProperties(menuOption.getMenuTargetElement());
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                            PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                            PMDesigner.project.isSave = false;
                                        }
                                    });
                                } else {
                                    PMDesigner.emailEventProperties(menuOption.getMenuTargetElement());
                                }
                                break;
                            default :
                                var messageEventDefinition,
                                    eventCurrent = menuOption.getMenuTargetElement();
                                if (menuMessages[eventCurrent.evn_type][eventCurrent.evn_marker] !== undefined) {
                                    message_window = new PMUI.ui.MessageWindow({
                                        id: "cancelMessageTriggers",
                                        width: 490,
                                        title: 'Information'.translate(),
                                        windowMessageType: 'info',
                                        bodyHeight: 'auto',
                                        message: menuMessages[eventCurrent.evn_type][eventCurrent.evn_marker],
                                        footerItems: [
                                            {
                                                text: 'Ok'.translate(),
                                                handler: function () {
                                                    message_window.close();
                                                },
                                                buttonType: "success"
                                            }
                                        ]
                                    });
                                    message_window.open();
                                    message_window.showFooter();
                                } else {
                                    if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                        PMDesigner.restApi.execute({
                                            data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                            method: "update",
                                            url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                            success: function (data, textStatus, xhr) {
                                                PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                                PMDesigner.project.isSave = false;
                                                //open property form
                                                messageEventDefinition = new MessageEventDefinition(eventCurrent);
                                            },
                                            error: function (xhr, textStatus, errorThrown) {
                                                PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                                PMDesigner.project.isSave = false;
                                            }
                                        });
                                    } else {
                                        messageEventDefinition = new MessageEventDefinition(eventCurrent);
                                    }
                                }
                        }
                    }
                }
            ],
            onShow: function (menu) {
                var propertyMap = ['MESSAGETHROW', 'EMAIL'],
                    targetElement = menu.getTargetElement();
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(targetElement);
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }


                //Enable && Disabled - Properties
                if (targetElement.evn_type === "END" && propertyMap.indexOf(targetElement.evn_marker) >= 0) {
                    menu.items.find('id', 'menuEndProperties').enable();
                } else {
                    menu.items.find('id', 'menuEndProperties').disable();
                }
            }
        },
        selection = {
            id: 'menuSelection',
            items: [
                {
                    text: "Properties".translate(),
                    icon: "mafe-menu-properties-action"
                },
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action"
                }
            ]
        },
        evaluation = {
            id: 'menuEvaluation',
            items: [

                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        alert("Working on this feature...");
                    }
                },
                {
                    text: "Properties".translate(),
                    icon: "mafe-menu-properties-action",
                    onClick: function (menuOption) {
                        alert("Working on this feature...");
                    }
                }
            ]
        },
        parallel = {
            id: 'menuParallel',
            items: [
                typeMenu,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            listeners: {},
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
            }
        },
        exclusive = {
            id: 'menuExclusive',
            items: [
                typeMenu,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: "Delete".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    text: "Properties".translate(),
                    icon: "mafe-menu-properties-action",
                    onClick: function (menuOption) {
                        PMDesigner.RoutingRule(menuOption.getMenuTargetElement());
                    }
                }
            ],
            onShow: function (menu) {
                var element = menu.getTargetElement(), propertyOption;
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(element);
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                if (menu.items) {
                    if (element && element.gat_direction) {
                        propertyOption = menu.items.find("text", "Properties");
                        if (propertyOption) {
                            if (element.gat_direction === 'CONVERGING') {
                                propertyOption.disable();
                            } else {
                                propertyOption.enable();

                            }
                        }
                    }
                }

            }
        },
        inclusive = {
            id: 'menuInclusive',
            items: [
                typeMenu,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    text: 'Properties'.translate(),
                    icon: 'mafe-menu-properties-action',
                    onClick: function (menuOption) {
                        PMDesigner.RoutingRule(menuOption.getMenuTargetElement());
                    }
                }
            ],
            onShow: function (menu) {
                var element = menu.getTargetElement(), propertyOption;
                PMUI.getActiveCanvas().addToSelection(element);
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();

                if (menu.items) {
                    if (element && element.gat_direction) {
                        propertyOption = menu.items.find("text", "Properties");
                        if (propertyOption) {
                            if (element.gat_direction === 'CONVERGING') {
                                propertyOption.disable();
                            } else {
                                propertyOption.enable();

                            }
                        }
                    }
                }
            }
        },
        complex = {
            id: 'menuComplex',
            items: [
                typeMenu,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    text: "Properties".translate(),
                    icon: "mafe-menu-properties-action",
                    onClick: function (menuOption) {
                        PMDesigner.complexRoutingRule(menuOption.getMenuTargetElement());
                    }
                }
            ],
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
            }
        },
        group = {
            id: 'menuLine',
            items: [
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
            }
        },
        dataObject = {
            id: 'menuDataObject',
            items: [
                {
                    id: "dataType",
                    text: "Data Type".translate(),
                    items: [
                        {
                            id: "dataobject",
                            text: "Data Empty".translate(),
                            onClick: function (menuOption) {
                                menuOption.getMenuTargetElement().switchDataType('DATAOBJECT');
                            }
                        },
                        {
                            id: "datainput",
                            text: "Data Input".translate(),
                            onClick: function (menuOption) {
                                menuOption.getMenuTargetElement().switchDataType('DATAINPUT');
                            }
                        },
                        {
                            id: "dataoutput",
                            text: "Data Output".translate(),
                            onClick: function (menuOption) {
                                menuOption.getMenuTargetElement().switchDataType('DATAOUTPUT');
                            }
                        }
                    ]
                },
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
            }
        },
        dataStore = {
            id: 'menuDataObject',
            items: [
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
            }
        },
        textAnnotation = {
            id: 'menuDataObject',
            items: [
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
            }
        },
        intermediate = {
            id: 'intermediate',
            items: [
                intermediateCatchMarker,
                intermediateThrowMarker,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                },
                {
                    id: "intermediateProperties",
                    text: "Properties".translate(),
                    icon: "mafe-menu-delete-action",
                    onClick: function (menuOption) {
                        var a = menuOption.getMenuTargetElement(), message_window,
                            splitedID = menuOption.getMenuTargetElement().getID().split("-");
                        switch (a.getEventMarker()) {
                            case "EMAIL":
                                menuOption.parent.hide();
                                if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                    PMDesigner.restApi.execute({
                                        data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                        method: "update",
                                        url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                        success: function (data, textStatus, xhr) {
                                            PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                            PMDesigner.project.isSave = false;
                                            //open property form
                                            PMDesigner.emailEventProperties(menuOption.getMenuTargetElement());
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                            PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                            PMDesigner.project.isSave = false;
                                        }
                                    });
                                } else {
                                    PMDesigner.emailEventProperties(menuOption.getMenuTargetElement());
                                }
                                break;
                            case "TIMER":
                                menuOption.parent.hide();
                                if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                    PMDesigner.restApi.execute({
                                        data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                        method: "update",
                                        url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                        success: function (data, textStatus, xhr) {
                                            PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                            PMDesigner.project.isSave = false;
                                            //open property form
                                            PMDesigner.timerEventProperties(menuOption.getMenuTargetElement());
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                            PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                            PMDesigner.project.isSave = false;
                                        }
                                    });
                                } else {
                                    PMDesigner.timerEventProperties(menuOption.getMenuTargetElement());
                                }
                                break;
                            default :
                                var messageEventDefinition,
                                    eventCurrent = menuOption.getMenuTargetElement();
                                if (menuMessages[eventCurrent.evn_type][eventCurrent.evn_behavior][eventCurrent.evn_marker] !== undefined) {
                                    message_window = new PMUI.ui.MessageWindow({
                                        id: "cancelMessageTriggers",
                                        width: 490,
                                        title: 'Information'.translate(),
                                        windowMessageType: 'info',
                                        bodyHeight: 'auto',
                                        message: menuMessages[eventCurrent.evn_type][eventCurrent.evn_behavior][eventCurrent.evn_marker],
                                        footerItems: [
                                            {
                                                text: 'Ok'.translate(),
                                                handler: function () {
                                                    message_window.close();
                                                },
                                                buttonType: "success"
                                            }
                                        ]
                                    });
                                    message_window.open();
                                    message_window.showFooter();
                                } else {
                                    menuOption.parent.hide();
                                    if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                                        PMDesigner.restApi.execute({
                                            data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                                            method: "update",
                                            url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                                            success: function (data, textStatus, xhr) {
                                                PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                                                PMDesigner.project.isSave = false;
                                                //open property form
                                                messageEventDefinition = new MessageEventDefinition(eventCurrent);
                                            },
                                            error: function (xhr, textStatus, errorThrown) {
                                                PMDesigner.project.listeners.failure(that, textStatus, xhr);
                                                PMDesigner.project.isSave = false;
                                            }
                                        });
                                    } else {
                                        messageEventDefinition = new MessageEventDefinition(eventCurrent);
                                    }
                                }
                        }

                    }
                }
            ],
            onShow: function (menu) {
                var targetElement = menu.getTargetElement(),
                    propertyEnabled = ['MESSAGECATCH', 'MESSAGETHROW', 'EMAIL', 'TIMER'];

                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();

                if (targetElement.evn_behavior === 'CATCH') {
                    targetElement.menu.getItems()[0].setVisible(true);
                    targetElement.menu.getItems()[1].setVisible(false);
                } else {
                    targetElement.menu.getItems()[0].setVisible(false);
                    targetElement.menu.getItems()[1].setVisible(true);
                }

                //Enable && Disabled - Properties
                if (propertyEnabled.indexOf(targetElement.evn_marker) >= 0) {

                    menu.items.find('id', 'intermediateProperties').enable();
                } else {
                    menu.items.find('id', 'intermediateProperties').disable();
                }
            }
        },
        boundary = {
            id: 'menuDataObject',
            items: [
                boundaryCatchMarker,
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            onShow: function (menu) {
                var targetElement = menu.getTargetElement();

                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();

            }
        },
        participant = {
            id: 'menuDataObject',
            items: [
                {
                    text: "Edit Label".translate(),
                    icon: "mafe-menu-edit-label-action",
                    onClick: function (menuOption) {
                        menuOption.getMenuTargetElement().label.canvas.hideAllFocusLabels();
                        menuOption.getMenuTargetElement().label.getFocus();
                    }
                },
                {
                    text: 'Delete'.translate(),
                    icon: 'mafe-menu-delete-action',
                    onClick: function (menuOption) {
                        PMUI.getActiveCanvas().removeElements();
                    }
                }
            ],
            onShow: function (menu) {
                PMUI.getActiveCanvas().emptyCurrentSelection();
                PMUI.getActiveCanvas().addToSelection(menu.getTargetElement());
                if (PMUI.getActiveCanvas().currentConnection) {
                    PMUI.getActiveCanvas().currentConnection.hidePortsAndHandlers();
                }
                PMUI.getActiveCanvas().hideDragConnectHandlers();
                PMUI.getActiveCanvas().hideAllFocusLabels();
            }
        };
    var defaults = {
        factory: {
            products: {
                'CANVAS': canvas,
                'TASK': task,
                'SUB_PROCESS': subProcess,
                'START': start,
                'END': end,
                'SELECTION': selection,
                'EVALUATION': evaluation,
                'PARALLEL': parallel,
                'EXCLUSIVE': exclusive,
                'EVENTBASED': exclusive,
                'EXCLUSIVEEVENTBASED': exclusive,
                'PARALLELEVENTBASED': exclusive,
                'INCLUSIVE': inclusive,
                'COMPLEX': complex,
                'VERTICAL_LINE': group,
                'HORIZONTAL_LINE': group,
                'GROUP': group,
                'LANE': participant,
                'DATAOBJECT': dataObject,
                'DATASTORE': dataStore,
                'TEXT_ANNOTATION': textAnnotation,
                'V_LABEL': textAnnotation,
                'H_LABEL': textAnnotation,
                'INTERMEDIATE': intermediate,
                'BOUNDARY': boundary,
                'PARTICIPANT': participant,
                'POOL': participant
            },

            defaultProduct: 'START'
        }
    };

    PMDesigner.contextMenuFactory = new ContextMenu(defaults.factory);
    PMDesigner.getMenuFactory = function (type) {
        if (prj_readonly === 'true') {
            return {};
        }
        return PMDesigner.contextMenuFactory.getProduct(type);
    };
    /**
     * Change task type marker
     * @param menuOption
     */
    function handlerMarkerType(menuOption) {
        var result = true,
            tempType = menuOption.getMenuTargetElement().getTaskType();
        menuOption.parent.hide();

        menuOption.getMenuTargetElement().switchTaskType(menuOption.id.toUpperCase());

        //validate if act loop type is parallel
        if (menuOption.getMenuTargetElement().act_loop_type === "PARALLEL") {
            handlerMarkerLoopType(menuOption, tempType)
        }

        //to enable save button
        PMDesigner.project.updateElement([]);

    }

    /**
     * Change marker loop type
     * @param menuOption
     * @param type
     * @returns {boolean}
     */
    function handlerMarkerLoopType(menuOption, type) {
        var message_window,
            loopType = menuOption.id.toUpperCase(),
            taskType = menuOption.getMenuTargetElement().act_task_type;
        if (typeof type !== 'undefined' && type !== null) {
            taskType = type;
        }

        if (menuOption.getMenuTargetElement().act_loop_type === "PARALLEL") {

            message_window = new PMUI.ui.MessageWindow({
                id: "handlerMarkerType",
                width: 490,
                title: 'Parallel Marker Type'.translate(),
                windowMessageType: 'warning',
                bodyHeight: 'auto',
                message: "The configuring of multiple instances will be lost".translate(),
                footerItems: [
                    {
                        text: 'Cancel'.translate(),
                        handler: function () {
                            menuOption.getMenuTargetElement().switchLoopType('PARALLEL');
                            menuOption.getMenuTargetElement().switchTaskType(taskType);
                            message_window.close();
                            return false;
                        },
                        buttonType: "error"
                    },
                    {
                        text: 'Continue'.translate(),
                        handler: function () {
                            try {
                                if (loopType == "loop" || loopType == "sequential") {
                                    menuOption.getMenuTargetElement().switchLoopType(loopType.toUpperCase());
                                } else {
                                    menuOption.getMenuTargetElement().switchLoopType('EMPTY');
                                }
                                PMDesigner.project.updateElement([]);
                            } catch (e) {
                                console.error("loop marker error", e.message);
                            }
                            message_window.close();
                            return true;
                        },
                        buttonType: "success"
                    }

                ]
            });
            message_window.open();
            message_window.showFooter();
        } else {
            menuOption.parent.hide();
            menuOption.getMenuTargetElement().switchLoopType(loopType.toUpperCase());
            PMDesigner.project.updateElement([]);
            return true;
        }
    }

}());

(function () {
    PMDesigner.shapeFactory = function (type, options) {
        var customshape = null,
            menuShape,
            defaultOptions = null,
            canvasName,
            name,
            id,
            classEvent = "start",
            pmCanvas = this.canvas,
            corona = PMDesigner.defaultCrown,
            wildcard;

        canvasName = new IncrementNameCanvas(pmCanvas);
        name = canvasName.get(type);

        if (typeof options === 'undefined') {
            options = {};
            if (type === 'START_MESSAGE') {
                type = 'START';
                classEvent = "message";
                options.evn_marker = 'MESSAGECATCH';
            }
            if (type === 'START_TIMER') {
                type = 'START';
                classEvent = "timer";
                options.evn_marker = 'TIMER';
            }

            if (type === 'END_MESSAGE') {
                type = 'END';
                classEvent = "message";
                options.evn_marker = 'MESSAGETHROW';
            }
            if (type === 'END_EMAIL') {
                type = 'END';
                classEvent = "email";
                options.evn_marker = 'EMAIL';
                options.evn_behavior = 'THROW';
            }
            if (type === 'INTERMEDIATE_SENDMESSAGE') {
                type = 'INTERMEDIATE';
                classEvent = "sendmessage";
                options.evn_marker = 'MESSAGETHROW';
                options.evn_behavior = 'THROW';
            }
            if (type === 'INTERMEDIATE_RECEIVEMESSAGE') {
                type = 'INTERMEDIATE';
                classEvent = "receivemessage";
                options.evn_marker = 'MESSAGECATCH';
                options.evn_behavior = 'CATCH';
            }
            if (type === 'INTERMEDIATE_EMAIL') {
                type = 'INTERMEDIATE';
                classEvent = "email";
                options.evn_marker = 'EMAIL';
                options.evn_behavior = 'THROW';
            }
            if (type === 'INTERMEDIATE_TIMER') {
                type = 'INTERMEDIATE';
                classEvent = "timer";
                options.evn_marker = 'TIMER';
            }
            if (type === 'BOUNDARY_EVENT') {
                type = 'BOUNDARY';
                classEvent = "receivemessage";
                options.evn_marker = 'EMPTY';
                options.evn_behavior = 'CATCH';
            }

            switch (type) {
                case 'COMPLEX':
                case 'PARALLEL':
                case 'EXCLUSIVE':
                case 'EVENTBASED':
                case 'EXCLUSIVEEVENTBASED':
                case 'PARALLELEVENTBASED':
                case 'INCLUSIVE':
                    options.gat_type = type;
                    break;
            }
        }
        if (type === 'DATAOBJECT') {
            type = 'DATAOBJECT';
            options.dat_object_type = 'dataobject';
        }
        if (type === 'DATAINPUT') {
            type = 'DATAOBJECT';
            options.dat_object_type = 'datainput';
        }
        if (type === 'DATAOUTPUT') {
            type = 'DATAOBJECT';
            options.dat_object_type = 'dataoutput';
        }

        wildcard = [
            {
                name: 'wildcard'.translate(),
                className: 'mafe-wildcard',
                onClick: null,
                column: 2
            }
        ];

        switch (type) {
            case 'TASK':
                defaultOptions = {
                    canvas: pmCanvas,
                    width: 150,
                    height: 75,
                    act_type: 'TASK',
                    act_name: name,
                    act_task_type: 'EMPTY',
                    act_loop_type: 'EMPTY',
                    minHeight: 30,
                    minWidth: 150,
                    maxHeight: 50,
                    maxWidth: 170,
                    container: "activity",
                    labels: [
                        {
                            message: name,
                            width: 0,
                            height: 0,
                            position: {
                                location: 'center',
                                diffX: 0,
                                diffY: 0
                            },
                            attachEvents: false
                        }
                    ],
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: [
                                    'mafe-activity-task'
                                ]
                            }
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }

                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'activityResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmactivitydrop",
                        selectors: [
                            "#BOUNDARY_EVENT",
                            ".mafe-event-boundary",
                            ".dragConnectHandler"
                        ]
                    },
                    markers: [
                        {
                            markerType: 'USERTASK',
                            x: 10,
                            y: 10,
                            position: 0,
                            markerZoomClasses: []
                        },
                        {
                            markerType: 'EMPTY',
                            x: 10,
                            y: 10,
                            position: 4,
                            markerZoomClasses: []
                        }
                    ],
                    validatorMarker: {
                        width: 12,
                        height: 12,
                        position: 2,
                        errors: {
                            style: {
                                markerZoomClassesError: [
                                    "mafe-style-error-marker-7",
                                    "mafe-style-error-marker-10",
                                    "mafe-style-error-marker-14",
                                    "mafe-style-error-marker-17",
                                    "mafe-style-error-marker-21"
                                ],
                                markerZoomClassesWarning: [
                                    "mafe-style-warning-marker-7",
                                    "mafe-style-warning-marker-10",
                                    "mafe-style-warning-marker-14",
                                    "mafe-style-warning-marker-17",
                                    "mafe-style-warning-marker-21"
                                ]
                            }
                        }
                    },
                    corona: corona,
                    focusLabel: true
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.markers[0]
                    .markerZoomClasses = PMDesigner.updateMarkerLayerClasses(defaultOptions);
                defaultOptions.markers[1]
                    .markerZoomClasses = PMDesigner.updateLoopLayerClasses(defaultOptions);
                customshape = new PMActivity(defaultOptions);
                break;
            case 'SUB_PROCESS':
                defaultOptions = {
                    canvas: pmCanvas,
                    width: 150,
                    height: 75,
                    act_type: 'SUB_PROCESS',
                    act_loop_type: 'EMPTY',
                    act_name: name,
                    act_task_type: 'COLLAPSED',
                    minHeight: 30,
                    minWidth: 150,
                    maxHeight: 50,
                    maxWidth: 170,
                    container: "activity",
                    labels: [
                        {
                            message: name,
                            position: {
                                location: 'center',
                                diffX: 0,
                                diffY: 0
                            },
                            attachEvents: false
                        }
                    ],
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: [
                                    'mafe-activity-subprocess'
                                ]
                            }
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }

                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'activityResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmactivitydrop",
                        selectors: [
                            "#BOUNDARY_EVENT",
                            ".mafe-event-boundary",
                            ".dragConnectHandler"
                        ]
                    },
                    markers: [
                        {
                            markerType: 'COLLAPSED',
                            x: 10,
                            y: 10,
                            position: 4,
                            markerZoomClasses: [
                                "mafe-collapsed-marker-10",
                                "mafe-collapsed-marker-15",
                                "mafe-collapsed-marker-21",
                                "mafe-collapsed-marker-26",
                                "mafe-collapsed-marker-31"
                            ]
                        }
                    ],
                    validatorMarker: {
                        width: 12,
                        height: 12,
                        position: 2,
                        errors: {
                            style: {
                                markerZoomClassesError: [
                                    "mafe-style-error-marker-7",
                                    "mafe-style-error-marker-10",
                                    "mafe-style-error-marker-14",
                                    "mafe-style-error-marker-17",
                                    "mafe-style-error-marker-21"
                                ]
                            }
                        }
                    },
                    corona: corona,
                    focusLabel: true
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.markers[0]
                    .markerZoomClasses = PMDesigner.updateMarkerLayerClasses(defaultOptions);
                customshape = new PMActivity(defaultOptions);
                break;
            case 'START':
                defaultOptions = {
                    canvas: pmCanvas,
                    width: 33,
                    height: 33,
                    evn_type: 'START',
                    evn_name: '',
                    evn_marker: 'EMPTY',
                    evn_behavior: 'catch',
                    evn_message: 'LEAD',
                    labels: [
                        {
                            message: '',
                            visible: true,
                            width: 100,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 13
                            }
                        }
                    ],
                    style: {
                        cssClasses: ['mafe-event-start']
                    },
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-event-start-empty-16',
                                'mafe-event-start-empty-24',
                                'mafe-event-start-empty-33',
                                'mafe-event-start-empty-41',
                                'mafe-event-start-empty-49'
                            ]
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    validatorMarker: {
                        width: 12,
                        height: 12,
                        position: 2,
                        errors: {
                            style: {
                                markerZoomClassesError: [
                                    "mafe-style-error-marker-7",
                                    "mafe-style-error-marker-10",
                                    "mafe-style-error-marker-14",
                                    "mafe-style-error-marker-17",
                                    "mafe-style-error-marker-21"
                                ]
                            }
                        }
                    },
                    corona: corona
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.layers[0]
                    .zoomSprites = PMDesigner.updateLayerClasses(defaultOptions);
                customshape = new PMEvent(defaultOptions);
                break;
            case 'INTERMEDIATE':
                defaultOptions = {
                    canvas: pmCanvas,
                    width: 33,
                    height: 33,
                    evn_type: 'INTERMEDIATE',
                    evn_name: '',
                    evn_marker: 'EMPTY',
                    evn_behavior: 'CATCH',
                    labels: [
                        {
                            message: '',
                            visible: true,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 13
                            }
                        }
                    ],
                    style: {
                        cssClasses: ['mafe-event-intermediate']
                    },
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-event-intermediate-16',
                                'mafe-event-intermediate-24',
                                'mafe-event-intermediate-33',
                                'mafe-event-intermediate-41',
                                'mafe-event-intermediate-49'
                            ]
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    validatorMarker: {
                        width: 12,
                        height: 12,
                        position: 2,
                        errors: {
                            style: {
                                markerZoomClassesError: [
                                    "mafe-style-error-marker-7",
                                    "mafe-style-error-marker-10",
                                    "mafe-style-error-marker-14",
                                    "mafe-style-error-marker-17",
                                    "mafe-style-error-marker-21"
                                ]
                            }
                        }
                    },
                    corona: corona
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.layers[0]
                    .zoomSprites = PMDesigner.updateLayerClasses(defaultOptions);
                customshape = new PMEvent(defaultOptions);
                break;
            case 'BOUNDARY':
                defaultOptions = {
                    canvas: pmCanvas,
                    width: 33,
                    height: 33,
                    evn_type: 'BOUNDARY',
                    evn_name: '',
                    evn_marker: 'EMPTY',
                    evn_behavior: 'CATCH',
                    labels: [
                        {
                            message: '',
                            visible: true,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 0
                            }
                        }
                    ],
                    style: {
                        cssClasses: ['mafe-event-boundary']
                    },
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-event-intermediate-16',
                                'mafe-event-intermediate-24',
                                'mafe-event-intermediate-33',
                                'mafe-event-intermediate-41',
                                'mafe-event-intermediate-49'
                            ]
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    drag: 'nodrag'
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.layers[0]
                    .zoomSprites = PMDesigner.updateLayerClasses(defaultOptions);
                customshape = new PMEvent(defaultOptions);
                break;

            case 'END':
                defaultOptions = {
                    canvas: pmCanvas,
                    width: 33,
                    height: 33,
                    evn_type: 'END',
                    evn_name: '',
                    evn_marker: 'EMPTY',
                    evn_behavior: 'throw',
                    labels: [
                        {
                            message: '',
                            visible: true,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 13
                            }
                        }
                    ],
                    style: {
                        cssClasses: ['mafe-event-end']
                    },
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-event-end-empty-16',
                                'mafe-event-end-empty-24',
                                'mafe-event-end-empty-33',
                                'mafe-event-end-empty-41',
                                'mafe-event-end-empty-49'
                            ]
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    validatorMarker: {
                        width: 12,
                        height: 12,
                        position: 2,
                        errors: {
                            style: {
                                markerZoomClassesError: [
                                    "mafe-style-error-marker-7",
                                    "mafe-style-error-marker-10",
                                    "mafe-style-error-marker-14",
                                    "mafe-style-error-marker-17",
                                    "mafe-style-error-marker-21"
                                ]
                            }
                        }
                    },
                    corona: corona
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.layers[0]
                    .zoomSprites = PMDesigner.updateLayerClasses(defaultOptions);
                customshape = new PMEvent(defaultOptions);
                break;

            case 'COMPLEX':
            case 'PARALLEL':
            case 'EXCLUSIVE':
            case 'EVENTBASED':
            case 'EXCLUSIVEEVENTBASED':
            case 'PARALLELEVENTBASED':
            case 'INCLUSIVE':
                defaultOptions = {
                    labels: [
                        {
                            message: '',
                            visible: true,
                            width: 100,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 13
                            }
                        }
                    ],
                    canvas: pmCanvas,
                    width: 41,
                    height: 41,
                    gat_type: 'EXCLUSIVE',
                    gat_name: '',
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-gateway-exclusive-20',
                                'mafe-gateway-exclusive-30',
                                'mafe-gateway-exclusive-41',
                                'mafe-gateway-exclusive-51',
                                'mafe-gateway-exclusive-61'
                            ]
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    validatorMarker: {
                        width: 12,
                        height: 12,
                        position: 2,
                        errors: {
                            style: {
                                markerZoomClassesError: [
                                    "mafe-style-error-marker-7",
                                    "mafe-style-error-marker-10",
                                    "mafe-style-error-marker-14",
                                    "mafe-style-error-marker-17",
                                    "mafe-style-error-marker-21"
                                ]
                            }
                        }
                    },
                    corona: corona
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.layers[0]
                    .zoomSprites = PMDesigner.updateGatewayLayerClasses(defaultOptions);
                customshape = new PMGateway(defaultOptions);
                break;
            case 'GROUP':
                defaultOptions = {
                    art_name: name,
                    art_type: 'GROUP',
                    canvas: pmCanvas,
                    width: 200,
                    height: 100,
                    style: {
                        cssClasses: ['mafe-artifact-group']
                    },
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "background-layer",
                            priority: 1,
                            visible: true,
                            style: {
                                cssClasses: [
                                    'mafe-artifact-group'
                                ]
                            }
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'annotationResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        }
                    },
                    labels: [
                        {
                            message: "",
                            width: 0,
                            height: 0,
                            position: {
                                location: 'top',
                                diffX: 2,
                                diffY: 0
                            },
                            attachEvents: false,
                            updateParent: true,
                            style: {
                                cssClasses: [
                                    'mafe-label-annotation'
                                ]
                            }
                        }
                    ],
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    corona: corona,
                    focusLabel: true
                };
                jQuery.extend(true, defaultOptions, options);
                customshape = new PMArtifact(defaultOptions);
                break;
            case 'TEXT_ANNOTATION':
                defaultOptions = {
                    art_name: name,
                    art_type: 'TEXT_ANNOTATION',
                    canvas: pmCanvas,
                    width: 100,
                    height: 30,
                    style: {
                        cssClasses: ['mafe-artifact-annotation']
                    },
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "background-layer",
                            priority: 1,
                            visible: true,
                            style: {
                                cssClasses: [
                                    'mafe-artifact-annotation'
                                ]
                            }
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'annotationResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        }
                    },
                    labels: [
                        {
                            message: name,
                            width: 0,
                            height: 0,
                            position: {
                                location: 'center',
                                diffX: 0,
                                diffY: 0
                            },
                            attachEvents: false,
                            updateParent: true
                        }
                    ],
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    corona: corona,
                    focusLabel: true
                };
                jQuery.extend(true, defaultOptions, options);
                customshape = new PMArtifact(defaultOptions);
                break;

            case 'DATAOBJECT':
                defaultOptions = {
                    labels: [
                        {
                            message: '',
                            visible: true,
                            width: 100,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 0
                            }
                        }
                    ],
                    canvas: pmCanvas,
                    width: 33,
                    height: 41,
                    dat_type: 'DATAOBJECT',
                    dat_object_type: "dataobject",
                    dat_name: '',
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-dataobject-50',
                                'mafe-dataobject-75',
                                'mafe-dataobject-100',
                                'mafe-dataobject-125',
                                'mafe-dataobject-150'
                            ]
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    markers: [
                        {
                            markerType: 'USERTASK',
                            x: 10,
                            y: 10,
                            position: 0
                        }
                    ],
                    corona: corona
                };
                jQuery.extend(true, defaultOptions, options);
                defaultOptions.markers[0]
                    .markerZoomClasses = PMDesigner.updateDataMarkerLayerClasses(defaultOptions);
                customshape = new PMData(defaultOptions);
                break;

            case 'DATASTORE':
                defaultOptions = {
                    labels: [
                        {
                            message: '',
                            visible: true,
                            width: 100,
                            position: {
                                location: 'bottom',
                                diffX: 0,
                                diffY: 0
                            }
                        }
                    ],
                    canvas: pmCanvas,
                    width: 41,
                    height: 41,
                    dat_type: 'DATASTORE',
                    dat_name: '',
                    layers: [
                        {
                            x: 0,
                            y: 0,
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssClasses: []
                            },
                            zoomSprites: [
                                'mafe-datastore-20',
                                'mafe-datastore-30',
                                'mafe-datastore-41',
                                'mafe-datastore-51',
                                'mafe-datastore-61'
                            ]
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    connectAtMiddlePoints: true,
                    resizeBehavior: 'NoResize',
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 4,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },

                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    corona: corona
                };
                jQuery.extend(true, defaultOptions, options);
                customshape = new PMData(defaultOptions);
                break;
            case 'PARTICIPANT':
                defaultOptions = {
                    width: 500,
                    height: 130,
                    "canvas": this,
                    "connectAtMiddlePoints": false,
                    topLeft: true,
                    connectionType: 'dotted',
                    resizeBehavior: "participantResize",
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmconnection",
                        selectors: ['.dragConnectHandler']
                    },
                    "style": {
                        cssClasses: ["mafe-pool"]

                    },
                    layers: [
                        {
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssProperties: {}
                            }
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    labels: [
                        {
                            message: name,
                            width: 0,
                            height: 0,
                            orientation: 'vertical',
                            position: {
                                location: 'center-left',
                                diffX: 15,
                                diffY: 0
                            },
                            attachEvents: false
                        }
                    ],
                    par_name: name,
                    corona: corona,
                    focusLabel: true

                };
                jQuery.extend(true, defaultOptions, options);
                customshape = new PMParticipant(defaultOptions);
                break;
            case 'POOL':
                if (options.lns_name) {
                    name = options.lns_name;
                } else if (options.par_name) {
                    name = options.par_name;
                }
                defaultOptions = {
                    width: 700,
                    height: 200,
                    "canvas": pmCanvas,
                    "connectAtMiddlePoints": false,
                    topLeft: false,
                    connectionType: 'dotted',
                    resizeBehavior: "poolResize",
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmcontainer",
                        selectors: [
                            "#TASK",
                            "#SUB_PROCESS",
                            "#START",
                            "#START_MESSAGE",
                            "#START_TIMER",
                            "#END",
                            "#END_MESSAGE",
                            "#END_EMAIL",
                            "#INTERMEDIATE_SENDMESSAGE",
                            "#INTERMEDIATE_RECEIVEMESSAGE",
                            "#INTERMEDIATE_EMAIL",
                            "#INTERMEDIATE_TIMER",
                            "#EXCLUSIVE",
                            "#PARALLEL",
                            "#INCLUSIVE",
                            "#DATAOBJECT",
                            "#DATASTORE",
                            "#TEXT_ANNOTATION",
                            "#LANE",
                            "#GROUP",
                            ".mafe-event-start",
                            ".mafe-event-intermediate",
                            ".mafe-event-end",
                            ".pmui-pmactivity",
                            ".pmui-pmgateway",
                            ".pmui-pmdata",
                            ".mafe-artifact-annotation",
                            ".mafe-artifact-group",
                            ".port"
                        ]
                    },
                    container: "pool",
                    "style": {
                        cssClasses: ["mafe-pool"]

                    },
                    layers: [
                        {
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssProperties: {}
                            }
                        },
                        {
                            x: 0,
                            y: 0,
                            layerName: "second-layer",
                            priority: 2,
                            visible: false,
                            style: {
                                cssClasses: []
                            }
                        }
                    ],
                    labels: [
                        {
                            message: name,
                            width: 0,
                            height: 0,
                            orientation: 'vertical',
                            position: {
                                location: 'center-left',
                                diffX: 15,
                                diffY: 0
                            },
                            attachEvents: false
                        }
                    ],
                    lns_name: name,
                    focusLabel: true,
                    corona: corona

                };
                jQuery.extend(true, defaultOptions, options);
                customshape = new PMPool(defaultOptions);
                break;
            case 'LANE':
                defaultOptions = {
                    width: 500,
                    height: 200,
                    "canvas": pmCanvas,
                    "connectAtMiddlePoints": false,
                    topLeft: true,
                    connectionType: 'dotted',
                    resizeBehavior: "laneResize",
                    resizeHandlers: {
                        type: "Rectangle",
                        total: 8,
                        resizableStyle: {
                            cssProperties: {
                                'background-color': "rgb(0, 255, 0)",
                                'border': '1px solid black'
                            }
                        },
                        nonResizableStyle: {
                            cssProperties: {
                                'background-color': "white",
                                'border': '1px solid black'
                            }
                        }
                    },
                    "drop": {
                        type: "pmcontainer",
                        selectors: [
                            "#TASK",
                            "#SUB_PROCESS",
                            "#START",
                            "#START_MESSAGE",
                            "#START_TIMER",
                            "#END",
                            "#END_MESSAGE",
                            "#END_EMAIL",
                            "#INTERMEDIATE_SENDMESSAGE",
                            "#INTERMEDIATE_RECEIVEMESSAGE",
                            "#INTERMEDIATE_EMAIL",
                            "#INTERMEDIATE_TIMER",
                            "#EXCLUSIVE",
                            "#PARALLEL",
                            "#INCLUSIVE",
                            "#DATAOBJECT",
                            "#DATASTORE",
                            "#GROUP",
                            "#TEXT_ANNOTATION",
                            ".mafe-event-start",
                            ".mafe-event-intermediate",
                            ".mafe-event-end",
                            ".pmui-pmactivity",
                            ".pmui-pmgateway",
                            ".pmui-pmdata",
                            ".mafe-artifact-annotation",
                            ".mafe-artifact-group"
                        ]
                    },
                    container: "lane",
                    layers: [
                        {
                            layerName: "first-layer",
                            priority: 2,
                            visible: true,
                            style: {
                                cssProperties: {}
                            }
                        }

                    ],
                    labels: [
                        {
                            message: name,
                            width: 0,
                            height: 0,
                            orientation: 'vertical',
                            position: {
                                location: 'center-left',
                                diffX: 15,
                                diffY: 0
                            }
                        }
                    ],
                    lan_name: name,
                    focusLabel: true

                };
                jQuery.extend(true, defaultOptions, options);
                customshape = new PMLane(defaultOptions);
                break;

        }
        if (customshape && !pmCanvas.readOnly) {
            customshape.attachListeners();
            customshape.extendedType = type;
            menuShape = PMDesigner.getMenuFactory(type);
            customshape.getHTML();
            customshape.setContextMenu(menuShape);
        }
        return customshape;
    };
    PMDesigner.updateLayerClasses = function (options) {
        return [
            'mafe-event-' + options.evn_type.toLowerCase() + '-' + options.evn_marker.toLowerCase() + '-16',
            'mafe-event-' + options.evn_type.toLowerCase() + '-' + options.evn_marker.toLowerCase() + '-24',
            'mafe-event-' + options.evn_type.toLowerCase() + '-' + options.evn_marker.toLowerCase() + '-33',
            'mafe-event-' + options.evn_type.toLowerCase() + '-' + options.evn_marker.toLowerCase() + '-41',
            'mafe-event-' + options.evn_type.toLowerCase() + '-' + options.evn_marker.toLowerCase() + '-49'
        ];
    };
    PMDesigner.updateGatewayLayerClasses = function (options) {
        return [
            'mafe-gateway-' + options.gat_type.toLowerCase() + '-20',
            'mafe-gateway-' + options.gat_type.toLowerCase() + '-30',
            'mafe-gateway-' + options.gat_type.toLowerCase() + '-41',
            'mafe-gateway-' + options.gat_type.toLowerCase() + '-51',
            'mafe-gateway-' + options.gat_type.toLowerCase() + '-61'
        ];
    };
    PMDesigner.updateMarkerLayerClasses = function (options) {
        if (options.act_task_type !== 'EMPTY') {
            return [
                "mafe-" + options.act_task_type.toLowerCase() + "-marker-10",
                "mafe-" + options.act_task_type.toLowerCase() + "-marker-15",
                "mafe-" + options.act_task_type.toLowerCase() + "-marker-21",
                "mafe-" + options.act_task_type.toLowerCase() + "-marker-26",
                "mafe-" + options.act_task_type.toLowerCase() + "-marker-31"
            ];
        }
    };
    PMDesigner.updateLoopLayerClasses = function (options) {
        if (options.act_loop_type !== 'EMPTY') {
            return [
                "mafe-" + options.act_loop_type.toLowerCase() + "-marker-10",
                "mafe-" + options.act_loop_type.toLowerCase() + "-marker-15",
                "mafe-" + options.act_loop_type.toLowerCase() + "-marker-21",
                "mafe-" + options.act_loop_type.toLowerCase() + "-marker-26",
                "mafe-" + options.act_loop_type.toLowerCase() + "-marker-31"
            ];
        }
    };
    PMDesigner.updateDataMarkerLayerClasses = function (options) {
        var type = options.dat_object_type.toLowerCase();
        if (type !== 'dataobject') {
            return [
                "mafe-" + type + "-marker-10",
                "mafe-" + type + "-marker-15",
                "mafe-" + type + "-marker-21",
                "mafe-" + type + "-marker-26",
                "mafe-" + type + "-marker-31"
            ];
        }
    };
    /**
     * Save a process and open the settings
     * @param shape
     * @param callback
     */
    PMDesigner.saveAndOpenSettings= function (shape, callback) {
        var splitedID;

        if(shape) {
            splitedID = shape.getID().split("-");
            if ((splitedID && splitedID[0] === 'pmui') || PMDesigner.project.isDirty()) {
                PMDesigner.restApi.execute({
                    data: JSON.stringify(PMDesigner.project.getDirtyObject()),
                    method: "update",
                    url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE + "/project/" + PMDesigner.project.id,
                    success: function (data, textStatus, xhr) {
                        PMDesigner.project.listeners.success(PMDesigner.project, textStatus, data);
                        PMDesigner.project.isSave = false;
                        if(callback) {
                            callback(shape);
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        PMDesigner.project.listeners.failure(that, textStatus, xhr);
                        PMDesigner.project.isSave = false;
                    }
                });
            } else {
                callback(shape);
            }
        }


    };
}());
PMDesigner.sidebar = [];

PMDesigner.sidebar.push(
    new ToolbarPanel({
        fields: [
            {
                selector: 'TASK',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-task'
                ],
                tooltip: "Task".translate()
            },
            {
                selector: 'SUB_PROCESS',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-subprocess'
                ],
                tooltip: "Sub Process".translate()
            }
        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'EXCLUSIVE',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-gateway-exclusive'
                ],
                tooltip: "Exclusive Gateway".translate()
            },
            {
                selector: 'PARALLEL',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-gateway-parallel'
                ],
                tooltip: "Parallel gateway".translate()
            },
            {
                selector: 'INCLUSIVE',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-gateway-inclusive'
                ],
                tooltip: "Inclusive Gateway".translate()
            }
        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'START',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-start'
                ],
                tooltip: "Start Event".translate()
            },
            {
                selector: 'START_TIMER',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-event-start-timer'
                ],
                tooltip: "Start Timer Event".translate()
            },
            {
                selector: 'INTERMEDIATE_EMAIL',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-intermediate-send-mesage'
                ],
                tooltip: "Intermediate Email Event".translate()
            },
            {
                selector: 'INTERMEDIATE_TIMER',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-event-intermediate-timer'
                ],
                tooltip: "Intermediate Timer Event".translate()
            },
            {
                selector: 'END',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-end'
                ],
                tooltip: "End Event".translate()
            },
            {
                selector: 'END_EMAIL',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-end-message'
                ],
                tooltip: "End Email Event ".translate()
            }
        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'DATAOBJECT',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-data-object'
                ],
                tooltip: "Data Object".translate()
            },
            {
                selector: 'DATASTORE',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-data-store'
                ],
                tooltip: "Data Store".translate()
            }
        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'PARTICIPANT',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-blackbox'
                ],
                tooltip: " Black Box Pool".translate()
            },
            {
                selector: 'POOL',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-pool'
                ],
                tooltip: "Pool".translate()
            },
            {
                selector: 'LANE',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-lane'
                ],
                tooltip: "Lane".translate()
            }
        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'GROUP',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-group'
                ],
                tooltip: "Group".translate()
            },
            {
                selector: 'TEXT_ANNOTATION',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-annotation'
                ],
                tooltip: "Text Annotation".translate()
            }
        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'LASSO',
                type: 'button',
                className: [
                    'mafe-designer-icon',
                    'mafe-toolbar-lasso'
                ],
                tooltip: "Lasso".translate()
            }

        ]
    }),
    new ToolbarPanel({
        fields: [
            {
                selector: 'enableAutosave',
                type: 'switch',
                className: [
                    'mafe-toolbar-autosave'
                ],
                tooltip: "Validate Now".translate(),
                checked: true,
                text: "Auto Save".translate(),
                checkHandler: function (value) {
                    PMDesigner.autoSaveValue(value);
                }
            }
        ]  
    })
);
ListDynaform = function () {
    this.superTitle = 'Dynaforms'.translate();
    this.tableContainerHeight = 374;
    this.buttonCreate = null;
    this.onCreate = new Function();
    this.onShowId = new Function();
    this.onEdit = new Function();
    this.onDel = new Function();
    this.loaded = false;
    this.clickedClose = true;
    Mafe.Grid.call(this);
    ListDynaform.prototype.init.call(this);
};
ListDynaform.prototype = new Mafe.Grid();
ListDynaform.prototype.init = function () {
    var that = this;
    that.buttonCreate = new PMUI.ui.Button({
        id: 'dynaformButtonNew',
        text: 'Create'.translate(),
        height: '36px',
        width: 100,
        style: {cssClasses: ['mafe-button-create']},
        handler: function (event) {
            that.onCreate(event);
        }
    });
    that.buttonCreate.defineEvents();
    that.setID('idListDynaform');
    that.setColumns([{
        id: 'copyuid',
        title: 'Show ID'.translate(),
        dataType: 'button',
        buttonLabel: 'Show ID'.translate(),
        buttonStyle: {cssClasses: ['mafe-button-show']},
        onButtonClick: function (row, grid) {
            that.onShowId(row, grid);
        }
    }, {
        id: 'dynaformGridPanelTitle',
        title: 'Title'.translate(),
        dataType: 'string',
        width: '460px',
        alignmentCell: 'left',
        sortable: true,
        columnData: 'dyn_title'
    }, {
        id: 'dynaformGridPanelEdit',
        title: '',
        dataType: 'button',
        buttonStyle: {cssClasses: ['mafe-button-edit']},
        buttonLabel: function (row, data) {
            return 'Edit'.translate();
        },
        onButtonClick: function (row, grid) {
            that.onEdit(row, grid);
        }
    }, {
        id: 'dynaformGridPanelDelete',
        title: '',
        dataType: 'button',
        buttonStyle: {cssClasses: ['mafe-button-delete']},
        buttonLabel: function (row, data) {
            return 'Delete'.translate();
        },
        onButtonClick: function (row, grid) {
            that.onDel(row, grid);
        }
    }
    ]);
};
ListDynaform.prototype.createHTML = function () {
    Mafe.Grid.prototype.createHTML.call(this);
    this.dom.toolbar.appendChild(this.buttonCreate.getHTML());
    return this.html;
};
ListDynaform.prototype.load = function () {
    var that = this;
    that.clearItems();
    (new PMRestClient({
        endpoint: 'dynaforms',
        typeRequest: 'get',
        functionSuccess: function (xhr, response) {
            that.setDataItems(response);
            that.sort('dyn_title', 'asc');
            that.loaded = true;
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);

            that.loaded = false;
        },
        messageError: 'There are problems getting the list of dynaforms, please try again.'.translate()
    })).executeRestClient();
};
ListDynaform.prototype.getSuperTitle = function () {
    return this.superTitle;
};

BlankDynaform = function () {
    this.superTitle = 'Create Blank Dynaform'.translate();
    this.onSave = new Function();
    this.onSaveOpen = new Function();
    this.onCancel = new Function();
    this.buttons = null;
    Mafe.Form.call(this);
    BlankDynaform.prototype.init.call(this);
};
BlankDynaform.prototype = new Mafe.Form();
BlankDynaform.prototype.init = function () {
    var that = this;
    that.setID('formDynaformInformation');
    that.setTitle('Dynaform Information'.translate());
    that.setItems([{
        id: 'formDynaformInformationTitle',
        pmType: 'text',
        label: 'Title'.translate(),
        value: '',
        maxLength: 255,
        placeholder: 'The Dynaform title'.translate(),
        name: 'dyn_title',
        required: true,
        controlsWidth: 303
    }, {
        id: 'formDynaformInformationDescription',
        pmType: 'textarea',
        rows: 200,
        name: 'dyn_description',
        width: 200,
        label: 'Description'.translate(),
        style: {cssClasses: ['mafe-textarea-resize']}
    }
    ]);
    that.buttons = [
        new PMUI.ui.Button({
            id: 'btnClose',
            text: 'Cancel'.translate(),
            buttonType: 'error',
            handler: function () {
                that.onCancel();
            }
        }),
        new PMUI.ui.Button({
            id: 'windowDynaformInformationSaveOpen',
            text: 'Save & Open'.translate(),
            buttonType: 'success',
            handler: function () {
                that.onSaveOpen();
            }
        }),
        new PMUI.ui.Button({
            id: 'windowDynaformInformationSave',
            text: 'Save'.translate(),
            buttonType: 'success',
            handler: function () {
                that.onSave();
            }
        })
    ];
};
BlankDynaform.prototype.getButtons = function () {
    return this.buttons;
};
BlankDynaform.prototype.getSuperTitle = function () {
    return this.superTitle;
};

Dynaform = function (settings) {
    this.listDynaform = null;
    this.blankDynaform = null;
    Mafe.Window.call(this, settings);
    Dynaform.prototype.init.call(this, settings);
};
Dynaform.prototype = new Mafe.Window();
Dynaform.prototype.init = function (settings) {
    var that = this;
    that.listDynaform = new ListDynaform();
    that.setOnBeforeCloseHandler(function () {
        this.clickedClose = true;
        if (!that.blankDynaform.isVisible()) {
            that.close();
        } else {
            that.blankDynaform.onCancel();
        }
    });
    that.listDynaform.load();
    that.listDynaform.onShowId = function (row, grid) {
        showUID(row.getData().dyn_uid);
    };
    that.listDynaform.onCreate = function () {
        that.resetView();
        that.setTitle(that.blankDynaform.getSuperTitle());
        that.blankDynaform.setVisible(true);
        that.setButtons(that.blankDynaform.getButtons());
    };
    that.listDynaform.onEdit = function (row, grid) {
        that.edit(row, grid);
    };
    that.listDynaform.onDel = function (row, grid) {
        that.del(row, grid);
    };

    that.blankDynaform = new BlankDynaform();
    that.blankDynaform.onSave = function () {
        that.saveBlank(false);
    };
    that.blankDynaform.onSaveOpen = function () {
        that.saveBlank(true);
    };
    that.blankDynaform.onCancel = function () {
        $("input,select,textarea").blur();
        var title = "";
        that.blankDynaform.loseChanges(title);
    };
    that.blankDynaform.onYesConfirmCancellation = function () {
        if (that.clickedClose) {
            that.close();
        }
        that.resetView();
        that.setTitle(that.listDynaform.getSuperTitle());
        that.listDynaform.setVisible(true);
    };

    that.addItem(that.listDynaform);
    that.addItem(that.blankDynaform);

    that.open();
    that.resetView();
    that.setTitle(that.listDynaform.getSuperTitle());
    that.listDynaform.setVisible(true);

    // hard coding dyn_title textfield because enter keypress reload the current page
    if (that.blankDynaform.getItems()[0]
        && that.blankDynaform.getItems()[0].controls[0]
        && that.blankDynaform.getItems()[0].controls[0].html) {
        $(that.blankDynaform.getItems()[0].controls[0].html).keypress(function (e) {
            if (e.which == 13) {
                e.preventDefault();
            }
        });
    }
};
Dynaform.prototype.saveBlank = function (open) {
    var that = this,
        data,
        restClient,
        flagAux;

    if (!that.blankDynaform.isValid()) {
        flagAux = that.blankDynaform.visible;
    } else {
        flagAux = that.blankDynaform.isValid();
    }

    if (flagAux) {
        if (getData2PMUI(that.blankDynaform.html).dyn_title == "") {
            return false;
        }
    }

    data = getData2PMUI(that.blankDynaform.html);
    data['dyn_version'] = 2;
    data['dyn_type'] = 'xmlform';
    restClient = new PMRestClient({
        endpoint: 'dynaform',
        typeRequest: 'post',
        data: data,
        functionSuccess: function (xhr, response) {
            if (open) {
                that.close();
                try {
                    PMUI.getActiveCanvas().emptyCurrentSelection();
                } catch (msg) {
                }
                PMDesigner.dynaformDesigner(response);
            } else {
                that.resetView();
                that.setTitle(that.listDynaform.getSuperTitle());
                that.listDynaform.setVisible(true);
                that.listDynaform.load();
            }
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        },
        messageError: 'There are problems creating the dynaform, please try again.'.translate(),
        messageSuccess: 'Dynaform saved successfully'.translate(),
        flashContainer: that.listDynaform
    });
    restClient.executeRestClient();
};
Dynaform.prototype.edit = function (row, grid) {
    this.close();
    try {
        PMUI.getActiveCanvas().emptyCurrentSelection();
    } catch (msg) {
    }
    PMDesigner.dynaformDesigner(row.getData());
};
Dynaform.prototype.del = function (row, grid) {
    var that = this,
        confirmDeletion = new Mafe.ConfirmDeletion();
    confirmDeletion.setMessage('Do you want to delete this DynaForm?'.translate());
    confirmDeletion.setTitle("Dynaform".translate());
    confirmDeletion.onDelete = function () {
        var restClient = new PMRestClient({
            endpoint: 'dynaform/' + row.getData().dyn_uid,
            typeRequest: 'remove',
            functionSuccess: function (xhr, response) {
                that.listDynaform.load();
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            },
            messageError: 'There are problems deleting the dynaform, please try again.'.translate(),
            messageSuccess: 'Dynaform deleted successfully'.translate(),
            flashContainer: that.listDynaform
        });
        restClient.executeRestClient();
    };
};

(function () {
    PMDesigner.dynaform = function () {
        var dynaform = new Dynaform();
    };
    PMDesigner.dynaform.create = function () {
        var dynaform = new Dynaform();
        dynaform.resetView();
        dynaform.setTitle(dynaform.blankDynaform.getSuperTitle());
        dynaform.blankDynaform.setVisible(true);
        dynaform.setButtons(dynaform.blankDynaform.getButtons());
    };
}());

/**
 * Updates the granular export feature after enabled features are loaded.
 */
var navbarExportUpdate = function () {
    //Code export - export granular (handler)
    var handlerExportNormal = function () {
        var ws = enviromentVariables('WORKSPACE');
        if (!HTTP_SERVER_HOSTNAME) {
            HTTP_SERVER_HOSTNAME = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '');
        }
        location.href = HTTP_SERVER_HOSTNAME + "/api/1.0/" + ws + "/project/" + PMDesigner.project.id + "/export?access_token=" + PMDesigner.project.keys.access_token;
    };

    var handlerExportGranular = function () {
        var optionExportNormal = $("<div class='mafe-button-submenu-option normalExport'>" + "Normal".translate() + "</div>"),
            optionExportGranular = $("<div class='mafe-button-submenu-option granularExport'>" + "Custom".translate() + "</div>"),
            menuExport = $("<div class='mafe-button-menu-container sub-nav'></div>").hide(),
            $item = $("#idNavBar").find(".mafe-button-export-process").closest("li");

        menuExport.append(optionExportNormal).append(optionExportGranular);
        if (!$item.find(".mafe-button-menu-container").length) {
            $item.append(menuExport);
        }
        $(".ui-tooltip").hide();
        $(menuExport).slideToggle("slow");
        $item.on("mouseleave", function (e) {
            if ($(this).find(".mafe-button-menu-container").eq(0).is(":visible")) {
                var that = this;
                $(that).find(".mafe-button-menu-container").remove();
            }
        });

        $(".sub-nav").on("click", ".normalExport", function (event) {
            var ws = enviromentVariables('WORKSPACE'),
                locationOrigin;
            if (!window.location.origin) {
                locationOrigin = window.location.protocol + "//" + window.location.hostname +
                    (window.location.port ? ':' + window.location.port : '');
            } else if (typeof HTTP_SERVER_HOSTNAME !== 'undefined') {
                locationOrigin = HTTP_SERVER_HOSTNAME;
            } else {
                locationOrigin = window.location.origin;
            }
            location.href = locationOrigin + "/api/1.0/" + ws + "/project/" + PMDesigner.project.id + "/export?access_token=" + PMDesigner.project.keys.access_token;
        });

        $(".sub-nav").on("click", ".granularExport", function (event) {
            PMDesigner.granularProcessExport();
        });
    };
    if (inArray("jXsSi94bkRUcVZyRStNVExlTXhEclVadGRRcG9xbjNvTWVFQUF3cklKQVBiVT0=", ENABLED_FEATURES)) {
        handler = handlerExportGranular;
    } else {
        handler = handlerExportNormal;
    }

};

function inArray(needle, haystack) {
    var i,
        length = haystack.length;
    for (i = 0; i < length; i += 1) {
        if (haystack[i] == needle) return true;
    }
    return false;
}

var defaultNavbarPanelMenus = {
    array: [],
    init: function () {
        var closeVar = {
                id: 'closeButton',
                name: 'Close',
                htmlProperty: {
                    id: 'closeButton',
                    element: 'li',
                    child: [
                        {
                            element: 'a',
                            class: 'mafe-close',
                            child: [
                                {
                                    element: 'span',
                                    class: 'mafe-button-close'
                                }
                            ]
                        }

                    ]
                },
                actions: {
                    selector: ".mafe-button-close",
                    tooltip: "Close".translate(),
                    execute: true,
                    handler: function () {
                        var message_window,
                            browser = PMDesigner.getBrowser(),
                            url = parent.location.href;

                        if (PMDesigner.project.isDirty() && !PMDesigner.project.isSave) {
                            var message_window = new PMUI.ui.MessageWindow({
                                windowMessageType: 'warning',
                                width: 490,
                                bodyHeight: 'auto',
                                id: "cancelSaveSubprocPropertiesWin",
                                title: PMDesigner.project.projectName,
                                message: 'Save your changes and exit ?'.translate(),
                                footerItems: [
                                    {
                                        pmType: 'label',
                                        text: ' '
                                    }, {
                                        text: "No".translate(),
                                        handler: function () {
                                            PMDesigner.project.isClose = true;
                                            if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
                                                window.close();
                                            } else {
                                                parent.location.href = url;
                                            }
                                        },
                                        buttonType: "error"
                                    },

                                    {
                                        text: "Yes".translate(),
                                        handler: function () {
                                            PMDesigner.project.saveClose(true);
                                        },
                                        buttonType: "success"
                                    }
                                ]
                            });
                            message_window.open();
                            message_window.showFooter();
                        } else {
                            if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
                                window.close();
                            } else {
                                parent.location.href = url;
                            }
                        }
                    }
                }
            },
            helpVar = {
                id: 'helpButton',
                name: 'Help',
                htmlProperty: {
                    id: 'helpButton',
                    element: 'li',
                    child: [
                        {
                            element: 'a',
                            class: 'mafe-help',
                            child: [
                                {
                                    element: 'span',
                                    class: 'mafe-toolbar-help'
                                }
                            ]
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-toolbar-help",
                    tooltip: "Help".translate(),
                    execute: true,
                    handler: function () {
                        var canvas = PMUI.getActiveCanvas();
                        PMDesigner.helper.startIntro();
                        if (canvas && canvas.getHTML()) {
                            canvas.getHTML().classList.remove("pmui-pmcanvas");
                        }
                    }
                }
            },
            saveVar = {
                id: 'saveButton',
                name: 'Save',
                htmlProperty: {
                    id: 'saveButton',
                    element: 'li',
                    class: 'mafe-save-process',
                    child: [
                        {
                            element: 'a',
                            class: 'mafe-button-save'
                        },
                        {
                            element: 'span',
                            class: 'mafe-button-menu',
                            child: [
                                {
                                    element: 'img',
                                    src: '/lib/img/caret-down.png'
                                }
                            ]
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-button-save",
                    tooltip: "Save process".translate(),
                    label: {
                        text: "Save".translate()
                    },
                    execute: true,
                    handler: function () {
                        if (PMDesigner.project.isDirty() && PMDesigner.project.isSave === false) {
                            PMDesigner.project.isSave = true;
                            document.getElementsByClassName("mafe-save-process")[0].childNodes[0].text = "Saving";
                            PMDesigner.project.save(true);
                        }
                    }
                }
            },
            exportButton = {
                id: 'exportButton',
                name: 'ExportButton',
                htmlProperty: {
                    id: 'exportButton',
                    element: 'li',
                    child: [
                        {
                            element: 'a',
                            class: 'mafe-button-export-process'
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-button-export-process",
                    tooltip: "Export process".translate(),
                    label: {
                        text: "Export Process".translate()
                    },
                    execute: true,
                    handler: function () {
                        handler();
                    }
                }
            },
            exportBpmnButton = {
                id: 'exportBpmnButton',
                name: 'ExportBpmn',
                htmlProperty: {
                    id: 'exportBpmnButton',
                    element: 'li',
                    child: [
                        {
                            element: 'a',
                            class: 'mafe-button-export-bpmn-process'
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-button-export-bpmn-process",
                    tooltip: "Export Diagram ".translate(),
                    label: {
                        text: "Export Diagram".translate()
                    },
                    execute: false,
                    handler: function () {
                    }
                }
            },
            zoomVar = {
                id: 'zoomOptions',
                name: 'Zoom',
                htmlProperty: {
                    id: 'zoomOptions',
                    element: 'li',
                    child: [
                        {
                            element: 'span',
                            class: 'mafe-zoom-options'
                        }
                    ]
                },
                actions: {
                    id: 'zoomOptions',
                    spanclass: 'mafe-zoom-options',
                    actions: 'zoom'
                },
                aditionalAction: {
                    execute: PMDesigner.ApplyOptionsZoom()
                }
            },
            undo = {
                id: 'undoButton',
                name: 'Undo',
                htmlProperty: {
                    id: 'undoButton',
                    element: 'li',
                    class: 'mafe-undo',
                    child: [
                        {
                            element: 'b',
                            class: 'mafe-action-undo',
                            child: [
                                {
                                    element: 'span',
                                    class: 'mafe-button-undo'
                                }
                            ]
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-action-undo",
                    tooltip: "Undo Action".translate(),
                    label: {
                        text: ''
                    },
                    execute: true,
                    handler: function () {
                        PMUI.getActiveCanvas().hideDragConnectHandlers();
                        PMUI.getActiveCanvas().commandStack.undo();
                    }
                }
            },
            redo = {
                id: 'redoButton',
                name: 'Redo',
                htmlProperty: {
                    id: 'redoButton',
                    element: 'li',
                    class: 'mafe-redo',
                    child: [
                        {
                            element: 'b',
                            class: 'mafe-action-redo',
                            child: [
                                {
                                    element: 'span',
                                    class: 'mafe-button-redo'
                                }
                            ]
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-action-redo",
                    tooltip: "Redo Action".translate(),
                    label: {
                        text: ''
                    },
                    execute: true,
                    handler: function () {
                        PMUI.getActiveCanvas().hideDragConnectHandlers();
                        PMUI.getActiveCanvas().commandStack.redo();
                    }
                }
            },
            fullScreen = {
                id: 'fullScreenButton',
                name: 'FullScreen',
                htmlProperty: {
                    id: 'fullScreenButton',
                    element: 'li',
                    child: [
                        {
                            element: 'a',
                            class: 'mafe-button-fullscreen'
                        }
                    ]
                },
                actions: {
                    selector: ".mafe-button-fullscreen",
                    tooltip: "Full Screen".translate(),
                    execute: true,
                    handler: function () {
                        PMDesigner.fullScreen.toggle(this);
                    }
                }
            };
        navbarExportUpdate();
        this.array = [
            closeVar,
            helpVar,
            saveVar,
            exportButton,
            exportBpmnButton,
            zoomVar,
            undo,
            redo,
            fullScreen
        ];
    },
    /**
     * Get Array of Items of the NavBarPanelMenu
     * @returns {Array}
     */
    getNavBarPanelMenu: function () {
        return this.array;
    },
    /**
     * Adds one Item To NavBarPanelMenu
     * @param item
     */
    addItemToNavBarPanelMenu: function (item) {
        this.array.push(item);
    }
};

defaultNavbarPanelMenus.init();

/**
 * @class PMUI.menu.navBarPanel
 * Handles the navbar panel of designer,
 * contains all menus for content elements.
 *
 * @param {array} items Default items
 * @constructor
 */
var NavbarPanel = function (items) {
    NavbarPanel.prototype.init.call(this, items);
};

/**
 * Initializes the object.
 *
 * @param {array} items Array with default values.
 */
NavbarPanel.prototype.init = function (items) {
    var item;
    if (typeof items === 'undefined') {
        items = defaultNavbarPanelMenus.getNavBarPanelMenu();
    }
    this.items = new PMUI.util.ArrayList();
    for (item in items) {
        if (!items.hasOwnProperty(item)) {
            continue;
        }
        this.items.insert(items[item]);
    }
};

/**
 * This method renders HTML and actions into designer
 *
 */
NavbarPanel.prototype.show = function () {
    var item = null,
        i,
        max;
    if (PMDesigner.navbarPanel.items instanceof Object) {
        for (i = 0, max = PMDesigner.navbarPanel.items.getSize(); i < max; i += 1) {
            item = PMDesigner.navbarPanel.items.get(i);
            if (typeof item.htmlProperty !== "undefined") {
                PMDesigner.navbarPanel.buildHtmlElement(item.htmlProperty);
            }
            if (typeof item.aditionalAction !== "undefined") {
                item.aditionalAction;
            }
            if (typeof item.actions !== "undefined") {
                new PMAction(item.actions);
            }
        }
    } else {
        throw new Error('cannot show the elements of the List');
    }

};

/**
 * This method creates a html element button into the navBar Panel
 * @param {Object} element
 * @param {HTMLElement} before
 */
NavbarPanel.prototype.buildHtmlElement = function (element, before) {
    var ul = document.getElementById('idNavBarList'),
        htmlElement;
    if ((typeof ul !== undefined) && (ul !== null)) {
        htmlElement = this.getNodeChild(element, ul);
        if (typeof before !== "undefined") {
            before = document.getElementById(before);
            ul.insertBefore(htmlElement, before);
        } else {
            ul.appendChild(htmlElement);
        }
    }

};

/**
 * This method assembling dependent html elements to the button
 * @param {Object} nodeChild
 * @param {HTMLElement} nodePattern
 * @returns {Element}
 */
NavbarPanel.prototype.getNodeChild = function (nodeChild, nodePattern) {
    var node = document.createElement(nodeChild.element),
        i;
    if (typeof nodeChild.id !== 'undefined') {
        node.setAttribute("id", nodeChild.id);
    }
    if (nodeChild.element === 'a') {
        node.setAttribute("href", "return;");
    }
    if (typeof(nodeChild.class) !== 'undefined') {
        node.setAttribute("class", nodeChild.class);
    }
    if (typeof(nodeChild.child) !== 'undefined' && nodeChild.child instanceof Array) {
        for (i = 0; i < nodeChild.child.length; i += 1) {
            this.getNodeChild(nodeChild.child[i], node);
        }
    }
    if (typeof(nodeChild.src) !== 'undefined') {
        node.setAttribute("src", nodeChild.src);
    }
    if ((typeof nodePattern !== undefined) && (nodePattern !== null) && nodePattern.localName !== 'ul') {
        nodePattern.appendChild(node);
    }
    return node;
};

/**
 * This method removes an html element for the
 * NavBar panel array List and delete the HTML from the designer.
 * @param {String} idButton
 */
NavbarPanel.prototype.deleteHtmlElement = function (idButton) {
    var btn = document.getElementById(idButton),
        element = PMDesigner.contentControl.items.find("id", idButton),
        remove = PMDesigner.contentControl.items.remove(element);
    if (typeof btn !== 'undefined' && remove === true) {
        btn.parentNode.removeChild(btn);
    } else {
        throw new Error('Cannot find the specified button: ' + idButton + '. Please, review this');
    }
};

/**
 * NavbarPanel get an instance
 * @type {NavbarPanel}
 */
PMDesigner.navbarPanel = new NavbarPanel(defaultNavbarPanelMenus.getNavBarPanelMenu());

function defaultContentControlMenus() {
    var variableCreate = {
            id: 'variableCreate',
            name: 'Variable',
            htmlProperty: {
                id: 'variableCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-variable'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-variable-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-variable",
                label: {
                    text: "Variables".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.variables();
                }
            },
            createAction: {
                selector: ".mafe-menu-variable-create",
                label: {
                    selector: ".mafe-menu-variable-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.variables.create();
                }
            }
        },
        messageType = {
            id: 'messageTypeCreate',
            name: 'MessageType',
            htmlProperty: {
                id: 'messageTypeCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-messagetype'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-messagetype-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-messagetype",
                label: {
                    text: "Message Types".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.messageType();
                }
            },
            createAction: {
                selector: ".mafe-menu-messagetype-create",
                label: {
                    selector: ".mafe-menu-messagetype-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.messageType.create();
                }
            }
        },
        dynaformCreate = {
            id: 'dynaformCreate',
            name: 'Dynaform',
            htmlProperty: {
                id: 'dynaformCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-dynaform'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-dynaform-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-dynaform",
                label: {
                    text: "Dynaforms".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.dynaform();
                }
            },
            createAction: {
                selector: ".mafe-menu-dynaform-create",
                label: {
                    selector: ".mafe-menu-dynaform-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.dynaform.create();
                }
            }
        },
        inputDocumentCreate = {
            id: 'inputDocumentCreate',
            name: 'InputDocument',
            htmlProperty: {
                id: 'inputDocumentCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-inputdocuments'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-inputdocuments-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-inputdocuments",
                label: {
                    text: "Input Documents".translate()
                },
                execute: true,
                handler: function () {
                    var inputDocument = new InputDocument();
                    inputDocument.build();
                }
            },
            createAction: {
                selector: ".mafe-menu-inputdocuments-create",
                label: {
                    selector: ".mafe-menu-inputdocuments-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    var inputDocument = new InputDocument();
                    inputDocument.build();
                    inputDocument.openFormInMainWindow();
                    inputDocument.method = "POST";
                }
            }
        },
        outputDocumentCreate = {
            id: 'outputDocumentCreate',
            name: 'OutputDocument',
            htmlProperty: {
                id: 'outputDocumentCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-outputdocuments'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-outputdocuments-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-outputdocuments",
                label: {
                    text: "Output Documents".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.output();
                }
            },
            createAction: {
                selector: ".mafe-menu-outputdocuments-create",
                label: {
                    selector: ".mafe-menu-outputdocuments-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.output();
                    PMDesigner.output.create();
                }
            }
        },
        triggerCreate = {
            id: 'triggerCreate',
            name: 'Trigger',
            htmlProperty: {
                id: 'triggerCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-triggers'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-triggers-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-triggers",
                label: {
                    text: "Triggers".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.trigger();
                }
            },
            createAction: {
                selector: ".mafe-menu-triggers-create",
                label: {
                    selector: ".mafe-menu-triggers-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.trigger();
                    PMDesigner.trigger.create();
                }
            }
        },
        reportTableCreate = {
            id: 'reportTableCreate',
            name: 'ReportTable',
            htmlProperty: {
                id: 'reportTableCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-reporttables'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-reporttables-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-reporttables",
                label: {
                    text: "Report Tables".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.reporttable();
                }
            },
            createAction: {
                selector: ".mafe-menu-reporttables-create",
                label: {
                    selector: ".mafe-menu-reporttables-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.reporttable();
                    PMDesigner.reporttable.create();
                }
            }
        },
        databaseCreate = {
            id: 'databaseCreate',
            name: 'Database',
            htmlProperty: {
                id: 'databaseCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-databaseconnections'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-databaseconnections-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-databaseconnections",
                label: {
                    text: "Database Connections".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.database();
                }
            },
            createAction: {
                selector: ".mafe-menu-databaseconnections-create",
                label: {
                    selector: ".mafe-menu-databaseconnections-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.database.create();
                }
            }
        },
        templateCreate = {
            id: 'templateCreate',
            name: 'TemplateCreate',
            htmlProperty: {
                id: 'templateCreate',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-templates'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-templates-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-templates",
                label: {
                    text: "Templates".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.ProcessFilesManager("templates", "CREATION_NORMAL");
                }
            },
            createAction: {
                selector: ".mafe-menu-templates-create",
                label: {
                    selector: ".mafe-menu-templates-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.ProcessFilesManager.createFirst("templates", "CREATION_MORE");
                }
            }
        },
        menuPublic = {
            id: 'menuPublic',
            name: 'MenuPublic',
            htmlProperty: {
                id: 'menuPublic',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-public'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-public-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-public",
                label: {
                    text: "Public Files".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.ProcessFilesManager("public", "CREATION_NORMAL");
                }
            },
            createAction: {
                selector: ".mafe-menu-public-create",
                label: {
                    selector: ".mafe-menu-public-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.ProcessFilesManager.createFirst("public", "CREATION_MORE");
                }
            }
        },
        menuPermission = {
            id: 'menuPermission',
            name: 'MenuPermission',
            htmlProperty: {
                id: 'menuPermission',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-permissions'
                    },
                    {
                        element: 'a',
                        class: 'btn_create mafe-menu-permissions-create',
                        child: [
                            {
                                element: 'span'
                            }
                        ]
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-permissions",
                label: {
                    text: "Permissions".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.processPermissions();
                }
            },
            createAction: {
                selector: ".mafe-menu-permissions-create",
                label: {
                    selector: ".mafe-menu-permissions-create span",
                    text: "Create".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.processPermissions.create();
                }
            }
        },
        menuCaseTracker = {
            id: 'menuCaseTracker',
            name: 'CaseTracker',
            htmlProperty: {
                id: 'menuCaseTracker',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-casetracker'
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-casetracker",
                label: {
                    text: "Case Tracker".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.caseTracker();
                }
            }
        },
        menuSupervisor = {
            id: 'menuSupervisor',
            name: 'MenuSupervisor',
            htmlProperty: {
                id: 'menuSupervisor',
                element: 'li',
                child: [
                    {
                        element: 'a',
                        class: 'mafe-menu-supervisors'
                    }
                ]
            },
            actions: {
                type: 'button',
                selector: ".mafe-menu-supervisors",
                label: {
                    text: "Supervisors".translate()
                },
                execute: true,
                handler: function () {
                    PMDesigner.assigmentSupervisors();
                }
            }
        };

    return [
        variableCreate,
        messageType,
        dynaformCreate,
        inputDocumentCreate,
        outputDocumentCreate,
        triggerCreate,
        reportTableCreate,
        databaseCreate,
        templateCreate,
        menuPublic,
        menuPermission,
        menuCaseTracker,
        menuSupervisor
    ];
};

/**
 * @class PMUI.menu.contentControl
 * Handles the content control menu of designer,
 * contains all menus for content elements.
 *
 * @param {array} items Default items
 * @constructor
 */
var ContentControl = function (items) {
    ContentControl.prototype.init.call(this, items);
};

/**
 * Initializes the object.
 *
 * @param {array} items Array with default values.
 */
ContentControl.prototype.init = function (items) {
    this.items = new PMUI.util.ArrayList();
    if (typeof items === 'undefined') {
        items = defaultContentControlMenus();
    }
    for (var item in items) {
        if (!items.hasOwnProperty(item)) {
            continue;
        }
        this.items.insert(items[item]);
    }
};

/**
 * This method renders HTML and actions into designer
 *
 */
ContentControl.prototype.show = function () {
    var item = null,
        i,
        max;
    if (this.items instanceof Object) {
        for (i = 0, max = this.items.getSize(); i < max; i += 1) {
            item = this.items.get(i);
            if (typeof item.htmlProperty !== "undefined") {
                this.buildHtmlElement(item.htmlProperty);
            }
            if (typeof item.actions !== "undefined") {
                new PMAction(item.actions);
            }
            if (typeof item.createAction !== "undefined") {
                new PMAction(item.createAction);
            }
        }
    } else {
        throw new Error('Cannot show the elements of the List');
    }
};

/**
 * This method creates a html element button into the content
 * control panel.
 * @param {Object} element
 * @param {HTMLElement} before
 */
ContentControl.prototype.buildHtmlElement = function (element, before) {
    var ul = document.getElementById('contentControlList'),
        htmlElement;
    if ((typeof ul !== undefined) && (ul !== null)) {
        htmlElement = this.getNodeChild(element, ul);
        if (typeof before !== "undefined") {
            before = document.getElementById(before);
            ul.insertBefore(htmlElement, before);
        } else {
            ul.appendChild(htmlElement);
        }
    }

};

/**
 * This method assembling dependent html elements to the button
 * @param {Object} nodeChild
 * @param {HTMLElement} nodePattern
 * @returns {Element}
 */
ContentControl.prototype.getNodeChild = function (nodeChild, nodePattern) {
    var node = document.createElement(nodeChild.element),
        i;
    if (typeof nodeChild.id !== 'undefined') {
        node.setAttribute("id", nodeChild.id);
    }
    if (nodeChild.element === 'a') {
        node.setAttribute("href", "#");
    }
    if (typeof(nodeChild.class) !== 'undefined') {
        node.setAttribute("class", nodeChild.class);
    }
    if (typeof(nodeChild.child) !== 'undefined' && nodeChild.child instanceof Array) {
        for (i = 0; i < nodeChild.child.length; i += 1) {
            this.getNodeChild(nodeChild.child[i], node);
        }
    }
    if (typeof(nodeChild.src) !== 'undefined') {
        node.setAttribute("src", nodeChild.src);
    }
    if ((typeof nodePattern !== undefined) && (nodePattern !== null) && nodePattern.localName !== 'ul') {
        nodePattern.appendChild(node);
    }
    return node;
};

/**
 * This method removes an html element for the
 * Content Control panel array List and delete the HTML from the designer.
 * @param {String} idButton
 */
ContentControl.prototype.deleteHtmlElement = function (idButton) {
    var btn = document.getElementById(idButton),
        element = this.items.find("id", idButton),
        remove = this.items.remove(element);
    if (typeof btn !== 'undefined' && remove === true) {
        btn.parentNode.removeChild(btn);
    } else {
        throw new Error('Cannot find the specified button: ' + idButton + '. Please, review this');
    }
};

/**
 * ContentControl get an instance
 * @type {ContentControl}
 */
PMDesigner.contentControl = new ContentControl(defaultContentControlMenus());

/**
 * Input Document module
 * @param options
 * @constructor
 */
var InputDocument = function (options) {
    this.winMainInputDocument = null;
    this.externalType = false;
    this.inputDocumentOriginDataForUpdate = {};
    this.windowDialog = null;
    this.assignAccordion = null;
    this.clickedClose = true;
    this.onUpdateInputDocumentHandler = null;
    InputDocument.prototype.init.call(this, options);
};
/**
 * set close modulo InputDocument constructor
 * @param handler, the callback function
 */
InputDocument.prototype.setOnUpdateInputDocumentHandler = function (handler) {
    if (typeof handler === "function") {
        this.onUpdateInputDocumentHandler = handler;
    }
    return this;
};
/**
 * constructor
 * @param options
 */
InputDocument.prototype.init = function (options) {
    var defaults = {
        onUpdateInputDocumentHandler: null
    };
    $.extend(true, defaults, options);
    this.setOnUpdateInputDocumentHandler(defaults.onUpdateInputDocumentHandler);
    return this;
};

/**
 * Puts input document using rest proxy, to update data
 * @param inputDocumentUid
 * @param data
 */
InputDocument.prototype.inputDocumentPutRestProxy = function (inputDocumentUid, data) {
    var that = this,
        restProxy;

    restProxy = new PMRestClient({
        endpoint: "input-document/" + inputDocumentUid,
        typeRequest: 'update',
        data: data,
        functionSuccess: function (xhr, response) {
            var message;
            if (!that.externalType) {
                if (typeof flagInputDocument != 'undefined' && flagInputDocument) {
                    that.winMainInputDocument.close();
                    return;
                }
                that.inputDocumentsGetRestProxy();
                that.openGridPanelInMainWindow();
            } else {
                that.winMainInputDocument.close();
                message = new PMUI.ui.FlashMessage({
                    message: 'Input Document edited correctly.'.translate(),
                    duration: 3000,
                    severity: 'success',
                    appendTo: that.windowDialog
                });
                message.show();
            }
            if (typeof that.onUpdateInputDocumentHandler === "function") {
                that.onUpdateInputDocumentHandler(data, that);
            }
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        },
        messageSuccess: 'Input Document updated successfully'.translate(),
        flashContainer: that.grdpnlInputDocument
    });
    restProxy.executeRestClient();
};
/**
 * Deletes an input document
 * @param inputDocumentUid
 */
InputDocument.prototype.inputDocumentDeleteRestProxy = function (inputDocumentUid) {
    var that = this,
        restProxy;
    restProxy = new PMRestClient({
        endpoint: "input-document/" + inputDocumentUid,
        typeRequest: 'remove',
        functionSuccess: function (xhr, response) {
            that.inputDocumentsGetRestProxy();
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        },
        messageSuccess: 'Input Document deleted successfully'.translate(),
        flashContainer: that.grdpnlInputDocument
    });
    restProxy.executeRestClient();
};
/**
 * Creates an input document using rest proxy
 * @param data
 */
InputDocument.prototype.inputDocumentPostRestProxy = function (data) {
    var that = this,
        restProxy;
    restProxy = new PMRestClient({
        endpoint: "input-document",
        typeRequest: 'post',
        data: data,
        functionSuccess: function (xhr, response) {
            that.inputDocumentsGetRestProxy();
            that.openGridPanelInMainWindow();
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        },
        messageSuccess: 'Input Document saved successfully'.translate(),
        flashContainer: that.grdpnlInputDocument
    });
    restProxy.executeRestClient();
};
/**
 * Gets all input documents to populate the grid
 */
InputDocument.prototype.inputDocumentsGetRestProxy = function () {
    var that = this,
        restProxy = new PMRestClient({
            endpoint: 'input-documents',
            typeRequest: 'get',
            functionSuccess: function (xhr, response) {
                that.grdpnlInputDocument.setDataItems(response);
                that.grdpnlInputDocument.sort('inp_doc_title', 'asc');
                if (PMVariables.prototype.isWindowActive()) {
                    PMVariables.prototype.setInputDocumentsFromIDModule(PMUI.getPMUIObject(inp_doc_uid), response);
                }
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });
    restProxy.executeRestClient();
};
/**
 * Gets an specific input document data to edit it
 * @param inputDocumentUid
 */
InputDocument.prototype.inputDocumentFormGetProxy = function (inputDocumentUid) {
    var that = this,
        restProxy;
    restProxy = new PMRestClient({
        endpoint: "input-document/" + inputDocumentUid,
        typeRequest: 'get',
        functionSuccess: function (xhr, response) {
            var data = response;
            that.method = "PUT";
            that.openFormForEditInMainWindow(data);
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        }
    });
    restProxy.executeRestClient();
};

/**
 * Open Edit form and sets to main windows
 * @param inputDocumentData
 */
InputDocument.prototype.openFormForEditInMainWindow = function (inputDocumentData) {
    var that = this;

    that.inputDocumentOriginDataForUpdate = inputDocumentData;
    that.inputDocumentUid = inputDocumentData.inp_doc_uid;
    that.frmInputDocument.getField('inp_doc_original').setValue("");
    that.winMainInputDocument.setTitle("Edit Input Document".translate());

    that.frmInputDocument.getField('inp_doc_title').setValue(inputDocumentData.inp_doc_title);
    that.frmInputDocument.getField('inp_doc_description').setValue(inputDocumentData.inp_doc_description);
    that.frmInputDocument.getField('inp_doc_form_needed').setValue(inputDocumentData.inp_doc_form_needed);
    that.frmInputDocument.getField('inp_doc_original').setValue(inputDocumentData.inp_doc_original);

    if (inputDocumentData.inp_doc_form_needed !== "VIRTUAL") {
        that.frmInputDocument.getField('inp_doc_original').setVisible(true);
    } else {
        that.frmInputDocument.getField('inp_doc_original').setVisible(false);
    }
    that.frmInputDocument.getField('inp_doc_versioning').setValue(parseInt(inputDocumentData.inp_doc_versioning + ""));
    that.frmInputDocument.getField('inp_doc_destination_path').setValue(inputDocumentData.inp_doc_destination_path);
    that.frmInputDocument.getField('inp_doc_tags').setValue(inputDocumentData.inp_doc_tags);
    that.frmInputDocument.getField('inp_doc_type_file').setValue(inputDocumentData.inp_doc_type_file);
    that.frmInputDocument.getField('inp_doc_max_filesize').setValue(inputDocumentData.inp_doc_max_filesize);
    that.frmInputDocument.getField('inp_doc_max_filesize_unit').setValue(inputDocumentData.inp_doc_max_filesize_unit);
};
/**
 * Open the grid panel and sets to mai windows
 */
InputDocument.prototype.openGridPanelInMainWindow = function () {
    this.grdpnlInputDocument.setVisible(true);
    this.frmInputDocument.setVisible(false);
    this.winMainInputDocument.setTitle("Input Documents".translate());
    this.winMainInputDocument.hideFooter();
};
/**
 * Set the option external type of input Document
 */
InputDocument.prototype.setExternalType = function (value) {
    if (typeof value === "boolean") {
        this.externalType = value;
    }
    return this;
};
/**
 * Set the option window Dialog, a window that open this class
 */
InputDocument.prototype.setWindowDialog = function (value) {
    this.windowDialog = value;
    return this;
};

InputDocument.prototype.setAssignAccordion = function (obj) {
    this.assignAccordion = obj;
};

/**
 * Open create form an sets to main windows
 */
InputDocument.prototype.openFormInMainWindow = function () {
    this.grdpnlInputDocument.setVisible(false);
    this.frmInputDocument.setVisible(true);
    this.winMainInputDocument.setTitle("Create Input Document".translate());
    this.winMainInputDocument.showFooter();
};

InputDocument.prototype.checkIfValuesAreEqual = function (initialData, finalData) {
    var key1, key2;
    if (!Object.keys(initialData).length && Object.keys(finalData).length) {
        if (finalData['inp_doc_title'] != '' || finalData['inp_doc_form_needed'] != 'VIRTUAL' || finalData['inp_doc_description'] != '' || finalData['inp_doc_versioning'] != '0' || finalData['inp_doc_destination_path'] != '') {
            return false;
        }
    }

    for (key1 in initialData) {
        for (key2 in finalData) {
            if (typeof(initialData[key1]) != "undefined" &&
                typeof(finalData[key2]) != "undefined" &&
                key1 == key2 &&
                initialData[key1] != finalData[key2]
            ) {
                //Return
                return false;
            }
        }
    }
    return true;
};

/**
 * Generate all ui components(window, form, grid, fields)
 */

InputDocument.prototype.isDirtyFormInput = function () {
    $("input,select,textarea").blur();
    var that = this, message_window;
    if (this.frmInputDocument.isVisible()) {
        if (!this.externalType) {
            if (!(this.checkIfValuesAreEqual(this.inputDocumentOriginDataForUpdate, getData2PMUI(this.frmInputDocument.html)))) {
                message_window = new PMUI.ui.MessageWindow({
                    id: "cancelMessageTriggers",
                    width: 490,
                    title: "Input Documents".translate(),
                    windowMessageType: 'warning',
                    bodyHeight: 'auto',
                    message: 'Are you sure you want to discard your changes?'.translate(),
                    footerItems: [
                        {
                            text: 'No'.translate(),
                            handler: function () {
                                message_window.close();
                            },
                            buttonType: "error"
                        }, {
                            text: 'Yes'.translate(),
                            handler: function () {
                                message_window.close();
                                if (typeof flagInputDocument != 'undefined' && flagInputDocument) {
                                    if (that.clickedClose) {
                                        message_window.close();
                                        that.winMainInputDocument.close();
                                        return;
                                    } else {
                                        that.winMainInputDocument.close();
                                        flagInputDocument = false;
                                    }
                                    return;
                                } else {
                                    if (that.clickedClose) {
                                        message_window.close();
                                        that.winMainInputDocument.close();
                                        return;
                                    } else {
                                        inputDocumentOption = "";
                                        that.openGridPanelInMainWindow();
                                    }
                                }
                            },
                            buttonType: "success"
                        }
                    ]
                });
                message_window.open();
                message_window.showFooter();
                this.inputDocumentOriginDataForUpdate = {};
            } else {
                if (that.clickedClose) {
                    this.winMainInputDocument.close();
                } else {
                    inputDocumentOption = "";
                    this.openGridPanelInMainWindow();
                }
            }
        } else {
            that.winMainInputDocument.close();
        }
    } else {
        that.winMainInputDocument.close();
    }
};

InputDocument.prototype.build = function () {
    var ID = this,
        btnSave,
        btnCancel,
        winMainInputDocument,
        frmInputDocument,
        grdpnlInputDocument,
        btnNew,
        inp_doc_destination_path,
        inp_doc_tags,
        that = this;

    btnSave = new PMUI.ui.Button({
        id: "btnSave",
        text: "Save".translate(),
        handler: function () {
            var flagAux, data;

            if (!ID.frmInputDocument.isValid()) {
                flagAux = ID.frmInputDocument.visible;
            } else {
                flagAux = ID.frmInputDocument.isValid();
            }

            if (flagAux) {
                if (getData2PMUI(ID.frmInputDocument.html).inp_doc_title == "") {
                    return false;
                }
            }

            if (ID.frmInputDocument.getField("inp_doc_max_filesize").getValue() != "") {
                if (!/^\+?(0|[1-9]\d*)$/.test(ID.frmInputDocument.getField("inp_doc_max_filesize").getValue())) {
                    return false;
                }
            }

            //validation because getData method do not work in IE
            if (navigator.userAgent.indexOf("MSIE") !== -1 || navigator.userAgent.indexOf("Trident") !== -1) {
                data = getData2PMUI(that.frmInputDocument.html);
            } else {
                data = that.frmInputDocument.getData();
            }

            data["inp_doc_versioning"] = parseInt(data["inp_doc_versioning"]);

            switch (that.method) {
                case "POST":
                    that.inputDocumentPostRestProxy(data);
                    break;
                case "PUT":
                    that.inputDocumentPutRestProxy(that.inputDocumentUid, data);
                    break;
            }
        },
        buttonType: 'success'
    });

    btnCancel = new PMUI.ui.Button({
        id: "btnCancel",
        text: "Cancel".translate(),
        handler: function () {
            that.clickedClose = false;
            that.isDirtyFormInput();
        },
        buttonType: 'error'
    });
    btnNew = new PMUI.ui.Button({
        id: "btnNew",
        text: "Create".translate(),
        height: "36px",
        width: 100,
        style: {
            cssClasses: [
                'mafe-button-create'
            ]
        },
        handler: function () {
            that.openFormInMainWindow();
            that.method = "POST";
            that.frmInputDocument.reset();
        }
    });

    /* form panel*/
    this.frmInputDocument = new PMUI.form.Form({
        id: "frmInputDocument",
        width: 900,
        visibleHeader: false,
        items: [
            {
                pmType: "text",
                label: "Title".translate(),
                id: "inputDocTitle",
                name: "inp_doc_title",
                valueType: 'string',
                maxLength: 200,
                required: true,
                controlsWidth: 300
            },
            {
                pmType: "dropdown",
                name: "inp_doc_form_needed",
                id: "inputDocDocumentType",
                label: "Document Type".translate(),
                value: "VIRTUAL",
                controlsWidth: 130,
                options: [
                    {
                        value: "VIRTUAL",
                        label: "Digital".translate()
                    },
                    {
                        value: "REAL",
                        label: "Printed".translate()
                    },
                    {
                        value: "VREAL",
                        label: "Digital/Printed".translate()
                    }
                ],
                onChange: function (newValue, prevValue) {
                    var fields = that.frmInputDocument.getFields();
                    if (newValue != "VIRTUAL") {
                        fields[2].setVisible(true);
                    } else {
                        fields[2].setVisible(false);
                    }
                }
            },
            {
                pmType: "dropdown",
                id: "inputDocDocumentType",
                name: "inp_doc_original",
                label: "Format".translate(),
                value: "ORIGINAL",
                controlsWidth: 105,
                visible: false,
                options: [
                    {
                        value: "ORIGINAL",
                        label: "Original".translate()
                    },
                    {
                        value: "COPYLEGAL",
                        label: "Legal Copy".translate()
                    },
                    {
                        value: "COPY",
                        label: "Copy".translate()
                    }
                ]
            },
            {
                pmType: "textarea",
                id: "inputDocDescription",
                name: "inp_doc_description",
                label: "Description".translate(),
                controlsWidth: 380,
                rows: 100,
                style: {cssClasses: ['mafe-textarea-resize']}
            },
            {
                pmType: "dropdown",
                id: "inputDocEnableVersioning",
                name: "inp_doc_versioning",
                label: "Enable Versioning".translate(),
                value: 0,
                controlsWidth: 75,
                options: [
                    {
                        value: 0,
                        label: "NO".translate(),
                        selected: true
                    },
                    {
                        value: 1,
                        label: "YES".translate()
                    }
                ]
            }
        ],
        buttonPanelPosition: 'top'
    });
    inp_doc_destination_path = new CriteriaField({
        id: "inputDocDestinationPath",
        name: "inp_doc_destination_path",
        valueType: "string",
        label: "Destination Path".translate(),
        maxLength: 200,
        controlsWidth: 380
    });

    inp_doc_tags = new CriteriaField({
        id: "inputDocTags",
        name: "inp_doc_tags",
        valueType: "string",
        label: "Tags".translate(),
        maxLength: 200,
        value: "INPUT",
        controlsWidth: 380
    });

    inp_doc_allowed = new PMUI.field.TextField({
        label: "Allowed file extensions (Use .* to allow any extension)".translate(),
        id: "inputDocAllowedFileExtensions",
        name: "inp_doc_type_file",
        valueType: 'string',
        maxLength: 200,
        required: true,
        value: ".*",
        controlsWidth: 380

    });

    inp_doc_maximum = new PMUI.field.TextField({
        label: "Maximum file size (Use zero if unlimited)".translate(),
        id: "inputDocMaximumFileSize",
        name: "inp_doc_max_filesize",
        valueType: 'string',
        maxLength: 200,
        required: true,
        value: "0",
        controlsWidth: 380,
        validators: [
            {
                pmType: "regexp",
                criteria: /^\d*$/,
                errorMessage: "Please enter a positive integer value".translate()
            }
        ]

    });

    inp_doc_maximum_unit = new PMUI.field.DropDownListField({
        id: "inputDocUnit",
        name: "inp_doc_max_filesize_unit",
        label: "Unit".translate(),
        value: "ORIGINAL",
        controlsWidth: 105,
        visible: true,
        options: [
            {
                value: "KB",
                label: "KB".translate()
            },
            {
                value: "MB",
                label: "MB".translate()
            }
        ]
    });

    that.frmInputDocument.addItem(inp_doc_destination_path);
    that.frmInputDocument.addItem(inp_doc_tags);
    that.frmInputDocument.addItem(inp_doc_allowed);
    that.frmInputDocument.addItem(inp_doc_maximum);
    that.frmInputDocument.addItem(inp_doc_maximum_unit);

    /*grid panel*/

    this.grdpnlInputDocument = new PMUI.grid.GridPanel({
        id: "grdpnlInputDocument",
        pageSize: 10,
        width: "96%",
        style: {
            cssClasses: ["mafe-gridPanel"]
        },
        filterPlaceholder: 'Search ...'.translate(),
        emptyMessage: 'No records found'.translate(),
        nextLabel: 'Next'.translate(),
        previousLabel: 'Previous'.translate(),
        tableContainerHeight: 374,
        customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
            return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
        },
        columns: [
            {
                id: 'grdpnlInputDocumentButtonShow',
                dataType: "button",
                title: "",
                buttonLabel: "Show ID".translate(),
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-show'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var data = row.getData();
                    showUID(data.inp_doc_uid);
                }
            },
            {
                columnData: "inp_doc_title",
                title: "Title".translate(),
                width: "607px",
                alignment: "left",
                sortable: true,
                alignmentCell: 'left'
            },
            {
                id: 'grdpnlInputDocumentButtonEdit',
                dataType: "button",
                title: "",
                buttonLabel: "Edit".translate(),
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-edit'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var data = row.getData();
                    that.inputDocumentOriginDataForUpdate = {};
                    that.openFormInMainWindow();
                    that.inputDocumentFormGetProxy(data.inp_doc_uid);

                }
            },
            {
                id: 'grdpnlInputDocumentButtonDelete',
                dataType: "button",
                title: "",
                buttonLabel: "Delete".translate(),
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-delete'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var data = row.getData(),
                        confirmWindow;
                    confirmWindow = new PMUI.ui.MessageWindow({
                        id: "inputMessageWindowWarning",
                        windowMessageType: 'warning',
                        width: 490,
                        bodyHeight: 'auto',
                        title: "Input Documents".translate(),
                        message: "Do you want to delete this Input Document?".translate(),
                        footerItems: [
                            {
                                id: 'confirmWindowButtonNo',
                                text: "No".translate(),
                                visible: true,
                                handler: function () {
                                    confirmWindow.close();
                                },
                                buttonType: "error"
                            },
                            {
                                id: 'confirmWindowButtonYes',
                                text: "Yes".translate(),
                                visible: true,
                                handler: function () {
                                    that.inputDocumentDeleteRestProxy(data.inp_doc_uid);
                                    confirmWindow.close();
                                    confirmWindow.close();
                                },
                                buttonType: "success"
                            }
                        ]
                    });
                    confirmWindow.open();
                    confirmWindow.dom.titleContainer.style.height = "17px";
                    confirmWindow.showFooter();
                }
            }
        ],
        dataItems: null
    });
    /* main windows */
    this.winMainInputDocument = new PMUI.ui.Window({
        id: "winMainInputDocument",
        title: "Input Documents".translate(),
        height: DEFAULT_WINDOW_HEIGHT,
        width: DEFAULT_WINDOW_WIDTH,
        buttonPanelPosition: 'bottom',
        footerAlign: 'right',
        visibleFooter: true,
        footerItems: [
            btnCancel,
            btnSave
        ],
        onBeforeClose: function () {
            that.clickedClose = true;
            that.isDirtyFormInput();
        }
    });
    // add form and grid to windows
    this.winMainInputDocument.addItem(this.grdpnlInputDocument);
    this.winMainInputDocument.addItem(this.frmInputDocument);
    this.winMainInputDocument.open();
    //custom css
    this.frmInputDocument.getField("inp_doc_type_file").html.style.padding = "6px 0";
    this.frmInputDocument.getField("inp_doc_type_file").html.style.float = "left";
    this.frmInputDocument.getField("inp_doc_max_filesize").html.style.padding = "6px 0";
    this.frmInputDocument.getField("inp_doc_max_filesize").html.style.float = "left";
    this.frmInputDocument.getField("inp_doc_max_filesize_unit").html.style.padding = "6px 0";
    this.frmInputDocument.getField("inp_doc_max_filesize_unit").html.style.float = "left";
    this.grdpnlInputDocument.setVisible(true);
    this.frmInputDocument.setVisible(false);
    this.winMainInputDocument.hideFooter();
    /* insert create button to grid*/
    this.grdpnlInputDocument.dom.toolbar.appendChild(btnNew.getHTML());
    btnNew.defineEvents();
    this.inputDocumentsGetRestProxy();
};

(function () {

    var loadValuesStartTimer, openForm, updateStatus;

    PMDesigner.startTimer = function (element) {

        var startTimer = element,
            restClient,
            loadServerData,
            listUsers,
            itemsDaly,
            itemsWeekly,
            loadOptionsRadio,
            itemsMonthly,
            itemsOneTime,
            itemsEvery,
            showProperties,
            updateCaseScheduler,
            buttonCancel,
            loadUsers,
            loadDataForm,
            formCreateCaseScheduler,
            schedulerListWindow,
            buttonSave,
            dataForm;

        loadValuesStartTimer = function ($flag) {
            listUsers = [];
            dataForm = [];
            restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: 'activity/' + startTimer.ports.get(0).connection.flo_element_dest + '/assignee/all',
                            method: 'GET'
                        },
                        {
                            url: 'case-scheduler/' + startTimer.evn_uid,
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    listUsers = response[0].response;
                    dataForm = response[1].response;
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: [null, 'There are problems loading the Start Timer, please try again.'.translate()]
            });
            restClient.executeRestClient();
            if ($flag) {
                return listUsers.length;
            }
            return true;
        };

        updateCaseScheduler = function (data) {
            var restProxy = new PMRestClient({
                endpoint: 'case-scheduler/' + startTimer.evn_uid,
                typeRequest: 'update',
                data: data,
                functionSuccess: function (xhr, response) {
                    formCreateCaseScheduler.reset();
                    schedulerListWindow.close();
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageSuccess: 'Start Timer updated successfully'.translate(),
                messageError: 'There are problems updating the Start Timer, please try again.'.translate(),
                flashContainer: document.body
            });
            restProxy.executeRestClient();
        };

        updateStatus = function () {
            var status = (typeof dataForm.sch_state !== 'undefined') ? ((dataForm.sch_state === 'ACTIVE') ? 'INACTIVE' : 'ACTIVE') : 'INACTIVE';
            dataForm.sch_state = status;
            updateCaseScheduler(dataForm);
        };

        //Items for the form Create and edit Case Scheduler
        itemsDaly = [
            {
                pmType: 'panel',
                layout: 'hbox',
                items: [
                    {
                        id: 'startDate',
                        pmType: 'datetime',
                        label: 'Start date'.translate(),
                        value: '',
                        returnFormat: 'yy-mm-dd',
                        required: true,
                        dateFormat: 'yy mm dd',
                        dateTime: false,
                        name: 'startDate',
                        valueType: 'date',
                        labelWidth: '26%'
                    },
                    {
                        id: 'endDate',
                        pmType: 'datetime',
                        label: 'End date'.translate(),
                        value: '',
                        returnFormat: 'yy-mm-dd',
                        required: false,
                        dateFormat: 'yy mm dd',
                        dateTime: false,
                        name: 'endDate',
                        valueType: 'date'
                    }
                ]
            },
            {
                id: 'execttime',
                pmType: 'text',
                label: 'Execution time'.translate(),
                value: '',
                required: true,
                name: 'execttime',
                placeholder: '(HH:MM) Format 24 hrs.'.translate(),
                valueType: 'string',
                validators: [{
                    pmType: 'regexp',
                    criteria: /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/,
                    errorMessage: 'Please enter a valid hour.'.translate()
                }
                ],
                helper: 'Example: 1:00, 14:30, 00:00'
            }
        ];

        itemsWeekly = [
            {
                pmType: 'panel',
                layout: 'hbox',
                items: [
                    {
                        id: 'startDate',
                        pmType: 'datetime',
                        label: 'Start date'.translate(),
                        value: '',
                        returnFormat: 'yy-mm-dd',
                        required: true,
                        dateFormat: 'yy mm dd',
                        dateTime: false,
                        name: 'startDate',
                        valueType: 'date',
                        labelWidth: '26%'
                    },
                    {
                        id: 'endDate',
                        pmType: 'datetime',
                        label: 'End date'.translate(),
                        value: '',
                        returnFormat: 'yy-mm-dd',
                        required: false,
                        dateFormat: 'yy mm dd',
                        dateTime: false,
                        name: 'endDate',
                        valueType: 'date'
                    }
                ]
            },
            {
                id: 'execttime',
                pmType: 'text',
                label: 'Execution time'.translate(),
                value: '',
                required: true,
                name: 'execttime',
                placeholder: '(HH:MM) Format 24 hrs.'.translate(),
                valueType: 'string',
                validators: [{
                    pmType: 'regexp',
                    criteria: /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/,
                    errorMessage: 'Please enter a valid hour.'.translate()
                }
                ],
                helper: 'Example: 1:00, 14:30, 00:00'
            },
            {
                id: 'daysoftheweek',
                pmType: 'checkbox',
                label: 'Select the day(s) of the week below'.translate(),
                value: '',
                name: 'daysoftheweek',
                required: false,
                controlPositioning: 'horizontal',
                maxDirectionOptions: 3,
                options: [
                    {
                        id: 'monday',
                        label: 'Monday'.translate(),
                        value: '1'
                    },
                    {
                        id: 'tuesday',
                        label: 'Tuesday'.translate(),
                        value: '2'
                    },
                    {
                        id: 'wednesday',
                        label: 'Wednesday'.translate(),
                        value: '3'
                    },
                    {
                        id: 'thursday',
                        label: 'Thursday'.translate(),
                        value: '4'
                    },
                    {
                        id: 'friday',
                        label: 'Friday'.translate(),
                        value: '5'
                    },
                    {
                        id: 'saturday',
                        label: 'Saturday'.translate(),
                        value: '6'
                    },
                    {
                        id: 'sunday',
                        label: 'Sunday'.translate(),
                        value: '7'
                    }
                ]
            }
        ];

        loadOptionsRadio = function (newVal) {
            var paneldaysofMonth = formCreateCaseScheduler.getItems()[1].getItems()[2].getItems()[1];
            paneldaysofMonth.setVisible(true);
            if (newVal === 'dayofmonth') {
                paneldaysofMonth.getItems()[0].setVisible(true);
                paneldaysofMonth.getItems()[1].setVisible(false);
            } else if (newVal === 'day') {
                paneldaysofMonth.getItems()[0].setVisible(false);
                paneldaysofMonth.getItems()[1].setVisible(true);
            }
        };

        itemsMonthly = [
            {
                pmType: 'panel',
                layout: 'hbox',
                items: [
                    {
                        id: 'startDate',
                        pmType: 'datetime',
                        label: 'Start date'.translate(),
                        value: '',
                        returnFormat: 'yy-mm-dd',
                        required: true,
                        dateFormat: 'yy mm dd',
                        datetime: false,
                        name: 'startDate',
                        valueType: 'date',
                        labelWidth: '26%'
                    },
                    {
                        id: 'endDate',
                        pmType: 'datetime',
                        label: 'End date'.translate(),
                        value: '',
                        returnFormat: 'yy-mm-dd',
                        required: false,
                        dateFormat: 'yy mm dd',
                        datetime: false,
                        name: 'endDate',
                        valueType: 'date'
                    }
                ]
            },
            {
                id: 'execttime',
                pmType: 'text',
                label: 'Execution time'.translate(),
                value: '',
                required: true,
                name: 'execttime',
                placeholder: '(HH:MM) Format 24 hrs.'.translate(),
                valueType: 'string',
                controlsWidth: 580,
                validators: [{
                    pmType: 'regexp',
                    criteria: /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/,
                    errorMessage: 'Please enter a valid hour.'.translate()
                }
                ],
                helper: 'Example: 1:00, 14:30, 00:00'
            },
            {
                pmType: 'panel',
                id: 'panelDays',
                layout: 'hbox',
                items: [
                    {
                        id: 'options',
                        pmType: 'radio',
                        label: '',
                        value: '',
                        name: 'options',
                        required: false,
                        controlPositioning: 'vertical',
                        maxDirectionOptions: 4,
                        options: [
                            {
                                id: 'dayMonth',
                                label: 'Day of month'.translate(),
                                value: 'dayofmonth'
                            },
                            {
                                id: 'day',
                                label: 'The day'.translate(),
                                value: 'day'
                            }
                        ],
                        onChange: function (newVal, oldVal) {
                            loadOptionsRadio(newVal);
                        },
                        labelWidth: '46%'
                    },
                    {
                        pmType: 'panel',
                        id: 'paneldaysofMonth',
                        layout: 'vbox',
                        items: [
                            {
                                id: 'dayoftheMonth',
                                pmType: 'text',
                                label: '',
                                value: '',
                                placeholder: 'Day of the month (example: 1)'.translate(),
                                required: false,
                                name: 'dayMonth',
                                valueType: 'string'
                            },
                            {
                                pmType: 'panel',
                                id: 'panelmonth',
                                layout: 'hbox',
                                items: [
                                    {
                                        id: 'first',
                                        pmType: 'dropdown',
                                        label: '',
                                        value: '',
                                        required: false,
                                        name: 'first',
                                        valueType: 'string',
                                        options: [
                                            {
                                                label: 'First'.translate(),
                                                value: '1'
                                            },
                                            {
                                                label: 'Second'.translate(),
                                                value: '2'
                                            },
                                            {
                                                label: 'Third'.translate(),
                                                value: '3'
                                            },
                                            {
                                                label: 'Fourth'.translate(),
                                                value: '4'
                                            },
                                            {
                                                label: 'Last'.translate(),
                                                value: '5'
                                            }
                                        ],
                                        controlsWidth: 100
                                    },
                                    {
                                        id: 'day',
                                        pmType: 'dropdown',
                                        label: '',
                                        value: '',
                                        required: false,
                                        name: 'day',
                                        valueType: 'string',
                                        options: [
                                            {
                                                label: 'Monday'.translate(),
                                                value: '1'
                                            },
                                            {
                                                label: 'Tuesday'.translate(),
                                                value: '2'
                                            },
                                            {
                                                label: 'Wednesday'.translate(),
                                                value: '3'
                                            },
                                            {
                                                label: 'Thursday'.translate(),
                                                value: '4'
                                            },
                                            {
                                                label: 'Friday'.translate(),
                                                value: '5'
                                            },
                                            {
                                                label: 'Saturday'.translate(),
                                                value: '6'
                                            },
                                            {
                                                label: 'Sunday'.translate(),
                                                value: '7'
                                            }
                                        ],
                                        controlsWidth: 100
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                id: 'months',
                pmType: 'checkbox',
                label: 'Of the month(s)'.translate(),
                value: '',
                name: 'months',
                required: false,
                controlPositioning: 'horizontal',
                maxDirectionOptions: 4,
                options: [
                    {
                        id: 'jan',
                        label: 'Jan'.translate(),
                        value: '1'
                    },
                    {
                        id: 'feb',
                        label: 'Feb'.translate(),
                        value: '2'
                    },
                    {
                        id: 'mar',
                        label: 'Mar'.translate(),
                        value: '3'
                    },
                    {
                        id: 'apr',
                        label: 'Apr'.translate(),
                        value: '4'
                    },
                    {
                        id: 'may',
                        label: 'May'.translate(),
                        value: '5'
                    },
                    {
                        id: 'jun',
                        label: 'Jun'.translate(),
                        value: '6'
                    },
                    {
                        id: 'jul',
                        label: 'Jul'.translate(),
                        value: '7'
                    },
                    {
                        id: 'aug',
                        label: 'Aug'.translate(),
                        value: '8'
                    },
                    {
                        id: 'sep',
                        label: 'Sep'.translate(),
                        value: '9'
                    },
                    {
                        id: 'oct',
                        label: 'Oct'.translate(),
                        value: '10'
                    },
                    {
                        id: 'nov',
                        label: 'Nov'.translate(),
                        value: '11'
                    },
                    {
                        id: 'dec',
                        label: 'Dec'.translate(),
                        value: '12'
                    }
                ]
            }
        ];

        itemsOneTime = [{
            id: 'execttime',
            pmType: 'text',
            label: 'Execution time'.translate(),
            value: '',
            required: true,
            name: 'execttime',
            placeholder: '(HH:MM) Format 24 hrs.'.translate(),
            valueType: 'string',
            validators: [{
                pmType: 'regexp',
                criteria: /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/,
                errorMessage: 'Please enter a valid hour.'.translate()
            }
            ],
            helper: 'Example: 1:00, 14:30, 00:00'
        }];

        itemsEvery = [{
            id: 'execttime',
            pmType: 'text',
            label: 'Execute every Hour(s)'.translate(),
            value: '',
            required: true,
            name: 'execttime',
            valueType: 'string',
            placeholder: '(HH:MM) Format 24 hrs.'.translate(),
            validators: [{
                pmType: 'regexp',
                criteria: /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/,
                errorMessage: 'Please enter a valid hour.'.translate()
            }
            ],
            helper: 'Example: 1:00, 14:30, 00:00'
        }];

        showProperties = function (newValue) {
            switch (newValue) {
                case 'daily':
                    formCreateCaseScheduler.getItems()[1].clearItems();
                    formCreateCaseScheduler.getItems()[1].setVisible(true);
                    formCreateCaseScheduler.getItems()[1].setItems(itemsDaly);
                    break;
                case 'weekly':
                    formCreateCaseScheduler.getItems()[1].clearItems();
                    formCreateCaseScheduler.getItems()[1].setVisible(true);
                    formCreateCaseScheduler.getItems()[1].setItems(itemsWeekly);
                    break;
                case 'monthly':
                    formCreateCaseScheduler.getItems()[1].clearItems();
                    formCreateCaseScheduler.getItems()[1].setVisible(true);
                    formCreateCaseScheduler.getItems()[1].setItems(itemsMonthly);
                    var paneldaysofMonth = formCreateCaseScheduler.getItems()[1].getItems()[2].getItems()[1];
                    paneldaysofMonth.setVisible(false);
                    formCreateCaseScheduler.getItems()[1].getItems()[2].getItems()[0].hideColon();
                    paneldaysofMonth.getItems()[0].hideColon();
                    paneldaysofMonth.getItems()[1].getItems()[0].hideColon();
                    paneldaysofMonth.getItems()[1].getItems()[1].hideColon();
                    break;
                case 'oneTime':
                    formCreateCaseScheduler.getItems()[1].clearItems();
                    formCreateCaseScheduler.getItems()[1].setVisible(true);
                    formCreateCaseScheduler.getItems()[1].setItems(itemsOneTime);
                    break;
                case 'every':
                    formCreateCaseScheduler.getItems()[1].clearItems();
                    formCreateCaseScheduler.getItems()[1].setVisible(true);
                    formCreateCaseScheduler.getItems()[1].setItems(itemsEvery);
                    validateKeysField(formCreateCaseScheduler.getField('execttime').getControls()[0].getHTML(), ['isnumber', 'iscolon']);
                    break;
            }
        };

        //Form to Edit and create the Case Scheduler
        formCreateCaseScheduler = new PMUI.form.Form({
            id: 'formCreateCaseScheduler',
            border: false,
            visibleHeader: false,
            width: '925px',
            name: 'formcreate',
            title: '',
            items: [
                {
                    id: 'panelProperties',
                    pmType: 'panel',
                    layout: 'vbox',
                    fieldset: true,
                    height: '350px',
                    legend: 'Properties'.translate(),
                    items: [
                        {
                            id: 'state',
                            pmType: 'dropdown',
                            label: 'Status'.translate(),
                            name: 'state',
                            required: true,
                            value: '',
                            controlsWidth: 150,
                            options: [
                                {
                                    value: 'ACTIVE',
                                    label: 'Active'.translate()
                                },
                                {
                                    value: 'INACTIVE',
                                    label: 'Inactive'.translate()
                                }
                            ]
                        },
                        {
                            id: 'username',
                            pmType: 'dropdown',
                            label: 'User'.translate(),
                            name: 'username',
                            required: true,
                            controlsWidth: 300,
                            value: '',
                            options: [],
                            onChange: function (newValue, prevValue) {
                            }
                        },
                        {
                            id: 'name',
                            pmType: 'text',
                            label: 'Name'.translate(),
                            value: startTimer.evn_name,
                            required: true,
                            name: 'name',
                            visible: false,
                            valueType: 'string'
                        },
                        {
                            id: 'performTask',
                            pmType: 'dropdown',
                            label: 'Perform this task'.translate(),
                            name: 'performTask',
                            required: true,
                            value: '',
                            controlsWidth: 300,
                            options: [
                                {
                                    label: '- Select -'.translate(),
                                    value: '',
                                    disabled: true,
                                    selected: true
                                },
                                {
                                    value: 'daily',
                                    label: 'Daily'.translate()
                                },
                                {
                                    value: 'weekly',
                                    label: 'Weekly'.translate()
                                },
                                {
                                    value: 'monthly',
                                    label: 'Monthly'.translate()
                                },
                                {
                                    value: 'oneTime',
                                    label: 'One Time Only'.translate()
                                },
                                {
                                    value: 'every',
                                    label: 'Every'.translate()
                                }
                            ],
                            onChange: function (newValue, prevValue) {
                                showProperties(newValue);
                            }
                        }
                    ]
                },
                {
                    id: 'panelSelectDate',
                    pmType: 'panel',
                    layout: 'vbox',
                    fieldset: true,
                    visible: false,
                    height: '350px',
                    legend: 'Select the date and time for case(s) to be initiated.'.translate(),
                    items: []
                }
            ]
        });

        buttonCancel = new PMUI.ui.Button({
            id: 'cancelSchedulerButton',
            text: 'Cancel'.translate(),
            buttonType: 'error',
            handler: function (event) {
                if (formCreateCaseScheduler.isDirty()) {
                    var message_window = new PMUI.ui.MessageWindow({
                        windowMessageType: 'warning',
                        width: 490,
                        bodyHeight: 'auto',
                        id: 'cancelMessageStartTimer',
                        title: 'Start Timer Event'.translate(),
                        message: 'Are you sure you want to discard your changes?'.translate(),
                        footerItems: [
                            {
                                text: 'No'.translate(),
                                handler: function () {
                                    message_window.close();
                                },
                                buttonType: "error"
                            },
                            {
                                text: 'Yes'.translate(),
                                handler: function () {
                                    message_window.close();
                                    schedulerListWindow.close();
                                },
                                buttonType: "success"
                            }
                        ]
                    });
                    message_window.open();
                    message_window.showFooter();
                } else {
                    formCreateCaseScheduler.reset();
                    schedulerListWindow.close();
                }
            }
        });

        //Window Buttons
        buttonSave = new PMUI.ui.Button({
            id: 'saveSchedulerButton',
            text: 'Save'.translate(),
            height: 31,
            buttonType: 'success',
            handler: function (event) {
                if (formCreateCaseScheduler.isValid()) {
                    var dataFormCreate = formCreateCaseScheduler.getData();

                    var dataToSend = {
                        sch_del_user_name: dataFormCreate.username,
                        sch_name: startTimer.evn_name,
                        tas_uid: startTimer.ports.get(0).connection.flo_element_dest,
                        sch_start_time: '',
                        sch_start_date: '',
                        sch_week_days: '',
                        sch_start_day: '',
                        sch_start_day_opt_1: '',
                        sch_start_day_opt_2: '',
                        sch_months: '',
                        sch_end_date: '',
                        sch_repeat_every: '',
                        sch_state: (dataFormCreate.state !== '') ? dataFormCreate.state : 'ACTIVE',
                        sch_option: ''
                    };

                    var perform = dataFormCreate.performTask;
                    switch (perform) {
                        case 'daily':
                            dataToSend.sch_option = '1';
                            dataToSend.sch_start_time = dataFormCreate.execttime;
                            dataToSend.sch_start_date = dataFormCreate.startDate;
                            dataToSend.sch_end_date = dataFormCreate.endDate;
                            break;
                        case 'weekly':
                            var formdays = eval(dataFormCreate.daysoftheweek);
                            var days = '';
                            for (i = 0; i < formdays.length; i += 1) {
                                if (i !== (formdays.length - 1)) {
                                    days += formdays[i] + '|';
                                } else {
                                    days += formdays[i];
                                }
                            }

                            dataToSend.sch_option = '2';
                            dataToSend.sch_start_time = dataFormCreate.execttime;
                            dataToSend.sch_start_date = dataFormCreate.startDate;
                            dataToSend.sch_end_date = dataFormCreate.endDate;
                            dataToSend.sch_week_days = days;
                            break;
                        case 'monthly':
                            dataToSend.sch_option = '3';
                            dataToSend.sch_start_time = dataFormCreate.execttime;
                            dataToSend.sch_start_date = dataFormCreate.startDate;
                            dataToSend.sch_end_date = dataFormCreate.endDate;
                            if (dataFormCreate.options === 'dayofmonth') {
                                var formmonths = eval(dataFormCreate.months);
                                var months = '';
                                for (i = 0; i < formmonths.length; i += 1) {
                                    if (i !== (formmonths.length - 1)) {
                                        months += formmonths[i] + '|';
                                    } else {
                                        months += formmonths[i];
                                    }
                                }
                                dataToSend.sch_start_day = '1'; //Day of month
                                dataToSend.sch_start_day_opt_1 = dataFormCreate.dayMonth;//1 to 31 - day of the month
                            } else if (dataFormCreate.options === 'day') {
                                var opt2 = dataFormCreate.first + '|' + dataFormCreate.day;
                                var formmonths = eval(dataFormCreate.months);
                                var months = '';
                                for (i = 0; i < formmonths.length; i += 1) {
                                    if (i !== (formmonths.length - 1)) {
                                        months += formmonths[i] + '|';
                                    } else {
                                        months += formmonths[i];
                                    }
                                }
                                dataToSend.sch_start_day = '2'; //Day of month
                                dataToSend.sch_start_day_opt_2 = opt2;//1 to 31 - day of the month

                            }
                            dataToSend.sch_months = months;
                            break;
                        case 'oneTime':
                            dataToSend.sch_option = '4';
                            dataToSend.sch_start_time = dataFormCreate.execttime;
                            break;
                        case 'every':
                            dataToSend.sch_option = '5';
                            dataToSend.sch_repeat_every = timeToDecimal(dataFormCreate.execttime).toFixed(2);
                            break;
                    }
                    updateCaseScheduler(dataToSend);
                }
            }
        });

        //load users
        loadUsers = function () {
            var field = formCreateCaseScheduler.getField('username');
            field.clearOptions();
            for (var i = 0; i < listUsers.length; i += 1) {
                field.addOption({
                    value: listUsers[i].aas_username,
                    label: listUsers[i].aas_name + ' ' + listUsers[i].aas_lastname
                });
            }
        };

        loadDataForm = function () {
            var loadTime,
                option,
                daysVal,
                monthsVal,
                monthsop,
                days,
                i,
                startTime,
                finallyST,
                dataEdit;

            loadTime = function (dataEdit, dataForm) {
                var starDate,
                    startTime,
                    finallyST,
                    endDate;
                starDate = dataForm.sch_start_date ? dataForm.sch_start_date.split(' ') : [''];
                endDate = dataForm.sch_end_date ? dataForm.sch_end_date.split(' ') : [''];

                startTime = dataForm.sch_start_time.split(' ');
                startTime = startTime[1].split(':');
                finallyST = startTime[0] + ':' + startTime[1];
                dataEdit[4].setValue(starDate[0]);
                dataEdit[5].setValue(endDate[0]);
                dataEdit[6].setValue(finallyST);
            };

            dataEdit = formCreateCaseScheduler.getFields();

            dataEdit[0].setValue(dataForm.sch_state);
            dataEdit[1].setValue(dataForm.sch_del_user_name);
            option = 'daily';
            switch (dataForm.sch_option) {
                case '1':
                    option = 'daily';
                    dataEdit[3].setValue(option);
                    showProperties(option);
                    dataEdit = formCreateCaseScheduler.getFields();
                    loadTime(dataEdit, dataForm);
                    break;
                case '2':
                    option = 'weekly';
                    dataEdit[3].setValue(option);
                    showProperties(option);
                    dataEdit = formCreateCaseScheduler.getFields();
                    loadTime(dataEdit, dataForm);

                    daysVal = "[\"";
                    days = dataForm.sch_week_days.split('|');
                    for (i = 0; i < days.length; i += 1) {
                        if (i !== (days.length - 1)) {
                            daysVal += days[i] + "\",\"";
                        } else {
                            daysVal += days[i] + "\"]";
                        }
                    }
                    dataEdit[7].setValue(daysVal);
                    break;
                case '3':
                    option = 'monthly';
                    dataEdit[3].setValue(option);
                    showProperties(option);
                    dataEdit = formCreateCaseScheduler.getFields();
                    loadTime(dataEdit, dataForm);
                    days = [];
                    if (dataForm.sch_start_day !== '') {
                        days = dataForm.sch_start_day.split('|');
                    }

                    if (days[0] === '1') {
                        dataEdit[7].setValue('dayofmonth');
                        loadOptionsRadio('dayofmonth');
                        dataEdit[8].setValue(days[1]);
                    } else if (days[0] === '2') {
                        dataEdit[7].setValue('day');
                        loadOptionsRadio('day');
                        dataEdit[9].setValue(days[1]);
                        dataEdit[10].setValue(days[2]);
                    }
                    monthsVal = "[\"";
                    monthsop = dataForm.sch_months.split('|');
                    for (i = 0; i < monthsop.length; i += 1) {
                        if (i !== (monthsop.length - 1)) {
                            monthsVal += monthsop[i] + "\",\"";
                        } else {
                            monthsVal += monthsop[i] + "\"]";
                        }
                    }
                    dataEdit[11].setValue(monthsVal);
                    break;
                case '4':
                    option = 'oneTime';
                    dataEdit[3].setValue(option);
                    showProperties(option);
                    dataEdit = formCreateCaseScheduler.getFields();
                    startTime = dataForm.sch_start_time.split(' ');
                    startTime = startTime[1].split(':');
                    finallyST = startTime[0] + ':' + startTime[1];
                    dataEdit[4].setValue(finallyST);
                    break;
                case '5':
                    option = 'every';
                    dataEdit[3].setValue(option);
                    showProperties(option);
                    dataEdit = formCreateCaseScheduler.getFields();
                    dataEdit[4].setValue(decimalToTime(parseFloat(dataForm.sch_repeat_every)));
                    break;
            }
        };

        //Main window Case Scheduler
        schedulerListWindow = new PMUI.ui.Window({
            id: 'schedulerListWindow',
            title: 'Start Timer Event'.translate(),
            height: DEFAULT_WINDOW_HEIGHT,
            width: DEFAULT_WINDOW_WIDTH,
            buttonPanelPosition: 'top',
            buttons: [
                buttonSave,
                {pmType: 'label', text: 'or'},
                buttonCancel
            ]
        });

        openForm = function () {
            schedulerListWindow.addItem(formCreateCaseScheduler);
            schedulerListWindow.open();
            loadUsers();
            loadDataForm();
            applyStyleWindowForm(schedulerListWindow);
            schedulerListWindow.showFooter();
            schedulerListWindow.defineEvents();
        };
    };

    PMDesigner.startTimer.openForm = function (element) {
        openForm();
    };

    PMDesigner.startTimer.validate = function (element) {
        if (element.ports.isEmpty()) {
            PMDesigner.msgFlash('Must connect to a Task'.translate(), document.body, 'error', 3000, 5);
            return false;
        }
        PMDesigner.startTimer(element);
        if (loadValuesStartTimer(true) === 0) {
            PMDesigner.msgFlash('The task doesn\'t have assigned users'.translate(), document.body, 'info', 3000, 5);
            return false;
        }
        return true;
    };

}());
(
    function () {
        var dataBaseConnectionOption,
            winFrmDataBaseConnectionShow,
            frmDataBaseConnection,
            closeClicked = true;

        PMDesigner.database = function (event) {
            var winGrdpnlDataBaseConnection,
                panelTest,
                grdpnlDataBaseConnection,
                flagError,
                titleOld,
                btnNew,
                btnTestConnection,
                btnCreate,
                btnCancel,
                testShow,
                isDirtyFrmDataBaseConnection,
                showForm,
                listDBConnection,
                refreshGridPanelInMainWindow,
                dataBaseConnectionsGetRestProxy,
                dataBaseConnectionPostTestRestProxy,
                dataBaseConnectionGetRestProxy,
                dataBaseConnectionPutRestProxy,
                dataBaseConnectionDeleteRestProxy,
                dataBaseConnectionPostRestProxy,
                cboEngineSetOptionsRestProxy,
                showEncoderOptions,
                hideEncoderOptions,
                cboConnectionTypeOracleSetOptions,
                cboEncodeSetOptionsRestProxy,
                winFrmDataBaseConnectionShow,
                cboEngine,
                txtUID,
                cboEncode,
                txtTns,
                txtServer,
                txtDataBaseName,
                disableAllItems,
                txtUsername,
                txtPassword,
                txtPort,
                btnBack,
                txtDescription,
                cboConnectionTypeOracle,
                dataBaseConnectionData;

            disableAllItems = function () {
                winGrdpnlDataBaseConnection.getItems()[0].setVisible(false);
                winGrdpnlDataBaseConnection.getItems()[1].setVisible(false);
                winGrdpnlDataBaseConnection.getItems()[2].setVisible(false);

                txtUID.setVisible(false);
                btnTestConnection.setVisible(false);
                btnBack.setVisible(false);
                btnCreate.setVisible(false);
                btnCancel.setVisible(false);
            };

            testShow = function (testData) {
                var msg = "", titleSummary, style, i, flag;
                flagError = 0;
                disableAllItems();
                titleOld = winGrdpnlDataBaseConnection.getTitle();
                winGrdpnlDataBaseConnection.setTitle("Testing Server Connection".translate());
                winGrdpnlDataBaseConnection.getItems()[2].setVisible(true);

                for (i = 0; i <= testData.length - 1; i += 1) {
                    flag = (typeof(testData[i].error) != "undefined") ? 1 : 0;
                    if (flag != 1) {
                        msg = msg + "<img src = \"/images/select-icon.png\" width=\"17\" height=\"17\" style=\"margin-right: 0.9em;\" />" + testData[i].test + "<br />";
                    } else {
                        msg = msg + "<img src = \"/images/error.png\" width=\"21\" height=\"21\" style=\"margin-right: 0.6em;\" />" + testData[i].error + "<br />";
                    }

                    if (typeof(testData[i].error) != "undefined" && flagError == 0) {
                        flagError = 1;
                    }
                }
                if (flag == 0) {
                    btnCreate.setVisible(true);
                    btnBack.setVisible(true);
                } else {
                    btnBack.setVisible(true);
                }

                titleSummary = "<div style=\"margin: 1em 1em 0.5em 1em; padding: 0 2em 0 2em; border: 2px solid #AFC5D0; background:#D7ECF1; font: bold 1em arial; text-align: center; width: " + (DEFAULT_WINDOW_WIDTH - 22) + ";\">Testing Database Server configuration</div>";

                style = $('#panelTest').attr("style");
                titleSummary = titleSummary + "<div style=\"margin-left: 0.5em; padding: 0.5em; height: 235px;\">" + msg + "</div>";
                $('#panelTest').empty();
                style = style + ' background: #FFFFFF; font: normal 0.8em arial;';
                $('#panelTest').attr("style", style);
                $('#panelTest').append(titleSummary);
            };

            isDirtyFrmDataBaseConnection = function () {
                var message_window;
                $("input,select,textarea").blur();
                if (frmDataBaseConnection.isVisible()) {
                    if (frmDataBaseConnection.isDirty()) {
                        message_window = new PMUI.ui.MessageWindow({
                            id: "cancelMessageTriggers",
                            windowMessageType: 'warning',
                            width: 490,
                            title: "Database Connections".translate(),
                            message: 'Are you sure you want to discard your changes?'.translate(),
                            footerItems: [
                                {
                                    text: "No".translate(),
                                    handler: function () {
                                        message_window.close();
                                    },
                                    buttonType: "error"
                                },
                                {
                                    text: "Yes".translate(),
                                    handler: function () {
                                        message_window.close();
                                        dataBaseConnectionOption = "";
                                        if (closeClicked) {
                                            winGrdpnlDataBaseConnection.close();
                                        }
                                        refreshGridPanelInMainWindow(false);
                                    },
                                    buttonType: "success"
                                }
                            ],
                            title: 'Confirm'.translate()
                        });
                        message_window.open();
                        message_window.showFooter();
                    } else {
                        if (closeClicked) {
                            winGrdpnlDataBaseConnection.close();
                        } else {
                            dataBaseConnectionOption = "";
                            refreshGridPanelInMainWindow(false);
                        }
                    }
                } else {
                    winGrdpnlDataBaseConnection.close();
                }
            };
            showForm = function () {
                disableAllItems();
                winGrdpnlDataBaseConnection.setTitle(titleOld);
                winGrdpnlDataBaseConnection.getItems()[1].setVisible(true);
                btnTestConnection.setVisible(true);
                btnCancel.setVisible(true);
            }

            refreshGridPanelInMainWindow = function (load) {
                disableAllItems();
                winGrdpnlDataBaseConnection.hideFooter();
                dataBaseConnectionOption = "";
                winGrdpnlDataBaseConnection.getItems()[0].setVisible(true);
                winGrdpnlDataBaseConnection.setTitle("Database Connections".translate());
                load = load != null ? load : true;
                if (load) {
                    dataBaseConnectionsGetRestProxy(grdpnlDataBaseConnection);
                }
            };

            dataBaseConnectionsGetRestProxy = function (grdpnl) {
                var restProxy = new PMRestClient({
                    endpoint: "database-connections",
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        listDBConnection = response;
                        grdpnl.setDataItems(listDBConnection);
                        grdpnl.sort('dbs_database_name', 'asc');
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            dataBaseConnectionPostTestRestProxy = function (data) {
                var restProxy = new PMRestClient({
                    endpoint: "database-connection/test",
                    typeRequest: "post",
                    data: data,
                    functionSuccess: function (xhr, response) {
                        testShow(response);
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            dataBaseConnectionGetRestProxy = function (dataBaseConnectionUid) {
                var restProxy = new PMRestClient({
                    endpoint: "database-connection/" + dataBaseConnectionUid,
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response;
                        dataBaseConnectionOption = "PUT";
                        winFrmDataBaseConnectionShow("PUT", data);
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            dataBaseConnectionPutRestProxy = function (dataBaseConnectionUid, data) {
                var restProxy = new PMRestClient({
                    endpoint: "database-connection/" + dataBaseConnectionUid,
                    typeRequest: "update",
                    data: data,
                    functionSuccess: function (xhr, response) {
                        refreshGridPanelInMainWindow();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'Database connection edited successfully'.translate(),
                    flashContainer: grdpnlDataBaseConnection
                });

                restProxy.executeRestClient();
            };

            dataBaseConnectionDeleteRestProxy = function (dataBaseConnectionUid) {
                var restProxy = new PMRestClient({
                    endpoint: "database-connection/" + dataBaseConnectionUid,
                    typeRequest: "remove",
                    functionSuccess: function (xhr, response) {
                        refreshGridPanelInMainWindow();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'Database connection deleted successfully'.translate(),
                    flashContainer: grdpnlDataBaseConnection
                });
                restProxy.executeRestClient();
            };

            dataBaseConnectionPostRestProxy = function (data) {
                var restProxy = new PMRestClient({
                    endpoint: "database-connection",
                    typeRequest: "post",
                    data: data,
                    functionSuccess: function (xhr, response) {
                        refreshGridPanelInMainWindow();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);

                        refreshGridPanelInMainWindow();
                    },
                    messageError: 'An unexpected error while deleting the DB Connection, please try again later.'.translate(),
                    messageSuccess: 'Database connection saved successfully'.translate(),
                    flashContainer: grdpnlDataBaseConnection
                });

                restProxy.executeRestClient();
            };

            cboEngineSetOptionsRestProxy = function (cboEngine, cboEncode) {
                cboEngine.clearOptions();
                var restProxy = new PMRestClient({
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response,
                            i,
                            arrayOptions = [];
                        for (i = 0; i <= data.length - 1; i += 1) {
                            arrayOptions.push(
                                {
                                    value: data[i].id,
                                    label: data[i].name
                                }
                            );
                        }
                        cboEngine.setOptions(arrayOptions);
                        cboEngine.setValue(arrayOptions[0].value);
                        cboEncodeSetOptionsRestProxy(cboEngine.getValue(), cboEncode);
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });

                restProxy.setBaseEndPoint("system/db-engines");
                restProxy.executeRestClient();
            };

            hideEncoderOptions = function () {
                cboEncode.setVisible(true);
                cboConnectionTypeOracle.setVisible(true);
            };

            showEncoderOptions = function () {
                cboEncode.setVisible(true);
                cboConnectionTypeOracle.setVisible(false);
            };
            cboConnectionTypeOracleSetOptions = function (cboConnectionTypeOracle) {
                var arrayEnconde = [],
                    i,
                    arrayOptions = [];
                cboConnectionTypeOracle.clearOptions();

                arrayEnconde = [
                    {"value": "NORMAL", "text": "Normal"},
                    {"value": "TNS", "text": "TNS"}
                ];

                for (i = 0; i <= arrayEnconde.length - 1; i += 1) {
                    arrayOptions.push(
                        {
                            value: arrayEnconde[i].value,
                            label: arrayEnconde[i].text
                        }
                    );
                }

                cboConnectionTypeOracle.setOptions(arrayOptions);
            };
            cboEncodeSetOptionsRestProxy = function (selectedCboEngineValue, cboEncode) {
                var arrayEnconde = [],
                    arrayNewEnconde,
                    i,
                    portsDefault,
                    arrayOptions,
                    encode = selectedCboEngineValue;
                cboEncode.clearOptions();

                arrayEnconde["mysql"] = [
                    {"value": "big5", "text": "big5 - Big5 Traditional Chinese"},
                    {"value": "dec8", "text": "dec8 - DEC West European"},
                    {"value": "cp850", "text": "cp850 - DOS West European"},
                    {"value": "hp8", "text": "hp8 - HP West European"},
                    {"value": "koi8r", "text": "koi8r - KOI8-R Relcom Russian"},
                    {"value": "latin1", "text": "latin1 - cp1252 West European"},
                    {"value": "latin2", "text": "latin2 - ISO 8859-2 Central European"},
                    {"value": "swe7", "text": "swe7 - 7bit Swedish"},
                    {"value": "ascii", "text": "ascii - US ASCII"},
                    {"value": "ujis", "text": "ujis - EUC-JP Japanese"},
                    {"value": "sjis", "text": "sjis - Shift-JIS Japanese"},
                    {"value": "hebrew", "text": "hebrew - ISO 8859-8 Hebrew"},
                    {"value": "tis620", "text": "tis620 - TIS620 Thai"},
                    {"value": "euckr", "text": "euckr - EUC-KR Korean"},
                    {"value": "koi8u", "text": "koi8u - KOI8-U Ukrainian"},
                    {"value": "gb2312", "text": "gb2312 - GB2312 Simplified Chinese"},
                    {"value": "greek", "text": "greek - ISO 8859-7 Greek"},
                    {"value": "cp1250", "text": "cp1250 - Windows Central European"},
                    {"value": "gbk", "text": "gbk - GBK Simplified Chinese"},
                    {"value": "latin5", "text": "latin5 - ISO 8859-9 Turkish"},
                    {"value": "armscii8", "text": "armscii8 - ARMSCII-8 Armenian"},
                    {"value": "utf8", "text": "utf8 - UTF-8 Unicode"},
                    {"value": "ucs2", "text": "ucs2 - UCS-2 Unicode"},
                    {"value": "cp866", "text": "cp866 - DOS Russian"},
                    {"value": "keybcs2", "text": "keybcs2 - DOS Kamenicky Czech-Slovak"},
                    {"value": "macce", "text": "macce - Mac Central European"},
                    {"value": "macroman", "text": "macroman - Mac West European"},
                    {"value": "cp852", "text": "cp852 - DOS Central European"},
                    {"value": "latin7", "text": "atin7 - ISO 8859-13 Baltic"},
                    {"value": "cp1251", "text": "cp1251 - Windows Cyrillic"},
                    {"value": "cp1256", "text": "cp1256  - Windows Arabic"},
                    {"value": "cp1257", "text": "cp1257  - Windows Baltic"},
                    {"value": "binary", "text": "binary  - Binary pseudo charset"},
                    {"value": "geostd8", "text": "geostd8 - GEOSTD8 Georgian"},
                    {"value": "cp932", "text": "cp932] - SJIS for Windows Japanese"},
                    {"value": "eucjpms", "text": "eucjpms - UJIS for Windows Japanese"}
                ];

                arrayEnconde["pgsql"] = [
                    {"value": "BIG5", "text": "BIG5"},
                    {"value": "EUC_CN", "text": "EUC_CN"},
                    {"value": "EUC_JP", "text": "EUC_JP"},
                    {"value": "EUC_KR", "text": "EUC_KR"},
                    {"value": "EUC_TW", "text": "EUC_TW"},
                    {"value": "GB18030", "text": "GB18030"},
                    {"value": "GBK", "text": "GBK"},
                    {"value": "ISO_8859_5", "text": "ISO_8859_5"},
                    {"value": "ISO_8859_6", "text": "ISO_8859_6"},
                    {"value": "ISO_8859_7", "text": "ISO_8859_7"},
                    {"value": "ISO_8859_8", "text": "ISO_8859_8"},
                    {"value": "JOHAB", "text": "JOHAB"},
                    {"value": "KOI8", "text": "KOI8"},
                    {"value": "selected", "text": "LATIN1"},
                    {"value": "LATIN2", "text": "LATIN2"},
                    {"value": "LATIN3", "text": "LATIN3"},
                    {"value": "LATIN4", "text": "LATIN4"},
                    {"value": "LATIN5", "text": "LATIN5"},
                    {"value": "LATIN6", "text": "LATIN6"},
                    {"value": "LATIN7", "text": "LATIN7"},
                    {"value": "LATIN8", "text": "LATIN8"},
                    {"value": "LATIN9", "text": "LATIN9"},
                    {"value": "LATIN10", "text": "LATIN10"},
                    {"value": "SJIS", "text": "SJIS"},
                    {"value": "SQL_ASCII", "text": "SQL_ASCII"},
                    {"value": "UHC", "text": "UHC"},
                    {"value": "UTF8", "text": "UTF8"},
                    {"value": "WIN866", "text": "WIN866"},
                    {"value": "WIN874", "text": "WIN874"},
                    {"value": "WIN1250", "text": "WIN1250"},
                    {"value": "WIN1251", "text": "WIN1251"},
                    {"value": "WIN1252", "text": "WIN1252"},
                    {"value": "WIN1256", "text": "WIN1256"},
                    {"value": "WIN1258", "text": "WIN1258"}
                ];

                arrayEnconde["mssql"] = [
                    {"value": "utf8", "text": "utf8 - UTF-8 Unicode"}
                ];

                arrayEnconde["oracle"] = [
                    {"value": "UTF8", "text": "UTF8 - Unicode 3.0 UTF-8 Universal character set, CESU-8 compliant"},
                    {"value": "UTFE", "text": "UTFE - EBCDIC form of Unicode 3.0 UTF-8 Universal character set"},
                    {"value": "AL16UTF16", "text": "AL16UTF16 - Unicode 3.1 UTF-16 Universal character set"},
                    {"value": "AL32UTF8", "text": "AL32UTF8 - Unicode 3.1 UTF-8 Universal character set"}
                ];

                arrayEnconde["sqlsrv"] = [
                    {"value": "utf8", "text": "utf8 - UTF-8 Unicode"}
                ];

                arrayNewEnconde = (typeof(arrayEnconde[encode]) != "undefined") ? arrayEnconde[encode] : [];
                arrayOptions = [];

                for (i = 0; i <= arrayNewEnconde.length - 1; i += 1) {
                    arrayOptions.push(
                        {
                            value: arrayNewEnconde[i].value,
                            label: arrayNewEnconde[i].text
                        }
                    );
                }

                cboEncode.setOptions(arrayOptions);
                cboEncode.setValue('utf8');

                portsDefault = ["3306", "5432", "1433", "1521"];
                switch (encode) {
                    case "mysql":
                        txtPort.setValue(portsDefault[0]);
                        showEncoderOptions();
                        break;
                    case "pgsql":
                        txtPort.setValue(portsDefault[1]);
                        showEncoderOptions();
                        break;
                    case "mssql":
                        txtPort.setValue(portsDefault[2]);
                        showEncoderOptions();
                        break;
                    case "oracle":
                        txtPort.setValue(portsDefault[3]);
                        hideEncoderOptions();
                        break;
                }
            };

            winFrmDataBaseConnectionShow = function (option, data) {
                disableAllItems();
                dataBaseConnectionData = data;
                frmDataBaseConnection.reset();
                cboEngineSetOptionsRestProxy(cboEngine, cboEncode);
                cboConnectionTypeOracleSetOptions(cboConnectionTypeOracle);
                winGrdpnlDataBaseConnection.getItems()[1].setVisible(true);
                btnTestConnection.setVisible(true);
                btnCancel.setVisible(true);
                winGrdpnlDataBaseConnection.showFooter();

                switch (option) {
                    case "POST":
                        winGrdpnlDataBaseConnection.setTitle("Create Database Connection".translate());
                        frmDataBaseConnection.setTitle("");
                        txtTns.setVisible(false);
                        txtTns.setRequired(false);
                        txtServer.setVisible(true);
                        txtServer.setRequired(true);
                        txtDataBaseName.setVisible(true);
                        txtDataBaseName.setRequired(true);
                        txtPort.setVisible(true);
                        txtPort.setRequired(true);
                        txtPort.setValue("3306");
                        break;
                    case "PUT":
                        winGrdpnlDataBaseConnection.setTitle("Edit Database Connection".translate());
                        frmDataBaseConnection.setTitle("");
                        txtUID.setVisible(true);
                        txtUID.setValue(dataBaseConnectionData.dbs_uid);
                        cboEngine.setValue(dataBaseConnectionData.dbs_type);
                        cboEncodeSetOptionsRestProxy(dataBaseConnectionData.dbs_type, cboEncode);
                        cboEncode.setValue(dataBaseConnectionData.dbs_encode);
                        txtServer.setValue(dataBaseConnectionData.dbs_server);
                        txtDataBaseName.setValue(dataBaseConnectionData.dbs_database_name);
                        txtUsername.setValue(dataBaseConnectionData.dbs_username);
                        txtPassword.setValue(dataBaseConnectionData.dbs_password);
                        txtPort.setValue(dataBaseConnectionData.dbs_port);
                        txtDescription.setValue(dataBaseConnectionData.dbs_description);

                        if (dataBaseConnectionData.dbs_type == "oracle") {
                            cboConnectionTypeOracle.setValue(dataBaseConnectionData.dbs_connection_type);
                            cboConnectionTypeOracle.setVisible(true);

                            if (dataBaseConnectionData.dbs_connection_type == "TNS" && dataBaseConnectionData.dbs_tns != "") {
                                txtTns.setValue(dataBaseConnectionData.dbs_tns);
                                txtTns.setVisible(true);
                                txtTns.setRequired(true);

                                txtServer.setValue("");
                                txtServer.setVisible(false);
                                txtServer.setRequired(false);

                                txtDataBaseName.setValue("");
                                txtDataBaseName.setVisible(false);
                                txtDataBaseName.setRequired(false);

                                txtPort.setValue("");
                                txtPort.setVisible(false);
                                txtPort.setRequired(false);
                            } else {
                                txtTns.setValue("");
                                txtTns.setVisible(false);
                                txtTns.setRequired(false);

                                txtServer.setVisible(true);
                                txtServer.setRequired(true);

                                txtDataBaseName.setVisible(true);
                                txtDataBaseName.setRequired(true);

                                txtPort.setVisible(true);
                                txtPort.setRequired(true);
                            }
                        } else {
                            txtTns.setValue("");
                            txtTns.setVisible(false);
                            txtTns.setRequired(false);

                            txtServer.setVisible(true);
                            txtServer.setRequired(true);

                            txtDataBaseName.setVisible(true);
                            txtDataBaseName.setRequired(true);

                            txtPort.setVisible(true);
                            txtPort.setRequired(true);
                        }
                        break;
                }
                frmDataBaseConnection.setFocus();
            };

            txtUID = new PMUI.field.TextField({
                id: "txtUID",
                name: "txtUID",
                valueType: "string",
                controlsWidth: 300,
                label: "UID".translate(),
                maxLength: 200,
                readOnly: true,
                visible: false
            });

            cboEngine = new PMUI.field.DropDownListField({
                id: "cboEngine",
                name: "cboEngine",
                label: "Engine".translate(),
                options: null,
                controlsWidth: 150,
                onChange: function (newValue, prevValue) {
                    if (cboEngine.getValue() == "oracle") {
                        cboConnectionTypeOracleSetOptions(cboConnectionTypeOracle);
                    } else {
                        txtTns.setVisible(false);
                        txtTns.setRequired(false);

                        txtServer.setVisible(true);
                        txtServer.setRequired(true);

                        txtDataBaseName.setVisible(true);
                        txtDataBaseName.setRequired(true);

                        txtPort.setVisible(true);
                        txtPort.setRequired(true);
                    }

                    cboEncodeSetOptionsRestProxy(cboEngine.getValue(), cboEncode);
                }
            });

            cboEncode = new PMUI.field.DropDownListField({
                id: "cboEncode",
                name: "cboEncode",
                label: "Encode".translate(),
                options: null,
                controlsWidth: 300
            });

            cboConnectionTypeOracle = new PMUI.field.DropDownListField({
                id: "cboConnectionTypeOracle",
                name: "cboConnectionTypeOracle",
                label: "Select Connection Type".translate(),
                options: null,
                controlsWidth: 300,

                onChange: function (newValue, prevValue) {
                    if (cboConnectionTypeOracle.getValue() != "NORMAL") {
                        txtTns.setVisible(true);
                        txtTns.setRequired(true);

                        txtServer.setVisible(false);
                        txtServer.setRequired(false);

                        txtDataBaseName.setVisible(false);
                        txtDataBaseName.setRequired(false);

                        txtPort.setVisible(false);
                        txtPort.setRequired(false);
                    } else {
                        txtTns.setVisible(false);
                        txtTns.setRequired(false);

                        txtServer.setVisible(true);
                        txtServer.setRequired(true);

                        txtDataBaseName.setVisible(true);
                        txtDataBaseName.setRequired(true);

                        txtPort.setValue("1521");
                        txtPort.setVisible(true);
                        txtPort.setRequired(true);
                    }
                }
            });

            txtTns = new PMUI.field.TextField({
                id: "txtTns",
                name: "txtTns",
                valueType: "txtTns",
                controlsWidth: 300,
                label: "TNS".translate(),
                maxLength: 200,
                visible: false,
                required: true
            });

            txtServer = new PMUI.field.TextField({
                id: "txtServer",
                name: "txtServer",
                valueType: "string",
                controlsWidth: 300,
                label: "Server".translate(),
                maxLength: 200,
                required: true
            });

            txtDataBaseName = new PMUI.field.TextField({
                id: "txtDataBaseName",
                name: "txtDataBaseName",
                valueType: "string",
                controlsWidth: 300,
                label: "Database Name".translate(),
                maxLength: 200,
                required: true
            });

            txtUsername = new PMUI.field.TextField({
                id: "txtUsername",
                name: "txtUsername",
                valueType: "string",
                controlsWidth: 300,
                label: "Username".translate(),
                maxLength: 200,
                required: true
            });

            txtPassword = new PMUI.field.PasswordField({
                id: "txtPassword",
                name: "txtPassword",
                valueType: "string",
                controlsWidth: 300,
                label: "Password".translate(),
                maxLength: 200
            });

            txtPort = new PMUI.field.TextField({
                id: "txtPort",
                name: "txtPort",
                valueType: "string",
                controlsWidth: 300,
                label: "Port".translate(),
                value: "3306",
                controlsWidth: 300,
                maxLength: 200,
                required: true
            });

            txtDescription = new PMUI.field.TextAreaField({
                id: "txtDescription",
                name: "txtDescription",
                valueType: "string",
                controlsWidth: 500,
                label: "Description".translate(),
                height: "200px",
                style: {cssClasses: ['mafe-textarea-resize']}
            });

            btnTestConnection = new PMUI.ui.Button({
                id: "btnTestConnection",
                text: "Test Connection".translate(),
                buttonType: 'success',
                handler: function () {
                    var data;
                    if (frmDataBaseConnection.isValid()) {
                        if (cboEngine.getValue() == "oracle") {
                            data = {
                                dbs_type: cboEngine.getValue(),
                                dbs_encode: cboEncode.getValue(),
                                dbs_connection_type: cboConnectionTypeOracle.getValue(),
                                dbs_tns: txtTns.getValue(),
                                dbs_server: txtServer.getValue(),
                                dbs_database_name: txtDataBaseName.getValue(),
                                dbs_username: txtUsername.getValue(),
                                dbs_password: getData2PMUI(frmDataBaseConnection.html).txtPassword,
                                dbs_port: parseInt(getData2PMUI(frmDataBaseConnection.html).txtPort),
                                dbs_description: txtDescription.getValue()
                            };
                        } else {
                            data = {
                                dbs_type: cboEngine.getValue(),
                                dbs_encode: cboEncode.getValue(),
                                dbs_server: txtServer.getValue(),
                                dbs_database_name: txtDataBaseName.getValue(),
                                dbs_username: txtUsername.getValue(),
                                dbs_password: getData2PMUI(frmDataBaseConnection.html).txtPassword,
                                dbs_port: parseInt(getData2PMUI(frmDataBaseConnection.html).txtPort),
                                dbs_description: txtDescription.getValue()
                            };
                        }
                        dataBaseConnectionPostTestRestProxy(data);
                    }
                }
            });

            btnCreate = new PMUI.ui.Button({
                id: "btnCreate",
                text: "Save".translate(),
                buttonType: "success",
                handler: function () {
                    var data;
                    if (cboEngine.getValue() == "oracle") {
                        data = {
                            dbs_type: cboEngine.getValue(),
                            dbs_encode: cboEncode.getValue(),
                            dbs_connection_type: cboConnectionTypeOracle.getValue(),
                            dbs_tns: txtTns.getValue(),
                            dbs_server: txtServer.getValue(),
                            dbs_database_name: txtDataBaseName.getValue(),
                            dbs_username: txtUsername.getValue(),
                            dbs_password: getData2PMUI(frmDataBaseConnection.html).txtPassword,
                            dbs_port: parseInt(getData2PMUI(frmDataBaseConnection.html).txtPort),
                            dbs_description: txtDescription.getValue()
                        };
                    } else {
                        data = {
                            dbs_type: cboEngine.getValue(),
                            dbs_encode: cboEncode.getValue(),
                            dbs_server: txtServer.getValue(),
                            dbs_database_name: txtDataBaseName.getValue(),
                            dbs_username: txtUsername.getValue(),
                            dbs_password: txtPassword.getValue(),
                            dbs_port: parseInt(txtPort.getValue()),
                            dbs_description: txtDescription.getValue()
                        };
                    }

                    switch (dataBaseConnectionOption) {
                        case "POST":
                            if (frmDataBaseConnection.isValid()) {
                                dataBaseConnectionPostRestProxy(data);
                            } else {
                                return;
                            }
                            break;
                        case "PUT":
                            if (frmDataBaseConnection.isValid()) {
                                dataBaseConnectionPutRestProxy(dataBaseConnectionData.dbs_uid, data);
                            } else {
                                return;
                            }
                            break;
                    }
                }
            });

            btnCancel = new PMUI.ui.Button({
                id: "btnCancel",
                text: "Cancel".translate(),
                buttonType: 'error',
                handler: function () {
                    closeClicked = false;
                    isDirtyFrmDataBaseConnection();
                }
            });

            btnBack = new PMUI.ui.Button({
                id: "btnBack",
                text: "Back".translate(),
                handler: function () {
                    showForm();
                }
            });

            frmDataBaseConnection = new PMUI.form.Form({
                id: "frmDataBaseConnection",
                width: DEFAULT_WINDOW_WIDTH - 70,
                items: [
                    txtUID,
                    cboEngine,
                    cboEncode,
                    cboConnectionTypeOracle,
                    txtTns,
                    txtServer,
                    txtDataBaseName,
                    txtUsername,
                    txtPassword,
                    txtPort,
                    txtDescription
                ]
            });

            txtPort.controls[0].onKeyUp = function () {
                var txtPortfinalValue,
                    txtPortValue = getData2PMUI(frmDataBaseConnection.html).txtPort;
                if (/\D/.test(txtPortValue)) {
                    if (isNaN(parseInt(txtPortValue))) {
                        txtPortfinalValue = "";
                    } else {
                        txtPortfinalValue = parseInt(txtPortValue);
                    }
                    txtPort.setValue(txtPortfinalValue);
                }
            };

            btnNew = new PMUI.ui.Button({
                id: "btnNew",
                text: "Create".translate(),
                height: "36px",
                width: 100,
                style: {
                    cssClasses: [
                        'mafe-button-create'
                    ]
                },
                handler: function () {
                    dataBaseConnectionOption = "POST";
                    winFrmDataBaseConnectionShow("POST", {});
                }
            });

            grdpnlDataBaseConnection = new PMUI.grid.GridPanel({
                id: "grdpnlDataBaseConnection",
                filterable: true,
                pageSize: 10,
                width: "96%",
                style: {
                    cssClasses: ["mafe-gridPanel"]
                },
                filterPlaceholder: 'Search ...'.translate(),
                emptyMessage: 'No records found'.translate(),
                nextLabel: 'Next'.translate(),
                previousLabel: 'Previous'.translate(),
                tableContainerHeight: 374,
                customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                    return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
                },
                columns: [
                    {
                        id: 'grdpnlDataBaseConnectionButtonShow',
                        dataType: "button",
                        title: "",
                        buttonLabel: "Show ID".translate(),
                        buttonStyle: {
                            cssClasses: [
                                'mafe-button-show'
                            ]
                        },
                        width: "100px",
                        onButtonClick: function (row, grid) {
                            showUID(row.getData().dbs_uid);
                        }
                    },
                    {
                        columnData: "dbs_type",
                        title: "Type".translate(),
                        width: "100px",
                        sortable: true,
                        alignmentCell: 'left'
                    },
                    {
                        columnData: "dbs_server",
                        title: "Server".translate(),
                        width: "155px",
                        alignmentCell: 'left'
                    },
                    {
                        columnData: "dbs_database_name",
                        title: "Database Name".translate(),
                        width: "160px",
                        sortable: true,
                        alignmentCell: 'left'
                    },
                    {
                        columnData: "dbs_description",
                        title: "Description".translate(),
                        width: "200px",
                        alignmentCell: 'left'
                    },
                    {
                        id: 'grdpnlDataBaseConnectionButtonEdit',
                        dataType: "button",
                        title: "",
                        buttonLabel: "Edit".translate(),
                        buttonStyle: {
                            cssClasses: [
                                'mafe-button-edit'
                            ]
                        },
                        onButtonClick: function (row, grid) {
                            dataBaseConnectionGetRestProxy(row.getData().dbs_uid);
                        }
                    },
                    {
                        id: 'grdpnlDataBaseConnectionButtonDelete',
                        dataType: "button",
                        title: "",
                        buttonLabel: "Delete".translate(),
                        buttonStyle: {
                            cssClasses: [
                                'mafe-button-delete'
                            ]
                        },
                        onButtonClick: function (row, grid) {
                            var data = row.getData();
                            var msgWarning = new PMUI.ui.MessageWindow({
                                id: "msgWarning",
                                title: 'Database Connections'.translate(),
                                windowMessageType: 'warning',
                                width: 490,
                                message: "Do you want to delete this DB Connection?".translate(),
                                buttons: [
                                    {
                                        text: "No".translate(),
                                        handler: function () {
                                            msgWarning.close();
                                        },
                                        buttonType: "error"
                                    },
                                    {
                                        text: "Yes".translate(),
                                        handler: function () {
                                            dataBaseConnectionDeleteRestProxy(data.dbs_uid);
                                            msgWarning.close();
                                        },
                                        buttonType: "success"
                                    }
                                ]
                            });
                            msgWarning.open();
                            msgWarning.showFooter();
                        }
                    }
                ],
                dataItems: null
            });

            panelTest = new PMUI.core.Panel({
                id: 'panelTest',
                height: DEFAULT_WINDOW_HEIGHT - 71,
                display: 'inline-block'
            });

            winGrdpnlDataBaseConnection = new PMUI.ui.Window({
                id: "winGrdpnlDataBaseConnection",
                title: "Database Connections".translate(),
                width: DEFAULT_WINDOW_WIDTH,
                height: DEFAULT_WINDOW_HEIGHT,
                buttonPanelPosition: "bottom",
                buttons: [btnCancel, btnBack, btnTestConnection, btnCreate],
                onBeforeClose: function () {
                    closeClicked = true;
                    isDirtyFrmDataBaseConnection();
                }
            });

            winGrdpnlDataBaseConnection.addItem(grdpnlDataBaseConnection);
            winGrdpnlDataBaseConnection.addItem(frmDataBaseConnection);
            winGrdpnlDataBaseConnection.addItem(panelTest);

            refreshGridPanelInMainWindow();
            if (typeof listDBConnection !== "undefined") {
                winGrdpnlDataBaseConnection.open();
                frmDataBaseConnection.panel.html.style.padding = "10px";
                $('#grdpnlDataBaseConnection .pmui-textcontrol').css({'margin-top': '5px', width: '250px'});
                winGrdpnlDataBaseConnection.defineEvents();
                applyStyleWindowForm(winGrdpnlDataBaseConnection);
                winGrdpnlDataBaseConnection.footer.html.style.textAlign = 'right';
                $(btnNew.getHTML()).css({float: "right"})
                grdpnlDataBaseConnection.dom.toolbar.appendChild(btnNew.getHTML());
                btnNew.defineEvents();

                disableAllItems();
                winGrdpnlDataBaseConnection.getItems()[0].setVisible(true);
            }
        };

        PMDesigner.database.create = function () {
            PMDesigner.database();
            dataBaseConnectionOption = "POST";
            winFrmDataBaseConnectionShow("POST", {});
        };
    }()
);

(function () {
    var openTinyInMainWindow,
        dataOutPutDocument,
        openFormInMainWindow,
        messageRequired;

    PMDesigner.output = function (event) {
        var winMainOutputDocument, formOutput, rowData, updateOutPut, restClient, isDirtyFormOutput, clickedClose = true, that = this,
            setDataRow,
            clearDataRow,
            getGridOutput,
            disableAllItems,
            deleteDataRow,
            updateOutput,
            refreshGridPanelInMainWindow,
            openGridPanelInMainWindow,
            openFormForEditInMainWindow,
            editorTiny,
            outputFormDocPdfSecurityOpen,
            docMargin,
            password,
            outputFormDocPdfSecurityOwner,
            outputFormDocPdfSecurityEnabled,
            btnCloseWindowOutputDoc,
            btnSaveWindowOutputDoc,
            btnCancelTiny,
            newButtonOutput,
            gridOutput,
            winMainOutputDocument,
            btnSaveTiny,
            listOutputDocs,
            headerSettings,
            footerSettings,
            changeType,
            setMinValue,
            getFieldById;
    
        /**
         * Get field by id string, if not found return null.
         * @param {string} id
         * @returns {object}
         */
        getFieldById = function (id) {
            var fields = formOutput.getFields();
            for (var i in fields) {
                if (fields[i].id === id) {
                    return fields[i];
                }
            }
            return null;
        };

        setDataRow = function (row) {
            dataOutPutDocument = row.getData();
            rowData = row;
        };

        clearDataRow = function () {
            dataOutPutDocument = '';
            rowData = '';
        };

        isDirtyFormOutput = function () {
            var message_window;
            $("input,select,textarea").blur();
            if (formOutput.isVisible()) {
                if (formOutput.isDirty()) {
                    message_window = new PMUI.ui.MessageWindow({
                        id: "cancelMessageTriggers",
                        width: 490,
                        title: "Output Documents".translate(),
                        windowMessageType: "warning",
                        bodyHeight: 'auto',
                        message: 'Are you sure you want to discard your changes?'.translate(),
                        footerItems: [
                            {
                                text: "No".translate(),
                                handler: function () {
                                    message_window.close();
                                },
                                buttonType: "error"
                            },
                            {
                                text: "Yes".translate(),
                                handler: function () {
                                    clearDataRow();
                                    message_window.close();
                                    if (clickedClose) {
                                        tinymce.EditorManager.execCommand('mceRemoveControl', true, 'tinyeditor');
                                        winMainOutputDocument.close();
                                    } else {
                                        clearDataRow();
                                        openGridPanelInMainWindow();
                                    }

                                },
                                buttonType: "success"
                            }
                        ]
                    });
                    message_window.open();
                    message_window.showFooter();
                } else {
                    clearDataRow();
                    if (clickedClose) {
                        tinymce.EditorManager.execCommand('mceRemoveControl', true, 'tinyeditor');
                        winMainOutputDocument.close()
                    } else {
                        openGridPanelInMainWindow();
                    }
                }
            } else {
                winMainOutputDocument.close();
            }
        };
        getGridOutput = function () {
            var restClientGet = new PMRestClient({
                endpoint: 'output-documents',
                typeRequest: 'get',
                functionSuccess: function (xhr, response) {
                    listOutputDocs = response;
                    gridOutput.setDataItems(listOutputDocs);
                    gridOutput.sort('out_doc_title', 'asc');
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: "There are problems getting the output documents, please try again.".translate()
            });
            restClientGet.executeRestClient();
        };

        disableAllItems = function () {
            winMainOutputDocument.hideFooter();
            formOutput.reset();

            winMainOutputDocument.getItems()[0].setVisible(false);
            winMainOutputDocument.getItems()[1].setVisible(false);
            for (var i = 0; i <= winMainOutputDocument.getItems()[1].getItems().length - 1; i += 1) {
                winMainOutputDocument.getItems()[1].getItems()[i].setVisible(false);
            }
            btnSaveWindowOutputDoc.setVisible(false);
            btnCloseWindowOutputDoc.setVisible(false);
            btnSaveTiny.setVisible(false);
            btnCancelTiny.setVisible(false);

            winMainOutputDocument.footer.getItems()[2].setVisible(false);
        };

        refreshGridPanelInMainWindow = function () {
            disableAllItems();
            winMainOutputDocument.getItems()[0].setVisible(true);
            winMainOutputDocument.setTitle("Output Documents".translate());
            getGridOutput();
        };

        openGridPanelInMainWindow = function () {
            disableAllItems();
            winMainOutputDocument.getItems()[0].setVisible(true);
            winMainOutputDocument.setTitle("Output Documents".translate());
            $(winMainOutputDocument.body).removeClass("pmui-background");
        };

        openFormInMainWindow = function () {
            disableAllItems();
            winMainOutputDocument.showFooter();
            winMainOutputDocument.getItems()[1].setVisible(true);
            for (var i = 0; i < winMainOutputDocument.getItems()[1].getItems().length; i += 1) {
                if (winMainOutputDocument.getItems()[1].getItems()[i].type !== "PMTinyField") {
                    winMainOutputDocument.getItems()[1].getItems()[i].setVisible(true);
                }
            }
            btnSaveWindowOutputDoc.setVisible(true);
            btnCloseWindowOutputDoc.setVisible(true);
            winMainOutputDocument.footer.getItems()[2].setVisible(true);
            password.setVisible(false);
            headerSettings.setVisible(false);
            footerSettings.setVisible(false);
            footerSettings.getField('total_number_page_footer').disable();
            headerSettings.getField('total_number_page_header').disable();
            winMainOutputDocument.setTitle("Create Output Document".translate());
            winMainOutputDocument.setHeight(520);
            formOutput.panel.style.addProperties({padding: '20px 10px'});
            formOutput.setFocus();
        };

        openFormForEditInMainWindow = function (outputDocumentData) {
            disableAllItems();
            winMainOutputDocument.showFooter();
            btnSaveWindowOutputDoc.setVisible(true);
            btnCloseWindowOutputDoc.setVisible(true);
            winMainOutputDocument.footer.getItems()[1].setVisible(false);
            formOutput.setWidth(700);
            winMainOutputDocument.getItems()[1].setVisible(true);
            winMainOutputDocument.setTitle("Edit Output Document".translate());
            $(winMainOutputDocument.body).addClass("pmui-background");
            for (var i = 0; i < winMainOutputDocument.getItems()[1].getItems().length; i += 1) {
                if (winMainOutputDocument.getItems()[1].getItems()[i].type !== "PMTinyField") {
                    winMainOutputDocument.getItems()[1].getItems()[i].setVisible(true);
                }
            }

            password.setVisible(false);
            headerSettings.setVisible(false);
            footerSettings.setVisible(false);
            if (dataOutPutDocument != '' && dataOutPutDocument != undefined) {
                var dataEdit = formOutput.getFields();
                getFieldById('outputDocTitle').setValue(dataOutPutDocument['out_doc_title']);
                getFieldById('outputDocFilenameGenerated').setValue(dataOutPutDocument['out_doc_filename']);
                getFieldById('outputDocDescription').setValue(dataOutPutDocument['out_doc_description']);
                getFieldById('outputDocReportGenerator').setValue(dataOutPutDocument['out_doc_report_generator']);
                getFieldById('outputDocMedia').setValue(dataOutPutDocument['out_doc_media']);
                getFieldById('outputDocOrientation').setValue(dataOutPutDocument['out_doc_landscape']);
                getFieldById('outputDocMarginLeft').setValue(dataOutPutDocument['out_doc_left_margin']);
                getFieldById('outputDocMarginRight').setValue(dataOutPutDocument['out_doc_right_margin']);
                getFieldById('outputDocMarginTop').setValue(dataOutPutDocument['out_doc_top_margin']);
                getFieldById('outputDocMarginBottom').setValue(dataOutPutDocument['out_doc_bottom_margin']);
                getFieldById('outputDocToGenerate').setValue(dataOutPutDocument['out_doc_generate']);

                //Set data in header settings
                if (dataOutPutDocument['out_doc_header'] !== "[]") {
                    getFieldById('enableHeader').setValue(dataOutPutDocument['out_doc_header'].enableHeader ? '["1"]' : '0');
                    dataOutPutDocument['out_doc_header'].enableHeader ? headerSettings.setVisible(true) : headerSettings.setVisible(false);
                    getFieldById('headerTitle').setValue(dataOutPutDocument['out_doc_header'].title);
                    getFieldById('fontSizeHeader').setValue(dataOutPutDocument['out_doc_header'].titleFontSize);
                    getFieldById('positionXTitleHeader').setValue(dataOutPutDocument['out_doc_header'].titleFontPositionX);
                    getFieldById('positionYTitleHeader').setValue(dataOutPutDocument['out_doc_header'].titleFontPositionY);
                    getFieldById('headerLogo').setValue(dataOutPutDocument['out_doc_header'].logo);
                    getFieldById('logoWidthHeader').setValue(dataOutPutDocument['out_doc_header'].logoWidth);
                    getFieldById('positionXLogoHeader').setValue(dataOutPutDocument['out_doc_header'].logoPositionX);
                    getFieldById('positionYLogoHeader').setValue(dataOutPutDocument['out_doc_header'].logoPositionY);
                    getFieldById('pageNumberHeader').setValue(dataOutPutDocument['out_doc_header'].pageNumber ? '["1"]' : '0');
                    getFieldById('paginationTitleHeader').setValue(dataOutPutDocument['out_doc_header'].pageNumberTitle);
                    getFieldById('totalNumberPageHeader').setValue(dataOutPutDocument['out_doc_header'].pageNumberTotal ? '["1"]' : '0');
                    getFieldById('positionXNumberHeader').setValue(dataOutPutDocument['out_doc_header'].pageNumberPositionX);
                    getFieldById('positionYNumberHeader').setValue(dataOutPutDocument['out_doc_header'].pageNumberPositionY);
                    if (getFieldById('pageNumberHeader').getValue() === '["1"]') {
                        getFieldById('paginationTitleHeader').enable();
                        getFieldById('totalNumberPageHeader').enable();
                        getFieldById('positionXNumberHeader').enable();
                        getFieldById('positionYNumberHeader').enable();
                    } else {
                        getFieldById('paginationTitleHeader').disable();
                        getFieldById('totalNumberPageHeader').disable();
                        getFieldById('positionXNumberHeader').disable();
                        getFieldById('positionYNumberHeader').disable();
                    }
                }
                //Set data in footer settings
                if (dataOutPutDocument['out_doc_header'] !== "[]") {
                    getFieldById('enableFooter').setValue(dataOutPutDocument['out_doc_footer'].enableFooter ? '["1"]' : '0');
                    dataOutPutDocument['out_doc_footer'].enableFooter ? footerSettings.setVisible(true) : footerSettings.setVisible(false);
                    getFieldById('footerTitle').setValue(dataOutPutDocument['out_doc_footer'].title);
                    getFieldById('fontSizeFooter').setValue(dataOutPutDocument['out_doc_footer'].titleFontSize);
                    getFieldById('positionXTitleFooter').setValue(dataOutPutDocument['out_doc_footer'].titleFontPositionX);
                    getFieldById('positionYTitleFooter').setValue(dataOutPutDocument['out_doc_footer'].titleFontPositionY);
                    getFieldById('footerLogo').setValue(dataOutPutDocument['out_doc_footer'].logo);
                    getFieldById('logoWidthFooter').setValue(dataOutPutDocument['out_doc_footer'].logoWidth);
                    getFieldById('positionXLogoFooter').setValue(dataOutPutDocument['out_doc_footer'].logoPositionX);
                    getFieldById('positionYLogoFooter').setValue(dataOutPutDocument['out_doc_footer'].logoPositionY);
                    getFieldById('pageNumerFooter').setValue(dataOutPutDocument['out_doc_footer'].pageNumber ? '["1"]' : '0');
                    getFieldById('paginationTitleFooter').setValue(dataOutPutDocument['out_doc_footer'].pageNumberTitle);
                    getFieldById('totalNumberPageFooter').setValue(dataOutPutDocument['out_doc_footer'].pageNumberTotal ? '["1"]' : '0');
                    getFieldById('positionXNumberFooter').setValue(dataOutPutDocument['out_doc_footer'].pageNumberPositionX);
                    getFieldById('positionYNumberFooter').setValue(dataOutPutDocument['out_doc_footer'].pageNumberPositionY);
                    if (getFieldById('pageNumerFooter').getValue() === '["1"]') {
                        getFieldById('paginationTitleFooter').enable();
                        getFieldById('totalNumberPageFooter').enable();
                        getFieldById('positionXNumberFooter').enable();
                        getFieldById('positionYNumberFooter').enable();
                    } else {
                        getFieldById('paginationTitleFooter').disable();
                        getFieldById('totalNumberPageFooter').disable();
                        getFieldById('positionXNumberFooter').disable();
                        getFieldById('positionYNumberFooter').disable();
                    }
                }

                if (dataOutPutDocument["out_doc_generate"] != "DOC") {
                    getFieldById('outputDocDPFSecurity').setVisible(true);
                } else {
                    getFieldById('outputDocDPFSecurity').setVisible(false);
                }

                getFieldById('outputDocDPFSecurity').setValue(dataOutPutDocument['out_doc_pdf_security_enabled']);
                if (dataOutPutDocument['out_doc_pdf_security_enabled'] != 0) {
                    password.setVisible(true);
                }
                getFieldById('outputFormDocPdfSecurityOpen').setValue(dataOutPutDocument['out_doc_pdf_security_open_password']);
                getFieldById('outputFormDocPdfSecurityOwner').setValue(dataOutPutDocument['out_doc_pdf_security_owner_password']);

                dataOutPutDocument['out_doc_pdf_security_permissions'] = dataOutPutDocument['out_doc_pdf_security_permissions'].split("|");
                getFieldById('outputFormDocPdfSecurityPermissions').setValue(JSON.stringify(dataOutPutDocument['out_doc_pdf_security_permissions']));

                getFieldById('outputDocEnableVersioning').setValue(dataOutPutDocument['out_doc_versioning']);
                getFieldById('outputDocDestinationPath').setValue(dataOutPutDocument['out_doc_destination_path']);
                getFieldById('outputDocTags').setValue(dataOutPutDocument['out_doc_tags']);
                getFieldById('outputDocGenerateFileLink').setValue(dataOutPutDocument["out_doc_open_type"]);
            }
            winMainOutputDocument.setHeight(520);
            formOutput.panel.style.addProperties({padding: '20px 10px'});
            formOutput.setFocus();
        };

        openTinyInMainWindow = function (outputDocumentData) {
            //Fix for IE11
            var isIe11 = /Trident\/7\.0;.*rv\s*\:?\s*11/.test(navigator.userAgent);

            if (isIe11) {
                tinyMCE.isGecko = false;
            }

            //Set TinyMCE
            disableAllItems();
            winMainOutputDocument.showFooter();
            tinyEditorField = 13;
            formOutput.setVisible(true);
            formOutput.getItems()[tinyEditorField].setVisible(true);
            formOutput.setWidth(890);
            btnSaveTiny.setVisible(true);
            btnCancelTiny.setVisible(true);
            if (!editorTiny.isInitialized) {
                editorTiny.createHTML();
                editorTiny.setParameterTiny();
                editorTiny.isInitialized = true;
            } else {
                tinyMCE.execCommand('mceFocus', false, 'tinyeditor');
            }
            var dataEdit = formOutput.getFields();
            winMainOutputDocument.setTitle("Edit Output Document".translate());
            if (dataOutPutDocument != '' && dataOutPutDocument != undefined) {
                dataOutPutDocument['out_doc_template'] = (dataOutPutDocument['out_doc_template'] != null) ? dataOutPutDocument['out_doc_template'] : ' ';
                dataEdit[47].setValue(dataOutPutDocument['out_doc_template']);
                dataEdit[47].setValueTiny(dataOutPutDocument['out_doc_template']);
                dataEdit[47].setHeight(425);

                formOutput.getItems()[13].setVisible(false)
                dataEdit[47].setVisible(true);
            }
            formOutput.panel.style.addProperties({padding: '0px 10px'});
            winMainOutputDocument.setHeight(520);
            if (!editorTiny.isInitialized)
                tinymce.execCommand('mceFocus', false, 'tinyeditor');
        };

        deleteDataRow = function () {
            confirmWindow = new PMUI.ui.MessageWindow({
                id: "outputMessageWindowWarning",
                windowMessageType: 'warning',
                bodyHeight: 'auto',
                width: 490,
                title: "Output Documents".translate(),
                message: "Do you want to delete this Output Document?".translate(),
                footerItems: [
                    {
                        id: 'confirmWindowButtonNo',
                        text: "No".translate(),
                        visible: true,
                        handler: function () {
                            confirmWindow.close();
                        },
                        buttonType: "error"
                    }, {
                        id: 'confirmWindowButtonYes',
                        text: "Yes".translate(),
                        visible: true,
                        handler: function () {
                            var restClient;
                            confirmWindow.close();
                            restClient = new PMRestClient({
                                endpoint: "output-document/" + dataOutPutDocument.out_doc_uid,
                                typeRequest: 'remove',
                                functionSuccess: function (xhr, response) {
                                    refreshGridPanelInMainWindow();
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageError: "There are problems deleting the OutputDocument, please try again.".translate(),
                                messageSuccess: 'Output Document deleted successfully'.translate(),
                                flashContainer: gridOutput
                            });
                            restClient.executeRestClient();
                        },
                        buttonType: "success"
                    },
                ]
            });
            confirmWindow.open();
            confirmWindow.dom.titleContainer.style.height = "17px";
            confirmWindow.showFooter();
        };

        updateOutput = function (data) {
            dataOutPutDocument = '';
            var restClientUpdate = new PMRestClient({
                endpoint: "output-document/" + data.out_doc_uid,
                typeRequest: 'update',
                data: data,
                functionSuccess: function (xhr, response) {
                    dataOutPutDocument = data;
                    refreshGridPanelInMainWindow();
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: "There are problems updating the OutputDocument, please try again.".translate(),
                messageSuccess: 'Output Document edited successfully'.translate(),
                flashContainer: gridOutput
            });
            restClientUpdate.executeRestClient();
        };

        editorTiny = new PMTinyField({
            id: 'outputEditorTiny',
            theme: "advanced",
            plugins: "advhr,advimage,advlink,advlist,autolink,autoresize,contextmenu,directionality,emotions,example,example_dependency,fullpage,fullscreen,iespell,inlinepopups,insertdatetime,layer,legacyoutput,lists,media,nonbreaking,noneditable,pagebreak,paste,preview,print,save,searchreplace,style,tabfocus,table,template,visualblocks,visualchars,wordcount,xhtmlxtras,pmSimpleUploader,pmVariablePicker,style",
            mode: "specific_textareas",
            editorSelector: "tmceEditor",
            widthTiny: DEFAULT_WINDOW_WIDTH - 58,
            heightTiny: DEFAULT_WINDOW_HEIGHT - 100,
            directionality: 'ltr',
            verifyHtml: false,
            themeAdvancedButtons1: "pmSimpleUploader,|,pmVariablePicker,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,justifyfull,|,fontselect,fontsizeselect,|,cut,copy,paste,|,bullist,numlist,|,outdent,indent,blockquote",
            themeAdvancedButtons2: "tablecontrols,|,undo,redo,|,link,unlink,image,|,forecolor,backcolor,styleprops,|,hr,removeformat,visualaid,|,sub,sup,|,ltr,rtl,|,code",
            popupCss: "/js/tinymce/jscripts/tiny_mce/themes/advanced/skins/default/dialogTinyBpmn.css",
            contentCss: "/css/fonts.css,/fonts/styles.php",
            themeAdvancedFonts: tcPdfFonts,
            skin: "o2k7",
            skin_variant: "silver"
        });

        docMargin = new PMUI.form.FormPanel({
            fieldset: true,
            layout: 'hbox',
            legend: "Margin".translate(),
            items: [
                new PMUI.form.FormPanel({
                    fieldset: true,
                    layout: "box",
                    proportion: 0.6,
                    padding: "5px 5px",
                    items: [
                        new PMUI.form.FormPanel({
                            fieldset: true,
                            height: 200,
                            width: 170,
                            borderWidth : "3px",
                        })
                    ]
                }),
                {
                    pmType: "panel",
                    layout: 'vbox',
                    items: [
                        {
                            id: 'outputDocMarginLeft',
                            pmType: "text",
                            label: "Left".translate(),
                            required: true,
                            value: 20,
                            name: "out_doc_left_margin",
                            controlsWidth: 50,
                            labelWidth: '35%'
                        }, {
                            id: 'outputDocMarginRight',
                            pmType: "text",
                            label: "Right".translate(),
                            required: true,
                            value: 20,
                            name: "out_doc_right_margin",
                            controlsWidth: 50,
                            labelWidth: '35%'
                        }
                    ]
                },
                {
                    pmType: "panel",
                    layout: 'vbox',
                    proportion: 1.5,
                    items: [
                        {
                            id: 'outputDocMarginTop',
                            pmType: "text",
                            label: "Top".translate(),
                            required: true,
                            value: 20,
                            name: "out_doc_top_margin",
                            controlsWidth: 50,
                            labelWidth: '27%'
                        }, {
                            id: 'outputDocMarginBottom',
                            pmType: "text",
                            label: "Bottom".translate(),
                            required: true,
                            value: 20,
                            name: "out_doc_bottom_margin",
                            controlsWidth: 50,
                            labelWidth: '27%'
                        }
                    ]
                }
            ]
        });

        //Field "Open Password - Owner Password"
        outputFormDocPdfSecurityOpen = new PMUI.field.PasswordField({
            id: "outputFormDocPdfSecurityOpen",
            name: "out_doc_pdf_security_open_password",
            value: "",
            label: "Open Password ".translate(),
            required: true,
            controlsWidth: 300
        });

        outputFormDocPdfSecurityOwner = new PMUI.field.PasswordField({
            id: "outputFormDocPdfSecurityOwner",
            name: "out_doc_pdf_security_owner_password",
            value: "",
            label: "Owner Password ".translate(),
            required: true,
            controlsWidth: 300

        });

        password = new PMUI.form.FormPanel({
            width: 500,
            height: 130,
            fieldset: true,
            visible: false,
            legend: "",
            items: [
                {
                    pmType: "panel",
                    layout: 'vbox',
                    items: [
                        outputFormDocPdfSecurityOpen,
                        outputFormDocPdfSecurityOwner
                    ]
                },
                {
                    pmType: "panel",
                    layout: 'vbox',
                    items: [
                        {
                            id: 'outputFormDocPdfSecurityPermissions',
                            pmType: 'checkbox',
                            label: "Allowed Permissions".translate(),
                            value: '',
                            name: 'out_doc_pdf_security_permissions',
                            required: false,
                            controlPositioning: 'horizontal',
                            separator: "|",
                            maxDirectionOptions: 4,
                            options: [
                                {
                                    id: 'monday',
                                    label: "print".translate(),
                                    value: 'print'
                                },
                                {
                                    id: 'monday',
                                    label: "modify".translate(),
                                    value: 'modify'
                                },
                                {
                                    id: 'monday',
                                    label: "copy".translate(),
                                    value: 'copy'
                                },
                                {
                                    id: 'monday',
                                    label: "forms".translate(),
                                    value: 'forms'
                                }

                            ]
                        }
                    ]
                }
            ],
            layout: "vbox"
        });

        /**
         * Header Settings
         */
        headerSettings = new PMUI.form.FormPanel({
            fieldset: true,
            layout: 'vbox',
            name: "header_settings",
            legend: "Header Settings".translate(),
            items: [
                {
                    pmType: "panel",
                    layout: 'hbox',
                    items: [
                        new CriteriaField({
                            id: 'headerTitle',
                            pmType: "text",
                            name: 'header_title',
                            label: "Header Title".translate(),
                            labelWidth: '26%',
                            controlsWidth: 285,
                            required: false,
                            proportion: 3
                        }),
                        {
                            id: 'fontSizeHeader',
                            pmType: "text",
                            label: "Font Size".translate(),
                            required: false,
                            value: 8,
                            name: "font_size_header",
                            controlsWidth: 50,
                            labelWidth: '51%',
                            proportion: 1.2,
                            onChange: function (newVal, oldVal) {
                                if (newVal <= 7 || newVal >= 73) {
                                    this.setValue(oldVal);
                                }
                            }
                        },
                        {
                            id: 'positionXTitleHeader',
                            pmType: "text",
                            label: "Position X".translate(),
                            required: false,
                            value: 0,
                            name: "position_x_title_header",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                        {
                            id: 'positionYTitleHeader',
                            pmType: "text",
                            label: "Position Y".translate(),
                            required: false,
                            value: 0,
                            name: "position_y_title_header",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                    ]
                },
                {
                    pmType: "panel",
                    layout: 'hbox',
                    items: [
                        new CriteriaField({
                            id: 'headerLogo',
                            pmType: "text",
                            name: 'header_logo',
                            label: "Header Logo".translate(),
                            labelWidth: '26%',
                            controlsWidth: 285,
                            required: false,
                            proportion: 3
                        }),
                        {
                            id: 'logoWidthHeader',
                            pmType: "text",
                            label: "Logo Width".translate(),
                            required: false,
                            value: 0,
                            name: "logo_width_header",
                            controlsWidth: 50,
                            labelWidth: '51%',
                            proportion: 1.2
                        },
                        {
                            id: 'positionXLogoHeader',
                            pmType: "text",
                            label: "Position X".translate(),
                            required: false,
                            value: 0,
                            name: "position_x_logo_header",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                        {
                            id: 'positionYLogoHeader',
                            pmType: "text",
                            label: "Position Y".translate(),
                            required: false,
                            value: 0,
                            name: "position_y_logo_header",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                    ]
                },
                {
                    pmType: "panel",
                    layout: "hbox",
                    items: [
                        new PMUI.form.FormPanel({
                            fieldset: false,
                            layout: 'hbox',
                            legend: "Header Settings".translate(),
                            proportion: 3,
                            fontSize: 10,
                            padding: 0,
                            items: [
                                new SwitchField({
                                    id: 'pageNumberHeader',
                                    labelWidth: "50%",
                                    label: "Page Number".translate(),
                                    name: "page_number_header",
                                    value: '1',
                                    controlsWidth: 54,
                                    proportion: 0.45,
                                    controlPositioning: 'vertical',
                                    options: [
                                        {
                                            id: 'pageNumberOptionHeader',
                                            disabled: false,
                                            value: '1',
                                            selected: false
                                        }
                                    ],
                                    onChange: function (newVal, oldVal) {
                                        if (newVal === '["1"]') {
                                            headerSettings.getField('pagination_title_header').updateDisabled(false);
                                            headerSettings.getField('total_number_page_header').enable();
                                            getFieldById('totalNumberPageHeader').enable();
                                            getFieldById('positionXNumberHeader').enable();
                                            getFieldById('positionYNumberHeader').enable();
                                        } else {
                                            headerSettings.getField('pagination_title_header').updateDisabled(true);
                                            headerSettings.getField('total_number_page_header').disable();
                                            getFieldById('totalNumberPageHeader').disable();
                                            getFieldById('positionXNumberHeader').disable();
                                            getFieldById('positionYNumberHeader').disable();
                                        }
                                    }
                                }),
                                new CriteriaField({
                                    id: 'paginationTitleHeader',
                                    pmType: "text",
                                    name: 'pagination_title_header',
                                    label: "Pagination Title".translate(),
                                    labelWidth: '27%',
                                    controlsWidth: 170,
                                    required: false,
                                    disabled: true
                                }),
                            ]
                        }),
                        new SwitchField({
                            id: 'totalNumberPageHeader',
                            labelWidth: "60%",
                            label: "Total Number of Pages".translate(),
                            name: "total_number_page_header",
                            value: '1',
                            controlPositioning: 'vertical',
                            controlsWidth: 54,
                            proportion: 1.2,
                            options: [
                                {
                                    id: 'totalNumberPageOptionHeader',
                                    disabled: false,
                                    value: '1',
                                    selected: false
                                }
                            ],
                            onChange: function (newVal, oldVal) {
                            }
                        }),
                        {
                            id: 'positionXNumberHeader',
                            pmType: "text",
                            label: "Position X".translate(),
                            required: false,
                            value: 0,
                            name: "position_x_number_header",
                            controlsWidth: 50,
                            labelWidth: '62%',
                            disabled: true
                        },
                        {
                            id: 'positionYNumberHeader',
                            pmType: "text",
                            label: "Position Y".translate(),
                            required: false,
                            value: 0,
                            name: "position_y_number_header",
                            controlsWidth: 50,
                            labelWidth: '62%',
                            disabled: true
                        },
                    ]
                }
            ]
        });

        /**
         * Footer settings
         */
        footerSettings = new PMUI.form.FormPanel({
            fieldset: true,
            layout: 'vbox',
            name: "footer_settings",
            legend: "Footer Settings".translate(),
            items: [
                {
                    pmType: "panel",
                    layout: 'hbox',
                    items: [
                        new CriteriaField({
                            id: 'footerTitle',
                            pmType: "text",
                            name: 'footer_title',
                            label: "Footer Title".translate(),
                            labelWidth: '26%',
                            controlsWidth: 285,
                            required: false,
                            proportion: 3
                        }),
                        {
                            id: 'fontSizeFooter',
                            pmType: "text",
                            label: "Font Size".translate(),
                            required: false,
                            value: 8,
                            name: "font_size_footer",
                            controlsWidth: 50,
                            labelWidth: '51%',
                            proportion: 1.2,
                            onChange: function (newVal, oldVal) {
                                if (newVal <= 7 || newVal >= 73) {
                                    this.setValue(oldVal);
                                }
                            }
                        },
                        {
                            id: 'positionXTitleFooter',
                            pmType: "text",
                            label: "Position X".translate(),
                            required: false,
                            value: 0,
                            name: "position_x_title_footer",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                        {
                            id: 'positionYTitleFooter',
                            pmType: "text",
                            label: "Position Y".translate(),
                            required: false,
                            value: 0,
                            name: "position_y_title_footer",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                    ]
                },
                {
                    pmType: "panel",
                    layout: 'hbox',
                    items: [
                        new CriteriaField({
                            id: 'footerLogo',
                            pmType: "text",
                            name: 'footer_logo',
                            label: "Footer Logo".translate(),
                            labelWidth: '26%',
                            controlsWidth: 285,
                            required: false,
                            proportion: 3
                        }),
                        {
                            id: 'logoWidthFooter',
                            pmType: "text",
                            label: "Logo Width".translate(),
                            required: false,
                            value: 0,
                            name: "logo_width_footer",
                            controlsWidth: 50,
                            labelWidth: '51%',
                            proportion: 1.2
                        },
                        {
                            id: 'positionXLogoFooter',
                            pmType: "text",
                            label: "Position X".translate(),
                            required: false,
                            value: 0,
                            name: "position_x_logo_footer",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                        {
                            id: 'positionYLogoFooter',
                            pmType: "text",
                            label: "Position Y".translate(),
                            required: false,
                            value: 0,
                            name: "position_y_logo_footer",
                            controlsWidth: 50,
                            labelWidth: '62%'
                        },
                    ]
                },
                {
                    pmType: "panel",
                    layout: "hbox",
                    items: [
                        new PMUI.form.FormPanel({
                            fieldset: false,
                            layout: 'hbox',
                            legend: "Footer Settings".translate(),
                            proportion: 3,
                            fontSize: 10,
                            padding: 0,
                            items: [
                                new SwitchField({
                                    id: 'pageNumerFooter',
                                    labelWidth: "50%",
                                    label: "Page Number".translate(),
                                    name: "page_number_footer",
                                    value: '1',
                                    controlsWidth: 54,
                                    proportion: 0.45,
                                    controlPositioning: 'vertical',
                                    options: [
                                        {
                                            id: 'pageNumberOptionFooter',
                                            disabled: false,
                                            value: '1',
                                            selected: false
                                        }
                                    ],
                                    onChange: function (newVal, oldVal) {
                                        if (newVal === '["1"]') {
                                            footerSettings.getField('pagination_title_footer').updateDisabled(false);
                                            footerSettings.getField('total_number_page_footer').enable();
                                            getFieldById('totalNumberPageFooter').enable();
                                            getFieldById('positionXNumberFooter').enable();
                                            getFieldById('positionYNumberFooter').enable();
                                        } else {
                                            footerSettings.getField('pagination_title_footer').updateDisabled(true);
                                            footerSettings.getField('total_number_page_footer').disable();
                                            getFieldById('totalNumberPageFooter').disable();
                                            getFieldById('positionXNumberFooter').disable();
                                            getFieldById('positionYNumberFooter').disable();
                                        }
                                    }
                                }),
                                new CriteriaField({
                                    id: 'paginationTitleFooter',
                                    pmType: "text",
                                    name: 'pagination_title_footer',
                                    label: "Pagination Title".translate(),
                                    labelWidth: '27%',
                                    controlsWidth: 170,
                                    required: false,
                                    disabled: true
                                }),
                            ]
                        }),
                        new SwitchField({
                            id: 'totalNumberPageFooter',
                            labelWidth: "60%",
                            label: "Total Number of Pages".translate(),
                            name: "total_number_page_footer",
                            value: '1',
                            controlPositioning: 'vertical',
                            controlsWidth: 54,
                            proportion: 1.2,
                            options: [
                                {
                                    id: 'totalNumberPageOptionFooter',
                                    disabled: false,
                                    value: '1',
                                    selected: false
                                }
                            ],
                            onChange: function (newVal, oldVal) {
                            }
                        }),
                        {
                            id: 'positionXNumberFooter',
                            pmType: "text",
                            label: "Position X".translate(),
                            required: false,
                            value: 0,
                            name: "position_x_number_footer",
                            controlsWidth: 50,
                            labelWidth: '62%',
                            disabled: true
                        },
                        {
                            id: 'positionYNumberFooter',
                            pmType: "text",
                            label: "Position Y".translate(),
                            required: false,
                            value: 0,
                            name: "position_y_number_footer",
                            controlsWidth: 50,
                            labelWidth: '62%',
                            disabled: true
                        },
                    ]
                }
            ]
        });

        /**
         * Change the type of control
         */
        changeType = function () {
            headerSettings.getField('font_size_header').getControl().getHTML().type = "number";
            headerSettings.getField('position_x_title_header').getControl().getHTML().type = "number";
            headerSettings.getField('position_y_title_header').getControl().getHTML().type = "number";
            headerSettings.getField('logo_width_header').getControl().getHTML().type = "number";
            headerSettings.getField('position_x_logo_header').getControl().getHTML().type = "number";
            headerSettings.getField('position_y_logo_header').getControl().getHTML().type = "number";
            headerSettings.getField('position_x_number_header').getControl().getHTML().type = "number";
            headerSettings.getField('position_y_number_header').getControl().getHTML().type = "number";
            footerSettings.getField('font_size_footer').getControl().getHTML().type = "number";
            footerSettings.getField('position_x_title_footer').getControl().getHTML().type = "number";
            footerSettings.getField('position_y_title_footer').getControl().getHTML().type = "number";
            footerSettings.getField('logo_width_footer').getControl().getHTML().type = "number";
            footerSettings.getField('position_x_logo_footer').getControl().getHTML().type = "number";
            footerSettings.getField('position_y_logo_footer').getControl().getHTML().type = "number";
            footerSettings.getField('position_x_number_footer').getControl().getHTML().type = "number";
            footerSettings.getField('position_y_number_footer').getControl().getHTML().type = "number";
        };

        /**
         * Set a minimum value to avoid entering negative numbers
         */
        setMinValue = function () {
            headerSettings.getField('position_x_title_header').getControl().getHTML().min = "0";
            headerSettings.getField('position_y_title_header').getControl().getHTML().min = "0";
            headerSettings.getField('logo_width_header').getControl().getHTML().min = "0";
            headerSettings.getField('position_x_logo_header').getControl().getHTML().min = "0";
            headerSettings.getField('position_y_logo_header').getControl().getHTML().min = "0";
            headerSettings.getField('position_x_number_header').getControl().getHTML().min = "0";
            headerSettings.getField('position_y_number_header').getControl().getHTML().min = "0";
            footerSettings.getField('position_x_title_footer').getControl().getHTML().min = "0";
            footerSettings.getField('position_y_title_footer').getControl().getHTML().min = "0";
            footerSettings.getField('logo_width_footer').getControl().getHTML().min = "0";
            footerSettings.getField('position_x_logo_footer').getControl().getHTML().min = "0";
            footerSettings.getField('position_y_logo_footer').getControl().getHTML().min = "0";
            footerSettings.getField('position_x_number_footer').getControl().getHTML().min = "0";
            footerSettings.getField('position_y_number_footer').getControl().getHTML().min = "0";
        };

        //Field "PDF security"
        outputFormDocPdfSecurityEnabled = new PMUI.field.DropDownListField({
            id: "outputDocDPFSecurity",
            name: "out_doc_pdf_security_enabled",
            label: "PDF security".translate(),
            labelWidth: "27%",
            valueType: "number",
            visible: false,

            options: [
                {
                    value: 0,
                    label: "Disabled".translate(),
                    selected: true
                },
                {
                    value: 1,
                    label: "Enabled".translate()

                }
            ],

            controlsWidth: 100,

            onChange: function (newValue, prevValue) {
                var visible = true;

                if (newValue == 0) {
                    visible = false;

                    outputFormDocPdfSecurityOpen.setValue("");
                    outputFormDocPdfSecurityOwner.setValue("");
                }

                password.setVisible(visible);
            }
        });

        //the form is 700px width, but with the tiny grows to 890
        formOutput = new PMUI.form.Form({
            id: 'outputForm',
            name: 'outputForm',
            fieldset: true,
            title: "",
            visibleHeader: false,
            width: DEFAULT_WINDOW_WIDTH - 43,
            items: [
                {
                    id: 'outputDocTitle',
                    pmType: "text",
                    name: 'out_doc_title',
                    label: "Title".translate(),
                    labelWidth: '27%',
                    controlsWidth: 300,
                    required: true
                },
                new CriteriaField({
                    id: 'outputDocFilenameGenerated',
                    pmType: "text",
                    name: 'out_doc_filename',
                    label: "Filename generated".translate(),
                    labelWidth: '27%',
                    controlsWidth: 300,
                    required: true
                }),
                {
                    id: 'outputDocDescription',
                    pmType: "textarea",
                    name: 'out_doc_description',
                    label: "Description".translate(),
                    labelWidth: '27%',
                    controlsWidth: 500,
                    rows: 100,
                    style: {cssClasses: ['mafe-textarea-resize']}
                },
                {
                    id: 'outputDocReportGenerator',
                    pmType: "dropdown",
                    name: 'out_doc_report_generator',
                    label: "Report Generator".translate(),
                    labelWidth: '27%',
                    require: true,
                    controlsWidth: 165,
                    options: [
                        {
                            label: "TCPDF".translate(),
                            value: "TCPDF"
                        },
                        {
                            label: "HTML2PDF (Old Version)".translate(),
                            value: "HTML2PDF"
                        }
                    ],
                    value: "TCPDF"
                },
                {
                    id: 'outputDocMedia',
                    pmType: "dropdown",
                    name: 'out_doc_media',
                    label: "Media".translate(),
                    labelWidth: '27%',
                    controlsWidth: 165,
                    options: [
                        {label: "Letter".translate(), value: "Letter"},
                        {label: "Legal".translate(), value: "Legal"},
                        {label: "Executive".translate(), value: "Executive"},
                        {label: "B5".translate(), value: "B5"},
                        {label: "Folio".translate(), value: "Folio"},
                        {label: "A0Oversize".translate(), value: "A0Oversize"},
                        {label: "A0".translate(), value: "A0"},
                        {label: "A1".translate(), value: "A1"},
                        {label: "A2".translate(), value: "A2"},
                        {label: "A3".translate(), value: "A3"},
                        {label: "A4".translate(), value: "A4"},
                        {label: "A5".translate(), value: "A5"},
                        {label: "A6".translate(), value: "A6"},
                        {label: "A7".translate(), value: "A7"},
                        {label: "A8".translate(), value: "A8"},
                        {label: "A9".translate(), value: "A9"},
                        {label: "A10", value: "A10"},
                        {label: "Screenshot640".translate(), value: "SH640"},
                        {label: "Screenshot800".translate(), value: "SH800"},
                        {label: "Screenshot1024".translate(), value: "SH1024"}
                    ]
                },
                {
                    id: 'outputDocOrientation',
                    pmType: "dropdown",
                    name: 'out_doc_landscape',
                    labelWidth: '27%',
                    label: "Orientation".translate(),
                    controlsWidth: 165,
                    options: [
                        {
                            label: "Portrait".translate(),
                            selected: true,
                            value: 0
                        },
                        {
                            label: "Landscape".translate(),
                            value: 1
                        }
                    ],
                    valueType: 'number'
                },
                docMargin,
                new SwitchField({
                    id: 'enableHeader',
                    labelWidth: "6%",
                    label: "Header".translate(),
                    name: "enableHeader",
                    value: '0',
                    controlsWidth: 54,
                    controlPositioning: 'vertical',
                    options: [
                        {
                            id: 'enableHeader',
                            disabled: false,
                            value: '1',
                            selected: false
                        }
                    ],
                    onChange: function (newVal, oldVal) {
                        if (newVal === '["1"]') {
                            headerSettings.setVisible(true);
                        } else {
                            headerSettings.setVisible(false);
                        }
                    }
                }),
                headerSettings,
                new SwitchField({
                    id: 'enableFooter',
                    labelWidth: "6%",
                    label: "Footer".translate(),
                    name: "enableFooter",
                    value: '0',
                    controlsWidth: 54,
                    controlPositioning: 'vertical',
                    options: [
                        {
                            id: 'enableFooter',
                            disabled: false,
                            value: '1',
                            selected: false
                        }
                    ],
                    onChange: function (newVal, oldVal) {
                        if (newVal === '["1"]') {
                            footerSettings.setVisible(true);
                        } else {
                            footerSettings.setVisible(false);
                        }
                    }
                }),
                footerSettings,
                {
                    id: 'outputDocToGenerate',
                    pmType: "dropdown",
                    name: 'out_doc_generate',
                    controlsWidth: 70,
                    labelWidth: '27%',
                    label: "Output Document to Generate".translate(),
                    options: [
                        {
                            label: "Both".translate(),
                            value: "BOTH"
                        },
                        {
                            label: "Doc".translate(),
                            value: "DOC"
                        },
                        {
                            label: "Pdf".translate(),
                            value: "PDF"
                        }
                    ],
                    value: "BOTH",
                    onChange: function (newValue, prevValue) {
                        if (newValue == "DOC") {
                            outputFormDocPdfSecurityEnabled.setVisible(false);
                            outputFormDocPdfSecurityEnabled.setValue(0);
                            password.setVisible(false);
                            outputFormDocPdfSecurityOpen.setValue("");
                            outputFormDocPdfSecurityOwner.setValue("");
                        } else {
                            outputFormDocPdfSecurityEnabled.setVisible(true);
                        }
                    }
                },
                outputFormDocPdfSecurityEnabled,
                password,
                {
                    id: 'outputDocEnableVersioning',
                    pmType: "dropdown",
                    name: "out_doc_versioning",
                    controlsWidth: 70,
                    labelWidth: '27%',
                    label: 'Enable versioning'.translate(),
                    options: [
                        {
                            label: "Yes".translate(),
                            value: 1
                        },
                        {
                            label: "No".translate(),
                            selected: true,
                            value: 0
                        }
                    ],
                    valueType: 'number'
                },
                new CriteriaField({
                    id: 'outputDocDestinationPath',
                    pmType: "text",
                    name: "out_doc_destination_path",
                    labelWidth: '27%',
                    label: "Destination Path".translate(),
                    controlsWidth: 340
                }),
                new CriteriaField({
                    id: 'outputDocTags',
                    pmType: "text",
                    name: "out_doc_tags",
                    labelWidth: '27%',
                    label: "Tags".translate(),
                    controlsWidth: 340
                }),
                {
                    id: "outputDocGenerateFileLink",
                    name: "cboByGeneratedFile",
                    pmType: "dropdown",
                    controlsWidth: 155,
                    labelWidth: "27%",
                    label: "By clicking on the generated file link".translate(),

                    options: [
                        {
                            value: 0,
                            label: "Open the file".translate()
                        },
                        {
                            label: "Download the file".translate(),
                            value: 1,
                            selected: true
                        }
                    ],

                    valueType: "number"
                }
            ],
            style: {
                cssProperties: {
                    marginLeft: '20px'
                }
            }
        });

        formOutput.style.addProperties({marginLeft: '20px'});
        gridOutput = new PMUI.grid.GridPanel({
            id: 'gridOutput',
            pageSize: 10,
            width: "96%",
            style: {
                cssClasses: ["mafe-gridPanel"]
            },
            filterPlaceholder: 'Search ...'.translate(),
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            tableContainerHeight: 374,
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            columns: [
                {
                    id: 'gridOutputButtonShow',
                    title: '',
                    dataType: 'button',
                    buttonLabel: 'Show ID'.translate(),
                    columnData: "out_doc_uid",
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-show'
                        ]
                    },
                    onButtonClick: function (row, grid) {
                        var data = row.getData();
                        showUID(data.out_doc_uid);
                    }
                },
                {
                    title: 'Title'.translate(),
                    dataType: 'string',
                    width: '392px',
                    alignment: "left",
                    columnData: "out_doc_title",
                    sortable: true,
                    alignmentCell: 'left'
                },
                {
                    title: 'Type'.translate(),
                    dataType: 'string',
                    width: '100px',
                    alignmentCell: 'left',
                    columnData: "out_doc_type",
                    sortable: true
                },
                {
                    id: 'gridOutputButtonEdit',
                    title: '',
                    dataType: 'button',
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-edit'
                        ]
                    },
                    buttonLabel: 'Edit'.translate(),
                    onButtonClick: function (row, grid) {
                        messageRequired.hide();
                        setDataRow(row);
                        openFormForEditInMainWindow();
                    }
                },
                {
                    id: 'gridOutputButtonProperties',
                    title: '',
                    dataType: 'button',
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-properties'
                        ]
                    },
                    buttonLabel: 'Open Editor'.translate(),
                    onButtonClick: function (row, grid) {
                        setDataRow(row);
                        openTinyInMainWindow(row);
                    }
                },
                {
                    id: 'gridOutputButtonDelete',
                    title: '',
                    dataType: 'button',
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-delete'
                        ]
                    },
                    buttonLabel: 'Delete'.translate(),
                    onButtonClick: function (row, grid) {
                        setDataRow(row);
                        deleteDataRow();
                    }
                }
            ]
        });

        /**
         * Filter data of header settings
         * @param {Array} data
         * @return {Array}
         */
        setDataHeaderSettings = function (data) {
            var headerData = {
                "logo": data.header_logo,
                "logoWidth": data.logo_width_header,
                "logoPositionX": data.position_x_logo_header,
                "logoPositionY": data.position_y_logo_header,
                "title": data.header_title,
                "titleFontSize": data.font_size_header,
                "titleFontPositionX": data.position_x_title_header,
                "titleFontPositionY": data.position_y_title_header,
                "pageNumber": headerSettings.getField('page_number_header').value === '["1"]',
                "pageNumberTitle": headerSettings.getField('pagination_title_header').value,
                "pageNumberTotal": headerSettings.getField('total_number_page_header').value === '["1"]',
                "pageNumberPositionX": headerSettings.getField('position_x_number_header').value,
                "pageNumberPositionY": headerSettings.getField('position_y_number_header').value,
                "enableHeader": data.enableHeader === '["1"]'
            };
            //it is necessary to clean the data because it is already in the json
            delete data.header_logo;
            delete data.logo_width_header;
            delete data.position_x_logo_header;
            delete data.position_y_logo_header;
            delete data.header_title;
            delete data.font_size_header;
            delete data.position_x_title_header;
            delete data.position_y_title_header;
            delete data.page_number_header;
            delete data.pagination_title_header;
            delete data.total_number_page_header;
            delete data.position_x_number_header;
            delete data.position_y_number_header;
            delete data.enableHeader;
            return headerData;
        };

        /**
         * Filter data of footer settings
         * @param {Array} data
         * @return {Array}
         */
         setDataFooterSettings = function (data) {
            var footerData = {
                "logo": data.footer_logo,
                "logoWidth": data.logo_width_footer,
                "logoPositionX": data.position_x_logo_footer,
                "logoPositionY": data.position_y_logo_footer,
                "title": data.footer_title,
                "titleFontSize": data.font_size_footer,
                "titleFontPositionX": data.position_x_title_footer,
                "titleFontPositionY": data.position_y_title_footer,
                "pageNumber": footerSettings.getField('page_number_footer').value === '["1"]',
                "pageNumberTitle": footerSettings.getField('pagination_title_footer').value,
                "pageNumberTotal": footerSettings.getField('total_number_page_footer').value === '["1"]',
                "pageNumberPositionX": footerSettings.getField('position_x_number_footer').value,
                "pageNumberPositionY": footerSettings.getField('position_y_number_footer').value,
                "enableFooter": data.enableFooter === '["1"]'
            };
            //it is necessary to clean the data because it is already in the json
            delete data.footer_logo;
            delete data.logo_width_footer;
            delete data.position_x_logo_footer;
            delete data.position_y_logo_footer;
            delete data.footer_title;
            delete data.font_size_footer;
            delete data.position_x_title_footer;
            delete data.position_y_title_footer;
            delete data.page_number_footer;
            delete data.pagination_title_footer;
            delete data.total_number_page_footer;
            delete data.position_x_number_footer;
            delete data.position_y_number_footer;
            delete data.enableFooter;
            return footerData;
        };

        btnSaveWindowOutputDoc = new PMUI.ui.Button({
            id: 'btnSaveWindowOutputDoc',
            text: "Save".translate(),
            handler: function () {
                var itemOutPut;
                if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
                    itemOutPut = getData2PMUI(formOutput.html);
                } else {
                    itemOutPut = formOutput.getData();
                }
                if (itemOutPut.out_doc_title != "" && itemOutPut.out_doc_filename != "") {

                    itemOutPut['out_doc_type'] = "HTML";

                    var items = jQuery.parseJSON(itemOutPut['out_doc_pdf_security_permissions']);
                    itemOutPut['out_doc_pdf_security_permissions'] = '';
                    for (var i = 0; i < items.length; i += 1) {
                        itemOutPut['out_doc_pdf_security_permissions'] += (i == 0) ? items[i] : '|' + items[i];
                    }

                    itemOutPut["out_doc_landscape"] = parseInt(itemOutPut["out_doc_landscape"]);
                    itemOutPut["out_doc_pdf_security_enabled"] = parseInt(itemOutPut["out_doc_pdf_security_enabled"]);
                    itemOutPut["out_doc_versioning"] = parseInt(itemOutPut["out_doc_versioning"]);
                    itemOutPut["out_doc_open_type"] = parseInt(getData2PMUI(formOutput.html).cboByGeneratedFile);
                    itemOutPut["out_doc_header"] = setDataHeaderSettings(itemOutPut);
                    itemOutPut["out_doc_footer"] = setDataFooterSettings(itemOutPut);
                    if (dataOutPutDocument != '' && dataOutPutDocument != undefined) {
                        itemOutPut['out_doc_uid'] = dataOutPutDocument.out_doc_uid;
                        restClient = new PMRestClient({
                            endpoint: "output-document/" + dataOutPutDocument.out_doc_uid,
                            typeRequest: 'update',
                            data: itemOutPut,
                            functionSuccess: function (xhr, response) {
                                dataOutPutDocument = itemOutPut;
                                refreshGridPanelInMainWindow();
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: "There are problems updating the OutputDocument, please try again.".translate(),
                            messageSuccess: 'Output Document edited successfully'.translate(),
                            flashContainer: gridOutput
                        });
                        restClient.executeRestClient();
                    } else {
                        if (1 === parseInt(itemOutPut.out_doc_pdf_security_enabled) && (itemOutPut.out_doc_pdf_security_open_password.trim() === "" || itemOutPut.out_doc_pdf_security_owner_password.trim() === "")) {
                            password.getItems()[0].getItems()[0].isValid();
                            password.getItems()[0].getItems()[1].isValid();
                            return false;
                        }
                        itemOutPut['out_doc_uid'] = '';
                        restClient = new PMRestClient({
                            endpoint: "output-document",
                            typeRequest: 'post',
                            data: itemOutPut,
                            functionSuccess: function (xhr, response) {
                                dataOutPutDocument = itemOutPut;
                                refreshGridPanelInMainWindow();
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: "There are problems saved the OutputDocument, please try again.".translate(),
                            messageSuccess: 'Output Document saved successfully'.translate(),
                            flashContainer: gridOutput
                        });
                        restClient.executeRestClient();
                    }
                    clearDataRow();
                } else {
                    formOutput.getField("out_doc_title").isValid();
                    formOutput.getField("out_doc_filename").isValid();
                }
            },
            buttonType: 'success'
        });

        btnCloseWindowOutputDoc = new PMUI.ui.Button({
            id: 'btnCloseWindowOutputDoc',
            text: "Cancel".translate(),
            handler: function () {
                clickedClose = false;
                isDirtyFormOutput();
            },
            buttonType: 'error'
        });

        newButtonOutput = new PMUI.ui.Button({
            id: 'outputButtonNew',
            text: 'Create'.translate(),
            height: "36px",
            width: 100,
            style: {
                cssClasses: [
                    'mafe-button-create'
                ]
            },
            handler: function () {
                clearDataRow();
                openFormInMainWindow();
            }
        });

        btnCancelTiny = new PMUI.ui.Button({
            id: 'btnCloseTiny',
            text: 'Cancel'.translate(),
            handler: function () {
                /*if (typeof dataOutPutDocument['externalType'] != 'undefined' && dataOutPutDocument['externalType']) {
                 winMainOutputDocument.close();
                 return;
                 }*/
                PMDesigner.hideAllTinyEditorControls();
                clickedClose = false;
                isDirtyFormOutput();
            },
            buttonType: 'error'
        });

        btnSaveTiny = new PMUI.ui.Button({
            id: 'btnSaveTiny',
            text: 'Save'.translate(),
            handler: function () {
                PMDesigner.hideAllTinyEditorControls();
                dataOutPutDocument['out_doc_template'] = tinyMCE.activeEditor.getContent();
                updateOutput(dataOutPutDocument);
                if (typeof dataOutPutDocument['externalType'] != 'undefined' && dataOutPutDocument['externalType']) {
                    winMainOutputDocument.close();
                    return;
                }
                clearDataRow();
                refreshGridPanelInMainWindow();
            },
            buttonType: 'success'
        });

        winMainOutputDocument = new PMUI.ui.Window({
            id: "winMainOutputDocument",
            title: "Output Documents".translate(),
            height: DEFAULT_WINDOW_HEIGHT,
            width: DEFAULT_WINDOW_WIDTH,
            buttonPanelPosition: "bottom",
            onBeforeClose: function () {
                PMDesigner.hideAllTinyEditorControls();
                clickedClose = true;
                isDirtyFormOutput();
            },
            footerItems: [
                btnCancelTiny,
                btnSaveTiny,
                btnCloseWindowOutputDoc,
                btnSaveWindowOutputDoc]
        });

        formOutput.addItem(editorTiny);
        formOutput.footer.setVisible(false);

        winMainOutputDocument.addItem(gridOutput);
        winMainOutputDocument.addItem(formOutput);

        refreshGridPanelInMainWindow();

        validateKeysField(docMargin.getField('out_doc_left_margin').getControls()[0].getHTML(), ['isbackspace', 'isnumber']);
        validateKeysField(docMargin.getField('out_doc_right_margin').getControls()[0].getHTML(), ['isbackspace', 'isnumber']);
        validateKeysField(docMargin.getField('out_doc_top_margin').getControls()[0].getHTML(), ['isbackspace', 'isnumber']);
        validateKeysField(docMargin.getField('out_doc_bottom_margin').getControls()[0].getHTML(), ['isbackspace', 'isnumber']);
        changeType();
        setMinValue();

        if (typeof listOutputDocs !== "undefined") {
            winMainOutputDocument.open();
            $('#gridOutput .pmui-textcontrol').css({'margin-top': '5px', width: '250px'});
            messageRequired = $(document.getElementById("requiredMessage"));
            applyStyleWindowForm(winMainOutputDocument);

            editorTiny.isInitialized = false;
            winMainOutputDocument.footer.html.style.textAlign = 'right';

            gridOutput.dom.toolbar.appendChild(newButtonOutput.getHTML());
            newButtonOutput.defineEvents();
            winMainOutputDocument.defineEvents();
            disableAllItems();
            winMainOutputDocument.getItems()[0].setVisible(true);
        }
    };

    PMDesigner.output.showTiny = function (uid) {
        getItemdOutput = function () {
            var restClientGet = new PMRestClient({
                endpoint: 'output-document/' + uid,
                typeRequest: 'get',
                functionSuccess: function (xhr, response) {
                    dataOutPutDocument = response;
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: "There are problems getting the output documents, please try again.".translate()
            });
            restClientGet.executeRestClient();
        };
        getItemdOutput();
        dataOutPutDocument['externalType'] = true;
        openTinyInMainWindow(dataOutPutDocument);
    };

    PMDesigner.output.create = function () {
        openFormInMainWindow();
    };
}());

(
    function () {
        var iframeRT,
            reportWindow,
            pathSrc;

        PMDesigner.reporttable = function (event) {
            reportWindow = new PMUI.ui.Window({
                id: 'reportTableWindow',
                title: "Report Tables".translate(),
                width: DEFAULT_WINDOW_WIDTH,
                height: DEFAULT_WINDOW_HEIGHT
            });

            pathSrc = window.parent.location;

            iframeRT = new PMIframe({
                id: 'reporTableIframe',
                src: window.location.href.split("/")[0] + "//" + pathSrc.host + "/sys" + WORKSPACE + "/" + LANG + "/" + SKIN + "/pmTables?PRO_UID=" + PMDesigner.project.id + "&flagProcessmap=1",
                width: DEFAULT_WINDOW_WIDTH,
                height: DEFAULT_WINDOW_HEIGHT - 36,
                scrolling: 'no',
                frameborder: '0'
            });

            reportWindow.addItem(iframeRT);
            reportWindow.open();
            reportWindow.setBodyPadding(0);
        };

        PMDesigner.reporttable.create = function () {
            pathSrc = window.parent.location;
            reportWindow.clearItems();
            iframeRT = new PMIframe({
                id: 'reporTableIframe',
                src: window.location.href.split("/")[0] + "//" + pathSrc.host + "/sys" + WORKSPACE + "/" + LANG + "/" + SKIN + "/pmTables/edit?PRO_UID=" + PMDesigner.project.id + "&tableType=report&flagProcessmap=1",
                width: DEFAULT_WINDOW_WIDTH,
                height: DEFAULT_WINDOW_HEIGHT - 36,
                scrolling: 'no',
                frameborder: '0'
            });
            reportWindow.addItem(iframeRT);
            reportWindow.open();
            reportWindow.setBodyPadding(0);
        }

    }()
);
(function () {
    $ctrlSpaceMessage = $("<p class='ctrlSpaceMessage'>" + "Press".translate() + " <strong>ctrl+space</strong> " + "to get the function list".translate() + ".</p>");
    var btnCopyImport, openFormCustom, formEditTriggerCustom;
    var triggerOriginDataForUpdate = {};
    PMDesigner.trigger = function (event) {
        var listTriggers,
            clickedClose = true,
            message_ErrorWindow,
            flagChanges,
            isDirtyFormTrigger,
            gridListTrigger,
            getListTrigger,
            addNumberTriggerWizard,
            newTriggerOptions,
            allTreesItems,
            buttonNew,
            buttonCopy,
            buttonWizard,
            openListTriggers,
            openFormWizard,
            openFormWizardEditMode,
            openFormCopy,
            openFormEditCode,
            openNewTriggerOptions,
            listProjects,
            getListProjects,
            triggerSelectedData,
            formCopyTrigger,
            codMirr,
            formEditTriggerWizard,
            sepInputs,
            labelInputs,
            paramPanel,
            sepOutputs,
            labelOutputs,
            returnPanel,
            parameterItems,
            returnItems,
            treeNewTrigger,
            accordionNewTrigger,
            updateCustom,
            checkIfValuesAreEqual,
            buttonSave,
            copyButton,
            applyButton,
            btnEditSourceCode,
            buttonCancel,
            editCode,
            formEditCode,
            triggerWindow,
            formcustom;

        message_ErrorWindow = new PMUI.ui.MessageWindow({
            id: "errorMessage",
            width: 490,
            windowMessageType: 'error',
            title: "Triggers".translate(),
            message: "This is an error message.".translate(),
            footerItems: [
                {
                    text: 'OK'.translate(),
                    handler: function () {
                        message_ErrorWindow.close();
                    },
                    buttonType: "success"
                }
            ]
        });

        isDirtyFormTrigger = function () {
            $("input,select,textarea").blur();
            $("div.pmui-window-body.pmui-background").css('overflow', '');
            var formcustom = triggerWindow.getItems()[1];
            var formwizard = triggerWindow.getItems()[2];
            var formcopy = triggerWindow.getItems()[3];
            var formeditcode = triggerWindow.getItems()[4];
            var accordionnewtrigger = triggerWindow.getItems()[5];
            var flag = false;

            var finalData = {
                tri_uid: getData2PMUI(formEditTriggerCustom.html).uid,
                tri_title: getData2PMUI(formEditTriggerCustom.html).title,
                tri_description: getData2PMUI(formEditTriggerCustom.html).description,
                tri_webbot: getData2PMUI(formEditTriggerCustom.html).code
            };

            if (formcustom.isVisible() == true) {
                flag = (checkIfValuesAreEqual(triggerOriginDataForUpdate, finalData)) ? false : true;
            } else if (formwizard.isVisible() == true) {
                flag = formEditTriggerWizard.isDirty();
            } else if (formcopy.isVisible() == true) {
                flag = formCopyTrigger.isDirty();
                if (!flag) {
                    $('.ctrlSpaceMessage').remove();
                }
            } else if (formeditcode.isVisible() == true) {
                flag = formeditcode.isDirty();
                var flagFormCustom = (checkIfValuesAreEqual(triggerOriginDataForUpdate, finalData)) ? false : true;
                if (!flag && formeditcode.getItems()[0].controls[0].value != "" || flagFormCustom) {
                    flag = true;
                }
            }

            if (flag == true) {
                var message_window = new PMUI.ui.MessageWindow({
                    id: "cancelMessageTriggers",
                    title: "Triggers".translate(),
                    windowMessageType: 'warning',
                    width: 490,
                    message: 'Are you sure you want to discard your changes?'.translate(),
                    footerItems: [
                        {
                            text: "No".translate(),
                            handler: function () {
                                message_window.close();
                            },
                            buttonType: "error"
                        }, {
                            text: "Yes".translate(),
                            handler: function () {
                                triggerOriginDataForUpdate = {};
                                var formcustom = triggerWindow.getItems()[1];
                                var formwizard = triggerWindow.getItems()[2];
                                var formcopy = triggerWindow.getItems()[3];
                                var formeditcode = triggerWindow.getItems()[4];

                                if (formcustom.isVisible() == true) {
                                    var uidInForm = formEditTriggerCustom.getFields()[0].getValue();
                                    formEditTriggerCustom.reset();
                                    openListTriggers();
                                } else if (formwizard.isVisible() == true) {
                                    var uidInForm = formEditTriggerWizard.getFields()[0].getValue();
                                    formEditTriggerWizard.reset();
                                    openListTriggers();
                                } else if (formcopy.isVisible() == true) {
                                    $('.ctrlSpaceMessage').remove();
                                    formCopyTrigger.reset();
                                    openListTriggers();
                                } else if (formeditcode.isVisible() == true) {
                                    formeditcode.reset();
                                    openFormCustom("Edit".translate());
                                }
                                message_window.close();
                                if (clickedClose) {
                                    triggerWindow.close();
                                }
                            },
                            buttonType: "success"
                        }
                    ]
                });
                message_window.open();
                message_window.showFooter();
            } else {
                var formcustom = triggerWindow.getItems()[1];
                var formwizard = triggerWindow.getItems()[2];
                var formcopy = triggerWindow.getItems()[3];
                var formeditcode = triggerWindow.getItems()[4];
                var accordionnewtrigger = triggerWindow.getItems()[5];

                if (formcustom.isVisible() == true) {
                    var uidInForm = formEditTriggerCustom.getFields()[0].getValue();
                    formEditTriggerCustom.reset();
                    openListTriggers();
                } else if (formwizard.isVisible() == true) {
                    var uidInForm = formEditTriggerWizard.getFields()[0].getValue();
                    formEditTriggerWizard.reset();
                    openListTriggers();
                } else if (formcopy.isVisible() == true) {
                    formCopyTrigger.reset();
                    openListTriggers();
                } else if (formeditcode.isVisible() == true) {
                    formeditcode.reset();
                    openFormCustom("Edit".translate());
                } else if (accordionnewtrigger.isVisible() == true) {
                    openListTriggers();
                }
                if (clickedClose) {
                    triggerWindow.close();
                }
            }
        };
        //GRID List Case Scheduler
        gridListTrigger = new PMUI.grid.GridPanel({
            id: "listTriggers",
            pageSize: 10,
            width: "96%",
            style: {
                cssClasses: ["mafe-gridPanel"]
            },
            filterPlaceholder: 'Search ...'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            tableContainerHeight: 374,
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            columns: [
                {
                    id: 'listTriggersButtonShow',
                    title: '',
                    dataType: 'button',
                    searchable: false,
                    buttonLabel: 'Show ID'.translate(),
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-show'
                        ]
                    },
                    id: 'copyuid',
                    onButtonClick: function (row, grid) {
                        var dataRow = row.getData();
                        messageWindow = new PMUI.ui.MessageWindow({
                            id: 'dynaformMessageWindowUID',
                            windowMessageType: 'info',
                            width: 490,
                            title: "Triggers".translate(),
                            message: dataRow.tri_uid,
                            footerItems: [
                                {
                                    text: 'OK'.translate(),
                                    handler: function () {
                                        messageWindow.close();
                                    },
                                    buttonType: "success"
                                }
                            ]
                        });
                        messageWindow.setTitle("ID".translate());
                        messageWindow.open();
                        messageWindow.showFooter();
                        $(messageWindow.dom.icon).removeClass();
                    }
                },
                {
                    title: 'Title'.translate(),
                    id: "title",
                    dataType: 'string',
                    width: "407px",
                    visible: true,
                    columnData: "tri_title",
                    searcheable: true,
                    sortable: true,
                    alignmentCell: 'left'
                },
                {
                    title: 'Type'.translate(),
                    id: "type",
                    dataType: 'string',
                    width: "225px",
                    visible: true,
                    alignmentCell: 'left',
                    columnData: function (data) {
                        if (typeof(data.tri_param) == "object" && typeof(data.tri_param.params) == "object") {
                            var wizardData = data.tri_param.params;

                            return wizardData.LIBRARY_NAME;
                        } else {
                            return "Custom";
                        }
                    },
                    searcheable: true,
                    sortable: true
                },
                {
                    id: "editButton",
                    title: '',
                    dataType: 'button',
                    messageTooltip: "Edit".translate(),
                    buttonLabel: "Edit".translate(),
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-edit'
                        ]
                    },
                    onButtonClick: function (row, grid) {
                        triggerOriginDataForUpdate = {};
                        var data = row.getData();
                        triggerOriginDataForUpdate = data;
                        var fields;
                        if (data.tri_param == "") {

                            openFormCustom("Edit".translate());
                            formEditTriggerCustom.showFooter();

                            var codeMirrorControl, cmControlCopyTrigger;
                            codeMirrorControl = formEditTriggerCustom.getItems()[1].controls[0].cm;

                            if (codeMirrorControl != undefined) {
                                codeMirrorControl.setSize(580, 160);
                            }
                            formEditTriggerCustom.getItems()[1].setHeight(170);
                            fields = formEditTriggerCustom.getItems()[0];
                            fields.getItems()[0].setValue(data.tri_uid);
                            fields.getItems()[1].setValue(data.tri_title);
                            fields.getItems()[2].setValue(data.tri_description);
                            formEditTriggerCustom.getItems()[1].setValue(data.tri_webbot);

                            codeMirrorControl.setValue(data.tri_webbot);
                            codeMirrorControl.refresh();
                        } else {
                            openFormWizardEditMode();

                            var wizardData = data.tri_param.params;

                            var lib = wizardData.LIBRARY_CLASS;
                            lib = lib.split('.');
                            lib = lib[1];
                            fields = formEditTriggerWizard.getFields();
                            fields[0].setValue(data.tri_uid);
                            fields[1].setValue(lib);
                            fields[2].setValue(wizardData.PMFUNTION_NAME);
                            fields[3].setValue(wizardData.LIBRARY_NAME + " (" + wizardData.PMFUNTION_LABEL + ")");
                            fields[4].setValue(data.tri_title);
                            fields[5].setValue(data.tri_description);
                            fields[6].setValue(data.tri_webbot);

                            var inputItems = [];
                            var outputItems = [];

                            restClient = new PMRestClient({
                                endpoint: "trigger-wizard/" + lib + "/" + wizardData.PMFUNTION_NAME,
                                typeRequest: 'get',
                                functionSuccess: function (xhr, response) {
                                    if (response.fn_params.input != undefined) {
                                        for (j = 0; j < response.fn_params.input.length; j++) {
                                            var nameInput = response.fn_params.input[j].name;

                                            var inp = new CriteriaField({
                                                id: nameInput,
                                                pmType: "text",
                                                name: nameInput,
                                                label: response.fn_params.input[j].label,
                                                value: wizardData[nameInput].toString(),
                                                controlsWidth: 400,
                                                labelWidth: '27%',
                                                helper: response.fn_params.input[j].description,
                                                required: response.fn_params.input[j].name === "unpauseDate" ? true : response.fn_params.input[j].required
                                            });

                                            inputItems.push(inp);
                                        }
                                    }
                                    if (response.fn_params.output != undefined) {
                                        for (k = 0; k < response.fn_params.output.length; k++) {
                                            var nameOutput = response.fn_params.output[k].name;

                                            var out = new CriteriaField({
                                                id: nameOutput,
                                                pmType: "text",
                                                name: nameOutput,
                                                label: response.fn_params.output[k].label,
                                                value: wizardData.TRI_ANSWER.toString(),
                                                controlsWidth: 400,
                                                labelWidth: '27%',
                                                helper: response.fn_params.output[k].description,
                                                required: response.fn_params.output[k].required
                                            });

                                            outputItems.push(out);
                                        }
                                    }
                                    triggerWindow.setTitle("Edit".translate() + " " + wizardData.LIBRARY_NAME);
                                    if (inputItems.length > 0) {
                                        formEditTriggerWizard.getItems()[1].setVisible(true);
                                        formEditTriggerWizard.getItems()[2].setVisible(true);
                                        formEditTriggerWizard.getItems()[3].setVisible(true);
                                        formEditTriggerWizard.getItems()[3].clearItems();
                                        formEditTriggerWizard.getItems()[3].setItems(inputItems);
                                    } else {
                                        formEditTriggerWizard.getItems()[1].setVisible(false);
                                        formEditTriggerWizard.getItems()[2].setVisible(false);
                                        formEditTriggerWizard.getItems()[3].setVisible(false);
                                        formEditTriggerWizard.getItems()[3].clearItems();
                                    }
                                    if (outputItems.length > 0) {
                                        formEditTriggerWizard.getItems()[4].setVisible(true);
                                        formEditTriggerWizard.getItems()[5].setVisible(true);
                                        formEditTriggerWizard.getItems()[6].setVisible(true);
                                        formEditTriggerWizard.getItems()[6].clearItems();
                                        formEditTriggerWizard.getItems()[6].setItems(outputItems);
                                    } else {
                                        formEditTriggerWizard.getItems()[4].setVisible(false);
                                        formEditTriggerWizard.getItems()[5].setVisible(false);
                                        formEditTriggerWizard.getItems()[6].setVisible(false);
                                        formEditTriggerWizard.getItems()[6].clearItems();
                                    }
                                    labelInputs.dom.labelTextContainer.style.display = "none";
                                    labelOutputs.dom.labelTextContainer.style.display = "none";
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageError: "There are problems getting the triggers wizard list, please try again.".translate()
                            });
                            restClient.executeRestClient();
                        }
                    }
                },
                {
                    id: "deleteButton",
                    title: '',
                    dataType: 'button',
                    messageTooltip: "Delete".translate(),
                    buttonLabel: "Delete".translate(),
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-delete'
                        ]
                    },
                    onButtonClick: function (row, grid) {
                        var questionWindow, dataRow = row.getData();

                        questionWindow = new PMUI.ui.MessageWindow({
                            id: "questionDeleteWindow",
                            title: "Triggers".translate(),
                            windowMessageType: 'warning',
                            width: 490,
                            message: "Do you want to delete this Trigger?".translate(),
                            footerItems: [
                                {
                                    id: 'questionDeleteWindowButtonNo',
                                    text: "No".translate(),
                                    visible: true,
                                    handler: function () {
                                        questionWindow.close();
                                    },
                                    buttonType: "error"
                                }, {
                                    id: 'questionDeleteWindowButtonYes',
                                    text: "Yes".translate(),
                                    visible: true,
                                    handler: function () {
                                        questionWindow.close();
                                        restClient = new PMRestClient({
                                            endpoint: "trigger/" + dataRow.tri_uid,
                                            typeRequest: 'remove',
                                            functionSuccess: function (xhr, response) {
                                                grid.removeItem(row);
                                            },
                                            functionFailure: function (xhr, response) {
                                                PMDesigner.msgWinError(response.error.message);
                                            },
                                            messageSuccess: "Trigger deleted successfully".translate(),
                                            flashContainer: gridListTrigger
                                        });
                                        restClient.executeRestClient();
                                    },
                                    buttonType: "success"
                                },
                            ]
                        });

                        questionWindow.open();
                        questionWindow.dom.titleContainer.style.height = "17px";
                        questionWindow.showFooter();
                    }
                }
            ],
            dataItems: listTriggers,
            onRowClick: function (row, data) {

            }
        });

        getListTrigger = function () {
            var restClient = new PMRestClient({
                endpoint: 'triggers',
                typeRequest: 'get',
                functionSuccess: function (xhr, response) {
                    listTriggers = response;
                    gridListTrigger.setDataItems(listTriggers);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: "There are problems getting the Triggers list, please try again.".translate()
            });
            restClient.executeRestClient();
        };

        addNumberTriggerWizard = function (value, position) {
            coutTriggers = document.createElement("span");
            coutTriggers.textContent = value;
            headerAccordion = triggerWindow.getItems()[5].getItems()[position].header.html;
            headerAccordion.appendChild(coutTriggers);
            coutTriggers.style.float = "right";
            coutTriggers.style.color = "white";
            coutTriggers.style.fontSize = "13px";
            coutTriggers.style.marginRight = "6px";
            coutTriggers.style.marginTop = "3px";
        };

        newTriggerOptions = function () {

            var acItemCustom = accordionNewTrigger.getItems()[0];
            var acItemCopy = accordionNewTrigger.getItems()[1];
            acItemCustom.setIconClosed('pmcustomtrigger');
            acItemCustom.setIconExpanded('pmcustomtrigger');
            acItemCopy.setIconClosed('pmcopytrigger');
            acItemCopy.setIconExpanded('pmcopytrigger');

            var itemCustom = jQuery("#custom > .pmui-accordion-item-header > span")[1];
            itemCustom.style.width = "0px";
            var itemCopy = jQuery("#copy > .pmui-accordion-item-header > span")[1];
            itemCopy.style.width = "0px";

            var numOfItems = accordionNewTrigger.getItems();

            var lengthLibFunctions = [];
            if (numOfItems.length <= 2) {
                restClient = new PMRestClient({
                    endpoint: "trigger-wizards",
                    typeRequest: 'get',
                    functionSuccess: function (xhr, response) {
                        for (i = 0; i < response.length; i++) {
                            var functTree = response[i].lib_functions;
                            lengthLibFunctions[i] = functTree.length;
                            var newTreeItems = [];
                            for (h = 0; h < functTree.length; h++) {
                                newTreeItems.push({
                                    label: functTree[h].fn_label,
                                    id: functTree[h].fn_name,
                                    onClick: function () {
                                        for (s = 0; s < response.length; s++) {
                                            for (p = 0; p < response[s].lib_functions.length; p++) {
                                                if (response[s].lib_functions[p].fn_name == this.id) {
                                                    var fn = response[s].lib_functions[p].fn_params;
                                                    var fnLabel = response[s].lib_functions[p].fn_label;
                                                    var fnName = response[s].lib_functions[p].fn_name;
                                                    var libName = response[s].lib_name;
                                                    var libTitle = response[s].lib_title;
                                                    p = response[s].lib_functions.length;
                                                    s = response.length - 1;
                                                }
                                            }
                                        }
                                        var inputItems = [];
                                        if (fn.input != undefined) {
                                            for (j = 0; j < fn.input.length; j++) {
                                                var val = "";
                                                if (fn.input[j].type == "array") {
                                                    val = "array('')";
                                                }
                                                var inp = new CriteriaField({
                                                    id: fn.input[j].name,
                                                    pmType: "text",
                                                    name: fn.input[j].name,
                                                    label: fn.input[j].label,
                                                    controlsWidth: 400,
                                                    labelWidth: '27%',
                                                    value: val,
                                                    helper: fn.input[j].description,
                                                    required: fn.input[j].name === "unpauseDate" ? true : fn.input[j].required
                                                });

                                                inputItems.push(inp);
                                            }
                                        }

                                        var outputItems = [];
                                        if (fn.output != undefined) {
                                            for (k = 0; k < fn.output.length; k++) {
                                                var out = new CriteriaField({
                                                    id: fn.output[k].name,
                                                    pmType: "text",
                                                    name: fn.output[k].name,
                                                    label: fn.output[k].label,
                                                    controlsWidth: 400,
                                                    labelWidth: '27%',
                                                    helper: fn.output[k].description,
                                                    required: fn.output[k].required
                                                });

                                                outputItems.push(out);
                                            }
                                        }
                                        formEditTriggerWizard.reset();
                                        formEditTriggerWizard.setTitle(fnLabel + ' (' + fnName + ')');
                                        formEditTriggerWizard.getItems()[0].getItems()[1].setValue(libName);
                                        formEditTriggerWizard.getItems()[0].getItems()[2].setValue(fnName);
                                        formEditTriggerWizard.getItems()[0].getItems()[3].setValue(libTitle + ' (' + fnLabel + ')');

                                        if (inputItems.length > 0) {
                                            formEditTriggerWizard.getItems()[1].setVisible(true);
                                            formEditTriggerWizard.getItems()[2].setVisible(true);
                                            formEditTriggerWizard.getItems()[3].setVisible(true);
                                            formEditTriggerWizard.getItems()[3].clearItems();
                                            formEditTriggerWizard.getItems()[3].setItems(inputItems);
                                        } else {
                                            formEditTriggerWizard.getItems()[1].setVisible(false);
                                            formEditTriggerWizard.getItems()[2].setVisible(false);
                                            formEditTriggerWizard.getItems()[3].setVisible(false);
                                            formEditTriggerWizard.getItems()[3].clearItems();
                                        }
                                        if (outputItems.length > 0) {
                                            formEditTriggerWizard.getItems()[4].setVisible(true);
                                            formEditTriggerWizard.getItems()[5].setVisible(true);
                                            formEditTriggerWizard.getItems()[6].setVisible(true);
                                            formEditTriggerWizard.getItems()[6].clearItems();
                                            formEditTriggerWizard.getItems()[6].setItems(outputItems);
                                        } else {
                                            formEditTriggerWizard.getItems()[4].setVisible(false);
                                            formEditTriggerWizard.getItems()[5].setVisible(false);
                                            formEditTriggerWizard.getItems()[6].setVisible(false);
                                            formEditTriggerWizard.getItems()[6].clearItems();
                                        }
                                        openFormWizard();
                                        $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                                        triggerWindow.setTitle("Create".translate() + " " + libTitle);
                                    }
                                });
                            }
                            labelInputs.dom.labelTextContainer.style.display = "none";
                            labelOutputs.dom.labelTextContainer.style.display = "none";
                            allTreesItems[i] = newTreeItems;

                            var arrayTriggerWizards = [
                                "pmFunctions",
                                "pmSugar",
                                "pmTalend",
                                "pmTrAlfresco",
                                "pmTrSharepoint",
                                "pmZimbra"
                            ];

                            if (arrayTriggerWizards.indexOf(response[i].lib_name) == -1) {
                                $("head").append("<style type=\"text/css\">." + response[i].lib_name + " {background: url(" + response[i].lib_icon + ") no-repeat 50% 50%;}</style>");
                            }

                            //Accordion
                            var newAccordionItem = [];
                            newAccordionItem = {
                                iconClass: response[i].lib_name,
                                id: response[i].lib_name,
                                title: response[i].lib_title,
                                height: 'auto'
                            };
                            accordionNewTrigger.addItem(newAccordionItem);
                        }
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageError: "There are problems getting the triggers wizard list, please try again.".translate()
                });
                restClient.executeRestClient();
            }

            openNewTriggerOptions();
            var accordion = triggerWindow.getItems()[5].getItems();
            accordion[0].setVisible(false);
            accordion[1].setVisible(false);
            for (i = 0; i < accordion.length; i++) {
                accordion[i].header.html.style.backgroundColor = "#FFFFFF";
                if (i > 1) {
                    addNumberTriggerWizard(lengthLibFunctions[i - 2], (i));
                }
            }
        };

        allTreesItems = [];
        getListTrigger();

        //Button NEW Trigger
        buttonNew = new PMUI.ui.Button({
            id: 'newTriggerButton',
            text: "Create".translate(),
            height: "36px",
            width: 100,
            handler: function (event) {
                openFormCustom("Create".translate());
                formEditTriggerCustom.getField("code").dom.labelTextContainer.style.width = "23.8%";
                $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                formEditTriggerCustom.showFooter();

                var codeMirrorControl, cmControlCopyTrigger;
                codeMirrorControl = formEditTriggerCustom.getItems()[1].controls[0].cm;
                formEditTriggerCustom.getItems()[1].html.style.padding = "10px";
                if (codeMirrorControl !== undefined) {
                    codeMirrorControl.setSize(580, 150);
                }
                formEditTriggerCustom.getItems()[1].setHeight(170);

                formEditTriggerCustom.reset();

                fields = formEditTriggerCustom.getItems()[0];
                fields.getItems()[0].setValue("");
                fields.getItems()[1].setValue("");
                fields.getItems()[2].setValue("");
                formEditTriggerCustom.getItems()[1].setValue("");
                formEditTriggerCustom.getItems()[1].controls[0].cm.setValue("");
                codeMirrorControl.refresh();
            },
            style: {
                cssClasses: [
                    'mafe-button-create'
                ]
            }
        });

        //Button COPY Trigger
        buttonCopy = new PMUI.ui.Button({
            id: 'copyTriggerButton',
            text: "Copy".translate(),
            height: "36px",
            width: 100,
            handler: function (event) {
                getListProjects();
                openFormCopy();
                formCopyTrigger.getFields()[1].clearOptions();
                $("#Code .CodeMirror.cm-s-default.CodeMirror-wrap").css({'border': '1px solid #c0c0c0'});

                var cmControlCopyTrigger = formCopyTrigger.getFields()[4].controls[0].cm;
                cmControlCopyTrigger.setValue("");
                if (cmControlCopyTrigger !== undefined) {
                    cmControlCopyTrigger.setSize(650, 140);
                }
                cmControlCopyTrigger.refresh();
            },
            style: {
                cssClasses: [
                    'mafe-button-create'
                ]
            }
        });

        //Button WIZARD Trigger
        buttonWizard = new PMUI.ui.Button({
            id: 'wizardTriggerButton',
            text: "Wizard".translate(),
            height: "36px",
            width: 100,
            handler: function (event) {
                newTriggerOptions();
            },
            style: {
                cssClasses: [
                    'mafe-button-create'
                ]
            }
        });

        openListTriggers = function () {
            triggerWindow.getItems()[0].setVisible(true);
            triggerWindow.getItems()[1].setVisible(false);
            triggerWindow.getItems()[2].setVisible(false);
            triggerWindow.getItems()[3].setVisible(false);
            triggerWindow.getItems()[4].setVisible(false);
            triggerWindow.getItems()[5].setVisible(false);
            triggerWindow.setTitle("Triggers".translate());
            triggerWindow.hideFooter();
            $(triggerWindow.body).removeClass("pmui-background");
        };

        openFormCustom = function (typeTitle) {
            triggerWindow.getItems()[0].setVisible(false);
            triggerWindow.getItems()[1].setVisible(true);
            triggerWindow.getItems()[2].setVisible(false);
            triggerWindow.getItems()[3].setVisible(false);
            triggerWindow.getItems()[4].setVisible(false);
            triggerWindow.getItems()[5].setVisible(false);
            triggerWindow.footer.getItems()[0].setVisible(true); //button Cancel
            triggerWindow.footer.getItems()[1].setVisible(true); //button Save
            triggerWindow.footer.getItems()[2].setVisible(false); //Edit Source Code
            triggerWindow.footer.getItems()[3].setVisible(false); //button Aply
            triggerWindow.footer.getItems()[4].setVisible(false); //button Copy/import

            triggerWindow.setTitle(typeTitle + " Custom Trigger".translate());
            triggerWindow.showFooter();
            $(triggerWindow.body).addClass("pmui-background");
            formEditTriggerCustom.setFocus();

            $('.CodeMirror.cm-s-default')[0].style.border = "1px solid #c0c0c0";
            if (formEditTriggerCustom.getItems()[0].getItems()[1].visible == false) {
                var fields = formEditTriggerCustom.getItems()[0];
                fields.getItems()[1].setVisible(true);
                fields.getItems()[2].setVisible(true);
                formEditTriggerCustom.footer.getItems()[1].setVisible(true);
            }
            formEditTriggerCustom.getFields()[4].dom.labelTextContainer.style.marginLeft = "10px";
            formEditTriggerCustom.setAlignmentButtons('left');

            $("#code").after($ctrlSpaceMessage.css({
                "margin": "5px 0 0 0",
                "text-align": "center",
                "width": "655px",
                "padding": ""
            }));
        };

        openFormWizard = function () {
            triggerWindow.getItems()[0].setVisible(false);
            triggerWindow.getItems()[1].setVisible(false);
            triggerWindow.getItems()[2].setVisible(true);
            triggerWindow.getItems()[3].setVisible(false);
            triggerWindow.getItems()[4].setVisible(false);
            triggerWindow.getItems()[5].setVisible(false);
            triggerWindow.footer.getItems()[0].setVisible(true); //button Cancel
            triggerWindow.footer.getItems()[1].setVisible(true); //button Save
            triggerWindow.footer.getItems()[2].setVisible(false); //Edit Source Code
            triggerWindow.footer.getItems()[3].setVisible(false); //button Aply
            triggerWindow.footer.getItems()[4].setVisible(false); //button Copy/import
            triggerWindow.showFooter();
            $(triggerWindow.body).addClass("pmui-background");
            formEditTriggerWizard.setFocus();
        };

        openFormWizardEditMode = function () {
            triggerWindow.getItems()[0].setVisible(false);
            triggerWindow.getItems()[1].setVisible(false);
            triggerWindow.getItems()[2].setVisible(true);
            triggerWindow.getItems()[3].setVisible(false);
            triggerWindow.getItems()[4].setVisible(false);
            triggerWindow.getItems()[5].setVisible(false);
            triggerWindow.footer.getItems()[0].setVisible(true); //button Cancel
            triggerWindow.footer.getItems()[1].setVisible(true); //button Save
            triggerWindow.footer.getItems()[2].setVisible(true); //Edit Source Code
            triggerWindow.footer.getItems()[3].setVisible(false); //button Aply
            triggerWindow.footer.getItems()[4].setVisible(false); //button Copy/import
            triggerWindow.showFooter();
            $(triggerWindow.body).addClass("pmui-background");
            formEditTriggerWizard.setFocus();
        };


        openFormCopy = function () {
            triggerWindow.getItems()[0].setVisible(false);
            triggerWindow.getItems()[1].setVisible(false);
            triggerWindow.getItems()[2].setVisible(false);
            triggerWindow.getItems()[3].setVisible(true);
            triggerWindow.getItems()[4].setVisible(false);
            triggerWindow.getItems()[5].setVisible(false);
            triggerWindow.setTitle("Copy Trigger".translate());
            triggerWindow.footer.getItems()[0].setVisible(true); //button Cancel
            triggerWindow.footer.getItems()[1].setVisible(false); //button Save
            triggerWindow.footer.getItems()[2].setVisible(false); //Edit Source Code
            triggerWindow.footer.getItems()[3].setVisible(false); //button Aply
            triggerWindow.footer.getItems()[4].setVisible(true); //button Copy/import
            triggerWindow.showFooter();
            $(triggerWindow.body).addClass("pmui-background");
            formCopyTrigger.setFocus();

            $(".pmui-field").css("float", "left");
            $('#Code .pmui.pmui-pmcodemirrorcontrol').append($ctrlSpaceMessage.css({
                "margin-top": "10px",
                "text-align": "",
                "width": "655px",
                "padding": ""
            }));
        };

        openFormEditCode = function () {
            triggerWindow.getItems()[0].setVisible(false);
            triggerWindow.getItems()[1].setVisible(false);
            triggerWindow.getItems()[2].setVisible(false);
            triggerWindow.getItems()[3].setVisible(false);
            triggerWindow.getItems()[4].setVisible(true);
            triggerWindow.getItems()[5].setVisible(false);
            triggerWindow.setTitle("Editor".translate());
            triggerWindow.footer.getItems()[0].setVisible(true); //button Cancel
            triggerWindow.footer.getItems()[1].setVisible(false); //button Save
            triggerWindow.footer.getItems()[2].setVisible(false); //Edit Source Code
            triggerWindow.footer.getItems()[3].setVisible(true); //button Aply
            triggerWindow.footer.getItems()[4].setVisible(false); //button Copy/import
            triggerWindow.showFooter();
            $(triggerWindow.body).addClass("pmui-background");

            $($('#codeEditor .CodeMirror.cm-s-default.CodeMirror-wrap')[0]).after($ctrlSpaceMessage.css({
                "padding": "5px 0 0 10px",
                "text-align": ""
            }));

        };

        openNewTriggerOptions = function () {
            triggerWindow.getItems()[0].setVisible(false);
            triggerWindow.getItems()[1].setVisible(false);
            triggerWindow.getItems()[2].setVisible(false);
            triggerWindow.getItems()[3].setVisible(false);
            triggerWindow.getItems()[4].setVisible(false);
            triggerWindow.getItems()[5].setVisible(true);
            triggerWindow.setTitle("Create Predefined Trigger".translate());
            triggerWindow.footer.getItems()[0].setVisible(true); //button Cancel
            triggerWindow.footer.getItems()[1].setVisible(false); //button Save
            triggerWindow.footer.getItems()[2].setVisible(false); //Edit Source Code
            triggerWindow.footer.getItems()[3].setVisible(false); //button Aply
            triggerWindow.footer.getItems()[4].setVisible(false); //button Copy/import
            triggerWindow.showFooter();
            $(triggerWindow.body).removeClass("pmui-background");
        };

        //obtaning the list of process to show it on the copy/import of a trigger dropdown
        listProjects = [];
        getListProjects = function () {
            restClient = new PMRestClient({
                typeRequest: 'get',
                functionSuccess: function (xhr, response) {
                    listProjects = [];
                    formCopyTrigger.getFields()[0].clearOptions();
                    listProjects[0] = {
                        label: "- Select a process -".translate(),
                        value: "",
                        disabled: true,
                        selected: true
                    };
                    for (i = 0; i < response.length; i++) {
                        listProjects.push({
                            label: response[i].prj_name,
                            value: response[i].prj_uid
                        });
                    }
                    formCopyTrigger.getFields()[0].setOptions(listProjects);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: "There are problems getting the list of projects.".translate()
            });
            restClient.setBaseEndPoint('projects');
            restClient.executeRestClient();
        };

        //form Copy/Import Trigger
        triggerSelectedData;
        formCopyTrigger = new PMUI.form.Form({
            id: "formCopyTriggers",
            border: true,
            width: '890px',
            height: 'auto',
            title: "",
            visibleHeader: false,
            items: [
                {
                    pmType: 'dropdown',
                    id: "processField",
                    label: 'Process'.translate(),
                    name: 'prj_uid',
                    required: true,
                    controlsWidth: 300,
                    value: "",
                    options: listProjects,
                    onChange: function (newValue, prevValue) {
                        var formFields = formCopyTrigger.getFields();
                        formFields[2].setValue("");
                        formFields[3].setValue("");
                        formFields[4].controls[0].cm.setValue("");

                        var uidProj = newValue, myForm = this.form;

                        //obtaning the Trigger list of the process SELECTED
                        restClient = new PMRestClient({
                            typeRequest: 'get',
                            functionSuccess: function (xhr, response) {
                                triggerSelectedData = response;
                                var listTriggersCopy = [];
                                listTriggersCopy[0] = {
                                    label: "- Select a trigger -".translate(),
                                    value: "",
                                    disabled: true,
                                    selected: true
                                };

                                for (i = 0; i < response.length; i++) {
                                    listTriggersCopy.push({
                                        label: response[i].tri_title,
                                        value: response[i].tri_uid
                                    });
                                }
                                formFields[1].setOptions(listTriggersCopy);
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: "There are problems getting the list of triggers.".translate()
                        });
                        restClient.setBaseEndPoint("project/" + uidProj + "/triggers");
                        restClient.executeRestClient();
                    }
                },
                {
                    pmType: 'dropdown',
                    id: "triggerField",
                    label: 'Trigger'.translate(),
                    name: 'tri_uid',
                    required: true,
                    controlsWidth: 300,
                    value: "",
                    options: [],
                    onChange: function (newValue, prevValue) {
                        var formFields = formCopyTrigger.getFields();
                        formFields[2].setValue("");
                        formFields[3].setValue("");
                        formFields[4].controls[0].cm.setValue("");

                        var uidTri = newValue;

                        for (i = 0; i < triggerSelectedData.length; i++) {
                            if (triggerSelectedData[i].tri_uid == uidTri) {
                                formFields[2].setValue(triggerSelectedData[i].tri_title);
                                formFields[3].setValue(triggerSelectedData[i].tri_description);
                                formFields[4].controls[0].cm.setValue(triggerSelectedData[i].tri_webbot);
                            }
                        }
                    }
                },
                {
                    pmType: "text",
                    id: "triTitle",
                    label: "Title of the new trigger".translate(),
                    placeholder: "Insert the title of the new trigger".translate(),
                    name: "tri_title",
                    required: true,
                    valueType: 'string',
                    controlsWidth: 300,
                    style: {
                        cssProperties: {
                            'float': 'left'
                        }
                    }
                },
                {
                    pmType: "textarea",
                    id: "triDescription",
                    rows: 80,
                    name: 'tri_description',
                    label: "Description of the new trigger".translate(),
                    valueType: 'string',
                    controlsWidth: 652,
                    style: {
                        cssClasses: ['mafe-textarea-resize'],
                        cssProperties: {'float': 'left'}
                    }
                }
            ]
        });
        codMirr = new PMCodeMirrorField();
        codMirr.setLabel("Code".translate());
        codMirr.setID("Code");
        codMirr.setName('tri_webbot');
        CodeMirror.commands.autocomplete = function (cm) {
            CodeMirror.showHint(cm, CodeMirror.phpHint);
        };
        formCopyTrigger.addItem(codMirr);

        //Form to Edit the trigger with the WIZARD (we used a Form because we need buttons to save the changes)
        formEditTriggerWizard = new PMUI.form.Form({
            id: "formEditTriggerWizard",
            border: true,
            visibleHeader: false,
            name: "formwizard",
            width: 926,
            title: "New Trigger".translate(),
            items: [
                {
                    id: "panelDetailsWizard",
                    pmType: "panel",
                    layout: 'vbox',
                    fieldset: false,
                    height: 'auto',
                    legend: "DETAILS".translate(),
                    items: [
                        {
                            id: "uid",
                            pmType: "text",
                            label: "ID".translate(),
                            value: "",
                            name: "uid",
                            visible: false,
                            valueType: 'string'
                        },
                        {
                            id: "libName",
                            pmType: "text",
                            label: "",
                            value: "",
                            name: "libName",
                            visible: false,
                            valueType: 'string'
                        },
                        {
                            id: "fnName",
                            pmType: "text",
                            label: "",
                            value: "",
                            name: "fnName",
                            visible: false,
                            valueType: 'string'
                        },
                        {
                            id: "type",
                            pmType: "text",
                            label: "Type".translate(),
                            value: "WIZARD",
                            controlsWidth: 450,
                            labelWidth: '27%',
                            readOnly: true,
                            name: "type",
                            valueType: 'string'
                        },
                        {
                            id: "titleDetailsWiz",
                            pmType: "text",
                            label: "Title".translate(),
                            value: "",
                            controlsWidth: 450,
                            labelWidth: '27%',
                            name: "titleDetails",
                            valueType: 'string',
                            required: true
                        },
                        {
                            id: "descriptionDetailsWiz",
                            pmType: "textarea",
                            label: "Description".translate(),
                            value: "",
                            rows: 90,
                            width: '300px',
                            controlsWidth: 450,
                            labelWidth: '27%',
                            name: "descriptionDetails",
                            valueType: 'string',
                            style: {cssClasses: ['mafe-textarea-resize']}
                        },
                        {
                            id: "webbot",
                            pmType: "text",
                            label: "Webbot".translate(),
                            value: "",
                            name: "webbot",
                            controlsWidth: 300,
                            labelWidth: '27%',
                            visible: false,
                            valueType: 'string'
                        }
                    ]
                }
            ]
        });

        //adding a separator Inputs line
        sepInputs = new PMSeparatorLineField({
            controlHeight: '1px',
            controlColor: "#CDCDCD",
            controlsWidth: "890px",
            marginLeft: '0%'
        });
        formEditTriggerWizard.addItem(sepInputs);

        //adding a label Inputs
        labelInputs = new PMLabelField({
            text: "PARAMETERS".translate(),
            textMode: "plain",
            style: {
                cssProperties: {
                    color: "#AEAEAE",
                    'font-weight': 'bold'
                }
            },
            controlsWidth: 885
        });
        formEditTriggerWizard.addItem(labelInputs);

        //adding the Inputs Items (PARAMETERS) Panel
        paramPanel = new PMUI.form.FormPanel({
            id: "panelParametersWizard",
            layout: 'vbox',
            fieldset: false,
            height: 'auto',
            visible: false,
            legend: "__PARAMETERS__".translate(),
            items: []
        });
        formEditTriggerWizard.addItem(paramPanel);

        //adding a separator Outputs line
        sepOutputs = new PMSeparatorLineField({
            controlHeight: 1,
            controlColor: "#CDCDCD",
            controlsWidth: "890px",
            marginLeft: '0%'
        });
        formEditTriggerWizard.addItem(sepOutputs);

        //adding a label Outputs
        labelOutputs = new PMLabelField({
            text: "RETURN VALUE".translate(),
            textMode: "plain",
            style: {
                cssProperties: {
                    color: "#AEAEAE",
                    'font-weight': 'bold'
                }
            },
            controlsWidth: 885
        });

        formEditTriggerWizard.addItem(labelOutputs);

        //adding the Output Items (Returns) Panel
        returnPanel = new PMUI.form.FormPanel({
            id: "panelReturnValWizard",
            layout: 'vbox',
            fieldset: false,
            height: 'auto',
            visible: false,
            legend: "RETURN VALUE".translate(),
            items: []
        });
        formEditTriggerWizard.addItem(returnPanel);


        //treePanel New Trigger PMF
        treeNewTrigger = new PMUI.panel.TreePanel({
            id: "treeNewTrigger",
            width: 'auto',
            height: 'auto',
            style: {
                cssClasses: ['pmtrigger'],
                cssProperties: {
                    'margin-top': '5px',
                    'margin-bottom': '4px'
                }
            },
            items: []
        });

        //Acordion Panel New Triggers Options
        accordionNewTrigger = new PMUI.panel.AccordionPanel({
            id: "accordionNewTrigger",
            width: 885,
            height: 'auto',
            borderWidth: "0px",
            hiddenTitle: true,
            style: {
                cssProperties: {
                    'margin-left': '30px'
                }
            },
            items: [
                {
                    iconClass: "",
                    id: 'custom',
                    title: "Custom Trigger".translate(),
                    height: '26px',
                    body: "",
                    style: {
                        cssProperties: {
                            "background-color": "#FDFDFD"
                        }
                    }
                },
                {
                    iconClass: "",
                    id: 'copy',
                    title: "Copy Trigger".translate(),
                    height: '26px',
                    body: "",
                    style: {
                        cssProperties: {
                            "background-color": "#FDFDFD"
                        }
                    }
                }
            ],
            listeners: {
                select: function (obj, event) {

                    if (obj.id == "custom") {
                        openFormCustom("Create".translate());
                        $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                        formEditTriggerCustom.showFooter();

                        var codeMirrorControl, cmControlCopyTrigger;
                        codeMirrorControl = formEditTriggerCustom.getItems()[1].controls[0].cm;

                        if (codeMirrorControl != undefined) {
                            codeMirrorControl.setSize(580, 150); //CodeMirror Size
                        }
                        formEditTriggerCustom.getItems()[1].setHeight(170);

                        formEditTriggerCustom.reset();

                        fields = formEditTriggerCustom.getItems()[0];
                        fields.getItems()[0].setValue("");
                        fields.getItems()[1].setValue("");
                        fields.getItems()[2].setValue("");
                        formEditTriggerCustom.getItems()[1].setValue("");
                        formEditTriggerCustom.getItems()[1].controls[0].cm.setValue("");

                    } else if (obj.id == "copy") {

                        getListProjects();
                        openFormCopy();
                        $($('#Code .CodeMirror.cm-s-default.CodeMirror-wrap')[1]).css({'border': '1px solid #c0c0c0'});
                        $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});

                        var cmControlCopyTrigger = formCopyTrigger.getFields()[4].controls[0].cm;
                        if (cmControlCopyTrigger != undefined) {
                            cmControlCopyTrigger.setSize(650, 140); //CodeMirror in formCopyTrigger Size
                        }
                    } else {
                        if (treeNewTrigger.getItems() == "" || treeNewTrigger.id != obj.id) {
                            var acItems = accordionNewTrigger.getItems();
                            var accordionActualItem = accordionNewTrigger.getItem(obj.id);

                            for (i = 0; i < acItems.length; i++) {
                                if (acItems[i].id == accordionActualItem.id) {
                                    var positionActualAcItem = i - 2;
                                }
                            }

                            treeNewTrigger.setItems(allTreesItems[positionActualAcItem]);
                            treeNewTrigger.setID(obj.id);

                            accordionActualItem.setBody(treeNewTrigger);
                            treeNewTrigger.defineEvents();
                            applyStyleTreePanel(treeNewTrigger, false);
                        }
                    }
                }
            }
        });

        updateCustom = function (dataToSend, triggerUid) {
            var restClient = new PMRestClient({
                endpoint: "trigger/" + triggerUid,
                typeRequest: 'update',
                data: dataToSend,
                functionSuccess: function (xhr, response) {
                    formEditTriggerCustom.setDirty(false);
                    getListTrigger();
                    openListTriggers();
                    $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                },
                functionFailure: function (xhr, response) {
                    var msg = response.error.message;
                    var arrayMatch = [];

                    if ((arrayMatch = /^[\w\s]+\:\s*(.*)$/i.exec(msg))) {
                        msg = arrayMatch[1];
                    }

                    PMDesigner.msgWinError(msg);
                },
                messageSuccess: "Trigger updated successfully".translate(),
                flashContainer: gridListTrigger
            });
            restClient.executeRestClient();
        };

        checkIfValuesAreEqual = function (initialData, finalData) {
            if (typeof(initialData['tri_uid']) == "undefined" && finalData['tri_uid'] == '') {
                if (finalData['tri_description'] != '' || finalData['tri_title'] != '' || finalData['tri_webbot'] != '') {
                    return false;
                }
            }
            for (var key1 in initialData) {
                for (var key2 in finalData) {
                    if (typeof(initialData[key1]) != "undefined" &&
                        typeof(finalData[key2]) != "undefined" &&
                        key1 == key2 &&
                        initialData[key1] != finalData[key2]
                    ) {
                        return false;
                    }
                }
            }
            return true;
        }

        //Buttons Save and Cancel for the 'formEditTriggerCustom' and 'formEditTriggerWizard'
        buttonSave = new PMUI.ui.Button({
            id: 'saveTriggerButton',
            text: "Save".translate(),
            handler: function (event) {
                triggerOriginDataForUpdate = {};
                var formcustom = triggerWindow.getItems()[1],
                    formwizard = triggerWindow.getItems()[2],
                    formTriggerData,
                    restClient,
                    dataToSend,
                    formTriggerData,
                    inputFields,
                    message_window,
                    outputV,
                    outputFields,
                    inputV,
                    dataToSend,
                    flagEdit;
                if (formcustom.isVisible() == true) {
                    valuesCustom=formcustom.getItems()[0];
                    if (!formEditTriggerCustom.isValid( )) {
                        flagEdit = formEditTriggerCustom.visible;
                    } else {
                        flagEdit = formEditTriggerCustom.isValid();
                    }
                    if (flagEdit) {
                        if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
                            formTriggerData = getData2PMUI(formEditTriggerCustom.html);
                        } else {
                            formTriggerData = formEditTriggerCustom.getData();
                        }
                        if (formTriggerData.title.trim() === "") {
                            return false;
                        }
                        dataToSend = {
                            tri_title: formTriggerData.title,
                            tri_description: formTriggerData.description,
                            tri_webbot: formTriggerData.code,
                            tri_param: ""
                        };

                        if (formTriggerData.uid === "") {
                            restClient = new PMRestClient({
                                endpoint: 'trigger',
                                typeRequest: 'post',
                                data: dataToSend,
                                functionSuccess: function (xhr, response) {
                                    formEditTriggerCustom.setDirty(false);
                                    getListTrigger();
                                    formEditTriggerCustom.getItems()[0].getItems()[0].setValue(response.tri_uid);
                                    openListTriggers();
                                    $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                                },
                                functionFailure: function (xhr, response) {
                                    var msg = response.error.message,
                                        arrayMatch = [];

                                    if ((arrayMatch = /^[\w\s]+\:\s*(.*)$/i.exec(msg))) {
                                        msg = arrayMatch[1];
                                    }

                                    PMDesigner.msgWinError(msg);
                                },
                                messageSuccess: "New Trigger saved successfully".translate(),
                                flashContainer: gridListTrigger
                            });
                            restClient.executeRestClient();
                        } else {
                            if (formTriggerData.wizzard != "") {
                                if (formEditTriggerCustom.isDirty()) {
                                    message_window = new PMUI.ui.MessageWindow({
                                        id: "wizzardToCustomTriggerWin",
                                        windowMessageType: 'warning',
                                        title: 'Triggers'.translate(),
                                        width: 490,
                                        message: 'Do you want to save the changes? This Trigger will be saved like a custom Trigger.'.translate(),
                                        footerItems: [
                                            {
                                                text: "No".translate(),
                                                handler: function () {
                                                    message_window.close();
                                                    openFormWizardEditMode();
                                                    $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                                                    formEditTriggerCustom.reset();
                                                },
                                                buttonType: "error"
                                            },
                                            {
                                                text: "Yes".translate(),
                                                handler: function () {
                                                    message_window.close();
                                                    updateCustom(dataToSend, formTriggerData.uid);
                                                },
                                                buttonType: "success"
                                            }
                                        ]

                                    });
                                    message_window.open();
                                    message_window.showFooter();
                                } else {
                                    openListTriggers();
                                    $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
                                }
                            } else {
                                updateCustom(dataToSend, formTriggerData.uid);
                            }
                        }
                    }
                } else if (formwizard.isVisible() == true) {
                    if (formEditTriggerWizard.isValid() || ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1))) {
                        if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
                            formTriggerData = getData2PMUI(formEditTriggerWizard.html);
                        } else {
                            formTriggerData = formEditTriggerWizard.getData();
                        }

                        inputV = {};
                        inputFields = formEditTriggerWizard.getItems()[3];
                        for (i = 0; i < inputFields.getItems().length; i++) {
                            inputV[inputFields.getItems()[i].name] = formTriggerData[inputFields.getItems()[i].name];
                        }

                        outputV = {};
                        outputFields = formEditTriggerWizard.getItems()[6];
                        for (j = 0; j < outputFields.getItems().length; j++) {
                            outputV[outputFields.getItems()[j].name] = formTriggerData[outputFields.getItems()[j].name];
                        }

                        dataToSend = {
                            tri_title: formTriggerData.titleDetails,
                            tri_description: formTriggerData.descriptionDetails,
                            tri_type: "SCRIPT",
                            tri_params: {
                                input: inputV,
                                output: outputV
                            }
                        };

                        if (formTriggerData.uid === "") {
                            restClient = new PMRestClient({
                                endpoint: 'trigger-wizard/' + formTriggerData.libName + '/' + formTriggerData.fnName,
                                typeRequest: 'post',
                                data: dataToSend,
                                functionSuccess: function (xhr, response) {
                                    formEditTriggerWizard.setDirty(false);
                                    getListTrigger();
                                    formEditTriggerWizard.getFields()[0].setValue(response.tri_uid);
                                    openListTriggers();
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageSuccess: "New Trigger saved successfully".translate(),
                                flashContainer: gridListTrigger
                            });
                            restClient.executeRestClient();
                        } else {
                            restClient = new PMRestClient({
                                endpoint: 'trigger-wizard/' + formTriggerData.libName + '/' + formTriggerData.fnName + '/' + formTriggerData.uid,
                                typeRequest: 'update',
                                data: dataToSend,
                                functionSuccess: function (xhr, response) {
                                    formEditTriggerWizard.setDirty(false);
                                    getListTrigger();
                                    openListTriggers();
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageSuccess: "Trigger updated successfully".translate(),
                                flashContainer: gridListTrigger
                            });
                            restClient.executeRestClient();
                        }
                    }
                }
            },
            buttonType: 'success'
        });

        //Buttons Save and Cancel for the 'formEditTriggerCustom' and 'formEditTriggerWizard'
        copyButton = new PMUI.ui.Button({
            id: 'copyAndSaveButton',
            text: "Copy Trigger".translate(),
            buttonType: 'success',
            handler: function (event) {
                var data,
                    dataToSend,
                    restClient;
                if (formCopyTrigger.isValid()) {
                    formCopyTrigger.setDirty(false);

                    data = formCopyTrigger.getData();
                    dataToSend = {
                        tri_title: getData2PMUI(formCopyTrigger.html).tri_title.trim(),
                        tri_description: data.tri_description,
                        tri_webbot: data.tri_webbot,
                        tri_param: ""
                    };
                    restClient = new PMRestClient({
                        endpoint: 'trigger',
                        typeRequest: 'post',
                        data: dataToSend,
                        functionSuccess: function (xhr, response) {
                            getListTrigger();
                            formCopyTrigger.reset();
                            openListTriggers();
                        },
                        functionFailure: function (xhr, response) {
                            PMDesigner.msgWinError(response.error.message);
                        },
                        messageSuccess: "New Trigger saved successfully".translate(),
                        flashContainer: gridListTrigger
                    });
                    restClient.executeRestClient();
                }
            }
        });

        //Buttons Apply for the Code Editor
        applyButton = new PMUI.ui.Button({
            id: 'applyButton',
            text: "Apply".translate(),
            buttonType: 'success',
            handler: function (event) {

                $("div.pmui-window-body.pmui-background").css('overflow', '');
                if (formEditCode.isValid()) {
                    var typeTitle = "Edit".translate();
                    if (triggerWindow.getItems()[1].getData().uid == "") {
                        typeTitle = "Create".translate();
                    }
                    openFormCustom(typeTitle);
                    formEditCode.setDirty(false);

                    var editCode = formEditCode.getItems()[0].controls[0].cm;
                    editCodeValue = editCode.getValue();

                    var codeMirrorCustom = formEditTriggerCustom.getItems()[1].controls[0].cm;

                    if (codeMirrorCustom != undefined) {
                        codeMirrorCustom.setSize(580, 150); //CodeMirror Size
                    }
                    codeMirrorCustom.setValue(editCodeValue);
                    formEditTriggerCustom.getItems()[1].setValue(editCodeValue);

                    editCode.setValue("");
                    editCodeValue = "";

                    formEditCode.getItems()[0].setValue("");
                }
            }
        });

        //Button Edit Source Code (this is showed just when the Trigger Wizzard is opened in edition mode)
        btnEditSourceCode = new PMUI.ui.Button({
            id: 'btnEditSourceCode',
            text: "Edit Source Code".translate(),
            buttonType: 'success',
            handler: function (event) {

                var data = formEditTriggerWizard.getData();
                var fields;
                openFormCustom("Edit".translate());
                formEditTriggerCustom.showFooter();

                var codeMirrorControl;
                codeMirrorControl = formEditTriggerCustom.getItems()[1].controls[0].cm;

                if (codeMirrorControl !== undefined) {
                    codeMirrorControl.setSize(650, 280);
                }
                formEditTriggerCustom.getItems()[1].setHeight(170);

                fields = formEditTriggerCustom.getItems()[0];
                fields.getItems()[0].setValue(data.uid);
                fields.getItems()[1].setValue(data.titleDetails);
                fields.getItems()[2].setValue(data.descriptionDetails);
                fields.getItems()[3].setValue(data.webbot);
                fields.getItems()[3].setVisible(false);
                formEditTriggerCustom.getItems()[1].setValue(data.webbot);

                codeMirrorControl.setValue(data.webbot);

                formEditTriggerCustom.getItems()[1].setHeight(300);
                fields.getItems()[1].setVisible(false);
                fields.getItems()[2].setVisible(false);
                formEditTriggerCustom.footer.getItems()[1].setVisible(false);
                formEditTriggerCustom.footer.getItems()[0].style.addProperties({'margin-right': "10px"});
                formEditTriggerCustom.footer.style.addProperties({width: '880px'});
                codeMirrorControl.refresh();
            }
        });

        buttonCancel = new PMUI.ui.Button({
            id: 'cancelTriggerButton',
            text: "Cancel".translate(),
            buttonType: 'error',
            handler: function (event) {
                clickedClose = false;
                isDirtyFormTrigger();
            }
        });

        //Form to Edit the Custom trigger (we used a Form because we need buttons to save the changes)
        formEditTriggerCustom = new PMUI.form.Form({
            id: "formEditTriggerCustom",
            border: true,
            visibleHeader: false,
            width: '900px',
            height: "365px",
            name: "formcustom",
            title: "Custom Trigger".translate(),
            items: [
                {
                    id: "panelDetailsCustom",
                    pmType: "panel",
                    layout: 'vbox',
                    fieldset: false,
                    height: '380px',
                    legend: "DETAILS".translate(),
                    items: [
                        {
                            id: "uid",
                            pmType: "text",
                            label: "ID".translate(),
                            value: "",
                            name: "uid",
                            readOnly: true,
                            visible: false,
                            valueType: 'string'
                        },
                        {
                            id: "title",
                            pmType: "text",
                            label: "Title".translate(),
                            value: "",
                            required: true,
                            name: "title",
                            valueType: 'string'
                        },
                        {
                            id: "description",
                            pmType: "textarea",
                            rows: 70,
                            name: 'description',
                            label: "Description".translate(),
                            valueType: 'string',
                            style: {cssClasses: ['mafe-textarea-resize']}
                        },
                        {
                            id: "wizzard",
                            pmType: "text",
                            label: "Wizzard".translate(),
                            value: "",
                            name: "wizzard",
                            readOnly: true,
                            visible: false,
                            valueType: 'string'
                        }
                    ]
                }
            ],
            buttons: [
                {
                    text: "@@",
                    id: "selectPickerButton",
                    handler: function () {
                        var picker = new VariablePicker();
                        picker.open({
                            success: function (variable) {
                                var codeMirror = formEditTriggerCustom.getItems()[1].controls[0].cm;
                                var cursorPos = codeMirror.getCursor();
                                codeMirror.replaceSelection(variable);
                                codeMirror.setCursor(cursorPos.line, cursorPos.ch);
                            }
                        });
                    },
                    style: {
                        cssProperties: {
                            "margin-left": '208px',
                            "background": "rgb(30, 145, 209)",
                            "border": "0px solid rgb(30, 145, 209)"
                        }
                    }
                }, {
                    text: "Open Editor".translate(),
                    id: "openEditorButton",
                    handler: function () {
                        openFormEditCode();
                        formEditCode.showFooter();

                        var codeMirrorCustom = formEditTriggerCustom.getItems()[1].controls[0].cm;
                        var value = codeMirrorCustom.getValue();

                        var codeMirrorCopy = formEditCode.getItems()[0].controls[0].cm;

                        if (codeMirrorCopy != undefined) {
                            codeMirrorCopy.setSize(810, 315); //CodeMirror Size
                            $($('#codeEditor .CodeMirror.cm-s-default.CodeMirror-wrap')[0]).css({'border': '1px solid #c0c0c0'});

                        }

                        formEditCode.getItems()[0].setHeight(325);

                        codeMirrorCopy.setValue(value);
                        formEditCode.getItems()[0].setValue(value);
                        formEditCode.setDirty(false);

                        $('#codeEditor .pmui-field-label').hide();
                        $('#formEditCode').children().last().css({
                            'margin-top': '-352px',
                            'border': '0px',
                            'margin-right': '-15px'
                        }).find('a').css('padding', '10px 5px');
                        $($('#codeEditor .CodeMirror.cm-s-default.CodeMirror-wrap')[0]).css({
                            'margin-left': '10px',
                            'width': '850px',
                            'height': '360px'
                        });
                        $('#triggerWindow .pmui-window-body').css('overflow', 'hidden');
                        codeMirrorCopy.refresh();
                    },
                    style: {
                        cssProperties: {
                            "margin-right": 2
                        }
                    }
                }
            ]
        });
        cd = new PMCodeMirrorField({
            labelWidth: '23.8%'
        });
        cd.setLabel("Code".translate());
        formEditTriggerCustom.addItem(cd);
        formEditTriggerCustom.getItems()[1].setName('code');
        formEditTriggerCustom.getItems()[1].setID('code');

        formEditCode = new PMUI.form.Form({
            id: "formEditCode",
            border: true,
            visibleHeader: false,
            width: '925px',
            name: "formeditcode",
            title: "Editor".translate(),
            items: [],
            buttons: [
                {
                    text: "@@",
                    id: "selectPickerButton",
                    handler: function () {
                        var picker = new VariablePicker();
                        picker.open({
                            success: function (variable) {
                                var codeMirror = formEditCode.getItems()[0].controls[0].cm;
                                var cursorPos = codeMirror.getCursor();
                                codeMirror.replaceSelection(variable);
                                codeMirror.setCursor(cursorPos.line, cursorPos.ch);
                            }
                        });
                    },
                    style: {
                        cssProperties: {
                            "margin-left": '229px',
                            "background": "rgb(45, 62, 80)",
                            "border": "1px solid rgb(45, 62, 80)"
                        }
                    }
                }
            ]
        });
        editCode = new PMCodeMirrorField({
            labelWidth: '9%'
        });
        editCode.setLabel("Code".translate());
        formEditCode.addItem(editCode);
        formEditCode.getItems()[0].setName('codeEditor');
        formEditCode.getItems()[0].setID('codeEditor');

        //Trigger Window
        triggerWindow = new PMUI.ui.Window({
            id: "triggerWindow",
            title: "Triggers".translate(),
            width: DEFAULT_WINDOW_WIDTH,
            height: DEFAULT_WINDOW_HEIGHT,
            footerItems: [
                buttonCancel,
                buttonSave,
                btnEditSourceCode,
                applyButton,
                copyButton
            ],
            buttonPanelPosition: "bottom",
            footerAling: "right",
            onBeforeClose: function () {
                clickedClose = true;
                isDirtyFormTrigger();
            }
        });


        triggerWindow.addItem(gridListTrigger);
        triggerWindow.addItem(formEditTriggerCustom);
        triggerWindow.addItem(formEditTriggerWizard);
        triggerWindow.addItem(formCopyTrigger);
        triggerWindow.addItem(formEditCode);
        triggerWindow.addItem(accordionNewTrigger);

        if (typeof listTriggers !== "undefined") {
            triggerWindow.open();
            codMirr.dom.labelTextContainer.style.width = "23.8%";
            codMirr.html.style.padding = "10px";
            formEditTriggerCustom.panel.html.style.padding = "10px 10px";
            $('#listTriggers .pmui-textcontrol').css({'margin-top': '5px', width: '250px'});
            applyStyleWindowForm(triggerWindow);
            triggerWindow.hideFooter();
            openListTriggers();

            gridListTrigger.dom.toolbar.appendChild(buttonNew.getHTML());
            buttonNew.defineEvents();

            gridListTrigger.dom.toolbar.appendChild(buttonCopy.getHTML());
            buttonCopy.defineEvents();

            gridListTrigger.dom.toolbar.appendChild(buttonWizard.getHTML());
            buttonWizard.defineEvents();

            triggerWindow.defineEvents();
            gridListTrigger.sort('tri_title', 'asc');
            formEditTriggerCustom.panel.style.addProperties({'overflow': 'hidden'});

            formcustom = triggerWindow.getItems()[1];
            valuesCustom=formcustom.getItems()[0];
        }
    };

    PMDesigner.trigger.create = function () {
        var codeMirrorControl, cmControlCopyTrigger;
        openFormCustom("Create".translate());
        formEditTriggerCustom.getField("code").dom.labelTextContainer.style.width = "23.8%";
        $('.pmui-pmseparatorlinefield .pmui-field-label').css({display: 'none'});
        formEditTriggerCustom.showFooter();

        codeMirrorControl = formEditTriggerCustom.getItems()[1].controls[0].cm;
        formEditTriggerCustom.getItems()[1].html.style.padding = "10px";
        if (codeMirrorControl !== undefined) {
            codeMirrorControl.setSize(580, 150);
            codeMirrorControl.refresh();
        }
        codeMirrorControl.refresh();
        formEditTriggerCustom.getItems()[1].setHeight(170);
        formEditTriggerCustom.reset();
    };
}());
/**
 * new stepTask module
 */
var stepsTask = function (activity) {
    this.mainWindow = null;
    this.secondaryWindow = null;
    this.stepsAssignTree = null;
    this.mainContainer = null;
    this.labelsPanel = null;
    this.stepsMainContainer = null;
    this.stepsAssignAccordion = null;
    this.confirmWindow = null;
    this.elementAccordionOpen = null;
    this.groupType = null;
    this.groupLabel = null;
    this.stepsType = null;
    this.stepsAssigned = null;
    stepsTask.prototype.initialize.call(this, activity);
};
/**
 * initialization method steps settings, constants are created.
 * components are created
 * the data is loaded
 * styles are customized
 * It extends behaviors and events
 */
stepsTask.prototype.initialize = function () {
    this.groupType = ['DYNAFORM', 'INPUT_DOCUMENT', 'OUTPUT_DOCUMENT', 'EXTERNAL'];
    this.groupLabel = ['Dynaform (s)'.translate(), 'Input Document (s)'.translate(), 'OutPut Document (s)'.translate(), 'External (s)'.translate()];
    this.stepsType = {
        "DYNAFORM": "Dynaform".translate(),
        "INPUT_DOCUMENT": "Input Document".translate(),
        "OUTPUT_DOCUMENT": "Output Document".translate(),
        "EXTERNAL": "External".translate()
    };
    this.stepsAssigned = new PMUI.util.ArrayList();
    this.elementAccordionOpen = new PMUI.util.ArrayList();
    this.createWidgets();
    this.mainWindow.addItem(this.mainContainer);
    this.mainWindow.open();
    this.loadInitialData();
    this.customStyles();
    this.elementsAccordionOpenFixed();
    this.addEventSortableInAccordionElements();
    this.addEventSortableInTreePanelElements();
};
/**
 * the components are created PMUI UI
 * - confirmWindow
 * - mainWindow
 * - labelsPanel
 * - stepsAssignTree
 * - stepsAssignAccordion
 * - stepsMainContainer
 * - mainContainer
 * - secondaryWindow
 */
stepsTask.prototype.createWidgets = function () {
    var that = this;
    this.confirmWindow = new PMUI.ui.MessageWindow({
        id: 'confirmWindowDeleteAcceptedValue',
        windowMessageType: 'warning',
        width: 490,
        bodyHeight: 'auto',
        title: '',
        message: '',
        footerItems: [
            {
                id: 'confirmWindow-footer-no',
                text: 'No'.translate(),
                visible: true,
                buttonType: "error"
            }, {
                id: 'confirmWindow-footer-yes',
                text: 'Yes'.translate(),
                visible: true,
                buttonType: "success"
            }
        ],
        visibleFooter: true
    });
    this.mainWindow = new PMUI.ui.Window({
        id: "stepsForTask",
        title: "Steps for task".translate(),
        height: DEFAULT_WINDOW_HEIGHT,
        width: DEFAULT_WINDOW_WIDTH
    });
    this.labelsPanel = new PMUI.core.Panel({
        width: DEFAULT_WINDOW_WIDTH,
        proportion: 0.08,
        layout: "hbox",
        items: [
            new PMUI.field.TextAnnotationField({
                text: 'Available Elements'.translate(),
                text_Align: 'center',
                proportion: 1.4
            }),
            new PMUI.field.TextAnnotationField({
                text: 'Assigned Elements (Drop here)'.translate(),
                text_Align: 'center',
                proportion: 1.3
            }),
            new PMUI.ui.Button({
                buttonType: "link",
                "text": "Expand all".translate(),
                id: "expand-button",
                proportion: 0.6,
                handler: function () {
                    var items, i, item, buttonAfected;
                    items = that.stepsAssignAccordion.getItems();
                    buttonAfected = that.labelsPanel.getItem("collapse-button");
                    buttonAfected.setDisabled(false);
                    this.setDisabled(true);
                    that.elementAccordionOpen.clear();
                    for (i = 0; i < items.length; i += 1) {
                        item = items[i];
                        item.expand();
                        that.elementAccordionOpen.insert(item);
                    }
                }
            }),
            new PMUI.ui.Button({
                buttonType: "link",
                "text": "Collapse all".translate(),
                id: "collapse-button",
                proportion: 0.7,
                disabled: true,
                handler: function () {
                    var items, i, item, buttonAfected;
                    buttonAfected = that.labelsPanel.getItem("expand-button");
                    buttonAfected.setDisabled(false);
                    this.setDisabled(true);
                    items = that.stepsAssignAccordion.getItems();
                    for (i = 0; i < items.length; i += 1) {
                        item = items[i];
                        that.elementAccordionOpen.remove(item);
                        item.collapse();
                    }
                }
            })
        ]
    });
    this.stepsAssignTree = new PMUI.panel.TreePanel({
        id: 'stepsAssignTree',
        proportion: 0.5,
        height: 475,
        filterable: true,
        autoBind: true,
        filterPlaceholder: 'Search ...'.translate(),
        emptyMessage: 'No records found'.translate(),
        nodeDefaultSettings: {
            labelDataBind: 'obj_title',
            autoBind: true,
            collapsed: false,
            itemsDataBind: 'items',
            childrenDefaultSettings: {
                labelDataBind: 'obj_title',
                autoBind: true
            },
            behavior: 'drag'
        },
        style: {
            cssProperties: {
                margin: '0px 0px 0px 0px',
                float: 'left',
                overflow: 'auto'
            },
            cssClasses: ['mafe-border-panel']
        }
    });
    this.stepsAssignAccordion = new PMUI.panel.AccordionPanel({
        id: 'stepsAssignAccordion',
        multipleSelection: true,
        hiddenTitle: true,
        proportion: 1.5,
        style: {
            cssProperties: {
                margin: '0px 0px 0px 0px'
            },
            cssClasses: ['mafe-border-panel']
        },
        listeners: {
            select: function (accordionItem, event) {
                var buttonExpand, buttonCollapse, itemsAccod;
                itemsAccod = that.stepsAssignAccordion.items;
                if (accordionItem.collapsed) {
                    if (that.elementAccordionOpen.indexOf(accordionItem) > -1) {
                        that.elementAccordionOpen.remove(accordionItem);
                    }
                } else {
                    if (that.elementAccordionOpen.indexOf(accordionItem) === -1) {
                        that.elementAccordionOpen.insert(accordionItem);
                    }
                }
                buttonCollapse = that.labelsPanel.getItem("collapse-button");
                buttonExpand = that.labelsPanel.getItem("expand-button");
                if (that.elementAccordionOpen.getSize() === 0) {
                    buttonExpand.setDisabled(false);
                    buttonCollapse.setDisabled(true);
                } else if (that.elementAccordionOpen.getSize() === itemsAccod.getSize()) {
                    buttonExpand.setDisabled(true);
                    buttonCollapse.setDisabled(false);
                } else {
                    buttonExpand.setDisabled(false);
                    buttonCollapse.setDisabled(false);
                }
            }
        }
    });
    this.stepsMainContainer = new PMUI.core.Panel({
        id: "stepsMainContainer",
        width: DEFAULT_WINDOW_WIDTH,
        height: DEFAULT_WINDOW_HEIGHT - 45,
        layout: 'hbox',
        height: 475,
        items: [
            this.stepsAssignTree,
            this.stepsAssignAccordion
        ]
    });
    this.mainContainer = new PMUI.core.Panel({
        id: "mainContainer",
        width: DEFAULT_WINDOW_WIDTH,
        height: DEFAULT_WINDOW_HEIGHT - 45,
        layout: 'vbox',
        items: [
            this.labelsPanel,
            this.stepsMainContainer
        ]
    });
    this.secondaryWindow = new PMUI.ui.Window({
        visibleFooter: true,
        title: 'Trigger'.translate(),
        footerAlign: 'right',
        footerItems: [
            {
                text: "@@",
                id: "secondaryWindow-criteria",
                handler: function () {
                },
                style: {
                    cssProperties: {
                        "background": "rgb(45, 62, 80)",
                        "border": "1px solid rgb(45, 62, 80)"
                    },
                    cssClasses: ["mafe-button-condition-trigger"]
                }
            }, {
                id: 'secondaryWindow-cancel',
                text: 'Cancel'.translate(),
                buttonType: 'error',
                height: 31,
                style: {
                    cssClasses: ["mafe-button-condition-trigger"]
                },
                handler: function () {
                }
            }, {
                id: 'secondaryWindow-save',
                text: 'Save'.translate(),
                buttonType: 'success',
                height: 31,
                style: {
                    cssClasses: ["mafe-button-condition-trigger"]
                },
                handler: function () {
                }
            }
        ]
    });
};
/**
 * This method loads the initial data module steps,for the components:
 * - stepsAssignTree
 * - stepsAssignAccordion
 */
stepsTask.prototype.loadInitialData = function () {
    this.loadTreePanelData(this.getTreePanelData());
    this.loadAccordionItems(this.getAccordionData());
};
/**
 * This method loads the options to stepsAssignAccordion
 * @param {Array} response An array where each element can be a {Element} object or a JSON object
 */
stepsTask.prototype.loadAccordionItems = function (response) {
    var firstResp = [],
        secondResp = [],
        i,
        item,
        assigmentConfig,
        firstRes = 0,
        secondRes = 1;
    if (jQuery.isArray(response) && response.length) {
        if (typeof response[firstRes] === "object") {
            firstResp = response[firstRes].response ? response[firstRes].response : [];
        }
        if (typeof response[secondRes] === "object") {
            secondResp = response[secondRes].response ? response[secondRes].response : [];
        }
    }
    if (firstResp.length) {
        for (i = 0; i < firstResp.length; i += 1) {
            item = this.createAccordionItem(firstResp[i], true, true);
            this.stepsAssignAccordion.addItem(item);
            item.dataItem = firstResp[i];
            this.customAccordionItemButtons(item.html, firstResp[i], item);
        }
    }
    assigmentConfig = {
        step_type_obj: "Assignment".translate(),
        triggers: secondResp,
        st_type: "ASSIGNMENT",
        obj_title: "Assignment".translate(),
        step_uid_obj: "Assignment"
    };
    item = this.createAccordionItem(assigmentConfig);
    this.stepsAssignAccordion.addItem(item);
    item.dataItem = assigmentConfig;
    assigmentConfig = {
        step_type_obj: "Routing".translate(),
        triggers: secondResp,
        obj_title: "Routing".translate(),
        st_type: 'ROUTING',
        step_uid_obj: "Routing"
    };
    item = this.createAccordionItem(assigmentConfig);
    this.stepsAssignAccordion.addItem(item);
    item.dataItem = assigmentConfig;
    this.stepsAssignAccordion.defineEvents();
};
/**
 * This method creates an element for stepsAssignAccordion
 * @param {data} It is an object with the settings to create the element
 * @returns {PMUI.item.AccordionItem}
 */
stepsTask.prototype.createAccordionItem = function (data) {
    var that = this,
        gridBefore,
        gridAfter,
        beforeTitle,
        afterTitle,
        i,
        textLabel;
    if (this.stepsType[data.step_type_obj]) {
        textLabel = this.stepsType[data.step_type_obj];
    } else {
        textLabel = data.step_type_obj;
    }
    beforeTitle = new PMUI.field.TextAnnotationField({
        text: 'Before'.translate() + ' ' + textLabel,
        proportion: 0.5,
        text_Align: 'left'
    });
    afterTitle = new PMUI.field.TextAnnotationField({
        text: 'After'.translate() + ' ' + textLabel,
        proportion: 0.5,
        text_Align: 'left',
        visible: data.st_type === "ASSIGNMENT" ? false : true
    });

    gridBefore = new PMUI.grid.GridPanel({
        behavior: 'dragdropsort',
        filterable: false,
        visibleHeaders: false,
        data: data.triggers,
        st_type: 'BEFORE',
        step_uid: data.step_uid,
        visibleFooter: false,
        width: '96%',
        emptyMessage: 'No records found'.translate(),
        style: {
            cssClasses: ['mafe-gridPanel']
        },
        customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
            return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
        },
        columns: [
            {
                title: '',
                dataType: 'string',
                alignmentCell: 'center',
                columnData: "st_position",
                width: 20
            }, {
                title: 'Before Output Document'.translate(),
                dataType: 'string',
                alignmentCell: 'left',
                columnData: 'tri_title',
                width: 360
            }, {
                title: '',
                dataType: 'button',
                buttonLabel: function (row, data) {
                    return data.st_condition === '' ? 'Condition'.translate() : 'Condition *'.translate();
                },
                buttonStyle: {cssClasses: ['mafe-button-edit']},
                onButtonClick: function (row, grid) {
                    var data = row.getData();
                    that.editCondition(grid.step_uid, data.tri_uid, data.st_type, row);
                }
            }, {
                title: '',
                dataType: 'button',
                buttonLabel: 'Edit'.translate(),
                buttonStyle: {cssClasses: ['mafe-button-edit']},
                onButtonClick: function (row, grid) {
                    var data = row.getData(),
                        restClient;
                    restClient = new PMRestClient({
                        endpoint: 'trigger/' + data.tri_uid,
                        typeRequest: 'get',
                        functionSuccess: function (xhr, response) {
                            that.editTrigger(response.tri_webbot, response.tri_uid);
                        },
                        functionFailure: function (xhr, response) {
                            PMDesigner.msgWinError(response.error.message);
                        }
                    });
                    restClient.executeRestClient();
                }
            }, {
                title: '',
                dataType: 'button',
                buttonLabel: 'Remove'.translate(),
                buttonStyle: {cssClasses: ['mafe-button-delete']},
                onButtonClick: function (row, grid) {
                    that.removeTrigger(row, grid);
                }
            }
        ],
        onDrop: function (container, draggableItem, index) {
            var receiveData = draggableItem.getData();
            if (draggableItem instanceof PMUI.item.TreeNode) {
                that.receiveTreeNodeItem(receiveData, this, index);
            } else {
                that.receiveRowItem(receiveData, this, index, draggableItem);
            }
            that.updateIndexToGrid(this);
            return false;
        },
        onSort: function (container, item, index) {
            var receiveData = item.getData();
            that.sortableRowHandler(receiveData, this, index);
            that.updateIndexToGrid(this);
        }
    });
    if (data.st_type !== "ROUTING" && data.st_type !== "ASSIGNMENT") {
        gridBefore.st_type = 'BEFORE';
    } else if (data.st_type === "ROUTING") {
        gridBefore.st_type = "BEFORE_ROUTING";
    } else {
        gridBefore.st_type = "BEFORE_ASSIGNMENT";
    }
    gridBefore.step_uid = data.step_uid;
    gridBefore.clearItems();
    if (jQuery.isArray(data.triggers)) {
        for (i = 0; i < data.triggers.length; i += 1) {
            if (gridBefore.st_type === data.triggers[i].st_type) {
                gridBefore.addDataItem({
                    st_condition: data.triggers[i].st_condition,
                    st_position: data.triggers[i].st_position,
                    st_type: data.triggers[i].st_type,
                    tri_description: data.triggers[i].tri_description,
                    tri_title: data.triggers[i].tri_title,
                    tri_uid: data.triggers[i].tri_uid,
                    obj_title: data.triggers[i].tri_title,
                    obj_uid: data.triggers[i].tri_uid
                });
            }
        }
    }
    gridAfter = new PMUI.grid.GridPanel({
        behavior: 'dragdropsort',
        filterable: false,
        visibleHeaders: false,
        data: data.triggers,
        visibleFooter: false,
        width: '96%',
        visible: data.st_type === "ASSIGNMENT" ? false : true,
        emptyMessage: 'No records found'.translate(),
        style: {
            cssClasses: ['mafe-gridPanel']
        },
        customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
            return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
        },
        columns: [
            {
                title: '',
                dataType: 'string',
                alignmentCell: 'center',
                columnData: 'st_position',
                width: 20
            }, {
                title: 'Before Output Document'.translate(),
                dataType: 'string',
                alignmentCell: 'left',
                columnData: 'tri_title',
                width: 360
            }, {
                title: '',
                dataType: 'button',
                buttonLabel: function (row, data) {
                    return data.st_condition === '' ? 'Condition'.translate() : 'Condition *'.translate();
                },
                buttonStyle: {cssClasses: ['mafe-button-edit']},
                onButtonClick: function (row, grid) {
                    var data = row.getData();
                    that.editCondition(grid.step_uid, data.tri_uid, data.st_type, row);
                }
            }, {
                title: '',
                dataType: 'button',
                buttonLabel: 'Edit'.translate(),
                buttonStyle: {cssClasses: ['mafe-button-edit']},
                onButtonClick: function (row, grid) {
                    var data = row.getData(),
                        restClient;
                    restClient = new PMRestClient({
                        endpoint: 'trigger/' + data.tri_uid,
                        typeRequest: 'get',
                        functionSuccess: function (xhr, response) {
                            that.editTrigger(response.tri_webbot, response.tri_uid);
                        },
                        functionFailure: function (xhr, response) {
                            PMDesigner.msgWinError(response.error.message);
                        }
                    });
                    restClient.executeRestClient();
                }
            }, {
                title: '',
                dataType: 'button',
                buttonLabel: 'Remove'.translate(),
                buttonStyle: {cssClasses: ['mafe-button-delete']},
                onButtonClick: function (row, grid) {
                    that.removeTrigger(row, grid);
                }
            }
        ],
        onDrop: function (container, draggableItem, index) {
            var receiveData = draggableItem.getData();
            if (draggableItem instanceof PMUI.item.TreeNode) {
                that.receiveTreeNodeItem(receiveData, this, index);
            } else {
                that.receiveRowItem(receiveData, this, index, draggableItem);
            }
            that.updateIndexToGrid(this);
            return false;
        },
        onSort: function (container, item, index) {
            var receiveData = item.getData();
            that.sortableRowHandler(receiveData, this, index);
            that.updateIndexToGrid(this);
        }
    });
    if (data.st_type !== "ROUTING" && data.st_type !== "ASSIGNMENT") {
        gridAfter.st_type = 'AFTER';
    } else if (data.st_type == "ROUTING") {
        gridAfter.st_type = "AFTER_ROUTING";
    } else {
        gridAfter.st_type = "AFTER_ASSIGNMENT";
    }
    gridAfter.step_uid = data.step_uid;
    if (jQuery.isArray(data.triggers)) {
        for (i = 0; i < data.triggers.length; i += 1) {
            if (gridAfter.st_type === data.triggers[i].st_type) {
                gridAfter.addDataItem({
                    st_condition: data.triggers[i].st_condition,
                    st_position: data.triggers[i].st_position,
                    st_type: data.triggers[i].st_type,
                    tri_description: data.triggers[i].tri_description,
                    tri_title: data.triggers[i].tri_title,
                    tri_uid: data.triggers[i].tri_uid,
                    obj_title: data.triggers[i].tri_title,
                    obj_uid: data.triggers[i].tri_uid
                });
            }
        }
    }
    var accordionItem = new PMUI.item.AccordionItem({
        id: 'id' + data.step_uid_obj,
        dataStep: data,
        closeable: true,
        body: new PMUI.core.Panel({
            layout: 'vbox',
            items: [
                beforeTitle,
                gridBefore,
                afterTitle,
                gridAfter
            ]
        })
    });
    if (this.stepsType[data.step_type_obj]) {
        accordionItem.setTitle(data.step_position + ".  " + data.obj_title + ' (' + this.stepsType[data.step_type_obj] + ')');
        this.stepsAssigned.insert(accordionItem);
    } else {
        accordionItem.setTitle((this.stepsAssignAccordion.items.getSize() + 1) + ". " + data.obj_title);
    }
    return accordionItem;
};
/**
 * styles that can not be handled with the library are customized PMUI
 * @chainable
 */
stepsTask.prototype.customStyles = function () {
    this.mainWindow.body.style.overflow = "hidden";
};
/**
 * run the endpoint 'activity/{activity_id}/available-steps' to get
 * dynaforms, output document, input Document and external, Unassigned or Availables
 * @returns {Array}
 */
stepsTask.prototype.getStepAvailables = function () {
    var resp = [];
    restClient = new PMRestClient({
        typeRequest: 'post',
        multipart: true,
        data: {
            calls: [
                {
                    url: 'activity/' + PMDesigner.act_uid + '/available-steps',
                    method: 'GET'
                }
            ]
        },
        functionSuccess: function (xhr, response) {
            if (jQuery.isArray(response)) {
                resp = response[0] ? response[0].response : [];
            }
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        }
    });
    restClient.executeRestClient();
    return resp;
};
/**
 * run the endpoint 'activity/{activity_id}/available-steps' to get all Availables
 * triggres and dynaforms Unassigned or Availables
 * @returns {Array}
 */
stepsTask.prototype.getTreePanelData = function () {
    var resp = [];
    restClient = new PMRestClient({
        typeRequest: 'post',
        multipart: true,
        data: {
            calls: [{
                url: 'activity/' + PMDesigner.act_uid + '/available-steps',
                method: 'GET'
            }, {
                url: 'triggers',
                method: 'GET'
            }
            ]
        },
        functionSuccess: function (xhr, response) {
            resp = response;
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        }
    });
    restClient.executeRestClient();
    return resp;
}
/**
 * this method loads the data to stepsAssignTree
 * @param response, the answer is an array containing all the elements
 * that will be loaded into the step stepsAssignTree
 * @chainable
 */
stepsTask.prototype.loadTreePanelData = function (response) {
    var that = this,
        data,
        i,
        j,
        type,
        label,
        items,
        labelTrigger,
        dataTree = [],
        treeNode;
    data = response[1].response;
    labelTrigger = 'Trigger (s)'.translate();
    if (data.length === 0) {
        dataTree.push({
            obj_title: labelTrigger,
            items: [this.notItemConfig()]
        });
    } else {
        items = [];
        for (i = 0; i < data.length; i += 1) {
            items.push({
                obj_title: data[i]['tri_title'],
                obj_type: data[i]['tri_type'],
                obj_uid: data[i]['tri_uid']
            });
        }
        dataTree.push({
            obj_title: labelTrigger,
            items: items,
            id: "TRIGGER"
        });
    }
    data = response[0].response;
    type = this.groupType;
    label = this.groupLabel;
    items = [];
    for (i = 0; i < type.length; i += 1) {
        items = [];
        for (j = 0; j < data.length; j += 1) {
            if (type[i] === data[j].obj_type) {
                items.push({
                    obj_title: data[j]['obj_title'],
                    obj_type: data[j]['obj_type'],
                    obj_uid: data[j]['obj_uid']
                });
            }
        }
        if (items.length === 0) {
            dataTree.push({
                obj_title: label[i].translate(),
                items: [this.notItemConfig()],
                behavior: '',
                id: type[i]
            });
        } else {
            dataTree.push({
                obj_title: label[i].translate(),
                items: items,
                behavior: 'drag',
                id: type[i]
            });
        }
    }
    this.stepsAssignTree.clearItems();
    for (i = 0; i < dataTree.length; i += 1) {
        this.stepsAssignTree.addDataItem(dataTree[i]);
        treeNode = this.stepsAssignTree.getItem(i);
        treeNode.setID(dataTree[i].id);
        this.updateIndexPosition(treeNode);
    }
    return this;
};
/**
 * run the endpoint 'activity/{activity_id}/steps' and 'activity/{activity_id}/step/triggers'
 * to get all triggres and dynaforms assigned
 * @returns {Array}
 */
stepsTask.prototype.getAccordionData = function () {
    var resp = [],
        restClient = new PMRestClient({
            typeRequest: 'post',
            multipart: true,
            data: {
                calls: [
                    {
                        url: 'activity/' + PMDesigner.act_uid + '/steps',
                        method: 'GET'
                    }, {
                        url: 'activity/' + PMDesigner.act_uid + '/step/triggers',
                        method: 'GET'
                    }
                ]
            },
            functionSuccess: function (xhr, response) {
                resp = response;
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            },
            messageError: 'There are problems getting the Steps, please try again.'.translate()
        });
    restClient.executeRestClient();
    return resp;
};
/**
 * checks whether a trigger is already assigned in a grid
 * @param grid, is instanceof PMUI.grid.Grid, in conducting the search
 * @param tri_uid, search parameter in the rows of the grid
 * @returns {boolean}
 */
stepsTask.prototype.isTriggerAssigned = function (grid, tri_uid) {
    var data, i, exist = false;
    data = grid.getData();
    if (grid && jQuery.isArray(data)) {
        for (i = 0; i < data.length; i += 1) {
            if (data[i].tri_uid === tri_uid) {
                exist = true;
                break;
            }
        }
    }
    return exist;
};
/**
 * retorna el tipo de de step, para la ejecucion de "endpoint"
 * @param st_type, this a step type, the accepted parameters are:
 *  - BEFORE_ASSIGNMENT
 *  - BEFORE_ROUTING
 *  - AFTER_ROUTING
 *  - BEFORE
 *  - AFTER
 * @returns {string}
 */
stepsTask.prototype.getStepType = function (st_type) {
    var value;
    switch (st_type) {
        case 'BEFORE_ASSIGNMENT':
            value = 'before-assignment';
            break;
        case 'BEFORE_ROUTING':
            value = 'before-routing';
            break;
        case 'AFTER_ROUTING':
            value = 'after-routing';
            break;
        case 'BEFORE':
            value = 'before';
            break;
        case 'AFTER':
            value = 'after';
            break;
        default:
            value = '';
            break;
    }
    return value;
};
/**
 * This method is executed when editing a "trigger" in a row of the grid.
 * secondary window opens with the current configuration of the trigger
 * @param trigger, is the return value when is update 'trigger' action  in the enpoint
 * @param triggerID, is the id of the trigger to update
 * @chainable
 */
stepsTask.prototype.editTrigger = function (trigger, triggerID) {
    var codeMirror,
        saveButton,
        cancelButton,
        criteriaButton,
        that = this;
    this.resetSecondaryWindow();
    codeMirror = new PMCodeMirror({
        id: "codeMirror"
    });
    CodeMirror.commands.autocomplete = function (cm) {
        CodeMirror.showHint(cm, CodeMirror.phpHint);
    };
    codeMirror.setValue(trigger);
    this.secondaryWindow.setWidth(DEFAULT_WINDOW_WIDTH);
    this.secondaryWindow.setHeight(DEFAULT_WINDOW_HEIGHT);
    this.secondaryWindow.setTitle("Trigger".translate());
    saveButton = this.secondaryWindow.footer.getItem("secondaryWindow-save");
    cancelButton = this.secondaryWindow.footer.getItem("secondaryWindow-cancel");
    criteriaButton = this.secondaryWindow.footer.getItem("secondaryWindow-criteria");
    if (saveButton) {
        saveButton.setHandler(function () {
            var restClient = new PMRestClient({
                endpoint: 'trigger/' + triggerID,
                typeRequest: 'update',
                data: {
                    tri_param: '',
                    tri_webbot: codeMirror.getValue()
                },
                messageError: 'There are problems updating the trigger, please try again.'.translate(),
                messageSuccess: 'Trigger updated correctly'.translate(),
                flashContainer: that.mainWindow,
                functionSuccess: function () {
                    that.secondaryWindow.close();
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.executeRestClient();
        });
    }
    if (cancelButton) {
        cancelButton.setHandler(function () {
            that.secondaryWindow.close();
        });
    }
    if (criteriaButton) {
        criteriaButton.setVisible(true);
        criteriaButton.setHandler(function () {
            var picker = new VariablePicker();
            picker.open({
                success: function (variable) {
                    var cursorPos,
                        codemirror;
                    codemirror = codeMirror.cm;
                    cursorPos = codemirror.getCursor();
                    codemirror.replaceSelection(variable);
                    codemirror.setCursor(cursorPos.line, cursorPos.ch);
                }
            });
        });
    }
    this.secondaryWindow.open();
    this.secondaryWindow.addItem(codeMirror);
    codeMirror.cm.setSize(this.secondaryWindow.getWidth(), 380);
    $(".CodeMirror.cm-s-default.CodeMirror-wrap").after($ctrlSpaceMessage.css({
        "padding-left": "10px",
        "margin": "3px 0px 0px 0px"
    }));
    $(".pmui-window-body").css("overflow", "hidden");
    codeMirror.cm.refresh();
};
/**
 * edit the selected trigger condition
 * @param stepID, It is the id of the step to upgrade
 * @param triggerID, is the id of the trigger to update
 * @param stepType, It is the kind of step to update
 * @param row, PMUI.grid.GridPanelRow, is the row affected
 */
stepsTask.prototype.editCondition = function (stepID, triggerID, stepType, row) {
    var saveButton,
        cancelButton,
        criteriaButton,
        form,
        dataRow,
        that = this;
    dataRow = row.getData();
    this.resetSecondaryWindow();
    this.secondaryWindow.setWidth(500);
    this.secondaryWindow.setHeight(350);
    this.secondaryWindow.setTitle('Condition Trigger'.translate());
    this.secondaryWindow.setTitle("Trigger".translate());
    form = new PMUI.form.Form({
        id: 'idFormEditCondition',
        width: 500,
        title: 'Condition Trigger'.translate(),
        visibleHeader: false,
        items: [
            new CriteriaField({
                id: 'st_condition',
                pmType: 'textarea',
                name: 'st_condition',
                valueType: 'string',
                label: 'Condition'.translate(),
                placeholder: 'Insert a condition'.translate(),
                rows: 150,
                controlsWidth: 250,
                renderType: 'textarea',
                value: dataRow.st_condition
            })
        ]
    });
    this.secondaryWindow.addItem(form);
    saveButton = this.secondaryWindow.footer.getItem("secondaryWindow-save");
    cancelButton = this.secondaryWindow.footer.getItem("secondaryWindow-cancel");
    criteriaButton = this.secondaryWindow.footer.getItem("secondaryWindow-criteria");
    if (saveButton) {
        saveButton.setHandler(function () {
            var data,
                restClient;
            data = form.getData();
            data.st_type = stepType;
            restClient = new PMRestClient({
                endpoint: 'activity/' + PMDesigner.act_uid + '/step/' + ((typeof(stepID) != "undefined") ? stepID + "/" : "") + 'trigger/' + triggerID,
                typeRequest: 'update',
                data: data,
                messageError: 'There are problems update the Step Trigger, please try again.'.translate(),
                functionSuccess: function (xhr, response) {
                    dataRow.st_condition = data.st_condition;
                    row.setData(dataRow);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.executeRestClient();
            that.secondaryWindow.close();
        });
    }
    if (cancelButton) {
        cancelButton.setHandler(function () {
            that.secondaryWindow.close();
        });
    }
    if (criteriaButton) {
        criteriaButton.setVisible(false);
        criteriaButton.handler = null;
    }
    this.secondaryWindow.open();
};
/**
 * eliminates the elements of the secondary window
 * @chainable
 */
stepsTask.prototype.resetSecondaryWindow = function () {
    var i, items;
    if (this.secondaryWindow && this.secondaryWindow.items.getSize() > 0) {
        items = this.secondaryWindow.items;
        for (i = 0; i < items.getSize(); i += 1) {
            this.secondaryWindow.removeItem(items.get(i));
        }
    }
};
/**
 * It establishes a PMUI.util.ArrayList that stores the
 * elements of "stepsAssignAccordion" that are open
 * @chainable
 */
stepsTask.prototype.elementsAccordionOpenFixed = function () {
    var i,
        accordionItems;
    if (this.stepsAssignAccordion) {
        accordionItems = this.stepsAssignAccordion.getItems();
        if ($.isArray(accordionItems)) {
            for (i = 0; i < accordionItems.length; i += 1) {
                if (!accordionItems[i].collapsed) {
                    this.elementAccordionOpen.insert(accordionItems[i]);
                }
            }
        }
    }
};
/**
 * It is an extension to add the "sortable" event "stepAssignAccordion".
 * when a node "treePanel" is added to stop runs and is where you choose if it's a sort or aggregation.
 * @chainable
 */
stepsTask.prototype.addEventSortableInAccordionElements = function () {
    var tagContainer,
        newIndex,
        index,
        treeNodeObject,
        treeNodeData,
        that = this;
    if (this.stepsAssignAccordion && this.stepsAssignAccordion.html) {
        tagContainer = this.stepsAssignAccordion.body;
        $(tagContainer).sortable({
            items: '>div:not(#idAssignment,#idRouting)',
            placeholder: 'steps-placeholder',
            receive: function (event, ui) {
                var item = ui ? ui.item : null;
                if (item && item instanceof jQuery && item.length) {
                    treeNodeObject = PMUI.getPMUIObject(item.get(0));
                    treeNodeData = treeNodeObject.getData();
                }
            },
            stop: function (event, ui) {
                var itemClone = ui ? ui.item : null,
                    accordionItems,
                    accordionItem,
                    dataEdited,
                    restClientMultipart,
                    restClient;
                var newIndex = ui.item.index();
                accordionItems = that.stepsAssignAccordion.getItems();
                if (itemClone && itemClone instanceof jQuery && itemClone.length) {
                    if (treeNodeObject) {
                        itemClone.remove();
                        if (newIndex + 1 > accordionItems.length) {
                            newIndex = that.stepsAssigned.getSize();
                        }
                        restClient = new PMRestClient({
                            endpoint: 'activity/' + PMDesigner.act_uid + '/step',
                            typeRequest: 'post',
                            data: {
                                step_type_obj: treeNodeData.obj_type,
                                step_uid_obj: treeNodeData.obj_uid,
                                step_condition: '',
                                step_position: newIndex + 1,
                                step_mode: 'EDIT'
                            },
                            functionSuccess: function (xhr, response) {
                                var item, buttonAfected, treeNode;
                                that.stepsAssignTree.removeItem(treeNodeObject);
                                treeNode = that.stepsAssignTree.items.find("id", response.step_type_obj);
                                if (treeNode.items.getSize() === 0) {
                                    treeNode.addDataItem(that.notItemConfig());
                                }
                                response.obj_description = '';
                                response.obj_title = treeNodeData.obj_title;
                                response.triggers = [];
                                item = that.createAccordionItem(response, true, true);
                                item.dataItem = response;
                                if (that.stepsAssignAccordion.items.getSize() === 2) {
                                    that.stepsAssignAccordion.addItem(item, 0);
                                } else {
                                    that.stepsAssignAccordion.addItem(item, newIndex);
                                }
                                that.stepsAssignAccordion.defineEvents();
                                that.customAccordionItemButtons(item.html, response, item);
                                that.updateItemIndexToAccordion();
                                that.addEventSortableInAccordionElements();
                                that.addEventSortableInTreePanelElements();
                                buttonAfected = that.labelsPanel.getItem("expand-button");
                                buttonAfected.setDisabled(false);
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: 'An unexpected error while assigning the step, please try again later.'.translate(),
                            messageSuccess: 'Step assigned successfully.'.translate(),
                            flashContainer: that.stepsAssignAccordion.getParent()
                        });
                        restClient.executeRestClient();
                    } else {
                        accordionItem = PMUI.getPMUIObject(ui.item.get(0));
                        index = that.stepsAssignAccordion.items.indexOf(accordionItem);
                        if (newIndex !== index) {
                            that.stepsAssignAccordion.items.remove(accordionItem);
                            that.stepsAssignAccordion.items.insertAt(accordionItem, newIndex);
                            dataEdited = {
                                step_position: newIndex + 1,
                                step_uid: accordionItem.dataItem.step_uid,
                                step_type_obj: accordionItem.dataItem.step_type_obj,
                                step_uid_obj: accordionItem.dataItem.step_uid_obj
                            };
                            restClientMultipart = new PMRestClient({
                                endpoint: 'activity/' + PMDesigner.act_uid + '/step/' + accordionItem.dataItem.step_uid,
                                typeRequest: 'update',
                                data: dataEdited,
                                functionSuccess: function (xhr, response) {
                                    that.updateItemIndexToAccordion();
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageError: 'An unexpected error while editing the step, please try again later.'.translate(),
                                messageSuccess: 'Step editing successfully.'.translate(),
                                flashContainer: this.mainWindow
                            });
                            restClientMultipart.executeRestClient();
                        }
                    }
                }
            },
            start: function (e, ui) {
                newIndex = ui.item.index();
            }
        });
    }
};
/**
 * It is an extension to add the "sortable" event "stepsAssignTree".
 * when choosing a node treePanel and you want to add to the accordion or the grid
 * @chainable
 */
stepsTask.prototype.addEventSortableInTreePanelElements = function () {
    var items = this.stepsAssignTree.getItems(),
        connect,
        i,
        sw,
        that = this,
        nodeItems;
    for (i = 0; i < items.length; i += 1) {
        nodeItems = items[i].getItems();
        if (nodeItems.length && nodeItems[0].getData().obj_type) {
            sw = items[i].getItems()[0].getData().obj_type === "SCRIPT";
            connect = sw ? ".pmui-gridpanel-tbody" : ".pmui-accordion-panel-body";
            $(items[i].html).find('ul').find('>li').draggable({
                appendTo: document.body,
                revert: "invalid",
                helper: "clone",
                cursor: "move",
                zIndex: 1000,
                connectToSortable: connect,
                start: function (e) {
                    var i, nodeTag, node, nodeData, accordionItems, item;
                    nodeTag = e.target;
                    node = PMUI.getPMUIObject(nodeTag);
                    nodeData = node.getData();
                    accordionItems = that.stepsAssignAccordion.getItems();
                    $(that.stepsAssignAccordion.body).hide();
                    if (nodeData.obj_type !== "SCRIPT") {
                        for (i = 0; i < accordionItems.length; i += 1) {
                            item = accordionItems[i];
                            item.collapse();
                        }
                    }
                    $(that.stepsAssignAccordion.body).show();
                },
                stop: function () {
                    var i = 0, max;
                    if (that.elementAccordionOpen) {
                        max = that.elementAccordionOpen.getSize();
                        for (i = 0; i < max; i += 1) {
                            that.elementAccordionOpen.get(i).expand();
                        }
                    }
                }
            });
        } else {
            $(nodeItems[0].html).draggable("disable");
        }
    }
};
/**
 * add custom buttons on the head of an element of stepsAssignAccordion
 * are three buttons
 * properties
 * edit
 * remove
 * @param html, is the html of the header accordion item
 * @param step, the data of the step selected
 */
stepsTask.prototype.customAccordionItemButtons = function (html, step, accordionItem) {
    var propertiesStep,
        editStep,
        removeStep,
        $html,
        containerButtons,
        that = this,
        title;
    if (html) {
        $html = jQuery(html.getElementsByClassName("pmui-accordion-item-header"));
        title = step.obj_title + ' (' + step.step_type_obj + ')';
        $html.find(".pmui-accordion-item-title").get(0).title = title;
        containerButtons = $('<div></div>');
        containerButtons.addClass("propertiesTask-accordionItem");
        propertiesStep = $('<a>' + 'Properties'.translate() + '</a>');
        propertiesStep.addClass("mafe-button-edit propertiesTask-accordionButton");
        editStep = $('<a>' + 'Edit'.translate() + '</a>');
        editStep.addClass("mafe-button-edit propertiesTask-accordionButton");
        removeStep = $('<a>' + 'Remove'.translate() + '</a>');
        removeStep.addClass("mafe-button-delete propertiesTask-accordionButton");

        propertiesStep.click(function (e) {
            e.preventDefault();
            e.stopPropagation();
            that.propertiesStepShow(step);
            return false;
        });

        editStep.click(function (e) {
            e.preventDefault();
            e.stopPropagation();
            that.editStepShow(step, accordionItem);
            return false;
        });

        removeStep.click(function (e) {
            e.preventDefault();
            e.stopPropagation();
            that.removeStepShow(step);
            return false;
        });
        containerButtons.append(propertiesStep);
        containerButtons.append(editStep);
        containerButtons.append(removeStep);
        $html.append(containerButtons);
    }
};
/**
 * opens the properties of the selected step with the current settings
 * @param step, is the data of selected step
 * @chainable
 */
stepsTask.prototype.propertiesStepShow = function (step) {
    var form,
        saveButton,
        cancelButton,
        criteriaButton,
        that = this;
    this.resetSecondaryWindow();
    this.secondaryWindow.setWidth(520);
    this.secondaryWindow.setHeight(370);
    this.secondaryWindow.setTitle('Step Properties'.translate());
    form = new PMUI.form.Form({
        id: 'stepsEditCondition',
        width: 500,
        title: 'Condition Trigger'.translate(),
        visibleHeader: false,
        items: [
            {
                id: 'step_mode',
                pmType: 'radio',
                label: 'Mode'.translate(),
                value: '',
                visible: step.step_type_obj === "DYNAFORM" ? true : false,
                name: 'step_mode',
                options: [
                    {
                        id: 'modeEdit',
                        label: 'Edit'.translate(),
                        value: 'EDIT',
                        selected: true
                    }, {
                        id: 'modeView',
                        label: 'View'.translate(),
                        value: 'VIEW'
                    }
                ]
            },
            new CriteriaField({
                id: 'step_condition',
                pmType: 'textarea',
                name: 'step_condition',
                valueType: 'string',
                label: 'Condition'.translate(),
                placeholder: 'Insert a condition'.translate(),
                rows: 150,
                controlsWidth: 250,
                renderType: 'textarea'
            })
        ]
    });
    this.secondaryWindow.addItem(form);

    var restClient = new PMRestClient({
        endpoint: 'activity/' + PMDesigner.act_uid + '/step/' + step.step_uid,
        typeRequest: 'get',
        functionSuccess: function (xhr, response) {
            form.getField('step_mode').setValue(response.step_mode);
            form.getField('step_condition').setValue(response.step_condition);
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        }
    });
    restClient.executeRestClient();
    saveButton = this.secondaryWindow.footer.getItem("secondaryWindow-save");
    cancelButton = this.secondaryWindow.footer.getItem("secondaryWindow-cancel");
    criteriaButton = this.secondaryWindow.footer.getItem("secondaryWindow-criteria");
    if (saveButton) {
        saveButton.setHandler(function () {
            var restClient;
            if (form.isValid()) {
                restClient = new PMRestClient({
                    endpoint: 'activity/' + PMDesigner.act_uid + '/step/' + step.step_uid,
                    typeRequest: 'update',
                    data: form.getData(),
                    functionSuccess: function () {
                        that.secondaryWindow.close();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageError: 'There are problems update the Step Trigger, please try again.'.translate()
                });
                restClient.executeRestClient();
            }
        });
    }
    if (cancelButton) {
        cancelButton.setHandler(function () {
            that.secondaryWindow.close();
        });
    }
    if (criteriaButton) {
        criteriaButton.handler = null;
        criteriaButton.setVisible(false);
    }
    this.secondaryWindow.open();
};
/**
 * opens the step of the selected step with the current settings
 * @param step, is the data of selected step
 * @chainable
 */
stepsTask.prototype.editStepShow = function (step, accordioItem) {
    var inputDocument,
        that = this;
    switch (step.step_type_obj) {
        case 'DYNAFORM':
            var restProxy = new PMRestClient({
                endpoint: 'dynaform/' + step.step_uid_obj,
                typeRequest: 'get',
                functionSuccess: function (xhr, response) {
                    var old = PMUI.activeCanvas,
                        formDesigner;
                    PMUI.activeCanvas = false;
                    formDesigner = PMDesigner.dynaformDesigner(response);
                    formDesigner.onHide = function () {
                        var assignedDynaform,
                            i,
                            data,
                            title;
                        assignedDynaform = that.getStepsAssignedByCriteria("DYNAFORM");
                        if (jQuery.isArray(assignedDynaform)) {
                            for (i = 0; i < assignedDynaform.length; i += 1) {
                                data = assignedDynaform[i];
                                if (typeof data === "object") {
                                    if (data.step_uid === step.step_uid) {
                                        title = data.step_position + ". " + data.obj_title;
                                        title = title + ' (' + that.stepsType["DYNAFORM"] + ')';
                                        accordioItem.setTitle(title);
                                        accordioItem.dataItem = data;
                                    }
                                }
                            }
                        }
                        PMUI.activeCanvas = old;
                    };
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restProxy.executeRestClient();
            break;
        case 'OUTPUT_DOCUMENT':
            PMDesigner.output();
            PMDesigner.output.showTiny(step.step_uid_obj);
            break;
        case 'INPUT_DOCUMENT':
            inputDocument = new InputDocument({
                onUpdateInputDocumentHandler: function (data, inputDoc) {
                    var position, title;
                    position = accordioItem.dataItem.step_position;
                    title = position + ". " + data.inp_doc_title;
                    title = title + ' (' + that.stepsType["INPUT_DOCUMENT"] + ')';
                    accordioItem.dataItem.obj_title = data.inp_doc_title;
                    accordioItem.setTitle(title);
                    inputDoc.winMainInputDocument.close();
                }
            });
            inputDocument.build();
            inputDocument.openFormInMainWindow();
            inputDocument.inputDocumentFormGetProxy(step.step_uid_obj);
            break;
    }
};
/**
 * the window opens for confirmation of the removal step
 * @param step, the current step to remove
 * @chainable
 */
stepsTask.prototype.removeStepShow = function (step) {
    var title,
        yesButton,
        noButton,
        that = this,
        restClient;
    if (this.stepsType[step.step_type_obj] !== undefined) {
        title = "Step {0} ( {1} )".translate([step.obj_title, this.stepsType[step.step_type_obj]]);
        this.confirmWindow.setTitle(title);
    } else {
        this.confirmWindow.setTitle("Step " + step.step_type_obj.capitalize());
    }
    this.confirmWindow.setMessage("Do you want to remove the step '{0}'?".translate([step.obj_title]));
    yesButton = this.confirmWindow.footer.getItem("confirmWindow-footer-yes");
    noButton = this.confirmWindow.footer.getItem("confirmWindow-footer-no");
    if (yesButton) {
        yesButton.setHandler(function () {
            restClient = new PMRestClient({
                endpoint: 'activity/' + PMDesigner.act_uid + '/step/' + step.step_uid,
                typeRequest: 'remove',
                functionSuccess: function (xhr, response) {
                    that.removingStepTask(step, response);
                    that.confirmWindow.close();
                    that.updateItemIndexToAccordion();
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: 'An unexpected error while deleting the step, please try again later.'.translate(),
                messageSuccess: 'Step removed successfully'.translate(),
                flashContainer: that.mainWindow.getParent()
            });
            restClient.executeRestClient();
        });
    }
    if (noButton) {
        noButton.setHandler(function () {
            that.confirmWindow.close();
        });
    }
    this.confirmWindow.open();
};
/**
 * eliminates the step of step Assign Accordion
 * @param step, the current step to remove
 * @param response, data from the endpoint
 */
stepsTask.prototype.removingStepTask = function (step, response) {
    var stepObject,
        stepAvailable,
        treeNodeObject,
        stepAvailables,
        i,
        itemsTreeNode = [],
        items = [];
    stepObject = this.stepsAssignAccordion.getItem("id" + step.step_uid_obj);
    this.elementAccordionOpen.remove(stepObject);
    this.stepsAssigned.remove(stepObject);
    this.stepsAssignAccordion.removeItem(stepObject);
    if (stepObject) {
        stepAvailable = this.getStepAvailables();
        stepAvailables = this.getAvailablesStepsByCriteria(step.step_type_obj, stepAvailable);
        for (i = 0; i < stepAvailables.length; i += 1) {
            items.push({
                obj_title: stepAvailables[i]['obj_title'],
                obj_type: stepAvailables[i]['obj_type'],
                obj_uid: stepAvailables[i]['obj_uid']
            });
        }
        treeNodeObject = this.stepsAssignTree.getItem(step.step_type_obj);
        itemsTreeNode = treeNodeObject.getItems();
        for (i = 0; i < itemsTreeNode.length; i += 1) {
            treeNodeObject.removeItem(itemsTreeNode[i]);
        }
        treeNodeObject.clearItems();
        treeNodeObject.setDataItems(items);
        this.updateIndexPosition(treeNodeObject);
        this.addEventSortableInTreePanelElements();
        this.addEventSortableInAccordionElements();
    }
};
/**
 * get the steps is not assigned by a criterion
 * @param criteria, It is the filter criteria search
 * @param stepAvailable, all steps Unassigned
 * @returns {Array}, filtered items
 */
stepsTask.prototype.getAvailablesStepsByCriteria = function (criteria, stepAvailable) {
    var items = [],
        i;
    if (jQuery.isArray(stepAvailable)) {
        for (i = 0; i < stepAvailable.length; i += 1) {
            if (stepAvailable[i].obj_type === criteria) {
                items.push(stepAvailable[i]);
            }
        }
    }
    return items;
};
/**
 * This method is executed when an element stepsAssignTree, is assigned in a grid
 * @param receiveData, data of the droppable item
 * @param grid, the affected grid
 * @param index, the index position row
 * @returns {stepsTask}
 */
stepsTask.prototype.receiveTreeNodeItem = function (receiveData, grid, index) {
    var restClient, that = this, message;
    if (that.isTriggerAssigned(grid, receiveData.obj_uid)) {
        message = new PMUI.ui.FlashMessage({
            message: 'Trigger is assigned.'.translate(),
            duration: 3000,
            severity: 'error',
            appendTo: that.mainWindow
        });
        message.show();
        return;
    }
    restClient = new PMRestClient({
        endpoint: grid.step_uid === undefined ?
        'activity/' + PMDesigner.act_uid + '/step/trigger' :
        'activity/' + PMDesigner.act_uid + '/step/' + grid.step_uid + '/trigger',
        typeRequest: 'post',
        data: {
            tri_uid: receiveData.obj_uid,
            st_type: grid.st_type,
            st_condition: '',
            st_position: index + 1
        },
        functionSuccess: function (xhr, response) {
            grid.addDataItem({
                st_condition: '',
                st_position: index + 1,
                st_type: grid.st_type,
                tri_description: '',
                tri_title: receiveData.obj_title,
                tri_uid: receiveData.obj_uid,
                obj_title: receiveData.obj_title,
                obj_uid: receiveData.obj_uid
            }, index);
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        }
    });
    restClient.executeRestClient();
    return this;
};
/**
 * This method is executed when a row is drop in another grid
 * @param receiveData, data of the droppable item
 * @param grid, the affected grid
 * @param index, the index position row
 * @param draggableItem
 * @returns {*}
 */
stepsTask.prototype.receiveRowItem = function (receiveData, grid, index, draggableItem) {
    var receiveParent = draggableItem.getParent(),
        message,
        restClient,
        that = this;
    if (this.isTriggerAssigned(grid, receiveData.obj_uid)) {
        message = new PMUI.ui.FlashMessage({
            message: 'Trigger is assigned.'.translate(),
            duration: 3000,
            severity: 'error',
            appendTo: that.mainWindow
        });
        index = receiveParent.items.indexOf(draggableItem);
        receiveParent.items.remove(draggableItem);
        receiveParent.addItem(draggableItem, index);
        message.show();
        return false;
    }
    restClient = new PMRestClient({
        typeRequest: 'post',
        multipart: true,
        data: {
            calls: [
                {
                    url: grid.step_uid === undefined ?
                    'activity/' + PMDesigner.act_uid + '/step/trigger' :
                    'activity/' + PMDesigner.act_uid + '/step/' + grid.step_uid + '/trigger',
                    method: 'POST',
                    data: {
                        tri_uid: receiveData.obj_uid,
                        st_type: grid.st_type,
                        st_condition: receiveData.st_condition,
                        st_position: index + 1
                    }
                }, {
                    url: receiveParent.step_uid === undefined ?
                    'activity/' + PMDesigner.act_uid + '/step/trigger/' + receiveData.obj_uid + '/' + that.getStepType(receiveParent.st_type) :
                    'activity/' + PMDesigner.act_uid + '/step/' + receiveParent.step_uid + '/trigger/' + receiveData.obj_uid + '/' + receiveParent.st_type.toLowerCase(),
                    method: 'DELETE'
                }
            ]
        },
        functionSuccess: function (xhr, response) {
            var data;
            data = receiveData;
            if (data.hasOwnProperty("st_type")) {
                data.st_type = grid.st_type;
                grid.addDataItem(receiveData, index);
            }
            receiveParent.removeItem(draggableItem);
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        },
        flashContainer: that.mainWindow,
        messageError: [
            'An unexpected error while assigning the trigger, please try again later.'.translate()
        ],
        messageSuccess: [
            'Trigger assigned successfully.'.translate()
        ]
    });
    restClient.executeRestClient();
    return this;
};
/**
 * This method is executed when a row is sorted in the grid
 * @param receiveData, data of the droppable item
 * @param grid, the affected grid
 * @param index, the new index position row
 * @returns {stepsTask}
 */
stepsTask.prototype.sortableRowHandler = function (receiveData, grid, index) {
    var that = this,
        restClient;
    restClient = new PMRestClient({
        endpoint: grid.step_uid === undefined ?
        'activity/' + PMDesigner.act_uid + "/step/trigger/" + receiveData.tri_uid :
        'activity/' + PMDesigner.act_uid + "/step/" + grid.step_uid + "/trigger/" + receiveData.tri_uid,
        typeRequest: 'update',
        data: {
            st_type: receiveData.st_type,
            st_condition: receiveData.st_condition,
            st_position: index + 1
        },
        functionFailure: function (xhr, response) {
            PMDesigner.msgWinError(response.error.message);
        },
        flashContainer: that.mainWindow,
        messageError: 'An unexpected error while assigning the trigger, please try again later.'.translate(),
        messageSuccess: 'Trigger assigned successfully.'.translate()
    });
    restClient.executeRestClient();
    return this;
};
/**
 * This method eliminates the list of triggers trigger an assigned step
 * @param row, the row affected or selected
 * @param grid, It is affected or grid to remove selected row
 */
stepsTask.prototype.removeTrigger = function (row, grid) {
    var message = 'Do you want to remove the trigger "',
        messageData = row.getData().tri_title ? row.getData().tri_title : "",
        yesButton,
        noButton,
        that = this,
        restClient;
    message = message + messageData + '"?';
    this.confirmWindow.setMessage(message.translate());
    yesButton = this.confirmWindow.footer.getItem("confirmWindow-footer-yes");
    if (yesButton) {
        yesButton.setHandler(function () {
            restClient = new PMRestClient({
                endpoint: grid.step_uid === undefined ?
                'activity/' + PMDesigner.act_uid + '/step/trigger/' + row.getData().tri_uid + '/' + that.getStepType(row.getData().st_type) :
                'activity/' + PMDesigner.act_uid + '/step/' + grid.step_uid + '/trigger/' + row.getData().tri_uid + '/' + that.getStepType(row.getData().st_type),
                typeRequest: 'remove',
                functionSuccess: function (xhr, response) {
                    grid.removeItem(row);
                    that.confirmWindow.close();
                    that.updateIndexToGrid(grid);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                flashContainer: that.mainWindow,
                messageError: 'An unexpected error while deleting the trigger, please try again later.'.translate(),
                messageSuccess: 'Trigger removed successfully'.translate()
            });
            restClient.executeRestClient();
        });
    }
    noButton = this.confirmWindow.footer.getItem("confirmWindow-footer-no");
    if (noButton) {
        noButton.setHandler(function () {
            that.confirmWindow.close();
        });
    }
    this.confirmWindow.open();
};
/**
 * updates indexes of elements selected grid
 * @param grid, It is affected or grid to remove selected row
 * @returns {stepsTask}
 */
stepsTask.prototype.updateIndexToGrid = function (grid) {
    var cell, rows, i, row;
    if (grid) {
        rows = grid.getItems();
        if (jQuery.isArray(rows)) {
            for (i = 0; i < rows.length; i += 1) {
                row = rows[i];
                cell = row.cells.find("columnData");
                if (cell) {
                    cell.setContent(i + 1);
                }
            }
        }
    }
    return this;
};
/**
 * get the steps assigned by a search criterion
 * @param criteria, search filter, after running the endpoint getAccordionData method
 * @returns {Array}, response with criteria
 */
stepsTask.prototype.getStepsAssignedByCriteria = function (criteria) {
    var allAssigned,
        i,
        elements,
        j,
        resp,
        response = [];
    allAssigned = this.getAccordionData();
    if (jQuery.isArray(allAssigned)) {
        for (i = 0; i < allAssigned.length; i += 1) {
            resp = allAssigned[i];
            if (typeof resp === "object") {
                elements = resp.response ? resp.response : [];
                for (j = 0; j < elements.length; j += 1) {
                    data = elements[j];
                    if (typeof data === "object") {
                        if (data.step_type_obj && data.step_type_obj === criteria) {
                            response.push(data);
                        }
                    }
                }
            }
        }
    }
    return response;
};
/**
 * updates indexes of elements assigned
 * @returns {stepsTask}
 */
stepsTask.prototype.updateItemIndexToAccordion = function () {
    var title,
        i,
        item,
        dataItem,
        items = this.stepsAssignAccordion.items,
        position,
        max;
    max = items.getSize();
    for (i = 0; i < max; i += 1) {
        item = items.get(i);
        position = items.indexOf(item);
        dataItem = item.dataItem;
        title = (position + 1) + ".  " + dataItem.obj_title;
        if (this.stepsType[dataItem.step_type_obj]){
            title = title + ' (' + this.stepsType[dataItem.step_type_obj] + ')';
        }
        item.dataItem.step_position = i + 1;
        item.setTitle(title);
    }
    return this;
};
/**
 * add tooltip in treeNode elements
 * @returns {stepsTask}
 */
stepsTask.prototype.updateIndexPosition = function (treeNode) {
    var items, i, item, $item, text, data;
    if (treeNode && treeNode.html) {
        items = treeNode.getItems();
        if (jQuery.isArray(items)) {
            for (i = 0; i < items.length; i += 1) {
                item = items[i];
                if (item.html) {
                    $item = $(item.html);
                    data = item.getData();
                    text = $item.find("a").get(0);
                    text.title = data.obj_title;
                }
            }
        }
    }
    return this;
};
/**
 * return the not items config.
 * @returns {{obj_title: *, obj_uid: string, id: string}}
 */
stepsTask.prototype.notItemConfig = function () {
    var config = {
        obj_title: 'N/A'.translate(),
        obj_uid: '',
        id: "notItem"
    };
    return config;
};
(
    function () {
        var processPermissionsSetForm;
        PMDesigner.processPermissions = function (event) {
            var PROCESS_PERMISSIONS_OPTION = "",
                PROCESS_PERMISSIONS_UID = "",
                arrayCboGroup = [],
                arrayCboUser = [],
                winGrdpnlProcessPermissions,
                grdpnlProcessPermissions,
                frmProcessPermissions,
                processPermissionsData,
                btnCreate, btnSave, btnCancel,
                loadDataFromServerToFields,
                disableAllItems,
                listProcessPermissions,
                isDirty2,
                isDirtyFormProcessPermission,
                refreshGridPanelInMainWindow,
                processPermissionsGetRestProxy,
                processPermissionsPostRestProxy,
                processPermissionGetRestProxy,
                processPermissionsPutRestProxy,
                cboTargetCboOriginTaskSetOptionsRestProxy,
                cboDynaFormSetOptionsRestProxy,
                cboInputDocumentSetOptionsRestProxy,
                cboOutputDocumentSetOptionsRestProxy,
                processPermissionsSetFormByType,
                processPermissionsDeleteRestProxy,
                cboStatusCase,
                cboTargetTask,
                cboGroupOrUser,
                cboOriginTask,
                optionsType,
                cboType,
                cboDynaForm,
                cboInputDocument,
                cboOutputDocument,
                cboPermission,
                cboParticipationRequired,
                processPermissionsDataIni = {},
                notification,
                notificationText = "Fields marked with an asterisk (%%ASTERISK%%) are required.".translate()
                    .replace(/%%ASTERISK%%/g, '<span style="color: #e84c3d">*</span>');

            loadDataFromServerToFields = function () {
                var restClient = new PMRestClient({
                    typeRequest: 'post',
                    multipart: true,
                    data: {
                        calls: [
                            {
                                url: 'project/' + PMDesigner.project.id + '/',
                                method: 'GET'
                            }, {
                                url: 'project/' + PMDesigner.project.id + '/dynaforms',
                                method: 'GET'
                            }, {
                                url: 'project/' + PMDesigner.project.id + '/input-documents',
                                method: 'GET'
                            }, {
                                url: 'project/' + PMDesigner.project.id + '/output-documents',
                                method: 'GET'
                            }
                        ]
                    },
                    functionSuccess: function (xhr, response) {
                        var i;
                        data = response[0].response;
                        cboTargetTask.clearOptions();
                        cboOriginTask.clearOptions();
                        cboTargetTask.addOption({value: '', label: 'Select an option'.translate()});
                        cboOriginTask.addOption({value: '', label: 'All Tasks'.translate()});
                        for (i = 0; i <= data.diagrams[0].activities.length - 1; i += 1) {
                            cboTargetTask.addOption({
                                value: data.diagrams[0].activities[i].act_uid,
                                label: data.diagrams[0].activities[i].act_name
                            });
                            cboOriginTask.addOption({
                                value: data.diagrams[0].activities[i].act_uid,
                                label: data.diagrams[0].activities[i].act_name
                            });
                        }
                        //project/dynaforms
                        data = response[1].response;
                        cboDynaForm.clearOptions();
                        cboDynaForm.addOption({value: '', label: 'All'.translate()});
                        for (i = 0; i <= data.length - 1; i += 1) {
                            cboDynaForm.addOption({value: data[i].dyn_uid, label: data[i].dyn_title});
                        }
                        //project/input-documents
                        data = response[2].response;
                        cboInputDocument.clearOptions();
                        cboInputDocument.addOption({value: '', label: 'All'.translate()});
                        for (i = 0; i <= data.length - 1; i += 1) {
                            cboInputDocument.addOption({value: data[i].inp_doc_uid, label: data[i].inp_doc_title});
                        }
                        //project/output-documents
                        data = response[3].response;
                        cboOutputDocument.clearOptions();
                        cboOutputDocument.addOption({value: '', label: 'All'.translate()});
                        for (i = 0; i <= data.length - 1; i += 1) {
                            cboOutputDocument.addOption({value: data[i].out_doc_uid, label: data[i].out_doc_title});
                        }
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restClient.setBaseEndPoint('');
                restClient.executeRestClient();
            };

            disableAllItems = function () {
                winGrdpnlProcessPermissions.getItems()[0].setVisible(false);
                winGrdpnlProcessPermissions.getItems()[1].setVisible(false);
                winGrdpnlProcessPermissions.hideFooter();
            };

            isDirty2 = function () {
                var user,
                    dynaForm,
                    inputDocument,
                    outputDocument,
                    flagInsert = (typeof(processPermissionsData.op_case_status) === "undefined") ? true : false;

                if (flagInsert) {
                    processPermissionsData = processPermissionsDataIni;
                }

                if (cboStatusCase.getValue() != processPermissionsData.op_case_status) {
                    return true;
                }

                if (cboTargetTask.getValue() != processPermissionsData.tas_uid) {
                    return true;
                }

                user = (cboGroupOrUser.get("value") !== null && cboGroupOrUser.get("value")) ? cboGroupOrUser.get("value") : "";

                if (user != processPermissionsData.usr_uid) {
                    return true;
                }

                if (cboOriginTask.getValue() != processPermissionsData.op_task_source) {
                    return true;
                }

                if (cboParticipationRequired.getValue() != processPermissionsData.op_participate) {
                    return true;
                }

                if (cboType.getValue() != processPermissionsData.op_obj_type) {
                    return true;
                }

                switch (cboType.getValue()) {
                    case "DYNAFORM":
                        dynaForm = (cboDynaForm.getValue() !== "") ? cboDynaForm.getValue() : "0";

                        if (dynaForm != processPermissionsData.op_obj_uid) {
                            return true;
                        }

                        if (cboPermission.getValue() != processPermissionsData.op_action) {
                            return true;
                        }
                        break;
                    case "ATTACHMENT":
                        if (cboPermission.getValue() !== processPermissionsData.op_action) {
                            return true;
                        }
                        break;
                    case "INPUT":
                        inputDocument = (cboInputDocument.getValue() !== "") ? cboInputDocument.getValue() : "0";

                        if (inputDocument != processPermissionsData.op_obj_uid) {
                            return true;
                        }

                        if (cboPermission.getValue() != processPermissionsData.op_action) {
                            return true;
                        }

                        break;
                    case "OUTPUT":
                        outputDocument = (cboOutputDocument.getValue() !== "") ? cboOutputDocument.getValue() : "0";

                        if (outputDocument != processPermissionsData.op_obj_uid) {
                            return true;
                        }
                        if (cboPermission.getValue() != processPermissionsData.op_action) {
                            return true;
                        }
                        break;
                    case "CASES_NOTES":
                    case "SUMMARY_FORM":
                        break;
                    case "ANY":
                    case "MSGS_HISTORY":
                        if (cboPermission.getValue() != processPermissionsData.op_action) {
                            return true;
                        }
                        break;
                }

                return false;
            };

            isDirtyFormProcessPermission = function () {
                $("input,select,textarea").blur();
                if (frmProcessPermissions.isVisible()) {
                    var result = frmProcessPermissions.isDirty(), message_window;

                    if (isDirty2()) {
                        message_window = new PMUI.ui.MessageWindow({
                            id: "cancelMessageTriggers",
                            windowMessageType: 'warning',
                            width: 490,
                            title: "Permissions".translate(),
                            message: 'Are you sure you want to discard your changes?'.translate(),
                            footerItems: [
                                {
                                    text: "No".translate(),
                                    handler: function () {
                                        message_window.close();
                                    },
                                    buttonType: "error"
                                },
                                {
                                    text: "Yes".translate(),
                                    handler: function () {
                                        message_window.close();
                                        PROCESS_PERMISSIONS_OPTION = "";
                                        PROCESS_PERMISSIONS_UID = "";
                                        cboGroupOrUser.html.find("input").val("");
                                        cboGroupOrUser.value = "";
                                        if (clickedClose) {
                                            winGrdpnlProcessPermissions.close();
                                        } else {
                                            refreshGridPanelInMainWindow(false);
                                        }

                                    },
                                    buttonType: "success"
                                }
                            ]
                        });
                        message_window.open();
                        message_window.showFooter();
                    } else {
                        if (cboGroupOrUser.html.find("input").val()) {
                            cboGroupOrUser.html.find("input").val("");
                        }
                        cboGroupOrUser.containerList.hide();
                        PROCESS_PERMISSIONS_OPTION = "";
                        PROCESS_PERMISSIONS_UID = "";
                        refreshGridPanelInMainWindow(false);
                        if (clickedClose) {
                            winGrdpnlProcessPermissions.close();
                        }
                    }
                } else {
                    winGrdpnlProcessPermissions.close();
                }
            };
            refreshGridPanelInMainWindow = function (load) {
                disableAllItems();
                PROCESS_PERMISSIONS_OPTION = "";
                PROCESS_PERMISSIONS_UID = "";
                winGrdpnlProcessPermissions.getItems()[0].setVisible(true);
                winGrdpnlProcessPermissions.setTitle("Permissions".translate());
                load = load != null ? load : true;
                if (load) {
                    processPermissionsGetRestProxy(grdpnlProcessPermissions);
                }
            };

            processPermissionsGetRestProxy = function (grdpnl) {
                var restProxy = new PMRestClient({
                    endpoint: "process-permissions",
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        listProcessPermissions = response;
                        grdpnl.setDataItems(listProcessPermissions);
                        grdpnl.sort('group_user', 'asc');
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });

                restProxy.executeRestClient();
            };

            processPermissionsPostRestProxy = function (data) {
                var restProxy = new PMRestClient({
                    endpoint: "process-permission",
                    typeRequest: "post",
                    data: data,
                    functionSuccess: function (xhr, response) {
                        refreshGridPanelInMainWindow();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'Permission saved successfully'.translate(),
                    flashContainer: grdpnlProcessPermissions
                });
                restProxy.executeRestClient();
            };

            processPermissionGetRestProxy = function (processPermissionsUid) {
                var restProxy = new PMRestClient({
                    endpoint: "process-permission/" + processPermissionsUid,
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response;
                        processPermissionsSetForm("PUT", data);
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            processPermissionsPutRestProxy = function (processPermissionsUid, data) {
                var restProxy = new PMRestClient({
                    endpoint: "process-permission/" + processPermissionsUid,
                    typeRequest: "update",
                    data: data,
                    functionSuccess: function (xhr, response) {
                        refreshGridPanelInMainWindow();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'Permission edited successfully'.translate(),
                    flashContainer: grdpnlProcessPermissions
                });
                restProxy.executeRestClient();
            };

            cboTargetCboOriginTaskSetOptionsRestProxy = function (cboTargetTask, cboOriginTask) {
                cboTargetTask.clearOptions();
                cboOriginTask.clearOptions();
                var restProxy = new PMRestClient({
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response, i;
                        cboTargetTask.addOption({value: "", label: "Select one option".translate()});
                        cboOriginTask.addOption({value: "", label: "All Tasks".translate()});
                        for (i = 0; i <= data.diagrams[0].activities.length - 1; i += 1) {
                            cboTargetTask.addOption({
                                value: data.diagrams[0].activities[i].act_uid,
                                label: data.diagrams[0].activities[i].act_name
                            });
                            cboOriginTask.addOption({
                                value: data.diagrams[0].activities[i].act_uid,
                                label: data.diagrams[0].activities[i].act_name
                            });
                        }
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });

                restProxy.executeRestClient();
            };

            cboDynaFormSetOptionsRestProxy = function (cboDynaForm) {
                cboDynaForm.clearOptions();
                var restProxy = new PMRestClient({
                    endpoint: "dynaforms",
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response, i;
                        cboDynaForm.addOption({value: "", label: "All".translate()});
                        for (i = 0; i <= data.length - 1; i += 1) {
                            cboDynaForm.addOption({value: data[i].dyn_uid, label: data[i].dyn_title});
                        }
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            cboInputDocumentSetOptionsRestProxy = function (cboInputDocument) {
                cboInputDocument.clearOptions();
                var restProxy = new PMRestClient({
                    endpoint: "input-documents",
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response, i;
                        cboInputDocument.addOption({value: "", label: "All".translate()});
                        for (i = 0; i <= data.length - 1; i += 1) {
                            cboInputDocument.addOption({value: data[i].inp_doc_uid, label: data[i].inp_doc_title});
                        }
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            cboOutputDocumentSetOptionsRestProxy = function (cboOutputDocument) {
                var restProxy;
                cboOutputDocument.clearOptions();
                restProxy = new PMRestClient({
                    endpoint: "output-documents",
                    typeRequest: "get",
                    functionSuccess: function (xhr, response) {
                        var data = response, i;
                        cboOutputDocument.addOption({value: "", label: "All".translate()});
                        for (i = 0; i <= data.length - 1; i += 1) {
                            cboOutputDocument.addOption({value: data[i].out_doc_uid, label: data[i].out_doc_title});
                        }
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restProxy.executeRestClient();
            };

            processPermissionsSetFormByType = function (type) {
                cboPermission.removeOption("DELETE");
                cboPermission.removeOption("RESEND");

                cboPermission.reset();
                cboOriginTask.setVisible(true);
                cboParticipationRequired.setVisible(true);
                cboStatusCase.setVisible(true);
                cboDynaForm.setVisible(false);
                cboInputDocument.setVisible(false);
                cboOutputDocument.setVisible(false);
                cboPermission.setVisible(false);

                switch (type) {
                    case "DYNAFORM":
                        cboDynaForm.setVisible(true);
                        cboPermission.setVisible(true);
                        break;
                    case "ATTACHMENT":
                        cboPermission.setVisible(true);
                        break;
                    case "INPUT":
                        cboPermission.addOption({value: "DELETE", label: "Delete".translate()});

                        cboInputDocument.setVisible(true);
                        cboPermission.setVisible(true);
                        break;
                    case "OUTPUT":
                        cboPermission.addOption({value: "DELETE", label: "Delete".translate()});

                        cboOutputDocument.setVisible(true);
                        cboPermission.setVisible(true);
                        break;
                    case "CASES_NOTES":
                    case "SUMMARY_FORM":
                        break;
                    case "MSGS_HISTORY":
                        cboPermission.addOption({value: "RESEND", label: "Resend".translate()});

                        cboPermission.setVisible(true);
                        break;
                    case "ANY":
                        cboPermission.setVisible(true);
                        break;
                    case "REASSIGN_MY_CASES":
                        cboOriginTask.setVisible(false);
                        cboParticipationRequired.setVisible(false);
                        cboStatusCase.setVisible(false);
                        break;
                }
            };

            processPermissionsDeleteRestProxy = function (processPermissionsUid) {
                var restProxy = new PMRestClient({
                    endpoint: "process-permission/" + processPermissionsUid,
                    typeRequest: "remove",
                    functionSuccess: function (xhr, response) {
                        refreshGridPanelInMainWindow();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'Permission deleted successfully'.translate(),
                    flashContainer: grdpnlProcessPermissions
                });
                restProxy.executeRestClient();
            };

            processPermissionsSetForm = function (option, data) {
                cboGroupOrUser.hideMessageRequired();
                processPermissionsData = data;
                PROCESS_PERMISSIONS_OPTION = option;
                PROCESS_PERMISSIONS_UID = (typeof(processPermissionsData.op_uid) !== "undefined") ? processPermissionsData.op_uid : "";

                disableAllItems();
                winGrdpnlProcessPermissions.showFooter();
                winGrdpnlProcessPermissions.getItems()[1].setVisible(true);

                loadDataFromServerToFields();

                switch (option) {
                    case "POST":
                        winGrdpnlProcessPermissions.setTitle("Create permission".translate());
                        frmProcessPermissions.reset();
                        processPermissionsSetFormByType(cboType.getValue());

                        break;
                    case "PUT":
                        winGrdpnlProcessPermissions.setTitle("Edit permission".translate());
                        cboStatusCase.setValue(processPermissionsData.op_case_status);
                        cboTargetTask.setValue(processPermissionsData.tas_uid);

                        var endpoint;
                        if (processPermissionsData.op_user_relation == 1) {
                            endpoint = "users/" + processPermissionsData.usr_uid;
                        }
                        if (processPermissionsData.op_user_relation == 2) {
                            endpoint = "groups/" + processPermissionsData.usr_uid;
                        }

                        if (endpoint) {
                            var restClient = new PMRestClient({
                                typeRequest: 'get',
                                functionSuccess: function (xhr, response) {
                                    if (response.hasOwnProperty("usr_uid")) {
                                        cboGroupOrUser.set("value", response["usr_uid"]);
                                        cboGroupOrUser.data = response;
                                        cboGroupOrUser.html.find("input").val(response["usr_firstname"] + " " + response["usr_lastname"] + " " + "(" + response["usr_username"] + ")");
                                    }
                                    if (response.hasOwnProperty("grp_uid")) {
                                        cboGroupOrUser.set("value", response["grp_uid"]);
                                        cboGroupOrUser.data = response;
                                        cboGroupOrUser.html.find("input").val(response["grp_title"]);
                                    }
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageError: 'There are problems saving the assigned user, please try again.'.translate()
                            });
                            restClient.setBaseEndPoint(endpoint);
                            restClient.executeRestClient();
                        }

                        cboParticipationRequired.setValue(processPermissionsData.op_participate);
                        cboType.setValue(processPermissionsData.op_obj_type);
                        cboOriginTask.setValue(processPermissionsData.op_task_source);
                        processPermissionsSetFormByType(processPermissionsData.op_obj_type);
                        switch (processPermissionsData.op_obj_type) {
                            case "ANY":
                                cboPermission.setValue(processPermissionsData.op_action);
                                break;
                            case "DYNAFORM":
                                cboDynaForm.setValue(processPermissionsData.op_obj_uid);
                                cboPermission.setValue(processPermissionsData.op_action);
                                break;
                            case "ATTACHMENT":
                                cboPermission.setValue(processPermissionsData.op_action);
                                break;
                            case "INPUT":
                                cboInputDocument.setValue(processPermissionsData.op_obj_uid);
                                cboPermission.setValue(processPermissionsData.op_action);
                                break;
                            case "OUTPUT":
                                cboOutputDocument.setValue(processPermissionsData.op_obj_uid);
                                cboPermission.setValue(processPermissionsData.op_action);
                                break;
                            case "CASES_NOTES":
                            case "SUMMARY_FORM":
                                break;
                            case "MSGS_HISTORY":
                                cboPermission.setValue(processPermissionsData.op_action);
                                break;
                        }
                        break;
                }
                frmProcessPermissions.setFocus();
            };

            cboStatusCase = new PMUI.field.DropDownListField({
                id: "cboStatusCase",
                name: "cboStatusCase",
                controlsWidth: "120px",
                label: "Case Status".translate(),
                value: "ALL",
                options: [
                    {
                        value: "ALL",
                        label: "All".translate()
                    },
                    {
                        value: "DRAFT",
                        label: "DRAFT".translate()
                    },
                    {
                        value: "TO_DO",
                        label: "TO DO".translate()
                    },
                    {
                        value: "PAUSED",
                        label: "PAUSED".translate()
                    },
                    {
                        value: "COMPLETED",
                        label: "COMPLETED".translate()
                    }
                ]
            });

            cboTargetTask = new PMUI.field.DropDownListField({
                id: "cboTargetTask",
                name: "cboTargetTask",
                controlsWidth: "300px",
                label: "Target Task".translate(),
                options: null
            });
            cboGroupOrUser = new SuggestField({
                label: "Group or User".translate(),
                id: "cboGroupOrUser",
                name: "cboGroupOrUser",
                placeholder: "suggest users and groups",
                width: 500,
                required: true,
                separatingText: ["Groups", "Users"],
                dynamicLoad: {
                    data: [
                        {
                            key: "grp_uid",
                            label: ["grp_title"]
                        },
                        {
                            key: "usr_uid",
                            label: ["usr_firstname", "usr_lastname", "(", "usr_username", ")"]
                        }
                    ],
                    keys: {
                        url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE,
                        accessToken: PMDesigner.project.tokens.access_token,
                        endpoints: [
                            {
                                method: "GET",
                                url: 'groups'
                            }, {
                                method: "GET",
                                url: 'users'
                            }
                        ]
                    }
                }
            });

            cboOriginTask = new PMUI.field.DropDownListField({
                id: "cboOriginTask",
                name: "cboOriginTask",
                controlsWidth: "300px",
                label: "Origin Task".translate(),
                options: null
            });

            cboParticipationRequired = new PMUI.field.DropDownListField({
                id: "cboParticipationRequired",
                name: "cboParticipationRequired",
                controlsWidth: "70px",
                label: "Participation required?".translate(),
                value: "0",
                options: [
                    {
                        value: "0",
                        label: "No".translate()
                    },
                    {
                        value: "1",
                        label: "Yes".translate()
                    }
                ]
            });
            notification = new PMUI.field.TextAnnotationField({
                id: "requiredMessage",
                name: "Message",
                textType: PMUI.field.TextAnnotationField.TEXT_TYPES.HTML,
                text: notificationText,
                text_Align: "center"
            });
            optionsType = [
                {
                    value: "ANY",
                    label: "All".translate()
                },
                {
                    value: "DYNAFORM",
                    label: "Dynaform".translate()
                },
                {
                    value: "ATTACHMENT",
                    label: "Attachment".translate()
                },
                {
                    value: "INPUT",
                    label: "Input Document".translate()
                },
                {
                    value: "OUTPUT",
                    label: "Output Document".translate()
                },
                {
                    value: "CASES_NOTES",
                    label: "Cases Notes".translate()
                },
                {
                    value: "MSGS_HISTORY",
                    label: "Messages History".translate()
                },
                {
                    value: "REASSIGN_MY_CASES",
                    label: "Reassign my cases".translate()
                }
            ];

            if (enterprise == "1") {
                optionsType.push({value: "SUMMARY_FORM", label: "Summary Form".translate()});
            }
            // sorting the optionsType
            optionsType.sort(function(a, b) {
                return (a.label > b.label) ? 1 : ((b.label > a.label) ? -1 : 0);
            });

            cboType = new PMUI.field.DropDownListField({
                id: "cboType",
                name: "cboType",
                controlsWidth: "180px",
                label: "Type".translate(),
                value: "ANY",
                options: optionsType,
                onChange: function (newValue, prevValue) {
                    processPermissionsSetFormByType(cboType.getValue());
                }
            });

            cboDynaForm = new PMUI.field.DropDownListField({
                id: "cboDynaForm",
                name: "cboDynaForm",
                controlsWidth: "300px",
                label: "DynaForm".translate(),
                options: [],
                visible: false
            });

            cboInputDocument = new PMUI.field.DropDownListField({
                id: "cboInputDocument",
                name: "cboInputDocument",
                controlsWidth: "300px",
                label: "Input Document".translate(),
                options: [],
                visible: false
            });

            cboOutputDocument = new PMUI.field.DropDownListField({
                id: "cboOutputDocument",
                name: "cboOutputDocument",
                controlsWidth: "300px",
                label: "Output Document".translate(),
                options: [],
                visible: false
            });

            cboPermission = new PMUI.field.DropDownListField({
                id: "cboPermission",
                name: "cboPermission",
                controlsWidth: "100px",
                label: "Permission".translate(),
                value: "VIEW",
                options: [
                    {
                        value: "VIEW",
                        label: "View".translate()
                    },
                    {
                        value: "BLOCK",
                        label: "Block".translate()
                    }
                ],
                visible: true
            });

            frmProcessPermissions = new PMUI.form.Form({
                id: "frmProcessPermissions",

                title: "",
                width: "890px",
                items: [
                    cboType,
                    cboStatusCase,
                    cboTargetTask,
                    cboOriginTask,
                    cboParticipationRequired,
                    cboDynaForm,
                    cboInputDocument,
                    cboOutputDocument,
                    cboPermission
                ]
            });

            btnCreate = new PMUI.ui.Button({
                id: "btnCreate",
                text: "Create".translate(),
                height: "36px",
                width: 100,
                style: {
                    cssClasses: [
                        "mafe-button-create"
                    ]
                },

                handler: function () {
                    frmProcessPermissions.reset();
                    processPermissionsDataIni = {};

                    processPermissionsDataIni.op_case_status = "ALL";
                    processPermissionsDataIni.tas_uid = "";
                    processPermissionsDataIni.usr_uid = "";
                    processPermissionsDataIni.op_task_source = "";
                    processPermissionsDataIni.op_participate = "0";
                    processPermissionsDataIni.op_obj_type = "ANY";
                    processPermissionsDataIni.op_obj_uid = "";
                    processPermissionsDataIni.op_action = "VIEW";

                    processPermissionsSetForm("POST", {});
                }
            });

            grdpnlProcessPermissions = new PMUI.grid.GridPanel({
                id: "grdpnlProcessPermissions",
                filterPlaceholder: "Search ...".translate(),
                emptyMessage: 'No records found'.translate(),
                nextLabel: 'Next'.translate(),
                previousLabel: 'Previous'.translate(),
                customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                    return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
                },
                pageSize: 10,
                width: "96%",
                tableContainerHeight: 374,
                //height: DEFAULT_WINDOW_HEIGHT - 60,
                style: {
                    cssClasses: ["mafe-gridPanel"]
                },
                filterable: true,
                columns: [
                    {
                        columnData: "group_user",
                        title: "Group or User".translate(),
                        alignmentCell: 'left',
                        width: "190px",
                        sortable: true
                    },
                    {
                        columnData: "op_obj_type",
                        title: "Type".translate(),
                        alignmentCell: 'left',
                        width: "100px",
                        sortable: true
                    },
                    {
                        columnData: "participated",
                        title: "Participation".translate(),
                        alignmentCell: 'left',
                        width: "115px",
                        sortable: true
                    },
                    {
                        columnData: "object",
                        title: "Object".translate(),
                        alignmentCell: 'left',
                        width: "158px",
                        sortable: true
                    },
                    {
                        columnData: "op_action",
                        title: "Permission".translate(),
                        alignmentCell: 'left',
                        width: "100px",
                        sortable: true
                    },
                    {
                        columnData: "op_case_status",
                        title: "Status".translate(),
                        alignmentCell: 'left',
                        width: "70px",
                        sortable: true
                    },
                    {
                        id: 'grdpnlProcessPermissionsButtonEdit',
                        dataType: "button",
                        title: "",
                        buttonLabel: "Edit".translate(),
                        width: "70px",
                        buttonStyle: {
                            cssClasses: [
                                "mafe-button-edit"
                            ]
                        },

                        onButtonClick: function (row, grid) {
                            var data;
                            frmProcessPermissions.reset();
                            data = row.getData();
                            processPermissionGetRestProxy(data.op_uid);
                        }
                    },
                    {
                        id: 'grdpnlProcessPermissionsButtonDelete',
                        dataType: "button",
                        title: "",
                        buttonLabel: "Delete".translate(),
                        width: "80px",
                        buttonStyle: {
                            cssClasses: [
                                "mafe-button-delete"
                            ]
                        },

                        onButtonClick: function (row, grid) {
                            var data = row.getData(), msgWarning;
                            msgWarning = new PMUI.ui.MessageWindow({
                                id: "msgWarning",
                                windowMessageType: 'warning',
                                width: 490,
                                title: "Permissions".translate(),
                                message: "Do you want to delete this permission?".translate(),
                                footerItems: [
                                    {
                                        id: 'msgWarningButtonNo',
                                        text: "No".translate(),
                                        handler: function () {
                                            msgWarning.close();
                                        },
                                        buttonType: "error"
                                    },
                                    {
                                        id: 'msgWarningButtonYes',
                                        text: "Yes".translate(),
                                        handler: function () {
                                            processPermissionsDeleteRestProxy(data.op_uid);
                                            msgWarning.close();
                                        },
                                        buttonType: "success"
                                    }
                                ]
                            });

                            msgWarning.open();
                            msgWarning.dom.titleContainer.style.height = '17px';
                            msgWarning.showFooter();
                        }
                    }
                ],
                dataItems: null
            });

            winGrdpnlProcessPermissions = new PMUI.ui.Window({
                id: "winGrdpnlProcessPermissions",
                title: "Permissions".translate(),
                width: DEFAULT_WINDOW_WIDTH,
                height: DEFAULT_WINDOW_HEIGHT,
                buttonPanelPosition: "bottom",
                footerAlign: "right",
                onBeforeClose: function () {
                    clickedClose = true;
                    isDirtyFormProcessPermission();
                },
                footerItems: [
                    {
                        id: "btnCancel",
                        text: "Cancel".translate(),
                        buttonType: "error",
                        handler: function () {
                            clickedClose = false;
                            isDirtyFormProcessPermission();
                        }
                    },
                    {
                        id: "btnSave",
                        text: "Save".translate(),
                        buttonType: "success",
                        handler: function () {
                            var cboGroupOrUserValue = "", groupOrUser, data;

                            if (frmProcessPermissions.isValid() && cboGroupOrUser.isValid()) {
                                if (cboGroupOrUser.data) {
                                    if (cboGroupOrUser.data.hasOwnProperty("usr_uid")) {
                                        cboGroupOrUserValue = "1|" + cboGroupOrUser.get("value");
                                    }
                                    if (cboGroupOrUser.data.hasOwnProperty("grp_uid")) {
                                        cboGroupOrUserValue = "2|" + cboGroupOrUser.get("value");
                                    }
                                } else {
                                    cboGroupOrUserValue = "";
                                }
                                groupOrUser = cboGroupOrUserValue.split("|");

                                data = {
                                    op_case_status: cboStatusCase.getValue(),
                                    tas_uid: cboTargetTask.getValue() === '0' ? '' : cboTargetTask.getValue(),
                                    op_user_relation: groupOrUser[0],
                                    usr_uid: groupOrUser[1],
                                    op_task_source: cboOriginTask.getValue() === '0' ? '' : cboOriginTask.getValue(),
                                    op_participate: cboParticipationRequired.getValue()
                                };

                                switch (cboType.getValue()) {
                                    case "DYNAFORM":
                                        data["op_obj_type"] = cboType.getValue();
                                        data["dynaforms"] = cboDynaForm.getValue();
                                        data["op_action"] = cboPermission.getValue();
                                        break;
                                    case "INPUT":
                                        data["op_obj_type"] = cboType.getValue();
                                        data["inputs"] = cboInputDocument.getValue();
                                        data["op_action"] = cboPermission.getValue();
                                        break;
                                    case "OUTPUT":
                                        data["op_obj_type"] = cboType.getValue();
                                        data["outputs"] = cboOutputDocument.getValue();
                                        data["op_action"] = cboPermission.getValue();
                                        break;
                                    case "CASES_NOTES":
                                        data["op_obj_type"] = cboType.getValue();
                                        data["op_action"] = cboPermission.getValue();
                                        break;
                                    case "REASSIGN_MY_CASES":
                                        data = {};
                                        data["op_user_relation"] =  groupOrUser[0];
                                        data["usr_uid"] = groupOrUser[1];
                                        data["tas_uid"] = cboTargetTask.getValue() === '0' ? '' : cboTargetTask.getValue();
                                        data["op_obj_type"] = cboType.getValue();
                                        break;
                                    default:
                                        data["op_obj_type"] = cboType.getValue();
                                        data["op_action"] = cboPermission.getValue();
                                        break;
                                }
                                switch (PROCESS_PERMISSIONS_OPTION) {
                                    case "POST":
                                        processPermissionsPostRestProxy(data);
                                        break;
                                    case "PUT":
                                        processPermissionsPutRestProxy(PROCESS_PERMISSIONS_UID, data);
                                        break;
                                }
                            } else {
                                cboGroupOrUser.showMessageRequired();
                                frmProcessPermissions.addItem(notification)
                            }

                            cboGroupOrUser.html.find("input").val("");
                            cboGroupOrUser.value = "";
                        }
                    }
                ]
            });

            winGrdpnlProcessPermissions.addItem(grdpnlProcessPermissions);
            winGrdpnlProcessPermissions.addItem(frmProcessPermissions);

            refreshGridPanelInMainWindow();
            if (typeof listProcessPermissions !== "undefined") {
                winGrdpnlProcessPermissions.open();
                $(cboGroupOrUser.createHTML()).insertBefore(cboType.html);


                cboGroupOrUser.html.find("input").val("");
                jQuery(grdpnlProcessPermissions.html).css({
                    margin: "2px"
                });
                winGrdpnlProcessPermissions.body.style.height = "auto";
                $('#grdpnlProcessPermissions .pmui-textcontrol').css({'margin-top': '5px', width: '250px'});
                winGrdpnlProcessPermissions.defineEvents();
                applyStyleWindowForm(winGrdpnlProcessPermissions);

                grdpnlProcessPermissions.dom.toolbar.appendChild(btnCreate.getHTML());
                btnCreate.defineEvents();
                disableAllItems();
                refreshGridPanelInMainWindow();
            }
        };

        PMDesigner.processPermissions.create = function () {
            PMDesigner.processPermissions();

            frmProcessPermissions.reset();
            processPermissionsDataIni = {};

            processPermissionsDataIni.op_case_status = "ALL";
            processPermissionsDataIni.tas_uid = "";
            processPermissionsDataIni.usr_uid = "";
            processPermissionsDataIni.op_task_source = "";
            processPermissionsDataIni.op_participate = "0";
            processPermissionsDataIni.op_obj_type = "ANY";
            processPermissionsDataIni.op_obj_uid = "";
            processPermissionsDataIni.op_action = "VIEW";

            processPermissionsSetForm("POST", {});
        };
    }()
);

(function () {
    var winHtmlShow, loadValuesStartMessage;

    PMDesigner.startMessage = function (element) {
        var winGrdpnlStartMessage,
            btnNew,
            cboUser,
            cboDynaForm,
            btnGenerateStartMessagePage,
            frmDataStartMessage,
            frmHtml,
            winFrmDataStartMessage,
            restProxy,
            disableAllItems,
            winFrmStartMessageShow,
            updateStartMessage,
            loadDataDynaform,
            loadDataUsers,
            loadDataForm,
            listUsers = [],
            cboMethod,
            listDynaforms = [],
            dataForm = [],
            enableGenerateWebEntry,
            btnSaveStartMessagePage,
            btnStartMessageCancel,
            btnClose,
            startMessage = element;

        disableAllItems = function () {
            winGrdpnlStartMessage.getItems()[0].setVisible(false);
            winGrdpnlStartMessage.getItems()[1].setVisible(false);
            btnGenerateStartMessagePage.setVisible(false);
            btnStartMessageCancel.setVisible(false);
            btnClose.setVisible(false);
            winGrdpnlStartMessage.hideFooter();
        };

        winFrmStartMessageShow = function () {
            disableAllItems();
            frmDataStartMessage.reset();
            winGrdpnlStartMessage.showFooter();
            winGrdpnlStartMessage.getItems()[0].setVisible(true);
            btnGenerateStartMessagePage.setVisible(true);
            btnStartMessageCancel.setVisible(true);
            loadDataUsers();
            loadDataDynaform();
            loadDataForm();
            frmDataStartMessage.setFocus();
        };

        winHtmlShow = function (msgHtml) {
            if (typeof msgHtml == 'undefined') {
                msgHtml = dataForm.we_data;
                if (dataForm.we_method == "WS") {
                    window.open(msgHtml);
                    winGrdpnlStartMessage.close();
                    return false;
                }
            }
            disableAllItems();
            winGrdpnlStartMessage.showFooter();
            winGrdpnlStartMessage.footer.getItems()[1].setVisible(false);
            btnClose.setVisible(true);
            winGrdpnlStartMessage.getItems()[1].setVisible(true);
            winGrdpnlStartMessage.getItems()[1].setWidth(925);
            winGrdpnlStartMessage.getItems()[1].setHeight(440);
            winGrdpnlStartMessage.getItems()[1].hideHeader();
            frmHtml.getFields()[0].setHeight(396);
            frmHtml.getItems()[0].setValue(msgHtml);
            frmHtml.panel.style.addProperties({'box-sizing': 'initial'});
            frmHtml.style.addProperties({marginLeft: '16px'});
            frmHtml.setFocus();
            return true;
        };

        loadValuesStartMessage = function (flag) {
            var viewFlagForm,
                restClient,
                response;
            listUsers = [];
            listDynaforms = [];
            dataForm = [];
            restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: 'activity/' + startMessage.ports.get(0).connection.flo_element_dest + '/assignee/all',
                            method: 'GET'
                        },
                        {
                            url: "activity/" + startMessage.ports.get(0).connection.flo_element_dest + "/steps",
                            method: 'GET'
                        }, {
                            url: 'web-entry/' + startMessage.evn_uid,
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    listUsers = response[0].response;
                    listDynaforms = response[1].response;
                    dataForm = response[2].response;
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.executeRestClient();
            if (flag) {
                viewFlagForm = false;
                if (typeof dataForm == 'object' && dataForm.we_data != null) {
                    viewFlagForm = true;
                }
                response = [listUsers.length, listDynaforms.length, viewFlagForm];
                return response;
            }
            return true;
        };

        updateStartMessage = function (data) {
            restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: "web-entry/" + startMessage.evn_uid,
                            method: 'PUT',
                            data: data
                        },
                        {
                            url: 'web-entry/' + startMessage.evn_uid,
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    dataForm = response[1].response;
                    if (data.we_method == "HTML") {
                        winHtmlShow(response.we_data);
                    }
                    btnGenerateStartMessagePage.setVisible(false);
                    btnStartMessageCancel.setVisible(false);
                    btnClose.setVisible(true);
                    winGrdpnlStartMessage.footer.getItems()[1].setVisible(false);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: ["There are problems updating the Web Entry, please try again.".translate()],
                messageSuccess: ['Web Entry updated successfully'.translate()],
                flashContainer: frmDataStartMessage
            });
            restClient.executeRestClient();
        };

        loadDataDynaform = function () {
            var i;
            cboDynaForm.clearOptions();
            for (i = 0; i <= listDynaforms.length - 1; i++) {
                if (listDynaforms[i].step_type_obj == "DYNAFORM") {
                    cboDynaForm.addOption({
                        value: listDynaforms[i].step_uid_obj,
                        label: listDynaforms[i].obj_title
                    });
                }
            }
        };

        loadDataUsers = function () {
            var i;
            cboUser.clearOptions();
            for (i = 0; i <= listUsers.length - 1; i++) {
                cboUser.addOption({
                    value: listUsers[i].aas_uid,
                    label: listUsers[i].aas_name + ' ' + listUsers[i].aas_lastname
                });
            }
        };

        loadDataForm = function () {
            cboUser.setValue(dataForm.usr_uid);
            cboDynaForm.setValue(dataForm.dyn_uid);
            cboMethod.setValue(dataForm.we_method);
        };

        enableGenerateWebEntry = function () {
            btnGenerateStartMessagePage.setVisible(true);
            btnStartMessageCancel.setVisible(true);
            btnClose.setVisible(false);
            winGrdpnlStartMessage.footer.getItems()[1].setVisible(true);
        };
        cboUser = new PMUI.field.DropDownListField({
            id: "cboUser",
            name: "cboUser",
            label: "User".translate(),
            required: true,
            options: null,
            onChange: function (newVal, oldVal) {
                enableGenerateWebEntry();
            },
            controlsWidth: 350
        });

        cboDynaForm = new PMUI.field.DropDownListField({
            id: "cboDynaForm",
            name: "cboDynaForm",
            label: "Initial Dynaform".translate(),
            options: null,
            required: true,
            onChange: function (newVal, oldVal) {
                enableGenerateWebEntry();
            },
            controlsWidth: 350
        });

        cboMethod = new PMUI.field.DropDownListField({
            id: "cboMethod",
            name: "cboMethod",
            label: "Method".translate(),
            value: "WS",
            options: [
                {
                    value: "WS",
                    label: "PHP pages with Web Services".translate()
                },
                {
                    value: "HTML",
                    label: "Single HTML".translate()
                }
            ],
            onChange: function (newVal, oldVal) {
                enableGenerateWebEntry();
            },
            controlsWidth: 350
        });

        btnGenerateStartMessagePage = new PMUI.ui.Button({
            id: "btnGenerateStartMessagePage",
            text: "Generate Web Entry Page".translate(),
            handler: function () {
                var flagGenerateStartMessage = 0, data;
                data = {
                    tas_uid: startMessage.ports.get(0).connection.flo_element_dest,
                    dyn_uid: cboDynaForm.getValue(),
                    usr_uid: cboUser.getValue(),
                    we_title: startMessage.evn_name,
                    we_description: '',
                    we_method: cboMethod.getValue(),
                    we_input_document_access: 1
                };

                if (frmDataStartMessage.isValid()) {
                    updateStartMessage(data);
                }
            },
            buttonType: 'success',
            height: 31,
            visible: true
        });
        btnSaveStartMessagePage = new PMUI.ui.Button({
            id: "btnGenerateStartMessagePage",
            text: "Save".translate(),
            handler: function () {
                var flagGenerateStartMessage = 0, data;
                data = {
                    tas_uid: startMessage.ports.get(0).connection.flo_element_dest,
                    dyn_uid: cboDynaForm.getValue(),
                    usr_uid: cboUser.getValue(),
                    we_title: startMessage.evn_name,
                    we_description: '',
                    we_method: cboMethod.getValue(),
                    we_input_document_access: 1
                };

                if (frmDataStartMessage.isValid()) {
                    updateStartMessage(data);
                }
            },
            buttonType: 'success',
            height: 31,
            visible: true
        });

        frmDataStartMessage = new PMUI.form.Form({
            id: "frmDataStartMessage",
            title: "",
            width: DEFAULT_WINDOW_WIDTH - 70,
            items: [
                cboUser,
                cboDynaForm,
                cboMethod
            ],
            visibleHeader: false
        });

        btnClose = new PMUI.ui.Button({
            id: "btnClose",
            text: "Close".translate(),
            handler: function () {
                winGrdpnlStartMessage.close();
            },
            buttonType: 'success',
            height: 31
        });

        btnStartMessageCancel = new PMUI.ui.Button({
            id: "btnStartMessageCancel",
            text: "Cancel".translate(),
            handler: function () {
                var message_window;
                if (frmDataStartMessage.isDirty()) {
                    message_window = new PMUI.ui.MessageWindow({
                        windowMessageType: 'warning',
                        id: "cancelMessageStartTimer",
                        title: "Start Message Event".translate(),
                        message: 'Are you sure you want to discard your changes?'.translate(),
                        bodyHeight: 'auto',
                        width: 490,
                        footerItems: [
                            {
                                text: 'No'.translate(),
                                handler: function () {
                                    message_window.close();
                                },
                                buttonType: "error"
                            },
                            {
                                text: 'Yes'.translate(),
                                handler: function () {
                                    message_window.close();
                                    winGrdpnlStartMessage.close();
                                },
                                buttonType: "success"
                            }
                        ]
                    });
                    message_window.open();
                    message_window.showFooter();
                } else {
                    frmDataStartMessage.reset();
                    winGrdpnlStartMessage.close();
                }
            }
        });

        frmHtml = new PMUI.form.Form({
            id: "frmHtml",
            title: "",
            width: DEFAULT_WINDOW_WIDTH - 43,
            items: [
                {
                    id: "txtHtml",
                    name: "txtHtml",
                    pmType: "textarea",
                    valueType: "string",
                    rows: 400,
                    value: '',
                    controlsWidth: DEFAULT_WINDOW_WIDTH - 50,
                    labelVisible: false,
                    style: {cssClasses: ['mafe-textarea-resize']}
                }
            ]
        });

        winGrdpnlStartMessage = new PMUI.ui.Window({
            id: "winGrdpnlStartMessage",
            title: "Start Message Event".translate(),
            height: DEFAULT_WINDOW_HEIGHT,
            width: DEFAULT_WINDOW_WIDTH,
            buttonPanelPosition: "top",
            buttons: [btnSaveStartMessagePage, {pmType: 'label', text: 'or'}, btnStartMessageCancel, btnClose]
        });

        winGrdpnlStartMessage.addItem(frmDataStartMessage);

        openForm = function () {
            winGrdpnlStartMessage.open();
            winGrdpnlStartMessage.defineEvents();
            applyStyleWindowForm(winGrdpnlStartMessage);
            winGrdpnlStartMessage.footer.html.style.textAlign = 'right';
            winFrmStartMessageShow();
        }
    };

    PMDesigner.startMessage.openForm = function (element) {
        openForm();
    };

    PMDesigner.startMessage.viewForm = function (element) {
        openForm();
    };

    PMDesigner.startMessage.validate = function (starMessageEvent) {
        if (starMessageEvent.ports.isEmpty()) {
            PMDesigner.msgFlash('Must connect to a Task'.translate(), document.body, 'error', 4000, 5);
            return [false, false];
        }
        PMDesigner.startMessage(starMessageEvent);
        response = loadValuesStartMessage(true);
        if (response[0] == 0) {
            PMDesigner.msgFlash('The task doesn\'t have assigned users'.translate(), document.body, 'info', 4000);
            return [false, false];
        }
        if (response[1] == 0) {
            PMDesigner.msgFlash('The task doesn\'t have assigned Dynaforms'.translate(), document.body, 'info', 4000);
            return [false, false];
        }
        return [true, response[2]];
    }
}());

(function () {
    var windowPropSub;

    PMDesigner.propertiesSubProcess = function (activity) {
        var typeVariables = ['@@', '@#', '@=', '@&'],
            restClient,
            isDirtyFormSubProcess,
            getSubProcess,
            formVarTexOriginOut,
            updateSubProcess,
            formVarTexOriginIn,
            loadDropProcess,
            formVarTexTargetOut,
            formVarTexTargetIn,
            windowPropertiesSub,
            formProperties,
            sepInputs,
            gridVariablesOut,
            gridVariablesIn,
            formVariablesPanelOut,
            formVariablesPanelIn,
            validateVariable,
            formVarButtonAddOut,
            formVarButtonAddIn,
            labelVariablesOut,
            labelVariablesIn,
            loadDataServer,
            loadActivity,
            isDirty = false;

        restClient = new PMRestClient({
            endpoint: 'projects',
            typeRequest: 'get',
            functionSuccess: function (xhr, response) {
                for (var i = 0; i < response.length; i += 1) {
                    if (response[i].prj_uid != PMDesigner.project.projectId) {
                        formProperties.getField('out_doc_process').addOption({
                            label: response[i].prj_name,
                            value: response[i].prj_uid
                        });
                    }
                }
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            },
            messageError: "There are problems getting the output documents, please try again.".translate()
        });
        isDirtyFormSubProcess = function () {
            var message_window;
            if (formProperties.isDirty() || isDirty) {
                message_window = new PMUI.ui.MessageWindow({
                    windowMessageType: 'warning',
                    width: 490,
                    bodyHeight: 'auto',
                    id: "cancelSaveSubprocPropertiesWin",
                    title: "Sub-process Properties".translate(),
                    message: 'Are you sure you want to discard your changes?'.translate(),
                    footerItems: [
                        {
                            text: "No".translate(),
                            handler: function () {
                                message_window.close();
                            },
                            buttonType: "error"
                        },
                        {
                            text: "Yes".translate(),
                            handler: function () {
                                message_window.close();
                                formProperties.reset();
                                gridVariablesOut.setDataItems("");
                                gridVariablesIn.setDataItems("");
                                formProperties.setDirty(false);
                                windowPropertiesSub.close();
                            },
                            buttonType: "success"
                        }
                    ]
                });
                message_window.open();
                message_window.showFooter();
            } else {
                windowPropertiesSub.close();
            }
        };
        getSubProcess = function () {
            var restProxy = new PMRestClient({
                endpoint: "subprocess/" + activity.act_uid,
                typeRequest: "get",
                functionSuccess: function (xhr, response) {
                    var yout,
                        oout,
                        jout,
                        itemsOut,
                        i,
                        xin,
                        yin,
                        oin,
                        jin,
                        dout,
                        din,
                        itemsIn,
                        xout;
                    formProperties.getField('out_doc_title').setValue(response.spr_name);
                    formProperties.getField('out_doc_process').setValue(response.spr_pro);
                    formProperties.getField('out_doc_type').setValue(response.spr_synchronous);

                    if (response.spr_variables_out != false) {
                        xout = JSON.stringify(response.spr_variables_out);
                        yout = xout.substring(1, xout.length - 1);
                        oout = yout.replace(/"/g, '');
                        jout = oout.split(',');

                        itemsOut = [];
                        for (i = 0; i < jout.length; i += 1) {
                            dout = jout[i].split(':');
                            itemsOut.push({
                                origin: dout[0],
                                target: dout[1]
                            });
                        }
                        gridVariablesOut.setDataItems(itemsOut);

                        gridVariablesIn.setVisible(false);
                        formVariablesPanelIn.setVisible(false);
                    }

                    if (response.spr_variables_in != false && response.spr_variables_in != undefined) {
                        xin = JSON.stringify(response.spr_variables_in);
                        yin = xin.substring(1, xin.length - 1);
                        oin = yin.replace(/"/g, '');
                        jin = oin.split(',');

                        itemsIn = [];
                        for (i = 0; i < jin.length; i += 1) {
                            din = jin[i].split(':');
                            itemsIn.push({
                                origin: din[0],
                                target: din[1]
                            });
                        }
                        gridVariablesIn.setDataItems(itemsIn);
                    }

                    if (response.spr_synchronous == "1") {
                        gridVariablesIn.setVisible(true);
                        formVariablesPanelIn.setVisible(true);
                    }
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restProxy.executeRestClient();
        };

        updateSubProcess = function (data) {
            var restProxy = new PMRestClient({
                endpoint: "subprocess/" + activity.act_uid,
                typeRequest: "update",
                data: data,
                functionSuccess: function (xhr, response) {
                    var name = formProperties.getData().out_doc_title;
                    activity.setName(name);
                    activity.setActName(name);
                    PMDesigner.project.dirty = true;

                    formProperties.reset();
                    gridVariablesOut.setDataItems("");
                    gridVariablesIn.setDataItems("");
                    formProperties.setDirty(false);
                    windowPropertiesSub.close();
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restProxy.executeRestClient();
        };

        formVarTexOriginOut = new CriteriaField({
            id: 'idformVarTexOriginOut',
            pmType: "text",
            name: 'nmformVarTexOriginOut',
            placeholder: 'Origin'.translate(),
            labelVisible: false,
            controlsWidth: 150
        });

        formVarTexOriginIn = new CriteriaField({
            id: 'idformVarTexOriginIn',
            pmType: "text",
            name: 'nmformVarTexOriginIn',
            placeholder: 'Select Origin Process'.translate(),
            labelVisible: false,
            controlsWidth: 150
        });

        formVarTexTargetOut = new CriteriaField({
            id: 'idformVarTexTargetOut',
            pmType: "text",
            name: 'nmformVarTexTargetOut',
            placeholder: 'Select Target Process'.translate(),
            labelVisible: false,
            controlsWidth: 150,
            required: true
        });

        formVarTexTargetIn = new CriteriaField({
            id: 'idformVarTexTargetIn',
            pmType: "text",
            name: 'nmformVarTexTargetIn',
            placeholder: 'Target'.translate(),
            labelVisible: false,
            controlsWidth: 150
        });

        windowPropertiesSub = new PMUI.ui.Window({
            id: 'propSubWindow',
            title: "Sub-process Properties".translate(),
            height: DEFAULT_WINDOW_HEIGHT,
            width: DEFAULT_WINDOW_WIDTH,
            bodyHeight: '465px',
            bodyWidth: '900px',
            onBeforeClose: function () {
                isDirtyFormSubProcess();
            },
            buttons: [
                {
                    id: 'propSubButtonClose',
                    text: "Close".translate(),
                    buttonType: 'error',
                    handler: function () {
                        isDirtyFormSubProcess();
                    }
                },
                {
                    id: 'propSubButtonSave',
                    text: "Save".translate(),
                    buttonType: 'success',
                    handler: function () {
                        if (!formProperties.isValid()) {
                            return;
                        }
                        var propertiesData = formProperties.getData();
                        var variablesOutData = gridVariablesOut.getData();
                        var variablesOut = {};
                        if (variablesOutData.length > "0") {
                            for (i = 0; i < variablesOutData.length; i += 1) {
                                variablesOut[variablesOutData[i].origin] = variablesOutData[i].target;
                            }
                        }
                        var variablesIn = {};
                        if (propertiesData.out_doc_type == "1") {
                            var variablesInData = gridVariablesIn.getData();
                            if (variablesInData.length > "0") {
                                for (j = 0; j < variablesInData.length; j += 1) {
                                    variablesIn[variablesInData[j].origin] = variablesInData[j].target;
                                }
                            }
                        }

                        var dataToSend = {
                            spr_pro: propertiesData.out_doc_process,
                            spr_tas: propertiesData.spr_tas,
                            spr_name: propertiesData.out_doc_title,
                            spr_synchronous: propertiesData.out_doc_type,
                            spr_variables_out: variablesOut,
                            spr_variables_in: variablesIn
                        };

                        updateSubProcess(dataToSend);
                    }
                }
            ],
            buttonPanelPosition: 'bottom',
            buttonsPosition: 'right'
        });

        formProperties = new PMUI.form.Form({
            id: 'propSubForm',
            title: "",
            fieldset: true,
            visibleHeader: false,
            width: 926,
            height: 'auto',
            items: [
                {
                    id: 'propSubFormTitle',
                    pmType: "text",
                    name: 'out_doc_title',
                    label: "Sub-Process name".translate(),
                    required: true,
                    controlsWidth: 300
                },
                {
                    id: 'propSubFormProcess',
                    pmType: "dropdown",
                    name: 'out_doc_process',
                    label: "Process".translate(),
                    controlsWidth: 300,
                    required: true,
                    options: [
                        {
                            label: "- Select a process -".translate(),
                            value: "",
                            disabled: true,
                            selected: true
                        }
                    ],
                    value: "",
                    onChange: function (a, b) {
                        if (a.trim().length !== 0) {
                            formVarTexTargetOut.buttonHTML.enable();
                            formVarTexOriginIn.buttonHTML.enable();
                            formVarTexTargetOut.controls[0].setPlaceholder("Target");
                            formVarTexOriginIn.controls[0].setPlaceholder("Origin");
                        } else {
                            formVarTexTargetOut.buttonHTML.disable();
                            formVarTexOriginIn.buttonHTML.disable();
                        }
                        formVarTexTargetOut.setProcess(a);
                        formVarTexOriginIn.setProcess(a);
                        loadActivity(a);
                    }
                },
                {
                    id: 'propSubFormActivity',
                    pmType: "dropdown",
                    name: 'spr_tas',
                    label: "Starting activity".translate(),
                    controlsWidth: 300,
                    required: true,
                    options: [
                        {
                            label: "- Select starting activity -".translate(),
                            value: "",
                            disabled: true,
                            selected: true
                        }
                    ],
                    value: "",
                    onChange: function (a, b) {
                    }
                },
                {
                    id: 'propSubFormType',
                    pmType: "dropdown",
                    name: 'out_doc_type',
                    label: "Type".translate(),
                    controlsWidth: 150,
                    required: true,
                    options: [
                        {
                            label: "Asynchronous".translate(),
                            value: "0"
                        },
                        {
                            label: "Synchronous".translate(),
                            value: "1"
                        }
                    ],
                    value: "0",
                    onChange: function (a, b) {
                        isDirty = true;
                    }
                }
            ],
            onChange: function (newValue, prevValue) {
                switch (newValue.value) {
                    case "1" :
                        gridVariablesIn.setVisible(true);
                        gridVariablesIn.style.addProperties({marginLeft: '45px'});
                        formVariablesPanelIn.setVisible(true);
                        formVariablesPanelIn.getItems()[2].setWidth(80);
                        $(formVariablesPanelIn.html).css({width: '850px', marginLeft: '45px'});
                        windowPropertiesSub.getItems()[4].setVisible(true);
                        break;
                    case "0":
                        gridVariablesIn.setVisible(false);
                        formVariablesPanelIn.setVisible(false);
                        windowPropertiesSub.getItems()[4].setVisible(false);
                        break;
                    default :
                        break;
                }
            }
        });

        sepInputs = new PMSeparatorLineField({
            controlHeight: '1px',
            controlColor: "#CDCDCD",
            controlsWidth: "890px",
            marginLeft: '0%'
        });

        formProperties.addItem(sepInputs);

        gridVariablesOut = new PMUI.grid.GridPanel({
            id: 'propSubGridVariablesOut',
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            pageSize: 10,
            style: {
                cssClasses: ["mafe-gridPanel"]
            },
            columns: [
                {
                    title: 'Origin'.translate(),
                    dataType: 'string',
                    width: '40%',
                    alignmentCell: 'left',
                    columnData: "origin"
                },
                {
                    title: 'Target'.translate(),
                    dataType: 'string',
                    width: '40%',
                    alignmentCell: 'left',
                    columnData: "target"
                },
                {
                    id: 'propSubGridVariablesOutButtonDelete',
                    title: '',
                    dataType: 'button',
                    width: '20%',
                    buttonLabel: 'Delete'.translate(),
                    onButtonClick: function (row, grid) {
                        grid.removeItem(row);
                        isDirty = true;
                    },
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-delete'
                        ]
                    }

                }
            ]
        });

        gridVariablesIn = new PMUI.grid.GridPanel({
            id: 'propSubGridVariablesIn',
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            pageSize: 10,
            columns: [
                {
                    title: 'Origin'.translate(),
                    dataType: 'string',
                    width: '40%',
                    alignmentCell: 'left',
                    columnData: "origin"
                },
                {
                    title: 'Target'.translate(),
                    dataType: 'string',
                    width: '40%',
                    alignmentCell: 'left',
                    columnData: "target"
                },
                {
                    id: 'propSubGridVariablesInButtonDelete',
                    title: '',
                    dataType: 'button',
                    width: '20%',
                    buttonLabel: 'Delete'.translate(),
                    onButtonClick: function (row, grid) {
                        grid.removeItem(row);
                        isDirty = true;
                    },
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-delete'
                        ]
                    }
                }
            ]
        });

        formVariablesPanelOut = new PMUI.core.Panel({
            id: "formVariablesPanelOut",
            layout: "hbox",
            fieldset: true,
            width: DEFAULT_WINDOW_WIDTH - 70
        });

        formVariablesPanelIn = new PMUI.core.Panel({
            id: "formVariablesPanelIn",
            layout: "hbox",
            fieldset: true,
            legend: "Variables In".translate(),
            width: DEFAULT_WINDOW_WIDTH - 70
        });

        validateVariable = function (field) {
            var value;
            field.controls[0].style.removeClasses(['error'])
            value = field.getValue();
            if (value == '') {
                PMDesigner.msgWinWarning('Please insert variable before adding to the list.'.translate());
                field.controls[0].style.addClasses(['error'])
                return false;
            }
            if (typeVariables.indexOf(String(value.substring(0, 2))) != -1) {
                return true;
            }
            PMDesigner.msgWinWarning("The value introduced doesn\'t have the correct format with a vallid prefix (@@, @#, @=, @&)".translate());
            field.controls[0].style.addClasses(['error'])
            return false;
        };

        formVarButtonAddOut = new PMUI.ui.Button({
            id: 'formVarButtonAddOut',
            text: 'Add'.translate(),
            width: 60,
            visible: false,
            buttonType: "success",
            buttonStyle: {
                cssClasses: [
                    'mafe-button-properties'
                ]
            },
            style: {
                cssProperties: {
                    padding: "5px"
                }
            },
            handler: function () {
                var gridOut, i;
                if (validateVariable(formVarTexOriginOut) && validateVariable(formVarTexTargetOut)) {
                    a = formVarTexOriginOut.getValue();
                    b = formVarTexTargetOut.getValue();
                    gridVariablesOut.addDataItem({origin: a, target: b});
                    formVarTexOriginOut.setValue("");
                    formVarTexTargetOut.setValue("");
                    isDirty = true;

                    gridOut = document.getElementById("propSubGridVariablesOut").getElementsByTagName("table")[0];
                    i = gridOut.rows.length - 1;
                    gridOut.getElementsByClassName("pmui pmui-button")[i].style.marginTop = "2px";
                }
            }
        });

        formVarButtonAddIn = new PMUI.ui.Button({
            id: 'formVarButtonAddIn',
            text: 'Add'.translate(),
            width: 60,
            buttonStyle: {
                cssClasses: [
                    'mafe-button-properties'
                ]
            },
            style: {
                cssProperties: {
                    padding: "5px",
                }
            },
            buttonType: 'success',
            handler: function () {
                var gridOut, i;
                if (validateVariable(formVarTexOriginIn) && validateVariable(formVarTexTargetIn)) {
                    a = formVarTexOriginIn.getValue();
                    b = formVarTexTargetIn.getValue();
                    gridVariablesIn.addDataItem({origin: a, target: b});
                    formVarTexOriginIn.setValue("");
                    formVarTexTargetIn.setValue("");
                    isDirty = true;

                    gridOut = document.getElementById("propSubGridVariablesIn").getElementsByTagName("table")[0];
                    i = gridOut.rows.length - 1;
                    gridOut.getElementsByClassName("pmui pmui-button")[i].style.marginTop = "2px";
                }
            }
        });

        labelVariablesOut = new PMUI.ui.TextLabel({
            textMode: 'plain',
            text: 'Variables Out'.translate()
        });

        labelVariablesIn = new PMUI.ui.TextLabel({
            textMode: 'plain',
            text: 'Variables In'.translate()
        });

        loadDropProcess = function () {
            formProperties.getField('out_doc_process').clearOptions();
            formProperties.getField('out_doc_process').addOption({
                label: "- Select a process -".translate(),
                value: "",
                disabled: true,
                selected: true
            });
        };
        loadDataServer = function () {
            var restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: 'projects',
                            method: 'GET'
                        },
                        {
                            url: 'project/' + PMDesigner.project.id + '/subprocess/' + activity.act_uid,
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    var dt,
                        itemsOut,
                        yout,
                        oout,
                        jout,
                        dout,
                        xin,
                        yin,
                        oin,
                        jin,
                        din,
                        itemsIn,
                        xout;

                    //projects
                    dt = response[0].response;
                    for (var i = 0; i < dt.length; i += 1) {
                        if (dt[i].prj_uid !== PMDesigner.project.projectId) {
                            formProperties.getField('out_doc_process').addOption({
                                label: dt[i].prj_name,
                                value: dt[i].prj_uid
                            });
                        }
                    }
                    //subprocess
                    dt = response[1].response;
                    formProperties.getField('out_doc_title').setValue(dt.spr_name);
                    formProperties.getField('out_doc_process').setValue(dt.spr_pro === '0' ? '' : dt.spr_pro);
                    formProperties.getField('out_doc_type').setValue(dt.spr_synchronous);

                    if (dt.spr_variables_out !== false) { //Asynchronous
                        xout = JSON.stringify(dt.spr_variables_out);
                        itemsOut = [];
                        if (xout != "[]") {
                            yout = xout.substring(1, xout.length - 1);
                            oout = yout.replace(/"/g, '');
                            jout = oout.split(',');
                            for (i = 0; i < jout.length; i += 1) {
                                dout = jout[i].split(':');
                                itemsOut.push({
                                    origin: dout[0],
                                    target: dout[1]
                                });
                            }
                        }
                        gridVariablesOut.setDataItems(itemsOut);
                        gridVariablesIn.setVisible(false);
                        formVariablesPanelIn.setVisible(false);
                    }

                    if (dt.spr_variables_in !== false && dt.spr_variables_in !== undefined) { //Synchronous
                        xin = JSON.stringify(dt.spr_variables_in);
                        itemsIn = [];
                        if (xin != "[]") {
                            yin = xin.substring(1, xin.length - 1);
                            oin = yin.replace(/"/g, '');
                            jin = oin.split(',');
                            for (i = 0; i < jin.length; i += 1) {
                                din = jin[i].split(':');
                                itemsIn.push({
                                    origin: din[0],
                                    target: din[1]
                                });
                            }
                        }
                        gridVariablesIn.setDataItems(itemsIn);
                    }

                    if (dt.spr_synchronous === "1") {
                        gridVariablesIn.setVisible(true);
                        formVariablesPanelIn.setVisible(true);
                    }
                    if (formProperties.getField('out_doc_process').getValue() !== '') {
                        loadActivity(formProperties.getField('out_doc_process').getValue());
                    }
                    formProperties.getField('spr_tas').setValue(dt.spr_tas === '0' ? '' : dt.spr_tas);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.setBaseEndPoint('');
            restClient.executeRestClient();
        };
        loadActivity = function (value) {
            var restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: 'project/' + value + '/starting-tasks',
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    var dropdown,
                        i,
                        dt = response[0].response;
                    dt = dt.sort(function (a, b) {
                        return a.act_name.toString().toLowerCase() > b.act_name.toString().toLowerCase();
                    });
                    dropdown = formProperties.getField('spr_tas');
                    dropdown.clearOptions();
                    dropdown.addOption({
                        value: '',
                        label: '- Select starting activity -'.translate()
                    });
                    for (i = 0; i < dt.length; i += 1) {
                        dropdown.addOption({
                            value: dt[i].act_uid,
                            label: dt[i].act_name
                        });
                    }
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.setBaseEndPoint('');
            restClient.executeRestClient();
        };

        formVariablesPanelOut.addItem(formVarTexOriginOut);
        formVariablesPanelOut.addItem(formVarTexTargetOut);
        formVariablesPanelOut.addItem(formVarButtonAddOut);

        formVariablesPanelIn.addItem(formVarTexOriginIn);
        formVariablesPanelIn.addItem(formVarTexTargetIn);
        formVariablesPanelIn.addItem(formVarButtonAddIn);

        gridVariablesIn.setVisible(false);
        formVariablesPanelIn.setVisible(false);

        windowPropertiesSub.addItem(formProperties);
        windowPropertiesSub.addItem(new PMUI.ui.TextLabel({
            width: 890,
            text: 'Variables Out'.translate(),
            style: {
                cssProperties: {
                    background: '#aaaaaa',
                    margin: '-15px 10px 10px 15px',
                    color: 'white',
                    padding: '6px',
                    'font-weight': 'bold'
                }
            },
            display: 'block'
        }));
        windowPropertiesSub.addItem(formVariablesPanelOut);
        windowPropertiesSub.addItem(gridVariablesOut);

        windowPropertiesSub.addItem(new PMUI.ui.TextLabel({
            width: 890,
            text: 'Variables In'.translate(),
            style: {
                cssProperties: {
                    background: '#aaaaaa',
                    margin: '15px 10px 10px 15px',
                    color: 'white',
                    padding: '6px',
                    'font-weight': 'bold'
                }
            },
            display: 'block',
            visible: false
        }));

        windowPropertiesSub.addItem(formVariablesPanelIn);
        windowPropertiesSub.addItem(gridVariablesIn);

        loadDropProcess();
        gridVariablesOut.setDataItems("");
        gridVariablesIn.setDataItems("");
        loadDataServer();

        if (formProperties.getItems()[1].getValue() != "0") {
            formVarTexTargetOut.setProcess(formProperties.getItems()[1].getValue());
            formVarTexOriginIn.setProcess(formProperties.getItems()[1].getValue());
        }
        windowPropertiesSub.open();
        if (formProperties.getField('out_doc_process').getValue().trim().length === 0) {
            formVarTexTargetOut.buttonHTML.disable();
            formVarTexOriginIn.buttonHTML.disable();
        } else {
            formVarTexTargetOut.buttonHTML.enable();
            formVarTexOriginIn.buttonHTML.enable();
        }
        windowPropertiesSub.showFooter();
        applyStyleWindowForm(windowPropertiesSub);
        formVariablesPanelIn.getItems()[0].dom.labelTextContainer.style.display = "none";
        formVariablesPanelIn.getItems()[1].dom.labelTextContainer.style.display = "none";
        formVariablesPanelOut.getItems()[0].dom.labelTextContainer.style.display = "none";
        formVariablesPanelOut.getItems()[1].dom.labelTextContainer.style.display = "none";
        formVariablesPanelOut.style.addProperties({marginLeft: '45px'});
        gridVariablesOut.style.addProperties({marginLeft: '45px'});
        if (formVariablesPanelIn.visible == true) {
            gridVariablesIn.setVisible(true);
            gridVariablesIn.style.addProperties({marginLeft: '45px'});
            formVariablesPanelIn.setVisible(true);
            formVariablesPanelIn.getItems()[2].setWidth(80);
            $(formVariablesPanelIn.html).css({width: '850px', marginLeft: '45px'});
            windowPropertiesSub.getItems()[4].setVisible(true);
        }

        formVariablesPanelOut.style.addProperties({width: '870px'});
        $(gridVariablesIn.html).find(".pmui-gridpanel-footer").css("position", "static");
        $(gridVariablesIn.html).find(".pmui-gridpanel-footer").css("margin-top", "0px");
        $(gridVariablesOut.html).find(".pmui-gridpanel-footer").css("position", "static");
        $(gridVariablesOut.html).find(".pmui-gridpanel-footer").css("margin-top", "0px");
        windowPropertiesSub.defineEvents();
        gridVariablesOut.html.children[0].style.display = "none";
        gridVariablesIn.html.children[0].style.display = "none";
        formProperties.getField('out_doc_title').setFocus();
        formVarButtonAddOut.setWidth(80);
        formVarButtonAddOut.setVisible(true);

    };
}());
if (typeof(consolidated) == 'undefined') {
    consolidated = '0';
}
PMDesigner.activityProperties = function (activity) {
    switch (activity.getActivityType()) {
        case "SUB_PROCESS":
            PMDesigner.propertiesSubProcess(activity);
            break;
        case "TASK":
            if (activity.getTaskType() === "SCRIPTTASK") {
                PMDesigner.scriptTaskProperties(activity);
            } else {
                PMDesigner.taskProperties(activity);
            }
            break;
    }
};

PMDesigner.taskProperties = function (activity) {
    var formDefinitions,
        featuresForms = [],
        propertiesTabs,
        formCaseLabels,
        dataProperties,
        formTimingControl,
        configurationForms,
        customGrid,
        formNotifications,
        buttonFieldCancel,
        buttonFieldAdd,
        abeForm,
        MobilePanel,
        enableTaskMobile,
        routeCaseMobile,
        abeMainPanel,
        abeAddOption,
        abeTemplates,
        abeDynaforms,
        abeReceiverAccount,
        abeEmailAcount,
        abeFields,
        warningChanges,
        windowProperties,
        processDataProperties,
        i,
        editRow = null,
        arrayTrue = '["TRUE"]',
        arrayFalse = '["FALSE"]',
        stringTrue = "TRUE",
        stringFalse = "FALSE",
        defaultServerlabel = "Mail (PHP)".translate();

    configurationForms = [
        {
            id: 'windowPropertiesTabPanelDefinitions',
            icon: '',
            title: 'Definitions'.translate(),
            panel: formDefinitions = new PMUI.form.Form({
                id: 'formDefinitions',
                visibleHeader: false,
                width: DEFAULT_WINDOW_WIDTH - 250,
                items: [{
                    id: 'formDefinitionsUID',
                    pmType: 'text',
                    name: 'UID',
                    valueType: 'string',
                    label: 'UID'.translate(),
                    controlsWidth: 300
                }, {
                    id: 'formDefinitionsTitle',
                    pmType: 'text',
                    name: 'tas_title',
                    valueType: 'string',
                    label: 'Title'.translate(),
                    placeholder: 'Insert a title'.translate(),
                    required: true,
                    controlsWidth: 300
                }, {
                    id: 'formDefinitionsDescription',
                    pmType: 'textarea',
                    name: 'tas_description',
                    valueType: 'string',
                    label: 'Description'.translate(),
                    placeholder: 'Insert a description'.translate(),
                    rows: 100,
                    controlsWidth: 300,
                    style: {cssClasses: ['mafe-textarea-resize']}
                }, new CriteriaField({
                    id: 'formDefinitionsVariable',
                    pmType: 'text',
                    name: 'tas_priority_variable',
                    valueType: 'string',
                    label: 'Variable for Case priority'.translate(),
                    controlsWidth: 300
                }), {
                    id: 'formDefinitionsRouting',
                    pmType: 'dropdown',
                    name: 'tas_derivation_screen_tpl',
                    valueType: 'string',
                    label: 'Routing Screen Template'.translate(),
                    controlsWidth: 150,
                    style: {
                        cssProperties: {
                            float: "left"
                        }
                    }
                }
                ]
            })
        },
        {
            id: 'windowPropertiesTabPanelCaseLabels',
            icon: '',
            title: 'Case Labels'.translate(),
            panel: formCaseLabels = new PMUI.form.Form({
                id: 'formCaseLabels',
                visibleHeader: false,
                width: DEFAULT_WINDOW_WIDTH - 250,
                items: [new CriteriaField({
                    id: 'formCaseLabelsTitle',
                    pmType: 'text',
                    name: 'tas_def_title',
                    valueType: 'string',
                    label: 'Title'.translate(),
                    placeholder: 'Insert a title'.translate(),
                    controlsWidth: DEFAULT_WINDOW_WIDTH - 527
                }), new CriteriaField({
                    id: 'formCaseLabelsDescription',
                    pmType: 'textarea',
                    name: 'tas_def_description',
                    valueType: 'string',
                    label: 'Description'.translate(),
                    placeholder: 'Insert a description'.translate(),
                    rows: 100,
                    controlsWidth: DEFAULT_WINDOW_WIDTH - 527,
                    renderType: 'textarea'
                })
                ]
            })
        },
        {
            id: 'windowPropertiesTabPanelTimingControl',
            icon: '',
            title: 'Timing Control'.translate(),
            panel: formTimingControl = new PMUI.form.Form({
                id: 'formTimingControl',
                visibleHeader: false,
                width: DEFAULT_WINDOW_WIDTH - 250,
                items: [{
                    id: 'formTimingControlFly',
                    pmType: 'checkbox',
                    name: 'tas_transfer_fly',
                    labelVisible: false,
                    options: [
                        {
                            id: 'formTimingControlOption',
                            label: 'Allow users to change the task duration in runtime'.translate(),
                            value: '1'
                        }
                    ],
                    onChange: function (val) {
                        changeTimingControl(this.controls[0].selected);
                    }
                }, {
                    id: 'formTimingMainPanel',
                    pmType: 'panel',
                    items: [
                        {
                            id: 'formTimingControlTask',
                            pmType: 'text',
                            name: 'tas_duration',
                            valueType: 'string',
                            label: 'Task duration'.translate(),
                            required: true,
                            maxLength: 3,
                            controlsWidth: 200,
                            validators: [
                                {
                                    pmType: "regexp",
                                    criteria: /^\d*$/,
                                    errorMessage: "Please enter a positive integer value".translate()
                                }
                            ]
                        },
                        {
                            id: 'formTimingControlAverage',
                            pmType: 'text',
                            name: 'tas_average',
                            valueType: 'string',
                            label: 'Average'.translate(),
                            maxLength: 3,
                            readOnly: true,
                            controlsWidth: 200
                        },
                        {
                            id: 'formTimingControlSdv',
                            pmType: 'text',
                            name: 'tas_sdv',
                            valueType: 'string',
                            label: 'SDV'.translate(),
                            maxLength: 3,
                            readOnly: true,
                            controlsWidth: 200
                        },
                        {
                            id: 'formTimingControlTime',
                            pmType: 'dropdown',
                            name: 'tas_timeunit',
                            label: 'Time unit'.translate(),
                            controlsWidth: 100,
                            options: [{
                                id: 'formTimingControlTime1',
                                label: 'Hours'.translate(),
                                value: 'HOURS'
                            }, {
                                id: 'formTimingControlTime2',
                                label: 'Days'.translate(),
                                value: 'DAYS'
                            }, {
                                id: 'formTimingControlTime3',
                                label: 'Minutes'.translate(),
                                value: 'MINUTES'
                            }
                            ]
                        }, {
                            id: 'formTimingControlCount',
                            pmType: 'dropdown',
                            name: 'tas_type_day',
                            label: 'Count days by'.translate(),
                            controlsWidth: 150,
                            options: [{
                                id: 'formTimingControlCount1',
                                label: 'Work Days'.translate(),
                                value: 1
                            }, {
                                id: 'formTimingControlCount2',
                                label: 'Calendar Days'.translate(),
                                value: 2
                            }
                            ]
                        }, {
                            id: 'formTimingControlCalendar',
                            pmType: 'dropdown',
                            name: 'tas_calendar',
                            label: 'Calendar'.translate(),
                            options: [],
                            controlsWidth: 150
                        }
                    ]
                }
                ]
            })
        },
        {
            id: 'windowPropertiesTabPanelNotifications',
            icon: '',
            title: 'Notifications'.translate(),
            panel: formNotifications = new PMUI.form.Form({
                id: 'formNotifications',
                visibleHeader: false,
                width: DEFAULT_WINDOW_WIDTH - 250,
                items: [
                    {
                        id: 'formNotificationsTasSend',
                        pmType: 'checkbox',
                        name: 'tas_send_last_email',
                        labelVisible: false,
                        options: [{
                            id: 'formNotificationsTasSend1',
                            label: 'After routing notify the next assigned user(s)'.translate(),
                            value: '1'
                        }
                        ],
                        onChange: function (val) {
                            changeFormNotifications(this.controls[0].selected, 'text');
                        }
                    }, {
                        id: 'formNotificationsMainPanel',
                        pmType: 'panel',
                        items: [
                            {
                                id: 'tas_email_server_uid',
                                name: 'tas_email_server_uid',
                                pmType: 'dropdown',
                                label: 'Email account'.translate(),
                                controlsWidth: 300,
                                labelWidth: "27%",
                                options: [
                                    {
                                        label: 'Default email account'.translate(),
                                        value: ''
                                    }
                                ]
                            },
                            {
                                id: 'tas_not_email_from_format',
                                name: 'tas_not_email_from_format',
                                pmType: 'dropdown',
                                label: 'Sender Name'.translate(),
                                controlsWidth: 300,
                                labelWidth: "27%",
                                options: [
                                    {
                                        id: 'assignedUser',
                                        label: 'Previous User'.translate(),
                                        value: 0
                                    }, {
                                        id: 'emailAccountSettings',
                                        label: 'Email Sender Name'.translate(),
                                        value: 1
                                    }
                                ]
                            },
                            new CriteriaField({
                                id: 'formNotificationsSubject',
                                pmType: 'text',
                                name: 'tas_def_subject_message',
                                valueType: 'string',
                                label: 'Subject'.translate(),
                                placeholder: 'Insert a title'.translate(),
                                required: true,
                                controlsWidth: 300,
                                labelWidth: "27%"
                            }), {
                                id: 'formNotificationsContent',
                                pmType: 'dropdown',
                                name: 'tas_def_message_type',
                                label: 'Content Type'.translate(),
                                controlsWidth: 150,
                                labelWidth: "27%",
                                options: [{
                                    id: 'formNotificationsContent1',
                                    value: 'text',
                                    label: 'Plain Text'.translate()
                                }, {
                                    id: 'formNotificationsContent2',
                                    value: 'template',
                                    label: 'Html Template'.translate()
                                }
                                ],
                                onChange: function (value) {
                                    visibleContentType(value);
                                }
                            }, new CriteriaField({
                                id: 'formNotificationsMessage',
                                pmType: 'textarea',
                                name: 'tas_def_message',
                                valueType: 'string',
                                label: 'Message'.translate(),
                                placeholder: 'Insert a message'.translate(),
                                rows: 100,
                                width: 10,
                                required: true,
                                controlsWidth: 300,
                                renderType: 'textarea',
                                labelWidth: "27%"
                            }), {
                                id: 'formNotificationsTemplate',
                                pmType: 'dropdown',
                                name: 'tas_def_message_template',
                                label: 'Template'.translate(),
                                options: [{
                                    value: '',
                                    label: ''
                                }],
                                labelWidth: "27%"
                            }
                        ]
                    },
                    {
                        id: 'formNotificationsTasReceive',
                        pmType: 'checkbox',
                        name: 'tas_receive_last_email',
                        labelVisible: false,
                        options: [{
                            id: 'formNotificationsTasReceive',
                            label: 'Notify the assigned user to this task'.translate(),
                            value: '1'
                        }
                        ],
                        onChange: function (val) {
                            changeFormNotificationsReceive(this.controls[0].selected, 'text');
                        }
                    },
                    {
                        id: 'formNotificationsReceivePanel',
                        pmType: 'panel',
                        items: [
                            {
                                id: 'tas_receive_server_uid',
                                name: 'tas_receive_server_uid',
                                pmType: 'dropdown',
                                label: 'Email account'.translate(),
                                controlsWidth: 300,
                                labelWidth: "27%",
                                options: [
                                    {
                                        label: 'Default email account'.translate(),
                                        value: ''
                                    }
                                ]
                            },
                            {
                                id: 'tas_receive_email_from_format',
                                name: 'tas_receive_email_from_format',
                                pmType: 'dropdown',
                                label: 'Sender Name'.translate(),
                                controlsWidth: 300,
                                labelWidth: "27%",
                                options: [
                                    {
                                        id: 'assignedUser',
                                        label: 'Previous User'.translate(),
                                        value: 0
                                    }, {
                                        id: 'emailAccountSettings',
                                        label: 'Email Sender Name'.translate(),
                                        value: 1
                                    }
                                ]
                            },
                            new CriteriaField({
                                id: 'tas_receive_subject_message',
                                pmType: 'text',
                                name: 'tas_receive_subject_message',
                                valueType: 'string',
                                label: 'Subject'.translate(),
                                placeholder: 'Insert a title'.translate(),
                                required: true,
                                controlsWidth: 300,
                                labelWidth: "27%"
                            }),
                            {
                                id: 'tas_receive_message_type',
                                pmType: 'dropdown',
                                name: 'tas_receive_message_type',
                                label: 'Content Type'.translate(),
                                controlsWidth: 150,
                                labelWidth: "27%",
                                options: [{
                                    id: 'formNotificationsReceive1',
                                    value: 'text',
                                    label: 'Plain Text'.translate()
                                }, {
                                    id: 'formNotificationsReceive2',
                                    value: 'template',
                                    label: 'Html Template'.translate()
                                }
                                ],
                                onChange: function (value) {
                                    visibleContentTypeReceive(value);
                                }
                            },
                            new CriteriaField({
                                id: 'tas_receive_message',
                                pmType: 'textarea',
                                name: 'tas_receive_message',
                                valueType: 'string',
                                label: 'Message'.translate(),
                                placeholder: 'Insert a message'.translate(),
                                rows: 100,
                                width: 10,
                                required: true,
                                controlsWidth: 300,
                                renderType: 'textarea',
                                labelWidth: "27%"
                            }),
                            {
                                id: 'tas_receive_message_template',
                                pmType: 'dropdown',
                                name: 'tas_receive_message_template',
                                label: 'Template'.translate(),
                                options: [{
                                    value: '',
                                    label: ''
                                }],
                                labelWidth: "27%"
                            }

                        ]
                    }
                ]
            })
        }
    ];
    if (consolidated == '1') {
        configurationForms.push({
            id: 'windowPropertiesTabPanelConsolidated',
            icon: '',
            title: 'Consolidated Case '.translate(),
            panel: formConsolidated = new PMUI.form.Form({
                id: 'formConsolidated',
                visibleHeader: false,
                width: DEFAULT_WINDOW_WIDTH - 250,
                items: [
                    {
                        id: 'formConsolidatedEnable',
                        pmType: 'checkbox',
                        name: 'consolidated_enable',
                        labelVisible: false,
                        options: [{
                            label: 'Enable consolidate for this task.'.translate(),
                            value: '1'
                        }
                        ],
                        onChange: function (val) {
                            changeConsolidated(this.controls[0].selected);
                        }
                    }, {
                        id: 'formConsolidatedMainPanel',
                        pmType: 'panel',
                        items: [
                            {
                                id: 'formConsolidatedReportTable',
                                pmType: 'text',
                                name: 'consolidated_report_table',
                                visible: false,
                                valueType: 'string',
                                controlsWidth: 300
                            }, {
                                id: 'formConsolidatedDynaform',
                                pmType: 'dropdown',
                                name: 'consolidated_dynaform',
                                label: 'Dynaform Template'.translate(),
                                options: [],
                                required: true,
                                controlsWidth: 300
                            }, {
                                id: 'formConsolidatedTable',
                                pmType: 'text',
                                name: 'consolidated_table',
                                valueType: 'string',
                                label: 'Table Name'.translate(),
                                placeholder: 'Insert a table name'.translate(),
                                required: true,
                                controlsWidth: 300,
                                style: {
                                    cssProperties: {
                                        float: "left"
                                    }
                                },
                                validators: [{
                                    pmType: "regexp",
                                    criteria: /^[a-zA-Z0-9_]+$/,
                                    errorMessage: "The table name can not contain spaces".translate()
                                }]
                            }, {
                                id: 'formConsolidatedTitle',
                                pmType: 'text',
                                name: 'consolidated_title',
                                valueType: 'string',
                                label: 'Title'.translate(),
                                placeholder: 'Insert a title'.translate(),
                                required: true,
                                controlsWidth: 300,
                                style: {
                                    cssProperties: {
                                        float: "left"
                                    }
                                }
                            }
                        ]
                    }
                ]
            })
        });
    }


    warningChanges = new PMUI.ui.MessageWindow({
        id: 'warningChanges',
        windowMessageType: 'warning',
        width: 490,
        bodyHeight: 'auto',
        title: 'Activity Properties'.translate(),
        message: 'Are you sure you want to discard your changes?'.translate(),
        footerItems: [
            {
                id: 'warningChangesButtonNo',
                text: "No".translate(),
                handler: function () {
                    warningChanges.close();
                },
                buttonType: "error"
            },
            {
                id: 'warningChangesButtonYes',
                text: "Yes".translate(),
                handler: function () {
                    windowProperties.close();
                    warningChanges.close();
                },
                buttonType: "success"
            }
        ]
    });
    windowProperties = new PMUI.ui.Window({
        id: 'windowProperties',
        title: 'Activity Properties'.translate(),
        height: DEFAULT_WINDOW_HEIGHT,
        width: DEFAULT_WINDOW_WIDTH,
        onOpen: function () {
            loadServerData();
        },
        items: [
            propertiesTabs = new PMUI.panel.TabPanel({
                id: 'windowPropertiesTabPanel',
                height: 435,
                width: DEFAULT_WINDOW_WIDTH - 50,
                style: {
                    cssProperties: {
                        'margin-left': '10px'
                    }
                },
                items: configurationForms.concat(featuresForms),
                itemsPosition: {
                    position: 'left'
                },
                onTabClick: function (tab) {
                    setFocusTab(tab);
                }
            }),
            customGrid
        ],
        onBeforeClose: function () {
            if (isDirty()) {
                warningChanges.open();
                warningChanges.showFooter();
            } else {
                windowProperties.close();
            }
        },
        buttonPanelPosition: 'bottom',
        buttonsPosition: 'right',
        buttons: [
            {
                id: 'windowPropertiesButtonCancel',
                text: 'Cancel'.translate(),
                handler: function () {
                    if (isDirty()) {
                        warningChanges.open();
                        warningChanges.showFooter();
                    } else {
                        windowProperties.close();
                    }
                },
                buttonType: "error"
            },
            {
                id: 'windowPropertiesButtonSave',
                text: 'Save'.translate(),
                handler: function () {
                    saveData();
                },
                buttonType: 'success'
            }
        ]
    });

    function changeConsolidated(value) {
        var panel = formConsolidated.getItem('formConsolidatedMainPanel');
        formConsolidated.getField('consolidated_enable').setValue(value ? '["1"]' : '[]');

        if (panel) {
            panel.setVisible(value);
            if (value) {
                panel.enable();
            } else {
                panel.disable();
            }
        }

        formConsolidated.getField('consolidated_report_table').setVisible(false);
    }

    function changeTimingControl(value) {
        var mainPanel = formTimingControl.getItem('formTimingMainPanel');
        formTimingControl.getField('tas_transfer_fly').setValue(value ? '["1"]' : '[]');
        if (mainPanel) {
            if (value) {
                mainPanel.disable();

            } else {
                mainPanel.enable();
            }
            mainPanel.setVisible(!value);
        }
        if (window.enterprise !== "1") {
            formTimingControl.getField('tas_average').setVisible(false);
            formTimingControl.getField('tas_sdv').setVisible(false);
        }
    }

    function changeFormNotifications(value, valueTwo) {
        var panel = formNotifications.getItem('formNotificationsMainPanel');

        if (panel) {
            panel.setVisible(value);
            if (value) {
                panel.enable();
            } else {
                panel.disable();
            }
        }

        if (value) {
            formNotifications.getField('tas_def_message_type').setValue(valueTwo);
            visibleContentType(valueTwo);
        }
        formNotifications.getField('tas_send_last_email').setValue(value ? '["1"]' : '[]');
        formNotifications.getField('tas_def_subject_message').setFocus();
    }

    /**
     * Notification receive change handler, according to user selection
     * @param value
     * @param valueTwo
     */
    function changeFormNotificationsReceive(value, valueTwo) {
        var panel = formNotifications.getItem('formNotificationsReceivePanel');

        if (panel) {
            panel.setVisible(value);
            if (value) {
                panel.enable();
            } else {
                panel.disable();
            }
        }

        if (value) {
            formNotifications.getField('tas_receive_message_type').setValue(valueTwo);
            visibleContentTypeReceive(valueTwo);
        }
        formNotifications.getField('tas_receive_last_email').setValue(value ? '["1"]' : '[]');
        formNotifications.getField('tas_receive_subject_message').setFocus();
    }

    /**
     * Get value parsed
     * @param valueCheckBox '["TRUE"]'/'["FALSE"]'
     * @returns {string} "TRUE"/"FALSE"
     */
    function getValueCheckBox(valueCheckBox) {
        var optionSelected = JSON.parse(valueCheckBox),
            valChecked;
        valChecked = (Array.isArray(optionSelected) && optionSelected.length === 1) ? optionSelected[0] : stringFalse;
        return valChecked;
    }

    function loadFormData(response) {
        dataProperties = response.properties;
        formDefinitions.getField('UID').setReadOnly(true);
        formDefinitions.getField('UID').setValue(activity.id);
        formDefinitions.getField('tas_title').setValue(dataProperties.tas_title);
        formDefinitions.getField('tas_title').setFocus();
        formDefinitions.getField('tas_description').setValue(dataProperties.tas_description);
        formDefinitions.getField('tas_priority_variable').setValue(dataProperties.tas_priority_variable);
        formDefinitions.getField('tas_derivation_screen_tpl').setValue(dataProperties.tas_derivation_screen_tpl);

        formCaseLabels.getField('tas_def_title').setValue(dataProperties.tas_def_title);
        formCaseLabels.getField('tas_def_description').setValue(dataProperties.tas_def_description);

        if (dataProperties.tas_transfer_fly === 'FALSE') {
            changeTimingControl(false);
        } else {
            changeTimingControl(true);
        }
        formTimingControl.getField('tas_duration').setValue(dataProperties.tas_duration);
        formTimingControl.getField('tas_timeunit').setValue(dataProperties.tas_timeunit);
        formTimingControl.getField('tas_type_day').setValue(dataProperties.tas_type_day);
        formTimingControl.getField('tas_calendar').setValue(dataProperties.tas_calendar);

        if (window.enterprise === "1") {
            formTimingControl.getField('tas_average').setValue(dataProperties.tas_average);
            formTimingControl.getField('tas_sdv').setValue(dataProperties.tas_sdv);
        }

        changeFormNotifications(dataProperties.tas_send_last_email === 'TRUE', dataProperties.tas_def_message_type);
        changeFormNotificationsReceive(dataProperties.tas_receive_last_email === 'TRUE', dataProperties.tas_receive_message_type);
        formNotifications.getField('tas_def_subject_message').setValue(dataProperties.tas_def_subject_message);
        formNotifications.getField('tas_def_message_type').setValue(dataProperties.tas_def_message_type);
        formNotifications.getField('tas_def_message').setValue(dataProperties.tas_def_message);
        formNotifications.getField('tas_email_server_uid').setValue(dataProperties.tas_email_server_uid);
        formNotifications.getField('tas_def_message_template').setValue(dataProperties.tas_def_message_template);
        formNotifications.getField('tas_not_email_from_format').setValue(dataProperties.tas_not_email_from_format);
        // receive
        formNotifications.getField('tas_receive_subject_message').setValue(dataProperties.tas_receive_subject_message);
        formNotifications.getField('tas_receive_message_type').setValue(dataProperties.tas_receive_message_type);
        formNotifications.getField('tas_receive_message').setValue(dataProperties.tas_receive_message);
        formNotifications.getField('tas_receive_server_uid').setValue(dataProperties.tas_receive_server_uid);
        formNotifications.getField('tas_receive_message_template').setValue(dataProperties.tas_receive_message_template);
        formNotifications.getField('tas_receive_email_from_format').setValue(dataProperties.tas_receive_email_from_format);
    }
    function loadCalendar(response) {
        var field = formTimingControl.getField('tas_calendar'), i;
        field.clearOptions();
        field.addOption({
            value: '',
            label: '- None -'.translate()
        });
        for (i = 0; i < response.length; i += 1) {
            field.addOption({
                value: response[i].cal_uid,
                label: response[i].cal_name
            });
        }
    }

    /**
     * Loads the template from rest service response
     * @param response
     * @param fieldName
     */
    function loadTemplate(response, fieldName) {
        var field = formNotifications.getField(fieldName), i, field2;
        field.clearOptions();
        field.addOption({
            value: 'alert_message.html',
            label: '-- Default --'.translate()
        });
        for (i = 0; i < response.length; i += 1) {
            field.addOption({
                value: response[i].prf_filename,
                label: response[i].prf_filename
            });
        }
        field2 = formDefinitions.getField('tas_derivation_screen_tpl');
        field2.clearOptions();
        field2.addOption({
            value: '',
            label: '-- Default --'.translate()
        });
        for (i = 0; i < response.length; i += 1) {
            if (response[i].prf_filename !== 'alert_message.html') {
                field2.addOption({
                    value: response[i].prf_filename,
                    label: response[i].prf_filename
                });
            }
        }
    };
    /**
     * Load Email account server dropdown options
     * @param response
     */
    function loadEmailAccount(response, fieldName) {
        var field = formNotifications.getField(fieldName) || null,
            i;
        if (response instanceof Array && field) {
            for (i = 0; i < response.length; i += 1) {
                field.addOption({
                    value: response[i].mess_uid,
                    label: response[i].mess_engine === "MAIL" ?
                        response[i].mess_from_name && response[i].mess_from_name !== "" ?
                        response[i].mess_from_name : defaultServerlabel : response[i].mess_from_name && response[i].mess_from_name !== "" ?
                        response[i].mess_from_name + ' <' + response[i].mess_account + '>' : ' <' + response[i].mess_account + '>'
                });
            }
        }
    };

    function loadABETemplateField(templates) {
        var templateField = abeForm.getField('ABE_TEMPLATE'), i;
        for (i in templates) {
            if (templateField !== null) {
                templateField.addOption({
                    value: templates[i].FIELD,
                    label: templates[i].NAME
                });
            }
            abeTemplates.options.push({
                value: templates[i].FIELD,
                label: templates[i].NAME
            });
        }
    };
    /**
     * Loads the email accounts settings
     * @param response
     */
    function loadABEmailAccount(response) {
        var accountField = abeForm.getField('ABE_EMAIL_SERVER_UID') || null,
            i;

        if (response instanceof Array) {
            for (i = 0; i < response.length; i += 1) {
                if (accountField !== null) {
                    accountField.addOption({
                        value: response[i].mess_uid,
                        label: response[i].mess_engine === "MAIL" ?
                            response[i].mess_from_name && response[i].mess_from_name !== "" ?
                            response[i].mess_from_name : defaultServerlabel : response[i].mess_from_name && response[i].mess_from_name !== "" ?
                            response[i].mess_from_name + ' <' + response[i].mess_account + '>' : ' <' + response[i].mess_account + '>'
                    });
                }
                abeEmailAcount.options.push({
                    value: response[i].mess_uid,
                    label: response[i].mess_engine === "MAIL" ?
                        response[i].mess_from_name && response[i].mess_from_name !== "" ?
                        response[i].mess_from_name : defaultServerlabel : response[i].mess_from_name && response[i].mess_from_name !== "" ?
                        response[i].mess_from_name + ' <' + response[i].mess_account + '>' : ' <' + response[i].mess_account + '>'
                });
            }
        }

    };

    /**
     * Loads the IMAP email accounts settings
     * @param response
     */
    function loadABImapEmailAccount(response) {
        var accountField = abeForm.getField('ABE_RECEIVER_EMAIL_SERVER_UID') || null,
            i;

        if (response instanceof Array) {
            for (i = 0; i < response.length; i += 1) {
                if (response[i].mess_engine === "IMAP" || response[i].mess_engine === "GMAILAPI" || response[i].mess_engine === "OFFICE365API") {
                    if (accountField !== null) {
                        accountField.addOption({
                            value: response[i].mess_uid,
                            label: response[i].mess_from_name && response[i].mess_from_name !== "" ?
                                    response[i].mess_from_name + ' <' + response[i].mess_account + '>' : ' <' + response[i].mess_account + '>'
                        });
                    }
                    abeReceiverAccount.options.push({
                        value: response[i].mess_uid,
                        label: response[i].mess_from_name && response[i].mess_from_name !== "" ?
                                response[i].mess_from_name + ' <' + response[i].mess_account + '>' : ' <' + response[i].mess_account + '>'
                    });
                }
            }
        }

    };

    function loadABEDynaformField(dynaforms) {
        var dynaformField = abeForm.getField('DYN_UID'), i;
        for (i in dynaforms) {
            if (dynaformField !== null) {
                dynaformField.addOption({
                    value: dynaforms[i].DYN_UID,
                    label: dynaforms[i].DYN_NAME
                });
            }
            abeDynaforms.options.push({
                value: dynaforms[i].DYN_UID,
                label: dynaforms[i].DYN_NAME
            });
        }
    }

    function loadServerData() {
        var restClient, i;
        restClient = new PMRestClient({
            typeRequest: 'post',
            multipart: true,
            data: {
                calls: {
                    "formconfig": {
                        "url": 'project/' + PMDesigner.project.id + '/activity/' + activity.id,
                        "method": 'GET'
                    },
                    "calendar": {
                        "url": 'calendar',
                        "method": 'GET'
                    },
                    "templates": {
                        "url": 'project/' + PMDesigner.project.id + '/file-manager?path=templates',
                        "method": 'GET'
                    },
                    "emailserver": {
                        "url": 'project/' + PMDesigner.project.id + '/email-event/accounts/emailServer',
                        "method": 'GET'
                    }
                }
            },
            functionSuccess: function (xhr, response) {
                loadTemplate(response["templates"].response, 'tas_def_message_template');
                loadTemplate(response["templates"].response, 'tas_receive_message_template');
                loadCalendar(response["calendar"].response);
                loadFormData(response["formconfig"].response);
                loadEmailAccount(response["emailserver"].response, 'tas_email_server_uid');
                loadEmailAccount(response["emailserver"].response, 'tas_receive_server_uid');

            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });
        if (consolidated == '1') {
            $.extend(restClient.data.calls, {
                "steps": {
                    'url': 'project/' + PMDesigner.project.id + '/activity/' + activity.id + '/steps',
                    'method': 'GET'
                },
                "consolidate": {
                    "url": 'consolidated/' + activity.id,
                    "method": 'GET'
                }
            });
        }
        restClient.setBaseEndPoint('');
        restClient.executeRestClient();
    }

    function visibleContentType(value) {
        formNotifications.getField('tas_def_message_template').disable();
        formNotifications.getField('tas_def_message').disable();
        if (value === 'text') {
            formNotifications.getField('tas_def_message').enable();
            formNotifications.getField('tas_def_message').setVisible(true);
            formNotifications.getField('tas_def_message_template').setVisible(false);
        }
        if (value === 'template') {
            formNotifications.getField('tas_def_message_template').enable();
            formNotifications.getField('tas_def_message').setVisible(false);
            formNotifications.getField('tas_def_message_template').setVisible(true);
        }
    };
    /**
     * content type handler, enable or disable templates or message field
     * @param value
     */
    function visibleContentTypeReceive(value) {
        formNotifications.getField('tas_receive_message_template').disable();
        formNotifications.getField('tas_receive_message').disable();
        if (value === 'text') {
            formNotifications.getField('tas_receive_message').enable();
            formNotifications.getField('tas_receive_message').setVisible(true);
            formNotifications.getField('tas_receive_message_template').setVisible(false);
        }
        if (value === 'template') {
            formNotifications.getField('tas_receive_message_template').enable();
            formNotifications.getField('tas_receive_message').setVisible(false);
            formNotifications.getField('tas_receive_message_template').setVisible(true);
        }
    };
    function saveData() {
        var tabPanel = windowProperties.getItem('windowPropertiesTabPanel'),
            tabItems = tabPanel.getItems(),
            valid = true,
            panel,
            tas_transfer_fly,
            tas_send_last_email,
            tas_receive_last_email,
            dataCaseLabels,
            dataDefinitions,
            dataTimingControl,
            dataNotification,
            consolidated_enable,
            message,
            i;

        /**Beging validations**/
        //Validate data inside forms.
        for (i = 0; i < tabItems.length; i += 1) {
            panel = tabItems[i].getPanel();
            if (panel instanceof PMUI.form.Form) {
                valid = valid && panel.isValid();
            } else {
                if (panel.getID() === "ActionsByEmailPanel") {
                    if (!abeForm.isValid()) {
                        valid = false;
                    }
                }
            }
            if (!valid) {
                tabItems[i].select();
                return;
            }
        }
        /**End validations**/


        tas_transfer_fly = formTimingControl.getField('tas_transfer_fly').getValue() === '["1"]';
        tas_send_last_email = formNotifications.getField('tas_send_last_email').getValue() === '["1"]';
        tas_receive_last_email = formNotifications.getField('tas_receive_last_email').getValue() === '["1"]';

        if (tas_transfer_fly !== false) {
            var a = formTimingControl.getField('tas_transfer_fly').getValue();
            formTimingControl.reset();
            formTimingControl.getField('tas_transfer_fly').setValue(a);
            formTimingControl.getField('tas_duration').setValue('1');
            formTimingControl.getField('tas_timeunit').setValue('DAYS');
            formTimingControl.getField('tas_type_day').setValue('');
            formTimingControl.getField('tas_calendar').setValue('');
        }

        if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
            dataDefinitions = getData2PMUI(formDefinitions.html);
            dataCaseLabels = getData2PMUI(formCaseLabels.html);
            dataTimingControl = getData2PMUI(formTimingControl.html);
            dataNotification = getData2PMUI(formNotifications.html);
            if (!dataCaseLabels) {
                dataCaseLabels = {};
            }
            if (!dataTimingControl) {
                dataTimingControl = {};
            }
            if (!dataNotification) {
                dataNotification = {};
            }
        } else {
            dataDefinitions = formDefinitions.getData();
            dataCaseLabels = formCaseLabels.getData();
            dataTimingControl = formTimingControl.getData();
            dataNotification = formNotifications.getData();
        }

        if (dataDefinitions['tas_title']) {
            dataProperties.tas_title = dataDefinitions['tas_title'];
        }
        if (dataDefinitions['tas_description']) {
            dataProperties.tas_description = dataDefinitions['tas_description'];
        }
        if (dataDefinitions['tas_priority_variable'] || typeof dataDefinitions['tas_priority_variable'] == "string") {
            dataProperties.tas_priority_variable = dataDefinitions['tas_priority_variable'];
        }
        if (dataDefinitions['tas_derivation_screen_tpl'] || dataDefinitions['tas_derivation_screen_tpl'] == "") {
            dataProperties.tas_derivation_screen_tpl = dataDefinitions['tas_derivation_screen_tpl'];
        }
        dataProperties.tas_def_title = dataCaseLabels['tas_def_title'];
        dataProperties.tas_def_description = dataCaseLabels['tas_def_description'];
        dataProperties.tas_transfer_fly = tas_transfer_fly ? 'TRUE' : 'FALSE';
        if (dataTimingControl['tas_duration']) {
            dataProperties.tas_duration = dataTimingControl['tas_duration'];
        }
        if (dataTimingControl['tas_timeunit']) {
            dataProperties.tas_timeunit = dataTimingControl['tas_timeunit'];
        }
        if (dataTimingControl['tas_type_day']) {
            dataProperties.tas_type_day = dataTimingControl['tas_type_day'];
        }
        if (dataTimingControl['tas_calendar']) {
            dataProperties.tas_calendar = dataTimingControl['tas_calendar'];
        }
        dataProperties.tas_send_last_email = tas_send_last_email ? 'TRUE' : 'FALSE';
        if (dataNotification['tas_not_email_from_format']) {
            dataProperties.tas_not_email_from_format = dataNotification['tas_not_email_from_format'];
        }
        if (dataNotification['tas_def_subject_message']) {
            dataProperties.tas_def_subject_message = dataNotification['tas_def_subject_message'];
        }
        if (dataNotification['tas_def_message_type']) {
            dataProperties.tas_def_message_type = dataNotification['tas_def_message_type'];
        }
        if (dataNotification['tas_def_message']) {
            dataProperties.tas_def_message = dataNotification['tas_def_message'];
        }
        if (dataNotification['tas_def_message_template']) {
            dataProperties.tas_def_message_template = dataNotification['tas_def_message_template'];
        }
        if (dataNotification['tas_email_server_uid'] !== 'undefined' && dataNotification['tas_email_server_uid'] !== null) {
            dataProperties.tas_email_server_uid = dataNotification['tas_email_server_uid'];
        }

        dataProperties.tas_receive_last_email = tas_receive_last_email ? 'TRUE' : 'FALSE';
        if (dataNotification['tas_receive_email_from_format']) {
            dataProperties.tas_receive_email_from_format = dataNotification['tas_receive_email_from_format'];
        }
        if (dataNotification['tas_receive_server_uid'] !== 'undefined' && dataNotification['tas_receive_server_uid'] !== null) {
            dataProperties.tas_receive_server_uid = dataNotification['tas_receive_server_uid'];
        }
        if (dataNotification['tas_receive_subject_message']) {
            dataProperties.tas_receive_subject_message = dataNotification['tas_receive_subject_message'];
        }
        if (dataNotification['tas_receive_message_type']) {
            dataProperties.tas_receive_message_type = dataNotification['tas_receive_message_type'];
        }
        if (dataNotification['tas_receive_message']) {
            dataProperties.tas_receive_message = dataNotification['tas_receive_message'];
        }
        if (dataNotification['tas_receive_message_template']) {
            dataProperties.tas_receive_message_template = dataNotification['tas_receive_message_template'];
        }

        if (consolidated == '1') {
            consolidated_enable = false;
            if (formConsolidated.getField('consolidated_enable').getValue() == '["1"]') {
                consolidated_enable = true;
                if (!formConsolidated.isValid()) {
                    return;
                }
            }
            dataProperties.consolidate_data = {
                "consolidated_enable": consolidated_enable,
                "consolidated_dynaform": formConsolidated.getField('consolidated_dynaform').getValue(),
                "consolidated_table": formConsolidated.getField('consolidated_table').getValue(),
                "consolidated_title": formConsolidated.getField('consolidated_title').getValue(),
                "consolidated_report_table": formConsolidated.getField('consolidated_report_table').getValue()
            };
        }

        (new PMRestClient({
            endpoint: 'activity/' + activity.id,
            typeRequest: 'update',
            messageError: '',
            data: {
                definition: {},
                properties: dataProperties
            },
            functionSuccess: function (xhr, response) {
                setNameActivity(dataProperties.tas_title);
                windowProperties.close();
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            },
            messageSuccess: 'Task properties saved successfully'.translate(),
            flashContainer: document.body
        })).executeRestClient();
    }

    function setFocusTab(tab) {
        var style;
        $customGrid = $("#customGrid");
        $customGrid.hide().appendTo($("#windowProperties").find(".pmui-window-body:eq(0)"));

        if (tab.getTitle() === 'Definitions'.translate()) {
            formDefinitions.getField('tas_title').setFocus();
        }
        if (tab.getTitle() === 'Case Labels'.translate()) {
            formCaseLabels.getField('tas_def_title').setFocus();
            style = $('#formCaseLabelsDescription .pmui-field-label').attr("style");
            style = style + ' float: left;';
            $('#formCaseLabelsDescription .pmui-field-label').attr("style", style);
        }
        if (tab.getTitle() === 'Timing Control'.translate()) {
            formTimingControl.getField('tas_duration').setFocus();
        }
        if (tab.getTitle() === 'Notifications'.translate()) {
            formNotifications.getField('tas_def_subject_message').setFocus();
            style = $('#formNotificationsMessage .pmui-field-label').attr("style");
            style = style + ' float: left;';
            $('#formNotificationsMessage .pmui-field-label').attr("style", style);

            style = $('#tas_receive_message .pmui-field-label').attr("style");
            style = style + ' float: left;';
            $('#tas_receive_message .pmui-field-label').attr("style", style);
        }
        if (tab.getTitle() === 'Actions by Email'.translate()) {
            abeForm.getField("ABE_TYPE").onChange(abeForm.getField("ABE_TYPE").getValue());
        }
    }

    function isDirty() {
        return formDefinitions.isDirty() ||
            formCaseLabels.isDirty() ||
            formTimingControl.isDirty() ||
            formNotifications.isDirty();
    }

    function setNameActivity(name) {
        activity.setName(name);
        activity.setActName(name);
        PMDesigner.project.dirty = true;
    }

    windowProperties.open();
    windowProperties.showFooter();

    applyStyleWindowForm(windowProperties);
    if (consolidated == '1') {
        formConsolidated.getField('consolidated_report_table').setVisible(false);
    }

    /**Builds the forms**/
    //This is necessary to do because many elements are built dynamically.
    var tabItems = propertiesTabs.getItems(), i;
    for (i = 0; i < tabItems.length; i += 1) {
        tabItems[i].select();
        setFocusTab(tabItems[i]);
    }
    tabItems[0].select();
    setFocusTab(tabItems[0]);
    /**End builds the forms**/

    function customDOM() {
        $customGrid = $("#customGrid");
        $customGrid.show().appendTo($("#customGridPanel").find("fieldset:eq(0)"));
        document.getElementById("customGridPanel").style.width = "720px";
        document.getElementById("customGridPanel").style.padding = "";
        document.getElementById("customGridPanel").getElementsByTagName("fieldset")[0].style.width = "100%";
        $(".pmui-gridpanel-footer").css({"text-align": "center", "margin-top": "10px", "width": "120%"});
        $(".pmui-gridpanel-footer").removeClass("pmui-gridpanel-footer");
    }

    function clearAddOptionForm() {
        abeAddOption.getField("abe_custom_value_add").setValue("");
        abeAddOption.getField("abe_custom_label_add").setValue("");
        abeAddOption.getField("abe_custom_format_add").setValue("");
        abeAddOption.getField("buttonFieldCancel").setVisible(false);
        abeAddOption.getField("buttonFieldAdd").setValue("Add".translate());
        editRow = null;
    };
    function addAcceptedValue() {
        var abeValue = abeAddOption.getField("abe_custom_value_add").getValue(),
            abeLabel = abeAddOption.getField("abe_custom_label_add").getValue(),
            abeFormat = abeAddOption.getField("abe_custom_format_add").getValue();

        if (abeAddOption && !abeAddOption.isValid()) {
            return;
        }

        if (!evaluateTags(abeFormat, 'validate')) {
            return;
        }

        if (editRow === null) {
            customGrid.addItem(new PMUI.grid.GridPanelRow({
                data: {
                    abe_custom_value: abeValue,
                    abe_custom_label: abeLabel,
                    abe_custom_format: abeFormat
                }
            }));
        } else {
            editRow.setData({
                abe_custom_value: abeValue,
                abe_custom_label: abeLabel,
                abe_custom_format: abeFormat
            });
            editRow = null;
            abeAddOption.getField("buttonFieldCancel").setVisible(false);
            abeAddOption.getField("buttonFieldAdd").setValue("Add".translate());
        }
        abeAddOption.getField("abe_custom_value_add").setValue("");
        abeAddOption.getField("abe_custom_label_add").setValue("");
        abeAddOption.getField("abe_custom_format_add").setValue("");
    }

    function customGridRowEdit(row) {
        editRow = row;
        row = row.getData();
        if (abeAddOption) {
            abeAddOption.getField("abe_custom_value_add").setValue(row.abe_custom_value);
            abeAddOption.getField("abe_custom_label_add").setValue(row.abe_custom_label);
            abeAddOption.getField("abe_custom_format_add").setValue(row.abe_custom_format);
            abeAddOption.getField("buttonFieldCancel").setVisible(true);
            abeAddOption.getField("buttonFieldAdd").setValue("Save".translate());
        }
    }

    function evaluateTags(html, action) {
        var oldHtml;
        var tagBody = '(?:[^"\'>]|"[^"]*"|\'[^\']*\')*';
        var pattern = /^[a-zA-Z0-9\s\[\]\.\-_#%;,=:()']*$/;
        var tagOrComment = new RegExp(
            '<(?:'
                // Comment body.
            + '!--(?:(?:-*[^->])*--+|-?)'
                // Special "raw text" elements whose content should be elided.
            + '|script\\b' + tagBody + '>[\\s\\S]*?</script\\s*'
            + '|style\\b' + tagBody + '>[\\s\\S]*?</style\\s*'
                // Regular name
            + '|/?[a-z]'
            + tagBody
            + ')>',
            'gi');

        var action = (typeof action === 'undefined') ? 'delete' : 'validate';
        if (action == "validate") {
            return pattern.test(html);
        } else {
            do {
                oldHtml = html;
                html = html.replace(tagOrComment, '');
            } while (html !== oldHtml);
            return html.replace(/</g, '&lt;');
        }
    }
};

var openCreateTemplates = false;

PMDesigner.ProcessFilesManager = function (processFileManagerOptionPath, optionCreation) {
    var rowselected = {};
    var rowselectedFile = {};
    var typeSave = '';
    var gridFilesManager;
    var gridTemplate;
    var gridPublic;
    var formEdit;
    var windowEdit;
    var windowCode;
    var editorHTML;
    var formUpload;
    var formUploadField;
    var initTinyMCE = null;
    var flagGridTemplate = true;
    var flagGridPublic = true;
    var presviusValueTiny = "";
    var buttonEditClass = 'mafe-button-edit';
    var buttonDeleteClass = 'mafe-button-delete';
    var buttonPropertiesClass = 'mafe-button-properties';

    var warningTemplate = new PMUI.ui.MessageWindow({
        id: 'warningTemplate',
        windowMessageType: 'warning',
        width: 490,
        title: 'Process Files Manager'.translate(),
        message: 'Do you want to delete this file?'.translate(),
        footerItems: [{
            id: 'warningTemplateButtonNo',
            text: 'No'.translate(),
            handler: function () {
                warningTemplate.close();
            },
            buttonType: "error"
        }, {
            id: 'warningTemplateButtonYes',
            text: 'Yes'.translate(),
            handler: function () {
                (new PMRestClient({
                    endpoint: 'file-manager/' + rowselectedFile.getData().prf_uid,
                    typeRequest: 'remove',
                    messageError: '',
                    functionSuccess: function (xhr, response) {
                        PMDesigner.msgFlash('File deleted successfully'.translate(), gridTemplate);
                        loadTemplate();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'File deleted successfully'.translate(),
                    flashContainer: gridTemplate
                })).executeRestClient();
                warningTemplate.close();
            },
            buttonType: "success"
        }
        ]
    });
    var isDirtyUpload = function () {
        if (formUpload.isDirty()) {
            var message_window = new PMUI.ui.MessageWindow({
                id: "cancelMessageTriggers",
                windowMessageType: 'warning',
                width: 490,
                title: "Upload File".translate(),
                message: 'Are you sure you want to discard your changes?'.translate(),
                footerItems: [
                    {
                        text: "No".translate(),
                        handler: function () {
                            message_window.close();
                        },
                        buttonType: "error"
                    },
                    {
                        text: "Yes".translate(),
                        handler: function () {
                            formUploadField.reset();
                            message_window.close();
                            windowUpload.close();
                        },
                        buttonType: "success"
                    }
                ]
            });
            message_window.open();
            message_window.showFooter();
        } else {
            windowUpload.close();
        }
    };

    var isDirtyFormEdit = function () {
        var fileContent = $(tinyMCE.activeEditor.getContent()).text().trim().length ? tinyMCE.activeEditor.getContent() : formEdit.getField("filecontent").getValue();
        if (formEdit.isDirty() || fileContent !== presviusValueTiny) {
            $(".mceSplitButtonMenu").each(function () {
                if ($(this).is(":visible")) {
                    $(this).addClass("mrdk").hide();
                }
            });
            var message_window = new PMUI.ui.MessageWindow({
                id: "cancelMessageTriggers",
                width: 490,
                windowMessageType: 'warning',
                title: 'Process Files Manager'.translate(),
                message: 'Are you sure you want to discard your changes?'.translate(),
                footerItems: [
                    {
                        text: "No".translate(),
                        handler: function () {
                            $(".mceSplitButtonMenu.mrdk").each(function () {
                                if ($(this).is(":hidden")) {
                                    $(this).removeClass("mrdk").show();
                                }
                            });
                            message_window.close();
                            windowFilesManager.close();
                        },
                        buttonType: "error"
                    }, {
                        text: "Yes".translate(),
                        handler: function () {
                            message_window.close();

                            if (clickedClose) {
                                windowEdit.close();
                            } else {
                                windowEdit.close();
                                windowFilesManager.open();
                            }
                        },
                        buttonType: "success"
                    }
                ]
            });
            message_window.open();
            message_window.showFooter();
        } else {
            if (clickedClose) {
                windowEdit.close();
            } else {
                windowEdit.close();
                windowFilesManager.open();
            }
        }
    };

    var warningPublic = new PMUI.ui.MessageWindow({
        id: 'warningPublic',
        title: 'Process Files Manager'.translate(),
        windowMessageType: 'warning',
        width: 490,
        message: 'Do you want to delete this file?'.translate(),
        footerItems: [{
            id: 'warningPublicButtonNo',
            text: 'No'.translate(),
            handler: function () {
                warningPublic.close();
            },
            buttonType: "error"
        }, {
            id: 'warningPublicButtonYes',
            text: 'Yes'.translate(),
            handler: function () {
                (new PMRestClient({
                    endpoint: 'file-manager/' + rowselectedFile.getData().prf_uid,
                    typeRequest: 'remove',
                    messageError: '',
                    functionSuccess: function (xhr, response) {
                        loadPublic();
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    },
                    messageSuccess: 'File deleted successfully'.translate(),
                    flashContainer: gridPublic
                })).executeRestClient();
                warningPublic.close();
            },
            buttonType: "success"
        }
        ]
    });

    var windowFilesManager = new PMUI.ui.Window({
        id: 'windowFilesManager',
        title: 'Process Files Manager'.translate(),
        height: DEFAULT_WINDOW_HEIGHT,
        width: DEFAULT_WINDOW_WIDTH,
        items: [
            gridFilesManager = new PMUI.grid.GridPanel({
                id: 'gridFilesManager',
                pageSize: 10,
                width: "96%",
                style: {
                    cssClasses: ["mafe-gridPanel"]
                },
                emptyMessage: 'No records found'.translate(),
                nextLabel: 'Next'.translate(),
                previousLabel: 'Previous'.translate(),
                customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                    return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
                },
                dataItems: {},
                columns: [
                    {
                        title: 'Main Folders'.translate(),
                        dataType: 'string',
                        columnData: 'prf_path',
                        width: DEFAULT_WINDOW_WIDTH - 200,
                        alignmentCell: 'left',
                        sortable: true
                    },
                    {
                        id: 'filesGridViewCol',
                        title: '',
                        dataType: 'button',
                        buttonLabel: 'View'.translate(),
                        buttonStyle: {cssClasses: ['mafe-button-show']},
                        onButtonClick: function (row, grid) {
                            rowselected = row;
                            openFolder();
                        }
                    }
                ],
                onRowClick: function (row, grid) {
                    rowselected = row;
                    openFolder();
                }
            })
        ]
    });
    var buttonNew = new PMUI.ui.Button({
        id: 'createBtn',
        text: 'Create'.translate(),
        height: "38px",
        width: 100,
        style: {cssClasses: ['mafe-button-create']},
        handler: function (event) {
            newfile();
        }
    });
    var gridTemplate = new PMUI.grid.GridPanel({
        id: 'gridTemplate',
        filterPlaceholder: 'Search ...'.translate(),
        pageSize: 10,
        width: '96%',
        style: {
            cssClasses: ["mafe-gridPanel"]
        },
        tableContainerHeight: 374,
        emptyMessage: 'No records found'.translate(),
        nextLabel: 'Next'.translate(),
        previousLabel: 'Previous'.translate(),
        customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
            return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
        },
        dataItems: {},
        columns: [{
            title: "TEMPLATES".translate(),
            dataType: 'string',
            columnData: 'prf_filename',
            width: '500px',
            alignmentCell: 'left',
            sortable: true
        }, {
            dataType: 'string',
            columnData: 'prf_uid',
            alignmentCell: 'left',
            visible: false
        }, {
            dataType: 'string',
            columnData: 'prf_content',
            alignmentCell: 'left',
            visible: false
        }, {
            id: 'gridTemplateButtonHtmlEditor',
            title: '',
            dataType: 'button',
            buttonLabel: 'Html Editor'.translate(),
            width: '106px',
            onButtonClick: function (row, grid) {
                openHtmlEditor(row);
            },
            buttonStyle: {cssClasses: [buttonEditClass]}
        }, {
            id: 'gridTemplateButtonRichTextEditor',
            title: '',
            dataType: 'button',
            buttonLabel: 'Rich Text'.translate(),
            width: '100px',
            onButtonClick: function (row, grid) {
                presviusValueTiny = row.getData().prf_content ? row.getData().prf_content : "";
                rowselectedFile = row;
                editfile();
            },
            buttonStyle: {cssClasses: [buttonEditClass]}
        }, {
            id: 'gridTemplateButtonDownload',
            title: '',
            dataType: 'button',
            buttonLabel: 'Download'.translate(),
            width: '100px',
            onButtonClick: function (row, grid) {
                rowselectedFile = row;
                download();
            },
            buttonStyle: {cssClasses: [buttonPropertiesClass]}
        }, {
            id: 'gridTemplateButtonDelete',
            title: '',
            dataType: 'button',
            buttonLabel: 'Delete'.translate(),
            width: '82px',
            onButtonClick: function (row, grid) {
                rowselectedFile = row;
                warningTemplate.open();
                warningTemplate.showFooter();
            },
            buttonStyle: {cssClasses: [buttonDeleteClass]}
        }
        ]
    });
    var buttonPublicCreate = new PMUI.ui.Button({
        id: 'buttonPublicCreate',
        text: 'Create'.translate(),
        height: "38px",
        width: 100,
        style: {cssClasses: ['mafe-button-create']},
        handler: function (event) {
            newfile();
        }

    });
    var buttonUpload = new PMUI.ui.Button({
        id: 'uploadBtn',
        text: 'Upload'.translate(),
        style: {cssClasses: ['mafe-button-upload'], cssProperties: {'margin-right': '5px', 'float': 'none'}},
        handler: function (event) {
            windowUpload.open();
            applyStyleWindowForm(windowUpload);

        }
    });
    var gridPublic = new PMUI.grid.GridPanel({
        id: 'gridPublic',
        pageSize: 10,
        width: '96%',
        style: {
            cssClasses: ["mafe-gridPanel"]
        },
        emptyMessage: 'No records found'.translate(),
        filterPlaceholder: 'Search ...'.translate(),
        nextLabel: 'Next'.translate(),
        previousLabel: 'Previous'.translate(),
        tableContainerHeight: 374,
        customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
            return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
        },
        dataItems: {},
        columns: [{
            title: "PUBLIC".translate(),
            dataType: 'string',
            columnData: 'prf_filename',
            width: '704px',
            alignmentCell: 'left',
            sortable: true
        }, {
            dataType: 'string',
            columnData: 'prf_uid',
            alignmentCell: 'left',
            visible: false
        }, {
            id: 'gridPublicButtonDownload',
            title: '',
            dataType: 'button',
            buttonLabel: 'Download'.translate(),
            width: '111px',
            onButtonClick: function (row, grid) {
                rowselectedFile = row;
                download();
            },
            buttonStyle: {cssClasses: ['mafe-button-properties']}
        }, {
            id: 'gridPublicButtonDelete',
            title: '',
            dataType: 'button',
            buttonLabel: 'Delete'.translate(),
            width: '82px',
            onButtonClick: function (row, grid) {
                rowselectedFile = row;
                warningPublic.open();
                warningPublic.showFooter();
            },
            buttonStyle: {cssClasses: ['mafe-button-delete']}
        }
        ]
    });
    var windowUpload = new PMUI.ui.Window({
        id: 'windowUpload',
        title: 'Upload File'.translate(),
        height: 200,
        width: DEFAULT_WINDOW_WIDTH,
        onBeforeClose: function () {
            isDirtyUpload();
        },
        items: [
            formUpload = new PMUI.form.Form({
                id: 'formUpload',
                visibleHeader: false,
                items: [
                    formUploadField = new PMUI.field.UploadField({
                        id: 'formUploadField',
                        label: 'File'.translate(),
                        name: 'prf_file',
                        multiple: false,
                        labelWidth: '25%',
                        accept: 'text/html',
                        controlsWidth: 300
                    })
                ]
            })
        ],
        visibleFooter: true,
        buttonPanelPosition: 'bottom',
        buttonsPosition: 'right',
        buttons: [{
            id: 'windowUploadButtonCancel',
            text: 'Cancel'.translate(),
            handler: function () {
                isDirtyUpload();
            },
            buttonType: "error"
        }, {
            id: 'windowUploadButtonUpload',
            text: 'Upload'.translate(),
            handler: function () {
                uploadFile();
            },
            buttonType: "success"
        }
        ]
    });
    /**
     * Create window TinyMCE
     */
    function createWindowTinyMCE() {
        windowEdit = new PMUI.ui.Window({
            id: 'windowEdit',
            title: '',
            height: DEFAULT_WINDOW_HEIGHT - 80,
            width: DEFAULT_WINDOW_WIDTH,
            onBeforeClose: function () {
                PMDesigner.hideAllTinyEditorControls();
                clickedClose = true;
                isDirtyFormEdit();
            },
            items: [
                formEdit = new PMUI.form.Form({
                    id: 'formEdit',
                    visibleHeader: false,
                    width: 900,
                    items: [
                        new PMUI.field.TextField({
                            id: 'filename',
                            name: 'filename',
                            label: 'Filename'.translate(),
                            placeholder: 'Insert file name'.translate(),
                            required: true,
                            valueType: 'string',
                            labelWidth: "15%",
                            controlsWidth: 300,
                            validators: [{
                                pmType: "regexp",
                                criteria: /^[a-zA-Z0-9-_ ]*$/,
                                errorMessage: "File name is invalid".translate()
                            }]
                        }),
                        new PMUI.field.TextAreaField({
                            id: 'filecontent',
                            name: 'filecontent',
                            label: 'Content'.translate(),
                            value: '',
                            rows: 210,
                            labelWidth: "15%",
                            controlsWidth: 720,
                            onChange: function (currentValue, previousValue) {
                            },
                            style: {cssClasses: ['mafe-textarea-resize']}
                        })
                    ]
                })
            ],
            buttonPanelPosition: 'bottom',
            buttonsPosition: 'right',
            buttons: [{
                id: 'windowEditButtonCancel',
                text: 'Cancel'.translate(),
                buttonType: 'error',
                handler: function () {
                    PMDesigner.hideAllTinyEditorControls();
                    clickedClose = false;
                    isDirtyFormEdit();
                }
            }, {
                id: 'windowEditButtonSave',
                text: "Save".translate(),
                buttonType: 'success',
                handler: function () {
                    if (formEdit.isValid()) {
                        PMDesigner.hideAllTinyEditorControls();
                        $(".mceSplitButtonMenu").hide();
                        save();
                    }
                }
            }
            ]
        });
        formEdit.getField('filename').enable();
        formEdit.getField('filecontent').getControls()[0].getHTML().className = 'tmceEditor';
        windowEdit.open();
        windowEdit.showFooter();
        applyStyleWindowForm(windowEdit);
        tinyMCE.init({
            editor_selector: 'tmceEditor',
            mode: 'specific_textareas',
            directionality: 'ltr',
            verify_html: false,
            skin: 'o2k7',
            theme: 'advanced',
            skin_variant: 'silver',
            relative_urls : false,
            remove_script_host : false,
            theme_advanced_source_editor_width: DEFAULT_WINDOW_WIDTH - 50,
            theme_advanced_source_editor_height: DEFAULT_WINDOW_HEIGHT - 100,
            plugins: "advhr,advimage,advlink,advlist,autolink,autoresize,contextmenu,directionality,emotions,example,example_dependency,fullpage,fullscreen,iespell,inlinepopups,insertdatetime,layer,legacyoutput,lists,media,nonbreaking,noneditable,pagebreak,paste,preview,print,save,searchreplace,style,tabfocus,table,template,visualblocks,visualchars,wordcount,xhtmlxtras,pmSimpleUploader,pmVariablePicker,style",
            theme_advanced_buttons1: 'pmSimpleUploader,|,pmVariablePicker,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,justifyfull,|,fontselect,fontsizeselect,|,cut,copy,paste',
            theme_advanced_buttons2: 'bullist,numlist,|,outdent,indent,blockquote,|,tablecontrols,|,undo,redo,|,link,unlink,image,|,forecolor,backcolor,styleprops',
            theme_advanced_buttons3: 'hr,removeformat,visualaid,|,sub,sup,|,ltr,rtl,|,code',
            popup_css: "/js/tinymce/jscripts/tiny_mce/themes/advanced/skins/default/dialogTinyBpmn.css",
            convert_urls: false,
            onchange_callback: function (inst) {
                formEdit.getField('filecontent').setValue(tinyMCE.activeEditor.getContent({format: 'raw'}));
            },
            handle_event_callback: function (e) {
            },
            setup: function (ed) {
                ed.onSetContent.add(function (ed, l) {
                    formEdit.getField('filecontent').setValue(tinyMCE.activeEditor.getContent({format: 'raw'}));
                });
            },
            oninit: function () {
                tinyMCE.activeEditor.processID = PMDesigner.project.id;
            }
        });
        validateKeysField(formEdit.getField('filename').getControls()[0].getHTML(), ['isbackspace', 'isnumber', 'isletter', 'isunderscore', 'ishyphen', 'isparenthesisopening', 'isparenthesisclosing']);
        windowEdit.footer.getItems()[0].setHeight(38);
        windowEdit.footer.getItems()[1].setHeight(38);
        document.getElementById(windowEdit.footer.getItems()[0].id).style.lineHeight = '18px';
        document.getElementById(windowEdit.footer.getItems()[1].id).style.lineHeight = '18px';
    }
    /**
     * Create and open HTML Editor
     */
    function openHtmlEditor(rowSelected) {
        var buttonCancel,
            buttonSave,
            contentHTML,
            rowData = rowSelected.getData(),
            factorWidth = 0.9,
            factorHeight = 0.7;

        //CodeMirror
        editorHTML = new PMCodeMirror({
            id: "editCodeHTML"
        });

        //Footer´s buttons
        buttonSave = new PMUI.ui.Button({
            id: 'saveHtmlEditor',
            text: "Apply".translate(),
            buttonType: 'success',
            handler: function (event) {
                saveHtmlEditor();
            }
        });
        buttonCancel = new PMUI.ui.Button({
            id: 'cancelHtmlEditor',
            text: "Cancel".translate(),
            buttonType: 'error',
            handler: function (event) {
                windowCode.close();
            }
        });
        //Create Window with Code Mirror
        windowCode = new PMUI.ui.Window({
            id: 'windowCode',
            title: 'HTML Editor'.translate(),
            height: DEFAULT_WINDOW_HEIGHT * 0.9,
            width: DEFAULT_WINDOW_WIDTH,
            footerItems: [
                buttonCancel,
                buttonSave
            ],
            buttonPanelPosition: "bottom",
            footerAlign: "right"
        });

        windowCode.open();
        windowCode.showFooter();
        windowCode.addItem(editorHTML);
        contentHTML = $.isPlainObject(rowData) && !$.isEmptyObject(rowData) ? rowData.prf_content : "";
        editorHTML.cm.setSize(windowCode.getWidth() * factorWidth, windowCode.getHeight() * factorHeight);
        editorHTML.cm.setValue(contentHTML);
        editorHTML.related_row = rowData.prf_uid;

        // Apply styles
        $(".CodeMirror.cm-s-default.CodeMirror-wrap").css({
            "margin": "10px 0 0 20px",
            "border": "1px solid #c0c0c0"
        });
        $(".CodeMirror.cm-s-default.CodeMirror-wrap").after($ctrlSpaceMessage.css({
            "margin": "5px 5px 5px 20px"
        }));
        $(".pmui-window-body").css("overflow", "hidden");
        editorHTML.cm.refresh();
    }

    function newfile() {
        windowFilesManager.close();

        initTinyMCE = function () {
            tinyMCE.activeEditor.domainURL = "/sys" + WORKSPACE + "/" + LANG + "/" + SKIN + "/";
            tinyMCE.activeEditor.processID = PMDesigner.project.id;
        };
        createWindowTinyMCE();
        typeSave = 'new';
        var title = (processFileManagerOptionPath == 'templates') ? "Create ".translate() + " " + processFileManagerOptionPath.substring(0, processFileManagerOptionPath.length - 1).translate() : "Create ".translate() + " " + processFileManagerOptionPath.translate() + " " + "file".translate();
        windowEdit.setTitle(title.translate());
        var closeElement = windowEdit.header.childNodes[1];
        if (closeElement.addEventListener) {
            closeElement.addEventListener("click", function () {
                $(".mceSplitButtonMenu").hide();
            }, false);
        } else {
            closeElement.attachEvent("click", function () {
                $(".mceSplitButtonMenu").hide();
            });
        }
        formEdit.setFocus();
    }

    function editfile() {
        var title,
            closeElement;

        windowFilesManager.close();
        initTinyMCE = function () {
            tinyMCE.activeEditor.domainURL = "/sys" + WORKSPACE + "/" + LANG + "/" + SKIN + "/";
            tinyMCE.activeEditor.processID = PMDesigner.project.id;
        };
        createWindowTinyMCE();
        typeSave = 'update';
        title = "Edit ".translate() + " " + processFileManagerOptionPath.substring(0, processFileManagerOptionPath.length - 1).translate();
        if (windowEdit && formEdit) {
            windowEdit.setTitle(title.translate());
            closeElement = windowEdit.header.childNodes[1];
            if (closeElement.addEventListener) {
                closeElement.addEventListener("click", function () {
                    $(".mceSplitButtonMenu").hide();
                }, false);
            } else {
                closeElement.attachEvent("click", function () {
                    $(".mceSplitButtonMenu").hide();
                });
            }
            formEdit.getField('filename').getControl().setStyle({cssProperties: {"background": "#EEEEEE"}});
            formEdit.getField('filename').disable();
            formEdit.getField('filename').setValue(rowselectedFile.getData().prf_filename);
            var a = rowselectedFile.getData().prf_content;
            formEdit.getField('filecontent').setValue(a);
            if (tinyMCE.activeEditor) {
                tinyMCE.activeEditor.setContent(a);
            }
        }
    }

    function save() {
        var flagAux;

        if (!formEdit.isValid()) {
            flagAux = formEdit.visible;
        } else {
            flagAux = formEdit.isValid();
        }

        if (flagAux) {
            if (getData2PMUI(formEdit.html).filename == "") {
                return false;
            }
        }

        if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
            var data = getData2PMUI(formEdit.html);
        } else {
            var data = formEdit.getData();
        }

        if (typeSave === 'new') {
            (new PMRestClient({
                endpoint: 'file-manager',
                typeRequest: 'post',
                messageError: '',
                data: {
                    prf_filename: data.filename + ".html",
                    prf_path: processFileManagerOptionPath,
                    prf_content: data.filecontent
                },
                functionSuccess: function (xhr, response) {
                    windowEdit.close();
                    if (processFileManagerOptionPath == "templates") {
                        PMDesigner.msgFlash('File saved successfully'.translate(), gridTemplate);
                        windowFilesManager.open();
                        loadTemplate();
                    }
                    if (processFileManagerOptionPath == "public") {
                        PMDesigner.msgFlash('File saved successfully'.translate(), gridPublic);
                        windowFilesManager.open();
                        loadPublic();
                    }
                    formEdit.getField('filename').setValue('');
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            })).executeRestClient();
        }
        if (typeSave === 'update') {
            (new PMRestClient({
                endpoint: 'file-manager/' + rowselectedFile.getData().prf_uid,
                typeRequest: 'update',
                messageError: '',
                data: {
                    prf_content: tinyMCE.activeEditor.getContent()
                },
                functionSuccess: function (xhr, response) {
                    windowEdit.close();
                    if (processFileManagerOptionPath == "templates") {
                        PMDesigner.msgFlash('File updated successfully'.translate(), gridTemplate);
                        windowFilesManager.open();
                        loadTemplate();
                    }
                    if (processFileManagerOptionPath == "public") {
                        PMDesigner.msgFlash('File updated successfully'.translate(), gridPublic);
                        windowFilesManager.open();
                        loadPublic();
                    }
                    formEdit.getField('filename').setValue('');
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            })).executeRestClient();
        }
    }
    /**
     * Save Content of the Html Editor
     */
    function saveHtmlEditor() {
        var index = 0,
            codeMirror = windowCode.getItems()[index],
            contentCodeMirror = codeMirror.getValue(),
            rowRelatedUID = codeMirror.related_row,
            request;


        request = new PMRestClient({
            endpoint: 'file-manager/' + rowRelatedUID,
            typeRequest: 'update',
            messageError: 'Error Update File'.translate(),
            data: {
                prf_content: contentCodeMirror
            },
            functionSuccess: function (xhr, response) {
                windowCode.close();
                if (processFileManagerOptionPath == "templates") {
                    PMDesigner.msgFlash('File updated successfully'.translate(), gridTemplate);
                    windowFilesManager.open();
                    loadTemplate();
                }
                if (processFileManagerOptionPath == "public") {
                    PMDesigner.msgFlash('File updated successfully'.translate(), gridPublic);
                    windowFilesManager.open();
                    loadPublic();
                }
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });
        request.executeRestClient();
    }

    function loadFileManager() {
        (new PMRestClient({
            endpoint: 'file-manager',
            typeRequest: 'get',
            messageError: '',
            functionSuccess: function (xhr, response) {
                gridFilesManager.clearItems();
                for (var i = 0; i < response.length; i++) {
                    gridFilesManager.addDataItem({prf_path: response[i].name});
                }
                if (openCreateTemplates) {
                    gridFilesManager.onRowClick(gridFilesManager.getItems()[0]);
                    newfile();
                }
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        })).executeRestClient();
    }

    function loadTemplate() {
        (new PMRestClient({
            endpoint: 'file-manager',
            typeRequest: 'get',
            messageError: '',
            data: {
                path: processFileManagerOptionPath,
                get_content: true
            },
            functionSuccess: function (xhr, response) {
                gridTemplate.clearItems();
                gridTemplate.clearItemsColumns();
                for (var i = 0; i < response.length; i++) {
                    gridTemplate.addDataItem({
                        prf_filename: response[i].prf_filename,
                        prf_content: response[i].prf_content,
                        prf_uid: response[i].prf_uid,
                        prf_assigned_routing_screen: response[i].prf_derivation_screen
                    });
                }
                gridTemplate.sort('prf_filename', 'asc');
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        })).executeRestClient();
        checkDerivationScreen();
    }

    function loadPublic() {
        (new PMRestClient({
            endpoint: 'file-manager',
            typeRequest: 'get',
            messageError: '',
            data: {
                path: processFileManagerOptionPath,
                get_content: false
            },
            functionSuccess: function (xhr, response) {
                gridPublic.clearItems();
                for (var i = 0; i < response.length; i++) {
                    gridPublic.addDataItem({
                        prf_filename: response[i].prf_filename,
                        prf_uid: response[i].prf_uid
                    });
                }
                gridPublic.sort('prf_filename', 'asc');
            },
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        })).executeRestClient();
    }

    function download() {
        var xhr,
            win = window,
            value = 'blob',
            url = HTTP_SERVER_HOSTNAME + '/api/1.0/' + WORKSPACE + '/project/' + PMDesigner.project.id + '/file-manager/' + rowselectedFile.getData().prf_uid + '/download';

        if (win.XMLHttpRequest) {
            xhr = new XMLHttpRequest();
        } else if (win.ActiveXObject) {
            xhr = new ActiveXObject('Microsoft.XMLHTTP');
        }
        win.URL = win.URL || win.webkitURL;

        xhr.open('GET', url, true);
        xhr.responseType = value;
        xhr.setRequestHeader('Authorization', 'Bearer ' + PMDesigner.project.keys.access_token);
        xhr.setRequestHeader ('Cache-Control', 'no-cache');
        xhr.onload = function () {
            if (this.status === 200) {
                if (processFileManagerOptionPath == "templates") {
                    PMDesigner.msgFlash('Start file download successfully'.translate(), gridTemplate);
                }
                if (processFileManagerOptionPath == "public") {
                    PMDesigner.msgFlash('Start file download successfully'.translate(), gridPublic);
                }
                var doc = win.document, a = doc.createElementNS('http://www.w3.org/1999/xhtml', 'a'), event = doc.createEvent('MouseEvents');
                event.initMouseEvent('click', true, false, win, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
                var blob = xhr.response;
                if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1) || (navigator.userAgent.indexOf("Edge") != -1)) {
                    window.navigator.msSaveBlob(blob, rowselectedFile.getData().prf_filename);
                }
                else {
                    a.href = win.URL.createObjectURL(blob);
                    a.download = rowselectedFile.getData().prf_filename;
                    a.dispatchEvent(event);
                }
            }
        };
        xhr.send()


    }

    /**
     * Upload file to Public Files or Templates
     */
    function uploadFile() {
        var fileSelector = formUploadField.getHTML().getElementsByTagName('input')[0],
            formData = new FormData(),
            xhr;
        if (fileSelector.files.length === 0) {
            PMDesigner.msgFlash('Please select a file to upload'.translate(), windowUpload.footer, "info");
            return;
        }
        formData.append('form', fileSelector.files[0]);
        xhr = new XMLHttpRequest();
        xhr.open('POST', '/api/1.0/' + WORKSPACE + '/project/' + PMDesigner.project.id + '/process-files-manager/' + processFileManagerOptionPath, true);
        xhr.setRequestHeader('Authorization', 'Bearer ' + PMDesigner.project.keys.access_token);
        xhr.onload = function () {
            var resp;
            switch (xhr.status) {
                case 200:
                    formUploadField.reset();
                    windowUpload.close();
                    if (processFileManagerOptionPath === "templates") {
                        PMDesigner.msgFlash('File uploaded successfully'.translate(), gridTemplate);
                        loadTemplate();
                    }
                    if (processFileManagerOptionPath === "public") {
                        PMDesigner.msgFlash('File uploaded successfully'.translate(), gridPublic);
                        loadPublic();
                    }
                    break;
                default:
                    if (this.response) {
                        resp = JSON.parse(this.response);
                        PMDesigner.msgWinError(resp.message ? resp.message : resp.error.message);
                    }
                    break;
            }
        };
        xhr.send(formData);
    }

    function styleApp() {
        try {
            gridFilesManager.dom.toolbar.style.display = 'none';
            gridTemplate.dom.toolbar.getElementsByTagName('input')[0].style.visibility = 'hidden';
            gridPublic.dom.toolbar.getElementsByTagName('input')[0].style.visibility = 'hidden';

        } catch (e) {
        }
    }

    function disableAllFields() {
        windowFilesManager.getItems()[0].setVisible(false);

    }

    function openFolder() {
        disableAllFields();
        styleApp();

        if (processFileManagerOptionPath == "templates") {
            windowFilesManager.setTitle("Templates".translate());
            loadTemplate();
            if (flagGridTemplate) {
                windowFilesManager.addItem(gridTemplate);
                flagGridTemplate = false;
            }

            var buttonsTemplate = document.createElement("div");
            buttonsTemplate.id = "buttonsTemplate";
            buttonsTemplate.style.display = "inlineBlock";
            buttonsTemplate.style.float = "right";

            buttonsTemplate.appendChild(buttonUpload.getHTML());
            buttonsTemplate.appendChild(buttonNew.getHTML());
            //buttonsTemplate.appendChild(buttonBack.getHTML());

            buttonUpload.defineEvents();
            buttonNew.defineEvents();
            //buttonBack.defineEvents();

            gridTemplate.dom.toolbar.appendChild(buttonsTemplate);
            gridTemplate.setVisible(true);
            gridTemplate.dom.toolbar.getElementsByTagName('input')[0].style.visibility = 'visible';
            buttonNew.getHTML().style.top = '-3px';
        }
        if (processFileManagerOptionPath == "public") {
            windowFilesManager.setTitle("Public Files".translate());
            loadPublic();
            if (flagGridPublic) {
                windowFilesManager.addItem(gridPublic);
                flagGridPublic = false;
            }
            var buttonsPublic = document.createElement("div");
            buttonsPublic.id = "buttonsPublic";
            buttonsPublic.style.display = "inlineBlock";
            buttonsPublic.style.float = "right";

            buttonsPublic.appendChild(buttonUpload.getHTML());
            buttonsPublic.appendChild(buttonPublicCreate.getHTML());
            //buttonsPublic.appendChild(buttonBack.getHTML());

            buttonUpload.defineEvents();
            buttonPublicCreate.defineEvents();
            //buttonBack.defineEvents();

            gridPublic.dom.toolbar.appendChild(buttonsPublic);
            gridPublic.dom.toolbar.getElementsByTagName('input')[0].style.visibility = 'visible';
            gridPublic.setVisible(true);
            buttonPublicCreate.getHTML().style.top = '-3px';
        }
    }
    /**
     * Check Templates Assigned Derivation Screen
     * @returns {checkDerivationScreen}
     */
    function checkDerivationScreen () {
        var gridTemplateAux = gridTemplate,
            idRichText = "gridTemplateButtonRichTextEditor",
            rowsGrid,
            columnsGrid,
            dataRowGrid,
            columnRichText,
            index = 0,
            cell = {},
            message = "Editor unavailable",
            tooltipMafeClass = "mafe-action-tooltip-black",
            i,
            max;

        rowsGrid = gridTemplateAux.getItems();
        columnsGrid = gridTemplateAux.getColumns();
        columnRichText = $.grep(columnsGrid, function (item, index) {
            return item.id === idRichText;
        });
        for (i = 0, max = rowsGrid.length; i < max; i += 1) {
            dataRowGrid = rowsGrid[i].data.customKeys;
            if (dataRowGrid.prf_assigned_routing_screen && columnRichText.length) {
                columnRichText[index].disableCell(i);
                cell = columnRichText[index].getCells().length ? columnRichText[index].getCells()[i] : cell;
                if (!$.isEmptyObject(cell)) {
                    $(cell.getHTML()).attr('title', message).tooltip({
                        tooltipClass: tooltipMafeClass,
                        position: {
                            my: 'center top',
                            at: 'center bottom+4'
                        }
                    });
                }
            }
        }
        return this;
    }

    if (optionCreation == "CREATION_NORMAL") {
        windowFilesManager.open();
        openFolder();
    } else {
        windowFilesManager.open();
        openFolder();
        newfile();
    }
    checkDerivationScreen();
};

PMDesigner.ProcessFilesManager.createFirst = function (processFileManagerOptionPath, optionCreation) {
    PMDesigner.ProcessFilesManager(processFileManagerOptionPath, optionCreation);
};

(function () {
    PMDesigner.assigmentRules = function (event) {
        var formAssignmentRules,
            i,
            tabPanelAssignmentRules,
            windowAssignmentRules,
            dataProperties,
            activity = event,
            pageSizeAssignment = 9,
            pageSizeAssignmentAD = 9,
            quickMessageWindow = new QuickMessageWindow(),
            arrayObjectUserList = [],
            arrayObjectUserList2 = [],
            arrayObjectUsers = [],
            arrayObjectUsers2 = [],
            arrayObjectAdhocUser = [],
            arrayObjectAdhocUser2 = [],
            arrayObjectAdhocUserList = [],
            arrayObjectAdhocUserList2 = [],
            warningMessageWindowDirty,
            restClient,
            assigmentPanelGlobal,
            assigmentPanelUser,
            panelTitleUser,
            titleUser,
            panelGridUser,
            buttonsUsers,
            gridUsers,
            assigmentPanelUserList,
            panelTitleUserList,
            titleUserList,
            panelGridUserList,
            buttonsUserList,
            gridUserList,
            assigmentPanelGlobalAD,
            assigmentPanelUserAD,
            panelTitleUserAD,
            titleUserAD,
            panelSearchUserAD,
            searchGridUserAD,
            panelGridUserAD,
            buttonsUsersAD,
            gridUsersAD,
            assigmentPanelUserListAD,
            panelTitleUseListAD,
            titleUserListAD,
            panelGridUserListAD,
            buttonsUserListAD,
            gridUserListAD,
            panelContainerRules,
            panelContainerUsers,
            panelContainerUsersAdHoc,
            loadTrigger,
            loadFormData,
            loadServerData,
            loadFreeUsers,
            loadAssignmentUsers,
            loadAdHocFreeUsers,
            loadAdHocAssignmentUsers,
            updateRules,
            allHidden,
            changeRadioButtons,
            visibleService,
            hiddenTab,
            saveData,
            saveOrUpdateUserAndAdHocUsers,
            applyStyles,
            applyStylesAD,
            assignee,
            remove,
            assigneeAD,
            removeAD,
            groupRows,
            flashMessage = new PMUI.ui.FlashMessage({
                message: '',
                appendTo: document.body,
                duration: 1000,
                severity: "success"
            });

        warningMessageWindowDirty = new PMUI.ui.MessageWindow({
            id: 'warningMessageWindowDirty',
            windowMessageType: 'warning',
            width: 490,
            bodyHeight: 'auto',
            title: 'Routing Rule'.translate(),
            message: 'Are you sure you want to discard your changes?'.translate(),
            footerItems: [{
                id: 'warningMessageWindowDirtyButtonNo',
                text: 'No'.translate(),
                visible: true,
                handler: function () {
                    warningMessageWindowDirty.close();
                },
                buttonType: "error"
            }, {
                id: 'warningMessageWindowDirtyButtonYes',
                text: 'Yes'.translate(),
                visible: true,
                handler: function () {
                    warningMessageWindowDirty.close();
                    windowAssignmentRules.close();
                },
                buttonType: "success"
            }]
        });
        formAssignmentRules = new PMUI.form.Form({
            id: 'formAssignmentRules',
            visibleHeader: false,
            buttonPanelPosition: 'top',
            width: 910,
            items: [
                new PMUI.field.RadioButtonGroupField({
                    id: 'formTasAssignType',
                    name: 'tas_assign_type',
                    label: 'Case assignment method'.translate(),
                    required: false,
                    controlPositioning: 'horizontal',
                    maxDirectionOptions: 3,
                    options: [{
                        id: 'formTasAssignTypeCyclical',
                        label: 'Cyclical Assignment'.translate(),
                        value: 'BALANCED',
                        selected: true
                    }, {
                        id: 'formTasAssignTypeManual',
                        label: 'Manual Assignment'.translate(),
                        value: 'MANUAL'
                    }, {
                        id: 'formTasAssignTypeValue',
                        label: 'Value Based Assignment'.translate(),
                        value: 'EVALUATE'
                    }, {
                        id: 'formTasAssignTypeReports',
                        label: 'Reports to'.translate(),
                        value: 'REPORT_TO'
                    }, {
                        id: 'formTasAssignTypeSelf',
                        label: 'Self Service'.translate(),
                        value: 'SELF_SERVICE'
                    }, {
                        id: 'formTasAssignTypeSelfValue',
                        label: 'Self Service Value Based Assignment'.translate(),
                        value: 'SELF_SERVICE_EVALUATE'
                    }, {
                        id: 'formTasAssignTypeParallel',
                        label: 'Parallel Assignment'.translate(),
                        value: 'MULTIPLE_INSTANCE'
                    }, {
                        id: 'formTasAssignTypeParallel',
                        label: 'Value Based Assignment'.translate(),
                        value: 'MULTIPLE_INSTANCE_VALUE_BASED'
                    }
                    ],
                    onChange: function (newVal, oldVal) {
                        changeRadioButtons(newVal);
                    },
                }), new CriteriaField({
                    id: 'formAssignmentRulesVariable',
                    pmType: 'text',
                    name: 'tas_assign_variable',
                    valueType: 'string',
                    label: 'Variable for Value Based Assignment'.translate(),
                    controlsWidth: DEFAULT_WINDOW_WIDTH - 527
                }), new CriteriaField({
                    id: 'formAssignmentRulesVariableSelf',
                    pmType: 'text',
                    name: 'tas_group_variable',
                    valueType: 'string',
                    label: 'Variable for Self Service Value Based Assignment'.translate(),
                    controlsWidth: DEFAULT_WINDOW_WIDTH - 527
                }), {
                    id: 'formAssignmentRulesSetTimeout',
                    pmType: 'checkbox',
                    name: 'tas_selfservice_timeout',
                    label: 'Set a timeout'.translate(),
                    options: [{
                        id: 'formAssignmentRulesSetTimeoutOption',
                        label: '',
                        value: '1'
                    }
                    ],
                    onChange: function (val) {
                        visibleService(this.controls[0].selected);
                    }
                }, {
                    id: 'formAssignmentRulesTime',
                    pmType: 'text',
                    name: 'tas_selfservice_time',
                    valueType: 'string',
                    label: 'Time'.translate(),
                    required: true,
                    validators: [{
                        pmType: "regexp",
                        criteria: /^[0-9]*$/,
                        errorMessage: "Please enter a numeric value".translate()
                    }]
                }, {
                    id: 'formAssignmentRulesTimeUnit',
                    pmType: 'dropdown',
                    name: 'tas_selfservice_time_unit',
                    label: 'Time unit'.translate(),
                    options: [{
                        id: 'formAssignmentRulesTimeUnitOption1',
                        label: 'Hours'.translate(),
                        value: 'HOURS'
                    }, {
                        id: 'formAssignmentRulesTimeUnitOption2',
                        label: 'Days'.translate(),
                        value: 'DAYS'
                    }, {
                        id: 'formAssignmentRulesTimeUnitOption3',
                        label: 'Minutes'.translate(),
                        value: 'MINUTES'
                    }]
                }, {
                    id: 'formAssignmentRulesTrigger',
                    pmType: 'dropdown',
                    name: 'tas_selfservice_trigger_uid',
                    label: 'Trigger to execute'.translate(),
                    required: true,
                    options: [{
                        id: 'formAssignmentRulesTriggerOption1',
                        value: '',
                        label: ''
                    }]
                }, {
                    id: 'formAssignmentRulesTriggerExecute',
                    pmType: 'dropdown',
                    name: 'tas_selfservice_execution',
                    label: 'Execute Trigger'.translate(),
                    options: [{
                        id: 'formAssignmentRulesTriggerExecute1',
                        label: 'Every time scheduled by cron'.translate(),
                        value: 'EVERY_TIME'
                    }, {
                        id: 'formAssignmentRulesTriggerExecute2',
                        label: 'Once'.translate(),
                        value: 'ONCE'
                    }]
                }
            ]
        });
        restClient = new PMRestClient({
            endpoint: 'projects',
            typeRequest: 'get',
            messageError: "There are problems, please try again.".translate(),
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });

        assigmentPanelGlobal = new PMUI.core.Panel({
            id: "assigmentPanelGlobal",
            layout: "hbox",
            width: DEFAULT_WINDOW_WIDTH
        });
        assigmentPanelUser = new PMUI.core.Panel({
            id: "assigmentPanelUser",
            layout: "vbox",
            width: "60%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-white'
                ]
            }
        });
        panelTitleUser = new PMUI.core.Panel({
            id: "panelTitleUser",
            layout: "hbox"
        });
        titleUser = new PMUI.ui.TextLabel({
            id: "titleUser",
            label: " ",
            textMode: 'plain',
            text: 'Available users list'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelGridUser = new PMUI.core.Panel({
            id: "panelGridUser",
            layout: "hbox",
            style: {
                cssClasses: ["mafe-panel"]
            }
        });
        buttonsUsers = new PMUI.field.RadioButtonGroupField({
            id: "buttonsUsers",
            controlPositioning: 'horizontal',
            maxDirectionOptions: 3,
            options: [{
                id: 'buttonAllAv',
                label: 'View all'.translate(),
                value: 'all',
                selected: true
            }, {
                id: 'buttonUsersAv',
                label: 'View users'.translate(),
                value: 'user'
            }, {
                id: 'buttonGroupsAv',
                label: 'View groups'.translate(),
                value: 'group'
            }],
            onChange: function (newVal, oldVal) {
                switch (newVal) {
                    case "user" :
                        gridUsers.typeList = "user";
                        break;
                    case "group":
                        gridUsers.typeList = "group";
                        break;
                    default:
                        gridUsers.typeList = "";
                        break;
                }
                gridUsers.goToPage(0);
            }
        });
        gridUsers = new PMUI.grid.GridPanel({
            id: "gridUsers",
            pageSize: pageSizeAssignment - 1,
            edges: 2,
            behavior: 'dragdropsort',
            displayedPages: 2,
            filterable: true,
            filterPlaceholder: 'Search ...'.translate(),
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            tableContainerHeight: 242,
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            customDataRest: function (data) {
                var i;
                for (i = 0; i < data.length; i += 1) {
                    if (data[i].aas_type == "group") {
                        data[i]["available"] = data[i].aas_name;
                    } else {
                        data[i]["available"] = data[i].aas_name + " " + data[i].aas_lastname + " (" + data[i].aas_username + ")";
                    }
                }
                return data;
            },
            dynamicLoad: {
                keys: {
                    server: HTTP_SERVER_HOSTNAME,
                    projectID: PMDesigner.project.projectId,
                    workspace: WORKSPACE,
                    accessToken: PMDesigner.project.tokens.access_token,
                    endPoint: 'project/' + PMDesigner.project.id + '/activity/' + activity.id + '/available-assignee/paged'
                }
            },
            columns: [{
                id: 'gridUsersButtonLabel',
                title: '',
                dataType: 'button',
                width: "10%",
                buttonLabel: function (row, data) {
                    return data.fullName;
                },
                buttonStyle: {
                    cssClasses: [
                        'mafe-grid-button'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var option, select;
                    select = document.createElement("span");
                    select.id = "list-usersIngroup";
                    option = document.createElement("span");
                    option.id = "list-usersIngroup-iem"

                    if (row.getData()["aas_type"] === 'group') {
                        var restClient = new PMRestClient({
                            typeRequest: 'get',
                            functionSuccess: function (xhr, response) {
                                var optionClone, i;
                                for (i = 0; i < response.length; i += 1) {
                                    if (i == 10) {
                                        optionClone = option.cloneNode(false);
                                        optionClone.innerHTML = "<b style='float: right'>. . .<b>";
                                        select.appendChild(optionClone);
                                    } else {
                                        optionClone = option.cloneNode(false);
                                        optionClone.textContent = "- " + response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                        optionClone.title = response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                        select.appendChild(optionClone);
                                    }
                                }
                                if (!optionClone) {
                                    optionClone = option.cloneNode(false);
                                    optionClone.textContent = "No users".translate();
                                    select.appendChild(optionClone);
                                }

                                quickMessageWindow.show($(row.html).find('a')[0], select);
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: 'There are problems saving the assigned user, please try again.'.translate()
                        });
                        restClient.setBaseEndPoint('group/' + row.getData()["aas_uid"] + '/users?start=0&limit=11');
                        restClient.executeRestClient();
                    }
                }
            },
                {
                    title: "",
                    dataType: 'string',
                    columnData: "available",
                    alignmentCell: "left",
                    width: "330px"
                },
                {
                    id: 'gridUsersButtonAssign',
                    title: '',
                    dataType: 'button',
                    width: "10%",
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-edit-assign'
                        ]
                    },
                    buttonLabel: function (row, data) {
                        var sw = row.getData()["aas_type"] === 'user';
                        row.getCells()[0].content.style.addClasses([sw ? 'button-icon-user' : 'button-icon-group']);
                        return '';
                    },
                    onButtonClick: function (row, grid) {
                        var dataRow = {};
                        grid = (grid != null) ? grid : gridUsers;
                        assignee(row);
                        gridUserList.goToPage(gridUserList.currentPage);
                        grid.goToPage(0);
                        gridUserList.goToPage(0);
                        flashMessage.setMessage("Assignee saved successfully".translate());
                        flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                        flashMessage.show();
                    }
                }],
            onDropOut: function (item, origin, destiny) {
            },
            onDrop: function (a, row) {
                grid = this;
                remove(row);
                gridUserList.goToPage(gridUserList.currentPage);
                grid.goToPage(grid.currentPage);
                flashMessage.setMessage("The user/group was successfully removed".translate());
                flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                flashMessage.show();
                return false;
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });
        assigmentPanelUserList = new PMUI.core.Panel({
            id: "assigmentPanelUserList",
            layout: "vbox",
            width: "60%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-white'
                ]
            }
        });
        panelTitleUserList = new PMUI.core.Panel({
            id: "panelTitleUserList",
            layout: "hbox"
        });
        titleUserList = new PMUI.ui.TextLabel({
            id: "titleUserList",
            textMode: 'plain',
            text: 'Assigned users list'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelGridUserList = new PMUI.core.Panel({
            id: "panelGridUserList",
            layout: "hbox",
            style: {
                cssClasses: ["mafe-panel"]
            }
        });
        buttonsUserList = new PMUI.field.RadioButtonGroupField({
            id: "buttonsUserList",
            controlPositioning: 'horizontal',
            maxDirectionOptions: 3,
            options: [{
                id: 'buttonAllAs',
                label: 'View all'.translate(),
                value: 'all',
                selected: true
            }, {
                id: 'buttonUsersAs',
                label: 'View users'.translate(),
                value: 'user'
            }, {
                id: 'buttonGroupsAs',
                label: 'View groups'.translate(),
                value: 'group'
            }],
            onChange: function (newVal, oldVal) {
                switch (newVal) {
                    case "user" :
                        gridUserList.typeList = "user";
                        break;
                    case "group":
                        gridUserList.typeList = "group";
                        break;
                    default:
                        gridUserList.typeList = "";
                        break;
                }
                gridUserList.goToPage(0);
            }
        });
        gridUserList = new PMUI.grid.GridPanel({
            id: "gridUserList",
            pageSize: pageSizeAssignment - 1,
            edges: 2,
            displayedPages: 2,
            behavior: 'dragdropsort',
            filterable: true,
            nextLabel: 'Next'.translate(),
            filterPlaceholder: 'Search ...'.translate(),
            previousLabel: 'Previous'.translate(),
            tableContainerHeight: 242,
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            emptyMessage: function () {
                var div = document.createElement('div'),
                    span = document.createElement('span');
                div.appendChild(span);
                div.className = "mafe-grid-panel-empty";
                div.style.height = gridUserList.dom.tableContainer.style.height;
                div.style.width = gridUserList.dom.tableContainer.style.width;
                span.innerHTML = 'Drag & Drop a User or a Group here'.translate();
                return div;
            },
            onEmpty: function () {
                gridUserList.dom.tableContainer.style.overflow = "hidden";
            },
            dynamicLoad: {
                keys: {
                    server: HTTP_SERVER_HOSTNAME,
                    projectID: PMDesigner.project.projectId,
                    workspace: WORKSPACE,
                    accessToken: PMDesigner.project.tokens.access_token,
                    endPoint: 'project/' + PMDesigner.project.id + '/activity/' + activity.id + '/assignee/paged'
                }
            },
            customDataRest: function (data) {
                var i;
                for (i = 0; i < data.length; i += 1) {
                    if (data[i].aas_type == "group") {
                        data[i]["assignment"] = data[i].aas_name;
                    } else {
                        data[i]["assignment"] = data[i].aas_name + " " + data[i].aas_lastname + " (" + data[i].aas_username + ")";
                    }
                }
                return data;
            },
            columns: [
                {
                    id: 'gridUserListButtonLabel',
                    title: "",
                    width: "10%",
                    dataType: 'button',
                    buttonLabel: function (row, data) {
                        return data.lastName;
                    },
                    buttonStyle: {
                        cssClasses: [
                            'mafe-grid-button'
                        ]
                    },
                    onButtonClick: function (row, grid) {
                        var option, select;
                        select = document.createElement("span");
                        select.id = "list-usersIngroup";
                        option = document.createElement("span");
                        option.id = "list-usersIngroup-iem";

                        if (row.getData()["aas_type"] === "group") {
                            var restClient = new PMRestClient({
                                typeRequest: 'get',
                                functionSuccess: function (xhr, response) {
                                    var optionClone, i;
                                    for (i = 0; i < response.length; i += 1) {
                                        if (i == 10) {
                                            optionClone = option.cloneNode(false);
                                            optionClone.innerHTML = "<b style='float: right'>. . .<b>";
                                            select.appendChild(optionClone);
                                        } else {
                                            optionClone = option.cloneNode(false);
                                            optionClone.textContent = "- " + response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                            optionClone.title = response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                            select.appendChild(optionClone);
                                        }
                                    }
                                    if (!optionClone) {
                                        optionClone = option.cloneNode(false);
                                        optionClone.textContent = "No users".translate();
                                        select.appendChild(optionClone);
                                    }

                                    quickMessageWindow.show($(row.html).find('a')[0], select);
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageError: 'There are problems saving the assigned user, please try again.'.translate()
                            });
                            restClient.setBaseEndPoint("group/" + row.getData()["aas_uid"] + "/users?start=0&limit=11");
                            restClient.executeRestClient();
                        }
                    }
                },
                {
                    title: '',
                    dataType: 'string',
                    columnData: "assignment",
                    alignmentCell: "left",
                    width: "330px"
                },
                {
                    id: 'gridUserListButtonDelete',
                    title: '',
                    dataType: 'button',
                    width: "10%",
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-delete-assign'
                        ]
                    },
                    buttonLabel: function (row, data) {
                        var sw = row.getData()["aas_type"] === 'user';
                        row.getCells()[0].content.style.addClasses([sw ? 'button-icon-user' : 'button-icon-group']);
                        return '';
                    },
                    onButtonClick: function (row, grid) {
                        var dataRow = {};
                        grid = (grid != null) ? grid : gridUserList;
                        remove(row);
                        gridUserList.goToPage(gridUserList.currentPage);
                        grid.goToPage(0);
                        gridUsers.goToPage(0);
                        flashMessage.setMessage("The user/group was successfully removed".translate());
                        flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                        flashMessage.show();
                    }
                }
            ],
            onDropOut: function (item, origin, destiny) {
            },
            onDrop: function (grid, row) {
                var dataRow = {};
                grid = this;
                assignee(row);
                gridUsers.goToPage(gridUsers.currentPage);
                grid.goToPage(grid.currentPage);
                flashMessage.setMessage("Assignee saved successfully".translate());
                flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                flashMessage.show();
                return false;
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });

        assigmentPanelGlobalAD = new PMUI.core.Panel({
            id: "assigmentPanelGlobalAD",
            layout: "hbox",
            width: DEFAULT_WINDOW_WIDTH

        });
        assigmentPanelUserAD = new PMUI.core.Panel({
            id: "assigmentPanelUserAD",
            layout: "vbox",
            width: "60%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-white'
                ]
            }
        });
        panelTitleUserAD = new PMUI.core.Panel({
            id: "panelTitleUserAD",
            layout: "hbox"
        });
        titleUserAD = new PMUI.ui.TextLabel({
            id: "titleUserAD",
            label: " ",
            textMode: 'plain',
            text: 'Available users list'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelSearchUserAD = new PMUI.core.Panel({
            id: "panelSearchUserAD",
            layout: "hbox"
        });
        searchGridUserAD = new PMUI.field.TextField({
            id: "searchGridUserAD",
            label: " ",
            placeholder: 'Search ...'.translate(),
            style: {
                cssClasses: [
                    'mafe-assigment-search'
                ]
            }
        });
        panelGridUserAD = new PMUI.core.Panel({
            id: "panelGridUserAD",
            layout: "hbox",
            style: {
                cssClasses: ["mafe-panel"]
            }
        });
        buttonsUsersAD = new PMUI.field.RadioButtonGroupField({
            id: "buttonsUsersAD",
            controlPositioning: 'horizontal',
            maxDirectionOptions: 3,
            options: [{
                id: 'buttonAllAv',
                label: 'View all'.translate(),
                selected: true,
                value: 'all'
            }, {
                id: 'buttonUsersAv',
                label: 'View users'.translate(),
                value: 'user'
            }, {
                id: 'buttonGroupsAv',
                label: 'View groups'.translate(),
                value: 'group'
            }],
            onChange: function (newVal, oldVal) {
                switch (newVal) {
                    case "user" :
                        gridUsersAD.typeList = "user";
                        break;
                    case "group":
                        gridUsersAD.typeList = "group";
                        break;
                    default:
                        gridUsersAD.typeList = "";
                        break;
                }
                gridUsersAD.goToPage(0);
            }
        });
        gridUsersAD = new PMUI.grid.GridPanel({
            id: "gridUsersAD",
            pageSize: pageSizeAssignmentAD - 1,
            filterable: true,
            behavior: 'dragdropsort',
            filterPlaceholder: 'Search ...'.translate(),
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            tableContainerHeight: 242,
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            dynamicLoad: {
                keys: {
                    server: HTTP_SERVER_HOSTNAME,
                    projectID: PMDesigner.project.projectId,
                    workspace: WORKSPACE,
                    accessToken: PMDesigner.project.tokens.access_token,
                    endPoint: 'project/' + PMDesigner.project.id + '/activity/' + activity.id + '/adhoc-available-assignee/paged'
                }
            },
            customDataRest: function (data) {
                var i;
                for (i = 0; i < data.length; i += 1) {
                    if (data[i].ada_type == "group") {
                        data[i]["available"] = data[i].ada_name;
                    } else {
                        data[i]["available"] = data[i].ada_name + " " + data[i].ada_lastname + " (" + data[i].ada_username + ")";
                    }
                }
                return data;
            },
            columns: [
                {
                    id: 'gridUsersADButtonLabel',
                    title: '',
                    dataType: 'button',
                    width: "10%",
                    buttonLabel: function (row, data) {
                        return data.lastName;
                    },
                    buttonStyle: {
                        cssClasses: [
                            'mafe-grid-button'
                        ]
                    },
                    onButtonClick: function (row, grid) {
                        var option, select;
                        select = document.createElement("span");
                        select.id = "list-usersIngroup";
                        option = document.createElement("span");
                        option.id = "list-usersIngroup-iem";
                        if (row.getData()["ada_type"] === "group") {
                            var restClient = new PMRestClient({
                                typeRequest: 'get',
                                functionSuccess: function (xhr, response) {
                                    var optionClone, i;
                                    for (i = 0; i < response.length; i += 1) {
                                        if (i == 10) {
                                            optionClone = option.cloneNode(false);
                                            optionClone.innerHTML = "<b style='float: right'>. . .<b>";
                                            select.appendChild(optionClone);
                                        } else {
                                            optionClone = option.cloneNode(false);
                                            optionClone.textContent = "- " + response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                            optionClone.title = response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                            select.appendChild(optionClone);
                                        }
                                    }
                                    if (!optionClone) {
                                        optionClone = option.cloneNode(false);
                                        optionClone.textContent = "No users".translate();
                                        select.appendChild(optionClone);
                                    }

                                    quickMessageWindow.show($(row.html).find('a')[0], select);
                                },
                                functionFailure: function (xhr, response) {
                                    PMDesigner.msgWinError(response.error.message);
                                },
                                messageError: 'There are problems saving the assigned user, please try again.'.translate()
                            });
                            restClient.setBaseEndPoint("group/" + row.getData()["ada_uid"] + "/users?start=0&limit=11");
                            restClient.executeRestClient();
                        }
                    }
                },
                {
                    title: "",
                    dataType: 'string',
                    columnData: "available",
                    alignmentCell: "left",
                    width: "330px"
                },
                {
                    id: 'gridUsersADButtonAssign',
                    title: '',
                    dataType: 'button',
                    width: "10%",
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-edit-assign'
                        ]
                    },
                    buttonLabel: function (row, data) {
                        var sw = row.getData()["ada_type"] === 'user';
                        row.getCells()[0].content.style.addClasses([sw ? 'button-icon-user' : 'button-icon-group']);
                        return '';
                    },
                    onButtonClick: function (row, grid) {
                        var dataRow = {};
                        grid = (grid != null) ? grid : gridUsersAD;
                        assigneeAD(row);
                        grid.goToPage(gridUsersAD.currentPage);
                        gridUserListAD.goToPage(0);
                        flashMessage.setMessage("Assignee saved successfully".translate());
                        flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                        flashMessage.show();
                    }
                }
            ],
            onDropOut: function (item, origin, destiny) {
                formAssignmentRules.dirty = true;
                grid = gridUsersAD;
                grid.sort('fullName', 'asc');
                buttonsUserListAD.setValue(buttonsUsersAD.getValue());
                groupRows(gridUsersAD, 'all');
                groupRows(gridUserListAD, 'all');
                arrayObjectAdhocUserList.push(item);
                index = arrayObjectAdhocUser.indexOf(item);
                if (index > -1) {
                    arrayObjectAdhocUser.splice(index, 1);
                }
            },
            onDrop: function (a, row) {
                grid = this;
                removeAD(row);
                gridUserListAD.goToPage(gridUserListAD.currentPage);
                grid.goToPage(grid.currentPage);
                flashMessage.setMessage("The user/group was successfully removed".translate());
                flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                flashMessage.show();
                return false;
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });
        assigmentPanelUserListAD = new PMUI.core.Panel({
            id: "assigmentPanelUserListAD",
            layout: "vbox",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-white'
                ]
            },
            width: "60%"
        });
        panelTitleUseListAD = new PMUI.core.Panel({
            id: "panelTitleUseListAD",
            layout: "hbox"
        });
        titleUserListAD = new PMUI.ui.TextLabel({
            id: "titleUserListAD",
            textMode: 'plain',
            text: 'Assigned users list'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelGridUserListAD = new PMUI.core.Panel({
            id: "panelGridUserListAD",
            layout: "hbox",
            style: {
                cssClasses: ["mafe-panel"]
            }
        });
        buttonsUserListAD = new PMUI.field.RadioButtonGroupField({
            id: "buttonsUserListAD",
            controlPositioning: 'horizontal',
            maxDirectionOptions: 3,
            options: [{
                id: 'buttonAllAs',
                label: 'View all'.translate(),
                value: 'all',
                selected: true
            }, {
                id: 'buttonUsersAs',
                label: 'View users'.translate(),
                value: 'user'
            }, {
                id: 'buttonGroupsAs',
                label: 'View groups'.translate(),
                value: 'group'
            }],
            onChange: function (newVal, oldVal) {
                switch (newVal) {
                    case "user" :
                        gridUserListAD.typeList = "user";
                        break;
                    case "group":
                        gridUserListAD.typeList = "group";
                        break;
                    default:
                        gridUserListAD.typeList = "";
                        break;
                }
                gridUserListAD.goToPage(0);
            }
        });
        gridUserListAD = new PMUI.grid.GridPanel({
            id: "gridUserListAD",
            pageSize: pageSizeAssignmentAD - 1,
            behavior: 'dragdropsort',
            filterable: true,
            filterPlaceholder: 'Search ...'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            tableContainerHeight: 242,
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            emptyMessage: function () {
                var div = document.createElement('div'),
                    span = document.createElement('span');
                div.appendChild(span);
                div.className = "mafe-grid-panel-empty";
                div.style.height = gridUserListAD.dom.tableContainer.style.height;
                div.style.width = gridUserListAD.dom.tableContainer.style.width;
                span.innerHTML = 'Drag & Drop a User or a Group here'.translate();
                return div;
            },
            onEmpty: function (grid, cell) {
                gridUserListAD.dom.tableContainer.style.overflow = "hidden";
            },
            dynamicLoad: {
                keys: {
                    server: HTTP_SERVER_HOSTNAME,
                    projectID: PMDesigner.project.projectId,
                    workspace: WORKSPACE,
                    accessToken: PMDesigner.project.tokens.access_token,
                    endPoint: 'project/' + PMDesigner.project.id + '/activity/' + activity.id + '/adhoc-assignee/paged'
                }
            },
            customDataRest: function (data) {
                var i;
                for (i = 0; i < data.length; i += 1) {
                    if (data[i].ada_type == "group") {
                        data[i]["assignee"] = data[i].ada_name;
                    } else {
                        data[i]["assignee"] = data[i].ada_name + " " + data[i].ada_lastname + " (" + data[i].ada_username + ")";
                    }
                }
                return data;
            },
            columns: [
                {
                    id: 'gridUserListADButtonLabel',
                    title: "",
                    width: "13%",
                    dataType: 'button',
                    buttonLabel: function (row, data) {
                        return data.lastName;
                    },
                    buttonStyle: {
                        cssClasses: [
                            'mafe-grid-button'
                        ]
                    },
                    onButtonClick: function (row, grid) {
                        var option, select;
                        select = document.createElement("span");
                        select.id = "list-usersIngroup";
                        option = document.createElement("span");
                        option.id = "list-usersIngroup-iem";
                        if (row.getData()["ada_type"] === "group") {
                            var i,
                                restClient = new PMRestClient({
                                    typeRequest: 'get',
                                    functionSuccess: function (xhr, response) {
                                        var optionClone, i;
                                        for (i = 0; i < response.length; i += 1) {
                                            if (i == 10) {
                                                optionClone = option.cloneNode(false);
                                                optionClone.innerHTML = "<b style='float: right'>. . .<b>";
                                                select.appendChild(optionClone);
                                            } else {
                                                optionClone = option.cloneNode(false);
                                                optionClone.textContent = "- " + response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                                optionClone.title = response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                                select.appendChild(optionClone);
                                            }
                                        }
                                        if (!optionClone) {
                                            optionClone = option.cloneNode(false);
                                            optionClone.textContent = "No users".translate();
                                            select.appendChild(optionClone);
                                        }

                                        quickMessageWindow.show($(row.html).find('a')[0], select);
                                    },
                                    functionFailure: function (xhr, response) {
                                        PMDesigner.msgWinError(response.error.message);
                                    },
                                    messageError: 'There are problems saving the assigned user, please try again.'.translate()
                                });
                            restClient.setBaseEndPoint("group/" + row.getData()["ada_uid"] + "/users?start=0&limit=11");
                            restClient.executeRestClient();
                        }
                    }
                },
                {
                    title: '',
                    dataType: 'string',
                    columnData: "assignee",
                    alignmentCell: "left",
                    width: "330px"
                },
                {
                    id: 'gridUserListADButtonDelete',
                    title: '',
                    dataType: 'button',
                    width: "10%",
                    buttonStyle: {
                        cssClasses: [
                            'mafe-button-delete-assign'
                        ]
                    },
                    buttonLabel: function (row, data) {
                        var sw = row.getData()["ada_type"] === 'user';
                        row.getCells()[0].content.style.addClasses([sw ? 'button-icon-user' : 'button-icon-group']);
                        return '';
                    },
                    onButtonClick: function (row, grid) {
                        var dataRow = {};
                        grid = (grid != null) ? grid : gridUserListAD;
                        removeAD(row);
                        grid.goToPage(grid.currentPage);
                        gridUsersAD.goToPage(gridUsersAD.currentPage);
                        flashMessage.setMessage("The user/group was successfully removed".translate());
                        flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                        flashMessage.show();
                    }
                }
            ],
            onDropOut: function (item, origin, destiny) {
            },
            onDrop: function (a, row) {
                grid = this;
                assigneeAD(row);
                gridUsersAD.goToPage(gridUsersAD.currentPage);
                grid.goToPage(grid.currentPage);
                flashMessage.setMessage("Assignee saved successfully".translate());
                flashMessage.setAppendTo(windowAssignmentRules.getHTML());
                flashMessage.show();
                return false;
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });

        panelContainerRules = new PMUI.core.Panel({
            width: DEFAULT_WINDOW_WIDTH - 55,
            height: "auto",
            fieldset: true,
            items: [
                formAssignmentRules
            ]
        });
        panelContainerUsers = new PMUI.core.Panel({
            width: DEFAULT_WINDOW_WIDTH,
            height: "auto",
            fieldset: true,
            items: [
                assigmentPanelGlobal
            ]
        });
        panelContainerUsersAdHoc = new PMUI.core.Panel({
            width: DEFAULT_WINDOW_WIDTH,
            height: "auto",
            fieldset: true,
            items: [
                assigmentPanelGlobalAD
            ]
        });

        tabPanelAssignmentRules = new PMUI.panel.TabPanel({
            id: 'tabPanelAssignmentRules',
            width: "100%",
            height: "auto",
            items: [
                {
                    id: 'tabUsers',
                    title: 'Users'.translate(),
                    panel: panelContainerUsers
                },
                {
                    id: 'tabUsersAdHoc',
                    title: 'Ad Hoc Users'.translate(),
                    panel: panelContainerUsersAdHoc
                }
            ],
            onTabClick: function (item) {
                quickMessageWindow.close();
                switch (item.id) {
                    case 'tabRules':
                        break;
                    case 'tabUsers':
                        applyStyles();
                        gridUsers.goToPage(0);
                        gridUserList.goToPage(0);
                        break;
                    case 'tabUsersAdHoc':
                        applyStylesAD();
                        gridUsersAD.goToPage(0);
                        gridUserListAD.goToPage(0);
                        break;
                }
            }
        });
        windowAssignmentRules = new PMUI.ui.Window({
            id: 'windowAssignmentRules',
            title: 'Assignment Rules'.translate() + ': ' + activity.act_name,
            height: DEFAULT_WINDOW_HEIGHT,
            width: DEFAULT_WINDOW_WIDTH,
            footerItems: [
                {
                    id: 'windowConnectionsButtonCancel',
                    text: 'Close'.translate(),
                    handler: function () {
                        if (formAssignmentRules.isDirty()) {
                            warningMessageWindowDirty.open();
                            warningMessageWindowDirty.showFooter();
                        } else {
                            windowAssignmentRules.close();
                        }
                    },
                    buttonType: 'error'
                },
                {
                    buttonType: 'success',
                    id: 'windowPropertiesButtonSave',
                    text: "Save".translate(),
                    handler: function () {
                        saveData();
                    }
                }
            ],
            visibleFooter: true,
            buttonPanelPosition: 'bottom',
            footerAlign: "right",
            onBeforeClose: function () {
                if (formAssignmentRules.isDirty()) {
                    warningMessageWindowDirty.open();
                    warningMessageWindowDirty.showFooter();
                } else {
                    windowAssignmentRules.close();
                }
            }
        });

        loadTrigger = function (response) {
            var field = formAssignmentRules.getField('tas_selfservice_trigger_uid'), i;
            field.clearOptions();
            field.addOption({
                value: '',
                label: '- Select Trigger -'.translate()
            });
            for (i = 0; i < response.length; i += 1) {
                field.addOption({
                    value: response[i].tri_uid,
                    label: response[i].tri_title
                });
            }
        };
        loadFormData = function (response) {
            dataProperties = response.properties;
            formAssignmentRules.getField('tas_assign_type').setValue(dataProperties.tas_assign_type);
            formAssignmentRules.getField('tas_assign_variable').setValue(dataProperties.tas_assign_variable);
            formAssignmentRules.getField('tas_group_variable').setValue(dataProperties.tas_group_variable);
            changeRadioButtons(formAssignmentRules.getField('tas_assign_type').getValue());
            formAssignmentRules.getField('tas_selfservice_timeout').controls[0].deselect();
            if (dataProperties.tas_selfservice_timeout === 1) {
                formAssignmentRules.getField('tas_selfservice_timeout').controls[0].select();
            }
            formAssignmentRules.getField('tas_selfservice_time').setValue(dataProperties.tas_selfservice_time);
            formAssignmentRules.getField('tas_selfservice_time_unit').setValue(dataProperties.tas_selfservice_time_unit);
            formAssignmentRules.getField('tas_selfservice_trigger_uid').setValue(dataProperties.tas_selfservice_trigger_uid);
            formAssignmentRules.getField('tas_selfservice_execution').setValue(dataProperties.tas_selfservice_execution);
            visibleService(dataProperties.tas_selfservice_timeout === 1);
        };
        loadServerData = function () {
            var restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: 'project/' + PMDesigner.project.id + '/activity/' + activity.id,
                            method: 'GET'
                        }, {
                            url: 'project/' + PMDesigner.project.id + '/triggers',
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    loadTrigger(response[1].response);
                    loadFormData(response[0].response);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.setBaseEndPoint('');
            restClient.executeRestClient();
        };
        loadFreeUsers = function (response) {
            var i;
            gridUsers.clearItems();
            for (i = 0; i < response.length; i += 1) {
                gridUsers.addDataItem({
                    fullName: response[i].aas_name + " " + response[i].aas_lastname,
                    ass_uid: response[i].aas_uid,
                    ass_type: response[i].aas_type
                });
            }
        };
        loadAssignmentUsers = function (response) {
            var i;
            gridUserList.clearItems();
            for (i = 0; i < response.length; i += 1) {
                gridUserList.addDataItem({
                    fullName: response[i].aas_name + " " + response[i].aas_lastname,
                    ass_uid: response[i].aas_uid,
                    ass_type: response[i].aas_type
                });
            }
        };
        loadAdHocFreeUsers = function (response) {
            var i;
            gridUsersAD.clearItems();
            for (i = 0; i < response.length; i += 1) {
                gridUsersAD.addDataItem({
                    fullName: response[i].ada_name + " " + response[i].ada_lastname,
                    ada_uid: response[i].ada_uid,
                    ass_type: response[i].ada_type
                });
            }
        };
        loadAdHocAssignmentUsers = function (response) {
            var i;
            gridUserListAD.clearItems();
            for (i = 0; i < response.length; i += 1) {
                gridUserListAD.addDataItem({
                    fullName: response[i].ada_name + " " + response[i].ada_lastname,
                    ada_uid: response[i].ada_uid,
                    ass_type: response[i].ada_type
                });
            }
        };
        updateRules = function () {
            (new PMRestClient({
                endpoint: 'activity/' + activity.id,
                typeRequest: 'update',
                messageError: ' ',
                data: {
                    definition: {},
                    properties: dataProperties
                },
                messageSuccess: 'Assignment Rules saved successfully'.translate(),
                flashContainer: document.body,
                functionSuccess: function () {
                    formAssignmentRules.dirty = false;
                    windowAssignmentRules.close();
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            })).executeRestClient();
        };
        allHidden = function () {
            formAssignmentRules.getField('tas_assign_variable').setVisible(false);
            formAssignmentRules.getField('tas_group_variable').setVisible(false);
            formAssignmentRules.getField('tas_selfservice_timeout').setVisible(false);
            formAssignmentRules.getField('tas_selfservice_timeout').controls[0].deselect();
            formAssignmentRules.getField('tas_selfservice_time').setVisible(false);
            formAssignmentRules.getField('tas_selfservice_time_unit').setVisible(false);
            formAssignmentRules.getField('tas_selfservice_trigger_uid').setVisible(false);
            formAssignmentRules.getField('tas_selfservice_execution').setVisible(false);
        };
        changeRadioButtons = function (newVal) {
            allHidden();
            tabPanelAssignmentRules.setVisible(true);
            switch (newVal) {
                case 'EVALUATE':
                    formAssignmentRules.getField('tas_assign_variable').setVisible(true);
                    if (dataProperties.tas_assign_variable === "" || dataProperties.tas_assign_variable === null) {
                        formAssignmentRules.getField('tas_assign_variable').setValue('@@SYS_NEXT_USER_TO_BE_ASSIGNED');
                    } else {
                        formAssignmentRules.getField('tas_assign_variable').setValue(dataProperties.tas_assign_variable);
                    }
                    break;
                case 'SELF_SERVICE':
                    formAssignmentRules.getField('tas_selfservice_timeout').setVisible(true);
                    break;
                case 'SELF_SERVICE_EVALUATE':
                    formAssignmentRules.getField('tas_group_variable').setVisible(true);
                    if (dataProperties.tas_group_variable === "@@SYS_GROUP_TO_BE_ASSIGNED" || dataProperties.tas_group_variable === "" || dataProperties.tas_group_variable === null) {
                        formAssignmentRules.getField('tas_group_variable').setPlaceholder('@@ARRAY_OF_USERS or @@GROUP_UID');
                    } else {
                        formAssignmentRules.getField('tas_group_variable').setValue(dataProperties.tas_group_variable);
                    }
                    formAssignmentRules.getField('tas_selfservice_timeout').setVisible(true);
                    break;
                case 'REPORT_TO':
                    break;
                case 'MULTIPLE_INSTANCE_VALUE_BASED':
                    formAssignmentRules.getField('tas_assign_variable').setLabel("Array of users".translate());
                    if (formAssignmentRules.getField('tas_assign_variable').getValue() == "@@SYS_NEXT_USER_TO_BE_ASSIGNED" || formAssignmentRules.getField('tas_assign_variable').getValue() == "") {
                        formAssignmentRules.getField('tas_assign_variable').setValue('');
                        formAssignmentRules.getField('tas_assign_variable').setPlaceholder('@@ARRAY_OF_USERS');
                    }
                    formAssignmentRules.getField('tas_assign_variable').setVisible(true);
                    if (activity.act_loop_type == "PARALLEL") {
                        tabPanelAssignmentRules.setVisible(false);
                    }
                    break;
                default:
                    break;
            }
        };
        visibleService = function (value) {
            var a = formAssignmentRules.getField('tas_assign_type').getValue();
            if (a === 'SELF_SERVICE' || a === 'SELF_SERVICE_EVALUATE') {
                formAssignmentRules.getField('tas_selfservice_time').setVisible(value);
                formAssignmentRules.getField('tas_selfservice_time_unit').setVisible(value);
                formAssignmentRules.getField('tas_selfservice_trigger_uid').setVisible(value);
                formAssignmentRules.getField('tas_selfservice_execution').setVisible(value);
            }
        };
        hiddenTab = function (value) {
            tabPanelAssignmentRules.showTab(2);
        };
        saveData = function () {
            var a, b, c, d, tas_selfservice_timeout, data;
            tas_selfservice_timeout = formAssignmentRules.getField('tas_selfservice_timeout').getValue() === '["1"]';
            if (!tas_selfservice_timeout) {
                //validation because getData method do not work in IE
                if (navigator.userAgent.indexOf("MSIE") !== -1 || navigator.userAgent.indexOf("Trident") !== -1) {
                    data = getData2PMUI(formAssignmentRules.html);
                    b = data["tas_assign_variable"];
                } else {
                    b = formAssignmentRules.getField('tas_assign_variable').getValue();
                }
                a = formAssignmentRules.getField('tas_assign_type').getValue();
                c = formAssignmentRules.getField('tas_group_variable').getValue();
                d = formAssignmentRules.getField('tas_group_variable').getValue();
                formAssignmentRules.getField('tas_assign_type').setValue(a);
                formAssignmentRules.getField('tas_assign_variable').setValue(b);
                formAssignmentRules.getField('tas_group_variable').setValue(c);
                formAssignmentRules.getField('tas_selfservice_timeout').setValue(d);
                formAssignmentRules.getField('tas_selfservice_time').setValue('');
                formAssignmentRules.getField('tas_selfservice_time_unit').setValue('');
                formAssignmentRules.getField('tas_selfservice_trigger_uid').setValue('');
                formAssignmentRules.getField('tas_selfservice_execution').setValue('');
            } else {
                if (!formAssignmentRules.isValid()) {
                    return;
                }
            }
            dataProperties.tas_assign_type = formAssignmentRules.getField('tas_assign_type').getValue();
            dataProperties.tas_assign_variable = formAssignmentRules.getField('tas_assign_variable').getValue() === '' ? '@@SYS_NEXT_USER_TO_BE_ASSIGNED' : formAssignmentRules.getField('tas_assign_variable').getValue();
            dataProperties.tas_group_variable = formAssignmentRules.getField('tas_group_variable').getValue() === '' ? '@@SYS_GROUP_TO_BE_ASSIGNED' : formAssignmentRules.getField('tas_group_variable').getValue();
            dataProperties.tas_selfservice_timeout = tas_selfservice_timeout ? 1 : 0;
            dataProperties.tas_selfservice_time = formAssignmentRules.getField('tas_selfservice_time').getValue() !== "" ? parseInt(formAssignmentRules.getField('tas_selfservice_time').getValue(), 10) : 0;
            dataProperties.tas_selfservice_time_unit = formAssignmentRules.getField('tas_selfservice_time_unit').getValue();
            dataProperties.tas_selfservice_trigger_uid = formAssignmentRules.getField('tas_selfservice_trigger_uid').getValue();
            dataProperties.tas_selfservice_execution = formAssignmentRules.getField('tas_selfservice_execution').getValue();
            updateRules();
        };
        saveOrUpdateUserAndAdHocUsers = function () {
            //Assigne and Remove (users)
            var i, b;
            if (gridUserList.getItems().length > 0) {
                grid = gridUserList;
                for (i = 0; i < arrayObjectUserList.length; i += 1) {
                    b = arrayObjectUserList[i];
                    if (arrayObjectUserList2.indexOf(b) == -1) {
                        assignee(b);
                    }
                }
            }
            if (gridUsers.getItems().length > 0) {
                for (i = 0; i < arrayObjectUsers.length; i += 1) {
                    b = arrayObjectUsers[i];
                    if (arrayObjectUsers2.indexOf(b) == -1) {
                        remove(arrayObjectUsers[i]);
                    }
                }
            }
            //Assigne and Remove (AdHocUsers)
            if (gridUserListAD.getItems().length > 0) {
                grid = gridUserListAD;
                for (i = 0; i < arrayObjectAdhocUserList.length; i += 1) {
                    b = arrayObjectAdhocUserList[i];
                    if (arrayObjectAdhocUserList2.indexOf(b) == -1) {
                        assigneeAD(b);
                    }
                }
            }
            if (gridUsersAD.getItems().length > 0) {
                for (i = 0; i < arrayObjectAdhocUser.length; i += 1) {
                    b = arrayObjectAdhocUser[i];
                    if (arrayObjectAdhocUser2.indexOf(b) == -1) {
                        removeAD(arrayObjectAdhocUser[i]);
                    }
                }
            }
        };
        applyStyles = function () {
            gridUsers.dom.toolbar.appendChild(buttonsUsers.getHTML());
            buttonsUsers.defineEvents();
            gridUsers.dom.toolbar.style.height = "76px";
            gridUserList.dom.toolbar.appendChild(buttonsUserList.getHTML());
            buttonsUserList.defineEvents();
            gridUserList.dom.toolbar.style.height = "76px";
            buttonsUsers.dom.labelTextContainer.style.display = "none";
            buttonsUserList.dom.labelTextContainer.style.display = "none";
            gridUsers.hideHeaders();
            gridUserList.hideHeaders();
            assigmentPanelUserList.setHeight('100%');
            gridUsers.filterControl.html.style.width = "300px";
            gridUserList.filterControl.html.style.width = "300px";
        };
        applyStylesAD = function () {
            gridUsersAD.dom.toolbar.appendChild(buttonsUsersAD.getHTML());
            buttonsUsersAD.defineEvents();
            gridUsersAD.dom.toolbar.style.height = "76px";

            gridUserListAD.dom.toolbar.appendChild(buttonsUserListAD.getHTML());
            buttonsUserListAD.defineEvents();
            gridUserListAD.dom.toolbar.style.height = "76px";
            buttonsUsersAD.dom.labelTextContainer.style.display = "none";
            buttonsUserListAD.dom.labelTextContainer.style.display = "none";
            gridUsersAD.hideHeaders();
            gridUserListAD.hideHeaders();
            assigmentPanelUserListAD.setHeight('100%');
            gridUsersAD.filterControl.html.style.width = "300px";
            gridUserListAD.filterControl.html.style.width = "300px";
        };
        assignee = function (row) {
            restClient.setTypeRequest("post");
            restClient.setEndpoint("activity/" + activity.id + "/assignee");
            restClient.setData({aas_uid: row.getData()["aas_uid"], aas_type: row.getData()["aas_type"]});
            restClient.functionSuccess = function (xhr, response) {
            };
            restClient.executeRestClient();
        };
        remove = function (row) {
            restClient.setTypeRequest("remove");
            restClient.setEndpoint("activity/" + activity.id + "/assignee/" + row.getData().aas_uid);
            restClient.functionSuccess = function (xhr, response) {
            };
            restClient.executeRestClient();
        };
        assigneeAD = function (row) {
            restClient.setTypeRequest("post");
            restClient.setEndpoint("activity/" + activity.id + "/adhoc-assignee");
            restClient.setData({ada_uid: row.getData()["ada_uid"], ada_type: row.getData()["ada_type"]});
            restClient.functionSuccess = function (xhr, response) {
            };
            restClient.executeRestClient();
        };
        removeAD = function (row) {
            restClient.setTypeRequest("remove");
            restClient.setEndpoint("activity/" + activity.id + "/adhoc-assignee/" + row.getData()["ada_uid"]);
            restClient.functionSuccess = function (xhr, response) {
            };
            restClient.executeRestClient();
        };
        groupRows = function (grid, value) {
            var i, items;
            if (grid.memorystack === undefined) {
                grid.memorystack = [];
            }
            items = grid.getItems();
            while (grid.memorystack.length > 0) {
                grid.addItem(grid.memorystack.pop());
            }
            if (value !== 'all') {
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].getData().ass_type !== value) {
                        grid.memorystack.push(items[i]);
                        grid.removeItem(items[i]);
                    }
                }
            }
            grid.sort('fullName', 'asc');
        };

        function onchangeRadio(grid, fieldName) {
            var radioButTrat = document.getElementsByName(fieldName), i;
            for (i = 0; i < radioButTrat.length; i += 1) {
                if (radioButTrat[i].checked == true) {
                    quickMessageWindow.close();
                    groupRows(grid, radioButTrat[i].value);
                }
            }
        }

        function domSettings() {
            if (activity.act_loop_type == "PARALLEL") {
                $(formAssignmentRules.getField("tas_assign_type").controls[0].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[1].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[2].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[3].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[4].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[5].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[6].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[7].html).parent().show();
                if (formAssignmentRules.getField('tas_assign_type').getValue() == "MULTIPLE_INSTANCE_VALUE_BASED") {
                    formAssignmentRules.getField('tas_assign_type').setValue("MULTIPLE_INSTANCE_VALUE_BASED");
                } else {
                    formAssignmentRules.getField('tas_assign_type').setValue("MULTIPLE_INSTANCE");
                }
            } else {
                $(formAssignmentRules.getField("tas_assign_type").controls[0].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[1].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[2].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[3].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[4].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[5].html).parent().show();
                $(formAssignmentRules.getField("tas_assign_type").controls[6].html).parent().hide();
                $(formAssignmentRules.getField("tas_assign_type").controls[7].html).parent().hide();
                if (formAssignmentRules.getField('tas_assign_type').getValue() == "MULTIPLE_INSTANCE_VALUE_BASED") {
                    formAssignmentRules.getField('tas_assign_type').setValue("BALANCED");
                    formAssignmentRules.getField('tas_assign_variable').setVisible(false);
                }
            }
        };

        panelTitleUser.addItem(titleUser);
        panelGridUser.addItem(gridUsers);
        assigmentPanelUser.addItem(panelTitleUser);
        assigmentPanelUser.addItem(panelGridUser);
        assigmentPanelGlobal.addItem(assigmentPanelUser);
        panelTitleUserList.addItem(titleUserList);
        panelGridUserList.addItem(gridUserList);
        assigmentPanelUserList.addItem(panelTitleUserList);
        assigmentPanelUserList.addItem(panelGridUserList);
        assigmentPanelGlobal.addItem(assigmentPanelUserList);

        panelTitleUserAD.addItem(titleUserAD);
        panelSearchUserAD.addItem(searchGridUserAD);
        panelGridUserAD.addItem(gridUsersAD);
        assigmentPanelUserAD.addItem(panelTitleUserAD);
        assigmentPanelUserAD.addItem(panelGridUserAD);
        assigmentPanelGlobalAD.addItem(assigmentPanelUserAD);
        panelTitleUseListAD.addItem(titleUserListAD);
        panelGridUserListAD.addItem(gridUserListAD);
        assigmentPanelUserListAD.addItem(panelTitleUseListAD);
        assigmentPanelUserListAD.addItem(panelGridUserListAD);
        assigmentPanelGlobalAD.addItem(assigmentPanelUserListAD);

        if (formAssignmentRules.dirty == null) {
            formAssignmentRules.dirty = false;
        }
        windowAssignmentRules.addItem(formAssignmentRules);
        windowAssignmentRules.addItem(tabPanelAssignmentRules);
        windowAssignmentRules.open();
        applyStyleWindowForm(windowAssignmentRules);
        windowAssignmentRules.body.style.overflowY = 'auto';
        windowAssignmentRules.body.style.overflowX = 'hidden';
        windowAssignmentRules.defineEvents();
        buttonsUsers.defineEvents();
        tabPanelAssignmentRules.itemClick(0);
        loadServerData();
        domSettings();
        //array for Users
        usersgrid = gridUsers;
        for (i = 0; i < usersgrid.getItems().length; i += 1) {
            arrayObjectUsers2[i] = usersgrid.getItems()[i];
        }
        userslist = gridUserList;
        for (i = 0; i < userslist.getItems().length; i += 1) {
            arrayObjectUserList2[i] = userslist.getItems()[i];
        }
        //array for AdHocUsers
        usersgrid = gridUsersAD;
        for (i = 0; i < usersgrid.getItems().length; i += 1) {
            arrayObjectAdhocUser2[i] = usersgrid.getItems()[i];
        }
        userslist = gridUserListAD;
        for (i = 0; i < userslist.getItems().length; i += 1) {
            arrayObjectAdhocUserList2[i] = userslist.getItems()[i];
        }
        formAssignmentRules.html.style.marginLeft = '30px';
        formAssignmentRulesSetTimeoutOption;
        document.getElementById("formAssignmentRulesSetTimeoutOption").childNodes[0].onchange = function () {
            visibleService(this.checked);
        };
        $(".pmui-field-control-table").css("border", "0px");
        $(".pmui-field-label").css("padding", "0px");
        $(".mafe-designer-assigment-title").css("margin-top", "25px");
        $("#formTasAssignType").append("<hr style=' border: 0; border-top: 1px solid #eee;'>");
        $(".pmui-gridpanel-footer").addClass("pmui-gridpanel-footer-dinamic");
    };
}());
(function () {
    PMDesigner.assigmentSupervisors = function (event) {
        var assigmentWindow = null,
            pageSizeAssignment = 8,
            restClient,
            assigmentPanelUser,
            assigmentPanelUserList,
            assigmentPanelGlobal,
            panelTitleUser,
            titleUser,
            panelSearchUser,
            searchGridUser,
            panelGridUser,
            buttonsUsers,
            gridUsers,
            panelTitleUserList,
            titleUserList,
            panelSearchUserList,
            searchGridUserList,
            panelGridUserList,
            buttonsUserList,
            gridUserList,
            applyStyles,
            loadServerData,
            loadUsers,
            loadUsersList,
            groupRows,
            assignee,
            remove,
            quickMessageWindow = new QuickMessageWindow();

        assigmentWindow = new PMUI.ui.Window({
            id: 'assigmentUserWindow',
            title: 'Assign Users and Groups as Supervisors'.translate(),
            width: DEFAULT_WINDOW_WIDTH + 1,
            height: DEFAULT_WINDOW_HEIGHT,
            footerHeight: 'auto',
            bodyHeight: 'auto',
            modal: true
        });
        restClient = new PMRestClient({
            endpoint: 'projects',
            typeRequest: 'get',
            messageError: 'There are problems, please try again.'.translate(),
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });

        assigmentPanelUser = new PMUI.core.Panel({
            layout: "vbox",
            width: "49%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-white'
                ]
            }
        });
        assigmentPanelUserList = new PMUI.core.Panel({
            layout: "vbox",
            width: "50%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-smooth'
                ]
            }
        });
        assigmentPanelGlobal = new PMUI.core.Panel({
            layout: 'hbox',
            width: DEFAULT_WINDOW_WIDTH,
            style: {
                cssClasses: [
                    'mafe-assigment-panel-global'
                ]
            }
        });

        panelTitleUser = new PMUI.core.Panel({
            layout: 'hbox'
        });
        titleUser = new PMUI.ui.TextLabel({
            id: 'titleUser',
            label: ' ',
            textMode: 'plain',
            text: 'Available Users List'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelSearchUser = new PMUI.core.Panel({
            layout: 'hbox'
        });
        searchGridUser = new PMUI.field.TextField({
            id: 'searchGridUser',
            label: ' ',
            placeholder: 'Search ...'.translate()
        });
        panelGridUser = new PMUI.core.Panel({layout: 'hbox'});
        buttonsUsers = new PMUI.field.OptionsSelectorField({
            id: 'buttonsUsers',
            orientation: 'horizontal',
            items: [{
                text: 'All'.translate(),
                selected: true,
                value: 'all',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-all'
                    ]
                }
            }, {
                text: 'Users'.translate(),
                value: 'user',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-user'
                    ]
                }
            }, {
                text: 'Groups'.translate(),
                value: 'group',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-group'
                    ]
                }
            }
            ],
            listeners: {
                select: function (item, event) {
                    groupRows(gridUsers, item.value);
                }
            },
            style: {
                cssClasses: [
                    'mafe-assigment-buttons'
                ]
            }
        });
        gridUsers = new PMUI.grid.GridPanel({
            id: 'gridUsers',
            pageSize: pageSizeAssignment,
            behavior: 'dragdropsort',
            filterable: true,
            filterPlaceholder: 'Search ...'.translate(),
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            columns: [{
                id: 'gridUsersButtonLabel',
                title: '',
                dataType: 'button',
                width: '10%',
                buttonLabel: function (row, data) {
                    return data.lastName;
                },
                buttonStyle: {
                    cssClasses: [
                        'mafe-grid-button'
                    ]
                },
                onButtonClick: function (row, grid) {
                    if (row.data.customKeys.obj_type === 'group') {
                        restClient.setTypeRequest('get');
                        restClient.functionSuccess = function (xhr, response) {
                            var stringUsers = '', i;
                            for (i = 0; i < response.length; i += 1) {
                                stringUsers = stringUsers + response[i].usr_firstname + ' ' + response[i].usr_lastname + ', ';
                            }
                            stringUsers = stringUsers.substring(0, stringUsers.length - 2);
                            if (stringUsers === '') {
                                stringUsers = 'No users';
                            }
                            quickMessageWindow.show($(row.html).find('a')[0], stringUsers);
                        };
                        restClient.setBaseEndPoint('group/' + row.data.customKeys.sup_uid + '/users');
                        restClient.executeRestClient();
                    }
                }
            }, {
                title: '',
                dataType: 'string',
                columnData: 'sup_name',
                alignmentCell: 'left',
                width: '80%'
            }, {
                id: 'gridUsersButtonAssign',
                title: '',
                dataType: 'button',
                width: '19%',
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-edit'
                    ]
                },
                buttonLabel: function (row, data) {
                    row.getCells()[0].content.style.addClasses([row.data.customKeys.obj_type === 'user' ? 'button-icon-user' : 'button-icon-group']);
                    return 'Assign'.translate();
                },
                onButtonClick: function (row, grid) {
                    grid.removeItem(row);
                    grid.sort('sup_name', 'asc');
                    gridUserList.addItem(row);
                    buttonsUserList.setValue(buttonsUsers.getValue());
                    groupRows(gridUserList, buttonsUsers.getValue());
                    assignee(row);
                }
            }
            ],
            onDropOut: function (item, origin, destiny) {
                assignee(item);
            },
            onDrop: function (a, row) {
                buttonsUsers.setValue(buttonsUserList.getValue());
                groupRows(gridUsers, buttonsUserList.getValue());
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });

        panelTitleUserList = new PMUI.core.Panel({
            layout: 'hbox'
        });
        titleUserList = new PMUI.ui.TextLabel({
            id: 'titleUserList',
            textMode: 'plain',
            text: 'Assigned Users List'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelSearchUserList = new PMUI.core.Panel({
            layout: 'hbox'
        });
        searchGridUserList = new PMUI.field.TextField({
            id: 'searchGridUserList',
            label: ' ',
            placeholder: 'Search ...'.translate()
        });
        panelGridUserList = new PMUI.core.Panel({
            layout: 'hbox'
        });
        buttonsUserList = new PMUI.field.OptionsSelectorField({
            id: 'buttonsUserList',
            orientation: 'horizontal',
            items: [{
                text: 'All'.translate(),
                value: 'all',
                selected: true,
                style: {
                    cssClasses: [
                        'pmui-switch-icon-all'
                    ]
                }
            }, {
                text: 'Users'.translate(),
                value: 'user',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-user'
                    ]
                }
            }, {
                text: 'Groups'.translate(),
                value: 'group',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-group'
                    ]
                }
            }

            ],
            listeners: {
                select: function (item, event) {
                    groupRows(gridUserList, item.value);
                }
            },
            style: {
                cssClasses: [
                    'mafe-assigment-buttons'
                ]
            }
        });
        gridUserList = new PMUI.grid.GridPanel({
            id: 'gridUserList',
            pageSize: pageSizeAssignment,
            behavior: 'dragdropsort',
            filterPlaceholder: 'Search ...'.translate(),
            filterable: true,
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            emptyMessage: function () {
                var div = document.createElement('div'),
                    span = document.createElement('span');
                div.appendChild(span);
                div.className = 'mafe-grid-panel-empty';
                span.innerHTML = 'Drag & Drop a User or a Group here'.translate();
                return div;
            },
            onEmpty: function (grid, cell) {
                gridUserList.dom.tableContainer.style.overflow = 'hidden';
            },
            columns: [{
                id: 'gridUserListButtonLabel',
                title: '',
                width: '10%',
                dataType: 'button',
                buttonLabel: function (row, data) {
                    return data.lastName;
                },
                buttonStyle: {
                    cssClasses: [
                        'mafe-grid-button'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var stringUsers, i;
                    if (row.data.customKeys.obj_type === 'group') {
                        restClient.setTypeRequest('get');
                        restClient.functionSuccess = function (xhr, response) {
                            stringUsers = '';
                            for (i = 0; i < response.length; i += 1) {
                                stringUsers = stringUsers + response[i].usr_firstname + ' ' + response[i].usr_lastname + ', ';
                            }
                            stringUsers = stringUsers.substring(0, stringUsers.length - 2);
                            if (stringUsers === '') {
                                stringUsers = 'No users';
                            }
                            quickMessageWindow.show($(row.html).find('a')[0], stringUsers);
                        };
                        restClient.setBaseEndPoint('group/' + row.data.customKeys.sup_uid + '/users');
                        restClient.executeRestClient();
                    }
                }
            }, {
                title: '',
                dataType: 'string',
                columnData: 'sup_name',
                width: '80%',
                alignmentCell: 'left'
            }, {
                id: 'gridUserListButtonDelete',
                title: '',
                dataType: 'button',
                width: '10%',
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-delete'
                    ]
                },
                buttonLabel: function (row, data) {
                    row.getCells()[0].content.style.addClasses([row.data.customKeys.obj_type === 'user' ? 'button-icon-user' : 'button-icon-group']);
                    return 'Remove'.translate();
                },
                onButtonClick: function (row, grid) {
                    grid.removeItem(row);
                    grid.sort('sup_name', 'asc');
                    gridUsers.addItem(row);
                    buttonsUsers.setValue(buttonsUserList.getValue());
                    groupRows(gridUsers, buttonsUserList.getValue());
                    remove(row);
                }
            }
            ],
            onDropOut: function (item, origin, destiny) {
                remove(item);
            },
            onDrop: function (a, row) {
                buttonsUserList.setValue(buttonsUsers.getValue());
                groupRows(gridUserList, buttonsUsers.getValue());
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });

        applyStyles = function () {
            gridUsers.dom.toolbar.appendChild(buttonsUsers.getHTML());
            gridUsers.dom.toolbar.style.height = "76px";
            gridUserList.dom.toolbar.appendChild(buttonsUserList.getHTML());
            gridUserList.dom.toolbar.style.height = "76px";
            buttonsUsers.dom.labelTextContainer.style.display = "none";
            buttonsUserList.dom.labelTextContainer.style.display = "none";
            gridUsers.hideHeaders();
            gridUserList.hideHeaders();
            assigmentPanelUserList.setHeight('100%');
            gridUsers.filterControl.html.style.width = "300px";
            gridUserList.filterControl.html.style.width = "300px";
        };
        loadServerData = function () {
            var restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    calls: [
                        {
                            url: 'project/' + PMDesigner.project.id + '/available-process-supervisors',
                            method: 'GET'
                        }, {
                            url: 'project/' + PMDesigner.project.id + '/process-supervisors',
                            method: 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    loadUsers(response[0].response);
                    loadUsersList(response[1].response);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.setBaseEndPoint('');
            restClient.executeRestClient();
        };
        loadUsers = function (response) {
            var i;
            for (i = 0; i < response.length; i += 1) {
                if (response[i].obj_type === 'user') {
                    gridUsers.addDataItem({
                        sup_uid: response[i].usr_uid,
                        sup_name: response[i].usr_firstname + ' ' + response[i].usr_lastname,
                        obj_type: response[i].obj_type
                    });
                }
                if (response[i].obj_type === 'group') {
                    gridUsers.addDataItem({
                        sup_uid: response[i].grp_uid,
                        sup_name: response[i].grp_name,
                        obj_type: response[i].obj_type
                    });
                }
            }
            gridUsers.sort('sup_name', 'asc');
        };
        loadUsersList = function (response) {
            var i;
            for (i = 0; i < response.length; i += 1) {
                if (response[i].pu_type === 'SUPERVISOR') {
                    gridUserList.addDataItem({
                        sup_uid: response[i].usr_uid,
                        sup_name: response[i].usr_firstname + ' ' + response[i].usr_lastname,
                        obj_type: 'user',
                        pu_type: response[i].pu_type,
                        pu_uid: response[i].pu_uid
                    });
                }
                if (response[i].pu_type === 'GROUP_SUPERVISOR') {
                    gridUserList.addDataItem({
                        sup_uid: response[i].grp_uid,
                        sup_name: response[i].grp_name,
                        obj_type: 'group',
                        pu_type: response[i].pu_type,
                        pu_uid: response[i].pu_uid
                    });
                }
            }
            gridUserList.sort('sup_name', 'asc');
        };
        groupRows = function (grid, value) {
            var i, items;
            if (grid.memorystack === undefined) {
                grid.memorystack = [];
            }
            items = grid.getItems();
            while (grid.memorystack.length > 0) {
                grid.addItem(grid.memorystack.pop());
            }
            if (value !== 'all') {
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].getData().obj_type !== value) {
                        grid.memorystack.push(items[i]);
                        grid.removeItem(items[i]);
                    }
                }
            }
            grid.sort('sup_name', 'asc');
        };
        assignee = function (row) {
            var restClient = new PMRestClient({
                endpoint: 'process-supervisor',
                typeRequest: 'post',
                data: {
                    usr_uid: row.data.customKeys.sup_uid,
                    pu_type: row.data.customKeys.obj_type === 'group' ? 'GROUP_SUPERVISOR' : 'SUPERVISOR'
                },
                functionSuccess: function (xhr, response) {
                    row.data.customKeys.pu_type = response.pu_type;
                    row.data.customKeys.pu_uid = response.pu_uid;
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: 'There are problems saving the assigned user, please try again.'.translate()
            });
            restClient.executeRestClient();
        };
        remove = function (row) {
            var restClient = new PMRestClient({
                endpoint: 'process-supervisor/' + row.data.customKeys.pu_uid,
                typeRequest: 'remove',
                functionSuccess: function () {
                },
                functionComplete: function () {
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.executeRestClient();
        };

        assigmentWindow.open();
        panelTitleUser.addItem(titleUser);
        panelTitleUserList.addItem(titleUserList);
        assigmentWindow.body.style.overflow = "hidden";
        panelGridUser.addItem(gridUsers);
        panelGridUserList.addItem(gridUserList);

        assigmentPanelGlobal.addItem(assigmentPanelUser);
        assigmentPanelGlobal.addItem(assigmentPanelUserList);
        assigmentWindow.addItem(assigmentPanelGlobal);

        assigmentPanelUser.addItem(panelTitleUser);
        assigmentPanelUser.addItem(panelSearchUser);
        assigmentPanelUser.addItem(buttonsUsers);
        assigmentPanelUser.addItem(panelGridUser);

        assigmentPanelUserList.addItem(panelTitleUserList);
        assigmentPanelUserList.addItem(panelSearchUserList);
        assigmentPanelUserList.addItem(buttonsUserList);
        assigmentPanelUserList.addItem(panelGridUserList);

        assigmentWindow.defineEvents();
        applyStyles();

        loadServerData();
    };
}());
(function () {
    PMDesigner.assigmentSupervisors = function (event) {
        var assigmentWindow = null,
            pageSizeAssignment = 8,
            flagEdit = 0,
            i,
            index = 0,
            quickMessageWindow = new QuickMessageWindow(),
            arrayObjectUserList = new Array(),
            arrayObjectUsers = new Array(),
            arrayObjectUserList2 = new Array(),
            arrayObjectUsers2 = new Array(),
            arrayDynaformInputDocumentID = new Array(),
            arrayDynaformInputDocumentObject = new Array(),
            arrayObjectRemovedSteps = new Array(),
            message_window,
            restClient,
            assigmentPanelUser,
            assigmentPanelUserList,
            assigmentPanelGlobal,
            panelTitleUser,
            titleUser,
            panelSearchUser,
            searchGridUser,
            panelGridUser,
            buttonsUsers,
            gridUsers,
            panelTitleUserList,
            titleUserList,
            panelSearchUserList,
            searchGridUserList,
            panelGridUserList,
            radioUsersList,
            buttonsUserList,
            gridUserList,
            radioUsers,
            applyStylesRadioButtonGroupField,
            applyStylesForToolbar,
            applyStyles,
            loadUsers,
            loadUsersList,
            groupRows,
            assignee,
            remove,
            loadGridCaseTacker,
            orderDataTree,
            titleTreeObjects,
            titleGridObjects,
            panelLabelObjects,
            panelObjects,
            treePanelObjects,
            updateItem,
            usersgrid,
            saveItemDyanformInputDocuments,
            getValuesAssignmentSteps,
            gridPanelObjects,
            panelContainerObjects,
            userslist,
            gridpanelobj,
            flashMessage = new PMUI.ui.FlashMessage({
                message: '',
                appendTo: document.body,
                duration: 1000,
                severity: "success"
            });
        assigmentWindow = new PMUI.ui.Window({
            id: 'assigmentUserWindow',
            title: 'Supervisors'.translate(),
            width: DEFAULT_WINDOW_WIDTH + 1,
            height: DEFAULT_WINDOW_HEIGHT,
            footerHeight: 'auto',
            bodyHeight: 'auto',
            modal: true,
            onBeforeClose: function () {
                if (flagEdit != 0) {
                    message_window.open();
                    message_window.showFooter();
                } else {
                    assigmentWindow.close();
                }
            },
            footerItems: [
                {
                    text: "Cancel",
                    handler: function () {
                        if (flagEdit != 0) {
                            message_window.open();
                            message_window.showFooter();
                        } else {
                            assigmentWindow.close();
                        }
                    },
                    buttonType: 'error'
                },
                {
                    text: 'Save',
                    handler: function () {
                        var i, j, idObject, objType, baseEndPointID;
                        if (flagEdit != 0) {
                            //save Configuration Supervisors and Steps(Dyanform - Inputs Documents)                            
                            if (gridUserList.getItems().length > 0) {
                                grid = gridUserList;
                                for (i = 0; i < arrayObjectUserList.length; i += 1) {
                                    b = arrayObjectUserList[i];
                                    grid.removeItem(b);
                                    grid.sort('sup_name', 'asc');
                                    gridUserList.addItem(b);
                                    radioUsersList.setValue(radioUsers.getValue());
                                    groupRows(gridUserList, radioUsers.getValue());
                                    if (arrayObjectUserList2.indexOf(b) == -1) {
                                        assignee(b);
                                    }
                                }
                            }
                            if (gridUsers.getItems().length > 0) {
                                for (i = 0; i < arrayObjectUsers.length; i += 1) {
                                    b = arrayObjectUsers[i];
                                    if (arrayObjectUsers2.indexOf(b) == -1) {
                                        remove(arrayObjectUsers[i]);
                                    }
                                }
                            }

                            index = 0;
                            for (i = 0; i < gridPanelObjects.getItems().length; i += 1) {
                                idObject = gridPanelObjects.getItems()[i].getData().obj_uid;
                                index = arrayDynaformInputDocumentID.indexOf(idObject);
                                if (index <= -1) {
                                    saveItemDyanformInputDocuments(gridPanelObjects.getItems()[i]);
                                } else {
                                    updateItem(gridPanelObjects.getItems()[i], i);
                                }
                            }

                            for (i = 0; i < arrayObjectRemovedSteps.length; i += 1) {
                                for (j = 0; j < arrayDynaformInputDocumentObject.length; j += 1) {
                                    index = (arrayObjectRemovedSteps[i] == arrayDynaformInputDocumentObject[j].obj_uid) ? 0 : 1;
                                    if (index == 0) {
                                        objType = arrayDynaformInputDocumentObject[j].obj_type.toLowerCase();
                                        baseEndPointID = (objType === "dynaform") ? arrayDynaformInputDocumentObject[j].pud_uid : arrayDynaformInputDocumentObject[j].pui_uid;
                                        restClient = new PMRestClient({
                                            typeRequest: 'post',
                                            multipart: true,
                                            data: {
                                                "calls": [
                                                    {
                                                        "url": 'process-supervisor/' + objType + '/' + baseEndPointID,
                                                        "method": 'DELETE'
                                                    }
                                                ]
                                            },
                                            functionSuccess: function (xhr, response) {
                                            },
                                            functionFailure: function (xhr, response) {
                                            }
                                        });
                                        restClient.executeRestClient();
                                        break;
                                    }
                                }
                            }
                            assigmentWindow.close();
                        }
                        else {
                            assigmentWindow.close();
                        }
                    },
                    buttonType: "success"
                }
            ],
            visibleFooter: true,
            buttonPanelPosition: "bottom",
            footerAlign: "right"
        });

        message_window = new PMUI.ui.MessageWindow({
            id: "messageWindowCancel",
            width: 490,
            title: "Supervisors".translate(),
            windowMessageType: "warning",
            bodyHeight: "auto",
            message: 'Are you sure you want to discard your changes?'.translate(),
            footerItems: [{
                id: "messageWindowNo",
                text: "No".translate(),
                handler: function () {
                    message_window.close();
                },
                buttonType: "error"
            },
                {
                    id: "messageWindowYes",
                    text: "Yes".translate(),
                    handler: function () {
                        message_window.close();
                        assigmentWindow.close();
                    },
                    buttonType: "success"
                }
            ]
        });

        restClient = new PMRestClient({
            endpoint: 'projects',
            typeRequest: 'get',
            messageError: 'There are problems, please try again.'.translate(),
            functionFailure: function (xhr, response) {
                PMDesigner.msgWinError(response.error.message);
            }
        });

        assigmentPanelUser = new PMUI.core.Panel({
            layout: "vbox",
            width: "49%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-white'
                ]
            }
        });
        assigmentPanelUserList = new PMUI.core.Panel({
            layout: "vbox",
            width: "50%",
            style: {
                cssClasses: [
                    'mafe-panel-assignment-smooth'
                ]
            }
        });
        assigmentPanelGlobal = new PMUI.core.Panel({
            layout: 'hbox',
            width: DEFAULT_WINDOW_WIDTH,
            style: {
                cssClasses: [
                    'mafe-assigment-panel-global'
                ]
            }
        });

        panelTitleUser = new PMUI.core.Panel({
            layout: 'hbox'
        });
        titleUser = new PMUI.ui.TextLabel({
            id: 'titleUser',
            label: ' ',
            textMode: 'plain',
            text: 'Available Users List'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelSearchUser = new PMUI.core.Panel({
            layout: 'hbox'
        });
        searchGridUser = new PMUI.field.TextField({
            id: 'searchGridUser',
            label: ' ',
            placeholder: 'Search ...'.translate()
        });
        panelGridUser = new PMUI.core.Panel({layout: 'hbox'});
        buttonsUsers = new PMUI.field.OptionsSelectorField({
            id: 'buttonsUsers',
            orientation: 'horizontal',
            items: [{
                text: 'All'.translate(),
                selected: true,
                value: 'all',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-all'
                    ]
                }
            }, {
                text: 'Users'.translate(),
                value: 'user',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-user'
                    ]
                }
            }, {
                text: 'Groups'.translate(),
                value: 'group',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-group'
                    ]
                }
            }
            ],
            listeners: {
                select: function (item, event) {
                    groupRows(gridUsers, item.value);
                }
            },
            style: {
                cssClasses: [
                    'mafe-assigment-buttons'
                ]
            }
        });
        gridUsers = new PMUI.grid.GridPanel({
            id: 'gridUsers',
            pageSize: pageSizeAssignment,
            behavior: 'dragdropsort',
            filterable: true,
            filterPlaceholder: 'Search ...'.translate(),
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            dynamicLoad: {
                keys: {
                    server: HTTP_SERVER_HOSTNAME,
                    projectID: PMDesigner.project.projectId,
                    workspace: WORKSPACE,
                    accessToken: PMDesigner.project.tokens.access_token,
                    endPoint: 'project/' + PMDesigner.project.id + '/available-process-supervisors/paged'
                }
            },
            customDataRest: function (data) {
                var i;
                for (i = 0; i < data.length; i += 1) {
                    if (data[i].obj_type == "group") {
                        data[i].available = data[i].grp_name;
                    } else {
                        data[i].available = data[i]["usr_firstname"] + " " + data[i]["usr_lastname"] + " (" + data[i]["usr_username"] + ")";
                    }
                }
                return data;
            },
            columns: [{
                id: 'gridUsersButtonLabel',
                title: '',
                dataType: 'button',
                width: '10%',
                buttonLabel: function (row, data) {
                    return data.lastName;
                },
                buttonStyle: {
                    cssClasses: [
                        'mafe-grid-button'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var option, select;
                    select = document.createElement("span");
                    select.id = "list-usersIngroup";
                    option = document.createElement("span");
                    option.id = "list-usersIngroup-iem"
                    if (row.getData()["obj_type"] === 'group') {
                        var restClient = new PMRestClient({
                            typeRequest: 'get',
                            functionSuccess: function (xhr, response) {
                                var optionClone, i;
                                for (i = 0; i < response.length; i += 1) {
                                    if (i == 10) {
                                        optionClone = option.cloneNode(false);
                                        optionClone.innerHTML = "<b style='float: right'>. . .<b>";
                                        select.appendChild(optionClone);
                                    } else {
                                        optionClone = option.cloneNode(false);
                                        optionClone.textContent = "- " + response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                        optionClone.title = response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                        select.appendChild(optionClone);
                                    }
                                }
                                if (!optionClone) {
                                    optionClone = option.cloneNode(false);
                                    optionClone.textContent = "No users".translate();
                                    select.appendChild(optionClone);
                                }

                                quickMessageWindow.show($(row.html).find('a')[0], select);
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: 'There are problems saving the assigned user, please try again.'.translate()
                        });
                        restClient.setBaseEndPoint('group/' + row.getData()["grp_uid"] + '/supervisor-users?start=0&limit=11');
                        restClient.executeRestClient();
                    }
                }
            }, {
                title: '',
                dataType: 'string',
                columnData: 'available',
                alignmentCell: 'left',
                width: '330px'
            }, {
                id: 'gridUsersButtonAssign',
                title: '',
                dataType: 'button',
                width: '19%',
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-edit-assign'
                    ]
                },
                buttonLabel: function (row, data) {
                    row.getCells()[0].content.style.addClasses([row.getData()["obj_type"] === 'user' ? 'button-icon-user' : 'button-icon-group']);
                    return '';
                },
                onButtonClick: function (row, grid) {
                    grid = (grid != null) ? grid : gridUsers;
                    assignee(row);
                    gridUserList.goToPage(gridUserList.currentPage);
                    grid.goToPage(grid.currentPage);
                    flashMessage.setMessage("The user/group was successfully removed".translate());
                    flashMessage.setAppendTo(assigmentWindow.getHTML());
                    flashMessage.show();
                }
            }
            ],
            onDropOut: function (item, origin, destiny) {
            },
            onDrop: function (a, row) {
                grid = this;
                remove(row);
                gridUserList.goToPage(gridUserList.currentPage);
                grid.goToPage(grid.currentPage);
                flashMessage.setMessage("The user/group was successfully removed".translate());
                flashMessage.setAppendTo(assigmentWindow.getHTML());
                flashMessage.show();
                return false;
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });

        panelTitleUserList = new PMUI.core.Panel({
            layout: 'hbox'
        });
        titleUserList = new PMUI.ui.TextLabel({
            id: 'titleUserList',
            textMode: 'plain',
            text: 'Assigned supervisors list'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });
        panelSearchUserList = new PMUI.core.Panel({
            layout: 'hbox'
        });
        searchGridUserList = new PMUI.field.TextField({
            id: 'searchGridUserList',
            label: ' ',
            placeholder: 'Search ...'.translate()
        });
        panelGridUserList = new PMUI.core.Panel({
            layout: 'hbox'
        });
        radioUsersList = new PMUI.field.RadioButtonGroupField({
            id: 'idRadioUsersList',
            controlPositioning: 'horizontal',
            maxDirectionOptions: 3,
            options: [
                {
                    label: "View all".translate(),
                    value: "all"
                },
                {
                    label: "View users".translate(),
                    value: "user"
                },
                {
                    label: "View groups".translate(),
                    value: "group"
                }
            ],
            onChange: function (newVal, oldVal) {
                switch (newVal) {
                    case "user" :
                        gridUserList.typeList = "user".translate();
                        break;
                    case "group":
                        gridUserList.typeList = "group".translate();
                        break;
                    default:
                        gridUserList.typeList = "";
                        break;
                }
                gridUserList.goToPage(0);
            },
            required: true,
            value: "all"
        });
        buttonsUserList = new PMUI.field.OptionsSelectorField({
            id: 'buttonsUserList',
            orientation: 'horizontal',
            items: [{
                text: 'All'.translate(),
                value: 'all',
                selected: true,
                style: {
                    cssClasses: [
                        'pmui-switch-icon-all'
                    ]
                }
            }, {
                text: 'Users'.translate(),
                value: 'user',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-user'
                    ]
                }
            }, {
                text: 'Groups'.translate(),
                value: 'group',
                style: {
                    cssClasses: [
                        'pmui-switch-icon-group'
                    ]
                }
            }

            ],
            listeners: {
                select: function (item, event) {
                    groupRows(gridUserList, item.value);
                }
            },
            style: {
                cssClasses: [
                    'mafe-assigment-buttons'
                ]
            }
        });
        gridUserList = new PMUI.grid.GridPanel({
            id: 'gridUserList',
            pageSize: pageSizeAssignment,
            behavior: 'dragdropsort',
            filterPlaceholder: 'Search ...'.translate(),
            filterable: true,
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            emptyMessage: function () {
                var div = document.createElement('div'),
                    span = document.createElement('span');
                div.appendChild(span);
                div.className = 'mafe-grid-panel-empty';
                span.innerHTML = 'Drag & Drop a User or a Group here'.translate();
                return div;
            },
            onEmpty: function (grid, cell) {
                gridUserList.dom.tableContainer.style.overflow = 'hidden';
            },
            dynamicLoad: {
                keys: {
                    server: HTTP_SERVER_HOSTNAME,
                    projectID: PMDesigner.project.projectId,
                    workspace: WORKSPACE,
                    accessToken: PMDesigner.project.tokens.access_token,
                    endPoint: 'project/' + PMDesigner.project.id + '/process-supervisors/paged'
                }
            },
            customDataRest: function (data) {
                var i;
                for (i = 0; i < data.length; i += 1) {
                    if (data[i].pu_type == "GROUP_SUPERVISOR") {
                        data[i].assignee = data[i].grp_name;
                    } else {
                        data[i].assignee = data[i]["usr_firstname"] + " " + data[i]["usr_lastname"] + " (" + data[i]["usr_username"] + ")";
                    }
                }
                return data;
            },
            columns: [{
                id: 'gridUserListButtonLabel',
                title: '',
                width: '10%',
                dataType: 'button',
                buttonLabel: function (row, data) {
                    return data.lastName;
                },
                buttonStyle: {
                    cssClasses: [
                        'mafe-grid-button'
                    ]
                },
                onButtonClick: function (row, grid) {
                    var option, select;
                    select = document.createElement("span");
                    select.id = "list-usersIngroup";
                    option = document.createElement("span");
                    option.id = "list-usersIngroup-iem"
                    if (row.getData()["pu_type"] === "GROUP_SUPERVISOR") {
                        var restClient = new PMRestClient({
                            typeRequest: 'get',
                            functionSuccess: function (xhr, response) {
                                var optionClone, i;
                                for (i = 0; i < response.length; i += 1) {
                                    if (i == 10) {
                                        optionClone = option.cloneNode(false);
                                        optionClone.innerHTML = "<b style='float: right'>. . .<b>";
                                        select.appendChild(optionClone);
                                    } else {
                                        optionClone = option.cloneNode(false);
                                        optionClone.textContent = "- " + response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                        optionClone.title = response[i].usr_firstname + ' ' + response[i].usr_lastname;
                                        select.appendChild(optionClone);
                                    }
                                }
                                if (!optionClone) {
                                    optionClone = option.cloneNode(false);
                                    optionClone.textContent = "No users".translate();
                                    select.appendChild(optionClone);
                                }

                                quickMessageWindow.show($(row.html).find('a')[0], select);
                            },
                            functionFailure: function (xhr, response) {
                                PMDesigner.msgWinError(response.error.message);
                            },
                            messageError: 'There are problems saving the assigned user, please try again.'.translate()
                        });
                        restClient.setBaseEndPoint('group/' + row.getData()["grp_uid"] + '/supervisor-users?start=0&limit=11');
                        restClient.executeRestClient();
                    }
                }
            }, {
                title: '',
                dataType: 'string',
                columnData: 'assignee',
                width: '330px',
                alignmentCell: 'left'
            }, {
                id: 'gridUserListButtonDelete',
                title: '',
                dataType: 'button',
                width: '10%',
                buttonStyle: {
                    cssClasses: [
                        'mafe-button-delete-assign'
                    ]
                },
                buttonLabel: function (row, data) {
                    row.getCells()[0].content.style.addClasses([row.getData()["pu_type"] === "SUPERVISOR" ? 'button-icon-user' : 'button-icon-group']);
                    return '';
                },
                onButtonClick: function (row, grid) {
                    grid = (grid != null) ? grid : gridUsers;
                    remove(row);
                    gridUsers.goToPage(gridUsers.currentPage);
                    grid.goToPage(grid.currentPage);
                    flashMessage.setMessage("Assignee saved successfully".translate());
                    flashMessage.setAppendTo(assigmentWindow.getHTML());
                    flashMessage.show();
                }
            }
            ],
            onDropOut: function (item, origin, destiny) {
            },
            onDrop: function (grid, row) {
                var dataRow = {};
                grid = this;
                assignee(row);
                gridUsers.goToPage(gridUsers.currentPage);
                grid.goToPage(grid.currentPage);
                flashMessage.setMessage("Assignee saved successfully".translate());
                flashMessage.setAppendTo(assigmentWindow.getHTML());
                flashMessage.show();
                return false;
            },
            style: {
                cssClasses: [
                    'mafe-designer-assigment-grid'
                ]
            }
        });
        radioUsers = new PMUI.field.RadioButtonGroupField({
            id: 'idRadioUsers',
            controlPositioning: 'horizontal',
            maxDirectionOptions: 3,
            options: [
                {
                    label: "View all".translate(),
                    value: "all"
                },
                {
                    label: "View users".translate(),
                    value: "user"
                },
                {
                    label: "View groups".translate(),
                    value: "group"
                }
            ],
            onChange: function (newVal, oldVal) {
                switch (newVal) {
                    case "user" :
                        gridUsers.typeList = "user";
                        break;
                    case "group":
                        gridUsers.typeList = "group";
                        break;
                    default:
                        gridUsers.typeList = "";
                        break;
                }
                gridUsers.goToPage(0);
            },
            required: true,
            value: "all",
            style: {
                cssProperties: {
                    'margin-top': '15px'
                }
            }
        });
        applyStylesRadioButtonGroupField = function () {
            $('#idRadioUsers .pmui-field-control-table').css("border", "none");
            $('#idRadioUsers').css("margin-top", "12px");
            radioUsers.defineEvents();

            $('#idRadioUsersList .pmui-field-control-table').css("border", "none");
            $('#idRadioUsersList').css("margin-top", "12px");
            radioUsersList.defineEvents();
        };

        applyStylesForToolbar = function () {
            $('.pmui-gridpanel-toolbar')[0].childNodes[0].style.width = "300px";
            $('.pmui-gridpanel-toolbar')[1].childNodes[0].style.width = "300px";
            $('.pmui-gridpanel-toolbar')[0].childNodes[0].style.backgroundColor = "#f5f5f5";
            $('.pmui-gridpanel-toolbar')[1].childNodes[0].style.backgroundColor = "#f5f5f5";
            $('#assigmentUserWindow')[0].childNodes[1].childNodes[0].childNodes[1].style.backgroundColor = "white";
            $('#gridUserList')[0].style.backgroundColor = "white";
            $('#gridUserList').css("width", "452px");
            $('#gridUsers').css({"width": "452px", "height": "175px"});
            $('.pmui-window-body .pmui-panel:eq(9)').css({
                'width': '1000px',
                'border-top': '1px solid #cdd2d5',
                'margin-top': '36px',
                'height': '80px'
            });
        };

        applyStyles = function () {
            applyStylesRadioButtonGroupField();
            gridUsers.dom.toolbar.appendChild(radioUsers.getHTML());
            gridUsers.dom.toolbar.style.height = "76px";
            gridUserList.dom.toolbar.appendChild(radioUsersList.getHTML());
            gridUserList.dom.toolbar.style.height = "76px";
            radioUsers.dom.labelTextContainer.style.display = "none";
            radioUsersList.dom.labelTextContainer.style.display = "none";
            gridUsers.hideHeaders();
            gridUserList.hideHeaders();
            assigmentPanelUserList.setHeight('100%');
            gridUsers.filterControl.html.style.width = "300px";
            gridUserList.filterControl.html.style.width = "300px";
            assigmentWindow.getItems()[0].getItems()[0].html.style.borderRight = "1px solid #cdd2d5";
            assigmentWindow.getItems()[0].getItems()[0].html.style.borderBottom = "1px solid #cdd2d5";
            assigmentWindow.getItems()[0].getItems()[1].html.style.borderBottom = "1px solid #cdd2d5";
            assigmentWindow.getItems()[0].getItems()[0].html.style.height = "415px";
            assigmentWindow.getItems()[0].getItems()[1].html.style.height = "415px";
            assigmentWindow.getItems()[0].getItems()[1].html.style.paddingLeft = "10px";
            $('#gridPanelObjects .pmui-gridpanel-tableContainer').css({'height': '245px'});
            $(".pmui-gridpanel-footer").addClass("pmui-gridpanel-footer-dinamic");
        };
        loadUsers = function (response) {
            var i;
            for (i = 0; i < response.length; i += 1) {
                if (response[i].obj_type === 'user') {
                    gridUsers.addDataItem({
                        sup_uid: response[i].usr_uid,
                        sup_name: response[i].usr_firstname + ' ' + response[i].usr_lastname,
                        obj_type: response[i].obj_type
                    });
                }
                if (response[i].obj_type === 'group') {
                    gridUsers.addDataItem({
                        sup_uid: response[i].grp_uid,
                        sup_name: response[i].grp_name,
                        obj_type: response[i].obj_type
                    });
                }
            }
            gridUsers.sort('sup_name', 'asc');
        };
        loadUsersList = function (response) {
            var i;
            for (i = 0; i < response.length; i += 1) {
                if (response[i].pu_type === 'SUPERVISOR') {
                    gridUserList.addDataItem({
                        sup_uid: response[i].usr_uid,
                        sup_name: response[i].usr_firstname + ' ' + response[i].usr_lastname,
                        obj_type: 'user',
                        pu_type: response[i].pu_type,
                        pu_uid: response[i].pu_uid
                    });
                }
                if (response[i].pu_type === 'GROUP_SUPERVISOR') {
                    gridUserList.addDataItem({
                        sup_uid: response[i].grp_uid,
                        sup_name: response[i].grp_name,
                        obj_type: 'group',
                        pu_type: response[i].pu_type,
                        pu_uid: response[i].pu_uid
                    });
                }
            }
            gridUserList.sort('sup_name', 'asc');
        };
        groupRows = function (grid, value) {
            var i, items;
            if (grid.memorystack === undefined) {
                grid.memorystack = [];
            }
            items = grid.getItems();
            while (grid.memorystack.length > 0) {
                grid.addItem(grid.memorystack.pop());
            }
            if (value !== 'all') {
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].getData().obj_type !== value) {
                        grid.memorystack.push(items[i]);
                        grid.removeItem(items[i]);
                    }
                }
            }
            grid.sort('sup_name', 'asc');
        };
        assignee = function (row) {
            var restClient = new PMRestClient({
                endpoint: 'process-supervisor',
                typeRequest: 'post',
                data: {
                    usr_uid: row.getData()["obj_type"] == "group" ? row.getData()["grp_uid"] : row.getData()["usr_uid"],
                    pu_type: row.getData()["obj_type"] === 'group' ? 'GROUP_SUPERVISOR' : 'SUPERVISOR'
                },
                functionSuccess: function (xhr, response) {
                    row.data.customKeys.pu_type = response.pu_type;
                    row.data.customKeys.pu_uid = response.pu_uid;
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                },
                messageError: 'There are problems saving the assigned user, please try again.'.translate()
            });
            restClient.executeRestClient();
        };
        remove = function (row) {
            var restClient = new PMRestClient({
                endpoint: 'process-supervisor/' + row.getData()["pu_uid"],
                typeRequest: 'remove',
                functionSuccess: function () {
                },
                functionComplete: function () {
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.executeRestClient();
        };

        //steps Dynaforms and InputDocuments
        titleTreeObjects = new PMUI.ui.TextLabel({
            id: "titleTreeObjects",
            textMode: 'plain',
            text: 'Available Objects'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ]
            }
        });

        titleGridObjects = new PMUI.ui.TextLabel({
            id: "titleGridObjects",
            textMode: 'plain',
            text: 'Assigned objects'.translate(),
            style: {
                cssClasses: [
                    'mafe-designer-assigment-title'
                ],
                cssProperties: {
                    'left': 40
                }
            }
        });

        panelLabelObjects = new PMUI.core.Panel({
            width: DEFAULT_WINDOW_WIDTH * 0.94,
            fieldset: true,
            items: [
                titleTreeObjects,
                titleGridObjects
            ],
            style: {
                cssProperties: {
                    'margin-bottom': 2,
                    'margin-left': 50
                }
            },
            layout: "hbox"
        });

        panelObjects = new PMUI.core.Panel({
            width: DEFAULT_WINDOW_WIDTH * 0.94,
            height: 30,
            fieldset: true,
            items: [
                panelLabelObjects
            ],
            layout: "vbox"
        });

        //Objects
        orderDataTree = function (data) {
            var items = [], i,
                type = ['DYNAFORM', 'INPUT-DOCUMENT'],
                label = ['Dynaform', 'Input Document'];
            for (i = 0; i < type.length; i += 1) {
                items = [];
                for (var j = 0; j < data.length; j += 1) {
                    if (type[i] === data[j].obj_type) {
                        if (data[j].obj_type == "DYNAFORM") {
                            items.push({
                                step_type_obj: label[i].translate(),
                                obj_label: label[i].translate(),
                                obj_title: data[j]['dyn_title'],
                                obj_type: data[j]['obj_type'],
                                obj_uid: data[j]['obj_uid'],
                                dyn_uid: data[j]['dyn_uid']
                            });
                        } else {
                            if (data[j].obj_type == "INPUT-DOCUMENT") {
                                items.push({
                                    step_type_obj: label[i].translate(),
                                    obj_label: label[i].translate(),
                                    obj_title: data[j]['inp_doc_title'],
                                    obj_type: data[j]['obj_type'],
                                    obj_uid: data[j]['obj_uid'],
                                    obj_uid: data[j]['obj_uid'],
                                    inp_uid: data[j]['inp_doc_uid']
                                });
                            }
                        }
                    }
                }
                if (items.length === 0) {
                    dataTree.push({
                        obj_title: label[i].translate(),
                        items: [{obj_title: 'N/A'.translate(), obj_uid: ''}]
                    });
                } else {
                    dataTree.push({
                        obj_title: label[i].translate(),
                        items: items
                    });
                }
            }
        };

        loadGridCaseTacker = function (data) {
            var dataOrder = new Array(), i, j;
            for (i = 0; i < data.length; i += 1) {
                for (j = 0; j < data.length; j += 1) {
                    positionIndex = (data[j]['obj_type'] == 'DYNAFORM') ? data[j].pud_position : data[j].pui_position;
                    if (positionIndex == (i + 1)) {
                        dataOrder.push(data[j]);
                        switch (dataOrder[i]['obj_type']) {
                            case 'DYNAFORM':
                                label = dataOrder[i]['dyn_title'].translate();
                                break;
                            case 'INPUT-DOCUMENT':
                                label = dataOrder[i]['input_doc_title'].translate();
                                break;
                            default:
                                break;
                        }
                        dataOrder[i]['obj_title'] = label;
                        break;
                    }
                }
            }
            gridPanelObjects.setDataItems(dataOrder);
        };

        getValuesAssignmentSteps = function () {
            restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    "calls": [
                        {
                            "url": "process-supervisor/available-assignmentsteps",
                            "method": 'GET'
                        },
                        {
                            "url": "process-supervisor/assignmentsteps",
                            "method": 'GET'
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                    dataTree = [];
                    orderDataTree(response[0].response);
                    treePanelObjects.setDataItems(dataTree);
                    loadGridCaseTacker(response[1].response);
                },
                functionFailure: function (xhr, response) {
                    PMDesigner.msgWinError(response.error.message);
                }
            });
            restClient.executeRestClient();
        };

        treePanelObjects = new PMUI.panel.TreePanel({
            id: 'treePanelObjects',
            proportion: 0.5,
            filterable: true,
            filterPlaceholder: 'Text to search'.translate(),
            emptyMessage: 'No records found'.translate(),
            style: {cssClasses: ['itemsSteps']},
            nodeDefaultSettings: {
                behavior: "drag",
                labelDataBind: 'obj_title',
                itemsDataBind: 'items',
                collapsed: false,
                childrenDefaultSettings: {
                    labelDataBind: 'obj_title',
                    autoBind: true
                },
                autoBind: true
            }
        });

        //Save Item (Drop)
        saveItemDyanformInputDocuments = function (rowStep) {
            rowStep = rowStep.getData();
            if (rowStep.obj_type === "DYNAFORM") {
                data = {
                    "dyn_uid": rowStep.obj_uid,
                    "pud_position": rowStep.obj_position
                };
            } else {
                data = {
                    "inp_doc_uid": rowStep.obj_uid,
                    "pui_position": rowStep.obj_position
                };
            }

            restClient = new PMRestClient({
                endpoint: 'process-supervisor/' + rowStep.obj_type.toLowerCase(),
                typeRequest: 'post',
                data: data,
                functionSuccess: function (xhr, response) {
                },
                functionFailure: function (xhr, response) {
                }
            });
            restClient.executeRestClient();
            return data;
        };

        //Update SORT tree
        updateItem = function (rowStep, i) {
            var objType,
                baseEndPointType,
                baseEndPointID;
            rowStep = rowStep.getData();
            rowStep.obj_position = i + 1;
            objType = rowStep.obj_type.toLowerCase(),
            baseEndPointType = (objType === "dynaform") ? 'dynaforms' : 'input-documents';
            baseEndPointID = (objType === "dynaform") ? rowStep.pud_uid : rowStep.pui_uid;
            if (objType === "dynaform") {
                rowStep.pud_position = rowStep.obj_position;
            } else {
                rowStep.pui_position = rowStep.obj_position;
            }

            restClient = new PMRestClient({
                typeRequest: 'post',
                multipart: true,
                data: {
                    "calls": [
                        {
                            "url": 'process-supervisor/' + objType + "/" + baseEndPointID,
                            "method": 'PUT',
                            "data": rowStep
                        }
                    ]
                },
                functionSuccess: function (xhr, response) {
                },
                functionFailure: function (xhr, response) {
                }
            });
            restClient.executeRestClient();
        };
        gridPanelObjects = new PMUI.grid.GridPanel({
            id: 'gridPanelObjects',
            proportion: 1.5,
            visibleFooter: false,
            filterable: false,
            style: {
                cssClasses: ['itemsSteps']
            },
            filterPlaceholder: 'Search ...'.translate(),
            emptyMessage: 'No records found'.translate(),
            nextLabel: 'Next'.translate(),
            previousLabel: 'Previous'.translate(),
            customStatusBar: function (currentPage, pageSize, numberItems, criteria, filter) {
                return messagePageGrid(currentPage, pageSize, numberItems, criteria, filter);
            },
            behavior: 'dragdropsort',
            columns: [
                {
                    title: 'Title'.translate(),
                    dataType: 'string',
                    width: 330,
                    alignment: "left",
                    columnData: "obj_title",
                    sortable: false,
                    alignmentCell: 'left'
                },
                {
                    title: 'Type'.translate(),
                    dataType: 'string',
                    width: 120,
                    alignment: "left",
                    columnData: "obj_type",
                    sortable: false,
                    alignmentCell: 'left'
                },
                {
                    id: 'gridPanelObjectsButtonDelete',
                    title: '',
                    dataType: 'button',
                    buttonLabel: '',
                    buttonStyle: {cssClasses: ['mafe-button-delete-assign']},
                    buttonTooltip: 'Remove Object'.translate(),
                    onButtonClick: function (row, grid) {
                        var rowStep, treePanelItems;
                        flagEdit = 1;
                        index = arrayDynaformInputDocumentID.indexOf(row.getData().obj_uid);
                        rowStep = row.getData();
                        treePanelItems = treePanelObjects.getItems();

                        if (index > -1) {
                            arrayObjectRemovedSteps.push(row.getData().obj_uid);
                            arrayDynaformInputDocumentID.splice(index, 1);
                        }
                        function removeRowClass(treeNode) {
                            var childNodeEl = $(treeNode.html).find('.pmui-gridpanelrow');
                            childNodeEl.removeClass('pmui-gridpanelrow');
                        }

                        function removeEmptyNode(indexNode) {
                            var parentNode = treePanelItems[indexNode];
                            if (parentNode.getItems().length == 1 &&
                                parentNode.getItems()[0].getData()['obj_uid'] == "") {
                                parentNode.removeItem(0);
                            }
                            parentNode.addItem(row);
                            removeRowClass(parentNode);
                        }

                        if (rowStep.obj_type === "DYNAFORM") {
                            removeEmptyNode(0);
                        } else {
                            removeEmptyNode(1);
                        }
                        grid.removeItem(row);
                    }
                }
            ],
            onDrop: function (grid, item, index) {
                var parentItems;
                if (item.getData()['obj_uid'] == "") {
                    return false;

                }
                parentItems = item.parent.getItems();
                if (parentItems.length == 1 && item.getData()['obj_uid'] != "") {
                    item.parent.addDataItem(
                        {obj_title: 'N/A'.translate(), obj_uid: ''}
                    );
                    item.parent.behaviorObject.draggedObject = item;
                }
                flagEdit = 1;
                rowStep = item.getData();
                rowStep.obj_position = index + 1;
                item.setData(rowStep);
                index = arrayObjectRemovedSteps.indexOf(item.getData().obj_uid);

                if (index > -1) {
                    arrayDynaformInputDocumentID.push(item.getData().obj_uid);
                    arrayObjectRemovedSteps.splice(index, 1);
                }
            },
            onSort: function (grid, item, index) {
                flagEdit = 1;
                rowStep = item.getData();
                rowStep.obj_position = index + 1;
            }
        });

        //principal Container Steps
        panelContainerObjects = new PMUI.core.Panel({
            id: "panelContainerObjects",
            width: DEFAULT_WINDOW_WIDTH,
            height: 250,
            fieldset: true,
            items: [treePanelObjects, gridPanelObjects],
            layout: "hbox",
            style: {
                cssProperties: {
                    'margin-top': '-40px'
                }
            }
        });

        assigmentWindow.open();
        panelTitleUser.addItem(titleUser);
        panelTitleUserList.addItem(titleUserList);
        assigmentWindow.body.style.overflowX = "hidden";

        panelGridUser.addItem(gridUsers);
        panelGridUserList.addItem(gridUserList);

        assigmentPanelGlobal.addItem(assigmentPanelUser);
        assigmentPanelGlobal.addItem(assigmentPanelUserList);
        assigmentWindow.addItem(assigmentPanelGlobal);

        assigmentWindow.addItem(panelObjects);
        assigmentWindow.addItem(panelContainerObjects);
        getValuesAssignmentSteps();

        gridPanelObjects.style.addProperties({overflow: 'auto'});
        gridPanelObjects.style.addProperties({float: 'right'});
        gridPanelObjects.setWidth(630);
        gridPanelObjects.setHeight(250);
        $('#gridPanelObjects').css("margin-right", "32px");
        $('#treePanelObjects').css("margin-left", "10px");

        assigmentPanelUser.addItem(panelTitleUser);
        assigmentPanelUser.addItem(panelSearchUser);
        assigmentPanelUser.addItem(radioUsers);
        assigmentPanelUser.addItem(panelGridUser);

        assigmentPanelUserList.addItem(panelTitleUserList);
        assigmentPanelUserList.addItem(panelSearchUserList);
        assigmentPanelUserList.addItem(radioUsersList);
        assigmentPanelUserList.addItem(panelGridUserList);
        gridUsers.dom.tableContainer.style.height = "245px";
        gridUserList.dom.tableContainer.style.height = "245px";
        gridUsers.goToPage(0);
        gridUserList.goToPage(0);
        assigmentWindow.defineEvents();
        applyStyles();
        treePanelObjects.style.addProperties({overflow: 'auto'});

        applyStylesForToolbar();
        usersgrid = gridUsers;
        for (i = 0; i < usersgrid.getItems().length; i += 1) {
            arrayObjectUsers2[i] = usersgrid.getItems()[i];
        }
        userslist = gridUserList;
        for (i = 0; i < userslist.getItems().length; i += 1) {
            arrayObjectUserList2[i] = userslist.getItems()[i];
        }
        gridpanelobj = gridPanelObjects;
        for (i = 0; i < gridpanelobj.getItems().length; i += 1) {
            arrayDynaformInputDocumentID[i] = gridpanelobj.getItems()[i].getData().obj_uid;
            arrayDynaformInputDocumentObject[i] = gridpanelobj.getItems()[i].getData();
        }
    };
}());
(
    function () {
        PMDesigner.propertiesProcess = function () {
            var responseProperties = null,
                getValuesProperties,
                isDirtyFormProcess,
                saveProperties,
                propertiesWindow,
                processUID,
                textTitle,
                textDescription,
                processOwner,
                dropCalendar,
                dropProcessCat,
                dropDynaform,
                dropRouting,
                checkDebug,
                checkHideCase,
                checkSubProcess,
                dropCaseCreated,
                dropCaseDeleted,
                dropCaseCancelled,
                dropCasePaused,
                dropCaseUnpaused,
                dropCaseReassigned,
                dropCaseOpen,
                dropTypeProcess,
                proCost,
                loadProperties,
                proUnitCost,
                formEditProcess,
                loadDynaforms,
                loadCalendar,
                loadTemplate,
                loadTriggers,
                loadTypeProcess,
                loadCategory,
                notification,
                notificationText = "Fields marked with an asterisk (%%ASTERISK%%) are required.".translate()
                    .replace(/%%ASTERISK%%/g, '<span style="color: #e84c3d">*</span>'),
                clickedClose;

            getValuesProperties = function () {
                var restClient = new PMRestClient({
                    typeRequest: 'post',
                    multipart: true,
                    data: {
                        "calls": [
                            {
                                "url": "project/" + PMDesigner.project.id + "/dynaforms",
                                "method": 'GET'
                            },
                            {
                                "url": "calendars",
                                "method": 'GET'
                            },
                            {
                                "url": "project/categories",
                                "method": 'GET'
                            },
                            {
                                "url": "project/" + PMDesigner.project.id + "/file-manager?path=templates",
                                "method": 'GET'
                            },
                            {
                                "url": "project/" + PMDesigner.project.id + "/triggers",
                                "method": 'GET'
                            },
                            {
                                "url": "project/" + PMDesigner.project.id + "/process",
                                "method": 'GET'
                            }
                        ]
                    },
                    functionSuccess: function (xhr, response) {
                        loadDynaforms(response[0].response);
                        loadCalendar(response[1].response);
                        loadCategory(response[2].response);
                        loadTemplate(response[3].response);
                        loadTriggers(response[4].response);
                        loadTypeProcess(response[5].response);
                        loadProperties(response[5].response);
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);
                    }
                });
                restClient.setBaseEndPoint('');
                restClient.executeRestClient();
            };
            isDirtyFormProcess = function () {
                var message_window
                if (formEditProcess.isDirty()) {
                    message_window = new PMUI.ui.MessageWindow({
                        id: "cancelMessageTriggers",
                        windowMessageType: 'warning',
                        width: 490,
                        title: "Edit process".translate(),
                        message: 'Are you sure you want to discard your changes?'.translate(),
                        footerItems: [
                            {
                                text: "No".translate(),
                                handler: function () {
                                    message_window.close();
                                },
                                buttonType: "error"
                            },
                            {
                                text: "Yes".translate(),
                                handler: function () {
                                    message_window.close();
                                    propertiesWindow.close();
                                },
                                buttonType: "success"
                            }
                        ]
                    });
                    message_window.open();
                    message_window.showFooter();
                } else {
                    propertiesWindow.close();
                }
            };
            saveProperties = function (data) {
                var restClient = new PMRestClient({
                    typeRequest: 'update',
                    data: data,
                    messageSuccess: "Properties saved successfully".translate(),
                    functionSuccess: function (xhr, response) {
                        propertiesWindow.close();

                        PMDesigner.project.setProjectName(data.pro_title);
                        PMDesigner.project.setDescription(data.pro_description);
                    },
                    functionFailure: function (xhr, response) {
                        PMDesigner.msgWinError(response.error.message);

                        PMDesigner.project.dirty = false;
                    }
                });
                restClient.setEndpoint("process");
                restClient.executeRestClient();
            };

            propertiesWindow = new PMUI.ui.Window({
                id: "propertiesProcessWindow",
                title: "Edit process".translate(),
                width: DEFAULT_WINDOW_WIDTH,
                height: DEFAULT_WINDOW_HEIGHT,
                footerHeight: 'auto',
                bodyHeight: "auto",
                modal: true,
                buttonPanelPosition: "bottom",
                footerAlign: "right",
                onBeforeClose: function () {
                    clickClose = true;
                    isDirtyFormProcess();
                },
                buttons: [
                    {
                        id: 'outputWindowDocButtonCancel',
                        text: "Cancel".translate(),
                        buttonType: "error",
                        handler: function () {
                            clickedClose = false;
                            isDirtyFormProcess();
                        }
                    },
                    {
                        id: 'outputWindowDocButtonSave',
                        text: "Save".translate(),
                        buttonType: "success",
                        handler: function () {
                            var dataForm;
                            if (formEditProcess.isValid() && processOwner.isValid()) {
                                if ((navigator.userAgent.indexOf("MSIE") != -1) || (navigator.userAgent.indexOf("Trident") != -1)) {
                                    dataForm = getData2PMUI(formEditProcess.html);
                                } else {
                                    dataForm = formEditProcess.getData();
                                    dataForm.pro_process_owner = processOwner.get("value");
                                }
                                dataForm.pro_debug = checkDebug.controls[0].selected ? 1 : 0;
                                dataForm.pro_show_message = checkHideCase.controls[0].selected ? 1 : 0;
                                dataForm.pro_subprocess = checkSubProcess.controls[0].selected ? 1 : 0;
                                functionAssignmentUsers = function (xhr, response) {
                                };
                                saveProperties(dataForm);
                            } else {
                                if (!(processOwner.isValid()) && formEditProcess.isValid()) {
                                    formEditProcess.addItem(notification);
                                } else {
                                    formEditProcess.removeItem(notification);
                                }
                            }
                        }
                    }
                ]
            });

            processUID = new PMUI.field.TextField({
                label: "UID".translate(),
                id: "process_uid",
                name: "pro_uid",
                labelWidth: "35%",
                controlsWidth: "300px"
            });

            textTitle = new PMUI.field.TextField({
                label: "Title".translate(),
                id: 'textTitle',
                name: 'pro_title',
                labelWidth: "35%",
                placeholder: 'a text here'.translate(),
                controlsWidth: "300px",
                required: true
            });

            textDescription = new PMUI.field.TextAreaField({
                id: 'textDescription',
                name: 'pro_description',
                label: "Description".translate(),
                labelWidth: "35%",
                controlsWidth: "500px",
                rows: 150,
                style: {cssClasses: ['mafe-textarea-resize']}
            });

            processOwner = new SuggestField({
                id: 'processOwner',
                name: 'pro_owner',
                label: "Process Owner".translate(),
                required: true,
                width: 500,
                placeholder: "suggest users".translate(),
                separatingText: ["Users".translate()],
                dynamicLoad: {
                    data: [
                        {
                            key: "usr_uid",
                            label: ["usr_firstname", "usr_lastname", "(", "usr_username", ")"]
                        }
                    ],
                    keys: {
                        url: HTTP_SERVER_HOSTNAME + "/api/1.0/" + WORKSPACE,
                        accessToken: PMDesigner.project.tokens.access_token,
                        endpoints: [
                            {
                                method: "GET",
                                url: 'users'
                            }
                        ]
                    }
                }
            });

            dropCalendar = new PMUI.field.DropDownListField({
                id: "dropCalendar",
                name: "pro_calendar",
                labelWidth: "35%",
                label: "Calendar".translate(),
                controlsWidth: "300px",
                valueType: 'string',
                onChange: function (newValue, prevValue) {
                }
            });

            dropProcessCat = new PMUI.field.DropDownListField({
                id: "dropProcessCat",
                name: "pro_category",
                controlsWidth: "300px",
                labelWidth: "35%",
                label: "Process Category".translate(),
                valueType: 'string',
                onChange: function (newValue, prevValue) {
                }
            });

            dropDynaform = new PMUI.field.DropDownListField({
                id: "dropDynaform",
                name: "pro_summary_dynaform",
                controlsWidth: "300px",
                labelWidth: "35%",
                label: "Dynaform to show a case summary".translate(),
                valueType: 'string',
                onChange: function (newValue, prevValue) {
                }
            });

            dropRouting = new PMUI.field.DropDownListField({
                id: "dropRouting",
                name: "pro_derivation_screen_tpl",
                controlsWidth: "300px",
                labelWidth: "35%",
                label: "Routing Screen Template".translate(),
                valueType: 'string',
                onChange: function (newValue, prevValue) {
                }
            });

            checkDebug = new PMUI.field.CheckBoxGroupField({
                id: 'checkDebug',
                labelWidth: "35%",
                label: "Debug".translate(),
                name: "pro_debug",
                value: '1',
                controlPositioning: 'vertical',
                options: [
                    {
                        id: 'pro_debug',
                        disabled: false,
                        value: '1',
                        selected: false
                    }
                ],
                onChange: function (newVal, oldVal) {
                }
            });

            checkHideCase = new PMUI.field.CheckBoxGroupField({
                id: 'checkHideCase',
                labelWidth: "35%",
                label: "Hide the case number and the case title in the steps".translate(),
                value: '1',
                name: "pro_show_message",
                controlPositioning: 'vertical',
                options: [
                    {
                        disabled: false,
                        value: '1',
                        selected: false
                    }
                ],
                onChange: function (newVal, oldVal) {
                }
            });

            checkSubProcess = new PMUI.field.CheckBoxGroupField({
                id: 'checkSubProcess',
                labelWidth: "35%",
                label: "This a sub-process".translate(),
                value: '1',
                name: "pro_subprocess",
                controlPositioning: 'vertical',
                options: [
                    {
                        disabled: false,
                        value: '1',
                        selected: false
                    }
                ],
                onChange: function (newVal, oldVal) {
                }
            });
            dropCaseCreated = new PMUI.field.DropDownListField({
                id: "dropCaseCreated",
                name: "pro_tri_create",
                labelWidth: "35%",
                label: "Execute a trigger when a case is created".translate(),
                valueType: 'string',
                controlsWidth: "300px",
                onChange: function (newValue, prevValue) {
                }
            });

            dropCaseDeleted = new PMUI.field.DropDownListField({
                id: "dropCaseDeleted",
                name: "pro_tri_deleted",
                labelWidth: "35%",
                label: "Execute a trigger when a case is deleted".translate(),
                valueType: 'string',
                controlsWidth: "300px",
                onChange: function (newValue, prevValue) {
                }
            });

            dropCaseCancelled = new PMUI.field.DropDownListField({
                id: "dropCaseCancelled",
                name: "pro_tri_canceled",
                labelWidth: "35%",
                label: "Execute a trigger when a case is cancelled".translate(),
                valueType: 'string',
                controlsWidth: "300px",
                onChange: function (newValue, prevValue) {
                }
            });

            dropCasePaused = new PMUI.field.DropDownListField({
                id: "dropCasePaused",
                name: "pro_tri_paused",
                labelWidth: "35%",
                label: "Execute a trigger when a case is paused".translate(),
                valueType: 'string',
                controlsWidth: "300px",
                onChange: function (newValue, prevValue) {
                }
            });

            dropCaseUnpaused = new PMUI.field.DropDownListField({
                id: "dropCaseUnpaused",
                name: "pro_tri_unpaused",
                labelWidth: "35%",
                label: "Execute a trigger when a case is unpaused".translate(),
                valueType: "string",
                controlsWidth: "300px"
            });

            dropCaseReassigned = new PMUI.field.DropDownListField({
                id: "dropCaseReassigned",
                name: "pro_tri_reassigned",
                labelWidth: "35%",
                label: "Execute a trigger when a case is reassigned".translate(),
                valueType: 'string',
                controlsWidth: "300px",
                onChange: function (newValue, prevValue) {
                }
            });

            dropCaseOpen = new PMUI.field.DropDownListField({
                id: "dropCaseOpen",
                name: "pro_tri_open",
                label: "Execute a trigger when a case is opened".translate(),
                labelWidth: "35%",
                valueType: "string",
                controlsWidth: "300px",

                onChange: function (newValue, prevValue) {
                }
            });

            dropTypeProcess = new PMUI.field.DropDownListField({
                id: "dropTypeProcess",
                name: "pro_type_process",
                labelWidth: "35%",
                label: "Process Design Access: Public / Private (Owner)".translate(),
                valueType: 'string',
                controlsWidth: "300px",
                onChange: function (newValue, prevValue) {
                }
            });

            proCost = new PMUI.field.TextField({
                id: 'proCost',
                name: 'pro_cost',
                labelWidth: "35%",
                value: 0,
                placeholder: 'a cost here'.translate(),
                label: "Cost".translate(),
                valueType: 'integer',
                controlsWidth: "300px",
                required: window.enterprise === "1" ? true : false,
                style: {
                    cssProperties: {
                        float: "left"
                    }
                }
            });

            proUnitCost = new PMUI.field.TextField({
                id: 'proUnitCost',
                name: 'pro_unit_cost',
                labelWidth: "35%",
                value: '$',
                placeholder: 'a unit cost here'.translate(),
                controlsWidth: "300px",
                label: "Units".translate(),
                valueType: 'string',
                required: window.enterprise === "1" ? true : false,
                style: {
                    cssProperties: {
                        float: "left"
                    }
                }
            });

            notification = new PMUI.field.TextAnnotationField({
                id: "requiredMessage",
                name: "Message",
                textType: PMUI.field.TextAnnotationField.TEXT_TYPES.HTML,
                text: notificationText,
                text_Align: "center"
            });

            formEditProcess = new PMUI.form.Form({
                id: 'formEditProcess',
                fieldset: true,
                title: "Process Information".translate(),
                width: DEFAULT_WINDOW_WIDTH - DEFAULT_WINDOW_WIDTH * 0.10,
                items: [
                    processUID,
                    textTitle,
                    textDescription,
                    dropCalendar,
                    dropProcessCat,
                    dropDynaform,
                    dropRouting,
                    checkDebug,
                    checkHideCase,
                    checkSubProcess,
                    dropCaseCreated,
                    dropCaseDeleted,
                    dropCaseCancelled,
                    dropCasePaused,
                    dropCaseUnpaused,
                    dropCaseReassigned,
                    dropCaseOpen,
                    dropTypeProcess,
                    proCost,
                    proUnitCost
                ]
            });

            //Load Dynaforms
            loadDynaforms = function (response) {
                var i;
                dropDynaform.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                for (i = 0; i < response.length; i += 1) {
                    dropDynaform.addOption({
                        label: response[i].dyn_title,
                        value: response[i].dyn_uid,
                        select: false
                    });
                }
            };

            //Load calendar
            loadCalendar = function (response) {
                var i;
                dropCalendar.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                for (i = 0; i < response.length; i += 1) {
                    dropCalendar.addOption({
                        label: response[i].cal_name,
                        value: response[i].cal_uid,
                        select: false
                    });
                }
            };

            //Load category
            loadCategory = function (response) {
                var i;
                dropProcessCat.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                for (i = 0; i < response.length; i += 1) {
                    dropProcessCat.addOption({
                        label: response[i].cat_name,
                        value: response[i].cat_uid,
                        select: false
                    });
                }
            };

            //Load Templates
            loadTemplate = function (response) {
                var i;
                dropRouting.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                for (i = 0; i < response.length; i += 1) {
                    if (response[i].prf_filename != "alert_message.html") {
                        dropRouting.addOption({
                            label: response[i].prf_filename,
                            value: response[i].prf_filename,
                            select: false
                        });
                    }
                }
            };

            //Load triggers
            loadTriggers = function (response) {
                var i;
                dropCaseCreated.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                dropCaseDeleted.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                dropCaseCancelled.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                dropCasePaused.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                dropCaseUnpaused.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });
                dropCaseReassigned.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });

                dropCaseOpen.addOption({
                    label: "None".translate(),
                    value: "",
                    select: false
                });

                for (i = 0; i < response.length; i += 1) {
                    dropCaseCreated.addOption({
                        label: