/**
 * Function viewNewCase
 * Description: load the form with parameters
 * (server,workspace,accesToken,refreshToken, procId, taskID, formsArrayJSON, formId, jsonForm)
 */
var app = {},
    viewNewCase,
    viewCase;

window.dynaform = app;
app.openCase = function (server, workspace, accessToken, refreshToken, processId, taskId, caseId, formsArray, delIndex, lang, isRTL, offLineMode, statusConnection, userData) {
    var environment,
        activeCase,
        userInfo;
    this.setIsRTL(isRTL);
    if (navigator.userAgent === "formslider-android")
        environment = "android";
    if (navigator.userAgent === "formslider-ios")
        environment = "ios";
    if (userData) {
        userInfo = JSON.parse(userData);
        userInfo['language'] = lang;
    }
    activeCase = new xCase.core.CaseManager({
        steps: formsArray,
        environment: environment,
        tokens: {
            accessToken: accessToken,
            refreshToken: refreshToken
        },
        config: {
            server: server,
            workspace: workspace,
            taskUID: taskId,
            processUID: processId,
            delIndex: delIndex,
            lang: lang,
            caseUID: caseId
        },
        isRTL: this.getIsRTL(),
        offLineMode: offLineMode,
        statusConnection: statusConnection,
        userInfo: userInfo
    });
    app.activeCase = activeCase;
    activeCase.startCase();
};

app.openStep = function (server, workspace, accessToken, refreshToken, processId, taskId, caseId, formsArray, delIndex, lang, stepInfo, isRTL, offLineMode, statusConnection, userData) {
    var environment,
        respDevice,
        dataServer,
        step,
        activeCase,
        serverDate,
        localDate,
        userInfo;

    this.setIsRTL(isRTL);
    if (navigator.userAgent === "formslider-android")
        environment = "android";
    if (navigator.userAgent === "formslider-ios")
        environment = "ios";
    if (userData) {
        userInfo = JSON.parse(userData);
        userInfo['language'] = lang;
    }
    activeCase = new xCase.core.CaseManager({
        steps: formsArray,
        environment: environment,
        tokens: {
            accessToken: accessToken,
            refreshToken: refreshToken
        },
        config: {
            server: server,
            workspace: workspace,
            taskUID: taskId,
            processUID: processId,
            delIndex: delIndex,
            lang: lang,
            caseUID: caseId
        },
        isRTL: this.getIsRTL(),
        offLineMode: offLineMode,
        statusConnection: statusConnection,
        userInfo: userInfo
    });
    app.activeCase = activeCase;
    respDevice = activeCase.getRequestManager().getStep(stepInfo);
    activeCase.setStepHistory(respDevice["stepHistory"]);
    step = activeCase.stepCollection.findByStepUID(respDevice["stepId"]);

    if (step.existTriggerBefore()) {
        after = activeCase.triggerBefore(respDevice["stepId"]);
    }

    if (activeCase.isOnlineDevice()) {
        dataServer = activeCase.getData({
            dyn_uid: respDevice.formId || null
        });
        serverDate = moment(dataServer.SYS_VAR_UPDATE_DATE, "YYYY-MM-DD HH:mm:ss");
    }

    localDate = moment(respDevice.updateDate, "YYYY-MM-DD HH:mm:ss");

    if (serverDate && (!serverDate.isValid() || !localDate.isValid())) {
        //default case: open the step with data from device
        activeCase.openStep(respDevice);
    } else if (serverDate && (serverDate.isAfter(localDate))) {
        app.getWhichDataToUse = function (val) {
            if (val === '1') {
                respDevice.data = dataServer;
            } else {
                respDevice.data.SYS_VAR_UPDATE_DATE = respDevice.updateDate;
            }
            activeCase.openStep(respDevice);
        };
        this.activeCase.getRequestManager().askWhichDataToUse();
    } else {
        respDevice.data.SYS_VAR_UPDATE_DATE = respDevice.updateDate;
        activeCase.openStep(respDevice);
    }
};

app.getWhichDataToUse = function () {
};

var kitKatMode = null;
var setKitKatMode = function (value) {
    kitKatMode = value;
};

app.setKitKatMode = setKitKatMode;

app.setFiles = function (input) {
    var parseInput, field, index, name, readStr, resp,
        appDocUid;

    if (_.isString(input) && input !== "") {
        try {
            parseInput = JSON.parse(input);
            field = getFieldById(parseInput.idField);

            if (parseInput.files.length === 1 && parseInput.files[0].docVersion > 1) {
                //Versioning
                if (field) {
                    // no grid
                    field.getFileView(parseInput.files[0].appDocUid)._startUpload(parseInput.files[0]);
                } else {
                    // grid
                    this.activeCase.getRequestManager().executeCallbackAction({
                        id: parseInput.idField,
                        data: parseInput
                    });
                }
            } else {
                //Not Versioning
                for (index = 0; index < parseInput.files.length; index += 1) {
                    if (parseInput.files[index].filePath) {
                        readStr = this.activeCase.getRequestManager().readerFile(parseInput.files[index].filePath, "text");
                        if (readStr) {
                            parseInput.files[index].filePath = readStr;
                        } else {
                            break;
                        }
                    }
                }
                if (field) {
                    if (_.isFunction(field.setFiles)) {
                        field.setFiles(parseInput.files);
                    }
                } else {
                    resp = this.activeCase.getRequestManager().executeCallbackAction({
                        id: parseInput.idField,
                        data: parseInput
                    });
                }
            }
        } catch (e) {
            console.error(e);
        }
    }
};

/**
 * Return data from device, works fine in REACT NATIVE for Android & IOS
 * @param data {id:"x", path:"dataPath"}
 */
app.channelEvents = function (data) {
    if (_.isString(data) && data !== "") {
        try {
            var parse = JSON.parse(data);
            if (parse.path) {
                parse.data = this.activeCase.getRequestManager().readerFile(parse.path, "json");
            }
            resp = this.activeCase.getRequestManager().executeCallbackEvent(parse);
        } catch (e) {
            console.error(e);
        }
    }
};
/**
 * Request data to PmDynaform
 * @param data
 */
app.channelRequest = function (data) {
    if (_.isString(data) && data !== "") {
        try {
            var parse = JSON.parse(data);
            this.activeCase.getRequestManager().requestEvent(parse);
        } catch (e) {
            console.error(e);
        }
    }
};


app.setLocation = function (input) {
    var parseInput,
        field;
    if (_.isString(input) && input !== "") {
        try {
            parseInput = JSON.parse(input);
            field = getFieldById(parseInput.idField);
            if (_.isFunction(field.setLocation)) {
                field.setLocation(parseInput);
            }
        } catch (e) {
            console.error(e);
        }
    }
};

app.setScannerCode = function (input) {
    var parseInput,
        field,
        index,
        readStr;

    if (_.isString(input) && input !== "") {
        try {
            parseInput = JSON.parse(input);
            field = getFieldById(parseInput.idField);
            if (_.isFunction(field.setScannerCode)) {
                readStr = this.activeCase.getRequestManager().readerFile(parseInput.data, "text");
                field.setScannerCode({data: readStr});
            }
        } catch (e) {
            console.error(e);
        }
    }
};

app.changeID = function (input) {
    var parseInput,
        field;
    if (_.isString(input) && input !== "") {
        try {
            parseInput = JSON.parse(input);
            field = getFieldById(parseInput.idField);
            if (_.isFunction(field.setLocation)) {
                field.changeID(parseInput.data);
            }
        } catch (e) {
            console.error(e);
        }
    }
};

/**
 * Interface with device that hide mask loading from a some Field
 * @param input
 */
app.hideFieldLoading = function (input) {
    var parseInput,
        resp,
        field,
        file;

    if (_.isString(input) && input !== "") {
        try {
            parseInput = JSON.parse(input);
            field = getFieldById(parseInput.idField);

            if (parseInput.docVersion > 1) {
                if (field) {
                    // it's a field
                    field.getFileView(parseInput.idFile)._finishUpload();
                } else {
                    // it's inside a grid
                    this.activeCase.getRequestManager().executeCallbackAction({
                        id: parseInput.idFile,
                        data: parseInput
                    });
                }

            } else {
                resp = this.activeCase.getRequestManager().executeCallbackAction({
                    id: parseInput.idFile,
                    data: parseInput
                });

                if (resp === false && field) {
                    if (_.isFunction(field.hideLoading)) {
                        field.hideLoading();
                    }
                }
            }
        } catch (e) {
            console.error(e);
        }
    }
};

app.hideMaskLoading = function () {
    this.activeCase.hideMaskLoading();
    return this;
};

app.showMaskLoading = function () {
    this.activeCase.showMaskLoading();
    return this;
};

app.getDataIOS = function () {
    var respData = this.activeCase.getRequestManager().getDataMemory();
    return JSON.stringify(respData);
};

app.validateForms = function () {
    return this.activeCase.getRequestManager().getValidateForm();
};

app.getDataFile = function () {
    var respData = this.activeCase.getRequestManager().getDataMemory();

    respData = JSON.stringify(respData);

    return respData;
};

app.loadForm = function (formID, path) {
    var draft = false,
        json = this.activeCase.getRequestManager().readerFile(path, "json");
    this.activeCase.loadForm(json);
};

app.setCacheLibraryMap = function (path) {
    var json = this.activeCase.getRequestManager().readerFile(path, "json");
    this.activeCase.setCacheLibraryMap(json);
};
/**
 * Gets form data of current step
 * @returns {string}
 */
app.getFormData = function () {
    var data = this.activeCase.getCurrentStepData();
    this.activeCase.getRequestManager().sendFormData(data);

    if (this.activeCase.environment === "ios") {
        return JSON.stringify(data);
    } else {
        return;
    }
};
/**
 * Gets current step's data and sends it to mobile device
 */
app.saveFormDataOffLine = function () {
    var data = this.activeCase.getCurrentStepData(),
        requestManager;
    requestManager = this.activeCase.getRequestManager();
    requestManager.saveCaseDataOffLine(data);
};
/**
 * this method, fixed the property is RTL in true if form is Right to Left
 */
app.setIsRTL = function (value) {
    var isRTL = false;
    if (typeof value === "string") {
        isRTL = JSON.parse(value);
    }
    this.isRTL = isRTL;
    return this;
};
/**
 * The ios engine needs to read the parameters needed
 * to execute the nextStep method.
 */
app.nextStepIOS = function () {
    var respData = this.activeCase.getRequestManager().getDataMemory();
    return JSON.stringify(respData);
};
/**
 * The device notifies the change of the state of the connection through a parameter
 * @param {string} value: "true" if connection exists or "false" if connection is not exists
 */
app.changeStatusConnection = function (value) {
    var activeCase = this.activeCase;
    if (activeCase && typeof value === "string") {
        this.activeCase.changeStatusConnection(value);
    }
};
/**
 * Set the case identifier
 * When the case is started offline, it is necessary to revalidate the "caseIUD"
 * if there is a connection
 * @param {string}, Is a valid caseUID of a created case
 */
app.setCaseId = function (caseId) {
    var caseInfo = this.activeCase.config || {};
    if (this.activeCase && (typeof caseId === "string")) {
        _.extend(caseInfo, {"caseUID": caseId});
        this.activeCase.setCaseInfo(caseInfo);
    }
};
/**
 * To retrieve the control from the device after calling get NextStep method
 * @param {string}, a path: Running with ajax, will get the actual values of the variables in a json
 */
app.continueStep = function (path) {
    var activeCase = this.activeCase,
        step = activeCase.getCurrentStep(),
        respDevice;
    if (typeof path === "string") {
        activeCase.setStep(step);
        respDevice = activeCase.getRequestManager().readerFile(path, "json");
        activeCase.nextStepDeviceResponseHandler(respDevice);
    }
};
/**
 * Sets the data of the case variables, in the current form
 * @param {string}, state: Is the state before losing control of the case
 * @param {string}, pathData: Running with ajax, will get the actual values of the variables in a json
 */
app.setFormData = function (state, pathData) {
    var activeCase = this.activeCase,
        respDevice;
    if (typeof state === "string" && typeof pathData === "string") {
        respDevice = activeCase.getRequestManager().readerFile(pathData, "json");
        state = JSON.parse(state);
        activeCase.getRequestManager().executeCallbackAction({
            id: "prevStepData-" + state.stepId,
            data: respDevice
        });
    }
};
/**
 * exchange value by id
 * on field and case variables
 * @param {string}, Is a fieldId
 * @param {string}, Is a oldValue
 * @param {string}, Is a newId
 */
app.exchangeValuesByID = function (fieldId, oldId, newId) {
    if (this.activeCase && (typeof fieldId === "string") && (typeof oldId === "string") && (typeof newId === "string")) {
        getFieldById(fieldId).exchangeMobileDataId(oldId, newId);
    }
    return this;
};
app.getIsRTL = function () {
    return this.isRTL;
};
/**
 * Function to be called by mobile device to get the parameters to query the versions of a file.
 */
app.getFileVersions = function () {
    return JSON.stringify(this.activeCase.getRequestManager().getDataMemory());
};
/**
 * Callback for mobile to be called when the versions are retrieved.
 * @param fieldID
 * @param appDocUid
 * @param response
 * @param success
 */
app.setFileVersions = function (fieldID, appDocUid, response, success) {
    this.activeCase.getRequestManager().executeCallbackAction({
        id: appDocUid + '-list',
        data: {
            data: JSON.parse(response),
            success: success
        }
    });
};
/**
 * Show a Flash Message Within a Dynaform.
 * @param {object} config
 */
app.flashMessage = function (config) {
    if (typeof config === "object") {
        this.flashModel = new PMDynaform.ui.FlashMessageModel({
            message: config.message || "",
            emphasisMessage: config.emphasisMessage || "",
            startAnimation: config.startAnimation || 1000,
            type: config.type || "info",
            appendTo: config.appendTo || document.body,
            duration: config.duration,
            absoluteTop: config.absoluteTop || false
        });
        this.flashView = new PMDynaform.ui.FlashMessageView({
            model: this.flashModel
        });
        this.flashView.render();
        if (this.flashModel.get("absoluteTop")) {
            this.onScrollUpdate(this.flashView.el);
        }
    }
    return this;
};

var PMURI = {
    encode: function (input) {

    },
    decode: function (input) {
        input = JSON.parse(input, function (key, value) {
            if (typeof value === "string") {
                value = value.replace(/(&d\|t&)/g, "\n");
                value = value.replace(/(&c\|t&)/g, "'");
                value = value.replace(/(&t\|t&)/g, "\t");
            }
            return value;
        });
        return input;
    }
};
