<?php

use ProcessMaker\Model\User;

if (!isset($_SESSION['USER_LOGGED'])) {
    $responseObject = new stdclass();
    $responseObject->error = G::LoadTranslation('ID_LOGIN_AGAIN');
    $responseObject->success = true;
    $responseObject->lostSession = true;
    print(G::json_encode($responseObject));
    die();
}

try {
    $userUid = $_SESSION['USER_LOGGED'];
    // This filter will search in the case title and this can be used '&'
    $filters['search'] = isset($_REQUEST["search"]) ? htmlspecialchars($_REQUEST["search"]) : "";
    // Sanitize the filters
    $filter = new InputFilter();
    $_REQUEST = $filter->xssFilterHard($_REQUEST);
    // Prepare filters
    $filters['paged'] = isset($_REQUEST["paged"]) ? $_REQUEST["paged"] : true;
    $filters['count'] = isset($_REQUEST['count']) ? $_REQUEST["count"] : true;
    $filters['category'] = isset($_REQUEST["category"]) ? $_REQUEST["category"] : "";
    $filters['process'] = isset($_REQUEST["process"]) ? $_REQUEST["process"] : "";
    $filters['filter'] = isset($_REQUEST["filter"]) ? $_REQUEST["filter"] : "";
    $filters['dateFrom'] = (!empty($_REQUEST["dateFrom"])) ? substr($_REQUEST["dateFrom"], 0, 10) : "";
    $filters['dateTo'] = (!empty($_REQUEST["dateTo"])) ? substr($_REQUEST["dateTo"], 0, 10) : "";
    $filters['start'] = isset($_REQUEST["start"]) ? $_REQUEST["start"] : "0";
    $filters['limit'] = isset($_REQUEST["limit"]) ? $_REQUEST["limit"] : "25";
    $filters['sort'] = (isset($_REQUEST['sort'])) ? (($_REQUEST['sort'] == 'APP_STATUS_LABEL') ? 'APP_STATUS' : $_REQUEST["sort"]) : '';
    $filters['dir'] = isset($_REQUEST["dir"]) ? $_REQUEST["dir"] : "DESC";
    $filters['action'] = isset($_REQUEST["action"]) ? $_REQUEST["action"] : "";
    $filters['user'] = isset($_REQUEST["user"]) ? $_REQUEST["user"] : "";
    $listName = isset($_REQUEST["list"]) ? $_REQUEST["list"] : "inbox";
    $filters['filterStatus'] = isset($_REQUEST["filterStatus"]) ? $_REQUEST["filterStatus"] : "";
    $filters['sort'] = G::toUpper($filters['sort']);
    $openApplicationUid = (isset($_REQUEST['openApplicationUid']) && $_REQUEST['openApplicationUid'] != '') ? $_REQUEST['openApplicationUid'] : null;

    global $RBAC;
    $RBAC->allows(basename(__FILE__), $filters['action']);

    //Define user when is reassign
    if ($filters['action'] == 'to_reassign') {
        if ($filters['user'] == '') {
            $userUid = '';
        }
        if ($filters['user'] !== '' && $filters['user'] !== 'CURRENT_USER') {
            $userUid = $filters['user'];
        }
    }

    // Select list
    switch ($listName) {
        case 'inbox':
            $list = new ListInbox();
            break;
        case 'participated_history':
            $list = new ListParticipatedHistory();
            break;
        case 'participated':
        case 'participated_last':
            $list = new ListParticipatedLast();
            break;
        case 'completed':
            $list = new ListCompleted();
            break;
        case 'paused':
            $list = new ListPaused();
            break;
        case 'canceled':
            $list = new ListCanceled();
            break;
        case 'my_inbox':
            $list = new ListMyInbox();
            break;
        case 'unassigned':
            $list = new ListUnassigned();
            break;
    }

    // Validate filters
    $filters['search'] = (!is_null($openApplicationUid)) ? $openApplicationUid : $filters['search'];
    //Set a flag for review in the list by APP_UID when is used the case Link with parallel task
    $filters['caseLink'] = (!is_null($openApplicationUid)) ? $openApplicationUid : '';

    $filters['start'] = (int) $filters['start'];
    $filters['start'] = abs($filters['start']);
    if ($filters['start'] != 0) {
        $filters['start'] + 1;
    }

    $filters['limit'] = (int) $filters['limit'];
    $filters['limit'] = abs($filters['limit']);
    $conf = new Configurations();
    $formats = $conf->getFormats();
    $list->setUserDisplayFormat($formats['format']);

    if ($filters['limit'] == 0) {
        $generalConfCasesList = $conf->getConfiguration('ENVIRONMENT_SETTINGS', '');
        if (isset($generalConfCasesList['casesListRowNumber'])) {
            $filters['limit'] = (int) $generalConfCasesList['casesListRowNumber'];
        } else {
            $filters['limit'] = 25;
        }
    } else {
        $filters['limit'] = (int) $filters['limit'];
    }

    switch ($filters['sort']) {
        case 'APP_CURRENT_USER':
            //This value is format according to the userDisplayFormat, for this reason we will sent the UID
            $filters['sort'] = 'USR_UID';
            break;
        case 'DEL_TASK_DUE_DATE':
            $filters['sort'] = 'DEL_DUE_DATE';
            break;
        case 'APP_UPDATE_DATE':
            $filters['sort'] = 'DEL_DELEGATE_DATE';
            break;
        case 'APP_DEL_PREVIOUS_USER':
            //This value is format according to the userDisplayFormat, for this reason we will sent the UID
            $filters['sort'] = 'DEL_PREVIOUS_USR_UID';
            break;
        case 'DEL_CURRENT_TAS_TITLE':
            $filters['sort'] = 'APP_TAS_TITLE';
            break;
        case 'APP_STATUS_LABEL':
            $filters['sort'] = 'APP_STATUS';
            break;
    }

    $filters['dir'] = G::toUpper($filters['dir']);
    if (!($filters['dir'] == 'DESC' || $filters['dir'] == 'ASC')) {
        $filters['dir'] = 'DESC';
    }

    $result = $list->loadList($userUid, $filters, function (array $record) {
        try {
            if (isset($record["DEL_PREVIOUS_USR_UID"])) {
                if ($record["DEL_PREVIOUS_USR_UID"] == "") {
                    $appDelegation = AppDelegationPeer::retrieveByPK($record["APP_UID"], $record["DEL_INDEX"]);

                    if (!is_null($appDelegation)) {
                        $appDelegationPrevious = AppDelegationPeer::retrieveByPK($record["APP_UID"], $appDelegation->getDelPrevious());

                        if (!is_null($appDelegationPrevious)) {
                            $taskPrevious = TaskPeer::retrieveByPK($appDelegationPrevious->getTasUid());

                            if (!is_null($taskPrevious)) {
                                switch ($taskPrevious->getTasType()) {
                                    case "SCRIPT-TASK":
                                        $record["DEL_PREVIOUS_USR_UID"] = $taskPrevious->getTasType();
                                        break;
                                }
                            }
                        }
                    }
                }

                $record["PREVIOUS_USR_UID"] = $record["DEL_PREVIOUS_USR_UID"];
                $record["PREVIOUS_USR_USERNAME"] = $record["DEL_PREVIOUS_USR_USERNAME"];
                $record["PREVIOUS_USR_FIRSTNAME"] = $record["DEL_PREVIOUS_USR_FIRSTNAME"];
                $record["PREVIOUS_USR_LASTNAME"] = $record["DEL_PREVIOUS_USR_LASTNAME"];
            } elseif (!empty($record["USR_ID"])) {
                $user = User::where("USR_ID", $record["USR_ID"])->first();
                $record["PREVIOUS_USR_UID"] = $record["DEL_PREVIOUS_USR_UID"] = $user->USR_UID;
                $record["PREVIOUS_USR_USERNAME"] = $record["DEL_PREVIOUS_USR_USERNAME"] = $user->USR_USERNAME;
                $record["PREVIOUS_USR_FIRSTNAME"] = $record["DEL_PREVIOUS_USR_FIRSTNAME"] = $user->USR_FIRSTNAME;
                $record["PREVIOUS_USR_LASTNAME"] = $record["DEL_PREVIOUS_USR_LASTNAME"] = $user->USR_LASTNAME;
            }

            if (isset($record["DEL_DUE_DATE"])) {
                $record["DEL_TASK_DUE_DATE"] = $record["DEL_DUE_DATE"];
            }

            if (isset($record["APP_PAUSED_DATE"])) {
                $record["APP_UPDATE_DATE"] = $record["APP_PAUSED_DATE"];
            }

            if (isset($record["DEL_CURRENT_USR_USERNAME"])) {
                $record["USR_USERNAME"] = $record["DEL_CURRENT_USR_USERNAME"];
                $record["USR_FIRSTNAME"] = $record["DEL_CURRENT_USR_FIRSTNAME"];
                $record["USR_LASTNAME"] = $record["DEL_CURRENT_USR_LASTNAME"];
                $record["APP_UPDATE_DATE"] = $record["DEL_DELEGATE_DATE"];
            }

            if (isset($record['DEL_CURRENT_TAS_TITLE']) && $record['DEL_CURRENT_TAS_TITLE'] != '') {
                $record['APP_TAS_TITLE'] = $record['DEL_CURRENT_TAS_TITLE'];
            } elseif (!empty($record["TAS_TITLE"]) && empty($record["APP_TAS_TITLE"])) {
                $record["APP_TAS_TITLE"] = $record["TAS_TITLE"];
            }

            if (isset($record["APP_STATUS"])) {
                $record["APP_STATUS_LABEL"] = G::LoadTranslation("ID_" . $record["APP_STATUS"]);
            }

            if (!empty($record["PRO_TITLE"]) && empty($record["APP_PRO_TITLE"])) {
                $record["APP_PRO_TITLE"] = $record["PRO_TITLE"];
            }

            return $record;
        } catch (Exception $e) {
            throw $e;
        }
    });

    $response = array();
    $response['filters'] = $filters;
    $response['totalCount'] = $list->getCountList($userUid, $filters);
    $response['data'] = \ProcessMaker\Util\DateTime::convertUtcToTimeZone($result);
    !empty($response['filters']['search']) ? $response['filters']['search'] = '' : '';
    echo G::json_encode($response);
} catch (Exception $e) {
    $msg = array("error" => $e->getMessage());
    echo G::json_encode($msg);
}
