/* This notice must be untouched at all times.

wz_jsgraphics.js    v. 3.05
The latest version is available at
http://www.walterzorn.com
or http://www.devira.com
or http://www.walterzorn.de

Copyright (c) 2002-2009 Walter Zorn. All rights reserved.
Created 3. 11. 2002 by Walter Zorn (Web: http://www.walterzorn.com )
Last modified: 2. 2. 2009

Performance optimizations for Internet Explorer
by Thomas Frank and John Holdsworth.
fillPolygon method implemented by Matthieu Haller.

High Performance JavaScript Graphics Library.
Provides methods
- to draw lines, rectangles, ellipses, polygons
	with specifiable line thickness,
- to fill rectangles, polygons, ellipses and arcs
- to draw text.
NOTE: Operations, functions and branching have rather been optimized
to efficiency and speed than to shortness of source code.

LICENSE: LGPL

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License (LGPL) as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
or see http://www.gnu.org/copyleft/lesser.html
*/


var jg_ok, jg_ie, jg_fast, jg_dom, jg_moz;


function _chkDHTM(wnd, x, i)
// Under XUL, owner of 'document' must be specified explicitly
{
	x = wnd.document.body || null;
	jg_ie = x && typeof x.insertAdjacentHTML != "undefined" && wnd.document.createElement;
	jg_dom = (x && !jg_ie &&
		typeof x.appendChild != "undefined" &&
		typeof wnd.document.createRange != "undefined" &&
		typeof (i = wnd.document.createRange()).setStartBefore != "undefined" &&
		typeof i.createContextualFragment != "undefined");
	jg_fast = jg_ie && wnd.document.all && !wnd.opera;
	jg_moz = jg_dom && typeof x.style.MozOpacity != "undefined";
	jg_ok = !!(jg_ie || jg_dom);
}

function _pntCnvDom()
{
	var x = this.wnd.document.createRange();
	x.setStartBefore(this.cnv);
	x = x.createContextualFragment(jg_fast? this._htmRpc() : this.htm);
	if(this.cnv) this.cnv.appendChild(x);
	this.htm = "";
}

function _pntCnvIe()
{
	if(this.cnv) this.cnv.insertAdjacentHTML("BeforeEnd", jg_fast? this._htmRpc() : this.htm);
	this.htm = "";
}

function _pntDoc()
{
	this.wnd.document.write(jg_fast? this._htmRpc() : this.htm);
	this.htm = '';
}

function _pntN()
{
	;
}

function _mkDiv(x, y, w, h)
{
	this.htm += '<div style="position:absolute;'+
		'left:' + x + 'px;'+
		'top:' + y + 'px;'+
		'width:' + w + 'px;'+
		'height:' + h + 'px;'+
		'clip:rect(0,'+w+'px,'+h+'px,0);'+
		'background-color:' + this.color +
		(!jg_moz? ';overflow:hidden' : '')+
		';"><\/div>';
}

function _mkDivIe(x, y, w, h)
{
	this.htm += '%%'+this.color+';'+x+';'+y+';'+w+';'+h+';';
}

function _mkDivPrt(x, y, w, h)
{
	this.htm += '<div style="position:absolute;'+
		'border-left:' + w + 'px solid ' + this.color + ';'+
		'left:' + x + 'px;'+
		'top:' + y + 'px;'+
		'width:0px;'+
		'height:' + h + 'px;'+
		'clip:rect(0,'+w+'px,'+h+'px,0);'+
		'background-color:' + this.color +
		(!jg_moz? ';overflow:hidden' : '')+
		';"><\/div>';
}

var _regex =  /%%([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);/g;
function _htmRpc()
{
	return this.htm.replace(
		_regex,
		'<div style="overflow:hidden;position:absolute;background-color:'+
		'$1;left:$2px;top:$3px;width:$4px;height:$5px"></div>\n');
}

function _htmPrtRpc()
{
	return this.htm.replace(
		_regex,
		'<div style="overflow:hidden;position:absolute;background-color:'+
		'$1;left:$2px;top:$3px;width:$4px;height:$5px;border-left:$4px solid $1"></div>\n');
}

function _mkLin(x1, y1, x2, y2)
{
	if(x1 > x2)
	{
		var _x2 = x2;
		var _y2 = y2;
		x2 = x1;
		y2 = y1;
		x1 = _x2;
		y1 = _y2;
	}
	var dx = x2-x1, dy = Math.abs(y2-y1),
	x = x1, y = y1,
	yIncr = (y1 > y2)? -1 : 1;

	if(dx >= dy)
	{
		var pr = dy<<1,
		pru = pr - (dx<<1),
		p = pr-dx,
		ox = x;
		while(dx > 0)
		{--dx;
			++x;
			if(p > 0)
			{
				this._mkDiv(ox, y, x-ox, 1);
				y += yIncr;
				p += pru;
				ox = x;
			}
			else p += pr;
		}
		this._mkDiv(ox, y, x2-ox+1, 1);
	}

	else
	{
		var pr = dx<<1,
		pru = pr - (dy<<1),
		p = pr-dy,
		oy = y;
		if(y2 <= y1)
		{
			while(dy > 0)
			{--dy;
				if(p > 0)
				{
					this._mkDiv(x++, y, 1, oy-y+1);
					y += yIncr;
					p += pru;
					oy = y;
				}
				else
				{
					y += yIncr;
					p += pr;
				}
			}
			this._mkDiv(x2, y2, 1, oy-y2+1);
		}
		else
		{
			while(dy > 0)
			{--dy;
				y += yIncr;
				if(p > 0)
				{
					this._mkDiv(x++, oy, 1, y-oy);
					p += pru;
					oy = y;
				}
				else p += pr;
			}
			this._mkDiv(x2, oy, 1, y2-oy+1);
		}
	}
}

function _mkLin2D(x1, y1, x2, y2)
{
	if(x1 > x2)
	{
		var _x2 = x2;
		var _y2 = y2;
		x2 = x1;
		y2 = y1;
		x1 = _x2;
		y1 = _y2;
	}
	var dx = x2-x1, dy = Math.abs(y2-y1),
	x = x1, y = y1,
	yIncr = (y1 > y2)? -1 : 1;

	var s = this.stroke;
	if(dx >= dy)
	{
		if(dx > 0 && s-3 > 0)
		{
			var _s = (s*dx*Math.sqrt(1+dy*dy/(dx*dx))-dx-(s>>1)*dy) / dx;
			_s = (!(s-4)? Math.ceil(_s) : Math.round(_s)) + 1;
		}
		else var _s = s;
		var ad = Math.ceil(s/2);

		var pr = dy<<1,
		pru = pr - (dx<<1),
		p = pr-dx,
		ox = x;
		while(dx > 0)
		{--dx;
			++x;
			if(p > 0)
			{
				this._mkDiv(ox, y, x-ox+ad, _s);
				y += yIncr;
				p += pru;
				ox = x;
			}
			else p += pr;
		}
		this._mkDiv(ox, y, x2-ox+ad+1, _s);
	}

	else
	{
		if(s-3 > 0)
		{
			var _s = (s*dy*Math.sqrt(1+dx*dx/(dy*dy))-(s>>1)*dx-dy) / dy;
			_s = (!(s-4)? Math.ceil(_s) : Math.round(_s)) + 1;
		}
		else var _s = s;
		var ad = Math.round(s/2);

		var pr = dx<<1,
		pru = pr - (dy<<1),
		p = pr-dy,
		oy = y;
		if(y2 <= y1)
		{
			++ad;
			while(dy > 0)
			{--dy;
				if(p > 0)
				{
					this._mkDiv(x++, y, _s, oy-y+ad);
					y += yIncr;
					p += pru;
					oy = y;
				}
				else
				{
					y += yIncr;
					p += pr;
				}
			}
			this._mkDiv(x2, y2, _s, oy-y2+ad);
		}
		else
		{
			while(dy > 0)
			{--dy;
				y += yIncr;
				if(p > 0)
				{
					this._mkDiv(x++, oy, _s, y-oy+ad);
					p += pru;
					oy = y;
				}
				else p += pr;
			}
			this._mkDiv(x2, oy, _s, y2-oy+ad+1);
		}
	}
}

function _mkLinDott(x1, y1, x2, y2)
{
	if(x1 > x2)
	{
		var _x2 = x2;
		var _y2 = y2;
		x2 = x1;
		y2 = y1;
		x1 = _x2;
		y1 = _y2;
	}
	var dx = x2-x1, dy = Math.abs(y2-y1),
	x = x1, y = y1,
	yIncr = (y1 > y2)? -1 : 1,
	drw = true;
	if(dx >= dy)
	{
		var pr = dy<<1,
		pru = pr - (dx<<1),
		p = pr-dx;
		while(dx > 0)
		{--dx;
			if(drw) this._mkDiv(x, y, 1, 1);
			drw = !drw;
			if(p > 0)
			{
				y += yIncr;
				p += pru;
			}
			else p += pr;
			++x;
		}
	}
	else
	{
		var pr = dx<<1,
		pru = pr - (dy<<1),
		p = pr-dy;
		while(dy > 0)
		{--dy;
			if(drw) this._mkDiv(x, y, 1, 1);
			drw = !drw;
			y += yIncr;
			if(p > 0)
			{
				++x;
				p += pru;
			}
			else p += pr;
		}
	}
	if(drw) this._mkDiv(x, y, 1, 1);
}

function _mkOv(left, top, width, height)
{
	var a = (++width)>>1, b = (++height)>>1,
	wod = width&1, hod = height&1,
	cx = left+a, cy = top+b,
	x = 0, y = b,
	ox = 0, oy = b,
	aa2 = (a*a)<<1, aa4 = aa2<<1, bb2 = (b*b)<<1, bb4 = bb2<<1,
	st = (aa2>>1)*(1-(b<<1)) + bb2,
	tt = (bb2>>1) - aa2*((b<<1)-1),
	w, h;
	while(y > 0)
	{
		if(st < 0)
		{
			st += bb2*((x<<1)+3);
			tt += bb4*(++x);
		}
		else if(tt < 0)
		{
			st += bb2*((x<<1)+3) - aa4*(y-1);
			tt += bb4*(++x) - aa2*(((y--)<<1)-3);
			w = x-ox;
			h = oy-y;
			if((w&2) && (h&2))
			{
				this._mkOvQds(cx, cy, x-2, y+2, 1, 1, wod, hod);
				this._mkOvQds(cx, cy, x-1, y+1, 1, 1, wod, hod);
			}
			else this._mkOvQds(cx, cy, x-1, oy, w, h, wod, hod);
			ox = x;
			oy = y;
		}
		else
		{
			tt -= aa2*((y<<1)-3);
			st -= aa4*(--y);
		}
	}
	w = a-ox+1;
	h = (oy<<1)+hod;
	y = cy-oy;
	this._mkDiv(cx-a, y, w, h);
	this._mkDiv(cx+ox+wod-1, y, w, h);
}

function _mkOv2D(left, top, width, height)
{
	var s = this.stroke;
	width += s+1;
	height += s+1;
	var a = width>>1, b = height>>1,
	wod = width&1, hod = height&1,
	cx = left+a, cy = top+b,
	x = 0, y = b,
	aa2 = (a*a)<<1, aa4 = aa2<<1, bb2 = (b*b)<<1, bb4 = bb2<<1,
	st = (aa2>>1)*(1-(b<<1)) + bb2,
	tt = (bb2>>1) - aa2*((b<<1)-1);

	if(s-4 < 0 && (!(s-2) || width-51 > 0 && height-51 > 0))
	{
		var ox = 0, oy = b,
		w, h,
		pxw;
		while(y > 0)
		{
			if(st < 0)
			{
				st += bb2*((x<<1)+3);
				tt += bb4*(++x);
			}
			else if(tt < 0)
			{
				st += bb2*((x<<1)+3) - aa4*(y-1);
				tt += bb4*(++x) - aa2*(((y--)<<1)-3);
				w = x-ox;
				h = oy-y;

				if(w-1)
				{
					pxw = w+1+(s&1);
					h = s;
				}
				else if(h-1)
				{
					pxw = s;
					h += 1+(s&1);
				}
				else pxw = h = s;
				this._mkOvQds(cx, cy, x-1, oy, pxw, h, wod, hod);
				ox = x;
				oy = y;
			}
			else
			{
				tt -= aa2*((y<<1)-3);
				st -= aa4*(--y);
			}
		}
		this._mkDiv(cx-a, cy-oy, s, (oy<<1)+hod);
		this._mkDiv(cx+a+wod-s, cy-oy, s, (oy<<1)+hod);
	}

	else
	{
		var _a = (width-(s<<1))>>1,
		_b = (height-(s<<1))>>1,
		_x = 0, _y = _b,
		_aa2 = (_a*_a)<<1, _aa4 = _aa2<<1, _bb2 = (_b*_b)<<1, _bb4 = _bb2<<1,
		_st = (_aa2>>1)*(1-(_b<<1)) + _bb2,
		_tt = (_bb2>>1) - _aa2*((_b<<1)-1),

		pxl = new Array(),
		pxt = new Array(),
		_pxb = new Array();
		pxl[0] = 0;
		pxt[0] = b;
		_pxb[0] = _b-1;
		while(y > 0)
		{
			if(st < 0)
			{
				pxl[pxl.length] = x;
				pxt[pxt.length] = y;
				st += bb2*((x<<1)+3);
				tt += bb4*(++x);
			}
			else if(tt < 0)
			{
				pxl[pxl.length] = x;
				st += bb2*((x<<1)+3) - aa4*(y-1);
				tt += bb4*(++x) - aa2*(((y--)<<1)-3);
				pxt[pxt.length] = y;
			}
			else
			{
				tt -= aa2*((y<<1)-3);
				st -= aa4*(--y);
			}

			if(_y > 0)
			{
				if(_st < 0)
				{
					_st += _bb2*((_x<<1)+3);
					_tt += _bb4*(++_x);
					_pxb[_pxb.length] = _y-1;
				}
				else if(_tt < 0)
				{
					_st += _bb2*((_x<<1)+3) - _aa4*(_y-1);
					_tt += _bb4*(++_x) - _aa2*(((_y--)<<1)-3);
					_pxb[_pxb.length] = _y-1;
				}
				else
				{
					_tt -= _aa2*((_y<<1)-3);
					_st -= _aa4*(--_y);
					_pxb[_pxb.length-1]--;
				}
			}
		}

		var ox = -wod, oy = b,
		_oy = _pxb[0],
		l = pxl.length,
		w, h;
		for(var i = 0; i < l; i++)
		{
			if(typeof _pxb[i] != "undefined")
			{
				if(_pxb[i] < _oy || pxt[i] < oy)
				{
					x = pxl[i];
					this._mkOvQds(cx, cy, x, oy, x-ox, oy-_oy, wod, hod);
					ox = x;
					oy = pxt[i];
					_oy = _pxb[i];
				}
			}
			else
			{
				x = pxl[i];
				this._mkDiv(cx-x, cy-oy, 1, (oy<<1)+hod);
				this._mkDiv(cx+ox+wod, cy-oy, 1, (oy<<1)+hod);
				ox = x;
				oy = pxt[i];
			}
		}
		this._mkDiv(cx-a, cy-oy, 1, (oy<<1)+hod);
		this._mkDiv(cx+ox+wod, cy-oy, 1, (oy<<1)+hod);
	}
}

function _mkOvDott(left, top, width, height)
{
	var a = (++width)>>1, b = (++height)>>1,
	wod = width&1, hod = height&1, hodu = hod^1,
	cx = left+a, cy = top+b,
	x = 0, y = b,
	aa2 = (a*a)<<1, aa4 = aa2<<1, bb2 = (b*b)<<1, bb4 = bb2<<1,
	st = (aa2>>1)*(1-(b<<1)) + bb2,
	tt = (bb2>>1) - aa2*((b<<1)-1),
	drw = true;
	while(y > 0)
	{
		if(st < 0)
		{
			st += bb2*((x<<1)+3);
			tt += bb4*(++x);
		}
		else if(tt < 0)
		{
			st += bb2*((x<<1)+3) - aa4*(y-1);
			tt += bb4*(++x) - aa2*(((y--)<<1)-3);
		}
		else
		{
			tt -= aa2*((y<<1)-3);
			st -= aa4*(--y);
		}
		if(drw && y >= hodu) this._mkOvQds(cx, cy, x, y, 1, 1, wod, hod);
		drw = !drw;
	}
}

function _mkRect(x, y, w, h)
{
	var s = this.stroke;
	this._mkDiv(x, y, w, s);
	this._mkDiv(x+w, y, s, h);
	this._mkDiv(x, y+h, w+s, s);
	this._mkDiv(x, y+s, s, h-s);
}

function _mkRectDott(x, y, w, h)
{
	this.drawLine(x, y, x+w, y);
	this.drawLine(x+w, y, x+w, y+h);
	this.drawLine(x, y+h, x+w, y+h);
	this.drawLine(x, y, x, y+h);
}

function jsgFont()
{
	this.PLAIN = 'font-weight:normal;';
	this.BOLD = 'font-weight:bold;';
	this.ITALIC = 'font-style:italic;';
	this.ITALIC_BOLD = this.ITALIC + this.BOLD;
	this.BOLD_ITALIC = this.ITALIC_BOLD;
}
var Font = new jsgFont();

function jsgStroke()
{
	this.DOTTED = -1;
}
var Stroke = new jsgStroke();

function JSGraphics(cnv, wnd)
{
	this.setColor = function(x)
	{
		this.color = x.toLowerCase();
	};

	this.setStroke = function(x)
	{
		this.stroke = x;
		if(!(x+1))
		{
			this.drawLine = _mkLinDott;
			this._mkOv = _mkOvDott;
			this.drawRect = _mkRectDott;
		}
		else if(x-1 > 0)
		{
			this.drawLine = _mkLin2D;
			this._mkOv = _mkOv2D;
			this.drawRect = _mkRect;
		}
		else
		{
			this.drawLine = _mkLin;
			this._mkOv = _mkOv;
			this.drawRect = _mkRect;
		}
	};

	this.setPrintable = function(arg)
	{
		this.printable = arg;
		if(jg_fast)
		{
			this._mkDiv = _mkDivIe;
			this._htmRpc = arg? _htmPrtRpc : _htmRpc;
		}
		else this._mkDiv = arg? _mkDivPrt : _mkDiv;
	};

	this.setFont = function(fam, sz, sty)
	{
		this.ftFam = fam;
		this.ftSz = sz;
		this.ftSty = sty || Font.PLAIN;
	};

	this.drawPolyline = this.drawPolyLine = function(x, y)
	{
		for (var i=x.length - 1; i;)
		{--i;
			this.drawLine(x[i], y[i], x[i+1], y[i+1]);
		}
	};

	this.fillRect = function(x, y, w, h)
	{
		this._mkDiv(x, y, w, h);
	};

	this.drawPolygon = function(x, y)
	{
		this.drawPolyline(x, y);
		this.drawLine(x[x.length-1], y[x.length-1], x[0], y[0]);
	};

	this.drawEllipse = this.drawOval = function(x, y, w, h)
	{
		this._mkOv(x, y, w, h);
	};

	this.fillEllipse = this.fillOval = function(left, top, w, h)
	{
		var a = w>>1, b = h>>1,
		wod = w&1, hod = h&1,
		cx = left+a, cy = top+b,
		x = 0, y = b, oy = b,
		aa2 = (a*a)<<1, aa4 = aa2<<1, bb2 = (b*b)<<1, bb4 = bb2<<1,
		st = (aa2>>1)*(1-(b<<1)) + bb2,
		tt = (bb2>>1) - aa2*((b<<1)-1),
		xl, dw, dh;
		if(w) while(y > 0)
		{
			if(st < 0)
			{
				st += bb2*((x<<1)+3);
				tt += bb4*(++x);
			}
			else if(tt < 0)
			{
				st += bb2*((x<<1)+3) - aa4*(y-1);
				xl = cx-x;
				dw = (x<<1)+wod;
				tt += bb4*(++x) - aa2*(((y--)<<1)-3);
				dh = oy-y;
				this._mkDiv(xl, cy-oy, dw, dh);
				this._mkDiv(xl, cy+y+hod, dw, dh);
				oy = y;
			}
			else
			{
				tt -= aa2*((y<<1)-3);
				st -= aa4*(--y);
			}
		}
		this._mkDiv(cx-a, cy-oy, w, (oy<<1)+hod);
	};

	this.fillArc = function(iL, iT, iW, iH, fAngA, fAngZ)
	{
		var a = iW>>1, b = iH>>1,
		iOdds = (iW&1) | ((iH&1) << 16),
		cx = iL+a, cy = iT+b,
		x = 0, y = b, ox = x, oy = y,
		aa2 = (a*a)<<1, aa4 = aa2<<1, bb2 = (b*b)<<1, bb4 = bb2<<1,
		st = (aa2>>1)*(1-(b<<1)) + bb2,
		tt = (bb2>>1) - aa2*((b<<1)-1),
		// Vars for radial boundary lines
		xEndA, yEndA, xEndZ, yEndZ,
		iSects = (1 << (Math.floor((fAngA %= 360.0)/180.0) << 3))
				| (2 << (Math.floor((fAngZ %= 360.0)/180.0) << 3))
				| ((fAngA >= fAngZ) << 16),
		aBndA = new Array(b+1), aBndZ = new Array(b+1);
		
		// Set up radial boundary lines
		fAngA *= Math.PI/180.0;
		fAngZ *= Math.PI/180.0;
		xEndA = cx+Math.round(a*Math.cos(fAngA));
		yEndA = cy+Math.round(-b*Math.sin(fAngA));
		_mkLinVirt(aBndA, cx, cy, xEndA, yEndA);
		xEndZ = cx+Math.round(a*Math.cos(fAngZ));
		yEndZ = cy+Math.round(-b*Math.sin(fAngZ));
		_mkLinVirt(aBndZ, cx, cy, xEndZ, yEndZ);

		while(y > 0)
		{
			if(st < 0) // Advance x
			{
				st += bb2*((x<<1)+3);
				tt += bb4*(++x);
			}
			else if(tt < 0) // Advance x and y
			{
				st += bb2*((x<<1)+3) - aa4*(y-1);
				ox = x;
				tt += bb4*(++x) - aa2*(((y--)<<1)-3);
				this._mkArcDiv(ox, y, oy, cx, cy, iOdds, aBndA, aBndZ, iSects);
				oy = y;
			}
			else // Advance y
			{
				tt -= aa2*((y<<1)-3);
				st -= aa4*(--y);
				if(y && (aBndA[y] != aBndA[y-1] || aBndZ[y] != aBndZ[y-1]))
				{
					this._mkArcDiv(x, y, oy, cx, cy, iOdds, aBndA, aBndZ, iSects);
					ox = x;
					oy = y;
				}
			}
		}
		this._mkArcDiv(x, 0, oy, cx, cy, iOdds, aBndA, aBndZ, iSects);
		if(iOdds >> 16) // Odd height
		{
			if(iSects >> 16) // Start-angle > end-angle
			{
				var xl = (yEndA <= cy || yEndZ > cy)? (cx - x) : cx;
				this._mkDiv(xl, cy, x + cx - xl + (iOdds & 0xffff), 1);
			}
			else if((iSects & 0x01) && yEndZ > cy)
				this._mkDiv(cx - x, cy, x, 1);
		}
	};

/* fillPolygon method, implemented by Matthieu Haller.
This javascript function is an adaptation of the gdImageFilledPolygon for Walter Zorn lib.
C source of GD 1.8.4 found at http://www.boutell.com/gd/

THANKS to Kirsten Schulz for the polygon fixes!

The intersection finding technique of this code could be improved
by remembering the previous intertersection, and by using the slope.
That could help to adjust intersections to produce a nice
interior_extrema. */
	this.fillPolygon = function(array_x, array_y)
	{
		var i;
		var y;
		var miny, maxy;
		var x1, y1;
		var x2, y2;
		var ind1, ind2;
		var ints;

		var n = array_x.length;
		if(!n) return;

		miny = array_y[0];
		maxy = array_y[0];
		for(i = 1; i < n; i++)
		{
			if(array_y[i] < miny)
				miny = array_y[i];

			if(array_y[i] > maxy)
				maxy = array_y[i];
		}
		for(y = miny; y <= maxy; y++)
		{
			var polyInts = new Array();
			ints = 0;
			for(i = 0; i < n; i++)
			{
				if(!i)
				{
					ind1 = n-1;
					ind2 = 0;
				}
				else
				{
					ind1 = i-1;
					ind2 = i;
				}
				y1 = array_y[ind1];
				y2 = array_y[ind2];
				if(y1 < y2)
				{
					x1 = array_x[ind1];
					x2 = array_x[ind2];
				}
				else if(y1 > y2)
				{
					y2 = array_y[ind1];
					y1 = array_y[ind2];
					x2 = array_x[ind1];
					x1 = array_x[ind2];
				}
				else continue;

				 //  Modified 11. 2. 2004 Walter Zorn
				if((y >= y1) && (y < y2))
					polyInts[ints++] = Math.round((y-y1) * (x2-x1) / (y2-y1) + x1);

				else if((y == maxy) && (y > y1) && (y <= y2))
					polyInts[ints++] = Math.round((y-y1) * (x2-x1) / (y2-y1) + x1);
			}
			polyInts.sort(_CompInt);
			for(i = 0; i < ints; i+=2)
				this._mkDiv(polyInts[i], y, polyInts[i+1]-polyInts[i]+1, 1);
		}
	};

	this.drawString = function(txt, x, y)
	{
		this.htm += '<div style="position:absolute;white-space:nowrap;'+
			'left:' + x + 'px;'+
			'top:' + y + 'px;'+
			'font-family:' +  this.ftFam + ';'+
			'font-size:' + this.ftSz + ';'+
			'color:' + this.color + ';' + this.ftSty + '">'+
			txt +
			'<\/div>';
	};

/* drawStringRect() added by Rick Blommers.
Allows to specify the size of the text rectangle and to align the
text both horizontally (e.g. right) and vertically within that rectangle */
	this.drawStringRect = function(txt, x, y, width, halign)
	{
		this.htm += '<div style="position:absolute;overflow:hidden;'+
			'left:' + x + 'px;'+
			'top:' + y + 'px;'+
			'width:'+width +'px;'+
			'text-align:'+halign+';'+
			'font-family:' +  this.ftFam + ';'+
			'font-size:' + this.ftSz + ';'+
			'color:' + this.color + ';' + this.ftSty + '">'+
			txt +
			'<\/div>';
	};

	this.drawImage = function(imgSrc, x, y, w, h, a)
	{
		this.htm += '<div style="position:absolute;'+
			'left:' + x + 'px;'+
			'top:' + y + 'px;'+
			// w (width) and h (height) arguments are now optional.
			// Added by Mahmut Keygubatli, 14.1.2008
			(w? ('width:' +  w + 'px;') : '') +
			(h? ('height:' + h + 'px;'):'')+'">'+
			'<img src="' + imgSrc +'"'+ (w ? (' width="' + w + '"'):'')+ (h ? (' height="' + h + '"'):'') + (a? (' '+a) : '') + '>'+
			'<\/div>';
	};

	this.clear = function()
	{
		this.htm = "";
		if(this.cnv) this.cnv.innerHTML = "";
	};

	this._mkOvQds = function(cx, cy, x, y, w, h, wod, hod)
	{
		var xl = cx - x, xr = cx + x + wod - w, yt = cy - y, yb = cy + y + hod - h;
		if(xr > xl+w)
		{
			this._mkDiv(xr, yt, w, h);
			this._mkDiv(xr, yb, w, h);
		}
		else
			w = xr - xl + w;
		this._mkDiv(xl, yt, w, h);
		this._mkDiv(xl, yb, w, h);
	};
	
	this._mkArcDiv = function(x, y, oy, cx, cy, iOdds, aBndA, aBndZ, iSects)
	{
		var xrDef = cx + x + (iOdds & 0xffff), y2, h = oy - y, xl, xr, w;

		if(!h) h = 1;
		x = cx - x;

		if(iSects & 0xff0000) // Start-angle > end-angle
		{
			y2 = cy - y - h;
			if(iSects & 0x00ff)
			{
				if(iSects & 0x02)
				{
					xl = Math.max(x, aBndZ[y]);
					w = xrDef - xl;
					if(w > 0) this._mkDiv(xl, y2, w, h);
				}
				if(iSects & 0x01)
				{
					xr = Math.min(xrDef, aBndA[y]);
					w = xr - x;
					if(w > 0) this._mkDiv(x, y2, w, h);
				}
			}
			else
				this._mkDiv(x, y2, xrDef - x, h);
			y2 = cy + y + (iOdds >> 16);
			if(iSects & 0xff00)
			{
				if(iSects & 0x0100)
				{
					xl = Math.max(x, aBndA[y]);
					w = xrDef - xl;
					if(w > 0) this._mkDiv(xl, y2, w, h);
				}
				if(iSects & 0x0200)
				{
					xr = Math.min(xrDef, aBndZ[y]);
					w = xr - x;
					if(w > 0) this._mkDiv(x, y2, w, h);
				}
			}
			else
				this._mkDiv(x, y2, xrDef - x, h);
		}
		else
		{
			if(iSects & 0x00ff)
			{
				if(iSects & 0x02)
					xl = Math.max(x, aBndZ[y]);
				else
					xl = x;
				if(iSects & 0x01)
					xr = Math.min(xrDef, aBndA[y]);
				else
					xr = xrDef;
				y2 = cy - y - h;
				w = xr - xl;
				if(w > 0) this._mkDiv(xl, y2, w, h);
			}
			if(iSects & 0xff00)
			{
				if(iSects & 0x0100)
					xl = Math.max(x, aBndA[y]);
				else
					xl = x;
				if(iSects & 0x0200)
					xr = Math.min(xrDef, aBndZ[y]);
				else
					xr = xrDef;
				y2 = cy + y + (iOdds >> 16);
				w = xr - xl;
				if(w > 0) this._mkDiv(xl, y2, w, h);
			}
		}
	};

	this.setStroke(1);
	this.setFont("verdana,geneva,helvetica,sans-serif", "12px", Font.PLAIN);
	this.color = "#000000";
	this.htm = "";
	this.wnd = wnd || window;

	if(!jg_ok) _chkDHTM(this.wnd);
    if(jg_ok)
	{
		if(cnv)
		{
			if(typeof(cnv) == "string")
				this.cont = document.all? (this.wnd.document.all[cnv] || null)
					: document.getElementById? (this.wnd.document.getElementById(cnv) || null)
					: null;
			else if(cnv == window.document)
				this.cont = document.getElementsByTagName("body")[0];
			// If cnv is a direct reference to a canvas DOM node
			// (option suggested by Andreas Luleich)
			else this.cont = cnv;
			// Create new canvas inside container DIV. Thus the drawing and clearing
			// methods won't interfere with the container's inner html.
			// Solution suggested by Vladimir.
			this.cnv = this.wnd.document.createElement("div");
			this.cnv.style.fontSize=0;
			this.cont.appendChild(this.cnv);
			this.paint = jg_dom? _pntCnvDom : _pntCnvIe;
		}
		else
			this.paint = _pntDoc;
	}
	else
		this.paint = _pntN;

	this.setPrintable(false);
}

function _mkLinVirt(aLin, x1, y1, x2, y2)
{
	var dx = Math.abs(x2-x1), dy = Math.abs(y2-y1),
	x = x1, y = y1,
	xIncr = (x1 > x2)? -1 : 1,
	yIncr = (y1 > y2)? -1 : 1,
	p,
	i = 0;
	if(dx >= dy)
	{
		var pr = dy<<1,
		pru = pr - (dx<<1);
		p = pr-dx;
		while(dx > 0)
		{--dx;
			if(p > 0)    //  Increment y
			{
				aLin[i++] = x;
				y += yIncr;
				p += pru;
			}
			else p += pr;
			x += xIncr;
		}
	}
	else
	{
		var pr = dx<<1,
		pru = pr - (dy<<1);
		p = pr-dy;
		while(dy > 0)
		{--dy;
			y += yIncr;
			aLin[i++] = x;
			if(p > 0)    //  Increment x
			{
				x += xIncr;
				p += pru;
			}
			else p += pr;
		}
	}
	for(var len = aLin.length, i = len-i; i;)
		aLin[len-(i--)] = x;
};

function _CompInt(x, y)
{
	return(x - y);
}


/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license*/
(function(e,t){var n,r,i=typeof t,o=e.location,a=e.document,s=a.documentElement,l=e.jQuery,u=e.$,c={},p=[],f="1.10.2",d=p.concat,h=p.push,g=p.slice,m=p.indexOf,y=c.toString,v=c.hasOwnProperty,b=f.trim,x=function(e,t){return new x.fn.init(e,t,r)},w=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,T=/\S+/g,C=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,N=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,k=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,E=/^[\],:{}\s]*$/,S=/(?:^|:|,)(?:\s*\[)+/g,A=/\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,j=/"[^"\\\r\n]*"|true|false|null|-?(?:\d+\.|)\d+(?:[eE][+-]?\d+|)/g,D=/^-ms-/,L=/-([\da-z])/gi,H=function(e,t){return t.toUpperCase()},q=function(e){(a.addEventListener||"load"===e.type||"complete"===a.readyState)&&(_(),x.ready())},_=function(){a.addEventListener?(a.removeEventListener("DOMContentLoaded",q,!1),e.removeEventListener("load",q,!1)):(a.detachEvent("onreadystatechange",q),e.detachEvent("onload",q))};x.fn=x.prototype={jquery:f,constructor:x,init:function(e,n,r){var i,o;if(!e)return this;if("string"==typeof e){if(i="<"===e.charAt(0)&&">"===e.charAt(e.length-1)&&e.length>=3?[null,e,null]:N.exec(e),!i||!i[1]&&n)return!n||n.jquery?(n||r).find(e):this.constructor(n).find(e);if(i[1]){if(n=n instanceof x?n[0]:n,x.merge(this,x.parseHTML(i[1],n&&n.nodeType?n.ownerDocument||n:a,!0)),k.test(i[1])&&x.isPlainObject(n))for(i in n)x.isFunction(this[i])?this[i](n[i]):this.attr(i,n[i]);return this}if(o=a.getElementById(i[2]),o&&o.parentNode){if(o.id!==i[2])return r.find(e);this.length=1,this[0]=o}return this.context=a,this.selector=e,this}return e.nodeType?(this.context=this[0]=e,this.length=1,this):x.isFunction(e)?r.ready(e):(e.selector!==t&&(this.selector=e.selector,this.context=e.context),x.makeArray(e,this))},selector:"",length:0,toArray:function(){return g.call(this)},get:function(e){return null==e?this.toArray():0>e?this[this.length+e]:this[e]},pushStack:function(e){var t=x.merge(this.constructor(),e);return t.prevObject=this,t.context=this.context,t},each:function(e,t){return x.each(this,e,t)},ready:function(e){return x.ready.promise().done(e),this},slice:function(){return this.pushStack(g.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(0>e?t:0);return this.pushStack(n>=0&&t>n?[this[n]]:[])},map:function(e){return this.pushStack(x.map(this,function(t,n){return e.call(t,n,t)}))},end:function(){return this.prevObject||this.constructor(null)},push:h,sort:[].sort,splice:[].splice},x.fn.init.prototype=x.fn,x.extend=x.fn.extend=function(){var e,n,r,i,o,a,s=arguments[0]||{},l=1,u=arguments.length,c=!1;for("boolean"==typeof s&&(c=s,s=arguments[1]||{},l=2),"object"==typeof s||x.isFunction(s)||(s={}),u===l&&(s=this,--l);u>l;l++)if(null!=(o=arguments[l]))for(i in o)e=s[i],r=o[i],s!==r&&(c&&r&&(x.isPlainObject(r)||(n=x.isArray(r)))?(n?(n=!1,a=e&&x.isArray(e)?e:[]):a=e&&x.isPlainObject(e)?e:{},s[i]=x.extend(c,a,r)):r!==t&&(s[i]=r));return s},x.extend({expando:"jQuery"+(f+Math.random()).replace(/\D/g,""),noConflict:function(t){return e.$===x&&(e.$=u),t&&e.jQuery===x&&(e.jQuery=l),x},isReady:!1,readyWait:1,holdReady:function(e){e?x.readyWait++:x.ready(!0)},ready:function(e){if(e===!0?!--x.readyWait:!x.isReady){if(!a.body)return setTimeout(x.ready);x.isReady=!0,e!==!0&&--x.readyWait>0||(n.resolveWith(a,[x]),x.fn.trigger&&x(a).trigger("ready").off("ready"))}},isFunction:function(e){return"function"===x.type(e)},isArray:Array.isArray||function(e){return"array"===x.type(e)},isWindow:function(e){return null!=e&&e==e.window},isNumeric:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},type:function(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?c[y.call(e)]||"object":typeof e},isPlainObject:function(e){var n;if(!e||"object"!==x.type(e)||e.nodeType||x.isWindow(e))return!1;try{if(e.constructor&&!v.call(e,"constructor")&&!v.call(e.constructor.prototype,"isPrototypeOf"))return!1}catch(r){return!1}if(x.support.ownLast)for(n in e)return v.call(e,n);for(n in e);return n===t||v.call(e,n)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},error:function(e){throw Error(e)},parseHTML:function(e,t,n){if(!e||"string"!=typeof e)return null;"boolean"==typeof t&&(n=t,t=!1),t=t||a;var r=k.exec(e),i=!n&&[];return r?[t.createElement(r[1])]:(r=x.buildFragment([e],t,i),i&&x(i).remove(),x.merge([],r.childNodes))},parseJSON:function(n){return e.JSON&&e.JSON.parse?e.JSON.parse(n):null===n?n:"string"==typeof n&&(n=x.trim(n),n&&E.test(n.replace(A,"@").replace(j,"]").replace(S,"")))?Function("return "+n)():(x.error("Invalid JSON: "+n),t)},parseXML:function(n){var r,i;if(!n||"string"!=typeof n)return null;try{e.DOMParser?(i=new DOMParser,r=i.parseFromString(n,"text/xml")):(r=new ActiveXObject("Microsoft.XMLDOM"),r.async="false",r.loadXML(n))}catch(o){r=t}return r&&r.documentElement&&!r.getElementsByTagName("parsererror").length||x.error("Invalid XML: "+n),r},noop:function(){},globalEval:function(t){t&&x.trim(t)&&(e.execScript||function(t){e.eval.call(e,t)})(t)},camelCase:function(e){return e.replace(D,"ms-").replace(L,H)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},each:function(e,t,n){var r,i=0,o=e.length,a=M(e);if(n){if(a){for(;o>i;i++)if(r=t.apply(e[i],n),r===!1)break}else for(i in e)if(r=t.apply(e[i],n),r===!1)break}else if(a){for(;o>i;i++)if(r=t.call(e[i],i,e[i]),r===!1)break}else for(i in e)if(r=t.call(e[i],i,e[i]),r===!1)break;return e},trim:b&&!b.call("\ufeff\u00a0")?function(e){return null==e?"":b.call(e)}:function(e){return null==e?"":(e+"").replace(C,"")},makeArray:function(e,t){var n=t||[];return null!=e&&(M(Object(e))?x.merge(n,"string"==typeof e?[e]:e):h.call(n,e)),n},inArray:function(e,t,n){var r;if(t){if(m)return m.call(t,e,n);for(r=t.length,n=n?0>n?Math.max(0,r+n):n:0;r>n;n++)if(n in t&&t[n]===e)return n}return-1},merge:function(e,n){var r=n.length,i=e.length,o=0;if("number"==typeof r)for(;r>o;o++)e[i++]=n[o];else while(n[o]!==t)e[i++]=n[o++];return e.length=i,e},grep:function(e,t,n){var r,i=[],o=0,a=e.length;for(n=!!n;a>o;o++)r=!!t(e[o],o),n!==r&&i.push(e[o]);return i},map:function(e,t,n){var r,i=0,o=e.length,a=M(e),s=[];if(a)for(;o>i;i++)r=t(e[i],i,n),null!=r&&(s[s.length]=r);else for(i in e)r=t(e[i],i,n),null!=r&&(s[s.length]=r);return d.apply([],s)},guid:1,proxy:function(e,n){var r,i,o;return"string"==typeof n&&(o=e[n],n=e,e=o),x.isFunction(e)?(r=g.call(arguments,2),i=function(){return e.apply(n||this,r.concat(g.call(arguments)))},i.guid=e.guid=e.guid||x.guid++,i):t},access:function(e,n,r,i,o,a,s){var l=0,u=e.length,c=null==r;if("object"===x.type(r)){o=!0;for(l in r)x.access(e,n,l,r[l],!0,a,s)}else if(i!==t&&(o=!0,x.isFunction(i)||(s=!0),c&&(s?(n.call(e,i),n=null):(c=n,n=function(e,t,n){return c.call(x(e),n)})),n))for(;u>l;l++)n(e[l],r,s?i:i.call(e[l],l,n(e[l],r)));return o?e:c?n.call(e):u?n(e[0],r):a},now:function(){return(new Date).getTime()},swap:function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];i=n.apply(e,r||[]);for(o in t)e.style[o]=a[o];return i}}),x.ready.promise=function(t){if(!n)if(n=x.Deferred(),"complete"===a.readyState)setTimeout(x.ready);else if(a.addEventListener)a.addEventListener("DOMContentLoaded",q,!1),e.addEventListener("load",q,!1);else{a.attachEvent("onreadystatechange",q),e.attachEvent("onload",q);var r=!1;try{r=null==e.frameElement&&a.documentElement}catch(i){}r&&r.doScroll&&function o(){if(!x.isReady){try{r.doScroll("left")}catch(e){return setTimeout(o,50)}_(),x.ready()}}()}return n.promise(t)},x.each("Boolean Number String Function Array Date RegExp Object Error".split(" "),function(e,t){c["[object "+t+"]"]=t.toLowerCase()});function M(e){var t=e.length,n=x.type(e);return x.isWindow(e)?!1:1===e.nodeType&&t?!0:"array"===n||"function"!==n&&(0===t||"number"==typeof t&&t>0&&t-1 in e)}r=x(a),function(e,t){var n,r,i,o,a,s,l,u,c,p,f,d,h,g,m,y,v,b="sizzle"+-new Date,w=e.document,T=0,C=0,N=st(),k=st(),E=st(),S=!1,A=function(e,t){return e===t?(S=!0,0):0},j=typeof t,D=1<<31,L={}.hasOwnProperty,H=[],q=H.pop,_=H.push,M=H.push,O=H.slice,F=H.indexOf||function(e){var t=0,n=this.length;for(;n>t;t++)if(this[t]===e)return t;return-1},B="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",P="[\\x20\\t\\r\\n\\f]",R="(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",W=R.replace("w","w#"),$="\\["+P+"*("+R+")"+P+"*(?:([*^$|!~]?=)"+P+"*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|("+W+")|)|)"+P+"*\\]",I=":("+R+")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|"+$.replace(3,8)+")*)|.*)\\)|)",z=RegExp("^"+P+"+|((?:^|[^\\\\])(?:\\\\.)*)"+P+"+$","g"),X=RegExp("^"+P+"*,"+P+"*"),U=RegExp("^"+P+"*([>+~]|"+P+")"+P+"*"),V=RegExp(P+"*[+~]"),Y=RegExp("="+P+"*([^\\]'\"]*)"+P+"*\\]","g"),J=RegExp(I),G=RegExp("^"+W+"$"),Q={ID:RegExp("^#("+R+")"),CLASS:RegExp("^\\.("+R+")"),TAG:RegExp("^("+R.replace("w","w*")+")"),ATTR:RegExp("^"+$),PSEUDO:RegExp("^"+I),CHILD:RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+P+"*(even|odd|(([+-]|)(\\d*)n|)"+P+"*(?:([+-]|)"+P+"*(\\d+)|))"+P+"*\\)|)","i"),bool:RegExp("^(?:"+B+")$","i"),needsContext:RegExp("^"+P+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+P+"*((?:-\\d)?\\d*)"+P+"*\\)|)(?=[^-]|$)","i")},K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,et=/^(?:input|select|textarea|button)$/i,tt=/^h\d$/i,nt=/'|\\/g,rt=RegExp("\\\\([\\da-f]{1,6}"+P+"?|("+P+")|.)","ig"),it=function(e,t,n){var r="0x"+t-65536;return r!==r||n?t:0>r?String.fromCharCode(r+65536):String.fromCharCode(55296|r>>10,56320|1023&r)};try{M.apply(H=O.call(w.childNodes),w.childNodes),H[w.childNodes.length].nodeType}catch(ot){M={apply:H.length?function(e,t){_.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]);e.length=n-1}}}function at(e,t,n,i){var o,a,s,l,u,c,d,m,y,x;if((t?t.ownerDocument||t:w)!==f&&p(t),t=t||f,n=n||[],!e||"string"!=typeof e)return n;if(1!==(l=t.nodeType)&&9!==l)return[];if(h&&!i){if(o=Z.exec(e))if(s=o[1]){if(9===l){if(a=t.getElementById(s),!a||!a.parentNode)return n;if(a.id===s)return n.push(a),n}else if(t.ownerDocument&&(a=t.ownerDocument.getElementById(s))&&v(t,a)&&a.id===s)return n.push(a),n}else{if(o[2])return M.apply(n,t.getElementsByTagName(e)),n;if((s=o[3])&&r.getElementsByClassName&&t.getElementsByClassName)return M.apply(n,t.getElementsByClassName(s)),n}if(r.qsa&&(!g||!g.test(e))){if(m=d=b,y=t,x=9===l&&e,1===l&&"object"!==t.nodeName.toLowerCase()){c=mt(e),(d=t.getAttribute("id"))?m=d.replace(nt,"\\$&"):t.setAttribute("id",m),m="[id='"+m+"'] ",u=c.length;while(u--)c[u]=m+yt(c[u]);y=V.test(e)&&t.parentNode||t,x=c.join(",")}if(x)try{return M.apply(n,y.querySelectorAll(x)),n}catch(T){}finally{d||t.removeAttribute("id")}}}return kt(e.replace(z,"$1"),t,n,i)}function st(){var e=[];function t(n,r){return e.push(n+=" ")>o.cacheLength&&delete t[e.shift()],t[n]=r}return t}function lt(e){return e[b]=!0,e}function ut(e){var t=f.createElement("div");try{return!!e(t)}catch(n){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function ct(e,t){var n=e.split("|"),r=e.length;while(r--)o.attrHandle[n[r]]=t}function pt(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&(~t.sourceIndex||D)-(~e.sourceIndex||D);if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function ft(e){return function(t){var n=t.nodeName.toLowerCase();return"input"===n&&t.type===e}}function dt(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function ht(e){return lt(function(t){return t=+t,lt(function(n,r){var i,o=e([],n.length,t),a=o.length;while(a--)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))})})}s=at.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?"HTML"!==t.nodeName:!1},r=at.support={},p=at.setDocument=function(e){var n=e?e.ownerDocument||e:w,i=n.defaultView;return n!==f&&9===n.nodeType&&n.documentElement?(f=n,d=n.documentElement,h=!s(n),i&&i.attachEvent&&i!==i.top&&i.attachEvent("onbeforeunload",function(){p()}),r.attributes=ut(function(e){return e.className="i",!e.getAttribute("className")}),r.getElementsByTagName=ut(function(e){return e.appendChild(n.createComment("")),!e.getElementsByTagName("*").length}),r.getElementsByClassName=ut(function(e){return e.innerHTML="<div class='a'></div><div class='a i'></div>",e.firstChild.className="i",2===e.getElementsByClassName("i").length}),r.getById=ut(function(e){return d.appendChild(e).id=b,!n.getElementsByName||!n.getElementsByName(b).length}),r.getById?(o.find.ID=function(e,t){if(typeof t.getElementById!==j&&h){var n=t.getElementById(e);return n&&n.parentNode?[n]:[]}},o.filter.ID=function(e){var t=e.replace(rt,it);return function(e){return e.getAttribute("id")===t}}):(delete o.find.ID,o.filter.ID=function(e){var t=e.replace(rt,it);return function(e){var n=typeof e.getAttributeNode!==j&&e.getAttributeNode("id");return n&&n.value===t}}),o.find.TAG=r.getElementsByTagName?function(e,n){return typeof n.getElementsByTagName!==j?n.getElementsByTagName(e):t}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},o.find.CLASS=r.getElementsByClassName&&function(e,n){return typeof n.getElementsByClassName!==j&&h?n.getElementsByClassName(e):t},m=[],g=[],(r.qsa=K.test(n.querySelectorAll))&&(ut(function(e){e.innerHTML="<select><option selected=''></option></select>",e.querySelectorAll("[selected]").length||g.push("\\["+P+"*(?:value|"+B+")"),e.querySelectorAll(":checked").length||g.push(":checked")}),ut(function(e){var t=n.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("t",""),e.querySelectorAll("[t^='']").length&&g.push("[*^$]="+P+"*(?:''|\"\")"),e.querySelectorAll(":enabled").length||g.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),g.push(",.*:")})),(r.matchesSelector=K.test(y=d.webkitMatchesSelector||d.mozMatchesSelector||d.oMatchesSelector||d.msMatchesSelector))&&ut(function(e){r.disconnectedMatch=y.call(e,"div"),y.call(e,"[s!='']:x"),m.push("!=",I)}),g=g.length&&RegExp(g.join("|")),m=m.length&&RegExp(m.join("|")),v=K.test(d.contains)||d.compareDocumentPosition?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},A=d.compareDocumentPosition?function(e,t){if(e===t)return S=!0,0;var i=t.compareDocumentPosition&&e.compareDocumentPosition&&e.compareDocumentPosition(t);return i?1&i||!r.sortDetached&&t.compareDocumentPosition(e)===i?e===n||v(w,e)?-1:t===n||v(w,t)?1:c?F.call(c,e)-F.call(c,t):0:4&i?-1:1:e.compareDocumentPosition?-1:1}:function(e,t){var r,i=0,o=e.parentNode,a=t.parentNode,s=[e],l=[t];if(e===t)return S=!0,0;if(!o||!a)return e===n?-1:t===n?1:o?-1:a?1:c?F.call(c,e)-F.call(c,t):0;if(o===a)return pt(e,t);r=e;while(r=r.parentNode)s.unshift(r);r=t;while(r=r.parentNode)l.unshift(r);while(s[i]===l[i])i++;return i?pt(s[i],l[i]):s[i]===w?-1:l[i]===w?1:0},n):f},at.matches=function(e,t){return at(e,null,null,t)},at.matchesSelector=function(e,t){if((e.ownerDocument||e)!==f&&p(e),t=t.replace(Y,"='$1']"),!(!r.matchesSelector||!h||m&&m.test(t)||g&&g.test(t)))try{var n=y.call(e,t);if(n||r.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(i){}return at(t,f,null,[e]).length>0},at.contains=function(e,t){return(e.ownerDocument||e)!==f&&p(e),v(e,t)},at.attr=function(e,n){(e.ownerDocument||e)!==f&&p(e);var i=o.attrHandle[n.toLowerCase()],a=i&&L.call(o.attrHandle,n.toLowerCase())?i(e,n,!h):t;return a===t?r.attributes||!h?e.getAttribute(n):(a=e.getAttributeNode(n))&&a.specified?a.value:null:a},at.error=function(e){throw Error("Syntax error, unrecognized expression: "+e)},at.uniqueSort=function(e){var t,n=[],i=0,o=0;if(S=!r.detectDuplicates,c=!r.sortStable&&e.slice(0),e.sort(A),S){while(t=e[o++])t===e[o]&&(i=n.push(o));while(i--)e.splice(n[i],1)}return e},a=at.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=a(e)}else if(3===i||4===i)return e.nodeValue}else for(;t=e[r];r++)n+=a(t);return n},o=at.selectors={cacheLength:50,createPseudo:lt,match:Q,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(rt,it),e[3]=(e[4]||e[5]||"").replace(rt,it),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||at.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&at.error(e[0]),e},PSEUDO:function(e){var n,r=!e[5]&&e[2];return Q.CHILD.test(e[0])?null:(e[3]&&e[4]!==t?e[2]=e[4]:r&&J.test(r)&&(n=mt(r,!0))&&(n=r.indexOf(")",r.length-n)-r.length)&&(e[0]=e[0].slice(0,n),e[2]=r.slice(0,n)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(rt,it).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=N[e+" "];return t||(t=RegExp("(^|"+P+")"+e+"("+P+"|$)"))&&N(e,function(e){return t.test("string"==typeof e.className&&e.className||typeof e.getAttribute!==j&&e.getAttribute("class")||"")})},ATTR:function(e,t,n){return function(r){var i=at.attr(r,e);return null==i?"!="===t:t?(i+="","="===t?i===n:"!="===t?i!==n:"^="===t?n&&0===i.indexOf(n):"*="===t?n&&i.indexOf(n)>-1:"$="===t?n&&i.slice(-n.length)===n:"~="===t?(" "+i+" ").indexOf(n)>-1:"|="===t?i===n||i.slice(0,n.length+1)===n+"-":!1):!0}},CHILD:function(e,t,n,r,i){var o="nth"!==e.slice(0,3),a="last"!==e.slice(-4),s="of-type"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,l){var u,c,p,f,d,h,g=o!==a?"nextSibling":"previousSibling",m=t.parentNode,y=s&&t.nodeName.toLowerCase(),v=!l&&!s;if(m){if(o){while(g){p=t;while(p=p[g])if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g="only"===e&&!h&&"nextSibling"}return!0}if(h=[a?m.firstChild:m.lastChild],a&&v){c=m[b]||(m[b]={}),u=c[e]||[],d=u[0]===T&&u[1],f=u[0]===T&&u[2],p=d&&m.childNodes[d];while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if(1===p.nodeType&&++f&&p===t){c[e]=[T,d,f];break}}else if(v&&(u=(t[b]||(t[b]={}))[e])&&u[0]===T)f=u[1];else while(p=++d&&p&&p[g]||(f=d=0)||h.pop())if((s?p.nodeName.toLowerCase()===y:1===p.nodeType)&&++f&&(v&&((p[b]||(p[b]={}))[e]=[T,f]),p===t))break;return f-=i,f===r||0===f%r&&f/r>=0}}},PSEUDO:function(e,t){var n,r=o.pseudos[e]||o.setFilters[e.toLowerCase()]||at.error("unsupported pseudo: "+e);return r[b]?r(t):r.length>1?(n=[e,e,"",t],o.setFilters.hasOwnProperty(e.toLowerCase())?lt(function(e,n){var i,o=r(e,t),a=o.length;while(a--)i=F.call(e,o[a]),e[i]=!(n[i]=o[a])}):function(e){return r(e,0,n)}):r}},pseudos:{not:lt(function(e){var t=[],n=[],r=l(e.replace(z,"$1"));return r[b]?lt(function(e,t,n,i){var o,a=r(e,null,i,[]),s=e.length;while(s--)(o=a[s])&&(e[s]=!(t[s]=o))}):function(e,i,o){return t[0]=e,r(t,null,o,n),!n.pop()}}),has:lt(function(e){return function(t){return at(e,t).length>0}}),contains:lt(function(e){return function(t){return(t.textContent||t.innerText||a(t)).indexOf(e)>-1}}),lang:lt(function(e){return G.test(e||"")||at.error("unsupported lang: "+e),e=e.replace(rt,it).toLowerCase(),function(t){var n;do if(n=h?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return n=n.toLowerCase(),n===e||0===n.indexOf(e+"-");while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===d},focus:function(e){return e===f.activeElement&&(!f.hasFocus||f.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeName>"@"||3===e.nodeType||4===e.nodeType)return!1;return!0},parent:function(e){return!o.pseudos.empty(e)},header:function(e){return tt.test(e.nodeName)},input:function(e){return et.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||t.toLowerCase()===e.type)},first:ht(function(){return[0]}),last:ht(function(e,t){return[t-1]}),eq:ht(function(e,t,n){return[0>n?n+t:n]}),even:ht(function(e,t){var n=0;for(;t>n;n+=2)e.push(n);return e}),odd:ht(function(e,t){var n=1;for(;t>n;n+=2)e.push(n);return e}),lt:ht(function(e,t,n){var r=0>n?n+t:n;for(;--r>=0;)e.push(r);return e}),gt:ht(function(e,t,n){var r=0>n?n+t:n;for(;t>++r;)e.push(r);return e})}},o.pseudos.nth=o.pseudos.eq;for(n in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})o.pseudos[n]=ft(n);for(n in{submit:!0,reset:!0})o.pseudos[n]=dt(n);function gt(){}gt.prototype=o.filters=o.pseudos,o.setFilters=new gt;function mt(e,t){var n,r,i,a,s,l,u,c=k[e+" "];if(c)return t?0:c.slice(0);s=e,l=[],u=o.preFilter;while(s){(!n||(r=X.exec(s)))&&(r&&(s=s.slice(r[0].length)||s),l.push(i=[])),n=!1,(r=U.exec(s))&&(n=r.shift(),i.push({value:n,type:r[0].replace(z," ")}),s=s.slice(n.length));for(a in o.filter)!(r=Q[a].exec(s))||u[a]&&!(r=u[a](r))||(n=r.shift(),i.push({value:n,type:a,matches:r}),s=s.slice(n.length));if(!n)break}return t?s.length:s?at.error(e):k(e,l).slice(0)}function yt(e){var t=0,n=e.length,r="";for(;n>t;t++)r+=e[t].value;return r}function vt(e,t,n){var r=t.dir,o=n&&"parentNode"===r,a=C++;return t.first?function(t,n,i){while(t=t[r])if(1===t.nodeType||o)return e(t,n,i)}:function(t,n,s){var l,u,c,p=T+" "+a;if(s){while(t=t[r])if((1===t.nodeType||o)&&e(t,n,s))return!0}else while(t=t[r])if(1===t.nodeType||o)if(c=t[b]||(t[b]={}),(u=c[r])&&u[0]===p){if((l=u[1])===!0||l===i)return l===!0}else if(u=c[r]=[p],u[1]=e(t,n,s)||i,u[1]===!0)return!0}}function bt(e){return e.length>1?function(t,n,r){var i=e.length;while(i--)if(!e[i](t,n,r))return!1;return!0}:e[0]}function xt(e,t,n,r,i){var o,a=[],s=0,l=e.length,u=null!=t;for(;l>s;s++)(o=e[s])&&(!n||n(o,r,i))&&(a.push(o),u&&t.push(s));return a}function wt(e,t,n,r,i,o){return r&&!r[b]&&(r=wt(r)),i&&!i[b]&&(i=wt(i,o)),lt(function(o,a,s,l){var u,c,p,f=[],d=[],h=a.length,g=o||Nt(t||"*",s.nodeType?[s]:s,[]),m=!e||!o&&t?g:xt(g,f,e,s,l),y=n?i||(o?e:h||r)?[]:a:m;if(n&&n(m,y,s,l),r){u=xt(y,d),r(u,[],s,l),c=u.length;while(c--)(p=u[c])&&(y[d[c]]=!(m[d[c]]=p))}if(o){if(i||e){if(i){u=[],c=y.length;while(c--)(p=y[c])&&u.push(m[c]=p);i(null,y=[],u,l)}c=y.length;while(c--)(p=y[c])&&(u=i?F.call(o,p):f[c])>-1&&(o[u]=!(a[u]=p))}}else y=xt(y===a?y.splice(h,y.length):y),i?i(null,a,y,l):M.apply(a,y)})}function Tt(e){var t,n,r,i=e.length,a=o.relative[e[0].type],s=a||o.relative[" "],l=a?1:0,c=vt(function(e){return e===t},s,!0),p=vt(function(e){return F.call(t,e)>-1},s,!0),f=[function(e,n,r){return!a&&(r||n!==u)||((t=n).nodeType?c(e,n,r):p(e,n,r))}];for(;i>l;l++)if(n=o.relative[e[l].type])f=[vt(bt(f),n)];else{if(n=o.filter[e[l].type].apply(null,e[l].matches),n[b]){for(r=++l;i>r;r++)if(o.relative[e[r].type])break;return wt(l>1&&bt(f),l>1&&yt(e.slice(0,l-1).concat({value:" "===e[l-2].type?"*":""})).replace(z,"$1"),n,r>l&&Tt(e.slice(l,r)),i>r&&Tt(e=e.slice(r)),i>r&&yt(e))}f.push(n)}return bt(f)}function Ct(e,t){var n=0,r=t.length>0,a=e.length>0,s=function(s,l,c,p,d){var h,g,m,y=[],v=0,b="0",x=s&&[],w=null!=d,C=u,N=s||a&&o.find.TAG("*",d&&l.parentNode||l),k=T+=null==C?1:Math.random()||.1;for(w&&(u=l!==f&&l,i=n);null!=(h=N[b]);b++){if(a&&h){g=0;while(m=e[g++])if(m(h,l,c)){p.push(h);break}w&&(T=k,i=++n)}r&&((h=!m&&h)&&v--,s&&x.push(h))}if(v+=b,r&&b!==v){g=0;while(m=t[g++])m(x,y,l,c);if(s){if(v>0)while(b--)x[b]||y[b]||(y[b]=q.call(p));y=xt(y)}M.apply(p,y),w&&!s&&y.length>0&&v+t.length>1&&at.uniqueSort(p)}return w&&(T=k,u=C),x};return r?lt(s):s}l=at.compile=function(e,t){var n,r=[],i=[],o=E[e+" "];if(!o){t||(t=mt(e)),n=t.length;while(n--)o=Tt(t[n]),o[b]?r.push(o):i.push(o);o=E(e,Ct(i,r))}return o};function Nt(e,t,n){var r=0,i=t.length;for(;i>r;r++)at(e,t[r],n);return n}function kt(e,t,n,i){var a,s,u,c,p,f=mt(e);if(!i&&1===f.length){if(s=f[0]=f[0].slice(0),s.length>2&&"ID"===(u=s[0]).type&&r.getById&&9===t.nodeType&&h&&o.relative[s[1].type]){if(t=(o.find.ID(u.matches[0].replace(rt,it),t)||[])[0],!t)return n;e=e.slice(s.shift().value.length)}a=Q.needsContext.test(e)?0:s.length;while(a--){if(u=s[a],o.relative[c=u.type])break;if((p=o.find[c])&&(i=p(u.matches[0].replace(rt,it),V.test(s[0].type)&&t.parentNode||t))){if(s.splice(a,1),e=i.length&&yt(s),!e)return M.apply(n,i),n;break}}}return l(e,f)(i,t,!h,n,V.test(e)),n}r.sortStable=b.split("").sort(A).join("")===b,r.detectDuplicates=S,p(),r.sortDetached=ut(function(e){return 1&e.compareDocumentPosition(f.createElement("div"))}),ut(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||ct("type|href|height|width",function(e,n,r){return r?t:e.getAttribute(n,"type"===n.toLowerCase()?1:2)}),r.attributes&&ut(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||ct("value",function(e,n,r){return r||"input"!==e.nodeName.toLowerCase()?t:e.defaultValue}),ut(function(e){return null==e.getAttribute("disabled")})||ct(B,function(e,n,r){var i;return r?t:(i=e.getAttributeNode(n))&&i.specified?i.value:e[n]===!0?n.toLowerCase():null}),x.find=at,x.expr=at.selectors,x.expr[":"]=x.expr.pseudos,x.unique=at.uniqueSort,x.text=at.getText,x.isXMLDoc=at.isXML,x.contains=at.contains}(e);var O={};function F(e){var t=O[e]={};return x.each(e.match(T)||[],function(e,n){t[n]=!0}),t}x.Callbacks=function(e){e="string"==typeof e?O[e]||F(e):x.extend({},e);var n,r,i,o,a,s,l=[],u=!e.once&&[],c=function(t){for(r=e.memory&&t,i=!0,a=s||0,s=0,o=l.length,n=!0;l&&o>a;a++)if(l[a].apply(t[0],t[1])===!1&&e.stopOnFalse){r=!1;break}n=!1,l&&(u?u.length&&c(u.shift()):r?l=[]:p.disable())},p={add:function(){if(l){var t=l.length;(function i(t){x.each(t,function(t,n){var r=x.type(n);"function"===r?e.unique&&p.has(n)||l.push(n):n&&n.length&&"string"!==r&&i(n)})})(arguments),n?o=l.length:r&&(s=t,c(r))}return this},remove:function(){return l&&x.each(arguments,function(e,t){var r;while((r=x.inArray(t,l,r))>-1)l.splice(r,1),n&&(o>=r&&o--,a>=r&&a--)}),this},has:function(e){return e?x.inArray(e,l)>-1:!(!l||!l.length)},empty:function(){return l=[],o=0,this},disable:function(){return l=u=r=t,this},disabled:function(){return!l},lock:function(){return u=t,r||p.disable(),this},locked:function(){return!u},fireWith:function(e,t){return!l||i&&!u||(t=t||[],t=[e,t.slice?t.slice():t],n?u.push(t):c(t)),this},fire:function(){return p.fireWith(this,arguments),this},fired:function(){return!!i}};return p},x.extend({Deferred:function(e){var t=[["resolve","done",x.Callbacks("once memory"),"resolved"],["reject","fail",x.Callbacks("once memory"),"rejected"],["notify","progress",x.Callbacks("memory")]],n="pending",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return x.Deferred(function(n){x.each(t,function(t,o){var a=o[0],s=x.isFunction(e[t])&&e[t];i[o[1]](function(){var e=s&&s.apply(this,arguments);e&&x.isFunction(e.promise)?e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[a+"With"](this===r?n.promise():this,s?[e]:arguments)})}),e=null}).promise()},promise:function(e){return null!=e?x.extend(e,r):r}},i={};return r.pipe=r.then,x.each(t,function(e,o){var a=o[2],s=o[3];r[o[1]]=a.add,s&&a.add(function(){n=s},t[1^e][2].disable,t[2][2].lock),i[o[0]]=function(){return i[o[0]+"With"](this===i?r:this,arguments),this},i[o[0]+"With"]=a.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t=0,n=g.call(arguments),r=n.length,i=1!==r||e&&x.isFunction(e.promise)?r:0,o=1===i?e:x.Deferred(),a=function(e,t,n){return function(r){t[e]=this,n[e]=arguments.length>1?g.call(arguments):r,n===s?o.notifyWith(t,n):--i||o.resolveWith(t,n)}},s,l,u;if(r>1)for(s=Array(r),l=Array(r),u=Array(r);r>t;t++)n[t]&&x.isFunction(n[t].promise)?n[t].promise().done(a(t,u,n)).fail(o.reject).progress(a(t,l,s)):--i;return i||o.resolveWith(u,n),o.promise()}}),x.support=function(t){var n,r,o,s,l,u,c,p,f,d=a.createElement("div");if(d.setAttribute("className","t"),d.innerHTML="  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>",n=d.getElementsByTagName("*")||[],r=d.getElementsByTagName("a")[0],!r||!r.style||!n.length)return t;s=a.createElement("select"),u=s.appendChild(a.createElement("option")),o=d.getElementsByTagName("input")[0],r.style.cssText="top:1px;float:left;opacity:.5",t.getSetAttribute="t"!==d.className,t.leadingWhitespace=3===d.firstChild.nodeType,t.tbody=!d.getElementsByTagName("tbody").length,t.htmlSerialize=!!d.getElementsByTagName("link").length,t.style=/top/.test(r.getAttribute("style")),t.hrefNormalized="/a"===r.getAttribute("href"),t.opacity=/^0.5/.test(r.style.opacity),t.cssFloat=!!r.style.cssFloat,t.checkOn=!!o.value,t.optSelected=u.selected,t.enctype=!!a.createElement("form").enctype,t.html5Clone="<:nav></:nav>"!==a.createElement("nav").cloneNode(!0).outerHTML,t.inlineBlockNeedsLayout=!1,t.shrinkWrapBlocks=!1,t.pixelPosition=!1,t.deleteExpando=!0,t.noCloneEvent=!0,t.reliableMarginRight=!0,t.boxSizingReliable=!0,o.checked=!0,t.noCloneChecked=o.cloneNode(!0).checked,s.disabled=!0,t.optDisabled=!u.disabled;try{delete d.test}catch(h){t.deleteExpando=!1}o=a.createElement("input"),o.setAttribute("value",""),t.input=""===o.getAttribute("value"),o.value="t",o.setAttribute("type","radio"),t.radioValue="t"===o.value,o.setAttribute("checked","t"),o.setAttribute("name","t"),l=a.createDocumentFragment(),l.appendChild(o),t.appendChecked=o.checked,t.checkClone=l.cloneNode(!0).cloneNode(!0).lastChild.checked,d.attachEvent&&(d.attachEvent("onclick",function(){t.noCloneEvent=!1}),d.cloneNode(!0).click());for(f in{submit:!0,change:!0,focusin:!0})d.setAttribute(c="on"+f,"t"),t[f+"Bubbles"]=c in e||d.attributes[c].expando===!1;d.style.backgroundClip="content-box",d.cloneNode(!0).style.backgroundClip="",t.clearCloneStyle="content-box"===d.style.backgroundClip;for(f in x(t))break;return t.ownLast="0"!==f,x(function(){var n,r,o,s="padding:0;margin:0;border:0;display:block;box-sizing:content-box;-moz-box-sizing:content-box;-webkit-box-sizing:content-box;",l=a.getElementsByTagName("body")[0];l&&(n=a.createElement("div"),n.style.cssText="border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px",l.appendChild(n).appendChild(d),d.innerHTML="<table><tr><td></td><td>t</td></tr></table>",o=d.getElementsByTagName("td"),o[0].style.cssText="padding:0;margin:0;border:0;display:none",p=0===o[0].offsetHeight,o[0].style.display="",o[1].style.display="none",t.reliableHiddenOffsets=p&&0===o[0].offsetHeight,d.innerHTML="",d.style.cssText="box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;",x.swap(l,null!=l.style.zoom?{zoom:1}:{},function(){t.boxSizing=4===d.offsetWidth}),e.getComputedStyle&&(t.pixelPosition="1%"!==(e.getComputedStyle(d,null)||{}).top,t.boxSizingReliable="4px"===(e.getComputedStyle(d,null)||{width:"4px"}).width,r=d.appendChild(a.createElement("div")),r.style.cssText=d.style.cssText=s,r.style.marginRight=r.style.width="0",d.style.width="1px",t.reliableMarginRight=!parseFloat((e.getComputedStyle(r,null)||{}).marginRight)),typeof d.style.zoom!==i&&(d.innerHTML="",d.style.cssText=s+"width:1px;padding:1px;display:inline;zoom:1",t.inlineBlockNeedsLayout=3===d.offsetWidth,d.style.display="block",d.innerHTML="<div></div>",d.firstChild.style.width="5px",t.shrinkWrapBlocks=3!==d.offsetWidth,t.inlineBlockNeedsLayout&&(l.style.zoom=1)),l.removeChild(n),n=d=o=r=null)}),n=s=l=u=r=o=null,t
}({});var B=/(?:\{[\s\S]*\}|\[[\s\S]*\])$/,P=/([A-Z])/g;function R(e,n,r,i){if(x.acceptData(e)){var o,a,s=x.expando,l=e.nodeType,u=l?x.cache:e,c=l?e[s]:e[s]&&s;if(c&&u[c]&&(i||u[c].data)||r!==t||"string"!=typeof n)return c||(c=l?e[s]=p.pop()||x.guid++:s),u[c]||(u[c]=l?{}:{toJSON:x.noop}),("object"==typeof n||"function"==typeof n)&&(i?u[c]=x.extend(u[c],n):u[c].data=x.extend(u[c].data,n)),a=u[c],i||(a.data||(a.data={}),a=a.data),r!==t&&(a[x.camelCase(n)]=r),"string"==typeof n?(o=a[n],null==o&&(o=a[x.camelCase(n)])):o=a,o}}function W(e,t,n){if(x.acceptData(e)){var r,i,o=e.nodeType,a=o?x.cache:e,s=o?e[x.expando]:x.expando;if(a[s]){if(t&&(r=n?a[s]:a[s].data)){x.isArray(t)?t=t.concat(x.map(t,x.camelCase)):t in r?t=[t]:(t=x.camelCase(t),t=t in r?[t]:t.split(" ")),i=t.length;while(i--)delete r[t[i]];if(n?!I(r):!x.isEmptyObject(r))return}(n||(delete a[s].data,I(a[s])))&&(o?x.cleanData([e],!0):x.support.deleteExpando||a!=a.window?delete a[s]:a[s]=null)}}}x.extend({cache:{},noData:{applet:!0,embed:!0,object:"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"},hasData:function(e){return e=e.nodeType?x.cache[e[x.expando]]:e[x.expando],!!e&&!I(e)},data:function(e,t,n){return R(e,t,n)},removeData:function(e,t){return W(e,t)},_data:function(e,t,n){return R(e,t,n,!0)},_removeData:function(e,t){return W(e,t,!0)},acceptData:function(e){if(e.nodeType&&1!==e.nodeType&&9!==e.nodeType)return!1;var t=e.nodeName&&x.noData[e.nodeName.toLowerCase()];return!t||t!==!0&&e.getAttribute("classid")===t}}),x.fn.extend({data:function(e,n){var r,i,o=null,a=0,s=this[0];if(e===t){if(this.length&&(o=x.data(s),1===s.nodeType&&!x._data(s,"parsedAttrs"))){for(r=s.attributes;r.length>a;a++)i=r[a].name,0===i.indexOf("data-")&&(i=x.camelCase(i.slice(5)),$(s,i,o[i]));x._data(s,"parsedAttrs",!0)}return o}return"object"==typeof e?this.each(function(){x.data(this,e)}):arguments.length>1?this.each(function(){x.data(this,e,n)}):s?$(s,e,x.data(s,e)):null},removeData:function(e){return this.each(function(){x.removeData(this,e)})}});function $(e,n,r){if(r===t&&1===e.nodeType){var i="data-"+n.replace(P,"-$1").toLowerCase();if(r=e.getAttribute(i),"string"==typeof r){try{r="true"===r?!0:"false"===r?!1:"null"===r?null:+r+""===r?+r:B.test(r)?x.parseJSON(r):r}catch(o){}x.data(e,n,r)}else r=t}return r}function I(e){var t;for(t in e)if(("data"!==t||!x.isEmptyObject(e[t]))&&"toJSON"!==t)return!1;return!0}x.extend({queue:function(e,n,r){var i;return e?(n=(n||"fx")+"queue",i=x._data(e,n),r&&(!i||x.isArray(r)?i=x._data(e,n,x.makeArray(r)):i.push(r)),i||[]):t},dequeue:function(e,t){t=t||"fx";var n=x.queue(e,t),r=n.length,i=n.shift(),o=x._queueHooks(e,t),a=function(){x.dequeue(e,t)};"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,a,o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return x._data(e,n)||x._data(e,n,{empty:x.Callbacks("once memory").add(function(){x._removeData(e,t+"queue"),x._removeData(e,n)})})}}),x.fn.extend({queue:function(e,n){var r=2;return"string"!=typeof e&&(n=e,e="fx",r--),r>arguments.length?x.queue(this[0],e):n===t?this:this.each(function(){var t=x.queue(this,e,n);x._queueHooks(this,e),"fx"===e&&"inprogress"!==t[0]&&x.dequeue(this,e)})},dequeue:function(e){return this.each(function(){x.dequeue(this,e)})},delay:function(e,t){return e=x.fx?x.fx.speeds[e]||e:e,t=t||"fx",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,n){var r,i=1,o=x.Deferred(),a=this,s=this.length,l=function(){--i||o.resolveWith(a,[a])};"string"!=typeof e&&(n=e,e=t),e=e||"fx";while(s--)r=x._data(a[s],e+"queueHooks"),r&&r.empty&&(i++,r.empty.add(l));return l(),o.promise(n)}});var z,X,U=/[\t\r\n\f]/g,V=/\r/g,Y=/^(?:input|select|textarea|button|object)$/i,J=/^(?:a|area)$/i,G=/^(?:checked|selected)$/i,Q=x.support.getSetAttribute,K=x.support.input;x.fn.extend({attr:function(e,t){return x.access(this,x.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){x.removeAttr(this,e)})},prop:function(e,t){return x.access(this,x.prop,e,t,arguments.length>1)},removeProp:function(e){return e=x.propFix[e]||e,this.each(function(){try{this[e]=t,delete this[e]}catch(n){}})},addClass:function(e){var t,n,r,i,o,a=0,s=this.length,l="string"==typeof e&&e;if(x.isFunction(e))return this.each(function(t){x(this).addClass(e.call(this,t,this.className))});if(l)for(t=(e||"").match(T)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(" "+n.className+" ").replace(U," "):" ")){o=0;while(i=t[o++])0>r.indexOf(" "+i+" ")&&(r+=i+" ");n.className=x.trim(r)}return this},removeClass:function(e){var t,n,r,i,o,a=0,s=this.length,l=0===arguments.length||"string"==typeof e&&e;if(x.isFunction(e))return this.each(function(t){x(this).removeClass(e.call(this,t,this.className))});if(l)for(t=(e||"").match(T)||[];s>a;a++)if(n=this[a],r=1===n.nodeType&&(n.className?(" "+n.className+" ").replace(U," "):"")){o=0;while(i=t[o++])while(r.indexOf(" "+i+" ")>=0)r=r.replace(" "+i+" "," ");n.className=e?x.trim(r):""}return this},toggleClass:function(e,t){var n=typeof e;return"boolean"==typeof t&&"string"===n?t?this.addClass(e):this.removeClass(e):x.isFunction(e)?this.each(function(n){x(this).toggleClass(e.call(this,n,this.className,t),t)}):this.each(function(){if("string"===n){var t,r=0,o=x(this),a=e.match(T)||[];while(t=a[r++])o.hasClass(t)?o.removeClass(t):o.addClass(t)}else(n===i||"boolean"===n)&&(this.className&&x._data(this,"__className__",this.className),this.className=this.className||e===!1?"":x._data(this,"__className__")||"")})},hasClass:function(e){var t=" "+e+" ",n=0,r=this.length;for(;r>n;n++)if(1===this[n].nodeType&&(" "+this[n].className+" ").replace(U," ").indexOf(t)>=0)return!0;return!1},val:function(e){var n,r,i,o=this[0];{if(arguments.length)return i=x.isFunction(e),this.each(function(n){var o;1===this.nodeType&&(o=i?e.call(this,n,x(this).val()):e,null==o?o="":"number"==typeof o?o+="":x.isArray(o)&&(o=x.map(o,function(e){return null==e?"":e+""})),r=x.valHooks[this.type]||x.valHooks[this.nodeName.toLowerCase()],r&&"set"in r&&r.set(this,o,"value")!==t||(this.value=o))});if(o)return r=x.valHooks[o.type]||x.valHooks[o.nodeName.toLowerCase()],r&&"get"in r&&(n=r.get(o,"value"))!==t?n:(n=o.value,"string"==typeof n?n.replace(V,""):null==n?"":n)}}}),x.extend({valHooks:{option:{get:function(e){var t=x.find.attr(e,"value");return null!=t?t:e.text}},select:{get:function(e){var t,n,r=e.options,i=e.selectedIndex,o="select-one"===e.type||0>i,a=o?null:[],s=o?i+1:r.length,l=0>i?s:o?i:0;for(;s>l;l++)if(n=r[l],!(!n.selected&&l!==i||(x.support.optDisabled?n.disabled:null!==n.getAttribute("disabled"))||n.parentNode.disabled&&x.nodeName(n.parentNode,"optgroup"))){if(t=x(n).val(),o)return t;a.push(t)}return a},set:function(e,t){var n,r,i=e.options,o=x.makeArray(t),a=i.length;while(a--)r=i[a],(r.selected=x.inArray(x(r).val(),o)>=0)&&(n=!0);return n||(e.selectedIndex=-1),o}}},attr:function(e,n,r){var o,a,s=e.nodeType;if(e&&3!==s&&8!==s&&2!==s)return typeof e.getAttribute===i?x.prop(e,n,r):(1===s&&x.isXMLDoc(e)||(n=n.toLowerCase(),o=x.attrHooks[n]||(x.expr.match.bool.test(n)?X:z)),r===t?o&&"get"in o&&null!==(a=o.get(e,n))?a:(a=x.find.attr(e,n),null==a?t:a):null!==r?o&&"set"in o&&(a=o.set(e,r,n))!==t?a:(e.setAttribute(n,r+""),r):(x.removeAttr(e,n),t))},removeAttr:function(e,t){var n,r,i=0,o=t&&t.match(T);if(o&&1===e.nodeType)while(n=o[i++])r=x.propFix[n]||n,x.expr.match.bool.test(n)?K&&Q||!G.test(n)?e[r]=!1:e[x.camelCase("default-"+n)]=e[r]=!1:x.attr(e,n,""),e.removeAttribute(Q?n:r)},attrHooks:{type:{set:function(e,t){if(!x.support.radioValue&&"radio"===t&&x.nodeName(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},propFix:{"for":"htmlFor","class":"className"},prop:function(e,n,r){var i,o,a,s=e.nodeType;if(e&&3!==s&&8!==s&&2!==s)return a=1!==s||!x.isXMLDoc(e),a&&(n=x.propFix[n]||n,o=x.propHooks[n]),r!==t?o&&"set"in o&&(i=o.set(e,r,n))!==t?i:e[n]=r:o&&"get"in o&&null!==(i=o.get(e,n))?i:e[n]},propHooks:{tabIndex:{get:function(e){var t=x.find.attr(e,"tabindex");return t?parseInt(t,10):Y.test(e.nodeName)||J.test(e.nodeName)&&e.href?0:-1}}}}),X={set:function(e,t,n){return t===!1?x.removeAttr(e,n):K&&Q||!G.test(n)?e.setAttribute(!Q&&x.propFix[n]||n,n):e[x.camelCase("default-"+n)]=e[n]=!0,n}},x.each(x.expr.match.bool.source.match(/\w+/g),function(e,n){var r=x.expr.attrHandle[n]||x.find.attr;x.expr.attrHandle[n]=K&&Q||!G.test(n)?function(e,n,i){var o=x.expr.attrHandle[n],a=i?t:(x.expr.attrHandle[n]=t)!=r(e,n,i)?n.toLowerCase():null;return x.expr.attrHandle[n]=o,a}:function(e,n,r){return r?t:e[x.camelCase("default-"+n)]?n.toLowerCase():null}}),K&&Q||(x.attrHooks.value={set:function(e,n,r){return x.nodeName(e,"input")?(e.defaultValue=n,t):z&&z.set(e,n,r)}}),Q||(z={set:function(e,n,r){var i=e.getAttributeNode(r);return i||e.setAttributeNode(i=e.ownerDocument.createAttribute(r)),i.value=n+="","value"===r||n===e.getAttribute(r)?n:t}},x.expr.attrHandle.id=x.expr.attrHandle.name=x.expr.attrHandle.coords=function(e,n,r){var i;return r?t:(i=e.getAttributeNode(n))&&""!==i.value?i.value:null},x.valHooks.button={get:function(e,n){var r=e.getAttributeNode(n);return r&&r.specified?r.value:t},set:z.set},x.attrHooks.contenteditable={set:function(e,t,n){z.set(e,""===t?!1:t,n)}},x.each(["width","height"],function(e,n){x.attrHooks[n]={set:function(e,r){return""===r?(e.setAttribute(n,"auto"),r):t}}})),x.support.hrefNormalized||x.each(["href","src"],function(e,t){x.propHooks[t]={get:function(e){return e.getAttribute(t,4)}}}),x.support.style||(x.attrHooks.style={get:function(e){return e.style.cssText||t},set:function(e,t){return e.style.cssText=t+""}}),x.support.optSelected||(x.propHooks.selected={get:function(e){var t=e.parentNode;return t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex),null}}),x.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){x.propFix[this.toLowerCase()]=this}),x.support.enctype||(x.propFix.enctype="encoding"),x.each(["radio","checkbox"],function(){x.valHooks[this]={set:function(e,n){return x.isArray(n)?e.checked=x.inArray(x(e).val(),n)>=0:t}},x.support.checkOn||(x.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})});var Z=/^(?:input|select|textarea)$/i,et=/^key/,tt=/^(?:mouse|contextmenu)|click/,nt=/^(?:focusinfocus|focusoutblur)$/,rt=/^([^.]*)(?:\.(.+)|)$/;function it(){return!0}function ot(){return!1}function at(){try{return a.activeElement}catch(e){}}x.event={global:{},add:function(e,n,r,o,a){var s,l,u,c,p,f,d,h,g,m,y,v=x._data(e);if(v){r.handler&&(c=r,r=c.handler,a=c.selector),r.guid||(r.guid=x.guid++),(l=v.events)||(l=v.events={}),(f=v.handle)||(f=v.handle=function(e){return typeof x===i||e&&x.event.triggered===e.type?t:x.event.dispatch.apply(f.elem,arguments)},f.elem=e),n=(n||"").match(T)||[""],u=n.length;while(u--)s=rt.exec(n[u])||[],g=y=s[1],m=(s[2]||"").split(".").sort(),g&&(p=x.event.special[g]||{},g=(a?p.delegateType:p.bindType)||g,p=x.event.special[g]||{},d=x.extend({type:g,origType:y,data:o,handler:r,guid:r.guid,selector:a,needsContext:a&&x.expr.match.needsContext.test(a),namespace:m.join(".")},c),(h=l[g])||(h=l[g]=[],h.delegateCount=0,p.setup&&p.setup.call(e,o,m,f)!==!1||(e.addEventListener?e.addEventListener(g,f,!1):e.attachEvent&&e.attachEvent("on"+g,f))),p.add&&(p.add.call(e,d),d.handler.guid||(d.handler.guid=r.guid)),a?h.splice(h.delegateCount++,0,d):h.push(d),x.event.global[g]=!0);e=null}},remove:function(e,t,n,r,i){var o,a,s,l,u,c,p,f,d,h,g,m=x.hasData(e)&&x._data(e);if(m&&(c=m.events)){t=(t||"").match(T)||[""],u=t.length;while(u--)if(s=rt.exec(t[u])||[],d=g=s[1],h=(s[2]||"").split(".").sort(),d){p=x.event.special[d]||{},d=(r?p.delegateType:p.bindType)||d,f=c[d]||[],s=s[2]&&RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),l=o=f.length;while(o--)a=f[o],!i&&g!==a.origType||n&&n.guid!==a.guid||s&&!s.test(a.namespace)||r&&r!==a.selector&&("**"!==r||!a.selector)||(f.splice(o,1),a.selector&&f.delegateCount--,p.remove&&p.remove.call(e,a));l&&!f.length&&(p.teardown&&p.teardown.call(e,h,m.handle)!==!1||x.removeEvent(e,d,m.handle),delete c[d])}else for(d in c)x.event.remove(e,d+t[u],n,r,!0);x.isEmptyObject(c)&&(delete m.handle,x._removeData(e,"events"))}},trigger:function(n,r,i,o){var s,l,u,c,p,f,d,h=[i||a],g=v.call(n,"type")?n.type:n,m=v.call(n,"namespace")?n.namespace.split("."):[];if(u=f=i=i||a,3!==i.nodeType&&8!==i.nodeType&&!nt.test(g+x.event.triggered)&&(g.indexOf(".")>=0&&(m=g.split("."),g=m.shift(),m.sort()),l=0>g.indexOf(":")&&"on"+g,n=n[x.expando]?n:new x.Event(g,"object"==typeof n&&n),n.isTrigger=o?2:3,n.namespace=m.join("."),n.namespace_re=n.namespace?RegExp("(^|\\.)"+m.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,n.result=t,n.target||(n.target=i),r=null==r?[n]:x.makeArray(r,[n]),p=x.event.special[g]||{},o||!p.trigger||p.trigger.apply(i,r)!==!1)){if(!o&&!p.noBubble&&!x.isWindow(i)){for(c=p.delegateType||g,nt.test(c+g)||(u=u.parentNode);u;u=u.parentNode)h.push(u),f=u;f===(i.ownerDocument||a)&&h.push(f.defaultView||f.parentWindow||e)}d=0;while((u=h[d++])&&!n.isPropagationStopped())n.type=d>1?c:p.bindType||g,s=(x._data(u,"events")||{})[n.type]&&x._data(u,"handle"),s&&s.apply(u,r),s=l&&u[l],s&&x.acceptData(u)&&s.apply&&s.apply(u,r)===!1&&n.preventDefault();if(n.type=g,!o&&!n.isDefaultPrevented()&&(!p._default||p._default.apply(h.pop(),r)===!1)&&x.acceptData(i)&&l&&i[g]&&!x.isWindow(i)){f=i[l],f&&(i[l]=null),x.event.triggered=g;try{i[g]()}catch(y){}x.event.triggered=t,f&&(i[l]=f)}return n.result}},dispatch:function(e){e=x.event.fix(e);var n,r,i,o,a,s=[],l=g.call(arguments),u=(x._data(this,"events")||{})[e.type]||[],c=x.event.special[e.type]||{};if(l[0]=e,e.delegateTarget=this,!c.preDispatch||c.preDispatch.call(this,e)!==!1){s=x.event.handlers.call(this,e,u),n=0;while((o=s[n++])&&!e.isPropagationStopped()){e.currentTarget=o.elem,a=0;while((i=o.handlers[a++])&&!e.isImmediatePropagationStopped())(!e.namespace_re||e.namespace_re.test(i.namespace))&&(e.handleObj=i,e.data=i.data,r=((x.event.special[i.origType]||{}).handle||i.handler).apply(o.elem,l),r!==t&&(e.result=r)===!1&&(e.preventDefault(),e.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,e),e.result}},handlers:function(e,n){var r,i,o,a,s=[],l=n.delegateCount,u=e.target;if(l&&u.nodeType&&(!e.button||"click"!==e.type))for(;u!=this;u=u.parentNode||this)if(1===u.nodeType&&(u.disabled!==!0||"click"!==e.type)){for(o=[],a=0;l>a;a++)i=n[a],r=i.selector+" ",o[r]===t&&(o[r]=i.needsContext?x(r,this).index(u)>=0:x.find(r,this,null,[u]).length),o[r]&&o.push(i);o.length&&s.push({elem:u,handlers:o})}return n.length>l&&s.push({elem:this,handlers:n.slice(l)}),s},fix:function(e){if(e[x.expando])return e;var t,n,r,i=e.type,o=e,s=this.fixHooks[i];s||(this.fixHooks[i]=s=tt.test(i)?this.mouseHooks:et.test(i)?this.keyHooks:{}),r=s.props?this.props.concat(s.props):this.props,e=new x.Event(o),t=r.length;while(t--)n=r[t],e[n]=o[n];return e.target||(e.target=o.srcElement||a),3===e.target.nodeType&&(e.target=e.target.parentNode),e.metaKey=!!e.metaKey,s.filter?s.filter(e,o):e},props:"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(e,t){return null==e.which&&(e.which=null!=t.charCode?t.charCode:t.keyCode),e}},mouseHooks:{props:"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(e,n){var r,i,o,s=n.button,l=n.fromElement;return null==e.pageX&&null!=n.clientX&&(i=e.target.ownerDocument||a,o=i.documentElement,r=i.body,e.pageX=n.clientX+(o&&o.scrollLeft||r&&r.scrollLeft||0)-(o&&o.clientLeft||r&&r.clientLeft||0),e.pageY=n.clientY+(o&&o.scrollTop||r&&r.scrollTop||0)-(o&&o.clientTop||r&&r.clientTop||0)),!e.relatedTarget&&l&&(e.relatedTarget=l===e.target?n.toElement:l),e.which||s===t||(e.which=1&s?1:2&s?3:4&s?2:0),e}},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==at()&&this.focus)try{return this.focus(),!1}catch(e){}},delegateType:"focusin"},blur:{trigger:function(){return this===at()&&this.blur?(this.blur(),!1):t},delegateType:"focusout"},click:{trigger:function(){return x.nodeName(this,"input")&&"checkbox"===this.type&&this.click?(this.click(),!1):t},_default:function(e){return x.nodeName(e.target,"a")}},beforeunload:{postDispatch:function(e){e.result!==t&&(e.originalEvent.returnValue=e.result)}}},simulate:function(e,t,n,r){var i=x.extend(new x.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?x.event.trigger(i,null,t):x.event.dispatch.call(t,i),i.isDefaultPrevented()&&n.preventDefault()}},x.removeEvent=a.removeEventListener?function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)}:function(e,t,n){var r="on"+t;e.detachEvent&&(typeof e[r]===i&&(e[r]=null),e.detachEvent(r,n))},x.Event=function(e,n){return this instanceof x.Event?(e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||e.returnValue===!1||e.getPreventDefault&&e.getPreventDefault()?it:ot):this.type=e,n&&x.extend(this,n),this.timeStamp=e&&e.timeStamp||x.now(),this[x.expando]=!0,t):new x.Event(e,n)},x.Event.prototype={isDefaultPrevented:ot,isPropagationStopped:ot,isImmediatePropagationStopped:ot,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=it,e&&(e.preventDefault?e.preventDefault():e.returnValue=!1)},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=it,e&&(e.stopPropagation&&e.stopPropagation(),e.cancelBubble=!0)},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=it,this.stopPropagation()}},x.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(e,t){x.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;return(!i||i!==r&&!x.contains(r,i))&&(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}}),x.support.submitBubbles||(x.event.special.submit={setup:function(){return x.nodeName(this,"form")?!1:(x.event.add(this,"click._submit keypress._submit",function(e){var n=e.target,r=x.nodeName(n,"input")||x.nodeName(n,"button")?n.form:t;r&&!x._data(r,"submitBubbles")&&(x.event.add(r,"submit._submit",function(e){e._submit_bubble=!0}),x._data(r,"submitBubbles",!0))}),t)},postDispatch:function(e){e._submit_bubble&&(delete e._submit_bubble,this.parentNode&&!e.isTrigger&&x.event.simulate("submit",this.parentNode,e,!0))},teardown:function(){return x.nodeName(this,"form")?!1:(x.event.remove(this,"._submit"),t)}}),x.support.changeBubbles||(x.event.special.change={setup:function(){return Z.test(this.nodeName)?(("checkbox"===this.type||"radio"===this.type)&&(x.event.add(this,"propertychange._change",function(e){"checked"===e.originalEvent.propertyName&&(this._just_changed=!0)}),x.event.add(this,"click._change",function(e){this._just_changed&&!e.isTrigger&&(this._just_changed=!1),x.event.simulate("change",this,e,!0)})),!1):(x.event.add(this,"beforeactivate._change",function(e){var t=e.target;Z.test(t.nodeName)&&!x._data(t,"changeBubbles")&&(x.event.add(t,"change._change",function(e){!this.parentNode||e.isSimulated||e.isTrigger||x.event.simulate("change",this.parentNode,e,!0)}),x._data(t,"changeBubbles",!0))}),t)},handle:function(e){var n=e.target;return this!==n||e.isSimulated||e.isTrigger||"radio"!==n.type&&"checkbox"!==n.type?e.handleObj.handler.apply(this,arguments):t},teardown:function(){return x.event.remove(this,"._change"),!Z.test(this.nodeName)}}),x.support.focusinBubbles||x.each({focus:"focusin",blur:"focusout"},function(e,t){var n=0,r=function(e){x.event.simulate(t,e.target,x.event.fix(e),!0)};x.event.special[t]={setup:function(){0===n++&&a.addEventListener(e,r,!0)},teardown:function(){0===--n&&a.removeEventListener(e,r,!0)}}}),x.fn.extend({on:function(e,n,r,i,o){var a,s;if("object"==typeof e){"string"!=typeof n&&(r=r||n,n=t);for(a in e)this.on(a,n,r,e[a],o);return this}if(null==r&&null==i?(i=n,r=n=t):null==i&&("string"==typeof n?(i=r,r=t):(i=r,r=n,n=t)),i===!1)i=ot;else if(!i)return this;return 1===o&&(s=i,i=function(e){return x().off(e),s.apply(this,arguments)},i.guid=s.guid||(s.guid=x.guid++)),this.each(function(){x.event.add(this,e,i,r,n)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,n,r){var i,o;if(e&&e.preventDefault&&e.handleObj)return i=e.handleObj,x(e.delegateTarget).off(i.namespace?i.origType+"."+i.namespace:i.origType,i.selector,i.handler),this;if("object"==typeof e){for(o in e)this.off(o,n,e[o]);return this}return(n===!1||"function"==typeof n)&&(r=n,n=t),r===!1&&(r=ot),this.each(function(){x.event.remove(this,e,r,n)})},trigger:function(e,t){return this.each(function(){x.event.trigger(e,t,this)})},triggerHandler:function(e,n){var r=this[0];return r?x.event.trigger(e,n,r,!0):t}});var st=/^.[^:#\[\.,]*$/,lt=/^(?:parents|prev(?:Until|All))/,ut=x.expr.match.needsContext,ct={children:!0,contents:!0,next:!0,prev:!0};x.fn.extend({find:function(e){var t,n=[],r=this,i=r.length;if("string"!=typeof e)return this.pushStack(x(e).filter(function(){for(t=0;i>t;t++)if(x.contains(r[t],this))return!0}));for(t=0;i>t;t++)x.find(e,r[t],n);return n=this.pushStack(i>1?x.unique(n):n),n.selector=this.selector?this.selector+" "+e:e,n},has:function(e){var t,n=x(e,this),r=n.length;return this.filter(function(){for(t=0;r>t;t++)if(x.contains(this,n[t]))return!0})},not:function(e){return this.pushStack(ft(this,e||[],!0))},filter:function(e){return this.pushStack(ft(this,e||[],!1))},is:function(e){return!!ft(this,"string"==typeof e&&ut.test(e)?x(e):e||[],!1).length},closest:function(e,t){var n,r=0,i=this.length,o=[],a=ut.test(e)||"string"!=typeof e?x(e,t||this.context):0;for(;i>r;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(11>n.nodeType&&(a?a.index(n)>-1:1===n.nodeType&&x.find.matchesSelector(n,e))){n=o.push(n);break}return this.pushStack(o.length>1?x.unique(o):o)},index:function(e){return e?"string"==typeof e?x.inArray(this[0],x(e)):x.inArray(e.jquery?e[0]:e,this):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){var n="string"==typeof e?x(e,t):x.makeArray(e&&e.nodeType?[e]:e),r=x.merge(this.get(),n);return this.pushStack(x.unique(r))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}});function pt(e,t){do e=e[t];while(e&&1!==e.nodeType);return e}x.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return x.dir(e,"parentNode")},parentsUntil:function(e,t,n){return x.dir(e,"parentNode",n)},next:function(e){return pt(e,"nextSibling")},prev:function(e){return pt(e,"previousSibling")},nextAll:function(e){return x.dir(e,"nextSibling")},prevAll:function(e){return x.dir(e,"previousSibling")},nextUntil:function(e,t,n){return x.dir(e,"nextSibling",n)},prevUntil:function(e,t,n){return x.dir(e,"previousSibling",n)},siblings:function(e){return x.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return x.sibling(e.firstChild)},contents:function(e){return x.nodeName(e,"iframe")?e.contentDocument||e.contentWindow.document:x.merge([],e.childNodes)}},function(e,t){x.fn[e]=function(n,r){var i=x.map(this,t,n);return"Until"!==e.slice(-5)&&(r=n),r&&"string"==typeof r&&(i=x.filter(r,i)),this.length>1&&(ct[e]||(i=x.unique(i)),lt.test(e)&&(i=i.reverse())),this.pushStack(i)}}),x.extend({filter:function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?x.find.matchesSelector(r,e)?[r]:[]:x.find.matches(e,x.grep(t,function(e){return 1===e.nodeType}))},dir:function(e,n,r){var i=[],o=e[n];while(o&&9!==o.nodeType&&(r===t||1!==o.nodeType||!x(o).is(r)))1===o.nodeType&&i.push(o),o=o[n];return i},sibling:function(e,t){var n=[];for(;e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n}});function ft(e,t,n){if(x.isFunction(t))return x.grep(e,function(e,r){return!!t.call(e,r,e)!==n});if(t.nodeType)return x.grep(e,function(e){return e===t!==n});if("string"==typeof t){if(st.test(t))return x.filter(t,e,n);t=x.filter(t,e)}return x.grep(e,function(e){return x.inArray(e,t)>=0!==n})}function dt(e){var t=ht.split("|"),n=e.createDocumentFragment();if(n.createElement)while(t.length)n.createElement(t.pop());return n}var ht="abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",gt=/ jQuery\d+="(?:null|\d+)"/g,mt=RegExp("<(?:"+ht+")[\\s/>]","i"),yt=/^\s+/,vt=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,bt=/<([\w:]+)/,xt=/<tbody/i,wt=/<|&#?\w+;/,Tt=/<(?:script|style|link)/i,Ct=/^(?:checkbox|radio)$/i,Nt=/checked\s*(?:[^=]|=\s*.checked.)/i,kt=/^$|\/(?:java|ecma)script/i,Et=/^true\/(.*)/,St=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,At={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],area:[1,"<map>","</map>"],param:[1,"<object>","</object>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:x.support.htmlSerialize?[0,"",""]:[1,"X<div>","</div>"]},jt=dt(a),Dt=jt.appendChild(a.createElement("div"));At.optgroup=At.option,At.tbody=At.tfoot=At.colgroup=At.caption=At.thead,At.th=At.td,x.fn.extend({text:function(e){return x.access(this,function(e){return e===t?x.text(this):this.empty().append((this[0]&&this[0].ownerDocument||a).createTextNode(e))},null,e,arguments.length)},append:function(){return this.domManip(arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Lt(this,e);t.appendChild(e)}})},prepend:function(){return this.domManip(arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Lt(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return this.domManip(arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return this.domManip(arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},remove:function(e,t){var n,r=e?x.filter(e,this):this,i=0;for(;null!=(n=r[i]);i++)t||1!==n.nodeType||x.cleanData(Ft(n)),n.parentNode&&(t&&x.contains(n.ownerDocument,n)&&_t(Ft(n,"script")),n.parentNode.removeChild(n));return this},empty:function(){var e,t=0;for(;null!=(e=this[t]);t++){1===e.nodeType&&x.cleanData(Ft(e,!1));while(e.firstChild)e.removeChild(e.firstChild);e.options&&x.nodeName(e,"select")&&(e.options.length=0)}return this},clone:function(e,t){return e=null==e?!1:e,t=null==t?e:t,this.map(function(){return x.clone(this,e,t)})},html:function(e){return x.access(this,function(e){var n=this[0]||{},r=0,i=this.length;if(e===t)return 1===n.nodeType?n.innerHTML.replace(gt,""):t;if(!("string"!=typeof e||Tt.test(e)||!x.support.htmlSerialize&&mt.test(e)||!x.support.leadingWhitespace&&yt.test(e)||At[(bt.exec(e)||["",""])[1].toLowerCase()])){e=e.replace(vt,"<$1></$2>");try{for(;i>r;r++)n=this[r]||{},1===n.nodeType&&(x.cleanData(Ft(n,!1)),n.innerHTML=e);n=0}catch(o){}}n&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var e=x.map(this,function(e){return[e.nextSibling,e.parentNode]}),t=0;return this.domManip(arguments,function(n){var r=e[t++],i=e[t++];i&&(r&&r.parentNode!==i&&(r=this.nextSibling),x(this).remove(),i.insertBefore(n,r))},!0),t?this:this.remove()},detach:function(e){return this.remove(e,!0)},domManip:function(e,t,n){e=d.apply([],e);var r,i,o,a,s,l,u=0,c=this.length,p=this,f=c-1,h=e[0],g=x.isFunction(h);if(g||!(1>=c||"string"!=typeof h||x.support.checkClone)&&Nt.test(h))return this.each(function(r){var i=p.eq(r);g&&(e[0]=h.call(this,r,i.html())),i.domManip(e,t,n)});if(c&&(l=x.buildFragment(e,this[0].ownerDocument,!1,!n&&this),r=l.firstChild,1===l.childNodes.length&&(l=r),r)){for(a=x.map(Ft(l,"script"),Ht),o=a.length;c>u;u++)i=l,u!==f&&(i=x.clone(i,!0,!0),o&&x.merge(a,Ft(i,"script"))),t.call(this[u],i,u);if(o)for(s=a[a.length-1].ownerDocument,x.map(a,qt),u=0;o>u;u++)i=a[u],kt.test(i.type||"")&&!x._data(i,"globalEval")&&x.contains(s,i)&&(i.src?x._evalUrl(i.src):x.globalEval((i.text||i.textContent||i.innerHTML||"").replace(St,"")));l=r=null}return this}});function Lt(e,t){return x.nodeName(e,"table")&&x.nodeName(1===t.nodeType?t:t.firstChild,"tr")?e.getElementsByTagName("tbody")[0]||e.appendChild(e.ownerDocument.createElement("tbody")):e}function Ht(e){return e.type=(null!==x.find.attr(e,"type"))+"/"+e.type,e}function qt(e){var t=Et.exec(e.type);return t?e.type=t[1]:e.removeAttribute("type"),e}function _t(e,t){var n,r=0;for(;null!=(n=e[r]);r++)x._data(n,"globalEval",!t||x._data(t[r],"globalEval"))}function Mt(e,t){if(1===t.nodeType&&x.hasData(e)){var n,r,i,o=x._data(e),a=x._data(t,o),s=o.events;if(s){delete a.handle,a.events={};for(n in s)for(r=0,i=s[n].length;i>r;r++)x.event.add(t,n,s[n][r])}a.data&&(a.data=x.extend({},a.data))}}function Ot(e,t){var n,r,i;if(1===t.nodeType){if(n=t.nodeName.toLowerCase(),!x.support.noCloneEvent&&t[x.expando]){i=x._data(t);for(r in i.events)x.removeEvent(t,r,i.handle);t.removeAttribute(x.expando)}"script"===n&&t.text!==e.text?(Ht(t).text=e.text,qt(t)):"object"===n?(t.parentNode&&(t.outerHTML=e.outerHTML),x.support.html5Clone&&e.innerHTML&&!x.trim(t.innerHTML)&&(t.innerHTML=e.innerHTML)):"input"===n&&Ct.test(e.type)?(t.defaultChecked=t.checked=e.checked,t.value!==e.value&&(t.value=e.value)):"option"===n?t.defaultSelected=t.selected=e.defaultSelected:("input"===n||"textarea"===n)&&(t.defaultValue=e.defaultValue)}}x.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){x.fn[e]=function(e){var n,r=0,i=[],o=x(e),a=o.length-1;for(;a>=r;r++)n=r===a?this:this.clone(!0),x(o[r])[t](n),h.apply(i,n.get());return this.pushStack(i)}});function Ft(e,n){var r,o,a=0,s=typeof e.getElementsByTagName!==i?e.getElementsByTagName(n||"*"):typeof e.querySelectorAll!==i?e.querySelectorAll(n||"*"):t;if(!s)for(s=[],r=e.childNodes||e;null!=(o=r[a]);a++)!n||x.nodeName(o,n)?s.push(o):x.merge(s,Ft(o,n));return n===t||n&&x.nodeName(e,n)?x.merge([e],s):s}function Bt(e){Ct.test(e.type)&&(e.defaultChecked=e.checked)}x.extend({clone:function(e,t,n){var r,i,o,a,s,l=x.contains(e.ownerDocument,e);if(x.support.html5Clone||x.isXMLDoc(e)||!mt.test("<"+e.nodeName+">")?o=e.cloneNode(!0):(Dt.innerHTML=e.outerHTML,Dt.removeChild(o=Dt.firstChild)),!(x.support.noCloneEvent&&x.support.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||x.isXMLDoc(e)))for(r=Ft(o),s=Ft(e),a=0;null!=(i=s[a]);++a)r[a]&&Ot(i,r[a]);if(t)if(n)for(s=s||Ft(e),r=r||Ft(o),a=0;null!=(i=s[a]);a++)Mt(i,r[a]);else Mt(e,o);return r=Ft(o,"script"),r.length>0&&_t(r,!l&&Ft(e,"script")),r=s=i=null,o},buildFragment:function(e,t,n,r){var i,o,a,s,l,u,c,p=e.length,f=dt(t),d=[],h=0;for(;p>h;h++)if(o=e[h],o||0===o)if("object"===x.type(o))x.merge(d,o.nodeType?[o]:o);else if(wt.test(o)){s=s||f.appendChild(t.createElement("div")),l=(bt.exec(o)||["",""])[1].toLowerCase(),c=At[l]||At._default,s.innerHTML=c[1]+o.replace(vt,"<$1></$2>")+c[2],i=c[0];while(i--)s=s.lastChild;if(!x.support.leadingWhitespace&&yt.test(o)&&d.push(t.createTextNode(yt.exec(o)[0])),!x.support.tbody){o="table"!==l||xt.test(o)?"<table>"!==c[1]||xt.test(o)?0:s:s.firstChild,i=o&&o.childNodes.length;while(i--)x.nodeName(u=o.childNodes[i],"tbody")&&!u.childNodes.length&&o.removeChild(u)}x.merge(d,s.childNodes),s.textContent="";while(s.firstChild)s.removeChild(s.firstChild);s=f.lastChild}else d.push(t.createTextNode(o));s&&f.removeChild(s),x.support.appendChecked||x.grep(Ft(d,"input"),Bt),h=0;while(o=d[h++])if((!r||-1===x.inArray(o,r))&&(a=x.contains(o.ownerDocument,o),s=Ft(f.appendChild(o),"script"),a&&_t(s),n)){i=0;while(o=s[i++])kt.test(o.type||"")&&n.push(o)}return s=null,f},cleanData:function(e,t){var n,r,o,a,s=0,l=x.expando,u=x.cache,c=x.support.deleteExpando,f=x.event.special;for(;null!=(n=e[s]);s++)if((t||x.acceptData(n))&&(o=n[l],a=o&&u[o])){if(a.events)for(r in a.events)f[r]?x.event.remove(n,r):x.removeEvent(n,r,a.handle);
u[o]&&(delete u[o],c?delete n[l]:typeof n.removeAttribute!==i?n.removeAttribute(l):n[l]=null,p.push(o))}},_evalUrl:function(e){return x.ajax({url:e,type:"GET",dataType:"script",async:!1,global:!1,"throws":!0})}}),x.fn.extend({wrapAll:function(e){if(x.isFunction(e))return this.each(function(t){x(this).wrapAll(e.call(this,t))});if(this[0]){var t=x(e,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstChild&&1===e.firstChild.nodeType)e=e.firstChild;return e}).append(this)}return this},wrapInner:function(e){return x.isFunction(e)?this.each(function(t){x(this).wrapInner(e.call(this,t))}):this.each(function(){var t=x(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=x.isFunction(e);return this.each(function(n){x(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){x.nodeName(this,"body")||x(this).replaceWith(this.childNodes)}).end()}});var Pt,Rt,Wt,$t=/alpha\([^)]*\)/i,It=/opacity\s*=\s*([^)]*)/,zt=/^(top|right|bottom|left)$/,Xt=/^(none|table(?!-c[ea]).+)/,Ut=/^margin/,Vt=RegExp("^("+w+")(.*)$","i"),Yt=RegExp("^("+w+")(?!px)[a-z%]+$","i"),Jt=RegExp("^([+-])=("+w+")","i"),Gt={BODY:"block"},Qt={position:"absolute",visibility:"hidden",display:"block"},Kt={letterSpacing:0,fontWeight:400},Zt=["Top","Right","Bottom","Left"],en=["Webkit","O","Moz","ms"];function tn(e,t){if(t in e)return t;var n=t.charAt(0).toUpperCase()+t.slice(1),r=t,i=en.length;while(i--)if(t=en[i]+n,t in e)return t;return r}function nn(e,t){return e=t||e,"none"===x.css(e,"display")||!x.contains(e.ownerDocument,e)}function rn(e,t){var n,r,i,o=[],a=0,s=e.length;for(;s>a;a++)r=e[a],r.style&&(o[a]=x._data(r,"olddisplay"),n=r.style.display,t?(o[a]||"none"!==n||(r.style.display=""),""===r.style.display&&nn(r)&&(o[a]=x._data(r,"olddisplay",ln(r.nodeName)))):o[a]||(i=nn(r),(n&&"none"!==n||!i)&&x._data(r,"olddisplay",i?n:x.css(r,"display"))));for(a=0;s>a;a++)r=e[a],r.style&&(t&&"none"!==r.style.display&&""!==r.style.display||(r.style.display=t?o[a]||"":"none"));return e}x.fn.extend({css:function(e,n){return x.access(this,function(e,n,r){var i,o,a={},s=0;if(x.isArray(n)){for(o=Rt(e),i=n.length;i>s;s++)a[n[s]]=x.css(e,n[s],!1,o);return a}return r!==t?x.style(e,n,r):x.css(e,n)},e,n,arguments.length>1)},show:function(){return rn(this,!0)},hide:function(){return rn(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){nn(this)?x(this).show():x(this).hide()})}}),x.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Wt(e,"opacity");return""===n?"1":n}}}},cssNumber:{columnCount:!0,fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":x.support.cssFloat?"cssFloat":"styleFloat"},style:function(e,n,r,i){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var o,a,s,l=x.camelCase(n),u=e.style;if(n=x.cssProps[l]||(x.cssProps[l]=tn(u,l)),s=x.cssHooks[n]||x.cssHooks[l],r===t)return s&&"get"in s&&(o=s.get(e,!1,i))!==t?o:u[n];if(a=typeof r,"string"===a&&(o=Jt.exec(r))&&(r=(o[1]+1)*o[2]+parseFloat(x.css(e,n)),a="number"),!(null==r||"number"===a&&isNaN(r)||("number"!==a||x.cssNumber[l]||(r+="px"),x.support.clearCloneStyle||""!==r||0!==n.indexOf("background")||(u[n]="inherit"),s&&"set"in s&&(r=s.set(e,r,i))===t)))try{u[n]=r}catch(c){}}},css:function(e,n,r,i){var o,a,s,l=x.camelCase(n);return n=x.cssProps[l]||(x.cssProps[l]=tn(e.style,l)),s=x.cssHooks[n]||x.cssHooks[l],s&&"get"in s&&(a=s.get(e,!0,r)),a===t&&(a=Wt(e,n,i)),"normal"===a&&n in Kt&&(a=Kt[n]),""===r||r?(o=parseFloat(a),r===!0||x.isNumeric(o)?o||0:a):a}}),e.getComputedStyle?(Rt=function(t){return e.getComputedStyle(t,null)},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),l=s?s.getPropertyValue(n)||s[n]:t,u=e.style;return s&&(""!==l||x.contains(e.ownerDocument,e)||(l=x.style(e,n)),Yt.test(l)&&Ut.test(n)&&(i=u.width,o=u.minWidth,a=u.maxWidth,u.minWidth=u.maxWidth=u.width=l,l=s.width,u.width=i,u.minWidth=o,u.maxWidth=a)),l}):a.documentElement.currentStyle&&(Rt=function(e){return e.currentStyle},Wt=function(e,n,r){var i,o,a,s=r||Rt(e),l=s?s[n]:t,u=e.style;return null==l&&u&&u[n]&&(l=u[n]),Yt.test(l)&&!zt.test(n)&&(i=u.left,o=e.runtimeStyle,a=o&&o.left,a&&(o.left=e.currentStyle.left),u.left="fontSize"===n?"1em":l,l=u.pixelLeft+"px",u.left=i,a&&(o.left=a)),""===l?"auto":l});function on(e,t,n){var r=Vt.exec(t);return r?Math.max(0,r[1]-(n||0))+(r[2]||"px"):t}function an(e,t,n,r,i){var o=n===(r?"border":"content")?4:"width"===t?1:0,a=0;for(;4>o;o+=2)"margin"===n&&(a+=x.css(e,n+Zt[o],!0,i)),r?("content"===n&&(a-=x.css(e,"padding"+Zt[o],!0,i)),"margin"!==n&&(a-=x.css(e,"border"+Zt[o]+"Width",!0,i))):(a+=x.css(e,"padding"+Zt[o],!0,i),"padding"!==n&&(a+=x.css(e,"border"+Zt[o]+"Width",!0,i)));return a}function sn(e,t,n){var r=!0,i="width"===t?e.offsetWidth:e.offsetHeight,o=Rt(e),a=x.support.boxSizing&&"border-box"===x.css(e,"boxSizing",!1,o);if(0>=i||null==i){if(i=Wt(e,t,o),(0>i||null==i)&&(i=e.style[t]),Yt.test(i))return i;r=a&&(x.support.boxSizingReliable||i===e.style[t]),i=parseFloat(i)||0}return i+an(e,t,n||(a?"border":"content"),r,o)+"px"}function ln(e){var t=a,n=Gt[e];return n||(n=un(e,t),"none"!==n&&n||(Pt=(Pt||x("<iframe frameborder='0' width='0' height='0'/>").css("cssText","display:block !important")).appendTo(t.documentElement),t=(Pt[0].contentWindow||Pt[0].contentDocument).document,t.write("<!doctype html><html><body>"),t.close(),n=un(e,t),Pt.detach()),Gt[e]=n),n}function un(e,t){var n=x(t.createElement(e)).appendTo(t.body),r=x.css(n[0],"display");return n.remove(),r}x.each(["height","width"],function(e,n){x.cssHooks[n]={get:function(e,r,i){return r?0===e.offsetWidth&&Xt.test(x.css(e,"display"))?x.swap(e,Qt,function(){return sn(e,n,i)}):sn(e,n,i):t},set:function(e,t,r){var i=r&&Rt(e);return on(e,t,r?an(e,n,r,x.support.boxSizing&&"border-box"===x.css(e,"boxSizing",!1,i),i):0)}}}),x.support.opacity||(x.cssHooks.opacity={get:function(e,t){return It.test((t&&e.currentStyle?e.currentStyle.filter:e.style.filter)||"")?.01*parseFloat(RegExp.$1)+"":t?"1":""},set:function(e,t){var n=e.style,r=e.currentStyle,i=x.isNumeric(t)?"alpha(opacity="+100*t+")":"",o=r&&r.filter||n.filter||"";n.zoom=1,(t>=1||""===t)&&""===x.trim(o.replace($t,""))&&n.removeAttribute&&(n.removeAttribute("filter"),""===t||r&&!r.filter)||(n.filter=$t.test(o)?o.replace($t,i):o+" "+i)}}),x(function(){x.support.reliableMarginRight||(x.cssHooks.marginRight={get:function(e,n){return n?x.swap(e,{display:"inline-block"},Wt,[e,"marginRight"]):t}}),!x.support.pixelPosition&&x.fn.position&&x.each(["top","left"],function(e,n){x.cssHooks[n]={get:function(e,r){return r?(r=Wt(e,n),Yt.test(r)?x(e).position()[n]+"px":r):t}}})}),x.expr&&x.expr.filters&&(x.expr.filters.hidden=function(e){return 0>=e.offsetWidth&&0>=e.offsetHeight||!x.support.reliableHiddenOffsets&&"none"===(e.style&&e.style.display||x.css(e,"display"))},x.expr.filters.visible=function(e){return!x.expr.filters.hidden(e)}),x.each({margin:"",padding:"",border:"Width"},function(e,t){x.cssHooks[e+t]={expand:function(n){var r=0,i={},o="string"==typeof n?n.split(" "):[n];for(;4>r;r++)i[e+Zt[r]+t]=o[r]||o[r-2]||o[0];return i}},Ut.test(e)||(x.cssHooks[e+t].set=on)});var cn=/%20/g,pn=/\[\]$/,fn=/\r?\n/g,dn=/^(?:submit|button|image|reset|file)$/i,hn=/^(?:input|select|textarea|keygen)/i;x.fn.extend({serialize:function(){return x.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=x.prop(this,"elements");return e?x.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!x(this).is(":disabled")&&hn.test(this.nodeName)&&!dn.test(e)&&(this.checked||!Ct.test(e))}).map(function(e,t){var n=x(this).val();return null==n?null:x.isArray(n)?x.map(n,function(e){return{name:t.name,value:e.replace(fn,"\r\n")}}):{name:t.name,value:n.replace(fn,"\r\n")}}).get()}}),x.param=function(e,n){var r,i=[],o=function(e,t){t=x.isFunction(t)?t():null==t?"":t,i[i.length]=encodeURIComponent(e)+"="+encodeURIComponent(t)};if(n===t&&(n=x.ajaxSettings&&x.ajaxSettings.traditional),x.isArray(e)||e.jquery&&!x.isPlainObject(e))x.each(e,function(){o(this.name,this.value)});else for(r in e)gn(r,e[r],n,o);return i.join("&").replace(cn,"+")};function gn(e,t,n,r){var i;if(x.isArray(t))x.each(t,function(t,i){n||pn.test(e)?r(e,i):gn(e+"["+("object"==typeof i?t:"")+"]",i,n,r)});else if(n||"object"!==x.type(t))r(e,t);else for(i in t)gn(e+"["+i+"]",t[i],n,r)}x.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "),function(e,t){x.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),x.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}});var mn,yn,vn=x.now(),bn=/\?/,xn=/#.*$/,wn=/([?&])_=[^&]*/,Tn=/^(.*?):[ \t]*([^\r\n]*)\r?$/gm,Cn=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Nn=/^(?:GET|HEAD)$/,kn=/^\/\//,En=/^([\w.+-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/,Sn=x.fn.load,An={},jn={},Dn="*/".concat("*");try{yn=o.href}catch(Ln){yn=a.createElement("a"),yn.href="",yn=yn.href}mn=En.exec(yn.toLowerCase())||[];function Hn(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var r,i=0,o=t.toLowerCase().match(T)||[];if(x.isFunction(n))while(r=o[i++])"+"===r[0]?(r=r.slice(1)||"*",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function qn(e,n,r,i){var o={},a=e===jn;function s(l){var u;return o[l]=!0,x.each(e[l]||[],function(e,l){var c=l(n,r,i);return"string"!=typeof c||a||o[c]?a?!(u=c):t:(n.dataTypes.unshift(c),s(c),!1)}),u}return s(n.dataTypes[0])||!o["*"]&&s("*")}function _n(e,n){var r,i,o=x.ajaxSettings.flatOptions||{};for(i in n)n[i]!==t&&((o[i]?e:r||(r={}))[i]=n[i]);return r&&x.extend(!0,e,r),e}x.fn.load=function(e,n,r){if("string"!=typeof e&&Sn)return Sn.apply(this,arguments);var i,o,a,s=this,l=e.indexOf(" ");return l>=0&&(i=e.slice(l,e.length),e=e.slice(0,l)),x.isFunction(n)?(r=n,n=t):n&&"object"==typeof n&&(a="POST"),s.length>0&&x.ajax({url:e,type:a,dataType:"html",data:n}).done(function(e){o=arguments,s.html(i?x("<div>").append(x.parseHTML(e)).find(i):e)}).complete(r&&function(e,t){s.each(r,o||[e.responseText,t,e])}),this},x.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){x.fn[t]=function(e){return this.on(t,e)}}),x.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:yn,type:"GET",isLocal:Cn.test(mn[1]),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Dn,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":x.parseJSON,"text xml":x.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?_n(_n(e,x.ajaxSettings),t):_n(x.ajaxSettings,e)},ajaxPrefilter:Hn(An),ajaxTransport:Hn(jn),ajax:function(e,n){"object"==typeof e&&(n=e,e=t),n=n||{};var r,i,o,a,s,l,u,c,p=x.ajaxSetup({},n),f=p.context||p,d=p.context&&(f.nodeType||f.jquery)?x(f):x.event,h=x.Deferred(),g=x.Callbacks("once memory"),m=p.statusCode||{},y={},v={},b=0,w="canceled",C={readyState:0,getResponseHeader:function(e){var t;if(2===b){if(!c){c={};while(t=Tn.exec(a))c[t[1].toLowerCase()]=t[2]}t=c[e.toLowerCase()]}return null==t?null:t},getAllResponseHeaders:function(){return 2===b?a:null},setRequestHeader:function(e,t){var n=e.toLowerCase();return b||(e=v[n]=v[n]||e,y[e]=t),this},overrideMimeType:function(e){return b||(p.mimeType=e),this},statusCode:function(e){var t;if(e)if(2>b)for(t in e)m[t]=[m[t],e[t]];else C.always(e[C.status]);return this},abort:function(e){var t=e||w;return u&&u.abort(t),k(0,t),this}};if(h.promise(C).complete=g.add,C.success=C.done,C.error=C.fail,p.url=((e||p.url||yn)+"").replace(xn,"").replace(kn,mn[1]+"//"),p.type=n.method||n.type||p.method||p.type,p.dataTypes=x.trim(p.dataType||"*").toLowerCase().match(T)||[""],null==p.crossDomain&&(r=En.exec(p.url.toLowerCase()),p.crossDomain=!(!r||r[1]===mn[1]&&r[2]===mn[2]&&(r[3]||("http:"===r[1]?"80":"443"))===(mn[3]||("http:"===mn[1]?"80":"443")))),p.data&&p.processData&&"string"!=typeof p.data&&(p.data=x.param(p.data,p.traditional)),qn(An,p,n,C),2===b)return C;l=p.global,l&&0===x.active++&&x.event.trigger("ajaxStart"),p.type=p.type.toUpperCase(),p.hasContent=!Nn.test(p.type),o=p.url,p.hasContent||(p.data&&(o=p.url+=(bn.test(o)?"&":"?")+p.data,delete p.data),p.cache===!1&&(p.url=wn.test(o)?o.replace(wn,"$1_="+vn++):o+(bn.test(o)?"&":"?")+"_="+vn++)),p.ifModified&&(x.lastModified[o]&&C.setRequestHeader("If-Modified-Since",x.lastModified[o]),x.etag[o]&&C.setRequestHeader("If-None-Match",x.etag[o])),(p.data&&p.hasContent&&p.contentType!==!1||n.contentType)&&C.setRequestHeader("Content-Type",p.contentType),C.setRequestHeader("Accept",p.dataTypes[0]&&p.accepts[p.dataTypes[0]]?p.accepts[p.dataTypes[0]]+("*"!==p.dataTypes[0]?", "+Dn+"; q=0.01":""):p.accepts["*"]);for(i in p.headers)C.setRequestHeader(i,p.headers[i]);if(p.beforeSend&&(p.beforeSend.call(f,C,p)===!1||2===b))return C.abort();w="abort";for(i in{success:1,error:1,complete:1})C[i](p[i]);if(u=qn(jn,p,n,C)){C.readyState=1,l&&d.trigger("ajaxSend",[C,p]),p.async&&p.timeout>0&&(s=setTimeout(function(){C.abort("timeout")},p.timeout));try{b=1,u.send(y,k)}catch(N){if(!(2>b))throw N;k(-1,N)}}else k(-1,"No Transport");function k(e,n,r,i){var c,y,v,w,T,N=n;2!==b&&(b=2,s&&clearTimeout(s),u=t,a=i||"",C.readyState=e>0?4:0,c=e>=200&&300>e||304===e,r&&(w=Mn(p,C,r)),w=On(p,w,C,c),c?(p.ifModified&&(T=C.getResponseHeader("Last-Modified"),T&&(x.lastModified[o]=T),T=C.getResponseHeader("etag"),T&&(x.etag[o]=T)),204===e||"HEAD"===p.type?N="nocontent":304===e?N="notmodified":(N=w.state,y=w.data,v=w.error,c=!v)):(v=N,(e||!N)&&(N="error",0>e&&(e=0))),C.status=e,C.statusText=(n||N)+"",c?h.resolveWith(f,[y,N,C]):h.rejectWith(f,[C,N,v]),C.statusCode(m),m=t,l&&d.trigger(c?"ajaxSuccess":"ajaxError",[C,p,c?y:v]),g.fireWith(f,[C,N]),l&&(d.trigger("ajaxComplete",[C,p]),--x.active||x.event.trigger("ajaxStop")))}return C},getJSON:function(e,t,n){return x.get(e,t,n,"json")},getScript:function(e,n){return x.get(e,t,n,"script")}}),x.each(["get","post"],function(e,n){x[n]=function(e,r,i,o){return x.isFunction(r)&&(o=o||i,i=r,r=t),x.ajax({url:e,type:n,dataType:o,data:r,success:i})}});function Mn(e,n,r){var i,o,a,s,l=e.contents,u=e.dataTypes;while("*"===u[0])u.shift(),o===t&&(o=e.mimeType||n.getResponseHeader("Content-Type"));if(o)for(s in l)if(l[s]&&l[s].test(o)){u.unshift(s);break}if(u[0]in r)a=u[0];else{for(s in r){if(!u[0]||e.converters[s+" "+u[0]]){a=s;break}i||(i=s)}a=a||i}return a?(a!==u[0]&&u.unshift(a),r[a]):t}function On(e,t,n,r){var i,o,a,s,l,u={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)u[a.toLowerCase()]=e.converters[a];o=c.shift();while(o)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!l&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),l=o,o=c.shift())if("*"===o)o=l;else if("*"!==l&&l!==o){if(a=u[l+" "+o]||u["* "+o],!a)for(i in u)if(s=i.split(" "),s[1]===o&&(a=u[l+" "+s[0]]||u["* "+s[0]])){a===!0?a=u[i]:u[i]!==!0&&(o=s[0],c.unshift(s[1]));break}if(a!==!0)if(a&&e["throws"])t=a(t);else try{t=a(t)}catch(p){return{state:"parsererror",error:a?p:"No conversion from "+l+" to "+o}}}return{state:"success",data:t}}x.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/(?:java|ecma)script/},converters:{"text script":function(e){return x.globalEval(e),e}}}),x.ajaxPrefilter("script",function(e){e.cache===t&&(e.cache=!1),e.crossDomain&&(e.type="GET",e.global=!1)}),x.ajaxTransport("script",function(e){if(e.crossDomain){var n,r=a.head||x("head")[0]||a.documentElement;return{send:function(t,i){n=a.createElement("script"),n.async=!0,e.scriptCharset&&(n.charset=e.scriptCharset),n.src=e.url,n.onload=n.onreadystatechange=function(e,t){(t||!n.readyState||/loaded|complete/.test(n.readyState))&&(n.onload=n.onreadystatechange=null,n.parentNode&&n.parentNode.removeChild(n),n=null,t||i(200,"success"))},r.insertBefore(n,r.firstChild)},abort:function(){n&&n.onload(t,!0)}}}});var Fn=[],Bn=/(=)\?(?=&|$)|\?\?/;x.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Fn.pop()||x.expando+"_"+vn++;return this[e]=!0,e}}),x.ajaxPrefilter("json jsonp",function(n,r,i){var o,a,s,l=n.jsonp!==!1&&(Bn.test(n.url)?"url":"string"==typeof n.data&&!(n.contentType||"").indexOf("application/x-www-form-urlencoded")&&Bn.test(n.data)&&"data");return l||"jsonp"===n.dataTypes[0]?(o=n.jsonpCallback=x.isFunction(n.jsonpCallback)?n.jsonpCallback():n.jsonpCallback,l?n[l]=n[l].replace(Bn,"$1"+o):n.jsonp!==!1&&(n.url+=(bn.test(n.url)?"&":"?")+n.jsonp+"="+o),n.converters["script json"]=function(){return s||x.error(o+" was not called"),s[0]},n.dataTypes[0]="json",a=e[o],e[o]=function(){s=arguments},i.always(function(){e[o]=a,n[o]&&(n.jsonpCallback=r.jsonpCallback,Fn.push(o)),s&&x.isFunction(a)&&a(s[0]),s=a=t}),"script"):t});var Pn,Rn,Wn=0,$n=e.ActiveXObject&&function(){var e;for(e in Pn)Pn[e](t,!0)};function In(){try{return new e.XMLHttpRequest}catch(t){}}function zn(){try{return new e.ActiveXObject("Microsoft.XMLHTTP")}catch(t){}}x.ajaxSettings.xhr=e.ActiveXObject?function(){return!this.isLocal&&In()||zn()}:In,Rn=x.ajaxSettings.xhr(),x.support.cors=!!Rn&&"withCredentials"in Rn,Rn=x.support.ajax=!!Rn,Rn&&x.ajaxTransport(function(n){if(!n.crossDomain||x.support.cors){var r;return{send:function(i,o){var a,s,l=n.xhr();if(n.username?l.open(n.type,n.url,n.async,n.username,n.password):l.open(n.type,n.url,n.async),n.xhrFields)for(s in n.xhrFields)l[s]=n.xhrFields[s];n.mimeType&&l.overrideMimeType&&l.overrideMimeType(n.mimeType),n.crossDomain||i["X-Requested-With"]||(i["X-Requested-With"]="XMLHttpRequest");try{for(s in i)l.setRequestHeader(s,i[s])}catch(u){}l.send(n.hasContent&&n.data||null),r=function(e,i){var s,u,c,p;try{if(r&&(i||4===l.readyState))if(r=t,a&&(l.onreadystatechange=x.noop,$n&&delete Pn[a]),i)4!==l.readyState&&l.abort();else{p={},s=l.status,u=l.getAllResponseHeaders(),"string"==typeof l.responseText&&(p.text=l.responseText);try{c=l.statusText}catch(f){c=""}s||!n.isLocal||n.crossDomain?1223===s&&(s=204):s=p.text?200:404}}catch(d){i||o(-1,d)}p&&o(s,c,p,u)},n.async?4===l.readyState?setTimeout(r):(a=++Wn,$n&&(Pn||(Pn={},x(e).unload($n)),Pn[a]=r),l.onreadystatechange=r):r()},abort:function(){r&&r(t,!0)}}}});var Xn,Un,Vn=/^(?:toggle|show|hide)$/,Yn=RegExp("^(?:([+-])=|)("+w+")([a-z%]*)$","i"),Jn=/queueHooks$/,Gn=[nr],Qn={"*":[function(e,t){var n=this.createTween(e,t),r=n.cur(),i=Yn.exec(t),o=i&&i[3]||(x.cssNumber[e]?"":"px"),a=(x.cssNumber[e]||"px"!==o&&+r)&&Yn.exec(x.css(n.elem,e)),s=1,l=20;if(a&&a[3]!==o){o=o||a[3],i=i||[],a=+r||1;do s=s||".5",a/=s,x.style(n.elem,e,a+o);while(s!==(s=n.cur()/r)&&1!==s&&--l)}return i&&(a=n.start=+a||+r||0,n.unit=o,n.end=i[1]?a+(i[1]+1)*i[2]:+i[2]),n}]};function Kn(){return setTimeout(function(){Xn=t}),Xn=x.now()}function Zn(e,t,n){var r,i=(Qn[t]||[]).concat(Qn["*"]),o=0,a=i.length;for(;a>o;o++)if(r=i[o].call(n,t,e))return r}function er(e,t,n){var r,i,o=0,a=Gn.length,s=x.Deferred().always(function(){delete l.elem}),l=function(){if(i)return!1;var t=Xn||Kn(),n=Math.max(0,u.startTime+u.duration-t),r=n/u.duration||0,o=1-r,a=0,l=u.tweens.length;for(;l>a;a++)u.tweens[a].run(o);return s.notifyWith(e,[u,o,n]),1>o&&l?n:(s.resolveWith(e,[u]),!1)},u=s.promise({elem:e,props:x.extend({},t),opts:x.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:Xn||Kn(),duration:n.duration,tweens:[],createTween:function(t,n){var r=x.Tween(e,u.opts,t,n,u.opts.specialEasing[t]||u.opts.easing);return u.tweens.push(r),r},stop:function(t){var n=0,r=t?u.tweens.length:0;if(i)return this;for(i=!0;r>n;n++)u.tweens[n].run(1);return t?s.resolveWith(e,[u,t]):s.rejectWith(e,[u,t]),this}}),c=u.props;for(tr(c,u.opts.specialEasing);a>o;o++)if(r=Gn[o].call(u,e,c,u.opts))return r;return x.map(c,Zn,u),x.isFunction(u.opts.start)&&u.opts.start.call(e,u),x.fx.timer(x.extend(l,{elem:e,anim:u,queue:u.opts.queue})),u.progress(u.opts.progress).done(u.opts.done,u.opts.complete).fail(u.opts.fail).always(u.opts.always)}function tr(e,t){var n,r,i,o,a;for(n in e)if(r=x.camelCase(n),i=t[r],o=e[n],x.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),a=x.cssHooks[r],a&&"expand"in a){o=a.expand(o),delete e[r];for(n in o)n in e||(e[n]=o[n],t[n]=i)}else t[r]=i}x.Animation=x.extend(er,{tweener:function(e,t){x.isFunction(e)?(t=e,e=["*"]):e=e.split(" ");var n,r=0,i=e.length;for(;i>r;r++)n=e[r],Qn[n]=Qn[n]||[],Qn[n].unshift(t)},prefilter:function(e,t){t?Gn.unshift(e):Gn.push(e)}});function nr(e,t,n){var r,i,o,a,s,l,u=this,c={},p=e.style,f=e.nodeType&&nn(e),d=x._data(e,"fxshow");n.queue||(s=x._queueHooks(e,"fx"),null==s.unqueued&&(s.unqueued=0,l=s.empty.fire,s.empty.fire=function(){s.unqueued||l()}),s.unqueued++,u.always(function(){u.always(function(){s.unqueued--,x.queue(e,"fx").length||s.empty.fire()})})),1===e.nodeType&&("height"in t||"width"in t)&&(n.overflow=[p.overflow,p.overflowX,p.overflowY],"inline"===x.css(e,"display")&&"none"===x.css(e,"float")&&(x.support.inlineBlockNeedsLayout&&"inline"!==ln(e.nodeName)?p.zoom=1:p.display="inline-block")),n.overflow&&(p.overflow="hidden",x.support.shrinkWrapBlocks||u.always(function(){p.overflow=n.overflow[0],p.overflowX=n.overflow[1],p.overflowY=n.overflow[2]}));for(r in t)if(i=t[r],Vn.exec(i)){if(delete t[r],o=o||"toggle"===i,i===(f?"hide":"show"))continue;c[r]=d&&d[r]||x.style(e,r)}if(!x.isEmptyObject(c)){d?"hidden"in d&&(f=d.hidden):d=x._data(e,"fxshow",{}),o&&(d.hidden=!f),f?x(e).show():u.done(function(){x(e).hide()}),u.done(function(){var t;x._removeData(e,"fxshow");for(t in c)x.style(e,t,c[t])});for(r in c)a=Zn(f?d[r]:0,r,u),r in d||(d[r]=a.start,f&&(a.end=a.start,a.start="width"===r||"height"===r?1:0))}}function rr(e,t,n,r,i){return new rr.prototype.init(e,t,n,r,i)}x.Tween=rr,rr.prototype={constructor:rr,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||"swing",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(x.cssNumber[n]?"":"px")},cur:function(){var e=rr.propHooks[this.prop];return e&&e.get?e.get(this):rr.propHooks._default.get(this)},run:function(e){var t,n=rr.propHooks[this.prop];return this.pos=t=this.options.duration?x.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):rr.propHooks._default.set(this),this}},rr.prototype.init.prototype=rr.prototype,rr.propHooks={_default:{get:function(e){var t;return null==e.elem[e.prop]||e.elem.style&&null!=e.elem.style[e.prop]?(t=x.css(e.elem,e.prop,""),t&&"auto"!==t?t:0):e.elem[e.prop]},set:function(e){x.fx.step[e.prop]?x.fx.step[e.prop](e):e.elem.style&&(null!=e.elem.style[x.cssProps[e.prop]]||x.cssHooks[e.prop])?x.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},rr.propHooks.scrollTop=rr.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},x.each(["toggle","show","hide"],function(e,t){var n=x.fn[t];x.fn[t]=function(e,r,i){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(ir(t,!0),e,r,i)}}),x.fn.extend({fadeTo:function(e,t,n,r){return this.filter(nn).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=x.isEmptyObject(e),o=x.speed(t,n,r),a=function(){var t=er(this,x.extend({},e),o);(i||x._data(this,"finish"))&&t.stop(!0)};return a.finish=a,i||o.queue===!1?this.each(a):this.queue(o.queue,a)},stop:function(e,n,r){var i=function(e){var t=e.stop;delete e.stop,t(r)};return"string"!=typeof e&&(r=n,n=e,e=t),n&&e!==!1&&this.queue(e||"fx",[]),this.each(function(){var t=!0,n=null!=e&&e+"queueHooks",o=x.timers,a=x._data(this);if(n)a[n]&&a[n].stop&&i(a[n]);else for(n in a)a[n]&&a[n].stop&&Jn.test(n)&&i(a[n]);for(n=o.length;n--;)o[n].elem!==this||null!=e&&o[n].queue!==e||(o[n].anim.stop(r),t=!1,o.splice(n,1));(t||!r)&&x.dequeue(this,e)})},finish:function(e){return e!==!1&&(e=e||"fx"),this.each(function(){var t,n=x._data(this),r=n[e+"queue"],i=n[e+"queueHooks"],o=x.timers,a=r?r.length:0;for(n.finish=!0,x.queue(this,e,[]),i&&i.stop&&i.stop.call(this,!0),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;a>t;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}});function ir(e,t){var n,r={height:e},i=0;for(t=t?1:0;4>i;i+=2-t)n=Zt[i],r["margin"+n]=r["padding"+n]=e;return t&&(r.opacity=r.width=e),r}x.each({slideDown:ir("show"),slideUp:ir("hide"),slideToggle:ir("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){x.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),x.speed=function(e,t,n){var r=e&&"object"==typeof e?x.extend({},e):{complete:n||!n&&t||x.isFunction(e)&&e,duration:e,easing:n&&t||t&&!x.isFunction(t)&&t};return r.duration=x.fx.off?0:"number"==typeof r.duration?r.duration:r.duration in x.fx.speeds?x.fx.speeds[r.duration]:x.fx.speeds._default,(null==r.queue||r.queue===!0)&&(r.queue="fx"),r.old=r.complete,r.complete=function(){x.isFunction(r.old)&&r.old.call(this),r.queue&&x.dequeue(this,r.queue)},r},x.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2}},x.timers=[],x.fx=rr.prototype.init,x.fx.tick=function(){var e,n=x.timers,r=0;for(Xn=x.now();n.length>r;r++)e=n[r],e()||n[r]!==e||n.splice(r--,1);n.length||x.fx.stop(),Xn=t},x.fx.timer=function(e){e()&&x.timers.push(e)&&x.fx.start()},x.fx.interval=13,x.fx.start=function(){Un||(Un=setInterval(x.fx.tick,x.fx.interval))},x.fx.stop=function(){clearInterval(Un),Un=null},x.fx.speeds={slow:600,fast:200,_default:400},x.fx.step={},x.expr&&x.expr.filters&&(x.expr.filters.animated=function(e){return x.grep(x.timers,function(t){return e===t.elem}).length}),x.fn.offset=function(e){if(arguments.length)return e===t?this:this.each(function(t){x.offset.setOffset(this,e,t)});var n,r,o={top:0,left:0},a=this[0],s=a&&a.ownerDocument;if(s)return n=s.documentElement,x.contains(n,a)?(typeof a.getBoundingClientRect!==i&&(o=a.getBoundingClientRect()),r=or(s),{top:o.top+(r.pageYOffset||n.scrollTop)-(n.clientTop||0),left:o.left+(r.pageXOffset||n.scrollLeft)-(n.clientLeft||0)}):o},x.offset={setOffset:function(e,t,n){var r=x.css(e,"position");"static"===r&&(e.style.position="relative");var i=x(e),o=i.offset(),a=x.css(e,"top"),s=x.css(e,"left"),l=("absolute"===r||"fixed"===r)&&x.inArray("auto",[a,s])>-1,u={},c={},p,f;l?(c=i.position(),p=c.top,f=c.left):(p=parseFloat(a)||0,f=parseFloat(s)||0),x.isFunction(t)&&(t=t.call(e,n,o)),null!=t.top&&(u.top=t.top-o.top+p),null!=t.left&&(u.left=t.left-o.left+f),"using"in t?t.using.call(e,u):i.css(u)}},x.fn.extend({position:function(){if(this[0]){var e,t,n={top:0,left:0},r=this[0];return"fixed"===x.css(r,"position")?t=r.getBoundingClientRect():(e=this.offsetParent(),t=this.offset(),x.nodeName(e[0],"html")||(n=e.offset()),n.top+=x.css(e[0],"borderTopWidth",!0),n.left+=x.css(e[0],"borderLeftWidth",!0)),{top:t.top-n.top-x.css(r,"marginTop",!0),left:t.left-n.left-x.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent||s;while(e&&!x.nodeName(e,"html")&&"static"===x.css(e,"position"))e=e.offsetParent;return e||s})}}),x.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(e,n){var r=/Y/.test(n);x.fn[e]=function(i){return x.access(this,function(e,i,o){var a=or(e);return o===t?a?n in a?a[n]:a.document.documentElement[i]:e[i]:(a?a.scrollTo(r?x(a).scrollLeft():o,r?o:x(a).scrollTop()):e[i]=o,t)},e,i,arguments.length,null)}});function or(e){return x.isWindow(e)?e:9===e.nodeType?e.defaultView||e.parentWindow:!1}x.each({Height:"height",Width:"width"},function(e,n){x.each({padding:"inner"+e,content:n,"":"outer"+e},function(r,i){x.fn[i]=function(i,o){var a=arguments.length&&(r||"boolean"!=typeof i),s=r||(i===!0||o===!0?"margin":"border");return x.access(this,function(n,r,i){var o;return x.isWindow(n)?n.document.documentElement["client"+e]:9===n.nodeType?(o=n.documentElement,Math.max(n.body["scroll"+e],o["scroll"+e],n.body["offset"+e],o["offset"+e],o["client"+e])):i===t?x.css(n,r,s):x.style(n,r,i,s)},n,a?i:t,a,null)}})}),x.fn.size=function(){return this.length},x.fn.andSelf=x.fn.addBack,"object"==typeof module&&module&&"object"==typeof module.exports?module.exports=x:(e.jQuery=e.$=x,"function"==typeof define&&define.amd&&define("jquery",[],function(){return x}))})(window);

//     Underscore.js 1.5.2
//     http://underscorejs.org
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
(function(){var n=this,t=n._,r={},e=Array.prototype,u=Object.prototype,i=Function.prototype,a=e.push,o=e.slice,c=e.concat,l=u.toString,f=u.hasOwnProperty,s=e.forEach,p=e.map,h=e.reduce,v=e.reduceRight,g=e.filter,d=e.every,m=e.some,y=e.indexOf,b=e.lastIndexOf,x=Array.isArray,w=Object.keys,_=i.bind,j=function(n){return n instanceof j?n:this instanceof j?(this._wrapped=n,void 0):new j(n)};"undefined"!=typeof exports?("undefined"!=typeof module&&module.exports&&(exports=module.exports=j),exports._=j):n._=j,j.VERSION="1.5.2";var A=j.each=j.forEach=function(n,t,e){if(null!=n)if(s&&n.forEach===s)n.forEach(t,e);else if(n.length===+n.length){for(var u=0,i=n.length;i>u;u++)if(t.call(e,n[u],u,n)===r)return}else for(var a=j.keys(n),u=0,i=a.length;i>u;u++)if(t.call(e,n[a[u]],a[u],n)===r)return};j.map=j.collect=function(n,t,r){var e=[];return null==n?e:p&&n.map===p?n.map(t,r):(A(n,function(n,u,i){e.push(t.call(r,n,u,i))}),e)};var E="Reduce of empty array with no initial value";j.reduce=j.foldl=j.inject=function(n,t,r,e){var u=arguments.length>2;if(null==n&&(n=[]),h&&n.reduce===h)return e&&(t=j.bind(t,e)),u?n.reduce(t,r):n.reduce(t);if(A(n,function(n,i,a){u?r=t.call(e,r,n,i,a):(r=n,u=!0)}),!u)throw new TypeError(E);return r},j.reduceRight=j.foldr=function(n,t,r,e){var u=arguments.length>2;if(null==n&&(n=[]),v&&n.reduceRight===v)return e&&(t=j.bind(t,e)),u?n.reduceRight(t,r):n.reduceRight(t);var i=n.length;if(i!==+i){var a=j.keys(n);i=a.length}if(A(n,function(o,c,l){c=a?a[--i]:--i,u?r=t.call(e,r,n[c],c,l):(r=n[c],u=!0)}),!u)throw new TypeError(E);return r},j.find=j.detect=function(n,t,r){var e;return O(n,function(n,u,i){return t.call(r,n,u,i)?(e=n,!0):void 0}),e},j.filter=j.select=function(n,t,r){var e=[];return null==n?e:g&&n.filter===g?n.filter(t,r):(A(n,function(n,u,i){t.call(r,n,u,i)&&e.push(n)}),e)},j.reject=function(n,t,r){return j.filter(n,function(n,e,u){return!t.call(r,n,e,u)},r)},j.every=j.all=function(n,t,e){t||(t=j.identity);var u=!0;return null==n?u:d&&n.every===d?n.every(t,e):(A(n,function(n,i,a){return(u=u&&t.call(e,n,i,a))?void 0:r}),!!u)};var O=j.some=j.any=function(n,t,e){t||(t=j.identity);var u=!1;return null==n?u:m&&n.some===m?n.some(t,e):(A(n,function(n,i,a){return u||(u=t.call(e,n,i,a))?r:void 0}),!!u)};j.contains=j.include=function(n,t){return null==n?!1:y&&n.indexOf===y?n.indexOf(t)!=-1:O(n,function(n){return n===t})},j.invoke=function(n,t){var r=o.call(arguments,2),e=j.isFunction(t);return j.map(n,function(n){return(e?t:n[t]).apply(n,r)})},j.pluck=function(n,t){return j.map(n,function(n){return n[t]})},j.where=function(n,t,r){return j.isEmpty(t)?r?void 0:[]:j[r?"find":"filter"](n,function(n){for(var r in t)if(t[r]!==n[r])return!1;return!0})},j.findWhere=function(n,t){return j.where(n,t,!0)},j.max=function(n,t,r){if(!t&&j.isArray(n)&&n[0]===+n[0]&&n.length<65535)return Math.max.apply(Math,n);if(!t&&j.isEmpty(n))return-1/0;var e={computed:-1/0,value:-1/0};return A(n,function(n,u,i){var a=t?t.call(r,n,u,i):n;a>e.computed&&(e={value:n,computed:a})}),e.value},j.min=function(n,t,r){if(!t&&j.isArray(n)&&n[0]===+n[0]&&n.length<65535)return Math.min.apply(Math,n);if(!t&&j.isEmpty(n))return 1/0;var e={computed:1/0,value:1/0};return A(n,function(n,u,i){var a=t?t.call(r,n,u,i):n;a<e.computed&&(e={value:n,computed:a})}),e.value},j.shuffle=function(n){var t,r=0,e=[];return A(n,function(n){t=j.random(r++),e[r-1]=e[t],e[t]=n}),e},j.sample=function(n,t,r){return arguments.length<2||r?n[j.random(n.length-1)]:j.shuffle(n).slice(0,Math.max(0,t))};var k=function(n){return j.isFunction(n)?n:function(t){return t[n]}};j.sortBy=function(n,t,r){var e=k(t);return j.pluck(j.map(n,function(n,t,u){return{value:n,index:t,criteria:e.call(r,n,t,u)}}).sort(function(n,t){var r=n.criteria,e=t.criteria;if(r!==e){if(r>e||r===void 0)return 1;if(e>r||e===void 0)return-1}return n.index-t.index}),"value")};var F=function(n){return function(t,r,e){var u={},i=null==r?j.identity:k(r);return A(t,function(r,a){var o=i.call(e,r,a,t);n(u,o,r)}),u}};j.groupBy=F(function(n,t,r){(j.has(n,t)?n[t]:n[t]=[]).push(r)}),j.indexBy=F(function(n,t,r){n[t]=r}),j.countBy=F(function(n,t){j.has(n,t)?n[t]++:n[t]=1}),j.sortedIndex=function(n,t,r,e){r=null==r?j.identity:k(r);for(var u=r.call(e,t),i=0,a=n.length;a>i;){var o=i+a>>>1;r.call(e,n[o])<u?i=o+1:a=o}return i},j.toArray=function(n){return n?j.isArray(n)?o.call(n):n.length===+n.length?j.map(n,j.identity):j.values(n):[]},j.size=function(n){return null==n?0:n.length===+n.length?n.length:j.keys(n).length},j.first=j.head=j.take=function(n,t,r){return null==n?void 0:null==t||r?n[0]:o.call(n,0,t)},j.initial=function(n,t,r){return o.call(n,0,n.length-(null==t||r?1:t))},j.last=function(n,t,r){return null==n?void 0:null==t||r?n[n.length-1]:o.call(n,Math.max(n.length-t,0))},j.rest=j.tail=j.drop=function(n,t,r){return o.call(n,null==t||r?1:t)},j.compact=function(n){return j.filter(n,j.identity)};var M=function(n,t,r){return t&&j.every(n,j.isArray)?c.apply(r,n):(A(n,function(n){j.isArray(n)||j.isArguments(n)?t?a.apply(r,n):M(n,t,r):r.push(n)}),r)};j.flatten=function(n,t){return M(n,t,[])},j.without=function(n){return j.difference(n,o.call(arguments,1))},j.uniq=j.unique=function(n,t,r,e){j.isFunction(t)&&(e=r,r=t,t=!1);var u=r?j.map(n,r,e):n,i=[],a=[];return A(u,function(r,e){(t?e&&a[a.length-1]===r:j.contains(a,r))||(a.push(r),i.push(n[e]))}),i},j.union=function(){return j.uniq(j.flatten(arguments,!0))},j.intersection=function(n){var t=o.call(arguments,1);return j.filter(j.uniq(n),function(n){return j.every(t,function(t){return j.indexOf(t,n)>=0})})},j.difference=function(n){var t=c.apply(e,o.call(arguments,1));return j.filter(n,function(n){return!j.contains(t,n)})},j.zip=function(){for(var n=j.max(j.pluck(arguments,"length").concat(0)),t=new Array(n),r=0;n>r;r++)t[r]=j.pluck(arguments,""+r);return t},j.object=function(n,t){if(null==n)return{};for(var r={},e=0,u=n.length;u>e;e++)t?r[n[e]]=t[e]:r[n[e][0]]=n[e][1];return r},j.indexOf=function(n,t,r){if(null==n)return-1;var e=0,u=n.length;if(r){if("number"!=typeof r)return e=j.sortedIndex(n,t),n[e]===t?e:-1;e=0>r?Math.max(0,u+r):r}if(y&&n.indexOf===y)return n.indexOf(t,r);for(;u>e;e++)if(n[e]===t)return e;return-1},j.lastIndexOf=function(n,t,r){if(null==n)return-1;var e=null!=r;if(b&&n.lastIndexOf===b)return e?n.lastIndexOf(t,r):n.lastIndexOf(t);for(var u=e?r:n.length;u--;)if(n[u]===t)return u;return-1},j.range=function(n,t,r){arguments.length<=1&&(t=n||0,n=0),r=arguments[2]||1;for(var e=Math.max(Math.ceil((t-n)/r),0),u=0,i=new Array(e);e>u;)i[u++]=n,n+=r;return i};var R=function(){};j.bind=function(n,t){var r,e;if(_&&n.bind===_)return _.apply(n,o.call(arguments,1));if(!j.isFunction(n))throw new TypeError;return r=o.call(arguments,2),e=function(){if(!(this instanceof e))return n.apply(t,r.concat(o.call(arguments)));R.prototype=n.prototype;var u=new R;R.prototype=null;var i=n.apply(u,r.concat(o.call(arguments)));return Object(i)===i?i:u}},j.partial=function(n){var t=o.call(arguments,1);return function(){return n.apply(this,t.concat(o.call(arguments)))}},j.bindAll=function(n){var t=o.call(arguments,1);if(0===t.length)throw new Error("bindAll must be passed function names");return A(t,function(t){n[t]=j.bind(n[t],n)}),n},j.memoize=function(n,t){var r={};return t||(t=j.identity),function(){var e=t.apply(this,arguments);return j.has(r,e)?r[e]:r[e]=n.apply(this,arguments)}},j.delay=function(n,t){var r=o.call(arguments,2);return setTimeout(function(){return n.apply(null,r)},t)},j.defer=function(n){return j.delay.apply(j,[n,1].concat(o.call(arguments,1)))},j.throttle=function(n,t,r){var e,u,i,a=null,o=0;r||(r={});var c=function(){o=r.leading===!1?0:new Date,a=null,i=n.apply(e,u)};return function(){var l=new Date;o||r.leading!==!1||(o=l);var f=t-(l-o);return e=this,u=arguments,0>=f?(clearTimeout(a),a=null,o=l,i=n.apply(e,u)):a||r.trailing===!1||(a=setTimeout(c,f)),i}},j.debounce=function(n,t,r){var e,u,i,a,o;return function(){i=this,u=arguments,a=new Date;var c=function(){var l=new Date-a;t>l?e=setTimeout(c,t-l):(e=null,r||(o=n.apply(i,u)))},l=r&&!e;return e||(e=setTimeout(c,t)),l&&(o=n.apply(i,u)),o}},j.once=function(n){var t,r=!1;return function(){return r?t:(r=!0,t=n.apply(this,arguments),n=null,t)}},j.wrap=function(n,t){return function(){var r=[n];return a.apply(r,arguments),t.apply(this,r)}},j.compose=function(){var n=arguments;return function(){for(var t=arguments,r=n.length-1;r>=0;r--)t=[n[r].apply(this,t)];return t[0]}},j.after=function(n,t){return function(){return--n<1?t.apply(this,arguments):void 0}},j.keys=w||function(n){if(n!==Object(n))throw new TypeError("Invalid object");var t=[];for(var r in n)j.has(n,r)&&t.push(r);return t},j.values=function(n){for(var t=j.keys(n),r=t.length,e=new Array(r),u=0;r>u;u++)e[u]=n[t[u]];return e},j.pairs=function(n){for(var t=j.keys(n),r=t.length,e=new Array(r),u=0;r>u;u++)e[u]=[t[u],n[t[u]]];return e},j.invert=function(n){for(var t={},r=j.keys(n),e=0,u=r.length;u>e;e++)t[n[r[e]]]=r[e];return t},j.functions=j.methods=function(n){var t=[];for(var r in n)j.isFunction(n[r])&&t.push(r);return t.sort()},j.extend=function(n){return A(o.call(arguments,1),function(t){if(t)for(var r in t)n[r]=t[r]}),n},j.pick=function(n){var t={},r=c.apply(e,o.call(arguments,1));return A(r,function(r){r in n&&(t[r]=n[r])}),t},j.omit=function(n){var t={},r=c.apply(e,o.call(arguments,1));for(var u in n)j.contains(r,u)||(t[u]=n[u]);return t},j.defaults=function(n){return A(o.call(arguments,1),function(t){if(t)for(var r in t)n[r]===void 0&&(n[r]=t[r])}),n},j.clone=function(n){return j.isObject(n)?j.isArray(n)?n.slice():j.extend({},n):n},j.tap=function(n,t){return t(n),n};var S=function(n,t,r,e){if(n===t)return 0!==n||1/n==1/t;if(null==n||null==t)return n===t;n instanceof j&&(n=n._wrapped),t instanceof j&&(t=t._wrapped);var u=l.call(n);if(u!=l.call(t))return!1;switch(u){case"[object String]":return n==String(t);case"[object Number]":return n!=+n?t!=+t:0==n?1/n==1/t:n==+t;case"[object Date]":case"[object Boolean]":return+n==+t;case"[object RegExp]":return n.source==t.source&&n.global==t.global&&n.multiline==t.multiline&&n.ignoreCase==t.ignoreCase}if("object"!=typeof n||"object"!=typeof t)return!1;for(var i=r.length;i--;)if(r[i]==n)return e[i]==t;var a=n.constructor,o=t.constructor;if(a!==o&&!(j.isFunction(a)&&a instanceof a&&j.isFunction(o)&&o instanceof o))return!1;r.push(n),e.push(t);var c=0,f=!0;if("[object Array]"==u){if(c=n.length,f=c==t.length)for(;c--&&(f=S(n[c],t[c],r,e)););}else{for(var s in n)if(j.has(n,s)&&(c++,!(f=j.has(t,s)&&S(n[s],t[s],r,e))))break;if(f){for(s in t)if(j.has(t,s)&&!c--)break;f=!c}}return r.pop(),e.pop(),f};j.isEqual=function(n,t){return S(n,t,[],[])},j.isEmpty=function(n){if(null==n)return!0;if(j.isArray(n)||j.isString(n))return 0===n.length;for(var t in n)if(j.has(n,t))return!1;return!0},j.isElement=function(n){return!(!n||1!==n.nodeType)},j.isArray=x||function(n){return"[object Array]"==l.call(n)},j.isObject=function(n){return n===Object(n)},A(["Arguments","Function","String","Number","Date","RegExp"],function(n){j["is"+n]=function(t){return l.call(t)=="[object "+n+"]"}}),j.isArguments(arguments)||(j.isArguments=function(n){return!(!n||!j.has(n,"callee"))}),"function"!=typeof/./&&(j.isFunction=function(n){return"function"==typeof n}),j.isFinite=function(n){return isFinite(n)&&!isNaN(parseFloat(n))},j.isNaN=function(n){return j.isNumber(n)&&n!=+n},j.isBoolean=function(n){return n===!0||n===!1||"[object Boolean]"==l.call(n)},j.isNull=function(n){return null===n},j.isUndefined=function(n){return n===void 0},j.has=function(n,t){return f.call(n,t)},j.noConflict=function(){return n._=t,this},j.identity=function(n){return n},j.times=function(n,t,r){for(var e=Array(Math.max(0,n)),u=0;n>u;u++)e[u]=t.call(r,u);return e},j.random=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))};var I={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}};I.unescape=j.invert(I.escape);var T={escape:new RegExp("["+j.keys(I.escape).join("")+"]","g"),unescape:new RegExp("("+j.keys(I.unescape).join("|")+")","g")};j.each(["escape","unescape"],function(n){j[n]=function(t){return null==t?"":(""+t).replace(T[n],function(t){return I[n][t]})}}),j.result=function(n,t){if(null==n)return void 0;var r=n[t];return j.isFunction(r)?r.call(n):r},j.mixin=function(n){A(j.functions(n),function(t){var r=j[t]=n[t];j.prototype[t]=function(){var n=[this._wrapped];return a.apply(n,arguments),z.call(this,r.apply(j,n))}})};var N=0;j.uniqueId=function(n){var t=++N+"";return n?n+t:t},j.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var q=/(.)^/,B={"'":"'","\\":"\\","\r":"r","\n":"n","	":"t","\u2028":"u2028","\u2029":"u2029"},D=/\\|'|\r|\n|\t|\u2028|\u2029/g;j.template=function(n,t,r){var e;r=j.defaults({},r,j.templateSettings);var u=new RegExp([(r.escape||q).source,(r.interpolate||q).source,(r.evaluate||q).source].join("|")+"|$","g"),i=0,a="__p+='";n.replace(u,function(t,r,e,u,o){return a+=n.slice(i,o).replace(D,function(n){return"\\"+B[n]}),r&&(a+="'+\n((__t=("+r+"))==null?'':_.escape(__t))+\n'"),e&&(a+="'+\n((__t=("+e+"))==null?'':__t)+\n'"),u&&(a+="';\n"+u+"\n__p+='"),i=o+t.length,t}),a+="';\n",r.variable||(a="with(obj||{}){\n"+a+"}\n"),a="var __t,__p='',__j=Array.prototype.join,"+"print=function(){__p+=__j.call(arguments,'');};\n"+a+"return __p;\n";try{e=new Function(r.variable||"obj","_",a)}catch(o){throw o.source=a,o}if(t)return e(t,j);var c=function(n){return e.call(this,n,j)};return c.source="function("+(r.variable||"obj")+"){\n"+a+"}",c},j.chain=function(n){return j(n).chain()};var z=function(n){return this._chain?j(n).chain():n};j.mixin(j),A(["pop","push","reverse","shift","sort","splice","unshift"],function(n){var t=e[n];j.prototype[n]=function(){var r=this._wrapped;return t.apply(r,arguments),"shift"!=n&&"splice"!=n||0!==r.length||delete r[0],z.call(this,r)}}),A(["concat","join","slice"],function(n){var t=e[n];j.prototype[n]=function(){return z.call(this,t.apply(this._wrapped,arguments))}}),j.extend(j.prototype,{chain:function(){return this._chain=!0,this},value:function(){return this._wrapped}})}).call(this);

/*! jQuery UI - v1.13.0 - 2021-10-07
* http://jqueryui.com
* Includes: widget.js, position.js, data.js, disable-selection.js, effect.js, effects/effect-blind.js, effects/effect-bounce.js, effects/effect-clip.js, effects/effect-drop.js, effects/effect-explode.js, effects/effect-fade.js, effects/effect-fold.js, effects/effect-highlight.js, effects/effect-puff.js, effects/effect-pulsate.js, effects/effect-scale.js, effects/effect-shake.js, effects/effect-size.js, effects/effect-slide.js, effects/effect-transfer.js, focusable.js, form-reset-mixin.js, jquery-patch.js, keycode.js, labels.js, scroll-parent.js, tabbable.js, unique-id.js, widgets/accordion.js, widgets/autocomplete.js, widgets/button.js, widgets/checkboxradio.js, widgets/controlgroup.js, widgets/datepicker.js, widgets/dialog.js, widgets/draggable.js, widgets/droppable.js, widgets/menu.js, widgets/mouse.js, widgets/progressbar.js, widgets/resizable.js, widgets/selectable.js, widgets/selectmenu.js, widgets/slider.js, widgets/sortable.js, widgets/spinner.js, widgets/tabs.js, widgets/tooltip.js
* Copyright jQuery Foundation and other contributors; Licensed MIT */

!function(t){"use strict";"function"==typeof define&&define.amd?define(["jquery"],t):t(jQuery)}(function(V){"use strict";V.ui=V.ui||{};V.ui.version="1.13.0";var n,i=0,a=Array.prototype.hasOwnProperty,r=Array.prototype.slice;V.cleanData=(n=V.cleanData,function(t){for(var e,i,s=0;null!=(i=t[s]);s++)(e=V._data(i,"events"))&&e.remove&&V(i).triggerHandler("remove");n(t)}),V.widget=function(t,i,e){var s,n,o,a={},r=t.split(".")[0],l=r+"-"+(t=t.split(".")[1]);return e||(e=i,i=V.Widget),Array.isArray(e)&&(e=V.extend.apply(null,[{}].concat(e))),V.expr.pseudos[l.toLowerCase()]=function(t){return!!V.data(t,l)},V[r]=V[r]||{},s=V[r][t],n=V[r][t]=function(t,e){if(!this._createWidget)return new n(t,e);arguments.length&&this._createWidget(t,e)},V.extend(n,s,{version:e.version,_proto:V.extend({},e),_childConstructors:[]}),(o=new i).options=V.widget.extend({},o.options),V.each(e,function(e,s){function n(){return i.prototype[e].apply(this,arguments)}function o(t){return i.prototype[e].apply(this,t)}a[e]="function"==typeof s?function(){var t,e=this._super,i=this._superApply;return this._super=n,this._superApply=o,t=s.apply(this,arguments),this._super=e,this._superApply=i,t}:s}),n.prototype=V.widget.extend(o,{widgetEventPrefix:s&&o.widgetEventPrefix||t},a,{constructor:n,namespace:r,widgetName:t,widgetFullName:l}),s?(V.each(s._childConstructors,function(t,e){var i=e.prototype;V.widget(i.namespace+"."+i.widgetName,n,e._proto)}),delete s._childConstructors):i._childConstructors.push(n),V.widget.bridge(t,n),n},V.widget.extend=function(t){for(var e,i,s=r.call(arguments,1),n=0,o=s.length;n<o;n++)for(e in s[n])i=s[n][e],a.call(s[n],e)&&void 0!==i&&(V.isPlainObject(i)?t[e]=V.isPlainObject(t[e])?V.widget.extend({},t[e],i):V.widget.extend({},i):t[e]=i);return t},V.widget.bridge=function(o,e){var a=e.prototype.widgetFullName||o;V.fn[o]=function(i){var t="string"==typeof i,s=r.call(arguments,1),n=this;return t?this.length||"instance"!==i?this.each(function(){var t,e=V.data(this,a);return"instance"===i?(n=e,!1):e?"function"!=typeof e[i]||"_"===i.charAt(0)?V.error("no such method '"+i+"' for "+o+" widget instance"):(t=e[i].apply(e,s))!==e&&void 0!==t?(n=t&&t.jquery?n.pushStack(t.get()):t,!1):void 0:V.error("cannot call methods on "+o+" prior to initialization; attempted to call method '"+i+"'")}):n=void 0:(s.length&&(i=V.widget.extend.apply(null,[i].concat(s))),this.each(function(){var t=V.data(this,a);t?(t.option(i||{}),t._init&&t._init()):V.data(this,a,new e(i,this))})),n}},V.Widget=function(){},V.Widget._childConstructors=[],V.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:!1,create:null},_createWidget:function(t,e){e=V(e||this.defaultElement||this)[0],this.element=V(e),this.uuid=i++,this.eventNamespace="."+this.widgetName+this.uuid,this.bindings=V(),this.hoverable=V(),this.focusable=V(),this.classesElementLookup={},e!==this&&(V.data(e,this.widgetFullName,this),this._on(!0,this.element,{remove:function(t){t.target===e&&this.destroy()}}),this.document=V(e.style?e.ownerDocument:e.document||e),this.window=V(this.document[0].defaultView||this.document[0].parentWindow)),this.options=V.widget.extend({},this.options,this._getCreateOptions(),t),this._create(),this.options.disabled&&this._setOptionDisabled(this.options.disabled),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:function(){return{}},_getCreateEventData:V.noop,_create:V.noop,_init:V.noop,destroy:function(){var i=this;this._destroy(),V.each(this.classesElementLookup,function(t,e){i._removeClass(e,t)}),this.element.off(this.eventNamespace).removeData(this.widgetFullName),this.widget().off(this.eventNamespace).removeAttr("aria-disabled"),this.bindings.off(this.eventNamespace)},_destroy:V.noop,widget:function(){return this.element},option:function(t,e){var i,s,n,o=t;if(0===arguments.length)return V.widget.extend({},this.options);if("string"==typeof t)if(o={},t=(i=t.split(".")).shift(),i.length){for(s=o[t]=V.widget.extend({},this.options[t]),n=0;n<i.length-1;n++)s[i[n]]=s[i[n]]||{},s=s[i[n]];if(t=i.pop(),1===arguments.length)return void 0===s[t]?null:s[t];s[t]=e}else{if(1===arguments.length)return void 0===this.options[t]?null:this.options[t];o[t]=e}return this._setOptions(o),this},_setOptions:function(t){for(var e in t)this._setOption(e,t[e]);return this},_setOption:function(t,e){return"classes"===t&&this._setOptionClasses(e),this.options[t]=e,"disabled"===t&&this._setOptionDisabled(e),this},_setOptionClasses:function(t){var e,i,s;for(e in t)s=this.classesElementLookup[e],t[e]!==this.options.classes[e]&&s&&s.length&&(i=V(s.get()),this._removeClass(s,e),i.addClass(this._classes({element:i,keys:e,classes:t,add:!0})))},_setOptionDisabled:function(t){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!t),t&&(this._removeClass(this.hoverable,null,"ui-state-hover"),this._removeClass(this.focusable,null,"ui-state-focus"))},enable:function(){return this._setOptions({disabled:!1})},disable:function(){return this._setOptions({disabled:!0})},_classes:function(n){var o=[],a=this;function t(t,e){for(var i,s=0;s<t.length;s++)i=a.classesElementLookup[t[s]]||V(),i=n.add?(n.element.each(function(t,e){V.map(a.classesElementLookup,function(t){return t}).some(function(t){return t.is(e)})||a._on(V(e),{remove:"_untrackClassesElement"})}),V(V.uniqueSort(i.get().concat(n.element.get())))):V(i.not(n.element).get()),a.classesElementLookup[t[s]]=i,o.push(t[s]),e&&n.classes[t[s]]&&o.push(n.classes[t[s]])}return(n=V.extend({element:this.element,classes:this.options.classes||{}},n)).keys&&t(n.keys.match(/\S+/g)||[],!0),n.extra&&t(n.extra.match(/\S+/g)||[]),o.join(" ")},_untrackClassesElement:function(i){var s=this;V.each(s.classesElementLookup,function(t,e){-1!==V.inArray(i.target,e)&&(s.classesElementLookup[t]=V(e.not(i.target).get()))}),this._off(V(i.target))},_removeClass:function(t,e,i){return this._toggleClass(t,e,i,!1)},_addClass:function(t,e,i){return this._toggleClass(t,e,i,!0)},_toggleClass:function(t,e,i,s){var n="string"==typeof t||null===t,i={extra:n?e:i,keys:n?t:e,element:n?this.element:t,add:s="boolean"==typeof s?s:i};return i.element.toggleClass(this._classes(i),s),this},_on:function(n,o,t){var a,r=this;"boolean"!=typeof n&&(t=o,o=n,n=!1),t?(o=a=V(o),this.bindings=this.bindings.add(o)):(t=o,o=this.element,a=this.widget()),V.each(t,function(t,e){function i(){if(n||!0!==r.options.disabled&&!V(this).hasClass("ui-state-disabled"))return("string"==typeof e?r[e]:e).apply(r,arguments)}"string"!=typeof e&&(i.guid=e.guid=e.guid||i.guid||V.guid++);var s=t.match(/^([\w:-]*)\s*(.*)$/),t=s[1]+r.eventNamespace,s=s[2];s?a.on(t,s,i):o.on(t,i)})},_off:function(t,e){e=(e||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,t.off(e),this.bindings=V(this.bindings.not(t).get()),this.focusable=V(this.focusable.not(t).get()),this.hoverable=V(this.hoverable.not(t).get())},_delay:function(t,e){var i=this;return setTimeout(function(){return("string"==typeof t?i[t]:t).apply(i,arguments)},e||0)},_hoverable:function(t){this.hoverable=this.hoverable.add(t),this._on(t,{mouseenter:function(t){this._addClass(V(t.currentTarget),null,"ui-state-hover")},mouseleave:function(t){this._removeClass(V(t.currentTarget),null,"ui-state-hover")}})},_focusable:function(t){this.focusable=this.focusable.add(t),this._on(t,{focusin:function(t){this._addClass(V(t.currentTarget),null,"ui-state-focus")},focusout:function(t){this._removeClass(V(t.currentTarget),null,"ui-state-focus")}})},_trigger:function(t,e,i){var s,n,o=this.options[t];if(i=i||{},(e=V.Event(e)).type=(t===this.widgetEventPrefix?t:this.widgetEventPrefix+t).toLowerCase(),e.target=this.element[0],n=e.originalEvent)for(s in n)s in e||(e[s]=n[s]);return this.element.trigger(e,i),!("function"==typeof o&&!1===o.apply(this.element[0],[e].concat(i))||e.isDefaultPrevented())}},V.each({show:"fadeIn",hide:"fadeOut"},function(o,a){V.Widget.prototype["_"+o]=function(e,t,i){var s,n=(t="string"==typeof t?{effect:t}:t)?!0!==t&&"number"!=typeof t&&t.effect||a:o;"number"==typeof(t=t||{})?t={duration:t}:!0===t&&(t={}),s=!V.isEmptyObject(t),t.complete=i,t.delay&&e.delay(t.delay),s&&V.effects&&V.effects.effect[n]?e[o](t):n!==o&&e[n]?e[n](t.duration,t.easing,i):e.queue(function(t){V(this)[o](),i&&i.call(e[0]),t()})}});var s,x,k,o,l,h,c,u,C;V.widget;function D(t,e,i){return[parseFloat(t[0])*(u.test(t[0])?e/100:1),parseFloat(t[1])*(u.test(t[1])?i/100:1)]}function I(t,e){return parseInt(V.css(t,e),10)||0}function T(t){return null!=t&&t===t.window}x=Math.max,k=Math.abs,o=/left|center|right/,l=/top|center|bottom/,h=/[\+\-]\d+(\.[\d]+)?%?/,c=/^\w+/,u=/%$/,C=V.fn.position,V.position={scrollbarWidth:function(){if(void 0!==s)return s;var t,e=V("<div style='display:block;position:absolute;width:200px;height:200px;overflow:hidden;'><div style='height:300px;width:auto;'></div></div>"),i=e.children()[0];return V("body").append(e),t=i.offsetWidth,e.css("overflow","scroll"),t===(i=i.offsetWidth)&&(i=e[0].clientWidth),e.remove(),s=t-i},getScrollInfo:function(t){var e=t.isWindow||t.isDocument?"":t.element.css("overflow-x"),i=t.isWindow||t.isDocument?"":t.element.css("overflow-y"),e="scroll"===e||"auto"===e&&t.width<t.element[0].scrollWidth;return{width:"scroll"===i||"auto"===i&&t.height<t.element[0].scrollHeight?V.position.scrollbarWidth():0,height:e?V.position.scrollbarWidth():0}},getWithinInfo:function(t){var e=V(t||window),i=T(e[0]),s=!!e[0]&&9===e[0].nodeType;return{element:e,isWindow:i,isDocument:s,offset:!i&&!s?V(t).offset():{left:0,top:0},scrollLeft:e.scrollLeft(),scrollTop:e.scrollTop(),width:e.outerWidth(),height:e.outerHeight()}}},V.fn.position=function(u){if(!u||!u.of)return C.apply(this,arguments);var d,p,f,g,m,t,_="string"==typeof(u=V.extend({},u)).of?V(document).find(u.of):V(u.of),v=V.position.getWithinInfo(u.within),b=V.position.getScrollInfo(v),y=(u.collision||"flip").split(" "),w={},e=9===(t=(e=_)[0]).nodeType?{width:e.width(),height:e.height(),offset:{top:0,left:0}}:T(t)?{width:e.width(),height:e.height(),offset:{top:e.scrollTop(),left:e.scrollLeft()}}:t.preventDefault?{width:0,height:0,offset:{top:t.pageY,left:t.pageX}}:{width:e.outerWidth(),height:e.outerHeight(),offset:e.offset()};return _[0].preventDefault&&(u.at="left top"),p=e.width,f=e.height,m=V.extend({},g=e.offset),V.each(["my","at"],function(){var t,e,i=(u[this]||"").split(" ");(i=1===i.length?o.test(i[0])?i.concat(["center"]):l.test(i[0])?["center"].concat(i):["center","center"]:i)[0]=o.test(i[0])?i[0]:"center",i[1]=l.test(i[1])?i[1]:"center",t=h.exec(i[0]),e=h.exec(i[1]),w[this]=[t?t[0]:0,e?e[0]:0],u[this]=[c.exec(i[0])[0],c.exec(i[1])[0]]}),1===y.length&&(y[1]=y[0]),"right"===u.at[0]?m.left+=p:"center"===u.at[0]&&(m.left+=p/2),"bottom"===u.at[1]?m.top+=f:"center"===u.at[1]&&(m.top+=f/2),d=D(w.at,p,f),m.left+=d[0],m.top+=d[1],this.each(function(){var i,t,a=V(this),r=a.outerWidth(),l=a.outerHeight(),e=I(this,"marginLeft"),s=I(this,"marginTop"),n=r+e+I(this,"marginRight")+b.width,o=l+s+I(this,"marginBottom")+b.height,h=V.extend({},m),c=D(w.my,a.outerWidth(),a.outerHeight());"right"===u.my[0]?h.left-=r:"center"===u.my[0]&&(h.left-=r/2),"bottom"===u.my[1]?h.top-=l:"center"===u.my[1]&&(h.top-=l/2),h.left+=c[0],h.top+=c[1],i={marginLeft:e,marginTop:s},V.each(["left","top"],function(t,e){V.ui.position[y[t]]&&V.ui.position[y[t]][e](h,{targetWidth:p,targetHeight:f,elemWidth:r,elemHeight:l,collisionPosition:i,collisionWidth:n,collisionHeight:o,offset:[d[0]+c[0],d[1]+c[1]],my:u.my,at:u.at,within:v,elem:a})}),u.using&&(t=function(t){var e=g.left-h.left,i=e+p-r,s=g.top-h.top,n=s+f-l,o={target:{element:_,left:g.left,top:g.top,width:p,height:f},element:{element:a,left:h.left,top:h.top,width:r,height:l},horizontal:i<0?"left":0<e?"right":"center",vertical:n<0?"top":0<s?"bottom":"middle"};p<r&&k(e+i)<p&&(o.horizontal="center"),f<l&&k(s+n)<f&&(o.vertical="middle"),x(k(e),k(i))>x(k(s),k(n))?o.important="horizontal":o.important="vertical",u.using.call(this,t,o)}),a.offset(V.extend(h,{using:t}))})},V.ui.position={fit:{left:function(t,e){var i=e.within,s=i.isWindow?i.scrollLeft:i.offset.left,n=i.width,o=t.left-e.collisionPosition.marginLeft,a=s-o,r=o+e.collisionWidth-n-s;e.collisionWidth>n?0<a&&r<=0?(i=t.left+a+e.collisionWidth-n-s,t.left+=a-i):t.left=!(0<r&&a<=0)&&r<a?s+n-e.collisionWidth:s:0<a?t.left+=a:0<r?t.left-=r:t.left=x(t.left-o,t.left)},top:function(t,e){var i=e.within,s=i.isWindow?i.scrollTop:i.offset.top,n=e.within.height,o=t.top-e.collisionPosition.marginTop,a=s-o,r=o+e.collisionHeight-n-s;e.collisionHeight>n?0<a&&r<=0?(i=t.top+a+e.collisionHeight-n-s,t.top+=a-i):t.top=!(0<r&&a<=0)&&r<a?s+n-e.collisionHeight:s:0<a?t.top+=a:0<r?t.top-=r:t.top=x(t.top-o,t.top)}},flip:{left:function(t,e){var i=e.within,s=i.offset.left+i.scrollLeft,n=i.width,o=i.isWindow?i.scrollLeft:i.offset.left,a=t.left-e.collisionPosition.marginLeft,r=a-o,l=a+e.collisionWidth-n-o,h="left"===e.my[0]?-e.elemWidth:"right"===e.my[0]?e.elemWidth:0,i="left"===e.at[0]?e.targetWidth:"right"===e.at[0]?-e.targetWidth:0,a=-2*e.offset[0];r<0?((s=t.left+h+i+a+e.collisionWidth-n-s)<0||s<k(r))&&(t.left+=h+i+a):0<l&&(0<(o=t.left-e.collisionPosition.marginLeft+h+i+a-o)||k(o)<l)&&(t.left+=h+i+a)},top:function(t,e){var i=e.within,s=i.offset.top+i.scrollTop,n=i.height,o=i.isWindow?i.scrollTop:i.offset.top,a=t.top-e.collisionPosition.marginTop,r=a-o,l=a+e.collisionHeight-n-o,h="top"===e.my[1]?-e.elemHeight:"bottom"===e.my[1]?e.elemHeight:0,i="top"===e.at[1]?e.targetHeight:"bottom"===e.at[1]?-e.targetHeight:0,a=-2*e.offset[1];r<0?((s=t.top+h+i+a+e.collisionHeight-n-s)<0||s<k(r))&&(t.top+=h+i+a):0<l&&(0<(o=t.top-e.collisionPosition.marginTop+h+i+a-o)||k(o)<l)&&(t.top+=h+i+a)}},flipfit:{left:function(){V.ui.position.flip.left.apply(this,arguments),V.ui.position.fit.left.apply(this,arguments)},top:function(){V.ui.position.flip.top.apply(this,arguments),V.ui.position.fit.top.apply(this,arguments)}}};V.ui.position,V.extend(V.expr.pseudos,{data:V.expr.createPseudo?V.expr.createPseudo(function(e){return function(t){return!!V.data(t,e)}}):function(t,e,i){return!!V.data(t,i[3])}}),V.fn.extend({disableSelection:(t="onselectstart"in document.createElement("div")?"selectstart":"mousedown",function(){return this.on(t+".ui-disableSelection",function(t){t.preventDefault()})}),enableSelection:function(){return this.off(".ui-disableSelection")}});var t,d=V,p={},e=p.toString,f=/^([\-+])=\s*(\d+\.?\d*)/,g=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(t){return[t[1],t[2],t[3],t[4]]}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(t){return[2.55*t[1],2.55*t[2],2.55*t[3],t[4]]}},{re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,parse:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16),t[4]?(parseInt(t[4],16)/255).toFixed(2):1]}},{re:/#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,parse:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16),t[4]?(parseInt(t[4]+t[4],16)/255).toFixed(2):1]}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function(t){return[t[1],t[2]/100,t[3]/100,t[4]]}}],m=d.Color=function(t,e,i,s){return new d.Color.fn.parse(t,e,i,s)},_={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},v={byte:{floor:!0,max:255},percent:{max:1},degrees:{mod:360,floor:!0}},b=m.support={},y=d("<p>")[0],w=d.each;function P(t){return null==t?t+"":"object"==typeof t?p[e.call(t)]||"object":typeof t}function M(t,e,i){var s=v[e.type]||{};return null==t?i||!e.def?null:e.def:(t=s.floor?~~t:parseFloat(t),isNaN(t)?e.def:s.mod?(t+s.mod)%s.mod:Math.min(s.max,Math.max(0,t)))}function S(s){var n=m(),o=n._rgba=[];return s=s.toLowerCase(),w(g,function(t,e){var i=e.re.exec(s),i=i&&e.parse(i),e=e.space||"rgba";if(i)return i=n[e](i),n[_[e].cache]=i[_[e].cache],o=n._rgba=i._rgba,!1}),o.length?("0,0,0,0"===o.join()&&d.extend(o,B.transparent),n):B[s]}function H(t,e,i){return 6*(i=(i+1)%1)<1?t+(e-t)*i*6:2*i<1?e:3*i<2?t+(e-t)*(2/3-i)*6:t}y.style.cssText="background-color:rgba(1,1,1,.5)",b.rgba=-1<y.style.backgroundColor.indexOf("rgba"),w(_,function(t,e){e.cache="_"+t,e.props.alpha={idx:3,type:"percent",def:1}}),d.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(t,e){p["[object "+e+"]"]=e.toLowerCase()}),(m.fn=d.extend(m.prototype,{parse:function(n,t,e,i){if(void 0===n)return this._rgba=[null,null,null,null],this;(n.jquery||n.nodeType)&&(n=d(n).css(t),t=void 0);var o=this,s=P(n),a=this._rgba=[];return void 0!==t&&(n=[n,t,e,i],s="array"),"string"===s?this.parse(S(n)||B._default):"array"===s?(w(_.rgba.props,function(t,e){a[e.idx]=M(n[e.idx],e)}),this):"object"===s?(w(_,n instanceof m?function(t,e){n[e.cache]&&(o[e.cache]=n[e.cache].slice())}:function(t,i){var s=i.cache;w(i.props,function(t,e){if(!o[s]&&i.to){if("alpha"===t||null==n[t])return;o[s]=i.to(o._rgba)}o[s][e.idx]=M(n[t],e,!0)}),o[s]&&d.inArray(null,o[s].slice(0,3))<0&&(null==o[s][3]&&(o[s][3]=1),i.from&&(o._rgba=i.from(o[s])))}),this):void 0},is:function(t){var n=m(t),o=!0,a=this;return w(_,function(t,e){var i,s=n[e.cache];return s&&(i=a[e.cache]||e.to&&e.to(a._rgba)||[],w(e.props,function(t,e){if(null!=s[e.idx])return o=s[e.idx]===i[e.idx]})),o}),o},_space:function(){var i=[],s=this;return w(_,function(t,e){s[e.cache]&&i.push(t)}),i.pop()},transition:function(t,a){var e=(h=m(t))._space(),i=_[e],t=0===this.alpha()?m("transparent"):this,r=t[i.cache]||i.to(t._rgba),l=r.slice(),h=h[i.cache];return w(i.props,function(t,e){var i=e.idx,s=r[i],n=h[i],o=v[e.type]||{};null!==n&&(null===s?l[i]=n:(o.mod&&(n-s>o.mod/2?s+=o.mod:s-n>o.mod/2&&(s-=o.mod)),l[i]=M((n-s)*a+s,e)))}),this[e](l)},blend:function(t){if(1===this._rgba[3])return this;var e=this._rgba.slice(),i=e.pop(),s=m(t)._rgba;return m(d.map(e,function(t,e){return(1-i)*s[e]+i*t}))},toRgbaString:function(){var t="rgba(",e=d.map(this._rgba,function(t,e){return null!=t?t:2<e?1:0});return 1===e[3]&&(e.pop(),t="rgb("),t+e.join()+")"},toHslaString:function(){var t="hsla(",e=d.map(this.hsla(),function(t,e){return null==t&&(t=2<e?1:0),t=e&&e<3?Math.round(100*t)+"%":t});return 1===e[3]&&(e.pop(),t="hsl("),t+e.join()+")"},toHexString:function(t){var e=this._rgba.slice(),i=e.pop();return t&&e.push(~~(255*i)),"#"+d.map(e,function(t){return 1===(t=(t||0).toString(16)).length?"0"+t:t}).join("")},toString:function(){return 0===this._rgba[3]?"transparent":this.toRgbaString()}})).parse.prototype=m.fn,_.hsla.to=function(t){if(null==t[0]||null==t[1]||null==t[2])return[null,null,null,t[3]];var e=t[0]/255,i=t[1]/255,s=t[2]/255,n=t[3],o=Math.max(e,i,s),a=Math.min(e,i,s),r=o-a,l=o+a,t=.5*l,i=a===o?0:e===o?60*(i-s)/r+360:i===o?60*(s-e)/r+120:60*(e-i)/r+240,l=0==r?0:t<=.5?r/l:r/(2-l);return[Math.round(i)%360,l,t,null==n?1:n]},_.hsla.from=function(t){if(null==t[0]||null==t[1]||null==t[2])return[null,null,null,t[3]];var e=t[0]/360,i=t[1],s=t[2],t=t[3],i=s<=.5?s*(1+i):s+i-s*i,s=2*s-i;return[Math.round(255*H(s,i,e+1/3)),Math.round(255*H(s,i,e)),Math.round(255*H(s,i,e-1/3)),t]},w(_,function(l,t){var e=t.props,o=t.cache,a=t.to,r=t.from;m.fn[l]=function(t){if(a&&!this[o]&&(this[o]=a(this._rgba)),void 0===t)return this[o].slice();var i=P(t),s="array"===i||"object"===i?t:arguments,n=this[o].slice();return w(e,function(t,e){t=s["object"===i?t:e.idx];null==t&&(t=n[e.idx]),n[e.idx]=M(t,e)}),r?((t=m(r(n)))[o]=n,t):m(n)},w(e,function(a,r){m.fn[a]||(m.fn[a]=function(t){var e,i=P(t),s="alpha"===a?this._hsla?"hsla":"rgba":l,n=this[s](),o=n[r.idx];return"undefined"===i?o:("function"===i&&(i=P(t=t.call(this,o))),null==t&&r.empty?this:("string"===i&&(e=f.exec(t))&&(t=o+parseFloat(e[2])*("+"===e[1]?1:-1)),n[r.idx]=t,this[s](n)))})})}),(m.hook=function(t){t=t.split(" ");w(t,function(t,o){d.cssHooks[o]={set:function(t,e){var i,s,n="";if("transparent"!==e&&("string"!==P(e)||(i=S(e)))){if(e=m(i||e),!b.rgba&&1!==e._rgba[3]){for(s="backgroundColor"===o?t.parentNode:t;(""===n||"transparent"===n)&&s&&s.style;)try{n=d.css(s,"backgroundColor"),s=s.parentNode}catch(t){}e=e.blend(n&&"transparent"!==n?n:"_default")}e=e.toRgbaString()}try{t.style[o]=e}catch(t){}}},d.fx.step[o]=function(t){t.colorInit||(t.start=m(t.elem,o),t.end=m(t.end),t.colorInit=!0),d.cssHooks[o].set(t.elem,t.start.transition(t.end,t.pos))}})})("backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor"),d.cssHooks.borderColor={expand:function(i){var s={};return w(["Top","Right","Bottom","Left"],function(t,e){s["border"+e+"Color"]=i}),s}};var z,A,O,N,E,W,F,L,R,Y,B=d.Color.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",transparent:[null,null,null,0],_default:"#ffffff"},j="ui-effects-",q="ui-effects-style",K="ui-effects-animated";function U(t){var e,i,s=t.ownerDocument.defaultView?t.ownerDocument.defaultView.getComputedStyle(t,null):t.currentStyle,n={};if(s&&s.length&&s[0]&&s[s[0]])for(i=s.length;i--;)"string"==typeof s[e=s[i]]&&(n[e.replace(/-([\da-z])/gi,function(t,e){return e.toUpperCase()})]=s[e]);else for(e in s)"string"==typeof s[e]&&(n[e]=s[e]);return n}function X(t,e,i,s){return t={effect:t=V.isPlainObject(t)?(e=t).effect:t},"function"==typeof(e=null==e?{}:e)&&(s=e,i=null,e={}),"number"!=typeof e&&!V.fx.speeds[e]||(s=i,i=e,e={}),"function"==typeof i&&(s=i,i=null),e&&V.extend(t,e),i=i||e.duration,t.duration=V.fx.off?0:"number"==typeof i?i:i in V.fx.speeds?V.fx.speeds[i]:V.fx.speeds._default,t.complete=s||e.complete,t}function $(t){return!t||"number"==typeof t||V.fx.speeds[t]||("string"==typeof t&&!V.effects.effect[t]||("function"==typeof t||"object"==typeof t&&!t.effect))}function G(t,e){var i=e.outerWidth(),e=e.outerHeight(),t=/^rect\((-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto)\)$/.exec(t)||["",0,i,e,0];return{top:parseFloat(t[1])||0,right:"auto"===t[2]?i:parseFloat(t[2]),bottom:"auto"===t[3]?e:parseFloat(t[3]),left:parseFloat(t[4])||0}}V.effects={effect:{}},N=["add","remove","toggle"],E={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1},V.each(["borderLeftStyle","borderRightStyle","borderBottomStyle","borderTopStyle"],function(t,e){V.fx.step[e]=function(t){("none"!==t.end&&!t.setAttr||1===t.pos&&!t.setAttr)&&(d.style(t.elem,e,t.end),t.setAttr=!0)}}),V.fn.addBack||(V.fn.addBack=function(t){return this.add(null==t?this.prevObject:this.prevObject.filter(t))}),V.effects.animateClass=function(n,t,e,i){var o=V.speed(t,e,i);return this.queue(function(){var i=V(this),t=i.attr("class")||"",e=(e=o.children?i.find("*").addBack():i).map(function(){return{el:V(this),start:U(this)}}),s=function(){V.each(N,function(t,e){n[e]&&i[e+"Class"](n[e])})};s(),e=e.map(function(){return this.end=U(this.el[0]),this.diff=function(t,e){var i,s,n={};for(i in e)s=e[i],t[i]!==s&&(E[i]||!V.fx.step[i]&&isNaN(parseFloat(s))||(n[i]=s));return n}(this.start,this.end),this}),i.attr("class",t),e=e.map(function(){var t=this,e=V.Deferred(),i=V.extend({},o,{queue:!1,complete:function(){e.resolve(t)}});return this.el.animate(this.diff,i),e.promise()}),V.when.apply(V,e.get()).done(function(){s(),V.each(arguments,function(){var e=this.el;V.each(this.diff,function(t){e.css(t,"")})}),o.complete.call(i[0])})})},V.fn.extend({addClass:(O=V.fn.addClass,function(t,e,i,s){return e?V.effects.animateClass.call(this,{add:t},e,i,s):O.apply(this,arguments)}),removeClass:(A=V.fn.removeClass,function(t,e,i,s){return 1<arguments.length?V.effects.animateClass.call(this,{remove:t},e,i,s):A.apply(this,arguments)}),toggleClass:(z=V.fn.toggleClass,function(t,e,i,s,n){return"boolean"==typeof e||void 0===e?i?V.effects.animateClass.call(this,e?{add:t}:{remove:t},i,s,n):z.apply(this,arguments):V.effects.animateClass.call(this,{toggle:t},e,i,s)}),switchClass:function(t,e,i,s,n){return V.effects.animateClass.call(this,{add:e,remove:t},i,s,n)}}),V.expr&&V.expr.pseudos&&V.expr.pseudos.animated&&(V.expr.pseudos.animated=(W=V.expr.pseudos.animated,function(t){return!!V(t).data(K)||W(t)})),!1!==V.uiBackCompat&&V.extend(V.effects,{save:function(t,e){for(var i=0,s=e.length;i<s;i++)null!==e[i]&&t.data(j+e[i],t[0].style[e[i]])},restore:function(t,e){for(var i,s=0,n=e.length;s<n;s++)null!==e[s]&&(i=t.data(j+e[s]),t.css(e[s],i))},setMode:function(t,e){return e="toggle"===e?t.is(":hidden")?"show":"hide":e},createWrapper:function(i){if(i.parent().is(".ui-effects-wrapper"))return i.parent();var s={width:i.outerWidth(!0),height:i.outerHeight(!0),float:i.css("float")},t=V("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),e={width:i.width(),height:i.height()},n=document.activeElement;try{n.id}catch(t){n=document.body}return i.wrap(t),i[0]!==n&&!V.contains(i[0],n)||V(n).trigger("focus"),t=i.parent(),"static"===i.css("position")?(t.css({position:"relative"}),i.css({position:"relative"})):(V.extend(s,{position:i.css("position"),zIndex:i.css("z-index")}),V.each(["top","left","bottom","right"],function(t,e){s[e]=i.css(e),isNaN(parseInt(s[e],10))&&(s[e]="auto")}),i.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"})),i.css(e),t.css(s).show()},removeWrapper:function(t){var e=document.activeElement;return t.parent().is(".ui-effects-wrapper")&&(t.parent().replaceWith(t),t[0]!==e&&!V.contains(t[0],e)||V(e).trigger("focus")),t}}),V.extend(V.effects,{version:"1.13.0",define:function(t,e,i){return i||(i=e,e="effect"),V.effects.effect[t]=i,V.effects.effect[t].mode=e,i},scaledDimensions:function(t,e,i){if(0===e)return{height:0,width:0,outerHeight:0,outerWidth:0};var s="horizontal"!==i?(e||100)/100:1,e="vertical"!==i?(e||100)/100:1;return{height:t.height()*e,width:t.width()*s,outerHeight:t.outerHeight()*e,outerWidth:t.outerWidth()*s}},clipToBox:function(t){return{width:t.clip.right-t.clip.left,height:t.clip.bottom-t.clip.top,left:t.clip.left,top:t.clip.top}},unshift:function(t,e,i){var s=t.queue();1<e&&s.splice.apply(s,[1,0].concat(s.splice(e,i))),t.dequeue()},saveStyle:function(t){t.data(q,t[0].style.cssText)},restoreStyle:function(t){t[0].style.cssText=t.data(q)||"",t.removeData(q)},mode:function(t,e){t=t.is(":hidden");return"toggle"===e&&(e=t?"show":"hide"),e=(t?"hide"===e:"show"===e)?"none":e},getBaseline:function(t,e){var i,s;switch(t[0]){case"top":i=0;break;case"middle":i=.5;break;case"bottom":i=1;break;default:i=t[0]/e.height}switch(t[1]){case"left":s=0;break;case"center":s=.5;break;case"right":s=1;break;default:s=t[1]/e.width}return{x:s,y:i}},createPlaceholder:function(t){var e,i=t.css("position"),s=t.position();return t.css({marginTop:t.css("marginTop"),marginBottom:t.css("marginBottom"),marginLeft:t.css("marginLeft"),marginRight:t.css("marginRight")}).outerWidth(t.outerWidth()).outerHeight(t.outerHeight()),/^(static|relative)/.test(i)&&(i="absolute",e=V("<"+t[0].nodeName+">").insertAfter(t).css({display:/^(inline|ruby)/.test(t.css("display"))?"inline-block":"block",visibility:"hidden",marginTop:t.css("marginTop"),marginBottom:t.css("marginBottom"),marginLeft:t.css("marginLeft"),marginRight:t.css("marginRight"),float:t.css("float")}).outerWidth(t.outerWidth()).outerHeight(t.outerHeight()).addClass("ui-effects-placeholder"),t.data(j+"placeholder",e)),t.css({position:i,left:s.left,top:s.top}),e},removePlaceholder:function(t){var e=j+"placeholder",i=t.data(e);i&&(i.remove(),t.removeData(e))},cleanUp:function(t){V.effects.restoreStyle(t),V.effects.removePlaceholder(t)},setTransition:function(s,t,n,o){return o=o||{},V.each(t,function(t,e){var i=s.cssUnit(e);0<i[0]&&(o[e]=i[0]*n+i[1])}),o}}),V.fn.extend({effect:function(){function t(t){var e=V(this),i=V.effects.mode(e,r)||o;e.data(K,!0),l.push(i),o&&("show"===i||i===o&&"hide"===i)&&e.show(),o&&"none"===i||V.effects.saveStyle(e),"function"==typeof t&&t()}var s=X.apply(this,arguments),n=V.effects.effect[s.effect],o=n.mode,e=s.queue,i=e||"fx",a=s.complete,r=s.mode,l=[];return V.fx.off||!n?r?this[r](s.duration,a):this.each(function(){a&&a.call(this)}):!1===e?this.each(t).each(h):this.queue(i,t).queue(i,h);function h(t){var e=V(this);function i(){"function"==typeof a&&a.call(e[0]),"function"==typeof t&&t()}s.mode=l.shift(),!1===V.uiBackCompat||o?"none"===s.mode?(e[r](),i()):n.call(e[0],s,function(){e.removeData(K),V.effects.cleanUp(e),"hide"===s.mode&&e.hide(),i()}):(e.is(":hidden")?"hide"===r:"show"===r)?(e[r](),i()):n.call(e[0],s,i)}},show:(R=V.fn.show,function(t){if($(t))return R.apply(this,arguments);t=X.apply(this,arguments);return t.mode="show",this.effect.call(this,t)}),hide:(L=V.fn.hide,function(t){if($(t))return L.apply(this,arguments);t=X.apply(this,arguments);return t.mode="hide",this.effect.call(this,t)}),toggle:(F=V.fn.toggle,function(t){if($(t)||"boolean"==typeof t)return F.apply(this,arguments);t=X.apply(this,arguments);return t.mode="toggle",this.effect.call(this,t)}),cssUnit:function(t){var i=this.css(t),s=[];return V.each(["em","px","%","pt"],function(t,e){0<i.indexOf(e)&&(s=[parseFloat(i),e])}),s},cssClip:function(t){return t?this.css("clip","rect("+t.top+"px "+t.right+"px "+t.bottom+"px "+t.left+"px)"):G(this.css("clip"),this)},transfer:function(t,e){var i=V(this),s=V(t.to),n="fixed"===s.css("position"),o=V("body"),a=n?o.scrollTop():0,r=n?o.scrollLeft():0,o=s.offset(),o={top:o.top-a,left:o.left-r,height:s.innerHeight(),width:s.innerWidth()},s=i.offset(),l=V("<div class='ui-effects-transfer'></div>");l.appendTo("body").addClass(t.className).css({top:s.top-a,left:s.left-r,height:i.innerHeight(),width:i.innerWidth(),position:n?"fixed":"absolute"}).animate(o,t.duration,t.easing,function(){l.remove(),"function"==typeof e&&e()})}}),V.fx.step.clip=function(t){t.clipInit||(t.start=V(t.elem).cssClip(),"string"==typeof t.end&&(t.end=G(t.end,t.elem)),t.clipInit=!0),V(t.elem).cssClip({top:t.pos*(t.end.top-t.start.top)+t.start.top,right:t.pos*(t.end.right-t.start.right)+t.start.right,bottom:t.pos*(t.end.bottom-t.start.bottom)+t.start.bottom,left:t.pos*(t.end.left-t.start.left)+t.start.left})},Y={},V.each(["Quad","Cubic","Quart","Quint","Expo"],function(e,t){Y[t]=function(t){return Math.pow(t,e+2)}}),V.extend(Y,{Sine:function(t){return 1-Math.cos(t*Math.PI/2)},Circ:function(t){return 1-Math.sqrt(1-t*t)},Elastic:function(t){return 0===t||1===t?t:-Math.pow(2,8*(t-1))*Math.sin((80*(t-1)-7.5)*Math.PI/15)},Back:function(t){return t*t*(3*t-2)},Bounce:function(t){for(var e,i=4;t<((e=Math.pow(2,--i))-1)/11;);return 1/Math.pow(4,3-i)-7.5625*Math.pow((3*e-2)/22-t,2)}}),V.each(Y,function(t,e){V.easing["easeIn"+t]=e,V.easing["easeOut"+t]=function(t){return 1-e(1-t)},V.easing["easeInOut"+t]=function(t){return t<.5?e(2*t)/2:1-e(-2*t+2)/2}});y=V.effects,V.effects.define("blind","hide",function(t,e){var i={up:["bottom","top"],vertical:["bottom","top"],down:["top","bottom"],left:["right","left"],horizontal:["right","left"],right:["left","right"]},s=V(this),n=t.direction||"up",o=s.cssClip(),a={clip:V.extend({},o)},r=V.effects.createPlaceholder(s);a.clip[i[n][0]]=a.clip[i[n][1]],"show"===t.mode&&(s.cssClip(a.clip),r&&r.css(V.effects.clipToBox(a)),a.clip=o),r&&r.animate(V.effects.clipToBox(a),t.duration,t.easing),s.animate(a,{queue:!1,duration:t.duration,easing:t.easing,complete:e})}),V.effects.define("bounce",function(t,e){var i,s,n=V(this),o=t.mode,a="hide"===o,r="show"===o,l=t.direction||"up",h=t.distance,c=t.times||5,o=2*c+(r||a?1:0),u=t.duration/o,d=t.easing,p="up"===l||"down"===l?"top":"left",f="up"===l||"left"===l,g=0,t=n.queue().length;for(V.effects.createPlaceholder(n),l=n.css(p),h=h||n["top"==p?"outerHeight":"outerWidth"]()/3,r&&((s={opacity:1})[p]=l,n.css("opacity",0).css(p,f?2*-h:2*h).animate(s,u,d)),a&&(h/=Math.pow(2,c-1)),(s={})[p]=l;g<c;g++)(i={})[p]=(f?"-=":"+=")+h,n.animate(i,u,d).animate(s,u,d),h=a?2*h:h/2;a&&((i={opacity:0})[p]=(f?"-=":"+=")+h,n.animate(i,u,d)),n.queue(e),V.effects.unshift(n,t,1+o)}),V.effects.define("clip","hide",function(t,e){var i={},s=V(this),n=t.direction||"vertical",o="both"===n,a=o||"horizontal"===n,o=o||"vertical"===n,n=s.cssClip();i.clip={top:o?(n.bottom-n.top)/2:n.top,right:a?(n.right-n.left)/2:n.right,bottom:o?(n.bottom-n.top)/2:n.bottom,left:a?(n.right-n.left)/2:n.left},V.effects.createPlaceholder(s),"show"===t.mode&&(s.cssClip(i.clip),i.clip=n),s.animate(i,{queue:!1,duration:t.duration,easing:t.easing,complete:e})}),V.effects.define("drop","hide",function(t,e){var i=V(this),s="show"===t.mode,n=t.direction||"left",o="up"===n||"down"===n?"top":"left",a="up"===n||"left"===n?"-=":"+=",r="+="==a?"-=":"+=",l={opacity:0};V.effects.createPlaceholder(i),n=t.distance||i["top"==o?"outerHeight":"outerWidth"](!0)/2,l[o]=a+n,s&&(i.css(l),l[o]=r+n,l.opacity=1),i.animate(l,{queue:!1,duration:t.duration,easing:t.easing,complete:e})}),V.effects.define("explode","hide",function(t,e){var i,s,n,o,a,r,l=t.pieces?Math.round(Math.sqrt(t.pieces)):3,h=l,c=V(this),u="show"===t.mode,d=c.show().css("visibility","hidden").offset(),p=Math.ceil(c.outerWidth()/h),f=Math.ceil(c.outerHeight()/l),g=[];function m(){g.push(this),g.length===l*h&&(c.css({visibility:"visible"}),V(g).remove(),e())}for(i=0;i<l;i++)for(o=d.top+i*f,r=i-(l-1)/2,s=0;s<h;s++)n=d.left+s*p,a=s-(h-1)/2,c.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",visibility:"visible",left:-s*p,top:-i*f}).parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:p,height:f,left:n+(u?a*p:0),top:o+(u?r*f:0),opacity:u?0:1}).animate({left:n+(u?0:a*p),top:o+(u?0:r*f),opacity:u?1:0},t.duration||500,t.easing,m)}),V.effects.define("fade","toggle",function(t,e){var i="show"===t.mode;V(this).css("opacity",i?0:1).animate({opacity:i?1:0},{queue:!1,duration:t.duration,easing:t.easing,complete:e})}),V.effects.define("fold","hide",function(e,t){var i=V(this),s=e.mode,n="show"===s,o="hide"===s,a=e.size||15,r=/([0-9]+)%/.exec(a),l=!!e.horizFirst?["right","bottom"]:["bottom","right"],h=e.duration/2,c=V.effects.createPlaceholder(i),u=i.cssClip(),d={clip:V.extend({},u)},p={clip:V.extend({},u)},f=[u[l[0]],u[l[1]]],s=i.queue().length;r&&(a=parseInt(r[1],10)/100*f[o?0:1]),d.clip[l[0]]=a,p.clip[l[0]]=a,p.clip[l[1]]=0,n&&(i.cssClip(p.clip),c&&c.css(V.effects.clipToBox(p)),p.clip=u),i.queue(function(t){c&&c.animate(V.effects.clipToBox(d),h,e.easing).animate(V.effects.clipToBox(p),h,e.easing),t()}).animate(d,h,e.easing).animate(p,h,e.easing).queue(t),V.effects.unshift(i,s,4)}),V.effects.define("highlight","show",function(t,e){var i=V(this),s={backgroundColor:i.css("backgroundColor")};"hide"===t.mode&&(s.opacity=0),V.effects.saveStyle(i),i.css({backgroundImage:"none",backgroundColor:t.color||"#ffff99"}).animate(s,{queue:!1,duration:t.duration,easing:t.easing,complete:e})}),V.effects.define("size",function(s,e){var n,i=V(this),t=["fontSize"],o=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],a=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],r=s.mode,l="effect"!==r,h=s.scale||"both",c=s.origin||["middle","center"],u=i.css("position"),d=i.position(),p=V.effects.scaledDimensions(i),f=s.from||p,g=s.to||V.effects.scaledDimensions(i,0);V.effects.createPlaceholder(i),"show"===r&&(r=f,f=g,g=r),n={from:{y:f.height/p.height,x:f.width/p.width},to:{y:g.height/p.height,x:g.width/p.width}},"box"!==h&&"both"!==h||(n.from.y!==n.to.y&&(f=V.effects.setTransition(i,o,n.from.y,f),g=V.effects.setTransition(i,o,n.to.y,g)),n.from.x!==n.to.x&&(f=V.effects.setTransition(i,a,n.from.x,f),g=V.effects.setTransition(i,a,n.to.x,g))),"content"!==h&&"both"!==h||n.from.y!==n.to.y&&(f=V.effects.setTransition(i,t,n.from.y,f),g=V.effects.setTransition(i,t,n.to.y,g)),c&&(c=V.effects.getBaseline(c,p),f.top=(p.outerHeight-f.outerHeight)*c.y+d.top,f.left=(p.outerWidth-f.outerWidth)*c.x+d.left,g.top=(p.outerHeight-g.outerHeight)*c.y+d.top,g.left=(p.outerWidth-g.outerWidth)*c.x+d.left),delete f.outerHeight,delete f.outerWidth,i.css(f),"content"!==h&&"both"!==h||(o=o.concat(["marginTop","marginBottom"]).concat(t),a=a.concat(["marginLeft","marginRight"]),i.find("*[width]").each(function(){var t=V(this),e=V.effects.scaledDimensions(t),i={height:e.height*n.from.y,width:e.width*n.from.x,outerHeight:e.outerHeight*n.from.y,outerWidth:e.outerWidth*n.from.x},e={height:e.height*n.to.y,width:e.width*n.to.x,outerHeight:e.height*n.to.y,outerWidth:e.width*n.to.x};n.from.y!==n.to.y&&(i=V.effects.setTransition(t,o,n.from.y,i),e=V.effects.setTransition(t,o,n.to.y,e)),n.from.x!==n.to.x&&(i=V.effects.setTransition(t,a,n.from.x,i),e=V.effects.setTransition(t,a,n.to.x,e)),l&&V.effects.saveStyle(t),t.css(i),t.animate(e,s.duration,s.easing,function(){l&&V.effects.restoreStyle(t)})})),i.animate(g,{queue:!1,duration:s.duration,easing:s.easing,complete:function(){var t=i.offset();0===g.opacity&&i.css("opacity",f.opacity),l||(i.css("position","static"===u?"relative":u).offset(t),V.effects.saveStyle(i)),e()}})}),V.effects.define("scale",function(t,e){var i=V(this),s=t.mode,s=parseInt(t.percent,10)||(0===parseInt(t.percent,10)||"effect"!==s?0:100),s=V.extend(!0,{from:V.effects.scaledDimensions(i),to:V.effects.scaledDimensions(i,s,t.direction||"both"),origin:t.origin||["middle","center"]},t);t.fade&&(s.from.opacity=1,s.to.opacity=0),V.effects.effect.size.call(this,s,e)}),V.effects.define("puff","hide",function(t,e){t=V.extend(!0,{},t,{fade:!0,percent:parseInt(t.percent,10)||150});V.effects.effect.scale.call(this,t,e)}),V.effects.define("pulsate","show",function(t,e){var i=V(this),s=t.mode,n="show"===s,o=2*(t.times||5)+(n||"hide"===s?1:0),a=t.duration/o,r=0,l=1,s=i.queue().length;for(!n&&i.is(":visible")||(i.css("opacity",0).show(),r=1);l<o;l++)i.animate({opacity:r},a,t.easing),r=1-r;i.animate({opacity:r},a,t.easing),i.queue(e),V.effects.unshift(i,s,1+o)}),V.effects.define("shake",function(t,e){var i=1,s=V(this),n=t.direction||"left",o=t.distance||20,a=t.times||3,r=2*a+1,l=Math.round(t.duration/r),h="up"===n||"down"===n?"top":"left",c="up"===n||"left"===n,u={},d={},p={},n=s.queue().length;for(V.effects.createPlaceholder(s),u[h]=(c?"-=":"+=")+o,d[h]=(c?"+=":"-=")+2*o,p[h]=(c?"-=":"+=")+2*o,s.animate(u,l,t.easing);i<a;i++)s.animate(d,l,t.easing).animate(p,l,t.easing);s.animate(d,l,t.easing).animate(u,l/2,t.easing).queue(e),V.effects.unshift(s,n,1+r)}),V.effects.define("slide","show",function(t,e){var i,s,n=V(this),o={up:["bottom","top"],down:["top","bottom"],left:["right","left"],right:["left","right"]},a=t.mode,r=t.direction||"left",l="up"===r||"down"===r?"top":"left",h="up"===r||"left"===r,c=t.distance||n["top"==l?"outerHeight":"outerWidth"](!0),u={};V.effects.createPlaceholder(n),i=n.cssClip(),s=n.position()[l],u[l]=(h?-1:1)*c+s,u.clip=n.cssClip(),u.clip[o[r][1]]=u.clip[o[r][0]],"show"===a&&(n.cssClip(u.clip),n.css(l,u[l]),u.clip=i,u[l]=s),n.animate(u,{queue:!1,duration:t.duration,easing:t.easing,complete:e})}),y=!1!==V.uiBackCompat?V.effects.define("transfer",function(t,e){V(this).transfer(t,e)}):y;V.ui.focusable=function(t,e){var i,s,n,o,a=t.nodeName.toLowerCase();return"area"===a?(s=(i=t.parentNode).name,!(!t.href||!s||"map"!==i.nodeName.toLowerCase())&&(0<(s=V("img[usemap='#"+s+"']")).length&&s.is(":visible"))):(/^(input|select|textarea|button|object)$/.test(a)?(n=!t.disabled)&&(o=V(t).closest("fieldset")[0])&&(n=!o.disabled):n="a"===a&&t.href||e,n&&V(t).is(":visible")&&function(t){var e=t.css("visibility");for(;"inherit"===e;)t=t.parent(),e=t.css("visibility");return"visible"===e}(V(t)))},V.extend(V.expr.pseudos,{focusable:function(t){return V.ui.focusable(t,null!=V.attr(t,"tabindex"))}});var Q,J;V.ui.focusable,V.fn._form=function(){return"string"==typeof this[0].form?this.closest("form"):V(this[0].form)},V.ui.formResetMixin={_formResetHandler:function(){var e=V(this);setTimeout(function(){var t=e.data("ui-form-reset-instances");V.each(t,function(){this.refresh()})})},_bindFormResetHandler:function(){var t;this.form=this.element._form(),this.form.length&&((t=this.form.data("ui-form-reset-instances")||[]).length||this.form.on("reset.ui-form-reset",this._formResetHandler),t.push(this),this.form.data("ui-form-reset-instances",t))},_unbindFormResetHandler:function(){var t;this.form.length&&((t=this.form.data("ui-form-reset-instances")).splice(V.inArray(this,t),1),t.length?this.form.data("ui-form-reset-instances",t):this.form.removeData("ui-form-reset-instances").off("reset.ui-form-reset"))}};V.expr.pseudos||(V.expr.pseudos=V.expr[":"]),V.uniqueSort||(V.uniqueSort=V.unique),V.escapeSelector||(Q=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g,J=function(t,e){return e?"\0"===t?"�":t.slice(0,-1)+"\\"+t.charCodeAt(t.length-1).toString(16)+" ":"\\"+t},V.escapeSelector=function(t){return(t+"").replace(Q,J)}),V.fn.even&&V.fn.odd||V.fn.extend({even:function(){return this.filter(function(t){return t%2==0})},odd:function(){return this.filter(function(t){return t%2==1})}});var Z;V.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38},V.fn.labels=function(){var t,e,i;return this.length?this[0].labels&&this[0].labels.length?this.pushStack(this[0].labels):(e=this.eq(0).parents("label"),(t=this.attr("id"))&&(i=(i=this.eq(0).parents().last()).add((i.length?i:this).siblings()),t="label[for='"+V.escapeSelector(t)+"']",e=e.add(i.find(t).addBack(t))),this.pushStack(e)):this.pushStack([])},V.fn.scrollParent=function(t){var e=this.css("position"),i="absolute"===e,s=t?/(auto|scroll|hidden)/:/(auto|scroll)/,t=this.parents().filter(function(){var t=V(this);return(!i||"static"!==t.css("position"))&&s.test(t.css("overflow")+t.css("overflow-y")+t.css("overflow-x"))}).eq(0);return"fixed"!==e&&t.length?t:V(this[0].ownerDocument||document)},V.extend(V.expr.pseudos,{tabbable:function(t){var e=V.attr(t,"tabindex"),i=null!=e;return(!i||0<=e)&&V.ui.focusable(t,i)}}),V.fn.extend({uniqueId:(Z=0,function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++Z)})}),removeUniqueId:function(){return this.each(function(){/^ui-id-\d+$/.test(this.id)&&V(this).removeAttr("id")})}}),V.widget("ui.accordion",{version:"1.13.0",options:{active:0,animate:{},classes:{"ui-accordion-header":"ui-corner-top","ui-accordion-header-collapsed":"ui-corner-all","ui-accordion-content":"ui-corner-bottom"},collapsible:!1,event:"click",header:function(t){return t.find("> li > :first-child").add(t.find("> :not(li)").even())},heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},activate:null,beforeActivate:null},hideProps:{borderTopWidth:"hide",borderBottomWidth:"hide",paddingTop:"hide",paddingBottom:"hide",height:"hide"},showProps:{borderTopWidth:"show",borderBottomWidth:"show",paddingTop:"show",paddingBottom:"show",height:"show"},_create:function(){var t=this.options;this.prevShow=this.prevHide=V(),this._addClass("ui-accordion","ui-widget ui-helper-reset"),this.element.attr("role","tablist"),t.collapsible||!1!==t.active&&null!=t.active||(t.active=0),this._processPanels(),t.active<0&&(t.active+=this.headers.length),this._refresh()},_getCreateEventData:function(){return{header:this.active,panel:this.active.length?this.active.next():V()}},_createIcons:function(){var t,e=this.options.icons;e&&(t=V("<span>"),this._addClass(t,"ui-accordion-header-icon","ui-icon "+e.header),t.prependTo(this.headers),t=this.active.children(".ui-accordion-header-icon"),this._removeClass(t,e.header)._addClass(t,null,e.activeHeader)._addClass(this.headers,"ui-accordion-icons"))},_destroyIcons:function(){this._removeClass(this.headers,"ui-accordion-icons"),this.headers.children(".ui-accordion-header-icon").remove()},_destroy:function(){var t;this.element.removeAttr("role"),this.headers.removeAttr("role aria-expanded aria-selected aria-controls tabIndex").removeUniqueId(),this._destroyIcons(),t=this.headers.next().css("display","").removeAttr("role aria-hidden aria-labelledby").removeUniqueId(),"content"!==this.options.heightStyle&&t.css("height","")},_setOption:function(t,e){"active"!==t?("event"===t&&(this.options.event&&this._off(this.headers,this.options.event),this._setupEvents(e)),this._super(t,e),"collapsible"!==t||e||!1!==this.options.active||this._activate(0),"icons"===t&&(this._destroyIcons(),e&&this._createIcons())):this._activate(e)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t),this._toggleClass(null,"ui-state-disabled",!!t),this._toggleClass(this.headers.add(this.headers.next()),null,"ui-state-disabled",!!t)},_keydown:function(t){if(!t.altKey&&!t.ctrlKey){var e=V.ui.keyCode,i=this.headers.length,s=this.headers.index(t.target),n=!1;switch(t.keyCode){case e.RIGHT:case e.DOWN:n=this.headers[(s+1)%i];break;case e.LEFT:case e.UP:n=this.headers[(s-1+i)%i];break;case e.SPACE:case e.ENTER:this._eventHandler(t);break;case e.HOME:n=this.headers[0];break;case e.END:n=this.headers[i-1]}n&&(V(t.target).attr("tabIndex",-1),V(n).attr("tabIndex",0),V(n).trigger("focus"),t.preventDefault())}},_panelKeyDown:function(t){t.keyCode===V.ui.keyCode.UP&&t.ctrlKey&&V(t.currentTarget).prev().trigger("focus")},refresh:function(){var t=this.options;this._processPanels(),!1===t.active&&!0===t.collapsible||!this.headers.length?(t.active=!1,this.active=V()):!1===t.active?this._activate(0):this.active.length&&!V.contains(this.element[0],this.active[0])?this.headers.length===this.headers.find(".ui-state-disabled").length?(t.active=!1,this.active=V()):this._activate(Math.max(0,t.active-1)):t.active=this.headers.index(this.active),this._destroyIcons(),this._refresh()},_processPanels:function(){var t=this.headers,e=this.panels;"function"==typeof this.options.header?this.headers=this.options.header(this.element):this.headers=this.element.find(this.options.header),this._addClass(this.headers,"ui-accordion-header ui-accordion-header-collapsed","ui-state-default"),this.panels=this.headers.next().filter(":not(.ui-accordion-content-active)").hide(),this._addClass(this.panels,"ui-accordion-content","ui-helper-reset ui-widget-content"),e&&(this._off(t.not(this.headers)),this._off(e.not(this.panels)))},_refresh:function(){var i,t=this.options,e=t.heightStyle,s=this.element.parent();this.active=this._findActive(t.active),this._addClass(this.active,"ui-accordion-header-active","ui-state-active")._removeClass(this.active,"ui-accordion-header-collapsed"),this._addClass(this.active.next(),"ui-accordion-content-active"),this.active.next().show(),this.headers.attr("role","tab").each(function(){var t=V(this),e=t.uniqueId().attr("id"),i=t.next(),s=i.uniqueId().attr("id");t.attr("aria-controls",s),i.attr("aria-labelledby",e)}).next().attr("role","tabpanel"),this.headers.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}).next().attr({"aria-hidden":"true"}).hide(),this.active.length?this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}).next().attr({"aria-hidden":"false"}):this.headers.eq(0).attr("tabIndex",0),this._createIcons(),this._setupEvents(t.event),"fill"===e?(i=s.height(),this.element.siblings(":visible").each(function(){var t=V(this),e=t.css("position");"absolute"!==e&&"fixed"!==e&&(i-=t.outerHeight(!0))}),this.headers.each(function(){i-=V(this).outerHeight(!0)}),this.headers.next().each(function(){V(this).height(Math.max(0,i-V(this).innerHeight()+V(this).height()))}).css("overflow","auto")):"auto"===e&&(i=0,this.headers.next().each(function(){var t=V(this).is(":visible");t||V(this).show(),i=Math.max(i,V(this).css("height","").height()),t||V(this).hide()}).height(i))},_activate:function(t){t=this._findActive(t)[0];t!==this.active[0]&&(t=t||this.active[0],this._eventHandler({target:t,currentTarget:t,preventDefault:V.noop}))},_findActive:function(t){return"number"==typeof t?this.headers.eq(t):V()},_setupEvents:function(t){var i={keydown:"_keydown"};t&&V.each(t.split(" "),function(t,e){i[e]="_eventHandler"}),this._off(this.headers.add(this.headers.next())),this._on(this.headers,i),this._on(this.headers.next(),{keydown:"_panelKeyDown"}),this._hoverable(this.headers),this._focusable(this.headers)},_eventHandler:function(t){var e=this.options,i=this.active,s=V(t.currentTarget),n=s[0]===i[0],o=n&&e.collapsible,a=o?V():s.next(),r=i.next(),a={oldHeader:i,oldPanel:r,newHeader:o?V():s,newPanel:a};t.preventDefault(),n&&!e.collapsible||!1===this._trigger("beforeActivate",t,a)||(e.active=!o&&this.headers.index(s),this.active=n?V():s,this._toggle(a),this._removeClass(i,"ui-accordion-header-active","ui-state-active"),e.icons&&(i=i.children(".ui-accordion-header-icon"),this._removeClass(i,null,e.icons.activeHeader)._addClass(i,null,e.icons.header)),n||(this._removeClass(s,"ui-accordion-header-collapsed")._addClass(s,"ui-accordion-header-active","ui-state-active"),e.icons&&(n=s.children(".ui-accordion-header-icon"),this._removeClass(n,null,e.icons.header)._addClass(n,null,e.icons.activeHeader)),this._addClass(s.next(),"ui-accordion-content-active")))},_toggle:function(t){var e=t.newPanel,i=this.prevShow.length?this.prevShow:t.oldPanel;this.prevShow.add(this.prevHide).stop(!0,!0),this.prevShow=e,this.prevHide=i,this.options.animate?this._animate(e,i,t):(i.hide(),e.show(),this._toggleComplete(t)),i.attr({"aria-hidden":"true"}),i.prev().attr({"aria-selected":"false","aria-expanded":"false"}),e.length&&i.length?i.prev().attr({tabIndex:-1,"aria-expanded":"false"}):e.length&&this.headers.filter(function(){return 0===parseInt(V(this).attr("tabIndex"),10)}).attr("tabIndex",-1),e.attr("aria-hidden","false").prev().attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0})},_animate:function(t,i,e){var s,n,o,a=this,r=0,l=t.css("box-sizing"),h=t.length&&(!i.length||t.index()<i.index()),c=this.options.animate||{},u=h&&c.down||c,h=function(){a._toggleComplete(e)};return n=(n="string"==typeof u?u:n)||u.easing||c.easing,o=(o="number"==typeof u?u:o)||u.duration||c.duration,i.length?t.length?(s=t.show().outerHeight(),i.animate(this.hideProps,{duration:o,easing:n,step:function(t,e){e.now=Math.round(t)}}),void t.hide().animate(this.showProps,{duration:o,easing:n,complete:h,step:function(t,e){e.now=Math.round(t),"height"!==e.prop?"content-box"===l&&(r+=e.now):"content"!==a.options.heightStyle&&(e.now=Math.round(s-i.outerHeight()-r),r=0)}})):i.animate(this.hideProps,o,n,h):t.animate(this.showProps,o,n,h)},_toggleComplete:function(t){var e=t.oldPanel,i=e.prev();this._removeClass(e,"ui-accordion-content-active"),this._removeClass(i,"ui-accordion-header-active")._addClass(i,"ui-accordion-header-collapsed"),e.length&&(e.parent()[0].className=e.parent()[0].className),this._trigger("activate",null,t)}}),V.ui.safeActiveElement=function(e){var i;try{i=e.activeElement}catch(t){i=e.body}return i=!(i=i||e.body).nodeName?e.body:i},V.widget("ui.menu",{version:"1.13.0",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-caret-1-e"},items:"> *",menus:"ul",position:{my:"left top",at:"right top"},role:"menu",blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element,this.mouseHandled=!1,this.lastMousePosition={x:null,y:null},this.element.uniqueId().attr({role:this.options.role,tabIndex:0}),this._addClass("ui-menu","ui-widget ui-widget-content"),this._on({"mousedown .ui-menu-item":function(t){t.preventDefault(),this._activateItem(t)},"click .ui-menu-item":function(t){var e=V(t.target),i=V(V.ui.safeActiveElement(this.document[0]));!this.mouseHandled&&e.not(".ui-state-disabled").length&&(this.select(t),t.isPropagationStopped()||(this.mouseHandled=!0),e.has(".ui-menu").length?this.expand(t):!this.element.is(":focus")&&i.closest(".ui-menu").length&&(this.element.trigger("focus",[!0]),this.active&&1===this.active.parents(".ui-menu").length&&clearTimeout(this.timer)))},"mouseenter .ui-menu-item":"_activateItem","mousemove .ui-menu-item":"_activateItem",mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function(t,e){var i=this.active||this._menuItems().first();e||this.focus(t,i)},blur:function(t){this._delay(function(){V.contains(this.element[0],V.ui.safeActiveElement(this.document[0]))||this.collapseAll(t)})},keydown:"_keydown"}),this.refresh(),this._on(this.document,{click:function(t){this._closeOnDocumentClick(t)&&this.collapseAll(t,!0),this.mouseHandled=!1}})},_activateItem:function(t){var e,i;this.previousFilter||t.clientX===this.lastMousePosition.x&&t.clientY===this.lastMousePosition.y||(this.lastMousePosition={x:t.clientX,y:t.clientY},e=V(t.target).closest(".ui-menu-item"),i=V(t.currentTarget),e[0]===i[0]&&(i.is(".ui-state-active")||(this._removeClass(i.siblings().children(".ui-state-active"),null,"ui-state-active"),this.focus(t,i))))},_destroy:function(){var t=this.element.find(".ui-menu-item").removeAttr("role aria-disabled").children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled tabIndex").removeUniqueId().show(),t.children().each(function(){var t=V(this);t.data("ui-menu-submenu-caret")&&t.remove()})},_keydown:function(t){var e,i,s,n=!0;switch(t.keyCode){case V.ui.keyCode.PAGE_UP:this.previousPage(t);break;case V.ui.keyCode.PAGE_DOWN:this.nextPage(t);break;case V.ui.keyCode.HOME:this._move("first","first",t);break;case V.ui.keyCode.END:this._move("last","last",t);break;case V.ui.keyCode.UP:this.previous(t);break;case V.ui.keyCode.DOWN:this.next(t);break;case V.ui.keyCode.LEFT:this.collapse(t);break;case V.ui.keyCode.RIGHT:this.active&&!this.active.is(".ui-state-disabled")&&this.expand(t);break;case V.ui.keyCode.ENTER:case V.ui.keyCode.SPACE:this._activate(t);break;case V.ui.keyCode.ESCAPE:this.collapse(t);break;default:e=this.previousFilter||"",s=n=!1,i=96<=t.keyCode&&t.keyCode<=105?(t.keyCode-96).toString():String.fromCharCode(t.keyCode),clearTimeout(this.filterTimer),i===e?s=!0:i=e+i,e=this._filterMenuItems(i),(e=s&&-1!==e.index(this.active.next())?this.active.nextAll(".ui-menu-item"):e).length||(i=String.fromCharCode(t.keyCode),e=this._filterMenuItems(i)),e.length?(this.focus(t,e),this.previousFilter=i,this.filterTimer=this._delay(function(){delete this.previousFilter},1e3)):delete this.previousFilter}n&&t.preventDefault()},_activate:function(t){this.active&&!this.active.is(".ui-state-disabled")&&(this.active.children("[aria-haspopup='true']").length?this.expand(t):this.select(t))},refresh:function(){var t,e,s=this,n=this.options.icons.submenu,i=this.element.find(this.options.menus);this._toggleClass("ui-menu-icons",null,!!this.element.find(".ui-icon").length),e=i.filter(":not(.ui-menu)").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var t=V(this),e=t.prev(),i=V("<span>").data("ui-menu-submenu-caret",!0);s._addClass(i,"ui-menu-icon","ui-icon "+n),e.attr("aria-haspopup","true").prepend(i),t.attr("aria-labelledby",e.attr("id"))}),this._addClass(e,"ui-menu","ui-widget ui-widget-content ui-front"),(t=i.add(this.element).find(this.options.items)).not(".ui-menu-item").each(function(){var t=V(this);s._isDivider(t)&&s._addClass(t,"ui-menu-divider","ui-widget-content")}),i=(e=t.not(".ui-menu-item, .ui-menu-divider")).children().not(".ui-menu").uniqueId().attr({tabIndex:-1,role:this._itemRole()}),this._addClass(e,"ui-menu-item")._addClass(i,"ui-menu-item-wrapper"),t.filter(".ui-state-disabled").attr("aria-disabled","true"),this.active&&!V.contains(this.element[0],this.active[0])&&this.blur()},_itemRole:function(){return{menu:"menuitem",listbox:"option"}[this.options.role]},_setOption:function(t,e){var i;"icons"===t&&(i=this.element.find(".ui-menu-icon"),this._removeClass(i,null,this.options.icons.submenu)._addClass(i,null,e.submenu)),this._super(t,e)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",String(t)),this._toggleClass(null,"ui-state-disabled",!!t)},focus:function(t,e){var i;this.blur(t,t&&"focus"===t.type),this._scrollIntoView(e),this.active=e.first(),i=this.active.children(".ui-menu-item-wrapper"),this._addClass(i,null,"ui-state-active"),this.options.role&&this.element.attr("aria-activedescendant",i.attr("id")),i=this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper"),this._addClass(i,null,"ui-state-active"),t&&"keydown"===t.type?this._close():this.timer=this._delay(function(){this._close()},this.delay),(i=e.children(".ui-menu")).length&&t&&/^mouse/.test(t.type)&&this._startOpening(i),this.activeMenu=e.parent(),this._trigger("focus",t,{item:e})},_scrollIntoView:function(t){var e,i,s;this._hasScroll()&&(i=parseFloat(V.css(this.activeMenu[0],"borderTopWidth"))||0,s=parseFloat(V.css(this.activeMenu[0],"paddingTop"))||0,e=t.offset().top-this.activeMenu.offset().top-i-s,i=this.activeMenu.scrollTop(),s=this.activeMenu.height(),t=t.outerHeight(),e<0?this.activeMenu.scrollTop(i+e):s<e+t&&this.activeMenu.scrollTop(i+e-s+t))},blur:function(t,e){e||clearTimeout(this.timer),this.active&&(this._removeClass(this.active.children(".ui-menu-item-wrapper"),null,"ui-state-active"),this._trigger("blur",t,{item:this.active}),this.active=null)},_startOpening:function(t){clearTimeout(this.timer),"true"===t.attr("aria-hidden")&&(this.timer=this._delay(function(){this._close(),this._open(t)},this.delay))},_open:function(t){var e=V.extend({of:this.active},this.options.position);clearTimeout(this.timer),this.element.find(".ui-menu").not(t.parents(".ui-menu")).hide().attr("aria-hidden","true"),t.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(e)},collapseAll:function(e,i){clearTimeout(this.timer),this.timer=this._delay(function(){var t=i?this.element:V(e&&e.target).closest(this.element.find(".ui-menu"));t.length||(t=this.element),this._close(t),this.blur(e),this._removeClass(t.find(".ui-state-active"),null,"ui-state-active"),this.activeMenu=t},i?0:this.delay)},_close:function(t){(t=t||(this.active?this.active.parent():this.element)).find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false")},_closeOnDocumentClick:function(t){return!V(t.target).closest(".ui-menu").length},_isDivider:function(t){return!/[^\-\u2014\u2013\s]/.test(t.text())},collapse:function(t){var e=this.active&&this.active.parent().closest(".ui-menu-item",this.element);e&&e.length&&(this._close(),this.focus(t,e))},expand:function(t){var e=this.active&&this._menuItems(this.active.children(".ui-menu")).first();e&&e.length&&(this._open(e.parent()),this._delay(function(){this.focus(t,e)}))},next:function(t){this._move("next","first",t)},previous:function(t){this._move("prev","last",t)},isFirstItem:function(){return this.active&&!this.active.prevAll(".ui-menu-item").length},isLastItem:function(){return this.active&&!this.active.nextAll(".ui-menu-item").length},_menuItems:function(t){return(t||this.element).find(this.options.items).filter(".ui-menu-item")},_move:function(t,e,i){var s;(s=this.active?"first"===t||"last"===t?this.active["first"===t?"prevAll":"nextAll"](".ui-menu-item").last():this.active[t+"All"](".ui-menu-item").first():s)&&s.length&&this.active||(s=this._menuItems(this.activeMenu)[e]()),this.focus(i,s)},nextPage:function(t){var e,i,s;this.active?this.isLastItem()||(this._hasScroll()?(i=this.active.offset().top,s=this.element.innerHeight(),0===V.fn.jquery.indexOf("3.2.")&&(s+=this.element[0].offsetHeight-this.element.outerHeight()),this.active.nextAll(".ui-menu-item").each(function(){return(e=V(this)).offset().top-i-s<0}),this.focus(t,e)):this.focus(t,this._menuItems(this.activeMenu)[this.active?"last":"first"]())):this.next(t)},previousPage:function(t){var e,i,s;this.active?this.isFirstItem()||(this._hasScroll()?(i=this.active.offset().top,s=this.element.innerHeight(),0===V.fn.jquery.indexOf("3.2.")&&(s+=this.element[0].offsetHeight-this.element.outerHeight()),this.active.prevAll(".ui-menu-item").each(function(){return 0<(e=V(this)).offset().top-i+s}),this.focus(t,e)):this.focus(t,this._menuItems(this.activeMenu).first())):this.next(t)},_hasScroll:function(){return this.element.outerHeight()<this.element.prop("scrollHeight")},select:function(t){this.active=this.active||V(t.target).closest(".ui-menu-item");var e={item:this.active};this.active.has(".ui-menu").length||this.collapseAll(t,!0),this._trigger("select",t,e)},_filterMenuItems:function(t){var t=t.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&"),e=new RegExp("^"+t,"i");return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function(){return e.test(String.prototype.trim.call(V(this).children(".ui-menu-item-wrapper").text()))})}});V.widget("ui.autocomplete",{version:"1.13.0",defaultElement:"<input>",options:{appendTo:null,autoFocus:!1,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},requestIndex:0,pending:0,_create:function(){var i,s,n,t=this.element[0].nodeName.toLowerCase(),e="textarea"===t,t="input"===t;this.isMultiLine=e||!t&&this._isContentEditable(this.element),this.valueMethod=this.element[e||t?"val":"text"],this.isNewMenu=!0,this._addClass("ui-autocomplete-input"),this.element.attr("autocomplete","off"),this._on(this.element,{keydown:function(t){if(this.element.prop("readOnly"))s=n=i=!0;else{s=n=i=!1;var e=V.ui.keyCode;switch(t.keyCode){case e.PAGE_UP:i=!0,this._move("previousPage",t);break;case e.PAGE_DOWN:i=!0,this._move("nextPage",t);break;case e.UP:i=!0,this._keyEvent("previous",t);break;case e.DOWN:i=!0,this._keyEvent("next",t);break;case e.ENTER:this.menu.active&&(i=!0,t.preventDefault(),this.menu.select(t));break;case e.TAB:this.menu.active&&this.menu.select(t);break;case e.ESCAPE:this.menu.element.is(":visible")&&(this.isMultiLine||this._value(this.term),this.close(t),t.preventDefault());break;default:s=!0,this._searchTimeout(t)}}},keypress:function(t){if(i)return i=!1,void(this.isMultiLine&&!this.menu.element.is(":visible")||t.preventDefault());if(!s){var e=V.ui.keyCode;switch(t.keyCode){case e.PAGE_UP:this._move("previousPage",t);break;case e.PAGE_DOWN:this._move("nextPage",t);break;case e.UP:this._keyEvent("previous",t);break;case e.DOWN:this._keyEvent("next",t)}}},input:function(t){if(n)return n=!1,void t.preventDefault();this._searchTimeout(t)},focus:function(){this.selectedItem=null,this.previous=this._value()},blur:function(t){clearTimeout(this.searching),this.close(t),this._change(t)}}),this._initSource(),this.menu=V("<ul>").appendTo(this._appendTo()).menu({role:null}).hide().attr({unselectable:"on"}).menu("instance"),this._addClass(this.menu.element,"ui-autocomplete","ui-front"),this._on(this.menu.element,{mousedown:function(t){t.preventDefault()},menufocus:function(t,e){var i;if(this.isNewMenu&&(this.isNewMenu=!1,t.originalEvent&&/^mouse/.test(t.originalEvent.type)))return this.menu.blur(),void this.document.one("mousemove",function(){V(t.target).trigger(t.originalEvent)});i=e.item.data("ui-autocomplete-item"),!1!==this._trigger("focus",t,{item:i})&&t.originalEvent&&/^key/.test(t.originalEvent.type)&&this._value(i.value),(i=e.item.attr("aria-label")||i.value)&&String.prototype.trim.call(i).length&&(this.liveRegion.children().hide(),V("<div>").text(i).appendTo(this.liveRegion))},menuselect:function(t,e){var i=e.item.data("ui-autocomplete-item"),s=this.previous;this.element[0]!==V.ui.safeActiveElement(this.document[0])&&(this.element.trigger("focus"),this.previous=s,this._delay(function(){this.previous=s,this.selectedItem=i})),!1!==this._trigger("select",t,{item:i})&&this._value(i.value),this.term=this._value(),this.close(t),this.selectedItem=i}}),this.liveRegion=V("<div>",{role:"status","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body),this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible"),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_destroy:function(){clearTimeout(this.searching),this.element.removeAttr("autocomplete"),this.menu.element.remove(),this.liveRegion.remove()},_setOption:function(t,e){this._super(t,e),"source"===t&&this._initSource(),"appendTo"===t&&this.menu.element.appendTo(this._appendTo()),"disabled"===t&&e&&this.xhr&&this.xhr.abort()},_isEventTargetInWidget:function(t){var e=this.menu.element[0];return t.target===this.element[0]||t.target===e||V.contains(e,t.target)},_closeOnClickOutside:function(t){this._isEventTargetInWidget(t)||this.close()},_appendTo:function(){var t=this.options.appendTo;return t=!(t=!(t=t&&(t.jquery||t.nodeType?V(t):this.document.find(t).eq(0)))||!t[0]?this.element.closest(".ui-front, dialog"):t).length?this.document[0].body:t},_initSource:function(){var i,s,n=this;Array.isArray(this.options.source)?(i=this.options.source,this.source=function(t,e){e(V.ui.autocomplete.filter(i,t.term))}):"string"==typeof this.options.source?(s=this.options.source,this.source=function(t,e){n.xhr&&n.xhr.abort(),n.xhr=V.ajax({url:s,data:t,dataType:"json",success:function(t){e(t)},error:function(){e([])}})}):this.source=this.options.source},_searchTimeout:function(s){clearTimeout(this.searching),this.searching=this._delay(function(){var t=this.term===this._value(),e=this.menu.element.is(":visible"),i=s.altKey||s.ctrlKey||s.metaKey||s.shiftKey;t&&(e||i)||(this.selectedItem=null,this.search(null,s))},this.options.delay)},search:function(t,e){return t=null!=t?t:this._value(),this.term=this._value(),t.length<this.options.minLength?this.close(e):!1!==this._trigger("search",e)?this._search(t):void 0},_search:function(t){this.pending++,this._addClass("ui-autocomplete-loading"),this.cancelSearch=!1,this.source({term:t},this._response())},_response:function(){var e=++this.requestIndex;return function(t){e===this.requestIndex&&this.__response(t),this.pending--,this.pending||this._removeClass("ui-autocomplete-loading")}.bind(this)},__response:function(t){t=t&&this._normalize(t),this._trigger("response",null,{content:t}),!this.options.disabled&&t&&t.length&&!this.cancelSearch?(this._suggest(t),this._trigger("open")):this._close()},close:function(t){this.cancelSearch=!0,this._close(t)},_close:function(t){this._off(this.document,"mousedown"),this.menu.element.is(":visible")&&(this.menu.element.hide(),this.menu.blur(),this.isNewMenu=!0,this._trigger("close",t))},_change:function(t){this.previous!==this._value()&&this._trigger("change",t,{item:this.selectedItem})},_normalize:function(t){return t.length&&t[0].label&&t[0].value?t:V.map(t,function(t){return"string"==typeof t?{label:t,value:t}:V.extend({},t,{label:t.label||t.value,value:t.value||t.label})})},_suggest:function(t){var e=this.menu.element.empty();this._renderMenu(e,t),this.isNewMenu=!0,this.menu.refresh(),e.show(),this._resizeMenu(),e.position(V.extend({of:this.element},this.options.position)),this.options.autoFocus&&this.menu.next(),this._on(this.document,{mousedown:"_closeOnClickOutside"})},_resizeMenu:function(){var t=this.menu.element;t.outerWidth(Math.max(t.width("").outerWidth()+1,this.element.outerWidth()))},_renderMenu:function(i,t){var s=this;V.each(t,function(t,e){s._renderItemData(i,e)})},_renderItemData:function(t,e){return this._renderItem(t,e).data("ui-autocomplete-item",e)},_renderItem:function(t,e){return V("<li>").append(V("<div>").text(e.label)).appendTo(t)},_move:function(t,e){if(this.menu.element.is(":visible"))return this.menu.isFirstItem()&&/^previous/.test(t)||this.menu.isLastItem()&&/^next/.test(t)?(this.isMultiLine||this._value(this.term),void this.menu.blur()):void this.menu[t](e);this.search(null,e)},widget:function(){return this.menu.element},_value:function(){return this.valueMethod.apply(this.element,arguments)},_keyEvent:function(t,e){this.isMultiLine&&!this.menu.element.is(":visible")||(this._move(t,e),e.preventDefault())},_isContentEditable:function(t){if(!t.length)return!1;var e=t.prop("contentEditable");return"inherit"===e?this._isContentEditable(t.parent()):"true"===e}}),V.extend(V.ui.autocomplete,{escapeRegex:function(t){return t.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")},filter:function(t,e){var i=new RegExp(V.ui.autocomplete.escapeRegex(e),"i");return V.grep(t,function(t){return i.test(t.label||t.value||t)})}}),V.widget("ui.autocomplete",V.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(t){return t+(1<t?" results are":" result is")+" available, use up and down arrow keys to navigate."}}},__response:function(t){this._superApply(arguments),this.options.disabled||this.cancelSearch||(t=t&&t.length?this.options.messages.results(t.length):this.options.messages.noResults,this.liveRegion.children().hide(),V("<div>").text(t).appendTo(this.liveRegion))}});V.ui.autocomplete;var tt=/ui-corner-([a-z]){2,6}/g;V.widget("ui.controlgroup",{version:"1.13.0",defaultElement:"<div>",options:{direction:"horizontal",disabled:null,onlyVisible:!0,items:{button:"input[type=button], input[type=submit], input[type=reset], button, a",controlgroupLabel:".ui-controlgroup-label",checkboxradio:"input[type='checkbox'], input[type='radio']",selectmenu:"select",spinner:".ui-spinner-input"}},_create:function(){this._enhance()},_enhance:function(){this.element.attr("role","toolbar"),this.refresh()},_destroy:function(){this._callChildMethod("destroy"),this.childWidgets.removeData("ui-controlgroup-data"),this.element.removeAttr("role"),this.options.items.controlgroupLabel&&this.element.find(this.options.items.controlgroupLabel).find(".ui-controlgroup-label-contents").contents().unwrap()},_initWidgets:function(){var o=this,a=[];V.each(this.options.items,function(s,t){var e,n={};if(t)return"controlgroupLabel"===s?((e=o.element.find(t)).each(function(){var t=V(this);t.children(".ui-controlgroup-label-contents").length||t.contents().wrapAll("<span class='ui-controlgroup-label-contents'></span>")}),o._addClass(e,null,"ui-widget ui-widget-content ui-state-default"),void(a=a.concat(e.get()))):void(V.fn[s]&&(n=o["_"+s+"Options"]?o["_"+s+"Options"]("middle"):{classes:{}},o.element.find(t).each(function(){var t=V(this),e=t[s]("instance"),i=V.widget.extend({},n);"button"===s&&t.parent(".ui-spinner").length||((e=e||t[s]()[s]("instance"))&&(i.classes=o._resolveClassesValues(i.classes,e)),t[s](i),i=t[s]("widget"),V.data(i[0],"ui-controlgroup-data",e||t[s]("instance")),a.push(i[0]))})))}),this.childWidgets=V(V.uniqueSort(a)),this._addClass(this.childWidgets,"ui-controlgroup-item")},_callChildMethod:function(e){this.childWidgets.each(function(){var t=V(this).data("ui-controlgroup-data");t&&t[e]&&t[e]()})},_updateCornerClass:function(t,e){e=this._buildSimpleOptions(e,"label").classes.label;this._removeClass(t,null,"ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all"),this._addClass(t,null,e)},_buildSimpleOptions:function(t,e){var i="vertical"===this.options.direction,s={classes:{}};return s.classes[e]={middle:"",first:"ui-corner-"+(i?"top":"left"),last:"ui-corner-"+(i?"bottom":"right"),only:"ui-corner-all"}[t],s},_spinnerOptions:function(t){t=this._buildSimpleOptions(t,"ui-spinner");return t.classes["ui-spinner-up"]="",t.classes["ui-spinner-down"]="",t},_buttonOptions:function(t){return this._buildSimpleOptions(t,"ui-button")},_checkboxradioOptions:function(t){return this._buildSimpleOptions(t,"ui-checkboxradio-label")},_selectmenuOptions:function(t){var e="vertical"===this.options.direction;return{width:e&&"auto",classes:{middle:{"ui-selectmenu-button-open":"","ui-selectmenu-button-closed":""},first:{"ui-selectmenu-button-open":"ui-corner-"+(e?"top":"tl"),"ui-selectmenu-button-closed":"ui-corner-"+(e?"top":"left")},last:{"ui-selectmenu-button-open":e?"":"ui-corner-tr","ui-selectmenu-button-closed":"ui-corner-"+(e?"bottom":"right")},only:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"}}[t]}},_resolveClassesValues:function(i,s){var n={};return V.each(i,function(t){var e=s.options.classes[t]||"",e=String.prototype.trim.call(e.replace(tt,""));n[t]=(e+" "+i[t]).replace(/\s+/g," ")}),n},_setOption:function(t,e){"direction"===t&&this._removeClass("ui-controlgroup-"+this.options.direction),this._super(t,e),"disabled"!==t?this.refresh():this._callChildMethod(e?"disable":"enable")},refresh:function(){var n,o=this;this._addClass("ui-controlgroup ui-controlgroup-"+this.options.direction),"horizontal"===this.options.direction&&this._addClass(null,"ui-helper-clearfix"),this._initWidgets(),n=this.childWidgets,(n=this.options.onlyVisible?n.filter(":visible"):n).length&&(V.each(["first","last"],function(t,e){var i,s=n[e]().data("ui-controlgroup-data");s&&o["_"+s.widgetName+"Options"]?((i=o["_"+s.widgetName+"Options"](1===n.length?"only":e)).classes=o._resolveClassesValues(i.classes,s),s.element[s.widgetName](i)):o._updateCornerClass(n[e](),e)}),this._callChildMethod("refresh"))}});V.widget("ui.checkboxradio",[V.ui.formResetMixin,{version:"1.13.0",options:{disabled:null,label:null,icon:!0,classes:{"ui-checkboxradio-label":"ui-corner-all","ui-checkboxradio-icon":"ui-corner-all"}},_getCreateOptions:function(){var t,e=this,i=this._super()||{};return this._readType(),t=this.element.labels(),this.label=V(t[t.length-1]),this.label.length||V.error("No label found for checkboxradio widget"),this.originalLabel="",this.label.contents().not(this.element[0]).each(function(){e.originalLabel+=3===this.nodeType?V(this).text():this.outerHTML}),this.originalLabel&&(i.label=this.originalLabel),null!=(t=this.element[0].disabled)&&(i.disabled=t),i},_create:function(){var t=this.element[0].checked;this._bindFormResetHandler(),null==this.options.disabled&&(this.options.disabled=this.element[0].disabled),this._setOption("disabled",this.options.disabled),this._addClass("ui-checkboxradio","ui-helper-hidden-accessible"),this._addClass(this.label,"ui-checkboxradio-label","ui-button ui-widget"),"radio"===this.type&&this._addClass(this.label,"ui-checkboxradio-radio-label"),this.options.label&&this.options.label!==this.originalLabel?this._updateLabel():this.originalLabel&&(this.options.label=this.originalLabel),this._enhance(),t&&this._addClass(this.label,"ui-checkboxradio-checked","ui-state-active"),this._on({change:"_toggleClasses",focus:function(){this._addClass(this.label,null,"ui-state-focus ui-visual-focus")},blur:function(){this._removeClass(this.label,null,"ui-state-focus ui-visual-focus")}})},_readType:function(){var t=this.element[0].nodeName.toLowerCase();this.type=this.element[0].type,"input"===t&&/radio|checkbox/.test(this.type)||V.error("Can't create checkboxradio on element.nodeName="+t+" and element.type="+this.type)},_enhance:function(){this._updateIcon(this.element[0].checked)},widget:function(){return this.label},_getRadioGroup:function(){var t=this.element[0].name,e="input[name='"+V.escapeSelector(t)+"']";return t?(this.form.length?V(this.form[0].elements).filter(e):V(e).filter(function(){return 0===V(this)._form().length})).not(this.element):V([])},_toggleClasses:function(){var t=this.element[0].checked;this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",t),this.options.icon&&"checkbox"===this.type&&this._toggleClass(this.icon,null,"ui-icon-check ui-state-checked",t)._toggleClass(this.icon,null,"ui-icon-blank",!t),"radio"===this.type&&this._getRadioGroup().each(function(){var t=V(this).checkboxradio("instance");t&&t._removeClass(t.label,"ui-checkboxradio-checked","ui-state-active")})},_destroy:function(){this._unbindFormResetHandler(),this.icon&&(this.icon.remove(),this.iconSpace.remove())},_setOption:function(t,e){if("label"!==t||e){if(this._super(t,e),"disabled"===t)return this._toggleClass(this.label,null,"ui-state-disabled",e),void(this.element[0].disabled=e);this.refresh()}},_updateIcon:function(t){var e="ui-icon ui-icon-background ";this.options.icon?(this.icon||(this.icon=V("<span>"),this.iconSpace=V("<span> </span>"),this._addClass(this.iconSpace,"ui-checkboxradio-icon-space")),"checkbox"===this.type?(e+=t?"ui-icon-check ui-state-checked":"ui-icon-blank",this._removeClass(this.icon,null,t?"ui-icon-blank":"ui-icon-check")):e+="ui-icon-blank",this._addClass(this.icon,"ui-checkboxradio-icon",e),t||this._removeClass(this.icon,null,"ui-icon-check ui-state-checked"),this.icon.prependTo(this.label).after(this.iconSpace)):void 0!==this.icon&&(this.icon.remove(),this.iconSpace.remove(),delete this.icon)},_updateLabel:function(){var t=this.label.contents().not(this.element[0]);this.icon&&(t=t.not(this.icon[0])),(t=this.iconSpace?t.not(this.iconSpace[0]):t).remove(),this.label.append(this.options.label)},refresh:function(){var t=this.element[0].checked,e=this.element[0].disabled;this._updateIcon(t),this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",t),null!==this.options.label&&this._updateLabel(),e!==this.options.disabled&&this._setOptions({disabled:e})}}]);var et;V.ui.checkboxradio;V.widget("ui.button",{version:"1.13.0",defaultElement:"<button>",options:{classes:{"ui-button":"ui-corner-all"},disabled:null,icon:null,iconPosition:"beginning",label:null,showLabel:!0},_getCreateOptions:function(){var t,e=this._super()||{};return this.isInput=this.element.is("input"),null!=(t=this.element[0].disabled)&&(e.disabled=t),this.originalLabel=this.isInput?this.element.val():this.element.html(),this.originalLabel&&(e.label=this.originalLabel),e},_create:function(){!this.option.showLabel&!this.options.icon&&(this.options.showLabel=!0),null==this.options.disabled&&(this.options.disabled=this.element[0].disabled||!1),this.hasTitle=!!this.element.attr("title"),this.options.label&&this.options.label!==this.originalLabel&&(this.isInput?this.element.val(this.options.label):this.element.html(this.options.label)),this._addClass("ui-button","ui-widget"),this._setOption("disabled",this.options.disabled),this._enhance(),this.element.is("a")&&this._on({keyup:function(t){t.keyCode===V.ui.keyCode.SPACE&&(t.preventDefault(),this.element[0].click?this.element[0].click():this.element.trigger("click"))}})},_enhance:function(){this.element.is("button")||this.element.attr("role","button"),this.options.icon&&(this._updateIcon("icon",this.options.icon),this._updateTooltip())},_updateTooltip:function(){this.title=this.element.attr("title"),this.options.showLabel||this.title||this.element.attr("title",this.options.label)},_updateIcon:function(t,e){var i="iconPosition"!==t,s=i?this.options.iconPosition:e,t="top"===s||"bottom"===s;this.icon?i&&this._removeClass(this.icon,null,this.options.icon):(this.icon=V("<span>"),this._addClass(this.icon,"ui-button-icon","ui-icon"),this.options.showLabel||this._addClass("ui-button-icon-only")),i&&this._addClass(this.icon,null,e),this._attachIcon(s),t?(this._addClass(this.icon,null,"ui-widget-icon-block"),this.iconSpace&&this.iconSpace.remove()):(this.iconSpace||(this.iconSpace=V("<span> </span>"),this._addClass(this.iconSpace,"ui-button-icon-space")),this._removeClass(this.icon,null,"ui-wiget-icon-block"),this._attachIconSpace(s))},_destroy:function(){this.element.removeAttr("role"),this.icon&&this.icon.remove(),this.iconSpace&&this.iconSpace.remove(),this.hasTitle||this.element.removeAttr("title")},_attachIconSpace:function(t){this.icon[/^(?:end|bottom)/.test(t)?"before":"after"](this.iconSpace)},_attachIcon:function(t){this.element[/^(?:end|bottom)/.test(t)?"append":"prepend"](this.icon)},_setOptions:function(t){var e=(void 0===t.showLabel?this.options:t).showLabel,i=(void 0===t.icon?this.options:t).icon;e||i||(t.showLabel=!0),this._super(t)},_setOption:function(t,e){"icon"===t&&(e?this._updateIcon(t,e):this.icon&&(this.icon.remove(),this.iconSpace&&this.iconSpace.remove())),"iconPosition"===t&&this._updateIcon(t,e),"showLabel"===t&&(this._toggleClass("ui-button-icon-only",null,!e),this._updateTooltip()),"label"===t&&(this.isInput?this.element.val(e):(this.element.html(e),this.icon&&(this._attachIcon(this.options.iconPosition),this._attachIconSpace(this.options.iconPosition)))),this._super(t,e),"disabled"===t&&(this._toggleClass(null,"ui-state-disabled",e),(this.element[0].disabled=e)&&this.element.trigger("blur"))},refresh:function(){var t=this.element.is("input, button")?this.element[0].disabled:this.element.hasClass("ui-button-disabled");t!==this.options.disabled&&this._setOptions({disabled:t}),this._updateTooltip()}}),!1!==V.uiBackCompat&&(V.widget("ui.button",V.ui.button,{options:{text:!0,icons:{primary:null,secondary:null}},_create:function(){this.options.showLabel&&!this.options.text&&(this.options.showLabel=this.options.text),!this.options.showLabel&&this.options.text&&(this.options.text=this.options.showLabel),this.options.icon||!this.options.icons.primary&&!this.options.icons.secondary?this.options.icon&&(this.options.icons.primary=this.options.icon):this.options.icons.primary?this.options.icon=this.options.icons.primary:(this.options.icon=this.options.icons.secondary,this.options.iconPosition="end"),this._super()},_setOption:function(t,e){"text"!==t?("showLabel"===t&&(this.options.text=e),"icon"===t&&(this.options.icons.primary=e),"icons"===t&&(e.primary?(this._super("icon",e.primary),this._super("iconPosition","beginning")):e.secondary&&(this._super("icon",e.secondary),this._super("iconPosition","end"))),this._superApply(arguments)):this._super("showLabel",e)}}),V.fn.button=(et=V.fn.button,function(i){var t="string"==typeof i,s=Array.prototype.slice.call(arguments,1),n=this;return t?this.length||"instance"!==i?this.each(function(){var t=V(this).attr("type"),e=V.data(this,"ui-"+("checkbox"!==t&&"radio"!==t?"button":"checkboxradio"));return"instance"===i?(n=e,!1):e?"function"!=typeof e[i]||"_"===i.charAt(0)?V.error("no such method '"+i+"' for button widget instance"):(t=e[i].apply(e,s))!==e&&void 0!==t?(n=t&&t.jquery?n.pushStack(t.get()):t,!1):void 0:V.error("cannot call methods on button prior to initialization; attempted to call method '"+i+"'")}):n=void 0:(s.length&&(i=V.widget.extend.apply(null,[i].concat(s))),this.each(function(){var t=V(this).attr("type"),e="checkbox"!==t&&"radio"!==t?"button":"checkboxradio",t=V.data(this,"ui-"+e);t?(t.option(i||{}),t._init&&t._init()):"button"!=e?V(this).checkboxradio(V.extend({icon:!1},i)):et.call(V(this),i)})),n}),V.fn.buttonset=function(){return V.ui.controlgroup||V.error("Controlgroup widget missing"),"option"===arguments[0]&&"items"===arguments[1]&&arguments[2]?this.controlgroup.apply(this,[arguments[0],"items.button",arguments[2]]):"option"===arguments[0]&&"items"===arguments[1]?this.controlgroup.apply(this,[arguments[0],"items.button"]):("object"==typeof arguments[0]&&arguments[0].items&&(arguments[0].items={button:arguments[0].items}),this.controlgroup.apply(this,arguments))});var it;V.ui.button;function st(){this._curInst=null,this._keyEvent=!1,this._disabledInputs=[],this._datepickerShowing=!1,this._inDialog=!1,this._mainDivId="ui-datepicker-div",this._inlineClass="ui-datepicker-inline",this._appendClass="ui-datepicker-append",this._triggerClass="ui-datepicker-trigger",this._dialogClass="ui-datepicker-dialog",this._disableClass="ui-datepicker-disabled",this._unselectableClass="ui-datepicker-unselectable",this._currentClass="ui-datepicker-current-day",this._dayOverClass="ui-datepicker-days-cell-over",this.regional=[],this.regional[""]={closeText:"Done",prevText:"Prev",nextText:"Next",currentText:"Today",monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],dayNamesMin:["Su","Mo","Tu","We","Th","Fr","Sa"],weekHeader:"Wk",dateFormat:"mm/dd/yy",firstDay:0,isRTL:!1,showMonthAfterYear:!1,yearSuffix:"",selectMonthLabel:"Select month",selectYearLabel:"Select year"},this._defaults={showOn:"focus",showAnim:"fadeIn",showOptions:{},defaultDate:null,appendText:"",buttonText:"...",buttonImage:"",buttonImageOnly:!1,hideIfNoPrevNext:!1,navigationAsDateFormat:!1,gotoCurrent:!1,changeMonth:!1,changeYear:!1,yearRange:"c-10:c+10",showOtherMonths:!1,selectOtherMonths:!1,showWeek:!1,calculateWeek:this.iso8601Week,shortYearCutoff:"+10",minDate:null,maxDate:null,duration:"fast",beforeShowDay:null,beforeShow:null,onSelect:null,onChangeMonthYear:null,onClose:null,onUpdateDatepicker:null,numberOfMonths:1,showCurrentAtPos:0,stepMonths:1,stepBigMonths:12,altField:"",altFormat:"",constrainInput:!0,showButtonPanel:!1,autoSize:!1,disabled:!1},V.extend(this._defaults,this.regional[""]),this.regional.en=V.extend(!0,{},this.regional[""]),this.regional["en-US"]=V.extend(!0,{},this.regional.en),this.dpDiv=nt(V("<div id='"+this._mainDivId+"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))}function nt(t){var e="button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";return t.on("mouseout",e,function(){V(this).removeClass("ui-state-hover"),-1!==this.className.indexOf("ui-datepicker-prev")&&V(this).removeClass("ui-datepicker-prev-hover"),-1!==this.className.indexOf("ui-datepicker-next")&&V(this).removeClass("ui-datepicker-next-hover")}).on("mouseover",e,ot)}function ot(){V.datepicker._isDisabledDatepicker((it.inline?it.dpDiv.parent():it.input)[0])||(V(this).parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover"),V(this).addClass("ui-state-hover"),-1!==this.className.indexOf("ui-datepicker-prev")&&V(this).addClass("ui-datepicker-prev-hover"),-1!==this.className.indexOf("ui-datepicker-next")&&V(this).addClass("ui-datepicker-next-hover"))}function at(t,e){for(var i in V.extend(t,e),e)null==e[i]&&(t[i]=e[i]);return t}V.extend(V.ui,{datepicker:{version:"1.13.0"}}),V.extend(st.prototype,{markerClassName:"hasDatepicker",maxRows:4,_widgetDatepicker:function(){return this.dpDiv},setDefaults:function(t){return at(this._defaults,t||{}),this},_attachDatepicker:function(t,e){var i,s=t.nodeName.toLowerCase(),n="div"===s||"span"===s;t.id||(this.uuid+=1,t.id="dp"+this.uuid),(i=this._newInst(V(t),n)).settings=V.extend({},e||{}),"input"===s?this._connectDatepicker(t,i):n&&this._inlineDatepicker(t,i)},_newInst:function(t,e){return{id:t[0].id.replace(/([^A-Za-z0-9_\-])/g,"\\\\$1"),input:t,selectedDay:0,selectedMonth:0,selectedYear:0,drawMonth:0,drawYear:0,inline:e,dpDiv:e?nt(V("<div class='"+this._inlineClass+" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>")):this.dpDiv}},_connectDatepicker:function(t,e){var i=V(t);e.append=V([]),e.trigger=V([]),i.hasClass(this.markerClassName)||(this._attachments(i,e),i.addClass(this.markerClassName).on("keydown",this._doKeyDown).on("keypress",this._doKeyPress).on("keyup",this._doKeyUp),this._autoSize(e),V.data(t,"datepicker",e),e.settings.disabled&&this._disableDatepicker(t))},_attachments:function(t,e){var i,s=this._get(e,"appendText"),n=this._get(e,"isRTL");e.append&&e.append.remove(),s&&(e.append=V("<span>").addClass(this._appendClass).text(s),t[n?"before":"after"](e.append)),t.off("focus",this._showDatepicker),e.trigger&&e.trigger.remove(),"focus"!==(i=this._get(e,"showOn"))&&"both"!==i||t.on("focus",this._showDatepicker),"button"!==i&&"both"!==i||(s=this._get(e,"buttonText"),i=this._get(e,"buttonImage"),this._get(e,"buttonImageOnly")?e.trigger=V("<img>").addClass(this._triggerClass).attr({src:i,alt:s,title:s}):(e.trigger=V("<button type='button'>").addClass(this._triggerClass),i?e.trigger.html(V("<img>").attr({src:i,alt:s,title:s})):e.trigger.text(s)),t[n?"before":"after"](e.trigger),e.trigger.on("click",function(){return V.datepicker._datepickerShowing&&V.datepicker._lastInput===t[0]?V.datepicker._hideDatepicker():(V.datepicker._datepickerShowing&&V.datepicker._lastInput!==t[0]&&V.datepicker._hideDatepicker(),V.datepicker._showDatepicker(t[0])),!1}))},_autoSize:function(t){var e,i,s,n,o,a;this._get(t,"autoSize")&&!t.inline&&(o=new Date(2009,11,20),(a=this._get(t,"dateFormat")).match(/[DM]/)&&(e=function(t){for(n=s=i=0;n<t.length;n++)t[n].length>i&&(i=t[n].length,s=n);return s},o.setMonth(e(this._get(t,a.match(/MM/)?"monthNames":"monthNamesShort"))),o.setDate(e(this._get(t,a.match(/DD/)?"dayNames":"dayNamesShort"))+20-o.getDay())),t.input.attr("size",this._formatDate(t,o).length))},_inlineDatepicker:function(t,e){var i=V(t);i.hasClass(this.markerClassName)||(i.addClass(this.markerClassName).append(e.dpDiv),V.data(t,"datepicker",e),this._setDate(e,this._getDefaultDate(e),!0),this._updateDatepicker(e),this._updateAlternate(e),e.settings.disabled&&this._disableDatepicker(t),e.dpDiv.css("display","block"))},_dialogDatepicker:function(t,e,i,s,n){var o,a=this._dialogInst;return a||(this.uuid+=1,o="dp"+this.uuid,this._dialogInput=V("<input type='text' id='"+o+"' style='position: absolute; top: -100px; width: 0px;'/>"),this._dialogInput.on("keydown",this._doKeyDown),V("body").append(this._dialogInput),(a=this._dialogInst=this._newInst(this._dialogInput,!1)).settings={},V.data(this._dialogInput[0],"datepicker",a)),at(a.settings,s||{}),e=e&&e.constructor===Date?this._formatDate(a,e):e,this._dialogInput.val(e),this._pos=n?n.length?n:[n.pageX,n.pageY]:null,this._pos||(o=document.documentElement.clientWidth,s=document.documentElement.clientHeight,e=document.documentElement.scrollLeft||document.body.scrollLeft,n=document.documentElement.scrollTop||document.body.scrollTop,this._pos=[o/2-100+e,s/2-150+n]),this._dialogInput.css("left",this._pos[0]+20+"px").css("top",this._pos[1]+"px"),a.settings.onSelect=i,this._inDialog=!0,this.dpDiv.addClass(this._dialogClass),this._showDatepicker(this._dialogInput[0]),V.blockUI&&V.blockUI(this.dpDiv),V.data(this._dialogInput[0],"datepicker",a),this},_destroyDatepicker:function(t){var e,i=V(t),s=V.data(t,"datepicker");i.hasClass(this.markerClassName)&&(e=t.nodeName.toLowerCase(),V.removeData(t,"datepicker"),"input"===e?(s.append.remove(),s.trigger.remove(),i.removeClass(this.markerClassName).off("focus",this._showDatepicker).off("keydown",this._doKeyDown).off("keypress",this._doKeyPress).off("keyup",this._doKeyUp)):"div"!==e&&"span"!==e||i.removeClass(this.markerClassName).empty(),it===s&&(it=null,this._curInst=null))},_enableDatepicker:function(e){var t,i=V(e),s=V.data(e,"datepicker");i.hasClass(this.markerClassName)&&("input"===(t=e.nodeName.toLowerCase())?(e.disabled=!1,s.trigger.filter("button").each(function(){this.disabled=!1}).end().filter("img").css({opacity:"1.0",cursor:""})):"div"!==t&&"span"!==t||((i=i.children("."+this._inlineClass)).children().removeClass("ui-state-disabled"),i.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",!1)),this._disabledInputs=V.map(this._disabledInputs,function(t){return t===e?null:t}))},_disableDatepicker:function(e){var t,i=V(e),s=V.data(e,"datepicker");i.hasClass(this.markerClassName)&&("input"===(t=e.nodeName.toLowerCase())?(e.disabled=!0,s.trigger.filter("button").each(function(){this.disabled=!0}).end().filter("img").css({opacity:"0.5",cursor:"default"})):"div"!==t&&"span"!==t||((i=i.children("."+this._inlineClass)).children().addClass("ui-state-disabled"),i.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",!0)),this._disabledInputs=V.map(this._disabledInputs,function(t){return t===e?null:t}),this._disabledInputs[this._disabledInputs.length]=e)},_isDisabledDatepicker:function(t){if(!t)return!1;for(var e=0;e<this._disabledInputs.length;e++)if(this._disabledInputs[e]===t)return!0;return!1},_getInst:function(t){try{return V.data(t,"datepicker")}catch(t){throw"Missing instance data for this datepicker"}},_optionDatepicker:function(t,e,i){var s,n,o=this._getInst(t);if(2===arguments.length&&"string"==typeof e)return"defaults"===e?V.extend({},V.datepicker._defaults):o?"all"===e?V.extend({},o.settings):this._get(o,e):null;s=e||{},"string"==typeof e&&((s={})[e]=i),o&&(this._curInst===o&&this._hideDatepicker(),n=this._getDateDatepicker(t,!0),e=this._getMinMaxDate(o,"min"),i=this._getMinMaxDate(o,"max"),at(o.settings,s),null!==e&&void 0!==s.dateFormat&&void 0===s.minDate&&(o.settings.minDate=this._formatDate(o,e)),null!==i&&void 0!==s.dateFormat&&void 0===s.maxDate&&(o.settings.maxDate=this._formatDate(o,i)),"disabled"in s&&(s.disabled?this._disableDatepicker(t):this._enableDatepicker(t)),this._attachments(V(t),o),this._autoSize(o),this._setDate(o,n),this._updateAlternate(o),this._updateDatepicker(o))},_changeDatepicker:function(t,e,i){this._optionDatepicker(t,e,i)},_refreshDatepicker:function(t){t=this._getInst(t);t&&this._updateDatepicker(t)},_setDateDatepicker:function(t,e){t=this._getInst(t);t&&(this._setDate(t,e),this._updateDatepicker(t),this._updateAlternate(t))},_getDateDatepicker:function(t,e){t=this._getInst(t);return t&&!t.inline&&this._setDateFromField(t,e),t?this._getDate(t):null},_doKeyDown:function(t){var e,i,s=V.datepicker._getInst(t.target),n=!0,o=s.dpDiv.is(".ui-datepicker-rtl");if(s._keyEvent=!0,V.datepicker._datepickerShowing)switch(t.keyCode){case 9:V.datepicker._hideDatepicker(),n=!1;break;case 13:return(i=V("td."+V.datepicker._dayOverClass+":not(."+V.datepicker._currentClass+")",s.dpDiv))[0]&&V.datepicker._selectDay(t.target,s.selectedMonth,s.selectedYear,i[0]),(e=V.datepicker._get(s,"onSelect"))?(i=V.datepicker._formatDate(s),e.apply(s.input?s.input[0]:null,[i,s])):V.datepicker._hideDatepicker(),!1;case 27:V.datepicker._hideDatepicker();break;case 33:V.datepicker._adjustDate(t.target,t.ctrlKey?-V.datepicker._get(s,"stepBigMonths"):-V.datepicker._get(s,"stepMonths"),"M");break;case 34:V.datepicker._adjustDate(t.target,t.ctrlKey?+V.datepicker._get(s,"stepBigMonths"):+V.datepicker._get(s,"stepMonths"),"M");break;case 35:(t.ctrlKey||t.metaKey)&&V.datepicker._clearDate(t.target),n=t.ctrlKey||t.metaKey;break;case 36:(t.ctrlKey||t.metaKey)&&V.datepicker._gotoToday(t.target),n=t.ctrlKey||t.metaKey;break;case 37:(t.ctrlKey||t.metaKey)&&V.datepicker._adjustDate(t.target,o?1:-1,"D"),n=t.ctrlKey||t.metaKey,t.originalEvent.altKey&&V.datepicker._adjustDate(t.target,t.ctrlKey?-V.datepicker._get(s,"stepBigMonths"):-V.datepicker._get(s,"stepMonths"),"M");break;case 38:(t.ctrlKey||t.metaKey)&&V.datepicker._adjustDate(t.target,-7,"D"),n=t.ctrlKey||t.metaKey;break;case 39:(t.ctrlKey||t.metaKey)&&V.datepicker._adjustDate(t.target,o?-1:1,"D"),n=t.ctrlKey||t.metaKey,t.originalEvent.altKey&&V.datepicker._adjustDate(t.target,t.ctrlKey?+V.datepicker._get(s,"stepBigMonths"):+V.datepicker._get(s,"stepMonths"),"M");break;case 40:(t.ctrlKey||t.metaKey)&&V.datepicker._adjustDate(t.target,7,"D"),n=t.ctrlKey||t.metaKey;break;default:n=!1}else 36===t.keyCode&&t.ctrlKey?V.datepicker._showDatepicker(this):n=!1;n&&(t.preventDefault(),t.stopPropagation())},_doKeyPress:function(t){var e,i=V.datepicker._getInst(t.target);if(V.datepicker._get(i,"constrainInput"))return e=V.datepicker._possibleChars(V.datepicker._get(i,"dateFormat")),i=String.fromCharCode(null==t.charCode?t.keyCode:t.charCode),t.ctrlKey||t.metaKey||i<" "||!e||-1<e.indexOf(i)},_doKeyUp:function(t){t=V.datepicker._getInst(t.target);if(t.input.val()!==t.lastVal)try{V.datepicker.parseDate(V.datepicker._get(t,"dateFormat"),t.input?t.input.val():null,V.datepicker._getFormatConfig(t))&&(V.datepicker._setDateFromField(t),V.datepicker._updateAlternate(t),V.datepicker._updateDatepicker(t))}catch(t){}return!0},_showDatepicker:function(t){var e,i,s,n;"input"!==(t=t.target||t).nodeName.toLowerCase()&&(t=V("input",t.parentNode)[0]),V.datepicker._isDisabledDatepicker(t)||V.datepicker._lastInput===t||(n=V.datepicker._getInst(t),V.datepicker._curInst&&V.datepicker._curInst!==n&&(V.datepicker._curInst.dpDiv.stop(!0,!0),n&&V.datepicker._datepickerShowing&&V.datepicker._hideDatepicker(V.datepicker._curInst.input[0])),!1!==(i=(s=V.datepicker._get(n,"beforeShow"))?s.apply(t,[t,n]):{})&&(at(n.settings,i),n.lastVal=null,V.datepicker._lastInput=t,V.datepicker._setDateFromField(n),V.datepicker._inDialog&&(t.value=""),V.datepicker._pos||(V.datepicker._pos=V.datepicker._findPos(t),V.datepicker._pos[1]+=t.offsetHeight),e=!1,V(t).parents().each(function(){return!(e|="fixed"===V(this).css("position"))}),s={left:V.datepicker._pos[0],top:V.datepicker._pos[1]},V.datepicker._pos=null,n.dpDiv.empty(),n.dpDiv.css({position:"absolute",display:"block",top:"-1000px"}),V.datepicker._updateDatepicker(n),s=V.datepicker._checkOffset(n,s,e),n.dpDiv.css({position:V.datepicker._inDialog&&V.blockUI?"static":e?"fixed":"absolute",display:"none",left:s.left+"px",top:s.top+"px"}),n.inline||(i=V.datepicker._get(n,"showAnim"),s=V.datepicker._get(n,"duration"),n.dpDiv.css("z-index",function(t){for(var e,i;t.length&&t[0]!==document;){if(("absolute"===(e=t.css("position"))||"relative"===e||"fixed"===e)&&(i=parseInt(t.css("zIndex"),10),!isNaN(i)&&0!==i))return i;t=t.parent()}return 0}(V(t))+1),V.datepicker._datepickerShowing=!0,V.effects&&V.effects.effect[i]?n.dpDiv.show(i,V.datepicker._get(n,"showOptions"),s):n.dpDiv[i||"show"](i?s:null),V.datepicker._shouldFocusInput(n)&&n.input.trigger("focus"),V.datepicker._curInst=n)))},_updateDatepicker:function(t){this.maxRows=4,(it=t).dpDiv.empty().append(this._generateHTML(t)),this._attachHandlers(t);var e,i=this._getNumberOfMonths(t),s=i[1],n=t.dpDiv.find("."+this._dayOverClass+" a"),o=V.datepicker._get(t,"onUpdateDatepicker");0<n.length&&ot.apply(n.get(0)),t.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width(""),1<s&&t.dpDiv.addClass("ui-datepicker-multi-"+s).css("width",17*s+"em"),t.dpDiv[(1!==i[0]||1!==i[1]?"add":"remove")+"Class"]("ui-datepicker-multi"),t.dpDiv[(this._get(t,"isRTL")?"add":"remove")+"Class"]("ui-datepicker-rtl"),t===V.datepicker._curInst&&V.datepicker._datepickerShowing&&V.datepicker._shouldFocusInput(t)&&t.input.trigger("focus"),t.yearshtml&&(e=t.yearshtml,setTimeout(function(){e===t.yearshtml&&t.yearshtml&&t.dpDiv.find("select.ui-datepicker-year").first().replaceWith(t.yearshtml),e=t.yearshtml=null},0)),o&&o.apply(t.input?t.input[0]:null,[t])},_shouldFocusInput:function(t){return t.input&&t.input.is(":visible")&&!t.input.is(":disabled")&&!t.input.is(":focus")},_checkOffset:function(t,e,i){var s=t.dpDiv.outerWidth(),n=t.dpDiv.outerHeight(),o=t.input?t.input.outerWidth():0,a=t.input?t.input.outerHeight():0,r=document.documentElement.clientWidth+(i?0:V(document).scrollLeft()),l=document.documentElement.clientHeight+(i?0:V(document).scrollTop());return e.left-=this._get(t,"isRTL")?s-o:0,e.left-=i&&e.left===t.input.offset().left?V(document).scrollLeft():0,e.top-=i&&e.top===t.input.offset().top+a?V(document).scrollTop():0,e.left-=Math.min(e.left,e.left+s>r&&s<r?Math.abs(e.left+s-r):0),e.top-=Math.min(e.top,e.top+n>l&&n<l?Math.abs(n+a):0),e},_findPos:function(t){for(var e=this._getInst(t),i=this._get(e,"isRTL");t&&("hidden"===t.type||1!==t.nodeType||V.expr.pseudos.hidden(t));)t=t[i?"previousSibling":"nextSibling"];return[(e=V(t).offset()).left,e.top]},_hideDatepicker:function(t){var e,i,s=this._curInst;!s||t&&s!==V.data(t,"datepicker")||this._datepickerShowing&&(e=this._get(s,"showAnim"),i=this._get(s,"duration"),t=function(){V.datepicker._tidyDialog(s)},V.effects&&(V.effects.effect[e]||V.effects[e])?s.dpDiv.hide(e,V.datepicker._get(s,"showOptions"),i,t):s.dpDiv["slideDown"===e?"slideUp":"fadeIn"===e?"fadeOut":"hide"](e?i:null,t),e||t(),this._datepickerShowing=!1,(t=this._get(s,"onClose"))&&t.apply(s.input?s.input[0]:null,[s.input?s.input.val():"",s]),this._lastInput=null,this._inDialog&&(this._dialogInput.css({position:"absolute",left:"0",top:"-100px"}),V.blockUI&&(V.unblockUI(),V("body").append(this.dpDiv))),this._inDialog=!1)},_tidyDialog:function(t){t.dpDiv.removeClass(this._dialogClass).off(".ui-datepicker-calendar")},_checkExternalClick:function(t){var e;V.datepicker._curInst&&(e=V(t.target),t=V.datepicker._getInst(e[0]),(e[0].id===V.datepicker._mainDivId||0!==e.parents("#"+V.datepicker._mainDivId).length||e.hasClass(V.datepicker.markerClassName)||e.closest("."+V.datepicker._triggerClass).length||!V.datepicker._datepickerShowing||V.datepicker._inDialog&&V.blockUI)&&(!e.hasClass(V.datepicker.markerClassName)||V.datepicker._curInst===t)||V.datepicker._hideDatepicker())},_adjustDate:function(t,e,i){var s=V(t),t=this._getInst(s[0]);this._isDisabledDatepicker(s[0])||(this._adjustInstDate(t,e,i),this._updateDatepicker(t))},_gotoToday:function(t){var e=V(t),i=this._getInst(e[0]);this._get(i,"gotoCurrent")&&i.currentDay?(i.selectedDay=i.currentDay,i.drawMonth=i.selectedMonth=i.currentMonth,i.drawYear=i.selectedYear=i.currentYear):(t=new Date,i.selectedDay=t.getDate(),i.drawMonth=i.selectedMonth=t.getMonth(),i.drawYear=i.selectedYear=t.getFullYear()),this._notifyChange(i),this._adjustDate(e)},_selectMonthYear:function(t,e,i){var s=V(t),t=this._getInst(s[0]);t["selected"+("M"===i?"Month":"Year")]=t["draw"+("M"===i?"Month":"Year")]=parseInt(e.options[e.selectedIndex].value,10),this._notifyChange(t),this._adjustDate(s)},_selectDay:function(t,e,i,s){var n=V(t);V(s).hasClass(this._unselectableClass)||this._isDisabledDatepicker(n[0])||((n=this._getInst(n[0])).selectedDay=n.currentDay=parseInt(V("a",s).attr("data-date")),n.selectedMonth=n.currentMonth=e,n.selectedYear=n.currentYear=i,this._selectDate(t,this._formatDate(n,n.currentDay,n.currentMonth,n.currentYear)))},_clearDate:function(t){t=V(t);this._selectDate(t,"")},_selectDate:function(t,e){var i=V(t),t=this._getInst(i[0]);e=null!=e?e:this._formatDate(t),t.input&&t.input.val(e),this._updateAlternate(t),(i=this._get(t,"onSelect"))?i.apply(t.input?t.input[0]:null,[e,t]):t.input&&t.input.trigger("change"),t.inline?this._updateDatepicker(t):(this._hideDatepicker(),this._lastInput=t.input[0],"object"!=typeof t.input[0]&&t.input.trigger("focus"),this._lastInput=null)},_updateAlternate:function(t){var e,i,s=this._get(t,"altField");s&&(e=this._get(t,"altFormat")||this._get(t,"dateFormat"),i=this._getDate(t),t=this.formatDate(e,i,this._getFormatConfig(t)),V(document).find(s).val(t))},noWeekends:function(t){t=t.getDay();return[0<t&&t<6,""]},iso8601Week:function(t){var e=new Date(t.getTime());return e.setDate(e.getDate()+4-(e.getDay()||7)),t=e.getTime(),e.setMonth(0),e.setDate(1),Math.floor(Math.round((t-e)/864e5)/7)+1},parseDate:function(e,n,t){if(null==e||null==n)throw"Invalid arguments";if(""===(n="object"==typeof n?n.toString():n+""))return null;for(var i,s,o,a=0,r=(t?t.shortYearCutoff:null)||this._defaults.shortYearCutoff,r="string"!=typeof r?r:(new Date).getFullYear()%100+parseInt(r,10),l=(t?t.dayNamesShort:null)||this._defaults.dayNamesShort,h=(t?t.dayNames:null)||this._defaults.dayNames,c=(t?t.monthNamesShort:null)||this._defaults.monthNamesShort,u=(t?t.monthNames:null)||this._defaults.monthNames,d=-1,p=-1,f=-1,g=-1,m=!1,_=function(t){t=w+1<e.length&&e.charAt(w+1)===t;return t&&w++,t},v=function(t){var e=_(t),e="@"===t?14:"!"===t?20:"y"===t&&e?4:"o"===t?3:2,e=new RegExp("^\\d{"+("y"===t?e:1)+","+e+"}"),e=n.substring(a).match(e);if(!e)throw"Missing number at position "+a;return a+=e[0].length,parseInt(e[0],10)},b=function(t,e,i){var s=-1,e=V.map(_(t)?i:e,function(t,e){return[[e,t]]}).sort(function(t,e){return-(t[1].length-e[1].length)});if(V.each(e,function(t,e){var i=e[1];if(n.substr(a,i.length).toLowerCase()===i.toLowerCase())return s=e[0],a+=i.length,!1}),-1!==s)return s+1;throw"Unknown name at position "+a},y=function(){if(n.charAt(a)!==e.charAt(w))throw"Unexpected literal at position "+a;a++},w=0;w<e.length;w++)if(m)"'"!==e.charAt(w)||_("'")?y():m=!1;else switch(e.charAt(w)){case"d":f=v("d");break;case"D":b("D",l,h);break;case"o":g=v("o");break;case"m":p=v("m");break;case"M":p=b("M",c,u);break;case"y":d=v("y");break;case"@":d=(o=new Date(v("@"))).getFullYear(),p=o.getMonth()+1,f=o.getDate();break;case"!":d=(o=new Date((v("!")-this._ticksTo1970)/1e4)).getFullYear(),p=o.getMonth()+1,f=o.getDate();break;case"'":_("'")?y():m=!0;break;default:y()}if(a<n.length&&(s=n.substr(a),!/^\s+/.test(s)))throw"Extra/unparsed characters found in date: "+s;if(-1===d?d=(new Date).getFullYear():d<100&&(d+=(new Date).getFullYear()-(new Date).getFullYear()%100+(d<=r?0:-100)),-1<g)for(p=1,f=g;;){if(f<=(i=this._getDaysInMonth(d,p-1)))break;p++,f-=i}if((o=this._daylightSavingAdjust(new Date(d,p-1,f))).getFullYear()!==d||o.getMonth()+1!==p||o.getDate()!==f)throw"Invalid date";return o},ATOM:"yy-mm-dd",COOKIE:"D, dd M yy",ISO_8601:"yy-mm-dd",RFC_822:"D, d M y",RFC_850:"DD, dd-M-y",RFC_1036:"D, d M y",RFC_1123:"D, d M yy",RFC_2822:"D, d M yy",RSS:"D, d M y",TICKS:"!",TIMESTAMP:"@",W3C:"yy-mm-dd",_ticksTo1970:24*(718685+Math.floor(492.5)-Math.floor(19.7)+Math.floor(4.925))*60*60*1e7,formatDate:function(e,t,i){if(!t)return"";function s(t,e,i){var s=""+e;if(c(t))for(;s.length<i;)s="0"+s;return s}function n(t,e,i,s){return(c(t)?s:i)[e]}var o,a=(i?i.dayNamesShort:null)||this._defaults.dayNamesShort,r=(i?i.dayNames:null)||this._defaults.dayNames,l=(i?i.monthNamesShort:null)||this._defaults.monthNamesShort,h=(i?i.monthNames:null)||this._defaults.monthNames,c=function(t){t=o+1<e.length&&e.charAt(o+1)===t;return t&&o++,t},u="",d=!1;if(t)for(o=0;o<e.length;o++)if(d)"'"!==e.charAt(o)||c("'")?u+=e.charAt(o):d=!1;else switch(e.charAt(o)){case"d":u+=s("d",t.getDate(),2);break;case"D":u+=n("D",t.getDay(),a,r);break;case"o":u+=s("o",Math.round((new Date(t.getFullYear(),t.getMonth(),t.getDate()).getTime()-new Date(t.getFullYear(),0,0).getTime())/864e5),3);break;case"m":u+=s("m",t.getMonth()+1,2);break;case"M":u+=n("M",t.getMonth(),l,h);break;case"y":u+=c("y")?t.getFullYear():(t.getFullYear()%100<10?"0":"")+t.getFullYear()%100;break;case"@":u+=t.getTime();break;case"!":u+=1e4*t.getTime()+this._ticksTo1970;break;case"'":c("'")?u+="'":d=!0;break;default:u+=e.charAt(o)}return u},_possibleChars:function(e){for(var t="",i=!1,s=function(t){t=n+1<e.length&&e.charAt(n+1)===t;return t&&n++,t},n=0;n<e.length;n++)if(i)"'"!==e.charAt(n)||s("'")?t+=e.charAt(n):i=!1;else switch(e.charAt(n)){case"d":case"m":case"y":case"@":t+="0123456789";break;case"D":case"M":return null;case"'":s("'")?t+="'":i=!0;break;default:t+=e.charAt(n)}return t},_get:function(t,e){return(void 0!==t.settings[e]?t.settings:this._defaults)[e]},_setDateFromField:function(t,e){if(t.input.val()!==t.lastVal){var i=this._get(t,"dateFormat"),s=t.lastVal=t.input?t.input.val():null,n=this._getDefaultDate(t),o=n,a=this._getFormatConfig(t);try{o=this.parseDate(i,s,a)||n}catch(t){s=e?"":s}t.selectedDay=o.getDate(),t.drawMonth=t.selectedMonth=o.getMonth(),t.drawYear=t.selectedYear=o.getFullYear(),t.currentDay=s?o.getDate():0,t.currentMonth=s?o.getMonth():0,t.currentYear=s?o.getFullYear():0,this._adjustInstDate(t)}},_getDefaultDate:function(t){return this._restrictMinMax(t,this._determineDate(t,this._get(t,"defaultDate"),new Date))},_determineDate:function(r,t,e){var i,s,t=null==t||""===t?e:"string"==typeof t?function(t){try{return V.datepicker.parseDate(V.datepicker._get(r,"dateFormat"),t,V.datepicker._getFormatConfig(r))}catch(t){}for(var e=(t.toLowerCase().match(/^c/)?V.datepicker._getDate(r):null)||new Date,i=e.getFullYear(),s=e.getMonth(),n=e.getDate(),o=/([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,a=o.exec(t);a;){switch(a[2]||"d"){case"d":case"D":n+=parseInt(a[1],10);break;case"w":case"W":n+=7*parseInt(a[1],10);break;case"m":case"M":s+=parseInt(a[1],10),n=Math.min(n,V.datepicker._getDaysInMonth(i,s));break;case"y":case"Y":i+=parseInt(a[1],10),n=Math.min(n,V.datepicker._getDaysInMonth(i,s))}a=o.exec(t)}return new Date(i,s,n)}(t):"number"==typeof t?isNaN(t)?e:(i=t,(s=new Date).setDate(s.getDate()+i),s):new Date(t.getTime());return(t=t&&"Invalid Date"===t.toString()?e:t)&&(t.setHours(0),t.setMinutes(0),t.setSeconds(0),t.setMilliseconds(0)),this._daylightSavingAdjust(t)},_daylightSavingAdjust:function(t){return t?(t.setHours(12<t.getHours()?t.getHours()+2:0),t):null},_setDate:function(t,e,i){var s=!e,n=t.selectedMonth,o=t.selectedYear,e=this._restrictMinMax(t,this._determineDate(t,e,new Date));t.selectedDay=t.currentDay=e.getDate(),t.drawMonth=t.selectedMonth=t.currentMonth=e.getMonth(),t.drawYear=t.selectedYear=t.currentYear=e.getFullYear(),n===t.selectedMonth&&o===t.selectedYear||i||this._notifyChange(t),this._adjustInstDate(t),t.input&&t.input.val(s?"":this._formatDate(t))},_getDate:function(t){return!t.currentYear||t.input&&""===t.input.val()?null:this._daylightSavingAdjust(new Date(t.currentYear,t.currentMonth,t.currentDay))},_attachHandlers:function(t){var e=this._get(t,"stepMonths"),i="#"+t.id.replace(/\\\\/g,"\\");t.dpDiv.find("[data-handler]").map(function(){var t={prev:function(){V.datepicker._adjustDate(i,-e,"M")},next:function(){V.datepicker._adjustDate(i,+e,"M")},hide:function(){V.datepicker._hideDatepicker()},today:function(){V.datepicker._gotoToday(i)},selectDay:function(){return V.datepicker._selectDay(i,+this.getAttribute("data-month"),+this.getAttribute("data-year"),this),!1},selectMonth:function(){return V.datepicker._selectMonthYear(i,this,"M"),!1},selectYear:function(){return V.datepicker._selectMonthYear(i,this,"Y"),!1}};V(this).on(this.getAttribute("data-event"),t[this.getAttribute("data-handler")])})},_generateHTML:function(t){var e,i,s,n,o,a,r,l,h,c,u,d,p,f,g,m,_,v,b,y,w,x,k,C,D,I,T,P,M,S,H,z,A=new Date,O=this._daylightSavingAdjust(new Date(A.getFullYear(),A.getMonth(),A.getDate())),N=this._get(t,"isRTL"),E=this._get(t,"showButtonPanel"),W=this._get(t,"hideIfNoPrevNext"),F=this._get(t,"navigationAsDateFormat"),L=this._getNumberOfMonths(t),R=this._get(t,"showCurrentAtPos"),A=this._get(t,"stepMonths"),Y=1!==L[0]||1!==L[1],B=this._daylightSavingAdjust(t.currentDay?new Date(t.currentYear,t.currentMonth,t.currentDay):new Date(9999,9,9)),j=this._getMinMaxDate(t,"min"),q=this._getMinMaxDate(t,"max"),K=t.drawMonth-R,U=t.drawYear;if(K<0&&(K+=12,U--),q)for(e=this._daylightSavingAdjust(new Date(q.getFullYear(),q.getMonth()-L[0]*L[1]+1,q.getDate())),e=j&&e<j?j:e;this._daylightSavingAdjust(new Date(U,K,1))>e;)--K<0&&(K=11,U--);for(t.drawMonth=K,t.drawYear=U,R=this._get(t,"prevText"),R=F?this.formatDate(R,this._daylightSavingAdjust(new Date(U,K-A,1)),this._getFormatConfig(t)):R,i=this._canAdjustMonth(t,-1,U,K)?V("<a>").attr({class:"ui-datepicker-prev ui-corner-all","data-handler":"prev","data-event":"click",title:R}).append(V("<span>").addClass("ui-icon ui-icon-circle-triangle-"+(N?"e":"w")).text(R))[0].outerHTML:W?"":V("<a>").attr({class:"ui-datepicker-prev ui-corner-all ui-state-disabled",title:R}).append(V("<span>").addClass("ui-icon ui-icon-circle-triangle-"+(N?"e":"w")).text(R))[0].outerHTML,R=this._get(t,"nextText"),R=F?this.formatDate(R,this._daylightSavingAdjust(new Date(U,K+A,1)),this._getFormatConfig(t)):R,s=this._canAdjustMonth(t,1,U,K)?V("<a>").attr({class:"ui-datepicker-next ui-corner-all","data-handler":"next","data-event":"click",title:R}).append(V("<span>").addClass("ui-icon ui-icon-circle-triangle-"+(N?"w":"e")).text(R))[0].outerHTML:W?"":V("<a>").attr({class:"ui-datepicker-next ui-corner-all ui-state-disabled",title:R}).append(V("<span>").attr("class","ui-icon ui-icon-circle-triangle-"+(N?"w":"e")).text(R))[0].outerHTML,A=this._get(t,"currentText"),W=this._get(t,"gotoCurrent")&&t.currentDay?B:O,A=F?this.formatDate(A,W,this._getFormatConfig(t)):A,R="",t.inline||(R=V("<button>").attr({type:"button",class:"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all","data-handler":"hide","data-event":"click"}).text(this._get(t,"closeText"))[0].outerHTML),F="",E&&(F=V("<div class='ui-datepicker-buttonpane ui-widget-content'>").append(N?R:"").append(this._isInRange(t,W)?V("<button>").attr({type:"button",class:"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all","data-handler":"today","data-event":"click"}).text(A):"").append(N?"":R)[0].outerHTML),n=parseInt(this._get(t,"firstDay"),10),n=isNaN(n)?0:n,o=this._get(t,"showWeek"),a=this._get(t,"dayNames"),r=this._get(t,"dayNamesMin"),l=this._get(t,"monthNames"),h=this._get(t,"monthNamesShort"),c=this._get(t,"beforeShowDay"),u=this._get(t,"showOtherMonths"),d=this._get(t,"selectOtherMonths"),p=this._getDefaultDate(t),f="",m=0;m<L[0];m++){for(_="",this.maxRows=4,v=0;v<L[1];v++){if(b=this._daylightSavingAdjust(new Date(U,K,t.selectedDay)),y=" ui-corner-all",w="",Y){if(w+="<div class='ui-datepicker-group",1<L[1])switch(v){case 0:w+=" ui-datepicker-group-first",y=" ui-corner-"+(N?"right":"left");break;case L[1]-1:w+=" ui-datepicker-group-last",y=" ui-corner-"+(N?"left":"right");break;default:w+=" ui-datepicker-group-middle",y=""}w+="'>"}for(w+="<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix"+y+"'>"+(/all|left/.test(y)&&0===m?N?s:i:"")+(/all|right/.test(y)&&0===m?N?i:s:"")+this._generateMonthYearHeader(t,K,U,j,q,0<m||0<v,l,h)+"</div><table class='ui-datepicker-calendar'><thead><tr>",x=o?"<th class='ui-datepicker-week-col'>"+this._get(t,"weekHeader")+"</th>":"",g=0;g<7;g++)x+="<th scope='col'"+(5<=(g+n+6)%7?" class='ui-datepicker-week-end'":"")+"><span title='"+a[k=(g+n)%7]+"'>"+r[k]+"</span></th>";for(w+=x+"</tr></thead><tbody>",D=this._getDaysInMonth(U,K),U===t.selectedYear&&K===t.selectedMonth&&(t.selectedDay=Math.min(t.selectedDay,D)),C=(this._getFirstDayOfMonth(U,K)-n+7)%7,D=Math.ceil((C+D)/7),I=Y&&this.maxRows>D?this.maxRows:D,this.maxRows=I,T=this._daylightSavingAdjust(new Date(U,K,1-C)),P=0;P<I;P++){for(w+="<tr>",M=o?"<td class='ui-datepicker-week-col'>"+this._get(t,"calculateWeek")(T)+"</td>":"",g=0;g<7;g++)S=c?c.apply(t.input?t.input[0]:null,[T]):[!0,""],z=(H=T.getMonth()!==K)&&!d||!S[0]||j&&T<j||q&&q<T,M+="<td class='"+(5<=(g+n+6)%7?" ui-datepicker-week-end":"")+(H?" ui-datepicker-other-month":"")+(T.getTime()===b.getTime()&&K===t.selectedMonth&&t._keyEvent||p.getTime()===T.getTime()&&p.getTime()===b.getTime()?" "+this._dayOverClass:"")+(z?" "+this._unselectableClass+" ui-state-disabled":"")+(H&&!u?"":" "+S[1]+(T.getTime()===B.getTime()?" "+this._currentClass:"")+(T.getTime()===O.getTime()?" ui-datepicker-today":""))+"'"+(H&&!u||!S[2]?"":" title='"+S[2].replace(/'/g,"&#39;")+"'")+(z?"":" data-handler='selectDay' data-event='click' data-month='"+T.getMonth()+"' data-year='"+T.getFullYear()+"'")+">"+(H&&!u?"&#xa0;":z?"<span class='ui-state-default'>"+T.getDate()+"</span>":"<a class='ui-state-default"+(T.getTime()===O.getTime()?" ui-state-highlight":"")+(T.getTime()===B.getTime()?" ui-state-active":"")+(H?" ui-priority-secondary":"")+"' href='#' aria-current='"+(T.getTime()===B.getTime()?"true":"false")+"' data-date='"+T.getDate()+"'>"+T.getDate()+"</a>")+"</td>",T.setDate(T.getDate()+1),T=this._daylightSavingAdjust(T);w+=M+"</tr>"}11<++K&&(K=0,U++),_+=w+="</tbody></table>"+(Y?"</div>"+(0<L[0]&&v===L[1]-1?"<div class='ui-datepicker-row-break'></div>":""):"")}f+=_}return f+=F,t._keyEvent=!1,f},_generateMonthYearHeader:function(t,e,i,s,n,o,a,r){var l,h,c,u,d,p,f=this._get(t,"changeMonth"),g=this._get(t,"changeYear"),m=this._get(t,"showMonthAfterYear"),_=this._get(t,"selectMonthLabel"),v=this._get(t,"selectYearLabel"),b="<div class='ui-datepicker-title'>",y="";if(o||!f)y+="<span class='ui-datepicker-month'>"+a[e]+"</span>";else{for(l=s&&s.getFullYear()===i,h=n&&n.getFullYear()===i,y+="<select class='ui-datepicker-month' aria-label='"+_+"' data-handler='selectMonth' data-event='change'>",c=0;c<12;c++)(!l||c>=s.getMonth())&&(!h||c<=n.getMonth())&&(y+="<option value='"+c+"'"+(c===e?" selected='selected'":"")+">"+r[c]+"</option>");y+="</select>"}if(m||(b+=y+(!o&&f&&g?"":"&#xa0;")),!t.yearshtml)if(t.yearshtml="",o||!g)b+="<span class='ui-datepicker-year'>"+i+"</span>";else{for(a=this._get(t,"yearRange").split(":"),u=(new Date).getFullYear(),d=(_=function(t){t=t.match(/c[+\-].*/)?i+parseInt(t.substring(1),10):t.match(/[+\-].*/)?u+parseInt(t,10):parseInt(t,10);return isNaN(t)?u:t})(a[0]),p=Math.max(d,_(a[1]||"")),d=s?Math.max(d,s.getFullYear()):d,p=n?Math.min(p,n.getFullYear()):p,t.yearshtml+="<select class='ui-datepicker-year' aria-label='"+v+"' data-handler='selectYear' data-event='change'>";d<=p;d++)t.yearshtml+="<option value='"+d+"'"+(d===i?" selected='selected'":"")+">"+d+"</option>";t.yearshtml+="</select>",b+=t.yearshtml,t.yearshtml=null}return b+=this._get(t,"yearSuffix"),m&&(b+=(!o&&f&&g?"":"&#xa0;")+y),b+="</div>"},_adjustInstDate:function(t,e,i){var s=t.selectedYear+("Y"===i?e:0),n=t.selectedMonth+("M"===i?e:0),e=Math.min(t.selectedDay,this._getDaysInMonth(s,n))+("D"===i?e:0),e=this._restrictMinMax(t,this._daylightSavingAdjust(new Date(s,n,e)));t.selectedDay=e.getDate(),t.drawMonth=t.selectedMonth=e.getMonth(),t.drawYear=t.selectedYear=e.getFullYear(),"M"!==i&&"Y"!==i||this._notifyChange(t)},_restrictMinMax:function(t,e){var i=this._getMinMaxDate(t,"min"),t=this._getMinMaxDate(t,"max"),e=i&&e<i?i:e;return t&&t<e?t:e},_notifyChange:function(t){var e=this._get(t,"onChangeMonthYear");e&&e.apply(t.input?t.input[0]:null,[t.selectedYear,t.selectedMonth+1,t])},_getNumberOfMonths:function(t){t=this._get(t,"numberOfMonths");return null==t?[1,1]:"number"==typeof t?[1,t]:t},_getMinMaxDate:function(t,e){return this._determineDate(t,this._get(t,e+"Date"),null)},_getDaysInMonth:function(t,e){return 32-this._daylightSavingAdjust(new Date(t,e,32)).getDate()},_getFirstDayOfMonth:function(t,e){return new Date(t,e,1).getDay()},_canAdjustMonth:function(t,e,i,s){var n=this._getNumberOfMonths(t),n=this._daylightSavingAdjust(new Date(i,s+(e<0?e:n[0]*n[1]),1));return e<0&&n.setDate(this._getDaysInMonth(n.getFullYear(),n.getMonth())),this._isInRange(t,n)},_isInRange:function(t,e){var i=this._getMinMaxDate(t,"min"),s=this._getMinMaxDate(t,"max"),n=null,o=null,a=this._get(t,"yearRange");return a&&(t=a.split(":"),a=(new Date).getFullYear(),n=parseInt(t[0],10),o=parseInt(t[1],10),t[0].match(/[+\-].*/)&&(n+=a),t[1].match(/[+\-].*/)&&(o+=a)),(!i||e.getTime()>=i.getTime())&&(!s||e.getTime()<=s.getTime())&&(!n||e.getFullYear()>=n)&&(!o||e.getFullYear()<=o)},_getFormatConfig:function(t){var e=this._get(t,"shortYearCutoff");return{shortYearCutoff:e="string"!=typeof e?e:(new Date).getFullYear()%100+parseInt(e,10),dayNamesShort:this._get(t,"dayNamesShort"),dayNames:this._get(t,"dayNames"),monthNamesShort:this._get(t,"monthNamesShort"),monthNames:this._get(t,"monthNames")}},_formatDate:function(t,e,i,s){e||(t.currentDay=t.selectedDay,t.currentMonth=t.selectedMonth,t.currentYear=t.selectedYear);e=e?"object"==typeof e?e:this._daylightSavingAdjust(new Date(s,i,e)):this._daylightSavingAdjust(new Date(t.currentYear,t.currentMonth,t.currentDay));return this.formatDate(this._get(t,"dateFormat"),e,this._getFormatConfig(t))}}),V.fn.datepicker=function(t){if(!this.length)return this;V.datepicker.initialized||(V(document).on("mousedown",V.datepicker._checkExternalClick),V.datepicker.initialized=!0),0===V("#"+V.datepicker._mainDivId).length&&V("body").append(V.datepicker.dpDiv);var e=Array.prototype.slice.call(arguments,1);return"string"==typeof t&&("isDisabled"===t||"getDate"===t||"widget"===t)||"option"===t&&2===arguments.length&&"string"==typeof arguments[1]?V.datepicker["_"+t+"Datepicker"].apply(V.datepicker,[this[0]].concat(e)):this.each(function(){"string"==typeof t?V.datepicker["_"+t+"Datepicker"].apply(V.datepicker,[this].concat(e)):V.datepicker._attachDatepicker(this,t)})},V.datepicker=new st,V.datepicker.initialized=!1,V.datepicker.uuid=(new Date).getTime(),V.datepicker.version="1.13.0";V.datepicker,V.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase());var rt=!1;V(document).on("mouseup",function(){rt=!1});V.widget("ui.mouse",{version:"1.13.0",options:{cancel:"input, textarea, button, select, option",distance:1,delay:0},_mouseInit:function(){var e=this;this.element.on("mousedown."+this.widgetName,function(t){return e._mouseDown(t)}).on("click."+this.widgetName,function(t){if(!0===V.data(t.target,e.widgetName+".preventClickEvent"))return V.removeData(t.target,e.widgetName+".preventClickEvent"),t.stopImmediatePropagation(),!1}),this.started=!1},_mouseDestroy:function(){this.element.off("."+this.widgetName),this._mouseMoveDelegate&&this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(t){if(!rt){this._mouseMoved=!1,this._mouseStarted&&this._mouseUp(t),this._mouseDownEvent=t;var e=this,i=1===t.which,s=!("string"!=typeof this.options.cancel||!t.target.nodeName)&&V(t.target).closest(this.options.cancel).length;return i&&!s&&this._mouseCapture(t)?(this.mouseDelayMet=!this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){e.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(t)&&this._mouseDelayMet(t)&&(this._mouseStarted=!1!==this._mouseStart(t),!this._mouseStarted)?(t.preventDefault(),!0):(!0===V.data(t.target,this.widgetName+".preventClickEvent")&&V.removeData(t.target,this.widgetName+".preventClickEvent"),this._mouseMoveDelegate=function(t){return e._mouseMove(t)},this._mouseUpDelegate=function(t){return e._mouseUp(t)},this.document.on("mousemove."+this.widgetName,this._mouseMoveDelegate).on("mouseup."+this.widgetName,this._mouseUpDelegate),t.preventDefault(),rt=!0)):!0}},_mouseMove:function(t){if(this._mouseMoved){if(V.ui.ie&&(!document.documentMode||document.documentMode<9)&&!t.button)return this._mouseUp(t);if(!t.which)if(t.originalEvent.altKey||t.originalEvent.ctrlKey||t.originalEvent.metaKey||t.originalEvent.shiftKey)this.ignoreMissingWhich=!0;else if(!this.ignoreMissingWhich)return this._mouseUp(t)}return(t.which||t.button)&&(this._mouseMoved=!0),this._mouseStarted?(this._mouseDrag(t),t.preventDefault()):(this._mouseDistanceMet(t)&&this._mouseDelayMet(t)&&(this._mouseStarted=!1!==this._mouseStart(this._mouseDownEvent,t),this._mouseStarted?this._mouseDrag(t):this._mouseUp(t)),!this._mouseStarted)},_mouseUp:function(t){this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,t.target===this._mouseDownEvent.target&&V.data(t.target,this.widgetName+".preventClickEvent",!0),this._mouseStop(t)),this._mouseDelayTimer&&(clearTimeout(this._mouseDelayTimer),delete this._mouseDelayTimer),this.ignoreMissingWhich=!1,rt=!1,t.preventDefault()},_mouseDistanceMet:function(t){return Math.max(Math.abs(this._mouseDownEvent.pageX-t.pageX),Math.abs(this._mouseDownEvent.pageY-t.pageY))>=this.options.distance},_mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}}),V.ui.plugin={add:function(t,e,i){var s,n=V.ui[t].prototype;for(s in i)n.plugins[s]=n.plugins[s]||[],n.plugins[s].push([e,i[s]])},call:function(t,e,i,s){var n,o=t.plugins[e];if(o&&(s||t.element[0].parentNode&&11!==t.element[0].parentNode.nodeType))for(n=0;n<o.length;n++)t.options[o[n][0]]&&o[n][1].apply(t.element,i)}},V.ui.safeBlur=function(t){t&&"body"!==t.nodeName.toLowerCase()&&V(t).trigger("blur")};V.widget("ui.draggable",V.ui.mouse,{version:"1.13.0",widgetEventPrefix:"drag",options:{addClasses:!0,appendTo:"parent",axis:!1,connectToSortable:!1,containment:!1,cursor:"auto",cursorAt:!1,grid:!1,handle:!1,helper:"original",iframeFix:!1,opacity:!1,refreshPositions:!1,revert:!1,revertDuration:500,scope:"default",scroll:!0,scrollSensitivity:20,scrollSpeed:20,snap:!1,snapMode:"both",snapTolerance:20,stack:!1,zIndex:!1,drag:null,start:null,stop:null},_create:function(){"original"===this.options.helper&&this._setPositionRelative(),this.options.addClasses&&this._addClass("ui-draggable"),this._setHandleClassName(),this._mouseInit()},_setOption:function(t,e){this._super(t,e),"handle"===t&&(this._removeHandleClassName(),this._setHandleClassName())},_destroy:function(){(this.helper||this.element).is(".ui-draggable-dragging")?this.destroyOnClear=!0:(this._removeHandleClassName(),this._mouseDestroy())},_mouseCapture:function(t){var e=this.options;return!(this.helper||e.disabled||0<V(t.target).closest(".ui-resizable-handle").length)&&(this.handle=this._getHandle(t),!!this.handle&&(this._blurActiveElement(t),this._blockFrames(!0===e.iframeFix?"iframe":e.iframeFix),!0))},_blockFrames:function(t){this.iframeBlocks=this.document.find(t).map(function(){var t=V(this);return V("<div>").css("position","absolute").appendTo(t.parent()).outerWidth(t.outerWidth()).outerHeight(t.outerHeight()).offset(t.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_blurActiveElement:function(t){var e=V.ui.safeActiveElement(this.document[0]);V(t.target).closest(e).length||V.ui.safeBlur(e)},_mouseStart:function(t){var e=this.options;return this.helper=this._createHelper(t),this._addClass(this.helper,"ui-draggable-dragging"),this._cacheHelperProportions(),V.ui.ddmanager&&(V.ui.ddmanager.current=this),this._cacheMargins(),this.cssPosition=this.helper.css("position"),this.scrollParent=this.helper.scrollParent(!0),this.offsetParent=this.helper.offsetParent(),this.hasFixedAncestor=0<this.helper.parents().filter(function(){return"fixed"===V(this).css("position")}).length,this.positionAbs=this.element.offset(),this._refreshOffsets(t),this.originalPosition=this.position=this._generatePosition(t,!1),this.originalPageX=t.pageX,this.originalPageY=t.pageY,e.cursorAt&&this._adjustOffsetFromHelper(e.cursorAt),this._setContainment(),!1===this._trigger("start",t)?(this._clear(),!1):(this._cacheHelperProportions(),V.ui.ddmanager&&!e.dropBehaviour&&V.ui.ddmanager.prepareOffsets(this,t),this._mouseDrag(t,!0),V.ui.ddmanager&&V.ui.ddmanager.dragStart(this,t),!0)},_refreshOffsets:function(t){this.offset={top:this.positionAbs.top-this.margins.top,left:this.positionAbs.left-this.margins.left,scroll:!1,parent:this._getParentOffset(),relative:this._getRelativeOffset()},this.offset.click={left:t.pageX-this.offset.left,top:t.pageY-this.offset.top}},_mouseDrag:function(t,e){if(this.hasFixedAncestor&&(this.offset.parent=this._getParentOffset()),this.position=this._generatePosition(t,!0),this.positionAbs=this._convertPositionTo("absolute"),!e){e=this._uiHash();if(!1===this._trigger("drag",t,e))return this._mouseUp(new V.Event("mouseup",t)),!1;this.position=e.position}return this.helper[0].style.left=this.position.left+"px",this.helper[0].style.top=this.position.top+"px",V.ui.ddmanager&&V.ui.ddmanager.drag(this,t),!1},_mouseStop:function(t){var e=this,i=!1;return V.ui.ddmanager&&!this.options.dropBehaviour&&(i=V.ui.ddmanager.drop(this,t)),this.dropped&&(i=this.dropped,this.dropped=!1),"invalid"===this.options.revert&&!i||"valid"===this.options.revert&&i||!0===this.options.revert||"function"==typeof this.options.revert&&this.options.revert.call(this.element,i)?V(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){!1!==e._trigger("stop",t)&&e._clear()}):!1!==this._trigger("stop",t)&&this._clear(),!1},_mouseUp:function(t){return this._unblockFrames(),V.ui.ddmanager&&V.ui.ddmanager.dragStop(this,t),this.handleElement.is(t.target)&&this.element.trigger("focus"),V.ui.mouse.prototype._mouseUp.call(this,t)},cancel:function(){return this.helper.is(".ui-draggable-dragging")?this._mouseUp(new V.Event("mouseup",{target:this.element[0]})):this._clear(),this},_getHandle:function(t){return!this.options.handle||!!V(t.target).closest(this.element.find(this.options.handle)).length},_setHandleClassName:function(){this.handleElement=this.options.handle?this.element.find(this.options.handle):this.element,this._addClass(this.handleElement,"ui-draggable-handle")},_removeHandleClassName:function(){this._removeClass(this.handleElement,"ui-draggable-handle")},_createHelper:function(t){var e=this.options,i="function"==typeof e.helper,t=i?V(e.helper.apply(this.element[0],[t])):"clone"===e.helper?this.element.clone().removeAttr("id"):this.element;return t.parents("body").length||t.appendTo("parent"===e.appendTo?this.element[0].parentNode:e.appendTo),i&&t[0]===this.element[0]&&this._setPositionRelative(),t[0]===this.element[0]||/(fixed|absolute)/.test(t.css("position"))||t.css("position","absolute"),t},_setPositionRelative:function(){/^(?:r|a|f)/.test(this.element.css("position"))||(this.element[0].style.position="relative")},_adjustOffsetFromHelper:function(t){"string"==typeof t&&(t=t.split(" ")),"left"in(t=Array.isArray(t)?{left:+t[0],top:+t[1]||0}:t)&&(this.offset.click.left=t.left+this.margins.left),"right"in t&&(this.offset.click.left=this.helperProportions.width-t.right+this.margins.left),"top"in t&&(this.offset.click.top=t.top+this.margins.top),"bottom"in t&&(this.offset.click.top=this.helperProportions.height-t.bottom+this.margins.top)},_isRootNode:function(t){return/(html|body)/i.test(t.tagName)||t===this.document[0]},_getParentOffset:function(){var t=this.offsetParent.offset(),e=this.document[0];return"absolute"===this.cssPosition&&this.scrollParent[0]!==e&&V.contains(this.scrollParent[0],this.offsetParent[0])&&(t.left+=this.scrollParent.scrollLeft(),t.top+=this.scrollParent.scrollTop()),{top:(t=this._isRootNode(this.offsetParent[0])?{top:0,left:0}:t).top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:t.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"!==this.cssPosition)return{top:0,left:0};var t=this.element.position(),e=this._isRootNode(this.scrollParent[0]);return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+(e?0:this.scrollParent.scrollTop()),left:t.left-(parseInt(this.helper.css("left"),10)||0)+(e?0:this.scrollParent.scrollLeft())}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var t,e,i,s=this.options,n=this.document[0];this.relativeContainer=null,s.containment?"window"!==s.containment?"document"!==s.containment?s.containment.constructor!==Array?("parent"===s.containment&&(s.containment=this.helper[0].parentNode),(i=(e=V(s.containment))[0])&&(t=/(scroll|auto)/.test(e.css("overflow")),this.containment=[(parseInt(e.css("borderLeftWidth"),10)||0)+(parseInt(e.css("paddingLeft"),10)||0),(parseInt(e.css("borderTopWidth"),10)||0)+(parseInt(e.css("paddingTop"),10)||0),(t?Math.max(i.scrollWidth,i.offsetWidth):i.offsetWidth)-(parseInt(e.css("borderRightWidth"),10)||0)-(parseInt(e.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(t?Math.max(i.scrollHeight,i.offsetHeight):i.offsetHeight)-(parseInt(e.css("borderBottomWidth"),10)||0)-(parseInt(e.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom],this.relativeContainer=e)):this.containment=s.containment:this.containment=[0,0,V(n).width()-this.helperProportions.width-this.margins.left,(V(n).height()||n.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]:this.containment=[V(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,V(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,V(window).scrollLeft()+V(window).width()-this.helperProportions.width-this.margins.left,V(window).scrollTop()+(V(window).height()||n.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]:this.containment=null},_convertPositionTo:function(t,e){e=e||this.position;var i="absolute"===t?1:-1,t=this._isRootNode(this.scrollParent[0]);return{top:e.top+this.offset.relative.top*i+this.offset.parent.top*i-("fixed"===this.cssPosition?-this.offset.scroll.top:t?0:this.offset.scroll.top)*i,left:e.left+this.offset.relative.left*i+this.offset.parent.left*i-("fixed"===this.cssPosition?-this.offset.scroll.left:t?0:this.offset.scroll.left)*i}},_generatePosition:function(t,e){var i,s=this.options,n=this._isRootNode(this.scrollParent[0]),o=t.pageX,a=t.pageY;return n&&this.offset.scroll||(this.offset.scroll={top:this.scrollParent.scrollTop(),left:this.scrollParent.scrollLeft()}),e&&(this.containment&&(i=this.relativeContainer?(i=this.relativeContainer.offset(),[this.containment[0]+i.left,this.containment[1]+i.top,this.containment[2]+i.left,this.containment[3]+i.top]):this.containment,t.pageX-this.offset.click.left<i[0]&&(o=i[0]+this.offset.click.left),t.pageY-this.offset.click.top<i[1]&&(a=i[1]+this.offset.click.top),t.pageX-this.offset.click.left>i[2]&&(o=i[2]+this.offset.click.left),t.pageY-this.offset.click.top>i[3]&&(a=i[3]+this.offset.click.top)),s.grid&&(t=s.grid[1]?this.originalPageY+Math.round((a-this.originalPageY)/s.grid[1])*s.grid[1]:this.originalPageY,a=!i||t-this.offset.click.top>=i[1]||t-this.offset.click.top>i[3]?t:t-this.offset.click.top>=i[1]?t-s.grid[1]:t+s.grid[1],t=s.grid[0]?this.originalPageX+Math.round((o-this.originalPageX)/s.grid[0])*s.grid[0]:this.originalPageX,o=!i||t-this.offset.click.left>=i[0]||t-this.offset.click.left>i[2]?t:t-this.offset.click.left>=i[0]?t-s.grid[0]:t+s.grid[0]),"y"===s.axis&&(o=this.originalPageX),"x"===s.axis&&(a=this.originalPageY)),{top:a-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.offset.scroll.top:n?0:this.offset.scroll.top),left:o-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.offset.scroll.left:n?0:this.offset.scroll.left)}},_clear:function(){this._removeClass(this.helper,"ui-draggable-dragging"),this.helper[0]===this.element[0]||this.cancelHelperRemoval||this.helper.remove(),this.helper=null,this.cancelHelperRemoval=!1,this.destroyOnClear&&this.destroy()},_trigger:function(t,e,i){return i=i||this._uiHash(),V.ui.plugin.call(this,t,[e,i,this],!0),/^(drag|start|stop)/.test(t)&&(this.positionAbs=this._convertPositionTo("absolute"),i.offset=this.positionAbs),V.Widget.prototype._trigger.call(this,t,e,i)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}}),V.ui.plugin.add("draggable","connectToSortable",{start:function(e,t,i){var s=V.extend({},t,{item:i.element});i.sortables=[],V(i.options.connectToSortable).each(function(){var t=V(this).sortable("instance");t&&!t.options.disabled&&(i.sortables.push(t),t.refreshPositions(),t._trigger("activate",e,s))})},stop:function(e,t,i){var s=V.extend({},t,{item:i.element});i.cancelHelperRemoval=!1,V.each(i.sortables,function(){var t=this;t.isOver?(t.isOver=0,i.cancelHelperRemoval=!0,t.cancelHelperRemoval=!1,t._storedCSS={position:t.placeholder.css("position"),top:t.placeholder.css("top"),left:t.placeholder.css("left")},t._mouseStop(e),t.options.helper=t.options._helper):(t.cancelHelperRemoval=!0,t._trigger("deactivate",e,s))})},drag:function(i,s,n){V.each(n.sortables,function(){var t=!1,e=this;e.positionAbs=n.positionAbs,e.helperProportions=n.helperProportions,e.offset.click=n.offset.click,e._intersectsWith(e.containerCache)&&(t=!0,V.each(n.sortables,function(){return this.positionAbs=n.positionAbs,this.helperProportions=n.helperProportions,this.offset.click=n.offset.click,t=this!==e&&this._intersectsWith(this.containerCache)&&V.contains(e.element[0],this.element[0])?!1:t})),t?(e.isOver||(e.isOver=1,n._parent=s.helper.parent(),e.currentItem=s.helper.appendTo(e.element).data("ui-sortable-item",!0),e.options._helper=e.options.helper,e.options.helper=function(){return s.helper[0]},i.target=e.currentItem[0],e._mouseCapture(i,!0),e._mouseStart(i,!0,!0),e.offset.click.top=n.offset.click.top,e.offset.click.left=n.offset.click.left,e.offset.parent.left-=n.offset.parent.left-e.offset.parent.left,e.offset.parent.top-=n.offset.parent.top-e.offset.parent.top,n._trigger("toSortable",i),n.dropped=e.element,V.each(n.sortables,function(){this.refreshPositions()}),n.currentItem=n.element,e.fromOutside=n),e.currentItem&&(e._mouseDrag(i),s.position=e.position)):e.isOver&&(e.isOver=0,e.cancelHelperRemoval=!0,e.options._revert=e.options.revert,e.options.revert=!1,e._trigger("out",i,e._uiHash(e)),e._mouseStop(i,!0),e.options.revert=e.options._revert,e.options.helper=e.options._helper,e.placeholder&&e.placeholder.remove(),s.helper.appendTo(n._parent),n._refreshOffsets(i),s.position=n._generatePosition(i,!0),n._trigger("fromSortable",i),n.dropped=!1,V.each(n.sortables,function(){this.refreshPositions()}))})}}),V.ui.plugin.add("draggable","cursor",{start:function(t,e,i){var s=V("body"),i=i.options;s.css("cursor")&&(i._cursor=s.css("cursor")),s.css("cursor",i.cursor)},stop:function(t,e,i){i=i.options;i._cursor&&V("body").css("cursor",i._cursor)}}),V.ui.plugin.add("draggable","opacity",{start:function(t,e,i){e=V(e.helper),i=i.options;e.css("opacity")&&(i._opacity=e.css("opacity")),e.css("opacity",i.opacity)},stop:function(t,e,i){i=i.options;i._opacity&&V(e.helper).css("opacity",i._opacity)}}),V.ui.plugin.add("draggable","scroll",{start:function(t,e,i){i.scrollParentNotHidden||(i.scrollParentNotHidden=i.helper.scrollParent(!1)),i.scrollParentNotHidden[0]!==i.document[0]&&"HTML"!==i.scrollParentNotHidden[0].tagName&&(i.overflowOffset=i.scrollParentNotHidden.offset())},drag:function(t,e,i){var s=i.options,n=!1,o=i.scrollParentNotHidden[0],a=i.document[0];o!==a&&"HTML"!==o.tagName?(s.axis&&"x"===s.axis||(i.overflowOffset.top+o.offsetHeight-t.pageY<s.scrollSensitivity?o.scrollTop=n=o.scrollTop+s.scrollSpeed:t.pageY-i.overflowOffset.top<s.scrollSensitivity&&(o.scrollTop=n=o.scrollTop-s.scrollSpeed)),s.axis&&"y"===s.axis||(i.overflowOffset.left+o.offsetWidth-t.pageX<s.scrollSensitivity?o.scrollLeft=n=o.scrollLeft+s.scrollSpeed:t.pageX-i.overflowOffset.left<s.scrollSensitivity&&(o.scrollLeft=n=o.scrollLeft-s.scrollSpeed))):(s.axis&&"x"===s.axis||(t.pageY-V(a).scrollTop()<s.scrollSensitivity?n=V(a).scrollTop(V(a).scrollTop()-s.scrollSpeed):V(window).height()-(t.pageY-V(a).scrollTop())<s.scrollSensitivity&&(n=V(a).scrollTop(V(a).scrollTop()+s.scrollSpeed))),s.axis&&"y"===s.axis||(t.pageX-V(a).scrollLeft()<s.scrollSensitivity?n=V(a).scrollLeft(V(a).scrollLeft()-s.scrollSpeed):V(window).width()-(t.pageX-V(a).scrollLeft())<s.scrollSensitivity&&(n=V(a).scrollLeft(V(a).scrollLeft()+s.scrollSpeed)))),!1!==n&&V.ui.ddmanager&&!s.dropBehaviour&&V.ui.ddmanager.prepareOffsets(i,t)}}),V.ui.plugin.add("draggable","snap",{start:function(t,e,i){var s=i.options;i.snapElements=[],V(s.snap.constructor!==String?s.snap.items||":data(ui-draggable)":s.snap).each(function(){var t=V(this),e=t.offset();this!==i.element[0]&&i.snapElements.push({item:this,width:t.outerWidth(),height:t.outerHeight(),top:e.top,left:e.left})})},drag:function(t,e,i){for(var s,n,o,a,r,l,h,c,u,d=i.options,p=d.snapTolerance,f=e.offset.left,g=f+i.helperProportions.width,m=e.offset.top,_=m+i.helperProportions.height,v=i.snapElements.length-1;0<=v;v--)l=(r=i.snapElements[v].left-i.margins.left)+i.snapElements[v].width,c=(h=i.snapElements[v].top-i.margins.top)+i.snapElements[v].height,g<r-p||l+p<f||_<h-p||c+p<m||!V.contains(i.snapElements[v].item.ownerDocument,i.snapElements[v].item)?(i.snapElements[v].snapping&&i.options.snap.release&&i.options.snap.release.call(i.element,t,V.extend(i._uiHash(),{snapItem:i.snapElements[v].item})),i.snapElements[v].snapping=!1):("inner"!==d.snapMode&&(s=Math.abs(h-_)<=p,n=Math.abs(c-m)<=p,o=Math.abs(r-g)<=p,a=Math.abs(l-f)<=p,s&&(e.position.top=i._convertPositionTo("relative",{top:h-i.helperProportions.height,left:0}).top),n&&(e.position.top=i._convertPositionTo("relative",{top:c,left:0}).top),o&&(e.position.left=i._convertPositionTo("relative",{top:0,left:r-i.helperProportions.width}).left),a&&(e.position.left=i._convertPositionTo("relative",{top:0,left:l}).left)),u=s||n||o||a,"outer"!==d.snapMode&&(s=Math.abs(h-m)<=p,n=Math.abs(c-_)<=p,o=Math.abs(r-f)<=p,a=Math.abs(l-g)<=p,s&&(e.position.top=i._convertPositionTo("relative",{top:h,left:0}).top),n&&(e.position.top=i._convertPositionTo("relative",{top:c-i.helperProportions.height,left:0}).top),o&&(e.position.left=i._convertPositionTo("relative",{top:0,left:r}).left),a&&(e.position.left=i._convertPositionTo("relative",{top:0,left:l-i.helperProportions.width}).left)),!i.snapElements[v].snapping&&(s||n||o||a||u)&&i.options.snap.snap&&i.options.snap.snap.call(i.element,t,V.extend(i._uiHash(),{snapItem:i.snapElements[v].item})),i.snapElements[v].snapping=s||n||o||a||u)}}),V.ui.plugin.add("draggable","stack",{start:function(t,e,i){var s,i=i.options,i=V.makeArray(V(i.stack)).sort(function(t,e){return(parseInt(V(t).css("zIndex"),10)||0)-(parseInt(V(e).css("zIndex"),10)||0)});i.length&&(s=parseInt(V(i[0]).css("zIndex"),10)||0,V(i).each(function(t){V(this).css("zIndex",s+t)}),this.css("zIndex",s+i.length))}}),V.ui.plugin.add("draggable","zIndex",{start:function(t,e,i){e=V(e.helper),i=i.options;e.css("zIndex")&&(i._zIndex=e.css("zIndex")),e.css("zIndex",i.zIndex)},stop:function(t,e,i){i=i.options;i._zIndex&&V(e.helper).css("zIndex",i._zIndex)}});V.ui.draggable;V.widget("ui.resizable",V.ui.mouse,{version:"1.13.0",widgetEventPrefix:"resize",options:{alsoResize:!1,animate:!1,animateDuration:"slow",animateEasing:"swing",aspectRatio:!1,autoHide:!1,classes:{"ui-resizable-se":"ui-icon ui-icon-gripsmall-diagonal-se"},containment:!1,ghost:!1,grid:!1,handles:"e,s,se",helper:!1,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:90,resize:null,start:null,stop:null},_num:function(t){return parseFloat(t)||0},_isNumber:function(t){return!isNaN(parseFloat(t))},_hasScroll:function(t,e){if("hidden"===V(t).css("overflow"))return!1;var i=e&&"left"===e?"scrollLeft":"scrollTop",e=!1;if(0<t[i])return!0;try{t[i]=1,e=0<t[i],t[i]=0}catch(t){}return e},_create:function(){var t,e=this.options,i=this;this._addClass("ui-resizable"),V.extend(this,{_aspectRatio:!!e.aspectRatio,aspectRatio:e.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:e.helper||e.ghost||e.animate?e.helper||"ui-resizable-helper":null}),this.element[0].nodeName.match(/^(canvas|textarea|input|select|button|img)$/i)&&(this.element.wrap(V("<div class='ui-wrapper'></div>").css({overflow:"hidden",position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")})),this.element=this.element.parent().data("ui-resizable",this.element.resizable("instance")),this.elementIsWrapper=!0,t={marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom"),marginLeft:this.originalElement.css("marginLeft")},this.element.css(t),this.originalElement.css("margin",0),this.originalResizeStyle=this.originalElement.css("resize"),this.originalElement.css("resize","none"),this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"})),this.originalElement.css(t),this._proportionallyResize()),this._setupHandles(),e.autoHide&&V(this.element).on("mouseenter",function(){e.disabled||(i._removeClass("ui-resizable-autohide"),i._handles.show())}).on("mouseleave",function(){e.disabled||i.resizing||(i._addClass("ui-resizable-autohide"),i._handles.hide())}),this._mouseInit()},_destroy:function(){this._mouseDestroy(),this._addedHandles.remove();function t(t){V(t).removeData("resizable").removeData("ui-resizable").off(".resizable")}var e;return this.elementIsWrapper&&(t(this.element),e=this.element,this.originalElement.css({position:e.css("position"),width:e.outerWidth(),height:e.outerHeight(),top:e.css("top"),left:e.css("left")}).insertAfter(e),e.remove()),this.originalElement.css("resize",this.originalResizeStyle),t(this.originalElement),this},_setOption:function(t,e){switch(this._super(t,e),t){case"handles":this._removeHandles(),this._setupHandles();break;case"aspectRatio":this._aspectRatio=!!e}},_setupHandles:function(){var t,e,i,s,n,o=this.options,a=this;if(this.handles=o.handles||(V(".ui-resizable-handle",this.element).length?{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"}:"e,s,se"),this._handles=V(),this._addedHandles=V(),this.handles.constructor===String)for("all"===this.handles&&(this.handles="n,e,s,w,se,sw,ne,nw"),i=this.handles.split(","),this.handles={},e=0;e<i.length;e++)s="ui-resizable-"+(t=String.prototype.trim.call(i[e])),n=V("<div>"),this._addClass(n,"ui-resizable-handle "+s),n.css({zIndex:o.zIndex}),this.handles[t]=".ui-resizable-"+t,this.element.children(this.handles[t]).length||(this.element.append(n),this._addedHandles=this._addedHandles.add(n));this._renderAxis=function(t){var e,i,s;for(e in t=t||this.element,this.handles)this.handles[e].constructor===String?this.handles[e]=this.element.children(this.handles[e]).first().show():(this.handles[e].jquery||this.handles[e].nodeType)&&(this.handles[e]=V(this.handles[e]),this._on(this.handles[e],{mousedown:a._mouseDown})),this.elementIsWrapper&&this.originalElement[0].nodeName.match(/^(textarea|input|select|button)$/i)&&(i=V(this.handles[e],this.element),s=/sw|ne|nw|se|n|s/.test(e)?i.outerHeight():i.outerWidth(),i=["padding",/ne|nw|n/.test(e)?"Top":/se|sw|s/.test(e)?"Bottom":/^e$/.test(e)?"Right":"Left"].join(""),t.css(i,s),this._proportionallyResize()),this._handles=this._handles.add(this.handles[e])},this._renderAxis(this.element),this._handles=this._handles.add(this.element.find(".ui-resizable-handle")),this._handles.disableSelection(),this._handles.on("mouseover",function(){a.resizing||(this.className&&(n=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)),a.axis=n&&n[1]?n[1]:"se")}),o.autoHide&&(this._handles.hide(),this._addClass("ui-resizable-autohide"))},_removeHandles:function(){this._addedHandles.remove()},_mouseCapture:function(t){var e,i,s=!1;for(e in this.handles)(i=V(this.handles[e])[0])!==t.target&&!V.contains(i,t.target)||(s=!0);return!this.options.disabled&&s},_mouseStart:function(t){var e,i,s=this.options,n=this.element;return this.resizing=!0,this._renderProxy(),e=this._num(this.helper.css("left")),i=this._num(this.helper.css("top")),s.containment&&(e+=V(s.containment).scrollLeft()||0,i+=V(s.containment).scrollTop()||0),this.offset=this.helper.offset(),this.position={left:e,top:i},this.size=this._helper?{width:this.helper.width(),height:this.helper.height()}:{width:n.width(),height:n.height()},this.originalSize=this._helper?{width:n.outerWidth(),height:n.outerHeight()}:{width:n.width(),height:n.height()},this.sizeDiff={width:n.outerWidth()-n.width(),height:n.outerHeight()-n.height()},this.originalPosition={left:e,top:i},this.originalMousePosition={left:t.pageX,top:t.pageY},this.aspectRatio="number"==typeof s.aspectRatio?s.aspectRatio:this.originalSize.width/this.originalSize.height||1,s=V(".ui-resizable-"+this.axis).css("cursor"),V("body").css("cursor","auto"===s?this.axis+"-resize":s),this._addClass("ui-resizable-resizing"),this._propagate("start",t),!0},_mouseDrag:function(t){var e=this.originalMousePosition,i=this.axis,s=t.pageX-e.left||0,e=t.pageY-e.top||0,i=this._change[i];return this._updatePrevProperties(),i&&(e=i.apply(this,[t,s,e]),this._updateVirtualBoundaries(t.shiftKey),(this._aspectRatio||t.shiftKey)&&(e=this._updateRatio(e,t)),e=this._respectSize(e,t),this._updateCache(e),this._propagate("resize",t),e=this._applyChanges(),!this._helper&&this._proportionallyResizeElements.length&&this._proportionallyResize(),V.isEmptyObject(e)||(this._updatePrevProperties(),this._trigger("resize",t,this.ui()),this._applyChanges())),!1},_mouseStop:function(t){this.resizing=!1;var e,i,s,n=this.options,o=this;return this._helper&&(s=(e=(i=this._proportionallyResizeElements).length&&/textarea/i.test(i[0].nodeName))&&this._hasScroll(i[0],"left")?0:o.sizeDiff.height,i=e?0:o.sizeDiff.width,e={width:o.helper.width()-i,height:o.helper.height()-s},i=parseFloat(o.element.css("left"))+(o.position.left-o.originalPosition.left)||null,s=parseFloat(o.element.css("top"))+(o.position.top-o.originalPosition.top)||null,n.animate||this.element.css(V.extend(e,{top:s,left:i})),o.helper.height(o.size.height),o.helper.width(o.size.width),this._helper&&!n.animate&&this._proportionallyResize()),V("body").css("cursor","auto"),this._removeClass("ui-resizable-resizing"),this._propagate("stop",t),this._helper&&this.helper.remove(),!1},_updatePrevProperties:function(){this.prevPosition={top:this.position.top,left:this.position.left},this.prevSize={width:this.size.width,height:this.size.height}},_applyChanges:function(){var t={};return this.position.top!==this.prevPosition.top&&(t.top=this.position.top+"px"),this.position.left!==this.prevPosition.left&&(t.left=this.position.left+"px"),this.size.width!==this.prevSize.width&&(t.width=this.size.width+"px"),this.size.height!==this.prevSize.height&&(t.height=this.size.height+"px"),this.helper.css(t),t},_updateVirtualBoundaries:function(t){var e,i,s=this.options,n={minWidth:this._isNumber(s.minWidth)?s.minWidth:0,maxWidth:this._isNumber(s.maxWidth)?s.maxWidth:1/0,minHeight:this._isNumber(s.minHeight)?s.minHeight:0,maxHeight:this._isNumber(s.maxHeight)?s.maxHeight:1/0};(this._aspectRatio||t)&&(e=n.minHeight*this.aspectRatio,i=n.minWidth/this.aspectRatio,s=n.maxHeight*this.aspectRatio,t=n.maxWidth/this.aspectRatio,e>n.minWidth&&(n.minWidth=e),i>n.minHeight&&(n.minHeight=i),s<n.maxWidth&&(n.maxWidth=s),t<n.maxHeight&&(n.maxHeight=t)),this._vBoundaries=n},_updateCache:function(t){this.offset=this.helper.offset(),this._isNumber(t.left)&&(this.position.left=t.left),this._isNumber(t.top)&&(this.position.top=t.top),this._isNumber(t.height)&&(this.size.height=t.height),this._isNumber(t.width)&&(this.size.width=t.width)},_updateRatio:function(t){var e=this.position,i=this.size,s=this.axis;return this._isNumber(t.height)?t.width=t.height*this.aspectRatio:this._isNumber(t.width)&&(t.height=t.width/this.aspectRatio),"sw"===s&&(t.left=e.left+(i.width-t.width),t.top=null),"nw"===s&&(t.top=e.top+(i.height-t.height),t.left=e.left+(i.width-t.width)),t},_respectSize:function(t){var e=this._vBoundaries,i=this.axis,s=this._isNumber(t.width)&&e.maxWidth&&e.maxWidth<t.width,n=this._isNumber(t.height)&&e.maxHeight&&e.maxHeight<t.height,o=this._isNumber(t.width)&&e.minWidth&&e.minWidth>t.width,a=this._isNumber(t.height)&&e.minHeight&&e.minHeight>t.height,r=this.originalPosition.left+this.originalSize.width,l=this.originalPosition.top+this.originalSize.height,h=/sw|nw|w/.test(i),i=/nw|ne|n/.test(i);return o&&(t.width=e.minWidth),a&&(t.height=e.minHeight),s&&(t.width=e.maxWidth),n&&(t.height=e.maxHeight),o&&h&&(t.left=r-e.minWidth),s&&h&&(t.left=r-e.maxWidth),a&&i&&(t.top=l-e.minHeight),n&&i&&(t.top=l-e.maxHeight),t.width||t.height||t.left||!t.top?t.width||t.height||t.top||!t.left||(t.left=null):t.top=null,t},_getPaddingPlusBorderDimensions:function(t){for(var e=0,i=[],s=[t.css("borderTopWidth"),t.css("borderRightWidth"),t.css("borderBottomWidth"),t.css("borderLeftWidth")],n=[t.css("paddingTop"),t.css("paddingRight"),t.css("paddingBottom"),t.css("paddingLeft")];e<4;e++)i[e]=parseFloat(s[e])||0,i[e]+=parseFloat(n[e])||0;return{height:i[0]+i[2],width:i[1]+i[3]}},_proportionallyResize:function(){if(this._proportionallyResizeElements.length)for(var t,e=0,i=this.helper||this.element;e<this._proportionallyResizeElements.length;e++)t=this._proportionallyResizeElements[e],this.outerDimensions||(this.outerDimensions=this._getPaddingPlusBorderDimensions(t)),t.css({height:i.height()-this.outerDimensions.height||0,width:i.width()-this.outerDimensions.width||0})},_renderProxy:function(){var t=this.element,e=this.options;this.elementOffset=t.offset(),this._helper?(this.helper=this.helper||V("<div></div>").css({overflow:"hidden"}),this._addClass(this.helper,this._helper),this.helper.css({width:this.element.outerWidth(),height:this.element.outerHeight(),position:"absolute",left:this.elementOffset.left+"px",top:this.elementOffset.top+"px",zIndex:++e.zIndex}),this.helper.appendTo("body").disableSelection()):this.helper=this.element},_change:{e:function(t,e){return{width:this.originalSize.width+e}},w:function(t,e){var i=this.originalSize;return{left:this.originalPosition.left+e,width:i.width-e}},n:function(t,e,i){var s=this.originalSize;return{top:this.originalPosition.top+i,height:s.height-i}},s:function(t,e,i){return{height:this.originalSize.height+i}},se:function(t,e,i){return V.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[t,e,i]))},sw:function(t,e,i){return V.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[t,e,i]))},ne:function(t,e,i){return V.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[t,e,i]))},nw:function(t,e,i){return V.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[t,e,i]))}},_propagate:function(t,e){V.ui.plugin.call(this,t,[e,this.ui()]),"resize"!==t&&this._trigger(t,e,this.ui())},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}}}),V.ui.plugin.add("resizable","animate",{stop:function(e){var i=V(this).resizable("instance"),t=i.options,s=i._proportionallyResizeElements,n=s.length&&/textarea/i.test(s[0].nodeName),o=n&&i._hasScroll(s[0],"left")?0:i.sizeDiff.height,a=n?0:i.sizeDiff.width,n={width:i.size.width-a,height:i.size.height-o},a=parseFloat(i.element.css("left"))+(i.position.left-i.originalPosition.left)||null,o=parseFloat(i.element.css("top"))+(i.position.top-i.originalPosition.top)||null;i.element.animate(V.extend(n,o&&a?{top:o,left:a}:{}),{duration:t.animateDuration,easing:t.animateEasing,step:function(){var t={width:parseFloat(i.element.css("width")),height:parseFloat(i.element.css("height")),top:parseFloat(i.element.css("top")),left:parseFloat(i.element.css("left"))};s&&s.length&&V(s[0]).css({width:t.width,height:t.height}),i._updateCache(t),i._propagate("resize",e)}})}}),V.ui.plugin.add("resizable","containment",{start:function(){var i,s,n=V(this).resizable("instance"),t=n.options,e=n.element,o=t.containment,a=o instanceof V?o.get(0):/parent/.test(o)?e.parent().get(0):o;a&&(n.containerElement=V(a),/document/.test(o)||o===document?(n.containerOffset={left:0,top:0},n.containerPosition={left:0,top:0},n.parentData={element:V(document),left:0,top:0,width:V(document).width(),height:V(document).height()||document.body.parentNode.scrollHeight}):(i=V(a),s=[],V(["Top","Right","Left","Bottom"]).each(function(t,e){s[t]=n._num(i.css("padding"+e))}),n.containerOffset=i.offset(),n.containerPosition=i.position(),n.containerSize={height:i.innerHeight()-s[3],width:i.innerWidth()-s[1]},t=n.containerOffset,e=n.containerSize.height,o=n.containerSize.width,o=n._hasScroll(a,"left")?a.scrollWidth:o,e=n._hasScroll(a)?a.scrollHeight:e,n.parentData={element:a,left:t.left,top:t.top,width:o,height:e}))},resize:function(t){var e=V(this).resizable("instance"),i=e.options,s=e.containerOffset,n=e.position,o=e._aspectRatio||t.shiftKey,a={top:0,left:0},r=e.containerElement,t=!0;r[0]!==document&&/static/.test(r.css("position"))&&(a=s),n.left<(e._helper?s.left:0)&&(e.size.width=e.size.width+(e._helper?e.position.left-s.left:e.position.left-a.left),o&&(e.size.height=e.size.width/e.aspectRatio,t=!1),e.position.left=i.helper?s.left:0),n.top<(e._helper?s.top:0)&&(e.size.height=e.size.height+(e._helper?e.position.top-s.top:e.position.top),o&&(e.size.width=e.size.height*e.aspectRatio,t=!1),e.position.top=e._helper?s.top:0),i=e.containerElement.get(0)===e.element.parent().get(0),n=/relative|absolute/.test(e.containerElement.css("position")),i&&n?(e.offset.left=e.parentData.left+e.position.left,e.offset.top=e.parentData.top+e.position.top):(e.offset.left=e.element.offset().left,e.offset.top=e.element.offset().top),n=Math.abs(e.sizeDiff.width+(e._helper?e.offset.left-a.left:e.offset.left-s.left)),s=Math.abs(e.sizeDiff.height+(e._helper?e.offset.top-a.top:e.offset.top-s.top)),n+e.size.width>=e.parentData.width&&(e.size.width=e.parentData.width-n,o&&(e.size.height=e.size.width/e.aspectRatio,t=!1)),s+e.size.height>=e.parentData.height&&(e.size.height=e.parentData.height-s,o&&(e.size.width=e.size.height*e.aspectRatio,t=!1)),t||(e.position.left=e.prevPosition.left,e.position.top=e.prevPosition.top,e.size.width=e.prevSize.width,e.size.height=e.prevSize.height)},stop:function(){var t=V(this).resizable("instance"),e=t.options,i=t.containerOffset,s=t.containerPosition,n=t.containerElement,o=V(t.helper),a=o.offset(),r=o.outerWidth()-t.sizeDiff.width,o=o.outerHeight()-t.sizeDiff.height;t._helper&&!e.animate&&/relative/.test(n.css("position"))&&V(this).css({left:a.left-s.left-i.left,width:r,height:o}),t._helper&&!e.animate&&/static/.test(n.css("position"))&&V(this).css({left:a.left-s.left-i.left,width:r,height:o})}}),V.ui.plugin.add("resizable","alsoResize",{start:function(){var t=V(this).resizable("instance").options;V(t.alsoResize).each(function(){var t=V(this);t.data("ui-resizable-alsoresize",{width:parseFloat(t.width()),height:parseFloat(t.height()),left:parseFloat(t.css("left")),top:parseFloat(t.css("top"))})})},resize:function(t,i){var e=V(this).resizable("instance"),s=e.options,n=e.originalSize,o=e.originalPosition,a={height:e.size.height-n.height||0,width:e.size.width-n.width||0,top:e.position.top-o.top||0,left:e.position.left-o.left||0};V(s.alsoResize).each(function(){var t=V(this),s=V(this).data("ui-resizable-alsoresize"),n={},e=t.parents(i.originalElement[0]).length?["width","height"]:["width","height","top","left"];V.each(e,function(t,e){var i=(s[e]||0)+(a[e]||0);i&&0<=i&&(n[e]=i||null)}),t.css(n)})},stop:function(){V(this).removeData("ui-resizable-alsoresize")}}),V.ui.plugin.add("resizable","ghost",{start:function(){var t=V(this).resizable("instance"),e=t.size;t.ghost=t.originalElement.clone(),t.ghost.css({opacity:.25,display:"block",position:"relative",height:e.height,width:e.width,margin:0,left:0,top:0}),t._addClass(t.ghost,"ui-resizable-ghost"),!1!==V.uiBackCompat&&"string"==typeof t.options.ghost&&t.ghost.addClass(this.options.ghost),t.ghost.appendTo(t.helper)},resize:function(){var t=V(this).resizable("instance");t.ghost&&t.ghost.css({position:"relative",height:t.size.height,width:t.size.width})},stop:function(){var t=V(this).resizable("instance");t.ghost&&t.helper&&t.helper.get(0).removeChild(t.ghost.get(0))}}),V.ui.plugin.add("resizable","grid",{resize:function(){var t,e=V(this).resizable("instance"),i=e.options,s=e.size,n=e.originalSize,o=e.originalPosition,a=e.axis,r="number"==typeof i.grid?[i.grid,i.grid]:i.grid,l=r[0]||1,h=r[1]||1,c=Math.round((s.width-n.width)/l)*l,u=Math.round((s.height-n.height)/h)*h,d=n.width+c,p=n.height+u,f=i.maxWidth&&i.maxWidth<d,g=i.maxHeight&&i.maxHeight<p,m=i.minWidth&&i.minWidth>d,s=i.minHeight&&i.minHeight>p;i.grid=r,m&&(d+=l),s&&(p+=h),f&&(d-=l),g&&(p-=h),/^(se|s|e)$/.test(a)?(e.size.width=d,e.size.height=p):/^(ne)$/.test(a)?(e.size.width=d,e.size.height=p,e.position.top=o.top-u):/^(sw)$/.test(a)?(e.size.width=d,e.size.height=p,e.position.left=o.left-c):((p-h<=0||d-l<=0)&&(t=e._getPaddingPlusBorderDimensions(this)),0<p-h?(e.size.height=p,e.position.top=o.top-u):(p=h-t.height,e.size.height=p,e.position.top=o.top+n.height-p),0<d-l?(e.size.width=d,e.position.left=o.left-c):(d=l-t.width,e.size.width=d,e.position.left=o.left+n.width-d))}});V.ui.resizable;V.widget("ui.dialog",{version:"1.13.0",options:{appendTo:"body",autoOpen:!0,buttons:[],classes:{"ui-dialog":"ui-corner-all","ui-dialog-titlebar":"ui-corner-all"},closeOnEscape:!0,closeText:"Close",draggable:!0,hide:null,height:"auto",maxHeight:null,maxWidth:null,minHeight:150,minWidth:150,modal:!1,position:{my:"center",at:"center",of:window,collision:"fit",using:function(t){var e=V(this).css(t).offset().top;e<0&&V(this).css("top",t.top-e)}},resizable:!0,show:null,title:null,width:300,beforeClose:null,close:null,drag:null,dragStart:null,dragStop:null,focus:null,open:null,resize:null,resizeStart:null,resizeStop:null},sizeRelatedOptions:{buttons:!0,height:!0,maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0,width:!0},resizableRelatedOptions:{maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0},_create:function(){this.originalCss={display:this.element[0].style.display,width:this.element[0].style.width,minHeight:this.element[0].style.minHeight,maxHeight:this.element[0].style.maxHeight,height:this.element[0].style.height},this.originalPosition={parent:this.element.parent(),index:this.element.parent().children().index(this.element)},this.originalTitle=this.element.attr("title"),null==this.options.title&&null!=this.originalTitle&&(this.options.title=this.originalTitle),this.options.disabled&&(this.options.disabled=!1),this._createWrapper(),this.element.show().removeAttr("title").appendTo(this.uiDialog),this._addClass("ui-dialog-content","ui-widget-content"),this._createTitlebar(),this._createButtonPane(),this.options.draggable&&V.fn.draggable&&this._makeDraggable(),this.options.resizable&&V.fn.resizable&&this._makeResizable(),this._isOpen=!1,this._trackFocus()},_init:function(){this.options.autoOpen&&this.open()},_appendTo:function(){var t=this.options.appendTo;return t&&(t.jquery||t.nodeType)?V(t):this.document.find(t||"body").eq(0)},_destroy:function(){var t,e=this.originalPosition;this._untrackInstance(),this._destroyOverlay(),this.element.removeUniqueId().css(this.originalCss).detach(),this.uiDialog.remove(),this.originalTitle&&this.element.attr("title",this.originalTitle),(t=e.parent.children().eq(e.index)).length&&t[0]!==this.element[0]?t.before(this.element):e.parent.append(this.element)},widget:function(){return this.uiDialog},disable:V.noop,enable:V.noop,close:function(t){var e=this;this._isOpen&&!1!==this._trigger("beforeClose",t)&&(this._isOpen=!1,this._focusedElement=null,this._destroyOverlay(),this._untrackInstance(),this.opener.filter(":focusable").trigger("focus").length||V.ui.safeBlur(V.ui.safeActiveElement(this.document[0])),this._hide(this.uiDialog,this.options.hide,function(){e._trigger("close",t)}))},isOpen:function(){return this._isOpen},moveToTop:function(){this._moveToTop()},_moveToTop:function(t,e){var i=!1,s=this.uiDialog.siblings(".ui-front:visible").map(function(){return+V(this).css("z-index")}).get(),s=Math.max.apply(null,s);return s>=+this.uiDialog.css("z-index")&&(this.uiDialog.css("z-index",s+1),i=!0),i&&!e&&this._trigger("focus",t),i},open:function(){var t=this;this._isOpen?this._moveToTop()&&this._focusTabbable():(this._isOpen=!0,this.opener=V(V.ui.safeActiveElement(this.document[0])),this._size(),this._position(),this._createOverlay(),this._moveToTop(null,!0),this.overlay&&this.overlay.css("z-index",this.uiDialog.css("z-index")-1),this._show(this.uiDialog,this.options.show,function(){t._focusTabbable(),t._trigger("focus")}),this._makeFocusTarget(),this._trigger("open"))},_focusTabbable:function(){var t=this._focusedElement;(t=!(t=!(t=!(t=!(t=t||this.element.find("[autofocus]")).length?this.element.find(":tabbable"):t).length?this.uiDialogButtonPane.find(":tabbable"):t).length?this.uiDialogTitlebarClose.filter(":tabbable"):t).length?this.uiDialog:t).eq(0).trigger("focus")},_restoreTabbableFocus:function(){var t=V.ui.safeActiveElement(this.document[0]);this.uiDialog[0]===t||V.contains(this.uiDialog[0],t)||this._focusTabbable()},_keepFocus:function(t){t.preventDefault(),this._restoreTabbableFocus(),this._delay(this._restoreTabbableFocus)},_createWrapper:function(){this.uiDialog=V("<div>").hide().attr({tabIndex:-1,role:"dialog"}).appendTo(this._appendTo()),this._addClass(this.uiDialog,"ui-dialog","ui-widget ui-widget-content ui-front"),this._on(this.uiDialog,{keydown:function(t){if(this.options.closeOnEscape&&!t.isDefaultPrevented()&&t.keyCode&&t.keyCode===V.ui.keyCode.ESCAPE)return t.preventDefault(),void this.close(t);var e,i,s;t.keyCode!==V.ui.keyCode.TAB||t.isDefaultPrevented()||(e=this.uiDialog.find(":tabbable"),i=e.first(),s=e.last(),t.target!==s[0]&&t.target!==this.uiDialog[0]||t.shiftKey?t.target!==i[0]&&t.target!==this.uiDialog[0]||!t.shiftKey||(this._delay(function(){s.trigger("focus")}),t.preventDefault()):(this._delay(function(){i.trigger("focus")}),t.preventDefault()))},mousedown:function(t){this._moveToTop(t)&&this._focusTabbable()}}),this.element.find("[aria-describedby]").length||this.uiDialog.attr({"aria-describedby":this.element.uniqueId().attr("id")})},_createTitlebar:function(){var t;this.uiDialogTitlebar=V("<div>"),this._addClass(this.uiDialogTitlebar,"ui-dialog-titlebar","ui-widget-header ui-helper-clearfix"),this._on(this.uiDialogTitlebar,{mousedown:function(t){V(t.target).closest(".ui-dialog-titlebar-close")||this.uiDialog.trigger("focus")}}),this.uiDialogTitlebarClose=V("<button type='button'></button>").button({label:V("<a>").text(this.options.closeText).html(),icon:"ui-icon-closethick",showLabel:!1}).appendTo(this.uiDialogTitlebar),this._addClass(this.uiDialogTitlebarClose,"ui-dialog-titlebar-close"),this._on(this.uiDialogTitlebarClose,{click:function(t){t.preventDefault(),this.close(t)}}),t=V("<span>").uniqueId().prependTo(this.uiDialogTitlebar),this._addClass(t,"ui-dialog-title"),this._title(t),this.uiDialogTitlebar.prependTo(this.uiDialog),this.uiDialog.attr({"aria-labelledby":t.attr("id")})},_title:function(t){this.options.title?t.text(this.options.title):t.html("&#160;")},_createButtonPane:function(){this.uiDialogButtonPane=V("<div>"),this._addClass(this.uiDialogButtonPane,"ui-dialog-buttonpane","ui-widget-content ui-helper-clearfix"),this.uiButtonSet=V("<div>").appendTo(this.uiDialogButtonPane),this._addClass(this.uiButtonSet,"ui-dialog-buttonset"),this._createButtons()},_createButtons:function(){var s=this,t=this.options.buttons;this.uiDialogButtonPane.remove(),this.uiButtonSet.empty(),V.isEmptyObject(t)||Array.isArray(t)&&!t.length?this._removeClass(this.uiDialog,"ui-dialog-buttons"):(V.each(t,function(t,e){var i;e=V.extend({type:"button"},e="function"==typeof e?{click:e,text:t}:e),i=e.click,t={icon:e.icon,iconPosition:e.iconPosition,showLabel:e.showLabel,icons:e.icons,text:e.text},delete e.click,delete e.icon,delete e.iconPosition,delete e.showLabel,delete e.icons,"boolean"==typeof e.text&&delete e.text,V("<button></button>",e).button(t).appendTo(s.uiButtonSet).on("click",function(){i.apply(s.element[0],arguments)})}),this._addClass(this.uiDialog,"ui-dialog-buttons"),this.uiDialogButtonPane.appendTo(this.uiDialog))},_makeDraggable:function(){var n=this,o=this.options;function a(t){return{position:t.position,offset:t.offset}}this.uiDialog.draggable({cancel:".ui-dialog-content, .ui-dialog-titlebar-close",handle:".ui-dialog-titlebar",containment:"document",start:function(t,e){n._addClass(V(this),"ui-dialog-dragging"),n._blockFrames(),n._trigger("dragStart",t,a(e))},drag:function(t,e){n._trigger("drag",t,a(e))},stop:function(t,e){var i=e.offset.left-n.document.scrollLeft(),s=e.offset.top-n.document.scrollTop();o.position={my:"left top",at:"left"+(0<=i?"+":"")+i+" top"+(0<=s?"+":"")+s,of:n.window},n._removeClass(V(this),"ui-dialog-dragging"),n._unblockFrames(),n._trigger("dragStop",t,a(e))}})},_makeResizable:function(){var n=this,o=this.options,t=o.resizable,e=this.uiDialog.css("position"),t="string"==typeof t?t:"n,e,s,w,se,sw,ne,nw";function a(t){return{originalPosition:t.originalPosition,originalSize:t.originalSize,position:t.position,size:t.size}}this.uiDialog.resizable({cancel:".ui-dialog-content",containment:"document",alsoResize:this.element,maxWidth:o.maxWidth,maxHeight:o.maxHeight,minWidth:o.minWidth,minHeight:this._minHeight(),handles:t,start:function(t,e){n._addClass(V(this),"ui-dialog-resizing"),n._blockFrames(),n._trigger("resizeStart",t,a(e))},resize:function(t,e){n._trigger("resize",t,a(e))},stop:function(t,e){var i=n.uiDialog.offset(),s=i.left-n.document.scrollLeft(),i=i.top-n.document.scrollTop();o.height=n.uiDialog.height(),o.width=n.uiDialog.width(),o.position={my:"left top",at:"left"+(0<=s?"+":"")+s+" top"+(0<=i?"+":"")+i,of:n.window},n._removeClass(V(this),"ui-dialog-resizing"),n._unblockFrames(),n._trigger("resizeStop",t,a(e))}}).css("position",e)},_trackFocus:function(){this._on(this.widget(),{focusin:function(t){this._makeFocusTarget(),this._focusedElement=V(t.target)}})},_makeFocusTarget:function(){this._untrackInstance(),this._trackingInstances().unshift(this)},_untrackInstance:function(){var t=this._trackingInstances(),e=V.inArray(this,t);-1!==e&&t.splice(e,1)},_trackingInstances:function(){var t=this.document.data("ui-dialog-instances");return t||this.document.data("ui-dialog-instances",t=[]),t},_minHeight:function(){var t=this.options;return"auto"===t.height?t.minHeight:Math.min(t.minHeight,t.height)},_position:function(){var t=this.uiDialog.is(":visible");t||this.uiDialog.show(),this.uiDialog.position(this.options.position),t||this.uiDialog.hide()},_setOptions:function(t){var i=this,s=!1,n={};V.each(t,function(t,e){i._setOption(t,e),t in i.sizeRelatedOptions&&(s=!0),t in i.resizableRelatedOptions&&(n[t]=e)}),s&&(this._size(),this._position()),this.uiDialog.is(":data(ui-resizable)")&&this.uiDialog.resizable("option",n)},_setOption:function(t,e){var i,s=this.uiDialog;"disabled"!==t&&(this._super(t,e),"appendTo"===t&&this.uiDialog.appendTo(this._appendTo()),"buttons"===t&&this._createButtons(),"closeText"===t&&this.uiDialogTitlebarClose.button({label:V("<a>").text(""+this.options.closeText).html()}),"draggable"===t&&((i=s.is(":data(ui-draggable)"))&&!e&&s.draggable("destroy"),!i&&e&&this._makeDraggable()),"position"===t&&this._position(),"resizable"===t&&((i=s.is(":data(ui-resizable)"))&&!e&&s.resizable("destroy"),i&&"string"==typeof e&&s.resizable("option","handles",e),i||!1===e||this._makeResizable()),"title"===t&&this._title(this.uiDialogTitlebar.find(".ui-dialog-title")))},_size:function(){var t,e,i,s=this.options;this.element.show().css({width:"auto",minHeight:0,maxHeight:"none",height:0}),s.minWidth>s.width&&(s.width=s.minWidth),t=this.uiDialog.css({height:"auto",width:s.width}).outerHeight(),e=Math.max(0,s.minHeight-t),i="number"==typeof s.maxHeight?Math.max(0,s.maxHeight-t):"none","auto"===s.height?this.element.css({minHeight:e,maxHeight:i,height:"auto"}):this.element.height(Math.max(0,s.height-t)),this.uiDialog.is(":data(ui-resizable)")&&this.uiDialog.resizable("option","minHeight",this._minHeight())},_blockFrames:function(){this.iframeBlocks=this.document.find("iframe").map(function(){var t=V(this);return V("<div>").css({position:"absolute",width:t.outerWidth(),height:t.outerHeight()}).appendTo(t.parent()).offset(t.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_allowInteraction:function(t){return!!V(t.target).closest(".ui-dialog").length||!!V(t.target).closest(".ui-datepicker").length},_createOverlay:function(){var i,s;this.options.modal&&(i=V.fn.jquery.substring(0,4),s=!0,this._delay(function(){s=!1}),this.document.data("ui-dialog-overlays")||this.document.on("focusin.ui-dialog",function(t){var e;s||((e=this._trackingInstances()[0])._allowInteraction(t)||(t.preventDefault(),e._focusTabbable(),"3.4."!==i&&"3.5."!==i||e._delay(e._restoreTabbableFocus)))}.bind(this)),this.overlay=V("<div>").appendTo(this._appendTo()),this._addClass(this.overlay,null,"ui-widget-overlay ui-front"),this._on(this.overlay,{mousedown:"_keepFocus"}),this.document.data("ui-dialog-overlays",(this.document.data("ui-dialog-overlays")||0)+1))},_destroyOverlay:function(){var t;this.options.modal&&this.overlay&&((t=this.document.data("ui-dialog-overlays")-1)?this.document.data("ui-dialog-overlays",t):(this.document.off("focusin.ui-dialog"),this.document.removeData("ui-dialog-overlays")),this.overlay.remove(),this.overlay=null)}}),!1!==V.uiBackCompat&&V.widget("ui.dialog",V.ui.dialog,{options:{dialogClass:""},_createWrapper:function(){this._super(),this.uiDialog.addClass(this.options.dialogClass)},_setOption:function(t,e){"dialogClass"===t&&this.uiDialog.removeClass(this.options.dialogClass).addClass(e),this._superApply(arguments)}});V.ui.dialog;function lt(t,e,i){return e<=t&&t<e+i}V.widget("ui.droppable",{version:"1.13.0",widgetEventPrefix:"drop",options:{accept:"*",addClasses:!0,greedy:!1,scope:"default",tolerance:"intersect",activate:null,deactivate:null,drop:null,out:null,over:null},_create:function(){var t,e=this.options,i=e.accept;this.isover=!1,this.isout=!0,this.accept="function"==typeof i?i:function(t){return t.is(i)},this.proportions=function(){if(!arguments.length)return t=t||{width:this.element[0].offsetWidth,height:this.element[0].offsetHeight};t=arguments[0]},this._addToManager(e.scope),e.addClasses&&this._addClass("ui-droppable")},_addToManager:function(t){V.ui.ddmanager.droppables[t]=V.ui.ddmanager.droppables[t]||[],V.ui.ddmanager.droppables[t].push(this)},_splice:function(t){for(var e=0;e<t.length;e++)t[e]===this&&t.splice(e,1)},_destroy:function(){var t=V.ui.ddmanager.droppables[this.options.scope];this._splice(t)},_setOption:function(t,e){var i;"accept"===t?this.accept="function"==typeof e?e:function(t){return t.is(e)}:"scope"===t&&(i=V.ui.ddmanager.droppables[this.options.scope],this._splice(i),this._addToManager(e)),this._super(t,e)},_activate:function(t){var e=V.ui.ddmanager.current;this._addActiveClass(),e&&this._trigger("activate",t,this.ui(e))},_deactivate:function(t){var e=V.ui.ddmanager.current;this._removeActiveClass(),e&&this._trigger("deactivate",t,this.ui(e))},_over:function(t){var e=V.ui.ddmanager.current;e&&(e.currentItem||e.element)[0]!==this.element[0]&&this.accept.call(this.element[0],e.currentItem||e.element)&&(this._addHoverClass(),this._trigger("over",t,this.ui(e)))},_out:function(t){var e=V.ui.ddmanager.current;e&&(e.currentItem||e.element)[0]!==this.element[0]&&this.accept.call(this.element[0],e.currentItem||e.element)&&(this._removeHoverClass(),this._trigger("out",t,this.ui(e)))},_drop:function(e,t){var i=t||V.ui.ddmanager.current,s=!1;return!(!i||(i.currentItem||i.element)[0]===this.element[0])&&(this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function(){var t=V(this).droppable("instance");if(t.options.greedy&&!t.options.disabled&&t.options.scope===i.options.scope&&t.accept.call(t.element[0],i.currentItem||i.element)&&V.ui.intersect(i,V.extend(t,{offset:t.element.offset()}),t.options.tolerance,e))return!(s=!0)}),!s&&(!!this.accept.call(this.element[0],i.currentItem||i.element)&&(this._removeActiveClass(),this._removeHoverClass(),this._trigger("drop",e,this.ui(i)),this.element)))},ui:function(t){return{draggable:t.currentItem||t.element,helper:t.helper,position:t.position,offset:t.positionAbs}},_addHoverClass:function(){this._addClass("ui-droppable-hover")},_removeHoverClass:function(){this._removeClass("ui-droppable-hover")},_addActiveClass:function(){this._addClass("ui-droppable-active")},_removeActiveClass:function(){this._removeClass("ui-droppable-active")}}),V.ui.intersect=function(t,e,i,s){if(!e.offset)return!1;var n=(t.positionAbs||t.position.absolute).left+t.margins.left,o=(t.positionAbs||t.position.absolute).top+t.margins.top,a=n+t.helperProportions.width,r=o+t.helperProportions.height,l=e.offset.left,h=e.offset.top,c=l+e.proportions().width,u=h+e.proportions().height;switch(i){case"fit":return l<=n&&a<=c&&h<=o&&r<=u;case"intersect":return l<n+t.helperProportions.width/2&&a-t.helperProportions.width/2<c&&h<o+t.helperProportions.height/2&&r-t.helperProportions.height/2<u;case"pointer":return lt(s.pageY,h,e.proportions().height)&&lt(s.pageX,l,e.proportions().width);case"touch":return(h<=o&&o<=u||h<=r&&r<=u||o<h&&u<r)&&(l<=n&&n<=c||l<=a&&a<=c||n<l&&c<a);default:return!1}},!(V.ui.ddmanager={current:null,droppables:{default:[]},prepareOffsets:function(t,e){var i,s,n=V.ui.ddmanager.droppables[t.options.scope]||[],o=e?e.type:null,a=(t.currentItem||t.element).find(":data(ui-droppable)").addBack();t:for(i=0;i<n.length;i++)if(!(n[i].options.disabled||t&&!n[i].accept.call(n[i].element[0],t.currentItem||t.element))){for(s=0;s<a.length;s++)if(a[s]===n[i].element[0]){n[i].proportions().height=0;continue t}n[i].visible="none"!==n[i].element.css("display"),n[i].visible&&("mousedown"===o&&n[i]._activate.call(n[i],e),n[i].offset=n[i].element.offset(),n[i].proportions({width:n[i].element[0].offsetWidth,height:n[i].element[0].offsetHeight}))}},drop:function(t,e){var i=!1;return V.each((V.ui.ddmanager.droppables[t.options.scope]||[]).slice(),function(){this.options&&(!this.options.disabled&&this.visible&&V.ui.intersect(t,this,this.options.tolerance,e)&&(i=this._drop.call(this,e)||i),!this.options.disabled&&this.visible&&this.accept.call(this.element[0],t.currentItem||t.element)&&(this.isout=!0,this.isover=!1,this._deactivate.call(this,e)))}),i},dragStart:function(t,e){t.element.parentsUntil("body").on("scroll.droppable",function(){t.options.refreshPositions||V.ui.ddmanager.prepareOffsets(t,e)})},drag:function(n,o){n.options.refreshPositions&&V.ui.ddmanager.prepareOffsets(n,o),V.each(V.ui.ddmanager.droppables[n.options.scope]||[],function(){var t,e,i,s;this.options.disabled||this.greedyChild||!this.visible||(s=!(i=V.ui.intersect(n,this,this.options.tolerance,o))&&this.isover?"isout":i&&!this.isover?"isover":null)&&(this.options.greedy&&(e=this.options.scope,(i=this.element.parents(":data(ui-droppable)").filter(function(){return V(this).droppable("instance").options.scope===e})).length&&((t=V(i[0]).droppable("instance")).greedyChild="isover"===s)),t&&"isover"===s&&(t.isover=!1,t.isout=!0,t._out.call(t,o)),this[s]=!0,this["isout"===s?"isover":"isout"]=!1,this["isover"===s?"_over":"_out"].call(this,o),t&&"isout"===s&&(t.isout=!1,t.isover=!0,t._over.call(t,o)))})},dragStop:function(t,e){t.element.parentsUntil("body").off("scroll.droppable"),t.options.refreshPositions||V.ui.ddmanager.prepareOffsets(t,e)}})!==V.uiBackCompat&&V.widget("ui.droppable",V.ui.droppable,{options:{hoverClass:!1,activeClass:!1},_addActiveClass:function(){this._super(),this.options.activeClass&&this.element.addClass(this.options.activeClass)},_removeActiveClass:function(){this._super(),this.options.activeClass&&this.element.removeClass(this.options.activeClass)},_addHoverClass:function(){this._super(),this.options.hoverClass&&this.element.addClass(this.options.hoverClass)},_removeHoverClass:function(){this._super(),this.options.hoverClass&&this.element.removeClass(this.options.hoverClass)}});V.ui.droppable,V.widget("ui.progressbar",{version:"1.13.0",options:{classes:{"ui-progressbar":"ui-corner-all","ui-progressbar-value":"ui-corner-left","ui-progressbar-complete":"ui-corner-right"},max:100,value:0,change:null,complete:null},min:0,_create:function(){this.oldValue=this.options.value=this._constrainedValue(),this.element.attr({role:"progressbar","aria-valuemin":this.min}),this._addClass("ui-progressbar","ui-widget ui-widget-content"),this.valueDiv=V("<div>").appendTo(this.element),this._addClass(this.valueDiv,"ui-progressbar-value","ui-widget-header"),this._refreshValue()},_destroy:function(){this.element.removeAttr("role aria-valuemin aria-valuemax aria-valuenow"),this.valueDiv.remove()},value:function(t){if(void 0===t)return this.options.value;this.options.value=this._constrainedValue(t),this._refreshValue()},_constrainedValue:function(t){return void 0===t&&(t=this.options.value),this.indeterminate=!1===t,"number"!=typeof t&&(t=0),!this.indeterminate&&Math.min(this.options.max,Math.max(this.min,t))},_setOptions:function(t){var e=t.value;delete t.value,this._super(t),this.options.value=this._constrainedValue(e),this._refreshValue()},_setOption:function(t,e){"max"===t&&(e=Math.max(this.min,e)),this._super(t,e)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t),this._toggleClass(null,"ui-state-disabled",!!t)},_percentage:function(){return this.indeterminate?100:100*(this.options.value-this.min)/(this.options.max-this.min)},_refreshValue:function(){var t=this.options.value,e=this._percentage();this.valueDiv.toggle(this.indeterminate||t>this.min).width(e.toFixed(0)+"%"),this._toggleClass(this.valueDiv,"ui-progressbar-complete",null,t===this.options.max)._toggleClass("ui-progressbar-indeterminate",null,this.indeterminate),this.indeterminate?(this.element.removeAttr("aria-valuenow"),this.overlayDiv||(this.overlayDiv=V("<div>").appendTo(this.valueDiv),this._addClass(this.overlayDiv,"ui-progressbar-overlay"))):(this.element.attr({"aria-valuemax":this.options.max,"aria-valuenow":t}),this.overlayDiv&&(this.overlayDiv.remove(),this.overlayDiv=null)),this.oldValue!==t&&(this.oldValue=t,this._trigger("change")),t===this.options.max&&this._trigger("complete")}}),V.widget("ui.selectable",V.ui.mouse,{version:"1.13.0",options:{appendTo:"body",autoRefresh:!0,distance:0,filter:"*",tolerance:"touch",selected:null,selecting:null,start:null,stop:null,unselected:null,unselecting:null},_create:function(){var i=this;this._addClass("ui-selectable"),this.dragged=!1,this.refresh=function(){i.elementPos=V(i.element[0]).offset(),i.selectees=V(i.options.filter,i.element[0]),i._addClass(i.selectees,"ui-selectee"),i.selectees.each(function(){var t=V(this),e=t.offset(),e={left:e.left-i.elementPos.left,top:e.top-i.elementPos.top};V.data(this,"selectable-item",{element:this,$element:t,left:e.left,top:e.top,right:e.left+t.outerWidth(),bottom:e.top+t.outerHeight(),startselected:!1,selected:t.hasClass("ui-selected"),selecting:t.hasClass("ui-selecting"),unselecting:t.hasClass("ui-unselecting")})})},this.refresh(),this._mouseInit(),this.helper=V("<div>"),this._addClass(this.helper,"ui-selectable-helper")},_destroy:function(){this.selectees.removeData("selectable-item"),this._mouseDestroy()},_mouseStart:function(i){var s=this,t=this.options;this.opos=[i.pageX,i.pageY],this.elementPos=V(this.element[0]).offset(),this.options.disabled||(this.selectees=V(t.filter,this.element[0]),this._trigger("start",i),V(t.appendTo).append(this.helper),this.helper.css({left:i.pageX,top:i.pageY,width:0,height:0}),t.autoRefresh&&this.refresh(),this.selectees.filter(".ui-selected").each(function(){var t=V.data(this,"selectable-item");t.startselected=!0,i.metaKey||i.ctrlKey||(s._removeClass(t.$element,"ui-selected"),t.selected=!1,s._addClass(t.$element,"ui-unselecting"),t.unselecting=!0,s._trigger("unselecting",i,{unselecting:t.element}))}),V(i.target).parents().addBack().each(function(){var t,e=V.data(this,"selectable-item");if(e)return t=!i.metaKey&&!i.ctrlKey||!e.$element.hasClass("ui-selected"),s._removeClass(e.$element,t?"ui-unselecting":"ui-selected")._addClass(e.$element,t?"ui-selecting":"ui-unselecting"),e.unselecting=!t,e.selecting=t,(e.selected=t)?s._trigger("selecting",i,{selecting:e.element}):s._trigger("unselecting",i,{unselecting:e.element}),!1}))},_mouseDrag:function(s){if(this.dragged=!0,!this.options.disabled){var t,n=this,o=this.options,a=this.opos[0],r=this.opos[1],l=s.pageX,h=s.pageY;return l<a&&(t=l,l=a,a=t),h<r&&(t=h,h=r,r=t),this.helper.css({left:a,top:r,width:l-a,height:h-r}),this.selectees.each(function(){var t=V.data(this,"selectable-item"),e=!1,i={};t&&t.element!==n.element[0]&&(i.left=t.left+n.elementPos.left,i.right=t.right+n.elementPos.left,i.top=t.top+n.elementPos.top,i.bottom=t.bottom+n.elementPos.top,"touch"===o.tolerance?e=!(i.left>l||i.right<a||i.top>h||i.bottom<r):"fit"===o.tolerance&&(e=i.left>a&&i.right<l&&i.top>r&&i.bottom<h),e?(t.selected&&(n._removeClass(t.$element,"ui-selected"),t.selected=!1),t.unselecting&&(n._removeClass(t.$element,"ui-unselecting"),t.unselecting=!1),t.selecting||(n._addClass(t.$element,"ui-selecting"),t.selecting=!0,n._trigger("selecting",s,{selecting:t.element}))):(t.selecting&&((s.metaKey||s.ctrlKey)&&t.startselected?(n._removeClass(t.$element,"ui-selecting"),t.selecting=!1,n._addClass(t.$element,"ui-selected"),t.selected=!0):(n._removeClass(t.$element,"ui-selecting"),t.selecting=!1,t.startselected&&(n._addClass(t.$element,"ui-unselecting"),t.unselecting=!0),n._trigger("unselecting",s,{unselecting:t.element}))),t.selected&&(s.metaKey||s.ctrlKey||t.startselected||(n._removeClass(t.$element,"ui-selected"),t.selected=!1,n._addClass(t.$element,"ui-unselecting"),t.unselecting=!0,n._trigger("unselecting",s,{unselecting:t.element})))))}),!1}},_mouseStop:function(e){var i=this;return this.dragged=!1,V(".ui-unselecting",this.element[0]).each(function(){var t=V.data(this,"selectable-item");i._removeClass(t.$element,"ui-unselecting"),t.unselecting=!1,t.startselected=!1,i._trigger("unselected",e,{unselected:t.element})}),V(".ui-selecting",this.element[0]).each(function(){var t=V.data(this,"selectable-item");i._removeClass(t.$element,"ui-selecting")._addClass(t.$element,"ui-selected"),t.selecting=!1,t.selected=!0,t.startselected=!0,i._trigger("selected",e,{selected:t.element})}),this._trigger("stop",e),this.helper.remove(),!1}}),V.widget("ui.selectmenu",[V.ui.formResetMixin,{version:"1.13.0",defaultElement:"<select>",options:{appendTo:null,classes:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"},disabled:null,icons:{button:"ui-icon-triangle-1-s"},position:{my:"left top",at:"left bottom",collision:"none"},width:!1,change:null,close:null,focus:null,open:null,select:null},_create:function(){var t=this.element.uniqueId().attr("id");this.ids={element:t,button:t+"-button",menu:t+"-menu"},this._drawButton(),this._drawMenu(),this._bindFormResetHandler(),this._rendered=!1,this.menuItems=V()},_drawButton:function(){var t,e=this,i=this._parseOption(this.element.find("option:selected"),this.element[0].selectedIndex);this.labels=this.element.labels().attr("for",this.ids.button),this._on(this.labels,{click:function(t){this.button.trigger("focus"),t.preventDefault()}}),this.element.hide(),this.button=V("<span>",{tabindex:this.options.disabled?-1:0,id:this.ids.button,role:"combobox","aria-expanded":"false","aria-autocomplete":"list","aria-owns":this.ids.menu,"aria-haspopup":"true",title:this.element.attr("title")}).insertAfter(this.element),this._addClass(this.button,"ui-selectmenu-button ui-selectmenu-button-closed","ui-button ui-widget"),t=V("<span>").appendTo(this.button),this._addClass(t,"ui-selectmenu-icon","ui-icon "+this.options.icons.button),this.buttonItem=this._renderButtonItem(i).appendTo(this.button),!1!==this.options.width&&this._resizeButton(),this._on(this.button,this._buttonEvents),this.button.one("focusin",function(){e._rendered||e._refreshMenu()})},_drawMenu:function(){var i=this;this.menu=V("<ul>",{"aria-hidden":"true","aria-labelledby":this.ids.button,id:this.ids.menu}),this.menuWrap=V("<div>").append(this.menu),this._addClass(this.menuWrap,"ui-selectmenu-menu","ui-front"),this.menuWrap.appendTo(this._appendTo()),this.menuInstance=this.menu.menu({classes:{"ui-menu":"ui-corner-bottom"},role:"listbox",select:function(t,e){t.preventDefault(),i._setSelection(),i._select(e.item.data("ui-selectmenu-item"),t)},focus:function(t,e){e=e.item.data("ui-selectmenu-item");null!=i.focusIndex&&e.index!==i.focusIndex&&(i._trigger("focus",t,{item:e}),i.isOpen||i._select(e,t)),i.focusIndex=e.index,i.button.attr("aria-activedescendant",i.menuItems.eq(e.index).attr("id"))}}).menu("instance"),this.menuInstance._off(this.menu,"mouseleave"),this.menuInstance._closeOnDocumentClick=function(){return!1},this.menuInstance._isDivider=function(){return!1}},refresh:function(){this._refreshMenu(),this.buttonItem.replaceWith(this.buttonItem=this._renderButtonItem(this._getSelectedItem().data("ui-selectmenu-item")||{})),null===this.options.width&&this._resizeButton()},_refreshMenu:function(){var t=this.element.find("option");this.menu.empty(),this._parseOptions(t),this._renderMenu(this.menu,this.items),this.menuInstance.refresh(),this.menuItems=this.menu.find("li").not(".ui-selectmenu-optgroup").find(".ui-menu-item-wrapper"),this._rendered=!0,t.length&&(t=this._getSelectedItem(),this.menuInstance.focus(null,t),this._setAria(t.data("ui-selectmenu-item")),this._setOption("disabled",this.element.prop("disabled")))},open:function(t){this.options.disabled||(this._rendered?(this._removeClass(this.menu.find(".ui-state-active"),null,"ui-state-active"),this.menuInstance.focus(null,this._getSelectedItem())):this._refreshMenu(),this.menuItems.length&&(this.isOpen=!0,this._toggleAttr(),this._resizeMenu(),this._position(),this._on(this.document,this._documentClick),this._trigger("open",t)))},_position:function(){this.menuWrap.position(V.extend({of:this.button},this.options.position))},close:function(t){this.isOpen&&(this.isOpen=!1,this._toggleAttr(),this.range=null,this._off(this.document),this._trigger("close",t))},widget:function(){return this.button},menuWidget:function(){return this.menu},_renderButtonItem:function(t){var e=V("<span>");return this._setText(e,t.label),this._addClass(e,"ui-selectmenu-text"),e},_renderMenu:function(s,t){var n=this,o="";V.each(t,function(t,e){var i;e.optgroup!==o&&(i=V("<li>",{text:e.optgroup}),n._addClass(i,"ui-selectmenu-optgroup","ui-menu-divider"+(e.element.parent("optgroup").prop("disabled")?" ui-state-disabled":"")),i.appendTo(s),o=e.optgroup),n._renderItemData(s,e)})},_renderItemData:function(t,e){return this._renderItem(t,e).data("ui-selectmenu-item",e)},_renderItem:function(t,e){var i=V("<li>"),s=V("<div>",{title:e.element.attr("title")});return e.disabled&&this._addClass(i,null,"ui-state-disabled"),this._setText(s,e.label),i.append(s).appendTo(t)},_setText:function(t,e){e?t.text(e):t.html("&#160;")},_move:function(t,e){var i,s=".ui-menu-item";this.isOpen?i=this.menuItems.eq(this.focusIndex).parent("li"):(i=this.menuItems.eq(this.element[0].selectedIndex).parent("li"),s+=":not(.ui-state-disabled)"),(s="first"===t||"last"===t?i["first"===t?"prevAll":"nextAll"](s).eq(-1):i[t+"All"](s).eq(0)).length&&this.menuInstance.focus(e,s)},_getSelectedItem:function(){return this.menuItems.eq(this.element[0].selectedIndex).parent("li")},_toggle:function(t){this[this.isOpen?"close":"open"](t)},_setSelection:function(){var t;this.range&&(window.getSelection?((t=window.getSelection()).removeAllRanges(),t.addRange(this.range)):this.range.select(),this.button.focus())},_documentClick:{mousedown:function(t){this.isOpen&&(V(t.target).closest(".ui-selectmenu-menu, #"+V.escapeSelector(this.ids.button)).length||this.close(t))}},_buttonEvents:{mousedown:function(){var t;window.getSelection?(t=window.getSelection()).rangeCount&&(this.range=t.getRangeAt(0)):this.range=document.selection.createRange()},click:function(t){this._setSelection(),this._toggle(t)},keydown:function(t){var e=!0;switch(t.keyCode){case V.ui.keyCode.TAB:case V.ui.keyCode.ESCAPE:this.close(t),e=!1;break;case V.ui.keyCode.ENTER:this.isOpen&&this._selectFocusedItem(t);break;case V.ui.keyCode.UP:t.altKey?this._toggle(t):this._move("prev",t);break;case V.ui.keyCode.DOWN:t.altKey?this._toggle(t):this._move("next",t);break;case V.ui.keyCode.SPACE:this.isOpen?this._selectFocusedItem(t):this._toggle(t);break;case V.ui.keyCode.LEFT:this._move("prev",t);break;case V.ui.keyCode.RIGHT:this._move("next",t);break;case V.ui.keyCode.HOME:case V.ui.keyCode.PAGE_UP:this._move("first",t);break;case V.ui.keyCode.END:case V.ui.keyCode.PAGE_DOWN:this._move("last",t);break;default:this.menu.trigger(t),e=!1}e&&t.preventDefault()}},_selectFocusedItem:function(t){var e=this.menuItems.eq(this.focusIndex).parent("li");e.hasClass("ui-state-disabled")||this._select(e.data("ui-selectmenu-item"),t)},_select:function(t,e){var i=this.element[0].selectedIndex;this.element[0].selectedIndex=t.index,this.buttonItem.replaceWith(this.buttonItem=this._renderButtonItem(t)),this._setAria(t),this._trigger("select",e,{item:t}),t.index!==i&&this._trigger("change",e,{item:t}),this.close(e)},_setAria:function(t){t=this.menuItems.eq(t.index).attr("id");this.button.attr({"aria-labelledby":t,"aria-activedescendant":t}),this.menu.attr("aria-activedescendant",t)},_setOption:function(t,e){var i;"icons"===t&&(i=this.button.find("span.ui-icon"),this._removeClass(i,null,this.options.icons.button)._addClass(i,null,e.button)),this._super(t,e),"appendTo"===t&&this.menuWrap.appendTo(this._appendTo()),"width"===t&&this._resizeButton()},_setOptionDisabled:function(t){this._super(t),this.menuInstance.option("disabled",t),this.button.attr("aria-disabled",t),this._toggleClass(this.button,null,"ui-state-disabled",t),this.element.prop("disabled",t),t?(this.button.attr("tabindex",-1),this.close()):this.button.attr("tabindex",0)},_appendTo:function(){var t=this.options.appendTo;return t=!(t=!(t=t&&(t.jquery||t.nodeType?V(t):this.document.find(t).eq(0)))||!t[0]?this.element.closest(".ui-front, dialog"):t).length?this.document[0].body:t},_toggleAttr:function(){this.button.attr("aria-expanded",this.isOpen),this._removeClass(this.button,"ui-selectmenu-button-"+(this.isOpen?"closed":"open"))._addClass(this.button,"ui-selectmenu-button-"+(this.isOpen?"open":"closed"))._toggleClass(this.menuWrap,"ui-selectmenu-open",null,this.isOpen),this.menu.attr("aria-hidden",!this.isOpen)},_resizeButton:function(){var t=this.options.width;!1!==t?(null===t&&(t=this.element.show().outerWidth(),this.element.hide()),this.button.outerWidth(t)):this.button.css("width","")},_resizeMenu:function(){this.menu.outerWidth(Math.max(this.button.outerWidth(),this.menu.width("").outerWidth()+1))},_getCreateOptions:function(){var t=this._super();return t.disabled=this.element.prop("disabled"),t},_parseOptions:function(t){var i=this,s=[];t.each(function(t,e){e.hidden||s.push(i._parseOption(V(e),t))}),this.items=s},_parseOption:function(t,e){var i=t.parent("optgroup");return{element:t,index:e,value:t.val(),label:t.text(),optgroup:i.attr("label")||"",disabled:i.prop("disabled")||t.prop("disabled")}},_destroy:function(){this._unbindFormResetHandler(),this.menuWrap.remove(),this.button.remove(),this.element.show(),this.element.removeUniqueId(),this.labels.attr("for",this.ids.element)}}]),V.widget("ui.slider",V.ui.mouse,{version:"1.13.0",widgetEventPrefix:"slide",options:{animate:!1,classes:{"ui-slider":"ui-corner-all","ui-slider-handle":"ui-corner-all","ui-slider-range":"ui-corner-all ui-widget-header"},distance:0,max:100,min:0,orientation:"horizontal",range:!1,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},numPages:5,_create:function(){this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this._calculateNewMax(),this._addClass("ui-slider ui-slider-"+this.orientation,"ui-widget ui-widget-content"),this._refresh(),this._animateOff=!1},_refresh:function(){this._createRange(),this._createHandles(),this._setupEvents(),this._refreshValue()},_createHandles:function(){var t,e=this.options,i=this.element.find(".ui-slider-handle"),s=[],n=e.values&&e.values.length||1;for(i.length>n&&(i.slice(n).remove(),i=i.slice(0,n)),t=i.length;t<n;t++)s.push("<span tabindex='0'></span>");this.handles=i.add(V(s.join("")).appendTo(this.element)),this._addClass(this.handles,"ui-slider-handle","ui-state-default"),this.handle=this.handles.eq(0),this.handles.each(function(t){V(this).data("ui-slider-handle-index",t).attr("tabIndex",0)})},_createRange:function(){var t=this.options;t.range?(!0===t.range&&(t.values?t.values.length&&2!==t.values.length?t.values=[t.values[0],t.values[0]]:Array.isArray(t.values)&&(t.values=t.values.slice(0)):t.values=[this._valueMin(),this._valueMin()]),this.range&&this.range.length?(this._removeClass(this.range,"ui-slider-range-min ui-slider-range-max"),this.range.css({left:"",bottom:""})):(this.range=V("<div>").appendTo(this.element),this._addClass(this.range,"ui-slider-range")),"min"!==t.range&&"max"!==t.range||this._addClass(this.range,"ui-slider-range-"+t.range)):(this.range&&this.range.remove(),this.range=null)},_setupEvents:function(){this._off(this.handles),this._on(this.handles,this._handleEvents),this._hoverable(this.handles),this._focusable(this.handles)},_destroy:function(){this.handles.remove(),this.range&&this.range.remove(),this._mouseDestroy()},_mouseCapture:function(t){var i,s,n,o,e,a,r=this,l=this.options;return!l.disabled&&(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),a={x:t.pageX,y:t.pageY},i=this._normValueFromMouse(a),s=this._valueMax()-this._valueMin()+1,this.handles.each(function(t){var e=Math.abs(i-r.values(t));(e<s||s===e&&(t===r._lastChangedValue||r.values(t)===l.min))&&(s=e,n=V(this),o=t)}),!1!==this._start(t,o)&&(this._mouseSliding=!0,this._handleIndex=o,this._addClass(n,null,"ui-state-active"),n.trigger("focus"),e=n.offset(),a=!V(t.target).parents().addBack().is(".ui-slider-handle"),this._clickOffset=a?{left:0,top:0}:{left:t.pageX-e.left-n.width()/2,top:t.pageY-e.top-n.height()/2-(parseInt(n.css("borderTopWidth"),10)||0)-(parseInt(n.css("borderBottomWidth"),10)||0)+(parseInt(n.css("marginTop"),10)||0)},this.handles.hasClass("ui-state-hover")||this._slide(t,o,i),this._animateOff=!0))},_mouseStart:function(){return!0},_mouseDrag:function(t){var e={x:t.pageX,y:t.pageY},e=this._normValueFromMouse(e);return this._slide(t,this._handleIndex,e),!1},_mouseStop:function(t){return this._removeClass(this.handles,null,"ui-state-active"),this._mouseSliding=!1,this._stop(t,this._handleIndex),this._change(t,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1},_detectOrientation:function(){this.orientation="vertical"===this.options.orientation?"vertical":"horizontal"},_normValueFromMouse:function(t){var e,t="horizontal"===this.orientation?(e=this.elementSize.width,t.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(e=this.elementSize.height,t.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),t=t/e;return(t=1<t?1:t)<0&&(t=0),"vertical"===this.orientation&&(t=1-t),e=this._valueMax()-this._valueMin(),e=this._valueMin()+t*e,this._trimAlignValue(e)},_uiHash:function(t,e,i){var s={handle:this.handles[t],handleIndex:t,value:void 0!==e?e:this.value()};return this._hasMultipleValues()&&(s.value=void 0!==e?e:this.values(t),s.values=i||this.values()),s},_hasMultipleValues:function(){return this.options.values&&this.options.values.length},_start:function(t,e){return this._trigger("start",t,this._uiHash(e))},_slide:function(t,e,i){var s,n=this.value(),o=this.values();this._hasMultipleValues()&&(s=this.values(e?0:1),n=this.values(e),2===this.options.values.length&&!0===this.options.range&&(i=0===e?Math.min(s,i):Math.max(s,i)),o[e]=i),i!==n&&!1!==this._trigger("slide",t,this._uiHash(e,i,o))&&(this._hasMultipleValues()?this.values(e,i):this.value(i))},_stop:function(t,e){this._trigger("stop",t,this._uiHash(e))},_change:function(t,e){this._keySliding||this._mouseSliding||(this._lastChangedValue=e,this._trigger("change",t,this._uiHash(e)))},value:function(t){return arguments.length?(this.options.value=this._trimAlignValue(t),this._refreshValue(),void this._change(null,0)):this._value()},values:function(t,e){var i,s,n;if(1<arguments.length)return this.options.values[t]=this._trimAlignValue(e),this._refreshValue(),void this._change(null,t);if(!arguments.length)return this._values();if(!Array.isArray(t))return this._hasMultipleValues()?this._values(t):this.value();for(i=this.options.values,s=t,n=0;n<i.length;n+=1)i[n]=this._trimAlignValue(s[n]),this._change(null,n);this._refreshValue()},_setOption:function(t,e){var i,s=0;switch("range"===t&&!0===this.options.range&&("min"===e?(this.options.value=this._values(0),this.options.values=null):"max"===e&&(this.options.value=this._values(this.options.values.length-1),this.options.values=null)),Array.isArray(this.options.values)&&(s=this.options.values.length),this._super(t,e),t){case"orientation":this._detectOrientation(),this._removeClass("ui-slider-horizontal ui-slider-vertical")._addClass("ui-slider-"+this.orientation),this._refreshValue(),this.options.range&&this._refreshRange(e),this.handles.css("horizontal"===e?"bottom":"left","");break;case"value":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case"values":for(this._animateOff=!0,this._refreshValue(),i=s-1;0<=i;i--)this._change(null,i);this._animateOff=!1;break;case"step":case"min":case"max":this._animateOff=!0,this._calculateNewMax(),this._refreshValue(),this._animateOff=!1;break;case"range":this._animateOff=!0,this._refresh(),this._animateOff=!1}},_setOptionDisabled:function(t){this._super(t),this._toggleClass(null,"ui-state-disabled",!!t)},_value:function(){var t=this.options.value;return t=this._trimAlignValue(t)},_values:function(t){var e,i;if(arguments.length)return t=this.options.values[t],t=this._trimAlignValue(t);if(this._hasMultipleValues()){for(e=this.options.values.slice(),i=0;i<e.length;i+=1)e[i]=this._trimAlignValue(e[i]);return e}return[]},_trimAlignValue:function(t){if(t<=this._valueMin())return this._valueMin();if(t>=this._valueMax())return this._valueMax();var e=0<this.options.step?this.options.step:1,i=(t-this._valueMin())%e,t=t-i;return 2*Math.abs(i)>=e&&(t+=0<i?e:-e),parseFloat(t.toFixed(5))},_calculateNewMax:function(){var t=this.options.max,e=this._valueMin(),i=this.options.step;(t=Math.round((t-e)/i)*i+e)>this.options.max&&(t-=i),this.max=parseFloat(t.toFixed(this._precision()))},_precision:function(){var t=this._precisionOf(this.options.step);return t=null!==this.options.min?Math.max(t,this._precisionOf(this.options.min)):t},_precisionOf:function(t){var e=t.toString(),t=e.indexOf(".");return-1===t?0:e.length-t-1},_valueMin:function(){return this.options.min},_valueMax:function(){return this.max},_refreshRange:function(t){"vertical"===t&&this.range.css({width:"",left:""}),"horizontal"===t&&this.range.css({height:"",bottom:""})},_refreshValue:function(){var e,i,t,s,n,o=this.options.range,a=this.options,r=this,l=!this._animateOff&&a.animate,h={};this._hasMultipleValues()?this.handles.each(function(t){i=(r.values(t)-r._valueMin())/(r._valueMax()-r._valueMin())*100,h["horizontal"===r.orientation?"left":"bottom"]=i+"%",V(this).stop(1,1)[l?"animate":"css"](h,a.animate),!0===r.options.range&&("horizontal"===r.orientation?(0===t&&r.range.stop(1,1)[l?"animate":"css"]({left:i+"%"},a.animate),1===t&&r.range[l?"animate":"css"]({width:i-e+"%"},{queue:!1,duration:a.animate})):(0===t&&r.range.stop(1,1)[l?"animate":"css"]({bottom:i+"%"},a.animate),1===t&&r.range[l?"animate":"css"]({height:i-e+"%"},{queue:!1,duration:a.animate}))),e=i}):(t=this.value(),s=this._valueMin(),n=this._valueMax(),i=n!==s?(t-s)/(n-s)*100:0,h["horizontal"===this.orientation?"left":"bottom"]=i+"%",this.handle.stop(1,1)[l?"animate":"css"](h,a.animate),"min"===o&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:i+"%"},a.animate),"max"===o&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:100-i+"%"},a.animate),"min"===o&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:i+"%"},a.animate),"max"===o&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:100-i+"%"},a.animate))},_handleEvents:{keydown:function(t){var e,i,s,n=V(t.target).data("ui-slider-handle-index");switch(t.keyCode){case V.ui.keyCode.HOME:case V.ui.keyCode.END:case V.ui.keyCode.PAGE_UP:case V.ui.keyCode.PAGE_DOWN:case V.ui.keyCode.UP:case V.ui.keyCode.RIGHT:case V.ui.keyCode.DOWN:case V.ui.keyCode.LEFT:if(t.preventDefault(),!this._keySliding&&(this._keySliding=!0,this._addClass(V(t.target),null,"ui-state-active"),!1===this._start(t,n)))return}switch(s=this.options.step,e=i=this._hasMultipleValues()?this.values(n):this.value(),t.keyCode){case V.ui.keyCode.HOME:i=this._valueMin();break;case V.ui.keyCode.END:i=this._valueMax();break;case V.ui.keyCode.PAGE_UP:i=this._trimAlignValue(e+(this._valueMax()-this._valueMin())/this.numPages);break;case V.ui.keyCode.PAGE_DOWN:i=this._trimAlignValue(e-(this._valueMax()-this._valueMin())/this.numPages);break;case V.ui.keyCode.UP:case V.ui.keyCode.RIGHT:if(e===this._valueMax())return;i=this._trimAlignValue(e+s);break;case V.ui.keyCode.DOWN:case V.ui.keyCode.LEFT:if(e===this._valueMin())return;i=this._trimAlignValue(e-s)}this._slide(t,n,i)},keyup:function(t){var e=V(t.target).data("ui-slider-handle-index");this._keySliding&&(this._keySliding=!1,this._stop(t,e),this._change(t,e),this._removeClass(V(t.target),null,"ui-state-active"))}}}),V.widget("ui.sortable",V.ui.mouse,{version:"1.13.0",widgetEventPrefix:"sort",ready:!1,options:{appendTo:"parent",axis:!1,connectWith:!1,containment:!1,cursor:"auto",cursorAt:!1,dropOnEmpty:!0,forcePlaceholderSize:!1,forceHelperSize:!1,grid:!1,handle:!1,helper:"original",items:"> *",opacity:!1,placeholder:!1,revert:!1,scroll:!0,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1e3,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_isOverAxis:function(t,e,i){return e<=t&&t<e+i},_isFloating:function(t){return/left|right/.test(t.css("float"))||/inline|table-cell/.test(t.css("display"))},_create:function(){this.containerCache={},this._addClass("ui-sortable"),this.refresh(),this.offset=this.element.offset(),this._mouseInit(),this._setHandleClassName(),this.ready=!0},_setOption:function(t,e){this._super(t,e),"handle"===t&&this._setHandleClassName()},_setHandleClassName:function(){var t=this;this._removeClass(this.element.find(".ui-sortable-handle"),"ui-sortable-handle"),V.each(this.items,function(){t._addClass(this.instance.options.handle?this.item.find(this.instance.options.handle):this.item,"ui-sortable-handle")})},_destroy:function(){this._mouseDestroy();for(var t=this.items.length-1;0<=t;t--)this.items[t].item.removeData(this.widgetName+"-item");return this},_mouseCapture:function(t,e){var i=null,s=!1,n=this;return!this.reverting&&(!this.options.disabled&&"static"!==this.options.type&&(this._refreshItems(t),V(t.target).parents().each(function(){if(V.data(this,n.widgetName+"-item")===n)return i=V(this),!1}),!!(i=V.data(t.target,n.widgetName+"-item")===n?V(t.target):i)&&(!(this.options.handle&&!e&&(V(this.options.handle,i).find("*").addBack().each(function(){this===t.target&&(s=!0)}),!s))&&(this.currentItem=i,this._removeCurrentsFromItems(),!0))))},_mouseStart:function(t,e,i){var s,n,o=this.options;if((this.currentContainer=this).refreshPositions(),this.appendTo=V("parent"!==o.appendTo?o.appendTo:this.currentItem.parent()),this.helper=this._createHelper(t),this._cacheHelperProportions(),this._cacheMargins(),this.offset=this.currentItem.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},V.extend(this.offset,{click:{left:t.pageX-this.offset.left,top:t.pageY-this.offset.top},relative:this._getRelativeOffset()}),this.helper.css("position","absolute"),this.cssPosition=this.helper.css("position"),o.cursorAt&&this._adjustOffsetFromHelper(o.cursorAt),this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]},this.helper[0]!==this.currentItem[0]&&this.currentItem.hide(),this._createPlaceholder(),this.scrollParent=this.placeholder.scrollParent(),V.extend(this.offset,{parent:this._getParentOffset()}),o.containment&&this._setContainment(),o.cursor&&"auto"!==o.cursor&&(n=this.document.find("body"),this.storedCursor=n.css("cursor"),n.css("cursor",o.cursor),this.storedStylesheet=V("<style>*{ cursor: "+o.cursor+" !important; }</style>").appendTo(n)),o.zIndex&&(this.helper.css("zIndex")&&(this._storedZIndex=this.helper.css("zIndex")),this.helper.css("zIndex",o.zIndex)),o.opacity&&(this.helper.css("opacity")&&(this._storedOpacity=this.helper.css("opacity")),this.helper.css("opacity",o.opacity)),this.scrollParent[0]!==this.document[0]&&"HTML"!==this.scrollParent[0].tagName&&(this.overflowOffset=this.scrollParent.offset()),this._trigger("start",t,this._uiHash()),this._preserveHelperProportions||this._cacheHelperProportions(),!i)for(s=this.containers.length-1;0<=s;s--)this.containers[s]._trigger("activate",t,this._uiHash(this));return V.ui.ddmanager&&(V.ui.ddmanager.current=this),V.ui.ddmanager&&!o.dropBehaviour&&V.ui.ddmanager.prepareOffsets(this,t),this.dragging=!0,this._addClass(this.helper,"ui-sortable-helper"),this.helper.parent().is(this.appendTo)||(this.helper.detach().appendTo(this.appendTo),this.offset.parent=this._getParentOffset()),this.position=this.originalPosition=this._generatePosition(t),this.originalPageX=t.pageX,this.originalPageY=t.pageY,this.lastPositionAbs=this.positionAbs=this._convertPositionTo("absolute"),this._mouseDrag(t),!0},_scroll:function(t){var e=this.options,i=!1;return this.scrollParent[0]!==this.document[0]&&"HTML"!==this.scrollParent[0].tagName?(this.overflowOffset.top+this.scrollParent[0].offsetHeight-t.pageY<e.scrollSensitivity?this.scrollParent[0].scrollTop=i=this.scrollParent[0].scrollTop+e.scrollSpeed:t.pageY-this.overflowOffset.top<e.scrollSensitivity&&(this.scrollParent[0].scrollTop=i=this.scrollParent[0].scrollTop-e.scrollSpeed),this.overflowOffset.left+this.scrollParent[0].offsetWidth-t.pageX<e.scrollSensitivity?this.scrollParent[0].scrollLeft=i=this.scrollParent[0].scrollLeft+e.scrollSpeed:t.pageX-this.overflowOffset.left<e.scrollSensitivity&&(this.scrollParent[0].scrollLeft=i=this.scrollParent[0].scrollLeft-e.scrollSpeed)):(t.pageY-this.document.scrollTop()<e.scrollSensitivity?i=this.document.scrollTop(this.document.scrollTop()-e.scrollSpeed):this.window.height()-(t.pageY-this.document.scrollTop())<e.scrollSensitivity&&(i=this.document.scrollTop(this.document.scrollTop()+e.scrollSpeed)),t.pageX-this.document.scrollLeft()<e.scrollSensitivity?i=this.document.scrollLeft(this.document.scrollLeft()-e.scrollSpeed):this.window.width()-(t.pageX-this.document.scrollLeft())<e.scrollSensitivity&&(i=this.document.scrollLeft(this.document.scrollLeft()+e.scrollSpeed))),i},_mouseDrag:function(t){var e,i,s,n,o=this.options;if(this.position=this._generatePosition(t),this.positionAbs=this._convertPositionTo("absolute"),this.options.axis&&"y"===this.options.axis||(this.helper[0].style.left=this.position.left+"px"),this.options.axis&&"x"===this.options.axis||(this.helper[0].style.top=this.position.top+"px"),this._contactContainers(t),null!==this.innermostContainer)for(o.scroll&&!1!==this._scroll(t)&&(this._refreshItemPositions(!0),V.ui.ddmanager&&!o.dropBehaviour&&V.ui.ddmanager.prepareOffsets(this,t)),this.dragDirection={vertical:this._getDragVerticalDirection(),horizontal:this._getDragHorizontalDirection()},e=this.items.length-1;0<=e;e--)if(s=(i=this.items[e]).item[0],(n=this._intersectsWithPointer(i))&&i.instance===this.currentContainer&&!(s===this.currentItem[0]||this.placeholder[1===n?"next":"prev"]()[0]===s||V.contains(this.placeholder[0],s)||"semi-dynamic"===this.options.type&&V.contains(this.element[0],s))){if(this.direction=1===n?"down":"up","pointer"!==this.options.tolerance&&!this._intersectsWithSides(i))break;this._rearrange(t,i),this._trigger("change",t,this._uiHash());break}return V.ui.ddmanager&&V.ui.ddmanager.drag(this,t),this._trigger("sort",t,this._uiHash()),this.lastPositionAbs=this.positionAbs,!1},_mouseStop:function(t,e){var i,s,n,o;if(t)return V.ui.ddmanager&&!this.options.dropBehaviour&&V.ui.ddmanager.drop(this,t),this.options.revert?(s=(i=this).placeholder.offset(),o={},(n=this.options.axis)&&"x"!==n||(o.left=s.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===this.document[0].body?0:this.offsetParent[0].scrollLeft)),n&&"y"!==n||(o.top=s.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===this.document[0].body?0:this.offsetParent[0].scrollTop)),this.reverting=!0,V(this.helper).animate(o,parseInt(this.options.revert,10)||500,function(){i._clear(t)})):this._clear(t,e),!1},cancel:function(){if(this.dragging){this._mouseUp(new V.Event("mouseup",{target:null})),"original"===this.options.helper?(this.currentItem.css(this._storedCSS),this._removeClass(this.currentItem,"ui-sortable-helper")):this.currentItem.show();for(var t=this.containers.length-1;0<=t;t--)this.containers[t]._trigger("deactivate",null,this._uiHash(this)),this.containers[t].containerCache.over&&(this.containers[t]._trigger("out",null,this._uiHash(this)),this.containers[t].containerCache.over=0)}return this.placeholder&&(this.placeholder[0].parentNode&&this.placeholder[0].parentNode.removeChild(this.placeholder[0]),"original"!==this.options.helper&&this.helper&&this.helper[0].parentNode&&this.helper.remove(),V.extend(this,{helper:null,dragging:!1,reverting:!1,_noFinalSort:null}),this.domPosition.prev?V(this.domPosition.prev).after(this.currentItem):V(this.domPosition.parent).prepend(this.currentItem)),this},serialize:function(e){var t=this._getItemsAsjQuery(e&&e.connected),i=[];return e=e||{},V(t).each(function(){var t=(V(e.item||this).attr(e.attribute||"id")||"").match(e.expression||/(.+)[\-=_](.+)/);t&&i.push((e.key||t[1]+"[]")+"="+(e.key&&e.expression?t[1]:t[2]))}),!i.length&&e.key&&i.push(e.key+"="),i.join("&")},toArray:function(t){var e=this._getItemsAsjQuery(t&&t.connected),i=[];return t=t||{},e.each(function(){i.push(V(t.item||this).attr(t.attribute||"id")||"")}),i},_intersectsWith:function(t){var e=this.positionAbs.left,i=e+this.helperProportions.width,s=this.positionAbs.top,n=s+this.helperProportions.height,o=t.left,a=o+t.width,r=t.top,l=r+t.height,h=this.offset.click.top,c=this.offset.click.left,h="x"===this.options.axis||r<s+h&&s+h<l,c="y"===this.options.axis||o<e+c&&e+c<a;return"pointer"===this.options.tolerance||this.options.forcePointerForContainers||"pointer"!==this.options.tolerance&&this.helperProportions[this.floating?"width":"height"]>t[this.floating?"width":"height"]?h&&c:o<e+this.helperProportions.width/2&&i-this.helperProportions.width/2<a&&r<s+this.helperProportions.height/2&&n-this.helperProportions.height/2<l},_intersectsWithPointer:function(t){var e="x"===this.options.axis||this._isOverAxis(this.positionAbs.top+this.offset.click.top,t.top,t.height),t="y"===this.options.axis||this._isOverAxis(this.positionAbs.left+this.offset.click.left,t.left,t.width);return!(!e||!t)&&(e=this.dragDirection.vertical,t=this.dragDirection.horizontal,this.floating?"right"===t||"down"===e?2:1:e&&("down"===e?2:1))},_intersectsWithSides:function(t){var e=this._isOverAxis(this.positionAbs.top+this.offset.click.top,t.top+t.height/2,t.height),i=this._isOverAxis(this.positionAbs.left+this.offset.click.left,t.left+t.width/2,t.width),s=this.dragDirection.vertical,t=this.dragDirection.horizontal;return this.floating&&t?"right"===t&&i||"left"===t&&!i:s&&("down"===s&&e||"up"===s&&!e)},_getDragVerticalDirection:function(){var t=this.positionAbs.top-this.lastPositionAbs.top;return 0!=t&&(0<t?"down":"up")},_getDragHorizontalDirection:function(){var t=this.positionAbs.left-this.lastPositionAbs.left;return 0!=t&&(0<t?"right":"left")},refresh:function(t){return this._refreshItems(t),this._setHandleClassName(),this.refreshPositions(),this},_connectWith:function(){var t=this.options;return t.connectWith.constructor===String?[t.connectWith]:t.connectWith},_getItemsAsjQuery:function(t){var e,i,s,n,o=[],a=[],r=this._connectWith();if(r&&t)for(e=r.length-1;0<=e;e--)for(i=(s=V(r[e],this.document[0])).length-1;0<=i;i--)(n=V.data(s[i],this.widgetFullName))&&n!==this&&!n.options.disabled&&a.push(["function"==typeof n.options.items?n.options.items.call(n.element):V(n.options.items,n.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),n]);function l(){o.push(this)}for(a.push(["function"==typeof this.options.items?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):V(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]),e=a.length-1;0<=e;e--)a[e][0].each(l);return V(o)},_removeCurrentsFromItems:function(){var i=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=V.grep(this.items,function(t){for(var e=0;e<i.length;e++)if(i[e]===t.item[0])return!1;return!0})},_refreshItems:function(t){this.items=[],this.containers=[this];var e,i,s,n,o,a,r,l,h=this.items,c=[["function"==typeof this.options.items?this.options.items.call(this.element[0],t,{item:this.currentItem}):V(this.options.items,this.element),this]],u=this._connectWith();if(u&&this.ready)for(e=u.length-1;0<=e;e--)for(i=(s=V(u[e],this.document[0])).length-1;0<=i;i--)(n=V.data(s[i],this.widgetFullName))&&n!==this&&!n.options.disabled&&(c.push(["function"==typeof n.options.items?n.options.items.call(n.element[0],t,{item:this.currentItem}):V(n.options.items,n.element),n]),this.containers.push(n));for(e=c.length-1;0<=e;e--)for(o=c[e][1],l=(a=c[e][i=0]).length;i<l;i++)(r=V(a[i])).data(this.widgetName+"-item",o),h.push({item:r,instance:o,width:0,height:0,left:0,top:0})},_refreshItemPositions:function(t){for(var e,i,s=this.items.length-1;0<=s;s--)e=this.items[s],this.currentContainer&&e.instance!==this.currentContainer&&e.item[0]!==this.currentItem[0]||(i=this.options.toleranceElement?V(this.options.toleranceElement,e.item):e.item,t||(e.width=i.outerWidth(),e.height=i.outerHeight()),i=i.offset(),e.left=i.left,e.top=i.top)},refreshPositions:function(t){var e,i;if(this.floating=!!this.items.length&&("x"===this.options.axis||this._isFloating(this.items[0].item)),null!==this.innermostContainer&&this._refreshItemPositions(t),this.options.custom&&this.options.custom.refreshContainers)this.options.custom.refreshContainers.call(this);else for(e=this.containers.length-1;0<=e;e--)i=this.containers[e].element.offset(),this.containers[e].containerCache.left=i.left,this.containers[e].containerCache.top=i.top,this.containers[e].containerCache.width=this.containers[e].element.outerWidth(),this.containers[e].containerCache.height=this.containers[e].element.outerHeight();return this},_createPlaceholder:function(i){var s,n,o=(i=i||this).options;o.placeholder&&o.placeholder.constructor!==String||(s=o.placeholder,n=i.currentItem[0].nodeName.toLowerCase(),o.placeholder={element:function(){var t=V("<"+n+">",i.document[0]);return i._addClass(t,"ui-sortable-placeholder",s||i.currentItem[0].className)._removeClass(t,"ui-sortable-helper"),"tbody"===n?i._createTrPlaceholder(i.currentItem.find("tr").eq(0),V("<tr>",i.document[0]).appendTo(t)):"tr"===n?i._createTrPlaceholder(i.currentItem,t):"img"===n&&t.attr("src",i.currentItem.attr("src")),s||t.css("visibility","hidden"),t},update:function(t,e){s&&!o.forcePlaceholderSize||(e.height()&&(!o.forcePlaceholderSize||"tbody"!==n&&"tr"!==n)||e.height(i.currentItem.innerHeight()-parseInt(i.currentItem.css("paddingTop")||0,10)-parseInt(i.currentItem.css("paddingBottom")||0,10)),e.width()||e.width(i.currentItem.innerWidth()-parseInt(i.currentItem.css("paddingLeft")||0,10)-parseInt(i.currentItem.css("paddingRight")||0,10)))}}),i.placeholder=V(o.placeholder.element.call(i.element,i.currentItem)),i.currentItem.after(i.placeholder),o.placeholder.update(i,i.placeholder)},_createTrPlaceholder:function(t,e){var i=this;t.children().each(function(){V("<td>&#160;</td>",i.document[0]).attr("colspan",V(this).attr("colspan")||1).appendTo(e)})},_contactContainers:function(t){for(var e,i,s,n,o,a,r,l,h,c=null,u=null,d=this.containers.length-1;0<=d;d--)V.contains(this.currentItem[0],this.containers[d].element[0])||(this._intersectsWith(this.containers[d].containerCache)?c&&V.contains(this.containers[d].element[0],c.element[0])||(c=this.containers[d],u=d):this.containers[d].containerCache.over&&(this.containers[d]._trigger("out",t,this._uiHash(this)),this.containers[d].containerCache.over=0));if(this.innermostContainer=c)if(1===this.containers.length)this.containers[u].containerCache.over||(this.containers[u]._trigger("over",t,this._uiHash(this)),this.containers[u].containerCache.over=1);else{for(i=1e4,s=null,n=(l=c.floating||this._isFloating(this.currentItem))?"left":"top",o=l?"width":"height",h=l?"pageX":"pageY",e=this.items.length-1;0<=e;e--)V.contains(this.containers[u].element[0],this.items[e].item[0])&&this.items[e].item[0]!==this.currentItem[0]&&(a=this.items[e].item.offset()[n],r=!1,t[h]-a>this.items[e][o]/2&&(r=!0),Math.abs(t[h]-a)<i&&(i=Math.abs(t[h]-a),s=this.items[e],this.direction=r?"up":"down"));(s||this.options.dropOnEmpty)&&(this.currentContainer!==this.containers[u]?(s?this._rearrange(t,s,null,!0):this._rearrange(t,null,this.containers[u].element,!0),this._trigger("change",t,this._uiHash()),this.containers[u]._trigger("change",t,this._uiHash(this)),this.currentContainer=this.containers[u],this.options.placeholder.update(this.currentContainer,this.placeholder),this.scrollParent=this.placeholder.scrollParent(),this.scrollParent[0]!==this.document[0]&&"HTML"!==this.scrollParent[0].tagName&&(this.overflowOffset=this.scrollParent.offset()),this.containers[u]._trigger("over",t,this._uiHash(this)),this.containers[u].containerCache.over=1):this.currentContainer.containerCache.over||(this.containers[u]._trigger("over",t,this._uiHash()),this.currentContainer.containerCache.over=1))}},_createHelper:function(t){var e=this.options,t="function"==typeof e.helper?V(e.helper.apply(this.element[0],[t,this.currentItem])):"clone"===e.helper?this.currentItem.clone():this.currentItem;return t.parents("body").length||this.appendTo[0].appendChild(t[0]),t[0]===this.currentItem[0]&&(this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}),t[0].style.width&&!e.forceHelperSize||t.width(this.currentItem.width()),t[0].style.height&&!e.forceHelperSize||t.height(this.currentItem.height()),t},_adjustOffsetFromHelper:function(t){"string"==typeof t&&(t=t.split(" ")),"left"in(t=Array.isArray(t)?{left:+t[0],top:+t[1]||0}:t)&&(this.offset.click.left=t.left+this.margins.left),"right"in t&&(this.offset.click.left=this.helperProportions.width-t.right+this.margins.left),"top"in t&&(this.offset.click.top=t.top+this.margins.top),"bottom"in t&&(this.offset.click.top=this.helperProportions.height-t.bottom+this.margins.top)},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var t=this.offsetParent.offset();return"absolute"===this.cssPosition&&this.scrollParent[0]!==this.document[0]&&V.contains(this.scrollParent[0],this.offsetParent[0])&&(t.left+=this.scrollParent.scrollLeft(),t.top+=this.scrollParent.scrollTop()),{top:(t=this.offsetParent[0]===this.document[0].body||this.offsetParent[0].tagName&&"html"===this.offsetParent[0].tagName.toLowerCase()&&V.ui.ie?{top:0,left:0}:t).top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:t.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"!==this.cssPosition)return{top:0,left:0};var t=this.currentItem.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css("marginLeft"),10)||0,top:parseInt(this.currentItem.css("marginTop"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var t,e,i=this.options;"parent"===i.containment&&(i.containment=this.helper[0].parentNode),"document"!==i.containment&&"window"!==i.containment||(this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,"document"===i.containment?this.document.width():this.window.width()-this.helperProportions.width-this.margins.left,("document"===i.containment?this.document.height()||document.body.parentNode.scrollHeight:this.window.height()||this.document[0].body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(i.containment)||(t=V(i.containment)[0],e=V(i.containment).offset(),i="hidden"!==V(t).css("overflow"),this.containment=[e.left+(parseInt(V(t).css("borderLeftWidth"),10)||0)+(parseInt(V(t).css("paddingLeft"),10)||0)-this.margins.left,e.top+(parseInt(V(t).css("borderTopWidth"),10)||0)+(parseInt(V(t).css("paddingTop"),10)||0)-this.margins.top,e.left+(i?Math.max(t.scrollWidth,t.offsetWidth):t.offsetWidth)-(parseInt(V(t).css("borderLeftWidth"),10)||0)-(parseInt(V(t).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,e.top+(i?Math.max(t.scrollHeight,t.offsetHeight):t.offsetHeight)-(parseInt(V(t).css("borderTopWidth"),10)||0)-(parseInt(V(t).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top])},_convertPositionTo:function(t,e){e=e||this.position;var i="absolute"===t?1:-1,s="absolute"!==this.cssPosition||this.scrollParent[0]!==this.document[0]&&V.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,t=/(html|body)/i.test(s[0].tagName);return{top:e.top+this.offset.relative.top*i+this.offset.parent.top*i-("fixed"===this.cssPosition?-this.scrollParent.scrollTop():t?0:s.scrollTop())*i,left:e.left+this.offset.relative.left*i+this.offset.parent.left*i-("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():t?0:s.scrollLeft())*i}},_generatePosition:function(t){var e=this.options,i=t.pageX,s=t.pageY,n="absolute"!==this.cssPosition||this.scrollParent[0]!==this.document[0]&&V.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,o=/(html|body)/i.test(n[0].tagName);return"relative"!==this.cssPosition||this.scrollParent[0]!==this.document[0]&&this.scrollParent[0]!==this.offsetParent[0]||(this.offset.relative=this._getRelativeOffset()),this.originalPosition&&(this.containment&&(t.pageX-this.offset.click.left<this.containment[0]&&(i=this.containment[0]+this.offset.click.left),t.pageY-this.offset.click.top<this.containment[1]&&(s=this.containment[1]+this.offset.click.top),t.pageX-this.offset.click.left>this.containment[2]&&(i=this.containment[2]+this.offset.click.left),t.pageY-this.offset.click.top>this.containment[3]&&(s=this.containment[3]+this.offset.click.top)),e.grid&&(t=this.originalPageY+Math.round((s-this.originalPageY)/e.grid[1])*e.grid[1],s=!this.containment||t-this.offset.click.top>=this.containment[1]&&t-this.offset.click.top<=this.containment[3]?t:t-this.offset.click.top>=this.containment[1]?t-e.grid[1]:t+e.grid[1],t=this.originalPageX+Math.round((i-this.originalPageX)/e.grid[0])*e.grid[0],i=!this.containment||t-this.offset.click.left>=this.containment[0]&&t-this.offset.click.left<=this.containment[2]?t:t-this.offset.click.left>=this.containment[0]?t-e.grid[0]:t+e.grid[0])),{top:s-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.scrollParent.scrollTop():o?0:n.scrollTop()),left:i-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():o?0:n.scrollLeft())}},_rearrange:function(t,e,i,s){i?i[0].appendChild(this.placeholder[0]):e.item[0].parentNode.insertBefore(this.placeholder[0],"down"===this.direction?e.item[0]:e.item[0].nextSibling),this.counter=this.counter?++this.counter:1;var n=this.counter;this._delay(function(){n===this.counter&&this.refreshPositions(!s)})},_clear:function(t,e){this.reverting=!1;var i,s=[];if(!this._noFinalSort&&this.currentItem.parent().length&&this.placeholder.before(this.currentItem),this._noFinalSort=null,this.helper[0]===this.currentItem[0]){for(i in this._storedCSS)"auto"!==this._storedCSS[i]&&"static"!==this._storedCSS[i]||(this._storedCSS[i]="");this.currentItem.css(this._storedCSS),this._removeClass(this.currentItem,"ui-sortable-helper")}else this.currentItem.show();function n(e,i,s){return function(t){s._trigger(e,t,i._uiHash(i))}}for(this.fromOutside&&!e&&s.push(function(t){this._trigger("receive",t,this._uiHash(this.fromOutside))}),!this.fromOutside&&this.domPosition.prev===this.currentItem.prev().not(".ui-sortable-helper")[0]&&this.domPosition.parent===this.currentItem.parent()[0]||e||s.push(function(t){this._trigger("update",t,this._uiHash())}),this!==this.currentContainer&&(e||(s.push(function(t){this._trigger("remove",t,this._uiHash())}),s.push(function(e){return function(t){e._trigger("receive",t,this._uiHash(this))}}.call(this,this.currentContainer)),s.push(function(e){return function(t){e._trigger("update",t,this._uiHash(this))}}.call(this,this.currentContainer)))),i=this.containers.length-1;0<=i;i--)e||s.push(n("deactivate",this,this.containers[i])),this.containers[i].containerCache.over&&(s.push(n("out",this,this.containers[i])),this.containers[i].containerCache.over=0);if(this.storedCursor&&(this.document.find("body").css("cursor",this.storedCursor),this.storedStylesheet.remove()),this._storedOpacity&&this.helper.css("opacity",this._storedOpacity),this._storedZIndex&&this.helper.css("zIndex","auto"===this._storedZIndex?"":this._storedZIndex),this.dragging=!1,e||this._trigger("beforeStop",t,this._uiHash()),this.placeholder[0].parentNode.removeChild(this.placeholder[0]),this.cancelHelperRemoval||(this.helper[0]!==this.currentItem[0]&&this.helper.remove(),this.helper=null),!e){for(i=0;i<s.length;i++)s[i].call(this,t);this._trigger("stop",t,this._uiHash())}return this.fromOutside=!1,!this.cancelHelperRemoval},_trigger:function(){!1===V.Widget.prototype._trigger.apply(this,arguments)&&this.cancel()},_uiHash:function(t){var e=t||this;return{helper:e.helper,placeholder:e.placeholder||V([]),position:e.position,originalPosition:e.originalPosition,offset:e.positionAbs,item:e.currentItem,sender:t?t.element:null}}});function ht(e){return function(){var t=this.element.val();e.apply(this,arguments),this._refresh(),t!==this.element.val()&&this._trigger("change")}}V.widget("ui.spinner",{version:"1.13.0",defaultElement:"<input>",widgetEventPrefix:"spin",options:{classes:{"ui-spinner":"ui-corner-all","ui-spinner-down":"ui-corner-br","ui-spinner-up":"ui-corner-tr"},culture:null,icons:{down:"ui-icon-triangle-1-s",up:"ui-icon-triangle-1-n"},incremental:!0,max:null,min:null,numberFormat:null,page:10,step:1,change:null,spin:null,start:null,stop:null},_create:function(){this._setOption("max",this.options.max),this._setOption("min",this.options.min),this._setOption("step",this.options.step),""!==this.value()&&this._value(this.element.val(),!0),this._draw(),this._on(this._events),this._refresh(),this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_getCreateOptions:function(){var s=this._super(),n=this.element;return V.each(["min","max","step"],function(t,e){var i=n.attr(e);null!=i&&i.length&&(s[e]=i)}),s},_events:{keydown:function(t){this._start(t)&&this._keydown(t)&&t.preventDefault()},keyup:"_stop",focus:function(){this.previous=this.element.val()},blur:function(t){this.cancelBlur?delete this.cancelBlur:(this._stop(),this._refresh(),this.previous!==this.element.val()&&this._trigger("change",t))},mousewheel:function(t,e){var i=V.ui.safeActiveElement(this.document[0]);if(this.element[0]===i&&e){if(!this.spinning&&!this._start(t))return!1;this._spin((0<e?1:-1)*this.options.step,t),clearTimeout(this.mousewheelTimer),this.mousewheelTimer=this._delay(function(){this.spinning&&this._stop(t)},100),t.preventDefault()}},"mousedown .ui-spinner-button":function(t){var e;function i(){this.element[0]===V.ui.safeActiveElement(this.document[0])||(this.element.trigger("focus"),this.previous=e,this._delay(function(){this.previous=e}))}e=this.element[0]===V.ui.safeActiveElement(this.document[0])?this.previous:this.element.val(),t.preventDefault(),i.call(this),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur,i.call(this)}),!1!==this._start(t)&&this._repeat(null,V(t.currentTarget).hasClass("ui-spinner-up")?1:-1,t)},"mouseup .ui-spinner-button":"_stop","mouseenter .ui-spinner-button":function(t){if(V(t.currentTarget).hasClass("ui-state-active"))return!1!==this._start(t)&&void this._repeat(null,V(t.currentTarget).hasClass("ui-spinner-up")?1:-1,t)},"mouseleave .ui-spinner-button":"_stop"},_enhance:function(){this.uiSpinner=this.element.attr("autocomplete","off").wrap("<span>").parent().append("<a></a><a></a>")},_draw:function(){this._enhance(),this._addClass(this.uiSpinner,"ui-spinner","ui-widget ui-widget-content"),this._addClass("ui-spinner-input"),this.element.attr("role","spinbutton"),this.buttons=this.uiSpinner.children("a").attr("tabIndex",-1).attr("aria-hidden",!0).button({classes:{"ui-button":""}}),this._removeClass(this.buttons,"ui-corner-all"),this._addClass(this.buttons.first(),"ui-spinner-button ui-spinner-up"),this._addClass(this.buttons.last(),"ui-spinner-button ui-spinner-down"),this.buttons.first().button({icon:this.options.icons.up,showLabel:!1}),this.buttons.last().button({icon:this.options.icons.down,showLabel:!1}),this.buttons.height()>Math.ceil(.5*this.uiSpinner.height())&&0<this.uiSpinner.height()&&this.uiSpinner.height(this.uiSpinner.height())},_keydown:function(t){var e=this.options,i=V.ui.keyCode;switch(t.keyCode){case i.UP:return this._repeat(null,1,t),!0;case i.DOWN:return this._repeat(null,-1,t),!0;case i.PAGE_UP:return this._repeat(null,e.page,t),!0;case i.PAGE_DOWN:return this._repeat(null,-e.page,t),!0}return!1},_start:function(t){return!(!this.spinning&&!1===this._trigger("start",t))&&(this.counter||(this.counter=1),this.spinning=!0)},_repeat:function(t,e,i){t=t||500,clearTimeout(this.timer),this.timer=this._delay(function(){this._repeat(40,e,i)},t),this._spin(e*this.options.step,i)},_spin:function(t,e){var i=this.value()||0;this.counter||(this.counter=1),i=this._adjustValue(i+t*this._increment(this.counter)),this.spinning&&!1===this._trigger("spin",e,{value:i})||(this._value(i),this.counter++)},_increment:function(t){var e=this.options.incremental;return e?"function"==typeof e?e(t):Math.floor(t*t*t/5e4-t*t/500+17*t/200+1):1},_precision:function(){var t=this._precisionOf(this.options.step);return t=null!==this.options.min?Math.max(t,this._precisionOf(this.options.min)):t},_precisionOf:function(t){var e=t.toString(),t=e.indexOf(".");return-1===t?0:e.length-t-1},_adjustValue:function(t){var e=this.options,i=null!==e.min?e.min:0,s=t-i;return t=i+Math.round(s/e.step)*e.step,t=parseFloat(t.toFixed(this._precision())),null!==e.max&&t>e.max?e.max:null!==e.min&&t<e.min?e.min:t},_stop:function(t){this.spinning&&(clearTimeout(this.timer),clearTimeout(this.mousewheelTimer),this.counter=0,this.spinning=!1,this._trigger("stop",t))},_setOption:function(t,e){var i;if("culture"===t||"numberFormat"===t)return i=this._parse(this.element.val()),this.options[t]=e,void this.element.val(this._format(i));"max"!==t&&"min"!==t&&"step"!==t||"string"==typeof e&&(e=this._parse(e)),"icons"===t&&(i=this.buttons.first().find(".ui-icon"),this._removeClass(i,null,this.options.icons.up),this._addClass(i,null,e.up),i=this.buttons.last().find(".ui-icon"),this._removeClass(i,null,this.options.icons.down),this._addClass(i,null,e.down)),this._super(t,e)},_setOptionDisabled:function(t){this._super(t),this._toggleClass(this.uiSpinner,null,"ui-state-disabled",!!t),this.element.prop("disabled",!!t),this.buttons.button(t?"disable":"enable")},_setOptions:ht(function(t){this._super(t)}),_parse:function(t){return""===(t="string"==typeof t&&""!==t?window.Globalize&&this.options.numberFormat?Globalize.parseFloat(t,10,this.options.culture):+t:t)||isNaN(t)?null:t},_format:function(t){return""===t?"":window.Globalize&&this.options.numberFormat?Globalize.format(t,this.options.numberFormat,this.options.culture):t},_refresh:function(){this.element.attr({"aria-valuemin":this.options.min,"aria-valuemax":this.options.max,"aria-valuenow":this._parse(this.element.val())})},isValid:function(){var t=this.value();return null!==t&&t===this._adjustValue(t)},_value:function(t,e){var i;""!==t&&null!==(i=this._parse(t))&&(e||(i=this._adjustValue(i)),t=this._format(i)),this.element.val(t),this._refresh()},_destroy:function(){this.element.prop("disabled",!1).removeAttr("autocomplete role aria-valuemin aria-valuemax aria-valuenow"),this.uiSpinner.replaceWith(this.element)},stepUp:ht(function(t){this._stepUp(t)}),_stepUp:function(t){this._start()&&(this._spin((t||1)*this.options.step),this._stop())},stepDown:ht(function(t){this._stepDown(t)}),_stepDown:function(t){this._start()&&(this._spin((t||1)*-this.options.step),this._stop())},pageUp:ht(function(t){this._stepUp((t||1)*this.options.page)}),pageDown:ht(function(t){this._stepDown((t||1)*this.options.page)}),value:function(t){if(!arguments.length)return this._parse(this.element.val());ht(this._value).call(this,t)},widget:function(){return this.uiSpinner}}),!1!==V.uiBackCompat&&V.widget("ui.spinner",V.ui.spinner,{_enhance:function(){this.uiSpinner=this.element.attr("autocomplete","off").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml())},_uiSpinnerHtml:function(){return"<span>"},_buttonHtml:function(){return"<a></a><a></a>"}});var ct;V.ui.spinner;V.widget("ui.tabs",{version:"1.13.0",delay:300,options:{active:null,classes:{"ui-tabs":"ui-corner-all","ui-tabs-nav":"ui-corner-all","ui-tabs-panel":"ui-corner-bottom","ui-tabs-tab":"ui-corner-top"},collapsible:!1,event:"click",heightStyle:"content",hide:null,show:null,activate:null,beforeActivate:null,beforeLoad:null,load:null},_isLocal:(ct=/#.*$/,function(t){var e=t.href.replace(ct,""),i=location.href.replace(ct,"");try{e=decodeURIComponent(e)}catch(t){}try{i=decodeURIComponent(i)}catch(t){}return 1<t.hash.length&&e===i}),_create:function(){var e=this,t=this.options;this.running=!1,this._addClass("ui-tabs","ui-widget ui-widget-content"),this._toggleClass("ui-tabs-collapsible",null,t.collapsible),this._processTabs(),t.active=this._initialActive(),Array.isArray(t.disabled)&&(t.disabled=V.uniqueSort(t.disabled.concat(V.map(this.tabs.filter(".ui-state-disabled"),function(t){return e.tabs.index(t)}))).sort()),!1!==this.options.active&&this.anchors.length?this.active=this._findActive(t.active):this.active=V(),this._refresh(),this.active.length&&this.load(t.active)},_initialActive:function(){var i=this.options.active,t=this.options.collapsible,s=location.hash.substring(1);return null===i&&(s&&this.tabs.each(function(t,e){if(V(e).attr("aria-controls")===s)return i=t,!1}),null!==(i=null===i?this.tabs.index(this.tabs.filter(".ui-tabs-active")):i)&&-1!==i||(i=!!this.tabs.length&&0)),!1!==i&&-1===(i=this.tabs.index(this.tabs.eq(i)))&&(i=!t&&0),i=!t&&!1===i&&this.anchors.length?0:i},_getCreateEventData:function(){return{tab:this.active,panel:this.active.length?this._getPanelForTab(this.active):V()}},_tabKeydown:function(t){var e=V(V.ui.safeActiveElement(this.document[0])).closest("li"),i=this.tabs.index(e),s=!0;if(!this._handlePageNav(t)){switch(t.keyCode){case V.ui.keyCode.RIGHT:case V.ui.keyCode.DOWN:i++;break;case V.ui.keyCode.UP:case V.ui.keyCode.LEFT:s=!1,i--;break;case V.ui.keyCode.END:i=this.anchors.length-1;break;case V.ui.keyCode.HOME:i=0;break;case V.ui.keyCode.SPACE:return t.preventDefault(),clearTimeout(this.activating),void this._activate(i);case V.ui.keyCode.ENTER:return t.preventDefault(),clearTimeout(this.activating),void this._activate(i!==this.options.active&&i);default:return}t.preventDefault(),clearTimeout(this.activating),i=this._focusNextTab(i,s),t.ctrlKey||t.metaKey||(e.attr("aria-selected","false"),this.tabs.eq(i).attr("aria-selected","true"),this.activating=this._delay(function(){this.option("active",i)},this.delay))}},_panelKeydown:function(t){this._handlePageNav(t)||t.ctrlKey&&t.keyCode===V.ui.keyCode.UP&&(t.preventDefault(),this.active.trigger("focus"))},_handlePageNav:function(t){return t.altKey&&t.keyCode===V.ui.keyCode.PAGE_UP?(this._activate(this._focusNextTab(this.options.active-1,!1)),!0):t.altKey&&t.keyCode===V.ui.keyCode.PAGE_DOWN?(this._activate(this._focusNextTab(this.options.active+1,!0)),!0):void 0},_findNextTab:function(t,e){var i=this.tabs.length-1;for(;-1!==V.inArray(t=(t=i<t?0:t)<0?i:t,this.options.disabled);)t=e?t+1:t-1;return t},_focusNextTab:function(t,e){return t=this._findNextTab(t,e),this.tabs.eq(t).trigger("focus"),t},_setOption:function(t,e){"active"!==t?(this._super(t,e),"collapsible"===t&&(this._toggleClass("ui-tabs-collapsible",null,e),e||!1!==this.options.active||this._activate(0)),"event"===t&&this._setupEvents(e),"heightStyle"===t&&this._setupHeightStyle(e)):this._activate(e)},_sanitizeSelector:function(t){return t?t.replace(/[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g,"\\$&"):""},refresh:function(){var t=this.options,e=this.tablist.children(":has(a[href])");t.disabled=V.map(e.filter(".ui-state-disabled"),function(t){return e.index(t)}),this._processTabs(),!1!==t.active&&this.anchors.length?this.active.length&&!V.contains(this.tablist[0],this.active[0])?this.tabs.length===t.disabled.length?(t.active=!1,this.active=V()):this._activate(this._findNextTab(Math.max(0,t.active-1),!1)):t.active=this.tabs.index(this.active):(t.active=!1,this.active=V()),this._refresh()},_refresh:function(){this._setOptionDisabled(this.options.disabled),this._setupEvents(this.options.event),this._setupHeightStyle(this.options.heightStyle),this.tabs.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}),this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-hidden":"true"}),this.active.length?(this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}),this._addClass(this.active,"ui-tabs-active","ui-state-active"),this._getPanelForTab(this.active).show().attr({"aria-hidden":"false"})):this.tabs.eq(0).attr("tabIndex",0)},_processTabs:function(){var l=this,t=this.tabs,e=this.anchors,i=this.panels;this.tablist=this._getList().attr("role","tablist"),this._addClass(this.tablist,"ui-tabs-nav","ui-helper-reset ui-helper-clearfix ui-widget-header"),this.tablist.on("mousedown"+this.eventNamespace,"> li",function(t){V(this).is(".ui-state-disabled")&&t.preventDefault()}).on("focus"+this.eventNamespace,".ui-tabs-anchor",function(){V(this).closest("li").is(".ui-state-disabled")&&this.blur()}),this.tabs=this.tablist.find("> li:has(a[href])").attr({role:"tab",tabIndex:-1}),this._addClass(this.tabs,"ui-tabs-tab","ui-state-default"),this.anchors=this.tabs.map(function(){return V("a",this)[0]}).attr({tabIndex:-1}),this._addClass(this.anchors,"ui-tabs-anchor"),this.panels=V(),this.anchors.each(function(t,e){var i,s,n,o=V(e).uniqueId().attr("id"),a=V(e).closest("li"),r=a.attr("aria-controls");l._isLocal(e)?(n=(i=e.hash).substring(1),s=l.element.find(l._sanitizeSelector(i))):(n=a.attr("aria-controls")||V({}).uniqueId()[0].id,(s=l.element.find(i="#"+n)).length||(s=l._createPanel(n)).insertAfter(l.panels[t-1]||l.tablist),s.attr("aria-live","polite")),s.length&&(l.panels=l.panels.add(s)),r&&a.data("ui-tabs-aria-controls",r),a.attr({"aria-controls":n,"aria-labelledby":o}),s.attr("aria-labelledby",o)}),this.panels.attr("role","tabpanel"),this._addClass(this.panels,"ui-tabs-panel","ui-widget-content"),t&&(this._off(t.not(this.tabs)),this._off(e.not(this.anchors)),this._off(i.not(this.panels)))},_getList:function(){return this.tablist||this.element.find("ol, ul").eq(0)},_createPanel:function(t){return V("<div>").attr("id",t).data("ui-tabs-destroy",!0)},_setOptionDisabled:function(t){var e,i;for(Array.isArray(t)&&(t.length?t.length===this.anchors.length&&(t=!0):t=!1),i=0;e=this.tabs[i];i++)e=V(e),!0===t||-1!==V.inArray(i,t)?(e.attr("aria-disabled","true"),this._addClass(e,null,"ui-state-disabled")):(e.removeAttr("aria-disabled"),this._removeClass(e,null,"ui-state-disabled"));this.options.disabled=t,this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!0===t)},_setupEvents:function(t){var i={};t&&V.each(t.split(" "),function(t,e){i[e]="_eventHandler"}),this._off(this.anchors.add(this.tabs).add(this.panels)),this._on(!0,this.anchors,{click:function(t){t.preventDefault()}}),this._on(this.anchors,i),this._on(this.tabs,{keydown:"_tabKeydown"}),this._on(this.panels,{keydown:"_panelKeydown"}),this._focusable(this.tabs),this._hoverable(this.tabs)},_setupHeightStyle:function(t){var i,e=this.element.parent();"fill"===t?(i=e.height(),i-=this.element.outerHeight()-this.element.height(),this.element.siblings(":visible").each(function(){var t=V(this),e=t.css("position");"absolute"!==e&&"fixed"!==e&&(i-=t.outerHeight(!0))}),this.element.children().not(this.panels).each(function(){i-=V(this).outerHeight(!0)}),this.panels.each(function(){V(this).height(Math.max(0,i-V(this).innerHeight()+V(this).height()))}).css("overflow","auto")):"auto"===t&&(i=0,this.panels.each(function(){i=Math.max(i,V(this).height("").height())}).height(i))},_eventHandler:function(t){var e=this.options,i=this.active,s=V(t.currentTarget).closest("li"),n=s[0]===i[0],o=n&&e.collapsible,a=o?V():this._getPanelForTab(s),r=i.length?this._getPanelForTab(i):V(),i={oldTab:i,oldPanel:r,newTab:o?V():s,newPanel:a};t.preventDefault(),s.hasClass("ui-state-disabled")||s.hasClass("ui-tabs-loading")||this.running||n&&!e.collapsible||!1===this._trigger("beforeActivate",t,i)||(e.active=!o&&this.tabs.index(s),this.active=n?V():s,this.xhr&&this.xhr.abort(),r.length||a.length||V.error("jQuery UI Tabs: Mismatching fragment identifier."),a.length&&this.load(this.tabs.index(s),t),this._toggle(t,i))},_toggle:function(t,e){var i=this,s=e.newPanel,n=e.oldPanel;function o(){i.running=!1,i._trigger("activate",t,e)}function a(){i._addClass(e.newTab.closest("li"),"ui-tabs-active","ui-state-active"),s.length&&i.options.show?i._show(s,i.options.show,o):(s.show(),o())}this.running=!0,n.length&&this.options.hide?this._hide(n,this.options.hide,function(){i._removeClass(e.oldTab.closest("li"),"ui-tabs-active","ui-state-active"),a()}):(this._removeClass(e.oldTab.closest("li"),"ui-tabs-active","ui-state-active"),n.hide(),a()),n.attr("aria-hidden","true"),e.oldTab.attr({"aria-selected":"false","aria-expanded":"false"}),s.length&&n.length?e.oldTab.attr("tabIndex",-1):s.length&&this.tabs.filter(function(){return 0===V(this).attr("tabIndex")}).attr("tabIndex",-1),s.attr("aria-hidden","false"),e.newTab.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0})},_activate:function(t){var t=this._findActive(t);t[0]!==this.active[0]&&(t=(t=!t.length?this.active:t).find(".ui-tabs-anchor")[0],this._eventHandler({target:t,currentTarget:t,preventDefault:V.noop}))},_findActive:function(t){return!1===t?V():this.tabs.eq(t)},_getIndex:function(t){return t="string"==typeof t?this.anchors.index(this.anchors.filter("[href$='"+V.escapeSelector(t)+"']")):t},_destroy:function(){this.xhr&&this.xhr.abort(),this.tablist.removeAttr("role").off(this.eventNamespace),this.anchors.removeAttr("role tabIndex").removeUniqueId(),this.tabs.add(this.panels).each(function(){V.data(this,"ui-tabs-destroy")?V(this).remove():V(this).removeAttr("role tabIndex aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded")}),this.tabs.each(function(){var t=V(this),e=t.data("ui-tabs-aria-controls");e?t.attr("aria-controls",e).removeData("ui-tabs-aria-controls"):t.removeAttr("aria-controls")}),this.panels.show(),"content"!==this.options.heightStyle&&this.panels.css("height","")},enable:function(i){var t=this.options.disabled;!1!==t&&(t=void 0!==i&&(i=this._getIndex(i),Array.isArray(t)?V.map(t,function(t){return t!==i?t:null}):V.map(this.tabs,function(t,e){return e!==i?e:null})),this._setOptionDisabled(t))},disable:function(t){var e=this.options.disabled;if(!0!==e){if(void 0===t)e=!0;else{if(t=this._getIndex(t),-1!==V.inArray(t,e))return;e=Array.isArray(e)?V.merge([t],e).sort():[t]}this._setOptionDisabled(e)}},load:function(t,s){t=this._getIndex(t);function n(t,e){"abort"===e&&o.panels.stop(!1,!0),o._removeClass(i,"ui-tabs-loading"),a.removeAttr("aria-busy"),t===o.xhr&&delete o.xhr}var o=this,i=this.tabs.eq(t),t=i.find(".ui-tabs-anchor"),a=this._getPanelForTab(i),r={tab:i,panel:a};this._isLocal(t[0])||(this.xhr=V.ajax(this._ajaxSettings(t,s,r)),this.xhr&&"canceled"!==this.xhr.statusText&&(this._addClass(i,"ui-tabs-loading"),a.attr("aria-busy","true"),this.xhr.done(function(t,e,i){setTimeout(function(){a.html(t),o._trigger("load",s,r),n(i,e)},1)}).fail(function(t,e){setTimeout(function(){n(t,e)},1)})))},_ajaxSettings:function(t,i,s){var n=this;return{url:t.attr("href").replace(/#.*$/,""),beforeSend:function(t,e){return n._trigger("beforeLoad",i,V.extend({jqXHR:t,ajaxSettings:e},s))}}},_getPanelForTab:function(t){t=V(t).attr("aria-controls");return this.element.find(this._sanitizeSelector("#"+t))}}),!1!==V.uiBackCompat&&V.widget("ui.tabs",V.ui.tabs,{_processTabs:function(){this._superApply(arguments),this._addClass(this.tabs,"ui-tab")}});V.ui.tabs;V.widget("ui.tooltip",{version:"1.13.0",options:{classes:{"ui-tooltip":"ui-corner-all ui-widget-shadow"},content:function(){var t=V(this).attr("title");return V("<a>").text(t).html()},hide:!0,items:"[title]:not([disabled])",position:{my:"left top+15",at:"left bottom",collision:"flipfit flip"},show:!0,track:!1,close:null,open:null},_addDescribedBy:function(t,e){var i=(t.attr("aria-describedby")||"").split(/\s+/);i.push(e),t.data("ui-tooltip-id",e).attr("aria-describedby",String.prototype.trim.call(i.join(" ")))},_removeDescribedBy:function(t){var e=t.data("ui-tooltip-id"),i=(t.attr("aria-describedby")||"").split(/\s+/),e=V.inArray(e,i);-1!==e&&i.splice(e,1),t.removeData("ui-tooltip-id"),(i=String.prototype.trim.call(i.join(" ")))?t.attr("aria-describedby",i):t.removeAttr("aria-describedby")},_create:function(){this._on({mouseover:"open",focusin:"open"}),this.tooltips={},this.parents={},this.liveRegion=V("<div>").attr({role:"log","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body),this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible"),this.disabledTitles=V([])},_setOption:function(t,e){var i=this;this._super(t,e),"content"===t&&V.each(this.tooltips,function(t,e){i._updateContent(e.element)})},_setOptionDisabled:function(t){this[t?"_disable":"_enable"]()},_disable:function(){var s=this;V.each(this.tooltips,function(t,e){var i=V.Event("blur");i.target=i.currentTarget=e.element[0],s.close(i,!0)}),this.disabledTitles=this.disabledTitles.add(this.element.find(this.options.items).addBack().filter(function(){var t=V(this);if(t.is("[title]"))return t.data("ui-tooltip-title",t.attr("title")).removeAttr("title")}))},_enable:function(){this.disabledTitles.each(function(){var t=V(this);t.data("ui-tooltip-title")&&t.attr("title",t.data("ui-tooltip-title"))}),this.disabledTitles=V([])},open:function(t){var i=this,e=V(t?t.target:this.element).closest(this.options.items);e.length&&!e.data("ui-tooltip-id")&&(e.attr("title")&&e.data("ui-tooltip-title",e.attr("title")),e.data("ui-tooltip-open",!0),t&&"mouseover"===t.type&&e.parents().each(function(){var t,e=V(this);e.data("ui-tooltip-open")&&((t=V.Event("blur")).target=t.currentTarget=this,i.close(t,!0)),e.attr("title")&&(e.uniqueId(),i.parents[this.id]={element:this,title:e.attr("title")},e.attr("title",""))}),this._registerCloseHandlers(t,e),this._updateContent(e,t))},_updateContent:function(e,i){var t=this.options.content,s=this,n=i?i.type:null;if("string"==typeof t||t.nodeType||t.jquery)return this._open(i,e,t);(t=t.call(e[0],function(t){s._delay(function(){e.data("ui-tooltip-open")&&(i&&(i.type=n),this._open(i,e,t))})}))&&this._open(i,e,t)},_open:function(t,e,i){var s,n,o,a=V.extend({},this.options.position);function r(t){a.of=t,n.is(":hidden")||n.position(a)}i&&((s=this._find(e))?s.tooltip.find(".ui-tooltip-content").html(i):(e.is("[title]")&&(t&&"mouseover"===t.type?e.attr("title",""):e.removeAttr("title")),s=this._tooltip(e),n=s.tooltip,this._addDescribedBy(e,n.attr("id")),n.find(".ui-tooltip-content").html(i),this.liveRegion.children().hide(),(i=V("<div>").html(n.find(".ui-tooltip-content").html())).removeAttr("name").find("[name]").removeAttr("name"),i.removeAttr("id").find("[id]").removeAttr("id"),i.appendTo(this.liveRegion),this.options.track&&t&&/^mouse/.test(t.type)?(this._on(this.document,{mousemove:r}),r(t)):n.position(V.extend({of:e},this.options.position)),n.hide(),this._show(n,this.options.show),this.options.track&&this.options.show&&this.options.show.delay&&(o=this.delayedShow=setInterval(function(){n.is(":visible")&&(r(a.of),clearInterval(o))},13)),this._trigger("open",t,{tooltip:n})))},_registerCloseHandlers:function(t,e){var i={keyup:function(t){t.keyCode===V.ui.keyCode.ESCAPE&&((t=V.Event(t)).currentTarget=e[0],this.close(t,!0))}};e[0]!==this.element[0]&&(i.remove=function(){this._removeTooltip(this._find(e).tooltip)}),t&&"mouseover"!==t.type||(i.mouseleave="close"),t&&"focusin"!==t.type||(i.focusout="close"),this._on(!0,e,i)},close:function(t){var e,i=this,s=V(t?t.currentTarget:this.element),n=this._find(s);n?(e=n.tooltip,n.closing||(clearInterval(this.delayedShow),s.data("ui-tooltip-title")&&!s.attr("title")&&s.attr("title",s.data("ui-tooltip-title")),this._removeDescribedBy(s),n.hiding=!0,e.stop(!0),this._hide(e,this.options.hide,function(){i._removeTooltip(V(this))}),s.removeData("ui-tooltip-open"),this._off(s,"mouseleave focusout keyup"),s[0]!==this.element[0]&&this._off(s,"remove"),this._off(this.document,"mousemove"),t&&"mouseleave"===t.type&&V.each(this.parents,function(t,e){V(e.element).attr("title",e.title),delete i.parents[t]}),n.closing=!0,this._trigger("close",t,{tooltip:e}),n.hiding||(n.closing=!1))):s.removeData("ui-tooltip-open")},_tooltip:function(t){var e=V("<div>").attr("role","tooltip"),i=V("<div>").appendTo(e),s=e.uniqueId().attr("id");return this._addClass(i,"ui-tooltip-content"),this._addClass(e,"ui-tooltip","ui-widget ui-widget-content"),e.appendTo(this._appendTo(t)),this.tooltips[s]={element:t,tooltip:e}},_find:function(t){t=t.data("ui-tooltip-id");return t?this.tooltips[t]:null},_removeTooltip:function(t){clearInterval(this.delayedShow),t.remove(),delete this.tooltips[t.attr("id")]},_appendTo:function(t){t=t.closest(".ui-front, dialog");return t=!t.length?this.document[0].body:t},_destroy:function(){var s=this;V.each(this.tooltips,function(t,e){var i=V.Event("blur"),e=e.element;i.target=i.currentTarget=e[0],s.close(i,!0),V("#"+t).remove(),e.data("ui-tooltip-title")&&(e.attr("title")||e.attr("title",e.data("ui-tooltip-title")),e.removeData("ui-tooltip-title"))}),this.liveRegion.remove()}}),!1!==V.uiBackCompat&&V.widget("ui.tooltip",V.ui.tooltip,{options:{tooltipClass:null},_tooltip:function(){var t=this._superApply(arguments);return this.options.tooltipClass&&t.tooltip.addClass(this.options.tooltipClass),t}});V.ui.tooltip});
/*
 jquery.layout 1.3.0 - Release Candidate 30.79
 $Date: 2013-01-01 08:00:00 (Tue, 1 Jan 2013) $
 $Rev: 303007 $

 Copyright (c) 2013 Kevin Dalman (http://allpro.net)
 Based on work by Fabrizio Balliano (http://www.fabrizioballiano.net)

 Dual licensed under the GPL (http://www.gnu.org/licenses/gpl.html)
 and MIT (http://www.opensource.org/licenses/mit-license.php) licenses.

 SEE: http://layout.jquery-dev.net/LICENSE.txt

 Changelog: http://layout.jquery-dev.net/changelog.cfm#1.3.0.rc30.79

 Docs: http://layout.jquery-dev.net/documentation.html
 Tips: http://layout.jquery-dev.net/tips.html
 Help: http://groups.google.com/group/jquery-ui-layout
*/
(function(b){var a=Math.min,d=Math.max,c=Math.floor,f=function(a){return"string"===b.type(a)},j=function(a,d){if(b.isArray(d))for(var c=0,j=d.length;c<j;c++){var h=d[c];try{f(h)&&(h=eval(h)),b.isFunction(h)&&h(a)}catch(k){}}};b.layout={version:"1.3.rc30.79",revision:0.033007,browser:{},effects:{slide:{all:{duration:"fast"},north:{direction:"up"},south:{direction:"down"},east:{direction:"right"},west:{direction:"left"}},drop:{all:{duration:"slow"},north:{direction:"up"},south:{direction:"down"},east:{direction:"right"},
west:{direction:"left"}},scale:{all:{duration:"fast"}},blind:{},clip:{},explode:{},fade:{},fold:{},puff:{},size:{all:{easing:"swing"}}},config:{optionRootKeys:"effects panes north south west east center".split(" "),allPanes:["north","south","west","east","center"],borderPanes:["north","south","west","east"],oppositeEdge:{north:"south",south:"north",east:"west",west:"east"},offscreenCSS:{left:"-99999px",right:"auto"},offscreenReset:"offscreenReset",hidden:{visibility:"hidden"},visible:{visibility:"visible"},
resizers:{cssReq:{position:"absolute",padding:0,margin:0,fontSize:"1px",textAlign:"left",overflow:"hidden"},cssDemo:{background:"#DDD",border:"none"}},togglers:{cssReq:{position:"absolute",display:"block",padding:0,margin:0,overflow:"hidden",textAlign:"center",fontSize:"1px",cursor:"pointer",zIndex:1},cssDemo:{background:"#AAA"}},content:{cssReq:{position:"relative"},cssDemo:{overflow:"auto",padding:"10px"},cssDemoPane:{overflow:"hidden",padding:0}},panes:{cssReq:{position:"absolute",margin:0},cssDemo:{padding:"10px",
background:"#FFF",border:"1px solid #BBB",overflow:"auto"}},north:{side:"top",sizeType:"Height",dir:"horz",cssReq:{top:0,bottom:"auto",left:0,right:0,width:"auto"}},south:{side:"bottom",sizeType:"Height",dir:"horz",cssReq:{top:"auto",bottom:0,left:0,right:0,width:"auto"}},east:{side:"right",sizeType:"Width",dir:"vert",cssReq:{left:"auto",right:0,top:"auto",bottom:"auto",height:"auto"}},west:{side:"left",sizeType:"Width",dir:"vert",cssReq:{left:0,right:"auto",top:"auto",bottom:"auto",height:"auto"}},
center:{dir:"center",cssReq:{left:"auto",right:"auto",top:"auto",bottom:"auto",height:"auto",width:"auto"}}},callbacks:{},getParentPaneElem:function(a){a=b(a);if(a=a.data("layout")||a.data("parentLayout")){a=a.container;if(a.data("layoutPane"))return a;a=a.closest("."+b.layout.defaults.panes.paneClass);if(a.data("layoutPane"))return a}return null},getParentPaneInstance:function(a){return(a=b.layout.getParentPaneElem(a))?a.data("layoutPane"):null},getParentLayoutInstance:function(a){return(a=b.layout.getParentPaneElem(a))?
a.data("parentLayout"):null},getEventObject:function(b){return"object"===typeof b&&b.stopPropagation?b:null},parsePaneName:function(a){var d=b.layout.getEventObject(a);d&&(d.stopPropagation(),a=b(this).data("layoutEdge"));a&&!/^(west|east|north|south|center)$/.test(a)&&(b.layout.msg('LAYOUT ERROR - Invalid pane-name: "'+a+'"'),a="error");return a},plugins:{draggable:!!b.fn.draggable,effects:{core:!!b.effects,slide:b.effects&&(b.effects.slide||b.effects.effect&&b.effects.effect.slide)}},onCreate:[],
onLoad:[],onReady:[],onDestroy:[],onUnload:[],afterOpen:[],afterClose:[],scrollbarWidth:function(){return window.scrollbarWidth||b.layout.getScrollbarSize("width")},scrollbarHeight:function(){return window.scrollbarHeight||b.layout.getScrollbarSize("height")},getScrollbarSize:function(a){var d=b('<div style="position: absolute; top: -10000px; left: -10000px; width: 100px; height: 100px; overflow: scroll;"></div>').appendTo("body"),c={width:d.css("width")-d[0].clientWidth,height:d.height()-d[0].clientHeight};
d.remove();window.scrollbarWidth=c.width;window.scrollbarHeight=c.height;return a.match(/^(width|height)$/)?c[a]:c},showInvisibly:function(b,a){if(b&&b.length&&(a||"none"===b.css("display"))){var d=b[0].style,d={display:d.display||"",visibility:d.visibility||""};b.css({display:"block",visibility:"hidden"});return d}return{}},getElementDimensions:function(a,c){var f={css:{},inset:{}},j=f.css,h={bottom:0},k=b.layout.cssNum,p=a.offset(),O,R,D;f.offsetLeft=p.left;f.offsetTop=p.top;c||(c={});b.each(["Left",
"Right","Top","Bottom"],function(d,k){O=j["border"+k]=b.layout.borderWidth(a,k);R=j["padding"+k]=b.layout.cssNum(a,"padding"+k);D=k.toLowerCase();f.inset[D]=0<=c[D]?c[D]:R;h[D]=f.inset[D]+O});j.width=a.width();j.height=a.height();j.top=k(a,"top",!0);j.bottom=k(a,"bottom",!0);j.left=k(a,"left",!0);j.right=k(a,"right",!0);f.outerWidth=a.outerWidth();f.outerHeight=a.outerHeight();f.innerWidth=d(0,f.outerWidth-h.left-h.right);f.innerHeight=d(0,f.outerHeight-h.top-h.bottom);f.layoutWidth=a.innerWidth();
f.layoutHeight=a.innerHeight();return f},getElementStyles:function(b,a){var d={},c=b[0].style,f=a.split(","),k=["Top","Bottom","Left","Right"],j=["Color","Style","Width"],h,p,D,x,A,r;for(x=0;x<f.length;x++)if(h=f[x],h.match(/(border|padding|margin)$/))for(A=0;4>A;A++)if(p=k[A],"border"===h)for(r=0;3>r;r++)D=j[r],d[h+p+D]=c[h+p+D];else d[h+p]=c[h+p];else d[h]=c[h];return d},cssWidth:function(a,c){if(0>=c)return 0;var f=!b.layout.browser.boxModel?"border-box":b.support.boxSizing?a.css("boxSizing"):
"content-box",j=b.layout.borderWidth,h=b.layout.cssNum,k=c;"border-box"!==f&&(k-=j(a,"Left")+j(a,"Right"));"content-box"===f&&(k-=h(a,"paddingLeft")+h(a,"paddingRight"));return d(0,k)},cssHeight:function(a,c){if(0>=c)return 0;var f=!b.layout.browser.boxModel?"border-box":b.support.boxSizing?a.css("boxSizing"):"content-box",j=b.layout.borderWidth,h=b.layout.cssNum,k=c;"border-box"!==f&&(k-=j(a,"Top")+j(a,"Bottom"));"content-box"===f&&(k-=h(a,"paddingTop")+h(a,"paddingBottom"));return d(0,k)},cssNum:function(a,
d,c){a.jquery||(a=b(a));var f=b.layout.showInvisibly(a);d=b.css(a[0],d,!0);c=c&&"auto"==d?d:Math.round(parseFloat(d)||0);a.css(f);return c},borderWidth:function(a,d){a.jquery&&(a=a[0]);var c="border"+d.substr(0,1).toUpperCase()+d.substr(1);return"none"===b.css(a,c+"Style",!0)?0:Math.round(parseFloat(b.css(a,c+"Width",!0))||0)},isMouseOverElem:function(a,d){var c=b(d||this),f=c.offset(),j=f.top,f=f.left,k=f+c.outerWidth(),c=j+c.outerHeight(),h=a.pageX,p=a.pageY;return b.layout.browser.msie&&0>h&&0>
p||h>=f&&h<=k&&p>=j&&p<=c},msg:function(a,d,c,f){b.isPlainObject(a)&&window.debugData?("string"===typeof d?(f=c,c=d):"object"===typeof c&&(f=c,c=null),c=c||"log( <object> )",f=b.extend({sort:!1,returnHTML:!1,display:!1},f),!0===d||f.display?debugData(a,c,f):window.console&&console.log(debugData(a,c,f))):d?alert(a):window.console?console.log(a):(d=b("#layoutLogger"),d.length||(d=b('<div id="layoutLogger" style="position: '+(b.support.fixedPosition?"fixed":"absolute")+'; top: 5px; z-index: 999999; max-width: 25%; overflow: hidden; border: 1px solid #000; border-radius: 5px; background: #FBFBFB; box-shadow: 0 2px 10px rgba(0,0,0,0.3);"><div style="font-size: 13px; font-weight: bold; padding: 5px 10px; background: #F6F6F6; border-radius: 5px 5px 0 0; cursor: move;"><span style="float: right; padding-left: 7px; cursor: pointer;" title="Remove Console" onclick="$(this).closest(\'#layoutLogger\').remove()">X</span>Layout console.log</div><ul style="font-size: 13px; font-weight: none; list-style: none; margin: 0; padding: 0 0 2px;"></ul></div>').appendTo("body"),
d.css("left",b(window).width()-d.outerWidth()-5),b.ui.draggable&&d.draggable({handle:":first-child"})),d.children("ul").append('<li style="padding: 4px 10px; margin: 0; border-top: 1px solid #CCC;">'+a.replace(/\</g,"&lt;").replace(/\>/g,"&gt;")+"</li>"))}};var h=navigator.userAgent.toLowerCase(),p=/(chrome)[ \/]([\w.]+)/.exec(h)||/(webkit)[ \/]([\w.]+)/.exec(h)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(h)||/(msie) ([\w.]+)/.exec(h)||0>h.indexOf("compatible")&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(h)||
[],h=p[1]||"",p=p[2]||0,x="msie"===h;b.layout.browser={version:p,safari:"webkit"===h,webkit:"chrome"===h,msie:x,isIE6:x&&6==p,boxModel:!x||!1!==b.support.boxModel};h&&(b.layout.browser[h]=!0);x&&b(function(){b.layout.browser.boxModel=b.support.boxModel});b.layout.defaults={name:"",containerClass:"ui-layout-container",inset:null,scrollToBookmarkOnLoad:!0,resizeWithWindow:!0,resizeWithWindowDelay:200,resizeWithWindowMaxDelay:0,maskPanesEarly:!1,onresizeall_start:null,onresizeall_end:null,onload_start:null,
onload_end:null,onunload_start:null,onunload_end:null,initPanes:!0,showErrorMessages:!0,showDebugMessages:!1,zIndex:null,zIndexes:{pane_normal:0,content_mask:1,resizer_normal:2,pane_sliding:100,pane_animate:1E3,resizer_drag:1E4},errors:{pane:"pane",selector:"selector",addButtonError:"Error Adding Button\nInvalid ",containerMissing:"UI Layout Initialization Error\nThe specified layout-container does not exist.",centerPaneMissing:"UI Layout Initialization Error\nThe center-pane element does not exist.\nThe center-pane is a required element.",
noContainerHeight:"UI Layout Initialization Warning\nThe layout-container \"CONTAINER\" has no height.\nTherefore the layout is 0-height and hence 'invisible'!",callbackError:"UI Layout Callback Error\nThe EVENT callback is not a valid function."},panes:{applyDemoStyles:!1,closable:!0,resizable:!0,slidable:!0,initClosed:!1,initHidden:!1,contentSelector:".ui-layout-content",contentIgnoreSelector:".ui-layout-ignore",findNestedContent:!1,paneClass:"ui-layout-pane",resizerClass:"ui-layout-resizer",togglerClass:"ui-layout-toggler",
buttonClass:"ui-layout-button",minSize:0,maxSize:0,spacing_open:6,spacing_closed:6,togglerLength_open:50,togglerLength_closed:50,togglerAlign_open:"center",togglerAlign_closed:"center",togglerContent_open:"",togglerContent_closed:"",resizerDblClickToggle:!0,autoResize:!0,autoReopen:!0,resizerDragOpacity:1,maskContents:!1,maskObjects:!1,maskZindex:null,resizingGrid:!1,livePaneResizing:!1,liveContentResizing:!1,liveResizingTolerance:1,sliderCursor:"pointer",slideTrigger_open:"click",slideTrigger_close:"mouseleave",
slideDelay_open:300,slideDelay_close:300,hideTogglerOnSlide:!1,preventQuickSlideClose:b.layout.browser.webkit,preventPrematureSlideClose:!1,tips:{Open:"Open",Close:"Close",Resize:"Resize",Slide:"Slide Open",Pin:"Pin",Unpin:"Un-Pin",noRoomToOpen:"Not enough room to show this panel.",minSizeWarning:"Panel has reached its minimum size",maxSizeWarning:"Panel has reached its maximum size"},showOverflowOnHover:!1,enableCursorHotkey:!0,customHotkeyModifier:"SHIFT",fxName:"slide",fxSpeed:null,fxSettings:{},
fxOpacityFix:!0,animatePaneSizing:!1,children:null,containerSelector:"",initChildren:!0,destroyChildren:!0,resizeChildren:!0,triggerEventsOnLoad:!1,triggerEventsDuringLiveResize:!0,onshow_start:null,onshow_end:null,onhide_start:null,onhide_end:null,onopen_start:null,onopen_end:null,onclose_start:null,onclose_end:null,onresize_start:null,onresize_end:null,onsizecontent_start:null,onsizecontent_end:null,onswap_start:null,onswap_end:null,ondrag_start:null,ondrag_end:null},north:{paneSelector:".ui-layout-north",
size:"auto",resizerCursor:"n-resize",customHotkey:""},south:{paneSelector:".ui-layout-south",size:"auto",resizerCursor:"s-resize",customHotkey:""},east:{paneSelector:".ui-layout-east",size:200,resizerCursor:"e-resize",customHotkey:""},west:{paneSelector:".ui-layout-west",size:200,resizerCursor:"w-resize",customHotkey:""},center:{paneSelector:".ui-layout-center",minWidth:0,minHeight:0}};b.layout.optionsMap={layout:"name instanceKey stateManagement effects inset zIndexes errors zIndex scrollToBookmarkOnLoad showErrorMessages maskPanesEarly outset resizeWithWindow resizeWithWindowDelay resizeWithWindowMaxDelay onresizeall onresizeall_start onresizeall_end onload onload_start onload_end onunload onunload_start onunload_end".split(" "),
center:"paneClass contentSelector contentIgnoreSelector findNestedContent applyDemoStyles triggerEventsOnLoad showOverflowOnHover maskContents maskObjects liveContentResizing containerSelector children initChildren resizeChildren destroyChildren onresize onresize_start onresize_end onsizecontent onsizecontent_start onsizecontent_end".split(" "),noDefault:["paneSelector","resizerCursor","customHotkey"]};b.layout.transformData=function(a,d){var c=d?{panes:{},center:{}}:{},f,j,k,h,p,x,D;if("object"!==
typeof a)return c;for(j in a){f=c;p=a[j];k=j.split("__");D=k.length-1;for(x=0;x<=D;x++)h=k[x],x===D?f[h]=b.isPlainObject(p)?b.layout.transformData(p):p:(f[h]||(f[h]={}),f=f[h])}return c};b.layout.backwardCompatibility={map:{applyDefaultStyles:"applyDemoStyles",childOptions:"children",initChildLayout:"initChildren",destroyChildLayout:"destroyChildren",resizeChildLayout:"resizeChildren",resizeNestedLayout:"resizeChildren",resizeWhileDragging:"livePaneResizing",resizeContentWhileDragging:"liveContentResizing",
triggerEventsWhileDragging:"triggerEventsDuringLiveResize",maskIframesOnResize:"maskContents",useStateCookie:"stateManagement.enabled","cookie.autoLoad":"stateManagement.autoLoad","cookie.autoSave":"stateManagement.autoSave","cookie.keys":"stateManagement.stateKeys","cookie.name":"stateManagement.cookie.name","cookie.domain":"stateManagement.cookie.domain","cookie.path":"stateManagement.cookie.path","cookie.expires":"stateManagement.cookie.expires","cookie.secure":"stateManagement.cookie.secure",
noRoomToOpenTip:"tips.noRoomToOpen",togglerTip_open:"tips.Close",togglerTip_closed:"tips.Open",resizerTip:"tips.Resize",sliderTip:"tips.Slide"},renameOptions:function(a){function d(b,c){for(var f=b.split("."),k=f.length-1,j={branch:a,key:f[k]},r=0,q;r<k;r++)q=f[r],j.branch=void 0==j.branch[q]?c?j.branch[q]={}:{}:j.branch[q];return j}var c=b.layout.backwardCompatibility.map,f,j,k,h;for(h in c)f=d(h),k=f.branch[f.key],void 0!==k&&(j=d(c[h],!0),j.branch[j.key]=k,delete f.branch[f.key])},renameAllOptions:function(a){var d=
b.layout.backwardCompatibility.renameOptions;d(a);a.defaults&&("object"!==typeof a.panes&&(a.panes={}),b.extend(!0,a.panes,a.defaults),delete a.defaults);a.panes&&d(a.panes);b.each(b.layout.config.allPanes,function(b,c){a[c]&&d(a[c])});return a}};b.fn.layout=function(h){function p(e){if(!e)return!0;var w=e.keyCode;if(33>w)return!0;var m={38:"north",40:"south",37:"west",39:"east"},a=e.shiftKey,g=e.ctrlKey,t,n,d,c;g&&(37<=w&&40>=w)&&r[m[w]].enableCursorHotkey?c=m[w]:(g||a)&&b.each(k.borderPanes,function(e,
b){t=r[b];n=t.customHotkey;d=t.customHotkeyModifier;if(a&&"SHIFT"==d||g&&"CTRL"==d||g&&a)if(n&&w===(isNaN(n)||9>=n?n.toUpperCase().charCodeAt(0):n))return c=b,!1});if(!c||!y[c]||!r[c].closable||q[c].isHidden)return!0;na(c);e.stopPropagation();return e.returnValue=!1}function x(e){if(H()){this&&this.tagName&&(e=this);var w;f(e)?w=y[e]:b(e).data("layoutRole")?w=b(e):b(e).parents().each(function(){if(b(this).data("layoutRole"))return w=b(this),!1});if(w&&w.length){var m=w.data("layoutEdge");e=q[m];e.cssSaved&&
X(m);if(e.isSliding||e.isResizing||e.isClosed)e.cssSaved=!1;else{var a={zIndex:r.zIndexes.resizer_normal+1},g={},t=w.css("overflow"),n=w.css("overflowX"),d=w.css("overflowY");"visible"!=t&&(g.overflow=t,a.overflow="visible");n&&!n.match(/(visible|auto)/)&&(g.overflowX=n,a.overflowX="visible");d&&!d.match(/(visible|auto)/)&&(g.overflowY=n,a.overflowY="visible");e.cssSaved=g;w.css(a);b.each(k.allPanes,function(e,b){b!=m&&X(b)})}}}}function X(e){if(H()){this&&this.tagName&&(e=this);var w;f(e)?w=y[e]:
b(e).data("layoutRole")?w=b(e):b(e).parents().each(function(){if(b(this).data("layoutRole"))return w=b(this),!1});if(w&&w.length){e=w.data("layoutEdge");e=q[e];var m=e.cssSaved||{};!e.isSliding&&!e.isResizing&&w.css("zIndex",r.zIndexes.pane_normal);w.css(m);e.cssSaved=!1}}}var G=b.layout.browser,k=b.layout.config,Q=b.layout.cssWidth,O=b.layout.cssHeight,R=b.layout.getElementDimensions,D=b.layout.getElementStyles,Ma=b.layout.getEventObject,A=b.layout.parsePaneName,r=b.extend(!0,{},b.layout.defaults);
r.effects=b.extend(!0,{},b.layout.effects);var q={id:"layout"+b.now(),initialized:!1,paneResizing:!1,panesSliding:{},container:{innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0,layoutWidth:0,layoutHeight:0},north:{childIdx:0},south:{childIdx:0},east:{childIdx:0},west:{childIdx:0},center:{childIdx:0}},ba={north:null,south:null,east:null,west:null,center:null},M={data:{},set:function(e,b,m){M.clear(e);M.data[e]=setTimeout(b,m)},clear:function(e){var b=M.data;b[e]&&(clearTimeout(b[e]),delete b[e])}},
ca=function(e,w,m){var a=r;(a.showErrorMessages&&!m||m&&a.showDebugMessages)&&b.layout.msg(a.name+" / "+e,!1!==w);return!1},C=function(e,w,m){var a=w&&f(w),g=a?q[w]:q,t=a?r[w]:r,n=r.name,d=e+(e.match(/_/)?"":"_end"),c=d.match(/_end$/)?d.substr(0,d.length-4):"",l=t[d]||t[c],h="NC",k=[];!a&&"boolean"===b.type(w)&&(m=w,w="");if(l)try{f(l)&&(l.match(/,/)?(k=l.split(","),l=eval(k[0])):l=eval(l)),b.isFunction(l)&&(h=k.length?l(k[1]):a?l(w,y[w],g,t,n):l(z,g,t,n))}catch(j){ca(r.errors.callbackError.replace(/EVENT/,
b.trim((w||"")+" "+d)),!1),"string"===b.type(j)&&string.length&&ca("Exception:  "+j,!1)}!m&&!1!==h&&(a?(m=y[w],t=r[w],g=q[w],m.triggerHandler("layoutpane"+d,[w,m,g,t,n]),c&&m.triggerHandler("layoutpane"+c,[w,m,g,t,n])):(u.triggerHandler("layout"+d,[z,g,t,n]),c&&u.triggerHandler("layout"+c,[z,g,t,n])));a&&"onresize_end"===e&&db(w+"",!0);return h},eb=function(e){if(!G.mozilla){var b=y[e];"IFRAME"===q[e].tagName?b.css(k.hidden).css(k.visible):b.find("IFRAME").css(k.hidden).css(k.visible)}},ya=function(e){var b=
y[e];e=k[e].dir;b={minWidth:1001-Q(b,1E3),minHeight:1001-O(b,1E3)};"horz"===e&&(b.minSize=b.minHeight);"vert"===e&&(b.minSize=b.minWidth);return b},fa=function(e,w,m){m||(m=k[e].dir);f(w)&&w.match(/%/)&&(w="100%"===w?-1:parseInt(w,10)/100);if(0===w)return 0;if(1<=w)return parseInt(w,10);var a=r,g=0;"horz"==m?g=v.innerHeight-(y.north?a.north.spacing_open:0)-(y.south?a.south.spacing_open:0):"vert"==m&&(g=v.innerWidth-(y.west?a.west.spacing_open:0)-(y.east?a.east.spacing_open:0));if(-1===w)return g;
if(0<w)return c(g*w);if("center"==e)return 0;m="horz"===m?"height":"width";a=y[e];e="height"===m?U[e]:!1;var g=b.layout.showInvisibly(a),t=a.css(m),n=e?e.css(m):0;a.css(m,"auto");e&&e.css(m,"auto");w="height"===m?a.outerHeight():a.outerWidth();a.css(m,t).css(g);e&&e.css(m,n);return w},ga=function(e,b){var a=y[e],E=r[e],g=q[e],t=b?E.spacing_open:0,E=b?E.spacing_closed:0;return!a||g.isHidden?0:g.isClosed||g.isSliding&&b?E:"horz"===k[e].dir?a.outerHeight()+t:a.outerWidth()+t},Y=function(e,b){if(H()){var m=
r[e],E=q[e],g=k[e],t=g.dir;g.sizeType.toLowerCase();var g=void 0!=b?b:E.isSliding,n=m.spacing_open,c=k.oppositeEdge[e],f=q[c],l=y[c],h=!l||!1===f.isVisible||f.isSliding?0:"horz"==t?l.outerHeight():l.outerWidth(),c=(!l||f.isHidden?0:r[c][!1!==f.isClosed?"spacing_closed":"spacing_open"])||0,f="horz"==t?v.innerHeight:v.innerWidth,l=ya("center"),l="horz"==t?d(r.center.minHeight,l.minHeight):d(r.center.minWidth,l.minWidth),g=f-n-(g?0:fa("center",l,t)+h+c),t=E.minSize=d(fa(e,m.minSize),ya(e).minSize),g=
E.maxSize=a(m.maxSize?fa(e,m.maxSize):1E5,g),E=E.resizerPosition={},n=v.inset.top,h=v.inset.left,c=v.innerWidth,f=v.innerHeight,m=m.spacing_open;switch(e){case "north":E.min=n+t;E.max=n+g;break;case "west":E.min=h+t;E.max=h+g;break;case "south":E.min=n+f-g-m;E.max=n+f-t-m;break;case "east":E.min=h+c-g-m,E.max=h+c-t-m}}},Na=function(e,a){var m=b(e),E=m.data("layoutRole"),g=m.data("layoutEdge"),t=r[g][E+"Class"],g="-"+g,n=m.hasClass(t+"-closed")?"-closed":"-open",d="-closed"===n?"-open":"-closed",n=
t+"-hover "+(t+g+"-hover ")+(t+n+"-hover ")+(t+g+n+"-hover ");a&&(n+=t+d+"-hover "+(t+g+d+"-hover "));"resizer"==E&&m.hasClass(t+"-sliding")&&(n+=t+"-sliding-hover "+(t+g+"-sliding-hover "));return b.trim(n)},Oa=function(e,a){var m=b(a||this);e&&"toggler"===m.data("layoutRole")&&e.stopPropagation();m.addClass(Na(m))},da=function(e,a){var m=b(a||this);m.removeClass(Na(m,!0))},fb=function(){var e=b(this).data("layoutEdge"),a=q[e];!a.isClosed&&(!a.isResizing&&!q.paneResizing)&&(b.fn.disableSelection&&
b("body").disableSelection(),r.maskPanesEarly&&va(e,{resizing:!0}))},gb=function(e,a){var m=a||this,E=b(m).data("layoutEdge"),g=E+"ResizerLeave";M.clear(E+"_openSlider");M.clear(g);a?q.paneResizing||(b.fn.enableSelection&&b("body").enableSelection(),r.maskPanesEarly&&za()):M.set(g,function(){gb(e,m)},200)},H=function(){return q.initialized||q.creatingLayout?!0:Aa()},Aa=function(e){var a=r;if(!u.is(":visible"))return!e&&(G.webkit&&"BODY"===u[0].tagName)&&setTimeout(function(){Aa(!0)},50),!1;if(!hb("center").length)return ca(a.errors.centerPaneMissing);
q.creatingLayout=!0;b.extend(v,R(u,a.inset));A(void 0);b.each(k.allPanes,function(e,b){ib(b,!0)});Pa();b.each(k.borderPanes,function(e,b){y[b]&&q[b].isVisible&&(Y(b),ha(b))});ia("center");b.each(k.allPanes,function(e,b){jb(b)});a.scrollToBookmarkOnLoad&&(e=self.location,e.hash&&e.replace(e.hash));z.hasParentLayout?a.resizeWithWindow=!1:a.resizeWithWindow&&b(window).bind("resize."+K,Ab);delete q.creatingLayout;q.initialized=!0;j(z,b.layout.onReady);C("onload_end");return!0},Qa=function(e,a){var m=
A.call(this,e),d=y[m];if(d){var g=U[m],t=q[m],n=r[m],c=r.stateManagement||{},n=a?n.children=a:n.children;if(b.isPlainObject(n))n=[n];else if(!n||!b.isArray(n))return;b.each(n,function(e,a){b.isPlainObject(a)&&(a.containerSelector?d.find(a.containerSelector):g||d).each(function(){var e=b(this),g=e.data("layout");if(!g){kb({container:e,options:a},t);if(c.includeChildren&&q.stateData[m]){var g=(q.stateData[m].children||{})[a.instanceKey],w=a.stateManagement||(a.stateManagement={autoLoad:!0});!0===w.autoLoad&&
g&&(w.autoSave=!1,w.includeChildren=!0,w.autoLoad=b.extend(!0,{},g))}(g=e.layout(a))&&Ba(m,g)}})})}},kb=function(e,b){var a=e.container,d=e.options,g=d.stateManagement,t=d.instanceKey||a.data("layoutInstanceKey");t||(t=(g&&g.cookie?g.cookie.name:"")||d.name);t=t?t.replace(/[^\w-]/gi,"_").replace(/_{2,}/g,"_"):"layout"+ ++b.childIdx;d.instanceKey=t;a.data("layoutInstanceKey",t);return t},Ba=function(e,a){var m=y[e],d=ba[e],g=q[e];b.isPlainObject(d)&&(b.each(d,function(e,b){b.destroyed&&delete d[e]}),
b.isEmptyObject(d)&&(d=ba[e]=null));!a&&!d&&(a=m.data("layout"));a&&(a.hasParentLayout=!0,m=a.options,kb(a,g),d||(d=ba[e]={}),d[m.instanceKey]=a.container.data("layout"));z[e].children=ba[e];a||Qa(e)},Ab=function(){var e=r,b=Number(e.resizeWithWindowDelay);10>b&&(b=100);M.clear("winResize");M.set("winResize",function(){M.clear("winResize");M.clear("winResizeRepeater");var b=R(u,e.inset);(b.innerWidth!==v.innerWidth||b.innerHeight!==v.innerHeight)&&oa()},b);M.data.winResizeRepeater||lb()},lb=function(){var e=
Number(r.resizeWithWindowMaxDelay);0<e&&M.set("winResizeRepeater",function(){lb();oa()},e)},mb=function(){C("onunload_start");j(z,b.layout.onUnload);C("onunload_end")},nb=function(e){e=e?e.split(","):k.borderPanes;b.each(e,function(e,a){var d=r[a];if(d.enableCursorHotkey||d.customHotkey)return b(document).bind("keydown."+K,p),!1})},hb=function(e){e=r[e].paneSelector;if("#"===e.substr(0,1))return u.find(e).eq(0);var b=u.children(e).eq(0);return b.length?b:u.children("form:first").children(e).eq(0)},
ib=function(e,b){if(b||H()){var m=r[e],c=q[e],g=k[e],t=g.dir,n="center"===e,f={},h=y[e],l,j;h?Ra(e,!1,!0,!1):U[e]=!1;h=y[e]=hb(e);if(h.length){h.data("layoutCSS")||h.data("layoutCSS",D(h,"position,top,left,bottom,right,width,height,overflow,zIndex,display,backgroundColor,padding,margin,border"));z[e]={name:e,pane:y[e],content:U[e],options:r[e],state:q[e],children:ba[e]};h.data({parentLayout:z,layoutPane:z[e],layoutEdge:e,layoutRole:"pane"}).css(g.cssReq).css("zIndex",r.zIndexes.pane_normal).css(m.applyDemoStyles?
g.cssDemo:{}).addClass(m.paneClass+" "+m.paneClass+"-"+e).bind("mouseenter."+K,Oa).bind("mouseleave."+K,da);g={hide:"",show:"",toggle:"",close:"",open:"",slideOpen:"",slideClose:"",slideToggle:"",size:"sizePane",sizePane:"sizePane",sizeContent:"",sizeHandles:"",enableClosable:"",disableClosable:"",enableSlideable:"",disableSlideable:"",enableResizable:"",disableResizable:"",swapPanes:"swapPanes",swap:"swapPanes",move:"swapPanes",removePane:"removePane",remove:"removePane",createChildren:"",resizeChildren:"",
resizeAll:"resizeAll",resizeLayout:"resizeAll"};for(j in g)h.bind("layoutpane"+j.toLowerCase()+"."+K,z[g[j]||j]);Sa(e,!1);n||(l=c.size=fa(e,m.size),n=fa(e,m.minSize)||1,j=fa(e,m.maxSize)||1E5,0<l&&(l=d(a(l,j),n)),c.autoResize=m.autoResize,c.isClosed=!1,c.isSliding=!1,c.isResizing=!1,c.isHidden=!1,c.pins||(c.pins=[]));c.tagName=h[0].tagName;c.edge=e;c.noRoom=!1;c.isVisible=!0;ob(e);"horz"===t?f.height=O(h,l):"vert"===t&&(f.width=Q(h,l));h.css(f);"horz"!=t&&ia(e,!0);q.initialized&&(Pa(e),nb(e));m.initClosed&&
m.closable&&!m.initHidden?ja(e,!0,!0):m.initHidden||m.initClosed?Ta(e):c.noRoom||h.css("display","block");h.css("visibility","visible");m.showOverflowOnHover&&h.hover(x,X);q.initialized&&jb(e)}else y[e]=!1}},jb=function(e){var b=y[e],a=q[e],d=r[e];b&&(b.data("layout")&&Ba(e,b.data("layout")),a.isVisible&&(q.initialized?oa():pa(e),d.triggerEventsOnLoad?C("onresize_end",e):db(e,!0)),d.initChildren&&d.children&&Qa(e))},ob=function(e){e=e?e.split(","):k.borderPanes;b.each(e,function(e,b){var a=y[b],g=
F[b],d=q[b],c=k[b].side,f={};if(a){switch(b){case "north":f.top=v.inset.top;f.left=v.inset.left;f.right=v.inset.right;break;case "south":f.bottom=v.inset.bottom;f.left=v.inset.left;f.right=v.inset.right;break;case "west":f.left=v.inset.left;break;case "east":f.right=v.inset.right}a.css(f);g&&d.isClosed?g.css(c,v.inset[c]):g&&!d.isHidden&&g.css(c,v.inset[c]+ga(b))}})},Pa=function(e){e=e?e.split(","):k.borderPanes;b.each(e,function(e,a){var d=y[a];F[a]=!1;P[a]=!1;if(d){var g=r[a],d=q[a],c="#"===g.paneSelector.substr(0,
1)?g.paneSelector.substr(1):"",n=g.resizerClass,f=g.togglerClass,h="-"+a,l=z[a],j=l.resizer=F[a]=b("<div></div>"),l=l.toggler=g.closable?P[a]=b("<div></div>"):!1;!d.isVisible&&g.slidable&&j.attr("title",g.tips.Slide).css("cursor",g.sliderCursor);j.attr("id",c?c+"-resizer":"").data({parentLayout:z,layoutPane:z[a],layoutEdge:a,layoutRole:"resizer"}).css(k.resizers.cssReq).css("zIndex",r.zIndexes.resizer_normal).css(g.applyDemoStyles?k.resizers.cssDemo:{}).addClass(n+" "+n+h).hover(Oa,da).hover(fb,gb).appendTo(u);
g.resizerDblClickToggle&&j.bind("dblclick."+K,na);l&&(l.attr("id",c?c+"-toggler":"").data({parentLayout:z,layoutPane:z[a],layoutEdge:a,layoutRole:"toggler"}).css(k.togglers.cssReq).css(g.applyDemoStyles?k.togglers.cssDemo:{}).addClass(f+" "+f+h).hover(Oa,da).bind("mouseenter",fb).appendTo(j),g.togglerContent_open&&b("<span>"+g.togglerContent_open+"</span>").data({layoutEdge:a,layoutRole:"togglerContent"}).data("layoutRole","togglerContent").data("layoutEdge",a).addClass("content content-open").css("display",
"none").appendTo(l),g.togglerContent_closed&&b("<span>"+g.togglerContent_closed+"</span>").data({layoutEdge:a,layoutRole:"togglerContent"}).addClass("content content-closed").css("display","none").appendTo(l),pb(a));var g=a,B=b.layout.plugins.draggable,g=g?g.split(","):k.borderPanes;b.each(g,function(e,a){var g=r[a];if(!B||!y[a]||!g.resizable)return g.resizable=!1,!0;var m=q[a],w=r.zIndexes,d=k[a],c="horz"==d.dir?"top":"left",t=F[a],n=g.resizerClass,f=0,l,h,E=n+"-drag",j=n+"-"+a+"-drag",J=n+"-dragging",
zb=n+"-"+a+"-dragging",cb=n+"-dragging-limit",v=n+"-"+a+"-dragging-limit",x=!1;m.isClosed||t.attr("title",g.tips.Resize).css("cursor",g.resizerCursor);t.draggable({containment:u[0],axis:"horz"==d.dir?"y":"x",delay:0,distance:1,grid:g.resizingGrid,helper:"clone",opacity:g.resizerDragOpacity,addClasses:!1,zIndex:w.resizer_drag,start:function(e,w){g=r[a];m=q[a];h=g.livePaneResizing;if(!1===C("ondrag_start",a))return!1;m.isResizing=!0;q.paneResizing=a;M.clear(a+"_closeSlider");Y(a);l=m.resizerPosition;
f=w.position[c];t.addClass(E+" "+j);x=!1;b("body").disableSelection();va(a,{resizing:!0})},drag:function(e,b){x||(b.helper.addClass(J+" "+zb).css({right:"auto",bottom:"auto"}).children().css("visibility","hidden"),x=!0,m.isSliding&&y[a].css("zIndex",w.pane_sliding));var d=0;b.position[c]<l.min?(b.position[c]=l.min,d=-1):b.position[c]>l.max&&(b.position[c]=l.max,d=1);d?(b.helper.addClass(cb+" "+v),window.defaultStatus=0<d&&a.match(/(north|west)/)||0>d&&a.match(/(south|east)/)?g.tips.maxSizeWarning:
g.tips.minSizeWarning):(b.helper.removeClass(cb+" "+v),window.defaultStatus="");h&&Math.abs(b.position[c]-f)>=g.liveResizingTolerance&&(f=b.position[c],p(e,b,a))},stop:function(e,g){b("body").enableSelection();window.defaultStatus="";t.removeClass(E+" "+j);m.isResizing=!1;q.paneResizing=!1;p(e,g,a,!0)}})});var p=function(b,e,a,g){var m=e.position,w=k[a];b=r[a];e=q[a];var d;switch(a){case "north":d=m.top;break;case "west":d=m.left;break;case "south":d=v.layoutHeight-m.top-b.spacing_open;break;case "east":d=
v.layoutWidth-m.left-b.spacing_open}d-=v.inset[w.side];g?(!1!==C("ondrag_end",a)&&Ca(a,d,!1,!0),za(!0),e.isSliding&&va(a,{resizing:!0})):Math.abs(d-e.size)<b.liveResizingTolerance||(Ca(a,d,!1,!0),ea.each(qb))};d.isVisible?Ua(a):(Da(a),ma(a,!0))}});qa()},Sa=function(b,a){if(H()){var m=r[b],d=m.contentSelector,g=z[b],c=y[b],n;d&&(n=g.content=U[b]=m.findNestedContent?c.find(d).eq(0):c.children(d).eq(0));n&&n.length?(n.data("layoutRole","content"),n.data("layoutCSS")||n.data("layoutCSS",D(n,"height")),
n.css(k.content.cssReq),m.applyDemoStyles&&(n.css(k.content.cssDemo),c.css(k.content.cssDemoPane)),c.css("overflowX").match(/(scroll|auto)/)&&c.css("overflow","hidden"),q[b].content={},!1!==a&&pa(b)):g.content=U[b]=!1}},qb=function(){var e=b(this),a=e.data("layoutMask"),a=q[a];"IFRAME"==a.tagName&&a.isVisible&&e.css({top:a.offsetTop,left:a.offsetLeft,width:a.outerWidth,height:a.outerHeight})},va=function(e,a){var m=k[e],d=["center"],g=r.zIndexes,c=b.extend({objectsOnly:!1,animation:!1,resizing:!0,
sliding:q[e].isSliding},a),n,f;c.resizing&&d.push(e);c.sliding&&d.push(k.oppositeEdge[e]);"horz"===m.dir&&(d.push("west"),d.push("east"));b.each(d,function(e,a){f=q[a];n=r[a];if(f.isVisible&&(n.maskObjects||!c.objectsOnly&&n.maskContents)){for(var m=b([]),d,w=0,h=ea.length;w<h;w++)d=ea.eq(w),d.data("layoutMask")===a&&(m=m.add(d));if(!m.length){m=y[a];d=q[a];var w=r[a],h=r.zIndexes,j=b([]),E,k,v,p,x;if(w.maskContents||w.maskObjects)for(x=0;x<(w.maskObjects?2:1);x++)E=w.maskObjects&&0==x,k=document.createElement(E?
"iframe":"div"),v=b(k).data("layoutMask",a),k.className="ui-layout-mask ui-layout-mask-"+a,p=k.style,p.display="block",p.position="absolute",p.background="#FFF",E&&(k.frameborder=0,k.src="about:blank",p.opacity=0,p.filter="Alpha(Opacity='0')",p.border=0),"IFRAME"==d.tagName?(p.zIndex=h.pane_normal+1,u.append(k)):(v.addClass("ui-layout-mask-inside-pane"),p.zIndex=w.maskZindex||h.content_mask,p.top=0,p.left=0,p.width="100%",p.height="100%",m.append(k)),j=j.add(k),ea=ea.add(k);m=j}m.each(function(){qb.call(this);
this.style.zIndex=f.isSliding?g.pane_sliding+1:g.pane_normal+1;this.style.display="block"})}})},za=function(a){if(a||!q.paneResizing)ea.hide();else if(!a&&!b.isEmptyObject(q.panesSliding)){a=ea.length-1;for(var d,m;0<=a;a--)m=ea.eq(a),d=m.data("layoutMask"),r[d].maskObjects||m.hide()}},Ra=function(a,d,m,c){if(H()){a=A.call(this,a);var g=y[a],t=U[a],n=F[a],f=P[a];g&&b.isEmptyObject(g.data())&&(g=!1);t&&b.isEmptyObject(t.data())&&(t=!1);n&&b.isEmptyObject(n.data())&&(n=!1);f&&b.isEmptyObject(f.data())&&
(f=!1);g&&g.stop(!0,!0);var h=r[a],l=ba[a],j=b.isPlainObject(l)&&!b.isEmptyObject(l);c=void 0!==c?c:h.destroyChildren;j&&c&&(b.each(l,function(a,b){b.destroyed||b.destroy(!0);b.destroyed&&delete l[a]}),b.isEmptyObject(l)&&(l=ba[a]=null,j=!1));g&&d&&!j?g.remove():g&&g[0]&&(d=h.paneClass,c=d+"-"+a,d=[d,d+"-open",d+"-closed",d+"-sliding",c,c+"-open",c+"-closed",c+"-sliding"],b.merge(d,Na(g,!0)),g.removeClass(d.join(" ")).removeData("parentLayout").removeData("layoutPane").removeData("layoutRole").removeData("layoutEdge").removeData("autoHidden").unbind("."+
K),j&&t?(t.width(t.width()),b.each(l,function(a,b){b.resizeAll()})):t&&t.css(t.data("layoutCSS")).removeData("layoutCSS").removeData("layoutRole"),g.data("layout")||g.css(g.data("layoutCSS")).removeData("layoutCSS"));f&&f.remove();n&&n.remove();z[a]=y[a]=U[a]=F[a]=P[a]=!1;m||oa()}},Ea=function(a){var b=y[a],d=b[0].style;r[a].useOffscreenClose?(b.data(k.offscreenReset)||b.data(k.offscreenReset,{left:d.left,right:d.right}),b.css(k.offscreenCSS)):b.hide().removeData(k.offscreenReset)},rb=function(a){var b=
y[a];a=r[a];var d=k.offscreenCSS,c=b.data(k.offscreenReset),g=b[0].style;b.show().removeData(k.offscreenReset);a.useOffscreenClose&&c&&(g.left==d.left&&(g.left=c.left),g.right==d.right&&(g.right=c.right))},Ta=function(a,b){if(H()){var d=A.call(this,a),c=r[d],g=q[d],t=F[d];y[d]&&!g.isHidden&&!(q.initialized&&!1===C("onhide_start",d))&&(g.isSliding=!1,delete q.panesSliding[d],t&&t.hide(),!q.initialized||g.isClosed?(g.isClosed=!0,g.isHidden=!0,g.isVisible=!1,q.initialized||Ea(d),ia("horz"===k[d].dir?
"":"center"),(q.initialized||c.triggerEventsOnLoad)&&C("onhide_end",d)):(g.isHiding=!0,ja(d,!1,b)))}},Fa=function(a,b,d,c){if(H()){a=A.call(this,a);var g=q[a];y[a]&&g.isHidden&&!1!==C("onshow_start",a)&&(g.isShowing=!0,g.isSliding=!1,delete q.panesSliding[a],!1===b?ja(a,!0):ra(a,!1,d,c))}},na=function(a,b){if(H()){var d=Ma(a),c=A.call(this,a),g=q[c];d&&d.stopImmediatePropagation();g.isHidden?Fa(c):g.isClosed?ra(c,!!b):ja(c)}},ja=function(a,b,d,c){function g(){l.isMoving=!1;ma(t,!0);var a=k.oppositeEdge[t];
q[a].noRoom&&(Y(a),ha(a));if(!c&&(q.initialized||h.triggerEventsOnLoad))p||C("onclose_end",t),p&&C("onshow_end",t),v&&C("onhide_end",t)}var t=A.call(this,a);if(!q.initialized&&y[t]){a=t;var n=q[a];Ea(a);n.isClosed=!0;n.isVisible=!1;Da(a)}else if(H()){var f=y[t],h=r[t],l=q[t],j,p,v;u.queue(function(a){if(!f||!h.closable&&!l.isShowing&&!l.isHiding||!b&&l.isClosed&&!l.isShowing)return a();var e=!l.isShowing&&!1===C("onclose_start",t);p=l.isShowing;v=l.isHiding;delete l.isShowing;delete l.isHiding;if(e)return a();
j=!d&&!l.isClosed&&"none"!=h.fxName_close;l.isMoving=!0;l.isClosed=!0;l.isVisible=!1;v?l.isHidden=!0:p&&(l.isHidden=!1);l.isSliding?wa(t,!1):ia("horz"===k[t].dir?"":"center",!1);Da(t);j?(Ga(t,!0),f.hide(h.fxName_close,h.fxSettings_close,h.fxSpeed_close,function(){Ga(t,!1);l.isClosed&&g();a()})):(Ea(t),g(),a())})}},Da=function(a){if(F[a]){var d=F[a],c=P[a],f=r[a],g=k[a].side,t=f.resizerClass,n=f.togglerClass,h="-"+a;d.css(g,v.inset[g]).removeClass(t+"-open "+t+h+"-open").removeClass(t+"-sliding "+
t+h+"-sliding").addClass(t+"-closed "+t+h+"-closed");f.resizable&&b.layout.plugins.draggable&&d.draggable("disable").removeClass("ui-state-disabled").css("cursor","default").attr("title","");c&&(c.removeClass(n+"-open "+n+h+"-open").addClass(n+"-closed "+n+h+"-closed").attr("title",f.tips.Open),c.children(".content-open").hide(),c.children(".content-closed").css("display","block"));Va(a,!1);q.initialized&&qa()}},ra=function(a,b,d,c){function g(){j.isMoving=!1;eb(f);j.isSliding||ia("vert"==k[f].dir?
"center":"",!1);Ua(f)}if(H()){var f=A.call(this,a),n=y[f],h=r[f],j=q[f],l,p;u.queue(function(a){if(!n||!h.resizable&&!h.closable&&!j.isShowing||j.isVisible&&!j.isSliding)return a();if(j.isHidden&&!j.isShowing)a(),Fa(f,!0);else{j.autoResize&&j.size!=h.size?ka(f,h.size,!0,!0,!0):Y(f,b);var e=C("onopen_start",f);if("abort"===e)return a();"NC"!==e&&Y(f,b);if(j.minSize>j.maxSize)return Va(f,!1),!c&&h.tips.noRoomToOpen&&alert(h.tips.noRoomToOpen),a();b?wa(f,!0):j.isSliding?wa(f,!1):h.slidable&&ma(f,!1);
j.noRoom=!1;ha(f);p=j.isShowing;delete j.isShowing;l=!d&&j.isClosed&&"none"!=h.fxName_open;j.isMoving=!0;j.isVisible=!0;j.isClosed=!1;p&&(j.isHidden=!1);l?(Ga(f,!0),n.show(h.fxName_open,h.fxSettings_open,h.fxSpeed_open,function(){Ga(f,!1);j.isVisible&&g();a()})):(rb(f),g(),a())}})}},Ua=function(a,d){var c=y[a],f=F[a],g=P[a],h=r[a],n=q[a],j=k[a].side,p=h.resizerClass,l=h.togglerClass,u="-"+a;f.css(j,v.inset[j]+ga(a)).removeClass(p+"-closed "+p+u+"-closed").addClass(p+"-open "+p+u+"-open");n.isSliding?
f.addClass(p+"-sliding "+p+u+"-sliding"):f.removeClass(p+"-sliding "+p+u+"-sliding");da(0,f);h.resizable&&b.layout.plugins.draggable?f.draggable("enable").css("cursor",h.resizerCursor).attr("title",h.tips.Resize):n.isSliding||f.css("cursor","default");g&&(g.removeClass(l+"-closed "+l+u+"-closed").addClass(l+"-open "+l+u+"-open").attr("title",h.tips.Close),da(0,g),g.children(".content-closed").hide(),g.children(".content-open").css("display","block"));Va(a,!n.isSliding);b.extend(n,R(c));q.initialized&&
(qa(),pa(a,!0));if(!d&&(q.initialized||h.triggerEventsOnLoad)&&c.is(":visible"))C("onopen_end",a),n.isShowing&&C("onshow_end",a),q.initialized&&C("onresize_end",a)},sb=function(a){function b(){g.isClosed?g.isMoving||ra(c,!0):wa(c,!0)}if(H()){var d=Ma(a),c=A.call(this,a),g=q[c];a=r[c].slideDelay_open;d&&d.stopImmediatePropagation();g.isClosed&&d&&"mouseenter"===d.type&&0<a?M.set(c+"_openSlider",b,a):b()}},Wa=function(a){function c(){g.isClosed?wa(f,!1):g.isMoving||ja(f)}if(H()){var m=Ma(a),f=A.call(this,
a);a=r[f];var g=q[f],h=g.isMoving?1E3:300;!g.isClosed&&!g.isResizing&&("click"===a.slideTrigger_close?c():a.preventQuickSlideClose&&g.isMoving||a.preventPrematureSlideClose&&m&&b.layout.isMouseOverElem(m,y[f])||(m?M.set(f+"_closeSlider",c,d(a.slideDelay_close,h)):c()))}},Ga=function(a,b){var d=y[a],c=q[a],g=r[a],f=r.zIndexes;b?(va(a,{animation:!0,objectsOnly:!0}),d.css({zIndex:f.pane_animate}),"south"==a?d.css({top:v.inset.top+v.innerHeight-d.outerHeight()}):"east"==a&&d.css({left:v.inset.left+v.innerWidth-
d.outerWidth()})):(za(),d.css({zIndex:c.isSliding?f.pane_sliding:f.pane_normal}),"south"==a?d.css({top:"auto"}):"east"==a&&!d.css("left").match(/\-99999/)&&d.css({left:"auto"}),G.msie&&(g.fxOpacityFix&&"slide"!=g.fxName_open&&d.css("filter")&&1==d.css("opacity"))&&d[0].style.removeAttribute("filter"))},ma=function(a,b){var d=r[a],c=F[a],g=d.slideTrigger_open.toLowerCase();if(c&&(!b||d.slidable)){g.match(/mouseover/)?g=d.slideTrigger_open="mouseenter":g.match(/(click|dblclick|mouseenter)/)||(g=d.slideTrigger_open=
"click");if(d.resizerDblClickToggle&&g.match(/click/))c[b?"unbind":"bind"]("dblclick."+K,na);c[b?"bind":"unbind"](g+"."+K,sb).css("cursor",b?d.sliderCursor:"default").attr("title",b?d.tips.Slide:"")}},wa=function(a,b){function d(b){M.clear(a+"_closeSlider");b.stopPropagation()}var c=r[a],g=q[a],f=r.zIndexes,h=c.slideTrigger_close.toLowerCase(),j=b?"bind":"unbind",k=y[a],l=F[a];M.clear(a+"_closeSlider");b?(g.isSliding=!0,q.panesSliding[a]=!0,ma(a,!1)):(g.isSliding=!1,delete q.panesSliding[a]);k.css("zIndex",
b?f.pane_sliding:f.pane_normal);l.css("zIndex",b?f.pane_sliding+2:f.resizer_normal);h.match(/(click|mouseleave)/)||(h=c.slideTrigger_close="mouseleave");l[j](h,Wa);"mouseleave"===h&&(k[j]("mouseleave."+K,Wa),l[j]("mouseenter."+K,d),k[j]("mouseenter."+K,d));b?"click"===h&&!c.resizable&&(l.css("cursor",b?c.sliderCursor:"default"),l.attr("title",b?c.tips.Close:"")):M.clear(a+"_closeSlider")},ha=function(a,d,c,f){d=r[a];var g=q[a],h=k[a],n=y[a],j=F[a],p="vert"===h.dir,l=!1;if("center"===a||p&&g.noVerticalRoom)(l=
0<=g.maxHeight)&&g.noRoom?(rb(a),j&&j.show(),g.isVisible=!0,g.noRoom=!1,p&&(g.noVerticalRoom=!1),eb(a)):!l&&!g.noRoom&&(Ea(a),j&&j.hide(),g.isVisible=!1,g.noRoom=!0);"center"!==a&&(g.minSize<=g.maxSize?(g.size>g.maxSize?ka(a,g.maxSize,c,!0,f):g.size<g.minSize?ka(a,g.minSize,c,!0,f):j&&(g.isVisible&&n.is(":visible"))&&(c=g.size+v.inset[h.side],b.layout.cssNum(j,h.side)!=c&&j.css(h.side,c)),g.noRoom&&(g.wasOpen&&d.closable?d.autoReopen?ra(a,!1,!0,!0):g.noRoom=!1:Fa(a,g.wasOpen,!0,!0))):g.noRoom||(g.noRoom=
!0,g.wasOpen=!g.isClosed&&!g.isSliding,g.isClosed||(d.closable?ja(a,!0,!0):Ta(a,!0))))},Ca=function(a,b,d,c,g){if(H()){a=A.call(this,a);var f=r[a],h=q[a];g=g||f.livePaneResizing&&!h.isResizing;h.autoResize=!1;ka(a,b,d,c,g)}},ka=function(e,c,f,h,g){function j(){for(var a="width"===ua?l.outerWidth():l.outerHeight(),a=[{pane:n,count:1,target:c,actual:a,correct:c===a,attempt:c,cssSize:D}],e=a[0],h={},t="Inaccurate size after resizing the "+n+"-pane.";!e.correct;){h={pane:n,count:e.count+1,target:c};h.attempt=
e.actual>c?d(0,e.attempt-(e.actual-c)):d(0,e.attempt+(c-e.actual));h.cssSize=("horz"==k[n].dir?O:Q)(y[n],h.attempt);l.css(ua,h.cssSize);h.actual="width"==ua?l.outerWidth():l.outerHeight();h.correct=c===h.actual;1===a.length&&(ca(t,!1,!0),ca(e,!1,!0));ca(h,!1,!0);if(3<a.length)break;a.push(h);e=a[a.length-1]}J.size=c;b.extend(J,R(l));J.isVisible&&l.is(":visible")&&(x&&x.css(B,c+v.inset[B]),pa(n));!f&&(!Z&&q.initialized&&J.isVisible)&&C("onresize_end",n);f||(J.isSliding||ia("horz"==k[n].dir?"":"center",
Z,g),qa());e=k.oppositeEdge[n];c<G&&q[e].noRoom&&(Y(e),ha(e,!1,f));1<a.length&&ca(t+"\nSee the Error Console for details.",!0,!0)}if(H()){var n=A.call(this,e),p=r[n],J=q[n],l=y[n],x=F[n],B=k[n].side,ua=k[n].sizeType.toLowerCase(),Z=J.isResizing&&!p.triggerEventsDuringLiveResize,z=!0!==h&&p.animatePaneSizing,G,D;u.queue(function(e){Y(n);G=J.size;c=fa(n,c);c=d(c,fa(n,p.minSize));c=a(c,J.maxSize);if(c<J.minSize)e(),ha(n,!1,f);else{if(!g&&c===G)return e();J.newSize=c;!f&&(q.initialized&&J.isVisible)&&
C("onresize_start",n);D=("horz"==k[n].dir?O:Q)(y[n],c);if(z&&l.is(":visible")){var h=b.layout.effects.size[n]||b.layout.effects.size.all,h=p.fxSettings_size.easing||h.easing,v=r.zIndexes,u={};u[ua]=D+"px";J.isMoving=!0;l.css({zIndex:v.pane_animate}).show().animate(u,p.fxSpeed_size,h,function(){l.css({zIndex:J.isSliding?v.pane_sliding:v.pane_normal});J.isMoving=!1;delete J.newSize;j();e()})}else l.css(ua,D),delete J.newSize,l.is(":visible")?j():(J.size=c,b.extend(J,R(l))),e()}})}},ia=function(a,c,
f){a=(a?a:"east,west,center").split(",");b.each(a,function(a,e){if(y[e]){var h=r[e],j=q[e],k=y[e],p=!0,l={},u=b.layout.showInvisibly(k),B={top:ga("north",!0),bottom:ga("south",!0),left:ga("west",!0),right:ga("east",!0),width:0,height:0};B.width=v.innerWidth-B.left-B.right;B.height=v.innerHeight-B.bottom-B.top;B.top+=v.inset.top;B.bottom+=v.inset.bottom;B.left+=v.inset.left;B.right+=v.inset.right;b.extend(j,R(k));if("center"===e){if(!f&&j.isVisible&&B.width===j.outerWidth&&B.height===j.outerHeight)return k.css(u),
!0;b.extend(j,ya(e),{maxWidth:B.width,maxHeight:B.height});l=B;j.newWidth=l.width;j.newHeight=l.height;l.width=Q(k,l.width);l.height=O(k,l.height);p=0<=l.width&&0<=l.height;if(!q.initialized&&h.minWidth>B.width){var h=h.minWidth-j.outerWidth,B=r.east.minSize||0,x=r.west.minSize||0,Z=q.east.size,z=q.west.size,A=Z,D=z;0<h&&(q.east.isVisible&&Z>B)&&(A=d(Z-B,Z-h),h-=Z-A);0<h&&(q.west.isVisible&&z>x)&&(D=d(z-x,z-h),h-=z-D);if(0===h){Z&&Z!=B&&ka("east",A,!0,!0,f);z&&z!=x&&ka("west",D,!0,!0,f);ia("center",
c,f);k.css(u);return}}}else{j.isVisible&&!j.noVerticalRoom&&b.extend(j,R(k),ya(e));if(!f&&!j.noVerticalRoom&&B.height===j.outerHeight)return k.css(u),!0;l.top=B.top;l.bottom=B.bottom;j.newSize=B.height;l.height=O(k,B.height);j.maxHeight=l.height;p=0<=j.maxHeight;p||(j.noVerticalRoom=!0)}p?(!c&&q.initialized&&C("onresize_start",e),k.css(l),"center"!==e&&qa(e),j.noRoom&&(!j.isClosed&&!j.isHidden)&&ha(e),j.isVisible&&(b.extend(j,R(k)),q.initialized&&pa(e))):!j.noRoom&&j.isVisible&&ha(e);k.css(u);delete j.newSize;
delete j.newWidth;delete j.newHeight;if(!j.isVisible)return!0;"center"===e&&(j=G.isIE6||!G.boxModel,y.north&&(j||"IFRAME"==q.north.tagName)&&y.north.css("width",Q(y.north,v.innerWidth)),y.south&&(j||"IFRAME"==q.south.tagName)&&y.south.css("width",Q(y.south,v.innerWidth)));!c&&q.initialized&&C("onresize_end",e)}})},oa=function(a){A(a);if(u.is(":visible"))if(q.initialized){if(!0===a&&b.isPlainObject(r.outset)&&u.css(r.outset),b.extend(v,R(u,r.inset)),v.outerHeight){!0===a&&ob();if(!1===C("onresizeall_start"))return!1;
var d,c,f;b.each(["south","north","east","west"],function(a,b){y[b]&&(c=r[b],f=q[b],f.autoResize&&f.size!=c.size?ka(b,c.size,!0,!0,!0):(Y(b),ha(b,!1,!0,!0)))});ia("",!0,!0);qa();b.each(k.allPanes,function(a,b){(d=y[b])&&q[b].isVisible&&C("onresize_end",b)});C("onresizeall_end")}}else Aa()},db=function(a,d){var c=A.call(this,a);r[c].resizeChildren&&(d||Ba(c),c=ba[c],b.isPlainObject(c)&&b.each(c,function(a,b){b.destroyed||b.resizeAll()}))},pa=function(a,c){if(H()){var h=A.call(this,a),h=h?h.split(","):
k.allPanes;b.each(h,function(a,e){function h(a){return d(u.css.paddingBottom,parseInt(a.css("marginBottom"),10)||0)}function j(){var a=r[e].contentIgnoreSelector,a=p.nextAll().not(".ui-layout-mask").not(a||":lt(0)"),b=a.filter(":visible"),d=b.filter(":last");v={top:p[0].offsetTop,height:p.outerHeight(),numFooters:a.length,hiddenFooters:a.length-b.length,spaceBelow:0};v.spaceAbove=v.top;v.bottom=v.top+v.height;v.spaceBelow=d.length?d[0].offsetTop+d.outerHeight()-v.bottom+h(d):h(p)}var m=y[e],p=U[e],
l=r[e],u=q[e],v=u.content;if(!m||!p||!m.is(":visible"))return!0;if(!p.length&&(Sa(e,!1),!p))return;if(!1!==C("onsizecontent_start",e)){if(!u.isMoving&&!u.isResizing||l.liveContentResizing||c||void 0==v.top)j(),0<v.hiddenFooters&&"hidden"===m.css("overflow")&&(m.css("overflow","visible"),j(),m.css("overflow","hidden"));m=u.innerHeight-(v.spaceAbove-u.css.paddingTop)-(v.spaceBelow-u.css.paddingBottom);if(!p.is(":visible")||v.height!=m){var x=p,l=x;f(x)?l=y[x]:x.jquery||(l=b(x));x=O(l,m);l.css({height:x,
visibility:"visible"});0<x&&0<l.innerWidth()?l.data("autoHidden")&&(l.show().data("autoHidden",!1),G.mozilla||l.css(k.hidden).css(k.visible)):l.data("autoHidden")||l.hide().data("autoHidden",!0);v.height=m}q.initialized&&C("onsizecontent_end",e)}})}},qa=function(a){a=(a=A.call(this,a))?a.split(","):k.borderPanes;b.each(a,function(a,d){var e=r[d],g=q[d],h=y[d],j=F[d],p=P[d],u;if(h&&j){var l=k[d].dir,x=g.isClosed?"_closed":"_open",B=e["spacing"+x],z=e["togglerAlign"+x],x=e["togglerLength"+x],A;if(0===
B)j.hide();else{!g.noRoom&&!g.isHidden&&j.show();"horz"===l?(A=v.innerWidth,g.resizerLength=A,h=b.layout.cssNum(h,"left"),j.css({width:Q(j,A),height:O(j,B),left:-9999<h?h:v.inset.left})):(A=h.outerHeight(),g.resizerLength=A,j.css({height:O(j,A),width:Q(j,B),top:v.inset.top+ga("north",!0)}));da(e,j);if(p){if(0===x||g.isSliding&&e.hideTogglerOnSlide){p.hide();return}p.show();if(!(0<x)||"100%"===x||x>A)x=A,z=0;else if(f(z))switch(z){case "top":case "left":z=0;break;case "bottom":case "right":z=A-x;break;
default:z=c((A-x)/2)}else h=parseInt(z,10),z=0<=z?h:A-x+h;if("horz"===l){var D=Q(p,x);p.css({width:D,height:O(p,B),left:z,top:0});p.children(".content").each(function(){u=b(this);u.css("marginLeft",c((D-u.outerWidth())/2))})}else{var C=O(p,x);p.css({height:C,width:Q(p,B),top:z,left:0});p.children(".content").each(function(){u=b(this);u.css("marginTop",c((C-u.outerHeight())/2))})}da(0,p)}if(!q.initialized&&(e.initHidden||g.isHidden))j.hide(),p&&p.hide()}}})},pb=function(a){if(H()){var b=A.call(this,
a);a=P[b];var d=r[b];a&&(d.closable=!0,a.bind("click."+K,function(a){a.stopPropagation();na(b)}).css("visibility","visible").css("cursor","pointer").attr("title",q[b].isClosed?d.tips.Open:d.tips.Close).show())}},Va=function(a,d){b.layout.plugins.buttons&&b.each(q[a].pins,function(c,f){b.layout.buttons.setPinState(z,b(f),a,d)})},u=b(this).eq(0);if(!u.length)return ca(r.errors.containerMissing);if(u.data("layoutContainer")&&u.data("layout"))return u.data("layout");var y={},U={},F={},P={},ea=b([]),v=
q.container,K=q.id,z={options:r,state:q,container:u,panes:y,contents:U,resizers:F,togglers:P,hide:Ta,show:Fa,toggle:na,open:ra,close:ja,slideOpen:sb,slideClose:Wa,slideToggle:function(a){a=A.call(this,a);na(a,!0)},setSizeLimits:Y,_sizePane:ka,sizePane:Ca,sizeContent:pa,swapPanes:function(a,c){function f(a){var d=y[a],c=U[a];return!d?!1:{pane:a,P:d?d[0]:!1,C:c?c[0]:!1,state:b.extend(!0,{},q[a]),options:b.extend(!0,{},r[a])}}function h(a,c){if(a){var e=a.P,f=a.C,g=a.pane,j=k[c],m=b.extend(!0,{},q[c]),
n=r[c],w={resizerCursor:n.resizerCursor};b.each(["fxName","fxSpeed","fxSettings"],function(a,b){w[b+"_open"]=n[b+"_open"];w[b+"_close"]=n[b+"_close"];w[b+"_size"]=n[b+"_size"]});y[c]=b(e).data({layoutPane:z[c],layoutEdge:c}).css(k.hidden).css(j.cssReq);U[c]=f?b(f):!1;r[c]=b.extend(!0,{},a.options,w);q[c]=b.extend(!0,{},a.state);e.className=e.className.replace(RegExp(n.paneClass+"-"+g,"g"),n.paneClass+"-"+c);Pa(c);j.dir!=k[g].dir?(e=p[c]||0,Y(c),e=d(e,q[c].minSize),Ca(c,e,!0,!0)):F[c].css(j.side,v.inset[j.side]+
(q[c].isVisible?ga(c):0));a.state.isVisible&&!m.isVisible?Ua(c,!0):(Da(c),ma(c,!0));a=null}}if(H()){var g=A.call(this,a);q[g].edge=c;q[c].edge=g;if(!1===C("onswap_start",g)||!1===C("onswap_start",c))q[g].edge=g,q[c].edge=c;else{var j=f(g),n=f(c),p={};p[g]=j?j.state.size:0;p[c]=n?n.state.size:0;y[g]=!1;y[c]=!1;q[g]={};q[c]={};P[g]&&P[g].remove();P[c]&&P[c].remove();F[g]&&F[g].remove();F[c]&&F[c].remove();F[g]=F[c]=P[g]=P[c]=!1;h(j,c);h(n,g);j=n=p=null;y[g]&&y[g].css(k.visible);y[c]&&y[c].css(k.visible);
oa();C("onswap_end",g);C("onswap_end",c)}}},showMasks:va,hideMasks:za,initContent:Sa,addPane:ib,removePane:Ra,createChildren:Qa,refreshChildren:Ba,enableClosable:pb,disableClosable:function(a,b){if(H()){var c=A.call(this,a),d=P[c];d&&(r[c].closable=!1,q[c].isClosed&&ra(c,!1,!0),d.unbind("."+K).css("visibility",b?"hidden":"visible").css("cursor","default").attr("title",""))}},enableSlidable:function(a){if(H()){a=A.call(this,a);var b=F[a];b&&b.data("draggable")&&(r[a].slidable=!0,q[a].isClosed&&ma(a,
!0))}},disableSlidable:function(a){if(H()){a=A.call(this,a);var b=F[a];b&&(r[a].slidable=!1,q[a].isSliding?ja(a,!1,!0):(ma(a,!1),b.css("cursor","default").attr("title",""),da(null,b[0])))}},enableResizable:function(a){if(H()){a=A.call(this,a);var b=F[a],c=r[a];b&&b.data("draggable")&&(c.resizable=!0,b.draggable("enable"),q[a].isClosed||b.css("cursor",c.resizerCursor).attr("title",c.tips.Resize))}},disableResizable:function(a){if(H()){a=A.call(this,a);var b=F[a];b&&b.data("draggable")&&(r[a].resizable=
!1,b.draggable("disable").css("cursor","default").attr("title",""),da(null,b[0]))}},allowOverflow:x,resetOverflow:X,destroy:function(a,c){b(window).unbind("."+K);b(document).unbind("."+K);"object"===typeof a?A(a):c=a;u.clearQueue().removeData("layout").removeData("layoutContainer").removeClass(r.containerClass).unbind("."+K);ea.remove();b.each(k.allPanes,function(a,b){Ra(b,!1,!0,c)});u.data("layoutCSS")&&!u.data("layoutRole")&&u.css(u.data("layoutCSS")).removeData("layoutCSS");"BODY"===v.tagName&&
(u=b("html")).data("layoutCSS")&&u.css(u.data("layoutCSS")).removeData("layoutCSS");j(z,b.layout.onDestroy);mb();for(var d in z)d.match(/^(container|options)$/)||delete z[d];z.destroyed=!0;return z},initPanes:H,resizeAll:oa,runCallbacks:C,hasParentLayout:!1,children:ba,north:!1,south:!1,west:!1,east:!1,center:!1},Xa;var V,Ya,N,Ha,la,sa,W;h=b.layout.transformData(h,!0);h=b.layout.backwardCompatibility.renameAllOptions(h);if(!b.isEmptyObject(h.panes)){V=b.layout.optionsMap.noDefault;la=0;for(sa=V.length;la<
sa;la++)N=V[la],delete h.panes[N];V=b.layout.optionsMap.layout;la=0;for(sa=V.length;la<sa;la++)N=V[la],delete h.panes[N]}V=b.layout.optionsMap.layout;var Bb=b.layout.config.optionRootKeys;for(N in h)Ha=h[N],0>b.inArray(N,Bb)&&0>b.inArray(N,V)&&(h.panes[N]||(h.panes[N]=b.isPlainObject(Ha)?b.extend(!0,{},Ha):Ha),delete h[N]);b.extend(!0,r,h);b.each(k.allPanes,function(a,c){k[c]=b.extend(!0,{},k.panes,k[c]);Ya=r.panes;W=r[c];if("center"===c){V=b.layout.optionsMap.center;a=0;for(sa=V.length;a<sa;a++)if(N=
V[a],!h.center[N]&&(h.panes[N]||!W[N]))W[N]=Ya[N]}else{W=r[c]=b.extend(!0,{},Ya,W);var d=r[c],f=r.panes;d.fxSettings||(d.fxSettings={});f.fxSettings||(f.fxSettings={});b.each(["_open","_close","_size"],function(a,e){var h="fxName"+e,j="fxSpeed"+e,k="fxSettings"+e,l=d[h]=d[h]||f[h]||d.fxName||f.fxName||"none",p=b.effects&&(b.effects[l]||b.effects.effect&&b.effects.effect[l]);if("none"===l||!r.effects[l]||!p)l=d[h]="none";l=r.effects[l]||{};h=l.all||null;l=l[c]||null;d[j]=d[j]||f[j]||d.fxSpeed||f.fxSpeed||
null;d[k]=b.extend(!0,{},h,l,f.fxSettings,d.fxSettings,f[k],d[k])});delete d.fxName;delete d.fxSpeed;delete d.fxSettings;W.resizerClass||(W.resizerClass="ui-layout-resizer");W.togglerClass||(W.togglerClass="ui-layout-toggler")}W.paneClass||(W.paneClass="ui-layout-pane")});var Ia=h.zIndex,xa=r.zIndexes;0<Ia&&(xa.pane_normal=Ia,xa.content_mask=d(Ia+1,xa.content_mask),xa.resizer_normal=d(Ia+2,xa.resizer_normal));delete r.panes;var Cb=r,tb=q;tb.creatingLayout=!0;j(z,b.layout.onCreate);if(!1===C("onload_start"))Xa=
"cancel";else{var Za=u[0],$=b("html"),ub=v.tagName=Za.tagName,vb=v.id=Za.id,wb=v.className=Za.className,L=r,Ja=L.name,$a={},Ka=u.data("parentLayout"),La=u.data("layoutEdge"),ab=Ka&&La,ta=b.layout.cssNum,bb,aa;v.selector=u.selector.split(".slice")[0];v.ref=(L.name?L.name+" layout / ":"")+ub+(vb?"#"+vb:wb?".["+wb+"]":"");v.isBody="BODY"===ub;!ab&&!v.isBody&&(bb=u.closest("."+b.layout.defaults.panes.paneClass),Ka=bb.data("parentLayout"),La=bb.data("layoutEdge"),ab=Ka&&La);u.data({layout:z,layoutContainer:K}).addClass(L.containerClass);
var xb={destroy:"",initPanes:"",resizeAll:"resizeAll",resize:"resizeAll"};for(Ja in xb)u.bind("layout"+Ja.toLowerCase()+"."+K,z[xb[Ja]||Ja]);ab&&(z.hasParentLayout=!0,Ka.refreshChildren(La,z));u.data("layoutCSS")||(v.isBody?(u.data("layoutCSS",b.extend(D(u,"position,margin,padding,border"),{height:u.css("height"),overflow:u.css("overflow"),overflowX:u.css("overflowX"),overflowY:u.css("overflowY")})),$.data("layoutCSS",b.extend(D($,"padding"),{height:"auto",overflow:$.css("overflow"),overflowX:$.css("overflowX"),
overflowY:$.css("overflowY")}))):u.data("layoutCSS",D(u,"position,margin,padding,border,top,bottom,left,right,width,height,overflow,overflowX,overflowY")));try{$a={overflow:"hidden",overflowX:"hidden",overflowY:"hidden"};u.css($a);L.inset&&!b.isPlainObject(L.inset)&&(aa=parseInt(L.inset,10)||0,L.inset={top:aa,bottom:aa,left:aa,right:aa});if(v.isBody)L.outset?b.isPlainObject(L.outset)||(aa=parseInt(L.outset,10)||0,L.outset={top:aa,bottom:aa,left:aa,right:aa}):L.outset={top:ta($,"paddingTop"),bottom:ta($,
"paddingBottom"),left:ta($,"paddingLeft"),right:ta($,"paddingRight")},$.css($a).css({height:"100%",border:"none",padding:0,margin:0}),G.isIE6?(u.css({width:"100%",height:"100%",border:"none",padding:0,margin:0,position:"relative"}),L.inset||(L.inset=R(u).inset)):(u.css({width:"auto",height:"auto",margin:0,position:"absolute"}),u.css(L.outset)),b.extend(v,R(u,L.inset));else{var yb=u.css("position");(!yb||!yb.match(/(fixed|absolute|relative)/))&&u.css("position","relative");u.is(":visible")&&(b.extend(v,
R(u,L.inset)),1>v.innerHeight&&ca(L.errors.noContainerHeight.replace(/CONTAINER/,v.ref)))}ta(u,"minWidth")&&u.parent().css("overflowX","auto");ta(u,"minHeight")&&u.parent().css("overflowY","auto")}catch(Db){}nb();b(window).bind("unload."+K,mb);j(z,b.layout.onLoad);Cb.initPanes&&Aa();delete tb.creatingLayout;Xa=q.initialized}return"cancel"===Xa?null:z}})(jQuery);
(function(b){b.ui||(b.ui={});b.ui.cookie={acceptsCookies:!!navigator.cookieEnabled,read:function(a){for(var d=document.cookie,d=d?d.split(";"):[],c,f=0,j=d.length;f<j;f++)if(c=b.trim(d[f]).split("="),c[0]==a)return decodeURIComponent(c[1]);return null},write:function(a,d,c){var f="",j="",h=!1;c=c||{};var p=c.expires||null,x=b.type(p);"date"===x?j=p:"string"===x&&0<p&&(p=parseInt(p,10),x="number");"number"===x&&(j=new Date,0<p?j.setDate(j.getDate()+p):(j.setFullYear(1970),h=!0));j&&(f+=";expires="+
j.toUTCString());c.path&&(f+=";path="+c.path);c.domain&&(f+=";domain="+c.domain);c.secure&&(f+=";secure");document.cookie=a+"="+(h?"":encodeURIComponent(d))+f},clear:function(a){b.ui.cookie.write(a,"",{expires:-1})}};b.cookie||(b.cookie=function(a,d,c){var f=b.ui.cookie;if(null===d)f.clear(a);else{if(void 0===d)return f.read(a);f.write(a,d,c)}});b.layout.plugins.stateManagement=!0;b.layout.config.optionRootKeys.push("stateManagement");b.layout.defaults.stateManagement={enabled:!1,autoSave:!0,autoLoad:!0,
animateLoad:!0,includeChildren:!0,stateKeys:"north.size,south.size,east.size,west.size,north.isClosed,south.isClosed,east.isClosed,west.isClosed,north.isHidden,south.isHidden,east.isHidden,west.isHidden",cookie:{name:"",domain:"",path:"",expires:"",secure:!1}};b.layout.optionsMap.layout.push("stateManagement");b.layout.state={saveCookie:function(a,d,c){var f=a.options,j=f.stateManagement;c=b.extend(!0,{},j.cookie,c||null);a=a.state.stateData=a.readState(d||j.stateKeys);b.ui.cookie.write(c.name||f.name||
"Layout",b.layout.state.encodeJSON(a),c);return b.extend(!0,{},a)},deleteCookie:function(a){a=a.options;b.ui.cookie.clear(a.stateManagement.cookie.name||a.name||"Layout")},readCookie:function(a){a=a.options;return(a=b.ui.cookie.read(a.stateManagement.cookie.name||a.name||"Layout"))?b.layout.state.decodeJSON(a):{}},loadCookie:function(a){var d=b.layout.state.readCookie(a);d&&(a.state.stateData=b.extend(!0,{},d),a.loadState(d));return d},loadState:function(a,d,c){if(b.isPlainObject(d)&&!b.isEmptyObject(d))if(d=
a.state.stateData=b.layout.transformData(d),c=b.extend({animateLoad:!1,includeChildren:a.options.stateManagement.includeChildren},c),a.state.initialized){var f=!c.animateLoad,j,h,p,x;b.each(b.layout.config.borderPanes,function(c,G){S=d[G];b.isPlainObject(S)&&(s=S.size,j=S.initClosed,h=S.initHidden,ar=S.autoResize,p=a.state[G],x=p.isVisible,ar&&(p.autoResize=ar),x||a._sizePane(G,s,!1,!1,!1),!0===h?a.hide(G,f):!0===j?a.close(G,!1,f):!1===j?a.open(G,!1,f):!1===h&&a.show(G,!1,f),x&&a._sizePane(G,s,!1,
!1,f))});if(c.includeChildren){var I,T;b.each(a.children,function(a,c){(I=d[a]?d[a].children:0)&&c&&b.each(c,function(a,b){T=I[a];b&&T&&b.loadState(T)})})}}else{var S=b.extend(!0,{},d);b.each(b.layout.config.allPanes,function(a,b){S[b]&&delete S[b].children});b.extend(!0,a.options,S)}},readState:function(a,d){"string"===b.type(d)&&(d={keys:d});d||(d={});var c=a.options.stateManagement,f=d.includeChildren,f=void 0!==f?f:c.includeChildren,c=d.stateKeys||c.stateKeys,j={isClosed:"initClosed",isHidden:"initHidden"},
h=a.state,p=b.layout.config.allPanes,x={},I,T,S,X,G,k;b.isArray(c)&&(c=c.join(","));for(var c=c.replace(/__/g,".").split(","),Q=0,O=c.length;Q<O;Q++)I=c[Q].split("."),T=I[0],I=I[1],0>b.inArray(T,p)||(S=h[T][I],void 0!=S&&("isClosed"==I&&h[T].isSliding&&(S=!0),(x[T]||(x[T]={}))[j[I]?j[I]:I]=S));f&&b.each(p,function(c,d){G=a.children[d];X=h.stateData[d];b.isPlainObject(G)&&!b.isEmptyObject(G)&&(k=x[d]||(x[d]={}),k.children||(k.children={}),b.each(G,function(a,c){c.state.initialized?k.children[a]=b.layout.state.readState(c):
X&&(X.children&&X.children[a])&&(k.children[a]=b.extend(!0,{},X.children[a]))}))});return x},encodeJSON:function(a){function d(a){var f=[],j=0,h,p,x,I=b.isArray(a);for(h in a)p=a[h],x=typeof p,"string"==x?p='"'+p+'"':"object"==x&&(p=d(p)),f[j++]=(!I?'"'+h+'":':"")+p;return(I?"[":"{")+f.join(",")+(I?"]":"}")}return d(a)},decodeJSON:function(a){try{return b.parseJSON?b.parseJSON(a):window.eval("("+a+")")||{}}catch(d){return{}}},_create:function(a){var d=b.layout.state,c=a.options.stateManagement;b.extend(a,
{readCookie:function(){return d.readCookie(a)},deleteCookie:function(){d.deleteCookie(a)},saveCookie:function(b,c){return d.saveCookie(a,b,c)},loadCookie:function(){return d.loadCookie(a)},loadState:function(b,c){d.loadState(a,b,c)},readState:function(b){return d.readState(a,b)},encodeJSON:d.encodeJSON,decodeJSON:d.decodeJSON});a.state.stateData={};if(c.autoLoad)if(b.isPlainObject(c.autoLoad))b.isEmptyObject(c.autoLoad)||a.loadState(c.autoLoad);else if(c.enabled)if(b.isFunction(c.autoLoad)){var f=
{};try{f=c.autoLoad(a,a.state,a.options,a.options.name||"")}catch(j){}f&&(b.isPlainObject(f)&&!b.isEmptyObject(f))&&a.loadState(f)}else a.loadCookie()},_unload:function(a){var d=a.options.stateManagement;if(d.enabled&&d.autoSave)if(b.isFunction(d.autoSave))try{d.autoSave(a,a.state,a.options,a.options.name||"")}catch(c){}else a.saveCookie()}};b.layout.onCreate.push(b.layout.state._create);b.layout.onUnload.push(b.layout.state._unload);b.layout.plugins.buttons=!0;b.layout.defaults.autoBindCustomButtons=
!1;b.layout.optionsMap.layout.push("autoBindCustomButtons");b.layout.buttons={init:function(a){var d=a.options.name||"",c;b.each("toggle open close pin toggle-slide open-slide".split(" "),function(f,j){b.each(b.layout.config.borderPanes,function(f,p){b(".ui-layout-button-"+j+"-"+p).each(function(){c=b(this).data("layoutName")||b(this).attr("layoutName");(void 0==c||c===d)&&a.bindButton(this,j,p)})})})},get:function(a,d,c,f){var j=b(d);a=a.options;var h=a.errors.addButtonError;j.length?0>b.inArray(c,
b.layout.config.borderPanes)?(b.layout.msg(h+" "+a.errors.pane+": "+c,!0),j=b("")):(d=a[c].buttonClass+"-"+f,j.addClass(d+" "+d+"-"+c).data("layoutName",a.name)):b.layout.msg(h+" "+a.errors.selector+": "+d,!0);return j},bind:function(a,d,c,f){var j=b.layout.buttons;switch(c.toLowerCase()){case "toggle":j.addToggle(a,d,f);break;case "open":j.addOpen(a,d,f);break;case "close":j.addClose(a,d,f);break;case "pin":j.addPin(a,d,f);break;case "toggle-slide":j.addToggle(a,d,f,!0);break;case "open-slide":j.addOpen(a,
d,f,!0)}return a},addToggle:function(a,d,c,f){b.layout.buttons.get(a,d,c,"toggle").click(function(b){a.toggle(c,!!f);b.stopPropagation()});return a},addOpen:function(a,d,c,f){b.layout.buttons.get(a,d,c,"open").attr("title",a.options[c].tips.Open).click(function(b){a.open(c,!!f);b.stopPropagation()});return a},addClose:function(a,d,c){b.layout.buttons.get(a,d,c,"close").attr("title",a.options[c].tips.Close).click(function(b){a.close(c);b.stopPropagation()});return a},addPin:function(a,d,c){var f=b.layout.buttons,
j=f.get(a,d,c,"pin");if(j.length){var h=a.state[c];j.click(function(d){f.setPinState(a,b(this),c,h.isSliding||h.isClosed);h.isSliding||h.isClosed?a.open(c):a.close(c);d.stopPropagation()});f.setPinState(a,j,c,!h.isClosed&&!h.isSliding);h.pins.push(d)}return a},setPinState:function(a,b,c,f){var j=b.attr("pin");if(!(j&&f===("down"==j))){a=a.options[c];var j=a.buttonClass+"-pin",h=j+"-"+c;c=j+"-up "+h+"-up";j=j+"-down "+h+"-down";b.attr("pin",f?"down":"up").attr("title",f?a.tips.Unpin:a.tips.Pin).removeClass(f?
c:j).addClass(f?j:c)}},syncPinBtns:function(a,d,c){b.each(a.state[d].pins,function(f,j){b.layout.buttons.setPinState(a,b(j),d,c)})},_load:function(a){var d=b.layout.buttons;b.extend(a,{bindButton:function(b,c,h){return d.bind(a,b,c,h)},addToggleBtn:function(b,c,h){return d.addToggle(a,b,c,h)},addOpenBtn:function(b,c,h){return d.addOpen(a,b,c,h)},addCloseBtn:function(b,c){return d.addClose(a,b,c)},addPinBtn:function(b,c){return d.addPin(a,b,c)}});for(var c=0;4>c;c++)a.state[b.layout.config.borderPanes[c]].pins=
[];a.options.autoBindCustomButtons&&d.init(a)},_unload:function(){}};b.layout.onLoad.push(b.layout.buttons._load);b.layout.plugins.browserZoom=!0;b.layout.defaults.browserZoomCheckInterval=1E3;b.layout.optionsMap.layout.push("browserZoomCheckInterval");b.layout.browserZoom={_init:function(a){!1!==b.layout.browserZoom.ratio()&&b.layout.browserZoom._setTimer(a)},_setTimer:function(a){if(!a.destroyed){var d=a.options,c=a.state,f=a.hasParentLayout?5E3:Math.max(d.browserZoomCheckInterval,100);setTimeout(function(){if(!a.destroyed&&
d.resizeWithWindow){var f=b.layout.browserZoom.ratio();f!==c.browserZoom&&(c.browserZoom=f,a.resizeAll());b.layout.browserZoom._setTimer(a)}},f)}},ratio:function(){function a(a,b){return(100*(parseInt(a,10)/parseInt(b,10))).toFixed()}var d=window,c=screen,f=document,j=f.documentElement||f.body,h=b.layout.browser,p=h.version,x,I,T;return h.msie&&8<p||!h.msie?!1:c.deviceXDPI&&c.systemXDPI?a(c.deviceXDPI,c.systemXDPI):h.webkit&&(x=f.body.getBoundingClientRect)?a(x.left-x.right,f.body.offsetWidth):h.webkit&&
(I=d.outerWidth)?a(I,d.innerWidth):(I=c.width)&&(T=j.clientWidth)?a(I,T):!1}};b.layout.onReady.push(b.layout.browserZoom._init)})(jQuery);
/* Modernizr 2.7.1 (Custom Build) | MIT & BSD
 * Build: http://modernizr.com/download/#-fontface-backgroundsize-borderimage-borderradius-boxshadow-flexbox-flexboxlegacy-hsla-multiplebgs-opacity-rgba-textshadow-cssanimations-csscolumns-generatedcontent-cssgradients-cssreflections-csstransforms-csstransforms3d-csstransitions-applicationcache-canvas-canvastext-draganddrop-hashchange-history-audio-video-indexeddb-input-inputtypes-localstorage-postmessage-sessionstorage-websockets-websqldatabase-webworkers-geolocation-inlinesvg-smil-svg-svgclippaths-touch-webgl-shiv-cssclasses-teststyles-testprop-testallprops-hasevent-prefixes-domprefixes-load
 */
;window.Modernizr=function(a,b,c){function C(a){j.cssText=a}function D(a,b){return C(n.join(a+";")+(b||""))}function E(a,b){return typeof a===b}function F(a,b){return!!~(""+a).indexOf(b)}function G(a,b){for(var d in a){var e=a[d];if(!F(e,"-")&&j[e]!==c)return b=="pfx"?e:!0}return!1}function H(a,b,d){for(var e in a){var f=b[a[e]];if(f!==c)return d===!1?a[e]:E(f,"function")?f.bind(d||b):f}return!1}function I(a,b,c){var d=a.charAt(0).toUpperCase()+a.slice(1),e=(a+" "+p.join(d+" ")+d).split(" ");return E(b,"string")||E(b,"undefined")?G(e,b):(e=(a+" "+q.join(d+" ")+d).split(" "),H(e,b,c))}function J(){e.input=function(c){for(var d=0,e=c.length;d<e;d++)u[c[d]]=c[d]in k;return u.list&&(u.list=!!b.createElement("datalist")&&!!a.HTMLDataListElement),u}("autocomplete autofocus list placeholder max min multiple pattern required step".split(" ")),e.inputtypes=function(a){for(var d=0,e,f,h,i=a.length;d<i;d++)k.setAttribute("type",f=a[d]),e=k.type!=="text",e&&(k.value=l,k.style.cssText="position:absolute;visibility:hidden;",/^range$/.test(f)&&k.style.WebkitAppearance!==c?(g.appendChild(k),h=b.defaultView,e=h.getComputedStyle&&h.getComputedStyle(k,null).WebkitAppearance!=="textfield"&&k.offsetHeight!==0,g.removeChild(k)):/^(search|tel)$/.test(f)||(/^(url|email)$/.test(f)?e=k.checkValidity&&k.checkValidity()===!1:e=k.value!=l)),t[a[d]]=!!e;return t}("search tel url email datetime date month week time datetime-local number range color".split(" "))}var d="2.7.1",e={},f=!0,g=b.documentElement,h="modernizr",i=b.createElement(h),j=i.style,k=b.createElement("input"),l=":)",m={}.toString,n=" -webkit- -moz- -o- -ms- ".split(" "),o="Webkit Moz O ms",p=o.split(" "),q=o.toLowerCase().split(" "),r={svg:"http://www.w3.org/2000/svg"},s={},t={},u={},v=[],w=v.slice,x,y=function(a,c,d,e){var f,i,j,k,l=b.createElement("div"),m=b.body,n=m||b.createElement("body");if(parseInt(d,10))while(d--)j=b.createElement("div"),j.id=e?e[d]:h+(d+1),l.appendChild(j);return f=["&#173;",'<style id="s',h,'">',a,"</style>"].join(""),l.id=h,(m?l:n).innerHTML+=f,n.appendChild(l),m||(n.style.background="",n.style.overflow="hidden",k=g.style.overflow,g.style.overflow="hidden",g.appendChild(n)),i=c(l,a),m?l.parentNode.removeChild(l):(n.parentNode.removeChild(n),g.style.overflow=k),!!i},z=function(){function d(d,e){e=e||b.createElement(a[d]||"div"),d="on"+d;var f=d in e;return f||(e.setAttribute||(e=b.createElement("div")),e.setAttribute&&e.removeAttribute&&(e.setAttribute(d,""),f=E(e[d],"function"),E(e[d],"undefined")||(e[d]=c),e.removeAttribute(d))),e=null,f}var a={select:"input",change:"input",submit:"form",reset:"form",error:"img",load:"img",abort:"img"};return d}(),A={}.hasOwnProperty,B;!E(A,"undefined")&&!E(A.call,"undefined")?B=function(a,b){return A.call(a,b)}:B=function(a,b){return b in a&&E(a.constructor.prototype[b],"undefined")},Function.prototype.bind||(Function.prototype.bind=function(b){var c=this;if(typeof c!="function")throw new TypeError;var d=w.call(arguments,1),e=function(){if(this instanceof e){var a=function(){};a.prototype=c.prototype;var f=new a,g=c.apply(f,d.concat(w.call(arguments)));return Object(g)===g?g:f}return c.apply(b,d.concat(w.call(arguments)))};return e}),s.flexbox=function(){return I("flexWrap")},s.flexboxlegacy=function(){return I("boxDirection")},s.canvas=function(){var a=b.createElement("canvas");return!!a.getContext&&!!a.getContext("2d")},s.canvastext=function(){return!!e.canvas&&!!E(b.createElement("canvas").getContext("2d").fillText,"function")},s.webgl=function(){return!!a.WebGLRenderingContext},s.touch=function(){var c;return"ontouchstart"in a||a.DocumentTouch&&b instanceof DocumentTouch?c=!0:y(["@media (",n.join("touch-enabled),("),h,")","{#modernizr{top:9px;position:absolute}}"].join(""),function(a){c=a.offsetTop===9}),c},s.geolocation=function(){return"geolocation"in navigator},s.postmessage=function(){return!!a.postMessage},s.websqldatabase=function(){return!!a.openDatabase},s.indexedDB=function(){return!!I("indexedDB",a)},s.hashchange=function(){return z("hashchange",a)&&(b.documentMode===c||b.documentMode>7)},s.history=function(){return!!a.history&&!!history.pushState},s.draganddrop=function(){var a=b.createElement("div");return"draggable"in a||"ondragstart"in a&&"ondrop"in a},s.websockets=function(){return"WebSocket"in a||"MozWebSocket"in a},s.rgba=function(){return C("background-color:rgba(150,255,150,.5)"),F(j.backgroundColor,"rgba")},s.hsla=function(){return C("background-color:hsla(120,40%,100%,.5)"),F(j.backgroundColor,"rgba")||F(j.backgroundColor,"hsla")},s.multiplebgs=function(){return C("background:url(https://),url(https://),red url(https://)"),/(url\s*\(.*?){3}/.test(j.background)},s.backgroundsize=function(){return I("backgroundSize")},s.borderimage=function(){return I("borderImage")},s.borderradius=function(){return I("borderRadius")},s.boxshadow=function(){return I("boxShadow")},s.textshadow=function(){return b.createElement("div").style.textShadow===""},s.opacity=function(){return D("opacity:.55"),/^0.55$/.test(j.opacity)},s.cssanimations=function(){return I("animationName")},s.csscolumns=function(){return I("columnCount")},s.cssgradients=function(){var a="background-image:",b="gradient(linear,left top,right bottom,from(#9f9),to(white));",c="linear-gradient(left top,#9f9, white);";return C((a+"-webkit- ".split(" ").join(b+a)+n.join(c+a)).slice(0,-a.length)),F(j.backgroundImage,"gradient")},s.cssreflections=function(){return I("boxReflect")},s.csstransforms=function(){return!!I("transform")},s.csstransforms3d=function(){var a=!!I("perspective");return a&&"webkitPerspective"in g.style&&y("@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}",function(b,c){a=b.offsetLeft===9&&b.offsetHeight===3}),a},s.csstransitions=function(){return I("transition")},s.fontface=function(){var a;return y('@font-face {font-family:"font";src:url("https://")}',function(c,d){var e=b.getElementById("smodernizr"),f=e.sheet||e.styleSheet,g=f?f.cssRules&&f.cssRules[0]?f.cssRules[0].cssText:f.cssText||"":"";a=/src/i.test(g)&&g.indexOf(d.split(" ")[0])===0}),a},s.generatedcontent=function(){var a;return y(["#",h,"{font:0/0 a}#",h,':after{content:"',l,'";visibility:hidden;font:3px/1 a}'].join(""),function(b){a=b.offsetHeight>=3}),a},s.video=function(){var a=b.createElement("video"),c=!1;try{if(c=!!a.canPlayType)c=new Boolean(c),c.ogg=a.canPlayType('video/ogg; codecs="theora"').replace(/^no$/,""),c.h264=a.canPlayType('video/mp4; codecs="avc1.42E01E"').replace(/^no$/,""),c.webm=a.canPlayType('video/webm; codecs="vp8, vorbis"').replace(/^no$/,"")}catch(d){}return c},s.audio=function(){var a=b.createElement("audio"),c=!1;try{if(c=!!a.canPlayType)c=new Boolean(c),c.ogg=a.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,""),c.mp3=a.canPlayType("audio/mpeg;").replace(/^no$/,""),c.wav=a.canPlayType('audio/wav; codecs="1"').replace(/^no$/,""),c.m4a=(a.canPlayType("audio/x-m4a;")||a.canPlayType("audio/aac;")).replace(/^no$/,"")}catch(d){}return c},s.localstorage=function(){try{return localStorage.setItem(h,h),localStorage.removeItem(h),!0}catch(a){return!1}},s.sessionstorage=function(){try{return sessionStorage.setItem(h,h),sessionStorage.removeItem(h),!0}catch(a){return!1}},s.webworkers=function(){return!!a.Worker},s.applicationcache=function(){return!!a.applicationCache},s.svg=function(){return!!b.createElementNS&&!!b.createElementNS(r.svg,"svg").createSVGRect},s.inlinesvg=function(){var a=b.createElement("div");return a.innerHTML="<svg/>",(a.firstChild&&a.firstChild.namespaceURI)==r.svg},s.smil=function(){return!!b.createElementNS&&/SVGAnimate/.test(m.call(b.createElementNS(r.svg,"animate")))},s.svgclippaths=function(){return!!b.createElementNS&&/SVGClipPath/.test(m.call(b.createElementNS(r.svg,"clipPath")))};for(var K in s)B(s,K)&&(x=K.toLowerCase(),e[x]=s[K](),v.push((e[x]?"":"no-")+x));return e.input||J(),e.addTest=function(a,b){if(typeof a=="object")for(var d in a)B(a,d)&&e.addTest(d,a[d]);else{a=a.toLowerCase();if(e[a]!==c)return e;b=typeof b=="function"?b():b,typeof f!="undefined"&&f&&(g.className+=" "+(b?"":"no-")+a),e[a]=b}return e},C(""),i=k=null,function(a,b){function l(a,b){var c=a.createElement("p"),d=a.getElementsByTagName("head")[0]||a.documentElement;return c.innerHTML="x<style>"+b+"</style>",d.insertBefore(c.lastChild,d.firstChild)}function m(){var a=s.elements;return typeof a=="string"?a.split(" "):a}function n(a){var b=j[a[h]];return b||(b={},i++,a[h]=i,j[i]=b),b}function o(a,c,d){c||(c=b);if(k)return c.createElement(a);d||(d=n(c));var g;return d.cache[a]?g=d.cache[a].cloneNode():f.test(a)?g=(d.cache[a]=d.createElem(a)).cloneNode():g=d.createElem(a),g.canHaveChildren&&!e.test(a)&&!g.tagUrn?d.frag.appendChild(g):g}function p(a,c){a||(a=b);if(k)return a.createDocumentFragment();c=c||n(a);var d=c.frag.cloneNode(),e=0,f=m(),g=f.length;for(;e<g;e++)d.createElement(f[e]);return d}function q(a,b){b.cache||(b.cache={},b.createElem=a.createElement,b.createFrag=a.createDocumentFragment,b.frag=b.createFrag()),a.createElement=function(c){return s.shivMethods?o(c,a,b):b.createElem(c)},a.createDocumentFragment=Function("h,f","return function(){var n=f.cloneNode(),c=n.createElement;h.shivMethods&&("+m().join().replace(/[\w\-]+/g,function(a){return b.createElem(a),b.frag.createElement(a),'c("'+a+'")'})+");return n}")(s,b.frag)}function r(a){a||(a=b);var c=n(a);return s.shivCSS&&!g&&!c.hasCSS&&(c.hasCSS=!!l(a,"article,aside,dialog,figcaption,figure,footer,header,hgroup,main,nav,section{display:block}mark{background:#FF0;color:#000}template{display:none}")),k||q(a,c),a}var c="3.7.0",d=a.html5||{},e=/^<|^(?:button|map|select|textarea|object|iframe|option|optgroup)$/i,f=/^(?:a|b|code|div|fieldset|h1|h2|h3|h4|h5|h6|i|label|li|ol|p|q|span|strong|style|table|tbody|td|th|tr|ul)$/i,g,h="_html5shiv",i=0,j={},k;(function(){try{var a=b.createElement("a");a.innerHTML="<xyz></xyz>",g="hidden"in a,k=a.childNodes.length==1||function(){b.createElement("a");var a=b.createDocumentFragment();return typeof a.cloneNode=="undefined"||typeof a.createDocumentFragment=="undefined"||typeof a.createElement=="undefined"}()}catch(c){g=!0,k=!0}})();var s={elements:d.elements||"abbr article aside audio bdi canvas data datalist details dialog figcaption figure footer header hgroup main mark meter nav output progress section summary template time video",version:c,shivCSS:d.shivCSS!==!1,supportsUnknownElements:k,shivMethods:d.shivMethods!==!1,type:"default",shivDocument:r,createElement:o,createDocumentFragment:p};a.html5=s,r(b)}(this,b),e._version=d,e._prefixes=n,e._domPrefixes=q,e._cssomPrefixes=p,e.hasEvent=z,e.testProp=function(a){return G([a])},e.testAllProps=I,e.testStyles=y,g.className=g.className.replace(/(^|\s)no-js(\s|$)/,"$1$2")+(f?" js "+v.join(" "):""),e}(this,this.document),function(a,b,c){function d(a){return"[object Function]"==o.call(a)}function e(a){return"string"==typeof a}function f(){}function g(a){return!a||"loaded"==a||"complete"==a||"uninitialized"==a}function h(){var a=p.shift();q=1,a?a.t?m(function(){("c"==a.t?B.injectCss:B.injectJs)(a.s,0,a.a,a.x,a.e,1)},0):(a(),h()):q=0}function i(a,c,d,e,f,i,j){function k(b){if(!o&&g(l.readyState)&&(u.r=o=1,!q&&h(),l.onload=l.onreadystatechange=null,b)){"img"!=a&&m(function(){t.removeChild(l)},50);for(var d in y[c])y[c].hasOwnProperty(d)&&y[c][d].onload()}}var j=j||B.errorTimeout,l=b.createElement(a),o=0,r=0,u={t:d,s:c,e:f,a:i,x:j};1===y[c]&&(r=1,y[c]=[]),"object"==a?l.data=c:(l.src=c,l.type=a),l.width=l.height="0",l.onerror=l.onload=l.onreadystatechange=function(){k.call(this,r)},p.splice(e,0,u),"img"!=a&&(r||2===y[c]?(t.insertBefore(l,s?null:n),m(k,j)):y[c].push(l))}function j(a,b,c,d,f){return q=0,b=b||"j",e(a)?i("c"==b?v:u,a,b,this.i++,c,d,f):(p.splice(this.i++,0,a),1==p.length&&h()),this}function k(){var a=B;return a.loader={load:j,i:0},a}var l=b.documentElement,m=a.setTimeout,n=b.getElementsByTagName("script")[0],o={}.toString,p=[],q=0,r="MozAppearance"in l.style,s=r&&!!b.createRange().compareNode,t=s?l:n.parentNode,l=a.opera&&"[object Opera]"==o.call(a.opera),l=!!b.attachEvent&&!l,u=r?"object":l?"script":"img",v=l?"script":u,w=Array.isArray||function(a){return"[object Array]"==o.call(a)},x=[],y={},z={timeout:function(a,b){return b.length&&(a.timeout=b[0]),a}},A,B;B=function(a){function b(a){var a=a.split("!"),b=x.length,c=a.pop(),d=a.length,c={url:c,origUrl:c,prefixes:a},e,f,g;for(f=0;f<d;f++)g=a[f].split("="),(e=z[g.shift()])&&(c=e(c,g));for(f=0;f<b;f++)c=x[f](c);return c}function g(a,e,f,g,h){var i=b(a),j=i.autoCallback;i.url.split(".").pop().split("?").shift(),i.bypass||(e&&(e=d(e)?e:e[a]||e[g]||e[a.split("/").pop().split("?")[0]]),i.instead?i.instead(a,e,f,g,h):(y[i.url]?i.noexec=!0:y[i.url]=1,f.load(i.url,i.forceCSS||!i.forceJS&&"css"==i.url.split(".").pop().split("?").shift()?"c":c,i.noexec,i.attrs,i.timeout),(d(e)||d(j))&&f.load(function(){k(),e&&e(i.origUrl,h,g),j&&j(i.origUrl,h,g),y[i.url]=2})))}function h(a,b){function c(a,c){if(a){if(e(a))c||(j=function(){var a=[].slice.call(arguments);k.apply(this,a),l()}),g(a,j,b,0,h);else if(Object(a)===a)for(n in m=function(){var b=0,c;for(c in a)a.hasOwnProperty(c)&&b++;return b}(),a)a.hasOwnProperty(n)&&(!c&&!--m&&(d(j)?j=function(){var a=[].slice.call(arguments);k.apply(this,a),l()}:j[n]=function(a){return function(){var b=[].slice.call(arguments);a&&a.apply(this,b),l()}}(k[n])),g(a[n],j,b,n,h))}else!c&&l()}var h=!!a.test,i=a.load||a.both,j=a.callback||f,k=j,l=a.complete||f,m,n;c(h?a.yep:a.nope,!!i),i&&c(i)}var i,j,l=this.yepnope.loader;if(e(a))g(a,0,l,0);else if(w(a))for(i=0;i<a.length;i++)j=a[i],e(j)?g(j,0,l,0):w(j)?B(j):Object(j)===j&&h(j,l);else Object(a)===a&&h(a,l)},B.addPrefix=function(a,b){z[a]=b},B.addFilter=function(a){x.push(a)},B.errorTimeout=1e4,null==b.readyState&&b.addEventListener&&(b.readyState="loading",b.addEventListener("DOMContentLoaded",A=function(){b.removeEventListener("DOMContentLoaded",A,0),b.readyState="complete"},0)),a.yepnope=k(),a.yepnope.executeStack=h,a.yepnope.injectJs=function(a,c,d,e,i,j){var k=b.createElement("script"),l,o,e=e||B.errorTimeout;k.src=a;for(o in d)k.setAttribute(o,d[o]);c=j?h:c||f,k.onreadystatechange=k.onload=function(){!l&&g(k.readyState)&&(l=1,c(),k.onload=k.onreadystatechange=null)},m(function(){l||(l=1,c(1))},e),i?k.onload():n.parentNode.insertBefore(k,n)},a.yepnope.injectCss=function(a,c,d,e,g,i){var e=b.createElement("link"),j,c=i?h:c||f;e.href=a,e.rel="stylesheet",e.type="text/css";for(j in d)e.setAttribute(j,d[j]);g||(n.parentNode.insertBefore(e,n),m(c,0))}}(this,document),Modernizr.load=function(){yepnope.apply(window,[].slice.call(arguments,0))};
var RCBase64={keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(e){var t,r,s,o,i,n,a,h="",c=0;for(e=this.utf8_encode(e);c<e.length;)t=e.charCodeAt(c++),r=e.charCodeAt(c++),s=e.charCodeAt(c++),o=t>>2,i=(3&t)<<4|r>>4,n=(15&r)<<2|s>>6,a=63&s,isNaN(r)?n=a=64:isNaN(s)&&(a=64),h=h+this.keyStr.charAt(o)+this.keyStr.charAt(i)+this.keyStr.charAt(n)+this.keyStr.charAt(a);return h},decode:function(e){var t,r,s,o,i,n,a,h="",c=0;for(e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"");c<e.length;)o=this.keyStr.indexOf(e.charAt(c++)),i=this.keyStr.indexOf(e.charAt(c++)),n=this.keyStr.indexOf(e.charAt(c++)),a=this.keyStr.indexOf(e.charAt(c++)),t=o<<2|i>>4,r=(15&i)<<4|n>>2,s=(3&n)<<6|a,h+=String.fromCharCode(t),64!==n&&(h+=String.fromCharCode(r)),64!==a&&(h+=String.fromCharCode(s));return h=this.utf8_decode(h)},utf8_encode:function(e){e=e.replace(/\r\n/g,"\n");var t,r,s="";for(t=0;t<e.length;t++)r=e.charCodeAt(t),128>r?s+=String.fromCharCode(r):r>127&&2048>r?(s+=String.fromCharCode(r>>6|192),s+=String.fromCharCode(63&r|128)):(s+=String.fromCharCode(r>>12|224),s+=String.fromCharCode(r>>6&63|128),s+=String.fromCharCode(63&r|128));return s},utf8_decode:function(e){for(var t="",r=0,s=0,o=0,i=0;r<e.length;)s=e.charCodeAt(r),128>s?(t+=String.fromCharCode(s),r++):s>191&&224>s?(o=e.charCodeAt(r+1),t+=String.fromCharCode((31&s)<<6|63&o),r+=2):(o=e.charCodeAt(r+1),i=e.charCodeAt(r+2),t+=String.fromCharCode((15&s)<<12|(63&o)<<6|63&i),r+=3);return t}},RestClient;if(RestClient=function(){this.VERSION="0.1.9\n",this.authorization={},this.server={},this.response={},this.headers={},this.accessToken={},this.autoUseRefreshToken=!0,this.autoStoreAccessToken=!0,this.authorizationType="none",this.contentType="application/json",this.sendOAuthBearerAuthorization=!1,this.dataType="json",this.oauth2NeedsAuthorization=!0,this.expiredAccessTokenMessage="",this.restfulBehavior=!0,this.backupAJAXURL=null,this.acceptType=null,this.RESTMethods={create:"POST",read:"GET",update:"PUT","delete":"DELETE"},this.OAUTH2GrantTypes={code:"authorization_code",implicit:"token",user:"password",client:"client_credentials",refresh:"refresh_token"},RestClient.prototype.initObject.call(this)},RestClient.prototype.HTTP_SUCCESS=["200","201","202","204","207"],RestClient.prototype.HTTP_BAD_REQUEST=400,RestClient.prototype.HTTP_UNAUTHORIZED=401,RestClient.prototype.OAUTH2_INVALID_GRANT="invalid_grant",RestClient.prototype.initObject=function(){this.authorization={},this.server={},this.response={},this.headers={},this.accessToken={},this.autoUseRefreshToken=!0,this.autoStoreAccessToken=!0,this.authorizationType="none",this.contentType="application/json",this.acceptType="application/json",this.sendOAuthBearerAuthorization=!1,this.oauth2NeedsAuthorization=!0,this.dataType="json",this.expiredAccessTokenMessage="The access token provided has expired."},RestClient.prototype.setUseRefreshTokenAutomatically=function(e){return _.isBoolean(e)&&(this.autoUseRefreshToken=e),this},RestClient.prototype.setStoreAccessTokenAutomatically=function(e){return _.isBoolean(e)&&(this.autoStoreAccessToken=e),this},RestClient.prototype.setAuthorizationType=function(e){var t={none:1,basic:1,oauth2:1};return t[e]&&(this.authorizationType=e),this},RestClient.prototype.setContentType=function(e){return this.contentType=e,this},RestClient.prototype.setAcceptType=function(e){var t={plain:"text/plain",xhtml_xml:"application/xhtml+xml",json:"application/json",xml:"application/xml",all:"*/*"};return t[e]&&(this.acceptType=t[e]),this},RestClient.prototype.setSendBearerAuthorization=function(e){return _.isBoolean(e)&&(this.sendOAuthBearerAuthorization=e),this},RestClient.prototype.setOAuth2NeedsAuthorization=function(e){return _.isBoolean(e)&&(this.oauth2NeedsAuthorization=e),this},RestClient.prototype.setDataType=function(e){var t={json:"application/json",plain:"text/plain",form:"application/x-www-form-urlencoded",html:"text/html"};return t[e]&&(this.dataType=e,this.contentType=t[e]),this},RestClient.prototype.setAccessTokenExpiredMessage=function(e){return this.expiredAccessTokenMessage=e,this},RestClient.prototype.getVersion=function(){return this.VERSION},RestClient.prototype.setClient=function(e,t,r){return this.authorization.client_id=e,this.authorization.client_secret=t,this.authorization.client_url="undefined"!==r?r:null,this},RestClient.prototype.setGrantType=function(e,t){return this.authorization.grant_type="undefined"!==this.OAUTH2GrantTypes[e]?this.OAUTH2GrantTypes[e]:null,this.authorization=_.extend(this.authorization,t),this},RestClient.prototype.setAuthorizationServer=function(e){var t,r=!0;return"undefined"==typeof e||null===e?r=!1:(t=/(http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/,e.match(t)?this.server.rest_auth_uri=e:r=!1),r},RestClient.prototype.setHeader=function(e,t){var r,s=!0;return e&&t?(r=JSON.parse('{"'+e+'" :  "'+t+'"}'),this.headers=_.extend(this.headers,r)):s=!1,s},RestClient.prototype.JSONParse=function(e){var t;try{t=e?""===e?"":JSON.parse(e):""}catch(r){t="ERROR_PARSE"}return t},RestClient.prototype.setBasicCredentials=function(e,t){return this.authorization.basic_user=e,this.authorization.basic_password=t,this},RestClient.prototype.setAccessToken=function(e){return"object"==typeof e&&(this.accessToken=e),this},RestClient.prototype.setRestfulBehavior=function(e){return _.isBoolean(e)&&(this.restfulBehavior=e),this},RestClient.prototype.setBackupAjaxUrl=function(e){return this.backupAJAXURL=e,this},RestClient.prototype.toParams=function(e){var t=_.keys(e),r=[];return _.each(t,function(t){r.push(t+"="+e[t])}),r.join("&")},RestClient.prototype.prepareBody=function(e){var t="";return"json"===this.dataType||"jsonp"===this.dataType?"object"==typeof e&&(t=JSON.stringify(e)):t=this.toParams(e),t},RestClient.prototype.createXHR=function(){var e;if(window.XMLHttpRequest)e=new XMLHttpRequest;else try{e=new ActiveXObject("MSXML2.XMLHTTP")}catch(t){try{e=new ActiveXObject("Microsoft.XMLHTTP")}catch(r){}}return e?e:!1},RestClient.prototype.authorize=function(e){var t,r,s,o,i=this,n=!1,a="create",h=this.RESTMethods[a];t=RCBase64.encode(this.authorization.client_id+":"+this.authorization.client_secret),r=this.createXHR();try{r.open(h,this.server.rest_auth_uri,!1)}catch(c){return e.xhrfailure?e.xhrfailure(c,{}):this.XHRFailure(c,{}),n}if(r.onreadystatechange=function(){if(e.ready?e.ready(r):i.AuthorizeReady(r),4===r.readyState){if(o=i.JSONParse(r.responseText),-1!=i.HTTP_SUCCESS.indexOf(String(r.status))&&"ERROR_PARSE"!==o)if(i.autoStoreAccessToken&&(i.accessToken=o.token||{}),n=!0,e.success)try{e.success(r,o)}catch(t){throw new Error(t.message)}else i.AuthorizeSuccess(r,o);else if("ERROR_PARSE"===o&&(o={success:!1,error:{error:i.HTTP_BAD_REQUEST,error_description:"Response is not a valid JSON"}}),e.failure)try{e.failure(r,o)}catch(t){throw new Error(t.message)}else i.AuthorizeFailure(r,o);"function"==typeof e.complete&&e.complete(r,o)}},s={},this.authorization.grant_type)switch(s.grant_type=this.authorization.grant_type,this.authorization.grant_type){case"authorization_code":s.code=this.authorization.code;break;case"token":s.token=this.authorization.token;break;case"password":s.username=this.authorization.username,s.password=this.authorization.password;break;case"client_credentials":s.client_id=this.authorization.client_id,s.client_id=this.authorization.client_secret;break;case"refresh_token":s.refresh_token=this.authorization.refresh_token}return this.oauth2NeedsAuthorization&&r.setRequestHeader("Authorization","Basic "+t),r.setRequestHeader("Accept",this.acceptType),r.setRequestHeader("Content-Type",this.contentType),_.each(this.headers,function(e,t){r.setRequestHeader(t,e)}),r.send(this.prepareBody(s)),n},RestClient.prototype.prepareReqFields=function(e){var t;return t={success:!1,error:{error:this.HTTP_BAD_REQUEST,error_description:"Required fields not found"},fields:e}},RestClient.prototype.prepareConsumeUrl=function(e,t,r,s){var o,i,n=this.acceptType,a=this.contentType,h=!1;if(this.restfulBehavior)switch(e){case"read":o=t,r&&(o+=r),"oauth2"!==this.authorizationType||this.sendOAuthBearerAuthorization||(h=!0,o+="?access_token="+this.accessToken.access_token),s&&s!=={}&&(o+=h?"&":"?",o+=this.toParams(s)),i=null,null===a&&(a="application/json");break;case"create":o=t,i=s||{},"oauth2"!==this.authorizationType||this.sendOAuthBearerAuthorization||(i.access_token=this.accessToken.access_token),i=this.prepareBody(i);break;case"update":o=t,r&&(o+=r),i=s||{},"oauth2"!==this.authorizationType||this.sendOAuthBearerAuthorization||(i.access_token=this.accessToken.access_token),i=this.prepareBody(i);break;case"delete":o=t,r&&(o+=r),i=s||{},"oauth2"!==this.authorizationType||this.sendOAuthBearerAuthorization||(i.access_token=this.accessToken.access_token),i=this.prepareBody(i)}else o=this.backupAJAXURL,i={operation:e,url:t,id:r,data:s},i="data='"+encodeURIComponent(JSON.stringify(i))+"'",null===a&&(a="application/json");return n||(n="*/*"),{url:o,body:i,content_type:a,acceptType:n}},RestClient.prototype.getCall=function(e){return e.operation="read",this.consume(e)},RestClient.prototype.postCall=function(e){return e.operation="create",this.consume(e)},RestClient.prototype.putCall=function(e){return e.operation="update",this.consume(e)},RestClient.prototype.deleteCall=function(e){return e.operation="delete",this.consume(e)},RestClient.prototype.consume=function(e){var t,r,s,o,i,n,a,h,c,u,p,l,d,f,y,R={},T=!0,C=[],A=!1;if(e.operation?s=e.operation:(T=!1,C.push("operation")),e.url?c=e.url:(T=!1,C.push("url")),u=e.data||null,p=e.id||null,!T)return e.failure?e.failure(null,this.prepareReqFields(C)):this.ConsumeFailure(null,this.prepareReqFields(C)),T;l=this.prepareConsumeUrl(s,c,p,u),n=l.url,i=l.body,f=l.content_type,y=l.acceptType,r=this.createXHR(),o=this.restfulBehavior?this.RESTMethods[s]:this.RESTMethods.create;try{switch(r.open(o,n,!1),this.authorizationType){case"none":break;case"basic":t=RCBase64.encode(this.authorization.basic_user+":"+this.authorization.basic_password),r.setRequestHeader("Authorization","Basic "+t);break;case"oauth2":if(!this.accessToken.access_token)return T=!1,C.push("access_token"),h={success:!1,error:{error:this.HTTP_BAD_REQUEST,error_description:"Access Token not defined"}},e.failure?e.failure(null,this.prepareReqFields(C)):this.ConsumeFailure(null,this.prepareReqFields(C)),T;this.sendOAuthBearerAuthorization&&(d="Bearer "+this.accessToken.access_token,r.setRequestHeader("Authorization",d))}}catch(k){return e.xhrfailure?e.xhrfailure(k,u):this.XHRFailure(k,u),!1}return a=this,r.onreadystatechange=function(){if(e.ready?e.ready(r):a.ConsumeReady(r),4===r.readyState){if(R=a.JSONParse(r.responseText),-1!=a.HTTP_SUCCESS.indexOf(String(r.status))&&"ERROR_PARSE"!==R)if(a.autoStoreAccessToken&&(a.accessToken=R.token||{}),T=!0,e.success)try{e.success(r,R)}catch(t){throw new Error(t.message)}else a.AuthorizeSuccess(r,R);else if(T=!1,"ERROR_PARSE"===R?R={success:!1,error:{error:a.HTTP_BAD_REQUEST,error_description:"Response is not a valid JSON"}}:(R.error===a.OAUTH2_INVALID_GRANT&&R.error_description===a.expiredAccessTokenMessage&&(A=!0),r.status===a.HTTP_UNAUTHORIZED&&a.autoUseRefreshToken&&A&&(a.accessToken.refresh_token?(a.setGrantType("refresh",{refresh_token:a.accessToken.refresh_token}),a.authorize({success:function(){T=a.consume(e),T&&(e.autorefresh?e.autorefresh(a.accessToken):a.AuthorizeAutoRefresh(a.accessToken))},failure:function(t,r){T=!1,e.failure?e.failure(null,r):a.ConsumeFailure(null,r)}})):(T=!1,R={success:!1,error:{error:a.HTTP_UNAUTHORIZED,error_description:"Refresh token is not defined"}}))),e.failure)try{e.failure(r,R)}catch(t){throw new Error(t.message)}else a.AuthorizeFailure(r,R);"function"==typeof e.complete&&e.complete(r,R)}},r.setRequestHeader("Accept",y),r.setRequestHeader("Content-Type",f),_.each(this.headers,function(e,t){r.setRequestHeader(t,e)}),r.send(i),T},RestClient.prototype.XHRFailure=function(){},RestClient.prototype.AuthorizeSuccess=function(){},RestClient.prototype.AuthorizeFailure=function(){},RestClient.prototype.AuthorizeReady=function(){},RestClient.prototype.AuthorizeAutoRefresh=function(){},RestClient.prototype.ConsumeSuccess=function(){},RestClient.prototype.ConsumeFailure=function(){},RestClient.prototype.ConsumeReady=function(){},"undefined"!=typeof exports){module.exports={RestClient:RestClient,RCBase64:RCBase64};var _=require("underscore")}
/**
 * @class PMUI
 * Base class PMUI
 * @singleton
 */
var PMUI = {},
    getUsersOS;
/**
 * Detect the users' OS
 * @return {string}
 */
getUsersOS = function () {
    var userAgent = window.navigator.userAgent,
        platform = window.navigator.platform,
        macOsPlatforms = ['Macintosh', 'MacIntel', 'MacPPC', 'Mac68K'],
        windowsPlatforms = ['Win32', 'Win64', 'Windows', 'WinCE'],
        iosPlatforms = ['iPhone', 'iPad', 'iPod'],
        os = null;

    if (macOsPlatforms.indexOf(platform) !== -1) {
        os = 'MacOS';
    } else if (iosPlatforms.indexOf(platform) !== -1) {
        os = 'iOS';
    } else if (windowsPlatforms.indexOf(platform) !== -1) {
        os = 'Windows';
    } else if (/Android/.test(userAgent)) {
        os = 'Android';
    } else if (!os && /Linux/.test(platform)) {
        os = 'Linux';
    }
    return os;
};

PMUI.version = '0.1.1';
PMUI.isCtrl = false;
PMUI.isAlt = false;
PMUI.isShift = false;
PMUI.metaKey = false;
PMUI.activeCanvas = null;
PMUI.currentContextMenu = null;
PMUI.keyCodeF5 = 116;
PMUI.keyDown = false;
PMUI.isDelete = false;
PMUI.OS = getUsersOS();

$(document).keydown(function (e) {
    var elementSelected,
        flowSelected;
    if (PMUI.activeCanvas) {
        elementSelected = PMUI.activeCanvas.getCurrentSelection();
        flowSelected = PMUI.activeCanvas.getCurrentConnection();
        switch (e.which) {
            case 8: //BACKSPACE
                if (PMUI.metaKey && PMUI.OS === "MacOS" && !PMUI.activeCanvas.readOnly &&
                    (elementSelected.asArray().length !== 0 || flowSelected !== null) && !PMUI.isDelete) {
                    if (PMUI.activeCanvas && !PMUI.activeCanvas.currentLabel) {
                        PMUI.isDelete = true;
                        PMUI.activeCanvas.removeElements();
                    }
                }
                break;
            case 16: // SHIFT KEY
                PMUI.isShift = true;
                break;
            case 17: // CTRL KEY
                if (!PMUI.isAlt) {
                    PMUI.isCtrl = true;
                } else if (PMUI.OS !== "MacOS") {
                    PMUI.isAlt = false;
                    PMUI.isCtrl = false;
                }
                break;
            case 18: //ALT KEY
                if (!PMUI.isCtrl) {
                    PMUI.isAlt = true;
                } else if (PMUI.OS !== "MacOS") {
                    PMUI.isCtrl = false;
                    PMUI.isAlt = false;
                }
                break;
            case 116: // F5 KEY
                e.preventDefault();
                window.location.reload(true);
                break;
            case 91: //meta key - window key - command key
                PMUI.metaKey = true;
                break;
            case 37:
                // Left
                if (!PMUI.activeCanvas.currentLabel && !PMUI.isDelete) {
                    e.preventDefault();
                    if (!PMUI.getCoordinatesElement(elementSelected.asArray(), "LEFT")) {
                        PMUI.activeCanvas.moveElements(PMUI.activeCanvas, 'LEFT');
                    }
                }
                break;
            case 38:
                // Top
                if (!PMUI.activeCanvas.currentLabel && !PMUI.isDelete) {
                    e.preventDefault();
                    if (!PMUI.getCoordinatesElement(elementSelected.asArray(), "TOP")) {
                        PMUI.activeCanvas.moveElements(PMUI.activeCanvas, 'TOP');
                    }
                }
                break;
            case 39:
                // Right
                if (!PMUI.activeCanvas.currentLabel && !PMUI.isDelete) {
                    e.preventDefault();
                    if (!PMUI.getCoordinatesElement(elementSelected.asArray(), "RIGHT")) {
                        PMUI.activeCanvas.moveElements(PMUI.activeCanvas, 'RIGHT');
                    }
                }
                break;
            case 40:
                // Bottom
                if (!PMUI.activeCanvas.currentLabel && !PMUI.isDelete) {
                    e.preventDefault();
                    if (!PMUI.getCoordinatesElement(elementSelected.asArray(), "BOTTOM")) {
                        PMUI.activeCanvas.moveElements(PMUI.activeCanvas, 'BOTTOM');
                    }
                }
                break;
            case 67:    // char 'c'
                if (!PMUI.activeCanvas.currentLabel && PMUI.isCtrl) {
                    if (PMUI.activeCanvas.copyAndPaste) {
                        e.preventDefault();
                        PMUI.activeCanvas.copy();
                    }
                }
                break;
            case 86:    // char 'v'
                if (!PMUI.activeCanvas.currentLabel && PMUI.isCtrl) {
                    if (PMUI.activeCanvas.copyAndPaste) {
                        e.preventDefault();
                        PMUI.activeCanvas.paste();
                    }
                }
                break;
            case 90:    // char 'z'
                if ((PMUI.isCtrl && PMUI.OS !== "MacOS") || (PMUI.metaKey && PMUI.OS === "MacOS")
                    && !PMUI.activeCanvas.readOnly) {
                    if (PMUI.isShift) {
                        // ctrl + shift + z (redo)
                        PMUI.activeCanvas.redo();
                        e.preventDefault();
                    } else {
                        // ctrl + z (undo)
                        PMUI.activeCanvas.undo();
                        e.preventDefault();
                    }
                }
                break;
            case 46: //Delete Key - Don't go to default.
                if (!PMUI.isCtrl && !PMUI.isAlt && !PMUI.metaKey && PMUI.activeCanvas && !PMUI.keyDown &&
                    !PMUI.activeCanvas.currentLabel && !PMUI.activeCanvas.readOnly && !PMUI.isDelete &&
                    (elementSelected.asArray().length !== 0 || flowSelected !== null)) {
                    PMUI.isDelete = true;
                    PMUI.activeCanvas.removeElements();
                }
                break;
            default:
                PMUI.keyDown = true;
                break;
        }
    }
}).keypress(function (e) {

}).keyup(function (e) {
    var current;
    if (PMUI.activeCanvas) {
        e.preventDefault();
        switch (e.which) {
            case 8: //BACKSPACE
                if (PMUI.metaKey && PMUI.OS === "MacOS" && !PMUI.activeCanvas.readOnly) {
                    if (PMUI.activeCanvas && !PMUI.activeCanvas.currentLabel) {
                        PMUI.activeCanvas.removeElements();
                    }
                }
                break;
            case 13: // ENTER
                if (PMUI.activeCanvas && PMUI.activeCanvas.currentLabel) {
                    PMUI.activeCanvas.currentLabel.loseFocus();
                }
                PMUI.keyDown = false;
                break;
            case 91: // META KEY
                PMUI.metaKey = false;
                break;
            case 16: // SHIFT KEY
                PMUI.isShift = false;
                break;
            case 17: //CTRL KEY
                PMUI.isCtrl = false;
                break;
            case 18: //ALT KEY
                PMUI.isAlt = false;
                break;
            case 46:
                //PMUI.isDelete = false;
                break;
            case 113: //F2 KEY
                if (PMUI.activeCanvas &&
                    PMUI.activeCanvas.getCurrentSelection().getLast() !== null) {
                    //Run other code here when the element
                    // 'CurElement' is deleted
                    current = PMUI.activeCanvas.getCurrentSelection().getLast();
                    if (current !== undefined && current.label.html !== null) {
                        $(current.label.html).dblclick();
                        $(current.label.text.html).focus();
                    }
                }
                break;
            default:
                PMUI.keyDown = false;
                break;
        }
    }

});


/**
 * Extends the PMUI namespace with the given `path` and making a pointer
 * from `path` to the given `class` (note that the `path`'s last token will be the pointer visible from outside
 * the definition of the class).
 *
 *      // e.g.
 *      // let's define a class inside an anonymous function
 *      // so that the global scope is not polluted
 *      (function () {
 *          var Canvas = function () {...};
 *
 *          // let's extend the namespace
 *          PMUI.extendNamespace('PMUI.core.Panel', Canvas);
 *
 *      }());
 *
 *      // now PMDraw.draw.Canvas is a pointer to the class defined above
 *
 *  Another example:
 *
 *      // let's define a class inside an anonymous function
 *      // so that the global scope is not polluted
 *      (function () {
 *          var Shape = function () {...};
 *
 *          // let's extend the namespace
 *          PMUI.extendNamespace('PMUI.draw.RandomName', Shape);
 *
 *      }());
 *
 *      // now PMUI.draw.RandomName is a pointer to the class Shape
 *      // note that this class can only be accessed through this pointer
 *
 * @param {string} path
 * @param {Object} newClass
 * @return {Object} The argument `newClass`
 */
PMUI.extendNamespace = function (path, newClass) {
    var current,
        pathArray,
        extension,
        i;

    if (arguments.length !== 2) {
        throw new Error("PMUI.extendNamespace(): method needs 2 arguments");
    }

    pathArray = path.split('.');
    if (pathArray[0] === 'PMUI') {
        pathArray = pathArray.slice(1);
    }
    current = PMUI;

    // create the 'path' namespace
    for (i = 0; i < pathArray.length - 1; i += 1) {
        extension = pathArray[i];
        if (typeof current[extension] === 'undefined') {
            current[extension] = {};
        }
        current = current[extension];
    }

    extension = pathArray[pathArray.length - 1];
    if (current[extension]) {
    }
    current[extension] = newClass;
    return newClass;
};
/**
 * Checks if `path` (a string separated with dots) is a valid path inside the `from` object if provided otherwise
 * checks if `path` is a valid path inside the {@link PMUI} object,
 * if so then returns a pointer to the object which is the last token of the string
 *
 *      // e.g
 *      validPath('PMDraw.event.Keyboard.modifiers.alt');    // returns a pointer to alt
 *      validPath('modifiers.alt', PMUI.event.Keyboard);   // returns a pointer to alt
 *
 * @param {string} path
 * @param {Object} [from]
 * @return {Object}
 */
PMUI.validPath = function (path, from) {
    var pathArray = path.split('.'),
        current,
        extension,
        i;

    if (!from) {
        if (pathArray[0] === 'PMUI') {
            pathArray = pathArray.slice(1);
        }
        current = PMUI;
    } else {
        current = from;
    }
    for (i = 0; i < pathArray.length; i += 1) {
        extension = pathArray[i];
        if (!current[extension]) {
            return null;
        }
        current = current[extension];
    }
    return current;
};

/**
 * Creates an object whose [[Prototype]] link points to an object's prototype (the object is gathered using the
 * argument `path` and it's the last token in the string), since `subClass` is given it will also mimic the
 * creation of the property `constructor` and a pointer to its parent called `superclass`:
 *
 *      // constructor pointer
 *      subClass.prototype.constructor === subClass       // true
 *
 *      // let's assume that superClass is the last token in the string 'path'
 *      subClass.superclass === superClass         // true
 *
 * An example of use:
 *
 *      (function () {
 *          var Core = function () {...};
 *
 *          // extending the namespace
 *          PMDraw.extendNamespace('PMDraw.draw.Core', Core);
 *
 *      }());
 *
 *      (function () {
 *          var BehavioralElement = function () {...};
 *
 *          // this class inherits from PMDraw.draw.Core
 *          PMDraw.inheritFrom('PMDraw.draw.Core', BehavioralElement);
 *
 *          // extending the namespace
 *          PMDraw.extendNamespace('PMDraw.draw.BehavioralElement', BehavioralElement);
 *
 *      }());
 *
 * @param {string} path
 * @param {Object} subClass
 * @return {Object}
 */
PMUI.inheritFrom = function (path, subClass) {
    var current,
        extension,
        pathArray,
        i,
        prototype;

    if (arguments.length !== 2) {
        throw new Error("PMUI.inheritFrom(): method needs 2 arguments");
    }

    // function used to create an object whose [[Prototype]] link
    // points to `object`
    function clone(object) {
        var F = function () {
        };
        F.prototype = object;
        return new F();
    }

    pathArray = path.split('.');
    if (pathArray[0] === 'PMUI') {
        pathArray = pathArray.slice(1);
    }
    current = PMUI;

    // find that class the 'path' namespace
    for (i = 0; i < pathArray.length; i += 1) {
        extension = pathArray[i];
        if (typeof current[extension] === 'undefined') {
            throw new Error("PMUI.inheritFrom(): object " + extension + " not found, full path was " + path);
        }
        current = current[extension];
    }

    prototype = clone(current.prototype);

    prototype.constructor = subClass;
    subClass.prototype = prototype;
    subClass.superclass = current;
};

/**
 * Generates 32-digits alphanumeric unique IDs
 * @return {String} Alphanumeric 32-char unique string
 */
PMUI.generateUniqueId = function () {
    var rand = function (min, max) {
            // Returns a random number
            //
            // version: 1109.2015
            // discuss at: http://phpjs.org/functions/rand
            // +   original by: Leslie Hoare
            // +   bugfixed by: Onno Marsman
            // %          note 1: See the commented out code below for a
            // version which will work with our experimental
            // (though probably unnecessary) srand() function)
            // *     example 1: rand(1, 1);
            // *     returns 1: 1

            // fix for jsLint
            // from: var argc = arguments.length;
            if (typeof min === "undefined") {
                min = 0;
            }
            if (typeof max === "undefined") {
                max = 999999999;
            }
            return Math.floor(Math.random() * (max - min + 1)) + min;
        },
        uniqid = function (prefix, more_entropy) {
            // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
            // +    revised by: Kankrelune (http://www.webfaktory.info/)
            // %        note 1: Uses an internal counter (in php_js global) to avoid collision
            // *     example 1: uniqid();
            // *     returns 1: 'a30285b160c14'
            // *     example 2: uniqid('foo');
            // *     returns 2: 'fooa30285b1cd361'
            // *     example 3: uniqid('bar', true);
            // *     returns 3: 'bara20285b23dfd1.31879087'
            if (typeof prefix === 'undefined') {
                prefix = "";
            }

            var retId,
                formatSeed = function (seed, reqWidth) {
                    var tempString = "",
                        i;
                    seed = parseInt(seed, 10).toString(16); // to hex str
                    if (reqWidth < seed.length) { // so long we split
                        return seed.slice(seed.length - reqWidth);
                    }
                    if (reqWidth > seed.length) { // so short we pad
                        // jsLint fix
                        tempString = "";
                        for (i = 0; i < 1 + (reqWidth - seed.length); i += 1) {
                            tempString += "0";
                        }
                        return tempString + seed;
                    }
                    return seed;
                };

            // BEGIN REDUNDANT
            if (!this.php_js) {
                this.php_js = {};
            }
            // END REDUNDANT
            if (!this.php_js.uniqidSeed) { // init seed with big random int
                this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
            }
            this.php_js.uniqidSeed += 1;

            retId = prefix; // start with prefix, add current milliseconds hex string
            retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
            retId += formatSeed(this.php_js.uniqidSeed, 5); // add seed hex string
            if (more_entropy) {
                // for more entropy we add a float lower to 10
                retId += (Math.random() * 10).toFixed(8).toString();
            }

            return retId;
        },
        sUID;

    do {
        sUID = uniqid(rand(0, 999999999), true);
        sUID = sUID.replace('.', '0');
    } while (sUID.length !== 32);

    return sUID;
};

/**
 * Creates and returns a HTML element
 * @param  {String} type The type for the element to be created, for example: div, span, p
 * @return {HTMLElement}    An HTML element
 */
PMUI.createHTMLElement = function (type) {
    return document.createElement(type);
};

/**
 * Calculates the text width usign a font family
 * @param {String} text The text which width will be calculated
 * @param {String} font The font family and size (expressed as the 'font' css properties)
 * to be used to calculate the width
 * @return {Number}
 */
PMUI.calculateWidth = function (text, font) {
    var f = font || '12px arial',
        $o = $(this.createHTMLElement('div')), w;
    $o.text(text)
        .css({'position': 'absolute', 'float': 'left', 'white-space': 'nowrap', 'visibility': 'hidden', 'font': f})
        .appendTo($('body'));
    w = $o.width();

    $o.remove();

    return w;
};

PMUI.emToPx = function (emUnits, context) {
    var testDiv = PMUI.createHTMLElement('div'), theWidth, $div;

    testDiv.style.margin = '0';
    testDiv.style.padding = '0';
    testDiv.style.position = 'absolute';
    testDiv.style.display = 'inline-block';
    testDiv.style.backgroundColor = 'none';
    testDiv.style.width = emUnits + "em";
    context = PMUI.isHTMLElement(context) ? context : document.body;
    if (context !== document.body && !jQuery(context).parents('body').length) {
        throw new Error("The context must be an HTML element appended to the DOM.");
    }
    context.appendChild(testDiv);
    $div = jQuery(testDiv);
    theWidth = $div.outerWidth();
    $div.remove();
    return theWidth;
};

/**
 * Get PMUI Version.
 * @return {String}
 */
PMUI.getVersion = function () {
    return this.version;
};

/**
 * Trigger events defined in the element
 * @param  {PMUI.core.Element} el Element associated with the event
 * @param  {String} eventName Event Name or alias
 * @param  {Object} scope  Calling scope for the event
 */
PMUI.triggerEvent = function (el, eventName, scope) {
    var scopeTrigger = scope || this;
    if (el instanceof PMUI.core.Element) {
        if (el.events[eventName] instanceof PMUI.event.Event) {
            el.events[eventName].handler.call(scopeTrigger);
        } else {
            throw new Error('Event name is not registered int this element');
        }
    } else {
        throw new Error('Current Element is not able to trigger events');
    }
};

/**
 * Sets the active canvas.
 * @param {PMUI.draw.Canvas} canvas
 * @chainable
 */
PMUI.setActiveCanvas = function (canvas) {
    PMUI.activeCanvas = canvas;
    return this;
};
/**
 * Gets the active canvas
 * @return {PMUI.draw.Canvas}
 */
PMUI.getActiveCanvas = function () {
    return PMUI.activeCanvas;
};

/**
 * Converts the coordinates `xCoord` and `yCoord` (assuming that xCoord and yCoord are pageCoordinates)
 * or the page coordinates gathered from the object `e` if there is no `xCoord` or `yCoord` to
 * `shape` coordinates, this new coordinate also considers the scroll done in the canvas
 *
 *      // e.g.
 *      // Let's assume that:
 *      // the canvas coordinates are [100, 100] and that it has no scroll
 *      // the shape coordinates are [100, 100] (inside the canvas)
 *      // e is an object containing page.X = 300, page.Y = 300
 *      Utils.pageCoordinatesToShapeCoordinates(shape, e)  // new Point(100, 100) respect to the shape
 *
 *
 * @param {Object} shape
 * @param {Object} e
 * @param {number} [xCoord]
 * @param {number} [yCoord]
 * @return {PMUI.util.Point} a point relative to the canvas
 */
PMUI.pageCoordinatesToShapeCoordinates = function (shape, e, xCoord, yCoord, customShape) {
    var coordinates,
        x = (!xCoord) ? e.pageX : xCoord,
        y = (!yCoord) ? e.pageY : yCoord,
        orgX = (!xCoord) ? e.pageX : xCoord,
        orgY = (!yCoord) ? e.pageY : yCoord,
        canvas = shape.getCanvas();
    x += canvas.getLeftScroll() - shape.getAbsoluteX() - canvas.getX();
    y += canvas.getTopScroll() - shape.getAbsoluteY() - canvas.getY();
    if (orgX === x) {
        x -= parseInt(customShape.width / 2, 10);
    }
    if (orgY === y) {
        y -= parseInt(customShape.height / 2, 10);
    }
    coordinates = new PMUI.util.Point(x, y);
    return coordinates;
};
/**
 * Validates the parameters that represents the coordinates for create a new shape
 * @param  {Object} canvas      Represents the current canvas for the project
 * @param  {Object} e           Represents the event that triggered on the event
 * @param  {Object} customShape Represents the object that will create a new element on the canvas
 * @return {Boolean} flag       After the review of the coordinates the method return true if the component
 * will create on the canvas and false if not possible create it.
 */
PMUI.validCoordinatedToCreate = function (canvas, e, customShape) {
    return function (canvas, e, customShape) {
        return true;
    };
};
/**
 * Converts the coordinates of the `shape` to page coordinates, this method
 * also considers the scroll of the canvas in the calculation
 *
 *      // e.g.
 *      // Let's assume that:
 *      // the canvas coordinates are [100, 100] and that it has no scroll
 *      // the shape coordinates are [100, 100] (inside the canvas)
 *      Utils.getPointRelativeToPage(shape)     // new Point(200, 200) respect to the page
 *
 * @param {Object} shape
 * @return {PMUI.util.Point} a point relative to the page
 */
PMUI.getPointRelativeToPage = function (shape) {
    var canvas = shape.getCanvas(),
        x = shape.absoluteX + canvas.getX() - canvas.getLeftScroll() +
            shape.zoomWidth / 2,
        y = shape.absoluteY + canvas.getY() - canvas.getTopScroll() +
            shape.zoomHeight / 2;
    return new PMUI.util.Point(x, y);
};

PMUI.json2xml = function (o) {
    var len,
        toXML,
        safeXMLValue,
        a;

    len = function (o) {
        var n = 0,
            a;
        for (a in o) {
            if (o.hasOwnProperty(a)) {
                n += 1;
            }
        }
        return n;
    };

    toXML = function (tag, o) {
        var a,
            b,
            doc = '<' + tag,
            sw = false,
            i;

        if (typeof o === 'undefined' || o === null) {
            doc += '/>';
            return doc;
        }
        if (typeof o !== 'object') {
            doc += '>' + safeXMLValue(o) + '</' + tag + '>';
            return doc;
        }
        if (o.constructor === Object) {
            for (a in o) {
                if (o.hasOwnProperty(a)) {
                    if (a.charAt(0) === '@') {
                        if (typeof o[a] !== 'object') {
                            doc += ' ' + a.substring(1) + '="' + o[a] + '"';
                            delete o[a];
                        } else {
                            throw new Error((typeof o[a])
                                + ' being attribute is not supported.');
                        }
                    }
                }
            }
            if (len(o) === 0) {
                doc += '/>';
                sw = true;
            } else {
                doc += '>';
            }
            if (sw) {
                return doc;
            }
            if (typeof o['#text'] !== 'undefined') {
                if (typeof o['#text'] !== 'object') {
                    doc += o['#text'];
                    delete o['#text'];
                } else {
                    throw new Error((typeof o['#text'])
                        + ' being #text is not supported.');
                }
            }
            for (b in o) {
                if (o.hasOwnProperty(b)) {
                    if (o[b].constructor === Array) {
                        for (i = 0; i < o[b].length; i += 1) {
                            if (typeof o[b][i] !== 'object'
                                || o[b][i].constructor === Object) {
                                doc += toXML(b, o[b][i]);
                            } else {
                                throw new Error((typeof o[b][i])
                                    + ' is not supported.');
                            }
                        }
                    } else if (o[b].constructor === Object
                        || typeof o[b] !== 'object') {
                        doc += toXML(b, o[b]);
                    } else {
                        throw new Error((typeof o[b]) + ' is not supported.');
                    }
                }
            }
            doc += '</' + tag + '>';
            return doc;
        }


    };

    safeXMLValue = function (value) {
        var s = value.toString();
        s = s.replace(/\&/g, '&amp;');
        s = s.replace(/\"/g, '&quot;');
        s = s.replace(/</g, '&lt;');
        s = s.replace(/>/g, '&gt;');
        return s;
    };

    if (typeof o === 'object' && o.constructor === Object && len(o) === 1) {
        for (a in o) {
            if (o.hasOwnProperty(a)) {
                return toXML(a, o[a]);
            }
        }
    }

};

PMUI.linkToPMUIObject = function (element, pmuiObject) {
    if (this.isHTMLElement(element) && pmuiObject instanceof PMUI.core.Element) {
        jQuery(element).data('pmui', pmuiObject);
    } else {
        throw new Error("PMUI.linkToPMUIObject(): the first parameter must be a HTMLElement and the second one must be "
            + "an instance of PMUI.core.Element.");
    }
};

PMUI.getPMUIObject = function (element) {
    if (this.isHTMLElement(element)) {
        return jQuery(element).data("pmui");
    }
    throw new Error("PMUI.getPMUIObject(): the parameter must be a HTMLElement.");
};

PMUI.isHTMLElement = function (obj) {
    try {
        //Using W3 DOM2 (works for FF, Opera and Chrom)
        return obj instanceof HTMLElement;
    }
    catch (e) {
        //Browsers not supporting W3 DOM2 don't have HTMLElement and
        //an exception is thrown and we end up here. Testing some
        //properties that all elements have. (works on IE7)
        return (typeof obj === "object") &&
            (obj.nodeType === 1) && (typeof obj.style === "object") &&
            (typeof obj.ownerDocument === "object");
    }
};
PMUI.removeCurrentMenu = function () {
    if (PMUI.currentContextMenu && PMUI.currentContextMenu.displayed) {
        PMUI.currentContextMenu.hide();
        PMUI.currentContextMenu = null;
    }
};
PMUI.init = function () {
    String.prototype.translate = PMUI.lang.I18N.translate;
    String.prototype.translateContext = PMUI.lang.I18N.translateContext;

    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (elt /*, from*/) {
            var len = this.length >>> 0;

            var from = Number(arguments[1]) || 0;
            from = (from < 0)
                ? Math.ceil(from)
                : Math.floor(from);
            if (from < 0)
                from += len;

            for (; from < len; from += 1) {
                if (from in this &&
                    this[from] === elt)
                    return from;
            }
            return -1;
        };
    }
    return this;
};

PMUI.loadLanguage = function (data, lang, loaded) {
    PMUI.lang.I18N.loadLanguage(data, lang, loaded);
    return this;
};

PMUI.setCurrentLanguage = function (lang) {
    PMUI.lang.I18N.setCurrentLanguage(lang);
    return this;
};

PMUI.setDefaultLanguage = function (lang) {
    PMUI.lang.I18N.setDefaultLanguage(lang);
    return this;
};

PMUI.convertDateFormat = function (dateInput) {
    //TODO Implement this method considering locate options
    return dateInput;
};

PMUI.castValue = function (value, format) {
    try {
        switch (format) {
            case 'string':
                out = String(value);
                break;
            case 'number':
                if (value != '') {
                    out = Number(value);
                } else {
                    out = 'NaN';
                }
                break;
            case 'date':
                out = PMUI.convertDateFormat(value);
                break;
            case 'boolean':
                out = Boolean(value);
                break;
            default:
                out = value;
        }
        return out;
    } catch (e) {
        throw new Error("The value cannot be showed in '" + format + "' format");
    }
};
/**
 * validates that the items do not leave the parent container
 * @param elements array of items selecteds
 * @param direction string of cursor key
 * @returns {boolean}
 */
PMUI.getCoordinatesElement = function (elements, direction) {
    var element,
        factorPixel,
        swError,
        factorZoom,
        ParentPoints,
        ShapePoints,
        limitTop,
        limitRight,
        limitBottom,
        limitLeft;

    swError = false;
    if (elements.length > 0) {
        if (elements[0].parent.parent !== null) {
            element = elements[0];
            factorPixel = [4, 4, 4, 2];
            factorZoom = element.getCanvas().getZoomFactor();
            ParentPoints = PMUI.getCoordenatesParent(element.parent, factorZoom);
            ShapePoints = PMUI.getAbsoluteShape(elements, factorZoom);
            limitTop = ParentPoints.PInit.getY() + (factorPixel[0] * factorZoom);
            limitRight = ParentPoints.PFinal.getX() - (factorPixel[1] * factorZoom);
            limitBottom = ParentPoints.PFinal.getY() - (factorPixel[2] * factorZoom);
            limitLeft = ParentPoints.PInit.getX() + (factorPixel[3] * factorZoom);
            switch (direction) {
                case 'TOP':
                    if (limitTop > ShapePoints.PInit.getY()) {
                        swError = true;
                    }
                    break;
                case 'RIGHT':
                    if (limitRight < ShapePoints.PFinal.getX()) {
                        swError = true;
                    }
                    break;
                case 'BOTTOM':
                    if (limitBottom < ShapePoints.PFinal.getY()) {
                        swError = true;
                    }
                    break;
                case 'LEFT':
                    if (limitLeft > ShapePoints.PInit.getX()) {
                        swError = true;
                    }
                    break;
            }
        }
    }

    return swError;
};
/**
 * Get the parent coordenates
 * @param parent Object parent of the item selected
 * @param factorZoom
 * @returns {Object of Objects Point}
 */
PMUI.getCoordenatesParent = function (parent, factorZoom) {
    var coordenatesParent,
        xInit,
        yInit,
        xFinal,
        yFinal,
        pointInit,
        pointFinal,
        headParent;

    headParent = 0;
    if (parent.type === "PMPool") {
        headParent = parent.headLineCoord * factorZoom;
    }
    xInit = parent.getAbsoluteX() + headParent;
    yInit = parent.getAbsoluteY();
    xFinal = parent.getAbsoluteX() + (parent.getWidth() * factorZoom);
    yFinal = parent.getAbsoluteY() + (parent.getHeight() * factorZoom);
    pointInit = new PMUI.util.Point(xInit, yInit);
    pointFinal = new PMUI.util.Point(xFinal, yFinal);
    coordenatesParent = {
        "PInit": pointInit,
        "PFinal": pointFinal
    };

    return coordenatesParent;
};
/**
 * Get coordenates min y max of the items selecteds
 * @param shapes Array of items selecteds
 * @param factorZoom
 * @returns {Object of Objects Point}
 */
PMUI.getAbsoluteShape = function (shapes, factorZoom) {
    var coordenatesShapeAux,
        coordenatesShape,
        arrayShapesAux = [],
        pointShapeInit,
        pointShapeFinal,
        shape,
        xFinalAux,
        yFinalAux,
        i;

    for (i = 0; i < shapes.length; i += 1) {
        shape = shapes[i];
        xFinalAux = shape.getAbsoluteX() + (shape.getWidth() * factorZoom);
        yFinalAux = shape.getAbsoluteY() + (shape.getHeight() * factorZoom);
        pointShapeInit = new PMUI.util.Point(shape.getAbsoluteX(), shape.getAbsoluteY());
        pointShapeFinal = new PMUI.util.Point(xFinalAux, yFinalAux);
        coordenatesShapeAux = {
            "PInit": pointShapeInit,
            "PFinal": pointShapeFinal
        };
        arrayShapesAux.push(coordenatesShapeAux);
    }
    coordenatesShape = PMUI.getMinMaxCoordenates(arrayShapesAux);
    return coordenatesShape;
};
/**
 * Get the Min y Max coordenates of a array of Objects Point
 * @param coordenates array of Objects Point
 * @returns {Object of Objects Point}
 */
PMUI.getMinMaxCoordenates = function (coordenates) {
    var objectCoordenates,
        xInit,
        yInit,
        xFinal,
        yFinal,
        j;

    xInit = coordenates[0].PInit.getX();
    yInit = coordenates[0].PInit.getY();
    xFinal = coordenates[0].PFinal.getX();
    yFinal = coordenates[0].PFinal.getY();

    for (j = 0; j < coordenates.length; j += 1) {
        if (coordenates[j].PInit.getX() < xInit) {
            xInit = coordenates[j].PInit.getX();
        }
        if (coordenates[j].PInit.getY() < yInit) {
            yInit = coordenates[j].PInit.getY();
        }
        if (coordenates[j].PFinal.getX() > xFinal) {
            xFinal = coordenates[j].PFinal.getX();
        }
        if (coordenates[j].PFinal.getY() > yFinal) {
            yFinal = coordenates[j].PFinal.getY();
        }
    }

    objectCoordenates = {
        "PInit": new PMUI.util.Point(xInit, yInit),
        "PFinal": new PMUI.util.Point(xFinal, yFinal)
    };

    return objectCoordenates;
};

PMUI.isInDOM = function (html) {
    var targetHTML = html instanceof PMUI.core.Element ? html.html : html,
        aux;

    if (targetHTML === null) {
        return false;
    } else if (!PMUI.isHTMLElement(targetHTML)) {
        throw new Error('isInDOM(): invalid parameter, only HTML or instance of PMUI.core.Element are allowed.');
    }

    aux = jQuery(html).parents('html')[0];
    return !!aux && aux.parentNode === document;
};

String.prototype.capitalize = function () {
    return this.toLowerCase().replace(/(^|\s)([a-z])/g, function (m, p1, p2) {
        return p1 + p2.toUpperCase();
    });
};

if (typeof exports !== "undefined") {
    module.exports = PMUI;
}

(function () {
    /**
     * @class PMUI.util.ArrayList
     * Construct a List similar to Java's ArrayList that encapsulates methods for
     * making a list that supports operations like get, insert and others.
     *
     *      some examples:
     *      var item,
     *          arrayList = new ArrayList();
     *      arrayList.getSize()                 // 0
     *      arrayList.insert({                  // insert an object
     *          id: 100,
     *          width: 100,
     *          height: 100
     *      });
     *      arrayList.getSize();                // 1
     *      arrayList.asArray();                // [{id : 100, ...}]
     *      item = arrayList.find('id', 100);   // finds the first element with an id that equals 100
     *      arrayList.remove(item);             // remove item from the arrayList
     *      arrayList.getSize();                // 0
     *      arrayList.isEmpty();                // true because the arrayList has no elements
     *
     * @constructor Returns an instance of the class ArrayList
     */
    var ArrayList = function () {
        /**
         * The elements of the arrayList
         * @property {Array}
         * @private
         */
        var elements = [],
            /**
             * The size of the array
             * @property {number} [size=0]
             * @private
             */
            size = 0,
            index,
            i;
        return {

            /**
             * The ID of this ArrayList is generated using the function Math.random
             * @property {number} id
             */
            id: Math.random(),
            /**
             * Gets an element in the specified index or undefined if the index
             * is not present in the array
             * @param {number} index
             * @returns {Object / undefined}
             */
            get: function (index) {
                return elements[index];
            },
            /**
             * Inserts an element at the end of the list
             * @param {Object} item
             * @chainable
             */
            insert: function (item) {
                elements[size] = item;
                size += 1;
                return this;
            },
            /**
             * Inserts an element in a specific position
             * @param {Object} item
             * @chainable
             */
            insertAt: function (item, index) {
                elements.splice(index, 0, item);
                size = elements.length;
                return this;
            },
            /**
             * Removes an item from the list
             * @param {Object} item
             * @return {boolean}
             */
            remove: function (item) {
                index = this.indexOf(item);
                if (index === -1) {
                    return false;
                }
                //swap(elements[index], elements[size-1]);
                size -= 1;
                elements.splice(index, 1);
                return true;
            },
            /**
             * Gets the length of the list
             * @return {number}
             */
            getSize: function () {
                return size;
            },
            /**
             * Returns true if the list is empty
             * @returns {boolean}
             */
            isEmpty: function () {
                return size === 0;
            },
            /**
             * Returns the first occurrence of an element, if the element is not
             * contained in the list then returns -1
             * @param {Object} item
             * @return {number}
             */
            indexOf: function (item) {
                for (i = 0; i < size; i += 1) {
                    if (item === elements[i]) {
                        return i;
                    }
                }
                return -1;
            },
            /**
             * Returns the the first object of the list that has the
             * specified attribute with the specified value
             * if the object is not found it returns undefined
             * @param {string} attribute
             * @param {string} value
             * @return {Object / undefined}
             */
            find: function (attribute, value) {
                var i,
                    current;

                for (i = 0; i < elements.length; i += 1) {
                    current = elements[i];
                    if (current[attribute] === value) {
                        return current;
                    }
                }
                return undefined;
            },

            /**
             * Returns true if the list contains the item and false otherwise
             * @param {Object} item
             * @return {boolean}
             */
            contains: function (item) {
                if (this.indexOf(item) !== -1) {
                    return true;
                }
                return false;
            },
            /**
             * Sorts the list using compFunction if possible, if no compFunction
             * is passed as an parameter then a default sorting method will be used. This default method will sort in
             * ascending order.
             * @param {Function} [compFunction] The criteria function used to find out the position for the elements in
             * the array list. This function will receive two parameters, each one will be an element from the array
             * list, the function will compare those elements and it must return:
             *
             * - 1, if the first element must be before the second element.
             * - -1, if the second element must be before the first element.
             * - 0, if the current situation doesn't met any of the two situations above. In this case both elements
             * can be evaluated as they had the same value. For example, in an array list of numbers, when you are
             * trying to apply a lineal sorting (ascending/descending) in a array list of numbers, if the array sorting
             * function finds two elements with the value 3 they should be evaluated returning 0, since both values are
             * the same.
             *
             * IMPORTANT NOTE: for a correct performance the sent parameter must return at least two of the values
             * listed above, if it doesn't the function can produce an infinite loop and thus an error.
             * @return {boolean}
             */
//            sort : function (compFunction) {
//                var compFunction = compFunction || function(a, b) {
//                        if(a < b) {
//                            return 1;
//                        } else if(a > b) {
//                            return -1;
//                        } else {
//                            return 0;
//                        }
//                    }, swap = function (items, firstIndex, secondIndex){
//                        var temp = items[firstIndex];
//                        items[firstIndex] = items[secondIndex];
//                        items[secondIndex] = temp;
//                    }, partition = function(items, left, right) {
//                        var pivot = items[Math.floor((right + left) / 2)],
//                            i = left,
//                            j = right;
//                        while (i <= j) {
//                            while (compFunction(items[i], pivot) > 0) {
//                                i++;
//                            }
//                            while (compFunction(items[j], pivot) < 0) {
//                                j--;
//                            }
//                            if (i <= j) {
//                                swap(items, i, j);
//                                i++;
//                                j--;
//                            }
//                        }
//                        return i;
//                    }, quickSort = function (items, left, right) {
//                        var index;
//                        if (items.length > 1) {
//                            index = partition(items, left, right);
//                            if (left < index - 1) {
//                                quickSort(items, left, index - 1);
//                            }
//                            if (index < right) {
//                                quickSort(items, index, right);
//                            }
//                        }
//                        return items;
//                    };
//
//                return quickSort(elements, 0, size - 1);
//            },

            sort: function (compFunction) {
                var returnValue = false;

                if (compFunction) {
                    elements.sort(compFunction);
                    returnValue = true;
                }
                return returnValue;
            },
            /**
             * Bubble sort function in array
             * @param {*} compFunction 
             * @return {Array}
             */
            bubbleSort: function (compFunction) {
                var inputArr = elements,
                    i,
                    tmp,
                    len = inputArr.length,
                    swapped;
                do {
                    swapped = false;
                    for (i = 0; i < len; i++) {
                        if (inputArr[i] && inputArr[i + 1] && compFunction(inputArr[i], inputArr[i + 1])) {
                            tmp = inputArr[i];
                            inputArr[i] = inputArr[i + 1];
                            inputArr[i + 1] = tmp;
                            swapped = true;
                        }
                    }
                } while (swapped);
                elements = inputArr;
                return elements;
            },
            /**
             * Returns the list as an array
             * @return {Array}
             */
            asArray: function () {
                return elements.slice(0);
            },
            /**
             * Swaps the position of two elements
             * @chainable
             */
            swap: function (index1, index2) {
                var aux;

                if (index1 < size && index1 >= 0 && index2 < size && index2 >= 0) {
                    aux = elements[index1];
                    elements[index1] = elements[index2];
                    elements[index2] = aux;
                }
                return this;
            },
            /**
             * Returns the first element of the list
             * @return {Object}
             */
            getFirst: function () {
                return elements[0];
            },
            /**
             * Returns the last element of the list
             * @return {Object}
             */
            getLast: function () {
                return elements[size - 1];
            },

            /**
             * Returns the last element of the list and deletes it from the list
             * @return {Object}
             */
            popLast: function () {
                var lastElement;
                size -= 1;
                lastElement = elements[size];
                elements.splice(size, 1);
                return lastElement;
            },
            /**
             * Returns an array with the objects that determine the minimum size
             * the container should have
             * The array values are in this order TOP, RIGHT, BOTTOM AND LEFT
             * @return {Array}
             */
            getDimensionLimit: function () {
                var result = [100000, -1, -1, 100000],
                    objects = [undefined, undefined, undefined, undefined];
                //number of pixels we want the inner shapes to be
                //apart from the border

                for (i = 0; i < size; i += 1) {
                    if (result[0] > elements[i].y) {
                        result[0] = elements[i].y;
                        objects[0] = elements[i];

                    }
                    if (result[1] < elements[i].x + elements[i].width) {
                        result[1] = elements[i].x + elements[i].width;
                        objects[1] = elements[i];
                    }
                    if (result[2] < elements[i].y + elements[i].height) {
                        result[2] = elements[i].y + elements[i].height;
                        objects[2] = elements[i];
                    }
                    if (result[3] > elements[i].x) {
                        result[3] = elements[i].x;
                        objects[3] = elements[i];
                    }
                }
                return result;
            },
            /**
             * Clears the content of the arrayList
             * @chainable
             */
            clear: function () {
                if (size !== 0) {
                    elements = [];
                    size = 0;
                }
                return this;
            },
            /**
             * Sets the elements for the object.
             * @param {Array|null} items Array with the items to set.
             * @chainable
             */
            set: function (items) {
                if (!(items === null || jQuery.isArray(items))) {
                    throw new Error("set(): The parameter must be an array or null.");
                }
                elements = (items && items.slice(0)) || [];
                size = elements.length;
                return this;
            }
        };
    };

    PMUI.extendNamespace('PMUI.util.ArrayList', ArrayList);

    if (typeof exports !== "undefined") {
        module.exports = ArrayList;
    }

}());

(function () {
    /**
     * @class PMUI.util.Style
     * Class that represent the style of a an object.
     *
     *      // i.e
     *      // Let's assume that 'shape' is a CustomShape
     *      var style = new Style({
     *          cssClasses: [
     *              'sprite-class', 'marker-class', ...
     *          ],
     *          cssProperties: {
     *              border: 1px solid black,
     *              background-color: grey,
     *              ...
     *          },
     *          belongsTo: shape
     *      })
     *
     * @constructor Creates a new instance of this class
     * @param {Object} options
     * @cfg {Array} [cssClasses=[]] the classes that `this.belongsTo` has
     * @cfg {Object} [cssProperties={}] the css properties that `this.belongsTo` has
     * @cfg {Object} [belongsTo=null] a pointer to the owner of this instance
     */
    var Style = function (options) {

        /**
         * JSON Object used to map each of the css properties of the object,
         * this object has the same syntax as the object passed to jQuery.css()
         *      cssProperties: {
         *          background-color: [value],
         *          border: [value],
         *          ...
         *      }
         * @property {Object}
         */
        this.cssProperties = null;

        /**
         * Array of all the classes of this object
         *      cssClasses = [
         *          'class_1',
         *          'class_2',
         *          ...
         *      ]
         * @property {Array}
         */
        this.cssClasses = null;

        /**
         * Pointer to the object to whom this style belongs to
         * @property {Object}
         */
        this.belongsTo = null;


        Style.prototype.initObject.call(this, options);
    };


    /**
     * The type of this class
     * @property {String}
     */
    Style.prototype.type = "Style";

    /**
     * Constant for the max z-index
     * @property {number} [MAX_ZINDEX=100]
     */
    Style.MAX_ZINDEX = 100;

    /**
     * Instance initializer which uses options to extend the config options to
     * initialize the instance
     * @private
     * @param {Object} options
     */
    Style.prototype.initObject = function (options) {
        var defaults = {
            cssClasses: [],
            cssProperties: {},
            belongsTo: null
        };

        jQuery.extend(true, defaults, options);
        this.cssClasses = defaults.cssClasses;
        this.cssProperties = defaults.cssProperties;
        this.belongsTo = defaults.belongsTo;
    };

    /**
     * Applies cssProperties and cssClasses to `this.belongsTo`
     * @chainable
     */
    Style.prototype.applyStyle = function () {
        var i,
            t,
            class_i;

        if (!this.belongsTo.html) {
            throw new Error("applyStyle(): can't apply style to an" +
                " object with no html.");
        }

        // apply the cssProperties
        jQuery(this.belongsTo.html).css(this.cssProperties);

        //adding default classes
        t = this.belongsTo.type.toLowerCase();
        if (this.cssClasses.indexOf('pmui-' + t) === -1) {
            this.cssClasses.unshift('pmui-' + t);
        }
        if (this.cssClasses.indexOf('pmui') === -1) {
            this.cssClasses.unshift('pmui');
        }

        // apply saved classes
        for (i = 0; i < this.cssClasses.length; i += 1) {
            class_i = this.cssClasses[i];
            if (!$(this.belongsTo.html).hasClass(class_i)) {
                jQuery(this.belongsTo.html).addClass(class_i);
            }
        }
        return this;
    };
    Style.prototype.unapplyStyle = function () {
        var t,
            property;

        if (!this.belongsTo.html) {
            throw new Error("unapplyStyle(): can't unapply style to an object with no html.");
        }
        t = this.belongsTo.type.toLowerCase();
        jQuery(this.belongsTo.html).removeClass("pmui-" + t);
        for (property in this.cssProperties) {
            jQuery(this.belongsTo.html).css(property, "");
        }
    };

    /**
     * Extends the property `cssProperties` with a new object and also applies those new properties
     * @param {Object} properties
     * @chainable
     */
    Style.prototype.addProperties = function (properties) {
        jQuery.extend(true, this.cssProperties, properties);
        jQuery(this.belongsTo && this.belongsTo.html).css(properties);
        return this;
    };

    /**
     * Gets a property from `this.cssProperties` using jQuery or `window.getComputedStyle()`
     * @param {String} property
     * @return {String}
     */
    Style.prototype.getProperty = function (property) {
        return this.cssProperties[property] ||
            jQuery(this.belongsTo.html).css(property) ||
            (this.belongsTo.html && window.getComputedStyle(this.belongsTo.html, null)
                .getPropertyValue(property)) || "";
    };
    /**
     * Returns all the style's css properties set explicitly.
     * @return {Object} An object literal with the properties.
     */
    Style.prototype.getProperties = function () {
        return this.cssProperties;
    };
    /**
     * Removes ´properties´ from the ´this.cssProperties´, also disables those properties from
     * the HTMLElement
     * @param {Array} properties An array in which each element is th name of the cssProperty to be removed.
     * @chainable
     */
    Style.prototype.removeProperties = function (properties) {
        var property,
            i;

        for (i = 0; i < properties.length; i += 1) {
            property = properties[i];
            if (this.cssProperties.hasOwnProperty(property)) { // JS Code Convention
                jQuery(this.belongsTo.html).css(property, "");   // reset inline style
                delete this.cssProperties[property];
            }
        }
        return this;
    };
    /**
     * Removes all properties from the object.
     * @chainable
     */
    Style.prototype.removeAllProperties = function () {
        var key;

        if (this.belongsTo) {
            for (key in this.cssProperties) {
                jQuery(this.belongsTo.html).css(key, "");
            }
        }
        this.cssProperties = {};
        return this;
    };
    /**
     * Adds new classes to ´this.cssClasses´ array
     * @param {Array} cssClasses
     * @chainable
     */
    Style.prototype.addClasses = function (cssClasses) {
        var i,
            cssClass;

        if (cssClasses && cssClasses instanceof Array) {
            for (i = 0; i < cssClasses.length; i += 1) {
                cssClass = cssClasses[i];
                if (typeof cssClass === "string") {
                    if (this.cssClasses.indexOf(cssClass) === -1) {
                        this.cssClasses.push(cssClass);
                        jQuery(this.belongsTo && this.belongsTo.html).addClass(cssClass);
                    }
                } else {
                    throw new Error("addClasses(): array element is not of type string");
                }
            }
        } else {
            throw new Error("addClasses(): parameter must be of type Array");
        }
        return this;
    };

    /**
     * Removes classes from ´this.cssClasses´ array, also removes those classes from
     * the HTMLElement
     * @param {Array} cssClasses
     * @chainable
     */
    Style.prototype.removeClasses = function (cssClasses) {
        var i,
            index,
            cssClass;

        if (cssClasses && cssClasses instanceof Array) {
            for (i = 0; i < cssClasses.length; i += 1) {
                cssClass = cssClasses[i];
                if (typeof cssClass === "string") {
                    index = this.cssClasses.indexOf(cssClass);
                    if (index !== -1) {
                        jQuery(this.belongsTo.html).removeClass(this.cssClasses[index]);
                        this.cssClasses.splice(index, 1);
                    }
                } else {
                    throw new Error("removeClasses(): array element is not of " +
                        "type string");
                }
            }
        } else {
            throw new Error("removeClasses(): parameter must be of type Array");
        }
        return this;
    };
    /**
     * Removes all the classes from ´this.cssClasses´ array
     * @param {Array} cssClasses
     * @chainable
     */
    Style.prototype.removeAllClasses = function () {
        while (this.cssClasses.length) {
            jQuery(this.belongsTo && this.belongsTo.html).removeClass(this.cssClasses.pop());
        }
        return this;
    };

    /**
     * Checks if the class is a class stored in ´this.cssClasses´
     * @param cssClass
     * @return {boolean}
     */
    Style.prototype.containsClass = function (cssClass) {
        return this.cssClasses.indexOf(cssClass) !== -1;
    };

    /**
     * Returns an array with all the classes of ´this.belongsTo´
     * @return {Array}
     */
    Style.prototype.getClasses = function () {
        return this.cssClasses.slice(0);
    };

    /**
     * Clears all the css properties and classes.
     * @chainable
     */
    Style.prototype.clear = function () {
        return this.removeAllClasses().removeAllProperties();
    }

    /**
     * Serializes this instance
     * @return {Object}
     * @return {Array} return.cssClasses
     */
    Style.prototype.stringify = function () {
        return {
            cssClasses: this.cssClasses
        };
    };

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = Style;
    }

    PMUI.extendNamespace('PMUI.util.Style', Style);

}());
(function () {
    /**
     * @class PMUI.util.Factory
     * This class encapsulate the way to construct object using the product definition inside
     *
     * @constructor
     * This method creates a new instance of this object
     * @param {Object} settings Constructor setiings
     */
    var Factory = function (settings) {
        /**
         * Defines the products can be make by the factory
         * @type {Object}
         */
        this.products = null;

        /**
         * Defines the default product to make
         * @type {String}
         */
        this.defaultProduct = null;
        Factory.prototype.init.call(this, settings);
    };

    /**
     * Defines the object type
     * @type {String}
     */
    Factory.prototype.type = "Factory";

    /**
     * Defines the object family
     * @type {String}
     */
    Factory.prototype.family = "Factory";
    /**
     * Initializes the object with the default values
     * @param  {Object} options Contructor options
     */
    Factory.prototype.init = function (options) {
        var defaults;

        if (!options) {
            options = {};
        }
        defaults = {
            defaultProduct: options.defaultProduct || "element",
            products: options.products || {"element": PMUI.core.Element}
        };
        this.setDefaultProduct(defaults.defaultProduct)
            .setProducts(defaults.products);
    };

    /**
     * Sets the default product property
     * @param {String} def Default value
     */
    Factory.prototype.setDefaultProduct = function (def) {
        this.defaultProduct = def;
        return this;
    };

    /**
     * Sets the product object
     * @param {Object} products Products object
     */
    Factory.prototype.setProducts = function (products) {
        this.products = products;
        return this;
    };
    /**
     * Removes a product from the factory.
     * @param  {String|Object} product The product to be removed, it can be:
     *
     *  - a string: the product referenced with that pmType will be removed from factory.
     *  - a object: the constructor, all the products with that constructor will be removed.
     * @return {[type]}         [description]
     */
    Factory.prototype.removeProduct = function (product) {
        var key,
            products = this.products;

        if (typeof product === 'string') {
            delete products[product];
        } else {
            for (key in products) {
                if (products[key] === product) {
                    delete products[key];
                }
            }
        }
        return this;
    };
    /**
     * Removes all the productrs from the factory.
     * @chainable
     */
    Factory.prototype.clearProducts = function () {
        var key;

        for (key in this.products) {
            this.removeProduct(key);
        }
        return this;
    };
    /**
     * Register a new product into the products object
     * @param  {String} name  Product type
     * @param  {Object} classObj Product Class
     * @chainable
     */
    Factory.prototype.register = function (name, classObj) {
        var aux = this.products || {};

        aux[name] = classObj;
        this.products = aux;
        return this;
    };

    /**
     * Retuns a new instance (product)
     * @param  {String} type    Product type
     * @param  {Object} options Settings object
     * @return {Object}         Instance of the object
     */
    Factory.prototype.build = function (type, options) {
        var Constructor,
            instance;

        if (this.isValidName(type)) {
            Constructor = this.products[type];
            instance = new Constructor(options);
        } else {
            throw new Error('The type "' + type + '" has not valid constructor or is undefined.');
        }
        return instance;
    };

    /**
     * Retuns true if the type is valid into the products object
     * @param  {String}  name Product Name
     * @return {Boolean}
     */
    Factory.prototype.isValidName = function (name) {
        var test = this.products[name];

        return !!test;
    };

    /**
     * Returns true if the class input is instance of one class into the product object
     * @param  {Object}  className [description]
     * @return {Boolean}           [description]
     */
    Factory.prototype.isValidClass = function (className) {
        var valid = false;

        jQuery.each(this.products, function (type, classProduct) {
            if (className instanceof classProduct) {
                valid = true;
            }
        });
        return valid;
    };


    /**
     * Comprobes the obj in and returns the instance of the object
     * @param  {Object} obj Input can be an isntance or an object with the pmType property or simply a JSON
     * @return {Object}     Returns an instance made from the products object.
     */
    Factory.prototype.make = function (obj) {
        var product,
            productType = obj.pmType || '';

        if (this.isValidClass(obj)) {
            product = obj;
        } else if (this.isValidName(productType)) {
            product = this.build.call(this, productType, obj);
        } else {
            product = this.build.call(this, this.defaultProduct, obj);
        }
        return product;
    };

    //Create a namespace for Factory class
    PMUI.extendNamespace('PMUI.util.Factory', Factory);

    // Publish to NodeJS environment
    if (typeof exports !== 'undefined') {
        module.exports = Factory;
    }

}());
(function () {
    /**
     * @class PMUI.util.Color
     * This class holds the representation and operations of RGBa representation of color,
     * it's very useful if we want to save color constants as an instance and later get the representation
     * in CSS.
     *
     *      //e.g.
     *      var color = new PMUI.util.Color(
     *          128,    // red
     *          128,    // green
     *          128,    // blue
     *          1       // opacity
     *      )
     *
     * @constructor Creates an instance of this class.
     * @param {number} red
     * @param {number} green
     * @param {number} blue
     * @param {number} opacity
     * @return {PMUI.util.Color}
     */
    var Color = function (red, green, blue, opacity) {
        /**
         * Red value of the RGB Color
         * @property {number} [red=0]
         */
        this.red = (!red) ? 0 : red;
        /**
         * Green value of the RGB Color
         * @property {number} [green=0]
         */
        this.green = (!green) ? 0 : green;
        /**
         * Blue value of the RGB Color
         * @property {number} [blue=0]
         */
        this.blue = (!blue) ? 0 : blue;
        /**
         * Opacity of the RGB Color
         * @property {number} [opacity=1]
         */
        this.opacity = (!opacity) ? 1 : opacity;
    };

    /**
     * Type of this class
     * @property {String}
     */
    Color.prototype.type = "Color";

    /**
     * Constant for the color grey
     * @property {PMUI.util.Color} [GREY=new Color(192, 192, 192, 1)]
     */
    Color.GREY = new Color(192, 192, 192, 1);

    /**
     * Returns the red value of the RGB Color
     * @returns {number}
     */
    Color.prototype.getRed = function () {
        return this.red;
    };

    /**
     * Returns the green value of the RGB Color
     * @returns {number}
     */
    Color.prototype.getGreen = function () {
        return this.green;
    };

    /**
     * Returns the blue value of the RGB Color
     * @returns {number}
     */
    Color.prototype.getBlue = function () {
        return this.blue;
    };

    /**
     * Returns the opacity of the RGB Color
     * @returns {number}
     */
    Color.prototype.getOpacity = function () {
        return this.opacity;
    };

    /**
     * Sets the red value of the RGB Color
     * @param {number} newRed
     * @chainable
     */
    Color.prototype.setRed = function (newRed) {
        if (typeof newRed === "number" && newRed >= 0 && newRed <= 255) {
            this.red = newRed;
        }
        return this;
    };

    /**
     * Sets the green value of the RGB Color
     * @param {number} newRed
     * @chainable
     */
    Color.prototype.setGreen = function (newGreen) {
        if (typeof newGreen === "number" && newGreen >= 0 && newGreen <= 255) {
            this.green = newGreen;
        }
        return this;
    };

    /**
     * Sets the blue value of the RGB Color
     * @param {number} newBlue
     * @chainable
     */
    Color.prototype.setBlue = function (newBlue) {
        if (typeof newBlue === "number" && newBlue >= 0 && newBlue <= 255) {
            this.blue = newBlue;
        }
        return this;
    };

    /**
     * Sets the opacity of the RGB Color
     * @param {number} newOpacity
     * @chainable
     */
    Color.prototype.setOpacity = function (newOpacity) {
        if (typeof newOpacity === "number" && newOpacity >= 0 && newOpacity <= 255) {
            this.opacity = newOpacity;
        }
        return this;
    };

    /**
     * Returns the css representation of the RGB color
     *      //e.g.
     *      var color = new PMUI.util.Color(10, 20, 30, 0.1);
     *      color.getCSS();         // "rgba(10, 20, 30, 0.1)"
     * @returns {String}
     */
    Color.prototype.getCSS = function () {
        var css = "rgba(" + this.red + "," + this.green + "," + this.blue +
            "," + this.opacity + ")";
        return css;
    };

    PMUI.extendNamespace('PMUI.util.Color', Color);
}());

(function () {
    /**
     * @class PMUI.util.Point
     * Class to represent points in the PMDraw library
     *
     *        // e.g.
     *        var p = new PMUI.util.Point(100, 100);
     *
     * @constructor Creates an instance of this class
     * @param {number} xCoordinate x-coordinate of the point
     * @param {number} yCoordinate y-coordinate of the point
     * @return {PMUI.util.Point}
     */
    var Point = function (xCoordinate, yCoordinate) {
        /**
         * x coordinate of the point in the plane
         */
        this.x = xCoordinate;
        /**
         * y coordinate of the point in the plane
         */
        this.y = yCoordinate;
    };

    /**
     * Type of this class
     * @property {String}
     */
    Point.prototype.type = "Point";

    /**
     * Returns the X coordinate
     * @property {number}
     **/
    Point.prototype.getX = function () {
        return this.x;
    };

    /**
     * Returns the Y coordinate
     * @property {number}
     **/
    Point.prototype.getY = function () {
        return this.y;
    };

    /**
     * Adds `other` point to `this` point and returns a new point with those coordinates.
     *
     *      // e.g.
     *      var p1 = new PMUI.util.Point(3, 5),
     *          p2 = new PMUI.util.Point(2, 3);
     *      p1.add(p2);     // new Point(5, 8)
     *
     * @param {PMUI.util.Point} other Point to be added to the current point
     * @returns {PMUI.util.Point}
     */
    Point.prototype.add = function (other) {
        return new Point(this.x + other.x, this.y + other.y);
    };

    /**
     * Subtracts the other point to the one that called the function.
     *
     *      // e.g.
     *      var p1 = new PMUI.util.Point(3, 5),
     *          p2 = new PMUI.util.Point(2, 3);
     *      p1.subtract(p2);     // new Point(1, 2)
     *
     * @param {PMUI.util.Point} other Point to be added to the current point
     * @returns {PMUI.util.Point}
     */
    Point.prototype.subtract = function (other) {
        return new Point(this.x - other.x, this.y - other.y);
    };

    /**
     * Multiplies the point with a scalar k.
     *
     *      // e.g.
     *      var p1 = new PMUI.util.Point(3, 5),
     *          k = 3;
     *      p1.multiply(k);     // new Point(9, 15)
     *
     * @param {number} k
     * @return {PMUI.util.Point}
     */
    Point.prototype.multiply = function (k) {
        return new Point(this.x * k, this.y * k);
    };

    /**
     * Determine if the points are equal.
     *
     *      // e.g.
     *      var p1 = new PMUI.util.Point(3, 5),
     *          p2 = new PMUI.util.Point(2, 3),
     *          p3 = new PMUI.util.Point(3, 5);
     *      p1.equals(p2);     // false
     *      p1.equals(p3);     // true
     *      p1.equals(p1);     // true
     *
     * @param {PMUI.util.Point} other Point to be compared with the current point
     * @returns {boolean}
     */
    Point.prototype.equals = function (other) {
        return (Math.abs(this.x - other.x) < PMUI.draw.Geometry.eps) &&
            (Math.abs(this.y - other.y) < PMUI.draw.Geometry.eps);
    };

    /**
     * Determine the distance between two Points
     *
     *      // e.g.
     *      // distance = sqrt(pow(x1 - x2, 2) + pow(y1 - y2, 2))
     *      var p1 = new PMUI.util.Point(3, 5),
     *          p2 = new PMUI.util.Point(2, 3);
     *      p1.getDistance(p2);         // sqrt(1 + 4)
     *
     * @param {PMUI.util.Point} other Point to be calculated from current point
     * @returns {number}
     **/
    Point.prototype.getDistance = function (other) {
        return Math.sqrt(
            (this.x - other.x) * (this.x - other.x) +
            (this.y - other.y) * (this.y - other.y)
        );
    };

    /**
     * Determine the squared distance between two Points
     *
     *      // e.g.
     *      // distance = sqrt(pow(x1 - x2, 2) + pow(y1 - y2, 2))
     *      // but since it's the squared distance then
     *      // distance = pow(distance, 2)
     *      var p1 = new PMUI.util.Point(3, 5),
     *          p2 = new PMUI.util.Point(2, 3);
     *      p1.getSquaredDistance(p2);         // (1 + 4)
     *
     * @param {PMUI.util.Point} other Point to be calculated from current point
     * @returns {number}
     **/
    Point.prototype.getSquaredDistance = function (other) {
        return (this.x - other.x) * (this.x - other.x) +
            (this.y - other.y) * (this.y - other.y);
    };

    /**
     * Determine the manhattan distance between two Points
     *
     *      // e.g.
     *      var p1 = new PMUI.util.Point(3, 5),
     *          p2 = new PMUI.util.Point(2, 3);
     *      p1.getManhattanDistance(p2);         // (1 + 2)
     *
     * @param {PMUI.util.Point} other Point to be calculated from current point
     * @returns {number}
     **/
    Point.prototype.getManhattanDistance = function (other) {
        return Math.abs(this.x - other.x) + Math.abs(this.y - other.y);
    };

    /**
     * Makes a clone of this
     *
     *      // e.g.
     *      var p1 = new PMUI.util.Point(3, 5),
     *          cloneP1;
     *      cloneP1 = p1.clone();       // cloneP1 is Point(3, 5)
     *
     * @returns {PMUI.util.Point} This point
     */
    Point.prototype.clone = function () {
        return new Point(this.x, this.y);
    };

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== 'undefined') {
        module.exports = Point;
    }

    // extend namespace
    PMUI.extendNamespace('PMUI.util.Point', Point);

}());

(function () {
    /**
     * @class PMUI.draw.Graphics
     * Class Graphics is the HTMLElement drawing engine used to draw lines (as HTMLElement divs),
     * arcs (using HTMLElement divs) and ovals.
     * Currently some elements in the designer are completely represented with the drawing engine:
     *
     * - Connection => a set of segments (regular, segmented, dotted)
     * - Port => oval
     * - Intersection => arc
     *
     * Some important notes:
     *
     * - Currently this class acts as an interface between the library **PMDraw** and the HTMLElement
     * drawing engine wz_jsGraphics
     * - The drawing engine constructor needs the HTMLElement where it will go as a parameter **(this
     * HTMLElement must exist in the DOM)**
     *
     * @constructor
     * Creates an instance of this class (currently it's an interface of the wz_graphics framework)
     * @param {Object} html This parameter can be either an id, or an html object
     */
    var Graphics = function (html) {

        if (!html) {
            return null;
        }

        /**
         * Create an instance of the class JSGraphics (this.graphics is an interface)
         * @type {Object}
         */
        this.graphics = new JSGraphics(html);

        /**
         * Creates an instance of the class Color (color black)
         * @type {PMUI.util.Color}
         */
        this.color = new PMUI.util.Color(0, 0, 0);
    };

    /**
     * Draws a line of a given type between two points.
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {string} type the type of line we wish to draw
     * @param {PMUI.util.Color} color The color of the segment
     * @param {number} segLength the segment length for segmented and segmentdot type of line
     * @param {number} spaceLength the space length for segmented and segmentdot type of line
     * @param {boolean} [doNotErasePrevious] if set to true then it won't clear the elements drew with this instance
     */
    Graphics.prototype.drawLine = function (x1, y1, x2, y2, type, color, segLength, spaceLength, doNotErasePrevious) {

        if (!doNotErasePrevious) {
            this.graphics.clear();
        }

        if (!type) {
            type = "regular";
        }
        switch (type) {
            case "dotted":
                this.graphics.setStroke(-1);
                break;
            case "segmented":
                this.graphics.setStroke(1);
                this.graphics.drawLine = this.makeSegmentedLine;
                break;
            case "segmentdot":
                this.graphics.setStroke(1);
                this.graphics.drawLine = this.makeSegmentDotLine;
                break;
            default:
                this.graphics.setStroke(1);
        }

        this.graphics.setColor(color.getCSS());
        this.graphics.drawLine(x1, y1, x2, y2, segLength, spaceLength);
        this.graphics.paint();

    };

    /**
     * Returns the color that was being used for drawing
     * @returns {PMUI.util.Color}
     */
    Graphics.prototype.getColor = function () {
        return this.color;
    };

    /**
     * Sets the color to be used for drawing
     * @param newColor
     * @chainable
     */
    Graphics.prototype.setColor = function (newColor) {
        if (newColor.type === "Color") {
            this.color = newColor;
        }
        return this;
    };

    /**
     * This function will make a segmented line between two points in the same axis,
     * if points in different axis are provided the method would simple return
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} segmentLength the segment length for segmented and
     * segmentdot type of line
     * @param {number} spLength the space length for segmented and
     * segmentdot type of line
     */
    Graphics.prototype.makeSegmentedLine = function (x1, y1, x2, y2, segmentLength, spLength) {
        var dx,
            dy,
            aux,
            segLength = 4,
            spaceLength = 3,
            diff = 0,
            x,
            y;

        //not same axis so just return
        if ((x2 !== x1 && y2 !== y1)) {
            return;
        }

        if (x2 === x1) {
            //same point just return
            if (y2 === y1) {
                return;
            }
            dx = 0;
            //swap
            if (y2 < y1) {
                aux = y2;
                y2 = y1;
                y1 = aux;
            }
            dy = diff = y2 - y1;
        } else {
            dy = 0;
            if (x2 < x1) {
                aux = x2;
                x2 = x1;
                x1 = aux;
            }
            dx = diff = x2 - x1;
        }

        x = x1;
        y = y1;

        if (diff < 7) {
            segLength = 2;
            spaceLength = 1;
        }

        segLength = (!segmentLength) ? segLength : segmentLength;
        spaceLength = (!spLength) ? spaceLength : spLength;

        if (dy === 0) {
            while (dx > 0) {
                if (dx >= segLength) {
                    this._mkDiv(x, y, segLength, 1);
                    x += segLength + spaceLength;
                    dx -= (segLength + spaceLength);
                } else {
                    this._mkDiv(x, y, dx, 1);
                    dx = 0;
                }
            }
        } else {
            while (dy > 0) {
                if (dy >= segLength) {
                    this._mkDiv(x, y, 1, segLength);
                    y += segLength + spaceLength;
                    dy -= (segLength + spaceLength);
                } else {
                    this._mkDiv(x, y, 1, dy);
                    dy = 0;
                }
            }
        }
    };

    /**
     * This function will make a segment between two points in the same axis with
     * the following structure segment-dot-segment
     * if points in different axis are provided the function will simply return.
     *
     * @param {number} x1
     * @param {number} y1
     * @param {number} x2
     * @param {number} y2
     * @param {number} segmentLength the segment length for segmented and
     * segmentdot type of line
     * @param {number} spLength the space length for segmented and
     * segmentdot type of line
     */

    Graphics.prototype.makeSegmentDotLine = function (x1, y1, x2, y2, segmentLength, spLength) {
        var dx,
            dy,
            aux,
            segLength = 7,
            spaceLength = 4,
            dotLength = 1,
            diff = 0,
            x,
            y;

        //not same axis so just return
        if ((x2 !== x1 && y2 !== y1)) {
            return;
        }


        if (x2 === x1) {
            //same point just return
            if (y2 === y1) {
                return;
            }
            dx = 0;
            //swap
            if (y2 < y1) {
                aux = y2;
                y2 = y1;
                y1 = aux;
            }
            dy = y2 - y1;
            diff = dy;
        } else {
            dy = 0;
            if (x2 < x1) {
                aux = x2;
                x2 = x1;
                x1 = aux;
            }
            dx = x2 - x1;
            diff = dx;
        }

        x = x1;
        y = y1;

        segLength = (!segmentLength) ? segLength : segmentLength;
        spaceLength = (!spLength) ? spaceLength : spLength;

        if (dy === 0) {
            while (dx > 0) {
                if (dx >= segLength) {
                    this._mkDiv(x, y, segLength, 1);
                    dx -= (segLength + spaceLength);
                    x += segLength + spaceLength;
                    if (dx > 0) {
                        this._mkDiv(x, y, dotLength, 1);
                        dx -= (dotLength + spaceLength);
                        x += dotLength + spaceLength;
                    }
                } else {
                    this._mkDiv(x, y, dx, 1);
                    dx = 0;
                }
            }
        } else {
            while (dy > 0) {
                if (dy >= segLength) {
                    this._mkDiv(x, y, 1, segLength);
                    dy -= (segLength + spaceLength);
                    y += segLength + spaceLength;
                    if (dy > 0) {
                        this._mkDiv(x, y, 1, dotLength);
                        dy -= (dotLength + spaceLength);
                        y += dotLength + spaceLength;

                    }
                } else {
                    this._mkDiv(x, y, 1, dy);
                    dy = 0;
                }
            }
        }

    };
    /**
     * Draws an arc with the center `[cx, cy]`, with a radius equal to `radius` from `startAngle` to `endAngle`
     * and drawing a line every `step` steps.
     * Logic:
     *
     * 1. Let's assume that we have a circle with center `[cx, cy]` and with a radius equal to `radius`
     * 2. We want to draw only a portion of the circle (from `startAngle` to `endAngle`)
     * 3. Given any angle of the circle `0 <= angle < 360` we can get its `x` and `y` coordinates using
     *    Pythagoras triangle rectangle laws.
     *      - We know that `hyp^2 = dx^2 + dy^2` and that `hyp = radius`
     *      - We know that `cos(angle) = dx / radius` so `dx = radius * cos(angle)`
     *      - We know that `sin(angle) = dy / radius` so `dx = radius * cos(angle)`
     * 4. Finally let's use the given center of the circle to move the triangle
     *
     * @param {number} cx
     * @param {number} cy
     * @param {number} radius
     * @param {number} startAngle
     * @param {number} endAngle
     * @param {number} step
     */
    Graphics.prototype.drawArc = function (cx, cy, radius, startAngle, endAngle, step) {
        var x,
            y,
            angle = startAngle;

        if (!step) {
            step = 10;
        }

        while (Math.abs(angle - endAngle) > 1e-5) {
            angle = (angle + step) % 360;
            x = cx + radius * Math.cos(angle * PMUI.draw.Geometry.pi / 180.0);
            y = cy + radius * Math.sin(angle * PMUI.draw.Geometry.pi / 180.0);
            this.graphics.drawLine(x, y, x, y);
        }
    };

    PMUI.extendNamespace('PMUI.draw.Graphics', Graphics);
}());

(function () {
    /**
     * @class PMUI.draw.Geometry
     * A little object that encapsulates most geometry functions used in the designer, most of the examples
     * are in 'spec/draw/geometry.spec.js'
     *
     * @singleton
     */
    var Geometry = {
        /**
         * The number pi
         * @property {number} [pi=Math.acos(-1)]
         */
        pi: Math.acos(-1),
        /**
         * Epsilon used for the correctness in comparison of float numbers
         * @property {number} [eps=1e-8]
         */
        eps: 1e-8,
        /**
         * Calculates the cross product of 2-dimensional vectors
         * @param {PMUI.util.Point} p1
         * @param {PMUI.util.Point} p2
         * @return {number}
         */
        cross: function (p1, p2) {
            return p1.x * p2.y - p1.y * p2.x;
        },
        /**
         * Calculates the SIGNED area of a parallelogram given three points, these three points are the points
         * that conforms the triangle that is half of the parallelogram, so. the area of the triangle
         * defined with these points is half the returned number (this method can return negative values)
         *
         *      // e.g.
         *      var p1 = new PMUI.util.Point(0, 0),
         *          p2 = new PMUI.util.Point(0, 1),
         *          p3 = new PMUI.util.Point(1, 0),
         *          parallelogramArea,
         *          triangleArea;
         *
         *      parallelogramArea = Geometry.area(p1, p2, p3)   // -1 (area of the parallelogram)
         *      triangleArea = parallelogramArea / 2            // -0.5 (area of the triangle)
         *
         * @param {PMUI.util.Point} p1
         * @param {PMUI.util.Point} p2
         * @param {PMUI.util.Point} p3
         * @return {number}
         */
        area: function (p1, p2, p3) {
            var auxP2 = p2.clone(),
                auxP3 = p3.clone();
            return this.cross(auxP2.subtract(p1), auxP3.subtract(p1));
        },
        /**
         * Determines if the point P is on segment AB
         * @param {PMUI.util.Point} P
         * @param {PMUI.util.Point} A
         * @param {PMUI.util.Point} B
         * @return {boolean}
         */
        onSegment: function (P, A, B) {
            return (Math.abs(this.area(A, B, P)) < this.eps &&
            P.x >= Math.min(A.x, B.x) && P.x <= Math.max(A.x, B.x) &&
            P.y >= Math.min(A.y, B.y) && P.y <= Math.max(A.y, B.y));
        },
        /**
         * Checks if two perpendicular segments intersect, if so it returns the intersection point,
         * (this method only allows the perpendicular segment to be parallel to the x and y axis)
         * @param {PMUI.util.Point} A
         * @param {PMUI.util.Point} B
         * @param {PMUI.util.Point} C
         * @param {PMUI.util.Point} D
         * @return {Object}
         */
        perpendicularSegmentIntersection: function (A, B, C, D) {
            var clone,
                returnValue = null;

            // swap the segments if possible
            if (A.x > B.x || A.y > B.y) {
                clone = A.clone();
                A = B.clone();
                B = clone;
            }

            if (C.x > D.x || C.y > D.y) {
                clone = C.clone();
                C = D.clone();
                D = clone;
            }

            if (A.x === B.x) {
                if (C.y === D.y && C.x < A.x && A.x < D.x &&
                    A.y < C.y && C.y < B.y) {
                    returnValue = new PMUI.util.Point(A.x, C.y);
                }
            } else if (A.y === B.y) {
                if (C.x === D.x && A.x < C.x && C.x < B.x &&
                    C.y < A.y && A.y < D.y) {
                    returnValue = new PMUI.util.Point(C.x, A.y);
                }
            }
            return returnValue;
        },
        /**
         * Determines if segment AB intersects with segment CD (won't check infinite intersections),
         * if `strict` is set to `true` then it'll consider the case when one end of a segment is right in the
         * other segment
         * @param {PMUI.util.Point} A
         * @param {PMUI.util.Point} B
         * @param {PMUI.util.Point} C
         * @param {PMUI.util.Point} D
         * @param {boolean} [strict]
         * @return {boolean}
         */
        segmentIntersection: function (A, B, C, D, strict) {

            var area1 = this.area(C, D, A),
                area2 = this.area(C, D, B),
                area3 = this.area(A, B, C),
                area4 = this.area(A, B, D),
                returnValue;
            if (((area1 > 0 && area2 < 0) || (area1 < 0 && area2 > 0)) &&
                ((area3 > 0 && area4 < 0) || (area3 < 0 && area4 > 0))) {
                return true;
            }

            returnValue = false;
            if (strict) {
                if (area1 === 0 && this.onSegment(A, C, D)) {
                    returnValue = true;
                } else if (area2 === 0 && this.onSegment(B, C, D)) {
                    returnValue = true;
                } else if (area3 === 0 && this.onSegment(C, A, B)) {
                    returnValue = true;
                } else if (area4 === 0 && this.onSegment(D, A, B)) {
                    returnValue = true;
                }
            }
            return returnValue;
        },
        /**
         * Checks if two segments intersect, if so it returns the intersection point
         * @param {PMUI.util.Point} A
         * @param {PMUI.util.Point} B
         * @param {PMUI.util.Point} C
         * @param {PMUI.util.Point} D
         * @return {PMUI.util.Point}
         */
        segmentIntersectionPoint: function (A, B, C, D) {
            return A.add((B.subtract(A))
                .multiply(this.cross(C.subtract(A), D.subtract(A)) /
                    this.cross(B.subtract(A), D.subtract(C))));
        },
        /**
         * Determines whether a point is in a given rectangle or not given its
         * upperLeft and bottomRight corner (consider that a rectangle is turned in the y-axis)
         * @param {PMUI.util.Point} point
         * @param {PMUI.util.Point} upperLeft
         * @param {PMUI.util.Point} bottomRight
         * @return {boolean}
         */
        pointInRectangle: function (point, upperLeft, bottomRight) {
            return (point.x >= upperLeft.x && point.x <= bottomRight.x &&
            point.y >= upperLeft.y && point.y <= bottomRight.y);
        },
        /**
         * Determines whether a point is in a circle or not given its center and
         * radius
         * @param {PMUI.util.Point} point
         * @param {PMUI.util.Point} center
         * @param {number} radius
         * @returns {boolean}
         */
        pointInCircle: function (point, center, radius) {
            return center.getDistance(point) <= radius;
        },
        /**
         * Determine whether a point is inside a rhombus or not given its center
         * and its points in clockwise order
         * @param {PMUI.util.Point} point
         * @param {Array} rhombus
         * @param {PMUI.util.Point} center
         * @return {boolean}
         */
        pointInRhombus: function (point, rhombus, center) {
            var i,
                j = rhombus.length - 1;
            for (i = 0; i < rhombus.length; j = i, i += 1) {
                if (this.segmentIntersection(center, point,
                        rhombus[j], rhombus[i], true) &&
                    this.onSegment(point, rhombus[j], rhombus[i]) === false) {
                    return false;
                }
            }
            return true;
        }
    };

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== 'undefined') {
        module.exports = Geometry;
    }

    // extend the namespace
    PMUI.extendNamespace('PMUI.draw.Geometry', Geometry);
}());

(function () {
    /**
     * @class PMUI.event.Action
     * Handles the action for buttons, menues, toolbars
     *
     * Example:
     *
     *      var action = new PMUI.event.Action({
     *          text: 'Save Document',
     *          icon: 'pm-icon-save',
     *          disabled: false,
     *          handler: function () {
     *              alert('Action has been called!');
     *          }
     *      });
     *
     * Using action as parameter to create another objects:
     *
     *      var button = new PMUI.ui.Button(action);
     *
     *      var form = new PMUI.form.Form({
     *          ...
     *          buttons: [
     *              action,
     *              {
     *                  text: 'Refresh',
     *                  handler: function() {
     *                      obj.refresh()  //this object is fake used for sample purposes only
     *                  }
     *              }
     *          ]
     *          ...
     *      });
     *
     * Actions are created to handle user functionality you can extend or use over several places or components
     *
     *
     * @constructor
     * Creates a new instance of object
     * @param {Object} options
     */
    var Action = function (options) {
        /**
         * Defines the text of the action
         * @type {String}
         */
        this.actionText = null;
        /**
         * Defines the icon asssociated with the action
         * @type {String}
         */
        this.actionIcon = null;
        /**
         * Defines the state of the action
         * @type {Boolean}
         */
        this.disabled = false;
        /**
         * Defines the action to be executed
         * @type {Function}
         */
        this.handler = null;

        Action.prototype.init.call(this, options);
    };

    /**
     * Defines the object's type
     * @type {String}
     */
    Action.prototype.type = 'Action';
    /**
     * Defines the object's family
     * @type {String}
     */
    Action.prototype.family = 'Action';

    /**
     * Defines the action flag
     * @type {Boolean}
     */
    Action.prototype.isAction = true;

    /**
     * @private
     * Initializes the object with the default values
     * @param  {Object} options Constructor options
     */
    Action.prototype.init = function (options) {
        var defaults;
        defaults = {
            icon: null,
            text: null,
            disabled: false,
            handler: function () {
            }
        };
        jQuery.extend(true, defaults, options);
        this.setActionIcon(defaults.icon)
            .setActionText(defaults.text)
            .setDisable(defaults.disabled)
            .setHandler(defaults.handler);
    };

    /**
     * Sets the action Icon
     * @param {String} icon Icon URL or class
     */
    Action.prototype.setActionIcon = function (icon) {
        this.actionIcon = icon;
        return this;
    };

    /**
     * Sets the action's text
     * @param {String} text Actions's name
     */
    Action.prototype.setActionText = function (text) {
        this.actionText = text;
        return this;
    };

    /**
     * Sets the disabled value
     * @param {Boolean} value
     */
    Action.prototype.setDisable = function (value) {
        if (typeof(value) === 'boolean') {
            this.disabled = value;
        }
        return this;
    };

    /**
     * Returns the icon url or class
     * @return {String} [description]
     */
    Action.prototype.getIcon = function () {
        return this.actionIcon;
    };

    /**
     * Returns the action name
     * @return {String} [description]
     */
    Action.prototype.getText = function () {
        return this.actionText;
    };

    /**
     * Sets the handler function
     * @param {Function} fn
     */
    Action.prototype.setHandler = function (fn) {
        if (typeof(fn) === 'function') {
            this.handler = fn;
        }
        return this;
    };

    /**
     * Enables the action functionality
     */
    Action.prototype.enable = function () {
        this.setDisable(false);
    };

    /**
     * Disables the action functionality
     */
    Action.prototype.disable = function () {
        this.setDisable(true);
    };

    /**
     * Returns if the action is enabled
     * @return {Boolean}
     */
    Action.prototype.isEnabled = function () {
        return !this.disabled;
    };

    /**
     * Executes the action if is enabled and has a valid handler
     */
    Action.prototype.execute = function () {
        if (!this.disabled && typeof this.handler === 'function') {
            this.handler();
        }
    };


    if (typeof exports !== "undefined") {
        module.exports = Action;
    }

    PMUI.extendNamespace('PMUI.event.Action', Action);

}());
(function () {
    /**
     * @class PMUI.core.Base
     * Base class for any other class in PMUI, this class is an abstract so it shouldn't be instantiated.
     * @param {Object} settings All the settings the the class requires
     *
     * Usage example:
     *
     *      var anObject = new PMUI.core.Base({
     *          id: "myUniqueId"
     *      });
     *
     * @constructor
     * Creates a new instance of the class 'Base'.
     * @param {Object} [options={}] The config options for the object.
     *
     * @cfg {String} [id=[an autogenerated unique id]] The unique identifier for the object. If it is not specified
     * then one is created an assigned to it.
     */
    var Base = function (settings) {
        /**
         * Unique ID
         * @type {String}
         */
        this.id = null;
        Base.prototype.init.call(this, settings);
    };
    /**
     * Class type
     * @type {String}
     */
    Base.prototype.type = 'Base';
    /**
     * Class family
     * @type {String}
     */
    Base.prototype.family = 'Core';
    /**
     * Initialize the object
     * @param  {Object} settings Settings for Base Class
     * @return {String}          the generated id
     * @private
     */
    Base.prototype.init = function (settings) {
        var defaults = {
            id: 'pmui-' + PMUI.generateUniqueId()
        };

        jQuery.extend(true, defaults, settings);

        this.setID(defaults.id);
    };
    /**
     * Set the id property for the object
     * @param {String} id
     * @chainable
     */
    Base.prototype.setID = function (id) {
        this.id = id;
        return this;
    };
    /**
     * Returns the id property from the object
     * @return {String} [description]
     */
    Base.prototype.getID = function () {
        return this.id;
    };
    /**
     * Returns the object's type
     * @return {String}
     */
    Base.prototype.getType = function () {
        return this.type;
    };
    /**
     * Return's the object's family name
     * @return {String}
     */
    Base.prototype.getFamily = function () {
        return this.family;
    };

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = Base;
    }

    PMUI.extendNamespace('PMUI.core.Base', Base);
}());
(function () {
    /**
     * @class PMUI.core.Element
     * Base class to handle objects that have a visual representation (HTML representation).
     * @extends PMUI.core.Base
     *
     * Usage example:
     *
     *      @example
     *      var element;
     *
     *      element = new PMUI.core.Element({
     *          x: 10,
     *          y: 20,
     *          positionMode: "absolute",
     *          width: 200,
     *          height: 200,
     *          style: {
     *              cssProperties: {
     *                  "background-color": "red"
     *              },
     *              cssClasses: [".square"]
     *          }
     *      });
     *
     *      document.body.appendChild(element.getHTML());
     *
     * @constructor
     * Create a new instace of the class 'Element'
     * @param {Object} options
     *
     * @cfg {String} [elementTag="div"] The html tag for the object's HTML element.
     * @cfg {String} [positionMode="relative"] The css position for the object's HTML element. It can take one of the
     * following values "static", "absolute", "fixed", "relative", "inherit" or "". Please read about the css "position"
     * property to know about how each value impacts in the html.
     * @cfg {Object} [style={cssProperties:{}, cssClasses:[]}] A JSON object which will contain the css properties for
     * the object's html.
     *
     * This object can have optionally two properties:
     *
     * - cssProperties: another JSON object in which each property can be a css property (if the css property has any
     * special character like "-" enclose the property name between quotes), the value can be any valid css value for
     * the property.
     * - cssClasses: An array where each element is a String, this String is the css class name.
     *
     * @cfg {Number} [x=0] The position coordinate in the x axis for the object's HTML, please note that the visual
     * position will depend on the {@link PMUI.core.Element#cfg-positionMode positionMode option}.
     * @cfg {Number} [y=0] The position coordinate in the y axis for the object's HTML, please note that the visual
     * position will depend on the {@link PMUI.core.Element#cfg-positionMode positionMode option}.
     * @cfg {Number|String} [width="auto"] The width for the object's HTML, it can be a Number or an String. In the
     * latter case the value must be "auto" or "inherit" or have one of the following formats:
     *
     * - "##px".
     * - "##%".
     * - "##em"
     *
     * Note that ## is a number.
     * @cfg {Number|String} [height="auto"] The height for the object's HTML, the values that can take are the same
     * specified in the {@link PMUI.core.Element#cfg-width}.
     * @cfg {Number|String} [zOrder="auto"] The position in the z axis for the object's HTML, it can be a Number or a
     * String, in the latter case the value only can be "auto" or "inherit".
     * @cfg {Boolean} [visible=true] If the object will be visible or not.
     * @cfg {Number} [proportion=1] A numeric value that specifies the final width of the object's HTML in case to be
     * contained by a {@link PMUI.core.Container Container} which is applying a {@link PMUI.layout.Layout Layout}.
     * @cfg {String} [display=""] The display property specifies the type of box used for an HTML element.
     * find out more about the css display property
     * @cfg {Function} [onBeforeContextMenu=null] description here.
     */
    var Element = function (settings) {
        Element.superclass.call(this, settings);
        /**
         * HTML element.
         * @type {HTMLElement}
         * @readonly
         */
        this.html = null;
        /**
         * @property {Object|PMUI.util.Style} [style={
                cssProperties: {},
                cssClasses: []
            }]
         * A {@link PMUI.util.Style Style} object or a JSON object with the settings to create a new
         * {@link PMUI.util.Style Style} object for the current's HTML element.
         * @readonly
         */
        this.style = null;
        /**
         * X coordinate for the HTML element.
         * @type {Number}
         * @readonly
         */
        this.x = null;
        /**
         * @property {Number} [y=0]
         * Y Coordinate for the HTML element.
         * @readonly
         */
        this.y = null;
        /**
         * Width for the HTML element, it can be a number or a string with the following format:
         ##px when ## is a number.
         * @type {Number|String}
         * @readonly
         */
        this.width = null;
        /**
         * Height for the HTML element, it can be a number or a string with the following format:
         ##px when ## is a number.
         * @type {Number|String}
         * @readonly
         */
        this.height = null;
        /**
         * A boolean value that indicates if the HTML element is visible or not.
         * @type {Boolean}
         * @readonly
         */
        this.visible = null;
        /**
         * A Number that indicates the HTML element's position on the Z axis.
         * @type {Number}
         * @readonly
         */
        this.zOrder = null;
        /**
         * @property {String} [elementTag="div"]
         * Tag name for the element to be created, it defaults to "div".
         * @readonly
         */
        this.elementTag = null;
        /**
         * @property {String} [positionMode="relative"]
         * Position for the object's html element, it must be a valid value for the "position" CSS property.
         * @readonly
         */
        this.positionMode = null;
        /**
         * Defines the proportion of the html.
         * @type {Number}
         */
        this.proportion = null;
        /**
         * @property {String} [display=""] The display mode for the element. It is set by the
         * {@link #cfg-display display} config option and the {@link #method-setDisplay setDisplay} method.
         * @readonly
         */
        this.display = null;
        /**
         * Defines the menu component for the element
         * @type {PMUI.ui.Menu}
         */
        this.menu = null;
        /**
         * Defines an object to handle/register events.
         * @type {Object}
         */
        this.events = {};
        /**
         * @property {Boolean} eventsDefined If the events were defined or not
         */
        this.eventsDefined = false;
        /**
         * [onContextMenu description]
         * @type {Boolean}
         */
        this.onContextMenu = false;
        /**
         * [onBeforeContextMenu description]
         * @type {Boolean}
         */
        this.onBeforeContextMenu = false;
        /**
         * The element's parent Container.
         * @type {PMUI.core.Element}
         */
        this.parent = null;
        /**
         * The HTML area in which some activities, actions can be performed (like display the context menu).
         * @type {HTMLElement}
         * @private
         */
        this.actionHTML = null;

        Element.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Base', Element);
    /**
     * The Object's type.
     * @type {String}
     */
    Element.prototype.type = 'Element';
    /**
     * Initialize the object.
     * @param  {Object} settings A JSON object with the settings to create the new class instance.
     * @private
     */
    Element.prototype.init = function (settings) {
        var defaults = {
            elementTag: "div",
            positionMode: "relative",
            menu: null,
            style: {
                cssProperties: {},
                cssClasses: []
            },
            x: 0,
            y: 0,
            width: "auto",
            height: "auto",
            zOrder: "auto",
            display: "",
            visible: true,
            proportion: 1,
            onContextMenu: null,
            onBeforeContextMenu: null
        };

        jQuery.extend(true, defaults, settings);

        this.setElementTag(defaults.elementTag)
            .setStyle(defaults.style)
            .setPositionMode(defaults.positionMode)
            .setDisplay(defaults.display)
            .setX(defaults.x)
            .setY(defaults.y)
            .setWidth(defaults.width)
            .setHeight(defaults.height)
            .setZOrder(defaults.zOrder)
            .setVisible(defaults.visible)
            .setProportion(defaults.proportion)
            .setContextMenu(defaults.menu)
            .setOnBeforeContextMenu(defaults.onBeforeContextMenu)
            .setOnContextMenuHandler(defaults.onContextMenu);
    };
    /**
     * [setOnBeforeContextMenu description]
     */
    Element.prototype.setOnBeforeContextMenu = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error("setOnBeforeContextMenu(): The parameter must be a function or null.");
        }
        this.onBeforeContextMenu = handler;
        return this;
    };
    /**
     * [setOnContextMenuHandler description]
     * @param {[type]} handler [description]
     */
    Element.prototype.setOnContextMenuHandler = function (handler) {
        if (typeof handler === 'function' || null) {
            this.onContextMenu = handler;
        }
        return this;
    };
    /**
     * Sets the display mode for the Element.
     * @param {String} display It can take one of the following values:
     *
     * - ""
     * - "block"
     * - "inline"
     * - "inline-block"
     * - "none"
     *
     * @chainable
     */
    Element.prototype.setDisplay = function (display) {
        if (display === "" || display === 'block' || display === 'inline'
            || display === 'inline-block' || display === 'none') {
            this.display = display;
            this.applyStyle();
        } else {
            throw new Error('The setDisplay() method only accepts one od the following options: ' +
                ' "", "block", "inline", "inline-block", "none"');
        }

        return this;
    };
    /**
     * Sets the position mode for the Element.
     * @param {String} position It can take one ot the following values:
     *
     * - "static"
     * - "asolute"
     * - "fixed"
     * - "relative"
     * - "inherit"
     *
     * @chainable
     */
    Element.prototype.setPositionMode = function (position) {
        if (position === 'static' || position === 'absolute' || position === 'fixed' || position === 'relative' ||
            position === 'inherit' || position === "") {
            this.positionMode = position;
            this.applyStyle();
        } else {
            throw new Error('The setPosition() method only accepts one of the following options:' +
                ' "static", "absolute", "fixed", "relative", "inherit" or an empty string.');
        }

        return this;
    };
    /**
     * Set the HTML tag for the HTML element to be created, note that it'll only work when its html property
     is still not set.
     * @param {String} tag a HTML tag
     * @chainable
     */
    Element.prototype.setElementTag = function (tag) {
        if (!this.html && typeof tag === 'string') {
            this.elementTag = tag;
        }

        return this;
    };
    /**
     * [addCSSClasses description]
     * @param {[type]} classes [description]
     */
    Element.prototype.addCSSClasses = function (classes) {
        this.style.addClasses(classes);
        return this;
    };
    /**
     * [addCSSProperties description]
     * @param {[type]} properties [description]
     */
    Element.prototype.addCSSProperties = function (properties) {
        this.style.addProperties(properties);
        return this;
    };
    /**
     * [removeCSSClasses description]
     * @param  {[type]} classes [description]
     * @return {[type]}         [description]
     */
    Element.prototype.removeCSSClasses = function (classes) {
        this.style.removeClasses(classes);
        return this;
    };
    /**
     * [removeCSSProperties description]
     * @param  {[type]} properties [description]
     * @return {[type]}            [description]
     */
    Element.prototype.removeCSSProperties = function (properties) {
        this.style.removeProperties(properties);
        return this;
    };
    /**
     * Set the style properties for the HTML element.
     * @param {Object|null} style an JSON structure with attributes cssProperties (another object) and cssClasses
     * (array). It also can be null, in this case no custom styles will be applied to the the element.
     * @chainable
     */
    Element.prototype.setStyle = function (style) {
        style = style || {};
        if (this.style && this.html) {
            this.style.unapplyStyle();
        }
        if (style instanceof PMUI.util.Style) {
            this.style = style;
            style.belongsTo = this;
        } else if (typeof style === 'object') {
            style.belongsTo = this;
            this.style = new PMUI.util.Style(style);
        }
        this.applyStyle();
        return this;
    };
    /**
     * Set the x position coordinate for the HTML element.
     * @chainable
     * @param {Number} x
     * @chainable
     */
    Element.prototype.setX = function (x) {
        if (typeof x === 'number') {
            this.x = x;
        } else if (/^\d+(\.\d+)?px$/.test(x)) {
            this.x = parseInt(x, 10);
        } else {
            throw new Error('setX: x param is not a number');
        }
        this.style.addProperties({left: this.x});

        return this;
    };
    /**
     * Returns the x position coordinate for the HTML element
     * @return {Number}
     */
    Element.prototype.getX = function () {
        return this.x;
    };
    /**
     * Set the y position coordinate for the HTML element.
     * @param {Number} y
     * @chainable
     */
    Element.prototype.setY = function (y) {
        if (typeof y === 'number') {
            this.y = y;
        } else if (/^\d+(\.\d+)?px$/.test(y)) {
            this.y = parseInt(y, 10);
        } else {
            throw new Error('setY: y param is not a number');
        }
        this.style.addProperties({top: this.y});
        return this;
    };
    /**
     * Returns the y position coordinate for the HTML element
     * @return {Number}
     */
    Element.prototype.getY = function () {
        return this.y;
    };
    /**
     * Set the width for the HTML element
     * @param {Number|String} width height it can be a number or a string.
     In case of using a String you only can use 'auto' or ##px or ##% or ##em when ## is a number.
     * @chainable
     */
    Element.prototype.setWidth = function (width) {
        if (typeof width === 'number') {
            this.width = width;
        } else if (/^\d+(\.\d+)?px$/.test(width)) {
            this.width = parseInt(width, 10);
        } else if (/^\d+(\.\d+)?%$/.test(width)) {
            this.width = width;
        } else if (/^\d+(\.\d+)?em$/.test(width)) {
            this.width = width;
        } else if (width === 'auto') {
            this.width = width;
        } else {
            throw new Error('setWidth: width param is not a number');
        }
        this.style.addProperties({width: this.width});
        return this;
    };
    /**
     * Returns the HTML element's width
     * @return {Number}
     */
    Element.prototype.getWidth = function () {
        return this.width;
    };
    /**
     * Set the height for the HTML element
     * @param {Number|String} height it can be a number or a string.
     In case of using a String you only can use 'auto' or 'inherit' or ##px or ##% or ##em when ## is a number.
     * @chainable
     */
    Element.prototype.setHeight = function (height) {
        if (typeof height === 'number') {
            this.height = height;
        } else if (/^\d+(\.\d+)?px$/.test(height)) {
            this.height = parseInt(height, 10);
        } else if (/^\d+(\.\d+)?%$/.test(height)) {
            this.height = height;
        } else if (/^\d+(\.\d+)?em$/.test(height)) {
            this.height = height;
        } else if (height === 'auto' || height === 'inherit') {
            this.height = height;
        } else {
            throw new Error('setHeight: height param is not a number');
        }
        this.style.addProperties({height: this.height});
        return this;
    };
    /**
     * Returns the HTML element's height.
     * @return {Number}
     */
    Element.prototype.getHeight = function () {
        return this.height;
    };
    /**
     * Set the position index om the z axis for the object's HTML element.
     * @param {Number|String} zOrder it can be a Number or a String.
     In case of using a String you only can use 'auto' or 'inherit'.
     * @chainable
     */
    Element.prototype.setZOrder = function (zOrder) {
        if (typeof zOrder === 'number') {
            this.zOrder = parseInt(zOrder, 10);
        } else if (zOrder === 'auto' || zOrder === 'inherit') {
            this.zOrder = zOrder;
        } else {
            throw new Error('setZOrder: zOrder param is not a number');
        }
        if (this.html) {
            this.style.addProperties({"z-index": this.zOrder});
        }
        return this;
    };
    /**
     * Returns the HTML element's zOrder.
     * @return {Number}
     */
    Element.prototype.getZOrder = function () {
        return this.zOrder;
    };
    /**
     * Set if the HTML element is visible or not.
     * @param {Boolean} visible
     * @chainable
     */
    Element.prototype.setVisible = function (visible) {
        visible = !!visible;
        this.visible = visible;
        if (this.html) {
            this.style.addProperties({"display": this.visible ? this.display : "none"});
        }

        return this;
    };
    /**
     * Returns a boolean value that indicates if the HTML element is visible or not.
     * @return {Boolean} [description]
     */
    Element.prototype.isVisible = function () {
        return this.visible;
    };
    /**
     * Set the HTML element's position.
     * @param {Object} position an object with x and y properties, both of them are Numbers
     * @chainable
     */
    Element.prototype.setPosition = function (position) {
        this.setX(position.x);
        this.setY(position.y);

        return this;
    };
    /**
     * Returns and object which contains the x and y positions from the HTML element.
     * @return {Object}
     */
    Element.prototype.getPosition = function () {
        return {
            x: this.getX(),
            y: this.getY()
        };
    };
    /**
     * Set the HTML element's dimension (width and height).
     * @param {Object} dimension
     * @chainable
     */
    Element.prototype.setDimension = function (dimension) {
        this.setWidth(dimension.width);
        this.setHeight(dimension.height);

        return this;
    };
    /**
     * Returns the HTML element's dimension.
     * @return {Object} and object with width and height properties.
     */
    Element.prototype.getDimension = function () {
        return {
            width: this.getWidth(),
            height: this.getHeight()
        };
    };
    /**
     * Applies the css classes and ptoperties to the element's html which the object is related.
     * @chainable
     */
    Element.prototype.applyStyle = function () {
        if (this.html) {
            this.style.applyStyle();

            this.style.addProperties({
                display: this.visible ? this.display : "none",
                position: this.positionMode,
                left: this.x,
                top: this.y,
                width: this.width,
                height: this.height,
                zIndex: this.zOrder
            });
        }
        return this;
    };
    /**
     * Creates the object's HTML element.
     * @return {HTMLElement} returns a HTML element
     */
    Element.prototype.createHTML = function () {
        var html;
        if (this.html) {
            return this.html;
        }
        html = PMUI.createHTMLElement(this.elementTag || "div");
        html.id = this.id;
        PMUI.linkToPMUIObject(html, this);
        this.html = html;
        this.actionHTML = html;
        this.applyStyle();
        if (this.eventsDefined) {
            this.defineEvents();
        }
        return this.html;
    };
    /**
     * Returns the object's HTML element, if it doesn't exist it's created then it is returned.
     * @return {HTMLElement}
     */
    Element.prototype.getHTML = function () {
        if (!this.html) {
            this.html = this.createHTML();
        }
        return this.html;
    };

    /**
     * Set the proportion of the html element.
     * @param {Number} p Proportion value.
     * @chainable
     */
    Element.prototype.setProportion = function (p) {
        this.proportion = p;
        return this;
    };

    /**
     * Creates and Instanciate an event.
     * @param {String} type  Event type.
     * @param {String} [alias] Registered Name.
     * @return {PMUI.event.Event}
     */
    Element.prototype.addEvent = function (type, alias) {
        var factory = new PMUI.event.EventFactory(),
            newEvent = factory.make(type),
            registerName = alias || PMUI.generateUniqueId();
        this.events[registerName] = newEvent;
        return newEvent;
    };

    /**
     * @abstract
     * Defines the events associated with the element.
     * @chainable
     * @abstract
     */
    Element.prototype.defineEvents = function () {
        var that = this;
        this.removeEvents();
        this.addEvent('contextmenu').listen(this.actionHTML, function (e) {
            if (typeof that.onBeforeContextMenu === 'function') {
                that.onBeforeContextMenu(that);
            }
            if (typeof that.onContextMenu === 'function') {
                that.onContextMenu(that);
            }
            if (that.menu) {
                e.stopPropagation();
                e.preventDefault();
                that.menu.show(e.pageX, e.pageY);
            }
        });
        this.eventsDefined = true;
        return this;
    };
    /**
     * Remove a specific event attached to the object.
     * @param  {String} identifier The id or alias used in the moment of event addition.
     * @chainable
     */
    Element.prototype.removeEvent = function (identifier) {
        if (this.events[identifier]) {
            this.events[identifier].unlisten();
            delete this.events[identifier];
        }
        return this;
    };
    /**
     * Removes events attached to the object.
     * @chainable
     */
    Element.prototype.removeEvents = function () {
        var k;
        for (k in this.events) {
            this.removeEvent(k);
        }
        ;
        return this;
    };
    /**
     * Calculates the width size of the container.
     *
     * @param {String} text
     * @param {String} font
     * @chainable
     */
    Element.prototype.calculateWidth = function (text, font) {
        //TODO Improve the div creation (maybe we can use a singleton for this)
        var f = font || '12px arial',
            $o = $(PMUI.createHTMLElement('div')), w;
        $o.text(text)
            .css({
                'position': 'absolute',
                'float': 'left',
                'white-space': 'nowrap',
                'visibility': 'hidden',
                'font': f
            })
            .appendTo($('body'));
        w = $o.width();

        $o.remove();

        return w;
    };
    /**
     * Sets the context menu for the component and the menu will be contained on the {@link PMUI.core.Element#menu menu} property.
     *
     * If the settings parameter is not a valid json the {@link PMUI.core.Element#menu menu} property will be an simple empty object.
     *
     * The example below shows the appropriate way to send a basic settings parameter.
     *
     *      component = new Class();
     *      component.setContextMenu({
     *          id: "id", //optional
     *          items: [
     *              {
     *                  text: "Option 1"
     *              },
     *              {
     *                  text: "Option 2"
     *              }
     *          ]
     *      });
     *
     * For more details about the context menu, the documentation is on the {@link PMUI.ui.Menu Menu} class.
     *
     * @param {Object} settings Configuration or config options for the context {@link PMUI.ui.Menu menu}.
     * @return {Object} this Represents the component of the class.
     */
    Element.prototype.setContextMenu = function (menuItems) {
        var contextMenu;
        this.removeContextMenu();
        if (menuItems !== null) {
            if (jQuery.isArray(menuItems)) {
                contextMenu = new PMUI.menu.Menu({items: menuItems});
            } else if (menuItems instanceof PMUI.menu.Menu) {
                contextMenu = menuItems;
            } else if (typeof menuItems === 'object') {
                contextMenu = new PMUI.menu.Menu(menuItems);
            }
            if (contextMenu) {
                this.menu = contextMenu.setTargetElement(this);
            }
        }
        return this;
    };
    /**
     * [removeContextMenu description]
     * @return {[type]} [description]
     */
    Element.prototype.removeContextMenu = function () {
        if (this.menu) {
            this.menu.setTargetElement(null);
            this.menu = null;
        }
        return this;
    };
    /**
     * Returns the elemnent's parent container.
     * @return {PMUI.core.Element|null} The parent container.
     */
    Element.prototype.getParent = function () {
        return this.parent;
    };
    /**
     * Shows the context menu for the element provided that the element contains an object that represent a
     * {@link PMUI.ui.Menu Menu}.
     *
     * If the {@link PMUI.core.Element#menu menu} property is an empty object the context menu will
     * never appear on the page.
     *
     * By default the context menu will appear after to do right click on the element.
     */
    Element.prototype.showContextMenu = function () {
        if (this.menu) {
            this.menu.show();
        }
        return this;
    };
    /**
     * Return true if the object's events were defined, otherwise it returns false.
     * @return {Boolean}
     */
    Element.prototype.eventsAreDefined = function () {
        return this.eventsDefined;
    };
    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = Element;
    }

    PMUI.extendNamespace('PMUI.core.Element', Element);

}());
(function () {
    /**
     * @class PMUI.core.Container
     * Handles HTML elements that have a container behavior (they can be contain {Element} objects)
     * @abstract
     * @extend PMUI.core.Element
     *  * Usage example (only for subclasses since this is an abstract class):
     *
     *      @example
     *       //Remember, this is an abstract class so it shouldn't be instantiate,
     *       //anyway we are instantiating it just for this example
     *       c = new PMUI.core.Container({
     *            x: 10,
     *            y: 20,
     *            positionMode: "absolute",
     *            width: 300,
     *            height: 100,
     *            style: {
     *                cssProperties: {
     *                    "background-color": "yellow"
     *                },
     *                cssClasses: [".square"]
     *            },
     *            items : [
     *               new PMUI.core.Element({
     *                    y : 0,
     *                    width: 100,
     *                    height: 100,
     *                    style: {
     *                        cssProperties: {
     *                            "background-color": "red"
     *                        },
     *                        cssClasses: [".square"]
     *                    }
     *               }),
     *               new PMUI.core.Element({
     *                    y : 100,
     *                    width: 100,
     *                    height: 100,
     *                    style: {
     *                        cssProperties: {
     *                            "background-color": "yellow"
     *                        },
     *                        cssClasses: [".square"]
     *                    }
     *               })
     *            ]
     *        });
     *        document.body.appendChild(c.getHTML());
     *
     * @constructor
     * Creates a new instance
     * @param {Object} settings
     *
     * @cfg {Array} [items=[]] An array with the items to be added to tyhe container. If the
     * {@link PMUI.core.Container#cfg-dataItems dataItems config option} is  specified then this config option will be
     * ignored.
     *
     * Each array's item can be:
     *
     *  - A JSON object with the config options required by an {@link PMUI.core.Element Element object}.
     *  - An instance of the {@link PMUI.core.Element Element class}.
     *
     * @cfg {String} [behavior='nobehavior'] A string that specifies the behavior for the container and its items.
     * The accepted values are the same ones that the specified ones for the
     * {@link PMUI.core.Container#method-setBehavior setBehavior() method}.
     *
     * @cfg {Array} [dataItems=null] An array in which each element is the data for the items that will be contained by
     * the container. If this config option is specfied the {@link PMUI.core.Container#cfg-items items config option}
     * will be ignored.
     *
     * @cfg {Function} [onDrop=null] The callback function to be executed everytime a draggable item is dropped on the
     * container. This callback can return a boolean value or not return anything. If it returns "false" then the drop
     * action will be cancelled. For info about the parameters sent to the callback function please read the
     * {@link PMUI.core.Container#event-onDrop onDrop} event documentation.
     *
     * @cfg {Function} [onSort=null] The callback function to be executed everytime a container's item order changes.
     * For info about the parameters sent to the callback function please read the
     * {@link PMUI.core.Container#event-onSort onSort} event documentation.
     *
     * @cfg {String} [sortableItems=null] Specifies which items inside the element should be sortable in case a
     * sort behavior is applied. It must be a jQuery selector.
     *
     * @cfg {Boolean} [disabled=false] If the interactive functions like the drag, drop, sort behaviors will be
     * disabled or not.
     *
     * @cfg {Function|null} [onBeforeDrop=null] The callback to be executed before a draggable item that was dropped
     * on the container is added.
     *
     * @cfg {Function|null} [onDropOut=null] The callback to be executed everytime a draggable item is drop out from
     * the container to another one. To know the parameters sent to the callback function read the documentation for
     * the {@link #event-onDropOut onDropOut} event.
     *
     * @cfg {Function|null} [onDragStart=null] The callback function to be executed everytime any of its draggable items
     * starts to be dragged. For info about the parameters sent to the callback function read the documentation for
     * the {@link #event-onDropOut onDropOut} event.
     *
     * @cfg {Function|null} [onAdd=null] The callback function be executed eveytime the {@link #event-onAdd onAdd event}.
     */
    var Container = function (settings) {
        Container.superclass.call(this, settings);
        /**
         * @property {PMUI.util.ArrayList} items
         * An ArrayList object that contains all the child Items
         */
        this.items = null;
        /**
         * @property {PMUI.util.Factory} factory
         * X
         */
        this.factory = null;
        /**
         * @property {PMUI.behavior.ContainerItemBehavior} behaviorObject The container's behavior object.
         * @private
         */
        this.behaviorObject = null;
        /**
         * @property {String} behavior The behavior's pmType being used by the object.
         * @readonly
         */
        this.behavior = null;
        /**
         * @property {HTMLElement} containmentArea The HTML area in which the items HTML will be append
         * @readonly
         */
        this.containmentArea = null;
        /**
         * @event onDragStart
         * Fired when the dragging is starting on any ot its items.
         * @param {PMUI.core.Container} container The container from which the draggable is starting to be dragged.
         * @param {PMUI.core.Element} draggableItem The item thais starting to be dragged.
         */
        this.onDragStart = null;
        /**
         * @event onDrop
         * Fired everytime a draggable item is dropped on the container.
         * @param {PMUI.core.Container} container The container on which the draggable item was dropped.
         * @param {PMUI.core.Element} draggableItem The item that was dropped on the container.
         * @param {Number} index The order index in which the new element was dropped.
         */
        this.onDrop = null;
        /**
         * @event onDropOut
         * Fired when a draggable item is drop out from the container to another one.
         * @param {PMUI.core.Element} draggable The draggable PMUI object involved in the action.
         * @param {PMUI.core.Container} origin The container the draggable item was drag from.
         * @param {PMUI.core.Container} destiny The container the draggable was dropped on.
         */
        this.onDropOut = null;
        /**
         * @event
         * Fired before an item is added to the container by dropping.
         * @param {PMUI.core.Element} draggableItem The container.
         * @param {PMUI.core.Element} draggableItem The item that was dropped and is ready to be appended to the
         * container.
         * @param {Number} index The new element's order index in which it will be added.
         */
        this.onBeforeDrop = null;
        /**
         * @event onSort
         * Fired everytime a container's item order changes.
         * @param {PMUI.core.Container} container The container on which the sort occur.
         * @param {PMUI.core.Element} orderedElement The element which was ordered.
         * @param {Number} index The new element's order index.
         */
        this.onSort = null;
        /**
         * Specifies which items inside the element should be sortable in case a drag/sort behavior is applied.
         * @type {String}
         */
        this.sortableItems = null;
        /**
         * If the container is disabled or not. Set by the {@link #cfg-disabled disabled} config option and the
         * {@link #method-disable disable()} method.
         * @type {Boolean}
         * @readonly
         */
        this.disabled = null;
        /**
         * If the container's behavior is disabled or not. Set by the {@link #cfg-disabledBehavio disabledBehavior} config option and the
         * {@link #method-disableBehavior disableBehavior()} method.
         * @type {Boolean}
         */
        this.disabledBehavior = null;
        /**
         * A flag that indicates if actually a massive action is being performed.
         * @private
         * @type {Boolean}
         */
        this.massiveAction = false;
        /**
         * @event onAdd
         * Fired everytime an item is added to the object.
         * @param {PMUI.core.Container} container The container in which the item was added to.
         * @param {PMUI.core.Element} item The item that was added.
         * @param {Number} index The index in which the item was added.
         */
        this.onAdd = null;
        /**
         * @property {String} dragDropBehaviorScope A draggable/droppable container with the same scope value as
         * another droppable/draggable container's item will be accepted by the behavior.
         */
        this.dragDropBehaviorScope = null;

        this.onSortStart = null;
        this.onStopDrag = null;
        /**
         * Restricts dragging/sorting from starting unless the mousedown occurs on the specified element(s). Only
         * elements that descend from the draggable element are permitted.
         * @type {String}
         */
        this.dragHandler = null;
        Container.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', Container);

    Container.prototype.type = 'Container';
    /**
     * Initializes the object.
     * @param  {Object} settings A JSON object with the config options.
     * @private
     */
    Container.prototype.init = function (settings) {
        var defaults = {
            items: [],
            behavior: 'nobehavior',
            dataItems: null,
            onDragStart: null,
            onBeforeDrop: null,
            onDrop: null,
            onDropOut: null,
            onSort: null,
            sortableItems: '> *',
            disabled: false,
            onAdd: null,
            onSortStart: null,
            onStopDrag: null,
            dragDropBehaviorScope: 'pmui-containeritem-behavior',
            dragHandler: null
        };

        jQuery.extend(true, defaults, settings);

        this.items = new PMUI.util.ArrayList();

        this.setFactory(defaults.factory)
            .setOnAddHandler(defaults.onAdd);

        if (jQuery.isArray(defaults.dataItems)) {
            this.setDataItems(defaults.dataItems);
        } else {
            this.setItems(defaults.items);
        }

        this.setSortableItems(defaults.sortableItems)
            .setDragHandler(defaults.dragHandler)
            .setDragDropBehaviorScope(defaults.dragDropBehaviorScope)
            .setBehavior(defaults.behavior)
            .setOnDragStartHandler(defaults.onDragStart)
            .setOnBeforeDropHandler(defaults.onBeforeDrop)
            .setOnDropHandler(defaults.onDrop)
            .setOnDropOutHandler(defaults.onDropOut)
            .setOnSortHandler(defaults.onSort);
        this.setOnSortStartHandler(defaults.onSortStart);
        this.setOnStopDragHandler(defaults.onStopDrag);
        if (this.disabled) {
            this.disable();
        } else {
            this.enable();
        }
    };
    /**
     * If specified, restricts dragging/sorting from starting unless the mousedown occurs on the specified element(s).
     * Only elements that descend from the draggable element are permitted.
     * @param {String} handler The selector for the handler.
     * @chainable
     */
    Container.prototype.setDragHandler = function (handler) {
        if (!(typeof handler === 'string' || handler === null)) {
            throw new Error("The parameter must be a string or null");
        }
        this.dragHandler = handler;
        this.setBehavior(this.behavior);
        return this;
    };
    /**
     * Sets the {@link #property-dragDropBehaviorScope dragDropBehaviorScope} property.
     * @param {String} scope Any string that represents a scope.
     * @chainable
     */
    Container.prototype.setDragDropBehaviorScope = function (scope) {
        if (typeof scope !== 'string') {
            throw new Error("setDragDropBehaviorScope(): The parameter must be a string.");
        }
        this.dragDropBehaviorScope = scope;
        this.setBehavior(this.behavior);
        return this;
    };
    /**
     * Sets the handler to be executed everytime the {@link #event-onAdd onAdd} event is fired.
     * @param {Function|null} handler The handler to execute, it also can be null.
     * @chainable
     */
    Container.prototype.setOnAddHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error('setOnAddHandler(): The parameter ust be a function or null.');
        }
        this.onAdd = handler;
        return this;
    };
    /**
     * Sets the callback function to be executed everytime any of its draggable items stop to be dragged.
     * @param {Function|null} handler It can be a function or null.
     */
    Container.prototype.setOnStopDragHandler = function (handler) {
        if (handler !== null && typeof handler !== 'function') {
            throw new Error('setOnStopDragHandler(): the parameter must be a function or null.');
        }
        this.onStopDrag = handler;
        return this;
    };
    /**
     * Sets the callback function to be executed everytime any of its draggable items starts to be dragged. For info
     * about the parameters sent to the callback function read the documentation for
     * the {@link #event-onDropOut onDropOut} event.
     * @param {Function|null} handler It can be a function or null.
     */
    Container.prototype.setOnDragStartHandler = function (handler) {
        if (!(typeof handler === 'function' || handler === null)) {
            throw new Error('setOnDragStartHandler(): the parameter must be a function or null.');
        }
        this.onDragStart = handler;
        return this;
    };
    /**
     * Sets the callback function to be executed when a draggable item is dragged from the container and dropped on
     * another container. This callback can return a boolean value or not return anything. If it returns "false" then
     * the drop action will be cancelled. For info about the parameters sent to the callback function please read the
     * {@link PMUI.core.Container#event-onDrop onDrop} event documentation.
     * @param {Function|null} handler
     * @chainable
     */
    Container.prototype.setOnDropOutHandler = function (handler) {
        if (!(typeof handler === 'function' || handler === null)) {
            throw new Error('setOnDropOutHandler(): the parameter must be a function or null.');
        }
        this.onDropOut = handler;
        return this;
    };
    /**
     * Disables the container's behavior.
     * @chainable
     */
    Container.prototype.disableBehavior = function () {
        this.disabledBehavior = true;
        this.behaviorObject.disable();
        return this;
    };
    /**
     * Enables the container's behavior.
     * @chainable
     */
    Container.prototype.enableBehavior = function () {
        this.disabledBehavior = false;
        this.behaviorObject.enable();
        this.disabled = false;
        this.style.removeClasses(['pmui-disabled']);
        return this;
    };
    /**
     * Disables interactive functions like the drag, drop, sort behaviors.
     * @chainable
     */
    Container.prototype.disable = function () {
        this.disabled = true;
        this.style.addClasses(['pmui-disabled']);
        return this.disableBehavior();
    };
    /**
     * Enables interactive functions like the drag, drop, sort behaviors.
     * @chainable
     */
    Container.prototype.enable = function () {
        this.disabled = false;
        this.style.removeClasses(['pmui-disabled']);
        return this.enableBehavior();
    };
    /**
     * Specifies which items inside the element should be sortable in case a drag/sort behavior is applied.
     * @param {String} selector A jQuery selector.
     * @chainable
     */
    Container.prototype.setSortableItems = function (selector) {
        this.sortableItems = selector;
        return this.setBehavior(this.behavior);
    };
    /**
     * Sets the callback function to be executed everytime a container's item order changes.
     * @param {Function} handler It can be a function or null. For info about the parameters sent to the callback
     * function please read the {@link PMUI.core.Container#event-onSort onSort} event documentation.
     */
    Container.prototype.setOnSortHandler = function (handler) {
        if (handler !== null && typeof handler !== 'function') {
            throw new Error('setOnSortHandler(): the parameter must be a function or null.');
        }
        this.onSort = handler;
        return this;
    };

    Container.prototype.setOnSortStartHandler = function (handler) {
        if (handler !== null && typeof handler !== 'function') {
            throw new Error('setOnSortStartHandler(): the parameter must be a function or null.');
        }
        this.onSortStart = handler;
        return this;
    };
    /**
     * Sets the callback function to be executed before a draggable item is added to the container by dropping.
     * @param {Function} handler It can be a function or null. For info about the parameters sent to the callback
     * function please read the {@link PMUI.core.Container#event-onBeforeDrop onBeforeDrop} event documentation.
     */
    Container.prototype.setOnBeforeDropHandler = function (handler) {
        if (handler !== null && typeof handler !== 'function') {
            throw new Error('setOnDropHandler(): the parameter must be a function or null.');
        }
        this.onBeforeDrop = handler;
        return this;
    };
    /**
     * Sets the callback function to be executed everytime a draggable item is dropped on the container.
     * @param {Function} handler It can be a function or null. For info about the parameters sent to the callback
     * function please read the {@link PMUI.core.Container#event-onDrop onDrop} event documentation.
     */
    Container.prototype.setOnDropHandler = function (handler) {
        if (handler !== null && typeof handler !== 'function') {
            throw new Error('setOnDropHandler(): the parameter must be a function or null.');
        }
        this.onDrop = handler;
        return this;
    };
    /**
     * Adds a new item but using raw data to create it.
     * @param {Object} dataItem A JSON object with the data to create the new object.
     * @param {Number} [index] The position index in which the data item will be inserted.
     */
    Container.prototype.addDataItem = function (dataItem, index) {
        var args,
            i;
        if (typeof dataItem !== 'object') {
            throw new Error('addDataItem(): The parameter must be an object.');
        }
        args = [{
            data: dataItem
        }];
        for (i = 1; i < arguments.length; i += 1) {
            args.push(arguments[i]);
        }
        this.addItem.apply(this, args);
        return this;
    };
    /**
     * Sets the data toi be used to create every item to be contained by the object.
     * @param {Array} dataItems An array in which each element is an object with the data for each of the items.
     */
    Container.prototype.setDataItems = function (dataItems) {
        var i;
        if (jQuery.isArray(dataItems)) {
            this.clearItems();
            this.massiveAction = true;
            for (i = 0; i < dataItems.length; i += 1) {
                this.addDataItem(dataItems[i]);
            }
            this.massiveAction = false;
            this.paintItems();
        }

        return this;
    };
    /**
     * Returns the html element in which the items are appended.
     * @return {HTMLElement}
     */
    Container.prototype.getContainmentArea = function () {
        this.getHTML();
        return this.containmentArea;
    };
    /**
     * Returns all the container's items the behavior will be applied on.
     * @return {Array} An array of items.
     * @private
     */
    Container.prototype.getBehavioralItems = function () {
        return this.getItems();
    };
    /**
     * Enables/disables one, two, all of the following behaviors:
     *
     * - "drag", allows to drag items from the object, also them can be dropped on another containers that have enables
     * the "drop" behavior.
     * - "drop", allows to drop draggable items from another container on the object.
     * - "sort", allows reorder the items in the object. Combined with "drop" behavior makes the object capable to
     * receive objects (drop) in a specific position.
     * @param {String} behavior The behavior to be set, the accepted values are:
     *
     * - "drag", enables the dragging functionality.
     * - "dragclone", enables the clone-dragging functionality.
     * - "drop", enables the dropping functionality.
     * - "sort", enabled the sorting functionality.
     * - "dragdrop", enables both dragging and dropping functionality.
     * - "dragsort", enables both dragging and sorting functionality.
     * - "dropsort", enables both dropping and sorting functionality.
     * - "dragdropsort", enables the three behaviors: dragging, dropping and sorting.
     * - "nobehavior", disables all the behaviors.
     * @chainable
     */
    Container.prototype.setBehavior = function (behavior, index) {
        var obj,
            behaviorObject,
            factory;

        if (typeof behavior === 'string') {
            factory = new PMUI.behavior.ContainerItemBehaviorFactory();
            obj = {
                pmType: behavior,
                targetObject: this,
                scope: this.dragDropBehaviorScope,
                handle: this.dragHandler
            };
            if (this.behaviorObject) {
                this.behaviorObject.detachBehavior();
            }
            behaviorObject = factory.make(obj);
            if (behaviorObject) {
                this.behaviorObject = behaviorObject;
                this.behavior = behavior;
            }
            if (this.html) {
                if (index !== undefined) {
                    this.behaviorObject.attachBehavior(index);
                } else {
                    this.behaviorObject.attachBehavior();
                }
            }
        }
        return this;
    };

    Container.prototype.addingBehaviorsElement = function (behavior, index) {
        var obj,
            behaviorObject,
            factory;

        if (typeof behavior === 'string') {
            factory = new PMUI.behavior.ContainerItemBehaviorFactory();
            obj = {
                pmType: behavior,
                targetObject: this,
                scope: this.dragDropBehaviorScope,
                handle: this.dragHandler
            };
            if (this.behaviorObject) {
                this.behaviorObject.detachBehavior();
            }
            behaviorObject = factory.make(obj);
            if (behaviorObject) {
                this.behaviorObject = behaviorObject;
                this.behavior = behavior;
            }
            if (this.html) {
                if (index !== undefined) {
                    this.behaviorObject.attachBehavior(index);
                } else {
                    this.behaviorObject.attachBehavior();
                }
            }
        }
        return this;
    };
    /**
     * Sets the "factory" property with a {PMUI.util.Factory} object
     * @param {Object} factory
     * @chainable
     * @private
     */
    Container.prototype.setFactory = function (factory) {
        if (factory instanceof PMUI.util.Factory) {
            this.factory = factory;
        } else {
            this.factory = new PMUI.util.Factory(factory);
        }
        return this;
    };

    /**
     * Removes a child element from the object
     * @param  {PMUI.core.Element|String|Number} item It can be a string (id of the child to remove),
     a number (index of the child to remove) or a {Element} object.
     * @chainable
     */
    Container.prototype.removeItem = function (item) {
        var itemToRemove,
            parent;
        if (item instanceof PMUI.core.Element) {
            itemToRemove = item;
        } else {
            if (typeof item === 'string') {
                itemToRemove = this.items.find("id", item.id);
            } else if (typeof item === 'number') {
                itemToRemove = this.items.get(item);
            }
        }
        if (itemToRemove) {
            parent = itemToRemove.parent;
            if (parent) {
                parent.items.remove(itemToRemove);
            } else {
                this.items.remove(itemToRemove);
            }
            itemToRemove.parent = null;
            if (this.html) {
                jQuery(itemToRemove.html).detach();
            }
        }
        if (!this.items.getSize()) {
            this.style.addClasses(['pmui-empty']);
        }
        if (this.massiveAction) {
            return this;
        }
        return this;
    };
    /**
     * Removes all the child items
     * @chainable
     */
    Container.prototype.clearItems = function () {
        this.massiveAction = true;
        while (this.items.getSize() > 0) {
            this.removeItem(0);
        }
        this.massiveAction = false;
        return this;
    };
    /**
     * Returns true if the item, used as the unique method parameter, is a direct child of the current Container object,
     otherwise returns false
     * @param  {PMUI.core.Element}  item The target child object
     * @return {Boolean}
     */
    Container.prototype.isDirectParentOf = function (item) {
        return this.items.indexOf(item) >= 0;
    };
    /**
     * Returns true if the supplied argument can be accepted as an item of the container.
     * @param  {PMUI.core.Element} obj The element to be evaluated.
     * @return {Boolean}
     */
    Container.prototype.canContain = function (obj) {
        return obj instanceof PMUI.core.Element ? this.factory.isValidClass(obj) : false;
    };
    /**
     * Paint a container's item (puts its HTML into the container's HTML).
     * @param  {PMUI.core.Element} item The item to add.
     * @chainable
     * @private
     */
    Container.prototype.paintItem = function (item, index) {
        var referenceItem;
        if (this.html) {
            if (index !== null && index !== undefined) {
                referenceItem = this.items.get(index + 1);
                if (referenceItem) {
                    this.containmentArea.insertBefore(item.getHTML(), referenceItem.getHTML());
                } else {
                    this.containmentArea.appendChild(item.getHTML());
                }
            } else {
                this.containmentArea.appendChild(item.getHTML());
            }
            if (this.eventsDefined) {
                item.defineEvents();
            }
            index = this.items.indexOf(item);
            this.setBehavior(this.behavior, index);
        }
        return this;
    };
    /**
     * Paint all the container items.
     * @chainable
     * @private
     */
    Container.prototype.paintItems = function () {
        var items,
            i;
        if (this.containmentArea) {
            items = this.items.asArray()
            for (i = 0; i < items.length; i += 1) {
                this.paintItem(items[i]);
            }
        }
        return this;
    };
    /**
     * Adds an child item to the object.
     * @param {PMUI.core.Element|Object} item It can be one of the following data types:
     * - {PMUI.core.Element} the object to add.
     * - {Object} a JSON object with the settings for the Container to be added.
     * @param {Number} [index] An index in which the item will be added.
     * @chainable
     */
    Container.prototype.addItem = function (item, index) {
        var itemToBeAdded;
        if (this.factory) {
            itemToBeAdded = this.factory.make(item);
        }
        if (itemToBeAdded && !this.isDirectParentOf(itemToBeAdded)) {
            if (index !== null && index !== undefined) {
                this.items.insertAt(itemToBeAdded, index);
            } else {
                this.items.insert(itemToBeAdded);
            }
            itemToBeAdded.parent = this;
            if (!this.massiveAction) {
                this.paintItem(itemToBeAdded, index);
            }
            if (typeof this.onAdd === 'function') {
                index = typeof index === 'number' ? index : this.items.getSize() - 1;
                this.onAdd(this, this.getItem(index), index);
            }
        }
        return this;
    };
    /**
     * Clear all the object's current child items and add new ones
     * @param {Array} items An array where each element can be a {Element} object or a JSON object
     where is specified the setting for the child item to be added
     * @chainable
     */
    Container.prototype.setItems = function (items) {
        var i;
        if (jQuery.isArray(items)) {
            this.clearItems();
            this.massiveAction = false;
            for (i = 0; i < items.length; i += 1) {
                this.addItem(items[i]);
            }
        }
        return this;
    };
    /**
     * Returns an array with all the child elements
     * @return {Array}
     */
    Container.prototype.getItems = function () {
        return this.items.asArray();
    };
    /**
     * Returns one single item based on the id or index position
     * @param  {String|Number} id If the parameter is a string then
     it will be take as the id for the element to find and return,
     but if the element is a Number it returns the object iwth that
     index position
     * @return {PMUI.core.Element}
     */
    Container.prototype.getItem = function (i) {
        var t;
        if (typeof i === 'number') {
            t = this.items.get(i);
        } else if (typeof i === 'string') {
            t = this.items.find('id', i);
        } else if (this.items.indexOf(i) >= 0) {
            t = i;
        }
        return t;
    };
    /**
     * Returns the index for the specified item.
     * @param  {PMUI.core.Element|String} item It can be:
     *
     * - {@link PMUI.core.Element}
     * - String, it will be interpreted as the items's id.
     * @return {Number}
     */
    Container.prototype.getItemIndex = function (item) {
        var evaluatedItem;

        if (item instanceof PMUI.core.Element) {
            evaluatedItem = item;
        } else if (typeof item === 'number') {
            evaluatedItem = this.items.get(item);
        } else if (typeof item === 'string') {
            evaluatedItem = this.items.find("id", item);
        }

        return this.items.indexOf(evaluatedItem);
    };
    /**
     * Creates the object's HTML element
     * @return {HTMLElement}
     */
    Container.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }
        Container.superclass.prototype.createHTML.call(this);
        this.containmentArea = this.html;
        this.paintItems();
        this.style.applyStyle();
        this.setBehavior(this.behavior);

        return this.html;
    };
    /**
     * Moves an object's item from a position to another.
     * @param  {PMUI.core.Element} item The item to move.
     * @param  {Number} index The index position in which the item will be moved.
     * @chainable
     */
    Container.prototype.moveItem = function (item, index) {
        var items = this.items,
            currentIndex,
            referenceObject;

        item = this.getItem(item);

        if (item instanceof PMUI.core.Element && this.isDirectParentOf(item)) {
            currentIndex = items.indexOf(item);
            items = items.asArray();
            referenceObject = this.items.get(index + (currentIndex < index ? 1 : 0));
            item = items.splice(currentIndex, 1)[0];
            this.items.remove(item);
            this.items.insertAt(item, index);
            if (this.html) {
                if (index === this.items.getSize() - 1) {
                    this.containmentArea.appendChild(item.getHTML());
                } else {
                    this.containmentArea.insertBefore(item.getHTML(), referenceObject.getHTML());
                }
            }
        }
        return this;
    };
    /**
     * Returns the function to be executed when an accepted draggable is dragged over the droppable area.
     * @return {Function}
     */
    Container.prototype.onDragOver = function () {
        return function () {
        };
    };
    /**
     * Returns the function to be executed when the items order has been changed.
     * @return {Function}
     * @private
     */
    Container.prototype.onSortingChange = function () {
        var that = this;
        return function (e, ui) {
            var itemHTML = ui.item.get(0),
                item = PMUI.getPMUIObject(itemHTML),
                newIndex;
            newIndex = jQuery(that.getContainmentArea()).find('>*').index(itemHTML);

            that.moveItem(item, newIndex);
            if (typeof that.onSort === 'function') {
                that.onSort(that, item, newIndex);
            }
        };
    };
    /**
     * Handler to be executed everytime the mouse enter a position over any container's draggable/sortable item.
     * @param {PMUI.core.Element} draggable The draggable PMUI object.
     * @chainable
     */
    Container.prototype.onDraggableMouseOver = function (draggable) {
        return this;
    };
    /**
     * Handler to be executed everytime the mouse leaves a position over any container's draggable/sortable item.
     * @param {PMUI.core.Element} draggable The draggable PMUI object.
     * @chainable
     */
    Container.prototype.onDraggableMouseOut = function (draggable) {
        return this;
    };
    /**
     * Executes children events defined
     * @return {PMUI.core.Container}
     * @chainable
     */
    Container.prototype.defineEvents = function () {
        var j,
            children,
            that = this;
        Container.superclass.prototype.defineEvents.call(this);
        if (that.items.getSize() > 0) {
            children = that.getItems();
            for (j = 0; j < children.length; j += 1) {
                children[j].defineEvents();
            }
        }
        return this;
    };

    PMUI.extendNamespace('PMUI.core.Container', Container);

    // Publish to NodeJS environment
    if (typeof exports !== 'undefined') {
        module.exports = Container;
    }

}());
(function () {
    /**
     * @class  PMUI.core.Item
     * @extends PMUI.core.Container
     * Create a items container
     *
     * @constructor
     * Creates a new instance of the class
     * @param {Object} options Contructor object
     */
    var Item = function (options) {
        Item.superclass.call(this, options);

        /**
         * Parent object associated to this item
         * @type {Object}
         */
        this.parent = null;
        Item.prototype.init.call(this, options);
    };

    PMUI.inheritFrom('PMUI.core.Container', Item);

    /**
     * Defines the object's type
     * @type {String}
     */
    Item.prototype.type = "Item";

    /**
     * Defines the object's family
     * @type {String}
     */
    Item.prototype.family = "Item";

    /**
     * @private
     * Initializes the object with default values
     * @param  {Object} options
     */
    Item.prototype.init = function (options) {
        var defaults = {
            parent: null
        };
        jQuery.extend(true, defaults, options);
        this.setParent(defaults.parent);
    };

    /**
     * Sets the parent object of the current item
     * @param {Object} parent Parent object
     */
    Item.prototype.setParent = function (parent) {
        this.parent = parent;
        return this;
    };

    /**
     * Returns the parent object pointer
     * @return {Object}
     */
    Item.prototype.getParent = function () {
        return this.parent;
    };
    /**
     * Removes the item from its parent container.
     * @chainable
     */
    Item.prototype.remove = function () {
        if (this.parent) {
            this.parent.removeItem(this);
        }

        return this;
    };

    PMUI.extendNamespace('PMUI.core.Item', Item);

    if (typeof exports !== 'undefined') {
        module.exports = Item;
    }
}());
(function () {
    /**
     * @class PMUI.core.Panel
     * Handles panels to be inserted into containers, it is composed by three main elements: header, body and footer
     * @abstract
     * @extends {PMUI.core.Container}
     *
     *       //Remember, this is an abstract class so it shouldn't be instantiate,
     *       //anyway we are instantiating it just for this example
     *        var p1, p2, panel;
     *        p1 = new PMUI.core.Panel({
     *            height : 140,
     *            width : 90,
     *            display : 'inline-block',
     *            style : {
     *                cssProperties : {
     *                    'background-color':'red'
     *                }
     *            }
     *        });
     *        p2 = new PMUI.core.Panel({
     *            height : 140,
     *            width : 90,
     *            display : 'inline-block',
     *            style : {
     *                cssProperties : {
     *                    'background-color':'yellow'
     *                }
     *            }
     *        });
     *        panel = new PMUI.core.Panel({
     *            height : 150,
     *            width : 200,
     *            display : 'block',
     *            items : [
     *                p1,
     *                p2
     *            ],
     *            layout : 'vbox',
     *            padding : "5px",
     *            borderWidth : "1px",
     *            border : true
     *        });
     *        document.body.appendChild(panel.getHTML());
     *
     * @constructor
     * Creates a new instacne of the object
     * @param {Object} settings
     *
     * @cfg {Object|PMUI.core.Panel|null} [panel=null] The panel to be appended into the current Panel. It can be an
     * object literal with the {@link PMUI.core.Panel config options for Panel} or an instance of
     * {@link PMUI.core.Panel Panel} or null.
     * @cfg {PMUI.core.Container} [parent=null] The panel's parent element.
     * @cfg {String|PMUI.layout.Layout} [layout='box'] The layout to be applied to the panel, the layout determines the
     * render position for the panel's items. The possible layouts are:
     *
     * - box: this applies no layout to the panel. To set the layout to box if you use a string as value for the config
     * option use "box", in the other case, if you use an object, use an instance of {@link PMUI.layout.Box Box}.
     * - hbox: this applies a layout that renders the panel's items side by side using the items's
     * {@link PMUI.core.Element#property-propotion proportion property} to calculate the width for each item. To set
     * this layout to the panel, if you are using a string as the value for the config option, use "hbox", in the other
     * case, if you are using an object use an instance of {@link PMUI.layout.HBox HBox}.
     * - vbox: this applies a layout that renders the panel's items in vertical position using the items's
     * {@link PMUI.core.Element#property-propotion proportion property} to calculate the height for each item. To set
     * this layout to the panel, if you are using a string as the value for the config option, use "vbox", in the other
     * case, if you are using an object use an instance of {@link PMUI.layout.VBox VBox}.
     * @cfg {String|Number} [padding=""] Sets the css padding property for the panel.  It can be a number or and string
     * with the format ##px or an empty string. If you use an empty string as the parameter, the padding will be set
     * dinamically from the used css file.
     * @cfg {String|Number} [borderWidth=""] Sets the border width for the panel. It can be a number or a string with
     * the format '##px' or an empty string. If you use an empty string as the parameter, the border width will be set
     * dinamically from the used css file.
     */
    var Panel = function (settings) {
        Panel.superclass.call(this, settings);
        /**
         * The child {Panel} object
         * @type {PMUI.core.Panel}
         */
        this.panel = null;
        /**
         * The Panel's parent object
         * @type {PMUI.core.Container}
         */
        this.parent = null;
        /**
         * A {Layout} object which handles the position layout for the object's direct child elements
         * @property {PMUI.layout.Layout}
         */
        this.layout = null;
        /**
         * @property {String} [topPadding=""]
         * The value for the css padding-top property to be applied to the object's html.
         * @readonly
         */
        this.topPadding = null;
        /**
         * @property {String} [leftPadding=""]
         * The value for the css padding-left property to be applied to the object's html.
         * @readonly
         */
        this.leftPadding = null;
        /**
         * @property {String} [bottomPadding=""]
         * The value for the css padding-bottom property to be applied to the object's html.
         * @readonly
         */
        this.bottomPadding = null;
        /**
         * @property {String} [rightPadding=""]
         * The value for the css padding-right property to be applied to the object's html.
         * @readonly
         */
        this.rightPadding = null;
        /**
         * @property {String} [borderWidth=""] A string with the format ##px (where ## is a number).
         * It determines the panel's border width.
         * @readonly
         */
        this.borderWidth = null;
        /**
         * @property {Boolean} [border=false] If the border is being shown.
         * @readonly
         */
        this.border = null;
        Panel.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Container', Panel);

    /**
     * Defines the object's type
     * @type {String}
     */
    Panel.prototype.type = 'Panel';

    /**
     * @private
     * Initializes the object with default values
     * @param  {Object} options
     */
    Panel.prototype.init = function (settings) {
        var defaults = {
            panel: null,
            parent: null,
            layout: 'box',
            padding: "",
            borderWidth: ""
        };

        jQuery.extend(true, defaults, settings);

        this.setPanel(defaults.panel)
            .setParent(defaults.parent)
            .setLayout(defaults.layout)
            .setPadding(defaults.padding)
            .setBorderWidth(defaults.borderWidth);

    };
    /**
     * Applies the css classes and ptoperties to the element's html which the object is related
     * @chainable
     */
    Panel.prototype.applyStyle = function () {
        if (this.html) {
            this.style.applyStyle();

            this.style.addProperties({
                display: this.visible ? this.display : "none",
                position: this.positionMode,
                left: this.x,
                top: this.y,
                width: this.width,
                height: this.height,
                zIndex: this.zOrder,
                "padding-top": this.topPadding,
                "padding-right": this.rightPadding,
                "padding-bottom": this.bottomPadding,
                "padding-left": this.leftPadding,
                "border-width": this.borderWidth,
                "border-style": this.borderWidth !== "" ? "solid" : "",
                "box-sizing": "border-box"
            });
        }
        return this;
    };
    /**
     * Sets the border width for the panel
     * @param {String|Number} width It can be a number or a string with the format '##px' or an empty string.
     * If you use an empty string as the parameter, the border width will be set dinamically from the used css file.
     */
    Panel.prototype.setBorderWidth = function (width) {
        var error = false;
        if (typeof width === 'number') {
            this.borderWidth = width + "px";
        } else if (typeof width === 'string') {
            width = jQuery.trim(width);
            if (/^\d+(\.\d+)?px$/.test(width) || width === "") {
                this.borderWidth = width;
            } else {
                error = true;
            }
        } else {
            error = false;
        }

        if (error) {
            throw new Error("setBorderWidth(): invalid parameter.");
        } else {
            this.applyStyle();
            if (this.layout) {
                this.layout.applyLayout();
            }
        }

        return this;
    };
    /**
     * Returns the border width from the object
     * @return {String}
     */
    Panel.prototype.getBorderWidth = function () {
        return this.borderWidth || this.style.getProperty("border-width");
    };
    /**
     * Sets the padding values for the panel.
     * @param {String|Number} padding It can be a number or and string with the format ##px or an empty string.
     * If you use an empty string as the parameter, the padding will be set dinamically from the used css file.
     */
    Panel.prototype.setPadding = function (padding) {
        var error = false;
        if (typeof padding === 'string') {
            padding = jQuery.trim(padding);
            padding = padding.split(/\s+/).join(" ");
            if (/^(\d+(\.\d+)?(px|%)\s)+$/.test(padding + " ")) {
                padding = padding.match(/\d+(\.\d+)?(px|%)/g);
                switch (padding.length) {
                    case 4:
                        this.topPadding = padding[0];
                        this.rightPadding = padding[1];
                        this.bottomPadding = padding[2];
                        this.leftPadding = padding[3];
                        break;
                    case 3:
                        this.topPadding = padding[0];
                        this.rightPadding = this.leftPadding = padding[1];
                        this.bottomPadding = padding[2];
                        break;
                    case 2:
                        this.topPadding = this.bottomPadding = padding[0];
                        this.rightPadding = this.leftPadding = padding[1];
                        break;
                    case 1:
                        this.topPadding = this.rightPadding = this.bottomPadding = this.leftPadding = padding[0];
                        break;
                }
            } else if (padding === "") {
                this.topPadding = this.rightPadding = this.bottomPadding = this.leftPadding = "";
            } else {
                error = true;
            }
        } else if (typeof padding === 'number') {
            this.topPadding = this.rightPadding = this.bottomPadding = this.leftPadding = padding + "px";
        } else {
            error = true;
        }

        if (error) {
            throw new Error("setPadding(): Invalid parameter.");
        } else {
            this.applyStyle();
            if (this.layout) {
                this.layout.applyLayout();
            }
        }

        return this;
    };
    /**
     * Returns an array with the padding values in the following order: [top, right, bottom, left].
     * @return {Array}
     */
    Panel.prototype.getPadding = function () {
        return [
            this.topPadding || this.style.getProperty("padding-top"),
            this.rightPadding || this.style.getProperty("padding-right"),
            this.bottomPadding || this.style.getProperty("padding-bottom"),
            this.leftPadding || this.style.getProperty("padding-left")
        ];
    };
    /**
     * Sets the panel object
     * @param {Object} panel Panel object
     */
    Panel.prototype.setPanel = function (panel) {
        if (panel) {
            if (panel instanceof Panel) {
                this.panel = panel;
            } else if (typeof panel === 'object') {
                this.panel = new Panel(panel);
            }

            if (this.html) {
                jQuery(this.html).empty().append(panel.getHTML());
            }
        }

        return this;
    };
    /**
     * Returns the object's html usable width.
     * @return {Number|String} It can return a Number or an String with a css property like "auto".
     */
    Panel.prototype.getUsableWidth = function () {
        var padding = this.getPadding(), border = parseInt(this.getBorderWidth(), 10) * 2;
        if (isNaN(this.getWidth())) {
            return this.getWidth();
        }
        return this.getWidth() - (parseInt(padding[1], 10) || 0) - (parseInt(padding[3], 10) || 0) - (border || 0);
    };
    /**
     * Returns the object's html usable height
     * @return {Number|String} It can return a Number or an String with a css property like "auto".
     */
    Panel.prototype.getUsableHeight = function () {
        var padding = this.getPadding(), border = parseInt(this.getBorderWidth(), 10) * 2;
        if (isNaN(this.getHeight())) {
            return this.getHeight();
        }
        return this.getHeight() - (parseInt(padding[0], 10) || 0) - (parseInt(padding[2], 10) || 0) - (border || 0);
    };
    /**
     * Sets the parent object
     * @param {Object} parent
     */
    Panel.prototype.setParent = function (parent) {
        this.parent = parent;
        return this;
    };

    /**
     * Sets the layout for the panel.
     * @param {Object|String} layout Layout object
     */
    Panel.prototype.setLayout = function (layout) {
        var factory = new PMUI.layout.LayoutFactory();
        if (!(typeof layout === "string")) {
            throw new Error("setLayout(): Property values sent an invalid, expected 'box' , 'vbox' or 'hbox'");
        }
        this.layout = factory.make(layout);
        this.layout.setContainer(this);
        if (this.html) {
            this.layout.applyLayout();
        }
        return this;
    };

    /**
     * Add an item to the panel.
     * @param {PMUI.core.Element|Object} item.
     * @param {Number} [index] The index position in which the item will be appended.
     * It can be a valid JSON object or an object that inherits from {@link PMUI.core.Element Element}.
     * @chainable
     */
    Panel.prototype.addItem = function (item, index) {
        Panel.superclass.prototype.addItem.call(this, item, index);
        if (this.layout) {
            this.layout.applyLayout();
        }

        return this;
    };
    /**
     * Sets the width for the Panel's HTML element
     * @param {Number|String} width It can be a number or a string.
     * In case of using a String you only can use 'auto' or 'inherit' or ##px or ##% or ##em when ## is a number
     * @chainable
     */
    Panel.prototype.setWidth = function (width) {
        Panel.superclass.prototype.setWidth.call(this, width);
        if (this.layout) {
            this.layout.applyLayout();
        }

        return this;
    };
    /**
     * Sets the height for the Panel's HTML element
     * @param {Number|String} height It can be a number or a string.
     * In case of using a String you only can use 'auto' or 'inherit' or ##px or ##% or ##em when ## is a number
     * @chainable
     */
    Panel.prototype.setHeight = function (height) {
        Panel.superclass.prototype.setHeight.call(this, height);
        if (this.layout) {
            this.layout.applyLayout();
        }
        return this;
    };
    /**
     * Returns the object pointed to the parent
     * @return {Object}
     */
    Panel.prototype.getParent = function () {
        return this.parent;
    };
    /**
     * Creates the HTML element for the Panel
     * @return {HTMLElement}
     */
    Panel.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }

        Panel.superclass.prototype.createHTML.call(this);
        this.applyStyle();
        if (this.layout) {
            this.layout.applyLayout();
        }

        return this.html;
    };

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = Panel;
    }

    PMUI.extendNamespace('PMUI.core.Panel', Panel);
}());
(function () {
    /**
     * @class PMUI.control.Control
     * Class that encapsulates the basic bahavior for a form control.
     * Since this class is abstract it shouldn't be instantiated.
     * @extends PMUI.core.Element
     * @abstract
     *
     * Usage example (only for subclasses since this is an abstract class):
     *
     *      //Remember, this is an abstract class so it shouldn't be instantiate,
     *      //anyway we are instantiating it just for this example
     *      var myControl = new PMUI.control.Control({
     *          name: "phrase",
     *          value: "Sometimes the sun goes down!",
     *          disabled: false,
     *          onChange: function(currentValue, previousValue) {
     *              console.log(this.name + " has changed!");
     *              console.log("Its previous value was: " + previousValue);
     *              console.log("Its current value is: " + currentValue);
     *          }
     *      });
     *
     * @constructor
     * While it is true that this class must not be instantiated,
     * it is useful to mention the settings parameter for the constructor
     * function (which will be used for the non abstract subclasses).
     * The parameter for the constructor will be a JSON object whose properties are specified in the
     * {@link PMUI.control.Control#cfg-disabled Config Options section}.
     *
     * @cfg {String} [name=The object's ID] The name for the control. If it is not specified then the object's id is
     * used.
     * @cfg {String} [value=""] The initial value to be set to the control.
     * @cfg {PMUI.form.Field} [field=null] The parent {@link PMUI.form.Field Field} object for the control.
     * @cfg {Boolean} [disabled=false] A boolean value which determines if the control will be enabled or not.
     * @cfg {Function} [onChange=null] A callback function to be invoked when the control changes. For info about the
     * received parameters please read the {@link PMUI.control.Control#event-onChange onChange event} section.
     * @cfg {Function} [onBeforeChange=null] A callback function to be invoked after the control's value changes. The
     * function can return false to avoid the value changing. For info about the received parameter please read the
     * {@link #event-onBeforeChange onBeforeChange event} documentation.
     */
    var Control = function (settings) {
        Control.superclass.call(this, settings);
        /**
         * @property {String} [name=id] The control's name, it defaults to null.
         * @readonly
         */
        this.name = null;
        /**
         * @property {String} [value=""] The control's value.
         * @readonly
         */
        this.value = null;
        /**
         * @property {PMUI.form.Field} [field=null] The {@link PMUI.form.Field Field}
         object the current object belongs to.
         * @readonly
         */
        this.field = null;
        /**
         * @property {Boolean} [disabled=false] If the control is disabled or not.
         * @readonly
         */
        this.disabled = null;
        /**
         * @event onChange
         * Fired when the control's value is changed.
         * @param {String} newValue The new control's value.
         * @param {String} prevValue The previous control's value.
         */
        this.onChange = null;
        /**
         * @event onBeforeChange
         * Fired after the control's value changes.
         * @param {String} newValue The new control's value.
         * @param {String} prevValue The previous vontrol's value.
         */
        this.onBeforeChange = null;
        Control.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', Control);

    Control.prototype.type = "Control";
    /**
     * Initialize the object.
     * @param  {Object} settings The config options.
     */
    Control.prototype.init = function (settings) {
        var defaults = {
            name: this.id,
            value: "",
            field: null,
            disabled: false,
            onBeforeChange: null,
            onChange: null
        };

        $.extend(true, defaults, settings);

        this.setName(defaults.name)
            .setValue(defaults.value)
            .setField(defaults.field)
            .disable(defaults.disabled)
            .setOnBeforeChangeHandler(defaults.onBeforeChange)
            .setOnChangeHandler(defaults.onChange);
    };
    /**
     * Sets the callback function to be executed when the {@link #event-onBeforeChange onBeforeChange event} fires.
     * @param {Function|null} handler
     * @chainable
     */
    Control.prototype.setOnBeforeChangeHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error('setOnBeforeChangeHandler(): The parameter must be a function or null.');
        }
        this.onBeforeChange = handler;
        return this;
    };
    /**
     * Sets the control's name.
     * @param {String} name
     * @chainable
     */
    Control.prototype.setName = function (name) {
        if (typeof name === "string" || typeof name === "number") {
            this.name = name.toString();
            if (this.html) {
                this.html.setAttribute("name", name);
            }
        } else {
            throw new Error("The setName() method only accepts string or number values");
        }

        return this;
    };
    /**
     * Returns the control's name.
     * @return {String}
     */
    Control.prototype.getName = function () {
        return this.name;
    };
    /**
     * Sets the control's value.
     * @param {String} value
     * @chainable
     */
    Control.prototype.setValue = function (value) {
        if (typeof value !== 'undefined') {
            this.value = value.toString();
        } else {
            throw new Error("setValue(): a parameter is required.");
        }

        return this;
    };
    /**
     * Returns the control's value.
     * @return {String}
     */
    Control.prototype.getValue = function () {
        return this.value;
    };
    /**
     * Sets the control's parent {@link PMUI.form.Field Field} object.
     * @param {PMUI.form.Field}
     * @chainable
     */
    Control.prototype.setField = function (field) {
        if (field instanceof PMUI.form.Field) {
            this.field = field;
        }

        return this;
    };
    /**
     * Returns the control's parent {@link PMUI.form.Field Field} object.
     * @return {PMUI.form.Field}
     */
    Control.prototype.getField = function () {
        return this.field;
    };
    /**
     * Disables/enables the control.
     * @param {Boolean} disable If the value is evaluated as true then the control is disabled,
     otherwise the control is enabled.
     * @chainable
     */
    Control.prototype.disable = function (disable) {
        this.disabled = !!disable;
        return this;
    };
    /**
     * Returns true if the control is enabled, if it don't then it returns false
     * @return {Boolean}
     */
    Control.prototype.isEnabled = function () {
        return !this.disabled;
    };
    /**
     * Sets the callback function which will be executed everytime the control changes (using the interface).
     *
     * The callback function will receive two parameters:
     *
     * - first argument: the current control's value.
     * - second argument: the previous control's value.
     *
     *
     *          //Remember, this is an abstract class so it shouldn't be instantiate,
     *          //anyway we are instantiating it just for this example
     *          var myControl = new PMUI.control.Control({
     *              name: "phrase",
     *              value: "Sometimes the sun goes down!",
     *              disabled: false
     *          });
     *
     *          myControl.setOnChangeHandler(function(currentValue, previousValue) {
     *              console.log(this.name + " has changed!");
     *              console.log("Its previous value was: " + previousValue);
     *              console.log("Its current value is: " + currentValue);
     *          });
     *
     * @chainable
     */
    Control.prototype.setOnChangeHandler = function (handler) {
        if (typeof handler === 'function') {
            this.onChange = handler;
        }

        return this;
    };
    /**
     * Returns the control's value directly from the control's HTML element.
     *
     * This method is used internally by the object, so in most of the cases you won't need to invocated.
     * To get the control's value please use the {@link PMUI.control.Control#getValue getValue()} method.
     *
     * Since this is an abstract method, it must be implemented in its non-abstract subclasses
     * @return {String}
     * @abstract
     */
    Control.prototype.getValueFromRawElement = function () {
        throw new Error("Calling getValueFromRawElement() from PMUI.control.Control: this is an abstract method!");
    };
    /**
     * A method which is called everytime the control changes.
     *
     * This method is used internally by the object, so in most of the cases you won't need to invocated.
     * To execute instructions when the control changes, please use the
     {@link PMUI.control.Control#setOnChangeHandler setOnChangeHandler()} method.
     *
     * @chainable
     * @private
     */
    Control.prototype.onChangeHandler = function () {
        var prevValue = this.value, newValue = this.getValueFromRawElement(), resCallback;
        if (typeof this.onBeforeChange === 'function' && newValue !== prevValue) {
            resCallback = this.onBeforeChange(newValue, prevValue);
            if (resCallback === false) {
                newValue = prevValue;
                this.setValue(newValue);
            }
        }
        this.value = newValue;
        if (typeof this.onChange === 'function' && this.value !== prevValue) {
            this.onChange(this.value, prevValue);
        }

        return this;
    };
    /**
     * Attach the event listeners for the control's HTML element.
     *
     * Since this is an abstract method, it must be implemented in its non-abstract subclasses
     * @abstract
     * @chainable
     */
    Control.prototype.attachListeners = function () {
        throw new Error("Calling attachListeners() from PMUI.control.Control: this is an abstract method!");
    };
    /**
     * Creates the HTML element for the control.
     *
     * Since this is an abstract method, it must be implemented in its non-abstract subclasses
     * @return {HTMLElement}
     * @abstract
     */
    Control.prototype.createHTML = function () {
        Control.superclass.prototype.createHTML.call(this);
        return this.html;
    };
    /**
     * Returns the HTML element for the control
     * @return {HTMLElement}
     */
    Control.prototype.getHTML = function () {
        if (!this.html) {
            this.html = this.createHTML();
        }

        return this.html;
    };
    /**
     * @method setFocus
     * set the focus on control
     * @chainable
     */
    Control.prototype.setFocus = function () {
        if (this.html && this.html.focus) {
            this.html.focus();
        }
    };

    PMUI.extendNamespace('PMUI.control.Control', Control);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = Control;
    }
}());
(function () {
    /**
     * @class PMUI.control.HTMLControl
     * Class that encapsulates the HTML native control's behavior.
     * Since this class is abstract it shouldn't be instantiated.
     * @extends PMUI.control.Control
     * @abstract
     *
     * @constructor
     * While it is true that this class must not be instantiated,
     * it is useful to mention that the settings parameter for the constructor function
     * has the same structure that the one for the superclass
     * (for more info see the {@link PMUI.control.Control#constructor constructor} method for Control class).
     * @param {Object} [settings=null] A JSON object with the config options.
     */
    var HTMLControl = function (settings) {
        HTMLControl.superclass.call(this, settings);
        /**
         * @property {String} [elementTag='input'] The tag for the HTML element to be created.
         * @private
         */
        this.elementTag = 'input';
    };

    PMUI.inheritFrom('PMUI.control.Control', HTMLControl);

    HTMLControl.prototype.type = "HTMLControl";

    /**
     * Sets the value for the control
     * @param {String} value
     * @chainable
     */
    HTMLControl.prototype.setValue = function (value) {
        HTMLControl.superclass.prototype.setValue.call(this, value);
        if (this.html && this.html.value !== this.value) {
            this.html.value = this.value;
        }

        return this;
    };

    /**
     * Disables/enables the control
     * @param {Boolean} disable If the value is evaluated as true then the control
     is disabled, otherwise the control is enabled.
     * @chainable
     */
    HTMLControl.prototype.disable = function (disable) {
        HTMLControl.superclass.prototype.disable.call(this, disable);
        if (this.html) {
            this.html.disabled = this.disabled;
        }

        return this;
    };
    /**
     * Returns the control's value directly from the control's HTML element.
     *
     * This method is used internally by the object, so in most of the cases you won't need to invocated.
     * To get the control's value please use the {@link PMUI.control.Control#getValue getValue()} method.
     * @return {String}
     */
    HTMLControl.prototype.getValueFromRawElement = function () {
        return this.html.value;
    };
    /**
     * Attach the event listeners for the control's HTML element
     * @chainable
     */
    HTMLControl.prototype.defineEvents = function () {
        var that = this;
        HTMLControl.superclass.prototype.defineEvents.call(this);
        if (this.html) {
            this.addEvent('blur').listen(this.html, function () {
                that.onChangeHandler();
            });
            this.addEvent('keydown').listen(this.html, function (e) {
                if (e.which === PMUI.keyCodeF5) {
                    this.blur();
                    e.preventDefault();
                    window.location.reload(true);
                }
            });
        }
        return this;
    };
    /**
     * Creates the HTML element for the control.
     * @return {HTMLElement}
     */
    HTMLControl.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }
        HTMLControl.superclass.prototype.createHTML.call(this);
        this.setName(this.name)
            .setValue(this.value)
            .disable(this.disabled);

        return this.html;
    };

    PMUI.extendNamespace('PMUI.control.HTMLControl', HTMLControl);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = HTMLControl;
    }
}());
(function () {
    /**
     * @class PMUI.control.TextControl
     * Class for handle the HTML native text input control.
     * @extends PMUI.control.HTMLControl
     *
     * Quick usage example:
     *
     *      @example
     *      myTextbox = new PMUI.control.TextControl({
     *          name: "my_name",
     *          value: "John Doe",
     *          maxLength: 12,
     *          placeholder: "insert your name here",
     *          disabled: false,
     *          onChange: function(currentValue, previousValue) {
     *              if(previousValue !== "") {
     *                  alert("Your name is not \"" + previousValue + "\" anymore.\nNow it's \"" + currentValue + "\"");
     *              } else {
     *                  alert("Now your name is " + currentValue);
     *              }
     *          }
     *      });
     *
     *      document.body.appendChild(myTextbox.getHTML());
     *
     * @constructor
     * Creates a new instance of the TextControl object.
     * @param {Object} [settings=null] A JSON object with the config options.
     *
     * @cfg {String} [placeholder=""] A string to be used as the control's placeholder.
     * @cfg {Number} [maxLength=524288] A number which specifies the maximum character length the control can accept.
     * @cfg {Function} [onKeyUp=null] A callback function to be called every time a pressed key is released on the
     * control. For info about the callback parameters please read the
     * {@link PMUI.control.TextControl#event-onKeyUp onKeyUp event} section.
     */
    var TextControl = function (settings) {
        TextControl.superclass.call(this, settings);
        /**
         * @property {String} [placeholder=""]
         * The control's placeholder (the text to be shown inside the control when there is not any text in it).
         * @readonly
         */
        this.placeholder = null;
        /**
         * @property {Number} [maxLength=524288] The maximum character length the control accepts.
         * @readonly
         */
        this.maxLength = null;
        /**
         * @event onKeyUp
         * Fired when a pressed key is released.
         * @param {Object} event The event object.
         */
        this.onKeyUp = null;
        TextControl.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.HTMLControl', TextControl);

    TextControl.prototype.type = "TextControl";
    /**
     * Initializes the object.
     * @param  {Object} [settings=null] A JSON object with the config options.
     * @private
     */
    TextControl.prototype.init = function (settings) {
        var defaults = {
            placeholder: "",
            maxLength: 524288,
            onKeyUp: null,
            height: 30
        };

        $.extend(true, defaults, settings);

        this.setPlaceholder(defaults.placeholder)
            .setMaxLength(defaults.maxLength)
            .setOnKeyUpHandler(defaults.onKeyUp)
            .setHeight(defaults.height);

    };
    /**
     * Sets the callback function to be called when the keyup event occurs.
     * @chainable
     */
    TextControl.prototype.setOnKeyUpHandler = function (handler) {
        if (typeof handler === 'function') {
            this.onKeyUp = handler;
        }

        return this;
    };
    /**
     * Sets the placeholder test to show in the control when there's not ant value in it.
     * @param {String} placeholder
     * @chainable
     */
    TextControl.prototype.setPlaceholder = function (placeholder) {
        if (typeof placeholder === 'string') {
            this.placeholder = placeholder;
            if (this.html) {
                this.html.placeholder = placeholder;
            }
        }

        return this;
    };
    /**
     * Sets the maximun character number to be accepted in the control.
     * @param {Number} maxLength The number must be an integer.
     * If the value is minor or equal to 0 then the maxLength property is set to the default (524288).
     * @chainable>
     */
    TextControl.prototype.setMaxLength = function (maxLength) {
        if (typeof maxLength === 'number' && maxLength % 1 === 0) {
            this.maxLength = maxLength;
            if (this.html) {
                this.html.maxLength = maxLength > 0 ? maxLength : 524288;
            }
        } else {
            throw new Error("method setMaxLength() only accepts integer values.");
        }

        return this;
    };
    /**
     * Set a value in the parameter disabled.
     * @param {Boolean} value
     */
     TextControl.prototype.setDisabled = function (value) {
        if (typeof value === 'boolean') {
            this.disabled = value;
            if (this.html) {
                this.html.disabled = value;
            }
        } else {
            throw new Error("method setDisabled() only accepts boolean values.");
        }
    };
    /**
     * Set the events for the object.
     * @chainable
     */
    TextControl.prototype.defineEvents = function () {
        var that = this;
        TextControl.superclass.prototype.defineEvents.call(this);
        if (this.html) {
            this.addEvent('keyup').listen(this.html, function (e) {
                if (typeof that.onKeyUp === 'function') {
                    that.onKeyUp(e);
                }
                //if(e.which == 13){
                //    that.onChangeHandler();
                //}
            });
        }
        return this;
    };
    /**
     * Creates the HTML element for the object
     * @return {HTMLElement}
     */
    TextControl.prototype.createHTML = function () {
        TextControl.superclass.prototype.createHTML.call(this);
        this.html.type = "text";
        this.setPlaceholder(this.placeholder)
            .setMaxLength(this.maxLength)
            .setReadOnly(this.readonly);

        return this.html;
    };
    /**
     * Sets if the control will be enabled for read only.
     * @param {Boolean}
     * @chainable
     */
    TextControl.prototype.setReadOnly = function (readonly) {
        if (typeof readonly !== 'undefined') {
            this.readonly = !!readonly;
            if (this.html) {
                this.html.readOnly = this.readonly;
            }
        }
        return this;
    };
    /**
     * Returns true if the control is enabled for read only.
     * @return {Boolean}
     */
    TextControl.prototype.isReadOnly = function () {
        return this.readonly;
    };

    TextControl.prototype.getMaxLength = function () {
        return this.maxLength;
    }

    PMUI.extendNamespace('PMUI.control.TextControl', TextControl);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = TextControl;
    }
}());
(function () {
    /**
     * @class PMUI.control.PasswordControl
     * Class for handle the HTML native password input control.
     * @extends PMUI.control.HTMLControl
     *
     * Quick usage example:
     *
     *      @example
     *      myTextbox = new PMUI.control.PasswordControl({
     *          name: "my_name",
     *          value: "John Doe",
     *          maxLength: 12,
     *          disabled: false,
     *          onChange: function(currentValue, previousValue) {
     *              if(previousValue !== "") {
     *                  alert("Your name is not \"" + previousValue + "\" anymore.\nNow it's \"" + currentValue + "\"");
     *              } else {
     *                  alert("Now your name is " + currentValue);
     *              }
     *          }
     *      });
     *
     *      document.body.appendChild(myTextbox.getHTML());
     *
     * @constructor
     * Creates a new instance of the PasswordControl object.
     * @param {Object} [settings=null] A JSON object with the config options.
     *
     * @cfg {Number} [maxLength=524288] A number which specifies the maximum character length the control can accept.
     * @cfg {Function} [onKeyUp=null] A callback function to be called every time a pressed key is released on the
     * control. For info about the callback parameters please read the
     * {@link PMUI.control.PasswordControl#event-onKeyUp onKeyUp event} section.
     */
    var PasswordControl = function (settings) {
        PasswordControl.superclass.call(this, settings);
//        /**
//         * @property {String} [placeholder=""]
//         * The control's placeholder (the text to be shown inside the control when there is not any text in it).
//         * @readonly
//         */
//        this.placeholder = null;
        /**
         * @property {Number} [maxLength=524288] The maximum character length the control accepts.
         * @readonly
         */
        this.maxLength = null;
        /**
         * @event onKeyUp
         * Fired when a pressed key is released.
         * @param {Object} event The event object.
         */
        this.onKeyUp = null;
        PasswordControl.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.HTMLControl', PasswordControl);

    PasswordControl.prototype.type = "PasswordControl";
    /**
     * Initializes the object.
     * @param  {Object} [settings=null] A JSON object with the config options.
     * @private
     */
    PasswordControl.prototype.init = function (settings) {
        var defaults = {
            maxLength: 524288,
            onKeyUp: null,
            height: 30
        };

        $.extend(true, defaults, settings);

        this.setMaxLength(defaults.maxLength)
            .setOnKeyUpHandler(defaults.onKeyUp)
            .setHeight(defaults.height);
    };
    /**
     * Sets the callback function to be called when the keyup event occurs.
     * @chainable
     */
    PasswordControl.prototype.setOnKeyUpHandler = function (handler) {
        if (typeof handler === 'function') {
            this.onKeyUp = handler;
        }

        return this;
    };
    /**
     * Sets the maximun character number to be accepted in the control.
     * @param {Number} maxLength The number must be an integer.
     * If the value is minor or equal to 0 then the maxLength property is set to the default (524288).
     * @chainable>
     */
    PasswordControl.prototype.setMaxLength = function (maxLength) {
        if (typeof maxLength === 'number' && maxLength % 1 === 0) {
            this.maxLength = maxLength;
            if (this.html) {
                this.html.maxLength = maxLength > 0 ? maxLength : 524288;
            }
        } else {
            throw new Error("method setMaxLength() only accepts integer values.");
        }

        return this;
    };
    /**
     * Set the events for the object.
     * @chainable
     */
    PasswordControl.prototype.defineEvents = function () {
        var that = this;

        PasswordControl.superclass.prototype.defineEvents.call(this);
        this.addEvent('keyup').listen(this.html, function (e) {
            if (typeof that.onKeyUp === 'function') {
                that.onKeyUp(e);
            }
        });
        return this;
    };
    /**
     * Creates the HTML element for the object
     * @return {HTMLElement}
     */
    PasswordControl.prototype.createHTML = function () {
        PasswordControl.superclass.prototype.createHTML.call(this);
        this.html.type = "password";
        this.setMaxLength(this.maxLength);
        return this.html;
    };

    PMUI.extendNamespace('PMUI.control.PasswordControl', PasswordControl);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = PasswordControl;
    }
}());
(function () {
    /**
     * @class PMUI.control.DropDownListControl
     * @extends PMUI.control.HTMLControl
     * Class to handle the Select HTML form element.
     *
     * Example usage:
     *
     *      @example
     *      var control;
     *      $(function() {
     *          var settings = {
     *              name: "myList",
     *              options: [
     *                  {
     *                      label: "one",
     *                      value: 1
     *                  },
     *                  {
     *                      label: "two",
     *                      value: 2,
     *                      disabled: true
     *                  },
     *                  {
     *                      label: "three",
     *                      value: 3,
     *                      selected: true
     *                  }, 
     *                  {
     *                      label: "Letters",
     *                      options: [
     *                          {
     *                              value: "A"
     *                          },
     *                          {
     *                              value: "B"
     *                          }
     *                      ]
     *                  },
     *                  {
     *                      label: "months",
     *                      disabled: true,
     *                      options: [
     *                          {
     *                              value: "january"
     *                          },
     *                          {
     *                              value: "february"
     *                          }
     *                      ]
     *                  }
     *              ],
     *              value: 2
     *          };
     *          control = new PMUI.control.DropDownListControl(settings);
     *          document.body.appendChild(control.getHTML());
     *      });
     *
     * @constructor
     * Creates a new instance of the DropDownListControl.
     * @param {Object} [settings=null] An JSON object with the config options.
     */
    /**
     * @cfg {Array} [options=[]]
     * An array with all the options to be contained by the control.
     *
     * Each element in the array is a JSON object, this JSON object can represent an option group
     * or an option item.
     *
     * In case to represent an option item it can contain the next properties:
     *
     * - value {String} (required): the value for the option.
     * - label {String} (optional): the label for the option, if isn't specified the value is used instead.
     * - selected {Boolean} (optional): if the option is selected. #Note. If the configuration object has the
     * "value" propery set then this "selected" property will be
     * - disabled {Boolean} (optional): if the option is disabled or not.
     *
     * On the other hand, in case to represent an option group, it can contain the next properties:
     *
     * - label {String} (required): The name for the option group.
     * - disabled {Boolean} (optional): If the group is disabled or not.
     * - options {Array} (required): An array in which each element is a JSON object representing an option item,
     * so every item must have the structure explained above (for represent option items). #Note. This propery makes
     * the difference between an option and a option group. If the "options" property is not specified or if it isn't
     * an array then it will treated like a option item.
     * @cfg {String|Number} [value=null] The value of the option that is wanted to be selected. It must be one of the values
     * of the list options, otherwise it will be set to "".
     */
    var DropDownListControl = function (settings) {
        DropDownListControl.superclass.call(this, settings);
        /**
         * @property {Array} [options] An array with all the options/option groups form the control.
         * @private
         */
        this.options = [];
        /**
         * @property {String} [elementTag='input'] The tag for the HTML element to be created.
         * @private
         */
        this.elementTag = 'select';
        DropDownListControl.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.HTMLControl', DropDownListControl);

    DropDownListControl.prototype.type = "DropDownListControl";
    /**
     * Initializes the object.
     * @param  {Oject} [settings=null] A JSON opbject with the config options.
     * @private
     */
    DropDownListControl.prototype.init = function (settings) {
        var defaults = {
            options: [],
            value: null,
            height: 30
        };

        jQuery.extend(true, defaults, settings);

        this.setOptions(defaults.options);
        this.setHeight(defaults.height);

        if (defaults.value !== null) {
            this.setValue(defaults.value);
        }
    };
    /**
     * Clear all the options from the control.
     * @chainable
     */
    DropDownListControl.prototype.clearOptions = function () {
        this.options = [];
        if (this.html) {
            jQuery(this.html).empty();
        }
        this.value = "";
        return this;
    };
    /**
     * Enables or disables one or more options/option groups.
     * @param  {Boolean} disabled If the function will disable (use true) or enable (use false)
     * the options/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be enabled/disabled the options that match the string in its value and the
     * option groups that match the string in its label. In this case more than one single item can be
     * enabled/disabled.
     * - In case to be a Number, it will be enabled/disabled the option/option group which index position matches the
     * number. Obviously, in this case only one item will be enabled/disabled.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group label.
     * Using this parameter, the elements to be match by the second parameter will be search only in the option groups
     * that match this parameter in its label.
     * @chainable
     * @private
     */
    DropDownListControl.prototype.enableDisableOption = function (disabled, option, group) {
        var dataGroupTarget = this,
            htmlGroupTarget = jQuery(this.html),
            i,
            j,
            suboptions,
            objectDefaults = {
                applyTo: 'all'
            };
        disabled = !!disabled;

        if (group) {
            for (i = 0; i < this.options.length; i += 1) {
                if (this.options[i].isGroup && this.options[i].label === group) {
                    dataGroupTarget = this.options[i];
                    break;
                }
            }
            if (dataGroupTarget === this.options) {
                throw new Error('disableOption(): the group "' + group + '" wasn\'t found.');
            }
            htmlGroupTarget = jQuery(this.html).find('>optgroup[label="' + group + '"]');
        }

        if (typeof option === 'number') {
            dataGroupTarget.options[option].disabled = disabled;
            htmlGroupTarget.find(">*").eq(option).attr("disabled", disabled);
        } else if (typeof option === 'string') {
            for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                if (!dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].value === option) {
                    dataGroupTarget.options[i].disabled = disabled;
                } else if (dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].label === option) {
                    dataGroupTarget.options[i].disabled = disabled;
                    suboptions = dataGroupTarget.options[i].options;
                    for (j = 0; j < suboptions.length; j += 1) {
                        if (suboptions[j].value === option) {
                            suboptions[j].disabled = true;
                        }
                    }
                }
            }
            jQuery(htmlGroupTarget).find('option[value="' + option + '"]').add('optgroup[label="' + option + '"]')
                .attr("disabled", disabled);
        } else if (typeof option === 'object') {
            jQuery.extend(true, objectDefaults, option);
            if (objectDefaults.applyTo === 'groups') {
                for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                    if (dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].label === option.criteria) {
                        dataGroupTarget.options[i].disabled = disabled;
                    }
                }
                jQuery(htmlGroupTarget).find('optgroup[label="' + option.criteria + '"]').attr("disabled", disabled);
            } else if (objectDefaults.applyTo === 'options') {
                for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                    if (!dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].value === option.criteria) {
                        dataGroupTarget.options[i].disabled = disabled;
                    }
                }
                jQuery(htmlGroupTarget).find('option[value="' + option.criteria + '"]')
                    .attr("disabled", disabled.criteria);
            } else {
                option = option.criteria;
                for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                    if (!dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].value === option) {
                        dataGroupTarget.options[i].disabled = disabled;
                    } else if (dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].label === option) {
                        dataGroupTarget.options[i].disabled = disabled;
                        suboptions = dataGroupTarget.options[i].options;
                        for (j = 0; j < suboptions.length; j += 1) {
                            if (suboptions[j].value === option) {
                                suboptions[j].disabled = true;
                            }
                        }
                    }
                }
                jQuery(htmlGroupTarget).find('option[value="' + option + '"]').add('optgroup[label="' + option + '"]')
                    .attr("disabled", disabled);
            }
        } else {
            throw new Error('disableOption(): the first parameter must be a Number or a String.');
        }

        return this;
    };
    /**
     * Disables one or more options/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be disabled the options that match the string in its value and the option
     * groups which match the string in its label. In this case more than one single item can be disabled.
     * - In case to be a Number, it will be disabled the option/option group which index position matches the number.
     * Obviously, in this case only one item will be disabled.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group label.
     * Using this parameter, the elements to be match by the first parameter will be search only in the option groups
     * that match this parameter in its label.
     * @chainable
     */
    DropDownListControl.prototype.disableOption = function (option, group) {
        return this.enableDisableOption(true, option, group);
    };
    /**
     * Enables one or more options/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be enabled the options that match the string in its value and the option
     * groups which match the string in its label. In this case more than one single item can be enabled.
     * - In case to be a Number, it will be enabled the option/option group which index position matches the number.
     * Obviously, in this case only one item will be enabled.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group label.
     * Using this parameter, the elements to be match by the first parameter will be search only in the option groups
     * that match this parameter in its label.
     * @chainable
     */
    DropDownListControl.prototype.enableOption = function (option, group) {
        return this.enableDisableOption(false, option, group);
    };
    /**
     * Removes one or more option/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be removed the options that match the string in its value and the option
     * groups which match the string in its label. In this case more than one single item can be removed.
     * - In case to be a Number, it will be removed the option/option group which index position matches the number.
     * Obviously, in this case only one item will be removed.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group label.
     * Using this parameter, the elements to be match by the first parameter will be search only in the option groups
     * that match this parameter in its label.
     *
     * ##Note. Removing an option group implies removing all its child options.
     * @chainable
     */
    DropDownListControl.prototype.removeOption = function (option, group) {
        var dataGroupTarget = this, htmlGroupTarget = jQuery(this.html), i, j, suboptions,
            objectDefaults = {
                applyTo: 'all'
            };

        if (group) {
            for (i = 0; i < this.options.length; i += 1) {
                if (this.options[i].isGroup && this.options[i].label === group) {
                    dataGroupTarget = this.options[i];
                    break;
                }
            }
            if (dataGroupTarget === this.options) {
                throw new Error('disableOption(): the group "' + group + '" wasn\'t found.');
            }
            htmlGroupTarget = jQuery(this.html).find('>optgroup[label="' + group + '"]');
        }

        if (typeof option === 'number') {
            dataGroupTarget.options.splice(option, 1);
            htmlGroupTarget.find(">*").eq(option).remove();
        } else if (typeof option === 'string') {
            for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                if (!dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].value === option) {
                    dataGroupTarget.options.splice(i, 1);
                    i -= 1;
                } else if (dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].label === option) {
                    suboptions = dataGroupTarget.options[i].options;
                    for (j = 0; j < suboptions.length; j += 1) {
                        if (suboptions[j].value === option) {
                            suboptions.splice(j, 1);
                            j -= 1;
                        }
                    }
                    dataGroupTarget.options.splice(i, 1);
                    i -= 1;
                }
            }
            jQuery(htmlGroupTarget).find('option[value="' + option + '"]').add('optgroup[label="' + option + '"]')
                .remove();
        } else if (typeof option === 'object') {
            jQuery.extend(true, objectDefaults, option);
            if (objectDefaults.applyTo === 'groups') {
                for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                    if (dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].label === option.criteria) {
                        dataGroupTarget.options.splice(i, 1);
                        i -= 1;
                    }
                }
                jQuery(htmlGroupTarget).find('optgroup[label="' + option.criteria + '"]').remove();
            } else if (objectDefaults.applyTo === 'options') {
                for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                    if (!dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].value === option.criteria) {
                        dataGroupTarget.options.splice(i, 1);
                        i -= 1;
                    }
                }
                jQuery(htmlGroupTarget).find('option[value="' + option.criteria + '"]').remove();
            } else {
                option = option.criteria;
                for (i = 0; i < dataGroupTarget.options.length; i += 1) {
                    if ((!dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].value === option) ||
                        (dataGroupTarget.options[i].isGroup && dataGroupTarget.options[i].label === option)) {
                        dataGroupTarget.options.splice(i, 1);
                        i -= 1;
                    }
                }
                jQuery(htmlGroupTarget).find('option[value="' + option + '"]').add('optgroup[label="' + option + '"]')
                    .remove();
            }
        } else {
            throw new Error('disableOption(): the first parameter must be a Number or a String.');
        }

        return this;
    };
    /**
     * Adds a new option group to the control
     * @param {Object} optionGroup A JSON object with the following properties:
     *
     * - label {String} (required): the label for the option group.
     * - disabled {Boolean}(optional): if the option group will be disabled or not.
     * it defaults to false.
     * - options {Array} (optional): An array of JSON object, each one represents an option and
     * should have the same structure than the "option" paremeter for the
     * {@link PMUI.control.DropDownListControl#addOption addOption() method}.
     * @chainable
     */
    DropDownListControl.prototype.addOptionGroup = function (optionGroup) {
        var newOptionGroup = {},
            optionGroupHTML,
            i;

        if (!optionGroup.label) {
            throw new Error("addOptionGroup(): a label for the new option group is required!");
        }

        newOptionGroup.label = optionGroup.label;
        newOptionGroup.disabled = !!optionGroup.disabled;
        newOptionGroup.isGroup = true;
        newOptionGroup.options = [];

        this.options.push(newOptionGroup);

        if (this.html) {
            optionGroupHTML = PMUI.createHTMLElement('optgroup');
            optionGroupHTML.label = newOptionGroup.label;
            optionGroupHTML.disabled = newOptionGroup.disabled;
            this.html.appendChild(optionGroupHTML);
        }
        if (!jQuery.isArray(optionGroup.options)) {
            optionGroup.options = [];
        }
        for (i = 0; i < optionGroup.options.length; i += 1) {
            this.addOption(optionGroup.options[i], newOptionGroup.label);
        }

        return this;
    };
    /**
     * Adds a new option to the control or to an option group.
     * @param {Object} option An object with ther settings for the new option.
     * this object can have the following properties:
     *
     * - value {String} (required): the value for the option.
     * - label {String} (optional): the label for the option, if isn't specified the value is used instead.
     * - selected {Boolean} (optional): if the option is selected. #Note. If the configuration object has the
     * "value" propery set then this "selected" property will be
     * - disabled {Boolean} (optional): if the option is disabled or not.
     *
     * @param {String} group The name of the option group in which the new option will be added. If it doesn't exist
     * it will be created.
     *
     * @chainable
     */
    DropDownListControl.prototype.addOption = function (option, group) {
        var newOption = {},
            optionHTML,
            i,
            groupHTML,
            flag = false;

        newOption.value = option.value !== null && option.value !== undefined && option.value.toString ? option.value : (option.label || "");
        newOption.value = newOption.value.toString();
        newOption.label = option.label || newOption.value;
        newOption.label = newOption.label.toString();
        newOption.disabled = !!option.disabled;
        newOption.isGroup = false;

        if (!group) {
            this.options.push(newOption);
        } else {
            for (i = 0; i < this.options.length; i += 1) {
                if (this.options[i].isGroup && this.options[i].label === group) {
                    this.options[i].options.push(newOption);
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                this.addOptionGroup({
                    label: group
                });
                this.options[this.options.length - 1].options.push(newOption);
            }
        }

        if (this.html) {
            optionHTML = PMUI.createHTMLElement('option');
            optionHTML.value = newOption.value;
            optionHTML.selected = !!option.selected;
            optionHTML.label = newOption.label;
            optionHTML.disabled = newOption.disabled;
            optionHTML.textContent = optionHTML.label;

            if (group) {
                groupHTML = jQuery(this.html).find('optgroup[label="' + group + '"]');
                if (groupHTML.length) {
                    groupHTML.get(0).appendChild(optionHTML);
                } else {
                    throw new Error("addOption(): the optiongroup \"" + group + "\" wasn't found");
                }
            } else {
                jQuery(this.html).append(optionHTML);
            }
        }

        if (option.selected) {
            this.value = newOption.value;
        }
        if (this.getOptions().length == 1) {
            this.value = newOption.value;
        }
        return this;
    };
    /**
     * Returns the label from the option currently selected.
     * @return {String}
     */
    DropDownListControl.prototype.getSelectedLabel = function () {
        var i;
        if (this.html) {
            return jQuery(this.html).find('option:selected').attr('label');
        }
        for (i = 0; i < this.options.length; i += 1) {
            if (this.options[i].value === this.value) {
                return this.options[i].label;
            }
        }

        return "";
    };
    /**
     * Determines if a value exists in any of the list options.
     * @param  {String|Number} value The value to be searched
     * @return {Boolean} It returns true if the value was found in any of the list options, otherwise it returns false.
     */
    DropDownListControl.prototype.valueExistsInOptions = function (value) {
        var i,
            j,
            options,
            optionsLength,
            subOptions,
            subOptionsLength;

        optionsLength = (options = this.options || []).length;
        for (i = 0; i < optionsLength; i += 1) {
            if (options[i].isGroup) {
                subOptionsLength = (subOptions = options[i].options || []).length;
                for (j = 0; j < subOptionsLength; j += 1) {
                    if (subOptions[j].value == value) {
                        return true;
                    }
                }
            } else if (options[i].value == value) {
                return true;
            }
        }
        return false;
    };
    /**
     * Returns the first available option in the list.
     * @return {Object|null} It returns a object literal with the label and value properties from the found option.
     * @private
     */
    DropDownListControl.prototype.getFirstAvailableOption = function () {
        var i,
            j,
            options,
            optionsLength,
            subOptions,
            subOptionsLength;

        optionsLength = (options = this.options || []).length;
        for (i = 0; i < optionsLength; i += 1) {
            if (options[i].isGroup) {
                return (options[i].options.length && options[i].options[0]) || null;
            } else {
                return options[i];
            }
        }
        return null;
    }
    /**
     * Sets the options/option groups for the control.
     * @param {Array} options An array with the same structure that the
     * {@link PMUI.control.DropDownListControl#cfg-options "options"} property in the
     * Config options section.
     * @chainable
     */
    DropDownListControl.prototype.setOptions = function (options) {
        var i,
            valueExists,
            firstOption;
        if (jQuery.isArray(options)) {
            this.clearOptions();
            for (i = 0; i < options.length; i += 1) {
                if (jQuery.isArray(options[i].options)) {
                    this.addOptionGroup(options[i]);
                } else {
                    this.addOption(options[i]);
                }
            }
            if (!this.valueExistsInOptions(this.value)) {
                firstOption = this.getFirstAvailableOption();
                this.value = (firstOption && firstOption.value) || "";
            }
        }

        return this;
    };
    /**
     * Returns the options/option groups from the field
     * @param  {Boolean} [includeGroups=false] If it's evaluated as true then it will include
     * the option groups with its child elements, otherwise it will return only the option items.
     * @return {Array}
     *
     * example
     *    list.getOptions(false);
     *     [La Paz][Cochabamba][Santa Cruz][Buenos Aires][Santa Fe][Cordoba][Santiago][.][.][Mexico D.F]
     *
     *    list.getOptions(true)
     *      [BOLIVIA
     *          [La Paz][Cochabamba][SantaCruz]
     *      ]
     *      [ARGENTINA
     *          [Buenos Aires][Santa Fe][Cordoba]
     *       ]
     *      [CHILE
     *         [x][y][z]
     *      ]
     *      [New York]
     *      [Mexico D.F.]
     */
    DropDownListControl.prototype.getOptions = function (includeGroups) {
        var options = [],
            i,
            j;
        if (includeGroups) {
            return this.options.slice(0);
        }
        for (i = 0; i < this.options.length; i += 1) {
            if (!this.options[i].isGroup) {
                options.push(this.options[i]);
            } else {
                for (j = 0; j < this.options[i].options.length; j += 1) {
                    options.push(this.options[i].options[j]);
                }
            }
        }

        return options;
    };
    /**
     * Defines the events for the control
     * @chainable
     */
    DropDownListControl.prototype.defineEvents = function () {
        var that = this;
        DropDownListControl.superclass.superclass.prototype.defineEvents.call(this);
        if (this.html) {
            this.addEvent('change').listen(this.html, function () {
                that.onChangeHandler();
            });
        }
        return this;
    };
    /**
     * Sets the selected option in the dropdown.
     * @param {String|Number} value The value of the option that is wanted to be selected. It must be one of the values
     * of the list options, otherwise it will be set to "".
     */
    DropDownListControl.prototype.setValue = function (value) {
        var firstOption;
        if (!this.valueExistsInOptions(value)) {
            firstOption = this.getFirstAvailableOption();
            value = (firstOption && firstOption.value) || "";
        }
        return DropDownListControl.superclass.prototype.setValue.call(this, value);
    };
    /**
     * Creates the HTML element for the control.
     * @return {HTMLElement}
     */
    DropDownListControl.prototype.createHTML = function () {
        var value;
        if (this.html) {
            return this.html;
        }
        value = this.value;
        DropDownListControl.superclass.prototype.createHTML.call(this);
        this.setOptions(this.options.slice(0))
            .setValue(value);

        return this.html;
    };

    PMUI.extendNamespace('PMUI.control.DropDownListControl', DropDownListControl);
}());
(function () {
    /**
     * @class PMUI.control.TextAreaControl
     * Class to handle a HTML TextArea control.
     * @extends PMUI.control.TextControl
     *
     * Usage example:
     *
     *      @example
     *          var myTextArea;
     *          $(function() {
     *              myTextArea = new PMUI.control.TextAreaControl({
     *                  name: "some_text",
     *                  value: "John Doe",
     *                  maxLength: 12,
     *                  readonly: false,
     *                  width: 300,
     *                  height: 200,
     *                  placeholder: "insert some text",
     *                  disabled: false,
     *                  onChange: function(currentValue, previousValue) {
     *                      if(previousValue !== "") {
     *                          alert("the text is not \"" + previousValue + "\" anymore.\nNow it's \"" 
     *                              + currentValue + "\"");
     *                      } else {
     *                          alert("Now your name is " + currentValue);
     *                      }
     *                  }
     *              });
     *      
     *              document.body.appendChild(myTextArea.getHTML());
     *              
     *              myTextArea.defineEvents();
     *          });
     *
     * @constructor
     * Creates a new instance
     * @param {Object} [settings] A JSON object that can contain the properties specified in the
     * config options section.
     *
     * @cfg {Boolean} [readonly=false] If the control will be readonly.
     */
    var TextAreaControl = function (settings) {
        TextAreaControl.superclass.call(this, settings);
        /**
         * @property {Boolean} readonly A Boolean that specifies if the control is enabled for read only.
         * @readonly
         */
        this.readonly = null;
        /**
         * @property {String} [elementTag='input'] The tag for the HTML element to be created.
         * @private
         */
        this.elementTag = 'textarea';
        TextAreaControl.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.TextControl', TextAreaControl);

    TextAreaControl.prototype.type = "TextAreaControl";
    /**
     * Initializes the object.
     * @param  {Object} [settings=null] A JSON object with the config options.
     * @private
     */
    TextAreaControl.prototype.init = function (settings) {
        var defaults = {
            readonly: false
        };

        jQuery.extend(true, defaults, settings);

        this.setReadOnly(defaults.readonly);
    };
    /**
     * Creates the HTML element for the object
     * @return {HTMLElement}
     */
    TextAreaControl.prototype.createHTML = function () {
        TextAreaControl.superclass.prototype.createHTML.call(this);

        this.setReadOnly(this.readonly);

        return this.html;
    };
    /**
     * Sets the maximun character number to be accepted in the control.
     * @param {Number} maxLength The number must be an integer.
     * If the value is minor or equal to 0 then the maxLength property is set to the default (524288).
     * @chainable>
     */
    TextAreaControl.prototype.setMaxLength = function (maxLength) {
        var that = this;

        if (typeof maxLength === 'number' && maxLength % 1 === 0) {
            this.maxLength = maxLength;
            if (this.html) {
                this.html.maxLength = maxLength > 0 ? maxLength : 524288;
            }
        } else {
            throw new Error("method setMaxLength() only accepts integer values.");
        }

        return this;
    };
    PMUI.extendNamespace('PMUI.control.TextAreaControl', TextAreaControl);

    if (typeof exports !== "undefined") {
        module.exports = TextAreaControl;
    }
}());
(function () {
    /**
     * @class PMUI.control.SelectableControl
     * A checkbox is a graphical component that can be in either an "on" (true) or "off" (false) state.
     * Clicking on a check box changes its state from "on" to "off," or from "off" to "on."
     * @extends PMUI.control.HTMLControl
     *
     * Usage example:
     *
     *      @example
     *      var a;
     *      $(function() {
     *          a = new PMUI.control.SelectableControl({
     *              name: "music",
     *              label: "Do you like music?",
     *              value: true,
     *              mode: 'checkbox', //it also can be "radio"
     *              onSelect: function() {
     *                  console.log("checked");
     *              },
     *              onDeselect: function() {
     *                  console.log("unchecked");
     *              }
     *          });
     *          document.body.appendChild(a.getHTML());
     *          a.defineEvents();
     *      });
     *
     * @constructor
     * Creates a new instance of the SelectableControl class.
     * @param {Object} [settings=null] A JSON object with the config options.
     *
     * @cfg {Boolean} [selected=false] If the control will be selected initially.
     * @cfg {String} [label=""] The label for the control.
     * @cfg {String} [value=""] The value for the control.
     * @cfg {Function} [onSelect=null] The function to be call when the item will be selected. For info about the
     * parameters please read the {@link PMUI.control.SelectableControl#event-onSelect onSelect event} documentation.
     * @cfg {Function} [onDeselect=null] The function to be call when the item will be deselected
     * (only supported when the mode is set to "checkbox"). For info about the callback parameters please read the
     * {@link PMUI.control.SelectableControl#event-onDeselect onDeselect event} documentation.
     * @cfg {String} [mode="checkbox"] The mode for the control, it can be: "checkbox" (default)
     * for a checkbox control or "radio" for a readio button.
     */
    var SelectableControl = function (settings) {
        SelectableControl.superclass.call(this, settings);
        /**
         * If the control is selected or not.
         * @type {Boolean}
         * @readonly
         */
        this.selected = null;
        /**
         * The control's label.
         * @type {String}
         * @readonly
         */
        this.label = null;
        /**
         * @event onSelect
         * Fired when the control is selected.
         */
        this.onSelect = null;
        /**
         * @event onDeselect
         * Fired when the control is deselected.
         */
        this.onDeselect = null;
        /**
         * The control's selection mode.
         * @type {String}
         * @readonly
         */
        this.mode = null;
        /**
         * The interactive control's HTML element.
         * @type {HTMLElement}
         * @private
         */
        this.control = null;
        /**
         * The control's HTML element that will contain the label text.
         * @type {[type]}
         */
        this.textContainer = null;
        SelectableControl.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.HTMLControl', SelectableControl);
    /**
     * The object's type.
     * @type {String}
     */
    SelectableControl.prototype.type = 'SelectableControl';
    /**
     * Initializes the object.
     * @param  {Object} [settings=null] A JSON object with the config options.
     * @private
     */
    SelectableControl.prototype.init = function (settings) {
        var defaults = {
            selected: false,
            mode: 'checkbox',
            label: '',
            value: "",
            onSelect: null,
            onDeselect: null
        };

        jQuery.extend(true, defaults, settings);

        if (defaults.mode === 'checkbox' || defaults.mode === 'radio') {
            this.mode = defaults.mode;
        } else {
            throw new Error('SelectableControl: it only accepts "checkbox" and "radio" as value for the "mode"'
                + ' property');
        }
        this.onSelect = defaults.onSelect;
        this.onDeselect = defaults.onDeselect;

        this.setLabel(defaults.label);

        if (defaults.selected) {
            this.select();
        } else {
            this.deselect();
        }
    };
    /**
     * Sets the control's name
     * @param {String} name
     * @chainable
     */
    SelectableControl.prototype.setName = function (name) {
        SelectableControl.superclass.prototype.setName.call(this, name);
        if (this.control) {
            this.control.name = name;
        }

        return this;
    };
    /**
     * Sets the value for the control
     * @param {String|Boolean|Number} setValue This param value is evaluated as boolean.
     * @chainable
     */
    SelectableControl.prototype.setValue = function (value) {
        SelectableControl.superclass.superclass.prototype.setValue.call(this, value);
        if (this.control) {
            this.control.value = value;
        }
        return this;
    };
    /**
     * Returns a boolean that specifies if the checkbox/radio button is selected.
     * @return {Boolean}
     */
    SelectableControl.prototype.isSelected = function () {
        if (this.html) {
            this.selected = jQuery(this.control).is(':checked');
        }
        return this.selected;
    };
    /**
     * Sets deselected the checkbox/radio button.
     * @chainable
     */
    SelectableControl.prototype.deselect = function () {
        this.selected = false;

        if (this.control) {
            this.control.checked = false;
        }

        return this;
    };
    /**
     * Sets selected the checkbox/radio button.
     * @chainable
     */
    SelectableControl.prototype.select = function () {
        this.selected = true;

        if (this.control) {
            this.control.checked = true;
        }

        return this;
    };
    /**
     * A method which is called everytime the checked state from the control changes.
     *
     * This method is used internally by the object, so in most of the cases you won't need to invocated.
     * To execute instructions when the control changes, please use the
     {@link PMUI.control.Control#setOnChangeHandler setOnChangeHandler()} method.
     *
     * @chainable
     * @private
     */
    SelectableControl.prototype.onChangeHandler = function () {
        this.selected = $(this.control).is(":checked");
        if (typeof this.onChange === 'function') {
            this.onChange(this.value, this.value);
        }
        if (this.selected && typeof this.onSelect === 'function') {
            this.onSelect();
        } else if (!this.selected && typeof this.onDeselect === 'function') {
            this.onDeselect();
        }

        return this;
    };
    /**
     * Sets the label for the control.
     * @param {String} label
     * @chainable
     */
    SelectableControl.prototype.setLabel = function (label) {
        if (typeof label !== 'string') {
            throw new Error("setLabel(): it only accepts string type values.");
        }
        this.label = label;
        if (this.html) {
            this.textContainer.textContent = label;
        }

        return this;
    };
    /**
     * Disables/enables the control
     * @param {Boolean} disable If the value is evaluated as true then the control
     is disabled, otherwise the control is enabled.
     * @chainable
     */
    SelectableControl.prototype.disable = function (disable) {
        SelectableControl.superclass.superclass.prototype.disable.call(this, disable);
        if (this.html) {
            this.control.disabled = this.disabled;
        }

        return this;
    };
    /**
     * @inheritDoc
     */
    SelectableControl.prototype.defineEvents = function () {
        var that = this,
            stopPropagation = function (e) {
                e.stopPropagation();
            };
        this.removeEvents();
        this.eventsDefined = true;
        if (this.html) {
            this.addEvent('change').listen(this.html, function () {
                that.onChangeHandler();
            });
            this.addEvent('keydown').listen(this.html, function (e) {
                if (e.which === PMUI.keyCodeF5) {
                    this.blur();
                    e.preventDefault();
                    window.location.reload(true);
                }
            });
        }
        return this;
    };
    /**
     * Creates the HTML element for the control.
     * @return {HTMLElement}
     */
    SelectableControl.prototype.createHTML = function () {
        var label,
            textContainer,
            control;
        if (this.html) {
            return this.html;
        }
        label = PMUI.createHTMLElement('label');
        control = PMUI.createHTMLElement('input');
        control.type = this.mode;
        textContainer = PMUI.createHTMLElement('span');
        textContainer.contentText = this.label;

        label.appendChild(control);
        label.appendChild(textContainer);
        this.control = control;
        this.textContainer = textContainer;
        this.html = label;

        this.html.id = this.id;

        this.setName(this.name)
            .setValue(this.value)
            .disable(this.disabled)
            .setLabel(this.label);

        if (this.selected) {
            this.select();
        } else {
            this.deselect();
        }

        this.applyStyle();

        return this.html;
    };

    SelectableControl.prototype.setFocus = function () {
        if (this.html) {
            this.control.focus();
        }
    };

    PMUI.extendNamespace('PMUI.control.SelectableControl', SelectableControl);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = SelectableControl;
    }
}());
(function () {
    /**
     * @class PMUI.control.HiddenControl
     * The HTML input tag with the type attribute set to "hidden".
     * @extends PMUI.control.HTMLControl
     *
     * Usage example:
     *
     *     var hiddenControl = new PMUI.control.HiddenControl();
     *
     *     document.body.appendChild(hiddenControl.getHTML());
     *
     * @constructor
     * Creates a new instance of the HiddenControl class.
     * @param {Object} [settings=null] A JSON object with the config options.
     */
    var HiddenControl = function (settings) {
        HiddenControl.superclass.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.HTMLControl', HiddenControl);

    HiddenControl.prototype.type = "HiddenControl";

    /**
     * Creates the HTML element for the control.
     * @return {HTMLElement}
     */
    HiddenControl.prototype.createHTML = function () {
        HiddenControl.superclass.prototype.createHTML.call(this);
        this.html.type = 'hidden';

        return this.html;
    };

    PMUI.extendNamespace('PMUI.control.HiddenControl', HiddenControl);

    if (typeof exports !== "undefined") {
        module.exports = HiddenControl;
    }
}());
(function () {
    /**
     * @class  PMUI.control.DateTimeControl
     * A control to handle dates and times.
     * @extends {PMUI.control.HTMLControl}
     *
     *
     * Usage example:
     *
     *      @example
     *      var dateTimePicker;
     *
     *      $(function() {
     *          dateTimePicker = new PMUI.control.DateTimeControl({
     *              dateFormat: 'M dd yy',
     *              minDate: -90,
     *              maxDate: "+1y -1m -4d",
     *              firstDay: 1,
     *              months: {
     *                  "january": {
     *                      name: "Enero",
     *                      shortname: "Ene"
     *                  },
     *                  "february": {
     *                      name: "Febrero",
     *                      shortname: "Feb"
     *                  },
     *                  "march": {
     *                      name: "Marzo",
     *                      shortname: "Mar"
     *                  },
     *                  "april": {
     *                      name: "Abril",
     *                      shortname: "Abr"
     *                  },
     *                  "may": "May",
     *                  "june": "Junio",
     *                  "july": "July",
     *                  "august": "Agosto",
     *                  "september": "Septiembre",
     *                  "october": "Octubre",
     *                  "november": "Noviembre",
     *                  "december": "Diciembre"
     *              },
     *              days: {
     *                  "sunday": {
     *                      name: "Domingo",
     *                      shortname: "Do"
     *                  },
     *                  "monday": {
     *                      name: "Lunes",
     *                      shortname: "Lu"
     *                  },
     *                  "tuesday": {
     *                      name: "Martes",
     *                      shortname: "Ma"
     *                  },
     *                  "wednesday": {
     *                      name: "Miércoles",
     *                      shortname: "Mi"
     *                  },
     *                  "thursday": {
     *                      name: "Jueves",
     *                      shortname: "Ju"
     *                  },
     *                  "friday": "Viernes",
     *                  "saturday": "Sábado"
     *              }
     *          });
     *          document.body.appendChild(dateTimePicker.getHTML());
     *          dateTimePicker.defineEvents();
     *      });
     *
     * @cfg {Boolean} [datetime=false] If the control will have time supporting.
     * @cfg {String} [dateFormat="yy-mm-dd HH:ii:ss"|"yy-mm-dd"] The format for the date to show in the text box.
     * It defaults to:
     *
     * - "yy-mm-dd HH:ii:ss" if {@link PMUI.control.DateTimeControl#cfg-datetime datetime} is set to true.
     * - "yy-mm-dd" if {@link PMUI.control.DateTimeControl#cfg-datetime datetime} is set to false.
     *
     * You can set a customized date format using the following wildcards:
     *
     * - d, day of month (no leading zero).
     * - dd, day of month (two digit).
     * - o, day of the year (no leading zeros).
     * - oo, day of the year (three digit).
     * - D, day name short.
     * - DD, day name long.
     * - m, month of year (no leading zero).
     * - mm, month of year (two digit).
     * - M, month name short.
     * - MM, month name long.
     * - y, year (two digit).
     * - yy, year (four digit).
     * - P, period (AM or PM).
     * - H, hours (0-23).
     * - HH, hours (00-23).
     * - h, hours (1-12).
     * - hh, hours (01-12).
     * - i, minutes (0-59).
     * - ii, minutes (00-59).
     * - s, seconds (0-59).
     * - ss, seconds (00-59).
     * - @, Unix timestamp (ms since 01/01/1970).
     * - !, Windows ticks (100ns since 01/01/0001).
     * - '...', literal text.
     * - '', single quote.
     * - anything else, literal text.
     *
     * The wildcards can be used together in the same string.
     *
     * @cfg {Object} [months={"january": "January", "february": "February", "march": "March", "april": "April",
     * "may": "May", "june": "June", "july": "July", "august": "August", "september": "September",
     * "october": "October", "november": "November", "december": "December"}]
     * A JSON object to set the names and shortnames for every month in year. Each property of this object can be:
     *
     * - A string, in this case the name for the month is set to this string, and the shortname is set using
     * the first 3 characters of the string.
     * - A JSON object, in this case the JSON may have two properties:
     *     - "name", will be used as the name for the month.
     *     - "shortname", will be used as the shortname for the month, if it is not specified the the shortname for
     *     the month will be set using the first 3 characters of the object's "name" property.
     *
     * @cfg {Object} [days={"sunday": "Sunday","monday": "Monday","tuesday": "Tuesday","wednesday": "Wednesday",
     * "thursday": "Thursday","friday": "Friday","saturday": "Saturday"}]
     * A JSON object to set the name and shortname for every day of week. Each property of this object can be:
     *
     * - A string, in this case the name for the day is set to this string, and the shortname is set using
     * the first 3 characters of the string.
     * - A JSON object, in this case the JSON may have two properties:
     *     - "name", will be used as the name for the day.
     *     - "shortname", will be used as the shortname for the day, if it is not specified the the shortname for
     *     the day will be set using the first 3 characters of the object's "name" property.
     *
     * @cfg {String|Number} [minDate=-365] A value which sets the minimum selectable date for the calendar. It can be:
     *
     * - a Date object.
     * - a String with the following format: "([+-]\d+[dmyw]\s)?". It will represent an addition or substraction of
     * time units to the current date, for example the expression "+1y -2m +3d" means
     * "the current date plus 1 year, minus 2 months plus 3 days". The prefixes you can use are:
     *     - "d" for days.
     *     - "w" for weeks.
     *     - "m" for months.
     *     - "y" for years.
     *
     *     You can also use one single unit, i.e. "+3y", "-1m", or a combination of two: "-2y +3d", etc.
     * - a Number, in this case the number is taken as the number of days that will be sum/substracted from the
     * current date. This number can be positive (for add days) or negative (for substract days).
     * - an Object, in this case the object must have the following structure:
     *
     *      {
     *          year: 2013,
     *          month: 5,
     *          day: 4,
     *          hours: 20,
     *          minutes: 15,
     *          seconds: 3,
     *          millisenconds
     *      }
     *
     * In this case only year and month are required.
     *
     * @cfg {String|Number} [maxDate=365] A value which sets the maximum selectable date for the calendar. It can take
     * the same type of values that the {@link PMUI.contriol.DateTimeControl#cfg-minDate minDate config option}.
     *
     * - a Date object.
     * - a String with the following format: "([+-]\d+[dmyw]\s)?". It will represent an addition or substraction of
     * time units to the current date, for example the expression "+1y -2m +3d" means
     * "the current date plus 1 year, minus 2 months plus 3 days". The prefixes you can use are:
     *     - "d" for days.
     *     - "w" for weeks.
     *     - "m" for months.
     *     - "y" for years.
     *
     *     You can also use one single unit, i.e. "+3y", "-1m", or a combination of two: "-2y +3d", etc.
     * - a Number, in this case the number is taken as the number of days that will be sum/substracted from the
     * current date. This number can be positive (for add days) or negative (for substract days).
     * - an Object, in this case the object must have the following structure:
     *
     *      {
     *          year: 2013,
     *          month: 5,
     *          day: 4,
     *          hours: 20,
     *          minutes: 15,
     *          seconds: 3,
     *          millisenconds
     *      }
     *
     * In this case only year and month are required.
     *
     * @cfg {Number} [firstDay=0] Sets the first day of week. You can use numbers from 0 to 6, 0 means Sunday,
     * 1 means Monday and so on.
     */
    var DateTimeControl = function (settings) {
        DateTimeControl.superclass.call(this, settings);
        /**
         * @property {Object} dom A JSON object that contains the control's DOM elements.
         * @private
         */
        this.dom = {};
        /**
         * @property {Boolean} datetime If the calendar has time supporting.
         * @readonly
         */
        this.datetime = null;
        /**
         * @property {String} dateFormat The format for the date to be shown on the control's textbox.
         * @readonly
         */
        this.dateFormat = null;
        /**
         * @property {Date} dateObject The control's date object.
         * @private
         */
        this.dateObject = null;
        /**
         * @property {Date} minDate The minimum selectable date.
         * @private
         */
        this.minDate = null;
        /**
         * @property {Date} maxDate The maximum selectable date.
         * @private
         */
        this.maxDate = null;
        /**
         * @property {Number} firstDay The first day of the week beginning with 0: Sunday and ending with 6: Saturday.
         * @readonly
         */
        this.firstDay = null;
        DateTimeControl.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.control.HTMLControl', DateTimeControl);

    DateTimeControl.prototype.type = "DateTimeControl";

    /**
     * An array with the name of each day of the week.
     * @type {Array}
     * @private
     */
    DateTimeControl.prototype.daysOrder = [
        "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"
    ];
    /**
     * An array with the name fo the months of year.
     * @type {Array}
     * @private
     */
    DateTimeControl.prototype.monthsOrder = [
        "january", "february", "march", "april", "may", "june", "july", "august", "september", "october",
        "november", "december"
    ];
    /**
     * An Object that contains the name, shortname and code for the days of the week.
     * @type {Object}
     * @private
     */
    DateTimeControl.prototype.days = {
        "sunday": {
            value: 0
        },
        "monday": {
            value: 1
        },
        "tuesday": {
            value: 2
        },
        "wednesday": {
            value: 3
        },
        "thursday": {
            value: 4
        },
        "friday": {
            value: 5
        },
        "saturday": {
            value: 6
        }
    };
    /**
     * An Object that contains the name, shortname and code for the months of year.
     * @type {Object}
     * @private
     */
    DateTimeControl.prototype.months = {
        "january": {
            value: 0
        },
        "february": {
            value: 1
        },
        "march": {
            value: 2
        },
        "april": {
            value: 3
        },
        "may": {
            value: 4
        },
        "june": {
            value: 5
        },
        "july": {
            value: 6
        },
        "august": {
            value: 7
        },
        "september": {
            value: 8
        },
        "october": {
            value: 9
        },
        "november": {
            value: 10
        },
        "december": {
            value: 11
        }
    };
    /**
     * Initialize the object.
     * @param  {Object} settings An object with the config options.
     * @private
     */
    DateTimeControl.prototype.init = function (settings) {
        var defaults = {
            datetime: false,
            dateFormat: settings && settings.datetime ? 'yy-mm-dd HH:ii:ss' : 'yy-mm-dd',
            months: {
                "january": "January",
                "february": "February",
                "march": "March",
                "april": "April",
                "may": "May",
                "june": "June",
                "july": "July",
                "august": "August",
                "september": "September",
                "october": "October",
                "november": "November",
                "december": "December"
            },
            days: {
                "sunday": "Sunday",
                "monday": "Monday",
                "tuesday": "Tuesday",
                "wednesday": "Wednesday",
                "thursday": "Thursday",
                "friday": "Friday",
                "saturday": "Saturday"
            },
            minDate: -365,
            maxDate: 365,
            firstDay: 0,
            height: 30

        };

        jQuery.extend(true, defaults, settings);

        this.setFirstDay(defaults.firstDay)
            .setDateFormat(defaults.dateFormat)
            .setMonths(defaults.months)
            .setDays(defaults.days)
            .setMinDate(defaults.minDate)
            .setMaxDate(defaults.maxDate)
            .visibleDateTime(defaults.datetime)
            .setHeight(defaults.height);
    };
    /**
     * @inheritdoc
     */
    DateTimeControl.prototype.setID = function (id) {
        DateTimeControl.superclass.prototype.setID.call(this, id);
        if (this.dom) {
            this.dom.calendar.id = 'pmui-datepicker-calendar-' + this.id;
        }
        return this;
    };
    /**
     * Returns the day index of the first day of week.
     * @return {Number} A number refering a day: 0 for Sunday, 1 for Monday and so on.
     */
    DateTimeControl.prototype.getFirstDay = function () {
        return this.firstDay;
    };
    /**
     * Returns the control's minimum selectable date.
     * @param {String} [format="UTC"] The format to applied to the returning date.
     * @return {String} The minimum selectable date in string format.
     */
    DateTimeControl.prototype.getMinDate = function (format) {
        return this.formatDate(this.minDate, format || "UTC");
    };
    /**
     * Returns the control's maximum selectable date.
     * @param {String} [format="UTC"] The format to applied to the returning date.
     * @return {String} The maximum selectable date in string format.
     */
    DateTimeControl.prototype.getMaxDate = function (format) {
        return this.formatDate(this.maxDate, format || "UTC");
    };
    /**
     * Enables/disabled the calendar's time supporting.
     * @param  {Boolean} visible If it's true, then the time supporting is enabled, otherwise it's disabled.
     * @chainable
     */
    DateTimeControl.prototype.visibleDateTime = function (visible) {
        visible = !!visible;
        this.datetime = visible;
        if (this.html) {
            this.dom.footer.style.display = this.datetime ? 'block' : 'none';
        }

        return this;
    };
    /**
     * @method  setValue
     * Sets the value for the Control.
     * @param {Date|Number|String} value The date to set to the control, it can be:
     *
     *  - A Date object, is used the date set in this object.
     *  - A Number, the number is used as the timestamp for the date (set in UTC).
     *  - A String, in this case the string must have one of the following formats:
     *
     *      - "" (empty string), the value is set to empty.
     *      - "\d", the value is parsed to a number to be used as the timestamp for the date.
     *      - "\d{4}\-\d{2}\-\d{2}", this date is taken as "yyyy-mm-dd" and it's parsed.
     *      - "\d{4}\-\d{2}\-\d{2}T\d{2}\:\d{2}\:\d{2}[\\+\-]\d{2}\:\d{2}", the date is taken as
     *      "yyyy-mm-ddTHH:ii:ss+HH:ii" (the timezone offset is used).
     *
     * @param {Boolean} [utc=false] If the date will be set as a UTC date.
     * (Only applicable if the first parameter is String and has the format "\d{4}\-\d{2}\-\d{2}").
     * @chainable
     */
    DateTimeControl.prototype.setValue = function (value, utc) {
        var newDate, aux, aux2, y, m, d, h, i, s, hd, id, datetime = false, error = false;
        if (value instanceof Date) {
            newDate = value;
        } else if (typeof value === 'number') {
            newDate = new Date(value);
        } else if (typeof value === 'string') {
            if (value === "") {
                this.dateObject = null;
            } else if (/^\d+$/.test(value)) {
                newDate = new Date(parseInt(value, 10));
            } else if (/^\d{4}\-\d{2}\-\d{2}$/.test(value)
                || /^\d{4}\-\d{2}\-\d{2}T\d{2}\:\d{2}\:\d{2}[\\+\-]\d{2}\:\d{2}$/.test(value)) {
                newDate = new Date();
                aux = value.split(/T|\+|\-(?=\d{2}\:\d{2})/);
                aux2 = aux[0].split("-");
                y = parseInt(aux2[0], 10);
                m = parseInt(aux2[1], 10);
                d = parseInt(aux2[2], 10);
                if (aux[1]) {
                    datetime = true;
                    aux2 = aux[1].split(":");
                    h = parseInt(aux2[0], 10);
                    i = parseInt(aux2[1], 10);
                    s = parseInt(aux2[2], 10);
                    aux2 = aux[2].split(":");
                    hd = (value[19] === '+' ? -1 : 1) * parseInt(aux2[0], 10);
                    id = (hd < 0 ? -1 : 1) * parseInt(aux2[1], 10);
                } else {
                    h = i = s = hd = id = 0;
                }

                if (!this.isValidDateTime(y, m, d, h, i, s)) {
                    throw new Error("setValue(): invalid date time.");
                }

                newDate.setFullYear(y);
                newDate.setMonth(m - 1);
                newDate.setDate(d);
                newDate.setHours(h);
                newDate.setMinutes(i);
                newDate.setSeconds(s);
                newDate.setMilliseconds(0);

                newDate.setHours(newDate.getHours() + hd);
                newDate.setMinutes(newDate.getMinutes() + id);

                if (!this.dateObject) {
                    this.dateObject = new Date();
                }

                if (datetime || utc) {
                    this.dateObject.setUTCFullYear(newDate.getFullYear());
                    this.dateObject.setUTCMonth(newDate.getMonth());
                    this.dateObject.setUTCDate(newDate.getDate());
                    this.dateObject.setUTCHours(newDate.getHours());
                    this.dateObject.setUTCMinutes(newDate.getMinutes());
                    this.dateObject.setUTCSeconds(newDate.getSeconds());
                } else {
                    this.dateObject.setFullYear(y);
                    this.dateObject.setMonth(m - 1);
                    this.dateObject.setDate(d);
                    this.dateObject.setHours(h);
                    this.dateObject.setMinutes(i);
                    this.dateObject.setSeconds(s);
                    this.dateObject.setMilliseconds(0);
                }
                newDate = null;
            } else {
                error = true;
            }
        } else {
            error = true;
        }

        if (error) {
            throw new Error("setValue(): Invalid parameter format/data type.");
        }
        if (value !== "") {
            if (!this.dateObject) {
                this.dateObject = new Date();
            }
            if (newDate) {
                this.dateObject.setFullYear(newDate.getFullYear());
                this.dateObject.setMonth(newDate.getMonth());
                this.dateObject.setDate(newDate.getDate());
                this.dateObject.setHours(newDate.getHours());
                this.dateObject.setMinutes(newDate.getMinutes());
                this.dateObject.setSeconds(newDate.getSeconds());
            }
        }

        if (this.html) {
            if (this.dateObject) {
                this.html.value = this.formatDate(this.dateObject, this.dateFormat);
                this.dom.hoursInput.value = this.dateObject.getHours();
                this.dom.minutesInput.value = this.dateObject.getMinutes();
                this.dom.secondsInput.value = this.dateObject.getSeconds();
            } else {
                this.html.value = "";
            }
            this.fillYearSelector();
            this.fillMonthSelector();
            this.buildDaysTable();
        }
        this.value = this.getValue('UTC');

        return this;
    };
    /**
     * Sets the first day of week.
     * @param {Number} day Use 0 for Sunday, 1 for Monday, 2 for Tuesday and so on!.
     * @chainable
     */
    DateTimeControl.prototype.setFirstDay = function (day) {
        if (typeof day === 'number') {
            if (day >= 0 && day < 7) {
                this.firstDay = Math.floor(day);
                if (this.html) {
                    this.setDays(this.days);
                    this.buildDaysTable();
                }
                return this;
            }
        }

        throw new Error("setFirstDay(): The parameter must be a number between 0 and 6.");
    };
    /**
     * Sets the format for the date to be displayed in the control's textbox.
     * @param {String} dateFormat A string that contains wildcards that represent a date part (day, month, etc.).
     * The valid wildcards are the same ones that are specified in the
     * {@link PMUI.control.DateTimeControl#cfg-dateFormat dateFormat config option}.
     * @chainable
     */
    DateTimeControl.prototype.setDateFormat = function (dateFormat) {
        if (typeof dateFormat === 'string') {
            this.dateFormat = dateFormat;
            this.updateValue();
        } else {
            throw new Error("setDateFormat(): The parameter must be a string.");
        }
        return this;
    };
    /**
     * Returns the date format to be displayed in the control's textbox.
     * @return {String}
     */
    DateTimeControl.prototype.getDateFormat = function () {
        return this.dateFormat;
    };
    /**
     * Returns the date using the format set by {@link PMUI.control.DateTimeControl#setDateFormat setDateFormat()}
     * method.
     * @return {String}
     */
    DateTimeControl.prototype.getFormatedDate = function () {
        return this.html.value;
    };
    /**
     * Returns the selected date.
     * @param  {String} format Specifies the date format that will be used for the returning date.
     * The valid values are:
     *
     * - "UTC", returns a date in the format: yyyy-mm-ddTHH:ii:ss-HH:mm (i.e. 2013-08-31T00:08:00+04:00).
     * - "@" or "timestamp", returns a date in timestamp format.
     * - [any other valid format string], will return the date using the string as the dateformat. This string can
     * contain any of the wilcards specified in the
     * {@link PMUI.control.DateTimeControl#cfg-dateFormat dateFormat config option}.
     * @return {String}
     */
    DateTimeControl.prototype.getValue = function (returningFormat) {
        var res;
        returningFormat = returningFormat || "UTC";
        if (this.dateObject) {
            switch (returningFormat) {
                case 'timestamp':
                case '@':
                    res = this.formatDate(this.dateObject, '@');
                    break;
                default:
                    res = this.formatDate(this.dateObject, returningFormat);
            }
        } else {
            res = "";
        }

        return res;
    };
    /**
     * Returns true if the parameter is a leap year, otherwise returns false.
     * @param  {Number}  year The year to be evaluated.
     * @return {Boolean}
     * @private
     */
    DateTimeControl.prototype.isLeapYear = function (year) {
        if (year % 400 === 0) {
            return true;
        }
        if (year % 100 === 0) {
            return false;
        }
        if (year % 4 === 0) {
            return true;
        }
        return false;
    };
    /**
     * Returns true if the bunch of arguments represents a valid date otherwise it returns false.
     * @param  {Number}  year
     * @param  {Number}  month The month number (a number from 1 to 12)
     * @param  {Number}  day
     * @param  {Number}  [hours]
     * @param  {Number}  [minutes]
     * @param  {Number}  [seconds]
     * @param  {Number}  [milliseconds]
     * @return {Boolean}
     * @private
     */
    DateTimeControl.prototype.isValidDateTime = function (year, month, day, hours, minutes, seconds, milliseconds) {
        if (!(typeof year === 'number' && typeof month === 'number' && typeof day === 'number')) {
            return false;
        }

        hours = hours || 0;
        minutes = minutes || 0;
        seconds = seconds || 0;
        milliseconds = milliseconds || 0;

        if (!(typeof hours === 'number' && typeof minutes === 'number' && typeof seconds === 'number'
            && typeof milliseconds === 'number')) {
            return false;
        }

        if (!(hours >= 0 && hours <= 23)) {
            return false;
        }

        if (!(minutes >= 0 && minutes <= 59)) {
            return false;
        }

        if (!(seconds >= 0 && seconds <= 59)) {
            return false;
        }

        if (!(milliseconds >= 0 && milliseconds <= 999)) {
            return false;
        }

        if (day < 1 || day > 31 || month < 1 || month > 12) {
            return false;
        }

        switch (month) {
            case 4:
            case 6:
            case 9:
            case 11:
                if (day > 30) {
                    return false;
                }
                break;
            case 2:
                if (this.isLeapYear(year)) {
                    return day <= 29;
                }
                return day <= 28;
        }

        return true;
    };
    /**
     * It parses the argument into a date.
     * @param  {String|Date} date It can be a String or a Date:
     *
     * - Date, in this case the argument isn't parse and it is returned.
     * - String, in this case the string must have the following format: "[-+]\d+[dwmy]". For example "+1y -4m +3d"
     * means that te returning date will be 1 year minus 4 months plus 3 days from today.
     * @return {Date}
     * @private
     */
    DateTimeControl.prototype.parseDate = function (date) {
        var startDate,
            aux,
            i,
            amount;

        if (typeof date === 'number') {
            startDate = new Date();
            startDate.setDate(startDate.getDate() + date);
        } else if (typeof date === 'string') {
            startDate = new Date();
            date = " " + jQuery.trim(date);
            if (/^(\s[\\+|\-]\d+[y|m|d|w])+$/.test(date)) {
                date = date.match(/[\\+|\-]\d+[y|m|d]/g);
                for (i = 0; i < date.length; i += 1) {
                    aux = date[i].match(/[\-|\\+]|\d+|[m|d|y]/g);
                    amount = parseInt(aux[1], 10);
                    if (aux[0] === '-') {
                        amount *= -1;
                    }
                    switch (aux[2]) {
                        case 'd':
                            startDate.setDate(startDate.getDate() + amount);
                            break;
                        case 'm':
                            startDate.setMonth(startDate.getMonth() + amount);
                            break;
                        case 'y':
                            startDate.setFullYear(startDate.getFullYear() + amount);
                            break;
                        case 'w':
                            startDate.setDate(startDate.getDate() + (amount * 7));
                            break;
                    }
                }
            }
        } else if (date instanceof Date) {
            startDate = date;
        } else if (typeof date === 'object') {
            startDate = new Date(date.year, date.month - 1, date.day || 1, date.hours || 0, date.minutes || 0, date.seconds || 0,
                date.milliseconds || 0);
        } else {
            throw new Error("parseDate(): invalid parameter.");
        }

        return startDate;
    };
    /**
     * Sets the minimum date the control can accept as a selectable one.
     * @param {String|Date|Number|Object} date It can be:
     *
     * - a Date object.
     * - a String with the following format: "([+-]\d+[dmyw]\s)?". It will represent an addition or substraction of
     * time units to the current date, for example the expression "+1y -2m +3d" means
     * "the current date plus 1 year, minus 2 months plus 3 days". The prefixes you can use are:
     *     - "d" for days.
     *     - "w" for weeks.
     *     - "m" for months.
     *     - "y" for years.
     *
     *     You can also use one single unit, i.e. "+3y", "-1m", or a combination of two: "-2y +3d", etc.
     * - a Number, in this case the number is taken as the number of days that will be sum/substracted from the
     * current date. This number can be positive (for add days) or negative (for substract days).
     * - an Object, in this case the object must have the following structure:
     *
     *      {
     *          year: 2013,
     *          month: 5,
     *          day: 4,
     *          hours: 20,
     *          minutes: 15,
     *          seconds: 3,
     *          millisenconds
     *      }
     *
     * In this case only year and month are required.
     *
     * @chainable
     */
    DateTimeControl.prototype.setMinDate = function (date) {
        var minDate = this.parseDate(date), d;

        if (this.maxDate) {
            if (minDate > this.maxDate) {
                throw new Error("setMinDate(): The min date can't be major than the max date");
            }
        }
        this.minDate = minDate;
        this.fillYearSelector();
        this.fillMonthSelector();
        this.buildDaysTable();

        if (this.html) {
            d = new Date();
            this.dom.todayButton.disabled = !(d >= minDate && (this.maxDate && d <= this.maxDate));
        }

        return this;
    };
    /**
     * Sets the maximum date the control can accept as a selectable one.
     * @param {String|Date|Number|Object} date It can be:
     *
     * - a Date object.
     * - a String with the following format: "([+-]\d+[dmyw]\s)?". It will represent an addition or substraction of
     * time units to the current date, for example the expression "+1y -2m +3d" means
     * "the current date plus 1 year, minus 2 months plus 3 days". The prefixes you can use are:
     *     - "d" for days.
     *     - "w" for weeks.
     *     - "m" for months.
     *     - "y" for years.
     *
     *     You can also use one single unit, i.e. "+3y", "-1m", or a combination of two: "-2y +3d", etc.
     * - a Number, in this case the number is taken as the number of days that will be sum/substracted from the
     * current date. This number can be positive (for add days) or negative (for substract days).
     * - an Object, in this case the object must have the following structure:
     *
     *      {
     *          year: 2013,
     *          month: 5,
     *          day: 4,
     *          hours: 20,
     *          minutes: 15,
     *          seconds: 3,
     *          millisenconds
     *      }
     *
     * In this case only year and month are required.
     * @chainable
     */
    DateTimeControl.prototype.setMaxDate = function (date) {
        var maxDate = this.parseDate(date), d;

        if (this.minDate) {
            if (maxDate < this.minDate) {
                throw new Error("setMaxDate(): The max date can't be minor than the min date");
            }
        }
        this.maxDate = maxDate;
        this.fillYearSelector();
        this.fillMonthSelector();
        this.buildDaysTable();

        if (this.html) {
            d = new Date();
            this.dom.todayButton.disabled = !(d <= maxDate && (this.minDate && d >= this.minDate));
        }

        return this;
    };
    /**
     * Sets the months names/shortnames to be used by the calendar.
     * @param {Object} months An object with the same structure that the
     * {@link PMUI.control.DateTimeControl#cfg-months months config option}.
     * @chainable
     */
    DateTimeControl.prototype.setMonths = function (months) {
        var key,
            changed;

        for (key in this.months) {
            if (this.months.hasOwnProperty(key)) {
                if (months.hasOwnProperty(key)) {
                    if (typeof months[key] === 'string') {
                        changed = true;
                        this.months[key].name = months[key];
                        this.months[key].shortname = months[key].charAt(0).toUpperCase() + months[key].slice(1, 3);
                    } else if (typeof months[key] === 'object') {
                        this.months[key].name = months[key].name;
                        this.months[key].shortname = months[key].shortname;
                        changed = true;
                    }
                }
            }
        }

        if (changed) {
            this.fillMonthSelector();
        }

        return this;
    };
    /**
     * Fills the months selector.
     * @chainable
     * @private
     */
    DateTimeControl.prototype.fillMonthSelector = function () {
        var currentMonth,
            option,
            year,
            i,
            j;

        if (this.dom.monthSelector) {
            year = this.dom.yearSelector.value;
            currentMonth = (this.dateObject && this.dateObject.getMonth()) || this.dom.monthSelector.value
                || (new Date()).getMonth().toString();
            jQuery(this.dom.monthSelector).empty();
            i = 0;
            j = this.monthsOrder.length - 1;
            if (year === this.minDate.getFullYear().toString()) {
                i = this.minDate.getMonth();
            }
            if (year === this.maxDate.getFullYear().toString()) {
                j = this.maxDate.getMonth();
            }
            for (i; i <= j; i += 1) {
                option = PMUI.createHTMLElement('option');
                option.label = this.months[this.monthsOrder[i]].name;
                option.textContent = option.label;
                option.value = this.months[this.monthsOrder[i]].value;
                option.selected = currentMonth.toString() === option.value;
                this.dom.monthSelector.appendChild(option);
            }
        }

        return this;
    };
    /**
     * Sets the name/shortnames for the days to be used in the calendar.
     * @param {Object} days A JSON object with the same structure than the
     * {@PMUI.control.DateTimeControl#cfg-days days config option}.
     * @chainable
     */
    DateTimeControl.prototype.setDays = function (days) {
        var key,
            changed,
            i,
            cell,
            daysLength = this.daysOrder.length,
            aux;

        for (key in this.days) {
            if (this.days.hasOwnProperty(key)) {
                if (days.hasOwnProperty(key)) {
                    if (typeof days[key] === 'string') {
                        this.days[key].name = days[key];
                        this.days[key].shortname = days[key].substr(0, 3);
                    } else if (typeof days[key] === 'object') {
                        this.days[key].name = days[key].name || this.days[key].name || "";
                        this.days[key].shortname = (days[key].shortname && days[key].shortname.substr(0, 3))
                            || (this.days[key].name && this.days[key].name.substr(0, 3)) || "";
                    } else {
                        throw new Error("setDays(): The argument supplied must be a string or an object.");
                    }
                    changed = true;
                }
            }
        }

        if (changed && this.html) {
            jQuery(this.dom.daysHeader).empty();
            aux = 0;
            i = this.firstDay;
            while (aux < daysLength) {
                if (i === daysLength) {
                    i = 0;
                }
                cell = PMUI.createHTMLElement('th');
                cell.textContent = this.days[this.daysOrder[i]].shortname;
                cell.setAttribute("data-value", this.days[this.daysOrder[i]].value);
                this.dom.daysHeader.appendChild(cell);
                i += 1;
                aux += 1;
            }
        }

        return this;
    };
    /**
     * Fill the year selector.
     * @chainable
     * @private
     */
    DateTimeControl.prototype.fillYearSelector = function () {
        var minYear,
            maxYear,
            option,
            selectedYear;

        if (this.dom.yearSelector) {
            selectedYear = (this.dateObject && this.dateObject.getFullYear()) || this.dom.yearSelector.value
                || (new Date()).getFullYear();
            selectedYear = selectedYear.toString();
            jQuery(this.dom.yearSelector).empty();
            minYear = this.minDate.getFullYear();
            maxYear = this.maxDate.getFullYear();
            for (minYear; minYear <= maxYear; minYear += 1) {
                option = PMUI.createHTMLElement('option');
                option.textContent = option.label = option.value = minYear;
                if (option.value.toString() === selectedYear) {
                    option.selected = true;
                }
                this.dom.yearSelector.appendChild(option);
            }
        }

        return this;
    };
    /**
     * Returns the number of days in a month
     * @param  {Number} y The year (it's necessary to determine the days in February.)
     * @param  {Number} m The month
     * @return {Number}   The number of days.
     * @private
     */
    DateTimeControl.prototype.daysInMonth = function (y, m) {
        if (m < 1 || m > 12) {
            return 0;
        }
        switch (m) {
            case 4:
            case 6:
            case 9:
            case 11:
                return 30;
            case 2:
                if (this.isLeapYear(y)) {
                    return 29;
                }
                return 28;
            default:
                return 31;
        }
    };
    /**
     * Returns the day of week for a date.
     * @param  {Number} y The year.
     * @param  {Number} m The month.
     * @param  {Number} d The day of month.
     * @return {Number}   A number from 0 to 6. 0 means Sunday, 1, Monday and so on.
     * @private
     */
    DateTimeControl.prototype.whichDay = function (y, m, d) {
        var centuryCode,
            monthCode,
            lastTwoYearDigits = y % 100,
            gregorianCenturyCodes = [6, 4, 2, 0],
            i;

        if (!this.isValidDateTime(y, m, d)) {
            throw new Error("whichDay(): invalid date.");
        }

        switch (m) {
            case 3:
            case 11:
                monthCode = 3;
                break;
            case 4:
            case 7:
                monthCode = 6;
                break;
            case 5:
                monthCode = 1;
                break;
            case 6:
                monthCode = 4;
                break;
            case 8:
                monthCode = 2;
                break;
            case 9:
            case 12:
                monthCode = 5;
                break;
            case 10:
                monthCode = 0;
                break;
            case 1:
                if (this.isLeapYear(y)) {
                    monthCode = -1;
                } else {
                    monthCode = 0;
                }
                break;
            case 2:
                if (this.isLeapYear(y)) {
                    monthCode = 2;
                } else {
                    monthCode = 3;
                }
                break;
        }

        centuryCode = Math.floor(y / 100);

        i = 0;
        while (centuryCode % 4 !== 0) {
            centuryCode += 1;
            i += 1;
        }
        if (i === 0) {
            centuryCode = gregorianCenturyCodes[0];
        } else {
            centuryCode = gregorianCenturyCodes[gregorianCenturyCodes.length - i];
        }

        return (d + monthCode + lastTwoYearDigits + Math.floor(lastTwoYearDigits / 4) + centuryCode    ) % 7;
    };
    /**
     * Build the days table for the calendar
     * @chainable
     * @private
     */
    DateTimeControl.prototype.buildDaysTable = function () {
        var dayOfTheWeek,
            daysInMonth,
            y,
            m,
            i,
            day = 1,
            row,
            cell,
            limit,
            link,
            selectableDate;

        if (this.dom.yearSelector && this.dom.monthSelector) {
            jQuery(this.dom.tableBody).empty();
            y = parseInt(this.dom.yearSelector.value, 10);
            m = parseInt(this.dom.monthSelector.value, 10) + 1;
            dayOfTheWeek = this.whichDay(y, m, 1) - this.firstDay;
            if (dayOfTheWeek < 0) {
                dayOfTheWeek = 7 + dayOfTheWeek;
            }
            daysInMonth = this.daysInMonth(y, m);
            limit = Math.ceil((dayOfTheWeek + daysInMonth) / 7) * 7;
            row = PMUI.createHTMLElement('tr');

            for (i = 0; i < limit; i += 1) {
                cell = PMUI.createHTMLElement("td");
                if (i - dayOfTheWeek >= 0 && day <= daysInMonth) {
                    selectableDate = true;
                    if ((m - 1) === this.maxDate.getMonth() && y === this.maxDate.getFullYear()) {
                        if (day > this.maxDate.getDate()) {
                            selectableDate = false;
                        }
                    } else if ((m - 1) === this.minDate.getMonth() && y === this.minDate.getFullYear()) {
                        if (day < this.minDate.getDate()) {
                            selectableDate = false;
                        }
                    }
                    if (selectableDate) {
                        link = PMUI.createHTMLElement("a");
                        link.href = "#";
                        link.setAttribute("data-date", day);
                        link.textContent = day;
                        link.className = (this.dateObject && this.dateObject.getFullYear() === y
                            && this.dateObject.getMonth() + 1 === m && this.dateObject.getDate() === day) ? 'selected' : '';
                        cell.appendChild(link);
                    } else {
                        cell.className = 'pmui-datepicker-disabled-date';
                        cell.textContent = day;
                    }
                    day += 1;
                }
                row.appendChild(cell);
                if ((i + 1) % 7 === 0) {
                    this.dom.tableBody.appendChild(row);
                    row = PMUI.createHTMLElement('tr');
                }
            }
            this.dom.tableBody.appendChild(row);
        }

        return this;
    };
    /**
     * Shows the control's calendar.
     * @chainable
     * @private
     */
    DateTimeControl.prototype.showCalendar = function () {
        var position,
            inputHeight,
            maxZIndex;

        if (this.html) {
            this.fillYearSelector();
            this.fillMonthSelector();
            this.buildDaysTable();

            position = jQuery(this.html).offset();
            inputHeight = jQuery(this.html).outerHeight();

            jQuery(document.body).find(">*").each(function () {
                var n;

                n = parseInt(jQuery(this).css("z-index"));
                if (!isNaN(n)) {
                    maxZIndex = n > maxZIndex ? n : maxZIndex;
                }
            });

            document.body.appendChild(this.dom.calendar);
            this.dom.calendar.style.zIndex = maxZIndex ? maxZIndex + 1 : 999;
            this.dom.calendar.style.left = position.left + 'px';
            this.dom.calendar.style.top = (position.top + inputHeight) + 'px';
            this.dom.calendar.style.display = "";
        }

        return this;
    };
    /**
     * Hide's the control's calendar.
     * @return {HTMLElement} The object's html.
     * @private
     */
    DateTimeControl.prototype.hideCalendar = function () {
        if (this.html) {
            jQuery(this.dom.calendar).detach();
        }

        return this.html;
    };
    /**
     * Returns the day number of a date in a whole year.
     * @param  {Number} y The year.
     * @param  {Number} m The month.
     * @param  {Number} d The day of month.
     * @return {Number}   The day of year.
     * @private
     */
    DateTimeControl.prototype.getDayOfYear = function (y, m, d) {
        var day = 0,
            month = 1;

        if (!(typeof y === 'number' && typeof m === 'number' && typeof d === 'number')) {
            throw new Error("getDayOfYear(): invalid parameters.");
        }
        if (!this.isValidDateTime(y, m, d)) {
            throw new Error("getDayOfYear(): invalid date.");
        }

        while (month < m) {
            day += this.daysInMonth(y, m);
            month += 1;
        }

        day += d;

        return day;
    };
    /**
     * Formats a date using the specified format string.
     * @param  {Date} dateObject a Date object.
     * @param  {String} format     String that contains wildcards specified in the
     * {@link PMUI.control.DateTimeControl#cfg-dateFormat dateFormat config option}.
     * @return {String}            The formatted date as a string.
     * @private
     */
    DateTimeControl.prototype.formatDate = function (dateObject, format) {
        var finalValue,
            d = dateObject.getDate(),
            o = this.getDayOfYear(dateObject.getFullYear(), dateObject.getMonth() + 1, dateObject.getDate()),
            m = dateObject.getMonth() + 1,
            h = dateObject.getHours(),
            h12 = h > 12 ? h - 12 : h,
            i = dateObject.getMinutes(),
            s = dateObject.getSeconds(),
            yy = dateObject.getFullYear(),
            formatArray,
            timeOffset,
            timeOffsetString,
            aux;

        timeOffset = dateObject.getTimezoneOffset();

        timeOffsetString = timeOffset < 0 ? '+' : '-';
        timeOffset = Math.sqrt(timeOffset * timeOffset);
        aux = Math.floor(timeOffset / 60);
        timeOffset = timeOffset - (aux * 60);
        timeOffsetString += (aux < 10 ? '0' : '') + aux + ':' + (timeOffset < 10 ? '0' : '') + timeOffset;

        formatArray = [
            {
                regExp: /dd/g,
                value: d < 10 ? "0" + d : d
            },
            {
                regExp: /d/g,
                value: d
            },
            {
                regExp: /oo/g,
                value: o < 10 ? "00" + o : (o < 100 ? "0" + o : o)
            },
            {
                regExp: /o/g,
                value: o
            },
            {
                regExp: /mm/g,
                value: m < 10 ? "0" + m : m
            },
            {
                regExp: /m/g,
                value: m
            },
            {
                regExp: /yy/g,
                value: yy
            },
            {
                regExp: /y/g,
                value: yy % 100
            },
            {
                regExp: /\@/g,
                value: dateObject.getTime()
            },
            {
                regExp: /\!/g,
                value: (dateObject.getTime() * 10000) + 621355968000000000
            },
            {
                regExp: /MM/g,
                value: this.months[this.monthsOrder[dateObject.getMonth()]].name
            },
            {
                regExp: /M/g,
                value: this.months[this.monthsOrder[dateObject.getMonth()]].shortname
            },
            {
                regExp: /HH/g,
                value: (h < 10 ? '0' : '') + h
            },
            {
                regExp: /H/g,
                value: h
            },
            {
                regExp: /hh/g,
                value: (h12 < 10 ? '0' : '') + h12
            },
            {
                regExp: /h/g,
                value: h12
            },
            {
                regExp: /ii/g,
                value: (i < 10 ? '0' : '') + i
            },
            {
                regExp: /i/g,
                value: i
            },
            {
                regExp: /ss/g,
                value: (s < 10 ? '0' : '') + s
            },
            {
                regExp: /s/g,
                value: s
            },
            {
                regExp: /UTC/g,
                value: yy + '-' + (m < 10 ? '0' : '') + m + '-' + (d < 10 ? '0' : '') + d + "T"
                + (h < 10 ? '0' : '') + h + ':' + (i < 10 ? '0' : '') + i + ':' + (s < 10 ? '0' : '') + s
                + timeOffsetString
            },
            {
                regExp: /P/g,
                value: h > 12 ? 'PM' : 'AM'
            },
            {
                regExp: /DD/g,
                value: this.days[this.daysOrder[dateObject.getDay()]].name
            },
            {
                regExp: /D/g,
                value: this.days[this.daysOrder[dateObject.getDay()]].shortname
            }
        ];

        finalValue = format || this.dateFormat;

        for (i = 0; i < formatArray.length; i += 1) {
            finalValue = finalValue.replace(formatArray[i].regExp, formatArray[i].value);
        }

        return finalValue;
    };
    /**
     * Updates the control's date text.
     * @chainable
     * @private
     */
    DateTimeControl.prototype.updateValue = function () {
        var finalValue;

        if (this.dateObject) {
            finalValue = this.formatDate(this.dateObject, this.dateFormat);
        } else {
            finalValue = "";
        }

        this.value = finalValue;

        if (this.html) {
            this.html.value = finalValue;
        }

        return this;
    };
    /**
     * Gets the control's value directly from the element.
     * @return {String}
     */
    DateTimeControl.prototype.getValueFromRawElement = function () {
        return this.getValue('UTC');
    };
    /**
     * The handler to be executed everytime the control's value changes.
     * @chainable
     * @private
     */
    DateTimeControl.prototype.onChangeHandler = function (hide) {
        var prevValue = this.value,
            newValue,
            resCallback,
            date,
            month,
            year,
            auxDate,
            valueChanged = false;

        auxDate = new Date();
        date = parseInt($(this.dom.tableBody).find("a.selected").text(), 10);
        if (isNaN(date)) {
            return this;
        }
        month = parseInt(this.dom.monthSelector.value, 10);
        year = parseInt(this.dom.yearSelector.value, 10);
        auxDate.setYear(year);
        auxDate.setMonth(month);
        auxDate.setDate(date);
        if (this.datetime) {
            auxDate.setMilliseconds(0);
            auxDate.setSeconds(parseInt(this.dom.secondsInput.value, 10));
            auxDate.setMinutes(parseInt(this.dom.minutesInput.value, 10));
            auxDate.setHours(parseInt(this.dom.hoursInput.value, 10));
            this.dom.doneButton.disabled = true;
        } else {
            if (!this.dateObject) {
                this.dateObject = new Date();
            }
            auxDate.setMilliseconds(0);
            auxDate.setSeconds(0);
            auxDate.setMinutes(0);
            auxDate.setHours(0);
        }
        if (!this.dateObject) {
            this.dateObject = new Date();
        }
        if (auxDate.getTime() !== this.dateObject.getTime()) {
            valueChanged = true;
        }
        if (typeof this.onBeforeChange === 'function' && valueChanged) {
            resCallback = this.onBeforeChange(this.formatDate(auxDate), prevValue);
        }
        if (resCallback !== false) {
            this.dateObject = auxDate;
        } else {
            if (this.dom.monthSelector.value == this.dateObject.getMonth()
                && this.dom.yearSelector.value == this.dateObject.getFullYear()) {

                jQuery(this.dom.tableBody).find('a.selected').removeClass('selected')
                    .find('a[data-date="' + this.dateObject.getDate() + '"]').addClass('selected');
            }
        }
        newValue = this.getValueFromRawElement();
        this.updateValue();
        if (hide) {
            this.hideCalendar();
        }
        if (typeof this.onChange === 'function' && this.value !== prevValue) {
            this.onChange(this.value, prevValue);
        }

        return this;
    };
    /**
     * Defines the events for the control
     * @chainable
     */
    DateTimeControl.prototype.defineEvents = function () {
        var that = this,
            preselectedDate,
            specialCloseHandler = function (e) {
                if ((e.target !== that.html && !$(e.target).parents('#pmui-datepicker-calendar-' + that.id).length)
                    || (e.type === 'keyup' && !jQuery(document.activeElement).parents('#pmui-datepicker-calendar-'
                        + that.id).length)) {
                    that.hideCalendar();
                }
            },
            timeInputFilter;

        if (this.dom.todayButton) {
            timeInputFilter = function () {
                var num = parseInt(this.value, 10),
                    maxValue;

                switch (this) {
                    case that.dom.hoursInput:
                        maxValue = 23;
                        break;
                    case that.dom.minutesInput:
                    case that.dom.secondsInput:
                        maxValue = 59;
                        break;
                    default:
                        throw new Error("defineEvents() at change event: No valid element.");
                }

                if (isNaN(num)) {
                    this.value = 0;
                } else {
                    this.value = num < 0 ? 0 : Math.min(num, maxValue);
                }
               that.dom.doneButton.disabled = false;
            };

            this.addEvent('change').listen(this.dom.yearSelector, function () {
                that.fillMonthSelector();
                that.buildDaysTable();
            });
            this.addEvent('change').listen(this.dom.monthSelector, function () {
                that.buildDaysTable();
            });
            this.addEvent('focusin click').listen(this.html, function () {
                that.showCalendar();
            });
            this.addEvent('change').listen(this.dom.hoursInput, timeInputFilter);
            this.addEvent('change').listen(this.dom.minutesInput, timeInputFilter);
            this.addEvent('change').listen(this.dom.secondsInput, timeInputFilter);
            this.addEvent('click').listen(this.dom.todayButton, function () {
                preselectedDate = new Date();
                that.dom.doneButton.disabled = false;
                that.dom.yearSelector.value = preselectedDate.getFullYear();
                that.fillMonthSelector();
                that.dom.monthSelector.value = preselectedDate.getMonth();
                that.buildDaysTable();
                jQuery(that.dom.tableBody).find(".selected").removeClass('selected').end()
                    .find('a[data-date=' + preselectedDate.getDate() + ']').addClass("selected");
            });
            this.addEvent('click keyup mousedown').listen(document, specialCloseHandler)
                .listen('.pmui-window', specialCloseHandler);
            //In the future, if the new Event objects model is implemented the following line should be listening to an
            //event close or windowClose. Currently a dirty implementation will fix he problem.
            this.addEvent('click').listen('.pmui-button.pmui-window-close', function () {
                that.hideCalendar();
            });
            this.addEvent('click').listen(this.dom.doneButton, function () {
                that.onChangeHandler(true);
            });
            jQuery(this.dom.tableBody).on('click', 'a', function (e) {
                e.preventDefault();
                jQuery(that.dom.tableBody).find("a").filter(".selected").removeClass("selected");
                jQuery(this).addClass("selected");
                var date, month, year;

                date = parseInt(this.textContent, 10);
                month = parseInt(that.dom.monthSelector.value, 10);
                year = parseInt(that.dom.yearSelector.value, 10);
                if (that.datetime) {
                    that.dom.doneButton.disabled = false;
                } else {
                    that.onChangeHandler(true);
                }
            });
        }
        return this;
    };
    /**
     * Creates the HTML for the control.
     * @return {HTMLElement}
     */
    DateTimeControl.prototype.createHTML = function () {
        var header,
            table,
            tableHeader,
            monthSelector,
            yearSelector,
            row,
            cell,
            tableBody,
            calendar,
            footer,
            button,
            input;
        if (this.html) {
            return this.html;
        }

        DateTimeControl.superclass.prototype.createHTML.call(this);

        this.html.type = 'text';
        this.html.readOnly = true;

        calendar = PMUI.createHTMLElement('div');
        calendar.className = 'pmui-datepicker';
        calendar.id = 'pmui-datepicker-calendar-' + this.id;
        header = PMUI.createHTMLElement('div');
        header.className = 'pmui-datepicker-header';
        table = PMUI.createHTMLElement('table');
        table.className = 'pmui-datepicker-head-table';
        monthSelector = PMUI.createHTMLElement("select");
        yearSelector = PMUI.createHTMLElement("select");
        row = PMUI.createHTMLElement("tr");
        cell = PMUI.createHTMLElement("td");
        cell.className = 'pmui-datepicker-month-selector';
        cell.appendChild(monthSelector);
        row.appendChild(cell);
        cell = PMUI.createHTMLElement("td");
        cell.className = 'pmui-datepicker-year-selector';
        cell.appendChild(yearSelector);
        row.appendChild(cell);
        table.appendChild(row);
        header.appendChild(table);

        this.dom.yearSelector = yearSelector;
        this.dom.monthSelector = monthSelector;

        table = PMUI.createHTMLElement('table');
        table.className = 'pmui-datepicker-table';
        tableHeader = PMUI.createHTMLElement('thead');
        row = PMUI.createHTMLElement('tr');
        this.dom.daysHeader = row;
        tableHeader.appendChild(row);
        table.appendChild(tableHeader);

        tableBody = PMUI.createHTMLElement('tbody');
        this.dom.tableBody = tableBody;
        table.appendChild(tableBody);

        footer = this.createFooterHTML();
        calendar.appendChild(header);
        calendar.appendChild(table);
        calendar.appendChild(footer);

        this.dom.calendar = calendar;
        this.dom.footer = footer;

        this.setMinDate(this.minDate)
            .setMaxDate(this.maxDate)
            .setDays(this.days)
            .visibleDateTime(this.datetime);

        if (this.eventsDefined) {
            this.defineEvents();
        }

        return this.html;
    };
    /**
     * Creates the Fotter HTML for the control.
     * @return {HTMLElement}
     */
    DateTimeControl.prototype.createFooterHTML = function () {
        var footertr,
            tableFooter,
            footer,
            button,
            cell1,
            cell2,
            cell3,
            cell4,
            cell5,
            input;

        footer = PMUI.createHTMLElement('div');
        tableFooter = PMUI.createHTMLElement('table');
        footertr = PMUI.createHTMLElement('tr');
        footer.className = 'pmui-datepicker-footer';

        cell1 = PMUI.createHTMLElement('td');
        cell2 = cell1.cloneNode(false);
        cell3 = cell1.cloneNode(false);
        cell4 = cell1.cloneNode(false);
        cell5 = cell1.cloneNode(false);

        button = PMUI.createHTMLElement('button');
        button.textContent = 'Today';
        button.className = 'pmui-datepicker-button';
        this.dom.todayButton = button;
        cell1.appendChild(button);
        footertr.appendChild(cell1);

        input = PMUI.createHTMLElement('input');
        input.setAttribute("type", "number");
        input.size = 2;
        input.min = 0;
        input.max = 23;
        input.value = 0;
        input.placeholder = "hrs.";
        this.dom.hoursInput = input;
        cell2.appendChild(input);
        footertr.appendChild(cell2);

        input = input.cloneNode(false);
        input.max = 59;
        input.placeholder = "min.";
        this.dom.minutesInput = input;
        cell3.appendChild(input);
        footertr.appendChild(cell3);

        input = input.cloneNode(false);
        input.max = 59;
        input.placeholder = "sec.";
        this.dom.secondsInput = input;
        cell4.appendChild(input);
        footertr.appendChild(cell4);

        button = button.cloneNode(true);
        button.textContent = "Done";
        button.disabled = true;
        this.dom.doneButton = button;
        cell5.appendChild(button);
        footertr.appendChild(cell5);
        tableFooter.appendChild(footertr);
        footer.appendChild(tableFooter);
        return footer;
    };
    PMUI.extendNamespace('PMUI.control.DateTimeControl', DateTimeControl);

    if (typeof exports !== "undefined") {
        module.exports = DateTimeControl;
    }
}());

(function () {
    /**
     * @class PMUI.ui.Window
     * @extend PMUI.core.Panel
     *    Usage example:
     *
     *      @example
     *
     *        f = new PMUI.form.Form({
     *               items: [
     *                   {
     *                       pmType: "text",
     *                       label: "Name",
     *                       id: "123",
     *                       value: "",
     *                       placeholder: "insert your name",
     *                       name: "name",
     *                       helper: "Introduce your name",
     *                       required : true,
     *                       controlsWidth: 200,
     *                       valueType: 'string'
     *                   },
     *                   {   
     *                       pmType: "text",
     *                       label: "test Number",
     *                       id: "1234",
     *                       value: 10,
     *                       placeholder: "insert your number",
     *                       name: "numberTest",
     *                       helper: "Introduce your number",
     *                       required : true,
     *                       controlsWidth: 200,
     *                       valueType: 'number'
     *                   },
     *                   {
     *                       pmType: "datetime",
     *                       visible : true,
     *                       label: "birth date",
     *                       name: "birthdate",
     *                       valueType: 'date',
     *                       required: true
     *                   }
     *               ]
     *           });
     *
     *      w = new PMUI.ui.Window({
     *               title: "Window Example",
     *               width: 500,
     *               height: 230,
     *               modal: true,
     *               buttons: [
     *                   {
     *                       pmType: 'button',
     *                       text: 'Save',
     *                       handler: function() {
     *                           alert("Saved!");
     *                       }
     *                   },
     *                   {
     *                       pmType: 'label',
     *                       text: " or "
     *                   },
     *                   {
     *                       pmType: 'button',
     *                       text: "Close",
     *                       handler : function () {
     *                           w.close();
     *                       },
     *                       border: 'link'
     *                   }
     *               ],
     *               closable: true,
     *               footerItems: [
     *                   {
     *                       text: "Close"
     *                   }
     *               ],
     *               visibleFooter: true,
     *               buttonPanelPosition: 'top'
     *           });
     *           w.addItem(f);
     *           w.open();
     *           w.defineEvents();
     *
     * Create a new instace of the Window class
     *
     * @cfg {String}  [title = [Untitled window]] Title The title for the Window
     * @cfg {Boolean} [modal = true] Defines the  window property  is modal or not
     * @cfg {String|Number} [height = "auto"] window height can be a number or a string. height
     * is the div
     * Element which contains a header, body and footer. When using a string that you can only use
     * 'auto' or 'inherit' or # # # # px or% or # # # # em when is a number
     * @cfg {String|Number} [width = 400] The width of the main window which contains a html element
     * Element 'div' header, body and footer
     * @cfg {String|Number} [footerHeight = "auto"] the height of the Element div footer (px, auto,
     * number)which default 'auto'
     * @cfg {PMUI.util.ArrayList} [buttons = []], defines an array of objects that are buttons
     * settings may in the fotter Element div.
     * @deprecated This config optio will be removed soon, please use the {@link #cfg-footerItems footerItems} config
     * option instead.
     * @cfg {boolean} [visibleCloseButton = true], the button close are can define or not in the window.
     * @cfg {Array} [footerItems=[]] Sets the elements in the window footer, this elements can be instances of Button
     * and/or instances of Label. The value for this config option must be an array in which each element can be:
     *
     * - An object literal, in this case the object literal must have the property "pmType" with its value set to
     * "button" (if you want the element be a {@link PMUI.ui.Button Button}) or "label" (if you want the element be a
     * {@link PMUI.ui.TextLabel Label}). Optionally you can add the respective config options for each case.
     *
     * - A PMUI object, in this case it must be an instance of {@link PMUI.ui.Button Button} or an instance of
     * {@link PMUI.ui.TextLabel Label}.
     *
     * @cfg {String} [footerAlign="center"] Sets the horizontal alignment for the items in the wondow footer, the
     * possible values are "center", "left", "right".
     * @cfg {Boolean} [visibleFooter="false"] indicating whether the footer of the Window is visible or was hidden
     * @cfg {String}  [buttonPanelPosition="bottom"] indicates that position does the panel of buttons, you can be
     * above or below body.
     * @cfg {Function|null} [onOpen=null] The callback function to be executed everytime the
     * {@link #event-onOpen onOpen} event.
     * @cfg {Function|null} [onClose=null] The callback function to be executed everytime the
     * {@link #event-onClose onClose} event.
     */
    var Window = function (settings) {
        Window.superclass.call(this, jQuery.extend(true, {
            positionMode: 'absolute'
        }, settings));
        /**
         * The window's header.
         * @type {HTMLElement}
         * @private
         */
        this.header = null;
        /**
         * The window's body.
         * @type {HTMLElement}
         * @private
         */
        this.body = null;
        /**
         * The window's footer.
         * @type {PMUI.panel.ButtonPanel}
         * @private
         */
        this.footer = null;
        /**
         * @property {String} title
         * The window's title. Set by the {@link #cfg-title title} config option and the
         * {@link #method-setTitle setTitle()} method.
         * @readonly
         */
        this.title = null;
        /**
         * The windo's close button.
         * @type {PMUI.ui.Button}
         * @private
         */
        this.closeButton = null;
        /**
         * If the window is opened or not.
         * @type {Boolean}
         * @readonly
         */
        this.isOpen = false;
        /**
         * is defined if button panes Object is visible
         * @type {[type]}
         */
        this.visibleFooter = null;
        /**
         * If the window's close button is visible or not. Set by the
         * {@link #cfg-visibleCloseButton visibleCloseButton} config option and the
         * {@link #method-showCloseButton showCloseButton()} and {@link #method-hideCloseButton hideCloseButton()}
         * methods.
         * @type {Boolean}
         * @readonly
         */
        this.visibleCloseButton = null;
        /**
         * If the window will be a modal window. Set by the {@link #cfg-modal modal} config option and the
         * {@link #method-setModal setModal()} method.
         * @type {Boolean}
         * @readonly
         */
        this.modal = null;
        /**
         * The window's footer height.
         * @type {Number|String}
         */
        this.footerHeight = null;
        /**
         * The window's footer alignment.
         * @type {String}
         */
        this.footerAlign = null;
        /**
         * defines the position of the buttons panel on the window
         * @type {String}
         */
        this.buttonPanelPosition = null;
        /**
         * @event onOpen
         * Fired everytime the window opens.
         * @param {PMUI.ui.Window} window The window that was opened.
         */
        this.onOpen = null;
        /**
         * @event onClose
         * Fired everytime the window closes.
         * @param {PMUI.ui.Window} window The window that was closed.
         */
        this.onClose = null;
        this.dom = {};
        this.onBeforeClose = null;
        Window.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Panel', Window);
    /**
     * Defines the object's type
     * @type {String}
     */
    Window.prototype.type = 'Window';
    /**
     * Defines the object's family
     * @type {String}
     */
    Window.prototype.family = 'ui';

    Window.prototype.init = function (settings) {
        var defaults = {
            height: 'auto',
            width: 'auto',
            title: '[Untitled window]',
            modal: true,
            footerHeight: 'auto',
            zOrder: 100,
            footerItems: [],
            footerAlign: 'center',
            visibleCloseButton: true,
            visibleFooter: false,
            buttons: [],
            buttonPanelPosition: 'bottom',
            onOpen: null,
            onClose: null,
            onBeforeClose: null
        };

        jQuery.extend(true, defaults, settings);

        this.footer = new PMUI.panel.ButtonPanel({
            style: {
                cssClasses: ['pmui-window-footer']
            }
        });

        this.setTitle(defaults.title)
            .setModal(defaults.modal)
            .setWidth(defaults.width)
            .setHeight(defaults.height)
            .setFooterHeight(defaults.footerHeight)
            .setFooterAlign(defaults.footerAlign)
            .setZOrder(defaults.zOrder)
            .setButtonPanelPosition(defaults.buttonPanelPosition)
            .setFooterItems(defaults.footerItems)
            .setOnOpenHandler(defaults.onOpen)
            .setOnCloseHandler(defaults.onClose);
        this.setOnBeforeCloseHandler(defaults.onBeforeClose);

        if (defaults.visibleCloseButton) {
            this.showCloseButton();
        } else {
            this.hideCloseButton();
        }
        if (defaults.visibleFooter) {
            this.showFooter();
        } else {
            this.hideFooter();
        }
        //TODO tell the guys to replace its 'buttons' config option by FooterItems
        if (defaults.footerItems && defaults.footerItems.length) {
            this.setFooterItems(defaults.footerItems);
        } else {
            this.setFooterItems(defaults.buttons);
        }
    };
    /**
     * Sets the callback function to be executed everytime the {@link #event-onClose onClose} event fires.
     * @param {Function|null} handler It can be a function or null.
     */
    Window.prototype.setOnCloseHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error("setOnCloseHandler(): The parameter must be a function or null.");
        }
        this.onClose = handler;
        return this;
    };

    Window.prototype.setOnBeforeCloseHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error("setOnCloseHandler(): The parameter must be a function or null.");
        }
        this.onBeforeClose = handler;
        return this;
    };

    /**
     * Sets the callback function to be executed everytime the {@link #event-onOpen onOpen} event fires.
     * @param {Function|null} handler It can be a function or null.
     */
    Window.prototype.setOnOpenHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error("setOnOpenHandler(): The parameter must be a function or null.");
        }
        this.onOpen = handler;
        return this;
    };
    /**
     * updates the dimensions of the height of the HTMLElement window, body and foot when
     it is modified by the user
     * @chainable
     */
    Window.prototype.updateDimensionsAndPosition = function () {
        var bodyHeight,
            footerHeight,
            headerHeight,
            windowHeight = this.height,
            windowWidth;

        if (!this.footer || !this.html || !this.isOpen) {
            return this;
        }
        if (this.footerHeight === 'auto') {
            this.footer.setHeight('auto');
        } else {
            this.footer.setHeight(this.footerHeight);
        }

        if (windowHeight === 'auto') {
            this.body.style.height = 'auto';
            this.body.style.minHeight = '150px';
        } else {
            if (/^\d+(\.\d+)?em$/.test(windowHeight)) {
                windowHeight = PMUI.emToPx(parseInt(windowHeight, 10), this.modalObject);
            } else if (/^\d+(\.\d+)?%$/.test(windowHeight)) {
                windowHeight = jQuery(this.html).outerHeight();
            }
            footerHeight = this.visibleFooter ? jQuery(this.footer.getHTML()).outerHeight() : 0;
            headerHeight = jQuery(this.header).outerHeight();
            bodyHeight = windowHeight - footerHeight - headerHeight;
            if (bodyHeight <= 0) {
                bodyHeight = 0;
            }
            this.body.style.minHeight = '';
            this.body.style.height = bodyHeight + "px";
        }

        windowWidth = jQuery(this.header).width();
        windowWidth = windowWidth - (this.visibleCloseButton ? jQuery(this.closeButton.getHTML()).outerWidth() : 0);
        this.dom.titleContainer.style.width = windowWidth < 0 ? 0 : windowWidth + 'px';

        windowWidth = jQuery(this.html).outerWidth();
        windowHeight = jQuery(this.html).outerHeight();

        this.addCSSProperties({
            left: '50%',
            "margin-left": (windowWidth / -2) + "px",
            top: '50%',
            "margin-top": (windowHeight / -2) + "px"
        });

        return this;
    };
    /**
     * shows the footer where the buttons are located
     * @chainable
     */
    Window.prototype.showFooter = function () {
        this.footer.setVisible(this.visibleFooter = true);
        return this.updateDimensionsAndPosition();
    };
    /**
     * hides the footer where the buttons are located
     * @chainable
     */
    Window.prototype.hideFooter = function () {
        this.footer.setVisible(this.visibleFooter = false);
        return this.updateDimensionsAndPosition();
    };
    /**
     * @method setTitle
     * Sets the window title in the header part of the window.
     * @param {String} title
     * @chainable
     */
    Window.prototype.setTitle = function (title) {
        if (typeof title === 'string') {
            this.title = title;
            if (this.dom.titleContainer) {
                this.dom.titleContainer.textContent = title;
                this.dom.titleContainer.title = title;
            }
        } else {
            throw new Error("The setTitle() method accepts only string values.");
        }
        return this;
    };
    /**
     * @method getTitle
     * its title of teh window
     * @return {String}
     */
    Window.prototype.getTitle = function () {
        return this.title;
    };
    /**
     * @method setModal
     * Set if the window is modal or not.
     * @param {Boolean} modal
     * @chainable
     */
    Window.prototype.setModal = function (modal) {
        if (typeof modal !== 'undefined') {
            this.modal = !!modal;
        }
        return this;
    };
    /**
     * @inheritdoc
     */
    Window.prototype.setWidth = function (width) {
        Window.superclass.prototype.setWidth.call(this, width);
        return this.updateDimensionsAndPosition();
    };
    /**
     * @inheritdoc
     */
    Window.prototype.setHeight = function (height) {
        Window.superclass.prototype.setHeight.call(this, height);
        return this.updateDimensionsAndPosition();
    };
    /**
     * @method  setFooterHeight
     * high fixed size for the footer of the window
     * @param {Number|String} height it can be a number or a string.
     In case of using a String equals to 'auto','inherit','##px','##%','##em'
     * @chainable
     */
    Window.prototype.setFooterHeight = function (footerHeight) {
        if (typeof footerHeight === 'number') {
            this.footerHeight = footerHeight;
        } else if (/^\d+(\.\d+)?px$/.test(footerHeight)) {
            this.footerHeight = parseInt(footerHeight, 10);
        } else if (footerHeight === 'auto') {
            this.footerHeight = footerHeight;
        } else {
            throw new Error('setFooterHeight: footerHeight param is not valid.');
        }
        if (this.footer) {
            this.footer.style.height = this.footerHeight + 'px';
        }
        if (this.isOpen) {
            this.updateDimensionsAndPosition();
        }

        return this;
    };
    /**
     * Sets the alignment for the items on the footer.
     * @param {String} align Possible values: "center", "left", "right".
     * @chainable
     */
    Window.prototype.setFooterAlign = function (align) {
        this.footer.setAlignment(align);
        this.footerAlign = align;
        return this;
    };
    /**
     * buttonPanelPosition parameter sets that have the panel of buttons, within the window
     * @param {String} buttonPanelPosition Accepted values ​​are 'top' or 'bottom'
     */
    Window.prototype.setButtonPanelPosition = function (buttonPanelPosition) {
        if (!(buttonPanelPosition === 'top' || buttonPanelPosition === 'bottom')) {
            throw  new Error('setButtonPanelPosition(): the value is not valid, should be a "top" or "bottom"');
        }
        this.buttonPanelPosition = buttonPanelPosition;
        if (this.html) {
            if (buttonPanelPosition === 'top') {
                this.html.insertBefore(this.footer.html, this.body);
            } else {
                this.html.appendChild(this.footer.html);
            }
        }
        return this;
    };
    /**
     * Clear the items in the window footer.
     * @chainable
     */
    Window.prototype.clearFooterItems = function () {
        this.footer.clearItems();
        return this;
    };
    /**
     * Adds an item to the window footer.
     * @param {Object|PMUI.ui.Button|PMUI.ui.TextLabel} item This parameter can be:
     *
     * - An object literal, in this case the object literal must have the property "pmType" with its value set to
     * "button" (if you want the element be a {@link PMUI.ui.Button Button}) or "label" (if you want the element be a
     * {@link PMUI.ui.TextLabel Label}). Optionally you can add the respective config options for each case.
     *
     * - A PMUI object, in this case it must be an instance of {@link PMUI.ui.Button Button} or an instance of
     * {@link PMUI.ui.TextLabel Label}.
     * @chainable
     */
    Window.prototype.addFooterItem = function (item) {
        this.footer.addItem(item);
        return this;
    };
    /**
     * Sets the items for the window's footer.
     * @param {Array} items This accepted value for this parameter is the same than the one for the
     * {@link #cfg-footerItems footerItems} config option.
     * @chainable
     */
    Window.prototype.setFooterItems = function (items) {
        var i;

        if (!jQuery.isArray(items)) {
            throw new Error("setFooterItems(): The parameter must be an array.");
        }
        this.clearFooterItems();
        for (i = 0; i < items.length; i += 1) {
            this.addFooterItem(items[i]);
        }
        return this;
    };
    /**
     * @method close
     * if the window is open, sets the status to closed
     * @chainable
     */
    Window.prototype.close = function () {
        jQuery(this.modalObject).detach();
        jQuery(this.html).detach();
        jQuery(this.closeButton).detach();
        if (typeof this.onClose === 'function') {
            this.onClose(this);
        }
        this.isOpen = false;
        if (document.body && this.modal) {
            document.body.style.overflow = "auto";
        }
        return this;
    };
    /**
     * Shows the window's close button.
     * @chainable
     */
    Window.prototype.showCloseButton = function () {
        this.visibleCloseButton = true;
        if (this.closeButton) {
            this.closeButton.setVisible(true);
        }
        return this;
    };
    /**
     * Adds an child item to the body HTMLElement
     * @param {PMUI.core.Window|Object} item It can be one of the following data types:
     * - {PMUI.core.Element} the object to add
     * - {Object} a JSON object with the settings for the Container to be added
     * @chainable
     */
    Window.prototype.addItem = function (item) {
        var itemToBeAdded;

        if (this.factory) {
            itemToBeAdded = this.factory.make(item);
        }
        if (itemToBeAdded && !this.isDirectParentOf(itemToBeAdded)) {
            itemToBeAdded.parent = this;
            this.items.insert(itemToBeAdded);
            if (this.body) {
                this.body.appendChild(itemToBeAdded.getHTML());
                if (this.eventsDefined) {
                    itemToBeAdded.defineEvents();
                }
            }
        }
        return this;
    };
    /**
     * @method open
     * If the window is closed, sets the status to open and displays the values ​​set in the properties window, header, body and footer
     * @chainable
     */
    Window.prototype.open = function () {
        var the_window;

        if (this.isOpen) {
            return this;
        }
        the_window = this.getHTML();
        if (this.modal) {
            this.modalObject.appendChild(the_window);
            document.body.appendChild(this.modalObject);
            jQuery(the_window).draggable({
                handle: $(this.header),
                containment: '#' + this.modalObject.id, 
                scroll: false
            });
        } else {
            document.body.appendChild(the_window);
            jQuery(this.getHTML()).draggable();
        }
        if (typeof this.onOpen === 'function') {
            this.onOpen(this);
        }
        this.isOpen = true;
        this.updateDimensionsAndPosition();
        this.setVisible(true);
        this.defineEvents();
        if (document.body && this.modal) {
            document.body.style.overflow = "hidden"
        }
        return this;
    };
    /**
     * Hides the window's close button.
     * @chainable
     */
    Window.prototype.hideCloseButton = function () {
        this.visibleCloseButton = false;
        if (this.closeButton) {
            this.closeButton.setVisible(false);
        }
        return this;
    };
    /**
     * Shows the window's close button.
     * @chainable
     */
    Window.prototype.showCloseButton = function () {
        this.visibleCloseButton = true;
        if (this.closeButton) {
            this.closeButton.setVisible(true);
        }
        return this;
    };
    /**
     * @method updateModalDimensions
     * Updates the status of modal HTMLElement and
     fixed all styles required to show
     */
    Window.prototype.updateModalDimensions = function () {
        if (document && this.modalObject) {
            this.modalObject.style.height = this.modalObject.style.width = "0px";
            this.modalObject.style.width = window.innerWidth + "px";
            this.modalObject.style.height = window.innerHeight + "px";
        }
        return this;
    };
    /**
     * Sets the padding for the windows body.
     * @param {Number|String} bodyPadding A number or a string with a pixel-unit formatted text.d
     */
    Window.prototype.setBodyPadding = function (bodyPadding) {
        if (typeof bodyPadding === 'number') {
            this.bodyPadding = bodyPadding
        } else if (/^\d+(\.\d+)?px$/.test(height)) {
            this.bodyPadding = parseInt(bodyPadding, 10);
        } else {
            throw new Error('setHeight: height param is not valid.');
        }

        this.bodyPadding = bodyPadding;
        if (this.html) {
            this.body.style.padding = bodyPadding + 'px';
        }
        return this;
    };
    /**
     * @inheritdoc
     */
    Window.prototype.paintItems = function () {
        if (this.body) {
            Window.superclass.prototype.paintItems.call(this);
        }
        return this;
    };
    /**
     * @method defineEvents
     * Defines the events associated with the Window
     */
    Window.prototype.defineEvents = function () {
        var that = this,
            html = this.html,
            modal = this.modal,
            stopPropagation,
            updateDimensions,
            cancelWheeling = function (e) {
                var height = that.body.clientHeight,
                    scrollHeight = that.body.scrollHeight,
                    scrollTop = that.body.scrollTop;

                e.stopPropagation();
            };

        Window.superclass.prototype.defineEvents.call(this);
        stopPropagation = new PMUI.event.Action({
            handler: function (e) {
                e.stopPropagation();
            }
        }),
            updateDimensions = new PMUI.event.Action({
                handler: function () {
                    that.updateModalDimensions();
                }
            });
        this.addEvent('mousedown').listen(this.body, stopPropagation);
        that.addEvent('click').listen(this.html, stopPropagation);
        that.addEvent('mouseover').listen(this.html, stopPropagation);
        that.addEvent('mouseout').listen(this.html, stopPropagation);
        that.addEvent('mousedown').listen(this.html, stopPropagation);
        that.addEvent('resize').listen(window, updateDimensions);
        this.addEvent('keydown').listen(this.html, stopPropagation);
        this.addEvent('keypress').listen(this.html, stopPropagation);
        this.addEvent('keyup').listen(this.html, stopPropagation);

        this.modalObject.addEventListener('wheel', function (e) {
            e.preventDefault();
            e.stopPropagation();
        }, false);

        this.body.addEventListener('wheel', cancelWheeling, false);
        this.footer.defineEvents();
        that.closeButton.defineEvents();
        this.updateModalDimensions();
        return this;
    };
    /**
     * @method createHTML
     * Creates natural elements to the window html: head, body and foot
     * @return {HTMLElement} returns a HTML element
     */
    Window.prototype.createHTML = function () {
        var header,
            body,
            titleContainer,
            closeButton,
            modal,
            that = this;

        if (this.html) {
            return this.html;
        }

        Window.superclass.prototype.createHTML.call(this);

        header = PMUI.createHTMLElement('div');
        header.className = 'pmui-window-header';
        body = PMUI.createHTMLElement('div');
        body.className = 'pmui-window-body';
        modal = PMUI.createHTMLElement('div');
        modal.className = 'pmui-window-modal';
        modal.id = this.id + "-modal";

        titleContainer = PMUI.createHTMLElement('span');
        titleContainer.className = 'pmui-window-title';
        titleContainer.style.display = "inline-block";

        closeButton = new PMUI.ui.Button({
            style: {
                cssClasses: ['pmui-window-close']
            },
            text: "",
            width: '16px',
            handler: function (event) {
                if (typeof that.onBeforeClose === "function") {
                    that.onBeforeClose(that);
                } else {
                    that.close();
                }
            }
        });

        this.modalObject = modal;
        header.appendChild(titleContainer);
        header.appendChild(closeButton.getHTML());
        $(closeButton.html).find(".button-icon").css('opacity', 'inherit');

        this.html.appendChild(header);
        this.html.appendChild(body);
        this.html.appendChild(this.footer.getHTML());

        this.dom.titleContainer = titleContainer;
        this.header = header;
        this.body = this.containmentArea = body;
        this.closeButton = closeButton;

        this.setTitle(this.title)
            .setFooterHeight(this.footerHeight)
            .setItems(this.items.asArray().slice(0))
            .setButtonPanelPosition(this.buttonPanelPosition);

        if (this.visibleCloseButton) {
            this.showCloseButton();
        } else {
            this.hideCloseButton();
        }
        if (this.visibleFooter) {
            this.showFooter();
        } else {
            this.hideFooter();
        }

        if (this.eventsDefined) {
            this.defineEvents();
        }

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.Window', Window);

    if (typeof exports !== "undefined") {
        module.exports = Window;
    }
}());
(function () {
    var MessageWindow = function (settings) {
        MessageWindow.superclass.call(this, settings);
        /**
         * The message for the message window.
         * @type {String}
         * @readonly
         */
        this.message = null;
        /**
         * An object for store the necessary dom elements to build the message window HTML.
         * @type {Object}
         * @private
         */
        this.dom = {};
        this.iconClass = null;
        this.windowMessageType = null;
        MessageWindow.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.ui.Window', MessageWindow);


    MessageWindow.prototype.type = 'WindowMessage';

    MessageWindow.prototype.family = 'ui';

    MessageWindow.prototype.init = function (settings) {
        var defaults = {
            message: '[not-message]',
            iconClass: '',
            windowMessageType: 'default',
            title: '',
            footerAlign: "right"
        };

        jQuery.extend(true, defaults, settings);

        this.setFooterAlign(defaults.footerAlign);
        this.setMessage(defaults.message);
        this.setWindowMessageType(defaults.windowMessageType);
        this.setTitle(defaults.title);

    };

    MessageWindow.prototype.setMessage = function (message) {
        if (typeof message !== 'string') {
            throw new Error('setMessage(): the parameter must be a string.');
        }

        this.message = jQuery.trim(message);

        if (this.dom.messageContainer) {
            this.dom.messageContainer.textContent = message;
        }

        return this;
    };
    MessageWindow.prototype.getMessage = function () {
        return this.message;
    };

    MessageWindow.prototype.setWindowMessageType = function (type) {
        var classMessage = "";

        if (typeof type !== "string") {
            throw  new Error("settype(): the type value is not valid");
        }
        this.windowMessageType = type;
        this.style.removeClasses(["pmui-windowmessage-default", "pmui-windowmessage-error", "pmui-windowmessage-warning", "pmui-windowmessage-success"]);
        classMessage = 'pmui-windowmessage-' + this.windowMessageType;
        switch (this.windowMessageType) {
            case 'error':
                this.style.addClasses([classMessage]);
                break;
            case 'warning':
                this.style.addClasses([classMessage]);
                break;
            case 'success':
                this.style.addClasses([classMessage]);
                break;
            case 'default':
                this.style.addClasses([classMessage]);
                break;
        }
        return this;
    };

    MessageWindow.prototype.getWindowMessageType = function () {
        return this.windowMessageType;
    };

    MessageWindow.prototype.addItem = function () {
        return this;
    };

    MessageWindow.prototype.createHTML = function () {
        var table,
            row,
            cellIcon,
            cellLabel,
            icon,
            p,
            textContent;

        MessageWindow.superclass.prototype.createHTML.call(this);

        table = PMUI.createHTMLElement('table');
        table.className = 'pmui-messagewindow-container';
        row = PMUI.createHTMLElement('tr');
        cellIcon = PMUI.createHTMLElement('td');
        cellLabel = PMUI.createHTMLElement('td');
        cellLabel.style.textAlign = "center";
        cellLabel.className = "pmui-content-label"
        icon = PMUI.createHTMLElement('span');
        icon.className = 'pmui-messagewindow-icon';
        textContent = PMUI.createHTMLElement('span');
        textContent.className = 'pmui-messagewindow-message';

        cellIcon.appendChild(icon);
        row.appendChild(cellIcon);


        cellLabel.appendChild(textContent);
        row.appendChild(cellLabel);
        table.appendChild(row);

        this.dom.icon = icon;
        this.dom.messageContainer = textContent;

        this.body.appendChild(table);

        this.setMessage(this.message);
        this.body.style.padding = "15px";
        cellLabel.style.width = (typeof this.width == 'number') ? this.width * (0.84) + "px" : "70%";
        this.body.style.minHeight = "inherit";
        return this.html;
    };

    MessageWindow.prototype.updateDimensionsAndPosition = function () {
        var bodyHeight,
            footerHeight,
            headerHeight,
            windowHeight = this.height,
            windowWidth;

        if (!this.footer || !this.html || !this.isOpen) {
            return this;
        }
        if (this.footerHeight === 'auto') {
            this.footer.setHeight('auto');
        } else {
            this.footer.setHeight(this.footerHeight);
        }

        if (windowHeight === 'auto') {
            this.body.style.height = 'auto';
            this.body.style.minHeight = 'inherit';
        } else {
            if (/^\d+(\.\d+)?em$/.test(windowHeight)) {
                windowHeight = PMUI.emToPx(parseInt(windowHeight, 10), this.modalObject);
            } else if (/^\d+(\.\d+)?%$/.test(windowHeight)) {
                windowHeight = jQuery(this.html).outerHeight();
            }
            footerHeight = this.visibleFooter ? jQuery(this.footer.getHTML()).outerHeight() : 0;
            headerHeight = jQuery(this.header).outerHeight();
            bodyHeight = windowHeight - footerHeight - headerHeight;
            if (bodyHeight <= 0) {
                bodyHeight = 0;
            }
            this.body.style.minHeight = '';
            this.body.style.height = bodyHeight + "px";
        }

        windowWidth = jQuery(this.header).width();
        windowWidth = windowWidth - (this.visibleCloseButton ? jQuery(this.closeButton.getHTML()).outerWidth() : 0);
        this.dom.titleContainer.style.width = windowWidth < 0 ? 0 : windowWidth + 'px';

        windowWidth = jQuery(this.html).outerWidth();
        windowHeight = jQuery(this.html).outerHeight();

        this.addCSSProperties({
            left: '50%',
            "margin-left": (windowWidth / -2) + "px",
            top: '50%',
            "margin-top": (windowHeight / -2) + "px"
        });
        return this;
    }

    PMUI.extendNamespace('PMUI.ui.MessageWindow', MessageWindow);

    if (typeof exports !== "undefined") {
        module.exports = MessageWindow;
    }
}());

(function () {
    /**
     * @class PMUI.ui.ErrorMessageWindow
     * A window to show a error message.
     * @extends {PMUI.ui.MessageWindow}
     *
     * Usage example:
     *
     *      @example
     *      var message_window = new PMUI.ui.ErrorMessageWindow({
     *          message: 'This is an error message.'
     *      });
     *      message_window.open();
     *
     * @constructor
     * Creates a new instance of the class ErrorMessageWindow
     * @param {Object} [settings={}] An object with the config options.
     *
     * @cfg {String} [title='Error'] The message to show in the message window.
     */
    var ErrorMessageWindow = function (settings) {
        ErrorMessageWindow.superclass.call(this, settings);
        ErrorMessageWindow.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.ui.MessageWindow', ErrorMessageWindow);
    /**
     * Initializes the object.
     * @param  {Object} settings The object with the config options.
     * @private
     */
    ErrorMessageWindow.prototype.init = function (settings) {
        var defaults = {
            title: 'Error'
        };

        jQuery.extend(true, defaults, settings);

        this.setTitle(defaults.title);
    };
    /**
     * Creates the message window HTML.
     * @return {HTMLElement}
     */
    ErrorMessageWindow.prototype.createHTML = function () {
        ErrorMessageWindow.superclass.prototype.createHTML.call(this);

        jQuery(this.dom.icon).addClass('pmui-messagewindow-icon-error');

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.ErrorMessageWindow', ErrorMessageWindow);

    if (typeof exports !== "undefined") {
        module.exports = ErrorMessageWindow;
    }
}());
(function () {
    /**
     * @class PMUI.ui.WarningMessageWindow
     * A window to show a warning message.
     * @extends {PMUI.ui.MessageWindow}
     *
     * Usage example:
     *
     *      @example
     *      var message_window = new PMUI.ui.WarningMessageWindow({
     *          message: 'This is a warning message.'
     *      });
     *      message_window.open();
     *
     * @constructor
     * Creates a new instance of the class WarningMessageWindow
     * @param {Object} [settings={}] An object with the config options.
     *
     * @cfg {String} [title='Warning'] The message to show in the message window.
     */
    var WarningMessageWindow = function (settings) {
        WarningMessageWindow.superclass.call(this, settings);
        WarningMessageWindow.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.ui.MessageWindow', WarningMessageWindow);
    /**
     * Initializes the object.
     * @param  {Object} settings The object with the config options.
     * @private
     */
    WarningMessageWindow.prototype.init = function (settings) {
        var defaults = {
            title: 'Warning'
        };

        jQuery.extend(true, defaults, settings);

        this.setTitle(defaults.title);
    };
    /**
     * Creates the message window ĤTML.
     * @return {HTMLElement}
     */
    WarningMessageWindow.prototype.createHTML = function () {
        WarningMessageWindow.superclass.prototype.createHTML.call(this);

        jQuery(this.dom.icon).addClass('pmui-messagewindow-icon-warning');

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.WarningMessageWindow', WarningMessageWindow);

    if (typeof exports !== "undefined") {
        module.exports = WarningMessageWindow;
    }
}());
(function () {
    /**
     * @class PMUI.ui.SuccessMessageWindow
     * A window to show a success message.
     * @extends {PMUI.ui.MessageWindow}
     *
     * Usage example:
     *
     *      @example
     *      var message_window = new PMUI.ui.SuccessMessageWindow({
     *          message: 'This is a success message.'
     *      });
     *      message_window.open();
     *
     * @constructor
     * Creates a new instance of the class SuccessMessageWindow
     * @param {Object} [settings={}] An object with the config options.
     *
     * @cfg {String} [title='Success'] The message to show in the message window.
     */
    var SuccessMessageWindow = function (settings) {
        SuccessMessageWindow.superclass.call(this, settings);
        SuccessMessageWindow.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.ui.MessageWindow', SuccessMessageWindow);
    /**
     * Initializes the object.
     * @param  {Object} settings The object with the config options.
     * @private
     */
    SuccessMessageWindow.prototype.init = function (settings) {
        var defaults = {
            title: 'Success'
        };

        jQuery.extend(true, defaults, settings);

        this.setTitle(defaults.title);
    };
    /**
     * Creates the message window ĤTML.
     * @return {HTMLElement}
     */
    SuccessMessageWindow.prototype.createHTML = function () {
        SuccessMessageWindow.superclass.prototype.createHTML.call(this);

        jQuery(this.dom.icon).addClass('pmui-messagewindow-icon-success');

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.SuccessMessageWindow', SuccessMessageWindow);

    if (typeof exports !== "undefined") {
        module.exports = SuccessMessageWindow;
    }
}());
(function () {
    /**
     * @class PMUI.ui.InfoMessageWindow
     * A window to show an info message.
     * @extends {PMUI.ui.MessageWindow}
     *
     * Usage example:
     *
     *      @example
     *      var message_window = new PMUI.ui.InfoMessageWindow({
     *          message: 'This is an info message.'
     *      });
     *      message_window.open();
     *
     * @constructor
     * Creates a new instance of the class InfoMessageWindow
     * @param {Object} [settings={}] An object with the config options.
     *
     * @cfg {String} [title='Information'] The message to show in the message window.
     */
    var InfoMessageWindow = function (settings) {
        InfoMessageWindow.superclass.call(this, settings);
        InfoMessageWindow.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.ui.MessageWindow', InfoMessageWindow);
    /**
     * Initializes the object.
     * @param  {Object} settings The object with the config options.
     * @private
     */
    InfoMessageWindow.prototype.init = function (settings) {
        var defaults = {
            title: 'Info'
        };

        jQuery.extend(true, defaults, settings);

        this.setTitle(defaults.title);
    };
    /**
     * Creates the message window HTML.
     * @return {HTMLElement}
     */
    InfoMessageWindow.prototype.createHTML = function () {
        InfoMessageWindow.superclass.prototype.createHTML.call(this);

        jQuery(this.dom.icon).addClass('pmui-messagewindow-icon-info');

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.InfoMessageWindow', InfoMessageWindow);

    if (typeof exports !== "undefined") {
        module.exports = InfoMessageWindow;
    }
}());
(function () {
    /**
     * @class PMUI.ui.ConfirmMessageWindow
     * A window to show a question message. It haas built-in Yes and No buttons, but they can be overrode by some
     * custom ones.
     * @extends {PMUI.ui.MessageWindow}
     *
     * Usage example:
     *
     *      @example
     *      var message_window = new PMUI.ui.ConfirmMessageWindow({
     *          message: 'Do you want to display an alert?',
     *              onYes: function() {
     *                  alert("this is an alert");
     *                  message_window.close();
     *              }, 
     *              onNo: function() {
     *                  message_window.close();
     *              }
     *      });
     *      message_window.open();
     *
     * @constructor
     * Creates a new instance of the class ConfirmMessageWindow
     * @param {Object} [settings={}] An object with the config options.
     *
     * @cfg {String} [title='Error'] The message to show in the message window.
     * @cfg {String} [yesText='Yes'] The text for the window's built-in Yes button.
     * @cfg {String} [noText='No'] The text for the window's built-in No button.
     * @cfg {Function|null} [onYes=null] The handler to be executed when the built-in Yes button is clicked.
     * @cfg {Function|null} [onNo=null] The handler to be executed when the built-in No button is clicked.
     * @cfg footerItems
     * The items to be shown in the message window's footer, the accepted values for this are the same that the ones
     * for the Window's footerItems config option.
     *
     * By default this is an empty array, if you modify this then the built-in Yes and No buttons won't be used,
     * therefore the yesText, noText config options and onYes, onNo handlers won't be used either.
     */
    var ConfirmMessageWindow = function (settings) {
        ConfirmMessageWindow.superclass.call(this, settings);
        ConfirmMessageWindow.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.ui.MessageWindow', ConfirmMessageWindow);
    /**
     * Initializes the object.
     * @param  {Object} settings The object with the config options.
     * @private
     */
    ConfirmMessageWindow.prototype.init = function (settings) {
        var yesButton = new PMUI.ui.Button(),
            noButton = new PMUI.ui.Button(),
            defaults = {
                title: 'Confirm',
                yesText: 'Yes',
                noText: 'No',
                onYes: null,
                onNo: null,
                footerItems: []
            };

        jQuery.extend(true, defaults, settings);

        this.setTitle(defaults.title);

        if (!defaults.footerItems || !defaults.footerItems.length) {
            defaults.footerItems = [
                yesButton.setHandler(defaults.onYes).setText(defaults.yesText),
                noButton.setHandler(defaults.onNo).setText(defaults.noText)
            ];
        }
        this.setFooterItems(defaults.footerItems);
    };
    /**
     * @inheritdoc
     */
    ConfirmMessageWindow.prototype.createHTML = function () {
        ConfirmMessageWindow.superclass.prototype.createHTML.call(this);

        jQuery(this.dom.icon).addClass('pmui-messagewindow-icon-confirm');

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.ConfirmMessageWindow', ConfirmMessageWindow);

    if (typeof exports !== "undefined") {
        module.exports = ConfirmMessageWindow;
    }
}());
(function () {
    /**
     * @class PMUI.ui.Button
     * @extend PMUI.core.Element
     *   * Usage example (only for subclasses since this is an abstract class):
     *
     *          @example
     *          //Remember, this is an abstract class so it shouldn't be instantiate,
     *          //anyway we are instantiating it just for this example
     *
     *          var a;
     *
     *           a = new PMUI.ui.Button({
     *               handler : function () {
     *                   alert("hi!");     
     *               },
     *               text : 'closed',
     *               iconClass:"pmui-gridpanel-pager_previous",
     *               iconPosition : "left",
     *               messageTooltip : 'this button to close the window'
     *           });
     *
     *           document.body.appendChild(a.getHTML());
     *           a.defineEvents();
     *
     * @constructor
     * Create a new instace of the Window class
     * @param {Object} settigs Constructor object
     */
    var Button = function (settings, parent) {
        Button.superclass.call(this, jQuery.extend(settings, {elementTag: "a"}));
        /**
         * @property icon for the Button, it can a string
         * @type {String}
         */
        this.icon = null;
        /**
         * @property {PMUI.event.Action} Defines the Action Object to handle he action windows
         * @type {Action}
         */
        this.action = null;
        /**
         * @property parent
         * @type {String}
         */
        this.parent = null;
        /**
         * @property text of the Button
         * @type {String}
         */
        this.text = null;
        /**
         * @property alias Button for idetified to alias
         * @type {String}
         */
        this.aliasButton = null;
        /**
         * [iconPosition description]
         * @type {[type]}
         */
        this.iconPosition = null;
        /**
         * [messageTooltip description]
         * @type {[type]}
         */
        this.messageTooltip = null;

        //this.buttonClass = null;

        //this.foreignClassName = null;

        this.linkStyle = null;

        this.labelVisible = null;
        this.iconVisible = null;
        this.disabled = null;
        this.dom = null;
        this.buttonType = null;

        Button.prototype.init.call(this, settings, parent);
    };

    PMUI.inheritFrom('PMUI.core.Element', Button);

    Button.prototype.type = 'Button';
    Button.prototype.family = 'Button';

    Button.prototype.init = function (settings, parent) {
        var defaults;

        defaults = {
            iconClass: '',
            aliasButton: null,
            parent: parent || null,
            height: "auto",
            width: "auto",
            handler: function () {
            },
            text: '[button]',
            iconPosition: "right",
            tooltip: false,
            messageTooltip: "",
            //buttonClass : '',
            iconVisible: true,
            labelVisible: true,
            disabled: false,
            //cls: 'pmui-button',
            //linkStyle: false,
            //foreignClassName : "",
            //useForeignClass : false
            buttonType: 'default'
        };
        this.dom = {};

        jQuery.extend(true, defaults, settings);

        this.setAliasButton(defaults.aliasButton)
            .setParent(defaults.parent)
            .setText(defaults.text)
            .setIcon(defaults.iconClass)
            .setWidth(defaults.width)
            .setHeight(defaults.height)
            .setIconPosition(defaults.iconPosition)
            .setHandler(defaults.handler)
            .setTooltipMessage(defaults.messageTooltip)
            .setDisabled(defaults.disabled)
            .setButtonType(defaults.buttonType);

    };

    Button.prototype.setButtonType = function (buttonType) {
        var classButton = "";

        if (typeof buttonType !== "string") {
            throw  new Error("setButtonType(): the type value is not valid");
        }
        this.buttonType = buttonType;
        this.style.removeClasses(["pmui-error", "pmui-warning", "pmui-success", "pmui-info", "pmui-link"]);
        classButton = 'pmui-' + this.buttonType;
        switch (this.buttonType) {
            case 'error':
                this.style.addClasses([classButton]);
                break;
            case 'warning':
                this.style.addClasses([classButton]);
                break;
            case 'success':
                this.style.addClasses([classButton]);
                break;
            case 'info':
                this.style.addClasses([classButton]);
                break;
            case 'link':
                this.style.addClasses([classButton]);
                break;
        }
        return this;
    };

    Button.prototype.showLabel = function () {
        this.labelVisible = true;
        if (this.html) {
            this.label.style.display = '';
        }
        return this;
    };

    Button.prototype.setDisabled = function (value) {
        if (typeof value !== 'boolean') {
            throw new Error('setDisabled(): the parameter is not valid, should be type boolean');
        }
        this.disabled = value;
        if (this.html) {
            if (this.disabled) {
                this.disable();
            } else {
                this.enable();
            }
        }
        return this;
    }

    Button.prototype.disable = function () {
        this.disabled = true;
        this.style.addClasses(['pmui-disabled']);
        if (this.eventsDefined) {
            this.defineEvents();
        }
        return this;
    };
    /**
     * @method enable
     * button can be enabled if it was disabled before
     * @chainable
     */
    Button.prototype.enable = function () {
        this.disabled = false;
        this.style.removeClasses(['pmui-disabled']);
        if (this.eventsDefined) {
            this.defineEvents();
        }
        return this;
    };

    /**
     * Performs the click action on the button.
     * @chainable
     */
    Button.prototype.click = function () {
        jQuery(this.html).trigger('click');
        return this;
    };

    /**
     * @method setHandler
     * Sets the handler for the button
     * @param {Function} handler is a Function.
     * @chainable
     */
    Button.prototype.setHandler = function (handler) {
        if (typeof handler !== "function" && handler !== null) {
            throw new Error("setHandler(): the parameter should be a function or null;");
        }
        this.handler = handler;
        this.action = new PMUI.event.Action({
            actionText: this.aliasButton,
            handler: this.handler
        });
        return this;
    };

    /**
     * @method removeEvent
     * Remove Event for the button
     * @param {Function} handler is a Function.
     * @chainable
     */
    Button.prototype.removeEvent = function (type) {
        jQuery(this.html).unbind(type);
        return this;
    };

    /**
     * @method removeEvents
     * Remove Events for the button
     * @param {Function} handler is a Function.
     * @chainable
     */
    Button.prototype.removeEvents = function () {
        var x;
        for (x in  this.events) {
            this.removeEvent(this.events[x].eventName);
        }
        this.events = {};
        return this;
    };

    /**
     * Sets the text for the label Button.
     * @param {String} is a String.
     * @chainable
     */
    Button.prototype.setText = function (text) {
        this.text = text;
        if (this.html && this.dom.spanText) {
            if (jQuery.trim(text) !== "") {
                this.dom.spanText.textContent = this.text;
            } else {
                this.dom.spanText.inerHTML = '&nbsp;';
            }
        }
        return this;
    };

    /**
     * Sets the icon for the Button.
     * @param {String} is a String.
     * @chainable
     */
    Button.prototype.setIcon = function (iconClass) {
        var icon;

        if (!(typeof iconClass == "string")) {
            throw new Error("setIcon(): the property should bo string");
        }
        this.icon = iconClass;
        if (this.html && this.dom.icon) {
            this.dom.icon.className = this.dom.icon.className + " " + this.icon;
        }
        return this;
    };

    /**
     * @method setAliasButton
     * Sets the alias for the label Button
     * @param {String} is a String. lue
     * @chainable
     */
    Button.prototype.setAliasButton = function (alias) {
        this.aliasButton = alias;
        return this;
    };

    /**
     * @method setParent
     * Sets the parent for the Button.
     * @param {Object} is a HTML Element.
     * @chainable
     */
    Button.prototype.setParent = function (parent) {
        this.parent = parent;
        return this;
    };
    /**
     * @method createHTML
     * Create HTML for the element
     * @return {HTMLElement} HTML Generated
     */

    Button.prototype.createHTML = function () {
        var spanText,
            icon;

        if (this.html) {
            return this.html;
        }
        Button.superclass.prototype.createHTML.call(this);
        this.html.href = '#';
        //***conatainer for text
        spanText = PMUI.createHTMLElement('span');
        spanText.className = "button-label";
        this.dom.spanText = spanText;
        this.html.appendChild(spanText);

        // container for icon
        icon = PMUI.createHTMLElement('span');
        icon.className = 'button-icon';
        this.dom.icon = icon;
        this.html.appendChild(icon);

        this.setIconPosition(this.iconPosition);
        this.setTooltipMessage(this.messageTooltip);

        this.setDisabled(this.disabled);
        this.setText(this.text);
        this.setIcon(this.icon);
        this.applyStyle();

        return this.html;
    };
    /**
     * @method defineEvents
     * Define events click for the Button, listening the function action
     */

    Button.prototype.defineEvents = function () {
        var that = this;

        Button.superclass.prototype.defineEvents.call(this);
        if (this.html) {
            if (this.disabled) {
                this.addEvent('click').listen(this.html, function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                });
            } else {
                this.addEvent('click').listen(this.html, function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (typeof that.handler === 'function') {
                        that.handler(that);
                    }
                });
            }
        }
        return this;
    };

    /**
     * @method setHeight
     * Sets the height for the button.
     * @param {String, number} height
     * This parameter can take the following types
     * - number
     * - string
     */
    Button.prototype.setHeight = function (height) {
        if (typeof height === 'number') {
            this.height = height + "px";
        } else if (/^\d+(\.\d+)?px$/.test(height)) {
            this.height = height;
        } else if (/^\d+(\.\d+)?%$/.test(height)) {
            this.height = height;
        } else if (/^\d+(\.\d+)?em$/.test(height)) {
            this.height = height;
        } else if (height === 'auto' || height === 'inherit') {
            this.height = height;
        } else {
            throw new Error('setHeight: height param is not a number');
        }
        if (this.height !== 'auto') {
            this.style.addProperties({"line-height": parseInt(this.height, 10) + "px"});
        } else {
            this.style.addProperties({"line-height": 'normal'});
        }
        this.applyStyle();
        return this;
    };
    /**
     * @method setIconPosition
     * Creates the HTML element for the control.
     * @param {String} position
     * This parameter can take the following values: left, right
     */
    Button.prototype.setIconPosition = function (position) {
        if (position == 'right' || position == "left" || position == "top" || position == "bottom") {
            this.iconPosition = position;
            if (this.html) {
                if (this.iconPosition == 'left' || this.iconPosition == 'top') {
                    $(this.html).prepend(this.dom.icon);
                    if (this.iconPosition == 'left') {
                        this.dom.icon.style.display = 'inline-block';
                        this.dom.icon.style.marginLeft = '';

                    } else {
                        this.dom.icon.style.display = 'block';
                        this.dom.icon.style.marginLeft = '50%';
                    }
                } else {
                    $(this.html).append(this.dom.icon);
                    if (this.iconPosition == 'right') {
                        this.dom.icon.style.display = 'inline-block';
                        this.dom.icon.style.marginLeft = '';
                    } else {
                        this.dom.icon.style.display = 'block';
                        this.dom.icon.style.marginLeft = '50%';
                    }
                }
            }

        } else {
            throw new Error("setIconPosition(): the parameter is not valid, should be 'right','left', 'top' or 'bottom'");
        }
        return this;
    };
    /**
     * @method setTooltipMessage
     * Sets the tooltip message
     * @param {String} messageTooltip
     */
    Button.prototype.setTooltipMessage = function (messageTooltip) {
        if (typeof messageTooltip == "string") {
            this.messageTooltip = messageTooltip;
            if (this.html) {
                this.html.setAttribute('title', messageTooltip);
            }
        }
        return this;
    };

    PMUI.extendNamespace("PMUI.ui.Button", Button);

    if (typeof exports !== "undefined") {
        module.exports = Button;
    }
}());


(function () {
    /**
     * @class PMUI.ui.TooltipMessage
     * @extends PMUI.core.Element
     * Class to handle tooltip elements and alert messages
     *
     * Usage example (creates 4 TooltipMessage instances):
     *
     *      @example
     *      //usage example
     *      //creates 4 TooltipMessage instances:
     *      var a, b, c, d;
     *      $(function() {
     *          // Instantiates a simple info message
     *          a = new PMUI.ui.TooltipMessage({
     *              message: "Hi folks! this is a info",
     *              category: "info",
     *              displayMode: "block",
     *              mode: "normal"
     *          });
     *          //Instantiates an error tooltip with mouse tracking option enabled
     *          b = new PMUI.ui.TooltipMessage({
     *              message: "Hi folks! this is an error",
     *              category: "error",
     *              track: true,
     *              displayMode: "block"
     *          });
     *          //Instantiates a warning tooltip with a slide down effect when the tooltip is opened
     *          c = new PMUI.ui.TooltipMessage({
     *              message: "Hi folks! this is a warning",
     *              category: "warning",
     *              displayMode: "block",
     *              showEffect: {
     *                  effect: "slideDown",
     *                  delay: 250
     *              }
     *          });
     *          //Instantiates a help tooltip with a explode effect when the tooltip is hidden
     *          d = new PMUI.ui.TooltipMessage({
     *              message: "Hi folks! this is a help",
     *              category: "help",
     *              displayMode: "block",
     *              hideEffect: {
     *                  effect: "explode",
     *                  delay: 250
     *              }
     *          });
     *          document.body.appendChild(a.getHTML());
     *          document.body.appendChild(b.getHTML());
     *          document.body.appendChild(c.getHTML());
     *          document.body.appendChild(d.getHTML());
     *      });
     * @constructor
     * Create a new instace of the class 'TooltipMessage'
     * @param {Object} settings
     * A JSON object which can contain the following fields:
     *
     * @cfg {String} [message = ""] The message to show
     * @cfg {String} [category = 'help'] The object's category, it can be "info", "help", "warning" or "error"
     * @cfg {String} [displayMode = 'inline'] Determines if the object will have an "inline" or "block" displaying
     * @cfg {String} [mode="tooltip"] When is set to "tooltip" the object has a tooltip behavior, but when is set to "normal" it
     * has a regular message behavior
     * @cfg {String} [tooltipClass='pmui-tooltip-message'] the css class for the HTML element which will contain the message
     * @cfg {Object} [tooltipPosition = { 
                my: "left top+15", 
                at: "left bottom", 
                collision: "flipfit" 
            }] specifies the position for the tooltip, read the
     {@link PMUI.ui.TooltipMessage#setTooltipPosition .setTooltipPosition()} for more info
     * @cfg {Object} [showEffect=null] specifies the animation to apply when the tooltip is shown, read the
     {@link PMUI.ui.TooltipMessage#setShowEffect .setShowEffect()} for more info
     *  @cfg {Object} [hideEffect=null] specifies the animation to apply when the tooltip is hidden, read the
     {@link PMUI.ui.TooltipMessage#setHideEffect .setHideEffect()} for more info
     * @cfg {Function} [onOpen] a callback function to be invoked when the tooltip is shown
     * @cfg {Function} [onClose] a callback functio to be invoked when the tooltip is hidden
     * @cfg {Boolean} [track = false] a turns on/off the tooltip to follow the mouse movement
     * Note: tooltipClass, tooltipPosition, showEffect, hideEffect, onOpen, onClose and track options
     only are applied when the mode is set to "tooltip"
     */
    var TooltipMessage = function (settings) {
        TooltipMessage.superclass.call(this, settings);
        /**
         * @property {PMUI.core.Element} icon
         * An {@link PMUI.core.Element} which is used to put the icon in
         * @private
         */
        this.icon = null;
        /**
         * An Element
         * @type {PMUI.core.Element} which is used to display the message when the mode is set to "normal"
         * @private
         */
        this.messageArea = null;
        /**
         * @property {String} [message=""]
         * The message to be displayed
         * @readonly
         */
        this.message = null;
        /**
         * @property {String} [category="help"]
         * The category for the message
         * @readonly
         */
        this.category = null;
        /**
         * @property {String} [displayMode="inline"]
         * The displaying mode for the object's HTML element
         * @readonly
         */
        this.displayMode = null;
        /**
         * @property {String} [mode="tooltip"]
         * The object's behavior mode
         * @readonly
         */
        this.mode = null;
        /**
         * @property {Object} [tooltipPosition={ 
                my: "left top+15", 
                at: "left bottom", 
                collision: "flipfit" 
            }]
         * The tooltip position
         * @readonly
         */
        this.tooltipPosition = null;
        /**
         * @property {String} [tooltipClass="pmui-tooltip-message"]
         * The CSS class name for the tooltip HTML element
         * @readonly
         */
        this.tooltipClass = null;
        /**
         * @property {Object|Boolean|String|Number} [showEffect=null]
         * The effect to apply when the tooltip is shown
         */
        this.showEffect = null;
        /**
         * @property {Object|Boolean|String|Number} [hideEffect=null]
         * The effect to apply when the tooltip is hidden
         */
        this.hideEffect = null;
        /**
         * @property {Function} [onOpen=null]
         * The function callback to be invoked when the tooltip is shown
         */
        this.onOpen = null;
        /**
         * @property {Function} [onClose=null]
         * The function callback to be invoked when the tooltip is hidden
         * @type {Function}
         */
        this.onClose = null;
        /**
         * @property {Boolean} [track=false]
         * A boolean that specifies if the the tooltip element must follow the mouse position
         */
        this.track = null;
        TooltipMessage.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', TooltipMessage);

    TooltipMessage.prototype.type = 'PMUITooltipMessage';

    TooltipMessage.prototype.family = 'PMUITooltipMessage';

    TooltipMessage.prototype.init = function (settings) {
        var defaults = {
            message: "",
            category: "help",
            displayMode: "inline",
            mode: "tooltip",
            tooltipClass: 'pmui-tooltip-message',
            tooltipPosition: {
                my: "left top+15",
                at: "left bottom",
                collision: "flipfit"
            },
            showEffect: null,
            hideEffect: null,
            onOpen: null,
            onClose: null,
            track: false
        };

        $.extend(true, defaults, settings);

        this.onClose = defaults.onClose;
        this.onOpen = defaults.onOpen;

        this.setTooltipClass(defaults.tooltipClass)
            .setTooltipPosition(defaults.tooltipPosition)
            .setShowEffect(defaults.showEffect)
            .setHideEffect(defaults.hideEffect)
            .setTrack(defaults.track)
            .setMessage(defaults.message)
            .setCategory(defaults.category)
            .setDisplayMode(defaults.displayMode)
            .setMode(defaults.mode);
    };
    /**
     * Set the CSS class for the HTML element which will contain the tooltip message.
     * This only takes effect when the mode property is set to "tooltip"
     * @param {String} tooltipClass
     */
    TooltipMessage.prototype.setTooltipClass = function (tooltipClass) {
        this.tooltipClass = tooltipClass;
        return this;
    };
    /**
     * Establish if the HTML element which will be contain the tooltip message should track
     (follow) the mouse position when it appears
     * * This only takes effect when the mode property is set to "tooltip"
     * @param {Boolean} [track=true]
     */
    TooltipMessage.prototype.setTrack = function (track) {
        this.track = !!track;
        if (this.html) {
            this.setMode(this.mode);
        }
        return this;
    };
    /**
     * [setHideEffect description]
     * If and how to animate the hiding of the tooltip.
     * This only takes effect when the mode property is set to "tooltip"
     * @param {Object|Boolean|String|Number} effect
     * - Boolean: When set to false, no animation will be used and the tooltip will be hidden
     immediately. When set to true, the tooltip will fade out with the default duration and the
     default easing.
     * - Number: The tooltip will fade out with the specified duration and the default easing.
     * - String: The tooltip will be hidden using the specified effect. The value can either be the
     name of a built-in jQuery animation method, such as "slideUp", or the name of a jQuery UI effect,
     such as "fold". In either case the effect will be used with the default duration and the default easing.
     * - Object: If the value is an object, then effect, delay, duration, and easing properties may be
     provided. If the effect property contains the name of a jQuery method, then that method will be used;
     otherwise it is assumed to be the name of a jQuery UI effect. When using a jQuery UI effect that supports
     additional settings, you may include those settings in the object and they will be passed to the effect.
     If duration or easing is omitted, then the default values will be used. If effect is omitted,
     then "fadeOut" will be used. If delay is omitted, then no delay is used.
     */
    TooltipMessage.prototype.setHideEffect = function (effect) {
        this.hideEffect = effect;
        if (this.html) {
            this.setMode(this.mode);
        }
        return this;
    };
    /**
     * If and how to animate the showing of the tooltip.
     * This only takes effect when the mode property is set to "tooltip"
     * @param {Object|Boolean|String|Number} effect
     * - Boolean: When set to false, no animation will be used and the tooltip will be shown immediately.
     When set to true, the tooltip will fade in with the default duration and the default easing.
     * - Number: The tooltip will fade in with the specified duration and the default easing.
     * - String: The tooltip will be shown using the specified effect. The value can either be the name of
     a built-in jQuery animation method, such as "slideDown", or the name of a jQuery UI effect, such as
     "fold". In either case the effect will be used with the default duration and the default easing.
     * - Object: If the value is an object, then effect, delay, duration, and easing properties may be
     provided. If the effect property contains the name of a jQuery method, then that method will be used;
     otherwise it is assumed to be the name of a jQuery UI effect. When using a jQuery UI effect that
     supports additional settings, you may include those settings in the object and they will be passed
     to the effect. If duration or easing is omitted, then the default values will be used. If effect is
     omitted, then "fadeIn" will be used. If delay is omitted, then no delay is used.
     */
    TooltipMessage.prototype.setShowEffect = function (effect) {
        this.showEffect = effect;
        if (this.html) {
            this.setMode(this.mode);
        }
        return this;
    };
    /**
     * Identifies the position of the tooltip in relation to the associated target element.
     * The of option defaults to the target element, but you can specify another element to position
     against. You can refer to the [jQuery UI Position][1] utility for more details about the various options.
     * [1]: http://api.jqueryui.com/position
     * @param {Object} position
     */
    TooltipMessage.prototype.setTooltipPosition = function (position) {
        this.tooltipPosition = position;
        if (this.html) {
            this.setMode(this.mode);
        }
        return this;
    };
    /**
     * Sets the message to be shown in both normal and tooltip modes
     * @param {String} message
     */
    TooltipMessage.prototype.setMessage = function (message) {
        if (typeof message === 'string') {
            this.message = message;
            if (this.html) {
                if (this.messageArea) {
                    this.messageArea.getHTML().textContent = message;
                }

                if (this.mode === 'tooltip') {
                    this.icon.html.title = message;
                } else {
                    this.icon.html.title = "";
                }
            }
        } else {
            throw new Error("setMessage() method only accepts string values.");
        }
        return this;
    };
    /**
     * Set the category for the tooltip/message object
     * @param {String} category the value can be one of the following:
     *
     * - help
     * - info
     * - error
     * - warning
     */
    TooltipMessage.prototype.setCategory = function (category) {
        var validCategories = [
            "help", "info", "error", "warning"
        ];

        if (typeof category === 'string' && validCategories.indexOf(category) > -1) {
            this.category = category;
            if (this.icon && this.messageArea) {
                this.icon.style.removeAllClasses();
                this.icon.style.addClasses(['pmui-icon', 'pmui-icon-' + category]);
                this.messageArea.className = 'pmui-tooltip-message pmui-tooltip-' + category + '-message';
            }
            if (this.html) {
                if (this.category === "error") {
                    this.style.addClasses(["pmui-tooltip-category-error"]);
                } else {
                    this.style.removeClasses(["pmui-tooltip-category-error"]);
                }
            }
        } else {
            throw new Error('setCategory() method only accepts' +
                ' one of the following values: "help", "info", "warning", "info".');
        }

        return this;
    };
    /**
     * Sets the CSS displaying mode
     * @param {String} displayMode It can take the "block" or "inline" values
     */
    TooltipMessage.prototype.setDisplayMode = function (displayMode) {
        if (displayMode === 'block' || displayMode === 'inline') {
            this.displayMode = displayMode;
            if (this.html) {
                this.style.addProperties({"display": displayMode});
            }
        } else {
            throw new Error('setDisplayMode() method only accepts "inline" or "block" values');
        }

        return this;
    };
    /**
     * Sets the mode for the object, it determines if the current object has a tooltip or notification message behavior
     * @param {String} mode It only can take one of the following values:
     * - "tooltip"
     * - "normal"
     */
    TooltipMessage.prototype.setMode = function (mode) {
        if (mode === 'tooltip' || mode === 'normal') {
            this.mode = mode;
            if (this.html) {
                $(this.html).addClass('pmui-tooltip-mode-' + mode);
                if (mode === 'tooltip') {
                    this.messageArea.setVisible(false);
                    this.icon.html.title = this.message;
                    $(this.icon.html).tooltip({
                        tooltipClass: this.tooltipClass,
                        position: this.tooltipPosition,
                        show: this.showEffect,
                        hide: this.hideEffect,
                        open: this.onOpen,
                        track: this.track,
                        close: this.onClose
                    });
                } else {
                    try {
                        $(this.icon.html).tooltip('destroy');
                    } catch (ex) {
                    }
                    this.icon.html.title = "";
                    this.messageArea.setVisible(true);
                }
            }
        } else {
            throw new Error('setMode() method only accepts "tooltip" or "normal" values');
        }

        return this;
    };
    /**
     * It creates the HTML Element for the current object
     * @return {HTMLElement}
     */
    TooltipMessage.prototype.createHTML = function () {
        var html,
            messageArea,
            icon;

        if (this.html) {
            return this.html;
        }

        html = PMUI.createHTMLElement("span");
        html.className = 'pmui-tooltip';
        icon = new PMUI.core.Element({
            elementTag: 'span',
            width: 18,
            height: 18,
            style: {
                cssClasses: ['pmui-icon'],
                cssProperties: {
                    display: "inline-block",
                    "vertical-align": "middle"
                }
            }
        });
        messageArea = new PMUI.core.Element({
            elementTag: 'span',
            style: {
                cssClasses: ['pmui-tooltip-message']
            }
        });

        html.appendChild(icon.getHTML());
        html.appendChild(messageArea.getHTML());
        this.icon = icon;
        this.messageArea = messageArea;
        this.html = html;

        this.applyStyle();

        this.setCategory(this.category);
        this.setMessage(this.message);
        this.setMode(this.mode);

        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.TooltipMessage', TooltipMessage);

    if (typeof exports !== "undefined") {
        module.exports = TooltipMessage;
    }
}());

(function () {
    /**
     * @class PMUI.ui.TextLabel
     * A text label that can contain a plain text or an HTML formatted text.
     * @extends {PMUI.core.Element}
     *
     * Usage example:
     *
     *      @example
     *      var plainText, htmlText;
     *      plainText = new PMUI.ui.TextLabel({
     *          textMode: 'plain',
     *          text: 'Hello! this is a label with a plain text in it',
     *          style: {
     *              cssProperties: {
     *                  background: "red"
     *              }
     *          }
     *      });
     *      htmlText = new PMUI.ui.TextLabel({
     *          textMode: 'html',
     *          text: '<h1>Hello!</h1> this ia a label with a <b> HTML</b> formatted text'
     *      });
     *      document.body.appendChild(plainText.getHTML());
     *      document.body.appendChild(htmlText.getHTML());
     *
     * @constructor
     * Creates a new instance of the class.
     * @param {Object} [settings={}] An object literal with the config options to config the object.
     *
     * @cfg {String} [textMode='plain'] The rendering mode for the text in the label. Possible values:
     *
     * - "plain": for plain text rendering.
     * - "html": for html text rendering. Only the <b>, <i>, <h1> to <h6> tags are allowed, any other tags will be
     * removed.
     * @cfg {String} [elementTag='span'] The HTML tag to be used as the text label.
     * @cfg {String} [text=""] The label's text.
     */
    var TextLabel = function (settings) {
        TextLabel.superclass.call(this, settings);
        /**
         * The text rendering mode. Set by the {@link #cfg-textMode textMode config option} and the
         * {@link #method-setTextMode setTextMode() method}.
         * @type {String}
         * @readonly
         */
        this.textMode = null;
        /**
         * The current displayed label's text. Set by the {@link #cfg-text text config option} and the
         * {@link #method-setText setText() method}.
         * @type {String}
         * @readonly
         */
        this.text = null;
        /**
         * The original set text.
         * @type {String}
         * @private
         */
        this.rawText = null;
        TextLabel.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', TextLabel);
    /**
     * The object's type.
     * @type {String}
     */
    TextLabel.prototype.type = 'TextLabel';
    /**
     * Initializes the object.
     * @param  {Object} [settings={}] An object literal with the config options the new object will be initialized
     * with.
     * @chainable
     * @private
     */
    TextLabel.prototype.init = function (settings) {
        var defaults = {
            textMode: 'plain',
            elementTag: 'span',
            text: ''
        };

        jQuery.extend(true, defaults, settings);

        this.setElementTag(defaults.elementTag)
            .setTextMode(defaults.textMode)
            .setText(defaults.text);

        return this;
    };
    /**
     * Sets the label's text.
     * @param {String} text
     */
    TextLabel.prototype.setText = function (text) {
        var tags;

        if (typeof text !== 'string') {
            throw new Error('setText(): the parameter must be a string.');
        }
        this.text = this.rawText = text;
        if (this.textMode === 'html') {
            allowed = ("<b><i><h1><h2><h3><h4><h5><h6>".match(/<[a-z][a-z0-9]*>/g) || []).join('');
            tags = /<\/?([a-z][a-z0-9]*)\b[^>]*>/gi,
                commentsAndPhpTags = /<!--[\s\S]*?-->|<\?(?:php)?[\s\S]*?\?>/gi;
            this.text = text.replace(commentsAndPhpTags, '').replace(tags, function ($0, $1) {
                return allowed.indexOf('<' + $1.toLowerCase() + '>') > -1 ? $0 : '';
            });
        }

        if (this.html) {
            if (this.textMode === 'html') {
                this.html.innerHTML = this.text;
            } else {
                this.html.textContent = this.text;
            }
        }
        return this;
    };
    /**
     * Sets the text rendering mode.
     * @param {String} textMode Possible values:
     *
     * - "plain": for plain text rendering.
     * - "html": for html text rendering. Only the <b>, <i>, <h1> to <h6> tags are allowed, any other tags will be
     * removed.
     */
    TextLabel.prototype.setTextMode = function (textMode) {
        if (textMode !== 'plain' && textMode !== 'html') {
            throw Error("setTextMode(): The parameter must be \"plain\" or \"html\".");
        }
        this.textMode = textMode;
        if (typeof this.rawText === 'string') {
            this.setText(this.rawText);
        }
        return this;
    };
    /**
     * Creates the label's HTML.
     * @return {HTMLElement}
     */
    TextLabel.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }
        TextLabel.superclass.prototype.createHTML.call(this);
        this.setText(this.rawText);
        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.TextLabel', TextLabel);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = TextLabel;
    }
}());
(function () {
    /**
     * @class PMUI.ui.FlashMessage
     * A message to display for a while.
     * @extends {PMUI.core.Element}
     *
     * Usage example:
     *
     *      @example
     *      var message = new PMUI.ui.FlashMessage({
     *          message: "Hi!, this is a flash message!",
     *          duration: 5000,
     *          severity: 'info'
     *      });
     *
     *      message.show();
     *
     * @constructor
     * Creates a new instance of the class.
     * @param {Object} [settings] The config options.
     *
     * @cfg {String|Array} [message=""] The object's message. It can be a single string or an array of strings. In the
     * llatter case the mesage will be showed in a list format.
     * @cfg {Number} [duration=3000] The time in milliseconds the message will be displayed.
     * @cfg {HTMLElement|PMUI.ui.Element} [appendTo=document.body] The html element/PMUI's object the flash message
     * will be displayed.
     * @cfg {String} [display="absolute"] The display mode for the object's html.
     * @cfg {String} [position="absolute"] The position mode for the object's html.
     * @cfg {String} [severity="info"] The severity for the message. Valid values: 'info', 'success', 'error'.
     */
    var FlashMessage = function (settings) {
        FlashMessage.superclass.call(this, settings);
        /**
         * The object's message. Set by the {@link #cfg-message message} config option and the
         * {@link #method-setMessage setMessage()} method.
         * @type {String|Array}
         * @readonly
         */
        this.message = null;
        /**
         * The duration in milliseconds to show the message. Set by the {@link #cfg-duration duration} config option
         * and the {@link #method-setDuration setDuration()} method.
         * @type {Number}
         * @readonly
         */
        this.duration = null;
        /**
         * The html element/PMUI's object the message will be displayed in. Set by the {@link #cfg-appendTo appendTo}
         * config option and the {@link #method-setAppendTo setAppendTo()} method.
         * @type {HTMLElement|PMUI.core.Element}
         */
        this.appendTo = null;
        /**
         * The message's severity. Set by the {@link #cfg-severity severity} config option and the
         * {@link #method-setSeverity setSeverity()} method.
         * @type {String}
         * @readonly
         */
        this.severity = null;
        FlashMessage.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', FlashMessage);
    /**
     * The object's type.
     * @type {String}
     */
    FlashMessage.prototype.type = 'FlashMessage';
    /**
     * The initializer method.
     * @param  {Object} [settings] The config options
     * @private
     */
    FlashMessage.prototype.init = function (settings) {
        var defaults = {
            message: "",
            duration: 3000,
            appendTo: document.body,
            display: 'inline-block',
            positionMode: 'fixed',
            severity: 'info'
        };

        jQuery.extend(true, defaults, settings);
        this.setMessage(defaults.message)
            .setDuration(defaults.duration)
            .setAppendTo(defaults.appendTo)
            .setPositionMode(defaults.positionMode)
            .setDisplay(defaults.display)
            .setSeverity(defaults.severity);
    };
    /**
     * Sets the severity for the message.
     * @param {String} severity Valid values: "info", "success" or "error".
     * @chainable
     */
    FlashMessage.prototype.setSeverity = function (severity) {
        if (!(severity === 'success' || severity === 'error' || severity === 'info')) {
            throw new Error('setSeverity(): the parameter must be "success" or "error" or "info"');
        }
        this.severity = severity;
        this.style.removeClasses(['pmui-info', 'pmui-error', 'pmui-success']).addClasses(['pmui-' + severity]);

        return this;
    };
    /**
     * Sets the html element/PMUI's object in which the message will be displayed.
     * @param {HTMLElement|PMUI.core.Element} appendTo
     * @chainable
     */
    FlashMessage.prototype.setAppendTo = function (appendTo) {
        if (!(PMUI.isHTMLElement(appendTo) || appendTo instanceof PMUI.core.Element)) {
            throw new Error("setAppendTo(): The parameter must be a HTML element or an instance of PMUI.ui.Element.");
        }
        this.appendTo = appendTo;
        return this;
    };
    /**
     * Sets the duration for display the message.
     * @param {Number} duration The duration in milliseconds.
     * @chainable
     */
    FlashMessage.prototype.setDuration = function (duration) {
        if (typeof duration !== 'number') {
            throw new Error('setDuration(): The parameter must be a number.');
        }
        this.duration = duration;
        return this;
    };
    /**
     * Sets the message for the object.
     * @param {String|Array} message It can be a string or an array of strings, in the latter case the message will be
     * showed in a list format.
     * @chainable
     */
    FlashMessage.prototype.setMessage = function (message) {
        var ul,
            li,
            i;

        if (typeof message !== 'string' && !jQuery.isArray(message)) {
            throw new Error('setMessage(): The parameter must be a message.');
        }
        this.message = (typeof message === 'string') ? jQuery.trim(message) : message;
        if (this.html) {
            jQuery(this.html).empty();
            if (typeof message === 'string') {
                this.html.textContent = message;
            } else {
                ul = PMUI.createHTMLElement('ul');
                ul.className = 'pmui-flashmessage-list';
                ul.style.listStyleType = 'none';
                for (i = 0; i < message.length; i += 1) {
                    li = PMUI.createHTMLElement('li');
                    li.textContent = message[i];
                    ul.appendChild(li);
                }
                this.html.appendChild(ul);
            }

        }
        return this;
    };
    /**
     * Shows the message in the html element/PMUI's object specified by the {@link #cfg-appendTo appendTo} config
     * option or the {@link #method-setAppendTo setAppendTo()} method.
     * @chainable
     */
    FlashMessage.prototype.show = function () {
        var targetHTML = this.appendTo,
            html = this.html,
            top = 50,
            w,
            pw;

        if (!PMUI.isHTMLElement(targetHTML)) {
            targetHTML = targetHTML.html;
        }
        if (targetHTML) {
            if (!html) {
                html = this.getHTML();
            }
            jQuery(html).fadeTo(1, 0).get(0).style.top = top + "px";
            document.body.appendChild(html);
            w = jQuery(html).outerWidth();
            targetHTML.appendChild(html);
            this.style.addProperties({
                left: '50%',
                'margin-left': w / -2
            });
            jQuery(html).finish().css({
                'top': '50px'
            }).fadeTo(1, 0).animate({
                top: "-=" + top,
                opacity: 1
            }, 400, 'swing').delay(this.duration).animate({
                top: "+=" + top,
                opacity: 0,
                zIndex: '0'
            });
        }
        return this;
    };
    /**
     * @inheritDoc
     */
    FlashMessage.prototype.createHTML = function () {
        FlashMessage.superclass.prototype.createHTML.call(this);
        this.setMessage(this.message);
        return this.html;
    };

    PMUI.extendNamespace('PMUI.ui.FlashMessage', FlashMessage);

    if (typeof exports !== 'undefined') {
        module.exports = FlashMessage;
    }
}());
(function () {
    var Menu = function (settings) {
        settings = jQuery.extend(true, settings, {
            elementTag: 'ul',
            positionMode: 'absolute'
        });
        Menu.superclass.call(this, settings);
        this.targetElement = null;
        this.parent = null;
        this.onShow = null;
        this.onHide = null;
        this.displayed = null;
        this.factory = new PMUI.menu.MenuItemFactory();
        this.items = new PMUI.util.ArrayList();
        this.onOutsideClickHandler = null;
        Menu.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', Menu);

    Menu.prototype.type = 'Menu';

    Menu.prototype.init = function (settings) {
        var defaults = {
            targetElement: null,
            parent: null,
            onShow: null,
            onHide: null,
            items: []
        };

        jQuery.extend(true, defaults, settings);

        this.onShow = defaults.onShow;
        this.onHide = defaults.onHide;
        this.setParent(defaults.parent)
            .setItems(defaults.items)
            .setTargetElement(defaults.targetElement)
            .setOutsideClickHandler();
    };

    Menu.prototype.setOutsideClickHandler = function () {
        var that = this;

        this.onOutsideClickHandler = function (e) {
            if (!jQuery(e.currentTarget).parents('#' + that.id).length) {
                that.hide();
            }
        };
        return this;
    };

    Menu.prototype.setTargetElement = function (target) {
        var rootMenu,
            targetElement = (this.targetElement && this.targetElement.html) || document.body;

        $(targetElement).removeClass('pmui-contextmenu-target');
        if (target instanceof PMUI.core.Element || null) {
            rootMenu = this.getRootMenu();
            if (rootMenu.targetElement) {
                if (rootMenu.targetElement.menu === rootMenu) {
                    rootMenu.targetElement.menu = null;
                }
            }
            rootMenu.targetElement = target;
        }
        return this;
    };

    Menu.prototype.getTargetElement = function () {
        var rootMenu = this.getRootMenu();
        return rootMenu.targetElement;
    };

    Menu.prototype.addItem = function (item) {
        var newItem = this.factory.make(item);

        if (newItem) {
            newItem.setParent(this);
            this.items.insert(newItem);
            if (this.html) {
                this.html.appendChild(newItem.getHTML());
            }
        }
        return this;
    };

    Menu.prototype.removeItem = function (item) {
        var itemToRemove;

        if (typeof item === 'string') {
            itemToRemove = this.items.find('id', item);
        } else if (typeof item === 'number') {
            itemToRemove = this.items.get(item);
        } else if (item instanceof PMUI.item.MenuItem && this.items.contains(item)) {
            itemToRemove = item;
        }
        if (itemToRemove) {
            this.items.remove(itemToRemove);
            jQuery(itemToRemove.html).detach();
        }
        return this;
    };

    Menu.prototype.clearItems = function () {
        var index = 0;
        while (this.items.getSize()) {
            this.removeItem(index);
        }
        return this;
    };

    Menu.prototype.setItems = function (items) {
        var i;

        if (!jQuery.isArray(items)) {
            throw new Error('setItems(): The parameter must be an array.');
        }
        this.clearItems();
        for (i = 0; i < items.length; i += 1) {
            this.addItem(items[i]);
        }
        return this;
    };

    Menu.prototype.getItems = function () {
        var index = 0;
        return this.items.asArray().slice(index);
    };

    Menu.prototype.setParent = function (parent) {
        if (!(parent === null || parent instanceof PMUI.menu.MenuItem)) {
            throw new Error('setParent(): The parameter must be an instance of PMUI.item.MenuItem or null.');
        }
        this.parent = parent;
        return this;
    };

    Menu.prototype.defineEventListeners = function () {
        this.removeEvents();
        this.addEvent('contextmenu').listen(this.html, function (e) {
            e.stopPropagation();
            e.preventDefault();
        });
        this.addEvent('click').listen(this.html, function (e) {
            e.stopPropagation();
        });
        this.addEvent('mousedown').listen(this.html, function (e) {
            e.stopPropagation();
        });

        return this;
    };

    Menu.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }

        Menu.superclass.prototype.createHTML.call(this);

        this.setItems(this.items.asArray().slice(0));

        this.defineEventListeners();

        return this.html;
    };

    Menu.prototype.isRoot = function () {
        return !this.parent;
    };

    Menu.prototype.getRootMenu = function () {
        if (this.isRoot()) {
            return this;
        } else {
            return this.parent.parent.getRootMenu();
        }
    };

    Menu.prototype.show = function (x, y) {
        var rootMenu = this.getRootMenu(),
            targetElement = (this.targetElement && this.targetElement.html) || document.body,
            zIndex = parseInt(targetElement.style.zIndex);
        x = x || 0;
        y = y || 0;
        rootMenu.setPosition({
            x: x,
            y: y
        });
        PMUI.removeCurrentMenu();
        rootMenu.setZOrder(zIndex + 1);
        $(targetElement).addClass('pmui-contextmenu-target');
        document.body.appendChild(rootMenu.getHTML());
        this.addEvent('mousedown', 'clickOutside').listen(document, this.onOutsideClickHandler);
        this.displayed = true;
        PMUI.currentContextMenu = this;
        if (typeof this.onShow === 'function') {
            this.onShow(this);
        }
        if (document.documentElement.clientHeight - y < jQuery(this.html).outerHeight()) {
            this.html.style.top = y - jQuery(this.html).outerHeight() + 'px'
        }
        return this;
    };

    Menu.prototype.hide = function () {
        var rootMenu = this.getRootMenu(),
            targetElement = (this.targetElement && this.targetElement.html) || document.body;

        this.removeEvent('clickOutside');
        $(targetElement).removeClass('pmui-contextmenu-target');
        jQuery(rootMenu.html).detach();
        rootMenu.displayed = false;
        PMUI.currentContextMenu = null;
        if (typeof rootMenu.onHide === 'function') {
            rootMenu.onHide(rootMenu);
        }
        return this;
    };

    Menu.prototype.setContextMenu = function () {
        return this;
    };

    PMUI.extendNamespace('PMUI.menu.Menu', Menu);

    // Declarations created to instantiate in NodeJS environment
    if (typeof exports !== "undefined") {
        module.exports = Menu;
    }
}());
(function () {
    var MenuItem = function (settings) {
        MenuItem.superclass.call(this, settings);
        this.dom = {};
        this.parent = null;
        MenuItem.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', MenuItem);

    MenuItem.prototype.type = 'MenuItem';

    MenuItem.prototype.init = function (settings) {
        var defaults = {
            parent: null
        }

        jQuery.extend(true, defaults, settings);

        this.setParent(defaults.parent);
    };

    MenuItem.prototype.setParent = function (parent) {
        if (!(parent === null || parent instanceof PMUI.menu.Menu)) {
            throw new Error('setParent(): The parameter must be an instance of PMUI.ui.Menu or null.');
        }
        this.parent = parent;
        return this;
    };

    MenuItem.prototype.getParent = function () {
        return this.parent;
    };

    MenuItem.prototype.getRootMenu = function () {
        var parent = this.parent;

        if (this.parent) {
            return this.parent.getRootMenu();
        }
        return parent;
    };

    MenuItem.prototype.isLeaf = function () {
        throw new Error("isLeaf() is being called from an abstract class.");
    };

    MenuItem.prototype.getMenu = function () {
        return this.parent;
    };

    MenuItem.prototype.setContextMenu = function () {
        return this;
    };

    MenuItem.prototype.getMenuTargetElement = function () {
        var rootMenu = this.getRootMenu();

        if (rootMenu) {
            return rootMenu.getTargetElement();
        }
        return rootMenu
    };

    MenuItem.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }
        MenuItem.superclass.prototype.createHTML.call(this);
        return this.html;
    };

    PMUI.extendNamespace('PMUI.menu.MenuItem', MenuItem);

}());
(function () {
    var MenuOption = function (settings) {
        MenuOption.superclass.call(this, settings);
        this.onClick = null;
        this.text = null;
        this.hideOnClick = null;
        this.disabled = null;
        MenuOption.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.menu.MenuItem', MenuOption);

    MenuOption.prototype.type = 'MenuOption';

    MenuOption.prototype.init = function (settings) {
        var defaults = {
            onClick: null,
            elementTag: 'li',
            text: '[option]',
            hideOnClick: true,
            disabled: false
        };

        jQuery.extend(true, defaults, settings);
        this.setElementTag(defaults.elementTag)
            .setText(defaults.text)
            .setOnClickHandler(defaults.onClick)
            .hideOnClick = !!defaults.hideOnClick;

        if (defaults.disabled) {
            this.disable();
        } else {
            this.enable();
        }
    };

    MenuOption.prototype.enable = function () {
        this.disabled = false;
        this.style.removeClasses(['pmui-disabled']);
        return this;
    };

    MenuOption.prototype.disable = function () {
        this.disabled = true;
        this.style.addClasses(['pmui-disabled']);
        return this;
    };

    MenuOption.prototype.setText = function (text) {
        if (typeof text !== 'string') {
            throw new Error('setText(): the parameter must be a srting.');
        }
        this.text = text;
        if (this.dom.textContainer) {
            this.dom.textContainer.textContent = text;
        }
        return this;
    };

    MenuOption.prototype.setOnClickHandler = function (onClick) {
        if (!(onClick === null || typeof onClick === 'function')) {
            throw new Error('setOnClickHandler(): The parameter must be a function or null.');
        }
        this.onClick = onClick;
        return this;
    };

    MenuOption.prototype.onClickHandler = function () {
        var that = this;

        return function (e) {
            e.preventDefault();
            e.stopPropagation();
            if (!that.disabled) {
                if (typeof that.onClick === 'function') {
                    that.onClick(that);
                }
                if (that.hideOnClick) {
                    that.parent.hide();
                }
            }
        };
    };

    MenuOption.prototype.remove = function () {
        this.parent.removeItem(this);
        return this;
    };

    MenuOption.prototype.defineEventListeners = function () {
        this.removeEvents();
        this.addEvent('click').listen(this.dom.title, this.onClickHandler());
        return this;
    };

    MenuOption.prototype.createHTML = function () {
        var link,
            textContainer,
            iconContainer;

        if (this.html) {
            return this.html;
        }
        MenuOption.superclass.prototype.createHTML.call(this);

        link = PMUI.createHTMLElement('a');
        link.href = '#';
        link.className = 'pmui-menuoption-title';

        textContainer = PMUI.createHTMLElement('span');
        textContainer.className = 'pmui-menuoption-text';

        iconContainer = PMUI.createHTMLElement('i');
        iconContainer.className = 'pmui-menuoption-text-icon';

        this.dom.title = link;
        this.dom.textContainer = textContainer;
        this.dom.iconContainer = iconContainer;

        link.appendChild(iconContainer);
        link.appendChild(textContainer);
        this.html.appendChild(link);

        this.setText(this.text);

        this.defineEventListeners();

        return this.html;
    };

    PMUI.extendNamespace('PMUI.menu.MenuOption', MenuOption);
}());
(function () {
    var MenuRegularOption = function (settings) {
        MenuRegularOption.superclass.call(this, settings);
        this.childMenu = null;
        MenuRegularOption.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.menu.MenuOption', MenuRegularOption);

    MenuRegularOption.prototype.init = function (settings) {
        var defaults = {
            items: []
        };

        jQuery.extend(true, defaults, settings);

        this.childMenu = new PMUI.menu.Menu({
            positionMode: 'absolute',
            parent: this
        });

        this.setItems(defaults.items);
    };

    MenuRegularOption.prototype.setItems = function (items) {
        this.childMenu.setItems(items);
        if (this.childMenu.getItems().length) {
            this.style.addClasses(['pmui-father']);
        }
        return this;
    };

    MenuRegularOption.prototype.getItems = function () {
        return this.childMenu.getItems();
    };

    MenuRegularOption.prototype.onClickHandler = function () {
        var that = this;
        return function (e) {
            e.preventDefault();
            e.stopPropagation();
            if (!that.disabled) {
                if (typeof that.onClick === 'function') {
                    that.onClick(that);
                }
                if (that.hideOnClick && that.childMenu.getItems().length === 0) {
                    that.parent.hide();
                }
            }
        };
    };

    MenuRegularOption.prototype.createHTML = function () {
        if (this.html) {
            return this.html;
        }
        MenuRegularOption.superclass.prototype.createHTML.call(this);
        this.html.appendChild(this.childMenu.getHTML());
        this.setItems(this.getItems());
        return this.html;
    };

    PMUI.extendNamespace('PMUI.menu.MenuRegularOption', MenuRegularOption);
}());
(function () {
    var MenuSeparatorItem = function (settings) {
        MenuSeparatorItem.superclass.call(this, jQuery.extend(true, settings, {
            elementTag: 'div'
        }));
        MenuSeparatorItem.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.menu.MenuItem', MenuSeparatorItem);

    MenuSeparatorItem.prototype.type = 'MenuSeparatorItem';

    MenuSeparatorItem.prototype.isLeaf = function () {
        return true;
    };

    PMUI.extendNamespace('PMUI.menu.MenuSeparatorItem', MenuSeparatorItem);
}());
(function () {
    var MenuItemFactory = function (settings) {
        MenuItemFactory.superclass.call(this, settings);
        MenuItemFactory.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.util.Factory', MenuItemFactory);

    MenuItemFactory.prototype.type = "MenuItemFactory";

    MenuItemFactory.prototype.init = function (settings) {
        var defaults = {
            products: {
                "menuRegularOption": PMUI.menu.MenuRegularOption,
                "menuSeparatorItem": PMUI.menu.MenuSeparatorItem
            },
            defaultProduct: "menuRegularOption"
        };

        this.setDefaultProduct(defaults.defaultProduct)
            .setProducts(defaults.products);
    };

    PMUI.extendNamespace('PMUI.menu.MenuItemFactory', MenuItemFactory);
}());
(function () {
    /**
     * @class PMUI.form.Field
     * Abstract class that encapsulates the field behavior
     * @extends PMUI.core.Element
     * @abstract
     *
     * @constructor
     * While it is true that this class must not be instantiated,
     * it is useful to mention the settings parameter for the constructor function
     * (which will be used for the non abstract subclasses).
     * @param {Object} [settings] A JSON object, it can be contain the following fields:
     *
     * - {@link PMUI.form.Field#cfg-name name}.
     * - {@link PMUI.form.Field#cfg-label label}.
     * - {@link PMUI.form.Field#cfg-value value}.
     * - {@link PMUI.form.Field#cfg-helper helper}.
     * - {@link PMUI.form.Field#cfg-showHelper showHelper}.
     * - {@link PMUI.form.Field#cfg-validators validators}.
     * - {@link PMUI.form.Field#cfg-valueType valueType}.
     * - {@link PMUI.form.Field#cfg-controlPositioning controlPositioning}.
     * - {@link PMUI.form.Field#cfg-labelWidth labelWidth}.
     * - {@link PMUI.form.Field#cfg-showColon showColon}
     *
     * @cfg {String} name The name for the field.
     * @cfg {String} label The text to be shown as the field's label
     * @cfg {String} value The initial value to be set to the control.
     * @cfg {String} helper The helper text to be shown in the helper tooltip
     * @cfg {Boolean} showHelper A boolean value which determines if the helper tootltip will be shown or not.
     * @cfg {Object} validators An array where each array's item is a JSON object (with the validator setting data)
     *  or a {@link PMUI.form.Validator Validator} object.
     *      {
     *          validators: [
     *              {
     *                  type: "maxlength",
     *                  criteria: 5
     *              },
     *              new LengthValidator({
     *                  min: 0,
     *                  max: 5
     *              })
     *          ]
     *      }
     * In example above, "validators" is an array in which their first element is an JSON object
     * and the second one is a {@link PMUI.form.Validator Validator} object.
     * @cfg {String} valueType A string which specifies the data type for the Field value.
     * @cfg {String} controlPositioning A formatted string that specifies the order output for the control(s).
     * A string  which specifies the output order for the field's controls.
     * Basically this string uses a wildcard with the format "[cx]", each one is replaced by the control:
     *      "[c0]-[c1]-[c2]"
     * If you apply the string above to the controlPositioning property, it will render
     * the first three field's controls, each one separated from the other by a "-".
     *
     * Another wildcard is [c*], this represents all the controls or the ones that haven't been included yet:
     *      "[c*]-"
     * The example above will render all the controls and at the end it will add a "-".
     *
     *      "[c2]-[c*]"
     * The example above will render first the second control and then the other ones (starting from the first one).
     * @cfg {String} labelWidth The width for the label.
     * The width label should be a String with the following format "X%"
     *
     * Note that this% should not exceed 80%, because 20% is the tooltip
     * @cfg {Boolean} showColon If a colon is shown after the label text.
     * @cfg {Boolean} [labelVisible=true] If the label is visible or not.
     * @cfg {String} [labelPosition="left"] Sets the position for the label, the value can take one of the following
     * options:
     *
     * - "left" (default).
     * - "right".
     * - "top".
     * - "bottom"
     *
     * @cfg {String|Number|Array} [controlsWidth] Determines the width for the field's controls, but the width of the
     * field must be a number or a string with the format "#px", otherwise the width for the controls will be set to
     * "auto".It can be:
     *
     * - A String, in this case the string must have the following format "##px", otherwise must be "auto".
     * - A Number, in this case the value received is parsed into a px units value.
     * - An Array in which each element can be a String or a Number (following the rules above).
     *
     * This will be applied respectively to each control in the field.
     * @cfg {Function} [onClick=null] Description here.
     * @cfg {Function|null} [onBeforeChange] The callback function to be executed before the field's value changes. To
     * avoid the change the callback function must return false. For info about the parameters sent to the calback
     * function please read the {@link #event-onBeforeChange onBeforeChange event} documentation.
     */
    var Field = function (settings) {
        Field.superclass.call(this, settings);
        /**
         * @property {String} [name=[The object's id]] The field's name.
         * @readonly
         */
        this.name = null;
        /**
         * @property {String} [label = "[field]"] The field's label text.
         * @readonly
         */
        this.label = null;
        /**
         * @property {String} [value=""] The field's value.
         * @readonly
         */
        this.value = null;
        /**
         * @property {PMUI.ui.TooltipMessage} [helper] The field's help tooltip
         * @readonly
         */
        this.helper = null;
        /**
         * @property {PMUI.ui.TooltipMessage} [message] A {@link PMUI.ui.TooltipMessage TooltipMessage}
         * object to show a message related to the field (i.e. validation error messages)
         * @private
         */
        this.message = null;
        /**
         * @property {Array} controls An array, it will contain all the necessary Control objects
         * @private
         */
        this.controls = [];
        /**
         * @property {Object} validators An JSON object which will contain all the
         * {@link PMUI.form.Validator Validators} object.
         * @private
         */
        this.validators = {};
        /**
         * @property {String} [controlPositioning="[c*]"] A formatted string that specifies
         * the order output for the field's controls.
         * @readonly
         */
        this.controlPositioning = null;
        /**
         * @property {Object} [dom] A JSON object which will contain important DOM object
         * for the Field object.
         * @private
         */
        this.dom = null;
        /**
         * @property {Boolean} [helperIsVisible=false] A Boolean that let us
         * know if the help tooltip will be shown or not.
         * @readonly
         */
        this.helperIsVisible = null;
        /**
         * @property {String} [labelWidth="30%"]
         * The width for the label. This property should be a String with the following format "X%"
         * @readonly
         */
        this.labelWidth = null;
        /**
         * @property {Boolean} [visibleColon=true]
         * If a colon is shown after the label text.
         * @readonly
         */
        this.visibleColon = null;
        /**
         * @property {Boolean} labelVisible
         * If the label is visible or not.
         * @readonly
         */
        this.labelVisible = null;
        /**
         * @property {String} [labelPosition="String"] The position for the field's label.
         * @readonly
         */
        this.labelPosition = null;
        /**
         * @event onBeforeChange
         * Fired before the field's value changes.
         * @param {String} newValue The new value to be set.
         * @param {String} oldValue The old field's value.
         */
        this.onBeforeChange = null;
        /**
         * @event onChange
         * Fired when the field's value changes.
         * @param {String} newValue The field's new value.
         * @param {String} oldValue The previous field's value.
         */
        this.onChange = null;
        /**
         * @property {String} valueType The value data type for the field.
         */
        this.valueType = null;
        /**
         * @property {PMUI.form.ValidatorFactory} validatorFactory The factory object for validator production.
         */
        this.validatorFactory = null;
        /**
         * @property {Boolean} [required] If the field is required or not
         */
        this.required = null;
        /**
         * @property {String} [requiredMessage="This field is required."]
         * The message to display when the validation for required property fails.
         */
        this.requiredMessage = null;
        /**
         * @property {Boolean} [validAtChange=true]
         * If the validation must be executed every time the field's value changes.
         */
        this.validAtChange = null;
        /**
         * The width for the control(s)
         * @type {Number|String|Array}
         * @readonly
         */
        this.controlsWidth = [];
        /**
         * @property {Number|String} controlsContainerWidth
         * @type {Number|String}
         */
        this.controlsContainerWidth = null;
        /**
         * @property {PMUI.form.Form} form
         * The form the field belongs to.
         */
        this.form = null;
        /**
         * @property {Boolean} eventsDefined
         * If the events for the object have been defined.
         */
        this.eventsDefined = null;
        /**
         * @property {PMUI.data.DataSet} data
         * The field's data object.
         * @private
         */
        this.data = null;
        /**
         * The initial value the field will be set when its reset() method is called.
         * @type {String}
         * @private
         */
        this.initialValue = null;
        /**
         * [onClick description]
         * @type {[type]}
         */
        this.onClick = null;
        /**
         * If the field is disabled or not. Notice that if it is disabled the validation won't be executed.
         * @type {Boolean}
         */
        this.disabled = null;

        /**
         * @protected
         * Valid Types
         * @type {Array}
         */
        this.dependentFields = [];
        this.dependencyHandler = null;

        this.validTypes = {
            'string': true,
            'number': true,
            'boolean': true,
            'date': true,
            'object': true,
            'integer': true,
            'float': true
        };
        Field.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.core.Element', Field);

    Field.prototype.type = "Field";

    Field.prototype.init = function (settings) {
        var defaults = {
            name: this.id,
            label: '[field]',
            value: '',
            helper: '',
            showHelper: !!(settings && settings.helper),
            validators: [],
            valueType: 'string',
            controlPositioning: '[c*]',
            labelWidth: '23.5%',
            width: '100%',
            showColon: true,
            validatorFactory: new PMUI.form.ValidatorFactory(),
            onBeforeChange: null,
            onChange: null,
            required: false,
            validAtChange: true,
            requiredMessage: 'This field is required.'.translate(),
            labelVisible: true,
            labelPosition: 'left',
            form: null,
            controlsWidth: "auto",
            controlsContainerWidth: "70%",
            disabled: false,
            dependentFields: [],
            dependencyHandler: function () {
            },
            onClick: null
        };

        this.dependentFields = [];
        this.dependencyFields = new PMUI.util.ArrayList();
        $.extend(true, defaults, settings);

        this.initialValue = defaults.value;

        this.helper = new PMUI.ui.TooltipMessage({
            category: 'help'
        });

        this.dom = {};
        this.data = new PMUI.data.DataField();

        this.message = new PMUI.ui.TextLabel({
            text: 'This field is required.'.translate(),
            displayMode: 'block',
            mode: 'normal',
            visible: false
        });

        this.setForm(defaults.form)
            .setValidAtChange(defaults.validAtChange)
            .setRequired(defaults.required)
            .setRequiredMessage(defaults.requiredMessage)
            .setValidatorFactory(defaults.validatorFactory)
            .setValidators(defaults.validators)
            .setName(defaults.name)
            .setLabel(defaults.label)
            .setValue(defaults.value)
            .setHelper(defaults.helper)
            .setValueType(defaults.valueType)
            .setControlPositioning(defaults.controlPositioning)
            .setOnBeforeChangeHandler(defaults.onBeforeChange)
            .setOnChangeHandler(defaults.onChange)
            .setWidth(defaults.width)
            .setLabelWidth(defaults.labelWidth)
            .setLabelPosition(defaults.labelPosition)
            .setControlsWidth(defaults.controlsWidth)
            .setControlsContainerWidth(defaults.controlsContainerWidth)
            .setOnClickHandler(defaults.onClick)
            .setControls();
        this.setDependencyHandler(defaults.dependencyHandler);
        this.setDependentFields(defaults.dependentFields);

        if (defaults.showHelper) {
            this.showHelper();
        } else {
            this.hideHelper();
        }
        if (defaults.showColon) {
            this.showColon();
        } else {
            this.hideColon();
        }
        if (defaults.labelVisible) {
            this.showLabel();
        } else {
            this.hideLabel();
        }
        if (defaults.disabled) {
            this.disable();
        } else {
            this.enable();
        }
    };
    Field.prototype.onBeforeChangeHandler = function (handler) {
        var that = this;
        return function (newValue, oldValue) {
            var callbackResponse,
                futureValue = "",
                i;

            if (typeof that.onBeforeChange === 'function') {
                for (i = 0; i < that.controls.length; i += 1) {
                    if (that.controls[i] === this) {
                        futureValue += ' ' + newValue;
                    } else {
                        futureValue += ' ' + that.controls[i].getValue();
                    }
                }
                futureValue = futureValue.substr(1);
                callbackResponse = that.onBeforeChange(futureValue, that.getValue());
            }
            return callbackResponse;
        };
    };
    Field.prototype.setOnBeforeChangeHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error("setOnBeforeChangeHandler(): The parameter must be a function or null.");
        }
        this.onBeforeChange = handler;
        return this;
    };
    Field.prototype.setOnClickHandler = function (handler) {
        if (!(handler === null || typeof handler === 'function')) {
            throw new Error("setOnClickHandler(): The parameter must be a function or null.");
        }
        this.onClick = handler;
        return this;
    };
    Field.prototype.setDependentFields = function (dependentFields) {
        if (!jQuery.isArray(dependentFields)) {
            throw new Error("setDependentFields(): The parameter must be an array.");
        }
        this.dependentFields = dependentFields;
        if (this.form) {
            this.form.updateDependencies();
        }
        return this;
    };

    Field.prototype.removeDependentField = function (FieldName) {
        var i;

        for (i = 0; this.dependentFields.length; i += 1) {
            if (this.dependentFields[i] === FieldName) {
                this.dependentFields.splice(i, 1);
                i--;
            }
        }
        return this;
    };

    Field.prototype.setDependencyHandler = function (handler) {
        if (typeof handler == 'function' || handler == null) {
            this.dependencyHandler = handler;
        }
        return this;
    };

    /**
     * Disables the field. Notice that when a field is disabled it is not validated and it is not returned when its
     * form's getData() method is invoked.
     * @chainable
     */
    Field.prototype.disable = function () {
        var i;

        this.disabled = true;
        this.style.addClasses(["pmui-disabled"]);
        for (i = 0; i < this.controls.length; i += 1) {
            this.controls[i].disable(true);
        }

        return this;
    };
    /**
     * Enables the field.
     * @chainable
     */
    Field.prototype.enable = function () {
        var i;

        this.disabled = false;
        this.style.removeClasses(["pmui-disabled"]);
        for (i = 0; i < this.controls.length; i += 1) {
            this.controls[i].disable(false);
        }

        return this;
    };
    /**
     * Resets the field to its original value.
     * @chainable
     */
    Field.prototype.reset = function () {
        this.setValue(this.initialValue);
        this.hideMessage();
        if (this.eventsDefined) {
            this.onChangeHandler();
        }
        return this;
    };
    /**
     * Determines the width for the field's controls, but the width of the field must be a number or a string with
     * the format "#px", otherwise the width for the controls will be set to "auto".
     * @param {Number|String|Array} width  It can be:
     *
     * - A String, in this case the string must have the following format "##px", otherwise must be "auto".
     * - A Number, in this case the value received is parsed into a px units value.
     * - An Array in which each element can be a String or a Number (following the rules above).
     *
     * This will be applied respectively to each control in the field.
     * @chainable
     */
    Field.prototype.setControlsWidth = function (width) {
        var i,
            labelWidthPx,
            auxWidth,
            autoGerateWidthForControls = false,
            fieldWidthIsAbsolute = false;

        if (!(width === 'auto' || typeof width === 'number' || jQuery.isArray(width) || /^\d+(\.\d+)?px/.test(width))) {
            throw new Error("setControlsWidth(): The parameter must be a string \"auto\", or a number or an array.");
        }

        this.controlsWidth = width;

        if (width === 'auto') {
            autoGerateWidthForControls = true;
        }

        if (typeof this.width === 'number' || /^\d+(\.\d+)?px/.test(this.width)) {
            fieldWidthIsAbsolute = true;
        }

        if (!autoGerateWidthForControls) {
            for (i = 0; i < this.controls.length; i += 1) {
                if (jQuery.isArray(width)) {
                    this.controls[i].setWidth(width[i] || "auto");
                } else {
                    this.controls[i].setWidth(width);
                }
            }
        } else if (fieldWidthIsAbsolute) {
            auxWidth = parseInt(this.width, 10);
            labelWidthPx = auxWidth * (parseInt(this.labelWidth, 10) / 100) + 4;
            labelWidthPx = auxWidth - 83 - labelWidthPx;
            for (i = 0; i < this.controls.length; i += 1) {
                this.controls[i].setWidth(labelWidthPx);
            }
        } else {
            for (i = 0; i < this.controls.length; i += 1) {
                this.controls[i].setWidth("auto");
            }
        }

        return this;
    };
    /**
     * Sets the width for the controls container.
     * @param width
     */
    Field.prototype.setControlsContainerWidth = function (width) {
        if (!(typeof width === 'number' || jQuery.isArray(width) || /^\d+(\.\d+)?(px|\%)/.test(width))) {
            throw new Error("setControlsContainerWidth(): The parameter must be a string (with a numeric or percentage value), or a number or an array.");
        }
        this.controlsContainerWidth = width;
        if (this.dom && this.dom.controlContainer) {
            $(this.dom.controlContainer).css('width', width);
        }
        return this;
    };
    /**
     * Sets the form the field belongs to.
     * @param {PMUI.form.Form} form
     * @chainable
     */
    Field.prototype.setForm = function (form) {
        if (form instanceof PMUI.form.Form) {
            this.form = form;
        }

        return this;
    };
    /**
     * Turns on/off the validation when the field's value changes.
     * @param {Boolean} validAtChange
     * @chainable
     */
    Field.prototype.setValidAtChange = function (validAtChange) {
        this.validAtChange = !!validAtChange;
        return this;
    };
    /**
     * Sets the position for the label.
     * @param {String} position It can take one of the following values: "top", "right", "bottom", "left".
     * @chainable
     */
    Field.prototype.setLabelPosition = function (position) {
        if (position === 'top' || position === 'right' || position === 'bottom' || position === 'left') {
            this.labelPosition = position;
            if (this.html) {
                if (position === 'top' || position === 'left') {
                    this.html.insertBefore(this.dom.labelTextContainer, this.dom.controlContainer);
                    this.dom.labelTextContainer.style.display = position === 'top' ? 'block' : 'inline-block';
                    $(this.dom.controlContainer).css("float", '');
                } else {
                    this.html.insertBefore(this.dom.controlContainer, this.dom.labelTextContainer);
                    this.dom.labelTextContainer.style.display = position === 'bottom' ? 'block' : 'inline-block';
                    $(this.dom.labelTextContainer).css("float", '');
                }
            }
        } else {
            throw new Error('setLabelPosition(): it only accepts "top", "rigth", "left" or "bottom" as value for ' +
                'the parameter');
        }

        return this;
    };
    /**
     * Sets the factory which must be produce {@link PMUI.form.Validator Validator} objects.
     * @param {PMUI.util.Factory|Object} factory
     * It can be a:
     *
     * - a {@link PMUI.util.Factory} object
     * - a JSON object: in this case a new {@link PMUI.form.ValidatorFactory ValidatorFactory} will be created
     * using the JSON object as the constructor parameter.
     * @private
     * @chainable
     */
    Field.prototype.setValidatorFactory = function (factory) {
        if (factory instanceof PMUI.util.Factory) {
            this.validatorFactory = factory;
        } else {
            this.validatorFactory = new PMUI.form.ValidatorFactory(factory);
        }

        return this;
    };
    /**
     * Sets the message to show when the required field validation fails.
     * @param {String} requiredMessage
     * @chainable
     */
    Field.prototype.setRequiredMessage = function (requiredMessage) {
        if (typeof requiredMessage === 'string') {
            this.requiredMessage = requiredMessage;
        } else {
            throw new Error("the setRequiredMessage() method only accepts string values.");
        }

        return this;
    };
    /**
     * Sets if the fields is required or not.
     * @param {Boolean} required
     * @chainable
     */
    Field.prototype.setRequired = function (required) {
        this.required = !!required;
        if (this.dom.fieldRequired) {
            if (this.required) {
                this.showRequired();
            } else {
                this.hideRequired();
            }
        }
        return this;
    };

    Field.prototype.hideRequired = function () {
        this.dom.fieldRequired.style.display = 'none';
        return this;
    };

    Field.prototype.showRequired = function () {
        this.dom.fieldRequired.style.display = 'inline-block';
        return this;
    };
    /**
     * Removes all the validators from the field.
     * @chainable
     */
    Field.prototype.clearValidators = function () {
        var key;

        for (key in this.validators) {
            if (this.validators.hasOwnProperty(key)) {
                this.validators[key] = null;
                delete this.validators[key];
            }
        }

        return this;
    };
    /**
     * Adds a validator to the field.
     * @param {String|PMUI.form.Validator|Object} validator
     * It can be:
     *
     * - a String: it must be on of the supported pmTypes by the
     * {@link PMUI.form.ValidatorFactory ValidatorFactory} class.
     * - a {@link PMUI.form.Validator Validator} object.
     * - a JSON object: in this case the JSON structure must be the same as the needed one to create
     * the desired validator, additionally must have the respective pmType.
     *
     * Note. All the supported pmTypes are specified in the
     * {@link PMUI.form.ValidatorFactory ValidatorFactory documentation}.
     * @chainable
     */
    Field.prototype.addValidator = function (validator) {
        var newValidator;

        if (this.validatorFactory) {
            if (this.validatorFactory.isValidClass(validator) || this.validatorFactory.isValidName(validator.pmType)) {
                newValidator = this.validatorFactory.make(validator);
            } else {
                throw new Error('Invalid validator to add.');
            }
        }

        if (newValidator && newValidator instanceof PMUI.form.Validator) {
            newValidator.setParent(this);
            this.validators[newValidator.type] = newValidator;
        }

        return this;
    };
    /**
     * Sets the validators for the field.
     * @param {Array} validators An array in which each element can be one of the accepted types in the
     * {@link PMUI.form.Field#addValidator addValidator() method}.
     * @chainable
     */
    Field.prototype.setValidators = function (validators) {
        var i = 0;

        if (jQuery.isArray(validators)) {
            this.clearValidators();
            for (i = 0; i < validators.length; i += 1) {
                this.addValidator(validators[i]);
            }
        }

        return this;
    };
    /**
     * Shows a colon after the label text.
     * @chainable
     */
    Field.prototype.showColon = function () {
        this.visibleColon = true;
        if (this.dom.fieldColon) {
            this.dom.fieldColon.style.display = '';
        }
    };
    /**
     * Hides the colon after the label text.
     * @chainable
     */
    Field.prototype.hideColon = function () {
        this.visibleColon = false;
        if (this.dom.fieldColon) {
            this.dom.fieldColon.style.display = "none";
        }
        return this;
    }
    /**
     * Sets the width for the label.
     * @param {String} width It can be a Number or a String.
     * This parameter should be a String with the following format "X%";
     * @chainable
     */
    Field.prototype.setLabelWidth = function (width) {
        if (/^\d+(\.\d+)?(px|em|%)$/.test(width)) {
            this.labelWidth = width;
            this.setControlsWidth(this.controlsWidth);
        } else {
            throw new Error('setLabelWidth(): invalid "width" parameter');
        }
        if (this.dom.labelTextContainer) {
            this.dom.labelTextContainer.style.width = this.labelWidth;
            if (this.labelVisible && this.labelPosition != "top")
                $(this.dom.messageContainer).css({"margin-left": parseInt(this.labelWidth) + 1 + "%"});
        }
        return this;
    };
    /**
     * Sets the callback function to be called when the field's value changes.
     * @param {Function} handler
     * @chainable
     */
    Field.prototype.setOnChangeHandler = function (handler) {
        if (typeof handler === 'function') {
            this.onChange = handler;
        }

        return this;
    };
    /**
     * Sets the helper tooltip visible.
     * @chainable
     */
    Field.prototype.showHelper = function () {
        this.helperIsVisible = true;
        this.helper.setVisible(true);
        return this;
    };
    /**
     * Sets the helper tooltip non visible.
     * @chainable
     */
    Field.prototype.hideHelper = function () {
        this.helperIsVisible = false;
        this.helper.setVisible(false);
        return this;
    };
    /**
     * Returns an array with all the field's controls.
     * @return {Array}
     */
    Field.prototype.getControls = function () {
        return this.controls;
    };
    /**
     * Returns an index based field's control.
     * @param  {Number} index An integer value.
     * @return {PMUI.control.Control}
     */
    Field.prototype.getControl = function (index) {
        index = index || 0;
        return this.controls[index];
    };
    /**
     * Sets the controlPositioning property.
     * @param {String} positioning The string must have the same format that the
     * {@link PMUI.form.Field#cfg-controlPositioning controlPositioning} config option.
     */
    Field.prototype.setControlPositioning = function (positioning) {
        var pos,
            controlPos,
            i,
            j,
            k,
            controls,
            span,
            addControl,
            that = this;

        if (typeof positioning === 'string') {
            this.controlPositioning = positioning;
            if (this.html && this.controls.length) {
                for (i = 0; i < this.controls.length; i += 1) {
                    jQuery(this.controls[i].getHTML()).detach();
                }
                $(this.dom.controlContainer).empty();
                if (positioning !== "") {
                    controls = this.controls.slice();
                    pos = positioning.split(/\[c[\d|\*]\]/);
                    controlPos = positioning.match(/\[c[\d|\*]\]/g);
                    addControl = function (c) {
                        var k;
                        if (c === '[c*]') {
                            for (k = 0; k < controls.length; k += 1) {
                                if (controls[k] !== null) {
                                    that.dom.controlContainer.appendChild(controls[k].getHTML());
                                    controls[k] = null;
                                }
                            }
                        } else {
                            k = c.match(/\d+/);
                            k = parseInt(k[0], 10);
                            if (controls[k] !== null) {
                                that.dom.controlContainer.appendChild(controls[k].getHTML());
                                controls[k] = null;
                            }
                        }
                    };

                    j = 0;
                    for (i = 0; i < pos.length; i += 1) {
                        if (pos[i] === "" && j < controlPos.length) {
                            addControl(controlPos[j]);
                            j++;
                        } else {
                            span = PMUI.createHTMLElement('span');
                            span.textContent = pos[i];
                            this.dom.controlContainer.appendChild(span);
                        }
                        if (j < controlPos.length) {
                            addControl(controlPos[j]);
                            j++;
                        }
                    }
                    this.dom.labelTextContainer.setAttribute('for', this.controls[0].id);
                    this.dom.controlContainer.appendChild(this.helper.getHTML());
                }
            }
        } else {
            throw new Error("The setControlPositioning() method only accepts string values.");
        }

        return this;
    };
    /**
     * Sets the controls for the field.
     *
     * Since this is an abstract method, it must be implemented in its non-abstract subclasses
     * @abstract
     * @private
     */
    Field.prototype.setControls = function () {
    };
    /**
     * Sets the name for the Field
     * @param {String} name
     */
    Field.prototype.setName = function (name) {
        if (typeof name === 'string') {
            this.name = name;
            this.data.setKey(name);
        } else {
            throw new Error('The setName() method only accepts string values!');
        }
        return this;
    };
    /**
     * Returns the field's name
     * @return {String}
     */
    Field.prototype.getName = function () {
        return this.name;
    };
    /**
     * Sets the text for the field's label.
     * @param {String} label
     */
    Field.prototype.setLabel = function (label) {
        if (typeof label === 'string') {
            this.label = label;
        } else {
            throw new Error("The setLabel() method only accepts string values!");
        }
        if (this.dom.fieldTextLabel) {
            this.dom.fieldTextLabel.textContent = this.label;
        }
        if (this.dom.fieldRequired) {
            this.dom.fieldRequired.textContent = '*';
            this.setRequired(this.required);
        }
        if (this.dom.fieldColon) {
            this.dom.fieldColon.textContent = ":";
        }
        return this;
    };
    /**
     * Returns the text from the field's label.
     * @return {String}
     */
    Field.prototype.getLabel = function () {
        return this.label;
    };
    /**
     * Sets the value to the field's controls.
     * @protected
     * @param {String} value
     * @chainable
     */
    Field.prototype.setValueToControls = function (value) {
        var i;

        for (i = 0; i < this.controls.length; i += 1) {
            this.controls[i].setValue(value);
        }
        return this;
    };
    /**
     * Returns the current value from the field's controls without affect the field's value.
     * @return {String}
     * @private
     */
    Field.prototype.getValueFromControls = function () {
        var value = '',
            i;

        for (i = 0; i < this.controls.length; i += 1) {
            value += ' ' + this.controls[i].getValue();
        }

        return value.substr(1);
    };
    /**
     * Update the field's value property from the controls
     * @protected
     * @chainable
     */
    Field.prototype.updateValueFromControls = function () {
        var value = this.getValueFromControls();

        this.value = value;
        this.data.setValue(value);

        return this;
    };
    /**
     * Sets the field's value.
     * @param {String} value
     */
    Field.prototype.setValue = function (value) {
        if (typeof value === 'number') {
            value = value.toString();
        }
        if (typeof value === 'string') {
            this.value = value;
        } else {
            throw new Error("The setValue() method only accepts string values!");
        }
        this.data.setValue(this.value);
        this.setValueToControls(this.value);
        return this;
    };
    /**
     * Returns the field's value.
     * @param [format] Defines the return format
     * @returns {*}
     */
    Field.prototype.getValue = function (format) {
        var castFormat = format || this.valueType;
        return PMUI.castValue(this.value, castFormat);
    };
    /**
     * Sets the helper text.
     * @param {String} helper
     */
    Field.prototype.setHelper = function (helper) {
        this.helper.setMessage(helper);

        return this;
    };
    /**
     * Shows a message below the control.
     * @param  {String} message  The message
     * @param  {String} [category="info"] The message category,
     * It can be one of the accepted values for the
     * {@link PMUI.ui.TooltipMessage#setCategory TooltipMessage's setCategory() method}, it defaults to "info".
     * @chainable
     */
    Field.prototype.showMessage = function () {
        this.message.setVisible(true)
        return this;
    };
    /**
     * Hides the message below the control.
     * @chainable
     */
    Field.prototype.hideMessage = function () {
        this.message.setVisible(false);

        return this;
    };
    /**
     * Sets the value type for the field.
     * @param {String} type
     */
    Field.prototype.setValueType = function (type) {
        var newType;
        if (typeof type === 'string') {
            newType = this.validTypes[type] ? type : 'object';
            this.valueType = newType;
            this.data.setType(newType);
        } else {
            throw new Error("The setValueType() method only accepts string values!");
        }

        return this;
    };
    /**
     * Returns the field's value type.
     * @return {String}
     */
    Field.prototype.getValueType = function () {
        return this.valueType;
    };
    /**
     * The onChange event handler constructor.
     * @private
     * @return {Function} The handler.
     */
    Field.prototype.onChangeHandler = function () {
        var that = this,
            i,
            dependentFields = this.dependentFields,
            form = this.form;

        return function () {
            var previousValue = that.value,
                newValue = that.getValueFromControls();

            if (newValue === previousValue) {
                return this;
            }

            that.value = newValue;
            that.data.setValue(newValue);

            if (that.validAtChange) {
                that.isValid();
            }

            if (typeof that.onChange === 'function') {
                that.onChange(that.getValue(), previousValue);
            }
            if (that.form) {
                (that.form.onChangeHandler())(that, that.value, previousValue);
                //PMUI call a event for dependency [dependencyHandler]
                for (i = 0; i < dependentFields.length; i += 1) {
                    dependentField = form.getField(dependentFields[i]);
                    if (!dependentField) {
                        that.removeDependentField(dependentFields[i]);
                        continue;
                    }
                    dependentField.fireDependencyHandler();
                }
            }
        };
    };

    Field.prototype.fireDependencyHandler = function () {
        var form = this.form,
            dependsOf,
            obj = {},
            i,
            that = this;

        if (form) {
            dependsOf = form.dependencies[that.name];
            for (i = 0; i < dependsOf.length; i += 1) {
                obj[dependsOf[i].name] = dependsOf[i];
            }
            if (typeof this.dependencyHandler === 'function') {
                this.dependencyHandler(that, obj);
            }
        }
        return this;
    };
    /**
     * Attach the event listeners to the HTML element
     * @private
     * @chainable
     */
    Field.prototype.defineEvents = function () {
        var i,
            that = this;

        Field.superclass.prototype.defineEvents.call(this);
        for (i = 0; i < this.controls.length; i += 1) {
            this.controls[i].setOnChangeHandler(this.onChangeHandler())
                .setOnBeforeChangeHandler(this.onBeforeChangeHandler())
                .defineEvents();
        }
        if (this.onClick) {
            this.addEvent('click').listen(this.html, function (e) {
                if (typeof that.onClick === 'function') {
                    that.onClick(that);
                }
            });
            this.addEvent('click').listen(this.dom.labelTextContainer, function (e) {
                e.stopPropagation();
            });
        }
        this.eventsDefined = true;

        return this;
    };
    /**
     * Returns true if the label is visible, otherwise returns false.
     * @return {Boolean}
     */
    Field.prototype.isLabelVisible = function () {
        return this.labelVisible;
    };
    /**
     * Hides the field's label.
     * @chainable
     */
    Field.prototype.hideLabel = function () {
        jQuery(this.dom.labelTextContainer).css('visibility', 'hidden');
        this.labelVisible = false;
        return this;
    };
    /**
     * Shows the field's label.
     * @chainable
     */
    Field.prototype.showLabel = function () {
        jQuery(this.dom.labelTextContainer).css('visibility', '');
        this.labelVisible = true;
        return this;
    };
    /**
     * Evaluates the required validation.
     * @return {Boolean} Returns true if the validation passes otherwise returns false.
     */
    Field.prototype.evalRequired = function () {
        var valid = true;
        if (this.required) {
            if (this.valueType !== 'number') {
                if (this.getValue() === "" || this.getValue() === "[]") {
                    valid = false;
                }
            } else {
                if (this.getValue().toString() === 'NaN') {
                    valid = false;
                }
            }
            if (valid) {
                this.hideMessage();
            } else {
                this.showMessage();
            }
        }
        return valid;
    };
    /**
     * Executes the validations and returns true if all of them passes, otherwise returns false.
     * @return {Boolean}
     */
    Field.prototype.isValid = function () {
        var valid = true, validator;
        valid = valid && this.evalRequired();
        if (!valid) {
            this.controls[0].style.addClasses(['error']);
            return valid;
        }
        this.controls[0].style.removeClasses(['error']);
        for (validator in this.validators) {
            if (this.validators.hasOwnProperty(validator)) {
                valid = valid && this.validators[validator].isValid();
                if (!valid) {
                    this.message.setText(this.validators[validator].errorMessage);
                    return valid;
                }
            }
        }
        return valid;
    };
    /**
     * Create the HTML Element for the Field.
     * @protected
     * @return {HTMLElement}
     */
    Field.prototype.createHTML = function () {
        var html, label,
            labelTextContainer,
            controlContainer,
            messageContainer,
            fieldColon,
            fieldRequired,
            fieldTextLabel;

        if (!this.html) {
            this.style.addClasses(['pmui-field']);
            Field.superclass.prototype.createHTML.call(this);


            labelTextContainer = PMUI.createHTMLElement("label");

            // contenedor de todos los labels
            labelTextContainer.className = 'pmui-field-label';

            //labelText
            fieldTextLabel = PMUI.createHTMLElement('span');
            fieldTextLabel.className = "pmui-field-textLabel";
            //asterisk for required
            fieldRequired = PMUI.createHTMLElement ('span');
            fieldRequired.className = "pmui-field-required";
            //colon
            fieldColon = PMUI.createHTMLElement('span');
            fieldColon.className = "pmui-field-colon";


            controlContainer = PMUI.createHTMLElement("span");
            controlContainer.className = 'pmui-field-control';
            messageContainer = PMUI.createHTMLElement("span");
            messageContainer.className = 'pmui-field-message';
            messageContainer.style.display = "block"


            //labelTextContainer append tree childs label, * and :
            labelTextContainer.appendChild(fieldTextLabel);
            labelTextContainer.appendChild(fieldRequired);
            labelTextContainer.appendChild(fieldColon);

            //messageContainer append the helper
            messageContainer.appendChild(this.message.getHTML());

            //this html append label, control and helper tag
            this.html.appendChild(labelTextContainer);
            this.html.appendChild(controlContainer);
            this.html.appendChild(messageContainer);

            this.dom.labelTextContainer = labelTextContainer;
            this.dom.fieldTextLabel = fieldTextLabel;
            this.dom.fieldColon = fieldColon;
            this.dom.fieldRequired = fieldRequired;
            this.dom.controlContainer = controlContainer;
            this.dom.messageContainer = messageContainer;

            this.setControlPositioning(this.controlPositioning);
            this.setLabelWidth(this.labelWidth);
            this.setLabel(this.label);
            this.setValue(this.value);
            this.setLabelPosition(this.labelPosition);
            if (this.labelVisible) {
                this.showLabel();
            } else {
                this.hideLabel();
            }
            if (this.visibleColon) {
                this.showColon();
            } else {
                this.hideColon();
            }
        }

        return this.html;
    };
    /**
     * Set the width for the field.
     * @param {Number|String} width height it can be a number or a string.
     * In case of using a String you only can use 'auto' or ##px or ##% or ##em when ## is a number.
     * @chainable
     */
    Field.prototype.setWidth = function (width) {
        Field.superclass.prototype.setWidth.call(this, width);
        if (this.labelWidth) {
            this.setLabelWidth(this.labelWidth);
        }
        return this;
    };
    /**
     * @method setFocus
     * set the focus on field for to control
     * @param {Number} [index] if the field has more than one control and needs to focus on a specific Control
     * @chainable
     */
    Field.prototype.setFocus = function (index) {
        var i = index || 0,
            j,
            controls = this.getControls();

        if (this.controls[i] && this.controls[i].setFocus) {
            this.controls[i].setFocus();
        }
        return this;
    };

    PMUI.extendNamespace('PMUI.form.Field', Field);

    if (typeof exports !== "undefined") {
        module.exports = Field;
    }
}());

(function () {
    /**
     * @class PMUI.field.TextField
     * @extends PMUI.form.Field
     * Class to handle a {@link PMUI.control.TextControl} field.
     *
     * Usage example:
     *
     *      @example
     *          var a;
     *          $(function() {
     *              a = new PMUI.field.TextField({
     *                  label: "Some Text",
     *                  placeholder: 'a text here',
     *                  required: true,
     *                  helper: "Introduce a text (6 chars. max.)",
     *                  validators: [
     *                      {
     *                          pmType: 'textLength',
     *                          criteria: {
     *                              maxLength: 6
     *                          }
     *                      }
     *                  ]
     *              });
     *              document.body.appendChild(a.getHTML());
     *              a.defineEvents();
     *          });
     *
     *
     * The code above will generate a required TextField with "Some Text" as label,
     * the control will have a placeholder with the text "a text here".
     * Also the field will contain a helper with the text "Introduce a text (6 chars. max.)"
     * and a validator that will control the maximum length for the text to be entered.
     *
     * @cfg {String} [placeholder=""] The text to show as placeholder for the field's control
     * @cfg {Number} [maxLength=0] An integer that specifies the maximum character length for the text to be entered.
     * 0 means no max length.
     *
     * #Note: This setting doesn't act as a validator, it simply set the max character length
     * for the field's control.
     * @cfg {Boolean} [trimOnBlur=true] A boolean that specifies if the value entered will be trimmed
     * when the field loses focus.
     */
    var TextField = function (settings) {
        TextField.superclass.call(this, settings);
        /**
         * @property {Boolean} [trimOnBlur=true] If the field's value must be trimmed every time it loses focus.
         */
        this.trimOnBlur = null;
        TextField.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.form.Field', TextField);

    TextField.prototype.type = "TextField";

    TextField.prototype.init = function (settings) {
        var defaults = {
            placeholder: "",
            maxLength: 0,
            trimOnBlur: true,
            readOnly: false
        };

        $.extend(true, defaults, settings);

        this.setPlaceholder(defaults.placeholder)
            .setMaxLength(defaults.maxLength)
            .setTrimOnBlur(defaults.trimOnBlur)
            .setReadOnly(defaults.readOnly)
            .setDependentFields(this.dependentFields);
    };
    /**
     * Sets the value for the field.
     * @param {String} value
     * @chainable
     */
    TextField.prototype.setValue = function (value) {
        if (this.trimOnBlur) {
            value = jQuery.trim(value);
        }
        TextField.superclass.prototype.setValue.call(this, value);

        return this;
    };
    /**
     * Sets the placeholder for the control. Note that this feature is only supported
     * by browsers which support the "placeholder" for input elements.
     * @param {String} placeholder
     * @chainable
     */
    TextField.prototype.setReadOnly = function (readonly) {
        this.controls[0].setReadOnly(readonly);
        return this;
    };
    /**
     * [setPlaceholder description]
     * @param {[type]} placeholder [description]
     */
    TextField.prototype.setPlaceholder = function (placeholder) {
        this.controls[0].setPlaceholder(placeholder);
        return this;
    };
    /**
     * [getPlaceholder description]
     * @return {[type]} [description]
     */
    TextField.prototype.getPlaceholder = function () {
        return this.controls[0].getPlaceholder();
    };
    /**
     * [setMaxLength description]
     * @param {[type]} maxLength [description]
     */
    TextField.prototype.setMaxLength = function (maxLength) {
        this.controls[0].setMaxLength(maxLength);
        return this;
    };
    /**
     * Set the parameter disabled for the control.
     * @param {[disabled]} value 
     * @chainable
     */
     TextField.prototype.setDisabled = function (value) {
        if (typeof value === 'boolean') {
            this.controls[0].setDisabled(value);
        }
        return this;
    };
    /**
     * [getMaxLength description]
     * @return {[type]} [description]
     */
    TextField.prototype.getMaxLength = function () {
        return this.controls[0].getMaxLength();
    };
    /**
     * [isReadOnly description]
     * @return {Boolean} [description]
     */
    TextField.prototype.isReadOnly = function () {
        return this.controls[0].isReadOnly();
    };
    /**
     * Switches on/off the value trimming for the field's value when it loses focus.
     * @param {Boolean} trimOnBlur Send true for switch on or false to switch off.
     * @chainable
     */
    TextField.prototype.setTrimOnBlur = function (trimOnBlur) {
        this.trimOnBlur = !!trimOnBlur;
        return this;
    };
    /**
     * Returns a boolean value that indicates if the trimming function is enabled/disabled
     * @return {Boolean}
     */
    TextField.prototype.getTrimOnBlur = function () {
        return this.trimOnBlur;
    };
    /**
     * Sets the control for the TextField
     * @chainable
     * @private
     */
    TextField.prototype.setControls = function () {
        if (this.controls.length) {
            return this;
        }

        this.controls.push(new PMUI.control.TextControl());

        return this;
    };
    /**
     * Establish the handler function for the internal onChange event
     * @return {Function}
     * @private
     */
    TextField.prototype.onChangeHandler = function () {
        var that = this,
            i,
            dependentFields = this.dependentFields,
            form = this.form;

        return function () {
            var previousValue = that.value,
                value;

            if (that.trimOnBlur) {
                value = that.controls[0].getValue();
                value = jQuery.trim(value);
                that.controls[0].setValue(value);
            }
            that.updateValueFromControls();
            if (that.validAtChange) {
                that.isValid();
            }
            if (typeof that.onChange === 'function') {
                that.onChange(that.getValue(), previousValue);
            }
            if (that.form) {
                (that.form.onChangeHandler())(that, that.getValue(), previousValue);
            } else if (that.parent && that.parent.form) {
                (that.parent.form.onChangeHandler())(that, that.getValue(), previousValue);
            } else if (that.parent.parent && that.parent.parent.form) {
                (that.parent.parent.form.onChangeHandler())(that, that.getValue(), previousValue);
            } else if (that.parent.parent.parent && that.parent.parent.parent.form) {
                (that.parent.parent.parent.form.onChangeHandler())(that, that.getValue(), previousValue);
            } else {
                return;
            }
            if (that.form) {
                for (i = 0; i < dependentFields.length; i += 1) {
                    dependentField = form.getField(dependentFields[i]);
                    if (!dependentField) {
                        that.removeDependentField(dependentFields[i]);
                        continue;
                    }
                    dependentField.fireDependencyHandler();
                }
            }
        };
    };

    PMUI.extendNamespace('PMUI.field.TextField', TextField);

    if (typeof exports !== "undefined") {
        module.exports = TextField;
    }
}());
(function () {
    /**
     * @class PMUI.field.PasswordField
     * @extends PMUI.form.Field
     * Class to handle a {@link PMUI.control.PasswordControl} field.
     *
     * Usage example:
     *
     *      @example
     *          var a;
     *          $(function() {
     *              a = new PMUI.field.PasswordField({
     *                  label: "Some Text",
     *                  required: true,
     *                  helper: "Introduce a text (6 chars. max.)",
     *                  validators: [
     *                      {
     *                          pmType: 'textLength',
     *                          criteria: {
     *                              maxLength: 6
     *                          }
     *                      }
     *                  ]
     *              });
     *              document.body.appendChild(a.getHTML());
     *              a.defineEvents();
     *          });
     *
     *
     * The code above will generate a required PasswordField with "Some Text" as label,
     * the control will have a placeholder with the text "a text here".
     * Also the field will contain a helper with the text "Introduce a text (6 chars. max.)"
     * and a validator that will control the maximum length for the text to be entered.
     *
     * @cfg {Number} [maxLength=0] An integer that specifies the maximum character length for the text to be entered.
     * 0 means no max length.
     *
     * #Note: This setting doesn't act as a validator, it simply set the max character length
     * for the field's control.
     * @cfg {Boolean} [trimOnBlur=true] A boolean that specifies if the value entered will be trimmed
     * when the field loses focus.
     */
    var PasswordField = function (settings) {
        PasswordField.superclass.call(this, settings);
        /**
         * @property {Boolean} [trimOnBlur=true] If the field's value must be trimmed every time it loses focus.
         */
        this.trimOnBlur = null;
        PasswordField.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.form.Field', PasswordField);

    PasswordField.prototype.type = "PasswordField";

    PasswordField.prototype.init = function (settings) {
        var defaults = {
            maxLength: 0,
            trimOnBlur: true
        };

        $.extend(true, defaults, settings);

        this.setMaxLength(defaults.maxLength)
            .setTrimOnBlur(defaults.trimOnBlur);
    };
    /**
     * Sets the value for the field.
     * @param {String} value
     * @chainable
     */
    PasswordField.prototype.setValue = function (value) {
        if (this.trimOnBlur) {
            value = jQuery.trim(value);
        }
        PasswordField.superclass.prototype.setValue.call(this, value);

        return this;
    };

    /**
     * Set MaxLength
     * @param maxLength
     * @returns {PMUI.field.PasswordField}
     */
    PasswordField.prototype.setMaxLength = function (maxLength) {
        this.controls[0].setMaxLength(maxLength);
        return this;
    };

    /**
     * Get Max Length
     * @returns {*}
     */
    PasswordField.prototype.getMaxLength = function () {
        return this.controls[0].getMaxLength();
    };

    /**
     * Switches on/off the value trimming for the field's value when it loses focus.
     * @param {Boolean} trimOnBlur Send true for switch on or false to switch off.
     * @chainable
     */
    PasswordField.prototype.setTrimOnBlur = function (trimOnBlur) {
        this.trimOnBlur = !!trimOnBlur;
        return this;
    };
    /**
     * Returns a boolean value that indicates if the trimming function is enabled/disabled
     * @return {Boolean}
     */
    PasswordField.prototype.getTrimOnBlur = function () {
        return this.trimOnBlur;
    };
    /**
     * Sets the control for the PasswordField
     * @chainable
     * @private
     */
    PasswordField.prototype.setControls = function () {
        if (this.controls.length) {
            return this;
        }

        this.controls.push(new PMUI.control.PasswordControl());

        return this;
    };
    /**
     * Establish the handler function for the internal onChange event
     * @return {Function}
     * @private
     */
    PasswordField.prototype.onChangeHandler = function () {
        var that = this;

        return function () {
            var previousValue = that.value,
                value;

            if (that.trimOnBlur) {
                value = that.controls[0].getValue();
                value = jQuery.trim(value);
                that.controls[0].setValue(value);
            }
            that.updateValueFromControls();
            if (that.validAtChange) {
                that.isValid();
            }
            if (typeof that.onChange === 'function') {
                that.onChange(that.getValue(), previousValue);
            }
            if (that.form) {
                (that.form.onChangeHandler())(that, that.getValue(), previousValue);
            }
        };
    };

    PMUI.extendNamespace('PMUI.field.PasswordField', PasswordField);

    if (typeof exports !== "undefined") {
        module.exports = PasswordField;
    }
}());
(function () {
    /**
     * @class PMUI.field.TextAreaField
     * @extends PMUI.field.TextField
     * Class to handle a {@link PMUI.control.TextAreaControl}.
     *
     * Usage example:
     *
     *      @example
     *           var a;
     *           $(function() {
     *                a = new PMUI.field.TextAreaField({
     *                     id:'12345',
     *                     label: "coment",
     *                     cols: 300,   
     *                     rows: 200,
     *                     name: 'coments',
     *                     placeholder: 'make your comment here...........',
     *                     required: true,
     *                     labelposition:'left',
     *                     labelVerticalPosition:'top',
     *                     tooltipPosition:'bottom',
     *                     helper: "Introduce a text (200 chars. max.)",
     *                     validators: [
     *                         {
     *                             pmType: 'textLength',
     *                             criteria: {
     *                                 maxLength: 200
     *                             }
     *                         }
     *                     ]
     *                 });
     *                 document.body.appendChild(a.getHTML());
     *             });
     *
     *
     * TextAreaField, is a field for very long text strings
     * to generate the above code on TextAreaField requires, one id, label, name, placeholder, required,
     labelposition,
     * labelVerticalPosition, tooltipPosition, helper.
     *
     * In case to modified label position or tooltip position it can contain the next properties:
     * @cfg {'string'} [labelVerticalPosition='top'] in case that the position of the label left or right we
     fixed this
     * property in three cases ('top', 'center', 'bottom')
     * @cfg {'string'} [tooltipPosition='top'] this property can set the tooltip in two cases ('top' or 'bottom')
     for TextAreaField
     */

    var TextAreaField = function (settings) {

        TextAreaField.superclass.call(this, settings);
        /**
         * @property {string} [labelVerticalPosition='top'], in case that the position of the label left
         or right we fixed this
         * property in three cases ('top', 'center', 'bottom')
         * @readonly
         */
        this.labelVerticalPosition = null;
        /**
         * @property {string} [tooltipPosition='top'] this property can set the tooltip in two cases ('top' or
         'bottom').
         * @readonly
         */
        this.tooltipPosition = null;
        this.cols = null;
        this.rows = null;

        TextAreaField.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.field.TextField', TextAreaField);

    TextAreaField.prototype.type = "TextAreaField";

    TextAreaField.prototype.init = function (settings) {
        var defaults = {
            labelVerticalPosition: 'top',
            tooltipPosition: 'top',
            cols: 'auto',
            rows: 'auto'
        };

        jQuery.extend(true, defaults, settings);

        this.setLabelVerticalPosition(defaults.labelVerticalPosition);
        this.setTooltipPosition(defaults.tooltipPosition);
        this.setRows(defaults.rows);
        this.setCols(defaults.cols);

    };

    /**
     * Sets the labelVerticalPosition for the Label of the TextAreaField.
     * input values ​​(top, center and bottom) only affect the field if the label of TextAreaField is in
     * left or right position.
     * @param {String} labelVerticalPosition
     * @chainable
     */

    TextAreaField.prototype.setLabelVerticalPosition = function (value) {
        var x,
            result;

        if (value === 'top' || value === 'bottom' || value === 'center') {
            this.labelVerticalPosition = value;

            if (this.controls[0] && this.html) {
                this.dom.labelTextContainer.style.position = 'relative';
                if (this.labelPosition === 'left' || this.labelPosition === 'right') {
                    if (this.labelVerticalPosition === 'top') {
                        this.dom.labelTextContainer.style.top = '0px';
                        this.dom.labelTextContainer.style.verticalAlign = 'top';
                    }
                    if (this.labelVerticalPosition === 'bottom') {
                        this.dom.labelTextContainer.style.top = '0px';

                        this.dom.labelTextContainer.style.verticalAlign = 'bottom';
                    }
                    if (this.labelVerticalPosition === 'center') {

                        this.dom.labelTextContainer.style.verticalAlign = 'top';
                        result = ($(this.controls[0].getHTML()).outerHeight() / 2) -
                            ($(this.dom.labelTextContainer).outerHeight() / 2);

                        this.dom.labelTextContainer.style.top = (result) + 'px';

                    }
                }
            }
        }
        else {
            throw new Error("The value is not 'top' or 'bottom' please enter these values");
        }

        return this;
    };
    /**
     * Sets the label position
     * input values(top, bottom, left, right)
     * @param {String} labelPosition
     * @chainable
     */
    TextAreaField.prototype.setLabelPosition = function (position) {
        if (this.html && (position === 'top' || position === 'bottom')) {
            this.dom.labelTextContainer.style.top = '0px';
        }
        TextAreaField.superclass.prototype.setLabelPosition.call(this, position);

        return this;
    };
    /**
     * Sets the tooltipPosition for the Label of the TextAreaField.
     * input values ​​(top and bottom) only affect the field if the label of TextAreaField
     * @param {String} tooltipPosition
     * @chainable
     */
    TextAreaField.prototype.setTooltipPosition = function (value) {

        if (value === 'top' || value === 'bottom') {
            this.tooltipPosition = value;

            if (this.controls[0] && this.html) {


                if (this.tooltipPosition === 'top') {
                    this.helper.icon.style.addProperties({'vertical-align': 'top'});
                }
                if (this.tooltipPosition === 'bottom') {

                    this.helper.icon.style.addProperties({'vertical-align': 'bottom'});
                }
            }
        }
        else {
            throw new Error("The value is not 'top' or 'bottom' please enter these values");
        }

        return this;
    };
    /**
     * Sets the  setHeight for the {PMUI.controls.TextAreaControl}.
     * @param {String|number} [PMUI.controls.TextAreaControl]
     * @chainable
     */
    TextAreaField.prototype.setControlHeight = function (height) {
        this.controls[0].setHeight(height);
        return this;
    };
    /**
     * Sets the  setWidth for the {PMUI.controls.TextAreaControl}.
     * @param {String|number} [PMUI.controls.TextAreaControl]
     * @chainable
     */
    TextAreaField.prototype.setControlWidth = function (width) {
        this.controls[0].setWidth(width);
        return this;
    };

    /**
     * Sets the text for the TextAreaField label.
     * @param {String} label
     */

    TextAreaField.prototype.setLabel = function (label) {
        if (typeof label === 'string') {
            this.label = label;
        } else {
            throw new Error("The setLabel() method only accepts string values!");
        }
        if (this.dom.fieldTextLabel) {
            this.dom.fieldTextLabel.textContent = this.label;
        }
        if (this.dom.fieldRequired) {
            this.dom.fieldRequired.textContent = '*';
            this.setRequired(this.required);
        }
        if (this.dom.fieldColon) {
            this.dom.fieldColon.textContent = ":";
        }
        return this;
    };
    /**
     * Sets the control for the TextField
     * @chainable
     * @private
     */
    TextAreaField.prototype.setControls = function () {
        if (this.controls.length) {
            return this;
        }

        this.controls.push(new PMUI.control.TextAreaControl());

        return this;
    };

    /**
     * Disables the field
     * @param {Boolean} Disable, if the field, then control is activated, if the control is enabled
     * @chainable
     */
    TextAreaField.prototype.disableField = function () {
        this.controls[0].disable(true);
        return this;
    };
    /**
     * Disables/enables the control
     * @param {Boolean} Enable, if the field, then control is activated, if the control is diabled
     * @chainable
     */
    TextAreaField.prototype.enableField = function () {
        this.controls[0].disable(false);
        return this;
    };
    /**
     * Creates the HTML element for the textAreaField
     * @return {HTMLElement}
     */
    TextAreaField.prototype.createHTML = function () {
        TextAreaField.superclass.prototype.createHTML.call(this);
        this.setLabelVerticalPosition(this.labelVerticalPosition);
        this.setTooltipPosition(this.tooltipPosition);
        return this.html;
    };
    /**
     * assign hight as rows to textArea,
     * @param {number|String} rows will be assigned as high in PX, the entered values ​​can
     * be numbers, 'number + px', 'auto' or percentage
     * @chainable
     */
    TextAreaField.prototype.setRows = function (rows) {
        this.controls[0].setHeight(rows);
        return this;
    };
    /**
     * assign width as Cols to textArea,
     * @param {number|String} Cols will be assigned as high in PX, the entered values ​​can
     * be numbers, 'number + px', 'auto' or percentage
     * @chainable
     */
    TextAreaField.prototype.setCols = function (cols) {
        this.controls[0].setWidth(cols);
        return this;
    };

    PMUI.extendNamespace('PMUI.field.TextAreaField', TextAreaField);

    if (typeof exports !== "undefined") {
        module.exports = TextAreaField;
    }
}());
(function () {
    /**
     * @class PMUI.field.DropDownListField
     * @extends PMUI.form.Field
     * Class to handle a {@link PMUI.control.DropDownListControl} field.
     *
     * Usage example:
     *
     *      @example
     *              var settings, list;
     *              $(function(){
     *                  settings = {
     *                   id : '123',
     *                  label : "Pais",
     *                  name : 'List Select',
     *                  required: true,
     *                  helper: "selected one opcion of the list",
     *                  options: [                                
     *                  {
     *                   label: "BOLIVIA",
     *                        options: [
     *                        {
     *                              label: "La Paz",
     *                              value: 1,
     *                              disabled : true
     *                          },
     *                          {
     *                              label: "Cochabamba",
     *                              value: 2
     *                          },
     *                          {
     *                              label: "SantaCruz",
     *                              value: 3
     *                          },
     *                      ]
     *                   },
     *                   {
     *                        label: "ARGENTINA",
     *                      options: [
     *                          {
     *                              label: "Buenos Aires",
     *                              value: 4
     *                          },
     *                          {
     *                              label: "Santa Fe",
     *                              value: 5
     *                          },
     *                          {
     *                                  value: "Cordoba"
     *                          }
     *                      ]
     *                   },
     *                   {
     *                        label: "CHILE",
     *                      options: [
     *                          {
     *                              label: "Arica",
     *                              value: 6
     *                          },
     *                          {
     *                              label: "Santiago",
     *                              value: 7
     *                          },
     *                          {
     *                                  value: "Concepcion"
     *                          }
     *                      ]
     *                   },
     *                   {
     *                        label: "New York",
     *                        value: 8
     *                   },
     *                   {
     *                        label: "Mexico D.F.",
     *                        value: 9
     *                   }
     *               ]
     *           }
     *           list = new PMUI.field.DropDownListField(settings);
     *           document.body.appendChild(list.getHTML());
     *         });
     *
     *
     * DropDownListField typo is a selection field, enclose the values â€‹â€‹that we can choose from a list
     * of options. The attributes that accompany the opening tag are:
     * The code above will generate a DropDownListField, required one id, name, requiere,
     * helper, text  for list the options, one opcion array  with the list options
     *
     * @constructor Creates an instance of the class DropDownListField.
     * @param {Object} options Initialization options.
     * @cfg {Array} [options=[]] An array with all the options to be contained by the
     {PMUI.control.DropDownListControl}.
     *
     * Each element in the array is a JSON object, this JSON object can represent an option group
     * or an option item.
     *
     * In case to represent an option item it can contain the next properties:
     *
     * - value {String} (required): the value for the option.
     * - label {String} (optional): the label for the option, if isn't specified the value is used instead.
     * - selected {Boolean} (optional): if the option is selected. #Note. If the configuration object has the
     * "value" propery set then this "selected" property will be
     * - disabled {Boolean} (optional): if the option is disabled or not.
     *
     * On the other hand, in case to represent an option group, it can contain the next properties:
     *
     * - label {String} (required): The name for the option group.
     * - disabled {Boolean} (optional): If the group is disabled or not.
     * - options {Array} (required): An array in which each element is a JSON object representing an option item,
     * so every item must have the structure explained above (for represent option items). #Note. This propery makes
     * the difference between an option and a option group. If the "options" property is not specified or if it isn't
     * an array then it will treated like a option item.
     * @cfg {String|Number} [listWidth='auto'] This value sets the width of the list
     */


    var DropDownListField = function (settings) {

        DropDownListField.superclass.call(this, settings);

        /**
         * @property {Boolean} [disabled=false] If the field is disabled or not.
         * @readonly
         */

        this.listWidth = null;
        //this.defaultValue = null;

        DropDownListField.prototype.init.call(this, settings);

    };

    PMUI.inheritFrom("PMUI.form.Field", DropDownListField);

    DropDownListField.prototype.type = "DropDownListField";

    DropDownListField.prototype.init = function (settings) {
        var defaults = {
            options: [],
            listWidth: 'auto',
            value: null
        };

        jQuery.extend(true, defaults, settings);

        this.setOptions(defaults.options);
        this.setListWidth(defaults.listWidth);
        this.updateValueFromControls();

        if (defaults.value !== null) {
            this.setValue(defaults.value);
        }
    };
    /**
     * Sets the options/option groups for the control.
     * @param {Array} options An array with the same structure that the
     * {@link PMUI.field.DropDownListField#cfg-options "options"} property in the
     * Config settings section.
     */
    DropDownListField.prototype.setOptions = function (options) {
        var i;
        if (jQuery.isArray(options)) {
            this.controls[0].setOptions(options);
        }
        if (!this.value && options) {
            for (i = 0; i < options.length; i += 1) {
                if (options[i].selected) {
                    this.initialValue = options[i].value || options[i].label || "";
                    break;
                }
            }
        }
        this.value = this.controls[0].getValue();
        return this;
    };
    /**
     * Returns the options/option groups from the field
     * @param  {Boolean} [includeGroups=false] If it's evaluated as true then it will include
     * the option groups with its child elements, otherwise it will return only the option items.
     * @return {Array}
     *
     *         example
     *
     *          list.getOptions(false)
     *         [La Paz][Cochabamba][Santa Cruz][Buenos Aires][Santa Fe][Cordoba][Santiago][.][.][Mexico D.F]
     *
     *        list.getOptions(true)
     *          [BOLIVIA
     *              [La Paz][Cochabamba][SantaCruz]
     *          ]
     *          [ARGENTINA
     *              [Buenos Aires][Santa Fe][Cordoba]
     *           ]
     *          [CHILE
     *             [x][y][z]
     *          ]
     *          [New York]
     *          [Mexico D.F.]
     *
     * @return {Array}
     */
    DropDownListField.prototype.getOptions = function (includeGroups) {
        return this.controls[0].getOptions(includeGroups);
    };
    /**
     * Clear all the options from the control.
     * @chainable
     */
    DropDownListField.prototype.clearOptions = function () {
        this.controls[0].clearOptions();
        this.value = this.controls[0].value;
        return this;
    };

    /**
     * Disables one or more options/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be disabled the options that match the string in its value and the option
     * groups which match the string in its label. In this case more than one single item can be disabled.
     * - In case to be a Number, it will be disabled the option/option group which index position matches the number.
     * Obviously, in this case only one item will be disabled.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items
     needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group
     label.
     * Using this parameter, the elements to be match by the first parameter will be search only in the option groups
     * that match this parameter in its label.
     *
     *         example
     *              list =    [a
     *                             [a0]
     *                             [a1]
     *                        ]
     *                        [b
     *                             [b0]
     *                             [b1]
     *                        ]
     *                        [c]
     *   //disabling sending a number
     *              list.disableOption(0); -->disabled group a
     *              list.disableOption(4); -->disabled option b[b0]
     *
     *    //disabling sending a string
     *             list.disableOption('a') --> disabled group a
     *             list.disableOption('b0') --> disabled option b[b0]

     *   //disabling sending a objects
     list.disableOption({criteria:'a', applyTo:'groups'}) --> disabled group a
     *
     * @chainable
     */

    DropDownListField.prototype.disableOption = function (option, group) {
        this.controls[0].disableOption(option, group);
        return this;
    };

    /**
     * Enables one or more options/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be enabled the options that match the string in its value and the option
     * groups which match the string in its label. In this case more than one single item can be enabled.
     * - In case to be a Number, it will be enabled the option/option group which index position matches the number.
     * Obviously, in this case only one item will be enabled.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group
     label.
     * Using this parameter, the elements to be match by the first parameter will be search only in the option groups
     * that match this parameter in its label.
     * @chainable
     */

    DropDownListField.prototype.enableOption = function (option, group) {
        this.controls[0].enableOption(option, group);
        return this;
    };

    /**
     * Removes one or more option/option groups.
     * @param  {String|Number|Object} option It can be a string, a number or a JSON object.
     *
     * - In case to be a String, it will be removed the options that match the string in its value and the option
     * groups which match the string in its label. In this case more than one single item can be removed.
     * - In case to be a Number, it will be removed the option/option group which index position matches the number.
     * Obviously, in this case only one item will be removed.
     * - In case to be an object you can specify if the change will be applied only to options or option groups,
     * it should have two properties:
     *     - criteria {String}: The value (in case of options) or the label (in case of option groups) the items
     needs
     *     to match for apply the changes.
     *     - applyTo {String} (optional), it can take the following values:
     *         - "groups", the change will be applied only to the option groups.
     *         - "options", the change will be applied only to the options (direct child of the object).
     *         - [any other string value], the default value, it indicates that the change will be applied to both
     *         options/option groups that matches the criteria in its value/label respectly.
     *
     * @param  {String} [group] It it is specified must be an String making reference to an existing option group
     label.
     * Using this parameter, the elements to be match by the first parameter will be search only in the option groups
     * that match this parameter in its label.
     *
     * ##Note. Removing an option group implies removing all its child options.
     * @chainable
     */
    DropDownListField.prototype.removeOption = function (option, group) {
        this.controls[0].removeOption(option, group);
        return this;
    };
    /**
     * Adds a new option group to the Field
     * @param {Object} optionGroup A JSON object with the following properties:
     *
     * - label {String} (required): the label for the option group.
     * - disabled {Boolean}(optional): if the option group will be disabled or not.
     * it defaults to false.
     * - options {Array} (optional): An array of JSON object, each one represents an option and
     * should have the same structure than the "option" paremeter for the
     * {@link PMUI.field.DropDownListField#addOption addOption() method}.
     */
    DropDownListField.prototype.addOptionGroup = function (optionGroup) {
        this.controls[0].addOptionGroup(optionGroup);
        return this;
    };

    /**
     * Adds a new option to the list of the DropDownListField or to an option group.
     * @param {Object} option An object with ther settings for the new option.
     * this object can have the following properties:
     *
     * - value {String} (required): the value for the option.
     * - label {String} (optional): the label for the option, if isn't specified the value is used instead.
     * - selected {Boolean} (optional): if the option is selected. #Note. If the configuration object has the
     * "value" propery set then this "selected" property will be
     * - disabled {Boolean} (optional): if the option is disabled or not.
     *
     * @param {String} group The name of the option group in which the new option will be added. If it doesn't exist
     * it will be created.
     *
     *         usage
     *         // add option a groupÃ§
     *
     *         list.addOption({value:'5', label:'Pando', selected: true, disabled:true },'BOLIVIA')
     *
     *         //or add option
     *
     *         list.addOption({value:'paris', label:'Paris'})
     *
     * @chainable
     */
    DropDownListField.prototype.addOption = function (option, group) {
        this.controls[0].addOption(option, group);
        if (this.getOptions().length == 1) {
            this.value = this.controls[0].value;
        }
        return this;
    };

    /**
     * Returns the label from the option currently selected.
     * @return {String}
     */
    DropDownListField.prototype.getSelectedLabel = function () {
        return this.controls[0].getSelectedLabel();
    };
    /**
     * Sets the control for the DropDownListField
     * @chainable
     * @private
     */
    DropDownListField.prototype.setControls = function () {
        if (this.controls.length) {
            return this;
        }
        this.controls.push(new PMUI.control.DropDownListControl());

        return this;
    };
    /**
     * Set the width for the HTML DropDownListControl(select)
     * @param {Number|String} width height it can be a number or a string.
     In case of using a String you only can use 'auto' or 'inherit' or ##px or ##% or ##em when ## is a number
     * @chainable
     */

    DropDownListField.prototype.setListWidth = function (width) {
        this.listWidth = width;
        this.controls[0].setWidth(this.listWidth);
        return this;
    };


    DropDownListField.prototype.getListWidth = function (width) {
        return this.listWidth;
    };

    DropDownListField.prototype.setValue = function (value) {
        var val;
        if (this.controls[0]) {
            val = this.controls[0].setValue(value).getValue();
        }
        DropDownListField.superclass.prototype.setValue.call(this, val || value);
        return this;
    };

    PMUI.extendNamespace('PMUI.field.DropDownListField', DropDownListField);

    if (typeof exports !== "undefined") {
        module.exports = DropDownListField;
    }
}());
(function () {
    /**
     * @class  PMUI.field.CheckBoxGroupField
     * Field where the values ​​can be selected from a group of options.
     * @extends PMUI.form.Field
     *
     *  Usage example:
     *
     *      @example
     *             var a;
     *             $(function() {
     *                 a = new PMUI.field.CheckBoxGroupField({
     *                     label: "development tools",
     *                     controlPositioning: 'vertical',
     *                     maxDirectionOptions: 2,
     *                     required: true,
     *                     value: '1',
     *                     helper: "what lanaguages you know?. Select others besides javascript",
     *                     options : [
     *                         {  label: 'Java',
     *                            disabled: false,
     *                            value: 'java',
     *                            selected :true
     *                         },
     *                         { label: 'JavaScript',
     *                            disabled: true,
     *                            value: 'javaScript',
     *                            selected :true
     *                         },
     *                         { label: 'Python',
     *                            disabled: false,
     *                            value: 'python'
     *                         },
     *                          {  label: 'C#',
     *                            disabled: true,
     *                            value: 'visualbasic'
     *                         }
     *                     ],
     *                      onChange: function(newVal, oldVal) {
     *                         console.log("The value for the field  \"" + this.getLabel() + 
     *                         "\": has change from \"" + oldVal + "\" to \"" + newVal + "\"");
     *                     },
     *                 });
     *                 document.body.appendChild(a.getHTML());
     *             });
     *
     *
     * The example above will generate a field with 4 CheckBox options.
     *
     * @constructor Creates an instance of the class CheckBoxGroupField.
     * @param {Object} options Initialization options.
     * @cfg {Array} [options=[]] An array in which every element is a JSON object with the same
     structure required in the
     * {@link PMUI.field.CheckBoxGroupField#addOption addOption() method}.
     * @cfg {String} [controlPositioning="vertical"] A string that determines the direction for the options to be added
     * in the field. This string can have one of the following values:
     *
     * - "horizontal" (default), in this case all the options will be included  in horizontal order.
     * - "vertical", in this case all the options will be included in vertical order.
     * @cfg {Number} [maxDirectionOptions=1] The maximum number of options to be added in the current direction
     * (set by the {@link PMUI.control.CheckBoxGroupField#cfg-controlPositioning controlPositioning config option}).
     *
     * @cfg {String} [value='[]'] The value that determines which options will be checked. the String must have an
     * array format in which each element is the value of the options that are wanted to be checked.
     */
    var CheckBoxGroupField = function (settings) {
        CheckBoxGroupField.superclass.call(this, settings);
        /**
         * @property {String} controlPositioning The direction for the options to be added in the field.
         * @readonly
         */
        this.controlPositioning = null;
        /**
         * @property {Number} maxDirectionOptions The max number of options that can be in the current options
         * direction.
         * @readonly
         */
        this.maxDirectionOptions = null;
        /**
         * The status if the controls to be saved when the field is switch between enabled/disabled.
         * @type {Object}
         * @private
         */
        this.auxControlStates = {};

        this.controlTable = {};
        CheckBoxGroupField.prototype.init.call(this, settings);
    };

    PMUI.inheritFrom('PMUI.form.Field', CheckBoxGroupField);

    CheckBoxGroupField.prototype.type = "CheckBoxGroupField";

    CheckBoxGroupField.prototype.init = function (settings) {
        var defaults = {
            options: [],
            controlPositioning: "vertical",
            maxDirectionOptions: 1,
            value: '[]'
        };

        jQuery.extend(true, defaults, settings);
        this.setOptions(defaults.options)
            .setMaxDirectionOptions(defaults.maxDirectionOptions)
            .setControlPositioning(defaults.controlPositioning);
    };
    /**
     * Enables the field. Notice that the controls that initially were disabled will continue being disabled.
     * @chainable
     */
    CheckBoxGroupField.prototype.enable = function () {
        var key,
            i,
            controlsLength = this.controls.length,
            controls = this.controls;
        CheckBoxGroupField.superclass.prototype.enable.call(this);
        this.disabled = false;
        for (i = 0; i < controlsLength; i += 1) {
            controls[i].disable(this.auxControlStates[controls[i].id]);
        }
        return this;
    };
    /**
     * Sets the max number of controls that can be in the current direction (the direction is set by the
     * CheckBoxGroupField's
     * {@link PMUI.field.CheckBoxGroupField#setControlPositioning setControlPositioning() method}).
     * @param {Number} max It should be an integer, otherwise it will be floor rounded. If the value is equal or minor
     * than 0 it means there's no limit.
     */
    CheckBoxGroupField.prototype.setMaxDirectionOptions = function (max) {
        if (typeof max === 'number') {
            this.maxDirectionOptions = Math.floor(max);
            if (this.html) {
                this.setControlPositioning(this.controlPositioning);
            }
        } else {
            throw new Error("setMaxDirectionOptions(): it only accepts number values.");
        }

        return this;
    };
    /**
     * It overrides the Field's {@link PMUI.form.Field#setControlPositioning setControlPositioning() method}.
     * This new implementation sets the direction for the control addition: horizontal or vertical.
     * @param {String} positioning It can be "horizontal" or "vertical".
     */
    CheckBoxGroupField.prototype.setControlPositioning = function (positioning) {
        var errorMessage = "The setControlPositioning() method only accepts \"horizontal\" or \"vertical\" as value.",
            table,
            tbody,
            cell,
            row,
            i,
            column,
            rowIndex;
        if (typeof positioning === 'string') {
            if (!(positioning === 'horizontal' || positioning === 'vertical')) {
                return this;
            }
            this.controlPositioning = positioning;
            if (this.html && this.controls) {
                for (i = 0; i < this.controls.length; i += 1) {
                    jQuery(this.controls[i].getHTML()).detach();
                }
                $(this.dom.controlContainer).empty();
                table = PMUI.createHTMLElement("table");
                table.className = 'pmui-field-control-table';
                tbody = PMUI.createHTMLElement("tbody");
                if (positioning === 'horizontal') {
                    row = PMUI.createHTMLElement("tr");
                    for (i = 0; i < this.controls.length; i += 1) {
                        cell = PMUI.createHTMLElement('td');
                        this.controls[i].getHTML();
                        this.controls[i].control.tabIndex = i;
                        cell.appendChild(this.controls[i].getHTML());
                        row.appendChild(cell);
                        if (this.maxDirectionOptions > 0 && (i + 1) % this.maxDirectionOptions === 0) {
                            tbody.appendChild(row);
                            row = PMUI.createHTMLElement("tr");
                        }
                    }
                    tbody.appendChild(row);
                } else {
                    column = 0;
                    for (i = 0; i < this.controls.length; i += 1) {
                        cell = PMUI.createHTMLElement('td');
                        this.controls[i].getHTML();
                        this.controls[i].control.tabIndex = i;
                        cell.appendChild(this.controls[i].getHTML());
                        rowIndex = this.maxDirectionOptions === 0 ? i : i % this.maxDirectionOptions;

                        row = jQuery(tbody).find('tr').eq(rowIndex).get(0);
                        if (!row) {
                            row = PMUI.createHTMLElement('tr');
                            tbody.appendChild(row);
                        }
                        row.appendChild(cell);
                    }
                }
                this.controlTable = table;
                table.appendChild(tbody);
                this.dom.controlContainer.appendChild(table);
                this.dom.controlContainer.appendChild(this.helper.getHTML());
            }
        }

        return this;
    };
    /**
     * Sets all the options for the control for checkbox button.
     * @param {Array} options An array in which every element is a JSON object with the
     same structure required in the
     * {@link PMUI.field.CheckBoxGroupField#addOption addOption() method}.
     * @chainable
     */
    CheckBoxGroupField.prototype.setOptions = function (options) {
        var i = 0;

        this.value = [];
        this.value = JSON.stringify(this.value);

        if (jQuery.isArray(options)) {
            for (i = 0; i < options.length; i += 1) {
                this.addOption(options[i]);
            }
        } else {
            throw new Error("setOptions(): the supplied argument must be an array.");
        }

        return this;
    };
    /**
     * Adds a new option to the CheckBoxGroupField.
     * @param {Object} option A JSON object, which can have the same properties that the config options
     * for the {@link PMUI.control.SelectableControl SelectableControl class} except by "mode",
     it will always be override by the value "checkBox".
     * @chainable
     */
    CheckBoxGroupField.prototype.addOption = function (option) {
        var newOption;

        newOption = new PMUI.control.SelectableControl(jQuery.extend(true, option, {
            mode: 'checkbox',
            name: this.controls.length + 1,
            selected: option.selected
        }));

        if (newOption.isSelected()) {
            this.value = JSON.parse(this.value);
            this.value.push(newOption.getValue());
            this.value = JSON.stringify(this.value);
        }
        if (this.eventsDefined) {
            newOption.setOnChangeHandler(this.onChangeHandler()).getHTML();
            newOption.setOnBeforeChangeHandler(this.onBeforeChangeHandler());
            newOption.defineEvents();
        }
        this.auxControlStates[newOption.id] = newOption.disabled;
        this.controls.push(newOption);
        this.setControlPositioning(this.controlPositioning);

        return this;
    };
    /**
     * Removes one or more options (checkBox Button).
     * @param  {String|Number|PMUI.control.SelectableControl} option It can be:
     *
     *  - A number, in that case the parameter is used as the index of the item to be removed.
     *  - A String, in that case the parameter is used as the item's value,
     *  that means that everyone item that has that value will be removed.
     *  - An instance of {@link PMUI.control.SelectableControl SelectableControl} which must be a control of the field.
     * @chainable
     */
    CheckBoxGroupField.prototype.removeOption = function (item) {
        var itemToRemove,
            i;
        if (item instanceof PMUI.control.SelectableControl) {
            for (i = 0; i < this.controls.length; i += 1) {
                if (this.controls[i] === item) {
                    itemToRemove = i;
                    break;
                }
            }
        } else if (typeof item === 'string') {
            for (i = 0; i < this.controls.length; i += 1) {
                if (this.controls[i].id === item) {
                    itemToRemove = this.controls[i];
                    break;
                }
            }
        } else {
            itemToRemove = item;
        }
        if (typeof itemToRemove === 'number') {
            itemToRemove = this.controls[itemToRemove];
            delete this.auxControlStates[itemToRemove.id];
            jQuery(itemToRemove.html).detach();
            this.controls.splice(itemToRemove, 1);
            this.setControlPositioning(this.controlPositioning);
        }
        return this;
    };
    /**
     * It clears all the options from the field.
     * @chainable
     */
    CheckBoxGroupField.prototype.clearOptions = function () {
        while (this.controls.length) {
            this.removeOption(0);
        }

        return this;
    };
    /**
     * Update the field's value property from the controls
     * the parameter value is a clean array;
     * @protected
     * @chainable
     */
    CheckBoxGroupField.prototype.updateValueFromControls = function () {
        var value = [], i;

        for (i = 0; i < this.controls.length; i += 1) {
            if (this.controls[i].isSelected()) {
                value.push(this.controls[i].getValue());
            }
        }

        this.value = JSON.stringify(value);
        this.data.setValue(this.value);

        return this;
    };
    /**
     * Sets the value to the field's controls.
     * @protected
     * @param {String} value
     * @chainable
     */
    CheckBoxGroupField.prototype.setValueToControls = function (value) {
        var i, j, values, controls, controlsLength;

        try {
            value = value.replace(/'/g, "\"");
            values = JSON.parse(value);
        } catch (e) {
            values = '[]';
        }

        controlsLength = (controls = this.controls.slice(0)).length;
        for (i = 0; i < controlsLength; i += 1) {
            co