<?php

/**

 * Bottom Footer Options for Astra Theme.

 *

 * @package     Astra

 * @author      Astra

 * @copyright   Copyright (c) 2020, Astra

 * @link        https://wpastra.com/

 * @since       Astra 1.0.0

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



if ( ! class_exists( 'Astra_Blog_Single_Layout_Configs' ) ) {



	/**

	 * Register Blog Single Layout Configurations.

	 */

	class Astra_Blog_Single_Layout_Configs extends Astra_Customizer_Config_Base {



		/**

		 * Register Blog Single Layout Configurations.

		 *

		 * @param Array                $configurations Astra Customizer Configurations.

		 * @param WP_Customize_Manager $wp_customize instance of WP_Customize_Manager.

		 * @since 1.4.3

		 * @return Array Astra Customizer Configurations with updated configurations.

		 */

		public function register_configuration( $configurations, $wp_customize ) {



			/** @psalm-suppress DocblockTypeContradiction */ // phpcs:ignore Generic.Commenting.DocComment.MissingShort

			$tab_config = ( true === Astra_Builder_Helper::$is_header_footer_builder_active ) ? Astra_Builder_Helper::$design_tab : Astra_Builder_Helper::$general_tab;



			$_configs = array(



				/**

				 * Option: Single Post Content Width

				 */

				array(

					'name'       => ASTRA_THEME_SETTINGS . '[blog-single-width]',

					'type'       => 'control',

					'control'    => 'ast-selector',

					'section'    => 'section-blog-single',

					'default'    => astra_get_option( 'blog-single-width' ),

					'priority'   => 6,

					'title'      => __( 'Content Width', 'astra' ),

					'choices'    => array(

						'default' => __( 'Default', 'astra' ),

						'custom'  => __( 'Custom', 'astra' ),

					),

					'transport'  => 'postMessage',

					'responsive' => false,

					'divider'    => array( 'ast_class' => 'ast-top-section-divider' ),

					'renderAs'   => 'text',

				),



				/**

				 * Option: Enter Width

				 */

				array(

					'name'        => ASTRA_THEME_SETTINGS . '[blog-single-max-width]',

					'type'        => 'control',

					'control'     => 'ast-slider',

					'section'     => 'section-blog-single',

					'transport'   => 'postMessage',

					'default'     => astra_get_option( 'blog-single-max-width' ),

					'context'     => array(

						Astra_Builder_Helper::$general_tab_config,

						array(

							'setting'  => ASTRA_THEME_SETTINGS . '[blog-single-width]',

							'operator' => '===',

							'value'    => 'custom',

						),

					),

					'priority'    => 6,

					'title'       => __( 'Custom Width', 'astra' ),

					'suffix'      => 'px',

					'input_attrs' => array(

						'min'  => 768,

						'step' => 1,

						'max'  => 1920,

					),

					'divider'     => array( 'ast_class' => 'ast-top-dotted-divider' ),

				),



				/**

				 * Option: Divider

				 */

				array(

					'name'     => ASTRA_THEME_SETTINGS . '[section-blog-single-spacing-divider]',

					'section'  => 'section-blog-single',

					'title'    => __( 'Post Spacing', 'astra' ),

					'type'     => 'control',

					'control'  => 'ast-heading',

					'priority' => 24,

					'context'  => $tab_config,

				),



				/**

				 * Option: Single Post Spacing

				 */

				array(

					'name'              => ASTRA_THEME_SETTINGS . '[single-post-outside-spacing]',

					'default'           => astra_get_option( 'single-post-outside-spacing' ),

					'type'              => 'control',

					'control'           => 'ast-responsive-spacing',

					'sanitize_callback' => array( 'Astra_Customizer_Sanitizes', 'sanitize_responsive_spacing' ),

					'section'           => 'section-blog-single',

					'title'             => __( 'Outside', 'astra' ),

					'linked_choices'    => true,

					'transport'         => 'postMessage',

					'unit_choices'      => array( 'px', 'em', '%' ),

					'choices'           => array(

						'top'    => __( 'Top', 'astra' ),

						'right'  => __( 'Right', 'astra' ),

						'bottom' => __( 'Bottom', 'astra' ),

						'left'   => __( 'Left', 'astra' ),

					),

					'priority'          => 25,

					'context'           => $tab_config,

					'divider'           => array( 'ast_class' => 'ast-section-spacing' ),

				),

			);



			if ( true === Astra_Builder_Helper::$is_header_footer_builder_active ) {

				$_configs[] = array(

					'name'        => 'section-blog-single-ast-context-tabs',

					'section'     => 'section-blog-single',

					'type'        => 'control',

					'control'     => 'ast-builder-header-control',

					'priority'    => 0,

					'description' => '',

				);

			}



			$configurations = array_merge( $configurations, $_configs );



			return $configurations;

		}

	}

}



new Astra_Blog_Single_Layout_Configs();

